<?php

// +----------------------------------------------------------------+
// | AtMail Open - Licensed under the Apache 2.0 Open-source License|
// | http://opensource.org/licenses/apache2.0.php                   |
// +----------------------------------------------------------------+
require_once('header.php');

header('Content-type: text/html; charset=utf-8');

require_once('Config.php');
require_once('Global_Base.php'); // Backwards compatability, e.g FC2, no file_put_contents if sqldo statement errors
require_once('SQL.php');

$db = new SQL();

$newversion = '1.02';

if (preg_match('/(\d+\.\d+)/', $pref['version'], $m)) {
    $version = $m[1];
    if ($version == $newversion) {
        die("Already at version $version");
    }
} else {
    die('Could not determine current version');
}

$alpha = range('a', 'z');
$alpha[] = 'other';

if ($version == '1.0') {
    $version = '1.01';
}

if ($version == '1.01') {

    // Add UseSSL column
    foreach ($alpha as $a) {
        $db->sqldo("alter table UserSettings_$a add UseSSL tinyint(1) default 0");
    }

    $db->sqldo("alter table Accounts add UseSSL tinyint(1) default 0");

    if (extension_loaded('openssl')) {
        $pref['mail_type_ssl'] = 'allow';
    } else {
        $pref['mail_type_ssl'] = 'deny';
    }

    $version = '1.02';
}

$pref['version'] = "AtMail Open $version";
writeconf();

$msg = <<<_EOF
<h1>Upgrade to @Mail $newversion - Complete</h1>
<p>Reload the <a href='index.php'>index page</a> of AtMail Open to continue using the latest release.</p>
<p>View the <a href="http://support.atmail.org/changelog.html">changelog</a> for details on the new AtMail Open $newversion release.</p>
<p>This script (upgrade.php) has been deleted from your server. A new version will be supplied with the next release.</p>
_EOF;
?>

<HTML>
<BODY>
<HEAD>
<STYLE>
BODY { background: #ffffff; width: 600px;}
H1 { font-family: Verdana, arial; font-size: 16px;}
P { font-family: Verdana, arial; font-size: 12px;}
pre {
    overflow: auto;
    padding: 1em;
    border: 1px solid #c0d8c0;
    background-color: #f0f0f0;
}
</STYLE>
</HEAD>

<img src="../../imgs/about.gif">
<?php echo $msg; ?>
</BODY>
</HTML>