#!/bin/sh

SERVERROOT=/usr/local/lsws
OPENLSWS_USER=nobody
OPENLSWS_GROUP=nobody
OPENLSWS_ADMIN=admin
OPENLSWS_PASSWORD=123456
OPENLSWS_EMAIL=root@localhost
OPENLSWS_ADMINSSL=yes
OPENLSWS_ADMINPORT=7080
USE_LSPHP7=yes
DEFAULT_TMP_DIR=/tmp/lshttpd
PID_FILE=/tmp/lshttpd/lshttpd.pid
OPENLSWS_EXAMPLEPORT=8088
CONFFILE=./ols.conf
    
#script start here
cd .

if [ -f $CONFFILE ] ; then
    source $CONFFILE 2>/dev/null
    if [ $? != 0 ]; then
        . $CONFFILE
    fi
fi

mkdir -p $SERVERROOT >/dev/null 2>&1

ISRUNNING=no

if [ -f $SERVERROOT/bin/openlitespeed ] ; then 
    echo Openlitespeed web server exists, will upgrade.
    
    $SERVERROOT/bin/lswsctrl status | grep ERROR
    if [ $? != 0 ]; then
        ISRUNNING=yes
    fi
fi

./_in.sh "$SERVERROOT" "$OPENLSWS_USER" "$OPENLSWS_GROUP" "$OPENLSWS_ADMIN" "$OPENLSWS_PASSWORD" "$OPENLSWS_EMAIL" "$OPENLSWS_ADMINSSL" "$OPENLSWS_ADMINPORT" "$USE_LSPHP7" "$DEFAULT_TMP_DIR" "$PID_FILE" "$OPENLSWS_EXAMPLEPORT" no

cp -f modules/*.so $SERVERROOT/modules/
cp -f bin/openlitespeed $SERVERROOT/bin/

if [ "$ISRUNNING" = "yes" ] ; then
    $SERVERROOT/bin/lswsctrl start
fi

