struct encode_el
{
    uint32_t code;
    int      bits;
};

static const struct encode_el encode_table[257] =
{
    {     0x1ff8,    13},    //        (  0)
    {   0x7fffd8,    23},    //        (  1)
    {  0xfffffe2,    28},    //        (  2)
    {  0xfffffe3,    28},    //        (  3)
    {  0xfffffe4,    28},    //        (  4)
    {  0xfffffe5,    28},    //        (  5)
    {  0xfffffe6,    28},    //        (  6)
    {  0xfffffe7,    28},    //        (  7)
    {  0xfffffe8,    28},    //        (  8)
    {   0xffffea,    24},    //        (  9)
    { 0x3ffffffc,    30},    //        ( 10)
    {  0xfffffe9,    28},    //        ( 11)
    {  0xfffffea,    28},    //        ( 12)
    { 0x3ffffffd,    30},    //        ( 13)
    {  0xfffffeb,    28},    //        ( 14)
    {  0xfffffec,    28},    //        ( 15)
    {  0xfffffed,    28},    //        ( 16)
    {  0xfffffee,    28},    //        ( 17)
    {  0xfffffef,    28},    //        ( 18)
    {  0xffffff0,    28},    //        ( 19)
    {  0xffffff1,    28},    //        ( 20)
    {  0xffffff2,    28},    //        ( 21)
    { 0x3ffffffe,    30},    //        ( 22)
    {  0xffffff3,    28},    //        ( 23)
    {  0xffffff4,    28},    //        ( 24)
    {  0xffffff5,    28},    //        ( 25)
    {  0xffffff6,    28},    //        ( 26)
    {  0xffffff7,    28},    //        ( 27)
    {  0xffffff8,    28},    //        ( 28)
    {  0xffffff9,    28},    //        ( 29)
    {  0xffffffa,    28},    //        ( 30)
    {  0xffffffb,    28},    //        ( 31)
    {       0x14,     6},    //    ' ' ( 32)
    {      0x3f8,    10},    //    '!' ( 33)
    {      0x3f9,    10},    //    '"' ( 34)
    {      0xffa,    12},    //    '#' ( 35)
    {     0x1ff9,    13},    //    '$' ( 36)
    {       0x15,     6},    //    '%' ( 37)
    {       0xf8,     8},    //    '&' ( 38)
    {      0x7fa,    11},    //    ''' ( 39)
    {      0x3fa,    10},    //    '(' ( 40)
    {      0x3fb,    10},    //    ')' ( 41)
    {       0xf9,     8},    //    '*' ( 42)
    {      0x7fb,    11},    //    '+' ( 43)
    {       0xfa,     8},    //    ',' ( 44)
    {       0x16,     6},    //    '-' ( 45)
    {       0x17,     6},    //    '.' ( 46)
    {       0x18,     6},    //    '/' ( 47)
    {        0x0,     5},    //    '0' ( 48)
    {        0x1,     5},    //    '1' ( 49)
    {        0x2,     5},    //    '2' ( 50)
    {       0x19,     6},    //    '3' ( 51)
    {       0x1a,     6},    //    '4' ( 52)
    {       0x1b,     6},    //    '5' ( 53)
    {       0x1c,     6},    //    '6' ( 54)
    {       0x1d,     6},    //    '7' ( 55)
    {       0x1e,     6},    //    '8' ( 56)
    {       0x1f,     6},    //    '9' ( 57)
    {       0x5c,     7},    //    ':' ( 58)
    {       0xfb,     8},    //    ';' ( 59)
    {     0x7ffc,    15},    //    '<' ( 60)
    {       0x20,     6},    //    '=' ( 61)
    {      0xffb,    12},    //    '>' ( 62)
    {      0x3fc,    10},    //    '?' ( 63)
    {     0x1ffa,    13},    //    '@' ( 64)
    {       0x21,     6},    //    'A' ( 65)
    {       0x5d,     7},    //    'B' ( 66)
    {       0x5e,     7},    //    'C' ( 67)
    {       0x5f,     7},    //    'D' ( 68)
    {       0x60,     7},    //    'E' ( 69)
    {       0x61,     7},    //    'F' ( 70)
    {       0x62,     7},    //    'G' ( 71)
    {       0x63,     7},    //    'H' ( 72)
    {       0x64,     7},    //    'I' ( 73)
    {       0x65,     7},    //    'J' ( 74)
    {       0x66,     7},    //    'K' ( 75)
    {       0x67,     7},    //    'L' ( 76)
    {       0x68,     7},    //    'M' ( 77)
    {       0x69,     7},    //    'N' ( 78)
    {       0x6a,     7},    //    'O' ( 79)
    {       0x6b,     7},    //    'P' ( 80)
    {       0x6c,     7},    //    'Q' ( 81)
    {       0x6d,     7},    //    'R' ( 82)
    {       0x6e,     7},    //    'S' ( 83)
    {       0x6f,     7},    //    'T' ( 84)
    {       0x70,     7},    //    'U' ( 85)
    {       0x71,     7},    //    'V' ( 86)
    {       0x72,     7},    //    'W' ( 87)
    {       0xfc,     8},    //    'X' ( 88)
    {       0x73,     7},    //    'Y' ( 89)
    {       0xfd,     8},    //    'Z' ( 90)
    {     0x1ffb,    13},    //    '[' ( 91)
    {    0x7fff0,    19},    //    '\' ( 92)
    {     0x1ffc,    13},    //    ']' ( 93)
    {     0x3ffc,    14},    //    '^' ( 94)
    {       0x22,     6},    //    '_' ( 95)
    {     0x7ffd,    15},    //    '`' ( 96)
    {        0x3,     5},    //    'a' ( 97)
    {       0x23,     6},    //    'b' ( 98)
    {        0x4,     5},    //    'c' ( 99)
    {       0x24,     6},    //    'd' (100)
    {        0x5,     5},    //    'e' (101)
    {       0x25,     6},    //    'f' (102)
    {       0x26,     6},    //    'g' (103)
    {       0x27,     6},    //    'h' (104)
    {        0x6,     5},    //    'i' (105)
    {       0x74,     7},    //    'j' (106)
    {       0x75,     7},    //    'k' (107)
    {       0x28,     6},    //    'l' (108)
    {       0x29,     6},    //    'm' (109)
    {       0x2a,     6},    //    'n' (110)
    {        0x7,     5},    //    'o' (111)
    {       0x2b,     6},    //    'p' (112)
    {       0x76,     7},    //    'q' (113)
    {       0x2c,     6},    //    'r' (114)
    {        0x8,     5},    //    's' (115)
    {        0x9,     5},    //    't' (116)
    {       0x2d,     6},    //    'u' (117)
    {       0x77,     7},    //    'v' (118)
    {       0x78,     7},    //    'w' (119)
    {       0x79,     7},    //    'x' (120)
    {       0x7a,     7},    //    'y' (121)
    {       0x7b,     7},    //    'z' (122)
    {     0x7ffe,    15},    //    '{' (123)
    {      0x7fc,    11},    //    '|' (124)
    {     0x3ffd,    14},    //    '}' (125)
    {     0x1ffd,    13},    //    '~' (126)
    {  0xffffffc,    28},    //        (127)
    {    0xfffe6,    20},    //        (128)
    {   0x3fffd2,    22},    //        (129)
    {    0xfffe7,    20},    //        (130)
    {    0xfffe8,    20},    //        (131)
    {   0x3fffd3,    22},    //        (132)
    {   0x3fffd4,    22},    //        (133)
    {   0x3fffd5,    22},    //        (134)
    {   0x7fffd9,    23},    //        (135)
    {   0x3fffd6,    22},    //        (136)
    {   0x7fffda,    23},    //        (137)
    {   0x7fffdb,    23},    //        (138)
    {   0x7fffdc,    23},    //        (139)
    {   0x7fffdd,    23},    //        (140)
    {   0x7fffde,    23},    //        (141)
    {   0xffffeb,    24},    //        (142)
    {   0x7fffdf,    23},    //        (143)
    {   0xffffec,    24},    //        (144)
    {   0xffffed,    24},    //        (145)
    {   0x3fffd7,    22},    //        (146)
    {   0x7fffe0,    23},    //        (147)
    {   0xffffee,    24},    //        (148)
    {   0x7fffe1,    23},    //        (149)
    {   0x7fffe2,    23},    //        (150)
    {   0x7fffe3,    23},    //        (151)
    {   0x7fffe4,    23},    //        (152)
    {   0x1fffdc,    21},    //        (153)
    {   0x3fffd8,    22},    //        (154)
    {   0x7fffe5,    23},    //        (155)
    {   0x3fffd9,    22},    //        (156)
    {   0x7fffe6,    23},    //        (157)
    {   0x7fffe7,    23},    //        (158)
    {   0xffffef,    24},    //        (159)
    {   0x3fffda,    22},    //        (160)
    {   0x1fffdd,    21},    //        (161)
    {    0xfffe9,    20},    //        (162)
    {   0x3fffdb,    22},    //        (163)
    {   0x3fffdc,    22},    //        (164)
    {   0x7fffe8,    23},    //        (165)
    {   0x7fffe9,    23},    //        (166)
    {   0x1fffde,    21},    //        (167)
    {   0x7fffea,    23},    //        (168)
    {   0x3fffdd,    22},    //        (169)
    {   0x3fffde,    22},    //        (170)
    {   0xfffff0,    24},    //        (171)
    {   0x1fffdf,    21},    //        (172)
    {   0x3fffdf,    22},    //        (173)
    {   0x7fffeb,    23},    //        (174)
    {   0x7fffec,    23},    //        (175)
    {   0x1fffe0,    21},    //        (176)
    {   0x1fffe1,    21},    //        (177)
    {   0x3fffe0,    22},    //        (178)
    {   0x1fffe2,    21},    //        (179)
    {   0x7fffed,    23},    //        (180)
    {   0x3fffe1,    22},    //        (181)
    {   0x7fffee,    23},    //        (182)
    {   0x7fffef,    23},    //        (183)
    {    0xfffea,    20},    //        (184)
    {   0x3fffe2,    22},    //        (185)
    {   0x3fffe3,    22},    //        (186)
    {   0x3fffe4,    22},    //        (187)
    {   0x7ffff0,    23},    //        (188)
    {   0x3fffe5,    22},    //        (189)
    {   0x3fffe6,    22},    //        (190)
    {   0x7ffff1,    23},    //        (191)
    {  0x3ffffe0,    26},    //        (192)
    {  0x3ffffe1,    26},    //        (193)
    {    0xfffeb,    20},    //        (194)
    {    0x7fff1,    19},    //        (195)
    {   0x3fffe7,    22},    //        (196)
    {   0x7ffff2,    23},    //        (197)
    {   0x3fffe8,    22},    //        (198)
    {  0x1ffffec,    25},    //        (199)
    {  0x3ffffe2,    26},    //        (200)
    {  0x3ffffe3,    26},    //        (201)
    {  0x3ffffe4,    26},    //        (202)
    {  0x7ffffde,    27},    //        (203)
    {  0x7ffffdf,    27},    //        (204)
    {  0x3ffffe5,    26},    //        (205)
    {   0xfffff1,    24},    //        (206)
    {  0x1ffffed,    25},    //        (207)
    {    0x7fff2,    19},    //        (208)
    {   0x1fffe3,    21},    //        (209)
    {  0x3ffffe6,    26},    //        (210)
    {  0x7ffffe0,    27},    //        (211)
    {  0x7ffffe1,    27},    //        (212)
    {  0x3ffffe7,    26},    //        (213)
    {  0x7ffffe2,    27},    //        (214)
    {   0xfffff2,    24},    //        (215)
    {   0x1fffe4,    21},    //        (216)
    {   0x1fffe5,    21},    //        (217)
    {  0x3ffffe8,    26},    //        (218)
    {  0x3ffffe9,    26},    //        (219)
    {  0xffffffd,    28},    //        (220)
    {  0x7ffffe3,    27},    //        (221)
    {  0x7ffffe4,    27},    //        (222)
    {  0x7ffffe5,    27},    //        (223)
    {    0xfffec,    20},    //        (224)
    {   0xfffff3,    24},    //        (225)
    {    0xfffed,    20},    //        (226)
    {   0x1fffe6,    21},    //        (227)
    {   0x3fffe9,    22},    //        (228)
    {   0x1fffe7,    21},    //        (229)
    {   0x1fffe8,    21},    //        (230)
    {   0x7ffff3,    23},    //        (231)
    {   0x3fffea,    22},    //        (232)
    {   0x3fffeb,    22},    //        (233)
    {  0x1ffffee,    25},    //        (234)
    {  0x1ffffef,    25},    //        (235)
    {   0xfffff4,    24},    //        (236)
    {   0xfffff5,    24},    //        (237)
    {  0x3ffffea,    26},    //        (238)
    {   0x7ffff4,    23},    //        (239)
    {  0x3ffffeb,    26},    //        (240)
    {  0x7ffffe6,    27},    //        (241)
    {  0x3ffffec,    26},    //        (242)
    {  0x3ffffed,    26},    //        (243)
    {  0x7ffffe7,    27},    //        (244)
    {  0x7ffffe8,    27},    //        (245)
    {  0x7ffffe9,    27},    //        (246)
    {  0x7ffffea,    27},    //        (247)
    {  0x7ffffeb,    27},    //        (248)
    {  0xffffffe,    28},    //        (249)
    {  0x7ffffec,    27},    //        (250)
    {  0x7ffffed,    27},    //        (251)
    {  0x7ffffee,    27},    //        (252)
    {  0x7ffffef,    27},    //        (253)
    {  0x7fffff0,    27},    //        (254)
    {  0x3ffffee,    26},    //        (255)
    { 0x3fffffff,    30}    //    EOS (256)
};


#if LS_HPACK_USE_LARGE_TABLES
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define I(i,j) ((j<<8)|i)
#else
#define I(i,j) ((i<<8)|j)
#endif
/* On 32-bit platforms the longest code would cause undefined behavior
 * when `bits' is shifted (you can't shift 32-bit value by 32 bits).
 * Setting this value to 64 make the entry invalid and forces the encoder
 * to use the slower loop.  In other words, the longest output sequence
 * is 32 bits on 64-bit platforms and 31 bits on 32-bit platforms.
 */
#if UINTPTR_MAX == 18446744073709551615ull
#define X32 32
#else
#define X32 64
#endif
static const struct henc { unsigned lens; uint32_t code; } hencs[] =
{
    [I(0,0)] = {26,0x3FF1FF8},
    [I(1,0)] = {64,0},
    [I(2,0)] = {64,0},
    [I(3,0)] = {64,0},
    [I(4,0)] = {64,0},
    [I(5,0)] = {64,0},
    [I(6,0)] = {64,0},
    [I(7,0)] = {64,0},
    [I(8,0)] = {64,0},
    [I(9,0)] = {64,0},
    [I(10,0)] = {64,0},
    [I(11,0)] = {64,0},
    [I(12,0)] = {64,0},
    [I(13,0)] = {64,0},
    [I(14,0)] = {64,0},
    [I(15,0)] = {64,0},
    [I(16,0)] = {64,0},
    [I(17,0)] = {64,0},
    [I(18,0)] = {64,0},
    [I(19,0)] = {64,0},
    [I(20,0)] = {64,0},
    [I(21,0)] = {64,0},
    [I(22,0)] = {64,0},
    [I(23,0)] = {64,0},
    [I(24,0)] = {64,0},
    [I(25,0)] = {64,0},
    [I(26,0)] = {64,0},
    [I(27,0)] = {64,0},
    [I(28,0)] = {64,0},
    [I(29,0)] = {64,0},
    [I(30,0)] = {64,0},
    [I(31,0)] = {64,0},
    [I(32,0)] = {19,0x29FF8},
    [I(33,0)] = {23,0x7F1FF8},
    [I(34,0)] = {23,0x7F3FF8},
    [I(35,0)] = {25,0x1FF5FF8},
    [I(36,0)] = {26,0x3FF3FF8},
    [I(37,0)] = {19,0x2BFF8},
    [I(38,0)] = {21,0x1F1FF8},
    [I(39,0)] = {24,0xFF5FF8},
    [I(40,0)] = {23,0x7F5FF8},
    [I(41,0)] = {23,0x7F7FF8},
    [I(42,0)] = {21,0x1F3FF8},
    [I(43,0)] = {24,0xFF7FF8},
    [I(44,0)] = {21,0x1F5FF8},
    [I(45,0)] = {19,0x2DFF8},
    [I(46,0)] = {19,0x2FFF8},
    [I(47,0)] = {19,0x31FF8},
    [I(48,0)] = {18,0x1FF8},
    [I(49,0)] = {18,0x3FF8},
    [I(50,0)] = {18,0x5FF8},
    [I(51,0)] = {19,0x33FF8},
    [I(52,0)] = {19,0x35FF8},
    [I(53,0)] = {19,0x37FF8},
    [I(54,0)] = {19,0x39FF8},
    [I(55,0)] = {19,0x3BFF8},
    [I(56,0)] = {19,0x3DFF8},
    [I(57,0)] = {19,0x3FFF8},
    [I(58,0)] = {20,0xB9FF8},
    [I(59,0)] = {21,0x1F7FF8},
    [I(60,0)] = {28,0xFFF9FF8},
    [I(61,0)] = {19,0x41FF8},
    [I(62,0)] = {25,0x1FF7FF8},
    [I(63,0)] = {23,0x7F9FF8},
    [I(64,0)] = {26,0x3FF5FF8},
    [I(65,0)] = {19,0x43FF8},
    [I(66,0)] = {20,0xBBFF8},
    [I(67,0)] = {20,0xBDFF8},
    [I(68,0)] = {20,0xBFFF8},
    [I(69,0)] = {20,0xC1FF8},
    [I(70,0)] = {20,0xC3FF8},
    [I(71,0)] = {20,0xC5FF8},
    [I(72,0)] = {20,0xC7FF8},
    [I(73,0)] = {20,0xC9FF8},
    [I(74,0)] = {20,0xCBFF8},
    [I(75,0)] = {20,0xCDFF8},
    [I(76,0)] = {20,0xCFFF8},
    [I(77,0)] = {20,0xD1FF8},
    [I(78,0)] = {20,0xD3FF8},
    [I(79,0)] = {20,0xD5FF8},
    [I(80,0)] = {20,0xD7FF8},
    [I(81,0)] = {20,0xD9FF8},
    [I(82,0)] = {20,0xDBFF8},
    [I(83,0)] = {20,0xDDFF8},
    [I(84,0)] = {20,0xDFFF8},
    [I(85,0)] = {20,0xE1FF8},
    [I(86,0)] = {20,0xE3FF8},
    [I(87,0)] = {20,0xE5FF8},
    [I(88,0)] = {21,0x1F9FF8},
    [I(89,0)] = {20,0xE7FF8},
    [I(90,0)] = {21,0x1FBFF8},
    [I(91,0)] = {26,0x3FF7FF8},
    [I(92,0)] = {X32,0xFFFE1FF8},
    [I(93,0)] = {26,0x3FF9FF8},
    [I(94,0)] = {27,0x7FF9FF8},
    [I(95,0)] = {19,0x45FF8},
    [I(96,0)] = {28,0xFFFBFF8},
    [I(97,0)] = {18,0x7FF8},
    [I(98,0)] = {19,0x47FF8},
    [I(99,0)] = {18,0x9FF8},
    [I(100,0)] = {19,0x49FF8},
    [I(101,0)] = {18,0xBFF8},
    [I(102,0)] = {19,0x4BFF8},
    [I(103,0)] = {19,0x4DFF8},
    [I(104,0)] = {19,0x4FFF8},
    [I(105,0)] = {18,0xDFF8},
    [I(106,0)] = {20,0xE9FF8},
    [I(107,0)] = {20,0xEBFF8},
    [I(108,0)] = {19,0x51FF8},
    [I(109,0)] = {19,0x53FF8},
    [I(110,0)] = {19,0x55FF8},
    [I(111,0)] = {18,0xFFF8},
    [I(112,0)] = {19,0x57FF8},
    [I(113,0)] = {20,0xEDFF8},
    [I(114,0)] = {19,0x59FF8},
    [I(115,0)] = {18,0x11FF8},
    [I(116,0)] = {18,0x13FF8},
    [I(117,0)] = {19,0x5BFF8},
    [I(118,0)] = {20,0xEFFF8},
    [I(119,0)] = {20,0xF1FF8},
    [I(120,0)] = {20,0xF3FF8},
    [I(121,0)] = {20,0xF5FF8},
    [I(122,0)] = {20,0xF7FF8},
    [I(123,0)] = {28,0xFFFDFF8},
    [I(124,0)] = {24,0xFF9FF8},
    [I(125,0)] = {27,0x7FFBFF8},
    [I(126,0)] = {26,0x3FFBFF8},
    [I(127,0)] = {64,0},
    [I(128,0)] = {64,0},
    [I(129,0)] = {64,0},
    [I(130,0)] = {64,0},
    [I(131,0)] = {64,0},
    [I(132,0)] = {64,0},
    [I(133,0)] = {64,0},
    [I(134,0)] = {64,0},
    [I(135,0)] = {64,0},
    [I(136,0)] = {64,0},
    [I(137,0)] = {64,0},
    [I(138,0)] = {64,0},
    [I(139,0)] = {64,0},
    [I(140,0)] = {64,0},
    [I(141,0)] = {64,0},
    [I(142,0)] = {64,0},
    [I(143,0)] = {64,0},
    [I(144,0)] = {64,0},
    [I(145,0)] = {64,0},
    [I(146,0)] = {64,0},
    [I(147,0)] = {64,0},
    [I(148,0)] = {64,0},
    [I(149,0)] = {64,0},
    [I(150,0)] = {64,0},
    [I(151,0)] = {64,0},
    [I(152,0)] = {64,0},
    [I(153,0)] = {64,0},
    [I(154,0)] = {64,0},
    [I(155,0)] = {64,0},
    [I(156,0)] = {64,0},
    [I(157,0)] = {64,0},
    [I(158,0)] = {64,0},
    [I(159,0)] = {64,0},
    [I(160,0)] = {64,0},
    [I(161,0)] = {64,0},
    [I(162,0)] = {64,0},
    [I(163,0)] = {64,0},
    [I(164,0)] = {64,0},
    [I(165,0)] = {64,0},
    [I(166,0)] = {64,0},
    [I(167,0)] = {64,0},
    [I(168,0)] = {64,0},
    [I(169,0)] = {64,0},
    [I(170,0)] = {64,0},
    [I(171,0)] = {64,0},
    [I(172,0)] = {64,0},
    [I(173,0)] = {64,0},
    [I(174,0)] = {64,0},
    [I(175,0)] = {64,0},
    [I(176,0)] = {64,0},
    [I(177,0)] = {64,0},
    [I(178,0)] = {64,0},
    [I(179,0)] = {64,0},
    [I(180,0)] = {64,0},
    [I(181,0)] = {64,0},
    [I(182,0)] = {64,0},
    [I(183,0)] = {64,0},
    [I(184,0)] = {64,0},
    [I(185,0)] = {64,0},
    [I(186,0)] = {64,0},
    [I(187,0)] = {64,0},
    [I(188,0)] = {64,0},
    [I(189,0)] = {64,0},
    [I(190,0)] = {64,0},
    [I(191,0)] = {64,0},
    [I(192,0)] = {64,0},
    [I(193,0)] = {64,0},
    [I(194,0)] = {64,0},
    [I(195,0)] = {X32,0xFFFE3FF8},
    [I(196,0)] = {64,0},
    [I(197,0)] = {64,0},
    [I(198,0)] = {64,0},
    [I(199,0)] = {64,0},
    [I(200,0)] = {64,0},
    [I(201,0)] = {64,0},
    [I(202,0)] = {64,0},
    [I(203,0)] = {64,0},
    [I(204,0)] = {64,0},
    [I(205,0)] = {64,0},
    [I(206,0)] = {64,0},
    [I(207,0)] = {64,0},
    [I(208,0)] = {X32,0xFFFE5FF8},
    [I(209,0)] = {64,0},
    [I(210,0)] = {64,0},
    [I(211,0)] = {64,0},
    [I(212,0)] = {64,0},
    [I(213,0)] = {64,0},
    [I(214,0)] = {64,0},
    [I(215,0)] = {64,0},
    [I(216,0)] = {64,0},
    [I(217,0)] = {64,0},
    [I(218,0)] = {64,0},
    [I(219,0)] = {64,0},
    [I(220,0)] = {64,0},
    [I(221,0)] = {64,0},
    [I(222,0)] = {64,0},
    [I(223,0)] = {64,0},
    [I(224,0)] = {64,0},
    [I(225,0)] = {64,0},
    [I(226,0)] = {64,0},
    [I(227,0)] = {64,0},
    [I(228,0)] = {64,0},
    [I(229,0)] = {64,0},
    [I(230,0)] = {64,0},
    [I(231,0)] = {64,0},
    [I(232,0)] = {64,0},
    [I(233,0)] = {64,0},
    [I(234,0)] = {64,0},
    [I(235,0)] = {64,0},
    [I(236,0)] = {64,0},
    [I(237,0)] = {64,0},
    [I(238,0)] = {64,0},
    [I(239,0)] = {64,0},
    [I(240,0)] = {64,0},
    [I(241,0)] = {64,0},
    [I(242,0)] = {64,0},
    [I(243,0)] = {64,0},
    [I(244,0)] = {64,0},
    [I(245,0)] = {64,0},
    [I(246,0)] = {64,0},
    [I(247,0)] = {64,0},
    [I(248,0)] = {64,0},
    [I(249,0)] = {64,0},
    [I(250,0)] = {64,0},
    [I(251,0)] = {64,0},
    [I(252,0)] = {64,0},
    [I(253,0)] = {64,0},
    [I(254,0)] = {64,0},
    [I(255,0)] = {64,0},
    [I(0,1)] = {64,0},
    [I(1,1)] = {64,0},
    [I(2,1)] = {64,0},
    [I(3,1)] = {64,0},
    [I(4,1)] = {64,0},
    [I(5,1)] = {64,0},
    [I(6,1)] = {64,0},
    [I(7,1)] = {64,0},
    [I(8,1)] = {64,0},
    [I(9,1)] = {64,0},
    [I(10,1)] = {64,0},
    [I(11,1)] = {64,0},
    [I(12,1)] = {64,0},
    [I(13,1)] = {64,0},
    [I(14,1)] = {64,0},
    [I(15,1)] = {64,0},
    [I(16,1)] = {64,0},
    [I(17,1)] = {64,0},
    [I(18,1)] = {64,0},
    [I(19,1)] = {64,0},
    [I(20,1)] = {64,0},
    [I(21,1)] = {64,0},
    [I(22,1)] = {64,0},
    [I(23,1)] = {64,0},
    [I(24,1)] = {64,0},
    [I(25,1)] = {64,0},
    [I(26,1)] = {64,0},
    [I(27,1)] = {64,0},
    [I(28,1)] = {64,0},
    [I(29,1)] = {64,0},
    [I(30,1)] = {64,0},
    [I(31,1)] = {64,0},
    [I(32,1)] = {29,0xA7FFFD8},
    [I(33,1)] = {64,0},
    [I(34,1)] = {64,0},
    [I(35,1)] = {64,0},
    [I(36,1)] = {64,0},
    [I(37,1)] = {29,0xAFFFFD8},
    [I(38,1)] = {31,0x7C7FFFD8},
    [I(39,1)] = {64,0},
    [I(40,1)] = {64,0},
    [I(41,1)] = {64,0},
    [I(42,1)] = {31,0x7CFFFFD8},
    [I(43,1)] = {64,0},
    [I(44,1)] = {31,0x7D7FFFD8},
    [I(45,1)] = {29,0xB7FFFD8},
    [I(46,1)] = {29,0xBFFFFD8},
    [I(47,1)] = {29,0xC7FFFD8},
    [I(48,1)] = {28,0x7FFFD8},
    [I(49,1)] = {28,0xFFFFD8},
    [I(50,1)] = {28,0x17FFFD8},
    [I(51,1)] = {29,0xCFFFFD8},
    [I(52,1)] = {29,0xD7FFFD8},
    [I(53,1)] = {29,0xDFFFFD8},
    [I(54,1)] = {29,0xE7FFFD8},
    [I(55,1)] = {29,0xEFFFFD8},
    [I(56,1)] = {29,0xF7FFFD8},
    [I(57,1)] = {29,0xFFFFFD8},
    [I(58,1)] = {30,0x2E7FFFD8},
    [I(59,1)] = {31,0x7DFFFFD8},
    [I(60,1)] = {64,0},
    [I(61,1)] = {29,0x107FFFD8},
    [I(62,1)] = {64,0},
    [I(63,1)] = {64,0},
    [I(64,1)] = {64,0},
    [I(65,1)] = {29,0x10FFFFD8},
    [I(66,1)] = {30,0x2EFFFFD8},
    [I(67,1)] = {30,0x2F7FFFD8},
    [I(68,1)] = {30,0x2FFFFFD8},
    [I(69,1)] = {30,0x307FFFD8},
    [I(70,1)] = {30,0x30FFFFD8},
    [I(71,1)] = {30,0x317FFFD8},
    [I(72,1)] = {30,0x31FFFFD8},
    [I(73,1)] = {30,0x327FFFD8},
    [I(74,1)] = {30,0x32FFFFD8},
    [I(75,1)] = {30,0x337FFFD8},
    [I(76,1)] = {30,0x33FFFFD8},
    [I(77,1)] = {30,0x347FFFD8},
    [I(78,1)] = {30,0x34FFFFD8},
    [I(79,1)] = {30,0x357FFFD8},
    [I(80,1)] = {30,0x35FFFFD8},
    [I(81,1)] = {30,0x367FFFD8},
    [I(82,1)] = {30,0x36FFFFD8},
    [I(83,1)] = {30,0x377FFFD8},
    [I(84,1)] = {30,0x37FFFFD8},
    [I(85,1)] = {30,0x387FFFD8},
    [I(86,1)] = {30,0x38FFFFD8},
    [I(87,1)] = {30,0x397FFFD8},
    [I(88,1)] = {31,0x7E7FFFD8},
    [I(89,1)] = {30,0x39FFFFD8},
    [I(90,1)] = {31,0x7EFFFFD8},
    [I(91,1)] = {64,0},
    [I(92,1)] = {64,0},
    [I(93,1)] = {64,0},
    [I(94,1)] = {64,0},
    [I(95,1)] = {29,0x117FFFD8},
    [I(96,1)] = {64,0},
    [I(97,1)] = {28,0x1FFFFD8},
    [I(98,1)] = {29,0x11FFFFD8},
    [I(99,1)] = {28,0x27FFFD8},
    [I(100,1)] = {29,0x127FFFD8},
    [I(101,1)] = {28,0x2FFFFD8},
    [I(102,1)] = {29,0x12FFFFD8},
    [I(103,1)] = {29,0x137FFFD8},
    [I(104,1)] = {29,0x13FFFFD8},
    [I(105,1)] = {28,0x37FFFD8},
    [I(106,1)] = {30,0x3A7FFFD8},
    [I(107,1)] = {30,0x3AFFFFD8},
    [I(108,1)] = {29,0x147FFFD8},
    [I(109,1)] = {29,0x14FFFFD8},
    [I(110,1)] = {29,0x157FFFD8},
    [I(111,1)] = {28,0x3FFFFD8},
    [I(112,1)] = {29,0x15FFFFD8},
    [I(113,1)] = {30,0x3B7FFFD8},
    [I(114,1)] = {29,0x167FFFD8},
    [I(115,1)] = {28,0x47FFFD8},
    [I(116,1)] = {28,0x4FFFFD8},
    [I(117,1)] = {29,0x16FFFFD8},
    [I(118,1)] = {30,0x3BFFFFD8},
    [I(119,1)] = {30,0x3C7FFFD8},
    [I(120,1)] = {30,0x3CFFFFD8},
    [I(121,1)] = {30,0x3D7FFFD8},
    [I(122,1)] = {30,0x3DFFFFD8},
    [I(123,1)] = {64,0},
    [I(124,1)] = {64,0},
    [I(125,1)] = {64,0},
    [I(126,1)] = {64,0},
    [I(127,1)] = {64,0},
    [I(128,1)] = {64,0},
    [I(129,1)] = {64,0},
    [I(130,1)] = {64,0},
    [I(131,1)] = {64,0},
    [I(132,1)] = {64,0},
    [I(133,1)] = {64,0},
    [I(134,1)] = {64,0},
    [I(135,1)] = {64,0},
    [I(136,1)] = {64,0},
    [I(137,1)] = {64,0},
    [I(138,1)] = {64,0},
    [I(139,1)] = {64,0},
    [I(140,1)] = {64,0},
    [I(141,1)] = {64,0},
    [I(142,1)] = {64,0},
    [I(143,1)] = {64,0},
    [I(144,1)] = {64,0},
    [I(145,1)] = {64,0},
    [I(146,1)] = {64,0},
    [I(147,1)] = {64,0},
    [I(148,1)] = {64,0},
    [I(149,1)] = {64,0},
    [I(150,1)] = {64,0},
    [I(151,1)] = {64,0},
    [I(152,1)] = {64,0},
    [I(153,1)] = {64,0},
    [I(154,1)] = {64,0},
    [I(155,1)] = {64,0},
    [I(156,1)] = {64,0},
    [I(157,1)] = {64,0},
    [I(158,1)] = {64,0},
    [I(159,1)] = {64,0},
    [I(160,1)] = {64,0},
    [I(161,1)] = {64,0},
    [I(162,1)] = {64,0},
    [I(163,1)] = {64,0},
    [I(164,1)] = {64,0},
    [I(165,1)] = {64,0},
    [I(166,1)] = {64,0},
    [I(167,1)] = {64,0},
    [I(168,1)] = {64,0},
    [I(169,1)] = {64,0},
    [I(170,1)] = {64,0},
    [I(171,1)] = {64,0},
    [I(172,1)] = {64,0},
    [I(173,1)] = {64,0},
    [I(174,1)] = {64,0},
    [I(175,1)] = {64,0},
    [I(176,1)] = {64,0},
    [I(177,1)] = {64,0},
    [I(178,1)] = {64,0},
    [I(179,1)] = {64,0},
    [I(180,1)] = {64,0},
    [I(181,1)] = {64,0},
    [I(182,1)] = {64,0},
    [I(183,1)] = {64,0},
    [I(184,1)] = {64,0},
    [I(185,1)] = {64,0},
    [I(186,1)] = {64,0},
    [I(187,1)] = {64,0},
    [I(188,1)] = {64,0},
    [I(189,1)] = {64,0},
    [I(190,1)] = {64,0},
    [I(191,1)] = {64,0},
    [I(192,1)] = {64,0},
    [I(193,1)] = {64,0},
    [I(194,1)] = {64,0},
    [I(195,1)] = {64,0},
    [I(196,1)] = {64,0},
    [I(197,1)] = {64,0},
    [I(198,1)] = {64,0},
    [I(199,1)] = {64,0},
    [I(200,1)] = {64,0},
    [I(201,1)] = {64,0},
    [I(202,1)] = {64,0},
    [I(203,1)] = {64,0},
    [I(204,1)] = {64,0},
    [I(205,1)] = {64,0},
    [I(206,1)] = {64,0},
    [I(207,1)] = {64,0},
    [I(208,1)] = {64,0},
    [I(209,1)] = {64,0},
    [I(210,1)] = {64,0},
    [I(211,1)] = {64,0},
    [I(212,1)] = {64,0},
    [I(213,1)] = {64,0},
    [I(214,1)] = {64,0},
    [I(215,1)] = {64,0},
    [I(216,1)] = {64,0},
    [I(217,1)] = {64,0},
    [I(218,1)] = {64,0},
    [I(219,1)] = {64,0},
    [I(220,1)] = {64,0},
    [I(221,1)] = {64,0},
    [I(222,1)] = {64,0},
    [I(223,1)] = {64,0},
    [I(224,1)] = {64,0},
    [I(225,1)] = {64,0},
    [I(226,1)] = {64,0},
    [I(227,1)] = {64,0},
    [I(228,1)] = {64,0},
    [I(229,1)] = {64,0},
    [I(230,1)] = {64,0},
    [I(231,1)] = {64,0},
    [I(232,1)] = {64,0},
    [I(233,1)] = {64,0},
    [I(234,1)] = {64,0},
    [I(235,1)] = {64,0},
    [I(236,1)] = {64,0},
    [I(237,1)] = {64,0},
    [I(238,1)] = {64,0},
    [I(239,1)] = {64,0},
    [I(240,1)] = {64,0},
    [I(241,1)] = {64,0},
    [I(242,1)] = {64,0},
    [I(243,1)] = {64,0},
    [I(244,1)] = {64,0},
    [I(245,1)] = {64,0},
    [I(246,1)] = {64,0},
    [I(247,1)] = {64,0},
    [I(248,1)] = {64,0},
    [I(249,1)] = {64,0},
    [I(250,1)] = {64,0},
    [I(251,1)] = {64,0},
    [I(252,1)] = {64,0},
    [I(253,1)] = {64,0},
    [I(254,1)] = {64,0},
    [I(255,1)] = {64,0},
    [I(0,2)] = {64,0},
    [I(1,2)] = {64,0},
    [I(2,2)] = {64,0},
    [I(3,2)] = {64,0},
    [I(4,2)] = {64,0},
    [I(5,2)] = {64,0},
    [I(6,2)] = {64,0},
    [I(7,2)] = {64,0},
    [I(8,2)] = {64,0},
    [I(9,2)] = {64,0},
    [I(10,2)] = {64,0},
    [I(11,2)] = {64,0},
    [I(12,2)] = {64,0},
    [I(13,2)] = {64,0},
    [I(14,2)] = {64,0},
    [I(15,2)] = {64,0},
    [I(16,2)] = {64,0},
    [I(17,2)] = {64,0},
    [I(18,2)] = {64,0},
    [I(19,2)] = {64,0},
    [I(20,2)] = {64,0},
    [I(21,2)] = {64,0},
    [I(22,2)] = {64,0},
    [I(23,2)] = {64,0},
    [I(24,2)] = {64,0},
    [I(25,2)] = {64,0},
    [I(26,2)] = {64,0},
    [I(27,2)] = {64,0},
    [I(28,2)] = {64,0},
    [I(29,2)] = {64,0},
    [I(30,2)] = {64,0},
    [I(31,2)] = {64,0},
    [I(32,2)] = {64,0},
    [I(33,2)] = {64,0},
    [I(34,2)] = {64,0},
    [I(35,2)] = {64,0},
    [I(36,2)] = {64,0},
    [I(37,2)] = {64,0},
    [I(38,2)] = {64,0},
    [I(39,2)] = {64,0},
    [I(40,2)] = {64,0},
    [I(41,2)] = {64,0},
    [I(42,2)] = {64,0},
    [I(43,2)] = {64,0},
    [I(44,2)] = {64,0},
    [I(45,2)] = {64,0},
    [I(46,2)] = {64,0},
    [I(47,2)] = {64,0},
    [I(48,2)] = {64,0},
    [I(49,2)] = {64,0},
    [I(50,2)] = {64,0},
    [I(51,2)] = {64,0},
    [I(52,2)] = {64,0},
    [I(53,2)] = {64,0},
    [I(54,2)] = {64,0},
    [I(55,2)] = {64,0},
    [I(56,2)] = {64,0},
    [I(57,2)] = {64,0},
    [I(58,2)] = {64,0},
    [I(59,2)] = {64,0},
    [I(60,2)] = {64,0},
    [I(61,2)] = {64,0},
    [I(62,2)] = {64,0},
    [I(63,2)] = {64,0},
    [I(64,2)] = {64,0},
    [I(65,2)] = {64,0},
    [I(66,2)] = {64,0},
    [I(67,2)] = {64,0},
    [I(68,2)] = {64,0},
    [I(69,2)] = {64,0},
    [I(70,2)] = {64,0},
    [I(71,2)] = {64,0},
    [I(72,2)] = {64,0},
    [I(73,2)] = {64,0},
    [I(74,2)] = {64,0},
    [I(75,2)] = {64,0},
    [I(76,2)] = {64,0},
    [I(77,2)] = {64,0},
    [I(78,2)] = {64,0},
    [I(79,2)] = {64,0},
    [I(80,2)] = {64,0},
    [I(81,2)] = {64,0},
    [I(82,2)] = {64,0},
    [I(83,2)] = {64,0},
    [I(84,2)] = {64,0},
    [I(85,2)] = {64,0},
    [I(86,2)] = {64,0},
    [I(87,2)] = {64,0},
    [I(88,2)] = {64,0},
    [I(89,2)] = {64,0},
    [I(90,2)] = {64,0},
    [I(91,2)] = {64,0},
    [I(92,2)] = {64,0},
    [I(93,2)] = {64,0},
    [I(94,2)] = {64,0},
    [I(95,2)] = {64,0},
    [I(96,2)] = {64,0},
    [I(97,2)] = {64,0},
    [I(98,2)] = {64,0},
    [I(99,2)] = {64,0},
    [I(100,2)] = {64,0},
    [I(101,2)] = {64,0},
    [I(102,2)] = {64,0},
    [I(103,2)] = {64,0},
    [I(104,2)] = {64,0},
    [I(105,2)] = {64,0},
    [I(106,2)] = {64,0},
    [I(107,2)] = {64,0},
    [I(108,2)] = {64,0},
    [I(109,2)] = {64,0},
    [I(110,2)] = {64,0},
    [I(111,2)] = {64,0},
    [I(112,2)] = {64,0},
    [I(113,2)] = {64,0},
    [I(114,2)] = {64,0},
    [I(115,2)] = {64,0},
    [I(116,2)] = {64,0},
    [I(117,2)] = {64,0},
    [I(118,2)] = {64,0},
    [I(119,2)] = {64,0},
    [I(120,2)] = {64,0},
    [I(121,2)] = {64,0},
    [I(122,2)] = {64,0},
    [I(123,2)] = {64,0},
    [I(124,2)] = {64,0},
    [I(125,2)] = {64,0},
    [I(126,2)] = {64,0},
    [I(127,2)] = {64,0},
    [I(128,2)] = {64,0},
    [I(129,2)] = {64,0},
    [I(130,2)] = {64,0},
    [I(131,2)] = {64,0},
    [I(132,2)] = {64,0},
    [I(133,2)] = {64,0},
    [I(134,2)] = {64,0},
    [I(135,2)] = {64,0},
    [I(136,2)] = {64,0},
    [I(137,2)] = {64,0},
    [I(138,2)] = {64,0},
    [I(139,2)] = {64,0},
    [I(140,2)] = {64,0},
    [I(141,2)] = {64,0},
    [I(142,2)] = {64,0},
    [I(143,2)] = {64,0},
    [I(144,2)] = {64,0},
    [I(145,2)] = {64,0},
    [I(146,2)] = {64,0},
    [I(147,2)] = {64,0},
    [I(148,2)] = {64,0},
    [I(149,2)] = {64,0},
    [I(150,2)] = {64,0},
    [I(151,2)] = {64,0},
    [I(152,2)] = {64,0},
    [I(153,2)] = {64,0},
    [I(154,2)] = {64,0},
    [I(155,2)] = {64,0},
    [I(156,2)] = {64,0},
    [I(157,2)] = {64,0},
    [I(158,2)] = {64,0},
    [I(159,2)] = {64,0},
    [I(160,2)] = {64,0},
    [I(161,2)] = {64,0},
    [I(162,2)] = {64,0},
    [I(163,2)] = {64,0},
    [I(164,2)] = {64,0},
    [I(165,2)] = {64,0},
    [I(166,2)] = {64,0},
    [I(167,2)] = {64,0},
    [I(168,2)] = {64,0},
    [I(169,2)] = {64,0},
    [I(170,2)] = {64,0},
    [I(171,2)] = {64,0},
    [I(172,2)] = {64,0},
    [I(173,2)] = {64,0},
    [I(174,2)] = {64,0},
    [I(175,2)] = {64,0},
    [I(176,2)] = {64,0},
    [I(177,2)] = {64,0},
    [I(178,2)] = {64,0},
    [I(179,2)] = {64,0},
    [I(180,2)] = {64,0},
    [I(181,2)] = {64,0},
    [I(182,2)] = {64,0},
    [I(183,2)] = {64,0},
    [I(184,2)] = {64,0},
    [I(185,2)] = {64,0},
    [I(186,2)] = {64,0},
    [I(187,2)] = {64,0},
    [I(188,2)] = {64,0},
    [I(189,2)] = {64,0},
    [I(190,2)] = {64,0},
    [I(191,2)] = {64,0},
    [I(192,2)] = {64,0},
    [I(193,2)] = {64,0},
    [I(194,2)] = {64,0},
    [I(195,2)] = {64,0},
    [I(196,2)] = {64,0},
    [I(197,2)] = {64,0},
    [I(198,2)] = {64,0},
    [I(199,2)] = {64,0},
    [I(200,2)] = {64,0},
    [I(201,2)] = {64,0},
    [I(202,2)] = {64,0},
    [I(203,2)] = {64,0},
    [I(204,2)] = {64,0},
    [I(205,2)] = {64,0},
    [I(206,2)] = {64,0},
    [I(207,2)] = {64,0},
    [I(208,2)] = {64,0},
    [I(209,2)] = {64,0},
    [I(210,2)] = {64,0},
    [I(211,2)] = {64,0},
    [I(212,2)] = {64,0},
    [I(213,2)] = {64,0},
    [I(214,2)] = {64,0},
    [I(215,2)] = {64,0},
    [I(216,2)] = {64,0},
    [I(217,2)] = {64,0},
    [I(218,2)] = {64,0},
    [I(219,2)] = {64,0},
    [I(220,2)] = {64,0},
    [I(221,2)] = {64,0},
    [I(222,2)] = {64,0},
    [I(223,2)] = {64,0},
    [I(224,2)] = {64,0},
    [I(225,2)] = {64,0},
    [I(226,2)] = {64,0},
    [I(227,2)] = {64,0},
    [I(228,2)] = {64,0},
    [I(229,2)] = {64,0},
    [I(230,2)] = {64,0},
    [I(231,2)] = {64,0},
    [I(232,2)] = {64,0},
    [I(233,2)] = {64,0},
    [I(234,2)] = {64,0},
    [I(235,2)] = {64,0},
    [I(236,2)] = {64,0},
    [I(237,2)] = {64,0},
    [I(238,2)] = {64,0},
    [I(239,2)] = {64,0},
    [I(240,2)] = {64,0},
    [I(241,2)] = {64,0},
    [I(242,2)] = {64,0},
    [I(243,2)] = {64,0},
    [I(244,2)] = {64,0},
    [I(245,2)] = {64,0},
    [I(246,2)] = {64,0},
    [I(247,2)] = {64,0},
    [I(248,2)] = {64,0},
    [I(249,2)] = {64,0},
    [I(250,2)] = {64,0},
    [I(251,2)] = {64,0},
    [I(252,2)] = {64,0},
    [I(253,2)] = {64,0},
    [I(254,2)] = {64,0},
    [I(255,2)] = {64,0},
    [I(0,3)] = {64,0},
    [I(1,3)] = {64,0},
    [I(2,3)] = {64,0},
    [I(3,3)] = {64,0},
    [I(4,3)] = {64,0},
    [I(5,3)] = {64,0},
    [I(6,3)] = {64,0},
    [I(7,3)] = {64,0},
    [I(8,3)] = {64,0},
    [I(9,3)] = {64,0},
    [I(10,3)] = {64,0},
    [I(11,3)] = {64,0},
    [I(12,3)] = {64,0},
    [I(13,3)] = {64,0},
    [I(14,3)] = {64,0},
    [I(15,3)] = {64,0},
    [I(16,3)] = {64,0},
    [I(17,3)] = {64,0},
    [I(18,3)] = {64,0},
    [I(19,3)] = {64,0},
    [I(20,3)] = {64,0},
    [I(21,3)] = {64,0},
    [I(22,3)] = {64,0},
    [I(23,3)] = {64,0},
    [I(24,3)] = {64,0},
    [I(25,3)] = {64,0},
    [I(26,3)] = {64,0},
    [I(27,3)] = {64,0},
    [I(28,3)] = {64,0},
    [I(29,3)] = {64,0},
    [I(30,3)] = {64,0},
    [I(31,3)] = {64,0},
    [I(32,3)] = {64,0},
    [I(33,3)] = {64,0},
    [I(34,3)] = {64,0},
    [I(35,3)] = {64,0},
    [I(36,3)] = {64,0},
    [I(37,3)] = {64,0},
    [I(38,3)] = {64,0},
    [I(39,3)] = {64,0},
    [I(40,3)] = {64,0},
    [I(41,3)] = {64,0},
    [I(42,3)] = {64,0},
    [I(43,3)] = {64,0},
    [I(44,3)] = {64,0},
    [I(45,3)] = {64,0},
    [I(46,3)] = {64,0},
    [I(47,3)] = {64,0},
    [I(48,3)] = {64,0},
    [I(49,3)] = {64,0},
    [I(50,3)] = {64,0},
    [I(51,3)] = {64,0},
    [I(52,3)] = {64,0},
    [I(53,3)] = {64,0},
    [I(54,3)] = {64,0},
    [I(55,3)] = {64,0},
    [I(56,3)] = {64,0},
    [I(57,3)] = {64,0},
    [I(58,3)] = {64,0},
    [I(59,3)] = {64,0},
    [I(60,3)] = {64,0},
    [I(61,3)] = {64,0},
    [I(62,3)] = {64,0},
    [I(63,3)] = {64,0},
    [I(64,3)] = {64,0},
    [I(65,3)] = {64,0},
    [I(66,3)] = {64,0},
    [I(67,3)] = {64,0},
    [I(68,3)] = {64,0},
    [I(69,3)] = {64,0},
    [I(70,3)] = {64,0},
    [I(71,3)] = {64,0},
    [I(72,3)] = {64,0},
    [I(73,3)] = {64,0},
    [I(74,3)] = {64,0},
    [I(75,3)] = {64,0},
    [I(76,3)] = {64,0},
    [I(77,3)] = {64,0},
    [I(78,3)] = {64,0},
    [I(79,3)] = {64,0},
    [I(80,3)] = {64,0},
    [I(81,3)] = {64,0},
    [I(82,3)] = {64,0},
    [I(83,3)] = {64,0},
    [I(84,3)] = {64,0},
    [I(85,3)] = {64,0},
    [I(86,3)] = {64,0},
    [I(87,3)] = {64,0},
    [I(88,3)] = {64,0},
    [I(89,3)] = {64,0},
    [I(90,3)] = {64,0},
    [I(91,3)] = {64,0},
    [I(92,3)] = {64,0},
    [I(93,3)] = {64,0},
    [I(94,3)] = {64,0},
    [I(95,3)] = {64,0},
    [I(96,3)] = {64,0},
    [I(97,3)] = {64,0},
    [I(98,3)] = {64,0},
    [I(99,3)] = {64,0},
    [I(100,3)] = {64,0},
    [I(101,3)] = {64,0},
    [I(102,3)] = {64,0},
    [I(103,3)] = {64,0},
    [I(104,3)] = {64,0},
    [I(105,3)] = {64,0},
    [I(106,3)] = {64,0},
    [I(107,3)] = {64,0},
    [I(108,3)] = {64,0},
    [I(109,3)] = {64,0},
    [I(110,3)] = {64,0},
    [I(111,3)] = {64,0},
    [I(112,3)] = {64,0},
    [I(113,3)] = {64,0},
    [I(114,3)] = {64,0},
    [I(115,3)] = {64,0},
    [I(116,3)] = {64,0},
    [I(117,3)] = {64,0},
    [I(118,3)] = {64,0},
    [I(119,3)] = {64,0},
    [I(120,3)] = {64,0},
    [I(121,3)] = {64,0},
    [I(122,3)] = {64,0},
    [I(123,3)] = {64,0},
    [I(124,3)] = {64,0},
    [I(125,3)] = {64,0},
    [I(126,3)] = {64,0},
    [I(127,3)] = {64,0},
    [I(128,3)] = {64,0},
    [I(129,3)] = {64,0},
    [I(130,3)] = {64,0},
    [I(131,3)] = {64,0},
    [I(132,3)] = {64,0},
    [I(133,3)] = {64,0},
    [I(134,3)] = {64,0},
    [I(135,3)] = {64,0},
    [I(136,3)] = {64,0},
    [I(137,3)] = {64,0},
    [I(138,3)] = {64,0},
    [I(139,3)] = {64,0},
    [I(140,3)] = {64,0},
    [I(141,3)] = {64,0},
    [I(142,3)] = {64,0},
    [I(143,3)] = {64,0},
    [I(144,3)] = {64,0},
    [I(145,3)] = {64,0},
    [I(146,3)] = {64,0},
    [I(147,3)] = {64,0},
    [I(148,3)] = {64,0},
    [I(149,3)] = {64,0},
    [I(150,3)] = {64,0},
    [I(151,3)] = {64,0},
    [I(152,3)] = {64,0},
    [I(153,3)] = {64,0},
    [I(154,3)] = {64,0},
    [I(155,3)] = {64,0},
    [I(156,3)] = {64,0},
    [I(157,3)] = {64,0},
    [I(158,3)] = {64,0},
    [I(159,3)] = {64,0},
    [I(160,3)] = {64,0},
    [I(161,3)] = {64,0},
    [I(162,3)] = {64,0},
    [I(163,3)] = {64,0},
    [I(164,3)] = {64,0},
    [I(165,3)] = {64,0},
    [I(166,3)] = {64,0},
    [I(167,3)] = {64,0},
    [I(168,3)] = {64,0},
    [I(169,3)] = {64,0},
    [I(170,3)] = {64,0},
    [I(171,3)] = {64,0},
    [I(172,3)] = {64,0},
    [I(173,3)] = {64,0},
    [I(174,3)] = {64,0},
    [I(175,3)] = {64,0},
    [I(176,3)] = {64,0},
    [I(177,3)] = {64,0},
    [I(178,3)] = {64,0},
    [I(179,3)] = {64,0},
    [I(180,3)] = {64,0},
    [I(181,3)] = {64,0},
    [I(182,3)] = {64,0},
    [I(183,3)] = {64,0},
    [I(184,3)] = {64,0},
    [I(185,3)] = {64,0},
    [I(186,3)] = {64,0},
    [I(187,3)] = {64,0},
    [I(188,3)] = {64,0},
    [I(189,3)] = {64,0},
    [I(190,3)] = {64,0},
    [I(191,3)] = {64,0},
    [I(192,3)] = {64,0},
    [I(193,3)] = {64,0},
    [I(194,3)] = {64,0},
    [I(195,3)] = {64,0},
    [I(196,3)] = {64,0},
    [I(197,3)] = {64,0},
    [I(198,3)] = {64,0},
    [I(199,3)] = {64,0},
    [I(200,3)] = {64,0},
    [I(201,3)] = {64,0},
    [I(202,3)] = {64,0},
    [I(203,3)] = {64,0},
    [I(204,3)] = {64,0},
    [I(205,3)] = {64,0},
    [I(206,3)] = {64,0},
    [I(207,3)] = {64,0},
    [I(208,3)] = {64,0},
    [I(209,3)] = {64,0},
    [I(210,3)] = {64,0},
    [I(211,3)] = {64,0},
    [I(212,3)] = {64,0},
    [I(213,3)] = {64,0},
    [I(214,3)] = {64,0},
    [I(215,3)] = {64,0},
    [I(216,3)] = {64,0},
    [I(217,3)] = {64,0},
    [I(218,3)] = {64,0},
    [I(219,3)] = {64,0},
    [I(220,3)] = {64,0},
    [I(221,3)] = {64,0},
    [I(222,3)] = {64,0},
    [I(223,3)] = {64,0},
    [I(224,3)] = {64,0},
    [I(225,3)] = {64,0},
    [I(226,3)] = {64,0},
    [I(227,3)] = {64,0},
    [I(228,3)] = {64,0},
    [I(229,3)] = {64,0},
    [I(230,3)] = {64,0},
    [I(231,3)] = {64,0},
    [I(232,3)] = {64,0},
    [I(233,3)] = {64,0},
    [I(234,3)] = {64,0},
    [I(235,3)] = {64,0},
    [I(236,3)] = {64,0},
    [I(237,3)] = {64,0},
    [I(238,3)] = {64,0},
    [I(239,3)] = {64,0},
    [I(240,3)] = {64,0},
    [I(241,3)] = {64,0},
    [I(242,3)] = {64,0},
    [I(243,3)] = {64,0},
    [I(244,3)] = {64,0},
    [I(245,3)] = {64,0},
    [I(246,3)] = {64,0},
    [I(247,3)] = {64,0},
    [I(248,3)] = {64,0},
    [I(249,3)] = {64,0},
    [I(250,3)] = {64,0},
    [I(251,3)] = {64,0},
    [I(252,3)] = {64,0},
    [I(253,3)] = {64,0},
    [I(254,3)] = {64,0},
    [I(255,3)] = {64,0},
    [I(0,4)] = {64,0},
    [I(1,4)] = {64,0},
    [I(2,4)] = {64,0},
    [I(3,4)] = {64,0},
    [I(4,4)] = {64,0},
    [I(5,4)] = {64,0},
    [I(6,4)] = {64,0},
    [I(7,4)] = {64,0},
    [I(8,4)] = {64,0},
    [I(9,4)] = {64,0},
    [I(10,4)] = {64,0},
    [I(11,4)] = {64,0},
    [I(12,4)] = {64,0},
    [I(13,4)] = {64,0},
    [I(14,4)] = {64,0},
    [I(15,4)] = {64,0},
    [I(16,4)] = {64,0},
    [I(17,4)] = {64,0},
    [I(18,4)] = {64,0},
    [I(19,4)] = {64,0},
    [I(20,4)] = {64,0},
    [I(21,4)] = {64,0},
    [I(22,4)] = {64,0},
    [I(23,4)] = {64,0},
    [I(24,4)] = {64,0},
    [I(25,4)] = {64,0},
    [I(26,4)] = {64,0},
    [I(27,4)] = {64,0},
    [I(28,4)] = {64,0},
    [I(29,4)] = {64,0},
    [I(30,4)] = {64,0},
    [I(31,4)] = {64,0},
    [I(32,4)] = {64,0},
    [I(33,4)] = {64,0},
    [I(34,4)] = {64,0},
    [I(35,4)] = {64,0},
    [I(36,4)] = {64,0},
    [I(37,4)] = {64,0},
    [I(38,4)] = {64,0},
    [I(39,4)] = {64,0},
    [I(40,4)] = {64,0},
    [I(41,4)] = {64,0},
    [I(42,4)] = {64,0},
    [I(43,4)] = {64,0},
    [I(44,4)] = {64,0},
    [I(45,4)] = {64,0},
    [I(46,4)] = {64,0},
    [I(47,4)] = {64,0},
    [I(48,4)] = {64,0},
    [I(49,4)] = {64,0},
    [I(50,4)] = {64,0},
    [I(51,4)] = {64,0},
    [I(52,4)] = {64,0},
    [I(53,4)] = {64,0},
    [I(54,4)] = {64,0},
    [I(55,4)] = {64,0},
    [I(56,4)] = {64,0},
    [I(57,4)] = {64,0},
    [I(58,4)] = {64,0},
    [I(59,4)] = {64,0},
    [I(60,4)] = {64,0},
    [I(61,4)] = {64,0},
    [I(62,4)] = {64,0},
    [I(63,4)] = {64,0},
    [I(64,4)] = {64,0},
    [I(65,4)] = {64,0},
    [I(66,4)] = {64,0},
    [I(67,4)] = {64,0},
    [I(68,4)] = {64,0},
    [I(69,4)] = {64,0},
    [I(70,4)] = {64,0},
    [I(71,4)] = {64,0},
    [I(72,4)] = {64,0},
    [I(73,4)] = {64,0},
    [I(74,4)] = {64,0},
    [I(75,4)] = {64,0},
    [I(76,4)] = {64,0},
    [I(77,4)] = {64,0},
    [I(78,4)] = {64,0},
    [I(79,4)] = {64,0},
    [I(80,4)] = {64,0},
    [I(81,4)] = {64,0},
    [I(82,4)] = {64,0},
    [I(83,4)] = {64,0},
    [I(84,4)] = {64,0},
    [I(85,4)] = {64,0},
    [I(86,4)] = {64,0},
    [I(87,4)] = {64,0},
    [I(88,4)] = {64,0},
    [I(89,4)] = {64,0},
    [I(90,4)] = {64,0},
    [I(91,4)] = {64,0},
    [I(92,4)] = {64,0},
    [I(93,4)] = {64,0},
    [I(94,4)] = {64,0},
    [I(95,4)] = {64,0},
    [I(96,4)] = {64,0},
    [I(97,4)] = {64,0},
    [I(98,4)] = {64,0},
    [I(99,4)] = {64,0},
    [I(100,4)] = {64,0},
    [I(101,4)] = {64,0},
    [I(102,4)] = {64,0},
    [I(103,4)] = {64,0},
    [I(104,4)] = {64,0},
    [I(105,4)] = {64,0},
    [I(106,4)] = {64,0},
    [I(107,4)] = {64,0},
    [I(108,4)] = {64,0},
    [I(109,4)] = {64,0},
    [I(110,4)] = {64,0},
    [I(111,4)] = {64,0},
    [I(112,4)] = {64,0},
    [I(113,4)] = {64,0},
    [I(114,4)] = {64,0},
    [I(115,4)] = {64,0},
    [I(116,4)] = {64,0},
    [I(117,4)] = {64,0},
    [I(118,4)] = {64,0},
    [I(119,4)] = {64,0},
    [I(120,4)] = {64,0},
    [I(121,4)] = {64,0},
    [I(122,4)] = {64,0},
    [I(123,4)] = {64,0},
    [I(124,4)] = {64,0},
    [I(125,4)] = {64,0},
    [I(126,4)] = {64,0},
    [I(127,4)] = {64,0},
    [I(128,4)] = {64,0},
    [I(129,4)] = {64,0},
    [I(130,4)] = {64,0},
    [I(131,4)] = {64,0},
    [I(132,4)] = {64,0},
    [I(133,4)] = {64,0},
    [I(134,4)] = {64,0},
    [I(135,4)] = {64,0},
    [I(136,4)] = {64,0},
    [I(137,4)] = {64,0},
    [I(138,4)] = {64,0},
    [I(139,4)] = {64,0},
    [I(140,4)] = {64,0},
    [I(141,4)] = {64,0},
    [I(142,4)] = {64,0},
    [I(143,4)] = {64,0},
    [I(144,4)] = {64,0},
    [I(145,4)] = {64,0},
    [I(146,4)] = {64,0},
    [I(147,4)] = {64,0},
    [I(148,4)] = {64,0},
    [I(149,4)] = {64,0},
    [I(150,4)] = {64,0},
    [I(151,4)] = {64,0},
    [I(152,4)] = {64,0},
    [I(153,4)] = {64,0},
    [I(154,4)] = {64,0},
    [I(155,4)] = {64,0},
    [I(156,4)] = {64,0},
    [I(157,4)] = {64,0},
    [I(158,4)] = {64,0},
    [I(159,4)] = {64,0},
    [I(160,4)] = {64,0},
    [I(161,4)] = {64,0},
    [I(162,4)] = {64,0},
    [I(163,4)] = {64,0},
    [I(164,4)] = {64,0},
    [I(165,4)] = {64,0},
    [I(166,4)] = {64,0},
    [I(167,4)] = {64,0},
    [I(168,4)] = {64,0},
    [I(169,4)] = {64,0},
    [I(170,4)] = {64,0},
    [I(171,4)] = {64,0},
    [I(172,4)] = {64,0},
    [I(173,4)] = {64,0},
    [I(174,4)] = {64,0},
    [I(175,4)] = {64,0},
    [I(176,4)] = {64,0},
    [I(177,4)] = {64,0},
    [I(178,4)] = {64,0},
    [I(179,4)] = {64,0},
    [I(180,4)] = {64,0},
    [I(181,4)] = {64,0},
    [I(182,4)] = {64,0},
    [I(183,4)] = {64,0},
    [I(184,4)] = {64,0},
    [I(185,4)] = {64,0},
    [I(186,4)] = {64,0},
    [I(187,4)] = {64,0},
    [I(188,4)] = {64,0},
    [I(189,4)] = {64,0},
    [I(190,4)] = {64,0},
    [I(191,4)] = {64,0},
    [I(192,4)] = {64,0},
    [I(193,4)] = {64,0},
    [I(194,4)] = {64,0},
    [I(195,4)] = {64,0},
    [I(196,4)] = {64,0},
    [I(197,4)] = {64,0},
    [I(198,4)] = {64,0},
    [I(199,4)] = {64,0},
    [I(200,4)] = {64,0},
    [I(201,4)] = {64,0},
    [I(202,4)] = {64,0},
    [I(203,4)] = {64,0},
    [I(204,4)] = {64,0},
    [I(205,4)] = {64,0},
    [I(206,4)] = {64,0},
    [I(207,4)] = {64,0},
    [I(208,4)] = {64,0},
    [I(209,4)] = {64,0},
    [I(210,4)] = {64,0},
    [I(211,4)] = {64,0},
    [I(212,4)] = {64,0},
    [I(213,4)] = {64,0},
    [I(214,4)] = {64,0},
    [I(215,4)] = {64,0},
    [I(216,4)] = {64,0},
    [I(217,4)] = {64,0},
    [I(218,4)] = {64,0},
    [I(219,4)] = {64,0},
    [I(220,4)] = {64,0},
    [I(221,4)] = {64,0},
    [I(222,4)] = {64,0},
    [I(223,4)] = {64,0},
    [I(224,4)] = {64,0},
    [I(225,4)] = {64,0},
    [I(226,4)] = {64,0},
    [I(227,4)] = {64,0},
    [I(228,4)] = {64,0},
    [I(229,4)] = {64,0},
    [I(230,4)] = {64,0},
    [I(231,4)] = {64,0},
    [I(232,4)] = {64,0},
    [I(233,4)] = {64,0},
    [I(234,4)] = {64,0},
    [I(235,4)] = {64,0},
    [I(236,4)] = {64,0},
    [I(237,4)] = {64,0},
    [I(238,4)] = {64,0},
    [I(239,4)] = {64,0},
    [I(240,4)] = {64,0},
    [I(241,4)] = {64,0},
    [I(242,4)] = {64,0},
    [I(243,4)] = {64,0},
    [I(244,4)] = {64,0},
    [I(245,4)] = {64,0},
    [I(246,4)] = {64,0},
    [I(247,4)] = {64,0},
    [I(248,4)] = {64,0},
    [I(249,4)] = {64,0},
    [I(250,4)] = {64,0},
    [I(251,4)] = {64,0},
    [I(252,4)] = {64,0},
    [I(253,4)] = {64,0},
    [I(254,4)] = {64,0},
    [I(255,4)] = {64,0},
    [I(0,5)] = {64,0},
    [I(1,5)] = {64,0},
    [I(2,5)] = {64,0},
    [I(3,5)] = {64,0},
    [I(4,5)] = {64,0},
    [I(5,5)] = {64,0},
    [I(6,5)] = {64,0},
    [I(7,5)] = {64,0},
    [I(8,5)] = {64,0},
    [I(9,5)] = {64,0},
    [I(10,5)] = {64,0},
    [I(11,5)] = {64,0},
    [I(12,5)] = {64,0},
    [I(13,5)] = {64,0},
    [I(14,5)] = {64,0},
    [I(15,5)] = {64,0},
    [I(16,5)] = {64,0},
    [I(17,5)] = {64,0},
    [I(18,5)] = {64,0},
    [I(19,5)] = {64,0},
    [I(20,5)] = {64,0},
    [I(21,5)] = {64,0},
    [I(22,5)] = {64,0},
    [I(23,5)] = {64,0},
    [I(24,5)] = {64,0},
    [I(25,5)] = {64,0},
    [I(26,5)] = {64,0},
    [I(27,5)] = {64,0},
    [I(28,5)] = {64,0},
    [I(29,5)] = {64,0},
    [I(30,5)] = {64,0},
    [I(31,5)] = {64,0},
    [I(32,5)] = {64,0},
    [I(33,5)] = {64,0},
    [I(34,5)] = {64,0},
    [I(35,5)] = {64,0},
    [I(36,5)] = {64,0},
    [I(37,5)] = {64,0},
    [I(38,5)] = {64,0},
    [I(39,5)] = {64,0},
    [I(40,5)] = {64,0},
    [I(41,5)] = {64,0},
    [I(42,5)] = {64,0},
    [I(43,5)] = {64,0},
    [I(44,5)] = {64,0},
    [I(45,5)] = {64,0},
    [I(46,5)] = {64,0},
    [I(47,5)] = {64,0},
    [I(48,5)] = {64,0},
    [I(49,5)] = {64,0},
    [I(50,5)] = {64,0},
    [I(51,5)] = {64,0},
    [I(52,5)] = {64,0},
    [I(53,5)] = {64,0},
    [I(54,5)] = {64,0},
    [I(55,5)] = {64,0},
    [I(56,5)] = {64,0},
    [I(57,5)] = {64,0},
    [I(58,5)] = {64,0},
    [I(59,5)] = {64,0},
    [I(60,5)] = {64,0},
    [I(61,5)] = {64,0},
    [I(62,5)] = {64,0},
    [I(63,5)] = {64,0},
    [I(64,5)] = {64,0},
    [I(65,5)] = {64,0},
    [I(66,5)] = {64,0},
    [I(67,5)] = {64,0},
    [I(68,5)] = {64,0},
    [I(69,5)] = {64,0},
    [I(70,5)] = {64,0},
    [I(71,5)] = {64,0},
    [I(72,5)] = {64,0},
    [I(73,5)] = {64,0},
    [I(74,5)] = {64,0},
    [I(75,5)] = {64,0},
    [I(76,5)] = {64,0},
    [I(77,5)] = {64,0},
    [I(78,5)] = {64,0},
    [I(79,5)] = {64,0},
    [I(80,5)] = {64,0},
    [I(81,5)] = {64,0},
    [I(82,5)] = {64,0},
    [I(83,5)] = {64,0},
    [I(84,5)] = {64,0},
    [I(85,5)] = {64,0},
    [I(86,5)] = {64,0},
    [I(87,5)] = {64,0},
    [I(88,5)] = {64,0},
    [I(89,5)] = {64,0},
    [I(90,5)] = {64,0},
    [I(91,5)] = {64,0},
    [I(92,5)] = {64,0},
    [I(93,5)] = {64,0},
    [I(94,5)] = {64,0},
    [I(95,5)] = {64,0},
    [I(96,5)] = {64,0},
    [I(97,5)] = {64,0},
    [I(98,5)] = {64,0},
    [I(99,5)] = {64,0},
    [I(100,5)] = {64,0},
    [I(101,5)] = {64,0},
    [I(102,5)] = {64,0},
    [I(103,5)] = {64,0},
    [I(104,5)] = {64,0},
    [I(105,5)] = {64,0},
    [I(106,5)] = {64,0},
    [I(107,5)] = {64,0},
    [I(108,5)] = {64,0},
    [I(109,5)] = {64,0},
    [I(110,5)] = {64,0},
    [I(111,5)] = {64,0},
    [I(112,5)] = {64,0},
    [I(113,5)] = {64,0},
    [I(114,5)] = {64,0},
    [I(115,5)] = {64,0},
    [I(116,5)] = {64,0},
    [I(117,5)] = {64,0},
    [I(118,5)] = {64,0},
    [I(119,5)] = {64,0},
    [I(120,5)] = {64,0},
    [I(121,5)] = {64,0},
    [I(122,5)] = {64,0},
    [I(123,5)] = {64,0},
    [I(124,5)] = {64,0},
    [I(125,5)] = {64,0},
    [I(126,5)] = {64,0},
    [I(127,5)] = {64,0},
    [I(128,5)] = {64,0},
    [I(129,5)] = {64,0},
    [I(130,5)] = {64,0},
    [I(131,5)] = {64,0},
    [I(132,5)] = {64,0},
    [I(133,5)] = {64,0},
    [I(134,5)] = {64,0},
    [I(135,5)] = {64,0},
    [I(136,5)] = {64,0},
    [I(137,5)] = {64,0},
    [I(138,5)] = {64,0},
    [I(139,5)] = {64,0},
    [I(140,5)] = {64,0},
    [I(141,5)] = {64,0},
    [I(142,5)] = {64,0},
    [I(143,5)] = {64,0},
    [I(144,5)] = {64,0},
    [I(145,5)] = {64,0},
    [I(146,5)] = {64,0},
    [I(147,5)] = {64,0},
    [I(148,5)] = {64,0},
    [I(149,5)] = {64,0},
    [I(150,5)] = {64,0},
    [I(151,5)] = {64,0},
    [I(152,5)] = {64,0},
    [I(153,5)] = {64,0},
    [I(154,5)] = {64,0},
    [I(155,5)] = {64,0},
    [I(156,5)] = {64,0},
    [I(157,5)] = {64,0},
    [I(158,5)] = {64,0},
    [I(159,5)] = {64,0},
    [I(160,5)] = {64,0},
    [I(161,5)] = {64,0},
    [I(162,5)] = {64,0},
    [I(163,5)] = {64,0},
    [I(164,5)] = {64,0},
    [I(165,5)] = {64,0},
    [I(166,5)] = {64,0},
    [I(167,5)] = {64,0},
    [I(168,5)] = {64,0},
    [I(169,5)] = {64,0},
    [I(170,5)] = {64,0},
    [I(171,5)] = {64,0},
    [I(172,5)] = {64,0},
    [I(173,5)] = {64,0},
    [I(174,5)] = {64,0},
    [I(175,5)] = {64,0},
    [I(176,5)] = {64,0},
    [I(177,5)] = {64,0},
    [I(178,5)] = {64,0},
    [I(179,5)] = {64,0},
    [I(180,5)] = {64,0},
    [I(181,5)] = {64,0},
    [I(182,5)] = {64,0},
    [I(183,5)] = {64,0},
    [I(184,5)] = {64,0},
    [I(185,5)] = {64,0},
    [I(186,5)] = {64,0},
    [I(187,5)] = {64,0},
    [I(188,5)] = {64,0},
    [I(189,5)] = {64,0},
    [I(190,5)] = {64,0},
    [I(191,5)] = {64,0},
    [I(192,5)] = {64,0},
    [I(193,5)] = {64,0},
    [I(194,5)] = {64,0},
    [I(195,5)] = {64,0},
    [I(196,5)] = {64,0},
    [I(197,5)] = {64,0},
    [I(198,5)] = {64,0},
    [I(199,5)] = {64,0},
    [I(200,5)] = {64,0},
    [I(201,5)] = {64,0},
    [I(202,5)] = {64,0},
    [I(203,5)] = {64,0},
    [I(204,5)] = {64,0},
    [I(205,5)] = {64,0},
    [I(206,5)] = {64,0},
    [I(207,5)] = {64,0},
    [I(208,5)] = {64,0},
    [I(209,5)] = {64,0},
    [I(210,5)] = {64,0},
    [I(211,5)] = {64,0},
    [I(212,5)] = {64,0},
    [I(213,5)] = {64,0},
    [I(214,5)] = {64,0},
    [I(215,5)] = {64,0},
    [I(216,5)] = {64,0},
    [I(217,5)] = {64,0},
    [I(218,5)] = {64,0},
    [I(219,5)] = {64,0},
    [I(220,5)] = {64,0},
    [I(221,5)] = {64,0},
    [I(222,5)] = {64,0},
    [I(223,5)] = {64,0},
    [I(224,5)] = {64,0},
    [I(225,5)] = {64,0},
    [I(226,5)] = {64,0},
    [I(227,5)] = {64,0},
    [I(228,5)] = {64,0},
    [I(229,5)] = {64,0},
    [I(230,5)] = {64,0},
    [I(231,5)] = {64,0},
    [I(232,5)] = {64,0},
    [I(233,5)] = {64,0},
    [I(234,5)] = {64,0},
    [I(235,5)] = {64,0},
    [I(236,5)] = {64,0},
    [I(237,5)] = {64,0},
    [I(238,5)] = {64,0},
    [I(239,5)] = {64,0},
    [I(240,5)] = {64,0},
    [I(241,5)] = {64,0},
    [I(242,5)] = {64,0},
    [I(243,5)] = {64,0},
    [I(244,5)] = {64,0},
    [I(245,5)] = {64,0},
    [I(246,5)] = {64,0},
    [I(247,5)] = {64,0},
    [I(248,5)] = {64,0},
    [I(249,5)] = {64,0},
    [I(250,5)] = {64,0},
    [I(251,5)] = {64,0},
    [I(252,5)] = {64,0},
    [I(253,5)] = {64,0},
    [I(254,5)] = {64,0},
    [I(255,5)] = {64,0},
    [I(0,6)] = {64,0},
    [I(1,6)] = {64,0},
    [I(2,6)] = {64,0},
    [I(3,6)] = {64,0},
    [I(4,6)] = {64,0},
    [I(5,6)] = {64,0},
    [I(6,6)] = {64,0},
    [I(7,6)] = {64,0},
    [I(8,6)] = {64,0},
    [I(9,6)] = {64,0},
    [I(10,6)] = {64,0},
    [I(11,6)] = {64,0},
    [I(12,6)] = {64,0},
    [I(13,6)] = {64,0},
    [I(14,6)] = {64,0},
    [I(15,6)] = {64,0},
    [I(16,6)] = {64,0},
    [I(17,6)] = {64,0},
    [I(18,6)] = {64,0},
    [I(19,6)] = {64,0},
    [I(20,6)] = {64,0},
    [I(21,6)] = {64,0},
    [I(22,6)] = {64,0},
    [I(23,6)] = {64,0},
    [I(24,6)] = {64,0},
    [I(25,6)] = {64,0},
    [I(26,6)] = {64,0},
    [I(27,6)] = {64,0},
    [I(28,6)] = {64,0},
    [I(29,6)] = {64,0},
    [I(30,6)] = {64,0},
    [I(31,6)] = {64,0},
    [I(32,6)] = {64,0},
    [I(33,6)] = {64,0},
    [I(34,6)] = {64,0},
    [I(35,6)] = {64,0},
    [I(36,6)] = {64,0},
    [I(37,6)] = {64,0},
    [I(38,6)] = {64,0},
    [I(39,6)] = {64,0},
    [I(40,6)] = {64,0},
    [I(41,6)] = {64,0},
    [I(42,6)] = {64,0},
    [I(43,6)] = {64,0},
    [I(44,6)] = {64,0},
    [I(45,6)] = {64,0},
    [I(46,6)] = {64,0},
    [I(47,6)] = {64,0},
    [I(48,6)] = {64,0},
    [I(49,6)] = {64,0},
    [I(50,6)] = {64,0},
    [I(51,6)] = {64,0},
    [I(52,6)] = {64,0},
    [I(53,6)] = {64,0},
    [I(54,6)] = {64,0},
    [I(55,6)] = {64,0},
    [I(56,6)] = {64,0},
    [I(57,6)] = {64,0},
    [I(58,6)] = {64,0},
    [I(59,6)] = {64,0},
    [I(60,6)] = {64,0},
    [I(61,6)] = {64,0},
    [I(62,6)] = {64,0},
    [I(63,6)] = {64,0},
    [I(64,6)] = {64,0},
    [I(65,6)] = {64,0},
    [I(66,6)] = {64,0},
    [I(67,6)] = {64,0},
    [I(68,6)] = {64,0},
    [I(69,6)] = {64,0},
    [I(70,6)] = {64,0},
    [I(71,6)] = {64,0},
    [I(72,6)] = {64,0},
    [I(73,6)] = {64,0},
    [I(74,6)] = {64,0},
    [I(75,6)] = {64,0},
    [I(76,6)] = {64,0},
    [I(77,6)] = {64,0},
    [I(78,6)] = {64,0},
    [I(79,6)] = {64,0},
    [I(80,6)] = {64,0},
    [I(81,6)] = {64,0},
    [I(82,6)] = {64,0},
    [I(83,6)] = {64,0},
    [I(84,6)] = {64,0},
    [I(85,6)] = {64,0},
    [I(86,6)] = {64,0},
    [I(87,6)] = {64,0},
    [I(88,6)] = {64,0},
    [I(89,6)] = {64,0},
    [I(90,6)] = {64,0},
    [I(91,6)] = {64,0},
    [I(92,6)] = {64,0},
    [I(93,6)] = {64,0},
    [I(94,6)] = {64,0},
    [I(95,6)] = {64,0},
    [I(96,6)] = {64,0},
    [I(97,6)] = {64,0},
    [I(98,6)] = {64,0},
    [I(99,6)] = {64,0},
    [I(100,6)] = {64,0},
    [I(101,6)] = {64,0},
    [I(102,6)] = {64,0},
    [I(103,6)] = {64,0},
    [I(104,6)] = {64,0},
    [I(105,6)] = {64,0},
    [I(106,6)] = {64,0},
    [I(107,6)] = {64,0},
    [I(108,6)] = {64,0},
    [I(109,6)] = {64,0},
    [I(110,6)] = {64,0},
    [I(111,6)] = {64,0},
    [I(112,6)] = {64,0},
    [I(113,6)] = {64,0},
    [I(114,6)] = {64,0},
    [I(115,6)] = {64,0},
    [I(116,6)] = {64,0},
    [I(117,6)] = {64,0},
    [I(118,6)] = {64,0},
    [I(119,6)] = {64,0},
    [I(120,6)] = {64,0},
    [I(121,6)] = {64,0},
    [I(122,6)] = {64,0},
    [I(123,6)] = {64,0},
    [I(124,6)] = {64,0},
    [I(125,6)] = {64,0},
    [I(126,6)] = {64,0},
    [I(127,6)] = {64,0},
    [I(128,6)] = {64,0},
    [I(129,6)] = {64,0},
    [I(130,6)] = {64,0},
    [I(131,6)] = {64,0},
    [I(132,6)] = {64,0},
    [I(133,6)] = {64,0},
    [I(134,6)] = {64,0},
    [I(135,6)] = {64,0},
    [I(136,6)] = {64,0},
    [I(137,6)] = {64,0},
    [I(138,6)] = {64,0},
    [I(139,6)] = {64,0},
    [I(140,6)] = {64,0},
    [I(141,6)] = {64,0},
    [I(142,6)] = {64,0},
    [I(143,6)] = {64,0},
    [I(144,6)] = {64,0},
    [I(145,6)] = {64,0},
    [I(146,6)] = {64,0},
    [I(147,6)] = {64,0},
    [I(148,6)] = {64,0},
    [I(149,6)] = {64,0},
    [I(150,6)] = {64,0},
    [I(151,6)] = {64,0},
    [I(152,6)] = {64,0},
    [I(153,6)] = {64,0},
    [I(154,6)] = {64,0},
    [I(155,6)] = {64,0},
    [I(156,6)] = {64,0},
    [I(157,6)] = {64,0},
    [I(158,6)] = {64,0},
    [I(159,6)] = {64,0},
    [I(160,6)] = {64,0},
    [I(161,6)] = {64,0},
    [I(162,6)] = {64,0},
    [I(163,6)] = {64,0},
    [I(164,6)] = {64,0},
    [I(165,6)] = {64,0},
    [I(166,6)] = {64,0},
    [I(167,6)] = {64,0},
    [I(168,6)] = {64,0},
    [I(169,6)] = {64,0},
    [I(170,6)] = {64,0},
    [I(171,6)] = {64,0},
    [I(172,6)] = {64,0},
    [I(173,6)] = {64,0},
    [I(174,6)] = {64,0},
    [I(175,6)] = {64,0},
    [I(176,6)] = {64,0},
    [I(177,6)] = {64,0},
    [I(178,6)] = {64,0},
    [I(179,6)] = {64,0},
    [I(180,6)] = {64,0},
    [I(181,6)] = {64,0},
    [I(182,6)] = {64,0},
    [I(183,6)] = {64,0},
    [I(184,6)] = {64,0},
    [I(185,6)] = {64,0},
    [I(186,6)] = {64,0},
    [I(187,6)] = {64,0},
    [I(188,6)] = {64,0},
    [I(189,6)] = {64,0},
    [I(190,6)] = {64,0},
    [I(191,6)] = {64,0},
    [I(192,6)] = {64,0},
    [I(193,6)] = {64,0},
    [I(194,6)] = {64,0},
    [I(195,6)] = {64,0},
    [I(196,6)] = {64,0},
    [I(197,6)] = {64,0},
    [I(198,6)] = {64,0},
    [I(199,6)] = {64,0},
    [I(200,6)] = {64,0},
    [I(201,6)] = {64,0},
    [I(202,6)] = {64,0},
    [I(203,6)] = {64,0},
    [I(204,6)] = {64,0},
    [I(205,6)] = {64,0},
    [I(206,6)] = {64,0},
    [I(207,6)] = {64,0},
    [I(208,6)] = {64,0},
    [I(209,6)] = {64,0},
    [I(210,6)] = {64,0},
    [I(211,6)] = {64,0},
    [I(212,6)] = {64,0},
    [I(213,6)] = {64,0},
    [I(214,6)] = {64,0},
    [I(215,6)] = {64,0},
    [I(216,6)] = {64,0},
    [I(217,6)] = {64,0},
    [I(218,6)] = {64,0},
    [I(219,6)] = {64,0},
    [I(220,6)] = {64,0},
    [I(221,6)] = {64,0},
    [I(222,6)] = {64,0},
    [I(223,6)] = {64,0},
    [I(224,6)] = {64,0},
    [I(225,6)] = {64,0},
    [I(226,6)] = {64,0},
    [I(227,6)] = {64,0},
    [I(228,6)] = {64,0},
    [I(229,6)] = {64,0},
    [I(230,6)] = {64,0},
    [I(231,6)] = {64,0},
    [I(232,6)] = {64,0},
    [I(233,6)] = {64,0},
    [I(234,6)] = {64,0},
    [I(235,6)] = {64,0},
    [I(236,6)] = {64,0},
    [I(237,6)] = {64,0},
    [I(238,6)] = {64,0},
    [I(239,6)] = {64,0},
    [I(240,6)] = {64,0},
    [I(241,6)] = {64,0},
    [I(242,6)] = {64,0},
    [I(243,6)] = {64,0},
    [I(244,6)] = {64,0},
    [I(245,6)] = {64,0},
    [I(246,6)] = {64,0},
    [I(247,6)] = {64,0},
    [I(248,6)] = {64,0},
    [I(249,6)] = {64,0},
    [I(250,6)] = {64,0},
    [I(251,6)] = {64,0},
    [I(252,6)] = {64,0},
    [I(253,6)] = {64,0},
    [I(254,6)] = {64,0},
    [I(255,6)] = {64,0},
    [I(0,7)] = {64,0},
    [I(1,7)] = {64,0},
    [I(2,7)] = {64,0},
    [I(3,7)] = {64,0},
    [I(4,7)] = {64,0},
    [I(5,7)] = {64,0},
    [I(6,7)] = {64,0},
    [I(7,7)] = {64,0},
    [I(8,7)] = {64,0},
    [I(9,7)] = {64,0},
    [I(10,7)] = {64,0},
    [I(11,7)] = {64,0},
    [I(12,7)] = {64,0},
    [I(13,7)] = {64,0},
    [I(14,7)] = {64,0},
    [I(15,7)] = {64,0},
    [I(16,7)] = {64,0},
    [I(17,7)] = {64,0},
    [I(18,7)] = {64,0},
    [I(19,7)] = {64,0},
    [I(20,7)] = {64,0},
    [I(21,7)] = {64,0},
    [I(22,7)] = {64,0},
    [I(23,7)] = {64,0},
    [I(24,7)] = {64,0},
    [I(25,7)] = {64,0},
    [I(26,7)] = {64,0},
    [I(27,7)] = {64,0},
    [I(28,7)] = {64,0},
    [I(29,7)] = {64,0},
    [I(30,7)] = {64,0},
    [I(31,7)] = {64,0},
    [I(32,7)] = {64,0},
    [I(33,7)] = {64,0},
    [I(34,7)] = {64,0},
    [I(35,7)] = {64,0},
    [I(36,7)] = {64,0},
    [I(37,7)] = {64,0},
    [I(38,7)] = {64,0},
    [I(39,7)] = {64,0},
    [I(40,7)] = {64,0},
    [I(41,7)] = {64,0},
    [I(42,7)] = {64,0},
    [I(43,7)] = {64,0},
    [I(44,7)] = {64,0},
    [I(45,7)] = {64,0},
    [I(46,7)] = {64,0},
    [I(47,7)] = {64,0},
    [I(48,7)] = {64,0},
    [I(49,7)] = {64,0},
    [I(50,7)] = {64,0},
    [I(51,7)] = {64,0},
    [I(52,7)] = {64,0},
    [I(53,7)] = {64,0},
    [I(54,7)] = {64,0},
    [I(55,7)] = {64,0},
    [I(56,7)] = {64,0},
    [I(57,7)] = {64,0},
    [I(58,7)] = {64,0},
    [I(59,7)] = {64,0},
    [I(60,7)] = {64,0},
    [I(61,7)] = {64,0},
    [I(62,7)] = {64,0},
    [I(63,7)] = {64,0},
    [I(64,7)] = {64,0},
    [I(65,7)] = {64,0},
    [I(66,7)] = {64,0},
    [I(67,7)] = {64,0},
    [I(68,7)] = {64,0},
    [I(69,7)] = {64,0},
    [I(70,7)] = {64,0},
    [I(71,7)] = {64,0},
    [I(72,7)] = {64,0},
    [I(73,7)] = {64,0},
    [I(74,7)] = {64,0},
    [I(75,7)] = {64,0},
    [I(76,7)] = {64,0},
    [I(77,7)] = {64,0},
    [I(78,7)] = {64,0},
    [I(79,7)] = {64,0},
    [I(80,7)] = {64,0},
    [I(81,7)] = {64,0},
    [I(82,7)] = {64,0},
    [I(83,7)] = {64,0},
    [I(84,7)] = {64,0},
    [I(85,7)] = {64,0},
    [I(86,7)] = {64,0},
    [I(87,7)] = {64,0},
    [I(88,7)] = {64,0},
    [I(89,7)] = {64,0},
    [I(90,7)] = {64,0},
    [I(91,7)] = {64,0},
    [I(92,7)] = {64,0},
    [I(93,7)] = {64,0},
    [I(94,7)] = {64,0},
    [I(95,7)] = {64,0},
    [I(96,7)] = {64,0},
    [I(97,7)] = {64,0},
    [I(98,7)] = {64,0},
    [I(99,7)] = {64,0},
    [I(100,7)] = {64,0},
    [I(101,7)] = {64,0},
    [I(102,7)] = {64,0},
    [I(103,7)] = {64,0},
    [I(104,7)] = {64,0},
    [I(105,7)] = {64,0},
    [I(106,7)] = {64,0},
    [I(107,7)] = {64,0},
    [I(108,7)] = {64,0},
    [I(109,7)] = {64,0},
    [I(110,7)] = {64,0},
    [I(111,7)] = {64,0},
    [I(112,7)] = {64,0},
    [I(113,7)] = {64,0},
    [I(114,7)] = {64,0},
    [I(115,7)] = {64,0},
    [I(116,7)] = {64,0},
    [I(117,7)] = {64,0},
    [I(118,7)] = {64,0},
    [I(119,7)] = {64,0},
    [I(120,7)] = {64,0},
    [I(121,7)] = {64,0},
    [I(122,7)] = {64,0},
    [I(123,7)] = {64,0},
    [I(124,7)] = {64,0},
    [I(125,7)] = {64,0},
    [I(126,7)] = {64,0},
    [I(127,7)] = {64,0},
    [I(128,7)] = {64,0},
    [I(129,7)] = {64,0},
    [I(130,7)] = {64,0},
    [I(131,7)] = {64,0},
    [I(132,7)] = {64,0},
    [I(133,7)] = {64,0},
    [I(134,7)] = {64,0},
    [I(135,7)] = {64,0},
    [I(136,7)] = {64,0},
    [I(137,7)] = {64,0},
    [I(138,7)] = {64,0},
    [I(139,7)] = {64,0},
    [I(140,7)] = {64,0},
    [I(141,7)] = {64,0},
    [I(142,7)] = {64,0},
    [I(143,7)] = {64,0},
    [I(144,7)] = {64,0},
    [I(145,7)] = {64,0},
    [I(146,7)] = {64,0},
    [I(147,7)] = {64,0},
    [I(148,7)] = {64,0},
    [I(149,7)] = {64,0},
    [I(150,7)] = {64,0},
    [I(151,7)] = {64,0},
    [I(152,7)] = {64,0},
    [I(153,7)] = {64,0},
    [I(154,7)] = {64,0},
    [I(155,7)] = {64,0},
    [I(156,7)] = {64,0},
    [I(157,7)] = {64,0},
    [I(158,7)] = {64,0},
    [I(159,7)] = {64,0},
    [I(160,7)] = {64,0},
    [I(161,7)] = {64,0},
    [I(162,7)] = {64,0},
    [I(163,7)] = {64,0},
    [I(164,7)] = {64,0},
    [I(165,7)] = {64,0},
    [I(166,7)] = {64,0},
    [I(167,7)] = {64,0},
    [I(168,7)] = {64,0},
    [I(169,7)] = {64,0},
    [I(170,7)] = {64,0},
    [I(171,7)] = {64,0},
    [I(172,7)] = {64,0},
    [I(173,7)] = {64,0},
    [I(174,7)] = {64,0},
    [I(175,7)] = {64,0},
    [I(176,7)] = {64,0},
    [I(177,7)] = {64,0},
    [I(178,7)] = {64,0},
    [I(179,7)] = {64,0},
    [I(180,7)] = {64,0},
    [I(181,7)] = {64,0},
    [I(182,7)] = {64,0},
    [I(183,7)] = {64,0},
    [I(184,7)] = {64,0},
    [I(185,7)] = {64,0},
    [I(186,7)] = {64,0},
    [I(187,7)] = {64,0},
    [I(188,7)] = {64,0},
    [I(189,7)] = {64,0},
    [I(190,7)] = {64,0},
    [I(191,7)] = {64,0},
    [I(192,7)] = {64,0},
    [I(193,7)] = {64,0},
    [I(194,7)] = {64,0},
    [I(195,7)] = {64,0},
    [I(196,7)] = {64,0},
    [I(197,7)] = {64,0},
    [I(198,7)] = {64,0},
    [I(199,7)] = {64,0},
    [I(200,7)] = {64,0},
    [I(201,7)] = {64,0},
    [I(202,7)] = {64,0},
    [I(203,7)] = {64,0},
    [I(204,7)] = {64,0},
    [I(205,7)] = {64,0},
    [I(206,7)] = {64,0},
    [I(207,7)] = {64,0},
    [I(208,7)] = {64,0},
    [I(209,7)] = {64,0},
    [I(210,7)] = {64,0},
    [I(211,7)] = {64,0},
    [I(212,7)] = {64,0},
    [I(213,7)] = {64,0},
    [I(214,7)] = {64,0},
    [I(215,7)] = {64,0},
    [I(216,7)] = {64,0},
    [I(217,7)] = {64,0},
    [I(218,7)] = {64,0},
    [I(219,7)] = {64,0},
    [I(220,7)] = {64,0},
    [I(221,7)] = {64,0},
    [I(222,7)] = {64,0},
    [I(223,7)] = {64,0},
    [I(224,7)] = {64,0},
    [I(225,7)] = {64,0},
    [I(226,7)] = {64,0},
    [I(227,7)] = {64,0},
    [I(228,7)] = {64,0},
    [I(229,7)] = {64,0},
    [I(230,7)] = {64,0},
    [I(231,7)] = {64,0},
    [I(232,7)] = {64,0},
    [I(233,7)] = {64,0},
    [I(234,7)] = {64,0},
    [I(235,7)] = {64,0},
    [I(236,7)] = {64,0},
    [I(237,7)] = {64,0},
    [I(238,7)] = {64,0},
    [I(239,7)] = {64,0},
    [I(240,7)] = {64,0},
    [I(241,7)] = {64,0},
    [I(242,7)] = {64,0},
    [I(243,7)] = {64,0},
    [I(244,7)] = {64,0},
    [I(245,7)] = {64,0},
    [I(246,7)] = {64,0},
    [I(247,7)] = {64,0},
    [I(248,7)] = {64,0},
    [I(249,7)] = {64,0},
    [I(250,7)] = {64,0},
    [I(251,7)] = {64,0},
    [I(252,7)] = {64,0},
    [I(253,7)] = {64,0},
    [I(254,7)] = {64,0},
    [I(255,7)] = {64,0},
    [I(0,8)] = {64,0},
    [I(1,8)] = {64,0},
    [I(2,8)] = {64,0},
    [I(3,8)] = {64,0},
    [I(4,8)] = {64,0},
    [I(5,8)] = {64,0},
    [I(6,8)] = {64,0},
    [I(7,8)] = {64,0},
    [I(8,8)] = {64,0},
    [I(9,8)] = {64,0},
    [I(10,8)] = {64,0},
    [I(11,8)] = {64,0},
    [I(12,8)] = {64,0},
    [I(13,8)] = {64,0},
    [I(14,8)] = {64,0},
    [I(15,8)] = {64,0},
    [I(16,8)] = {64,0},
    [I(17,8)] = {64,0},
    [I(18,8)] = {64,0},
    [I(19,8)] = {64,0},
    [I(20,8)] = {64,0},
    [I(21,8)] = {64,0},
    [I(22,8)] = {64,0},
    [I(23,8)] = {64,0},
    [I(24,8)] = {64,0},
    [I(25,8)] = {64,0},
    [I(26,8)] = {64,0},
    [I(27,8)] = {64,0},
    [I(28,8)] = {64,0},
    [I(29,8)] = {64,0},
    [I(30,8)] = {64,0},
    [I(31,8)] = {64,0},
    [I(32,8)] = {64,0},
    [I(33,8)] = {64,0},
    [I(34,8)] = {64,0},
    [I(35,8)] = {64,0},
    [I(36,8)] = {64,0},
    [I(37,8)] = {64,0},
    [I(38,8)] = {64,0},
    [I(39,8)] = {64,0},
    [I(40,8)] = {64,0},
    [I(41,8)] = {64,0},
    [I(42,8)] = {64,0},
    [I(43,8)] = {64,0},
    [I(44,8)] = {64,0},
    [I(45,8)] = {64,0},
    [I(46,8)] = {64,0},
    [I(47,8)] = {64,0},
    [I(48,8)] = {64,0},
    [I(49,8)] = {64,0},
    [I(50,8)] = {64,0},
    [I(51,8)] = {64,0},
    [I(52,8)] = {64,0},
    [I(53,8)] = {64,0},
    [I(54,8)] = {64,0},
    [I(55,8)] = {64,0},
    [I(56,8)] = {64,0},
    [I(57,8)] = {64,0},
    [I(58,8)] = {64,0},
    [I(59,8)] = {64,0},
    [I(60,8)] = {64,0},
    [I(61,8)] = {64,0},
    [I(62,8)] = {64,0},
    [I(63,8)] = {64,0},
    [I(64,8)] = {64,0},
    [I(65,8)] = {64,0},
    [I(66,8)] = {64,0},
    [I(67,8)] = {64,0},
    [I(68,8)] = {64,0},
    [I(69,8)] = {64,0},
    [I(70,8)] = {64,0},
    [I(71,8)] = {64,0},
    [I(72,8)] = {64,0},
    [I(73,8)] = {64,0},
    [I(74,8)] = {64,0},
    [I(75,8)] = {64,0},
    [I(76,8)] = {64,0},
    [I(77,8)] = {64,0},
    [I(78,8)] = {64,0},
    [I(79,8)] = {64,0},
    [I(80,8)] = {64,0},
    [I(81,8)] = {64,0},
    [I(82,8)] = {64,0},
    [I(83,8)] = {64,0},
    [I(84,8)] = {64,0},
    [I(85,8)] = {64,0},
    [I(86,8)] = {64,0},
    [I(87,8)] = {64,0},
    [I(88,8)] = {64,0},
    [I(89,8)] = {64,0},
    [I(90,8)] = {64,0},
    [I(91,8)] = {64,0},
    [I(92,8)] = {64,0},
    [I(93,8)] = {64,0},
    [I(94,8)] = {64,0},
    [I(95,8)] = {64,0},
    [I(96,8)] = {64,0},
    [I(97,8)] = {64,0},
    [I(98,8)] = {64,0},
    [I(99,8)] = {64,0},
    [I(100,8)] = {64,0},
    [I(101,8)] = {64,0},
    [I(102,8)] = {64,0},
    [I(103,8)] = {64,0},
    [I(104,8)] = {64,0},
    [I(105,8)] = {64,0},
    [I(106,8)] = {64,0},
    [I(107,8)] = {64,0},
    [I(108,8)] = {64,0},
    [I(109,8)] = {64,0},
    [I(110,8)] = {64,0},
    [I(111,8)] = {64,0},
    [I(112,8)] = {64,0},
    [I(113,8)] = {64,0},
    [I(114,8)] = {64,0},
    [I(115,8)] = {64,0},
    [I(116,8)] = {64,0},
    [I(117,8)] = {64,0},
    [I(118,8)] = {64,0},
    [I(119,8)] = {64,0},
    [I(120,8)] = {64,0},
    [I(121,8)] = {64,0},
    [I(122,8)] = {64,0},
    [I(123,8)] = {64,0},
    [I(124,8)] = {64,0},
    [I(125,8)] = {64,0},
    [I(126,8)] = {64,0},
    [I(127,8)] = {64,0},
    [I(128,8)] = {64,0},
    [I(129,8)] = {64,0},
    [I(130,8)] = {64,0},
    [I(131,8)] = {64,0},
    [I(132,8)] = {64,0},
    [I(133,8)] = {64,0},
    [I(134,8)] = {64,0},
    [I(135,8)] = {64,0},
    [I(136,8)] = {64,0},
    [I(137,8)] = {64,0},
    [I(138,8)] = {64,0},
    [I(139,8)] = {64,0},
    [I(140,8)] = {64,0},
    [I(141,8)] = {64,0},
    [I(142,8)] = {64,0},
    [I(143,8)] = {64,0},
    [I(144,8)] = {64,0},
    [I(145,8)] = {64,0},
    [I(146,8)] = {64,0},
    [I(147,8)] = {64,0},
    [I(148,8)] = {64,0},
    [I(149,8)] = {64,0},
    [I(150,8)] = {64,0},
    [I(151,8)] = {64,0},
    [I(152,8)] = {64,0},
    [I(153,8)] = {64,0},
    [I(154,8)] = {64,0},
    [I(155,8)] = {64,0},
    [I(156,8)] = {64,0},
    [I(157,8)] = {64,0},
    [I(158,8)] = {64,0},
    [I(159,8)] = {64,0},
    [I(160,8)] = {64,0},
    [I(161,8)] = {64,0},
    [I(162,8)] = {64,0},
    [I(163,8)] = {64,0},
    [I(164,8)] = {64,0},
    [I(165,8)] = {64,0},
    [I(166,8)] = {64,0},
    [I(167,8)] = {64,0},
    [I(168,8)] = {64,0},
    [I(169,8)] = {64,0},
    [I(170,8)] = {64,0},
    [I(171,8)] = {64,0},
    [I(172,8)] = {64,0},
    [I(173,8)] = {64,0},
    [I(174,8)] = {64,0},
    [I(175,8)] = {64,0},
    [I(176,8)] = {64,0},
    [I(177,8)] = {64,0},
    [I(178,8)] = {64,0},
    [I(179,8)] = {64,0},
    [I(180,8)] = {64,0},
    [I(181,8)] = {64,0},
    [I(182,8)] = {64,0},
    [I(183,8)] = {64,0},
    [I(184,8)] = {64,0},
    [I(185,8)] = {64,0},
    [I(186,8)] = {64,0},
    [I(187,8)] = {64,0},
    [I(188,8)] = {64,0},
    [I(189,8)] = {64,0},
    [I(190,8)] = {64,0},
    [I(191,8)] = {64,0},
    [I(192,8)] = {64,0},
    [I(193,8)] = {64,0},
    [I(194,8)] = {64,0},
    [I(195,8)] = {64,0},
    [I(196,8)] = {64,0},
    [I(197,8)] = {64,0},
    [I(198,8)] = {64,0},
    [I(199,8)] = {64,0},
    [I(200,8)] = {64,0},
    [I(201,8)] = {64,0},
    [I(202,8)] = {64,0},
    [I(203,8)] = {64,0},
    [I(204,8)] = {64,0},
    [I(205,8)] = {64,0},
    [I(206,8)] = {64,0},
    [I(207,8)] = {64,0},
    [I(208,8)] = {64,0},
    [I(209,8)] = {64,0},
    [I(210,8)] = {64,0},
    [I(211,8)] = {64,0},
    [I(212,8)] = {64,0},
    [I(213,8)] = {64,0},
    [I(214,8)] = {64,0},
    [I(215,8)] = {64,0},
    [I(216,8)] = {64,0},
    [I(217,8)] = {64,0},
    [I(218,8)] = {64,0},
    [I(219,8)] = {64,0},
    [I(220,8)] = {64,0},
    [I(221,8)] = {64,0},
    [I(222,8)] = {64,0},
    [I(223,8)] = {64,0},
    [I(224,8)] = {64,0},
    [I(225,8)] = {64,0},
    [I(226,8)] = {64,0},
    [I(227,8)] = {64,0},
    [I(228,8)] = {64,0},
    [I(229,8)] = {64,0},
    [I(230,8)] = {64,0},
    [I(231,8)] = {64,0},
    [I(232,8)] = {64,0},
    [I(233,8)] = {64,0},
    [I(234,8)] = {64,0},
    [I(235,8)] = {64,0},
    [I(236,8)] = {64,0},
    [I(237,8)] = {64,0},
    [I(238,8)] = {64,0},
    [I(239,8)] = {64,0},
    [I(240,8)] = {64,0},
    [I(241,8)] = {64,0},
    [I(242,8)] = {64,0},
    [I(243,8)] = {64,0},
    [I(244,8)] = {64,0},
    [I(245,8)] = {64,0},
    [I(246,8)] = {64,0},
    [I(247,8)] = {64,0},
    [I(248,8)] = {64,0},
    [I(249,8)] = {64,0},
    [I(250,8)] = {64,0},
    [I(251,8)] = {64,0},
    [I(252,8)] = {64,0},
    [I(253,8)] = {64,0},
    [I(254,8)] = {64,0},
    [I(255,8)] = {64,0},
    [I(0,9)] = {64,0},
    [I(1,9)] = {64,0},
    [I(2,9)] = {64,0},
    [I(3,9)] = {64,0},
    [I(4,9)] = {64,0},
    [I(5,9)] = {64,0},
    [I(6,9)] = {64,0},
    [I(7,9)] = {64,0},
    [I(8,9)] = {64,0},
    [I(9,9)] = {64,0},
    [I(10,9)] = {64,0},
    [I(11,9)] = {64,0},
    [I(12,9)] = {64,0},
    [I(13,9)] = {64,0},
    [I(14,9)] = {64,0},
    [I(15,9)] = {64,0},
    [I(16,9)] = {64,0},
    [I(17,9)] = {64,0},
    [I(18,9)] = {64,0},
    [I(19,9)] = {64,0},
    [I(20,9)] = {64,0},
    [I(21,9)] = {64,0},
    [I(22,9)] = {64,0},
    [I(23,9)] = {64,0},
    [I(24,9)] = {64,0},
    [I(25,9)] = {64,0},
    [I(26,9)] = {64,0},
    [I(27,9)] = {64,0},
    [I(28,9)] = {64,0},
    [I(29,9)] = {64,0},
    [I(30,9)] = {64,0},
    [I(31,9)] = {64,0},
    [I(32,9)] = {30,0x14FFFFEA},
    [I(33,9)] = {64,0},
    [I(34,9)] = {64,0},
    [I(35,9)] = {64,0},
    [I(36,9)] = {64,0},
    [I(37,9)] = {30,0x15FFFFEA},
    [I(38,9)] = {X32,0xF8FFFFEA},
    [I(39,9)] = {64,0},
    [I(40,9)] = {64,0},
    [I(41,9)] = {64,0},
    [I(42,9)] = {X32,0xF9FFFFEA},
    [I(43,9)] = {64,0},
    [I(44,9)] = {X32,0xFAFFFFEA},
    [I(45,9)] = {30,0x16FFFFEA},
    [I(46,9)] = {30,0x17FFFFEA},
    [I(47,9)] = {30,0x18FFFFEA},
    [I(48,9)] = {29,0xFFFFEA},
    [I(49,9)] = {29,0x1FFFFEA},
    [I(50,9)] = {29,0x2FFFFEA},
    [I(51,9)] = {30,0x19FFFFEA},
    [I(52,9)] = {30,0x1AFFFFEA},
    [I(53,9)] = {30,0x1BFFFFEA},
    [I(54,9)] = {30,0x1CFFFFEA},
    [I(55,9)] = {30,0x1DFFFFEA},
    [I(56,9)] = {30,0x1EFFFFEA},
    [I(57,9)] = {30,0x1FFFFFEA},
    [I(58,9)] = {31,0x5CFFFFEA},
    [I(59,9)] = {X32,0xFBFFFFEA},
    [I(60,9)] = {64,0},
    [I(61,9)] = {30,0x20FFFFEA},
    [I(62,9)] = {64,0},
    [I(63,9)] = {64,0},
    [I(64,9)] = {64,0},
    [I(65,9)] = {30,0x21FFFFEA},
    [I(66,9)] = {31,0x5DFFFFEA},
    [I(67,9)] = {31,0x5EFFFFEA},
    [I(68,9)] = {31,0x5FFFFFEA},
    [I(69,9)] = {31,0x60FFFFEA},
    [I(70,9)] = {31,0x61FFFFEA},
    [I(71,9)] = {31,0x62FFFFEA},
    [I(72,9)] = {31,0x63FFFFEA},
    [I(73,9)] = {31,0x64FFFFEA},
    [I(74,9)] = {31,0x65FFFFEA},
    [I(75,9)] = {31,0x66FFFFEA},
    [I(76,9)] = {31,0x67FFFFEA},
    [I(77,9)] = {31,0x68FFFFEA},
    [I(78,9)] = {31,0x69FFFFEA},
    [I(79,9)] = {31,0x6AFFFFEA},
    [I(80,9)] = {31,0x6BFFFFEA},
    [I(81,9)] = {31,0x6CFFFFEA},
    [I(82,9)] = {31,0x6DFFFFEA},
    [I(83,9)] = {31,0x6EFFFFEA},
    [I(84,9)] = {31,0x6FFFFFEA},
    [I(85,9)] = {31,0x70FFFFEA},
    [I(86,9)] = {31,0x71FFFFEA},
    [I(87,9)] = {31,0x72FFFFEA},
    [I(88,9)] = {X32,0xFCFFFFEA},
    [I(89,9)] = {31,0x73FFFFEA},
    [I(90,9)] = {X32,0xFDFFFFEA},
    [I(91,9)] = {64,0},
    [I(92,9)] = {64,0},
    [I(93,9)] = {64,0},
    [I(94,9)] = {64,0},
    [I(95,9)] = {30,0x22FFFFEA},
    [I(96,9)] = {64,0},
    [I(97,9)] = {29,0x3FFFFEA},
    [I(98,9)] = {30,0x23FFFFEA},
    [I(99,9)] = {29,0x4FFFFEA},
    [I(100,9)] = {30,0x24FFFFEA},
    [I(101,9)] = {29,0x5FFFFEA},
    [I(102,9)] = {30,0x25FFFFEA},
    [I(103,9)] = {30,0x26FFFFEA},
    [I(104,9)] = {30,0x27FFFFEA},
    [I(105,9)] = {29,0x6FFFFEA},
    [I(106,9)] = {31,0x74FFFFEA},
    [I(107,9)] = {31,0x75FFFFEA},
    [I(108,9)] = {30,0x28FFFFEA},
    [I(109,9)] = {30,0x29FFFFEA},
    [I(110,9)] = {30,0x2AFFFFEA},
    [I(111,9)] = {29,0x7FFFFEA},
    [I(112,9)] = {30,0x2BFFFFEA},
    [I(113,9)] = {31,0x76FFFFEA},
    [I(114,9)] = {30,0x2CFFFFEA},
    [I(115,9)] = {29,0x8FFFFEA},
    [I(116,9)] = {29,0x9FFFFEA},
    [I(117,9)] = {30,0x2DFFFFEA},
    [I(118,9)] = {31,0x77FFFFEA},
    [I(119,9)] = {31,0x78FFFFEA},
    [I(120,9)] = {31,0x79FFFFEA},
    [I(121,9)] = {31,0x7AFFFFEA},
    [I(122,9)] = {31,0x7BFFFFEA},
    [I(123,9)] = {64,0},
    [I(124,9)] = {64,0},
    [I(125,9)] = {64,0},
    [I(126,9)] = {64,0},
    [I(127,9)] = {64,0},
    [I(128,9)] = {64,0},
    [I(129,9)] = {64,0},
    [I(130,9)] = {64,0},
    [I(131,9)] = {64,0},
    [I(132,9)] = {64,0},
    [I(133,9)] = {64,0},
    [I(134,9)] = {64,0},
    [I(135,9)] = {64,0},
    [I(136,9)] = {64,0},
    [I(137,9)] = {64,0},
    [I(138,9)] = {64,0},
    [I(139,9)] = {64,0},
    [I(140,9)] = {64,0},
    [I(141,9)] = {64,0},
    [I(142,9)] = {64,0},
    [I(143,9)] = {64,0},
    [I(144,9)] = {64,0},
    [I(145,9)] = {64,0},
    [I(146,9)] = {64,0},
    [I(147,9)] = {64,0},
    [I(148,9)] = {64,0},
    [I(149,9)] = {64,0},
    [I(150,9)] = {64,0},
    [I(151,9)] = {64,0},
    [I(152,9)] = {64,0},
    [I(153,9)] = {64,0},
    [I(154,9)] = {64,0},
    [I(155,9)] = {64,0},
    [I(156,9)] = {64,0},
    [I(157,9)] = {64,0},
    [I(158,9)] = {64,0},
    [I(159,9)] = {64,0},
    [I(160,9)] = {64,0},
    [I(161,9)] = {64,0},
    [I(162,9)] = {64,0},
    [I(163,9)] = {64,0},
    [I(164,9)] = {64,0},
    [I(165,9)] = {64,0},
    [I(166,9)] = {64,0},
    [I(167,9)] = {64,0},
    [I(168,9)] = {64,0},
    [I(169,9)] = {64,0},
    [I(170,9)] = {64,0},
    [I(171,9)] = {64,0},
    [I(172,9)] = {64,0},
    [I(173,9)] = {64,0},
    [I(174,9)] = {64,0},
    [I(175,9)] = {64,0},
    [I(176,9)] = {64,0},
    [I(177,9)] = {64,0},
    [I(178,9)] = {64,0},
    [I(179,9)] = {64,0},
    [I(180,9)] = {64,0},
    [I(181,9)] = {64,0},
    [I(182,9)] = {64,0},
    [I(183,9)] = {64,0},
    [I(184,9)] = {64,0},
    [I(185,9)] = {64,0},
    [I(186,9)] = {64,0},
    [I(187,9)] = {64,0},
    [I(188,9)] = {64,0},
    [I(189,9)] = {64,0},
    [I(190,9)] = {64,0},
    [I(191,9)] = {64,0},
    [I(192,9)] = {64,0},
    [I(193,9)] = {64,0},
    [I(194,9)] = {64,0},
    [I(195,9)] = {64,0},
    [I(196,9)] = {64,0},
    [I(197,9)] = {64,0},
    [I(198,9)] = {64,0},
    [I(199,9)] = {64,0},
    [I(200,9)] = {64,0},
    [I(201,9)] = {64,0},
    [I(202,9)] = {64,0},
    [I(203,9)] = {64,0},
    [I(204,9)] = {64,0},
    [I(205,9)] = {64,0},
    [I(206,9)] = {64,0},
    [I(207,9)] = {64,0},
    [I(208,9)] = {64,0},
    [I(209,9)] = {64,0},
    [I(210,9)] = {64,0},
    [I(211,9)] = {64,0},
    [I(212,9)] = {64,0},
    [I(213,9)] = {64,0},
    [I(214,9)] = {64,0},
    [I(215,9)] = {64,0},
    [I(216,9)] = {64,0},
    [I(217,9)] = {64,0},
    [I(218,9)] = {64,0},
    [I(219,9)] = {64,0},
    [I(220,9)] = {64,0},
    [I(221,9)] = {64,0},
    [I(222,9)] = {64,0},
    [I(223,9)] = {64,0},
    [I(224,9)] = {64,0},
    [I(225,9)] = {64,0},
    [I(226,9)] = {64,0},
    [I(227,9)] = {64,0},
    [I(228,9)] = {64,0},
    [I(229,9)] = {64,0},
    [I(230,9)] = {64,0},
    [I(231,9)] = {64,0},
    [I(232,9)] = {64,0},
    [I(233,9)] = {64,0},
    [I(234,9)] = {64,0},
    [I(235,9)] = {64,0},
    [I(236,9)] = {64,0},
    [I(237,9)] = {64,0},
    [I(238,9)] = {64,0},
    [I(239,9)] = {64,0},
    [I(240,9)] = {64,0},
    [I(241,9)] = {64,0},
    [I(242,9)] = {64,0},
    [I(243,9)] = {64,0},
    [I(244,9)] = {64,0},
    [I(245,9)] = {64,0},
    [I(246,9)] = {64,0},
    [I(247,9)] = {64,0},
    [I(248,9)] = {64,0},
    [I(249,9)] = {64,0},
    [I(250,9)] = {64,0},
    [I(251,9)] = {64,0},
    [I(252,9)] = {64,0},
    [I(253,9)] = {64,0},
    [I(254,9)] = {64,0},
    [I(255,9)] = {64,0},
    [I(0,10)] = {64,0},
    [I(1,10)] = {64,0},
    [I(2,10)] = {64,0},
    [I(3,10)] = {64,0},
    [I(4,10)] = {64,0},
    [I(5,10)] = {64,0},
    [I(6,10)] = {64,0},
    [I(7,10)] = {64,0},
    [I(8,10)] = {64,0},
    [I(9,10)] = {64,0},
    [I(10,10)] = {64,0},
    [I(11,10)] = {64,0},
    [I(12,10)] = {64,0},
    [I(13,10)] = {64,0},
    [I(14,10)] = {64,0},
    [I(15,10)] = {64,0},
    [I(16,10)] = {64,0},
    [I(17,10)] = {64,0},
    [I(18,10)] = {64,0},
    [I(19,10)] = {64,0},
    [I(20,10)] = {64,0},
    [I(21,10)] = {64,0},
    [I(22,10)] = {64,0},
    [I(23,10)] = {64,0},
    [I(24,10)] = {64,0},
    [I(25,10)] = {64,0},
    [I(26,10)] = {64,0},
    [I(27,10)] = {64,0},
    [I(28,10)] = {64,0},
    [I(29,10)] = {64,0},
    [I(30,10)] = {64,0},
    [I(31,10)] = {64,0},
    [I(32,10)] = {64,0},
    [I(33,10)] = {64,0},
    [I(34,10)] = {64,0},
    [I(35,10)] = {64,0},
    [I(36,10)] = {64,0},
    [I(37,10)] = {64,0},
    [I(38,10)] = {64,0},
    [I(39,10)] = {64,0},
    [I(40,10)] = {64,0},
    [I(41,10)] = {64,0},
    [I(42,10)] = {64,0},
    [I(43,10)] = {64,0},
    [I(44,10)] = {64,0},
    [I(45,10)] = {64,0},
    [I(46,10)] = {64,0},
    [I(47,10)] = {64,0},
    [I(48,10)] = {64,0},
    [I(49,10)] = {64,0},
    [I(50,10)] = {64,0},
    [I(51,10)] = {64,0},
    [I(52,10)] = {64,0},
    [I(53,10)] = {64,0},
    [I(54,10)] = {64,0},
    [I(55,10)] = {64,0},
    [I(56,10)] = {64,0},
    [I(57,10)] = {64,0},
    [I(58,10)] = {64,0},
    [I(59,10)] = {64,0},
    [I(60,10)] = {64,0},
    [I(61,10)] = {64,0},
    [I(62,10)] = {64,0},
    [I(63,10)] = {64,0},
    [I(64,10)] = {64,0},
    [I(65,10)] = {64,0},
    [I(66,10)] = {64,0},
    [I(67,10)] = {64,0},
    [I(68,10)] = {64,0},
    [I(69,10)] = {64,0},
    [I(70,10)] = {64,0},
    [I(71,10)] = {64,0},
    [I(72,10)] = {64,0},
    [I(73,10)] = {64,0},
    [I(74,10)] = {64,0},
    [I(75,10)] = {64,0},
    [I(76,10)] = {64,0},
    [I(77,10)] = {64,0},
    [I(78,10)] = {64,0},
    [I(79,10)] = {64,0},
    [I(80,10)] = {64,0},
    [I(81,10)] = {64,0},
    [I(82,10)] = {64,0},
    [I(83,10)] = {64,0},
    [I(84,10)] = {64,0},
    [I(85,10)] = {64,0},
    [I(86,10)] = {64,0},
    [I(87,10)] = {64,0},
    [I(88,10)] = {64,0},
    [I(89,10)] = {64,0},
    [I(90,10)] = {64,0},
    [I(91,10)] = {64,0},
    [I(92,10)] = {64,0},
    [I(93,10)] = {64,0},
    [I(94,10)] = {64,0},
    [I(95,10)] = {64,0},
    [I(96,10)] = {64,0},
    [I(97,10)] = {64,0},
    [I(98,10)] = {64,0},
    [I(99,10)] = {64,0},
    [I(100,10)] = {64,0},
    [I(101,10)] = {64,0},
    [I(102,10)] = {64,0},
    [I(103,10)] = {64,0},
    [I(104,10)] = {64,0},
    [I(105,10)] = {64,0},
    [I(106,10)] = {64,0},
    [I(107,10)] = {64,0},
    [I(108,10)] = {64,0},
    [I(109,10)] = {64,0},
    [I(110,10)] = {64,0},
    [I(111,10)] = {64,0},
    [I(112,10)] = {64,0},
    [I(113,10)] = {64,0},
    [I(114,10)] = {64,0},
    [I(115,10)] = {64,0},
    [I(116,10)] = {64,0},
    [I(117,10)] = {64,0},
    [I(118,10)] = {64,0},
    [I(119,10)] = {64,0},
    [I(120,10)] = {64,0},
    [I(121,10)] = {64,0},
    [I(122,10)] = {64,0},
    [I(123,10)] = {64,0},
    [I(124,10)] = {64,0},
    [I(125,10)] = {64,0},
    [I(126,10)] = {64,0},
    [I(127,10)] = {64,0},
    [I(128,10)] = {64,0},
    [I(129,10)] = {64,0},
    [I(130,10)] = {64,0},
    [I(131,10)] = {64,0},
    [I(132,10)] = {64,0},
    [I(133,10)] = {64,0},
    [I(134,10)] = {64,0},
    [I(135,10)] = {64,0},
    [I(136,10)] = {64,0},
    [I(137,10)] = {64,0},
    [I(138,10)] = {64,0},
    [I(139,10)] = {64,0},
    [I(140,10)] = {64,0},
    [I(141,10)] = {64,0},
    [I(142,10)] = {64,0},
    [I(143,10)] = {64,0},
    [I(144,10)] = {64,0},
    [I(145,10)] = {64,0},
    [I(146,10)] = {64,0},
    [I(147,10)] = {64,0},
    [I(148,10)] = {64,0},
    [I(149,10)] = {64,0},
    [I(150,10)] = {64,0},
    [I(151,10)] = {64,0},
    [I(152,10)] = {64,0},
    [I(153,10)] = {64,0},
    [I(154,10)] = {64,0},
    [I(155,10)] = {64,0},
    [I(156,10)] = {64,0},
    [I(157,10)] = {64,0},
    [I(158,10)] = {64,0},
    [I(159,10)] = {64,0},
    [I(160,10)] = {64,0},
    [I(161,10)] = {64,0},
    [I(162,10)] = {64,0},
    [I(163,10)] = {64,0},
    [I(164,10)] = {64,0},
    [I(165,10)] = {64,0},
    [I(166,10)] = {64,0},
    [I(167,10)] = {64,0},
    [I(168,10)] = {64,0},
    [I(169,10)] = {64,0},
    [I(170,10)] = {64,0},
    [I(171,10)] = {64,0},
    [I(172,10)] = {64,0},
    [I(173,10)] = {64,0},
    [I(174,10)] = {64,0},
    [I(175,10)] = {64,0},
    [I(176,10)] = {64,0},
    [I(177,10)] = {64,0},
    [I(178,10)] = {64,0},
    [I(179,10)] = {64,0},
    [I(180,10)] = {64,0},
    [I(181,10)] = {64,0},
    [I(182,10)] = {64,0},
    [I(183,10)] = {64,0},
    [I(184,10)] = {64,0},
    [I(185,10)] = {64,0},
    [I(186,10)] = {64,0},
    [I(187,10)] = {64,0},
    [I(188,10)] = {64,0},
    [I(189,10)] = {64,0},
    [I(190,10)] = {64,0},
    [I(191,10)] = {64,0},
    [I(192,10)] = {64,0},
    [I(193,10)] = {64,0},
    [I(194,10)] = {64,0},
    [I(195,10)] = {64,0},
    [I(196,10)] = {64,0},
    [I(197,10)] = {64,0},
    [I(198,10)] = {64,0},
    [I(199,10)] = {64,0},
    [I(200,10)] = {64,0},
    [I(201,10)] = {64,0},
    [I(202,10)] = {64,0},
    [I(203,10)] = {64,0},
    [I(204,10)] = {64,0},
    [I(205,10)] = {64,0},
    [I(206,10)] = {64,0},
    [I(207,10)] = {64,0},
    [I(208,10)] = {64,0},
    [I(209,10)] = {64,0},
    [I(210,10)] = {64,0},
    [I(211,10)] = {64,0},
    [I(212,10)] = {64,0},
    [I(213,10)] = {64,0},
    [I(214,10)] = {64,0},
    [I(215,10)] = {64,0},
    [I(216,10)] = {64,0},
    [I(217,10)] = {64,0},
    [I(218,10)] = {64,0},
    [I(219,10)] = {64,0},
    [I(220,10)] = {64,0},
    [I(221,10)] = {64,0},
    [I(222,10)] = {64,0},
    [I(223,10)] = {64,0},
    [I(224,10)] = {64,0},
    [I(225,10)] = {64,0},
    [I(226,10)] = {64,0},
    [I(227,10)] = {64,0},
    [I(228,10)] = {64,0},
    [I(229,10)] = {64,0},
    [I(230,10)] = {64,0},
    [I(231,10)] = {64,0},
    [I(232,10)] = {64,0},
    [I(233,10)] = {64,0},
    [I(234,10)] = {64,0},
    [I(235,10)] = {64,0},
    [I(236,10)] = {64,0},
    [I(237,10)] = {64,0},
    [I(238,10)] = {64,0},
    [I(239,10)] = {64,0},
    [I(240,10)] = {64,0},
    [I(241,10)] = {64,0},
    [I(242,10)] = {64,0},
    [I(243,10)] = {64,0},
    [I(244,10)] = {64,0},
    [I(245,10)] = {64,0},
    [I(246,10)] = {64,0},
    [I(247,10)] = {64,0},
    [I(248,10)] = {64,0},
    [I(249,10)] = {64,0},
    [I(250,10)] = {64,0},
    [I(251,10)] = {64,0},
    [I(252,10)] = {64,0},
    [I(253,10)] = {64,0},
    [I(254,10)] = {64,0},
    [I(255,10)] = {64,0},
    [I(0,11)] = {64,0},
    [I(1,11)] = {64,0},
    [I(2,11)] = {64,0},
    [I(3,11)] = {64,0},
    [I(4,11)] = {64,0},
    [I(5,11)] = {64,0},
    [I(6,11)] = {64,0},
    [I(7,11)] = {64,0},
    [I(8,11)] = {64,0},
    [I(9,11)] = {64,0},
    [I(10,11)] = {64,0},
    [I(11,11)] = {64,0},
    [I(12,11)] = {64,0},
    [I(13,11)] = {64,0},
    [I(14,11)] = {64,0},
    [I(15,11)] = {64,0},
    [I(16,11)] = {64,0},
    [I(17,11)] = {64,0},
    [I(18,11)] = {64,0},
    [I(19,11)] = {64,0},
    [I(20,11)] = {64,0},
    [I(21,11)] = {64,0},
    [I(22,11)] = {64,0},
    [I(23,11)] = {64,0},
    [I(24,11)] = {64,0},
    [I(25,11)] = {64,0},
    [I(26,11)] = {64,0},
    [I(27,11)] = {64,0},
    [I(28,11)] = {64,0},
    [I(29,11)] = {64,0},
    [I(30,11)] = {64,0},
    [I(31,11)] = {64,0},
    [I(32,11)] = {64,0},
    [I(33,11)] = {64,0},
    [I(34,11)] = {64,0},
    [I(35,11)] = {64,0},
    [I(36,11)] = {64,0},
    [I(37,11)] = {64,0},
    [I(38,11)] = {64,0},
    [I(39,11)] = {64,0},
    [I(40,11)] = {64,0},
    [I(41,11)] = {64,0},
    [I(42,11)] = {64,0},
    [I(43,11)] = {64,0},
    [I(44,11)] = {64,0},
    [I(45,11)] = {64,0},
    [I(46,11)] = {64,0},
    [I(47,11)] = {64,0},
    [I(48,11)] = {64,0},
    [I(49,11)] = {64,0},
    [I(50,11)] = {64,0},
    [I(51,11)] = {64,0},
    [I(52,11)] = {64,0},
    [I(53,11)] = {64,0},
    [I(54,11)] = {64,0},
    [I(55,11)] = {64,0},
    [I(56,11)] = {64,0},
    [I(57,11)] = {64,0},
    [I(58,11)] = {64,0},
    [I(59,11)] = {64,0},
    [I(60,11)] = {64,0},
    [I(61,11)] = {64,0},
    [I(62,11)] = {64,0},
    [I(63,11)] = {64,0},
    [I(64,11)] = {64,0},
    [I(65,11)] = {64,0},
    [I(66,11)] = {64,0},
    [I(67,11)] = {64,0},
    [I(68,11)] = {64,0},
    [I(69,11)] = {64,0},
    [I(70,11)] = {64,0},
    [I(71,11)] = {64,0},
    [I(72,11)] = {64,0},
    [I(73,11)] = {64,0},
    [I(74,11)] = {64,0},
    [I(75,11)] = {64,0},
    [I(76,11)] = {64,0},
    [I(77,11)] = {64,0},
    [I(78,11)] = {64,0},
    [I(79,11)] = {64,0},
    [I(80,11)] = {64,0},
    [I(81,11)] = {64,0},
    [I(82,11)] = {64,0},
    [I(83,11)] = {64,0},
    [I(84,11)] = {64,0},
    [I(85,11)] = {64,0},
    [I(86,11)] = {64,0},
    [I(87,11)] = {64,0},
    [I(88,11)] = {64,0},
    [I(89,11)] = {64,0},
    [I(90,11)] = {64,0},
    [I(91,11)] = {64,0},
    [I(92,11)] = {64,0},
    [I(93,11)] = {64,0},
    [I(94,11)] = {64,0},
    [I(95,11)] = {64,0},
    [I(96,11)] = {64,0},
    [I(97,11)] = {64,0},
    [I(98,11)] = {64,0},
    [I(99,11)] = {64,0},
    [I(100,11)] = {64,0},
    [I(101,11)] = {64,0},
    [I(102,11)] = {64,0},
    [I(103,11)] = {64,0},
    [I(104,11)] = {64,0},
    [I(105,11)] = {64,0},
    [I(106,11)] = {64,0},
    [I(107,11)] = {64,0},
    [I(108,11)] = {64,0},
    [I(109,11)] = {64,0},
    [I(110,11)] = {64,0},
    [I(111,11)] = {64,0},
    [I(112,11)] = {64,0},
    [I(113,11)] = {64,0},
    [I(114,11)] = {64,0},
    [I(115,11)] = {64,0},
    [I(116,11)] = {64,0},
    [I(117,11)] = {64,0},
    [I(118,11)] = {64,0},
    [I(119,11)] = {64,0},
    [I(120,11)] = {64,0},
    [I(121,11)] = {64,0},
    [I(122,11)] = {64,0},
    [I(123,11)] = {64,0},
    [I(124,11)] = {64,0},
    [I(125,11)] = {64,0},
    [I(126,11)] = {64,0},
    [I(127,11)] = {64,0},
    [I(128,11)] = {64,0},
    [I(129,11)] = {64,0},
    [I(130,11)] = {64,0},
    [I(131,11)] = {64,0},
    [I(132,11)] = {64,0},
    [I(133,11)] = {64,0},
    [I(134,11)] = {64,0},
    [I(135,11)] = {64,0},
    [I(136,11)] = {64,0},
    [I(137,11)] = {64,0},
    [I(138,11)] = {64,0},
    [I(139,11)] = {64,0},
    [I(140,11)] = {64,0},
    [I(141,11)] = {64,0},
    [I(142,11)] = {64,0},
    [I(143,11)] = {64,0},
    [I(144,11)] = {64,0},
    [I(145,11)] = {64,0},
    [I(146,11)] = {64,0},
    [I(147,11)] = {64,0},
    [I(148,11)] = {64,0},
    [I(149,11)] = {64,0},
    [I(150,11)] = {64,0},
    [I(151,11)] = {64,0},
    [I(152,11)] = {64,0},
    [I(153,11)] = {64,0},
    [I(154,11)] = {64,0},
    [I(155,11)] = {64,0},
    [I(156,11)] = {64,0},
    [I(157,11)] = {64,0},
    [I(158,11)] = {64,0},
    [I(159,11)] = {64,0},
    [I(160,11)] = {64,0},
    [I(161,11)] = {64,0},
    [I(162,11)] = {64,0},
    [I(163,11)] = {64,0},
    [I(164,11)] = {64,0},
    [I(165,11)] = {64,0},
    [I(166,11)] = {64,0},
    [I(167,11)] = {64,0},
    [I(168,11)] = {64,0},
    [I(169,11)] = {64,0},
    [I(170,11)] = {64,0},
    [I(171,11)] = {64,0},
    [I(172,11)] = {64,0},
    [I(173,11)] = {64,0},
    [I(174,11)] = {64,0},
    [I(175,11)] = {64,0},
    [I(176,11)] = {64,0},
    [I(177,11)] = {64,0},
    [I(178,11)] = {64,0},
    [I(179,11)] = {64,0},
    [I(180,11)] = {64,0},
    [I(181,11)] = {64,0},
    [I(182,11)] = {64,0},
    [I(183,11)] = {64,0},
    [I(184,11)] = {64,0},
    [I(185,11)] = {64,0},
    [I(186,11)] = {64,0},
    [I(187,11)] = {64,0},
    [I(188,11)] = {64,0},
    [I(189,11)] = {64,0},
    [I(190,11)] = {64,0},
    [I(191,11)] = {64,0},
    [I(192,11)] = {64,0},
    [I(193,11)] = {64,0},
    [I(194,11)] = {64,0},
    [I(195,11)] = {64,0},
    [I(196,11)] = {64,0},
    [I(197,11)] = {64,0},
    [I(198,11)] = {64,0},
    [I(199,11)] = {64,0},
    [I(200,11)] = {64,0},
    [I(201,11)] = {64,0},
    [I(202,11)] = {64,0},
    [I(203,11)] = {64,0},
    [I(204,11)] = {64,0},
    [I(205,11)] = {64,0},
    [I(206,11)] = {64,0},
    [I(207,11)] = {64,0},
    [I(208,11)] = {64,0},
    [I(209,11)] = {64,0},
    [I(210,11)] = {64,0},
    [I(211,11)] = {64,0},
    [I(212,11)] = {64,0},
    [I(213,11)] = {64,0},
    [I(214,11)] = {64,0},
    [I(215,11)] = {64,0},
    [I(216,11)] = {64,0},
    [I(217,11)] = {64,0},
    [I(218,11)] = {64,0},
    [I(219,11)] = {64,0},
    [I(220,11)] = {64,0},
    [I(221,11)] = {64,0},
    [I(222,11)] = {64,0},
    [I(223,11)] = {64,0},
    [I(224,11)] = {64,0},
    [I(225,11)] = {64,0},
    [I(226,11)] = {64,0},
    [I(227,11)] = {64,0},
    [I(228,11)] = {64,0},
    [I(229,11)] = {64,0},
    [I(230,11)] = {64,0},
    [I(231,11)] = {64,0},
    [I(232,11)] = {64,0},
    [I(233,11)] = {64,0},
    [I(234,11)] = {64,0},
    [I(235,11)] = {64,0},
    [I(236,11)] = {64,0},
    [I(237,11)] = {64,0},
    [I(238,11)] = {64,0},
    [I(239,11)] = {64,0},
    [I(240,11)] = {64,0},
    [I(241,11)] = {64,0},
    [I(242,11)] = {64,0},
    [I(243,11)] = {64,0},
    [I(244,11)] = {64,0},
    [I(245,11)] = {64,0},
    [I(246,11)] = {64,0},
    [I(247,11)] = {64,0},
    [I(248,11)] = {64,0},
    [I(249,11)] = {64,0},
    [I(250,11)] = {64,0},
    [I(251,11)] = {64,0},
    [I(252,11)] = {64,0},
    [I(253,11)] = {64,0},
    [I(254,11)] = {64,0},
    [I(255,11)] = {64,0},
    [I(0,12)] = {64,0},
    [I(1,12)] = {64,0},
    [I(2,12)] = {64,0},
    [I(3,12)] = {64,0},
    [I(4,12)] = {64,0},
    [I(5,12)] = {64,0},
    [I(6,12)] = {64,0},
    [I(7,12)] = {64,0},
    [I(8,12)] = {64,0},
    [I(9,12)] = {64,0},
    [I(10,12)] = {64,0},
    [I(11,12)] = {64,0},
    [I(12,12)] = {64,0},
    [I(13,12)] = {64,0},
    [I(14,12)] = {64,0},
    [I(15,12)] = {64,0},
    [I(16,12)] = {64,0},
    [I(17,12)] = {64,0},
    [I(18,12)] = {64,0},
    [I(19,12)] = {64,0},
    [I(20,12)] = {64,0},
    [I(21,12)] = {64,0},
    [I(22,12)] = {64,0},
    [I(23,12)] = {64,0},
    [I(24,12)] = {64,0},
    [I(25,12)] = {64,0},
    [I(26,12)] = {64,0},
    [I(27,12)] = {64,0},
    [I(28,12)] = {64,0},
    [I(29,12)] = {64,0},
    [I(30,12)] = {64,0},
    [I(31,12)] = {64,0},
    [I(32,12)] = {64,0},
    [I(33,12)] = {64,0},
    [I(34,12)] = {64,0},
    [I(35,12)] = {64,0},
    [I(36,12)] = {64,0},
    [I(37,12)] = {64,0},
    [I(38,12)] = {64,0},
    [I(39,12)] = {64,0},
    [I(40,12)] = {64,0},
    [I(41,12)] = {64,0},
    [I(42,12)] = {64,0},
    [I(43,12)] = {64,0},
    [I(44,12)] = {64,0},
    [I(45,12)] = {64,0},
    [I(46,12)] = {64,0},
    [I(47,12)] = {64,0},
    [I(48,12)] = {64,0},
    [I(49,12)] = {64,0},
    [I(50,12)] = {64,0},
    [I(51,12)] = {64,0},
    [I(52,12)] = {64,0},
    [I(53,12)] = {64,0},
    [I(54,12)] = {64,0},
    [I(55,12)] = {64,0},
    [I(56,12)] = {64,0},
    [I(57,12)] = {64,0},
    [I(58,12)] = {64,0},
    [I(59,12)] = {64,0},
    [I(60,12)] = {64,0},
    [I(61,12)] = {64,0},
    [I(62,12)] = {64,0},
    [I(63,12)] = {64,0},
    [I(64,12)] = {64,0},
    [I(65,12)] = {64,0},
    [I(66,12)] = {64,0},
    [I(67,12)] = {64,0},
    [I(68,12)] = {64,0},
    [I(69,12)] = {64,0},
    [I(70,12)] = {64,0},
    [I(71,12)] = {64,0},
    [I(72,12)] = {64,0},
    [I(73,12)] = {64,0},
    [I(74,12)] = {64,0},
    [I(75,12)] = {64,0},
    [I(76,12)] = {64,0},
    [I(77,12)] = {64,0},
    [I(78,12)] = {64,0},
    [I(79,12)] = {64,0},
    [I(80,12)] = {64,0},
    [I(81,12)] = {64,0},
    [I(82,12)] = {64,0},
    [I(83,12)] = {64,0},
    [I(84,12)] = {64,0},
    [I(85,12)] = {64,0},
    [I(86,12)] = {64,0},
    [I(87,12)] = {64,0},
    [I(88,12)] = {64,0},
    [I(89,12)] = {64,0},
    [I(90,12)] = {64,0},
    [I(91,12)] = {64,0},
    [I(92,12)] = {64,0},
    [I(93,12)] = {64,0},
    [I(94,12)] = {64,0},
    [I(95,12)] = {64,0},
    [I(96,12)] = {64,0},
    [I(97,12)] = {64,0},
    [I(98,12)] = {64,0},
    [I(99,12)] = {64,0},
    [I(100,12)] = {64,0},
    [I(101,12)] = {64,0},
    [I(102,12)] = {64,0},
    [I(103,12)] = {64,0},
    [I(104,12)] = {64,0},
    [I(105,12)] = {64,0},
    [I(106,12)] = {64,0},
    [I(107,12)] = {64,0},
    [I(108,12)] = {64,0},
    [I(109,12)] = {64,0},
    [I(110,12)] = {64,0},
    [I(111,12)] = {64,0},
    [I(112,12)] = {64,0},
    [I(113,12)] = {64,0},
    [I(114,12)] = {64,0},
    [I(115,12)] = {64,0},
    [I(116,12)] = {64,0},
    [I(117,12)] = {64,0},
    [I(118,12)] = {64,0},
    [I(119,12)] = {64,0},
    [I(120,12)] = {64,0},
    [I(121,12)] = {64,0},
    [I(122,12)] = {64,0},
    [I(123,12)] = {64,0},
    [I(124,12)] = {64,0},
    [I(125,12)] = {64,0},
    [I(126,12)] = {64,0},
    [I(127,12)] = {64,0},
    [I(128,12)] = {64,0},
    [I(129,12)] = {64,0},
    [I(130,12)] = {64,0},
    [I(131,12)] = {64,0},
    [I(132,12)] = {64,0},
    [I(133,12)] = {64,0},
    [I(134,12)] = {64,0},
    [I(135,12)] = {64,0},
    [I(136,12)] = {64,0},
    [I(137,12)] = {64,0},
    [I(138,12)] = {64,0},
    [I(139,12)] = {64,0},
    [I(140,12)] = {64,0},
    [I(141,12)] = {64,0},
    [I(142,12)] = {64,0},
    [I(143,12)] = {64,0},
    [I(144,12)] = {64,0},
    [I(145,12)] = {64,0},
    [I(146,12)] = {64,0},
    [I(147,12)] = {64,0},
    [I(148,12)] = {64,0},
    [I(149,12)] = {64,0},
    [I(150,12)] = {64,0},
    [I(151,12)] = {64,0},
    [I(152,12)] = {64,0},
    [I(153,12)] = {64,0},
    [I(154,12)] = {64,0},
    [I(155,12)] = {64,0},
    [I(156,12)] = {64,0},
    [I(157,12)] = {64,0},
    [I(158,12)] = {64,0},
    [I(159,12)] = {64,0},
    [I(160,12)] = {64,0},
    [I(161,12)] = {64,0},
    [I(162,12)] = {64,0},
    [I(163,12)] = {64,0},
    [I(164,12)] = {64,0},
    [I(165,12)] = {64,0},
    [I(166,12)] = {64,0},
    [I(167,12)] = {64,0},
    [I(168,12)] = {64,0},
    [I(169,12)] = {64,0},
    [I(170,12)] = {64,0},
    [I(171,12)] = {64,0},
    [I(172,12)] = {64,0},
    [I(173,12)] = {64,0},
    [I(174,12)] = {64,0},
    [I(175,12)] = {64,0},
    [I(176,12)] = {64,0},
    [I(177,12)] = {64,0},
    [I(178,12)] = {64,0},
    [I(179,12)] = {64,0},
    [I(180,12)] = {64,0},
    [I(181,12)] = {64,0},
    [I(182,12)] = {64,0},
    [I(183,12)] = {64,0},
    [I(184,12)] = {64,0},
    [I(185,12)] = {64,0},
    [I(186,12)] = {64,0},
    [I(187,12)] = {64,0},
    [I(188,12)] = {64,0},
    [I(189,12)] = {64,0},
    [I(190,12)] = {64,0},
    [I(191,12)] = {64,0},
    [I(192,12)] = {64,0},
    [I(193,12)] = {64,0},
    [I(194,12)] = {64,0},
    [I(195,12)] = {64,0},
    [I(196,12)] = {64,0},
    [I(197,12)] = {64,0},
    [I(198,12)] = {64,0},
    [I(199,12)] = {64,0},
    [I(200,12)] = {64,0},
    [I(201,12)] = {64,0},
    [I(202,12)] = {64,0},
    [I(203,12)] = {64,0},
    [I(204,12)] = {64,0},
    [I(205,12)] = {64,0},
    [I(206,12)] = {64,0},
    [I(207,12)] = {64,0},
    [I(208,12)] = {64,0},
    [I(209,12)] = {64,0},
    [I(210,12)] = {64,0},
    [I(211,12)] = {64,0},
    [I(212,12)] = {64,0},
    [I(213,12)] = {64,0},
    [I(214,12)] = {64,0},
    [I(215,12)] = {64,0},
    [I(216,12)] = {64,0},
    [I(217,12)] = {64,0},
    [I(218,12)] = {64,0},
    [I(219,12)] = {64,0},
    [I(220,12)] = {64,0},
    [I(221,12)] = {64,0},
    [I(222,12)] = {64,0},
    [I(223,12)] = {64,0},
    [I(224,12)] = {64,0},
    [I(225,12)] = {64,0},
    [I(226,12)] = {64,0},
    [I(227,12)] = {64,0},
    [I(228,12)] = {64,0},
    [I(229,12)] = {64,0},
    [I(230,12)] = {64,0},
    [I(231,12)] = {64,0},
    [I(232,12)] = {64,0},
    [I(233,12)] = {64,0},
    [I(234,12)] = {64,0},
    [I(235,12)] = {64,0},
    [I(236,12)] = {64,0},
    [I(237,12)] = {64,0},
    [I(238,12)] = {64,0},
    [I(239,12)] = {64,0},
    [I(240,12)] = {64,0},
    [I(241,12)] = {64,0},
    [I(242,12)] = {64,0},
    [I(243,12)] = {64,0},
    [I(244,12)] = {64,0},
    [I(245,12)] = {64,0},
    [I(246,12)] = {64,0},
    [I(247,12)] = {64,0},
    [I(248,12)] = {64,0},
    [I(249,12)] = {64,0},
    [I(250,12)] = {64,0},
    [I(251,12)] = {64,0},
    [I(252,12)] = {64,0},
    [I(253,12)] = {64,0},
    [I(254,12)] = {64,0},
    [I(255,12)] = {64,0},
    [I(0,13)] = {64,0},
    [I(1,13)] = {64,0},
    [I(2,13)] = {64,0},
    [I(3,13)] = {64,0},
    [I(4,13)] = {64,0},
    [I(5,13)] = {64,0},
    [I(6,13)] = {64,0},
    [I(7,13)] = {64,0},
    [I(8,13)] = {64,0},
    [I(9,13)] = {64,0},
    [I(10,13)] = {64,0},
    [I(11,13)] = {64,0},
    [I(12,13)] = {64,0},
    [I(13,13)] = {64,0},
    [I(14,13)] = {64,0},
    [I(15,13)] = {64,0},
    [I(16,13)] = {64,0},
    [I(17,13)] = {64,0},
    [I(18,13)] = {64,0},
    [I(19,13)] = {64,0},
    [I(20,13)] = {64,0},
    [I(21,13)] = {64,0},
    [I(22,13)] = {64,0},
    [I(23,13)] = {64,0},
    [I(24,13)] = {64,0},
    [I(25,13)] = {64,0},
    [I(26,13)] = {64,0},
    [I(27,13)] = {64,0},
    [I(28,13)] = {64,0},
    [I(29,13)] = {64,0},
    [I(30,13)] = {64,0},
    [I(31,13)] = {64,0},
    [I(32,13)] = {64,0},
    [I(33,13)] = {64,0},
    [I(34,13)] = {64,0},
    [I(35,13)] = {64,0},
    [I(36,13)] = {64,0},
    [I(37,13)] = {64,0},
    [I(38,13)] = {64,0},
    [I(39,13)] = {64,0},
    [I(40,13)] = {64,0},
    [I(41,13)] = {64,0},
    [I(42,13)] = {64,0},
    [I(43,13)] = {64,0},
    [I(44,13)] = {64,0},
    [I(45,13)] = {64,0},
    [I(46,13)] = {64,0},
    [I(47,13)] = {64,0},
    [I(48,13)] = {64,0},
    [I(49,13)] = {64,0},
    [I(50,13)] = {64,0},
    [I(51,13)] = {64,0},
    [I(52,13)] = {64,0},
    [I(53,13)] = {64,0},
    [I(54,13)] = {64,0},
    [I(55,13)] = {64,0},
    [I(56,13)] = {64,0},
    [I(57,13)] = {64,0},
    [I(58,13)] = {64,0},
    [I(59,13)] = {64,0},
    [I(60,13)] = {64,0},
    [I(61,13)] = {64,0},
    [I(62,13)] = {64,0},
    [I(63,13)] = {64,0},
    [I(64,13)] = {64,0},
    [I(65,13)] = {64,0},
    [I(66,13)] = {64,0},
    [I(67,13)] = {64,0},
    [I(68,13)] = {64,0},
    [I(69,13)] = {64,0},
    [I(70,13)] = {64,0},
    [I(71,13)] = {64,0},
    [I(72,13)] = {64,0},
    [I(73,13)] = {64,0},
    [I(74,13)] = {64,0},
    [I(75,13)] = {64,0},
    [I(76,13)] = {64,0},
    [I(77,13)] = {64,0},
    [I(78,13)] = {64,0},
    [I(79,13)] = {64,0},
    [I(80,13)] = {64,0},
    [I(81,13)] = {64,0},
    [I(82,13)] = {64,0},
    [I(83,13)] = {64,0},
    [I(84,13)] = {64,0},
    [I(85,13)] = {64,0},
    [I(86,13)] = {64,0},
    [I(87,13)] = {64,0},
    [I(88,13)] = {64,0},
    [I(89,13)] = {64,0},
    [I(90,13)] = {64,0},
    [I(91,13)] = {64,0},
    [I(92,13)] = {64,0},
    [I(93,13)] = {64,0},
    [I(94,13)] = {64,0},
    [I(95,13)] = {64,0},
    [I(96,13)] = {64,0},
    [I(97,13)] = {64,0},
    [I(98,13)] = {64,0},
    [I(99,13)] = {64,0},
    [I(100,13)] = {64,0},
    [I(101,13)] = {64,0},
    [I(102,13)] = {64,0},
    [I(103,13)] = {64,0},
    [I(104,13)] = {64,0},
    [I(105,13)] = {64,0},
    [I(106,13)] = {64,0},
    [I(107,13)] = {64,0},
    [I(108,13)] = {64,0},
    [I(109,13)] = {64,0},
    [I(110,13)] = {64,0},
    [I(111,13)] = {64,0},
    [I(112,13)] = {64,0},
    [I(113,13)] = {64,0},
    [I(114,13)] = {64,0},
    [I(115,13)] = {64,0},
    [I(116,13)] = {64,0},
    [I(117,13)] = {64,0},
    [I(118,13)] = {64,0},
    [I(119,13)] = {64,0},
    [I(120,13)] = {64,0},
    [I(121,13)] = {64,0},
    [I(122,13)] = {64,0},
    [I(123,13)] = {64,0},
    [I(124,13)] = {64,0},
    [I(125,13)] = {64,0},
    [I(126,13)] = {64,0},
    [I(127,13)] = {64,0},
    [I(128,13)] = {64,0},
    [I(129,13)] = {64,0},
    [I(130,13)] = {64,0},
    [I(131,13)] = {64,0},
    [I(132,13)] = {64,0},
    [I(133,13)] = {64,0},
    [I(134,13)] = {64,0},
    [I(135,13)] = {64,0},
    [I(136,13)] = {64,0},
    [I(137,13)] = {64,0},
    [I(138,13)] = {64,0},
    [I(139,13)] = {64,0},
    [I(140,13)] = {64,0},
    [I(141,13)] = {64,0},
    [I(142,13)] = {64,0},
    [I(143,13)] = {64,0},
    [I(144,13)] = {64,0},
    [I(145,13)] = {64,0},
    [I(146,13)] = {64,0},
    [I(147,13)] = {64,0},
    [I(148,13)] = {64,0},
    [I(149,13)] = {64,0},
    [I(150,13)] = {64,0},
    [I(151,13)] = {64,0},
    [I(152,13)] = {64,0},
    [I(153,13)] = {64,0},
    [I(154,13)] = {64,0},
    [I(155,13)] = {64,0},
    [I(156,13)] = {64,0},
    [I(157,13)] = {64,0},
    [I(158,13)] = {64,0},
    [I(159,13)] = {64,0},
    [I(160,13)] = {64,0},
    [I(161,13)] = {64,0},
    [I(162,13)] = {64,0},
    [I(163,13)] = {64,0},
    [I(164,13)] = {64,0},
    [I(165,13)] = {64,0},
    [I(166,13)] = {64,0},
    [I(167,13)] = {64,0},
    [I(168,13)] = {64,0},
    [I(169,13)] = {64,0},
    [I(170,13)] = {64,0},
    [I(171,13)] = {64,0},
    [I(172,13)] = {64,0},
    [I(173,13)] = {64,0},
    [I(174,13)] = {64,0},
    [I(175,13)] = {64,0},
    [I(176,13)] = {64,0},
    [I(177,13)] = {64,0},
    [I(178,13)] = {64,0},
    [I(179,13)] = {64,0},
    [I(180,13)] = {64,0},
    [I(181,13)] = {64,0},
    [I(182,13)] = {64,0},
    [I(183,13)] = {64,0},
    [I(184,13)] = {64,0},
    [I(185,13)] = {64,0},
    [I(186,13)] = {64,0},
    [I(187,13)] = {64,0},
    [I(188,13)] = {64,0},
    [I(189,13)] = {64,0},
    [I(190,13)] = {64,0},
    [I(191,13)] = {64,0},
    [I(192,13)] = {64,0},
    [I(193,13)] = {64,0},
    [I(194,13)] = {64,0},
    [I(195,13)] = {64,0},
    [I(196,13)] = {64,0},
    [I(197,13)] = {64,0},
    [I(198,13)] = {64,0},
    [I(199,13)] = {64,0},
    [I(200,13)] = {64,0},
    [I(201,13)] = {64,0},
    [I(202,13)] = {64,0},
    [I(203,13)] = {64,0},
    [I(204,13)] = {64,0},
    [I(205,13)] = {64,0},
    [I(206,13)] = {64,0},
    [I(207,13)] = {64,0},
    [I(208,13)] = {64,0},
    [I(209,13)] = {64,0},
    [I(210,13)] = {64,0},
    [I(211,13)] = {64,0},
    [I(212,13)] = {64,0},
    [I(213,13)] = {64,0},
    [I(214,13)] = {64,0},
    [I(215,13)] = {64,0},
    [I(216,13)] = {64,0},
    [I(217,13)] = {64,0},
    [I(218,13)] = {64,0},
    [I(219,13)] = {64,0},
    [I(220,13)] = {64,0},
    [I(221,13)] = {64,0},
    [I(222,13)] = {64,0},
    [I(223,13)] = {64,0},
    [I(224,13)] = {64,0},
    [I(225,13)] = {64,0},
    [I(226,13)] = {64,0},
    [I(227,13)] = {64,0},
    [I(228,13)] = {64,0},
    [I(229,13)] = {64,0},
    [I(230,13)] = {64,0},
    [I(231,13)] = {64,0},
    [I(232,13)] = {64,0},
    [I(233,13)] = {64,0},
    [I(234,13)] = {64,0},
    [I(235,13)] = {64,0},
    [I(236,13)] = {64,0},
    [I(237,13)] = {64,0},
    [I(238,13)] = {64,0},
    [I(239,13)] = {64,0},
    [I(240,13)] = {64,0},
    [I(241,13)] = {64,0},
    [I(242,13)] = {64,0},
    [I(243,13)] = {64,0},
    [I(244,13)] = {64,0},
    [I(245,13)] = {64,0},
    [I(246,13)] = {64,0},
    [I(247,13)] = {64,0},
    [I(248,13)] = {64,0},
    [I(249,13)] = {64,0},
    [I(250,13)] = {64,0},
    [I(251,13)] = {64,0},
    [I(252,13)] = {64,0},
    [I(253,13)] = {64,0},
    [I(254,13)] = {64,0},
    [I(255,13)] = {64,0},
    [I(0,14)] = {64,0},
    [I(1,14)] = {64,0},
    [I(2,14)] = {64,0},
    [I(3,14)] = {64,0},
    [I(4,14)] = {64,0},
    [I(5,14)] = {64,0},
    [I(6,14)] = {64,0},
    [I(7,14)] = {64,0},
    [I(8,14)] = {64,0},
    [I(9,14)] = {64,0},
    [I(10,14)] = {64,0},
    [I(11,14)] = {64,0},
    [I(12,14)] = {64,0},
    [I(13,14)] = {64,0},
    [I(14,14)] = {64,0},
    [I(15,14)] = {64,0},
    [I(16,14)] = {64,0},
    [I(17,14)] = {64,0},
    [I(18,14)] = {64,0},
    [I(19,14)] = {64,0},
    [I(20,14)] = {64,0},
    [I(21,14)] = {64,0},
    [I(22,14)] = {64,0},
    [I(23,14)] = {64,0},
    [I(24,14)] = {64,0},
    [I(25,14)] = {64,0},
    [I(26,14)] = {64,0},
    [I(27,14)] = {64,0},
    [I(28,14)] = {64,0},
    [I(29,14)] = {64,0},
    [I(30,14)] = {64,0},
    [I(31,14)] = {64,0},
    [I(32,14)] = {64,0},
    [I(33,14)] = {64,0},
    [I(34,14)] = {64,0},
    [I(35,14)] = {64,0},
    [I(36,14)] = {64,0},
    [I(37,14)] = {64,0},
    [I(38,14)] = {64,0},
    [I(39,14)] = {64,0},
    [I(40,14)] = {64,0},
    [I(41,14)] = {64,0},
    [I(42,14)] = {64,0},
    [I(43,14)] = {64,0},
    [I(44,14)] = {64,0},
    [I(45,14)] = {64,0},
    [I(46,14)] = {64,0},
    [I(47,14)] = {64,0},
    [I(48,14)] = {64,0},
    [I(49,14)] = {64,0},
    [I(50,14)] = {64,0},
    [I(51,14)] = {64,0},
    [I(52,14)] = {64,0},
    [I(53,14)] = {64,0},
    [I(54,14)] = {64,0},
    [I(55,14)] = {64,0},
    [I(56,14)] = {64,0},
    [I(57,14)] = {64,0},
    [I(58,14)] = {64,0},
    [I(59,14)] = {64,0},
    [I(60,14)] = {64,0},
    [I(61,14)] = {64,0},
    [I(62,14)] = {64,0},
    [I(63,14)] = {64,0},
    [I(64,14)] = {64,0},
    [I(65,14)] = {64,0},
    [I(66,14)] = {64,0},
    [I(67,14)] = {64,0},
    [I(68,14)] = {64,0},
    [I(69,14)] = {64,0},
    [I(70,14)] = {64,0},
    [I(71,14)] = {64,0},
    [I(72,14)] = {64,0},
    [I(73,14)] = {64,0},
    [I(74,14)] = {64,0},
    [I(75,14)] = {64,0},
    [I(76,14)] = {64,0},
    [I(77,14)] = {64,0},
    [I(78,14)] = {64,0},
    [I(79,14)] = {64,0},
    [I(80,14)] = {64,0},
    [I(81,14)] = {64,0},
    [I(82,14)] = {64,0},
    [I(83,14)] = {64,0},
    [I(84,14)] = {64,0},
    [I(85,14)] = {64,0},
    [I(86,14)] = {64,0},
    [I(87,14)] = {64,0},
    [I(88,14)] = {64,0},
    [I(89,14)] = {64,0},
    [I(90,14)] = {64,0},
    [I(91,14)] = {64,0},
    [I(92,14)] = {64,0},
    [I(93,14)] = {64,0},
    [I(94,14)] = {64,0},
    [I(95,14)] = {64,0},
    [I(96,14)] = {64,0},
    [I(97,14)] = {64,0},
    [I(98,14)] = {64,0},
    [I(99,14)] = {64,0},
    [I(100,14)] = {64,0},
    [I(101,14)] = {64,0},
    [I(102,14)] = {64,0},
    [I(103,14)] = {64,0},
    [I(104,14)] = {64,0},
    [I(105,14)] = {64,0},
    [I(106,14)] = {64,0},
    [I(107,14)] = {64,0},
    [I(108,14)] = {64,0},
    [I(109,14)] = {64,0},
    [I(110,14)] = {64,0},
    [I(111,14)] = {64,0},
    [I(112,14)] = {64,0},
    [I(113,14)] = {64,0},
    [I(114,14)] = {64,0},
    [I(115,14)] = {64,0},
    [I(116,14)] = {64,0},
    [I(117,14)] = {64,0},
    [I(118,14)] = {64,0},
    [I(119,14)] = {64,0},
    [I(120,14)] = {64,0},
    [I(121,14)] = {64,0},
    [I(122,14)] = {64,0},
    [I(123,14)] = {64,0},
    [I(124,14)] = {64,0},
    [I(125,14)] = {64,0},
    [I(126,14)] = {64,0},
    [I(127,14)] = {64,0},
    [I(128,14)] = {64,0},
    [I(129,14)] = {64,0},
    [I(130,14)] = {64,0},
    [I(131,14)] = {64,0},
    [I(132,14)] = {64,0},
    [I(133,14)] = {64,0},
    [I(134,14)] = {64,0},
    [I(135,14)] = {64,0},
    [I(136,14)] = {64,0},
    [I(137,14)] = {64,0},
    [I(138,14)] = {64,0},
    [I(139,14)] = {64,0},
    [I(140,14)] = {64,0},
    [I(141,14)] = {64,0},
    [I(142,14)] = {64,0},
    [I(143,14)] = {64,0},
    [I(144,14)] = {64,0},
    [I(145,14)] = {64,0},
    [I(146,14)] = {64,0},
    [I(147,14)] = {64,0},
    [I(148,14)] = {64,0},
    [I(149,14)] = {64,0},
    [I(150,14)] = {64,0},
    [I(151,14)] = {64,0},
    [I(152,14)] = {64,0},
    [I(153,14)] = {64,0},
    [I(154,14)] = {64,0},
    [I(155,14)] = {64,0},
    [I(156,14)] = {64,0},
    [I(157,14)] = {64,0},
    [I(158,14)] = {64,0},
    [I(159,14)] = {64,0},
    [I(160,14)] = {64,0},
    [I(161,14)] = {64,0},
    [I(162,14)] = {64,0},
    [I(163,14)] = {64,0},
    [I(164,14)] = {64,0},
    [I(165,14)] = {64,0},
    [I(166,14)] = {64,0},
    [I(167,14)] = {64,0},
    [I(168,14)] = {64,0},
    [I(169,14)] = {64,0},
    [I(170,14)] = {64,0},
    [I(171,14)] = {64,0},
    [I(172,14)] = {64,0},
    [I(173,14)] = {64,0},
    [I(174,14)] = {64,0},
    [I(175,14)] = {64,0},
    [I(176,14)] = {64,0},
    [I(177,14)] = {64,0},
    [I(178,14)] = {64,0},
    [I(179,14)] = {64,0},
    [I(180,14)] = {64,0},
    [I(181,14)] = {64,0},
    [I(182,14)] = {64,0},
    [I(183,14)] = {64,0},
    [I(184,14)] = {64,0},
    [I(185,14)] = {64,0},
    [I(186,14)] = {64,0},
    [I(187,14)] = {64,0},
    [I(188,14)] = {64,0},
    [I(189,14)] = {64,0},
    [I(190,14)] = {64,0},
    [I(191,14)] = {64,0},
    [I(192,14)] = {64,0},
    [I(193,14)] = {64,0},
    [I(194,14)] = {64,0},
    [I(195,14)] = {64,0},
    [I(196,14)] = {64,0},
    [I(197,14)] = {64,0},
    [I(198,14)] = {64,0},
    [I(199,14)] = {64,0},
    [I(200,14)] = {64,0},
    [I(201,14)] = {64,0},
    [I(202,14)] = {64,0},
    [I(203,14)] = {64,0},
    [I(204,14)] = {64,0},
    [I(205,14)] = {64,0},
    [I(206,14)] = {64,0},
    [I(207,14)] = {64,0},
    [I(208,14)] = {64,0},
    [I(209,14)] = {64,0},
    [I(210,14)] = {64,0},
    [I(211,14)] = {64,0},
    [I(212,14)] = {64,0},
    [I(213,14)] = {64,0},
    [I(214,14)] = {64,0},
    [I(215,14)] = {64,0},
    [I(216,14)] = {64,0},
    [I(217,14)] = {64,0},
    [I(218,14)] = {64,0},
    [I(219,14)] = {64,0},
    [I(220,14)] = {64,0},
    [I(221,14)] = {64,0},
    [I(222,14)] = {64,0},
    [I(223,14)] = {64,0},
    [I(224,14)] = {64,0},
    [I(225,14)] = {64,0},
    [I(226,14)] = {64,0},
    [I(227,14)] = {64,0},
    [I(228,14)] = {64,0},
    [I(229,14)] = {64,0},
    [I(230,14)] = {64,0},
    [I(231,14)] = {64,0},
    [I(232,14)] = {64,0},
    [I(233,14)] = {64,0},
    [I(234,14)] = {64,0},
    [I(235,14)] = {64,0},
    [I(236,14)] = {64,0},
    [I(237,14)] = {64,0},
    [I(238,14)] = {64,0},
    [I(239,14)] = {64,0},
    [I(240,14)] = {64,0},
    [I(241,14)] = {64,0},
    [I(242,14)] = {64,0},
    [I(243,14)] = {64,0},
    [I(244,14)] = {64,0},
    [I(245,14)] = {64,0},
    [I(246,14)] = {64,0},
    [I(247,14)] = {64,0},
    [I(248,14)] = {64,0},
    [I(249,14)] = {64,0},
    [I(250,14)] = {64,0},
    [I(251,14)] = {64,0},
    [I(252,14)] = {64,0},
    [I(253,14)] = {64,0},
    [I(254,14)] = {64,0},
    [I(255,14)] = {64,0},
    [I(0,15)] = {64,0},
    [I(1,15)] = {64,0},
    [I(2,15)] = {64,0},
    [I(3,15)] = {64,0},
    [I(4,15)] = {64,0},
    [I(5,15)] = {64,0},
    [I(6,15)] = {64,0},
    [I(7,15)] = {64,0},
    [I(8,15)] = {64,0},
    [I(9,15)] = {64,0},
    [I(10,15)] = {64,0},
    [I(11,15)] = {64,0},
    [I(12,15)] = {64,0},
    [I(13,15)] = {64,0},
    [I(14,15)] = {64,0},
    [I(15,15)] = {64,0},
    [I(16,15)] = {64,0},
    [I(17,15)] = {64,0},
    [I(18,15)] = {64,0},
    [I(19,15)] = {64,0},
    [I(20,15)] = {64,0},
    [I(21,15)] = {64,0},
    [I(22,15)] = {64,0},
    [I(23,15)] = {64,0},
    [I(24,15)] = {64,0},
    [I(25,15)] = {64,0},
    [I(26,15)] = {64,0},
    [I(27,15)] = {64,0},
    [I(28,15)] = {64,0},
    [I(29,15)] = {64,0},
    [I(30,15)] = {64,0},
    [I(31,15)] = {64,0},
    [I(32,15)] = {64,0},
    [I(33,15)] = {64,0},
    [I(34,15)] = {64,0},
    [I(35,15)] = {64,0},
    [I(36,15)] = {64,0},
    [I(37,15)] = {64,0},
    [I(38,15)] = {64,0},
    [I(39,15)] = {64,0},
    [I(40,15)] = {64,0},
    [I(41,15)] = {64,0},
    [I(42,15)] = {64,0},
    [I(43,15)] = {64,0},
    [I(44,15)] = {64,0},
    [I(45,15)] = {64,0},
    [I(46,15)] = {64,0},
    [I(47,15)] = {64,0},
    [I(48,15)] = {64,0},
    [I(49,15)] = {64,0},
    [I(50,15)] = {64,0},
    [I(51,15)] = {64,0},
    [I(52,15)] = {64,0},
    [I(53,15)] = {64,0},
    [I(54,15)] = {64,0},
    [I(55,15)] = {64,0},
    [I(56,15)] = {64,0},
    [I(57,15)] = {64,0},
    [I(58,15)] = {64,0},
    [I(59,15)] = {64,0},
    [I(60,15)] = {64,0},
    [I(61,15)] = {64,0},
    [I(62,15)] = {64,0},
    [I(63,15)] = {64,0},
    [I(64,15)] = {64,0},
    [I(65,15)] = {64,0},
    [I(66,15)] = {64,0},
    [I(67,15)] = {64,0},
    [I(68,15)] = {64,0},
    [I(69,15)] = {64,0},
    [I(70,15)] = {64,0},
    [I(71,15)] = {64,0},
    [I(72,15)] = {64,0},
    [I(73,15)] = {64,0},
    [I(74,15)] = {64,0},
    [I(75,15)] = {64,0},
    [I(76,15)] = {64,0},
    [I(77,15)] = {64,0},
    [I(78,15)] = {64,0},
    [I(79,15)] = {64,0},
    [I(80,15)] = {64,0},
    [I(81,15)] = {64,0},
    [I(82,15)] = {64,0},
    [I(83,15)] = {64,0},
    [I(84,15)] = {64,0},
    [I(85,15)] = {64,0},
    [I(86,15)] = {64,0},
    [I(87,15)] = {64,0},
    [I(88,15)] = {64,0},
    [I(89,15)] = {64,0},
    [I(90,15)] = {64,0},
    [I(91,15)] = {64,0},
    [I(92,15)] = {64,0},
    [I(93,15)] = {64,0},
    [I(94,15)] = {64,0},
    [I(95,15)] = {64,0},
    [I(96,15)] = {64,0},
    [I(97,15)] = {64,0},
    [I(98,15)] = {64,0},
    [I(99,15)] = {64,0},
    [I(100,15)] = {64,0},
    [I(101,15)] = {64,0},
    [I(102,15)] = {64,0},
    [I(103,15)] = {64,0},
    [I(104,15)] = {64,0},
    [I(105,15)] = {64,0},
    [I(106,15)] = {64,0},
    [I(107,15)] = {64,0},
    [I(108,15)] = {64,0},
    [I(109,15)] = {64,0},
    [I(110,15)] = {64,0},
    [I(111,15)] = {64,0},
    [I(112,15)] = {64,0},
    [I(113,15)] = {64,0},
    [I(114,15)] = {64,0},
    [I(115,15)] = {64,0},
    [I(116,15)] = {64,0},
    [I(117,15)] = {64,0},
    [I(118,15)] = {64,0},
    [I(119,15)] = {64,0},
    [I(120,15)] = {64,0},
    [I(121,15)] = {64,0},
    [I(122,15)] = {64,0},
    [I(123,15)] = {64,0},
    [I(124,15)] = {64,0},
    [I(125,15)] = {64,0},
    [I(126,15)] = {64,0},
    [I(127,15)] = {64,0},
    [I(128,15)] = {64,0},
    [I(129,15)] = {64,0},
    [I(130,15)] = {64,0},
    [I(131,15)] = {64,0},
    [I(132,15)] = {64,0},
    [I(133,15)] = {64,0},
    [I(134,15)] = {64,0},
    [I(135,15)] = {64,0},
    [I(136,15)] = {64,0},
    [I(137,15)] = {64,0},
    [I(138,15)] = {64,0},
    [I(139,15)] = {64,0},
    [I(140,15)] = {64,0},
    [I(141,15)] = {64,0},
    [I(142,15)] = {64,0},
    [I(143,15)] = {64,0},
    [I(144,15)] = {64,0},
    [I(145,15)] = {64,0},
    [I(146,15)] = {64,0},
    [I(147,15)] = {64,0},
    [I(148,15)] = {64,0},
    [I(149,15)] = {64,0},
    [I(150,15)] = {64,0},
    [I(151,15)] = {64,0},
    [I(152,15)] = {64,0},
    [I(153,15)] = {64,0},
    [I(154,15)] = {64,0},
    [I(155,15)] = {64,0},
    [I(156,15)] = {64,0},
    [I(157,15)] = {64,0},
    [I(158,15)] = {64,0},
    [I(159,15)] = {64,0},
    [I(160,15)] = {64,0},
    [I(161,15)] = {64,0},
    [I(162,15)] = {64,0},
    [I(163,15)] = {64,0},
    [I(164,15)] = {64,0},
    [I(165,15)] = {64,0},
    [I(166,15)] = {64,0},
    [I(167,15)] = {64,0},
    [I(168,15)] = {64,0},
    [I(169,15)] = {64,0},
    [I(170,15)] = {64,0},
    [I(171,15)] = {64,0},
    [I(172,15)] = {64,0},
    [I(173,15)] = {64,0},
    [I(174,15)] = {64,0},
    [I(175,15)] = {64,0},
    [I(176,15)] = {64,0},
    [I(177,15)] = {64,0},
    [I(178,15)] = {64,0},
    [I(179,15)] = {64,0},
    [I(180,15)] = {64,0},
    [I(181,15)] = {64,0},
    [I(182,15)] = {64,0},
    [I(183,15)] = {64,0},
    [I(184,15)] = {64,0},
    [I(185,15)] = {64,0},
    [I(186,15)] = {64,0},
    [I(187,15)] = {64,0},
    [I(188,15)] = {64,0},
    [I(189,15)] = {64,0},
    [I(190,15)] = {64,0},
    [I(191,15)] = {64,0},
    [I(192,15)] = {64,0},
    [I(193,15)] = {64,0},
    [I(194,15)] = {64,0},
    [I(195,15)] = {64,0},
    [I(196,15)] = {64,0},
    [I(197,15)] = {64,0},
    [I(198,15)] = {64,0},
    [I(199,15)] = {64,0},
    [I(200,15)] = {64,0},
    [I(201,15)] = {64,0},
    [I(202,15)] = {64,0},
    [I(203,15)] = {64,0},
    [I(204,15)] = {64,0},
    [I(205,15)] = {64,0},
    [I(206,15)] = {64,0},
    [I(207,15)] = {64,0},
    [I(208,15)] = {64,0},
    [I(209,15)] = {64,0},
    [I(210,15)] = {64,0},
    [I(211,15)] = {64,0},
    [I(212,15)] = {64,0},
    [I(213,15)] = {64,0},
    [I(214,15)] = {64,0},
    [I(215,15)] = {64,0},
    [I(216,15)] = {64,0},
    [I(217,15)] = {64,0},
    [I(218,15)] = {64,0},
    [I(219,15)] = {64,0},
    [I(220,15)] = {64,0},
    [I(221,15)] = {64,0},
    [I(222,15)] = {64,0},
    [I(223,15)] = {64,0},
    [I(224,15)] = {64,0},
    [I(225,15)] = {64,0},
    [I(226,15)] = {64,0},
    [I(227,15)] = {64,0},
    [I(228,15)] = {64,0},
    [I(229,15)] = {64,0},
    [I(230,15)] = {64,0},
    [I(231,15)] = {64,0},
    [I(232,15)] = {64,0},
    [I(233,15)] = {64,0},
    [I(234,15)] = {64,0},
    [I(235,15)] = {64,0},
    [I(236,15)] = {64,0},
    [I(237,15)] = {64,0},
    [I(238,15)] = {64,0},
    [I(239,15)] = {64,0},
    [I(240,15)] = {64,0},
    [I(241,15)] = {64,0},
    [I(242,15)] = {64,0},
    [I(243,15)] = {64,0},
    [I(244,15)] = {64,0},
    [I(245,15)] = {64,0},
    [I(246,15)] = {64,0},
    [I(247,15)] = {64,0},
    [I(248,15)] = {64,0},
    [I(249,15)] = {64,0},
    [I(250,15)] = {64,0},
    [I(251,15)] = {64,0},
    [I(252,15)] = {64,0},
    [I(253,15)] = {64,0},
    [I(254,15)] = {64,0},
    [I(255,15)] = {64,0},
    [I(0,16)] = {64,0},
    [I(1,16)] = {64,0},
    [I(2,16)] = {64,0},
    [I(3,16)] = {64,0},
    [I(4,16)] = {64,0},
    [I(5,16)] = {64,0},
    [I(6,16)] = {64,0},
    [I(7,16)] = {64,0},
    [I(8,16)] = {64,0},
    [I(9,16)] = {64,0},
    [I(10,16)] = {64,0},
    [I(11,16)] = {64,0},
    [I(12,16)] = {64,0},
    [I(13,16)] = {64,0},
    [I(14,16)] = {64,0},
    [I(15,16)] = {64,0},
    [I(16,16)] = {64,0},
    [I(17,16)] = {64,0},
    [I(18,16)] = {64,0},
    [I(19,16)] = {64,0},
    [I(20,16)] = {64,0},
    [I(21,16)] = {64,0},
    [I(22,16)] = {64,0},
    [I(23,16)] = {64,0},
    [I(24,16)] = {64,0},
    [I(25,16)] = {64,0},
    [I(26,16)] = {64,0},
    [I(27,16)] = {64,0},
    [I(28,16)] = {64,0},
    [I(29,16)] = {64,0},
    [I(30,16)] = {64,0},
    [I(31,16)] = {64,0},
    [I(32,16)] = {64,0},
    [I(33,16)] = {64,0},
    [I(34,16)] = {64,0},
    [I(35,16)] = {64,0},
    [I(36,16)] = {64,0},
    [I(37,16)] = {64,0},
    [I(38,16)] = {64,0},
    [I(39,16)] = {64,0},
    [I(40,16)] = {64,0},
    [I(41,16)] = {64,0},
    [I(42,16)] = {64,0},
    [I(43,16)] = {64,0},
    [I(44,16)] = {64,0},
    [I(45,16)] = {64,0},
    [I(46,16)] = {64,0},
    [I(47,16)] = {64,0},
    [I(48,16)] = {64,0},
    [I(49,16)] = {64,0},
    [I(50,16)] = {64,0},
    [I(51,16)] = {64,0},
    [I(52,16)] = {64,0},
    [I(53,16)] = {64,0},
    [I(54,16)] = {64,0},
    [I(55,16)] = {64,0},
    [I(56,16)] = {64,0},
    [I(57,16)] = {64,0},
    [I(58,16)] = {64,0},
    [I(59,16)] = {64,0},
    [I(60,16)] = {64,0},
    [I(61,16)] = {64,0},
    [I(62,16)] = {64,0},
    [I(63,16)] = {64,0},
    [I(64,16)] = {64,0},
    [I(65,16)] = {64,0},
    [I(66,16)] = {64,0},
    [I(67,16)] = {64,0},
    [I(68,16)] = {64,0},
    [I(69,16)] = {64,0},
    [I(70,16)] = {64,0},
    [I(71,16)] = {64,0},
    [I(72,16)] = {64,0},
    [I(73,16)] = {64,0},
    [I(74,16)] = {64,0},
    [I(75,16)] = {64,0},
    [I(76,16)] = {64,0},
    [I(77,16)] = {64,0},
    [I(78,16)] = {64,0},
    [I(79,16)] = {64,0},
    [I(80,16)] = {64,0},
    [I(81,16)] = {64,0},
    [I(82,16)] = {64,0},
    [I(83,16)] = {64,0},
    [I(84,16)] = {64,0},
    [I(85,16)] = {64,0},
    [I(86,16)] = {64,0},
    [I(87,16)] = {64,0},
    [I(88,16)] = {64,0},
    [I(89,16)] = {64,0},
    [I(90,16)] = {64,0},
    [I(91,16)] = {64,0},
    [I(92,16)] = {64,0},
    [I(93,16)] = {64,0},
    [I(94,16)] = {64,0},
    [I(95,16)] = {64,0},
    [I(96,16)] = {64,0},
    [I(97,16)] = {64,0},
    [I(98,16)] = {64,0},
    [I(99,16)] = {64,0},
    [I(100,16)] = {64,0},
    [I(101,16)] = {64,0},
    [I(102,16)] = {64,0},
    [I(103,16)] = {64,0},
    [I(104,16)] = {64,0},
    [I(105,16)] = {64,0},
    [I(106,16)] = {64,0},
    [I(107,16)] = {64,0},
    [I(108,16)] = {64,0},
    [I(109,16)] = {64,0},
    [I(110,16)] = {64,0},
    [I(111,16)] = {64,0},
    [I(112,16)] = {64,0},
    [I(113,16)] = {64,0},
    [I(114,16)] = {64,0},
    [I(115,16)] = {64,0},
    [I(116,16)] = {64,0},
    [I(117,16)] = {64,0},
    [I(118,16)] = {64,0},
    [I(119,16)] = {64,0},
    [I(120,16)] = {64,0},
    [I(121,16)] = {64,0},
    [I(122,16)] = {64,0},
    [I(123,16)] = {64,0},
    [I(124,16)] = {64,0},
    [I(125,16)] = {64,0},
    [I(126,16)] = {64,0},
    [I(127,16)] = {64,0},
    [I(128,16)] = {64,0},
    [I(129,16)] = {64,0},
    [I(130,16)] = {64,0},
    [I(131,16)] = {64,0},
    [I(132,16)] = {64,0},
    [I(133,16)] = {64,0},
    [I(134,16)] = {64,0},
    [I(135,16)] = {64,0},
    [I(136,16)] = {64,0},
    [I(137,16)] = {64,0},
    [I(138,16)] = {64,0},
    [I(139,16)] = {64,0},
    [I(140,16)] = {64,0},
    [I(141,16)] = {64,0},
    [I(142,16)] = {64,0},
    [I(143,16)] = {64,0},
    [I(144,16)] = {64,0},
    [I(145,16)] = {64,0},
    [I(146,16)] = {64,0},
    [I(147,16)] = {64,0},
    [I(148,16)] = {64,0},
    [I(149,16)] = {64,0},
    [I(150,16)] = {64,0},
    [I(151,16)] = {64,0},
    [I(152,16)] = {64,0},
    [I(153,16)] = {64,0},
    [I(154,16)] = {64,0},
    [I(155,16)] = {64,0},
    [I(156,16)] = {64,0},
    [I(157,16)] = {64,0},
    [I(158,16)] = {64,0},
    [I(159,16)] = {64,0},
    [I(160,16)] = {64,0},
    [I(161,16)] = {64,0},
    [I(162,16)] = {64,0},
    [I(163,16)] = {64,0},
    [I(164,16)] = {64,0},
    [I(165,16)] = {64,0},
    [I(166,16)] = {64,0},
    [I(167,16)] = {64,0},
    [I(168,16)] = {64,0},
    [I(169,16)] = {64,0},
    [I(170,16)] = {64,0},
    [I(171,16)] = {64,0},
    [I(172,16)] = {64,0},
    [I(173,16)] = {64,0},
    [I(174,16)] = {64,0},
    [I(175,16)] = {64,0},
    [I(176,16)] = {64,0},
    [I(177,16)] = {64,0},
    [I(178,16)] = {64,0},
    [I(179,16)] = {64,0},
    [I(180,16)] = {64,0},
    [I(181,16)] = {64,0},
    [I(182,16)] = {64,0},
    [I(183,16)] = {64,0},
    [I(184,16)] = {64,0},
    [I(185,16)] = {64,0},
    [I(186,16)] = {64,0},
    [I(187,16)] = {64,0},
    [I(188,16)] = {64,0},
    [I(189,16)] = {64,0},
    [I(190,16)] = {64,0},
    [I(191,16)] = {64,0},
    [I(192,16)] = {64,0},
    [I(193,16)] = {64,0},
    [I(194,16)] = {64,0},
    [I(195,16)] = {64,0},
    [I(196,16)] = {64,0},
    [I(197,16)] = {64,0},
    [I(198,16)] = {64,0},
    [I(199,16)] = {64,0},
    [I(200,16)] = {64,0},
    [I(201,16)] = {64,0},
    [I(202,16)] = {64,0},
    [I(203,16)] = {64,0},
    [I(204,16)] = {64,0},
    [I(205,16)] = {64,0},
    [I(206,16)] = {64,0},
    [I(207,16)] = {64,0},
    [I(208,16)] = {64,0},
    [I(209,16)] = {64,0},
    [I(210,16)] = {64,0},
    [I(211,16)] = {64,0},
    [I(212,16)] = {64,0},
    [I(213,16)] = {64,0},
    [I(214,16)] = {64,0},
    [I(215,16)] = {64,0},
    [I(216,16)] = {64,0},
    [I(217,16)] = {64,0},
    [I(218,16)] = {64,0},
    [I(219,16)] = {64,0},
    [I(220,16)] = {64,0},
    [I(221,16)] = {64,0},
    [I(222,16)] = {64,0},
    [I(223,16)] = {64,0},
    [I(224,16)] = {64,0},
    [I(225,16)] = {64,0},
    [I(226,16)] = {64,0},
    [I(227,16)] = {64,0},
    [I(228,16)] = {64,0},
    [I(229,16)] = {64,0},
    [I(230,16)] = {64,0},
    [I(231,16)] = {64,0},
    [I(232,16)] = {64,0},
    [I(233,16)] = {64,0},
    [I(234,16)] = {64,0},
    [I(235,16)] = {64,0},
    [I(236,16)] = {64,0},
    [I(237,16)] = {64,0},
    [I(238,16)] = {64,0},
    [I(239,16)] = {64,0},
    [I(240,16)] = {64,0},
    [I(241,16)] = {64,0},
    [I(242,16)] = {64,0},
    [I(243,16)] = {64,0},
    [I(244,16)] = {64,0},
    [I(245,16)] = {64,0},
    [I(246,16)] = {64,0},
    [I(247,16)] = {64,0},
    [I(248,16)] = {64,0},
    [I(249,16)] = {64,0},
    [I(250,16)] = {64,0},
    [I(251,16)] = {64,0},
    [I(252,16)] = {64,0},
    [I(253,16)] = {64,0},
    [I(254,16)] = {64,0},
    [I(255,16)] = {64,0},
    [I(0,17)] = {64,0},
    [I(1,17)] = {64,0},
    [I(2,17)] = {64,0},
    [I(3,17)] = {64,0},
    [I(4,17)] = {64,0},
    [I(5,17)] = {64,0},
    [I(6,17)] = {64,0},
    [I(7,17)] = {64,0},
    [I(8,17)] = {64,0},
    [I(9,17)] = {64,0},
    [I(10,17)] = {64,0},
    [I(11,17)] = {64,0},
    [I(12,17)] = {64,0},
    [I(13,17)] = {64,0},
    [I(14,17)] = {64,0},
    [I(15,17)] = {64,0},
    [I(16,17)] = {64,0},
    [I(17,17)] = {64,0},
    [I(18,17)] = {64,0},
    [I(19,17)] = {64,0},
    [I(20,17)] = {64,0},
    [I(21,17)] = {64,0},
    [I(22,17)] = {64,0},
    [I(23,17)] = {64,0},
    [I(24,17)] = {64,0},
    [I(25,17)] = {64,0},
    [I(26,17)] = {64,0},
    [I(27,17)] = {64,0},
    [I(28,17)] = {64,0},
    [I(29,17)] = {64,0},
    [I(30,17)] = {64,0},
    [I(31,17)] = {64,0},
    [I(32,17)] = {64,0},
    [I(33,17)] = {64,0},
    [I(34,17)] = {64,0},
    [I(35,17)] = {64,0},
    [I(36,17)] = {64,0},
    [I(37,17)] = {64,0},
    [I(38,17)] = {64,0},
    [I(39,17)] = {64,0},
    [I(40,17)] = {64,0},
    [I(41,17)] = {64,0},
    [I(42,17)] = {64,0},
    [I(43,17)] = {64,0},
    [I(44,17)] = {64,0},
    [I(45,17)] = {64,0},
    [I(46,17)] = {64,0},
    [I(47,17)] = {64,0},
    [I(48,17)] = {64,0},
    [I(49,17)] = {64,0},
    [I(50,17)] = {64,0},
    [I(51,17)] = {64,0},
    [I(52,17)] = {64,0},
    [I(53,17)] = {64,0},
    [I(54,17)] = {64,0},
    [I(55,17)] = {64,0},
    [I(56,17)] = {64,0},
    [I(57,17)] = {64,0},
    [I(58,17)] = {64,0},
    [I(59,17)] = {64,0},
    [I(60,17)] = {64,0},
    [I(61,17)] = {64,0},
    [I(62,17)] = {64,0},
    [I(63,17)] = {64,0},
    [I(64,17)] = {64,0},
    [I(65,17)] = {64,0},
    [I(66,17)] = {64,0},
    [I(67,17)] = {64,0},
    [I(68,17)] = {64,0},
    [I(69,17)] = {64,0},
    [I(70,17)] = {64,0},
    [I(71,17)] = {64,0},
    [I(72,17)] = {64,0},
    [I(73,17)] = {64,0},
    [I(74,17)] = {64,0},
    [I(75,17)] = {64,0},
    [I(76,17)] = {64,0},
    [I(77,17)] = {64,0},
    [I(78,17)] = {64,0},
    [I(79,17)] = {64,0},
    [I(80,17)] = {64,0},
    [I(81,17)] = {64,0},
    [I(82,17)] = {64,0},
    [I(83,17)] = {64,0},
    [I(84,17)] = {64,0},
    [I(85,17)] = {64,0},
    [I(86,17)] = {64,0},
    [I(87,17)] = {64,0},
    [I(88,17)] = {64,0},
    [I(89,17)] = {64,0},
    [I(90,17)] = {64,0},
    [I(91,17)] = {64,0},
    [I(92,17)] = {64,0},
    [I(93,17)] = {64,0},
    [I(94,17)] = {64,0},
    [I(95,17)] = {64,0},
    [I(96,17)] = {64,0},
    [I(97,17)] = {64,0},
    [I(98,17)] = {64,0},
    [I(99,17)] = {64,0},
    [I(100,17)] = {64,0},
    [I(101,17)] = {64,0},
    [I(102,17)] = {64,0},
    [I(103,17)] = {64,0},
    [I(104,17)] = {64,0},
    [I(105,17)] = {64,0},
    [I(106,17)] = {64,0},
    [I(107,17)] = {64,0},
    [I(108,17)] = {64,0},
    [I(109,17)] = {64,0},
    [I(110,17)] = {64,0},
    [I(111,17)] = {64,0},
    [I(112,17)] = {64,0},
    [I(113,17)] = {64,0},
    [I(114,17)] = {64,0},
    [I(115,17)] = {64,0},
    [I(116,17)] = {64,0},
    [I(117,17)] = {64,0},
    [I(118,17)] = {64,0},
    [I(119,17)] = {64,0},
    [I(120,17)] = {64,0},
    [I(121,17)] = {64,0},
    [I(122,17)] = {64,0},
    [I(123,17)] = {64,0},
    [I(124,17)] = {64,0},
    [I(125,17)] = {64,0},
    [I(126,17)] = {64,0},
    [I(127,17)] = {64,0},
    [I(128,17)] = {64,0},
    [I(129,17)] = {64,0},
    [I(130,17)] = {64,0},
    [I(131,17)] = {64,0},
    [I(132,17)] = {64,0},
    [I(133,17)] = {64,0},
    [I(134,17)] = {64,0},
    [I(135,17)] = {64,0},
    [I(136,17)] = {64,0},
    [I(137,17)] = {64,0},
    [I(138,17)] = {64,0},
    [I(139,17)] = {64,0},
    [I(140,17)] = {64,0},
    [I(141,17)] = {64,0},
    [I(142,17)] = {64,0},
    [I(143,17)] = {64,0},
    [I(144,17)] = {64,0},
    [I(145,17)] = {64,0},
    [I(146,17)] = {64,0},
    [I(147,17)] = {64,0},
    [I(148,17)] = {64,0},
    [I(149,17)] = {64,0},
    [I(150,17)] = {64,0},
    [I(151,17)] = {64,0},
    [I(152,17)] = {64,0},
    [I(153,17)] = {64,0},
    [I(154,17)] = {64,0},
    [I(155,17)] = {64,0},
    [I(156,17)] = {64,0},
    [I(157,17)] = {64,0},
    [I(158,17)] = {64,0},
    [I(159,17)] = {64,0},
    [I(160,17)] = {64,0},
    [I(161,17)] = {64,0},
    [I(162,17)] = {64,0},
    [I(163,17)] = {64,0},
    [I(164,17)] = {64,0},
    [I(165,17)] = {64,0},
    [I(166,17)] = {64,0},
    [I(167,17)] = {64,0},
    [I(168,17)] = {64,0},
    [I(169,17)] = {64,0},
    [I(170,17)] = {64,0},
    [I(171,17)] = {64,0},
    [I(172,17)] = {64,0},
    [I(173,17)] = {64,0},
    [I(174,17)] = {64,0},
    [I(175,17)] = {64,0},
    [I(176,17)] = {64,0},
    [I(177,17)] = {64,0},
    [I(178,17)] = {64,0},
    [I(179,17)] = {64,0},
    [I(180,17)] = {64,0},
    [I(181,17)] = {64,0},
    [I(182,17)] = {64,0},
    [I(183,17)] = {64,0},
    [I(184,17)] = {64,0},
    [I(185,17)] = {64,0},
    [I(186,17)] = {64,0},
    [I(187,17)] = {64,0},
    [I(188,17)] = {64,0},
    [I(189,17)] = {64,0},
    [I(190,17)] = {64,0},
    [I(191,17)] = {64,0},
    [I(192,17)] = {64,0},
    [I(193,17)] = {64,0},
    [I(194,17)] = {64,0},
    [I(195,17)] = {64,0},
    [I(196,17)] = {64,0},
    [I(197,17)] = {64,0},
    [I(198,17)] = {64,0},
    [I(199,17)] = {64,0},
    [I(200,17)] = {64,0},
    [I(201,17)] = {64,0},
    [I(202,17)] = {64,0},
    [I(203,17)] = {64,0},
    [I(204,17)] = {64,0},
    [I(205,17)] = {64,0},
    [I(206,17)] = {64,0},
    [I(207,17)] = {64,0},
    [I(208,17)] = {64,0},
    [I(209,17)] = {64,0},
    [I(210,17)] = {64,0},
    [I(211,17)] = {64,0},
    [I(212,17)] = {64,0},
    [I(213,17)] = {64,0},
    [I(214,17)] = {64,0},
    [I(215,17)] = {64,0},
    [I(216,17)] = {64,0},
    [I(217,17)] = {64,0},
    [I(218,17)] = {64,0},
    [I(219,17)] = {64,0},
    [I(220,17)] = {64,0},
    [I(221,17)] = {64,0},
    [I(222,17)] = {64,0},
    [I(223,17)] = {64,0},
    [I(224,17)] = {64,0},
    [I(225,17)] = {64,0},
    [I(226,17)] = {64,0},
    [I(227,17)] = {64,0},
    [I(228,17)] = {64,0},
    [I(229,17)] = {64,0},
    [I(230,17)] = {64,0},
    [I(231,17)] = {64,0},
    [I(232,17)] = {64,0},
    [I(233,17)] = {64,0},
    [I(234,17)] = {64,0},
    [I(235,17)] = {64,0},
    [I(236,17)] = {64,0},
    [I(237,17)] = {64,0},
    [I(238,17)] = {64,0},
    [I(239,17)] = {64,0},
    [I(240,17)] = {64,0},
    [I(241,17)] = {64,0},
    [I(242,17)] = {64,0},
    [I(243,17)] = {64,0},
    [I(244,17)] = {64,0},
    [I(245,17)] = {64,0},
    [I(246,17)] = {64,0},
    [I(247,17)] = {64,0},
    [I(248,17)] = {64,0},
    [I(249,17)] = {64,0},
    [I(250,17)] = {64,0},
    [I(251,17)] = {64,0},
    [I(252,17)] = {64,0},
    [I(253,17)] = {64,0},
    [I(254,17)] = {64,0},
    [I(255,17)] = {64,0},
    [I(0,18)] = {64,0},
    [I(1,18)] = {64,0},
    [I(2,18)] = {64,0},
    [I(3,18)] = {64,0},
    [I(4,18)] = {64,0},
    [I(5,18)] = {64,0},
    [I(6,18)] = {64,0},
    [I(7,18)] = {64,0},
    [I(8,18)] = {64,0},
    [I(9,18)] = {64,0},
    [I(10,18)] = {64,0},
    [I(11,18)] = {64,0},
    [I(12,18)] = {64,0},
    [I(13,18)] = {64,0},
    [I(14,18)] = {64,0},
    [I(15,18)] = {64,0},
    [I(16,18)] = {64,0},
    [I(17,18)] = {64,0},
    [I(18,18)] = {64,0},
    [I(19,18)] = {64,0},
    [I(20,18)] = {64,0},
    [I(21,18)] = {64,0},
    [I(22,18)] = {64,0},
    [I(23,18)] = {64,0},
    [I(24,18)] = {64,0},
    [I(25,18)] = {64,0},
    [I(26,18)] = {64,0},
    [I(27,18)] = {64,0},
    [I(28,18)] = {64,0},
    [I(29,18)] = {64,0},
    [I(30,18)] = {64,0},
    [I(31,18)] = {64,0},
    [I(32,18)] = {64,0},
    [I(33,18)] = {64,0},
    [I(34,18)] = {64,0},
    [I(35,18)] = {64,0},
    [I(36,18)] = {64,0},
    [I(37,18)] = {64,0},
    [I(38,18)] = {64,0},
    [I(39,18)] = {64,0},
    [I(40,18)] = {64,0},
    [I(41,18)] = {64,0},
    [I(42,18)] = {64,0},
    [I(43,18)] = {64,0},
    [I(44,18)] = {64,0},
    [I(45,18)] = {64,0},
    [I(46,18)] = {64,0},
    [I(47,18)] = {64,0},
    [I(48,18)] = {64,0},
    [I(49,18)] = {64,0},
    [I(50,18)] = {64,0},
    [I(51,18)] = {64,0},
    [I(52,18)] = {64,0},
    [I(53,18)] = {64,0},
    [I(54,18)] = {64,0},
    [I(55,18)] = {64,0},
    [I(56,18)] = {64,0},
    [I(57,18)] = {64,0},
    [I(58,18)] = {64,0},
    [I(59,18)] = {64,0},
    [I(60,18)] = {64,0},
    [I(61,18)] = {64,0},
    [I(62,18)] = {64,0},
    [I(63,18)] = {64,0},
    [I(64,18)] = {64,0},
    [I(65,18)] = {64,0},
    [I(66,18)] = {64,0},
    [I(67,18)] = {64,0},
    [I(68,18)] = {64,0},
    [I(69,18)] = {64,0},
    [I(70,18)] = {64,0},
    [I(71,18)] = {64,0},
    [I(72,18)] = {64,0},
    [I(73,18)] = {64,0},
    [I(74,18)] = {64,0},
    [I(75,18)] = {64,0},
    [I(76,18)] = {64,0},
    [I(77,18)] = {64,0},
    [I(78,18)] = {64,0},
    [I(79,18)] = {64,0},
    [I(80,18)] = {64,0},
    [I(81,18)] = {64,0},
    [I(82,18)] = {64,0},
    [I(83,18)] = {64,0},
    [I(84,18)] = {64,0},
    [I(85,18)] = {64,0},
    [I(86,18)] = {64,0},
    [I(87,18)] = {64,0},
    [I(88,18)] = {64,0},
    [I(89,18)] = {64,0},
    [I(90,18)] = {64,0},
    [I(91,18)] = {64,0},
    [I(92,18)] = {64,0},
    [I(93,18)] = {64,0},
    [I(94,18)] = {64,0},
    [I(95,18)] = {64,0},
    [I(96,18)] = {64,0},
    [I(97,18)] = {64,0},
    [I(98,18)] = {64,0},
    [I(99,18)] = {64,0},
    [I(100,18)] = {64,0},
    [I(101,18)] = {64,0},
    [I(102,18)] = {64,0},
    [I(103,18)] = {64,0},
    [I(104,18)] = {64,0},
    [I(105,18)] = {64,0},
    [I(106,18)] = {64,0},
    [I(107,18)] = {64,0},
    [I(108,18)] = {64,0},
    [I(109,18)] = {64,0},
    [I(110,18)] = {64,0},
    [I(111,18)] = {64,0},
    [I(112,18)] = {64,0},
    [I(113,18)] = {64,0},
    [I(114,18)] = {64,0},
    [I(115,18)] = {64,0},
    [I(116,18)] = {64,0},
    [I(117,18)] = {64,0},
    [I(118,18)] = {64,0},
    [I(119,18)] = {64,0},
    [I(120,18)] = {64,0},
    [I(121,18)] = {64,0},
    [I(122,18)] = {64,0},
    [I(123,18)] = {64,0},
    [I(124,18)] = {64,0},
    [I(125,18)] = {64,0},
    [I(126,18)] = {64,0},
    [I(127,18)] = {64,0},
    [I(128,18)] = {64,0},
    [I(129,18)] = {64,0},
    [I(130,18)] = {64,0},
    [I(131,18)] = {64,0},
    [I(132,18)] = {64,0},
    [I(133,18)] = {64,0},
    [I(134,18)] = {64,0},
    [I(135,18)] = {64,0},
    [I(136,18)] = {64,0},
    [I(137,18)] = {64,0},
    [I(138,18)] = {64,0},
    [I(139,18)] = {64,0},
    [I(140,18)] = {64,0},
    [I(141,18)] = {64,0},
    [I(142,18)] = {64,0},
    [I(143,18)] = {64,0},
    [I(144,18)] = {64,0},
    [I(145,18)] = {64,0},
    [I(146,18)] = {64,0},
    [I(147,18)] = {64,0},
    [I(148,18)] = {64,0},
    [I(149,18)] = {64,0},
    [I(150,18)] = {64,0},
    [I(151,18)] = {64,0},
    [I(152,18)] = {64,0},
    [I(153,18)] = {64,0},
    [I(154,18)] = {64,0},
    [I(155,18)] = {64,0},
    [I(156,18)] = {64,0},
    [I(157,18)] = {64,0},
    [I(158,18)] = {64,0},
    [I(159,18)] = {64,0},
    [I(160,18)] = {64,0},
    [I(161,18)] = {64,0},
    [I(162,18)] = {64,0},
    [I(163,18)] = {64,0},
    [I(164,18)] = {64,0},
    [I(165,18)] = {64,0},
    [I(166,18)] = {64,0},
    [I(167,18)] = {64,0},
    [I(168,18)] = {64,0},
    [I(169,18)] = {64,0},
    [I(170,18)] = {64,0},
    [I(171,18)] = {64,0},
    [I(172,18)] = {64,0},
    [I(173,18)] = {64,0},
    [I(174,18)] = {64,0},
    [I(175,18)] = {64,0},
    [I(176,18)] = {64,0},
    [I(177,18)] = {64,0},
    [I(178,18)] = {64,0},
    [I(179,18)] = {64,0},
    [I(180,18)] = {64,0},
    [I(181,18)] = {64,0},
    [I(182,18)] = {64,0},
    [I(183,18)] = {64,0},
    [I(184,18)] = {64,0},
    [I(185,18)] = {64,0},
    [I(186,18)] = {64,0},
    [I(187,18)] = {64,0},
    [I(188,18)] = {64,0},
    [I(189,18)] = {64,0},
    [I(190,18)] = {64,0},
    [I(191,18)] = {64,0},
    [I(192,18)] = {64,0},
    [I(193,18)] = {64,0},
    [I(194,18)] = {64,0},
    [I(195,18)] = {64,0},
    [I(196,18)] = {64,0},
    [I(197,18)] = {64,0},
    [I(198,18)] = {64,0},
    [I(199,18)] = {64,0},
    [I(200,18)] = {64,0},
    [I(201,18)] = {64,0},
    [I(202,18)] = {64,0},
    [I(203,18)] = {64,0},
    [I(204,18)] = {64,0},
    [I(205,18)] = {64,0},
    [I(206,18)] = {64,0},
    [I(207,18)] = {64,0},
    [I(208,18)] = {64,0},
    [I(209,18)] = {64,0},
    [I(210,18)] = {64,0},
    [I(211,18)] = {64,0},
    [I(212,18)] = {64,0},
    [I(213,18)] = {64,0},
    [I(214,18)] = {64,0},
    [I(215,18)] = {64,0},
    [I(216,18)] = {64,0},
    [I(217,18)] = {64,0},
    [I(218,18)] = {64,0},
    [I(219,18)] = {64,0},
    [I(220,18)] = {64,0},
    [I(221,18)] = {64,0},
    [I(222,18)] = {64,0},
    [I(223,18)] = {64,0},
    [I(224,18)] = {64,0},
    [I(225,18)] = {64,0},
    [I(226,18)] = {64,0},
    [I(227,18)] = {64,0},
    [I(228,18)] = {64,0},
    [I(229,18)] = {64,0},
    [I(230,18)] = {64,0},
    [I(231,18)] = {64,0},
    [I(232,18)] = {64,0},
    [I(233,18)] = {64,0},
    [I(234,18)] = {64,0},
    [I(235,18)] = {64,0},
    [I(236,18)] = {64,0},
    [I(237,18)] = {64,0},
    [I(238,18)] = {64,0},
    [I(239,18)] = {64,0},
    [I(240,18)] = {64,0},
    [I(241,18)] = {64,0},
    [I(242,18)] = {64,0},
    [I(243,18)] = {64,0},
    [I(244,18)] = {64,0},
    [I(245,18)] = {64,0},
    [I(246,18)] = {64,0},
    [I(247,18)] = {64,0},
    [I(248,18)] = {64,0},
    [I(249,18)] = {64,0},
    [I(250,18)] = {64,0},
    [I(251,18)] = {64,0},
    [I(252,18)] = {64,0},
    [I(253,18)] = {64,0},
    [I(254,18)] = {64,0},
    [I(255,18)] = {64,0},
    [I(0,19)] = {64,0},
    [I(1,19)] = {64,0},
    [I(2,19)] = {64,0},
    [I(3,19)] = {64,0},
    [I(4,19)] = {64,0},
    [I(5,19)] = {64,0},
    [I(6,19)] = {64,0},
    [I(7,19)] = {64,0},
    [I(8,19)] = {64,0},
    [I(9,19)] = {64,0},
    [I(10,19)] = {64,0},
    [I(11,19)] = {64,0},
    [I(12,19)] = {64,0},
    [I(13,19)] = {64,0},
    [I(14,19)] = {64,0},
    [I(15,19)] = {64,0},
    [I(16,19)] = {64,0},
    [I(17,19)] = {64,0},
    [I(18,19)] = {64,0},
    [I(19,19)] = {64,0},
    [I(20,19)] = {64,0},
    [I(21,19)] = {64,0},
    [I(22,19)] = {64,0},
    [I(23,19)] = {64,0},
    [I(24,19)] = {64,0},
    [I(25,19)] = {64,0},
    [I(26,19)] = {64,0},
    [I(27,19)] = {64,0},
    [I(28,19)] = {64,0},
    [I(29,19)] = {64,0},
    [I(30,19)] = {64,0},
    [I(31,19)] = {64,0},
    [I(32,19)] = {64,0},
    [I(33,19)] = {64,0},
    [I(34,19)] = {64,0},
    [I(35,19)] = {64,0},
    [I(36,19)] = {64,0},
    [I(37,19)] = {64,0},
    [I(38,19)] = {64,0},
    [I(39,19)] = {64,0},
    [I(40,19)] = {64,0},
    [I(41,19)] = {64,0},
    [I(42,19)] = {64,0},
    [I(43,19)] = {64,0},
    [I(44,19)] = {64,0},
    [I(45,19)] = {64,0},
    [I(46,19)] = {64,0},
    [I(47,19)] = {64,0},
    [I(48,19)] = {64,0},
    [I(49,19)] = {64,0},
    [I(50,19)] = {64,0},
    [I(51,19)] = {64,0},
    [I(52,19)] = {64,0},
    [I(53,19)] = {64,0},
    [I(54,19)] = {64,0},
    [I(55,19)] = {64,0},
    [I(56,19)] = {64,0},
    [I(57,19)] = {64,0},
    [I(58,19)] = {64,0},
    [I(59,19)] = {64,0},
    [I(60,19)] = {64,0},
    [I(61,19)] = {64,0},
    [I(62,19)] = {64,0},
    [I(63,19)] = {64,0},
    [I(64,19)] = {64,0},
    [I(65,19)] = {64,0},
    [I(66,19)] = {64,0},
    [I(67,19)] = {64,0},
    [I(68,19)] = {64,0},
    [I(69,19)] = {64,0},
    [I(70,19)] = {64,0},
    [I(71,19)] = {64,0},
    [I(72,19)] = {64,0},
    [I(73,19)] = {64,0},
    [I(74,19)] = {64,0},
    [I(75,19)] = {64,0},
    [I(76,19)] = {64,0},
    [I(77,19)] = {64,0},
    [I(78,19)] = {64,0},
    [I(79,19)] = {64,0},
    [I(80,19)] = {64,0},
    [I(81,19)] = {64,0},
    [I(82,19)] = {64,0},
    [I(83,19)] = {64,0},
    [I(84,19)] = {64,0},
    [I(85,19)] = {64,0},
    [I(86,19)] = {64,0},
    [I(87,19)] = {64,0},
    [I(88,19)] = {64,0},
    [I(89,19)] = {64,0},
    [I(90,19)] = {64,0},
    [I(91,19)] = {64,0},
    [I(92,19)] = {64,0},
    [I(93,19)] = {64,0},
    [I(94,19)] = {64,0},
    [I(95,19)] = {64,0},
    [I(96,19)] = {64,0},
    [I(97,19)] = {64,0},
    [I(98,19)] = {64,0},
    [I(99,19)] = {64,0},
    [I(100,19)] = {64,0},
    [I(101,19)] = {64,0},
    [I(102,19)] = {64,0},
    [I(103,19)] = {64,0},
    [I(104,19)] = {64,0},
    [I(105,19)] = {64,0},
    [I(106,19)] = {64,0},
    [I(107,19)] = {64,0},
    [I(108,19)] = {64,0},
    [I(109,19)] = {64,0},
    [I(110,19)] = {64,0},
    [I(111,19)] = {64,0},
    [I(112,19)] = {64,0},
    [I(113,19)] = {64,0},
    [I(114,19)] = {64,0},
    [I(115,19)] = {64,0},
    [I(116,19)] = {64,0},
    [I(117,19)] = {64,0},
    [I(118,19)] = {64,0},
    [I(119,19)] = {64,0},
    [I(120,19)] = {64,0},
    [I(121,19)] = {64,0},
    [I(122,19)] = {64,0},
    [I(123,19)] = {64,0},
    [I(124,19)] = {64,0},
    [I(125,19)] = {64,0},
    [I(126,19)] = {64,0},
    [I(127,19)] = {64,0},
    [I(128,19)] = {64,0},
    [I(129,19)] = {64,0},
    [I(130,19)] = {64,0},
    [I(131,19)] = {64,0},
    [I(132,19)] = {64,0},
    [I(133,19)] = {64,0},
    [I(134,19)] = {64,0},
    [I(135,19)] = {64,0},
    [I(136,19)] = {64,0},
    [I(137,19)] = {64,0},
    [I(138,19)] = {64,0},
    [I(139,19)] = {64,0},
    [I(140,19)] = {64,0},
    [I(141,19)] = {64,0},
    [I(142,19)] = {64,0},
    [I(143,19)] = {64,0},
    [I(144,19)] = {64,0},
    [I(145,19)] = {64,0},
    [I(146,19)] = {64,0},
    [I(147,19)] = {64,0},
    [I(148,19)] = {64,0},
    [I(149,19)] = {64,0},
    [I(150,19)] = {64,0},
    [I(151,19)] = {64,0},
    [I(152,19)] = {64,0},
    [I(153,19)] = {64,0},
    [I(154,19)] = {64,0},
    [I(155,19)] = {64,0},
    [I(156,19)] = {64,0},
    [I(157,19)] = {64,0},
    [I(158,19)] = {64,0},
    [I(159,19)] = {64,0},
    [I(160,19)] = {64,0},
    [I(161,19)] = {64,0},
    [I(162,19)] = {64,0},
    [I(163,19)] = {64,0},
    [I(164,19)] = {64,0},
    [I(165,19)] = {64,0},
    [I(166,19)] = {64,0},
    [I(167,19)] = {64,0},
    [I(168,19)] = {64,0},
    [I(169,19)] = {64,0},
    [I(170,19)] = {64,0},
    [I(171,19)] = {64,0},
    [I(172,19)] = {64,0},
    [I(173,19)] = {64,0},
    [I(174,19)] = {64,0},
    [I(175,19)] = {64,0},
    [I(176,19)] = {64,0},
    [I(177,19)] = {64,0},
    [I(178,19)] = {64,0},
    [I(179,19)] = {64,0},
    [I(180,19)] = {64,0},
    [I(181,19)] = {64,0},
    [I(182,19)] = {64,0},
    [I(183,19)] = {64,0},
    [I(184,19)] = {64,0},
    [I(185,19)] = {64,0},
    [I(186,19)] = {64,0},
    [I(187,19)] = {64,0},
    [I(188,19)] = {64,0},
    [I(189,19)] = {64,0},
    [I(190,19)] = {64,0},
    [I(191,19)] = {64,0},
    [I(192,19)] = {64,0},
    [I(193,19)] = {64,0},
    [I(194,19)] = {64,0},
    [I(195,19)] = {64,0},
    [I(196,19)] = {64,0},
    [I(197,19)] = {64,0},
    [I(198,19)] = {64,0},
    [I(199,19)] = {64,0},
    [I(200,19)] = {64,0},
    [I(201,19)] = {64,0},
    [I(202,19)] = {64,0},
    [I(203,19)] = {64,0},
    [I(204,19)] = {64,0},
    [I(205,19)] = {64,0},
    [I(206,19)] = {64,0},
    [I(207,19)] = {64,0},
    [I(208,19)] = {64,0},
    [I(209,19)] = {64,0},
    [I(210,19)] = {64,0},
    [I(211,19)] = {64,0},
    [I(212,19)] = {64,0},
    [I(213,19)] = {64,0},
    [I(214,19)] = {64,0},
    [I(215,19)] = {64,0},
    [I(216,19)] = {64,0},
    [I(217,19)] = {64,0},
    [I(218,19)] = {64,0},
    [I(219,19)] = {64,0},
    [I(220,19)] = {64,0},
    [I(221,19)] = {64,0},
    [I(222,19)] = {64,0},
    [I(223,19)] = {64,0},
    [I(224,19)] = {64,0},
    [I(225,19)] = {64,0},
    [I(226,19)] = {64,0},
    [I(227,19)] = {64,0},
    [I(228,19)] = {64,0},
    [I(229,19)] = {64,0},
    [I(230,19)] = {64,0},
    [I(231,19)] = {64,0},
    [I(232,19)] = {64,0},
    [I(233,19)] = {64,0},
    [I(234,19)] = {64,0},
    [I(235,19)] = {64,0},
    [I(236,19)] = {64,0},
    [I(237,19)] = {64,0},
    [I(238,19)] = {64,0},
    [I(239,19)] = {64,0},
    [I(240,19)] = {64,0},
    [I(241,19)] = {64,0},
    [I(242,19)] = {64,0},
    [I(243,19)] = {64,0},
    [I(244,19)] = {64,0},
    [I(245,19)] = {64,0},
    [I(246,19)] = {64,0},
    [I(247,19)] = {64,0},
    [I(248,19)] = {64,0},
    [I(249,19)] = {64,0},
    [I(250,19)] = {64,0},
    [I(251,19)] = {64,0},
    [I(252,19)] = {64,0},
    [I(253,19)] = {64,0},
    [I(254,19)] = {64,0},
    [I(255,19)] = {64,0},
    [I(0,20)] = {64,0},
    [I(1,20)] = {64,0},
    [I(2,20)] = {64,0},
    [I(3,20)] = {64,0},
    [I(4,20)] = {64,0},
    [I(5,20)] = {64,0},
    [I(6,20)] = {64,0},
    [I(7,20)] = {64,0},
    [I(8,20)] = {64,0},
    [I(9,20)] = {64,0},
    [I(10,20)] = {64,0},
    [I(11,20)] = {64,0},
    [I(12,20)] = {64,0},
    [I(13,20)] = {64,0},
    [I(14,20)] = {64,0},
    [I(15,20)] = {64,0},
    [I(16,20)] = {64,0},
    [I(17,20)] = {64,0},
    [I(18,20)] = {64,0},
    [I(19,20)] = {64,0},
    [I(20,20)] = {64,0},
    [I(21,20)] = {64,0},
    [I(22,20)] = {64,0},
    [I(23,20)] = {64,0},
    [I(24,20)] = {64,0},
    [I(25,20)] = {64,0},
    [I(26,20)] = {64,0},
    [I(27,20)] = {64,0},
    [I(28,20)] = {64,0},
    [I(29,20)] = {64,0},
    [I(30,20)] = {64,0},
    [I(31,20)] = {64,0},
    [I(32,20)] = {64,0},
    [I(33,20)] = {64,0},
    [I(34,20)] = {64,0},
    [I(35,20)] = {64,0},
    [I(36,20)] = {64,0},
    [I(37,20)] = {64,0},
    [I(38,20)] = {64,0},
    [I(39,20)] = {64,0},
    [I(40,20)] = {64,0},
    [I(41,20)] = {64,0},
    [I(42,20)] = {64,0},
    [I(43,20)] = {64,0},
    [I(44,20)] = {64,0},
    [I(45,20)] = {64,0},
    [I(46,20)] = {64,0},
    [I(47,20)] = {64,0},
    [I(48,20)] = {64,0},
    [I(49,20)] = {64,0},
    [I(50,20)] = {64,0},
    [I(51,20)] = {64,0},
    [I(52,20)] = {64,0},
    [I(53,20)] = {64,0},
    [I(54,20)] = {64,0},
    [I(55,20)] = {64,0},
    [I(56,20)] = {64,0},
    [I(57,20)] = {64,0},
    [I(58,20)] = {64,0},
    [I(59,20)] = {64,0},
    [I(60,20)] = {64,0},
    [I(61,20)] = {64,0},
    [I(62,20)] = {64,0},
    [I(63,20)] = {64,0},
    [I(64,20)] = {64,0},
    [I(65,20)] = {64,0},
    [I(66,20)] = {64,0},
    [I(67,20)] = {64,0},
    [I(68,20)] = {64,0},
    [I(69,20)] = {64,0},
    [I(70,20)] = {64,0},
    [I(71,20)] = {64,0},
    [I(72,20)] = {64,0},
    [I(73,20)] = {64,0},
    [I(74,20)] = {64,0},
    [I(75,20)] = {64,0},
    [I(76,20)] = {64,0},
    [I(77,20)] = {64,0},
    [I(78,20)] = {64,0},
    [I(79,20)] = {64,0},
    [I(80,20)] = {64,0},
    [I(81,20)] = {64,0},
    [I(82,20)] = {64,0},
    [I(83,20)] = {64,0},
    [I(84,20)] = {64,0},
    [I(85,20)] = {64,0},
    [I(86,20)] = {64,0},
    [I(87,20)] = {64,0},
    [I(88,20)] = {64,0},
    [I(89,20)] = {64,0},
    [I(90,20)] = {64,0},
    [I(91,20)] = {64,0},
    [I(92,20)] = {64,0},
    [I(93,20)] = {64,0},
    [I(94,20)] = {64,0},
    [I(95,20)] = {64,0},
    [I(96,20)] = {64,0},
    [I(97,20)] = {64,0},
    [I(98,20)] = {64,0},
    [I(99,20)] = {64,0},
    [I(100,20)] = {64,0},
    [I(101,20)] = {64,0},
    [I(102,20)] = {64,0},
    [I(103,20)] = {64,0},
    [I(104,20)] = {64,0},
    [I(105,20)] = {64,0},
    [I(106,20)] = {64,0},
    [I(107,20)] = {64,0},
    [I(108,20)] = {64,0},
    [I(109,20)] = {64,0},
    [I(110,20)] = {64,0},
    [I(111,20)] = {64,0},
    [I(112,20)] = {64,0},
    [I(113,20)] = {64,0},
    [I(114,20)] = {64,0},
    [I(115,20)] = {64,0},
    [I(116,20)] = {64,0},
    [I(117,20)] = {64,0},
    [I(118,20)] = {64,0},
    [I(119,20)] = {64,0},
    [I(120,20)] = {64,0},
    [I(121,20)] = {64,0},
    [I(122,20)] = {64,0},
    [I(123,20)] = {64,0},
    [I(124,20)] = {64,0},
    [I(125,20)] = {64,0},
    [I(126,20)] = {64,0},
    [I(127,20)] = {64,0},
    [I(128,20)] = {64,0},
    [I(129,20)] = {64,0},
    [I(130,20)] = {64,0},
    [I(131,20)] = {64,0},
    [I(132,20)] = {64,0},
    [I(133,20)] = {64,0},
    [I(134,20)] = {64,0},
    [I(135,20)] = {64,0},
    [I(136,20)] = {64,0},
    [I(137,20)] = {64,0},
    [I(138,20)] = {64,0},
    [I(139,20)] = {64,0},
    [I(140,20)] = {64,0},
    [I(141,20)] = {64,0},
    [I(142,20)] = {64,0},
    [I(143,20)] = {64,0},
    [I(144,20)] = {64,0},
    [I(145,20)] = {64,0},
    [I(146,20)] = {64,0},
    [I(147,20)] = {64,0},
    [I(148,20)] = {64,0},
    [I(149,20)] = {64,0},
    [I(150,20)] = {64,0},
    [I(151,20)] = {64,0},
    [I(152,20)] = {64,0},
    [I(153,20)] = {64,0},
    [I(154,20)] = {64,0},
    [I(155,20)] = {64,0},
    [I(156,20)] = {64,0},
    [I(157,20)] = {64,0},
    [I(158,20)] = {64,0},
    [I(159,20)] = {64,0},
    [I(160,20)] = {64,0},
    [I(161,20)] = {64,0},
    [I(162,20)] = {64,0},
    [I(163,20)] = {64,0},
    [I(164,20)] = {64,0},
    [I(165,20)] = {64,0},
    [I(166,20)] = {64,0},
    [I(167,20)] = {64,0},
    [I(168,20)] = {64,0},
    [I(169,20)] = {64,0},
    [I(170,20)] = {64,0},
    [I(171,20)] = {64,0},
    [I(172,20)] = {64,0},
    [I(173,20)] = {64,0},
    [I(174,20)] = {64,0},
    [I(175,20)] = {64,0},
    [I(176,20)] = {64,0},
    [I(177,20)] = {64,0},
    [I(178,20)] = {64,0},
    [I(179,20)] = {64,0},
    [I(180,20)] = {64,0},
    [I(181,20)] = {64,0},
    [I(182,20)] = {64,0},
    [I(183,20)] = {64,0},
    [I(184,20)] = {64,0},
    [I(185,20)] = {64,0},
    [I(186,20)] = {64,0},
    [I(187,20)] = {64,0},
    [I(188,20)] = {64,0},
    [I(189,20)] = {64,0},
    [I(190,20)] = {64,0},
    [I(191,20)] = {64,0},
    [I(192,20)] = {64,0},
    [I(193,20)] = {64,0},
    [I(194,20)] = {64,0},
    [I(195,20)] = {64,0},
    [I(196,20)] = {64,0},
    [I(197,20)] = {64,0},
    [I(198,20)] = {64,0},
    [I(199,20)] = {64,0},
    [I(200,20)] = {64,0},
    [I(201,20)] = {64,0},
    [I(202,20)] = {64,0},
    [I(203,20)] = {64,0},
    [I(204,20)] = {64,0},
    [I(205,20)] = {64,0},
    [I(206,20)] = {64,0},
    [I(207,20)] = {64,0},
    [I(208,20)] = {64,0},
    [I(209,20)] = {64,0},
    [I(210,20)] = {64,0},
    [I(211,20)] = {64,0},
    [I(212,20)] = {64,0},
    [I(213,20)] = {64,0},
    [I(214,20)] = {64,0},
    [I(215,20)] = {64,0},
    [I(216,20)] = {64,0},
    [I(217,20)] = {64,0},
    [I(218,20)] = {64,0},
    [I(219,20)] = {64,0},
    [I(220,20)] = {64,0},
    [I(221,20)] = {64,0},
    [I(222,20)] = {64,0},
    [I(223,20)] = {64,0},
    [I(224,20)] = {64,0},
    [I(225,20)] = {64,0},
    [I(226,20)] = {64,0},
    [I(227,20)] = {64,0},
    [I(228,20)] = {64,0},
    [I(229,20)] = {64,0},
    [I(230,20)] = {64,0},
    [I(231,20)] = {64,0},
    [I(232,20)] = {64,0},
    [I(233,20)] = {64,0},
    [I(234,20)] = {64,0},
    [I(235,20)] = {64,0},
    [I(236,20)] = {64,0},
    [I(237,20)] = {64,0},
    [I(238,20)] = {64,0},
    [I(239,20)] = {64,0},
    [I(240,20)] = {64,0},
    [I(241,20)] = {64,0},
    [I(242,20)] = {64,0},
    [I(243,20)] = {64,0},
    [I(244,20)] = {64,0},
    [I(245,20)] = {64,0},
    [I(246,20)] = {64,0},
    [I(247,20)] = {64,0},
    [I(248,20)] = {64,0},
    [I(249,20)] = {64,0},
    [I(250,20)] = {64,0},
    [I(251,20)] = {64,0},
    [I(252,20)] = {64,0},
    [I(253,20)] = {64,0},
    [I(254,20)] = {64,0},
    [I(255,20)] = {64,0},
    [I(0,21)] = {64,0},
    [I(1,21)] = {64,0},
    [I(2,21)] = {64,0},
    [I(3,21)] = {64,0},
    [I(4,21)] = {64,0},
    [I(5,21)] = {64,0},
    [I(6,21)] = {64,0},
    [I(7,21)] = {64,0},
    [I(8,21)] = {64,0},
    [I(9,21)] = {64,0},
    [I(10,21)] = {64,0},
    [I(11,21)] = {64,0},
    [I(12,21)] = {64,0},
    [I(13,21)] = {64,0},
    [I(14,21)] = {64,0},
    [I(15,21)] = {64,0},
    [I(16,21)] = {64,0},
    [I(17,21)] = {64,0},
    [I(18,21)] = {64,0},
    [I(19,21)] = {64,0},
    [I(20,21)] = {64,0},
    [I(21,21)] = {64,0},
    [I(22,21)] = {64,0},
    [I(23,21)] = {64,0},
    [I(24,21)] = {64,0},
    [I(25,21)] = {64,0},
    [I(26,21)] = {64,0},
    [I(27,21)] = {64,0},
    [I(28,21)] = {64,0},
    [I(29,21)] = {64,0},
    [I(30,21)] = {64,0},
    [I(31,21)] = {64,0},
    [I(32,21)] = {64,0},
    [I(33,21)] = {64,0},
    [I(34,21)] = {64,0},
    [I(35,21)] = {64,0},
    [I(36,21)] = {64,0},
    [I(37,21)] = {64,0},
    [I(38,21)] = {64,0},
    [I(39,21)] = {64,0},
    [I(40,21)] = {64,0},
    [I(41,21)] = {64,0},
    [I(42,21)] = {64,0},
    [I(43,21)] = {64,0},
    [I(44,21)] = {64,0},
    [I(45,21)] = {64,0},
    [I(46,21)] = {64,0},
    [I(47,21)] = {64,0},
    [I(48,21)] = {64,0},
    [I(49,21)] = {64,0},
    [I(50,21)] = {64,0},
    [I(51,21)] = {64,0},
    [I(52,21)] = {64,0},
    [I(53,21)] = {64,0},
    [I(54,21)] = {64,0},
    [I(55,21)] = {64,0},
    [I(56,21)] = {64,0},
    [I(57,21)] = {64,0},
    [I(58,21)] = {64,0},
    [I(59,21)] = {64,0},
    [I(60,21)] = {64,0},
    [I(61,21)] = {64,0},
    [I(62,21)] = {64,0},
    [I(63,21)] = {64,0},
    [I(64,21)] = {64,0},
    [I(65,21)] = {64,0},
    [I(66,21)] = {64,0},
    [I(67,21)] = {64,0},
    [I(68,21)] = {64,0},
    [I(69,21)] = {64,0},
    [I(70,21)] = {64,0},
    [I(71,21)] = {64,0},
    [I(72,21)] = {64,0},
    [I(73,21)] = {64,0},
    [I(74,21)] = {64,0},
    [I(75,21)] = {64,0},
    [I(76,21)] = {64,0},
    [I(77,21)] = {64,0},
    [I(78,21)] = {64,0},
    [I(79,21)] = {64,0},
    [I(80,21)] = {64,0},
    [I(81,21)] = {64,0},
    [I(82,21)] = {64,0},
    [I(83,21)] = {64,0},
    [I(84,21)] = {64,0},
    [I(85,21)] = {64,0},
    [I(86,21)] = {64,0},
    [I(87,21)] = {64,0},
    [I(88,21)] = {64,0},
    [I(89,21)] = {64,0},
    [I(90,21)] = {64,0},
    [I(91,21)] = {64,0},
    [I(92,21)] = {64,0},
    [I(93,21)] = {64,0},
    [I(94,21)] = {64,0},
    [I(95,21)] = {64,0},
    [I(96,21)] = {64,0},
    [I(97,21)] = {64,0},
    [I(98,21)] = {64,0},
    [I(99,21)] = {64,0},
    [I(100,21)] = {64,0},
    [I(101,21)] = {64,0},
    [I(102,21)] = {64,0},
    [I(103,21)] = {64,0},
    [I(104,21)] = {64,0},
    [I(105,21)] = {64,0},
    [I(106,21)] = {64,0},
    [I(107,21)] = {64,0},
    [I(108,21)] = {64,0},
    [I(109,21)] = {64,0},
    [I(110,21)] = {64,0},
    [I(111,21)] = {64,0},
    [I(112,21)] = {64,0},
    [I(113,21)] = {64,0},
    [I(114,21)] = {64,0},
    [I(115,21)] = {64,0},
    [I(116,21)] = {64,0},
    [I(117,21)] = {64,0},
    [I(118,21)] = {64,0},
    [I(119,21)] = {64,0},
    [I(120,21)] = {64,0},
    [I(121,21)] = {64,0},
    [I(122,21)] = {64,0},
    [I(123,21)] = {64,0},
    [I(124,21)] = {64,0},
    [I(125,21)] = {64,0},
    [I(126,21)] = {64,0},
    [I(127,21)] = {64,0},
    [I(128,21)] = {64,0},
    [I(129,21)] = {64,0},
    [I(130,21)] = {64,0},
    [I(131,21)] = {64,0},
    [I(132,21)] = {64,0},
    [I(133,21)] = {64,0},
    [I(134,21)] = {64,0},
    [I(135,21)] = {64,0},
    [I(136,21)] = {64,0},
    [I(137,21)] = {64,0},
    [I(138,21)] = {64,0},
    [I(139,21)] = {64,0},
    [I(140,21)] = {64,0},
    [I(141,21)] = {64,0},
    [I(142,21)] = {64,0},
    [I(143,21)] = {64,0},
    [I(144,21)] = {64,0},
    [I(145,21)] = {64,0},
    [I(146,21)] = {64,0},
    [I(147,21)] = {64,0},
    [I(148,21)] = {64,0},
    [I(149,21)] = {64,0},
    [I(150,21)] = {64,0},
    [I(151,21)] = {64,0},
    [I(152,21)] = {64,0},
    [I(153,21)] = {64,0},
    [I(154,21)] = {64,0},
    [I(155,21)] = {64,0},
    [I(156,21)] = {64,0},
    [I(157,21)] = {64,0},
    [I(158,21)] = {64,0},
    [I(159,21)] = {64,0},
    [I(160,21)] = {64,0},
    [I(161,21)] = {64,0},
    [I(162,21)] = {64,0},
    [I(163,21)] = {64,0},
    [I(164,21)] = {64,0},
    [I(165,21)] = {64,0},
    [I(166,21)] = {64,0},
    [I(167,21)] = {64,0},
    [I(168,21)] = {64,0},
    [I(169,21)] = {64,0},
    [I(170,21)] = {64,0},
    [I(171,21)] = {64,0},
    [I(172,21)] = {64,0},
    [I(173,21)] = {64,0},
    [I(174,21)] = {64,0},
    [I(175,21)] = {64,0},
    [I(176,21)] = {64,0},
    [I(177,21)] = {64,0},
    [I(178,21)] = {64,0},
    [I(179,21)] = {64,0},
    [I(180,21)] = {64,0},
    [I(181,21)] = {64,0},
    [I(182,21)] = {64,0},
    [I(183,21)] = {64,0},
    [I(184,21)] = {64,0},
    [I(185,21)] = {64,0},
    [I(186,21)] = {64,0},
    [I(187,21)] = {64,0},
    [I(188,21)] = {64,0},
    [I(189,21)] = {64,0},
    [I(190,21)] = {64,0},
    [I(191,21)] = {64,0},
    [I(192,21)] = {64,0},
    [I(193,21)] = {64,0},
    [I(194,21)] = {64,0},
    [I(195,21)] = {64,0},
    [I(196,21)] = {64,0},
    [I(197,21)] = {64,0},
    [I(198,21)] = {64,0},
    [I(199,21)] = {64,0},
    [I(200,21)] = {64,0},
    [I(201,21)] = {64,0},
    [I(202,21)] = {64,0},
    [I(203,21)] = {64,0},
    [I(204,21)] = {64,0},
    [I(205,21)] = {64,0},
    [I(206,21)] = {64,0},
    [I(207,21)] = {64,0},
    [I(208,21)] = {64,0},
    [I(209,21)] = {64,0},
    [I(210,21)] = {64,0},
    [I(211,21)] = {64,0},
    [I(212,21)] = {64,0},
    [I(213,21)] = {64,0},
    [I(214,21)] = {64,0},
    [I(215,21)] = {64,0},
    [I(216,21)] = {64,0},
    [I(217,21)] = {64,0},
    [I(218,21)] = {64,0},
    [I(219,21)] = {64,0},
    [I(220,21)] = {64,0},
    [I(221,21)] = {64,0},
    [I(222,21)] = {64,0},
    [I(223,21)] = {64,0},
    [I(224,21)] = {64,0},
    [I(225,21)] = {64,0},
    [I(226,21)] = {64,0},
    [I(227,21)] = {64,0},
    [I(228,21)] = {64,0},
    [I(229,21)] = {64,0},
    [I(230,21)] = {64,0},
    [I(231,21)] = {64,0},
    [I(232,21)] = {64,0},
    [I(233,21)] = {64,0},
    [I(234,21)] = {64,0},
    [I(235,21)] = {64,0},
    [I(236,21)] = {64,0},
    [I(237,21)] = {64,0},
    [I(238,21)] = {64,0},
    [I(239,21)] = {64,0},
    [I(240,21)] = {64,0},
    [I(241,21)] = {64,0},
    [I(242,21)] = {64,0},
    [I(243,21)] = {64,0},
    [I(244,21)] = {64,0},
    [I(245,21)] = {64,0},
    [I(246,21)] = {64,0},
    [I(247,21)] = {64,0},
    [I(248,21)] = {64,0},
    [I(249,21)] = {64,0},
    [I(250,21)] = {64,0},
    [I(251,21)] = {64,0},
    [I(252,21)] = {64,0},
    [I(253,21)] = {64,0},
    [I(254,21)] = {64,0},
    [I(255,21)] = {64,0},
    [I(0,22)] = {64,0},
    [I(1,22)] = {64,0},
    [I(2,22)] = {64,0},
    [I(3,22)] = {64,0},
    [I(4,22)] = {64,0},
    [I(5,22)] = {64,0},
    [I(6,22)] = {64,0},
    [I(7,22)] = {64,0},
    [I(8,22)] = {64,0},
    [I(9,22)] = {64,0},
    [I(10,22)] = {64,0},
    [I(11,22)] = {64,0},
    [I(12,22)] = {64,0},
    [I(13,22)] = {64,0},
    [I(14,22)] = {64,0},
    [I(15,22)] = {64,0},
    [I(16,22)] = {64,0},
    [I(17,22)] = {64,0},
    [I(18,22)] = {64,0},
    [I(19,22)] = {64,0},
    [I(20,22)] = {64,0},
    [I(21,22)] = {64,0},
    [I(22,22)] = {64,0},
    [I(23,22)] = {64,0},
    [I(24,22)] = {64,0},
    [I(25,22)] = {64,0},
    [I(26,22)] = {64,0},
    [I(27,22)] = {64,0},
    [I(28,22)] = {64,0},
    [I(29,22)] = {64,0},
    [I(30,22)] = {64,0},
    [I(31,22)] = {64,0},
    [I(32,22)] = {64,0},
    [I(33,22)] = {64,0},
    [I(34,22)] = {64,0},
    [I(35,22)] = {64,0},
    [I(36,22)] = {64,0},
    [I(37,22)] = {64,0},
    [I(38,22)] = {64,0},
    [I(39,22)] = {64,0},
    [I(40,22)] = {64,0},
    [I(41,22)] = {64,0},
    [I(42,22)] = {64,0},
    [I(43,22)] = {64,0},
    [I(44,22)] = {64,0},
    [I(45,22)] = {64,0},
    [I(46,22)] = {64,0},
    [I(47,22)] = {64,0},
    [I(48,22)] = {64,0},
    [I(49,22)] = {64,0},
    [I(50,22)] = {64,0},
    [I(51,22)] = {64,0},
    [I(52,22)] = {64,0},
    [I(53,22)] = {64,0},
    [I(54,22)] = {64,0},
    [I(55,22)] = {64,0},
    [I(56,22)] = {64,0},
    [I(57,22)] = {64,0},
    [I(58,22)] = {64,0},
    [I(59,22)] = {64,0},
    [I(60,22)] = {64,0},
    [I(61,22)] = {64,0},
    [I(62,22)] = {64,0},
    [I(63,22)] = {64,0},
    [I(64,22)] = {64,0},
    [I(65,22)] = {64,0},
    [I(66,22)] = {64,0},
    [I(67,22)] = {64,0},
    [I(68,22)] = {64,0},
    [I(69,22)] = {64,0},
    [I(70,22)] = {64,0},
    [I(71,22)] = {64,0},
    [I(72,22)] = {64,0},
    [I(73,22)] = {64,0},
    [I(74,22)] = {64,0},
    [I(75,22)] = {64,0},
    [I(76,22)] = {64,0},
    [I(77,22)] = {64,0},
    [I(78,22)] = {64,0},
    [I(79,22)] = {64,0},
    [I(80,22)] = {64,0},
    [I(81,22)] = {64,0},
    [I(82,22)] = {64,0},
    [I(83,22)] = {64,0},
    [I(84,22)] = {64,0},
    [I(85,22)] = {64,0},
    [I(86,22)] = {64,0},
    [I(87,22)] = {64,0},
    [I(88,22)] = {64,0},
    [I(89,22)] = {64,0},
    [I(90,22)] = {64,0},
    [I(91,22)] = {64,0},
    [I(92,22)] = {64,0},
    [I(93,22)] = {64,0},
    [I(94,22)] = {64,0},
    [I(95,22)] = {64,0},
    [I(96,22)] = {64,0},
    [I(97,22)] = {64,0},
    [I(98,22)] = {64,0},
    [I(99,22)] = {64,0},
    [I(100,22)] = {64,0},
    [I(101,22)] = {64,0},
    [I(102,22)] = {64,0},
    [I(103,22)] = {64,0},
    [I(104,22)] = {64,0},
    [I(105,22)] = {64,0},
    [I(106,22)] = {64,0},
    [I(107,22)] = {64,0},
    [I(108,22)] = {64,0},
    [I(109,22)] = {64,0},
    [I(110,22)] = {64,0},
    [I(111,22)] = {64,0},
    [I(112,22)] = {64,0},
    [I(113,22)] = {64,0},
    [I(114,22)] = {64,0},
    [I(115,22)] = {64,0},
    [I(116,22)] = {64,0},
    [I(117,22)] = {64,0},
    [I(118,22)] = {64,0},
    [I(119,22)] = {64,0},
    [I(120,22)] = {64,0},
    [I(121,22)] = {64,0},
    [I(122,22)] = {64,0},
    [I(123,22)] = {64,0},
    [I(124,22)] = {64,0},
    [I(125,22)] = {64,0},
    [I(126,22)] = {64,0},
    [I(127,22)] = {64,0},
    [I(128,22)] = {64,0},
    [I(129,22)] = {64,0},
    [I(130,22)] = {64,0},
    [I(131,22)] = {64,0},
    [I(132,22)] = {64,0},
    [I(133,22)] = {64,0},
    [I(134,22)] = {64,0},
    [I(135,22)] = {64,0},
    [I(136,22)] = {64,0},
    [I(137,22)] = {64,0},
    [I(138,22)] = {64,0},
    [I(139,22)] = {64,0},
    [I(140,22)] = {64,0},
    [I(141,22)] = {64,0},
    [I(142,22)] = {64,0},
    [I(143,22)] = {64,0},
    [I(144,22)] = {64,0},
    [I(145,22)] = {64,0},
    [I(146,22)] = {64,0},
    [I(147,22)] = {64,0},
    [I(148,22)] = {64,0},
    [I(149,22)] = {64,0},
    [I(150,22)] = {64,0},
    [I(151,22)] = {64,0},
    [I(152,22)] = {64,0},
    [I(153,22)] = {64,0},
    [I(154,22)] = {64,0},
    [I(155,22)] = {64,0},
    [I(156,22)] = {64,0},
    [I(157,22)] = {64,0},
    [I(158,22)] = {64,0},
    [I(159,22)] = {64,0},
    [I(160,22)] = {64,0},
    [I(161,22)] = {64,0},
    [I(162,22)] = {64,0},
    [I(163,22)] = {64,0},
    [I(164,22)] = {64,0},
    [I(165,22)] = {64,0},
    [I(166,22)] = {64,0},
    [I(167,22)] = {64,0},
    [I(168,22)] = {64,0},
    [I(169,22)] = {64,0},
    [I(170,22)] = {64,0},
    [I(171,22)] = {64,0},
    [I(172,22)] = {64,0},
    [I(173,22)] = {64,0},
    [I(174,22)] = {64,0},
    [I(175,22)] = {64,0},
    [I(176,22)] = {64,0},
    [I(177,22)] = {64,0},
    [I(178,22)] = {64,0},
    [I(179,22)] = {64,0},
    [I(180,22)] = {64,0},
    [I(181,22)] = {64,0},
    [I(182,22)] = {64,0},
    [I(183,22)] = {64,0},
    [I(184,22)] = {64,0},
    [I(185,22)] = {64,0},
    [I(186,22)] = {64,0},
    [I(187,22)] = {64,0},
    [I(188,22)] = {64,0},
    [I(189,22)] = {64,0},
    [I(190,22)] = {64,0},
    [I(191,22)] = {64,0},
    [I(192,22)] = {64,0},
    [I(193,22)] = {64,0},
    [I(194,22)] = {64,0},
    [I(195,22)] = {64,0},
    [I(196,22)] = {64,0},
    [I(197,22)] = {64,0},
    [I(198,22)] = {64,0},
    [I(199,22)] = {64,0},
    [I(200,22)] = {64,0},
    [I(201,22)] = {64,0},
    [I(202,22)] = {64,0},
    [I(203,22)] = {64,0},
    [I(204,22)] = {64,0},
    [I(205,22)] = {64,0},
    [I(206,22)] = {64,0},
    [I(207,22)] = {64,0},
    [I(208,22)] = {64,0},
    [I(209,22)] = {64,0},
    [I(210,22)] = {64,0},
    [I(211,22)] = {64,0},
    [I(212,22)] = {64,0},
    [I(213,22)] = {64,0},
    [I(214,22)] = {64,0},
    [I(215,22)] = {64,0},
    [I(216,22)] = {64,0},
    [I(217,22)] = {64,0},
    [I(218,22)] = {64,0},
    [I(219,22)] = {64,0},
    [I(220,22)] = {64,0},
    [I(221,22)] = {64,0},
    [I(222,22)] = {64,0},
    [I(223,22)] = {64,0},
    [I(224,22)] = {64,0},
    [I(225,22)] = {64,0},
    [I(226,22)] = {64,0},
    [I(227,22)] = {64,0},
    [I(228,22)] = {64,0},
    [I(229,22)] = {64,0},
    [I(230,22)] = {64,0},
    [I(231,22)] = {64,0},
    [I(232,22)] = {64,0},
    [I(233,22)] = {64,0},
    [I(234,22)] = {64,0},
    [I(235,22)] = {64,0},
    [I(236,22)] = {64,0},
    [I(237,22)] = {64,0},
    [I(238,22)] = {64,0},
    [I(239,22)] = {64,0},
    [I(240,22)] = {64,0},
    [I(241,22)] = {64,0},
    [I(242,22)] = {64,0},
    [I(243,22)] = {64,0},
    [I(244,22)] = {64,0},
    [I(245,22)] = {64,0},
    [I(246,22)] = {64,0},
    [I(247,22)] = {64,0},
    [I(248,22)] = {64,0},
    [I(249,22)] = {64,0},
    [I(250,22)] = {64,0},
    [I(251,22)] = {64,0},
    [I(252,22)] = {64,0},
    [I(253,22)] = {64,0},
    [I(254,22)] = {64,0},
    [I(255,22)] = {64,0},
    [I(0,23)] = {64,0},
    [I(1,23)] = {64,0},
    [I(2,23)] = {64,0},
    [I(3,23)] = {64,0},
    [I(4,23)] = {64,0},
    [I(5,23)] = {64,0},
    [I(6,23)] = {64,0},
    [I(7,23)] = {64,0},
    [I(8,23)] = {64,0},
    [I(9,23)] = {64,0},
    [I(10,23)] = {64,0},
    [I(11,23)] = {64,0},
    [I(12,23)] = {64,0},
    [I(13,23)] = {64,0},
    [I(14,23)] = {64,0},
    [I(15,23)] = {64,0},
    [I(16,23)] = {64,0},
    [I(17,23)] = {64,0},
    [I(18,23)] = {64,0},
    [I(19,23)] = {64,0},
    [I(20,23)] = {64,0},
    [I(21,23)] = {64,0},
    [I(22,23)] = {64,0},
    [I(23,23)] = {64,0},
    [I(24,23)] = {64,0},
    [I(25,23)] = {64,0},
    [I(26,23)] = {64,0},
    [I(27,23)] = {64,0},
    [I(28,23)] = {64,0},
    [I(29,23)] = {64,0},
    [I(30,23)] = {64,0},
    [I(31,23)] = {64,0},
    [I(32,23)] = {64,0},
    [I(33,23)] = {64,0},
    [I(34,23)] = {64,0},
    [I(35,23)] = {64,0},
    [I(36,23)] = {64,0},
    [I(37,23)] = {64,0},
    [I(38,23)] = {64,0},
    [I(39,23)] = {64,0},
    [I(40,23)] = {64,0},
    [I(41,23)] = {64,0},
    [I(42,23)] = {64,0},
    [I(43,23)] = {64,0},
    [I(44,23)] = {64,0},
    [I(45,23)] = {64,0},
    [I(46,23)] = {64,0},
    [I(47,23)] = {64,0},
    [I(48,23)] = {64,0},
    [I(49,23)] = {64,0},
    [I(50,23)] = {64,0},
    [I(51,23)] = {64,0},
    [I(52,23)] = {64,0},
    [I(53,23)] = {64,0},
    [I(54,23)] = {64,0},
    [I(55,23)] = {64,0},
    [I(56,23)] = {64,0},
    [I(57,23)] = {64,0},
    [I(58,23)] = {64,0},
    [I(59,23)] = {64,0},
    [I(60,23)] = {64,0},
    [I(61,23)] = {64,0},
    [I(62,23)] = {64,0},
    [I(63,23)] = {64,0},
    [I(64,23)] = {64,0},
    [I(65,23)] = {64,0},
    [I(66,23)] = {64,0},
    [I(67,23)] = {64,0},
    [I(68,23)] = {64,0},
    [I(69,23)] = {64,0},
    [I(70,23)] = {64,0},
    [I(71,23)] = {64,0},
    [I(72,23)] = {64,0},
    [I(73,23)] = {64,0},
    [I(74,23)] = {64,0},
    [I(75,23)] = {64,0},
    [I(76,23)] = {64,0},
    [I(77,23)] = {64,0},
    [I(78,23)] = {64,0},
    [I(79,23)] = {64,0},
    [I(80,23)] = {64,0},
    [I(81,23)] = {64,0},
    [I(82,23)] = {64,0},
    [I(83,23)] = {64,0},
    [I(84,23)] = {64,0},
    [I(85,23)] = {64,0},
    [I(86,23)] = {64,0},
    [I(87,23)] = {64,0},
    [I(88,23)] = {64,0},
    [I(89,23)] = {64,0},
    [I(90,23)] = {64,0},
    [I(91,23)] = {64,0},
    [I(92,23)] = {64,0},
    [I(93,23)] = {64,0},
    [I(94,23)] = {64,0},
    [I(95,23)] = {64,0},
    [I(96,23)] = {64,0},
    [I(97,23)] = {64,0},
    [I(98,23)] = {64,0},
    [I(99,23)] = {64,0},
    [I(100,23)] = {64,0},
    [I(101,23)] = {64,0},
    [I(102,23)] = {64,0},
    [I(103,23)] = {64,0},
    [I(104,23)] = {64,0},
    [I(105,23)] = {64,0},
    [I(106,23)] = {64,0},
    [I(107,23)] = {64,0},
    [I(108,23)] = {64,0},
    [I(109,23)] = {64,0},
    [I(110,23)] = {64,0},
    [I(111,23)] = {64,0},
    [I(112,23)] = {64,0},
    [I(113,23)] = {64,0},
    [I(114,23)] = {64,0},
    [I(115,23)] = {64,0},
    [I(116,23)] = {64,0},
    [I(117,23)] = {64,0},
    [I(118,23)] = {64,0},
    [I(119,23)] = {64,0},
    [I(120,23)] = {64,0},
    [I(121,23)] = {64,0},
    [I(122,23)] = {64,0},
    [I(123,23)] = {64,0},
    [I(124,23)] = {64,0},
    [I(125,23)] = {64,0},
    [I(126,23)] = {64,0},
    [I(127,23)] = {64,0},
    [I(128,23)] = {64,0},
    [I(129,23)] = {64,0},
    [I(130,23)] = {64,0},
    [I(131,23)] = {64,0},
    [I(132,23)] = {64,0},
    [I(133,23)] = {64,0},
    [I(134,23)] = {64,0},
    [I(135,23)] = {64,0},
    [I(136,23)] = {64,0},
    [I(137,23)] = {64,0},
    [I(138,23)] = {64,0},
    [I(139,23)] = {64,0},
    [I(140,23)] = {64,0},
    [I(141,23)] = {64,0},
    [I(142,23)] = {64,0},
    [I(143,23)] = {64,0},
    [I(144,23)] = {64,0},
    [I(145,23)] = {64,0},
    [I(146,23)] = {64,0},
    [I(147,23)] = {64,0},
    [I(148,23)] = {64,0},
    [I(149,23)] = {64,0},
    [I(150,23)] = {64,0},
    [I(151,23)] = {64,0},
    [I(152,23)] = {64,0},
    [I(153,23)] = {64,0},
    [I(154,23)] = {64,0},
    [I(155,23)] = {64,0},
    [I(156,23)] = {64,0},
    [I(157,23)] = {64,0},
    [I(158,23)] = {64,0},
    [I(159,23)] = {64,0},
    [I(160,23)] = {64,0},
    [I(161,23)] = {64,0},
    [I(162,23)] = {64,0},
    [I(163,23)] = {64,0},
    [I(164,23)] = {64,0},
    [I(165,23)] = {64,0},
    [I(166,23)] = {64,0},
    [I(167,23)] = {64,0},
    [I(168,23)] = {64,0},
    [I(169,23)] = {64,0},
    [I(170,23)] = {64,0},
    [I(171,23)] = {64,0},
    [I(172,23)] = {64,0},
    [I(173,23)] = {64,0},
    [I(174,23)] = {64,0},
    [I(175,23)] = {64,0},
    [I(176,23)] = {64,0},
    [I(177,23)] = {64,0},
    [I(178,23)] = {64,0},
    [I(179,23)] = {64,0},
    [I(180,23)] = {64,0},
    [I(181,23)] = {64,0},
    [I(182,23)] = {64,0},
    [I(183,23)] = {64,0},
    [I(184,23)] = {64,0},
    [I(185,23)] = {64,0},
    [I(186,23)] = {64,0},
    [I(187,23)] = {64,0},
    [I(188,23)] = {64,0},
    [I(189,23)] = {64,0},
    [I(190,23)] = {64,0},
    [I(191,23)] = {64,0},
    [I(192,23)] = {64,0},
    [I(193,23)] = {64,0},
    [I(194,23)] = {64,0},
    [I(195,23)] = {64,0},
    [I(196,23)] = {64,0},
    [I(197,23)] = {64,0},
    [I(198,23)] = {64,0},
    [I(199,23)] = {64,0},
    [I(200,23)] = {64,0},
    [I(201,23)] = {64,0},
    [I(202,23)] = {64,0},
    [I(203,23)] = {64,0},
    [I(204,23)] = {64,0},
    [I(205,23)] = {64,0},
    [I(206,23)] = {64,0},
    [I(207,23)] = {64,0},
    [I(208,23)] = {64,0},
    [I(209,23)] = {64,0},
    [I(210,23)] = {64,0},
    [I(211,23)] = {64,0},
    [I(212,23)] = {64,0},
    [I(213,23)] = {64,0},
    [I(214,23)] = {64,0},
    [I(215,23)] = {64,0},
    [I(216,23)] = {64,0},
    [I(217,23)] = {64,0},
    [I(218,23)] = {64,0},
    [I(219,23)] = {64,0},
    [I(220,23)] = {64,0},
    [I(221,23)] = {64,0},
    [I(222,23)] = {64,0},
    [I(223,23)] = {64,0},
    [I(224,23)] = {64,0},
    [I(225,23)] = {64,0},
    [I(226,23)] = {64,0},
    [I(227,23)] = {64,0},
    [I(228,23)] = {64,0},
    [I(229,23)] = {64,0},
    [I(230,23)] = {64,0},
    [I(231,23)] = {64,0},
    [I(232,23)] = {64,0},
    [I(233,23)] = {64,0},
    [I(234,23)] = {64,0},
    [I(235,23)] = {64,0},
    [I(236,23)] = {64,0},
    [I(237,23)] = {64,0},
    [I(238,23)] = {64,0},
    [I(239,23)] = {64,0},
    [I(240,23)] = {64,0},
    [I(241,23)] = {64,0},
    [I(242,23)] = {64,0},
    [I(243,23)] = {64,0},
    [I(244,23)] = {64,0},
    [I(245,23)] = {64,0},
    [I(246,23)] = {64,0},
    [I(247,23)] = {64,0},
    [I(248,23)] = {64,0},
    [I(249,23)] = {64,0},
    [I(250,23)] = {64,0},
    [I(251,23)] = {64,0},
    [I(252,23)] = {64,0},
    [I(253,23)] = {64,0},
    [I(254,23)] = {64,0},
    [I(255,23)] = {64,0},
    [I(0,24)] = {64,0},
    [I(1,24)] = {64,0},
    [I(2,24)] = {64,0},
    [I(3,24)] = {64,0},
    [I(4,24)] = {64,0},
    [I(5,24)] = {64,0},
    [I(6,24)] = {64,0},
    [I(7,24)] = {64,0},
    [I(8,24)] = {64,0},
    [I(9,24)] = {64,0},
    [I(10,24)] = {64,0},
    [I(11,24)] = {64,0},
    [I(12,24)] = {64,0},
    [I(13,24)] = {64,0},
    [I(14,24)] = {64,0},
    [I(15,24)] = {64,0},
    [I(16,24)] = {64,0},
    [I(17,24)] = {64,0},
    [I(18,24)] = {64,0},
    [I(19,24)] = {64,0},
    [I(20,24)] = {64,0},
    [I(21,24)] = {64,0},
    [I(22,24)] = {64,0},
    [I(23,24)] = {64,0},
    [I(24,24)] = {64,0},
    [I(25,24)] = {64,0},
    [I(26,24)] = {64,0},
    [I(27,24)] = {64,0},
    [I(28,24)] = {64,0},
    [I(29,24)] = {64,0},
    [I(30,24)] = {64,0},
    [I(31,24)] = {64,0},
    [I(32,24)] = {64,0},
    [I(33,24)] = {64,0},
    [I(34,24)] = {64,0},
    [I(35,24)] = {64,0},
    [I(36,24)] = {64,0},
    [I(37,24)] = {64,0},
    [I(38,24)] = {64,0},
    [I(39,24)] = {64,0},
    [I(40,24)] = {64,0},
    [I(41,24)] = {64,0},
    [I(42,24)] = {64,0},
    [I(43,24)] = {64,0},
    [I(44,24)] = {64,0},
    [I(45,24)] = {64,0},
    [I(46,24)] = {64,0},
    [I(47,24)] = {64,0},
    [I(48,24)] = {64,0},
    [I(49,24)] = {64,0},
    [I(50,24)] = {64,0},
    [I(51,24)] = {64,0},
    [I(52,24)] = {64,0},
    [I(53,24)] = {64,0},
    [I(54,24)] = {64,0},
    [I(55,24)] = {64,0},
    [I(56,24)] = {64,0},
    [I(57,24)] = {64,0},
    [I(58,24)] = {64,0},
    [I(59,24)] = {64,0},
    [I(60,24)] = {64,0},
    [I(61,24)] = {64,0},
    [I(62,24)] = {64,0},
    [I(63,24)] = {64,0},
    [I(64,24)] = {64,0},
    [I(65,24)] = {64,0},
    [I(66,24)] = {64,0},
    [I(67,24)] = {64,0},
    [I(68,24)] = {64,0},
    [I(69,24)] = {64,0},
    [I(70,24)] = {64,0},
    [I(71,24)] = {64,0},
    [I(72,24)] = {64,0},
    [I(73,24)] = {64,0},
    [I(74,24)] = {64,0},
    [I(75,24)] = {64,0},
    [I(76,24)] = {64,0},
    [I(77,24)] = {64,0},
    [I(78,24)] = {64,0},
    [I(79,24)] = {64,0},
    [I(80,24)] = {64,0},
    [I(81,24)] = {64,0},
    [I(82,24)] = {64,0},
    [I(83,24)] = {64,0},
    [I(84,24)] = {64,0},
    [I(85,24)] = {64,0},
    [I(86,24)] = {64,0},
    [I(87,24)] = {64,0},
    [I(88,24)] = {64,0},
    [I(89,24)] = {64,0},
    [I(90,24)] = {64,0},
    [I(91,24)] = {64,0},
    [I(92,24)] = {64,0},
    [I(93,24)] = {64,0},
    [I(94,24)] = {64,0},
    [I(95,24)] = {64,0},
    [I(96,24)] = {64,0},
    [I(97,24)] = {64,0},
    [I(98,24)] = {64,0},
    [I(99,24)] = {64,0},
    [I(100,24)] = {64,0},
    [I(101,24)] = {64,0},
    [I(102,24)] = {64,0},
    [I(103,24)] = {64,0},
    [I(104,24)] = {64,0},
    [I(105,24)] = {64,0},
    [I(106,24)] = {64,0},
    [I(107,24)] = {64,0},
    [I(108,24)] = {64,0},
    [I(109,24)] = {64,0},
    [I(110,24)] = {64,0},
    [I(111,24)] = {64,0},
    [I(112,24)] = {64,0},
    [I(113,24)] = {64,0},
    [I(114,24)] = {64,0},
    [I(115,24)] = {64,0},
    [I(116,24)] = {64,0},
    [I(117,24)] = {64,0},
    [I(118,24)] = {64,0},
    [I(119,24)] = {64,0},
    [I(120,24)] = {64,0},
    [I(121,24)] = {64,0},
    [I(122,24)] = {64,0},
    [I(123,24)] = {64,0},
    [I(124,24)] = {64,0},
    [I(125,24)] = {64,0},
    [I(126,24)] = {64,0},
    [I(127,24)] = {64,0},
    [I(128,24)] = {64,0},
    [I(129,24)] = {64,0},
    [I(130,24)] = {64,0},
    [I(131,24)] = {64,0},
    [I(132,24)] = {64,0},
    [I(133,24)] = {64,0},
    [I(134,24)] = {64,0},
    [I(135,24)] = {64,0},
    [I(136,24)] = {64,0},
    [I(137,24)] = {64,0},
    [I(138,24)] = {64,0},
    [I(139,24)] = {64,0},
    [I(140,24)] = {64,0},
    [I(141,24)] = {64,0},
    [I(142,24)] = {64,0},
    [I(143,24)] = {64,0},
    [I(144,24)] = {64,0},
    [I(145,24)] = {64,0},
    [I(146,24)] = {64,0},
    [I(147,24)] = {64,0},
    [I(148,24)] = {64,0},
    [I(149,24)] = {64,0},
    [I(150,24)] = {64,0},
    [I(151,24)] = {64,0},
    [I(152,24)] = {64,0},
    [I(153,24)] = {64,0},
    [I(154,24)] = {64,0},
    [I(155,24)] = {64,0},
    [I(156,24)] = {64,0},
    [I(157,24)] = {64,0},
    [I(158,24)] = {64,0},
    [I(159,24)] = {64,0},
    [I(160,24)] = {64,0},
    [I(161,24)] = {64,0},
    [I(162,24)] = {64,0},
    [I(163,24)] = {64,0},
    [I(164,24)] = {64,0},
    [I(165,24)] = {64,0},
    [I(166,24)] = {64,0},
    [I(167,24)] = {64,0},
    [I(168,24)] = {64,0},
    [I(169,24)] = {64,0},
    [I(170,24)] = {64,0},
    [I(171,24)] = {64,0},
    [I(172,24)] = {64,0},
    [I(173,24)] = {64,0},
    [I(174,24)] = {64,0},
    [I(175,24)] = {64,0},
    [I(176,24)] = {64,0},
    [I(177,24)] = {64,0},
    [I(178,24)] = {64,0},
    [I(179,24)] = {64,0},
    [I(180,24)] = {64,0},
    [I(181,24)] = {64,0},
    [I(182,24)] = {64,0},
    [I(183,24)] = {64,0},
    [I(184,24)] = {64,0},
    [I(185,24)] = {64,0},
    [I(186,24)] = {64,0},
    [I(187,24)] = {64,0},
    [I(188,24)] = {64,0},
    [I(189,24)] = {64,0},
    [I(190,24)] = {64,0},
    [I(191,24)] = {64,0},
    [I(192,24)] = {64,0},
    [I(193,24)] = {64,0},
    [I(194,24)] = {64,0},
    [I(195,24)] = {64,0},
    [I(196,24)] = {64,0},
    [I(197,24)] = {64,0},
    [I(198,24)] = {64,0},
    [I(199,24)] = {64,0},
    [I(200,24)] = {64,0},
    [I(201,24)] = {64,0},
    [I(202,24)] = {64,0},
    [I(203,24)] = {64,0},
    [I(204,24)] = {64,0},
    [I(205,24)] = {64,0},
    [I(206,24)] = {64,0},
    [I(207,24)] = {64,0},
    [I(208,24)] = {64,0},
    [I(209,24)] = {64,0},
    [I(210,24)] = {64,0},
    [I(211,24)] = {64,0},
    [I(212,24)] = {64,0},
    [I(213,24)] = {64,0},
    [I(214,24)] = {64,0},
    [I(215,24)] = {64,0},
    [I(216,24)] = {64,0},
    [I(217,24)] = {64,0},
    [I(218,24)] = {64,0},
    [I(219,24)] = {64,0},
    [I(220,24)] = {64,0},
    [I(221,24)] = {64,0},
    [I(222,24)] = {64,0},
    [I(223,24)] = {64,0},
    [I(224,24)] = {64,0},
    [I(225,24)] = {64,0},
    [I(226,24)] = {64,0},
    [I(227,24)] = {64,0},
    [I(228,24)] = {64,0},
    [I(229,24)] = {64,0},
    [I(230,24)] = {64,0},
    [I(231,24)] = {64,0},
    [I(232,24)] = {64,0},
    [I(233,24)] = {64,0},
    [I(234,24)] = {64,0},
    [I(235,24)] = {64,0},
    [I(236,24)] = {64,0},
    [I(237,24)] = {64,0},
    [I(238,24)] = {64,0},
    [I(239,24)] = {64,0},
    [I(240,24)] = {64,0},
    [I(241,24)] = {64,0},
    [I(242,24)] = {64,0},
    [I(243,24)] = {64,0},
    [I(244,24)] = {64,0},
    [I(245,24)] = {64,0},
    [I(246,24)] = {64,0},
    [I(247,24)] = {64,0},
    [I(248,24)] = {64,0},
    [I(249,24)] = {64,0},
    [I(250,24)] = {64,0},
    [I(251,24)] = {64,0},
    [I(252,24)] = {64,0},
    [I(253,24)] = {64,0},
    [I(254,24)] = {64,0},
    [I(255,24)] = {64,0},
    [I(0,25)] = {64,0},
    [I(1,25)] = {64,0},
    [I(2,25)] = {64,0},
    [I(3,25)] = {64,0},
    [I(4,25)] = {64,0},
    [I(5,25)] = {64,0},
    [I(6,25)] = {64,0},
    [I(7,25)] = {64,0},
    [I(8,25)] = {64,0},
    [I(9,25)] = {64,0},
    [I(10,25)] = {64,0},
    [I(11,25)] = {64,0},
    [I(12,25)] = {64,0},
    [I(13,25)] = {64,0},
    [I(14,25)] = {64,0},
    [I(15,25)] = {64,0},
    [I(16,25)] = {64,0},
    [I(17,25)] = {64,0},
    [I(18,25)] = {64,0},
    [I(19,25)] = {64,0},
    [I(20,25)] = {64,0},
    [I(21,25)] = {64,0},
    [I(22,25)] = {64,0},
    [I(23,25)] = {64,0},
    [I(24,25)] = {64,0},
    [I(25,25)] = {64,0},
    [I(26,25)] = {64,0},
    [I(27,25)] = {64,0},
    [I(28,25)] = {64,0},
    [I(29,25)] = {64,0},
    [I(30,25)] = {64,0},
    [I(31,25)] = {64,0},
    [I(32,25)] = {64,0},
    [I(33,25)] = {64,0},
    [I(34,25)] = {64,0},
    [I(35,25)] = {64,0},
    [I(36,25)] = {64,0},
    [I(37,25)] = {64,0},
    [I(38,25)] = {64,0},
    [I(39,25)] = {64,0},
    [I(40,25)] = {64,0},
    [I(41,25)] = {64,0},
    [I(42,25)] = {64,0},
    [I(43,25)] = {64,0},
    [I(44,25)] = {64,0},
    [I(45,25)] = {64,0},
    [I(46,25)] = {64,0},
    [I(47,25)] = {64,0},
    [I(48,25)] = {64,0},
    [I(49,25)] = {64,0},
    [I(50,25)] = {64,0},
    [I(51,25)] = {64,0},
    [I(52,25)] = {64,0},
    [I(53,25)] = {64,0},
    [I(54,25)] = {64,0},
    [I(55,25)] = {64,0},
    [I(56,25)] = {64,0},
    [I(57,25)] = {64,0},
    [I(58,25)] = {64,0},
    [I(59,25)] = {64,0},
    [I(60,25)] = {64,0},
    [I(61,25)] = {64,0},
    [I(62,25)] = {64,0},
    [I(63,25)] = {64,0},
    [I(64,25)] = {64,0},
    [I(65,25)] = {64,0},
    [I(66,25)] = {64,0},
    [I(67,25)] = {64,0},
    [I(68,25)] = {64,0},
    [I(69,25)] = {64,0},
    [I(70,25)] = {64,0},
    [I(71,25)] = {64,0},
    [I(72,25)] = {64,0},
    [I(73,25)] = {64,0},
    [I(74,25)] = {64,0},
    [I(75,25)] = {64,0},
    [I(76,25)] = {64,0},
    [I(77,25)] = {64,0},
    [I(78,25)] = {64,0},
    [I(79,25)] = {64,0},
    [I(80,25)] = {64,0},
    [I(81,25)] = {64,0},
    [I(82,25)] = {64,0},
    [I(83,25)] = {64,0},
    [I(84,25)] = {64,0},
    [I(85,25)] = {64,0},
    [I(86,25)] = {64,0},
    [I(87,25)] = {64,0},
    [I(88,25)] = {64,0},
    [I(89,25)] = {64,0},
    [I(90,25)] = {64,0},
    [I(91,25)] = {64,0},
    [I(92,25)] = {64,0},
    [I(93,25)] = {64,0},
    [I(94,25)] = {64,0},
    [I(95,25)] = {64,0},
    [I(96,25)] = {64,0},
    [I(97,25)] = {64,0},
    [I(98,25)] = {64,0},
    [I(99,25)] = {64,0},
    [I(100,25)] = {64,0},
    [I(101,25)] = {64,0},
    [I(102,25)] = {64,0},
    [I(103,25)] = {64,0},
    [I(104,25)] = {64,0},
    [I(105,25)] = {64,0},
    [I(106,25)] = {64,0},
    [I(107,25)] = {64,0},
    [I(108,25)] = {64,0},
    [I(109,25)] = {64,0},
    [I(110,25)] = {64,0},
    [I(111,25)] = {64,0},
    [I(112,25)] = {64,0},
    [I(113,25)] = {64,0},
    [I(114,25)] = {64,0},
    [I(115,25)] = {64,0},
    [I(116,25)] = {64,0},
    [I(117,25)] = {64,0},
    [I(118,25)] = {64,0},
    [I(119,25)] = {64,0},
    [I(120,25)] = {64,0},
    [I(121,25)] = {64,0},
    [I(122,25)] = {64,0},
    [I(123,25)] = {64,0},
    [I(124,25)] = {64,0},
    [I(125,25)] = {64,0},
    [I(126,25)] = {64,0},
    [I(127,25)] = {64,0},
    [I(128,25)] = {64,0},
    [I(129,25)] = {64,0},
    [I(130,25)] = {64,0},
    [I(131,25)] = {64,0},
    [I(132,25)] = {64,0},
    [I(133,25)] = {64,0},
    [I(134,25)] = {64,0},
    [I(135,25)] = {64,0},
    [I(136,25)] = {64,0},
    [I(137,25)] = {64,0},
    [I(138,25)] = {64,0},
    [I(139,25)] = {64,0},
    [I(140,25)] = {64,0},
    [I(141,25)] = {64,0},
    [I(142,25)] = {64,0},
    [I(143,25)] = {64,0},
    [I(144,25)] = {64,0},
    [I(145,25)] = {64,0},
    [I(146,25)] = {64,0},
    [I(147,25)] = {64,0},
    [I(148,25)] = {64,0},
    [I(149,25)] = {64,0},
    [I(150,25)] = {64,0},
    [I(151,25)] = {64,0},
    [I(152,25)] = {64,0},
    [I(153,25)] = {64,0},
    [I(154,25)] = {64,0},
    [I(155,25)] = {64,0},
    [I(156,25)] = {64,0},
    [I(157,25)] = {64,0},
    [I(158,25)] = {64,0},
    [I(159,25)] = {64,0},
    [I(160,25)] = {64,0},
    [I(161,25)] = {64,0},
    [I(162,25)] = {64,0},
    [I(163,25)] = {64,0},
    [I(164,25)] = {64,0},
    [I(165,25)] = {64,0},
    [I(166,25)] = {64,0},
    [I(167,25)] = {64,0},
    [I(168,25)] = {64,0},
    [I(169,25)] = {64,0},
    [I(170,25)] = {64,0},
    [I(171,25)] = {64,0},
    [I(172,25)] = {64,0},
    [I(173,25)] = {64,0},
    [I(174,25)] = {64,0},
    [I(175,25)] = {64,0},
    [I(176,25)] = {64,0},
    [I(177,25)] = {64,0},
    [I(178,25)] = {64,0},
    [I(179,25)] = {64,0},
    [I(180,25)] = {64,0},
    [I(181,25)] = {64,0},
    [I(182,25)] = {64,0},
    [I(183,25)] = {64,0},
    [I(184,25)] = {64,0},
    [I(185,25)] = {64,0},
    [I(186,25)] = {64,0},
    [I(187,25)] = {64,0},
    [I(188,25)] = {64,0},
    [I(189,25)] = {64,0},
    [I(190,25)] = {64,0},
    [I(191,25)] = {64,0},
    [I(192,25)] = {64,0},
    [I(193,25)] = {64,0},
    [I(194,25)] = {64,0},
    [I(195,25)] = {64,0},
    [I(196,25)] = {64,0},
    [I(197,25)] = {64,0},
    [I(198,25)] = {64,0},
    [I(199,25)] = {64,0},
    [I(200,25)] = {64,0},
    [I(201,25)] = {64,0},
    [I(202,25)] = {64,0},
    [I(203,25)] = {64,0},
    [I(204,25)] = {64,0},
    [I(205,25)] = {64,0},
    [I(206,25)] = {64,0},
    [I(207,25)] = {64,0},
    [I(208,25)] = {64,0},
    [I(209,25)] = {64,0},
    [I(210,25)] = {64,0},
    [I(211,25)] = {64,0},
    [I(212,25)] = {64,0},
    [I(213,25)] = {64,0},
    [I(214,25)] = {64,0},
    [I(215,25)] = {64,0},
    [I(216,25)] = {64,0},
    [I(217,25)] = {64,0},
    [I(218,25)] = {64,0},
    [I(219,25)] = {64,0},
    [I(220,25)] = {64,0},
    [I(221,25)] = {64,0},
    [I(222,25)] = {64,0},
    [I(223,25)] = {64,0},
    [I(224,25)] = {64,0},
    [I(225,25)] = {64,0},
    [I(226,25)] = {64,0},
    [I(227,25)] = {64,0},
    [I(228,25)] = {64,0},
    [I(229,25)] = {64,0},
    [I(230,25)] = {64,0},
    [I(231,25)] = {64,0},
    [I(232,25)] = {64,0},
    [I(233,25)] = {64,0},
    [I(234,25)] = {64,0},
    [I(235,25)] = {64,0},
    [I(236,25)] = {64,0},
    [I(237,25)] = {64,0},
    [I(238,25)] = {64,0},
    [I(239,25)] = {64,0},
    [I(240,25)] = {64,0},
    [I(241,25)] = {64,0},
    [I(242,25)] = {64,0},
    [I(243,25)] = {64,0},
    [I(244,25)] = {64,0},
    [I(245,25)] = {64,0},
    [I(246,25)] = {64,0},
    [I(247,25)] = {64,0},
    [I(248,25)] = {64,0},
    [I(249,25)] = {64,0},
    [I(250,25)] = {64,0},
    [I(251,25)] = {64,0},
    [I(252,25)] = {64,0},
    [I(253,25)] = {64,0},
    [I(254,25)] = {64,0},
    [I(255,25)] = {64,0},
    [I(0,26)] = {64,0},
    [I(1,26)] = {64,0},
    [I(2,26)] = {64,0},
    [I(3,26)] = {64,0},
    [I(4,26)] = {64,0},
    [I(5,26)] = {64,0},
    [I(6,26)] = {64,0},
    [I(7,26)] = {64,0},
    [I(8,26)] = {64,0},
    [I(9,26)] = {64,0},
    [I(10,26)] = {64,0},
    [I(11,26)] = {64,0},
    [I(12,26)] = {64,0},
    [I(13,26)] = {64,0},
    [I(14,26)] = {64,0},
    [I(15,26)] = {64,0},
    [I(16,26)] = {64,0},
    [I(17,26)] = {64,0},
    [I(18,26)] = {64,0},
    [I(19,26)] = {64,0},
    [I(20,26)] = {64,0},
    [I(21,26)] = {64,0},
    [I(22,26)] = {64,0},
    [I(23,26)] = {64,0},
    [I(24,26)] = {64,0},
    [I(25,26)] = {64,0},
    [I(26,26)] = {64,0},
    [I(27,26)] = {64,0},
    [I(28,26)] = {64,0},
    [I(29,26)] = {64,0},
    [I(30,26)] = {64,0},
    [I(31,26)] = {64,0},
    [I(32,26)] = {64,0},
    [I(33,26)] = {64,0},
    [I(34,26)] = {64,0},
    [I(35,26)] = {64,0},
    [I(36,26)] = {64,0},
    [I(37,26)] = {64,0},
    [I(38,26)] = {64,0},
    [I(39,26)] = {64,0},
    [I(40,26)] = {64,0},
    [I(41,26)] = {64,0},
    [I(42,26)] = {64,0},
    [I(43,26)] = {64,0},
    [I(44,26)] = {64,0},
    [I(45,26)] = {64,0},
    [I(46,26)] = {64,0},
    [I(47,26)] = {64,0},
    [I(48,26)] = {64,0},
    [I(49,26)] = {64,0},
    [I(50,26)] = {64,0},
    [I(51,26)] = {64,0},
    [I(52,26)] = {64,0},
    [I(53,26)] = {64,0},
    [I(54,26)] = {64,0},
    [I(55,26)] = {64,0},
    [I(56,26)] = {64,0},
    [I(57,26)] = {64,0},
    [I(58,26)] = {64,0},
    [I(59,26)] = {64,0},
    [I(60,26)] = {64,0},
    [I(61,26)] = {64,0},
    [I(62,26)] = {64,0},
    [I(63,26)] = {64,0},
    [I(64,26)] = {64,0},
    [I(65,26)] = {64,0},
    [I(66,26)] = {64,0},
    [I(67,26)] = {64,0},
    [I(68,26)] = {64,0},
    [I(69,26)] = {64,0},
    [I(70,26)] = {64,0},
    [I(71,26)] = {64,0},
    [I(72,26)] = {64,0},
    [I(73,26)] = {64,0},
    [I(74,26)] = {64,0},
    [I(75,26)] = {64,0},
    [I(76,26)] = {64,0},
    [I(77,26)] = {64,0},
    [I(78,26)] = {64,0},
    [I(79,26)] = {64,0},
    [I(80,26)] = {64,0},
    [I(81,26)] = {64,0},
    [I(82,26)] = {64,0},
    [I(83,26)] = {64,0},
    [I(84,26)] = {64,0},
    [I(85,26)] = {64,0},
    [I(86,26)] = {64,0},
    [I(87,26)] = {64,0},
    [I(88,26)] = {64,0},
    [I(89,26)] = {64,0},
    [I(90,26)] = {64,0},
    [I(91,26)] = {64,0},
    [I(92,26)] = {64,0},
    [I(93,26)] = {64,0},
    [I(94,26)] = {64,0},
    [I(95,26)] = {64,0},
    [I(96,26)] = {64,0},
    [I(97,26)] = {64,0},
    [I(98,26)] = {64,0},
    [I(99,26)] = {64,0},
    [I(100,26)] = {64,0},
    [I(101,26)] = {64,0},
    [I(102,26)] = {64,0},
    [I(103,26)] = {64,0},
    [I(104,26)] = {64,0},
    [I(105,26)] = {64,0},
    [I(106,26)] = {64,0},
    [I(107,26)] = {64,0},
    [I(108,26)] = {64,0},
    [I(109,26)] = {64,0},
    [I(110,26)] = {64,0},
    [I(111,26)] = {64,0},
    [I(112,26)] = {64,0},
    [I(113,26)] = {64,0},
    [I(114,26)] = {64,0},
    [I(115,26)] = {64,0},
    [I(116,26)] = {64,0},
    [I(117,26)] = {64,0},
    [I(118,26)] = {64,0},
    [I(119,26)] = {64,0},
    [I(120,26)] = {64,0},
    [I(121,26)] = {64,0},
    [I(122,26)] = {64,0},
    [I(123,26)] = {64,0},
    [I(124,26)] = {64,0},
    [I(125,26)] = {64,0},
    [I(126,26)] = {64,0},
    [I(127,26)] = {64,0},
    [I(128,26)] = {64,0},
    [I(129,26)] = {64,0},
    [I(130,26)] = {64,0},
    [I(131,26)] = {64,0},
    [I(132,26)] = {64,0},
    [I(133,26)] = {64,0},
    [I(134,26)] = {64,0},
    [I(135,26)] = {64,0},
    [I(136,26)] = {64,0},
    [I(137,26)] = {64,0},
    [I(138,26)] = {64,0},
    [I(139,26)] = {64,0},
    [I(140,26)] = {64,0},
    [I(141,26)] = {64,0},
    [I(142,26)] = {64,0},
    [I(143,26)] = {64,0},
    [I(144,26)] = {64,0},
    [I(145,26)] = {64,0},
    [I(146,26)] = {64,0},
    [I(147,26)] = {64,0},
    [I(148,26)] = {64,0},
    [I(149,26)] = {64,0},
    [I(150,26)] = {64,0},
    [I(151,26)] = {64,0},
    [I(152,26)] = {64,0},
    [I(153,26)] = {64,0},
    [I(154,26)] = {64,0},
    [I(155,26)] = {64,0},
    [I(156,26)] = {64,0},
    [I(157,26)] = {64,0},
    [I(158,26)] = {64,0},
    [I(159,26)] = {64,0},
    [I(160,26)] = {64,0},
    [I(161,26)] = {64,0},
    [I(162,26)] = {64,0},
    [I(163,26)] = {64,0},
    [I(164,26)] = {64,0},
    [I(165,26)] = {64,0},
    [I(166,26)] = {64,0},
    [I(167,26)] = {64,0},
    [I(168,26)] = {64,0},
    [I(169,26)] = {64,0},
    [I(170,26)] = {64,0},
    [I(171,26)] = {64,0},
    [I(172,26)] = {64,0},
    [I(173,26)] = {64,0},
    [I(174,26)] = {64,0},
    [I(175,26)] = {64,0},
    [I(176,26)] = {64,0},
    [I(177,26)] = {64,0},
    [I(178,26)] = {64,0},
    [I(179,26)] = {64,0},
    [I(180,26)] = {64,0},
    [I(181,26)] = {64,0},
    [I(182,26)] = {64,0},
    [I(183,26)] = {64,0},
    [I(184,26)] = {64,0},
    [I(185,26)] = {64,0},
    [I(186,26)] = {64,0},
    [I(187,26)] = {64,0},
    [I(188,26)] = {64,0},
    [I(189,26)] = {64,0},
    [I(190,26)] = {64,0},
    [I(191,26)] = {64,0},
    [I(192,26)] = {64,0},
    [I(193,26)] = {64,0},
    [I(194,26)] = {64,0},
    [I(195,26)] = {64,0},
    [I(196,26)] = {64,0},
    [I(197,26)] = {64,0},
    [I(198,26)] = {64,0},
    [I(199,26)] = {64,0},
    [I(200,26)] = {64,0},
    [I(201,26)] = {64,0},
    [I(202,26)] = {64,0},
    [I(203,26)] = {64,0},
    [I(204,26)] = {64,0},
    [I(205,26)] = {64,0},
    [I(206,26)] = {64,0},
    [I(207,26)] = {64,0},
    [I(208,26)] = {64,0},
    [I(209,26)] = {64,0},
    [I(210,26)] = {64,0},
    [I(211,26)] = {64,0},
    [I(212,26)] = {64,0},
    [I(213,26)] = {64,0},
    [I(214,26)] = {64,0},
    [I(215,26)] = {64,0},
    [I(216,26)] = {64,0},
    [I(217,26)] = {64,0},
    [I(218,26)] = {64,0},
    [I(219,26)] = {64,0},
    [I(220,26)] = {64,0},
    [I(221,26)] = {64,0},
    [I(222,26)] = {64,0},
    [I(223,26)] = {64,0},
    [I(224,26)] = {64,0},
    [I(225,26)] = {64,0},
    [I(226,26)] = {64,0},
    [I(227,26)] = {64,0},
    [I(228,26)] = {64,0},
    [I(229,26)] = {64,0},
    [I(230,26)] = {64,0},
    [I(231,26)] = {64,0},
    [I(232,26)] = {64,0},
    [I(233,26)] = {64,0},
    [I(234,26)] = {64,0},
    [I(235,26)] = {64,0},
    [I(236,26)] = {64,0},
    [I(237,26)] = {64,0},
    [I(238,26)] = {64,0},
    [I(239,26)] = {64,0},
    [I(240,26)] = {64,0},
    [I(241,26)] = {64,0},
    [I(242,26)] = {64,0},
    [I(243,26)] = {64,0},
    [I(244,26)] = {64,0},
    [I(245,26)] = {64,0},
    [I(246,26)] = {64,0},
    [I(247,26)] = {64,0},
    [I(248,26)] = {64,0},
    [I(249,26)] = {64,0},
    [I(250,26)] = {64,0},
    [I(251,26)] = {64,0},
    [I(252,26)] = {64,0},
    [I(253,26)] = {64,0},
    [I(254,26)] = {64,0},
    [I(255,26)] = {64,0},
    [I(0,27)] = {64,0},
    [I(1,27)] = {64,0},
    [I(2,27)] = {64,0},
    [I(3,27)] = {64,0},
    [I(4,27)] = {64,0},
    [I(5,27)] = {64,0},
    [I(6,27)] = {64,0},
    [I(7,27)] = {64,0},
    [I(8,27)] = {64,0},
    [I(9,27)] = {64,0},
    [I(10,27)] = {64,0},
    [I(11,27)] = {64,0},
    [I(12,27)] = {64,0},
    [I(13,27)] = {64,0},
    [I(14,27)] = {64,0},
    [I(15,27)] = {64,0},
    [I(16,27)] = {64,0},
    [I(17,27)] = {64,0},
    [I(18,27)] = {64,0},
    [I(19,27)] = {64,0},
    [I(20,27)] = {64,0},
    [I(21,27)] = {64,0},
    [I(22,27)] = {64,0},
    [I(23,27)] = {64,0},
    [I(24,27)] = {64,0},
    [I(25,27)] = {64,0},
    [I(26,27)] = {64,0},
    [I(27,27)] = {64,0},
    [I(28,27)] = {64,0},
    [I(29,27)] = {64,0},
    [I(30,27)] = {64,0},
    [I(31,27)] = {64,0},
    [I(32,27)] = {64,0},
    [I(33,27)] = {64,0},
    [I(34,27)] = {64,0},
    [I(35,27)] = {64,0},
    [I(36,27)] = {64,0},
    [I(37,27)] = {64,0},
    [I(38,27)] = {64,0},
    [I(39,27)] = {64,0},
    [I(40,27)] = {64,0},
    [I(41,27)] = {64,0},
    [I(42,27)] = {64,0},
    [I(43,27)] = {64,0},
    [I(44,27)] = {64,0},
    [I(45,27)] = {64,0},
    [I(46,27)] = {64,0},
    [I(47,27)] = {64,0},
    [I(48,27)] = {64,0},
    [I(49,27)] = {64,0},
    [I(50,27)] = {64,0},
    [I(51,27)] = {64,0},
    [I(52,27)] = {64,0},
    [I(53,27)] = {64,0},
    [I(54,27)] = {64,0},
    [I(55,27)] = {64,0},
    [I(56,27)] = {64,0},
    [I(57,27)] = {64,0},
    [I(58,27)] = {64,0},
    [I(59,27)] = {64,0},
    [I(60,27)] = {64,0},
    [I(61,27)] = {64,0},
    [I(62,27)] = {64,0},
    [I(63,27)] = {64,0},
    [I(64,27)] = {64,0},
    [I(65,27)] = {64,0},
    [I(66,27)] = {64,0},
    [I(67,27)] = {64,0},
    [I(68,27)] = {64,0},
    [I(69,27)] = {64,0},
    [I(70,27)] = {64,0},
    [I(71,27)] = {64,0},
    [I(72,27)] = {64,0},
    [I(73,27)] = {64,0},
    [I(74,27)] = {64,0},
    [I(75,27)] = {64,0},
    [I(76,27)] = {64,0},
    [I(77,27)] = {64,0},
    [I(78,27)] = {64,0},
    [I(79,27)] = {64,0},
    [I(80,27)] = {64,0},
    [I(81,27)] = {64,0},
    [I(82,27)] = {64,0},
    [I(83,27)] = {64,0},
    [I(84,27)] = {64,0},
    [I(85,27)] = {64,0},
    [I(86,27)] = {64,0},
    [I(87,27)] = {64,0},
    [I(88,27)] = {64,0},
    [I(89,27)] = {64,0},
    [I(90,27)] = {64,0},
    [I(91,27)] = {64,0},
    [I(92,27)] = {64,0},
    [I(93,27)] = {64,0},
    [I(94,27)] = {64,0},
    [I(95,27)] = {64,0},
    [I(96,27)] = {64,0},
    [I(97,27)] = {64,0},
    [I(98,27)] = {64,0},
    [I(99,27)] = {64,0},
    [I(100,27)] = {64,0},
    [I(101,27)] = {64,0},
    [I(102,27)] = {64,0},
    [I(103,27)] = {64,0},
    [I(104,27)] = {64,0},
    [I(105,27)] = {64,0},
    [I(106,27)] = {64,0},
    [I(107,27)] = {64,0},
    [I(108,27)] = {64,0},
    [I(109,27)] = {64,0},
    [I(110,27)] = {64,0},
    [I(111,27)] = {64,0},
    [I(112,27)] = {64,0},
    [I(113,27)] = {64,0},
    [I(114,27)] = {64,0},
    [I(115,27)] = {64,0},
    [I(116,27)] = {64,0},
    [I(117,27)] = {64,0},
    [I(118,27)] = {64,0},
    [I(119,27)] = {64,0},
    [I(120,27)] = {64,0},
    [I(121,27)] = {64,0},
    [I(122,27)] = {64,0},
    [I(123,27)] = {64,0},
    [I(124,27)] = {64,0},
    [I(125,27)] = {64,0},
    [I(126,27)] = {64,0},
    [I(127,27)] = {64,0},
    [I(128,27)] = {64,0},
    [I(129,27)] = {64,0},
    [I(130,27)] = {64,0},
    [I(131,27)] = {64,0},
    [I(132,27)] = {64,0},
    [I(133,27)] = {64,0},
    [I(134,27)] = {64,0},
    [I(135,27)] = {64,0},
    [I(136,27)] = {64,0},
    [I(137,27)] = {64,0},
    [I(138,27)] = {64,0},
    [I(139,27)] = {64,0},
    [I(140,27)] = {64,0},
    [I(141,27)] = {64,0},
    [I(142,27)] = {64,0},
    [I(143,27)] = {64,0},
    [I(144,27)] = {64,0},
    [I(145,27)] = {64,0},
    [I(146,27)] = {64,0},
    [I(147,27)] = {64,0},
    [I(148,27)] = {64,0},
    [I(149,27)] = {64,0},
    [I(150,27)] = {64,0},
    [I(151,27)] = {64,0},
    [I(152,27)] = {64,0},
    [I(153,27)] = {64,0},
    [I(154,27)] = {64,0},
    [I(155,27)] = {64,0},
    [I(156,27)] = {64,0},
    [I(157,27)] = {64,0},
    [I(158,27)] = {64,0},
    [I(159,27)] = {64,0},
    [I(160,27)] = {64,0},
    [I(161,27)] = {64,0},
    [I(162,27)] = {64,0},
    [I(163,27)] = {64,0},
    [I(164,27)] = {64,0},
    [I(165,27)] = {64,0},
    [I(166,27)] = {64,0},
    [I(167,27)] = {64,0},
    [I(168,27)] = {64,0},
    [I(169,27)] = {64,0},
    [I(170,27)] = {64,0},
    [I(171,27)] = {64,0},
    [I(172,27)] = {64,0},
    [I(173,27)] = {64,0},
    [I(174,27)] = {64,0},
    [I(175,27)] = {64,0},
    [I(176,27)] = {64,0},
    [I(177,27)] = {64,0},
    [I(178,27)] = {64,0},
    [I(179,27)] = {64,0},
    [I(180,27)] = {64,0},
    [I(181,27)] = {64,0},
    [I(182,27)] = {64,0},
    [I(183,27)] = {64,0},
    [I(184,27)] = {64,0},
    [I(185,27)] = {64,0},
    [I(186,27)] = {64,0},
    [I(187,27)] = {64,0},
    [I(188,27)] = {64,0},
    [I(189,27)] = {64,0},
    [I(190,27)] = {64,0},
    [I(191,27)] = {64,0},
    [I(192,27)] = {64,0},
    [I(193,27)] = {64,0},
    [I(194,27)] = {64,0},
    [I(195,27)] = {64,0},
    [I(196,27)] = {64,0},
    [I(197,27)] = {64,0},
    [I(198,27)] = {64,0},
    [I(199,27)] = {64,0},
    [I(200,27)] = {64,0},
    [I(201,27)] = {64,0},
    [I(202,27)] = {64,0},
    [I(203,27)] = {64,0},
    [I(204,27)] = {64,0},
    [I(205,27)] = {64,0},
    [I(206,27)] = {64,0},
    [I(207,27)] = {64,0},
    [I(208,27)] = {64,0},
    [I(209,27)] = {64,0},
    [I(210,27)] = {64,0},
    [I(211,27)] = {64,0},
    [I(212,27)] = {64,0},
    [I(213,27)] = {64,0},
    [I(214,27)] = {64,0},
    [I(215,27)] = {64,0},
    [I(216,27)] = {64,0},
    [I(217,27)] = {64,0},
    [I(218,27)] = {64,0},
    [I(219,27)] = {64,0},
    [I(220,27)] = {64,0},
    [I(221,27)] = {64,0},
    [I(222,27)] = {64,0},
    [I(223,27)] = {64,0},
    [I(224,27)] = {64,0},
    [I(225,27)] = {64,0},
    [I(226,27)] = {64,0},
    [I(227,27)] = {64,0},
    [I(228,27)] = {64,0},
    [I(229,27)] = {64,0},
    [I(230,27)] = {64,0},
    [I(231,27)] = {64,0},
    [I(232,27)] = {64,0},
    [I(233,27)] = {64,0},
    [I(234,27)] = {64,0},
    [I(235,27)] = {64,0},
    [I(236,27)] = {64,0},
    [I(237,27)] = {64,0},
    [I(238,27)] = {64,0},
    [I(239,27)] = {64,0},
    [I(240,27)] = {64,0},
    [I(241,27)] = {64,0},
    [I(242,27)] = {64,0},
    [I(243,27)] = {64,0},
    [I(244,27)] = {64,0},
    [I(245,27)] = {64,0},
    [I(246,27)] = {64,0},
    [I(247,27)] = {64,0},
    [I(248,27)] = {64,0},
    [I(249,27)] = {64,0},
    [I(250,27)] = {64,0},
    [I(251,27)] = {64,0},
    [I(252,27)] = {64,0},
    [I(253,27)] = {64,0},
    [I(254,27)] = {64,0},
    [I(255,27)] = {64,0},
    [I(0,28)] = {64,0},
    [I(1,28)] = {64,0},
    [I(2,28)] = {64,0},
    [I(3,28)] = {64,0},
    [I(4,28)] = {64,0},
    [I(5,28)] = {64,0},
    [I(6,28)] = {64,0},
    [I(7,28)] = {64,0},
    [I(8,28)] = {64,0},
    [I(9,28)] = {64,0},
    [I(10,28)] = {64,0},
    [I(11,28)] = {64,0},
    [I(12,28)] = {64,0},
    [I(13,28)] = {64,0},
    [I(14,28)] = {64,0},
    [I(15,28)] = {64,0},
    [I(16,28)] = {64,0},
    [I(17,28)] = {64,0},
    [I(18,28)] = {64,0},
    [I(19,28)] = {64,0},
    [I(20,28)] = {64,0},
    [I(21,28)] = {64,0},
    [I(22,28)] = {64,0},
    [I(23,28)] = {64,0},
    [I(24,28)] = {64,0},
    [I(25,28)] = {64,0},
    [I(26,28)] = {64,0},
    [I(27,28)] = {64,0},
    [I(28,28)] = {64,0},
    [I(29,28)] = {64,0},
    [I(30,28)] = {64,0},
    [I(31,28)] = {64,0},
    [I(32,28)] = {64,0},
    [I(33,28)] = {64,0},
    [I(34,28)] = {64,0},
    [I(35,28)] = {64,0},
    [I(36,28)] = {64,0},
    [I(37,28)] = {64,0},
    [I(38,28)] = {64,0},
    [I(39,28)] = {64,0},
    [I(40,28)] = {64,0},
    [I(41,28)] = {64,0},
    [I(42,28)] = {64,0},
    [I(43,28)] = {64,0},
    [I(44,28)] = {64,0},
    [I(45,28)] = {64,0},
    [I(46,28)] = {64,0},
    [I(47,28)] = {64,0},
    [I(48,28)] = {64,0},
    [I(49,28)] = {64,0},
    [I(50,28)] = {64,0},
    [I(51,28)] = {64,0},
    [I(52,28)] = {64,0},
    [I(53,28)] = {64,0},
    [I(54,28)] = {64,0},
    [I(55,28)] = {64,0},
    [I(56,28)] = {64,0},
    [I(57,28)] = {64,0},
    [I(58,28)] = {64,0},
    [I(59,28)] = {64,0},
    [I(60,28)] = {64,0},
    [I(61,28)] = {64,0},
    [I(62,28)] = {64,0},
    [I(63,28)] = {64,0},
    [I(64,28)] = {64,0},
    [I(65,28)] = {64,0},
    [I(66,28)] = {64,0},
    [I(67,28)] = {64,0},
    [I(68,28)] = {64,0},
    [I(69,28)] = {64,0},
    [I(70,28)] = {64,0},
    [I(71,28)] = {64,0},
    [I(72,28)] = {64,0},
    [I(73,28)] = {64,0},
    [I(74,28)] = {64,0},
    [I(75,28)] = {64,0},
    [I(76,28)] = {64,0},
    [I(77,28)] = {64,0},
    [I(78,28)] = {64,0},
    [I(79,28)] = {64,0},
    [I(80,28)] = {64,0},
    [I(81,28)] = {64,0},
    [I(82,28)] = {64,0},
    [I(83,28)] = {64,0},
    [I(84,28)] = {64,0},
    [I(85,28)] = {64,0},
    [I(86,28)] = {64,0},
    [I(87,28)] = {64,0},
    [I(88,28)] = {64,0},
    [I(89,28)] = {64,0},
    [I(90,28)] = {64,0},
    [I(91,28)] = {64,0},
    [I(92,28)] = {64,0},
    [I(93,28)] = {64,0},
    [I(94,28)] = {64,0},
    [I(95,28)] = {64,0},
    [I(96,28)] = {64,0},
    [I(97,28)] = {64,0},
    [I(98,28)] = {64,0},
    [I(99,28)] = {64,0},
    [I(100,28)] = {64,0},
    [I(101,28)] = {64,0},
    [I(102,28)] = {64,0},
    [I(103,28)] = {64,0},
    [I(104,28)] = {64,0},
    [I(105,28)] = {64,0},
    [I(106,28)] = {64,0},
    [I(107,28)] = {64,0},
    [I(108,28)] = {64,0},
    [I(109,28)] = {64,0},
    [I(110,28)] = {64,0},
    [I(111,28)] = {64,0},
    [I(112,28)] = {64,0},
    [I(113,28)] = {64,0},
    [I(114,28)] = {64,0},
    [I(115,28)] = {64,0},
    [I(116,28)] = {64,0},
    [I(117,28)] = {64,0},
    [I(118,28)] = {64,0},
    [I(119,28)] = {64,0},
    [I(120,28)] = {64,0},
    [I(121,28)] = {64,0},
    [I(122,28)] = {64,0},
    [I(123,28)] = {64,0},
    [I(124,28)] = {64,0},
    [I(125,28)] = {64,0},
    [I(126,28)] = {64,0},
    [I(127,28)] = {64,0},
    [I(128,28)] = {64,0},
    [I(129,28)] = {64,0},
    [I(130,28)] = {64,0},
    [I(131,28)] = {64,0},
    [I(132,28)] = {64,0},
    [I(133,28)] = {64,0},
    [I(134,28)] = {64,0},
    [I(135,28)] = {64,0},
    [I(136,28)] = {64,0},
    [I(137,28)] = {64,0},
    [I(138,28)] = {64,0},
    [I(139,28)] = {64,0},
    [I(140,28)] = {64,0},
    [I(141,28)] = {64,0},
    [I(142,28)] = {64,0},
    [I(143,28)] = {64,0},
    [I(144,28)] = {64,0},
    [I(145,28)] = {64,0},
    [I(146,28)] = {64,0},
    [I(147,28)] = {64,0},
    [I(148,28)] = {64,0},
    [I(149,28)] = {64,0},
    [I(150,28)] = {64,0},
    [I(151,28)] = {64,0},
    [I(152,28)] = {64,0},
    [I(153,28)] = {64,0},
    [I(154,28)] = {64,0},
    [I(155,28)] = {64,0},
    [I(156,28)] = {64,0},
    [I(157,28)] = {64,0},
    [I(158,28)] = {64,0},
    [I(159,28)] = {64,0},
    [I(160,28)] = {64,0},
    [I(161,28)] = {64,0},
    [I(162,28)] = {64,0},
    [I(163,28)] = {64,0},
    [I(164,28)] = {64,0},
    [I(165,28)] = {64,0},
    [I(166,28)] = {64,0},
    [I(167,28)] = {64,0},
    [I(168,28)] = {64,0},
    [I(169,28)] = {64,0},
    [I(170,28)] = {64,0},
    [I(171,28)] = {64,0},
    [I(172,28)] = {64,0},
    [I(173,28)] = {64,0},
    [I(174,28)] = {64,0},
    [I(175,28)] = {64,0},
    [I(176,28)] = {64,0},
    [I(177,28)] = {64,0},
    [I(178,28)] = {64,0},
    [I(179,28)] = {64,0},
    [I(180,28)] = {64,0},
    [I(181,28)] = {64,0},
    [I(182,28)] = {64,0},
    [I(183,28)] = {64,0},
    [I(184,28)] = {64,0},
    [I(185,28)] = {64,0},
    [I(186,28)] = {64,0},
    [I(187,28)] = {64,0},
    [I(188,28)] = {64,0},
    [I(189,28)] = {64,0},
    [I(190,28)] = {64,0},
    [I(191,28)] = {64,0},
    [I(192,28)] = {64,0},
    [I(193,28)] = {64,0},
    [I(194,28)] = {64,0},
    [I(195,28)] = {64,0},
    [I(196,28)] = {64,0},
    [I(197,28)] = {64,0},
    [I(198,28)] = {64,0},
    [I(199,28)] = {64,0},
    [I(200,28)] = {64,0},
    [I(201,28)] = {64,0},
    [I(202,28)] = {64,0},
    [I(203,28)] = {64,0},
    [I(204,28)] = {64,0},
    [I(205,28)] = {64,0},
    [I(206,28)] = {64,0},
    [I(207,28)] = {64,0},
    [I(208,28)] = {64,0},
    [I(209,28)] = {64,0},
    [I(210,28)] = {64,0},
    [I(211,28)] = {64,0},
    [I(212,28)] = {64,0},
    [I(213,28)] = {64,0},
    [I(214,28)] = {64,0},
    [I(215,28)] = {64,0},
    [I(216,28)] = {64,0},
    [I(217,28)] = {64,0},
    [I(218,28)] = {64,0},
    [I(219,28)] = {64,0},
    [I(220,28)] = {64,0},
    [I(221,28)] = {64,0},
    [I(222,28)] = {64,0},
    [I(223,28)] = {64,0},
    [I(224,28)] = {64,0},
    [I(225,28)] = {64,0},
    [I(226,28)] = {64,0},
    [I(227,28)] = {64,0},
    [I(228,28)] = {64,0},
    [I(229,28)] = {64,0},
    [I(230,28)] = {64,0},
    [I(231,28)] = {64,0},
    [I(232,28)] = {64,0},
    [I(233,28)] = {64,0},
    [I(234,28)] = {64,0},
    [I(235,28)] = {64,0},
    [I(236,28)] = {64,0},
    [I(237,28)] = {64,0},
    [I(238,28)] = {64,0},
    [I(239,28)] = {64,0},
    [I(240,28)] = {64,0},
    [I(241,28)] = {64,0},
    [I(242,28)] = {64,0},
    [I(243,28)] = {64,0},
    [I(244,28)] = {64,0},
    [I(245,28)] = {64,0},
    [I(246,28)] = {64,0},
    [I(247,28)] = {64,0},
    [I(248,28)] = {64,0},
    [I(249,28)] = {64,0},
    [I(250,28)] = {64,0},
    [I(251,28)] = {64,0},
    [I(252,28)] = {64,0},
    [I(253,28)] = {64,0},
    [I(254,28)] = {64,0},
    [I(255,28)] = {64,0},
    [I(0,29)] = {64,0},
    [I(1,29)] = {64,0},
    [I(2,29)] = {64,0},
    [I(3,29)] = {64,0},
    [I(4,29)] = {64,0},
    [I(5,29)] = {64,0},
    [I(6,29)] = {64,0},
    [I(7,29)] = {64,0},
    [I(8,29)] = {64,0},
    [I(9,29)] = {64,0},
    [I(10,29)] = {64,0},
    [I(11,29)] = {64,0},
    [I(12,29)] = {64,0},
    [I(13,29)] = {64,0},
    [I(14,29)] = {64,0},
    [I(15,29)] = {64,0},
    [I(16,29)] = {64,0},
    [I(17,29)] = {64,0},
    [I(18,29)] = {64,0},
    [I(19,29)] = {64,0},
    [I(20,29)] = {64,0},
    [I(21,29)] = {64,0},
    [I(22,29)] = {64,0},
    [I(23,29)] = {64,0},
    [I(24,29)] = {64,0},
    [I(25,29)] = {64,0},
    [I(26,29)] = {64,0},
    [I(27,29)] = {64,0},
    [I(28,29)] = {64,0},
    [I(29,29)] = {64,0},
    [I(30,29)] = {64,0},
    [I(31,29)] = {64,0},
    [I(32,29)] = {64,0},
    [I(33,29)] = {64,0},
    [I(34,29)] = {64,0},
    [I(35,29)] = {64,0},
    [I(36,29)] = {64,0},
    [I(37,29)] = {64,0},
    [I(38,29)] = {64,0},
    [I(39,29)] = {64,0},
    [I(40,29)] = {64,0},
    [I(41,29)] = {64,0},
    [I(42,29)] = {64,0},
    [I(43,29)] = {64,0},
    [I(44,29)] = {64,0},
    [I(45,29)] = {64,0},
    [I(46,29)] = {64,0},
    [I(47,29)] = {64,0},
    [I(48,29)] = {64,0},
    [I(49,29)] = {64,0},
    [I(50,29)] = {64,0},
    [I(51,29)] = {64,0},
    [I(52,29)] = {64,0},
    [I(53,29)] = {64,0},
    [I(54,29)] = {64,0},
    [I(55,29)] = {64,0},
    [I(56,29)] = {64,0},
    [I(57,29)] = {64,0},
    [I(58,29)] = {64,0},
    [I(59,29)] = {64,0},
    [I(60,29)] = {64,0},
    [I(61,29)] = {64,0},
    [I(62,29)] = {64,0},
    [I(63,29)] = {64,0},
    [I(64,29)] = {64,0},
    [I(65,29)] = {64,0},
    [I(66,29)] = {64,0},
    [I(67,29)] = {64,0},
    [I(68,29)] = {64,0},
    [I(69,29)] = {64,0},
    [I(70,29)] = {64,0},
    [I(71,29)] = {64,0},
    [I(72,29)] = {64,0},
    [I(73,29)] = {64,0},
    [I(74,29)] = {64,0},
    [I(75,29)] = {64,0},
    [I(76,29)] = {64,0},
    [I(77,29)] = {64,0},
    [I(78,29)] = {64,0},
    [I(79,29)] = {64,0},
    [I(80,29)] = {64,0},
    [I(81,29)] = {64,0},
    [I(82,29)] = {64,0},
    [I(83,29)] = {64,0},
    [I(84,29)] = {64,0},
    [I(85,29)] = {64,0},
    [I(86,29)] = {64,0},
    [I(87,29)] = {64,0},
    [I(88,29)] = {64,0},
    [I(89,29)] = {64,0},
    [I(90,29)] = {64,0},
    [I(91,29)] = {64,0},
    [I(92,29)] = {64,0},
    [I(93,29)] = {64,0},
    [I(94,29)] = {64,0},
    [I(95,29)] = {64,0},
    [I(96,29)] = {64,0},
    [I(97,29)] = {64,0},
    [I(98,29)] = {64,0},
    [I(99,29)] = {64,0},
    [I(100,29)] = {64,0},
    [I(101,29)] = {64,0},
    [I(102,29)] = {64,0},
    [I(103,29)] = {64,0},
    [I(104,29)] = {64,0},
    [I(105,29)] = {64,0},
    [I(106,29)] = {64,0},
    [I(107,29)] = {64,0},
    [I(108,29)] = {64,0},
    [I(109,29)] = {64,0},
    [I(110,29)] = {64,0},
    [I(111,29)] = {64,0},
    [I(112,29)] = {64,0},
    [I(113,29)] = {64,0},
    [I(114,29)] = {64,0},
    [I(115,29)] = {64,0},
    [I(116,29)] = {64,0},
    [I(117,29)] = {64,0},
    [I(118,29)] = {64,0},
    [I(119,29)] = {64,0},
    [I(120,29)] = {64,0},
    [I(121,29)] = {64,0},
    [I(122,29)] = {64,0},
    [I(123,29)] = {64,0},
    [I(124,29)] = {64,0},
    [I(125,29)] = {64,0},
    [I(126,29)] = {64,0},
    [I(127,29)] = {64,0},
    [I(128,29)] = {64,0},
    [I(129,29)] = {64,0},
    [I(130,29)] = {64,0},
    [I(131,29)] = {64,0},
    [I(132,29)] = {64,0},
    [I(133,29)] = {64,0},
    [I(134,29)] = {64,0},
    [I(135,29)] = {64,0},
    [I(136,29)] = {64,0},
    [I(137,29)] = {64,0},
    [I(138,29)] = {64,0},
    [I(139,29)] = {64,0},
    [I(140,29)] = {64,0},
    [I(141,29)] = {64,0},
    [I(142,29)] = {64,0},
    [I(143,29)] = {64,0},
    [I(144,29)] = {64,0},
    [I(145,29)] = {64,0},
    [I(146,29)] = {64,0},
    [I(147,29)] = {64,0},
    [I(148,29)] = {64,0},
    [I(149,29)] = {64,0},
    [I(150,29)] = {64,0},
    [I(151,29)] = {64,0},
    [I(152,29)] = {64,0},
    [I(153,29)] = {64,0},
    [I(154,29)] = {64,0},
    [I(155,29)] = {64,0},
    [I(156,29)] = {64,0},
    [I(157,29)] = {64,0},
    [I(158,29)] = {64,0},
    [I(159,29)] = {64,0},
    [I(160,29)] = {64,0},
    [I(161,29)] = {64,0},
    [I(162,29)] = {64,0},
    [I(163,29)] = {64,0},
    [I(164,29)] = {64,0},
    [I(165,29)] = {64,0},
    [I(166,29)] = {64,0},
    [I(167,29)] = {64,0},
    [I(168,29)] = {64,0},
    [I(169,29)] = {64,0},
    [I(170,29)] = {64,0},
    [I(171,29)] = {64,0},
    [I(172,29)] = {64,0},
    [I(173,29)] = {64,0},
    [I(174,29)] = {64,0},
    [I(175,29)] = {64,0},
    [I(176,29)] = {64,0},
    [I(177,29)] = {64,0},
    [I(178,29)] = {64,0},
    [I(179,29)] = {64,0},
    [I(180,29)] = {64,0},
    [I(181,29)] = {64,0},
    [I(182,29)] = {64,0},
    [I(183,29)] = {64,0},
    [I(184,29)] = {64,0},
    [I(185,29)] = {64,0},
    [I(186,29)] = {64,0},
    [I(187,29)] = {64,0},
    [I(188,29)] = {64,0},
    [I(189,29)] = {64,0},
    [I(190,29)] = {64,0},
    [I(191,29)] = {64,0},
    [I(192,29)] = {64,0},
    [I(193,29)] = {64,0},
    [I(194,29)] = {64,0},
    [I(195,29)] = {64,0},
    [I(196,29)] = {64,0},
    [I(197,29)] = {64,0},
    [I(198,29)] = {64,0},
    [I(199,29)] = {64,0},
    [I(200,29)] = {64,0},
    [I(201,29)] = {64,0},
    [I(202,29)] = {64,0},
    [I(203,29)] = {64,0},
    [I(204,29)] = {64,0},
    [I(205,29)] = {64,0},
    [I(206,29)] = {64,0},
    [I(207,29)] = {64,0},
    [I(208,29)] = {64,0},
    [I(209,29)] = {64,0},
    [I(210,29)] = {64,0},
    [I(211,29)] = {64,0},
    [I(212,29)] = {64,0},
    [I(213,29)] = {64,0},
    [I(214,29)] = {64,0},
    [I(215,29)] = {64,0},
    [I(216,29)] = {64,0},
    [I(217,29)] = {64,0},
    [I(218,29)] = {64,0},
    [I(219,29)] = {64,0},
    [I(220,29)] = {64,0},
    [I(221,29)] = {64,0},
    [I(222,29)] = {64,0},
    [I(223,29)] = {64,0},
    [I(224,29)] = {64,0},
    [I(225,29)] = {64,0},
    [I(226,29)] = {64,0},
    [I(227,29)] = {64,0},
    [I(228,29)] = {64,0},
    [I(229,29)] = {64,0},
    [I(230,29)] = {64,0},
    [I(231,29)] = {64,0},
    [I(232,29)] = {64,0},
    [I(233,29)] = {64,0},
    [I(234,29)] = {64,0},
    [I(235,29)] = {64,0},
    [I(236,29)] = {64,0},
    [I(237,29)] = {64,0},
    [I(238,29)] = {64,0},
    [I(239,29)] = {64,0},
    [I(240,29)] = {64,0},
    [I(241,29)] = {64,0},
    [I(242,29)] = {64,0},
    [I(243,29)] = {64,0},
    [I(244,29)] = {64,0},
    [I(245,29)] = {64,0},
    [I(246,29)] = {64,0},
    [I(247,29)] = {64,0},
    [I(248,29)] = {64,0},
    [I(249,29)] = {64,0},
    [I(250,29)] = {64,0},
    [I(251,29)] = {64,0},
    [I(252,29)] = {64,0},
    [I(253,29)] = {64,0},
    [I(254,29)] = {64,0},
    [I(255,29)] = {64,0},
    [I(0,30)] = {64,0},
    [I(1,30)] = {64,0},
    [I(2,30)] = {64,0},
    [I(3,30)] = {64,0},
    [I(4,30)] = {64,0},
    [I(5,30)] = {64,0},
    [I(6,30)] = {64,0},
    [I(7,30)] = {64,0},
    [I(8,30)] = {64,0},
    [I(9,30)] = {64,0},
    [I(10,30)] = {64,0},
    [I(11,30)] = {64,0},
    [I(12,30)] = {64,0},
    [I(13,30)] = {64,0},
    [I(14,30)] = {64,0},
    [I(15,30)] = {64,0},
    [I(16,30)] = {64,0},
    [I(17,30)] = {64,0},
    [I(18,30)] = {64,0},
    [I(19,30)] = {64,0},
    [I(20,30)] = {64,0},
    [I(21,30)] = {64,0},
    [I(22,30)] = {64,0},
    [I(23,30)] = {64,0},
    [I(24,30)] = {64,0},
    [I(25,30)] = {64,0},
    [I(26,30)] = {64,0},
    [I(27,30)] = {64,0},
    [I(28,30)] = {64,0},
    [I(29,30)] = {64,0},
    [I(30,30)] = {64,0},
    [I(31,30)] = {64,0},
    [I(32,30)] = {64,0},
    [I(33,30)] = {64,0},
    [I(34,30)] = {64,0},
    [I(35,30)] = {64,0},
    [I(36,30)] = {64,0},
    [I(37,30)] = {64,0},
    [I(38,30)] = {64,0},
    [I(39,30)] = {64,0},
    [I(40,30)] = {64,0},
    [I(41,30)] = {64,0},
    [I(42,30)] = {64,0},
    [I(43,30)] = {64,0},
    [I(44,30)] = {64,0},
    [I(45,30)] = {64,0},
    [I(46,30)] = {64,0},
    [I(47,30)] = {64,0},
    [I(48,30)] = {64,0},
    [I(49,30)] = {64,0},
    [I(50,30)] = {64,0},
    [I(51,30)] = {64,0},
    [I(52,30)] = {64,0},
    [I(53,30)] = {64,0},
    [I(54,30)] = {64,0},
    [I(55,30)] = {64,0},
    [I(56,30)] = {64,0},
    [I(57,30)] = {64,0},
    [I(58,30)] = {64,0},
    [I(59,30)] = {64,0},
    [I(60,30)] = {64,0},
    [I(61,30)] = {64,0},
    [I(62,30)] = {64,0},
    [I(63,30)] = {64,0},
    [I(64,30)] = {64,0},
    [I(65,30)] = {64,0},
    [I(66,30)] = {64,0},
    [I(67,30)] = {64,0},
    [I(68,30)] = {64,0},
    [I(69,30)] = {64,0},
    [I(70,30)] = {64,0},
    [I(71,30)] = {64,0},
    [I(72,30)] = {64,0},
    [I(73,30)] = {64,0},
    [I(74,30)] = {64,0},
    [I(75,30)] = {64,0},
    [I(76,30)] = {64,0},
    [I(77,30)] = {64,0},
    [I(78,30)] = {64,0},
    [I(79,30)] = {64,0},
    [I(80,30)] = {64,0},
    [I(81,30)] = {64,0},
    [I(82,30)] = {64,0},
    [I(83,30)] = {64,0},
    [I(84,30)] = {64,0},
    [I(85,30)] = {64,0},
    [I(86,30)] = {64,0},
    [I(87,30)] = {64,0},
    [I(88,30)] = {64,0},
    [I(89,30)] = {64,0},
    [I(90,30)] = {64,0},
    [I(91,30)] = {64,0},
    [I(92,30)] = {64,0},
    [I(93,30)] = {64,0},
    [I(94,30)] = {64,0},
    [I(95,30)] = {64,0},
    [I(96,30)] = {64,0},
    [I(97,30)] = {64,0},
    [I(98,30)] = {64,0},
    [I(99,30)] = {64,0},
    [I(100,30)] = {64,0},
    [I(101,30)] = {64,0},
    [I(102,30)] = {64,0},
    [I(103,30)] = {64,0},
    [I(104,30)] = {64,0},
    [I(105,30)] = {64,0},
    [I(106,30)] = {64,0},
    [I(107,30)] = {64,0},
    [I(108,30)] = {64,0},
    [I(109,30)] = {64,0},
    [I(110,30)] = {64,0},
    [I(111,30)] = {64,0},
    [I(112,30)] = {64,0},
    [I(113,30)] = {64,0},
    [I(114,30)] = {64,0},
    [I(115,30)] = {64,0},
    [I(116,30)] = {64,0},
    [I(117,30)] = {64,0},
    [I(118,30)] = {64,0},
    [I(119,30)] = {64,0},
    [I(120,30)] = {64,0},
    [I(121,30)] = {64,0},
    [I(122,30)] = {64,0},
    [I(123,30)] = {64,0},
    [I(124,30)] = {64,0},
    [I(125,30)] = {64,0},
    [I(126,30)] = {64,0},
    [I(127,30)] = {64,0},
    [I(128,30)] = {64,0},
    [I(129,30)] = {64,0},
    [I(130,30)] = {64,0},
    [I(131,30)] = {64,0},
    [I(132,30)] = {64,0},
    [I(133,30)] = {64,0},
    [I(134,30)] = {64,0},
    [I(135,30)] = {64,0},
    [I(136,30)] = {64,0},
    [I(137,30)] = {64,0},
    [I(138,30)] = {64,0},
    [I(139,30)] = {64,0},
    [I(140,30)] = {64,0},
    [I(141,30)] = {64,0},
    [I(142,30)] = {64,0},
    [I(143,30)] = {64,0},
    [I(144,30)] = {64,0},
    [I(145,30)] = {64,0},
    [I(146,30)] = {64,0},
    [I(147,30)] = {64,0},
    [I(148,30)] = {64,0},
    [I(149,30)] = {64,0},
    [I(150,30)] = {64,0},
    [I(151,30)] = {64,0},
    [I(152,30)] = {64,0},
    [I(153,30)] = {64,0},
    [I(154,30)] = {64,0},
    [I(155,30)] = {64,0},
    [I(156,30)] = {64,0},
    [I(157,30)] = {64,0},
    [I(158,30)] = {64,0},
    [I(159,30)] = {64,0},
    [I(160,30)] = {64,0},
    [I(161,30)] = {64,0},
    [I(162,30)] = {64,0},
    [I(163,30)] = {64,0},
    [I(164,30)] = {64,0},
    [I(165,30)] = {64,0},
    [I(166,30)] = {64,0},
    [I(167,30)] = {64,0},
    [I(168,30)] = {64,0},
    [I(169,30)] = {64,0},
    [I(170,30)] = {64,0},
    [I(171,30)] = {64,0},
    [I(172,30)] = {64,0},
    [I(173,30)] = {64,0},
    [I(174,30)] = {64,0},
    [I(175,30)] = {64,0},
    [I(176,30)] = {64,0},
    [I(177,30)] = {64,0},
    [I(178,30)] = {64,0},
    [I(179,30)] = {64,0},
    [I(180,30)] = {64,0},
    [I(181,30)] = {64,0},
    [I(182,30)] = {64,0},
    [I(183,30)] = {64,0},
    [I(184,30)] = {64,0},
    [I(185,30)] = {64,0},
    [I(186,30)] = {64,0},
    [I(187,30)] = {64,0},
    [I(188,30)] = {64,0},
    [I(189,30)] = {64,0},
    [I(190,30)] = {64,0},
    [I(191,30)] = {64,0},
    [I(192,30)] = {64,0},
    [I(193,30)] = {64,0},
    [I(194,30)] = {64,0},
    [I(195,30)] = {64,0},
    [I(196,30)] = {64,0},
    [I(197,30)] = {64,0},
    [I(198,30)] = {64,0},
    [I(199,30)] = {64,0},
    [I(200,30)] = {64,0},
    [I(201,30)] = {64,0},
    [I(202,30)] = {64,0},
    [I(203,30)] = {64,0},
    [I(204,30)] = {64,0},
    [I(205,30)] = {64,0},
    [I(206,30)] = {64,0},
    [I(207,30)] = {64,0},
    [I(208,30)] = {64,0},
    [I(209,30)] = {64,0},
    [I(210,30)] = {64,0},
    [I(211,30)] = {64,0},
    [I(212,30)] = {64,0},
    [I(213,30)] = {64,0},
    [I(214,30)] = {64,0},
    [I(215,30)] = {64,0},
    [I(216,30)] = {64,0},
    [I(217,30)] = {64,0},
    [I(218,30)] = {64,0},
    [I(219,30)] = {64,0},
    [I(220,30)] = {64,0},
    [I(221,30)] = {64,0},
    [I(222,30)] = {64,0},
    [I(223,30)] = {64,0},
    [I(224,30)] = {64,0},
    [I(225,30)] = {64,0},
    [I(226,30)] = {64,0},
    [I(227,30)] = {64,0},
    [I(228,30)] = {64,0},
    [I(229,30)] = {64,0},
    [I(230,30)] = {64,0},
    [I(231,30)] = {64,0},
    [I(232,30)] = {64,0},
    [I(233,30)] = {64,0},
    [I(234,30)] = {64,0},
    [I(235,30)] = {64,0},
    [I(236,30)] = {64,0},
    [I(237,30)] = {64,0},
    [I(238,30)] = {64,0},
    [I(239,30)] = {64,0},
    [I(240,30)] = {64,0},
    [I(241,30)] = {64,0},
    [I(242,30)] = {64,0},
    [I(243,30)] = {64,0},
    [I(244,30)] = {64,0},
    [I(245,30)] = {64,0},
    [I(246,30)] = {64,0},
    [I(247,30)] = {64,0},
    [I(248,30)] = {64,0},
    [I(249,30)] = {64,0},
    [I(250,30)] = {64,0},
    [I(251,30)] = {64,0},
    [I(252,30)] = {64,0},
    [I(253,30)] = {64,0},
    [I(254,30)] = {64,0},
    [I(255,30)] = {64,0},
    [I(0,31)] = {64,0},
    [I(1,31)] = {64,0},
    [I(2,31)] = {64,0},
    [I(3,31)] = {64,0},
    [I(4,31)] = {64,0},
    [I(5,31)] = {64,0},
    [I(6,31)] = {64,0},
    [I(7,31)] = {64,0},
    [I(8,31)] = {64,0},
    [I(9,31)] = {64,0},
    [I(10,31)] = {64,0},
    [I(11,31)] = {64,0},
    [I(12,31)] = {64,0},
    [I(13,31)] = {64,0},
    [I(14,31)] = {64,0},
    [I(15,31)] = {64,0},
    [I(16,31)] = {64,0},
    [I(17,31)] = {64,0},
    [I(18,31)] = {64,0},
    [I(19,31)] = {64,0},
    [I(20,31)] = {64,0},
    [I(21,31)] = {64,0},
    [I(22,31)] = {64,0},
    [I(23,31)] = {64,0},
    [I(24,31)] = {64,0},
    [I(25,31)] = {64,0},
    [I(26,31)] = {64,0},
    [I(27,31)] = {64,0},
    [I(28,31)] = {64,0},
    [I(29,31)] = {64,0},
    [I(30,31)] = {64,0},
    [I(31,31)] = {64,0},
    [I(32,31)] = {64,0},
    [I(33,31)] = {64,0},
    [I(34,31)] = {64,0},
    [I(35,31)] = {64,0},
    [I(36,31)] = {64,0},
    [I(37,31)] = {64,0},
    [I(38,31)] = {64,0},
    [I(39,31)] = {64,0},
    [I(40,31)] = {64,0},
    [I(41,31)] = {64,0},
    [I(42,31)] = {64,0},
    [I(43,31)] = {64,0},
    [I(44,31)] = {64,0},
    [I(45,31)] = {64,0},
    [I(46,31)] = {64,0},
    [I(47,31)] = {64,0},
    [I(48,31)] = {64,0},
    [I(49,31)] = {64,0},
    [I(50,31)] = {64,0},
    [I(51,31)] = {64,0},
    [I(52,31)] = {64,0},
    [I(53,31)] = {64,0},
    [I(54,31)] = {64,0},
    [I(55,31)] = {64,0},
    [I(56,31)] = {64,0},
    [I(57,31)] = {64,0},
    [I(58,31)] = {64,0},
    [I(59,31)] = {64,0},
    [I(60,31)] = {64,0},
    [I(61,31)] = {64,0},
    [I(62,31)] = {64,0},
    [I(63,31)] = {64,0},
    [I(64,31)] = {64,0},
    [I(65,31)] = {64,0},
    [I(66,31)] = {64,0},
    [I(67,31)] = {64,0},
    [I(68,31)] = {64,0},
    [I(69,31)] = {64,0},
    [I(70,31)] = {64,0},
    [I(71,31)] = {64,0},
    [I(72,31)] = {64,0},
    [I(73,31)] = {64,0},
    [I(74,31)] = {64,0},
    [I(75,31)] = {64,0},
    [I(76,31)] = {64,0},
    [I(77,31)] = {64,0},
    [I(78,31)] = {64,0},
    [I(79,31)] = {64,0},
    [I(80,31)] = {64,0},
    [I(81,31)] = {64,0},
    [I(82,31)] = {64,0},
    [I(83,31)] = {64,0},
    [I(84,31)] = {64,0},
    [I(85,31)] = {64,0},
    [I(86,31)] = {64,0},
    [I(87,31)] = {64,0},
    [I(88,31)] = {64,0},
    [I(89,31)] = {64,0},
    [I(90,31)] = {64,0},
    [I(91,31)] = {64,0},
    [I(92,31)] = {64,0},
    [I(93,31)] = {64,0},
    [I(94,31)] = {64,0},
    [I(95,31)] = {64,0},
    [I(96,31)] = {64,0},
    [I(97,31)] = {64,0},
    [I(98,31)] = {64,0},
    [I(99,31)] = {64,0},
    [I(100,31)] = {64,0},
    [I(101,31)] = {64,0},
    [I(102,31)] = {64,0},
    [I(103,31)] = {64,0},
    [I(104,31)] = {64,0},
    [I(105,31)] = {64,0},
    [I(106,31)] = {64,0},
    [I(107,31)] = {64,0},
    [I(108,31)] = {64,0},
    [I(109,31)] = {64,0},
    [I(110,31)] = {64,0},
    [I(111,31)] = {64,0},
    [I(112,31)] = {64,0},
    [I(113,31)] = {64,0},
    [I(114,31)] = {64,0},
    [I(115,31)] = {64,0},
    [I(116,31)] = {64,0},
    [I(117,31)] = {64,0},
    [I(118,31)] = {64,0},
    [I(119,31)] = {64,0},
    [I(120,31)] = {64,0},
    [I(121,31)] = {64,0},
    [I(122,31)] = {64,0},
    [I(123,31)] = {64,0},
    [I(124,31)] = {64,0},
    [I(125,31)] = {64,0},
    [I(126,31)] = {64,0},
    [I(127,31)] = {64,0},
    [I(128,31)] = {64,0},
    [I(129,31)] = {64,0},
    [I(130,31)] = {64,0},
    [I(131,31)] = {64,0},
    [I(132,31)] = {64,0},
    [I(133,31)] = {64,0},
    [I(134,31)] = {64,0},
    [I(135,31)] = {64,0},
    [I(136,31)] = {64,0},
    [I(137,31)] = {64,0},
    [I(138,31)] = {64,0},
    [I(139,31)] = {64,0},
    [I(140,31)] = {64,0},
    [I(141,31)] = {64,0},
    [I(142,31)] = {64,0},
    [I(143,31)] = {64,0},
    [I(144,31)] = {64,0},
    [I(145,31)] = {64,0},
    [I(146,31)] = {64,0},
    [I(147,31)] = {64,0},
    [I(148,31)] = {64,0},
    [I(149,31)] = {64,0},
    [I(150,31)] = {64,0},
    [I(151,31)] = {64,0},
    [I(152,31)] = {64,0},
    [I(153,31)] = {64,0},
    [I(154,31)] = {64,0},
    [I(155,31)] = {64,0},
    [I(156,31)] = {64,0},
    [I(157,31)] = {64,0},
    [I(158,31)] = {64,0},
    [I(159,31)] = {64,0},
    [I(160,31)] = {64,0},
    [I(161,31)] = {64,0},
    [I(162,31)] = {64,0},
    [I(163,31)] = {64,0},
    [I(164,31)] = {64,0},
    [I(165,31)] = {64,0},
    [I(166,31)] = {64,0},
    [I(167,31)] = {64,0},
    [I(168,31)] = {64,0},
    [I(169,31)] = {64,0},
    [I(170,31)] = {64,0},
    [I(171,31)] = {64,0},
    [I(172,31)] = {64,0},
    [I(173,31)] = {64,0},
    [I(174,31)] = {64,0},
    [I(175,31)] = {64,0},
    [I(176,31)] = {64,0},
    [I(177,31)] = {64,0},
    [I(178,31)] = {64,0},
    [I(179,31)] = {64,0},
    [I(180,31)] = {64,0},
    [I(181,31)] = {64,0},
    [I(182,31)] = {64,0},
    [I(183,31)] = {64,0},
    [I(184,31)] = {64,0},
    [I(185,31)] = {64,0},
    [I(186,31)] = {64,0},
    [I(187,31)] = {64,0},
    [I(188,31)] = {64,0},
    [I(189,31)] = {64,0},
    [I(190,31)] = {64,0},
    [I(191,31)] = {64,0},
    [I(192,31)] = {64,0},
    [I(193,31)] = {64,0},
    [I(194,31)] = {64,0},
    [I(195,31)] = {64,0},
    [I(196,31)] = {64,0},
    [I(197,31)] = {64,0},
    [I(198,31)] = {64,0},
    [I(199,31)] = {64,0},
    [I(200,31)] = {64,0},
    [I(201,31)] = {64,0},
    [I(202,31)] = {64,0},
    [I(203,31)] = {64,0},
    [I(204,31)] = {64,0},
    [I(205,31)] = {64,0},
    [I(206,31)] = {64,0},
    [I(207,31)] = {64,0},
    [I(208,31)] = {64,0},
    [I(209,31)] = {64,0},
    [I(210,31)] = {64,0},
    [I(211,31)] = {64,0},
    [I(212,31)] = {64,0},
    [I(213,31)] = {64,0},
    [I(214,31)] = {64,0},
    [I(215,31)] = {64,0},
    [I(216,31)] = {64,0},
    [I(217,31)] = {64,0},
    [I(218,31)] = {64,0},
    [I(219,31)] = {64,0},
    [I(220,31)] = {64,0},
    [I(221,31)] = {64,0},
    [I(222,31)] = {64,0},
    [I(223,31)] = {64,0},
    [I(224,31)] = {64,0},
    [I(225,31)] = {64,0},
    [I(226,31)] = {64,0},
    [I(227,31)] = {64,0},
    [I(228,31)] = {64,0},
    [I(229,31)] = {64,0},
    [I(230,31)] = {64,0},
    [I(231,31)] = {64,0},
    [I(232,31)] = {64,0},
    [I(233,31)] = {64,0},
    [I(234,31)] = {64,0},
    [I(235,31)] = {64,0},
    [I(236,31)] = {64,0},
    [I(237,31)] = {64,0},
    [I(238,31)] = {64,0},
    [I(239,31)] = {64,0},
    [I(240,31)] = {64,0},
    [I(241,31)] = {64,0},
    [I(242,31)] = {64,0},
    [I(243,31)] = {64,0},
    [I(244,31)] = {64,0},
    [I(245,31)] = {64,0},
    [I(246,31)] = {64,0},
    [I(247,31)] = {64,0},
    [I(248,31)] = {64,0},
    [I(249,31)] = {64,0},
    [I(250,31)] = {64,0},
    [I(251,31)] = {64,0},
    [I(252,31)] = {64,0},
    [I(253,31)] = {64,0},
    [I(254,31)] = {64,0},
    [I(255,31)] = {64,0},
    [I(0,32)] = {19,0x7FE14},
    [I(1,32)] = {29,0x1FFFF614},
    [I(2,32)] = {64,0},
    [I(3,32)] = {64,0},
    [I(4,32)] = {64,0},
    [I(5,32)] = {64,0},
    [I(6,32)] = {64,0},
    [I(7,32)] = {64,0},
    [I(8,32)] = {64,0},
    [I(9,32)] = {30,0x3FFFFA94},
    [I(10,32)] = {64,0},
    [I(11,32)] = {64,0},
    [I(12,32)] = {64,0},
    [I(13,32)] = {64,0},
    [I(14,32)] = {64,0},
    [I(15,32)] = {64,0},
    [I(16,32)] = {64,0},
    [I(17,32)] = {64,0},
    [I(18,32)] = {64,0},
    [I(19,32)] = {64,0},
    [I(20,32)] = {64,0},
    [I(21,32)] = {64,0},
    [I(22,32)] = {64,0},
    [I(23,32)] = {64,0},
    [I(24,32)] = {64,0},
    [I(25,32)] = {64,0},
    [I(26,32)] = {64,0},
    [I(27,32)] = {64,0},
    [I(28,32)] = {64,0},
    [I(29,32)] = {64,0},
    [I(30,32)] = {64,0},
    [I(31,32)] = {64,0},
    [I(32,32)] = {12,0x514},
    [I(33,32)] = {16,0xFE14},
    [I(34,32)] = {16,0xFE54},
    [I(35,32)] = {18,0x3FE94},
    [I(36,32)] = {19,0x7FE54},
    [I(37,32)] = {12,0x554},
    [I(38,32)] = {14,0x3E14},
    [I(39,32)] = {17,0x1FE94},
    [I(40,32)] = {16,0xFE94},
    [I(41,32)] = {16,0xFED4},
    [I(42,32)] = {14,0x3E54},
    [I(43,32)] = {17,0x1FED4},
    [I(44,32)] = {14,0x3E94},
    [I(45,32)] = {12,0x594},
    [I(46,32)] = {12,0x5D4},
    [I(47,32)] = {12,0x614},
    [I(48,32)] = {11,0x14},
    [I(49,32)] = {11,0x54},
    [I(50,32)] = {11,0x94},
    [I(51,32)] = {12,0x654},
    [I(52,32)] = {12,0x694},
    [I(53,32)] = {12,0x6D4},
    [I(54,32)] = {12,0x714},
    [I(55,32)] = {12,0x754},
    [I(56,32)] = {12,0x794},
    [I(57,32)] = {12,0x7D4},
    [I(58,32)] = {13,0x1714},
    [I(59,32)] = {14,0x3ED4},
    [I(60,32)] = {21,0x1FFF14},
    [I(61,32)] = {12,0x814},
    [I(62,32)] = {18,0x3FED4},
    [I(63,32)] = {16,0xFF14},
    [I(64,32)] = {19,0x7FE94},
    [I(65,32)] = {12,0x854},
    [I(66,32)] = {13,0x1754},
    [I(67,32)] = {13,0x1794},
    [I(68,32)] = {13,0x17D4},
    [I(69,32)] = {13,0x1814},
    [I(70,32)] = {13,0x1854},
    [I(71,32)] = {13,0x1894},
    [I(72,32)] = {13,0x18D4},
    [I(73,32)] = {13,0x1914},
    [I(74,32)] = {13,0x1954},
    [I(75,32)] = {13,0x1994},
    [I(76,32)] = {13,0x19D4},
    [I(77,32)] = {13,0x1A14},
    [I(78,32)] = {13,0x1A54},
    [I(79,32)] = {13,0x1A94},
    [I(80,32)] = {13,0x1AD4},
    [I(81,32)] = {13,0x1B14},
    [I(82,32)] = {13,0x1B54},
    [I(83,32)] = {13,0x1B94},
    [I(84,32)] = {13,0x1BD4},
    [I(85,32)] = {13,0x1C14},
    [I(86,32)] = {13,0x1C54},
    [I(87,32)] = {13,0x1C94},
    [I(88,32)] = {14,0x3F14},
    [I(89,32)] = {13,0x1CD4},
    [I(90,32)] = {14,0x3F54},
    [I(91,32)] = {19,0x7FED4},
    [I(92,32)] = {25,0x1FFFC14},
    [I(93,32)] = {19,0x7FF14},
    [I(94,32)] = {20,0xFFF14},
    [I(95,32)] = {12,0x894},
    [I(96,32)] = {21,0x1FFF54},
    [I(97,32)] = {11,0xD4},
    [I(98,32)] = {12,0x8D4},
    [I(99,32)] = {11,0x114},
    [I(100,32)] = {12,0x914},
    [I(101,32)] = {11,0x154},
    [I(102,32)] = {12,0x954},
    [I(103,32)] = {12,0x994},
    [I(104,32)] = {12,0x9D4},
    [I(105,32)] = {11,0x194},
    [I(106,32)] = {13,0x1D14},
    [I(107,32)] = {13,0x1D54},
    [I(108,32)] = {12,0xA14},
    [I(109,32)] = {12,0xA54},
    [I(110,32)] = {12,0xA94},
    [I(111,32)] = {11,0x1D4},
    [I(112,32)] = {12,0xAD4},
    [I(113,32)] = {13,0x1D94},
    [I(114,32)] = {12,0xB14},
    [I(115,32)] = {11,0x214},
    [I(116,32)] = {11,0x254},
    [I(117,32)] = {12,0xB54},
    [I(118,32)] = {13,0x1DD4},
    [I(119,32)] = {13,0x1E14},
    [I(120,32)] = {13,0x1E54},
    [I(121,32)] = {13,0x1E94},
    [I(122,32)] = {13,0x1ED4},
    [I(123,32)] = {21,0x1FFF94},
    [I(124,32)] = {17,0x1FF14},
    [I(125,32)] = {20,0xFFF54},
    [I(126,32)] = {19,0x7FF54},
    [I(127,32)] = {64,0},
    [I(128,32)] = {26,0x3FFF994},
    [I(129,32)] = {28,0xFFFF494},
    [I(130,32)] = {26,0x3FFF9D4},
    [I(131,32)] = {26,0x3FFFA14},
    [I(132,32)] = {28,0xFFFF4D4},
    [I(133,32)] = {28,0xFFFF514},
    [I(134,32)] = {28,0xFFFF554},
    [I(135,32)] = {29,0x1FFFF654},
    [I(136,32)] = {28,0xFFFF594},
    [I(137,32)] = {29,0x1FFFF694},
    [I(138,32)] = {29,0x1FFFF6D4},
    [I(139,32)] = {29,0x1FFFF714},
    [I(140,32)] = {29,0x1FFFF754},
    [I(141,32)] = {29,0x1FFFF794},
    [I(142,32)] = {30,0x3FFFFAD4},
    [I(143,32)] = {29,0x1FFFF7D4},
    [I(144,32)] = {30,0x3FFFFB14},
    [I(145,32)] = {30,0x3FFFFB54},
    [I(146,32)] = {28,0xFFFF5D4},
    [I(147,32)] = {29,0x1FFFF814},
    [I(148,32)] = {30,0x3FFFFB94},
    [I(149,32)] = {29,0x1FFFF854},
    [I(150,32)] = {29,0x1FFFF894},
    [I(151,32)] = {29,0x1FFFF8D4},
    [I(152,32)] = {29,0x1FFFF914},
    [I(153,32)] = {27,0x7FFF714},
    [I(154,32)] = {28,0xFFFF614},
    [I(155,32)] = {29,0x1FFFF954},
    [I(156,32)] = {28,0xFFFF654},
    [I(157,32)] = {29,0x1FFFF994},
    [I(158,32)] = {29,0x1FFFF9D4},
    [I(159,32)] = {30,0x3FFFFBD4},
    [I(160,32)] = {28,0xFFFF694},
    [I(161,32)] = {27,0x7FFF754},
    [I(162,32)] = {26,0x3FFFA54},
    [I(163,32)] = {28,0xFFFF6D4},
    [I(164,32)] = {28,0xFFFF714},
    [I(165,32)] = {29,0x1FFFFA14},
    [I(166,32)] = {29,0x1FFFFA54},
    [I(167,32)] = {27,0x7FFF794},
    [I(168,32)] = {29,0x1FFFFA94},
    [I(169,32)] = {28,0xFFFF754},
    [I(170,32)] = {28,0xFFFF794},
    [I(171,32)] = {30,0x3FFFFC14},
    [I(172,32)] = {27,0x7FFF7D4},
    [I(173,32)] = {28,0xFFFF7D4},
    [I(174,32)] = {29,0x1FFFFAD4},
    [I(175,32)] = {29,0x1FFFFB14},
    [I(176,32)] = {27,0x7FFF814},
    [I(177,32)] = {27,0x7FFF854},
    [I(178,32)] = {28,0xFFFF814},
    [I(179,32)] = {27,0x7FFF894},
    [I(180,32)] = {29,0x1FFFFB54},
    [I(181,32)] = {28,0xFFFF854},
    [I(182,32)] = {29,0x1FFFFB94},
    [I(183,32)] = {29,0x1FFFFBD4},
    [I(184,32)] = {26,0x3FFFA94},
    [I(185,32)] = {28,0xFFFF894},
    [I(186,32)] = {28,0xFFFF8D4},
    [I(187,32)] = {28,0xFFFF914},
    [I(188,32)] = {29,0x1FFFFC14},
    [I(189,32)] = {28,0xFFFF954},
    [I(190,32)] = {28,0xFFFF994},
    [I(191,32)] = {29,0x1FFFFC54},
    [I(192,32)] = {X32,0xFFFFF814},
    [I(193,32)] = {X32,0xFFFFF854},
    [I(194,32)] = {26,0x3FFFAD4},
    [I(195,32)] = {25,0x1FFFC54},
    [I(196,32)] = {28,0xFFFF9D4},
    [I(197,32)] = {29,0x1FFFFC94},
    [I(198,32)] = {28,0xFFFFA14},
    [I(199,32)] = {31,0x7FFFFB14},
    [I(200,32)] = {X32,0xFFFFF894},
    [I(201,32)] = {X32,0xFFFFF8D4},
    [I(202,32)] = {X32,0xFFFFF914},
    [I(203,32)] = {64,0},
    [I(204,32)] = {64,0},
    [I(205,32)] = {X32,0xFFFFF954},
    [I(206,32)] = {30,0x3FFFFC54},
    [I(207,32)] = {31,0x7FFFFB54},
    [I(208,32)] = {25,0x1FFFC94},
    [I(209,32)] = {27,0x7FFF8D4},
    [I(210,32)] = {X32,0xFFFFF994},
    [I(211,32)] = {64,0},
    [I(212,32)] = {64,0},
    [I(213,32)] = {X32,0xFFFFF9D4},
    [I(214,32)] = {64,0},
    [I(215,32)] = {30,0x3FFFFC94},
    [I(216,32)] = {27,0x7FFF914},
    [I(217,32)] = {27,0x7FFF954},
    [I(218,32)] = {X32,0xFFFFFA14},
    [I(219,32)] = {X32,0xFFFFFA54},
    [I(220,32)] = {64,0},
    [I(221,32)] = {64,0},
    [I(222,32)] = {64,0},
    [I(223,32)] = {64,0},
    [I(224,32)] = {26,0x3FFFB14},
    [I(225,32)] = {30,0x3FFFFCD4},
    [I(226,32)] = {26,0x3FFFB54},
    [I(227,32)] = {27,0x7FFF994},
    [I(228,32)] = {28,0xFFFFA54},
    [I(229,32)] = {27,0x7FFF9D4},
    [I(230,32)] = {27,0x7FFFA14},
    [I(231,32)] = {29,0x1FFFFCD4},
    [I(232,32)] = {28,0xFFFFA94},
    [I(233,32)] = {28,0xFFFFAD4},
    [I(234,32)] = {31,0x7FFFFB94},
    [I(235,32)] = {31,0x7FFFFBD4},
    [I(236,32)] = {30,0x3FFFFD14},
    [I(237,32)] = {30,0x3FFFFD54},
    [I(238,32)] = {X32,0xFFFFFA94},
    [I(239,32)] = {29,0x1FFFFD14},
    [I(240,32)] = {X32,0xFFFFFAD4},
    [I(241,32)] = {64,0},
    [I(242,32)] = {X32,0xFFFFFB14},
    [I(243,32)] = {X32,0xFFFFFB54},
    [I(244,32)] = {64,0},
    [I(245,32)] = {64,0},
    [I(246,32)] = {64,0},
    [I(247,32)] = {64,0},
    [I(248,32)] = {64,0},
    [I(249,32)] = {64,0},
    [I(250,32)] = {64,0},
    [I(251,32)] = {64,0},
    [I(252,32)] = {64,0},
    [I(253,32)] = {64,0},
    [I(254,32)] = {64,0},
    [I(255,32)] = {X32,0xFFFFFB94},
    [I(0,33)] = {23,0x7FE3F8},
    [I(1,33)] = {64,0},
    [I(2,33)] = {64,0},
    [I(3,33)] = {64,0},
    [I(4,33)] = {64,0},
    [I(5,33)] = {64,0},
    [I(6,33)] = {64,0},
    [I(7,33)] = {64,0},
    [I(8,33)] = {64,0},
    [I(9,33)] = {64,0},
    [I(10,33)] = {64,0},
    [I(11,33)] = {64,0},
    [I(12,33)] = {64,0},
    [I(13,33)] = {64,0},
    [I(14,33)] = {64,0},
    [I(15,33)] = {64,0},
    [I(16,33)] = {64,0},
    [I(17,33)] = {64,0},
    [I(18,33)] = {64,0},
    [I(19,33)] = {64,0},
    [I(20,33)] = {64,0},
    [I(21,33)] = {64,0},
    [I(22,33)] = {64,0},
    [I(23,33)] = {64,0},
    [I(24,33)] = {64,0},
    [I(25,33)] = {64,0},
    [I(26,33)] = {64,0},
    [I(27,33)] = {64,0},
    [I(28,33)] = {64,0},
    [I(29,33)] = {64,0},
    [I(30,33)] = {64,0},
    [I(31,33)] = {64,0},
    [I(32,33)] = {16,0x53F8},
    [I(33,33)] = {20,0xFE3F8},
    [I(34,33)] = {20,0xFE7F8},
    [I(35,33)] = {22,0x3FEBF8},
    [I(36,33)] = {23,0x7FE7F8},
    [I(37,33)] = {16,0x57F8},
    [I(38,33)] = {18,0x3E3F8},
    [I(39,33)] = {21,0x1FEBF8},
    [I(40,33)] = {20,0xFEBF8},
    [I(41,33)] = {20,0xFEFF8},
    [I(42,33)] = {18,0x3E7F8},
    [I(43,33)] = {21,0x1FEFF8},
    [I(44,33)] = {18,0x3EBF8},
    [I(45,33)] = {16,0x5BF8},
    [I(46,33)] = {16,0x5FF8},
    [I(47,33)] = {16,0x63F8},
    [I(48,33)] = {15,0x3F8},
    [I(49,33)] = {15,0x7F8},
    [I(50,33)] = {15,0xBF8},
    [I(51,33)] = {16,0x67F8},
    [I(52,33)] = {16,0x6BF8},
    [I(53,33)] = {16,0x6FF8},
    [I(54,33)] = {16,0x73F8},
    [I(55,33)] = {16,0x77F8},
    [I(56,33)] = {16,0x7BF8},
    [I(57,33)] = {16,0x7FF8},
    [I(58,33)] = {17,0x173F8},
    [I(59,33)] = {18,0x3EFF8},
    [I(60,33)] = {25,0x1FFF3F8},
    [I(61,33)] = {16,0x83F8},
    [I(62,33)] = {22,0x3FEFF8},
    [I(63,33)] = {20,0xFF3F8},
    [I(64,33)] = {23,0x7FEBF8},
    [I(65,33)] = {16,0x87F8},
    [I(66,33)] = {17,0x177F8},
    [I(67,33)] = {17,0x17BF8},
    [I(68,33)] = {17,0x17FF8},
    [I(69,33)] = {17,0x183F8},
    [I(70,33)] = {17,0x187F8},
    [I(71,33)] = {17,0x18BF8},
    [I(72,33)] = {17,0x18FF8},
    [I(73,33)] = {17,0x193F8},
    [I(74,33)] = {17,0x197F8},
    [I(75,33)] = {17,0x19BF8},
    [I(76,33)] = {17,0x19FF8},
    [I(77,33)] = {17,0x1A3F8},
    [I(78,33)] = {17,0x1A7F8},
    [I(79,33)] = {17,0x1ABF8},
    [I(80,33)] = {17,0x1AFF8},
    [I(81,33)] = {17,0x1B3F8},
    [I(82,33)] = {17,0x1B7F8},
    [I(83,33)] = {17,0x1BBF8},
    [I(84,33)] = {17,0x1BFF8},
    [I(85,33)] = {17,0x1C3F8},
    [I(86,33)] = {17,0x1C7F8},
    [I(87,33)] = {17,0x1CBF8},
    [I(88,33)] = {18,0x3F3F8},
    [I(89,33)] = {17,0x1CFF8},
    [I(90,33)] = {18,0x3F7F8},
    [I(91,33)] = {23,0x7FEFF8},
    [I(92,33)] = {29,0x1FFFC3F8},
    [I(93,33)] = {23,0x7FF3F8},
    [I(94,33)] = {24,0xFFF3F8},
    [I(95,33)] = {16,0x8BF8},
    [I(96,33)] = {25,0x1FFF7F8},
    [I(97,33)] = {15,0xFF8},
    [I(98,33)] = {16,0x8FF8},
    [I(99,33)] = {15,0x13F8},
    [I(100,33)] = {16,0x93F8},
    [I(101,33)] = {15,0x17F8},
    [I(102,33)] = {16,0x97F8},
    [I(103,33)] = {16,0x9BF8},
    [I(104,33)] = {16,0x9FF8},
    [I(105,33)] = {15,0x1BF8},
    [I(106,33)] = {17,0x1D3F8},
    [I(107,33)] = {17,0x1D7F8},
    [I(108,33)] = {16,0xA3F8},
    [I(109,33)] = {16,0xA7F8},
    [I(110,33)] = {16,0xABF8},
    [I(111,33)] = {15,0x1FF8},
    [I(112,33)] = {16,0xAFF8},
    [I(113,33)] = {17,0x1DBF8},
    [I(114,33)] = {16,0xB3F8},
    [I(115,33)] = {15,0x23F8},
    [I(116,33)] = {15,0x27F8},
    [I(117,33)] = {16,0xB7F8},
    [I(118,33)] = {17,0x1DFF8},
    [I(119,33)] = {17,0x1E3F8},
    [I(120,33)] = {17,0x1E7F8},
    [I(121,33)] = {17,0x1EBF8},
    [I(122,33)] = {17,0x1EFF8},
    [I(123,33)] = {25,0x1FFFBF8},
    [I(124,33)] = {21,0x1FF3F8},
    [I(125,33)] = {24,0xFFF7F8},
    [I(126,33)] = {23,0x7FF7F8},
    [I(127,33)] = {64,0},
    [I(128,33)] = {30,0x3FFF9BF8},
    [I(129,33)] = {X32,0xFFFF4BF8},
    [I(130,33)] = {30,0x3FFF9FF8},
    [I(131,33)] = {30,0x3FFFA3F8},
    [I(132,33)] = {X32,0xFFFF4FF8},
    [I(133,33)] = {X32,0xFFFF53F8},
    [I(134,33)] = {X32,0xFFFF57F8},
    [I(135,33)] = {64,0},
    [I(136,33)] = {X32,0xFFFF5BF8},
    [I(137,33)] = {64,0},
    [I(138,33)] = {64,0},
    [I(139,33)] = {64,0},
    [I(140,33)] = {64,0},
    [I(141,33)] = {64,0},
    [I(142,33)] = {64,0},
    [I(143,33)] = {64,0},
    [I(144,33)] = {64,0},
    [I(145,33)] = {64,0},
    [I(146,33)] = {X32,0xFFFF5FF8},
    [I(147,33)] = {64,0},
    [I(148,33)] = {64,0},
    [I(149,33)] = {64,0},
    [I(150,33)] = {64,0},
    [I(151,33)] = {64,0},
    [I(152,33)] = {64,0},
    [I(153,33)] = {31,0x7FFF73F8},
    [I(154,33)] = {X32,0xFFFF63F8},
    [I(155,33)] = {64,0},
    [I(156,33)] = {X32,0xFFFF67F8},
    [I(157,33)] = {64,0},
    [I(158,33)] = {64,0},
    [I(159,33)] = {64,0},
    [I(160,33)] = {X32,0xFFFF6BF8},
    [I(161,33)] = {31,0x7FFF77F8},
    [I(162,33)] = {30,0x3FFFA7F8},
    [I(163,33)] = {X32,0xFFFF6FF8},
    [I(164,33)] = {X32,0xFFFF73F8},
    [I(165,33)] = {64,0},
    [I(166,33)] = {64,0},
    [I(167,33)] = {31,0x7FFF7BF8},
    [I(168,33)] = {64,0},
    [I(169,33)] = {X32,0xFFFF77F8},
    [I(170,33)] = {X32,0xFFFF7BF8},
    [I(171,33)] = {64,0},
    [I(172,33)] = {31,0x7FFF7FF8},
    [I(173,33)] = {X32,0xFFFF7FF8},
    [I(174,33)] = {64,0},
    [I(175,33)] = {64,0},
    [I(176,33)] = {31,0x7FFF83F8},
    [I(177,33)] = {31,0x7FFF87F8},
    [I(178,33)] = {X32,0xFFFF83F8},
    [I(179,33)] = {31,0x7FFF8BF8},
    [I(180,33)] = {64,0},
    [I(181,33)] = {X32,0xFFFF87F8},
    [I(182,33)] = {64,0},
    [I(183,33)] = {64,0},
    [I(184,33)] = {30,0x3FFFABF8},
    [I(185,33)] = {X32,0xFFFF8BF8},
    [I(186,33)] = {X32,0xFFFF8FF8},
    [I(187,33)] = {X32,0xFFFF93F8},
    [I(188,33)] = {64,0},
    [I(189,33)] = {X32,0xFFFF97F8},
    [I(190,33)] = {X32,0xFFFF9BF8},
    [I(191,33)] = {64,0},
    [I(192,33)] = {64,0},
    [I(193,33)] = {64,0},
    [I(194,33)] = {30,0x3FFFAFF8},
    [I(195,33)] = {29,0x1FFFC7F8},
    [I(196,33)] = {X32,0xFFFF9FF8},
    [I(197,33)] = {64,0},
    [I(198,33)] = {X32,0xFFFFA3F8},
    [I(199,33)] = {64,0},
    [I(200,33)] = {64,0},
    [I(201,33)] = {64,0},
    [I(202,33)] = {64,0},
    [I(203,33)] = {64,0},
    [I(204,33)] = {64,0},
    [I(205,33)] = {64,0},
    [I(206,33)] = {64,0},
    [I(207,33)] = {64,0},
    [I(208,33)] = {29,0x1FFFCBF8},
    [I(209,33)] = {31,0x7FFF8FF8},
    [I(210,33)] = {64,0},
    [I(211,33)] = {64,0},
    [I(212,33)] = {64,0},
    [I(213,33)] = {64,0},
    [I(214,33)] = {64,0},
    [I(215,33)] = {64,0},
    [I(216,33)] = {31,0x7FFF93F8},
    [I(217,33)] = {31,0x7FFF97F8},
    [I(218,33)] = {64,0},
    [I(219,33)] = {64,0},
    [I(220,33)] = {64,0},
    [I(221,33)] = {64,0},
    [I(222,33)] = {64,0},
    [I(223,33)] = {64,0},
    [I(224,33)] = {30,0x3FFFB3F8},
    [I(225,33)] = {64,0},
    [I(226,33)] = {30,0x3FFFB7F8},
    [I(227,33)] = {31,0x7FFF9BF8},
    [I(228,33)] = {X32,0xFFFFA7F8},
    [I(229,33)] = {31,0x7FFF9FF8},
    [I(230,33)] = {31,0x7FFFA3F8},
    [I(231,33)] = {64,0},
    [I(232,33)] = {X32,0xFFFFABF8},
    [I(233,33)] = {X32,0xFFFFAFF8},
    [I(234,33)] = {64,0},
    [I(235,33)] = {64,0},
    [I(236,33)] = {64,0},
    [I(237,33)] = {64,0},
    [I(238,33)] = {64,0},
    [I(239,33)] = {64,0},
    [I(240,33)] = {64,0},
    [I(241,33)] = {64,0},
    [I(242,33)] = {64,0},
    [I(243,33)] = {64,0},
    [I(244,33)] = {64,0},
    [I(245,33)] = {64,0},
    [I(246,33)] = {64,0},
    [I(247,33)] = {64,0},
    [I(248,33)] = {64,0},
    [I(249,33)] = {64,0},
    [I(250,33)] = {64,0},
    [I(251,33)] = {64,0},
    [I(252,33)] = {64,0},
    [I(253,33)] = {64,0},
    [I(254,33)] = {64,0},
    [I(255,33)] = {64,0},
    [I(0,34)] = {23,0x7FE3F9},
    [I(1,34)] = {64,0},
    [I(2,34)] = {64,0},
    [I(3,34)] = {64,0},
    [I(4,34)] = {64,0},
    [I(5,34)] = {64,0},
    [I(6,34)] = {64,0},
    [I(7,34)] = {64,0},
    [I(8,34)] = {64,0},
    [I(9,34)] = {64,0},
    [I(10,34)] = {64,0},
    [I(11,34)] = {64,0},
    [I(12,34)] = {64,0},
    [I(13,34)] = {64,0},
    [I(14,34)] = {64,0},
    [I(15,34)] = {64,0},
    [I(16,34)] = {64,0},
    [I(17,34)] = {64,0},
    [I(18,34)] = {64,0},
    [I(19,34)] = {64,0},
    [I(20,34)] = {64,0},
    [I(21,34)] = {64,0},
    [I(22,34)] = {64,0},
    [I(23,34)] = {64,0},
    [I(24,34)] = {64,0},
    [I(25,34)] = {64,0},
    [I(26,34)] = {64,0},
    [I(27,34)] = {64,0},
    [I(28,34)] = {64,0},
    [I(29,34)] = {64,0},
    [I(30,34)] = {64,0},
    [I(31,34)] = {64,0},
    [I(32,34)] = {16,0x53F9},
    [I(33,34)] = {20,0xFE3F9},
    [I(34,34)] = {20,0xFE7F9},
    [I(35,34)] = {22,0x3FEBF9},
    [I(36,34)] = {23,0x7FE7F9},
    [I(37,34)] = {16,0x57F9},
    [I(38,34)] = {18,0x3E3F9},
    [I(39,34)] = {21,0x1FEBF9},
    [I(40,34)] = {20,0xFEBF9},
    [I(41,34)] = {20,0xFEFF9},
    [I(42,34)] = {18,0x3E7F9},
    [I(43,34)] = {21,0x1FEFF9},
    [I(44,34)] = {18,0x3EBF9},
    [I(45,34)] = {16,0x5BF9},
    [I(46,34)] = {16,0x5FF9},
    [I(47,34)] = {16,0x63F9},
    [I(48,34)] = {15,0x3F9},
    [I(49,34)] = {15,0x7F9},
    [I(50,34)] = {15,0xBF9},
    [I(51,34)] = {16,0x67F9},
    [I(52,34)] = {16,0x6BF9},
    [I(53,34)] = {16,0x6FF9},
    [I(54,34)] = {16,0x73F9},
    [I(55,34)] = {16,0x77F9},
    [I(56,34)] = {16,0x7BF9},
    [I(57,34)] = {16,0x7FF9},
    [I(58,34)] = {17,0x173F9},
    [I(59,34)] = {18,0x3EFF9},
    [I(60,34)] = {25,0x1FFF3F9},
    [I(61,34)] = {16,0x83F9},
    [I(62,34)] = {22,0x3FEFF9},
    [I(63,34)] = {20,0xFF3F9},
    [I(64,34)] = {23,0x7FEBF9},
    [I(65,34)] = {16,0x87F9},
    [I(66,34)] = {17,0x177F9},
    [I(67,34)] = {17,0x17BF9},
    [I(68,34)] = {17,0x17FF9},
    [I(69,34)] = {17,0x183F9},
    [I(70,34)] = {17,0x187F9},
    [I(71,34)] = {17,0x18BF9},
    [I(72,34)] = {17,0x18FF9},
    [I(73,34)] = {17,0x193F9},
    [I(74,34)] = {17,0x197F9},
    [I(75,34)] = {17,0x19BF9},
    [I(76,34)] = {17,0x19FF9},
    [I(77,34)] = {17,0x1A3F9},
    [I(78,34)] = {17,0x1A7F9},
    [I(79,34)] = {17,0x1ABF9},
    [I(80,34)] = {17,0x1AFF9},
    [I(81,34)] = {17,0x1B3F9},
    [I(82,34)] = {17,0x1B7F9},
    [I(83,34)] = {17,0x1BBF9},
    [I(84,34)] = {17,0x1BFF9},
    [I(85,34)] = {17,0x1C3F9},
    [I(86,34)] = {17,0x1C7F9},
    [I(87,34)] = {17,0x1CBF9},
    [I(88,34)] = {18,0x3F3F9},
    [I(89,34)] = {17,0x1CFF9},
    [I(90,34)] = {18,0x3F7F9},
    [I(91,34)] = {23,0x7FEFF9},
    [I(92,34)] = {29,0x1FFFC3F9},
    [I(93,34)] = {23,0x7FF3F9},
    [I(94,34)] = {24,0xFFF3F9},
    [I(95,34)] = {16,0x8BF9},
    [I(96,34)] = {25,0x1FFF7F9},
    [I(97,34)] = {15,0xFF9},
    [I(98,34)] = {16,0x8FF9},
    [I(99,34)] = {15,0x13F9},
    [I(100,34)] = {16,0x93F9},
    [I(101,34)] = {15,0x17F9},
    [I(102,34)] = {16,0x97F9},
    [I(103,34)] = {16,0x9BF9},
    [I(104,34)] = {16,0x9FF9},
    [I(105,34)] = {15,0x1BF9},
    [I(106,34)] = {17,0x1D3F9},
    [I(107,34)] = {17,0x1D7F9},
    [I(108,34)] = {16,0xA3F9},
    [I(109,34)] = {16,0xA7F9},
    [I(110,34)] = {16,0xABF9},
    [I(111,34)] = {15,0x1FF9},
    [I(112,34)] = {16,0xAFF9},
    [I(113,34)] = {17,0x1DBF9},
    [I(114,34)] = {16,0xB3F9},
    [I(115,34)] = {15,0x23F9},
    [I(116,34)] = {15,0x27F9},
    [I(117,34)] = {16,0xB7F9},
    [I(118,34)] = {17,0x1DFF9},
    [I(119,34)] = {17,0x1E3F9},
    [I(120,34)] = {17,0x1E7F9},
    [I(121,34)] = {17,0x1EBF9},
    [I(122,34)] = {17,0x1EFF9},
    [I(123,34)] = {25,0x1FFFBF9},
    [I(124,34)] = {21,0x1FF3F9},
    [I(125,34)] = {24,0xFFF7F9},
    [I(126,34)] = {23,0x7FF7F9},
    [I(127,34)] = {64,0},
    [I(128,34)] = {30,0x3FFF9BF9},
    [I(129,34)] = {X32,0xFFFF4BF9},
    [I(130,34)] = {30,0x3FFF9FF9},
    [I(131,34)] = {30,0x3FFFA3F9},
    [I(132,34)] = {X32,0xFFFF4FF9},
    [I(133,34)] = {X32,0xFFFF53F9},
    [I(134,34)] = {X32,0xFFFF57F9},
    [I(135,34)] = {64,0},
    [I(136,34)] = {X32,0xFFFF5BF9},
    [I(137,34)] = {64,0},
    [I(138,34)] = {64,0},
    [I(139,34)] = {64,0},
    [I(140,34)] = {64,0},
    [I(141,34)] = {64,0},
    [I(142,34)] = {64,0},
    [I(143,34)] = {64,0},
    [I(144,34)] = {64,0},
    [I(145,34)] = {64,0},
    [I(146,34)] = {X32,0xFFFF5FF9},
    [I(147,34)] = {64,0},
    [I(148,34)] = {64,0},
    [I(149,34)] = {64,0},
    [I(150,34)] = {64,0},
    [I(151,34)] = {64,0},
    [I(152,34)] = {64,0},
    [I(153,34)] = {31,0x7FFF73F9},
    [I(154,34)] = {X32,0xFFFF63F9},
    [I(155,34)] = {64,0},
    [I(156,34)] = {X32,0xFFFF67F9},
    [I(157,34)] = {64,0},
    [I(158,34)] = {64,0},
    [I(159,34)] = {64,0},
    [I(160,34)] = {X32,0xFFFF6BF9},
    [I(161,34)] = {31,0x7FFF77F9},
    [I(162,34)] = {30,0x3FFFA7F9},
    [I(163,34)] = {X32,0xFFFF6FF9},
    [I(164,34)] = {X32,0xFFFF73F9},
    [I(165,34)] = {64,0},
    [I(166,34)] = {64,0},
    [I(167,34)] = {31,0x7FFF7BF9},
    [I(168,34)] = {64,0},
    [I(169,34)] = {X32,0xFFFF77F9},
    [I(170,34)] = {X32,0xFFFF7BF9},
    [I(171,34)] = {64,0},
    [I(172,34)] = {31,0x7FFF7FF9},
    [I(173,34)] = {X32,0xFFFF7FF9},
    [I(174,34)] = {64,0},
    [I(175,34)] = {64,0},
    [I(176,34)] = {31,0x7FFF83F9},
    [I(177,34)] = {31,0x7FFF87F9},
    [I(178,34)] = {X32,0xFFFF83F9},
    [I(179,34)] = {31,0x7FFF8BF9},
    [I(180,34)] = {64,0},
    [I(181,34)] = {X32,0xFFFF87F9},
    [I(182,34)] = {64,0},
    [I(183,34)] = {64,0},
    [I(184,34)] = {30,0x3FFFABF9},
    [I(185,34)] = {X32,0xFFFF8BF9},
    [I(186,34)] = {X32,0xFFFF8FF9},
    [I(187,34)] = {X32,0xFFFF93F9},
    [I(188,34)] = {64,0},
    [I(189,34)] = {X32,0xFFFF97F9},
    [I(190,34)] = {X32,0xFFFF9BF9},
    [I(191,34)] = {64,0},
    [I(192,34)] = {64,0},
    [I(193,34)] = {64,0},
    [I(194,34)] = {30,0x3FFFAFF9},
    [I(195,34)] = {29,0x1FFFC7F9},
    [I(196,34)] = {X32,0xFFFF9FF9},
    [I(197,34)] = {64,0},
    [I(198,34)] = {X32,0xFFFFA3F9},
    [I(199,34)] = {64,0},
    [I(200,34)] = {64,0},
    [I(201,34)] = {64,0},
    [I(202,34)] = {64,0},
    [I(203,34)] = {64,0},
    [I(204,34)] = {64,0},
    [I(205,34)] = {64,0},
    [I(206,34)] = {64,0},
    [I(207,34)] = {64,0},
    [I(208,34)] = {29,0x1FFFCBF9},
    [I(209,34)] = {31,0x7FFF8FF9},
    [I(210,34)] = {64,0},
    [I(211,34)] = {64,0},
    [I(212,34)] = {64,0},
    [I(213,34)] = {64,0},
    [I(214,34)] = {64,0},
    [I(215,34)] = {64,0},
    [I(216,34)] = {31,0x7FFF93F9},
    [I(217,34)] = {31,0x7FFF97F9},
    [I(218,34)] = {64,0},
    [I(219,34)] = {64,0},
    [I(220,34)] = {64,0},
    [I(221,34)] = {64,0},
    [I(222,34)] = {64,0},
    [I(223,34)] = {64,0},
    [I(224,34)] = {30,0x3FFFB3F9},
    [I(225,34)] = {64,0},
    [I(226,34)] = {30,0x3FFFB7F9},
    [I(227,34)] = {31,0x7FFF9BF9},
    [I(228,34)] = {X32,0xFFFFA7F9},
    [I(229,34)] = {31,0x7FFF9FF9},
    [I(230,34)] = {31,0x7FFFA3F9},
    [I(231,34)] = {64,0},
    [I(232,34)] = {X32,0xFFFFABF9},
    [I(233,34)] = {X32,0xFFFFAFF9},
    [I(234,34)] = {64,0},
    [I(235,34)] = {64,0},
    [I(236,34)] = {64,0},
    [I(237,34)] = {64,0},
    [I(238,34)] = {64,0},
    [I(239,34)] = {64,0},
    [I(240,34)] = {64,0},
    [I(241,34)] = {64,0},
    [I(242,34)] = {64,0},
    [I(243,34)] = {64,0},
    [I(244,34)] = {64,0},
    [I(245,34)] = {64,0},
    [I(246,34)] = {64,0},
    [I(247,34)] = {64,0},
    [I(248,34)] = {64,0},
    [I(249,34)] = {64,0},
    [I(250,34)] = {64,0},
    [I(251,34)] = {64,0},
    [I(252,34)] = {64,0},
    [I(253,34)] = {64,0},
    [I(254,34)] = {64,0},
    [I(255,34)] = {64,0},
    [I(0,35)] = {25,0x1FF8FFA},
    [I(1,35)] = {64,0},
    [I(2,35)] = {64,0},
    [I(3,35)] = {64,0},
    [I(4,35)] = {64,0},
    [I(5,35)] = {64,0},
    [I(6,35)] = {64,0},
    [I(7,35)] = {64,0},
    [I(8,35)] = {64,0},
    [I(9,35)] = {64,0},
    [I(10,35)] = {64,0},
    [I(11,35)] = {64,0},
    [I(12,35)] = {64,0},
    [I(13,35)] = {64,0},
    [I(14,35)] = {64,0},
    [I(15,35)] = {64,0},
    [I(16,35)] = {64,0},
    [I(17,35)] = {64,0},
    [I(18,35)] = {64,0},
    [I(19,35)] = {64,0},
    [I(20,35)] = {64,0},
    [I(21,35)] = {64,0},
    [I(22,35)] = {64,0},
    [I(23,35)] = {64,0},
    [I(24,35)] = {64,0},
    [I(25,35)] = {64,0},
    [I(26,35)] = {64,0},
    [I(27,35)] = {64,0},
    [I(28,35)] = {64,0},
    [I(29,35)] = {64,0},
    [I(30,35)] = {64,0},
    [I(31,35)] = {64,0},
    [I(32,35)] = {18,0x14FFA},
    [I(33,35)] = {22,0x3F8FFA},
    [I(34,35)] = {22,0x3F9FFA},
    [I(35,35)] = {24,0xFFAFFA},
    [I(36,35)] = {25,0x1FF9FFA},
    [I(37,35)] = {18,0x15FFA},
    [I(38,35)] = {20,0xF8FFA},
    [I(39,35)] = {23,0x7FAFFA},
    [I(40,35)] = {22,0x3FAFFA},
    [I(41,35)] = {22,0x3FBFFA},
    [I(42,35)] = {20,0xF9FFA},
    [I(43,35)] = {23,0x7FBFFA},
    [I(44,35)] = {20,0xFAFFA},
    [I(45,35)] = {18,0x16FFA},
    [I(46,35)] = {18,0x17FFA},
    [I(47,35)] = {18,0x18FFA},
    [I(48,35)] = {17,0xFFA},
    [I(49,35)] = {17,0x1FFA},
    [I(50,35)] = {17,0x2FFA},
    [I(51,35)] = {18,0x19FFA},
    [I(52,35)] = {18,0x1AFFA},
    [I(53,35)] = {18,0x1BFFA},
    [I(54,35)] = {18,0x1CFFA},
    [I(55,35)] = {18,0x1DFFA},
    [I(56,35)] = {18,0x1EFFA},
    [I(57,35)] = {18,0x1FFFA},
    [I(58,35)] = {19,0x5CFFA},
    [I(59,35)] = {20,0xFBFFA},
    [I(60,35)] = {27,0x7FFCFFA},
    [I(61,35)] = {18,0x20FFA},
    [I(62,35)] = {24,0xFFBFFA},
    [I(63,35)] = {22,0x3FCFFA},
    [I(64,35)] = {25,0x1FFAFFA},
    [I(65,35)] = {18,0x21FFA},
    [I(66,35)] = {19,0x5DFFA},
    [I(67,35)] = {19,0x5EFFA},
    [I(68,35)] = {19,0x5FFFA},
    [I(69,35)] = {19,0x60FFA},
    [I(70,35)] = {19,0x61FFA},
    [I(71,35)] = {19,0x62FFA},
    [I(72,35)] = {19,0x63FFA},
    [I(73,35)] = {19,0x64FFA},
    [I(74,35)] = {19,0x65FFA},
    [I(75,35)] = {19,0x66FFA},
    [I(76,35)] = {19,0x67FFA},
    [I(77,35)] = {19,0x68FFA},
    [I(78,35)] = {19,0x69FFA},
    [I(79,35)] = {19,0x6AFFA},
    [I(80,35)] = {19,0x6BFFA},
    [I(81,35)] = {19,0x6CFFA},
    [I(82,35)] = {19,0x6DFFA},
    [I(83,35)] = {19,0x6EFFA},
    [I(84,35)] = {19,0x6FFFA},
    [I(85,35)] = {19,0x70FFA},
    [I(86,35)] = {19,0x71FFA},
    [I(87,35)] = {19,0x72FFA},
    [I(88,35)] = {20,0xFCFFA},
    [I(89,35)] = {19,0x73FFA},
    [I(90,35)] = {20,0xFDFFA},
    [I(91,35)] = {25,0x1FFBFFA},
    [I(92,35)] = {31,0x7FFF0FFA},
    [I(93,35)] = {25,0x1FFCFFA},
    [I(94,35)] = {26,0x3FFCFFA},
    [I(95,35)] = {18,0x22FFA},
    [I(96,35)] = {27,0x7FFDFFA},
    [I(97,35)] = {17,0x3FFA},
    [I(98,35)] = {18,0x23FFA},
    [I(99,35)] = {17,0x4FFA},
    [I(100,35)] = {18,0x24FFA},
    [I(101,35)] = {17,0x5FFA},
    [I(102,35)] = {18,0x25FFA},
    [I(103,35)] = {18,0x26FFA},
    [I(104,35)] = {18,0x27FFA},
    [I(105,35)] = {17,0x6FFA},
    [I(106,35)] = {19,0x74FFA},
    [I(107,35)] = {19,0x75FFA},
    [I(108,35)] = {18,0x28FFA},
    [I(109,35)] = {18,0x29FFA},
    [I(110,35)] = {18,0x2AFFA},
    [I(111,35)] = {17,0x7FFA},
    [I(112,35)] = {18,0x2BFFA},
    [I(113,35)] = {19,0x76FFA},
    [I(114,35)] = {18,0x2CFFA},
    [I(115,35)] = {17,0x8FFA},
    [I(116,35)] = {17,0x9FFA},
    [I(117,35)] = {18,0x2DFFA},
    [I(118,35)] = {19,0x77FFA},
    [I(119,35)] = {19,0x78FFA},
    [I(120,35)] = {19,0x79FFA},
    [I(121,35)] = {19,0x7AFFA},
    [I(122,35)] = {19,0x7BFFA},
    [I(123,35)] = {27,0x7FFEFFA},
    [I(124,35)] = {23,0x7FCFFA},
    [I(125,35)] = {26,0x3FFDFFA},
    [I(126,35)] = {25,0x1FFDFFA},
    [I(127,35)] = {64,0},
    [I(128,35)] = {X32,0xFFFE6FFA},
    [I(129,35)] = {64,0},
    [I(130,35)] = {X32,0xFFFE7FFA},
    [I(131,35)] = {X32,0xFFFE8FFA},
    [I(132,35)] = {64,0},
    [I(133,35)] = {64,0},
    [I(134,35)] = {64,0},
    [I(135,35)] = {64,0},
    [I(136,35)] = {64,0},
    [I(137,35)] = {64,0},
    [I(138,35)] = {64,0},
    [I(139,35)] = {64,0},
    [I(140,35)] = {64,0},
    [I(141,35)] = {64,0},
    [I(142,35)] = {64,0},
    [I(143,35)] = {64,0},
    [I(144,35)] = {64,0},
    [I(145,35)] = {64,0},
    [I(146,35)] = {64,0},
    [I(147,35)] = {64,0},
    [I(148,35)] = {64,0},
    [I(149,35)] = {64,0},
    [I(150,35)] = {64,0},
    [I(151,35)] = {64,0},
    [I(152,35)] = {64,0},
    [I(153,35)] = {64,0},
    [I(154,35)] = {64,0},
    [I(155,35)] = {64,0},
    [I(156,35)] = {64,0},
    [I(157,35)] = {64,0},
    [I(158,35)] = {64,0},
    [I(159,35)] = {64,0},
    [I(160,35)] = {64,0},
    [I(161,35)] = {64,0},
    [I(162,35)] = {X32,0xFFFE9FFA},
    [I(163,35)] = {64,0},
    [I(164,35)] = {64,0},
    [I(165,35)] = {64,0},
    [I(166,35)] = {64,0},
    [I(167,35)] = {64,0},
    [I(168,35)] = {64,0},
    [I(169,35)] = {64,0},
    [I(170,35)] = {64,0},
    [I(171,35)] = {64,0},
    [I(172,35)] = {64,0},
    [I(173,35)] = {64,0},
    [I(174,35)] = {64,0},
    [I(175,35)] = {64,0},
    [I(176,35)] = {64,0},
    [I(177,35)] = {64,0},
    [I(178,35)] = {64,0},
    [I(179,35)] = {64,0},
    [I(180,35)] = {64,0},
    [I(181,35)] = {64,0},
    [I(182,35)] = {64,0},
    [I(183,35)] = {64,0},
    [I(184,35)] = {X32,0xFFFEAFFA},
    [I(185,35)] = {64,0},
    [I(186,35)] = {64,0},
    [I(187,35)] = {64,0},
    [I(188,35)] = {64,0},
    [I(189,35)] = {64,0},
    [I(190,35)] = {64,0},
    [I(191,35)] = {64,0},
    [I(192,35)] = {64,0},
    [I(193,35)] = {64,0},
    [I(194,35)] = {X32,0xFFFEBFFA},
    [I(195,35)] = {31,0x7FFF1FFA},
    [I(196,35)] = {64,0},
    [I(197,35)] = {64,0},
    [I(198,35)] = {64,0},
    [I(199,35)] = {64,0},
    [I(200,35)] = {64,0},
    [I(201,35)] = {64,0},
    [I(202,35)] = {64,0},
    [I(203,35)] = {64,0},
    [I(204,35)] = {64,0},
    [I(205,35)] = {64,0},
    [I(206,35)] = {64,0},
    [I(207,35)] = {64,0},
    [I(208,35)] = {31,0x7FFF2FFA},
    [I(209,35)] = {64,0},
    [I(210,35)] = {64,0},
    [I(211,35)] = {64,0},
    [I(212,35)] = {64,0},
    [I(213,35)] = {64,0},
    [I(214,35)] = {64,0},
    [I(215,35)] = {64,0},
    [I(216,35)] = {64,0},
    [I(217,35)] = {64,0},
    [I(218,35)] = {64,0},
    [I(219,35)] = {64,0},
    [I(220,35)] = {64,0},
    [I(221,35)] = {64,0},
    [I(222,35)] = {64,0},
    [I(223,35)] = {64,0},
    [I(224,35)] = {X32,0xFFFECFFA},
    [I(225,35)] = {64,0},
    [I(226,35)] = {X32,0xFFFEDFFA},
    [I(227,35)] = {64,0},
    [I(228,35)] = {64,0},
    [I(229,35)] = {64,0},
    [I(230,35)] = {64,0},
    [I(231,35)] = {64,0},
    [I(232,35)] = {64,0},
    [I(233,35)] = {64,0},
    [I(234,35)] = {64,0},
    [I(235,35)] = {64,0},
    [I(236,35)] = {64,0},
    [I(237,35)] = {64,0},
    [I(238,35)] = {64,0},
    [I(239,35)] = {64,0},
    [I(240,35)] = {64,0},
    [I(241,35)] = {64,0},
    [I(242,35)] = {64,0},
    [I(243,35)] = {64,0},
    [I(244,35)] = {64,0},
    [I(245,35)] = {64,0},
    [I(246,35)] = {64,0},
    [I(247,35)] = {64,0},
    [I(248,35)] = {64,0},
    [I(249,35)] = {64,0},
    [I(250,35)] = {64,0},
    [I(251,35)] = {64,0},
    [I(252,35)] = {64,0},
    [I(253,35)] = {64,0},
    [I(254,35)] = {64,0},
    [I(255,35)] = {64,0},
    [I(0,36)] = {26,0x3FF1FF9},
    [I(1,36)] = {64,0},
    [I(2,36)] = {64,0},
    [I(3,36)] = {64,0},
    [I(4,36)] = {64,0},
    [I(5,36)] = {64,0},
    [I(6,36)] = {64,0},
    [I(7,36)] = {64,0},
    [I(8,36)] = {64,0},
    [I(9,36)] = {64,0},
    [I(10,36)] = {64,0},
    [I(11,36)] = {64,0},
    [I(12,36)] = {64,0},
    [I(13,36)] = {64,0},
    [I(14,36)] = {64,0},
    [I(15,36)] = {64,0},
    [I(16,36)] = {64,0},
    [I(17,36)] = {64,0},
    [I(18,36)] = {64,0},
    [I(19,36)] = {64,0},
    [I(20,36)] = {64,0},
    [I(21,36)] = {64,0},
    [I(22,36)] = {64,0},
    [I(23,36)] = {64,0},
    [I(24,36)] = {64,0},
    [I(25,36)] = {64,0},
    [I(26,36)] = {64,0},
    [I(27,36)] = {64,0},
    [I(28,36)] = {64,0},
    [I(29,36)] = {64,0},
    [I(30,36)] = {64,0},
    [I(31,36)] = {64,0},
    [I(32,36)] = {19,0x29FF9},
    [I(33,36)] = {23,0x7F1FF9},
    [I(34,36)] = {23,0x7F3FF9},
    [I(35,36)] = {25,0x1FF5FF9},
    [I(36,36)] = {26,0x3FF3FF9},
    [I(37,36)] = {19,0x2BFF9},
    [I(38,36)] = {21,0x1F1FF9},
    [I(39,36)] = {24,0xFF5FF9},
    [I(40,36)] = {23,0x7F5FF9},
    [I(41,36)] = {23,0x7F7FF9},
    [I(42,36)] = {21,0x1F3FF9},
    [I(43,36)] = {24,0xFF7FF9},
    [I(44,36)] = {21,0x1F5FF9},
    [I(45,36)] = {19,0x2DFF9},
    [I(46,36)] = {19,0x2FFF9},
    [I(47,36)] = {19,0x31FF9},
    [I(48,36)] = {18,0x1FF9},
    [I(49,36)] = {18,0x3FF9},
    [I(50,36)] = {18,0x5FF9},
    [I(51,36)] = {19,0x33FF9},
    [I(52,36)] = {19,0x35FF9},
    [I(53,36)] = {19,0x37FF9},
    [I(54,36)] = {19,0x39FF9},
    [I(55,36)] = {19,0x3BFF9},
    [I(56,36)] = {19,0x3DFF9},
    [I(57,36)] = {19,0x3FFF9},
    [I(58,36)] = {20,0xB9FF9},
    [I(59,36)] = {21,0x1F7FF9},
    [I(60,36)] = {28,0xFFF9FF9},
    [I(61,36)] = {19,0x41FF9},
    [I(62,36)] = {25,0x1FF7FF9},
    [I(63,36)] = {23,0x7F9FF9},
    [I(64,36)] = {26,0x3FF5FF9},
    [I(65,36)] = {19,0x43FF9},
    [I(66,36)] = {20,0xBBFF9},
    [I(67,36)] = {20,0xBDFF9},
    [I(68,36)] = {20,0xBFFF9},
    [I(69,36)] = {20,0xC1FF9},
    [I(70,36)] = {20,0xC3FF9},
    [I(71,36)] = {20,0xC5FF9},
    [I(72,36)] = {20,0xC7FF9},
    [I(73,36)] = {20,0xC9FF9},
    [I(74,36)] = {20,0xCBFF9},
    [I(75,36)] = {20,0xCDFF9},
    [I(76,36)] = {20,0xCFFF9},
    [I(77,36)] = {20,0xD1FF9},
    [I(78,36)] = {20,0xD3FF9},
    [I(79,36)] = {20,0xD5FF9},
    [I(80,36)] = {20,0xD7FF9},
    [I(81,36)] = {20,0xD9FF9},
    [I(82,36)] = {20,0xDBFF9},
    [I(83,36)] = {20,0xDDFF9},
    [I(84,36)] = {20,0xDFFF9},
    [I(85,36)] = {20,0xE1FF9},
    [I(86,36)] = {20,0xE3FF9},
    [I(87,36)] = {20,0xE5FF9},
    [I(88,36)] = {21,0x1F9FF9},
    [I(89,36)] = {20,0xE7FF9},
    [I(90,36)] = {21,0x1FBFF9},
    [I(91,36)] = {26,0x3FF7FF9},
    [I(92,36)] = {X32,0xFFFE1FF9},
    [I(93,36)] = {26,0x3FF9FF9},
    [I(94,36)] = {27,0x7FF9FF9},
    [I(95,36)] = {19,0x45FF9},
    [I(96,36)] = {28,0xFFFBFF9},
    [I(97,36)] = {18,0x7FF9},
    [I(98,36)] = {19,0x47FF9},
    [I(99,36)] = {18,0x9FF9},
    [I(100,36)] = {19,0x49FF9},
    [I(101,36)] = {18,0xBFF9},
    [I(102,36)] = {19,0x4BFF9},
    [I(103,36)] = {19,0x4DFF9},
    [I(104,36)] = {19,0x4FFF9},
    [I(105,36)] = {18,0xDFF9},
    [I(106,36)] = {20,0xE9FF9},
    [I(107,36)] = {20,0xEBFF9},
    [I(108,36)] = {19,0x51FF9},
    [I(109,36)] = {19,0x53FF9},
    [I(110,36)] = {19,0x55FF9},
    [I(111,36)] = {18,0xFFF9},
    [I(112,36)] = {19,0x57FF9},
    [I(113,36)] = {20,0xEDFF9},
    [I(114,36)] = {19,0x59FF9},
    [I(115,36)] = {18,0x11FF9},
    [I(116,36)] = {18,0x13FF9},
    [I(117,36)] = {19,0x5BFF9},
    [I(118,36)] = {20,0xEFFF9},
    [I(119,36)] = {20,0xF1FF9},
    [I(120,36)] = {20,0xF3FF9},
    [I(121,36)] = {20,0xF5FF9},
    [I(122,36)] = {20,0xF7FF9},
    [I(123,36)] = {28,0xFFFDFF9},
    [I(124,36)] = {24,0xFF9FF9},
    [I(125,36)] = {27,0x7FFBFF9},
    [I(126,36)] = {26,0x3FFBFF9},
    [I(127,36)] = {64,0},
    [I(128,36)] = {64,0},
    [I(129,36)] = {64,0},
    [I(130,36)] = {64,0},
    [I(131,36)] = {64,0},
    [I(132,36)] = {64,0},
    [I(133,36)] = {64,0},
    [I(134,36)] = {64,0},
    [I(135,36)] = {64,0},
    [I(136,36)] = {64,0},
    [I(137,36)] = {64,0},
    [I(138,36)] = {64,0},
    [I(139,36)] = {64,0},
    [I(140,36)] = {64,0},
    [I(141,36)] = {64,0},
    [I(142,36)] = {64,0},
    [I(143,36)] = {64,0},
    [I(144,36)] = {64,0},
    [I(145,36)] = {64,0},
    [I(146,36)] = {64,0},
    [I(147,36)] = {64,0},
    [I(148,36)] = {64,0},
    [I(149,36)] = {64,0},
    [I(150,36)] = {64,0},
    [I(151,36)] = {64,0},
    [I(152,36)] = {64,0},
    [I(153,36)] = {64,0},
    [I(154,36)] = {64,0},
    [I(155,36)] = {64,0},
    [I(156,36)] = {64,0},
    [I(157,36)] = {64,0},
    [I(158,36)] = {64,0},
    [I(159,36)] = {64,0},
    [I(160,36)] = {64,0},
    [I(161,36)] = {64,0},
    [I(162,36)] = {64,0},
    [I(163,36)] = {64,0},
    [I(164,36)] = {64,0},
    [I(165,36)] = {64,0},
    [I(166,36)] = {64,0},
    [I(167,36)] = {64,0},
    [I(168,36)] = {64,0},
    [I(169,36)] = {64,0},
    [I(170,36)] = {64,0},
    [I(171,36)] = {64,0},
    [I(172,36)] = {64,0},
    [I(173,36)] = {64,0},
    [I(174,36)] = {64,0},
    [I(175,36)] = {64,0},
    [I(176,36)] = {64,0},
    [I(177,36)] = {64,0},
    [I(178,36)] = {64,0},
    [I(179,36)] = {64,0},
    [I(180,36)] = {64,0},
    [I(181,36)] = {64,0},
    [I(182,36)] = {64,0},
    [I(183,36)] = {64,0},
    [I(184,36)] = {64,0},
    [I(185,36)] = {64,0},
    [I(186,36)] = {64,0},
    [I(187,36)] = {64,0},
    [I(188,36)] = {64,0},
    [I(189,36)] = {64,0},
    [I(190,36)] = {64,0},
    [I(191,36)] = {64,0},
    [I(192,36)] = {64,0},
    [I(193,36)] = {64,0},
    [I(194,36)] = {64,0},
    [I(195,36)] = {X32,0xFFFE3FF9},
    [I(196,36)] = {64,0},
    [I(197,36)] = {64,0},
    [I(198,36)] = {64,0},
    [I(199,36)] = {64,0},
    [I(200,36)] = {64,0},
    [I(201,36)] = {64,0},
    [I(202,36)] = {64,0},
    [I(203,36)] = {64,0},
    [I(204,36)] = {64,0},
    [I(205,36)] = {64,0},
    [I(206,36)] = {64,0},
    [I(207,36)] = {64,0},
    [I(208,36)] = {X32,0xFFFE5FF9},
    [I(209,36)] = {64,0},
    [I(210,36)] = {64,0},
    [I(211,36)] = {64,0},
    [I(212,36)] = {64,0},
    [I(213,36)] = {64,0},
    [I(214,36)] = {64,0},
    [I(215,36)] = {64,0},
    [I(216,36)] = {64,0},
    [I(217,36)] = {64,0},
    [I(218,36)] = {64,0},
    [I(219,36)] = {64,0},
    [I(220,36)] = {64,0},
    [I(221,36)] = {64,0},
    [I(222,36)] = {64,0},
    [I(223,36)] = {64,0},
    [I(224,36)] = {64,0},
    [I(225,36)] = {64,0},
    [I(226,36)] = {64,0},
    [I(227,36)] = {64,0},
    [I(228,36)] = {64,0},
    [I(229,36)] = {64,0},
    [I(230,36)] = {64,0},
    [I(231,36)] = {64,0},
    [I(232,36)] = {64,0},
    [I(233,36)] = {64,0},
    [I(234,36)] = {64,0},
    [I(235,36)] = {64,0},
    [I(236,36)] = {64,0},
    [I(237,36)] = {64,0},
    [I(238,36)] = {64,0},
    [I(239,36)] = {64,0},
    [I(240,36)] = {64,0},
    [I(241,36)] = {64,0},
    [I(242,36)] = {64,0},
    [I(243,36)] = {64,0},
    [I(244,36)] = {64,0},
    [I(245,36)] = {64,0},
    [I(246,36)] = {64,0},
    [I(247,36)] = {64,0},
    [I(248,36)] = {64,0},
    [I(249,36)] = {64,0},
    [I(250,36)] = {64,0},
    [I(251,36)] = {64,0},
    [I(252,36)] = {64,0},
    [I(253,36)] = {64,0},
    [I(254,36)] = {64,0},
    [I(255,36)] = {64,0},
    [I(0,37)] = {19,0x7FE15},
    [I(1,37)] = {29,0x1FFFF615},
    [I(2,37)] = {64,0},
    [I(3,37)] = {64,0},
    [I(4,37)] = {64,0},
    [I(5,37)] = {64,0},
    [I(6,37)] = {64,0},
    [I(7,37)] = {64,0},
    [I(8,37)] = {64,0},
    [I(9,37)] = {30,0x3FFFFA95},
    [I(10,37)] = {64,0},
    [I(11,37)] = {64,0},
    [I(12,37)] = {64,0},
    [I(13,37)] = {64,0},
    [I(14,37)] = {64,0},
    [I(15,37)] = {64,0},
    [I(16,37)] = {64,0},
    [I(17,37)] = {64,0},
    [I(18,37)] = {64,0},
    [I(19,37)] = {64,0},
    [I(20,37)] = {64,0},
    [I(21,37)] = {64,0},
    [I(22,37)] = {64,0},
    [I(23,37)] = {64,0},
    [I(24,37)] = {64,0},
    [I(25,37)] = {64,0},
    [I(26,37)] = {64,0},
    [I(27,37)] = {64,0},
    [I(28,37)] = {64,0},
    [I(29,37)] = {64,0},
    [I(30,37)] = {64,0},
    [I(31,37)] = {64,0},
    [I(32,37)] = {12,0x515},
    [I(33,37)] = {16,0xFE15},
    [I(34,37)] = {16,0xFE55},
    [I(35,37)] = {18,0x3FE95},
    [I(36,37)] = {19,0x7FE55},
    [I(37,37)] = {12,0x555},
    [I(38,37)] = {14,0x3E15},
    [I(39,37)] = {17,0x1FE95},
    [I(40,37)] = {16,0xFE95},
    [I(41,37)] = {16,0xFED5},
    [I(42,37)] = {14,0x3E55},
    [I(43,37)] = {17,0x1FED5},
    [I(44,37)] = {14,0x3E95},
    [I(45,37)] = {12,0x595},
    [I(46,37)] = {12,0x5D5},
    [I(47,37)] = {12,0x615},
    [I(48,37)] = {11,0x15},
    [I(49,37)] = {11,0x55},
    [I(50,37)] = {11,0x95},
    [I(51,37)] = {12,0x655},
    [I(52,37)] = {12,0x695},
    [I(53,37)] = {12,0x6D5},
    [I(54,37)] = {12,0x715},
    [I(55,37)] = {12,0x755},
    [I(56,37)] = {12,0x795},
    [I(57,37)] = {12,0x7D5},
    [I(58,37)] = {13,0x1715},
    [I(59,37)] = {14,0x3ED5},
    [I(60,37)] = {21,0x1FFF15},
    [I(61,37)] = {12,0x815},
    [I(62,37)] = {18,0x3FED5},
    [I(63,37)] = {16,0xFF15},
    [I(64,37)] = {19,0x7FE95},
    [I(65,37)] = {12,0x855},
    [I(66,37)] = {13,0x1755},
    [I(67,37)] = {13,0x1795},
    [I(68,37)] = {13,0x17D5},
    [I(69,37)] = {13,0x1815},
    [I(70,37)] = {13,0x1855},
    [I(71,37)] = {13,0x1895},
    [I(72,37)] = {13,0x18D5},
    [I(73,37)] = {13,0x1915},
    [I(74,37)] = {13,0x1955},
    [I(75,37)] = {13,0x1995},
    [I(76,37)] = {13,0x19D5},
    [I(77,37)] = {13,0x1A15},
    [I(78,37)] = {13,0x1A55},
    [I(79,37)] = {13,0x1A95},
    [I(80,37)] = {13,0x1AD5},
    [I(81,37)] = {13,0x1B15},
    [I(82,37)] = {13,0x1B55},
    [I(83,37)] = {13,0x1B95},
    [I(84,37)] = {13,0x1BD5},
    [I(85,37)] = {13,0x1C15},
    [I(86,37)] = {13,0x1C55},
    [I(87,37)] = {13,0x1C95},
    [I(88,37)] = {14,0x3F15},
    [I(89,37)] = {13,0x1CD5},
    [I(90,37)] = {14,0x3F55},
    [I(91,37)] = {19,0x7FED5},
    [I(92,37)] = {25,0x1FFFC15},
    [I(93,37)] = {19,0x7FF15},
    [I(94,37)] = {20,0xFFF15},
    [I(95,37)] = {12,0x895},
    [I(96,37)] = {21,0x1FFF55},
    [I(97,37)] = {11,0xD5},
    [I(98,37)] = {12,0x8D5},
    [I(99,37)] = {11,0x115},
    [I(100,37)] = {12,0x915},
    [I(101,37)] = {11,0x155},
    [I(102,37)] = {12,0x955},
    [I(103,37)] = {12,0x995},
    [I(104,37)] = {12,0x9D5},
    [I(105,37)] = {11,0x195},
    [I(106,37)] = {13,0x1D15},
    [I(107,37)] = {13,0x1D55},
    [I(108,37)] = {12,0xA15},
    [I(109,37)] = {12,0xA55},
    [I(110,37)] = {12,0xA95},
    [I(111,37)] = {11,0x1D5},
    [I(112,37)] = {12,0xAD5},
    [I(113,37)] = {13,0x1D95},
    [I(114,37)] = {12,0xB15},
    [I(115,37)] = {11,0x215},
    [I(116,37)] = {11,0x255},
    [I(117,37)] = {12,0xB55},
    [I(118,37)] = {13,0x1DD5},
    [I(119,37)] = {13,0x1E15},
    [I(120,37)] = {13,0x1E55},
    [I(121,37)] = {13,0x1E95},
    [I(122,37)] = {13,0x1ED5},
    [I(123,37)] = {21,0x1FFF95},
    [I(124,37)] = {17,0x1FF15},
    [I(125,37)] = {20,0xFFF55},
    [I(126,37)] = {19,0x7FF55},
    [I(127,37)] = {64,0},
    [I(128,37)] = {26,0x3FFF995},
    [I(129,37)] = {28,0xFFFF495},
    [I(130,37)] = {26,0x3FFF9D5},
    [I(131,37)] = {26,0x3FFFA15},
    [I(132,37)] = {28,0xFFFF4D5},
    [I(133,37)] = {28,0xFFFF515},
    [I(134,37)] = {28,0xFFFF555},
    [I(135,37)] = {29,0x1FFFF655},
    [I(136,37)] = {28,0xFFFF595},
    [I(137,37)] = {29,0x1FFFF695},
    [I(138,37)] = {29,0x1FFFF6D5},
    [I(139,37)] = {29,0x1FFFF715},
    [I(140,37)] = {29,0x1FFFF755},
    [I(141,37)] = {29,0x1FFFF795},
    [I(142,37)] = {30,0x3FFFFAD5},
    [I(143,37)] = {29,0x1FFFF7D5},
    [I(144,37)] = {30,0x3FFFFB15},
    [I(145,37)] = {30,0x3FFFFB55},
    [I(146,37)] = {28,0xFFFF5D5},
    [I(147,37)] = {29,0x1FFFF815},
    [I(148,37)] = {30,0x3FFFFB95},
    [I(149,37)] = {29,0x1FFFF855},
    [I(150,37)] = {29,0x1FFFF895},
    [I(151,37)] = {29,0x1FFFF8D5},
    [I(152,37)] = {29,0x1FFFF915},
    [I(153,37)] = {27,0x7FFF715},
    [I(154,37)] = {28,0xFFFF615},
    [I(155,37)] = {29,0x1FFFF955},
    [I(156,37)] = {28,0xFFFF655},
    [I(157,37)] = {29,0x1FFFF995},
    [I(158,37)] = {29,0x1FFFF9D5},
    [I(159,37)] = {30,0x3FFFFBD5},
    [I(160,37)] = {28,0xFFFF695},
    [I(161,37)] = {27,0x7FFF755},
    [I(162,37)] = {26,0x3FFFA55},
    [I(163,37)] = {28,0xFFFF6D5},
    [I(164,37)] = {28,0xFFFF715},
    [I(165,37)] = {29,0x1FFFFA15},
    [I(166,37)] = {29,0x1FFFFA55},
    [I(167,37)] = {27,0x7FFF795},
    [I(168,37)] = {29,0x1FFFFA95},
    [I(169,37)] = {28,0xFFFF755},
    [I(170,37)] = {28,0xFFFF795},
    [I(171,37)] = {30,0x3FFFFC15},
    [I(172,37)] = {27,0x7FFF7D5},
    [I(173,37)] = {28,0xFFFF7D5},
    [I(174,37)] = {29,0x1FFFFAD5},
    [I(175,37)] = {29,0x1FFFFB15},
    [I(176,37)] = {27,0x7FFF815},
    [I(177,37)] = {27,0x7FFF855},
    [I(178,37)] = {28,0xFFFF815},
    [I(179,37)] = {27,0x7FFF895},
    [I(180,37)] = {29,0x1FFFFB55},
    [I(181,37)] = {28,0xFFFF855},
    [I(182,37)] = {29,0x1FFFFB95},
    [I(183,37)] = {29,0x1FFFFBD5},
    [I(184,37)] = {26,0x3FFFA95},
    [I(185,37)] = {28,0xFFFF895},
    [I(186,37)] = {28,0xFFFF8D5},
    [I(187,37)] = {28,0xFFFF915},
    [I(188,37)] = {29,0x1FFFFC15},
    [I(189,37)] = {28,0xFFFF955},
    [I(190,37)] = {28,0xFFFF995},
    [I(191,37)] = {29,0x1FFFFC55},
    [I(192,37)] = {X32,0xFFFFF815},
    [I(193,37)] = {X32,0xFFFFF855},
    [I(194,37)] = {26,0x3FFFAD5},
    [I(195,37)] = {25,0x1FFFC55},
    [I(196,37)] = {28,0xFFFF9D5},
    [I(197,37)] = {29,0x1FFFFC95},
    [I(198,37)] = {28,0xFFFFA15},
    [I(199,37)] = {31,0x7FFFFB15},
    [I(200,37)] = {X32,0xFFFFF895},
    [I(201,37)] = {X32,0xFFFFF8D5},
    [I(202,37)] = {X32,0xFFFFF915},
    [I(203,37)] = {64,0},
    [I(204,37)] = {64,0},
    [I(205,37)] = {X32,0xFFFFF955},
    [I(206,37)] = {30,0x3FFFFC55},
    [I(207,37)] = {31,0x7FFFFB55},
    [I(208,37)] = {25,0x1FFFC95},
    [I(209,37)] = {27,0x7FFF8D5},
    [I(210,37)] = {X32,0xFFFFF995},
    [I(211,37)] = {64,0},
    [I(212,37)] = {64,0},
    [I(213,37)] = {X32,0xFFFFF9D5},
    [I(214,37)] = {64,0},
    [I(215,37)] = {30,0x3FFFFC95},
    [I(216,37)] = {27,0x7FFF915},
    [I(217,37)] = {27,0x7FFF955},
    [I(218,37)] = {X32,0xFFFFFA15},
    [I(219,37)] = {X32,0xFFFFFA55},
    [I(220,37)] = {64,0},
    [I(221,37)] = {64,0},
    [I(222,37)] = {64,0},
    [I(223,37)] = {64,0},
    [I(224,37)] = {26,0x3FFFB15},
    [I(225,37)] = {30,0x3FFFFCD5},
    [I(226,37)] = {26,0x3FFFB55},
    [I(227,37)] = {27,0x7FFF995},
    [I(228,37)] = {28,0xFFFFA55},
    [I(229,37)] = {27,0x7FFF9D5},
    [I(230,37)] = {27,0x7FFFA15},
    [I(231,37)] = {29,0x1FFFFCD5},
    [I(232,37)] = {28,0xFFFFA95},
    [I(233,37)] = {28,0xFFFFAD5},
    [I(234,37)] = {31,0x7FFFFB95},
    [I(235,37)] = {31,0x7FFFFBD5},
    [I(236,37)] = {30,0x3FFFFD15},
    [I(237,37)] = {30,0x3FFFFD55},
    [I(238,37)] = {X32,0xFFFFFA95},
    [I(239,37)] = {29,0x1FFFFD15},
    [I(240,37)] = {X32,0xFFFFFAD5},
    [I(241,37)] = {64,0},
    [I(242,37)] = {X32,0xFFFFFB15},
    [I(243,37)] = {X32,0xFFFFFB55},
    [I(244,37)] = {64,0},
    [I(245,37)] = {64,0},
    [I(246,37)] = {64,0},
    [I(247,37)] = {64,0},
    [I(248,37)] = {64,0},
    [I(249,37)] = {64,0},
    [I(250,37)] = {64,0},
    [I(251,37)] = {64,0},
    [I(252,37)] = {64,0},
    [I(253,37)] = {64,0},
    [I(254,37)] = {64,0},
    [I(255,37)] = {X32,0xFFFFFB95},
    [I(0,38)] = {21,0x1FF8F8},
    [I(1,38)] = {31,0x7FFFD8F8},
    [I(2,38)] = {64,0},
    [I(3,38)] = {64,0},
    [I(4,38)] = {64,0},
    [I(5,38)] = {64,0},
    [I(6,38)] = {64,0},
    [I(7,38)] = {64,0},
    [I(8,38)] = {64,0},
    [I(9,38)] = {X32,0xFFFFEAF8},
    [I(10,38)] = {64,0},
    [I(11,38)] = {64,0},
    [I(12,38)] = {64,0},
    [I(13,38)] = {64,0},
    [I(14,38)] = {64,0},
    [I(15,38)] = {64,0},
    [I(16,38)] = {64,0},
    [I(17,38)] = {64,0},
    [I(18,38)] = {64,0},
    [I(19,38)] = {64,0},
    [I(20,38)] = {64,0},
    [I(21,38)] = {64,0},
    [I(22,38)] = {64,0},
    [I(23,38)] = {64,0},
    [I(24,38)] = {64,0},
    [I(25,38)] = {64,0},
    [I(26,38)] = {64,0},
    [I(27,38)] = {64,0},
    [I(28,38)] = {64,0},
    [I(29,38)] = {64,0},
    [I(30,38)] = {64,0},
    [I(31,38)] = {64,0},
    [I(32,38)] = {14,0x14F8},
    [I(33,38)] = {18,0x3F8F8},
    [I(34,38)] = {18,0x3F9F8},
    [I(35,38)] = {20,0xFFAF8},
    [I(36,38)] = {21,0x1FF9F8},
    [I(37,38)] = {14,0x15F8},
    [I(38,38)] = {16,0xF8F8},
    [I(39,38)] = {19,0x7FAF8},
    [I(40,38)] = {18,0x3FAF8},
    [I(41,38)] = {18,0x3FBF8},
    [I(42,38)] = {16,0xF9F8},
    [I(43,38)] = {19,0x7FBF8},
    [I(44,38)] = {16,0xFAF8},
    [I(45,38)] = {14,0x16F8},
    [I(46,38)] = {14,0x17F8},
    [I(47,38)] = {14,0x18F8},
    [I(48,38)] = {13,0xF8},
    [I(49,38)] = {13,0x1F8},
    [I(50,38)] = {13,0x2F8},
    [I(51,38)] = {14,0x19F8},
    [I(52,38)] = {14,0x1AF8},
    [I(53,38)] = {14,0x1BF8},
    [I(54,38)] = {14,0x1CF8},
    [I(55,38)] = {14,0x1DF8},
    [I(56,38)] = {14,0x1EF8},
    [I(57,38)] = {14,0x1FF8},
    [I(58,38)] = {15,0x5CF8},
    [I(59,38)] = {16,0xFBF8},
    [I(60,38)] = {23,0x7FFCF8},
    [I(61,38)] = {14,0x20F8},
    [I(62,38)] = {20,0xFFBF8},
    [I(63,38)] = {18,0x3FCF8},
    [I(64,38)] = {21,0x1FFAF8},
    [I(65,38)] = {14,0x21F8},
    [I(66,38)] = {15,0x5DF8},
    [I(67,38)] = {15,0x5EF8},
    [I(68,38)] = {15,0x5FF8},
    [I(69,38)] = {15,0x60F8},
    [I(70,38)] = {15,0x61F8},
    [I(71,38)] = {15,0x62F8},
    [I(72,38)] = {15,0x63F8},
    [I(73,38)] = {15,0x64F8},
    [I(74,38)] = {15,0x65F8},
    [I(75,38)] = {15,0x66F8},
    [I(76,38)] = {15,0x67F8},
    [I(77,38)] = {15,0x68F8},
    [I(78,38)] = {15,0x69F8},
    [I(79,38)] = {15,0x6AF8},
    [I(80,38)] = {15,0x6BF8},
    [I(81,38)] = {15,0x6CF8},
    [I(82,38)] = {15,0x6DF8},
    [I(83,38)] = {15,0x6EF8},
    [I(84,38)] = {15,0x6FF8},
    [I(85,38)] = {15,0x70F8},
    [I(86,38)] = {15,0x71F8},
    [I(87,38)] = {15,0x72F8},
    [I(88,38)] = {16,0xFCF8},
    [I(89,38)] = {15,0x73F8},
    [I(90,38)] = {16,0xFDF8},
    [I(91,38)] = {21,0x1FFBF8},
    [I(92,38)] = {27,0x7FFF0F8},
    [I(93,38)] = {21,0x1FFCF8},
    [I(94,38)] = {22,0x3FFCF8},
    [I(95,38)] = {14,0x22F8},
    [I(96,38)] = {23,0x7FFDF8},
    [I(97,38)] = {13,0x3F8},
    [I(98,38)] = {14,0x23F8},
    [I(99,38)] = {13,0x4F8},
    [I(100,38)] = {14,0x24F8},
    [I(101,38)] = {13,0x5F8},
    [I(102,38)] = {14,0x25F8},
    [I(103,38)] = {14,0x26F8},
    [I(104,38)] = {14,0x27F8},
    [I(105,38)] = {13,0x6F8},
    [I(106,38)] = {15,0x74F8},
    [I(107,38)] = {15,0x75F8},
    [I(108,38)] = {14,0x28F8},
    [I(109,38)] = {14,0x29F8},
    [I(110,38)] = {14,0x2AF8},
    [I(111,38)] = {13,0x7F8},
    [I(112,38)] = {14,0x2BF8},
    [I(113,38)] = {15,0x76F8},
    [I(114,38)] = {14,0x2CF8},
    [I(115,38)] = {13,0x8F8},
    [I(116,38)] = {13,0x9F8},
    [I(117,38)] = {14,0x2DF8},
    [I(118,38)] = {15,0x77F8},
    [I(119,38)] = {15,0x78F8},
    [I(120,38)] = {15,0x79F8},
    [I(121,38)] = {15,0x7AF8},
    [I(122,38)] = {15,0x7BF8},
    [I(123,38)] = {23,0x7FFEF8},
    [I(124,38)] = {19,0x7FCF8},
    [I(125,38)] = {22,0x3FFDF8},
    [I(126,38)] = {21,0x1FFDF8},
    [I(127,38)] = {64,0},
    [I(128,38)] = {28,0xFFFE6F8},
    [I(129,38)] = {30,0x3FFFD2F8},
    [I(130,38)] = {28,0xFFFE7F8},
    [I(131,38)] = {28,0xFFFE8F8},
    [I(132,38)] = {30,0x3FFFD3F8},
    [I(133,38)] = {30,0x3FFFD4F8},
    [I(134,38)] = {30,0x3FFFD5F8},
    [I(135,38)] = {31,0x7FFFD9F8},
    [I(136,38)] = {30,0x3FFFD6F8},
    [I(137,38)] = {31,0x7FFFDAF8},
    [I(138,38)] = {31,0x7FFFDBF8},
    [I(139,38)] = {31,0x7FFFDCF8},
    [I(140,38)] = {31,0x7FFFDDF8},
    [I(141,38)] = {31,0x7FFFDEF8},
    [I(142,38)] = {X32,0xFFFFEBF8},
    [I(143,38)] = {31,0x7FFFDFF8},
    [I(144,38)] = {X32,0xFFFFECF8},
    [I(145,38)] = {X32,0xFFFFEDF8},
    [I(146,38)] = {30,0x3FFFD7F8},
    [I(147,38)] = {31,0x7FFFE0F8},
    [I(148,38)] = {X32,0xFFFFEEF8},
    [I(149,38)] = {31,0x7FFFE1F8},
    [I(150,38)] = {31,0x7FFFE2F8},
    [I(151,38)] = {31,0x7FFFE3F8},
    [I(152,38)] = {31,0x7FFFE4F8},
    [I(153,38)] = {29,0x1FFFDCF8},
    [I(154,38)] = {30,0x3FFFD8F8},
    [I(155,38)] = {31,0x7FFFE5F8},
    [I(156,38)] = {30,0x3FFFD9F8},
    [I(157,38)] = {31,0x7FFFE6F8},
    [I(158,38)] = {31,0x7FFFE7F8},
    [I(159,38)] = {X32,0xFFFFEFF8},
    [I(160,38)] = {30,0x3FFFDAF8},
    [I(161,38)] = {29,0x1FFFDDF8},
    [I(162,38)] = {28,0xFFFE9F8},
    [I(163,38)] = {30,0x3FFFDBF8},
    [I(164,38)] = {30,0x3FFFDCF8},
    [I(165,38)] = {31,0x7FFFE8F8},
    [I(166,38)] = {31,0x7FFFE9F8},
    [I(167,38)] = {29,0x1FFFDEF8},
    [I(168,38)] = {31,0x7FFFEAF8},
    [I(169,38)] = {30,0x3FFFDDF8},
    [I(170,38)] = {30,0x3FFFDEF8},
    [I(171,38)] = {X32,0xFFFFF0F8},
    [I(172,38)] = {29,0x1FFFDFF8},
    [I(173,38)] = {30,0x3FFFDFF8},
    [I(174,38)] = {31,0x7FFFEBF8},
    [I(175,38)] = {31,0x7FFFECF8},
    [I(176,38)] = {29,0x1FFFE0F8},
    [I(177,38)] = {29,0x1FFFE1F8},
    [I(178,38)] = {30,0x3FFFE0F8},
    [I(179,38)] = {29,0x1FFFE2F8},
    [I(180,38)] = {31,0x7FFFEDF8},
    [I(181,38)] = {30,0x3FFFE1F8},
    [I(182,38)] = {31,0x7FFFEEF8},
    [I(183,38)] = {31,0x7FFFEFF8},
    [I(184,38)] = {28,0xFFFEAF8},
    [I(185,38)] = {30,0x3FFFE2F8},
    [I(186,38)] = {30,0x3FFFE3F8},
    [I(187,38)] = {30,0x3FFFE4F8},
    [I(188,38)] = {31,0x7FFFF0F8},
    [I(189,38)] = {30,0x3FFFE5F8},
    [I(190,38)] = {30,0x3FFFE6F8},
    [I(191,38)] = {31,0x7FFFF1F8},
    [I(192,38)] = {64,0},
    [I(193,38)] = {64,0},
    [I(194,38)] = {28,0xFFFEBF8},
    [I(195,38)] = {27,0x7FFF1F8},
    [I(196,38)] = {30,0x3FFFE7F8},
    [I(197,38)] = {31,0x7FFFF2F8},
    [I(198,38)] = {30,0x3FFFE8F8},
    [I(199,38)] = {64,0},
    [I(200,38)] = {64,0},
    [I(201,38)] = {64,0},
    [I(202,38)] = {64,0},
    [I(203,38)] = {64,0},
    [I(204,38)] = {64,0},
    [I(205,38)] = {64,0},
    [I(206,38)] = {X32,0xFFFFF1F8},
    [I(207,38)] = {64,0},
    [I(208,38)] = {27,0x7FFF2F8},
    [I(209,38)] = {29,0x1FFFE3F8},
    [I(210,38)] = {64,0},
    [I(211,38)] = {64,0},
    [I(212,38)] = {64,0},
    [I(213,38)] = {64,0},
    [I(214,38)] = {64,0},
    [I(215,38)] = {X32,0xFFFFF2F8},
    [I(216,38)] = {29,0x1FFFE4F8},
    [I(217,38)] = {29,0x1FFFE5F8},
    [I(218,38)] = {64,0},
    [I(219,38)] = {64,0},
    [I(220,38)] = {64,0},
    [I(221,38)] = {64,0},
    [I(222,38)] = {64,0},
    [I(223,38)] = {64,0},
    [I(224,38)] = {28,0xFFFECF8},
    [I(225,38)] = {X32,0xFFFFF3F8},
    [I(226,38)] = {28,0xFFFEDF8},
    [I(227,38)] = {29,0x1FFFE6F8},
    [I(228,38)] = {30,0x3FFFE9F8},
    [I(229,38)] = {29,0x1FFFE7F8},
    [I(230,38)] = {29,0x1FFFE8F8},
    [I(231,38)] = {31,0x7FFFF3F8},
    [I(232,38)] = {30,0x3FFFEAF8},
    [I(233,38)] = {30,0x3FFFEBF8},
    [I(234,38)] = {64,0},
    [I(235,38)] = {64,0},
    [I(236,38)] = {X32,0xFFFFF4F8},
    [I(237,38)] = {X32,0xFFFFF5F8},
    [I(238,38)] = {64,0},
    [I(239,38)] = {31,0x7FFFF4F8},
    [I(240,38)] = {64,0},
    [I(241,38)] = {64,0},
    [I(242,38)] = {64,0},
    [I(243,38)] = {64,0},
    [I(244,38)] = {64,0},
    [I(245,38)] = {64,0},
    [I(246,38)] = {64,0},
    [I(247,38)] = {64,0},
    [I(248,38)] = {64,0},
    [I(249,38)] = {64,0},
    [I(250,38)] = {64,0},
    [I(251,38)] = {64,0},
    [I(252,38)] = {64,0},
    [I(253,38)] = {64,0},
    [I(254,38)] = {64,0},
    [I(255,38)] = {64,0},
    [I(0,39)] = {24,0xFFC7FA},
    [I(1,39)] = {64,0},
    [I(2,39)] = {64,0},
    [I(3,39)] = {64,0},
    [I(4,39)] = {64,0},
    [I(5,39)] = {64,0},
    [I(6,39)] = {64,0},
    [I(7,39)] = {64,0},
    [I(8,39)] = {64,0},
    [I(9,39)] = {64,0},
    [I(10,39)] = {64,0},
    [I(11,39)] = {64,0},
    [I(12,39)] = {64,0},
    [I(13,39)] = {64,0},
    [I(14,39)] = {64,0},
    [I(15,39)] = {64,0},
    [I(16,39)] = {64,0},
    [I(17,39)] = {64,0},
    [I(18,39)] = {64,0},
    [I(19,39)] = {64,0},
    [I(20,39)] = {64,0},
    [I(21,39)] = {64,0},
    [I(22,39)] = {64,0},
    [I(23,39)] = {64,0},
    [I(24,39)] = {64,0},
    [I(25,39)] = {64,0},
    [I(26,39)] = {64,0},
    [I(27,39)] = {64,0},
    [I(28,39)] = {64,0},
    [I(29,39)] = {64,0},
    [I(30,39)] = {64,0},
    [I(31,39)] = {64,0},
    [I(32,39)] = {17,0xA7FA},
    [I(33,39)] = {21,0x1FC7FA},
    [I(34,39)] = {21,0x1FCFFA},
    [I(35,39)] = {23,0x7FD7FA},
    [I(36,39)] = {24,0xFFCFFA},
    [I(37,39)] = {17,0xAFFA},
    [I(38,39)] = {19,0x7C7FA},
    [I(39,39)] = {22,0x3FD7FA},
    [I(40,39)] = {21,0x1FD7FA},
    [I(41,39)] = {21,0x1FDFFA},
    [I(42,39)] = {19,0x7CFFA},
    [I(43,39)] = {22,0x3FDFFA},
    [I(44,39)] = {19,0x7D7FA},
    [I(45,39)] = {17,0xB7FA},
    [I(46,39)] = {17,0xBFFA},
    [I(47,39)] = {17,0xC7FA},
    [I(48,39)] = {16,0x7FA},
    [I(49,39)] = {16,0xFFA},
    [I(50,39)] = {16,0x17FA},
    [I(51,39)] = {17,0xCFFA},
    [I(52,39)] = {17,0xD7FA},
    [I(53,39)] = {17,0xDFFA},
    [I(54,39)] = {17,0xE7FA},
    [I(55,39)] = {17,0xEFFA},
    [I(56,39)] = {17,0xF7FA},
    [I(57,39)] = {17,0xFFFA},
    [I(58,39)] = {18,0x2E7FA},
    [I(59,39)] = {19,0x7DFFA},
    [I(60,39)] = {26,0x3FFE7FA},
    [I(61,39)] = {17,0x107FA},
    [I(62,39)] = {23,0x7FDFFA},
    [I(63,39)] = {21,0x1FE7FA},
    [I(64,39)] = {24,0xFFD7FA},
    [I(65,39)] = {17,0x10FFA},
    [I(66,39)] = {18,0x2EFFA},
    [I(67,39)] = {18,0x2F7FA},
    [I(68,39)] = {18,0x2FFFA},
    [I(69,39)] = {18,0x307FA},
    [I(70,39)] = {18,0x30FFA},
    [I(71,39)] = {18,0x317FA},
    [I(72,39)] = {18,0x31FFA},
    [I(73,39)] = {18,0x327FA},
    [I(74,39)] = {18,0x32FFA},
    [I(75,39)] = {18,0x337FA},
    [I(76,39)] = {18,0x33FFA},
    [I(77,39)] = {18,0x347FA},
    [I(78,39)] = {18,0x34FFA},
    [I(79,39)] = {18,0x357FA},
    [I(80,39)] = {18,0x35FFA},
    [I(81,39)] = {18,0x367FA},
    [I(82,39)] = {18,0x36FFA},
    [I(83,39)] = {18,0x377FA},
    [I(84,39)] = {18,0x37FFA},
    [I(85,39)] = {18,0x387FA},
    [I(86,39)] = {18,0x38FFA},
    [I(87,39)] = {18,0x397FA},
    [I(88,39)] = {19,0x7E7FA},
    [I(89,39)] = {18,0x39FFA},
    [I(90,39)] = {19,0x7EFFA},
    [I(91,39)] = {24,0xFFDFFA},
    [I(92,39)] = {30,0x3FFF87FA},
    [I(93,39)] = {24,0xFFE7FA},
    [I(94,39)] = {25,0x1FFE7FA},
    [I(95,39)] = {17,0x117FA},
    [I(96,39)] = {26,0x3FFEFFA},
    [I(97,39)] = {16,0x1FFA},
    [I(98,39)] = {17,0x11FFA},
    [I(99,39)] = {16,0x27FA},
    [I(100,39)] = {17,0x127FA},
    [I(101,39)] = {16,0x2FFA},
    [I(102,39)] = {17,0x12FFA},
    [I(103,39)] = {17,0x137FA},
    [I(104,39)] = {17,0x13FFA},
    [I(105,39)] = {16,0x37FA},
    [I(106,39)] = {18,0x3A7FA},
    [I(107,39)] = {18,0x3AFFA},
    [I(108,39)] = {17,0x147FA},
    [I(109,39)] = {17,0x14FFA},
    [I(110,39)] = {17,0x157FA},
    [I(111,39)] = {16,0x3FFA},
    [I(112,39)] = {17,0x15FFA},
    [I(113,39)] = {18,0x3B7FA},
    [I(114,39)] = {17,0x167FA},
    [I(115,39)] = {16,0x47FA},
    [I(116,39)] = {16,0x4FFA},
    [I(117,39)] = {17,0x16FFA},
    [I(118,39)] = {18,0x3BFFA},
    [I(119,39)] = {18,0x3C7FA},
    [I(120,39)] = {18,0x3CFFA},
    [I(121,39)] = {18,0x3D7FA},
    [I(122,39)] = {18,0x3DFFA},
    [I(123,39)] = {26,0x3FFF7FA},
    [I(124,39)] = {22,0x3FE7FA},
    [I(125,39)] = {25,0x1FFEFFA},
    [I(126,39)] = {24,0xFFEFFA},
    [I(127,39)] = {64,0},
    [I(128,39)] = {31,0x7FFF37FA},
    [I(129,39)] = {64,0},
    [I(130,39)] = {31,0x7FFF3FFA},
    [I(131,39)] = {31,0x7FFF47FA},
    [I(132,39)] = {64,0},
    [I(133,39)] = {64,0},
    [I(134,39)] = {64,0},
    [I(135,39)] = {64,0},
    [I(136,39)] = {64,0},
    [I(137,39)] = {64,0},
    [I(138,39)] = {64,0},
    [I(139,39)] = {64,0},
    [I(140,39)] = {64,0},
    [I(141,39)] = {64,0},
    [I(142,39)] = {64,0},
    [I(143,39)] = {64,0},
    [I(144,39)] = {64,0},
    [I(145,39)] = {64,0},
    [I(146,39)] = {64,0},
    [I(147,39)] = {64,0},
    [I(148,39)] = {64,0},
    [I(149,39)] = {64,0},
    [I(150,39)] = {64,0},
    [I(151,39)] = {64,0},
    [I(152,39)] = {64,0},
    [I(153,39)] = {X32,0xFFFEE7FA},
    [I(154,39)] = {64,0},
    [I(155,39)] = {64,0},
    [I(156,39)] = {64,0},
    [I(157,39)] = {64,0},
    [I(158,39)] = {64,0},
    [I(159,39)] = {64,0},
    [I(160,39)] = {64,0},
    [I(161,39)] = {X32,0xFFFEEFFA},
    [I(162,39)] = {31,0x7FFF4FFA},
    [I(163,39)] = {64,0},
    [I(164,39)] = {64,0},
    [I(165,39)] = {64,0},
    [I(166,39)] = {64,0},
    [I(167,39)] = {X32,0xFFFEF7FA},
    [I(168,39)] = {64,0},
    [I(169,39)] = {64,0},
    [I(170,39)] = {64,0},
    [I(171,39)] = {64,0},
    [I(172,39)] = {X32,0xFFFEFFFA},
    [I(173,39)] = {64,0},
    [I(174,39)] = {64,0},
    [I(175,39)] = {64,0},
    [I(176,39)] = {X32,0xFFFF07FA},
    [I(177,39)] = {X32,0xFFFF0FFA},
    [I(178,39)] = {64,0},
    [I(179,39)] = {X32,0xFFFF17FA},
    [I(180,39)] = {64,0},
    [I(181,39)] = {64,0},
    [I(182,39)] = {64,0},
    [I(183,39)] = {64,0},
    [I(184,39)] = {31,0x7FFF57FA},
    [I(185,39)] = {64,0},
    [I(186,39)] = {64,0},
    [I(187,39)] = {64,0},
    [I(188,39)] = {64,0},
    [I(189,39)] = {64,0},
    [I(190,39)] = {64,0},
    [I(191,39)] = {64,0},
    [I(192,39)] = {64,0},
    [I(193,39)] = {64,0},
    [I(194,39)] = {31,0x7FFF5FFA},
    [I(195,39)] = {30,0x3FFF8FFA},
    [I(196,39)] = {64,0},
    [I(197,39)] = {64,0},
    [I(198,39)] = {64,0},
    [I(199,39)] = {64,0},
    [I(200,39)] = {64,0},
    [I(201,39)] = {64,0},
    [I(202,39)] = {64,0},
    [I(203,39)] = {64,0},
    [I(204,39)] = {64,0},
    [I(205,39)] = {64,0},
    [I(206,39)] = {64,0},
    [I(207,39)] = {64,0},
    [I(208,39)] = {30,0x3FFF97FA},
    [I(209,39)] = {X32,0xFFFF1FFA},
    [I(210,39)] = {64,0},
    [I(211,39)] = {64,0},
    [I(212,39)] = {64,0},
    [I(213,39)] = {64,0},
    [I(214,39)] = {64,0},
    [I(215,39)] = {64,0},
    [I(216,39)] = {X32,0xFFFF27FA},
    [I(217,39)] = {X32,0xFFFF2FFA},
    [I(218,39)] = {64,0},
    [I(219,39)] = {64,0},
    [I(220,39)] = {64,0},
    [I(221,39)] = {64,0},
    [I(222,39)] = {64,0},
    [I(223,39)] = {64,0},
    [I(224,39)] = {31,0x7FFF67FA},
    [I(225,39)] = {64,0},
    [I(226,39)] = {31,0x7FFF6FFA},
    [I(227,39)] = {X32,0xFFFF37FA},
    [I(228,39)] = {64,0},
    [I(229,39)] = {X32,0xFFFF3FFA},
    [I(230,39)] = {X32,0xFFFF47FA},
    [I(231,39)] = {64,0},
    [I(232,39)] = {64,0},
    [I(233,39)] = {64,0},
    [I(234,39)] = {64,0},
    [I(235,39)] = {64,0},
    [I(236,39)] = {64,0},
    [I(237,39)] = {64,0},
    [I(238,39)] = {64,0},
    [I(239,39)] = {64,0},
    [I(240,39)] = {64,0},
    [I(241,39)] = {64,0},
    [I(242,39)] = {64,0},
    [I(243,39)] = {64,0},
    [I(244,39)] = {64,0},
    [I(245,39)] = {64,0},
    [I(246,39)] = {64,0},
    [I(247,39)] = {64,0},
    [I(248,39)] = {64,0},
    [I(249,39)] = {64,0},
    [I(250,39)] = {64,0},
    [I(251,39)] = {64,0},
    [I(252,39)] = {64,0},
    [I(253,39)] = {64,0},
    [I(254,39)] = {64,0},
    [I(255,39)] = {64,0},
    [I(0,40)] = {23,0x7FE3FA},
    [I(1,40)] = {64,0},
    [I(2,40)] = {64,0},
    [I(3,40)] = {64,0},
    [I(4,40)] = {64,0},
    [I(5,40)] = {64,0},
    [I(6,40)] = {64,0},
    [I(7,40)] = {64,0},
    [I(8,40)] = {64,0},
    [I(9,40)] = {64,0},
    [I(10,40)] = {64,0},
    [I(11,40)] = {64,0},
    [I(12,40)] = {64,0},
    [I(13,40)] = {64,0},
    [I(14,40)] = {64,0},
    [I(15,40)] = {64,0},
    [I(16,40)] = {64,0},
    [I(17,40)] = {64,0},
    [I(18,40)] = {64,0},
    [I(19,40)] = {64,0},
    [I(20,40)] = {64,0},
    [I(21,40)] = {64,0},
    [I(22,40)] = {64,0},
    [I(23,40)] = {64,0},
    [I(24,40)] = {64,0},
    [I(25,40)] = {64,0},
    [I(26,40)] = {64,0},
    [I(27,40)] = {64,0},
    [I(28,40)] = {64,0},
    [I(29,40)] = {64,0},
    [I(30,40)] = {64,0},
    [I(31,40)] = {64,0},
    [I(32,40)] = {16,0x53FA},
    [I(33,40)] = {20,0xFE3FA},
    [I(34,40)] = {20,0xFE7FA},
    [I(35,40)] = {22,0x3FEBFA},
    [I(36,40)] = {23,0x7FE7FA},
    [I(37,40)] = {16,0x57FA},
    [I(38,40)] = {18,0x3E3FA},
    [I(39,40)] = {21,0x1FEBFA},
    [I(40,40)] = {20,0xFEBFA},
    [I(41,40)] = {20,0xFEFFA},
    [I(42,40)] = {18,0x3E7FA},
    [I(43,40)] = {21,0x1FEFFA},
    [I(44,40)] = {18,0x3EBFA},
    [I(45,40)] = {16,0x5BFA},
    [I(46,40)] = {16,0x5FFA},
    [I(47,40)] = {16,0x63FA},
    [I(48,40)] = {15,0x3FA},
    [I(49,40)] = {15,0x7FA},
    [I(50,40)] = {15,0xBFA},
    [I(51,40)] = {16,0x67FA},
    [I(52,40)] = {16,0x6BFA},
    [I(53,40)] = {16,0x6FFA},
    [I(54,40)] = {16,0x73FA},
    [I(55,40)] = {16,0x77FA},
    [I(56,40)] = {16,0x7BFA},
    [I(57,40)] = {16,0x7FFA},
    [I(58,40)] = {17,0x173FA},
    [I(59,40)] = {18,0x3EFFA},
    [I(60,40)] = {25,0x1FFF3FA},
    [I(61,40)] = {16,0x83FA},
    [I(62,40)] = {22,0x3FEFFA},
    [I(63,40)] = {20,0xFF3FA},
    [I(64,40)] = {23,0x7FEBFA},
    [I(65,40)] = {16,0x87FA},
    [I(66,40)] = {17,0x177FA},
    [I(67,40)] = {17,0x17BFA},
    [I(68,40)] = {17,0x17FFA},
    [I(69,40)] = {17,0x183FA},
    [I(70,40)] = {17,0x187FA},
    [I(71,40)] = {17,0x18BFA},
    [I(72,40)] = {17,0x18FFA},
    [I(73,40)] = {17,0x193FA},
    [I(74,40)] = {17,0x197FA},
    [I(75,40)] = {17,0x19BFA},
    [I(76,40)] = {17,0x19FFA},
    [I(77,40)] = {17,0x1A3FA},
    [I(78,40)] = {17,0x1A7FA},
    [I(79,40)] = {17,0x1ABFA},
    [I(80,40)] = {17,0x1AFFA},
    [I(81,40)] = {17,0x1B3FA},
    [I(82,40)] = {17,0x1B7FA},
    [I(83,40)] = {17,0x1BBFA},
    [I(84,40)] = {17,0x1BFFA},
    [I(85,40)] = {17,0x1C3FA},
    [I(86,40)] = {17,0x1C7FA},
    [I(87,40)] = {17,0x1CBFA},
    [I(88,40)] = {18,0x3F3FA},
    [I(89,40)] = {17,0x1CFFA},
    [I(90,40)] = {18,0x3F7FA},
    [I(91,40)] = {23,0x7FEFFA},
    [I(92,40)] = {29,0x1FFFC3FA},
    [I(93,40)] = {23,0x7FF3FA},
    [I(94,40)] = {24,0xFFF3FA},
    [I(95,40)] = {16,0x8BFA},
    [I(96,40)] = {25,0x1FFF7FA},
    [I(97,40)] = {15,0xFFA},
    [I(98,40)] = {16,0x8FFA},
    [I(99,40)] = {15,0x13FA},
    [I(100,40)] = {16,0x93FA},
    [I(101,40)] = {15,0x17FA},
    [I(102,40)] = {16,0x97FA},
    [I(103,40)] = {16,0x9BFA},
    [I(104,40)] = {16,0x9FFA},
    [I(105,40)] = {15,0x1BFA},
    [I(106,40)] = {17,0x1D3FA},
    [I(107,40)] = {17,0x1D7FA},
    [I(108,40)] = {16,0xA3FA},
    [I(109,40)] = {16,0xA7FA},
    [I(110,40)] = {16,0xABFA},
    [I(111,40)] = {15,0x1FFA},
    [I(112,40)] = {16,0xAFFA},
    [I(113,40)] = {17,0x1DBFA},
    [I(114,40)] = {16,0xB3FA},
    [I(115,40)] = {15,0x23FA},
    [I(116,40)] = {15,0x27FA},
    [I(117,40)] = {16,0xB7FA},
    [I(118,40)] = {17,0x1DFFA},
    [I(119,40)] = {17,0x1E3FA},
    [I(120,40)] = {17,0x1E7FA},
    [I(121,40)] = {17,0x1EBFA},
    [I(122,40)] = {17,0x1EFFA},
    [I(123,40)] = {25,0x1FFFBFA},
    [I(124,40)] = {21,0x1FF3FA},
    [I(125,40)] = {24,0xFFF7FA},
    [I(126,40)] = {23,0x7FF7FA},
    [I(127,40)] = {64,0},
    [I(128,40)] = {30,0x3FFF9BFA},
    [I(129,40)] = {X32,0xFFFF4BFA},
    [I(130,40)] = {30,0x3FFF9FFA},
    [I(131,40)] = {30,0x3FFFA3FA},
    [I(132,40)] = {X32,0xFFFF4FFA},
    [I(133,40)] = {X32,0xFFFF53FA},
    [I(134,40)] = {X32,0xFFFF57FA},
    [I(135,40)] = {64,0},
    [I(136,40)] = {X32,0xFFFF5BFA},
    [I(137,40)] = {64,0},
    [I(138,40)] = {64,0},
    [I(139,40)] = {64,0},
    [I(140,40)] = {64,0},
    [I(141,40)] = {64,0},
    [I(142,40)] = {64,0},
    [I(143,40)] = {64,0},
    [I(144,40)] = {64,0},
    [I(145,40)] = {64,0},
    [I(146,40)] = {X32,0xFFFF5FFA},
    [I(147,40)] = {64,0},
    [I(148,40)] = {64,0},
    [I(149,40)] = {64,0},
    [I(150,40)] = {64,0},
    [I(151,40)] = {64,0},
    [I(152,40)] = {64,0},
    [I(153,40)] = {31,0x7FFF73FA},
    [I(154,40)] = {X32,0xFFFF63FA},
    [I(155,40)] = {64,0},
    [I(156,40)] = {X32,0xFFFF67FA},
    [I(157,40)] = {64,0},
    [I(158,40)] = {64,0},
    [I(159,40)] = {64,0},
    [I(160,40)] = {X32,0xFFFF6BFA},
    [I(161,40)] = {31,0x7FFF77FA},
    [I(162,40)] = {30,0x3FFFA7FA},
    [I(163,40)] = {X32,0xFFFF6FFA},
    [I(164,40)] = {X32,0xFFFF73FA},
    [I(165,40)] = {64,0},
    [I(166,40)] = {64,0},
    [I(167,40)] = {31,0x7FFF7BFA},
    [I(168,40)] = {64,0},
    [I(169,40)] = {X32,0xFFFF77FA},
    [I(170,40)] = {X32,0xFFFF7BFA},
    [I(171,40)] = {64,0},
    [I(172,40)] = {31,0x7FFF7FFA},
    [I(173,40)] = {X32,0xFFFF7FFA},
    [I(174,40)] = {64,0},
    [I(175,40)] = {64,0},
    [I(176,40)] = {31,0x7FFF83FA},
    [I(177,40)] = {31,0x7FFF87FA},
    [I(178,40)] = {X32,0xFFFF83FA},
    [I(179,40)] = {31,0x7FFF8BFA},
    [I(180,40)] = {64,0},
    [I(181,40)] = {X32,0xFFFF87FA},
    [I(182,40)] = {64,0},
    [I(183,40)] = {64,0},
    [I(184,40)] = {30,0x3FFFABFA},
    [I(185,40)] = {X32,0xFFFF8BFA},
    [I(186,40)] = {X32,0xFFFF8FFA},
    [I(187,40)] = {X32,0xFFFF93FA},
    [I(188,40)] = {64,0},
    [I(189,40)] = {X32,0xFFFF97FA},
    [I(190,40)] = {X32,0xFFFF9BFA},
    [I(191,40)] = {64,0},
    [I(192,40)] = {64,0},
    [I(193,40)] = {64,0},
    [I(194,40)] = {30,0x3FFFAFFA},
    [I(195,40)] = {29,0x1FFFC7FA},
    [I(196,40)] = {X32,0xFFFF9FFA},
    [I(197,40)] = {64,0},
    [I(198,40)] = {X32,0xFFFFA3FA},
    [I(199,40)] = {64,0},
    [I(200,40)] = {64,0},
    [I(201,40)] = {64,0},
    [I(202,40)] = {64,0},
    [I(203,40)] = {64,0},
    [I(204,40)] = {64,0},
    [I(205,40)] = {64,0},
    [I(206,40)] = {64,0},
    [I(207,40)] = {64,0},
    [I(208,40)] = {29,0x1FFFCBFA},
    [I(209,40)] = {31,0x7FFF8FFA},
    [I(210,40)] = {64,0},
    [I(211,40)] = {64,0},
    [I(212,40)] = {64,0},
    [I(213,40)] = {64,0},
    [I(214,40)] = {64,0},
    [I(215,40)] = {64,0},
    [I(216,40)] = {31,0x7FFF93FA},
    [I(217,40)] = {31,0x7FFF97FA},
    [I(218,40)] = {64,0},
    [I(219,40)] = {64,0},
    [I(220,40)] = {64,0},
    [I(221,40)] = {64,0},
    [I(222,40)] = {64,0},
    [I(223,40)] = {64,0},
    [I(224,40)] = {30,0x3FFFB3FA},
    [I(225,40)] = {64,0},
    [I(226,40)] = {30,0x3FFFB7FA},
    [I(227,40)] = {31,0x7FFF9BFA},
    [I(228,40)] = {X32,0xFFFFA7FA},
    [I(229,40)] = {31,0x7FFF9FFA},
    [I(230,40)] = {31,0x7FFFA3FA},
    [I(231,40)] = {64,0},
    [I(232,40)] = {X32,0xFFFFABFA},
    [I(233,40)] = {X32,0xFFFFAFFA},
    [I(234,40)] = {64,0},
    [I(235,40)] = {64,0},
    [I(236,40)] = {64,0},
    [I(237,40)] = {64,0},
    [I(238,40)] = {64,0},
    [I(239,40)] = {64,0},
    [I(240,40)] = {64,0},
    [I(241,40)] = {64,0},
    [I(242,40)] = {64,0},
    [I(243,40)] = {64,0},
    [I(244,40)] = {64,0},
    [I(245,40)] = {64,0},
    [I(246,40)] = {64,0},
    [I(247,40)] = {64,0},
    [I(248,40)] = {64,0},
    [I(249,40)] = {64,0},
    [I(250,40)] = {64,0},
    [I(251,40)] = {64,0},
    [I(252,40)] = {64,0},
    [I(253,40)] = {64,0},
    [I(254,40)] = {64,0},
    [I(255,40)] = {64,0},
    [I(0,41)] = {23,0x7FE3FB},
    [I(1,41)] = {64,0},
    [I(2,41)] = {64,0},
    [I(3,41)] = {64,0},
    [I(4,41)] = {64,0},
    [I(5,41)] = {64,0},
    [I(6,41)] = {64,0},
    [I(7,41)] = {64,0},
    [I(8,41)] = {64,0},
    [I(9,41)] = {64,0},
    [I(10,41)] = {64,0},
    [I(11,41)] = {64,0},
    [I(12,41)] = {64,0},
    [I(13,41)] = {64,0},
    [I(14,41)] = {64,0},
    [I(15,41)] = {64,0},
    [I(16,41)] = {64,0},
    [I(17,41)] = {64,0},
    [I(18,41)] = {64,0},
    [I(19,41)] = {64,0},
    [I(20,41)] = {64,0},
    [I(21,41)] = {64,0},
    [I(22,41)] = {64,0},
    [I(23,41)] = {64,0},
    [I(24,41)] = {64,0},
    [I(25,41)] = {64,0},
    [I(26,41)] = {64,0},
    [I(27,41)] = {64,0},
    [I(28,41)] = {64,0},
    [I(29,41)] = {64,0},
    [I(30,41)] = {64,0},
    [I(31,41)] = {64,0},
    [I(32,41)] = {16,0x53FB},
    [I(33,41)] = {20,0xFE3FB},
    [I(34,41)] = {20,0xFE7FB},
    [I(35,41)] = {22,0x3FEBFB},
    [I(36,41)] = {23,0x7FE7FB},
    [I(37,41)] = {16,0x57FB},
    [I(38,41)] = {18,0x3E3FB},
    [I(39,41)] = {21,0x1FEBFB},
    [I(40,41)] = {20,0xFEBFB},
    [I(41,41)] = {20,0xFEFFB},
    [I(42,41)] = {18,0x3E7FB},
    [I(43,41)] = {21,0x1FEFFB},
    [I(44,41)] = {18,0x3EBFB},
    [I(45,41)] = {16,0x5BFB},
    [I(46,41)] = {16,0x5FFB},
    [I(47,41)] = {16,0x63FB},
    [I(48,41)] = {15,0x3FB},
    [I(49,41)] = {15,0x7FB},
    [I(50,41)] = {15,0xBFB},
    [I(51,41)] = {16,0x67FB},
    [I(52,41)] = {16,0x6BFB},
    [I(53,41)] = {16,0x6FFB},
    [I(54,41)] = {16,0x73FB},
    [I(55,41)] = {16,0x77FB},
    [I(56,41)] = {16,0x7BFB},
    [I(57,41)] = {16,0x7FFB},
    [I(58,41)] = {17,0x173FB},
    [I(59,41)] = {18,0x3EFFB},
    [I(60,41)] = {25,0x1FFF3FB},
    [I(61,41)] = {16,0x83FB},
    [I(62,41)] = {22,0x3FEFFB},
    [I(63,41)] = {20,0xFF3FB},
    [I(64,41)] = {23,0x7FEBFB},
    [I(65,41)] = {16,0x87FB},
    [I(66,41)] = {17,0x177FB},
    [I(67,41)] = {17,0x17BFB},
    [I(68,41)] = {17,0x17FFB},
    [I(69,41)] = {17,0x183FB},
    [I(70,41)] = {17,0x187FB},
    [I(71,41)] = {17,0x18BFB},
    [I(72,41)] = {17,0x18FFB},
    [I(73,41)] = {17,0x193FB},
    [I(74,41)] = {17,0x197FB},
    [I(75,41)] = {17,0x19BFB},
    [I(76,41)] = {17,0x19FFB},
    [I(77,41)] = {17,0x1A3FB},
    [I(78,41)] = {17,0x1A7FB},
    [I(79,41)] = {17,0x1ABFB},
    [I(80,41)] = {17,0x1AFFB},
    [I(81,41)] = {17,0x1B3FB},
    [I(82,41)] = {17,0x1B7FB},
    [I(83,41)] = {17,0x1BBFB},
    [I(84,41)] = {17,0x1BFFB},
    [I(85,41)] = {17,0x1C3FB},
    [I(86,41)] = {17,0x1C7FB},
    [I(87,41)] = {17,0x1CBFB},
    [I(88,41)] = {18,0x3F3FB},
    [I(89,41)] = {17,0x1CFFB},
    [I(90,41)] = {18,0x3F7FB},
    [I(91,41)] = {23,0x7FEFFB},
    [I(92,41)] = {29,0x1FFFC3FB},
    [I(93,41)] = {23,0x7FF3FB},
    [I(94,41)] = {24,0xFFF3FB},
    [I(95,41)] = {16,0x8BFB},
    [I(96,41)] = {25,0x1FFF7FB},
    [I(97,41)] = {15,0xFFB},
    [I(98,41)] = {16,0x8FFB},
    [I(99,41)] = {15,0x13FB},
    [I(100,41)] = {16,0x93FB},
    [I(101,41)] = {15,0x17FB},
    [I(102,41)] = {16,0x97FB},
    [I(103,41)] = {16,0x9BFB},
    [I(104,41)] = {16,0x9FFB},
    [I(105,41)] = {15,0x1BFB},
    [I(106,41)] = {17,0x1D3FB},
    [I(107,41)] = {17,0x1D7FB},
    [I(108,41)] = {16,0xA3FB},
    [I(109,41)] = {16,0xA7FB},
    [I(110,41)] = {16,0xABFB},
    [I(111,41)] = {15,0x1FFB},
    [I(112,41)] = {16,0xAFFB},
    [I(113,41)] = {17,0x1DBFB},
    [I(114,41)] = {16,0xB3FB},
    [I(115,41)] = {15,0x23FB},
    [I(116,41)] = {15,0x27FB},
    [I(117,41)] = {16,0xB7FB},
    [I(118,41)] = {17,0x1DFFB},
    [I(119,41)] = {17,0x1E3FB},
    [I(120,41)] = {17,0x1E7FB},
    [I(121,41)] = {17,0x1EBFB},
    [I(122,41)] = {17,0x1EFFB},
    [I(123,41)] = {25,0x1FFFBFB},
    [I(124,41)] = {21,0x1FF3FB},
    [I(125,41)] = {24,0xFFF7FB},
    [I(126,41)] = {23,0x7FF7FB},
    [I(127,41)] = {64,0},
    [I(128,41)] = {30,0x3FFF9BFB},
    [I(129,41)] = {X32,0xFFFF4BFB},
    [I(130,41)] = {30,0x3FFF9FFB},
    [I(131,41)] = {30,0x3FFFA3FB},
    [I(132,41)] = {X32,0xFFFF4FFB},
    [I(133,41)] = {X32,0xFFFF53FB},
    [I(134,41)] = {X32,0xFFFF57FB},
    [I(135,41)] = {64,0},
    [I(136,41)] = {X32,0xFFFF5BFB},
    [I(137,41)] = {64,0},
    [I(138,41)] = {64,0},
    [I(139,41)] = {64,0},
    [I(140,41)] = {64,0},
    [I(141,41)] = {64,0},
    [I(142,41)] = {64,0},
    [I(143,41)] = {64,0},
    [I(144,41)] = {64,0},
    [I(145,41)] = {64,0},
    [I(146,41)] = {X32,0xFFFF5FFB},
    [I(147,41)] = {64,0},
    [I(148,41)] = {64,0},
    [I(149,41)] = {64,0},
    [I(150,41)] = {64,0},
    [I(151,41)] = {64,0},
    [I(152,41)] = {64,0},
    [I(153,41)] = {31,0x7FFF73FB},
    [I(154,41)] = {X32,0xFFFF63FB},
    [I(155,41)] = {64,0},
    [I(156,41)] = {X32,0xFFFF67FB},
    [I(157,41)] = {64,0},
    [I(158,41)] = {64,0},
    [I(159,41)] = {64,0},
    [I(160,41)] = {X32,0xFFFF6BFB},
    [I(161,41)] = {31,0x7FFF77FB},
    [I(162,41)] = {30,0x3FFFA7FB},
    [I(163,41)] = {X32,0xFFFF6FFB},
    [I(164,41)] = {X32,0xFFFF73FB},
    [I(165,41)] = {64,0},
    [I(166,41)] = {64,0},
    [I(167,41)] = {31,0x7FFF7BFB},
    [I(168,41)] = {64,0},
    [I(169,41)] = {X32,0xFFFF77FB},
    [I(170,41)] = {X32,0xFFFF7BFB},
    [I(171,41)] = {64,0},
    [I(172,41)] = {31,0x7FFF7FFB},
    [I(173,41)] = {X32,0xFFFF7FFB},
    [I(174,41)] = {64,0},
    [I(175,41)] = {64,0},
    [I(176,41)] = {31,0x7FFF83FB},
    [I(177,41)] = {31,0x7FFF87FB},
    [I(178,41)] = {X32,0xFFFF83FB},
    [I(179,41)] = {31,0x7FFF8BFB},
    [I(180,41)] = {64,0},
    [I(181,41)] = {X32,0xFFFF87FB},
    [I(182,41)] = {64,0},
    [I(183,41)] = {64,0},
    [I(184,41)] = {30,0x3FFFABFB},
    [I(185,41)] = {X32,0xFFFF8BFB},
    [I(186,41)] = {X32,0xFFFF8FFB},
    [I(187,41)] = {X32,0xFFFF93FB},
    [I(188,41)] = {64,0},
    [I(189,41)] = {X32,0xFFFF97FB},
    [I(190,41)] = {X32,0xFFFF9BFB},
    [I(191,41)] = {64,0},
    [I(192,41)] = {64,0},
    [I(193,41)] = {64,0},
    [I(194,41)] = {30,0x3FFFAFFB},
    [I(195,41)] = {29,0x1FFFC7FB},
    [I(196,41)] = {X32,0xFFFF9FFB},
    [I(197,41)] = {64,0},
    [I(198,41)] = {X32,0xFFFFA3FB},
    [I(199,41)] = {64,0},
    [I(200,41)] = {64,0},
    [I(201,41)] = {64,0},
    [I(202,41)] = {64,0},
    [I(203,41)] = {64,0},
    [I(204,41)] = {64,0},
    [I(205,41)] = {64,0},
    [I(206,41)] = {64,0},
    [I(207,41)] = {64,0},
    [I(208,41)] = {29,0x1FFFCBFB},
    [I(209,41)] = {31,0x7FFF8FFB},
    [I(210,41)] = {64,0},
    [I(211,41)] = {64,0},
    [I(212,41)] = {64,0},
    [I(213,41)] = {64,0},
    [I(214,41)] = {64,0},
    [I(215,41)] = {64,0},
    [I(216,41)] = {31,0x7FFF93FB},
    [I(217,41)] = {31,0x7FFF97FB},
    [I(218,41)] = {64,0},
    [I(219,41)] = {64,0},
    [I(220,41)] = {64,0},
    [I(221,41)] = {64,0},
    [I(222,41)] = {64,0},
    [I(223,41)] = {64,0},
    [I(224,41)] = {30,0x3FFFB3FB},
    [I(225,41)] = {64,0},
    [I(226,41)] = {30,0x3FFFB7FB},
    [I(227,41)] = {31,0x7FFF9BFB},
    [I(228,41)] = {X32,0xFFFFA7FB},
    [I(229,41)] = {31,0x7FFF9FFB},
    [I(230,41)] = {31,0x7FFFA3FB},
    [I(231,41)] = {64,0},
    [I(232,41)] = {X32,0xFFFFABFB},
    [I(233,41)] = {X32,0xFFFFAFFB},
    [I(234,41)] = {64,0},
    [I(235,41)] = {64,0},
    [I(236,41)] = {64,0},
    [I(237,41)] = {64,0},
    [I(238,41)] = {64,0},
    [I(239,41)] = {64,0},
    [I(240,41)] = {64,0},
    [I(241,41)] = {64,0},
    [I(242,41)] = {64,0},
    [I(243,41)] = {64,0},
    [I(244,41)] = {64,0},
    [I(245,41)] = {64,0},
    [I(246,41)] = {64,0},
    [I(247,41)] = {64,0},
    [I(248,41)] = {64,0},
    [I(249,41)] = {64,0},
    [I(250,41)] = {64,0},
    [I(251,41)] = {64,0},
    [I(252,41)] = {64,0},
    [I(253,41)] = {64,0},
    [I(254,41)] = {64,0},
    [I(255,41)] = {64,0},
    [I(0,42)] = {21,0x1FF8F9},
    [I(1,42)] = {31,0x7FFFD8F9},
    [I(2,42)] = {64,0},
    [I(3,42)] = {64,0},
    [I(4,42)] = {64,0},
    [I(5,42)] = {64,0},
    [I(6,42)] = {64,0},
    [I(7,42)] = {64,0},
    [I(8,42)] = {64,0},
    [I(9,42)] = {X32,0xFFFFEAF9},
    [I(10,42)] = {64,0},
    [I(11,42)] = {64,0},
    [I(12,42)] = {64,0},
    [I(13,42)] = {64,0},
    [I(14,42)] = {64,0},
    [I(15,42)] = {64,0},
    [I(16,42)] = {64,0},
    [I(17,42)] = {64,0},
    [I(18,42)] = {64,0},
    [I(19,42)] = {64,0},
    [I(20,42)] = {64,0},
    [I(21,42)] = {64,0},
    [I(22,42)] = {64,0},
    [I(23,42)] = {64,0},
    [I(24,42)] = {64,0},
    [I(25,42)] = {64,0},
    [I(26,42)] = {64,0},
    [I(27,42)] = {64,0},
    [I(28,42)] = {64,0},
    [I(29,42)] = {64,0},
    [I(30,42)] = {64,0},
    [I(31,42)] = {64,0},
    [I(32,42)] = {14,0x14F9},
    [I(33,42)] = {18,0x3F8F9},
    [I(34,42)] = {18,0x3F9F9},
    [I(35,42)] = {20,0xFFAF9},
    [I(36,42)] = {21,0x1FF9F9},
    [I(37,42)] = {14,0x15F9},
    [I(38,42)] = {16,0xF8F9},
    [I(39,42)] = {19,0x7FAF9},
    [I(40,42)] = {18,0x3FAF9},
    [I(41,42)] = {18,0x3FBF9},
    [I(42,42)] = {16,0xF9F9},
    [I(43,42)] = {19,0x7FBF9},
    [I(44,42)] = {16,0xFAF9},
    [I(45,42)] = {14,0x16F9},
    [I(46,42)] = {14,0x17F9},
    [I(47,42)] = {14,0x18F9},
    [I(48,42)] = {13,0xF9},
    [I(49,42)] = {13,0x1F9},
    [I(50,42)] = {13,0x2F9},
    [I(51,42)] = {14,0x19F9},
    [I(52,42)] = {14,0x1AF9},
    [I(53,42)] = {14,0x1BF9},
    [I(54,42)] = {14,0x1CF9},
    [I(55,42)] = {14,0x1DF9},
    [I(56,42)] = {14,0x1EF9},
    [I(57,42)] = {14,0x1FF9},
    [I(58,42)] = {15,0x5CF9},
    [I(59,42)] = {16,0xFBF9},
    [I(60,42)] = {23,0x7FFCF9},
    [I(61,42)] = {14,0x20F9},
    [I(62,42)] = {20,0xFFBF9},
    [I(63,42)] = {18,0x3FCF9},
    [I(64,42)] = {21,0x1FFAF9},
    [I(65,42)] = {14,0x21F9},
    [I(66,42)] = {15,0x5DF9},
    [I(67,42)] = {15,0x5EF9},
    [I(68,42)] = {15,0x5FF9},
    [I(69,42)] = {15,0x60F9},
    [I(70,42)] = {15,0x61F9},
    [I(71,42)] = {15,0x62F9},
    [I(72,42)] = {15,0x63F9},
    [I(73,42)] = {15,0x64F9},
    [I(74,42)] = {15,0x65F9},
    [I(75,42)] = {15,0x66F9},
    [I(76,42)] = {15,0x67F9},
    [I(77,42)] = {15,0x68F9},
    [I(78,42)] = {15,0x69F9},
    [I(79,42)] = {15,0x6AF9},
    [I(80,42)] = {15,0x6BF9},
    [I(81,42)] = {15,0x6CF9},
    [I(82,42)] = {15,0x6DF9},
    [I(83,42)] = {15,0x6EF9},
    [I(84,42)] = {15,0x6FF9},
    [I(85,42)] = {15,0x70F9},
    [I(86,42)] = {15,0x71F9},
    [I(87,42)] = {15,0x72F9},
    [I(88,42)] = {16,0xFCF9},
    [I(89,42)] = {15,0x73F9},
    [I(90,42)] = {16,0xFDF9},
    [I(91,42)] = {21,0x1FFBF9},
    [I(92,42)] = {27,0x7FFF0F9},
    [I(93,42)] = {21,0x1FFCF9},
    [I(94,42)] = {22,0x3FFCF9},
    [I(95,42)] = {14,0x22F9},
    [I(96,42)] = {23,0x7FFDF9},
    [I(97,42)] = {13,0x3F9},
    [I(98,42)] = {14,0x23F9},
    [I(99,42)] = {13,0x4F9},
    [I(100,42)] = {14,0x24F9},
    [I(101,42)] = {13,0x5F9},
    [I(102,42)] = {14,0x25F9},
    [I(103,42)] = {14,0x26F9},
    [I(104,42)] = {14,0x27F9},
    [I(105,42)] = {13,0x6F9},
    [I(106,42)] = {15,0x74F9},
    [I(107,42)] = {15,0x75F9},
    [I(108,42)] = {14,0x28F9},
    [I(109,42)] = {14,0x29F9},
    [I(110,42)] = {14,0x2AF9},
    [I(111,42)] = {13,0x7F9},
    [I(112,42)] = {14,0x2BF9},
    [I(113,42)] = {15,0x76F9},
    [I(114,42)] = {14,0x2CF9},
    [I(115,42)] = {13,0x8F9},
    [I(116,42)] = {13,0x9F9},
    [I(117,42)] = {14,0x2DF9},
    [I(118,42)] = {15,0x77F9},
    [I(119,42)] = {15,0x78F9},
    [I(120,42)] = {15,0x79F9},
    [I(121,42)] = {15,0x7AF9},
    [I(122,42)] = {15,0x7BF9},
    [I(123,42)] = {23,0x7FFEF9},
    [I(124,42)] = {19,0x7FCF9},
    [I(125,42)] = {22,0x3FFDF9},
    [I(126,42)] = {21,0x1FFDF9},
    [I(127,42)] = {64,0},
    [I(128,42)] = {28,0xFFFE6F9},
    [I(129,42)] = {30,0x3FFFD2F9},
    [I(130,42)] = {28,0xFFFE7F9},
    [I(131,42)] = {28,0xFFFE8F9},
    [I(132,42)] = {30,0x3FFFD3F9},
    [I(133,42)] = {30,0x3FFFD4F9},
    [I(134,42)] = {30,0x3FFFD5F9},
    [I(135,42)] = {31,0x7FFFD9F9},
    [I(136,42)] = {30,0x3FFFD6F9},
    [I(137,42)] = {31,0x7FFFDAF9},
    [I(138,42)] = {31,0x7FFFDBF9},
    [I(139,42)] = {31,0x7FFFDCF9},
    [I(140,42)] = {31,0x7FFFDDF9},
    [I(141,42)] = {31,0x7FFFDEF9},
    [I(142,42)] = {X32,0xFFFFEBF9},
    [I(143,42)] = {31,0x7FFFDFF9},
    [I(144,42)] = {X32,0xFFFFECF9},
    [I(145,42)] = {X32,0xFFFFEDF9},
    [I(146,42)] = {30,0x3FFFD7F9},
    [I(147,42)] = {31,0x7FFFE0F9},
    [I(148,42)] = {X32,0xFFFFEEF9},
    [I(149,42)] = {31,0x7FFFE1F9},
    [I(150,42)] = {31,0x7FFFE2F9},
    [I(151,42)] = {31,0x7FFFE3F9},
    [I(152,42)] = {31,0x7FFFE4F9},
    [I(153,42)] = {29,0x1FFFDCF9},
    [I(154,42)] = {30,0x3FFFD8F9},
    [I(155,42)] = {31,0x7FFFE5F9},
    [I(156,42)] = {30,0x3FFFD9F9},
    [I(157,42)] = {31,0x7FFFE6F9},
    [I(158,42)] = {31,0x7FFFE7F9},
    [I(159,42)] = {X32,0xFFFFEFF9},
    [I(160,42)] = {30,0x3FFFDAF9},
    [I(161,42)] = {29,0x1FFFDDF9},
    [I(162,42)] = {28,0xFFFE9F9},
    [I(163,42)] = {30,0x3FFFDBF9},
    [I(164,42)] = {30,0x3FFFDCF9},
    [I(165,42)] = {31,0x7FFFE8F9},
    [I(166,42)] = {31,0x7FFFE9F9},
    [I(167,42)] = {29,0x1FFFDEF9},
    [I(168,42)] = {31,0x7FFFEAF9},
    [I(169,42)] = {30,0x3FFFDDF9},
    [I(170,42)] = {30,0x3FFFDEF9},
    [I(171,42)] = {X32,0xFFFFF0F9},
    [I(172,42)] = {29,0x1FFFDFF9},
    [I(173,42)] = {30,0x3FFFDFF9},
    [I(174,42)] = {31,0x7FFFEBF9},
    [I(175,42)] = {31,0x7FFFECF9},
    [I(176,42)] = {29,0x1FFFE0F9},
    [I(177,42)] = {29,0x1FFFE1F9},
    [I(178,42)] = {30,0x3FFFE0F9},
    [I(179,42)] = {29,0x1FFFE2F9},
    [I(180,42)] = {31,0x7FFFEDF9},
    [I(181,42)] = {30,0x3FFFE1F9},
    [I(182,42)] = {31,0x7FFFEEF9},
    [I(183,42)] = {31,0x7FFFEFF9},
    [I(184,42)] = {28,0xFFFEAF9},
    [I(185,42)] = {30,0x3FFFE2F9},
    [I(186,42)] = {30,0x3FFFE3F9},
    [I(187,42)] = {30,0x3FFFE4F9},
    [I(188,42)] = {31,0x7FFFF0F9},
    [I(189,42)] = {30,0x3FFFE5F9},
    [I(190,42)] = {30,0x3FFFE6F9},
    [I(191,42)] = {31,0x7FFFF1F9},
    [I(192,42)] = {64,0},
    [I(193,42)] = {64,0},
    [I(194,42)] = {28,0xFFFEBF9},
    [I(195,42)] = {27,0x7FFF1F9},
    [I(196,42)] = {30,0x3FFFE7F9},
    [I(197,42)] = {31,0x7FFFF2F9},
    [I(198,42)] = {30,0x3FFFE8F9},
    [I(199,42)] = {64,0},
    [I(200,42)] = {64,0},
    [I(201,42)] = {64,0},
    [I(202,42)] = {64,0},
    [I(203,42)] = {64,0},
    [I(204,42)] = {64,0},
    [I(205,42)] = {64,0},
    [I(206,42)] = {X32,0xFFFFF1F9},
    [I(207,42)] = {64,0},
    [I(208,42)] = {27,0x7FFF2F9},
    [I(209,42)] = {29,0x1FFFE3F9},
    [I(210,42)] = {64,0},
    [I(211,42)] = {64,0},
    [I(212,42)] = {64,0},
    [I(213,42)] = {64,0},
    [I(214,42)] = {64,0},
    [I(215,42)] = {X32,0xFFFFF2F9},
    [I(216,42)] = {29,0x1FFFE4F9},
    [I(217,42)] = {29,0x1FFFE5F9},
    [I(218,42)] = {64,0},
    [I(219,42)] = {64,0},
    [I(220,42)] = {64,0},
    [I(221,42)] = {64,0},
    [I(222,42)] = {64,0},
    [I(223,42)] = {64,0},
    [I(224,42)] = {28,0xFFFECF9},
    [I(225,42)] = {X32,0xFFFFF3F9},
    [I(226,42)] = {28,0xFFFEDF9},
    [I(227,42)] = {29,0x1FFFE6F9},
    [I(228,42)] = {30,0x3FFFE9F9},
    [I(229,42)] = {29,0x1FFFE7F9},
    [I(230,42)] = {29,0x1FFFE8F9},
    [I(231,42)] = {31,0x7FFFF3F9},
    [I(232,42)] = {30,0x3FFFEAF9},
    [I(233,42)] = {30,0x3FFFEBF9},
    [I(234,42)] = {64,0},
    [I(235,42)] = {64,0},
    [I(236,42)] = {X32,0xFFFFF4F9},
    [I(237,42)] = {X32,0xFFFFF5F9},
    [I(238,42)] = {64,0},
    [I(239,42)] = {31,0x7FFFF4F9},
    [I(240,42)] = {64,0},
    [I(241,42)] = {64,0},
    [I(242,42)] = {64,0},
    [I(243,42)] = {64,0},
    [I(244,42)] = {64,0},
    [I(245,42)] = {64,0},
    [I(246,42)] = {64,0},
    [I(247,42)] = {64,0},
    [I(248,42)] = {64,0},
    [I(249,42)] = {64,0},
    [I(250,42)] = {64,0},
    [I(251,42)] = {64,0},
    [I(252,42)] = {64,0},
    [I(253,42)] = {64,0},
    [I(254,42)] = {64,0},
    [I(255,42)] = {64,0},
    [I(0,43)] = {24,0xFFC7FB},
    [I(1,43)] = {64,0},
    [I(2,43)] = {64,0},
    [I(3,43)] = {64,0},
    [I(4,43)] = {64,0},
    [I(5,43)] = {64,0},
    [I(6,43)] = {64,0},
    [I(7,43)] = {64,0},
    [I(8,43)] = {64,0},
    [I(9,43)] = {64,0},
    [I(10,43)] = {64,0},
    [I(11,43)] = {64,0},
    [I(12,43)] = {64,0},
    [I(13,43)] = {64,0},
    [I(14,43)] = {64,0},
    [I(15,43)] = {64,0},
    [I(16,43)] = {64,0},
    [I(17,43)] = {64,0},
    [I(18,43)] = {64,0},
    [I(19,43)] = {64,0},
    [I(20,43)] = {64,0},
    [I(21,43)] = {64,0},
    [I(22,43)] = {64,0},
    [I(23,43)] = {64,0},
    [I(24,43)] = {64,0},
    [I(25,43)] = {64,0},
    [I(26,43)] = {64,0},
    [I(27,43)] = {64,0},
    [I(28,43)] = {64,0},
    [I(29,43)] = {64,0},
    [I(30,43)] = {64,0},
    [I(31,43)] = {64,0},
    [I(32,43)] = {17,0xA7FB},
    [I(33,43)] = {21,0x1FC7FB},
    [I(34,43)] = {21,0x1FCFFB},
    [I(35,43)] = {23,0x7FD7FB},
    [I(36,43)] = {24,0xFFCFFB},
    [I(37,43)] = {17,0xAFFB},
    [I(38,43)] = {19,0x7C7FB},
    [I(39,43)] = {22,0x3FD7FB},
    [I(40,43)] = {21,0x1FD7FB},
    [I(41,43)] = {21,0x1FDFFB},
    [I(42,43)] = {19,0x7CFFB},
    [I(43,43)] = {22,0x3FDFFB},
    [I(44,43)] = {19,0x7D7FB},
    [I(45,43)] = {17,0xB7FB},
    [I(46,43)] = {17,0xBFFB},
    [I(47,43)] = {17,0xC7FB},
    [I(48,43)] = {16,0x7FB},
    [I(49,43)] = {16,0xFFB},
    [I(50,43)] = {16,0x17FB},
    [I(51,43)] = {17,0xCFFB},
    [I(52,43)] = {17,0xD7FB},
    [I(53,43)] = {17,0xDFFB},
    [I(54,43)] = {17,0xE7FB},
    [I(55,43)] = {17,0xEFFB},
    [I(56,43)] = {17,0xF7FB},
    [I(57,43)] = {17,0xFFFB},
    [I(58,43)] = {18,0x2E7FB},
    [I(59,43)] = {19,0x7DFFB},
    [I(60,43)] = {26,0x3FFE7FB},
    [I(61,43)] = {17,0x107FB},
    [I(62,43)] = {23,0x7FDFFB},
    [I(63,43)] = {21,0x1FE7FB},
    [I(64,43)] = {24,0xFFD7FB},
    [I(65,43)] = {17,0x10FFB},
    [I(66,43)] = {18,0x2EFFB},
    [I(67,43)] = {18,0x2F7FB},
    [I(68,43)] = {18,0x2FFFB},
    [I(69,43)] = {18,0x307FB},
    [I(70,43)] = {18,0x30FFB},
    [I(71,43)] = {18,0x317FB},
    [I(72,43)] = {18,0x31FFB},
    [I(73,43)] = {18,0x327FB},
    [I(74,43)] = {18,0x32FFB},
    [I(75,43)] = {18,0x337FB},
    [I(76,43)] = {18,0x33FFB},
    [I(77,43)] = {18,0x347FB},
    [I(78,43)] = {18,0x34FFB},
    [I(79,43)] = {18,0x357FB},
    [I(80,43)] = {18,0x35FFB},
    [I(81,43)] = {18,0x367FB},
    [I(82,43)] = {18,0x36FFB},
    [I(83,43)] = {18,0x377FB},
    [I(84,43)] = {18,0x37FFB},
    [I(85,43)] = {18,0x387FB},
    [I(86,43)] = {18,0x38FFB},
    [I(87,43)] = {18,0x397FB},
    [I(88,43)] = {19,0x7E7FB},
    [I(89,43)] = {18,0x39FFB},
    [I(90,43)] = {19,0x7EFFB},
    [I(91,43)] = {24,0xFFDFFB},
    [I(92,43)] = {30,0x3FFF87FB},
    [I(93,43)] = {24,0xFFE7FB},
    [I(94,43)] = {25,0x1FFE7FB},
    [I(95,43)] = {17,0x117FB},
    [I(96,43)] = {26,0x3FFEFFB},
    [I(97,43)] = {16,0x1FFB},
    [I(98,43)] = {17,0x11FFB},
    [I(99,43)] = {16,0x27FB},
    [I(100,43)] = {17,0x127FB},
    [I(101,43)] = {16,0x2FFB},
    [I(102,43)] = {17,0x12FFB},
    [I(103,43)] = {17,0x137FB},
    [I(104,43)] = {17,0x13FFB},
    [I(105,43)] = {16,0x37FB},
    [I(106,43)] = {18,0x3A7FB},
    [I(107,43)] = {18,0x3AFFB},
    [I(108,43)] = {17,0x147FB},
    [I(109,43)] = {17,0x14FFB},
    [I(110,43)] = {17,0x157FB},
    [I(111,43)] = {16,0x3FFB},
    [I(112,43)] = {17,0x15FFB},
    [I(113,43)] = {18,0x3B7FB},
    [I(114,43)] = {17,0x167FB},
    [I(115,43)] = {16,0x47FB},
    [I(116,43)] = {16,0x4FFB},
    [I(117,43)] = {17,0x16FFB},
    [I(118,43)] = {18,0x3BFFB},
    [I(119,43)] = {18,0x3C7FB},
    [I(120,43)] = {18,0x3CFFB},
    [I(121,43)] = {18,0x3D7FB},
    [I(122,43)] = {18,0x3DFFB},
    [I(123,43)] = {26,0x3FFF7FB},
    [I(124,43)] = {22,0x3FE7FB},
    [I(125,43)] = {25,0x1FFEFFB},
    [I(126,43)] = {24,0xFFEFFB},
    [I(127,43)] = {64,0},
    [I(128,43)] = {31,0x7FFF37FB},
    [I(129,43)] = {64,0},
    [I(130,43)] = {31,0x7FFF3FFB},
    [I(131,43)] = {31,0x7FFF47FB},
    [I(132,43)] = {64,0},
    [I(133,43)] = {64,0},
    [I(134,43)] = {64,0},
    [I(135,43)] = {64,0},
    [I(136,43)] = {64,0},
    [I(137,43)] = {64,0},
    [I(138,43)] = {64,0},
    [I(139,43)] = {64,0},
    [I(140,43)] = {64,0},
    [I(141,43)] = {64,0},
    [I(142,43)] = {64,0},
    [I(143,43)] = {64,0},
    [I(144,43)] = {64,0},
    [I(145,43)] = {64,0},
    [I(146,43)] = {64,0},
    [I(147,43)] = {64,0},
    [I(148,43)] = {64,0},
    [I(149,43)] = {64,0},
    [I(150,43)] = {64,0},
    [I(151,43)] = {64,0},
    [I(152,43)] = {64,0},
    [I(153,43)] = {X32,0xFFFEE7FB},
    [I(154,43)] = {64,0},
    [I(155,43)] = {64,0},
    [I(156,43)] = {64,0},
    [I(157,43)] = {64,0},
    [I(158,43)] = {64,0},
    [I(159,43)] = {64,0},
    [I(160,43)] = {64,0},
    [I(161,43)] = {X32,0xFFFEEFFB},
    [I(162,43)] = {31,0x7FFF4FFB},
    [I(163,43)] = {64,0},
    [I(164,43)] = {64,0},
    [I(165,43)] = {64,0},
    [I(166,43)] = {64,0},
    [I(167,43)] = {X32,0xFFFEF7FB},
    [I(168,43)] = {64,0},
    [I(169,43)] = {64,0},
    [I(170,43)] = {64,0},
    [I(171,43)] = {64,0},
    [I(172,43)] = {X32,0xFFFEFFFB},
    [I(173,43)] = {64,0},
    [I(174,43)] = {64,0},
    [I(175,43)] = {64,0},
    [I(176,43)] = {X32,0xFFFF07FB},
    [I(177,43)] = {X32,0xFFFF0FFB},
    [I(178,43)] = {64,0},
    [I(179,43)] = {X32,0xFFFF17FB},
    [I(180,43)] = {64,0},
    [I(181,43)] = {64,0},
    [I(182,43)] = {64,0},
    [I(183,43)] = {64,0},
    [I(184,43)] = {31,0x7FFF57FB},
    [I(185,43)] = {64,0},
    [I(186,43)] = {64,0},
    [I(187,43)] = {64,0},
    [I(188,43)] = {64,0},
    [I(189,43)] = {64,0},
    [I(190,43)] = {64,0},
    [I(191,43)] = {64,0},
    [I(192,43)] = {64,0},
    [I(193,43)] = {64,0},
    [I(194,43)] = {31,0x7FFF5FFB},
    [I(195,43)] = {30,0x3FFF8FFB},
    [I(196,43)] = {64,0},
    [I(197,43)] = {64,0},
    [I(198,43)] = {64,0},
    [I(199,43)] = {64,0},
    [I(200,43)] = {64,0},
    [I(201,43)] = {64,0},
    [I(202,43)] = {64,0},
    [I(203,43)] = {64,0},
    [I(204,43)] = {64,0},
    [I(205,43)] = {64,0},
    [I(206,43)] = {64,0},
    [I(207,43)] = {64,0},
    [I(208,43)] = {30,0x3FFF97FB},
    [I(209,43)] = {X32,0xFFFF1FFB},
    [I(210,43)] = {64,0},
    [I(211,43)] = {64,0},
    [I(212,43)] = {64,0},
    [I(213,43)] = {64,0},
    [I(214,43)] = {64,0},
    [I(215,43)] = {64,0},
    [I(216,43)] = {X32,0xFFFF27FB},
    [I(217,43)] = {X32,0xFFFF2FFB},
    [I(218,43)] = {64,0},
    [I(219,43)] = {64,0},
    [I(220,43)] = {64,0},
    [I(221,43)] = {64,0},
    [I(222,43)] = {64,0},
    [I(223,43)] = {64,0},
    [I(224,43)] = {31,0x7FFF67FB},
    [I(225,43)] = {64,0},
    [I(226,43)] = {31,0x7FFF6FFB},
    [I(227,43)] = {X32,0xFFFF37FB},
    [I(228,43)] = {64,0},
    [I(229,43)] = {X32,0xFFFF3FFB},
    [I(230,43)] = {X32,0xFFFF47FB},
    [I(231,43)] = {64,0},
    [I(232,43)] = {64,0},
    [I(233,43)] = {64,0},
    [I(234,43)] = {64,0},
    [I(235,43)] = {64,0},
    [I(236,43)] = {64,0},
    [I(237,43)] = {64,0},
    [I(238,43)] = {64,0},
    [I(239,43)] = {64,0},
    [I(240,43)] = {64,0},
    [I(241,43)] = {64,0},
    [I(242,43)] = {64,0},
    [I(243,43)] = {64,0},
    [I(244,43)] = {64,0},
    [I(245,43)] = {64,0},
    [I(246,43)] = {64,0},
    [I(247,43)] = {64,0},
    [I(248,43)] = {64,0},
    [I(249,43)] = {64,0},
    [I(250,43)] = {64,0},
    [I(251,43)] = {64,0},
    [I(252,43)] = {64,0},
    [I(253,43)] = {64,0},
    [I(254,43)] = {64,0},
    [I(255,43)] = {64,0},
    [I(0,44)] = {21,0x1FF8FA},
    [I(1,44)] = {31,0x7FFFD8FA},
    [I(2,44)] = {64,0},
    [I(3,44)] = {64,0},
    [I(4,44)] = {64,0},
    [I(5,44)] = {64,0},
    [I(6,44)] = {64,0},
    [I(7,44)] = {64,0},
    [I(8,44)] = {64,0},
    [I(9,44)] = {X32,0xFFFFEAFA},
    [I(10,44)] = {64,0},
    [I(11,44)] = {64,0},
    [I(12,44)] = {64,0},
    [I(13,44)] = {64,0},
    [I(14,44)] = {64,0},
    [I(15,44)] = {64,0},
    [I(16,44)] = {64,0},
    [I(17,44)] = {64,0},
    [I(18,44)] = {64,0},
    [I(19,44)] = {64,0},
    [I(20,44)] = {64,0},
    [I(21,44)] = {64,0},
    [I(22,44)] = {64,0},
    [I(23,44)] = {64,0},
    [I(24,44)] = {64,0},
    [I(25,44)] = {64,0},
    [I(26,44)] = {64,0},
    [I(27,44)] = {64,0},
    [I(28,44)] = {64,0},
    [I(29,44)] = {64,0},
    [I(30,44)] = {64,0},
    [I(31,44)] = {64,0},
    [I(32,44)] = {14,0x14FA},
    [I(33,44)] = {18,0x3F8FA},
    [I(34,44)] = {18,0x3F9FA},
    [I(35,44)] = {20,0xFFAFA},
    [I(36,44)] = {21,0x1FF9FA},
    [I(37,44)] = {14,0x15FA},
    [I(38,44)] = {16,0xF8FA},
    [I(39,44)] = {19,0x7FAFA},
    [I(40,44)] = {18,0x3FAFA},
    [I(41,44)] = {18,0x3FBFA},
    [I(42,44)] = {16,0xF9FA},
    [I(43,44)] = {19,0x7FBFA},
    [I(44,44)] = {16,0xFAFA},
    [I(45,44)] = {14,0x16FA},
    [I(46,44)] = {14,0x17FA},
    [I(47,44)] = {14,0x18FA},
    [I(48,44)] = {13,0xFA},
    [I(49,44)] = {13,0x1FA},
    [I(50,44)] = {13,0x2FA},
    [I(51,44)] = {14,0x19FA},
    [I(52,44)] = {14,0x1AFA},
    [I(53,44)] = {14,0x1BFA},
    [I(54,44)] = {14,0x1CFA},
    [I(55,44)] = {14,0x1DFA},
    [I(56,44)] = {14,0x1EFA},
    [I(57,44)] = {14,0x1FFA},
    [I(58,44)] = {15,0x5CFA},
    [I(59,44)] = {16,0xFBFA},
    [I(60,44)] = {23,0x7FFCFA},
    [I(61,44)] = {14,0x20FA},
    [I(62,44)] = {20,0xFFBFA},
    [I(63,44)] = {18,0x3FCFA},
    [I(64,44)] = {21,0x1FFAFA},
    [I(65,44)] = {14,0x21FA},
    [I(66,44)] = {15,0x5DFA},
    [I(67,44)] = {15,0x5EFA},
    [I(68,44)] = {15,0x5FFA},
    [I(69,44)] = {15,0x60FA},
    [I(70,44)] = {15,0x61FA},
    [I(71,44)] = {15,0x62FA},
    [I(72,44)] = {15,0x63FA},
    [I(73,44)] = {15,0x64FA},
    [I(74,44)] = {15,0x65FA},
    [I(75,44)] = {15,0x66FA},
    [I(76,44)] = {15,0x67FA},
    [I(77,44)] = {15,0x68FA},
    [I(78,44)] = {15,0x69FA},
    [I(79,44)] = {15,0x6AFA},
    [I(80,44)] = {15,0x6BFA},
    [I(81,44)] = {15,0x6CFA},
    [I(82,44)] = {15,0x6DFA},
    [I(83,44)] = {15,0x6EFA},
    [I(84,44)] = {15,0x6FFA},
    [I(85,44)] = {15,0x70FA},
    [I(86,44)] = {15,0x71FA},
    [I(87,44)] = {15,0x72FA},
    [I(88,44)] = {16,0xFCFA},
    [I(89,44)] = {15,0x73FA},
    [I(90,44)] = {16,0xFDFA},
    [I(91,44)] = {21,0x1FFBFA},
    [I(92,44)] = {27,0x7FFF0FA},
    [I(93,44)] = {21,0x1FFCFA},
    [I(94,44)] = {22,0x3FFCFA},
    [I(95,44)] = {14,0x22FA},
    [I(96,44)] = {23,0x7FFDFA},
    [I(97,44)] = {13,0x3FA},
    [I(98,44)] = {14,0x23FA},
    [I(99,44)] = {13,0x4FA},
    [I(100,44)] = {14,0x24FA},
    [I(101,44)] = {13,0x5FA},
    [I(102,44)] = {14,0x25FA},
    [I(103,44)] = {14,0x26FA},
    [I(104,44)] = {14,0x27FA},
    [I(105,44)] = {13,0x6FA},
    [I(106,44)] = {15,0x74FA},
    [I(107,44)] = {15,0x75FA},
    [I(108,44)] = {14,0x28FA},
    [I(109,44)] = {14,0x29FA},
    [I(110,44)] = {14,0x2AFA},
    [I(111,44)] = {13,0x7FA},
    [I(112,44)] = {14,0x2BFA},
    [I(113,44)] = {15,0x76FA},
    [I(114,44)] = {14,0x2CFA},
    [I(115,44)] = {13,0x8FA},
    [I(116,44)] = {13,0x9FA},
    [I(117,44)] = {14,0x2DFA},
    [I(118,44)] = {15,0x77FA},
    [I(119,44)] = {15,0x78FA},
    [I(120,44)] = {15,0x79FA},
    [I(121,44)] = {15,0x7AFA},
    [I(122,44)] = {15,0x7BFA},
    [I(123,44)] = {23,0x7FFEFA},
    [I(124,44)] = {19,0x7FCFA},
    [I(125,44)] = {22,0x3FFDFA},
    [I(126,44)] = {21,0x1FFDFA},
    [I(127,44)] = {64,0},
    [I(128,44)] = {28,0xFFFE6FA},
    [I(129,44)] = {30,0x3FFFD2FA},
    [I(130,44)] = {28,0xFFFE7FA},
    [I(131,44)] = {28,0xFFFE8FA},
    [I(132,44)] = {30,0x3FFFD3FA},
    [I(133,44)] = {30,0x3FFFD4FA},
    [I(134,44)] = {30,0x3FFFD5FA},
    [I(135,44)] = {31,0x7FFFD9FA},
    [I(136,44)] = {30,0x3FFFD6FA},
    [I(137,44)] = {31,0x7FFFDAFA},
    [I(138,44)] = {31,0x7FFFDBFA},
    [I(139,44)] = {31,0x7FFFDCFA},
    [I(140,44)] = {31,0x7FFFDDFA},
    [I(141,44)] = {31,0x7FFFDEFA},
    [I(142,44)] = {X32,0xFFFFEBFA},
    [I(143,44)] = {31,0x7FFFDFFA},
    [I(144,44)] = {X32,0xFFFFECFA},
    [I(145,44)] = {X32,0xFFFFEDFA},
    [I(146,44)] = {30,0x3FFFD7FA},
    [I(147,44)] = {31,0x7FFFE0FA},
    [I(148,44)] = {X32,0xFFFFEEFA},
    [I(149,44)] = {31,0x7FFFE1FA},
    [I(150,44)] = {31,0x7FFFE2FA},
    [I(151,44)] = {31,0x7FFFE3FA},
    [I(152,44)] = {31,0x7FFFE4FA},
    [I(153,44)] = {29,0x1FFFDCFA},
    [I(154,44)] = {30,0x3FFFD8FA},
    [I(155,44)] = {31,0x7FFFE5FA},
    [I(156,44)] = {30,0x3FFFD9FA},
    [I(157,44)] = {31,0x7FFFE6FA},
    [I(158,44)] = {31,0x7FFFE7FA},
    [I(159,44)] = {X32,0xFFFFEFFA},
    [I(160,44)] = {30,0x3FFFDAFA},
    [I(161,44)] = {29,0x1FFFDDFA},
    [I(162,44)] = {28,0xFFFE9FA},
    [I(163,44)] = {30,0x3FFFDBFA},
    [I(164,44)] = {30,0x3FFFDCFA},
    [I(165,44)] = {31,0x7FFFE8FA},
    [I(166,44)] = {31,0x7FFFE9FA},
    [I(167,44)] = {29,0x1FFFDEFA},
    [I(168,44)] = {31,0x7FFFEAFA},
    [I(169,44)] = {30,0x3FFFDDFA},
    [I(170,44)] = {30,0x3FFFDEFA},
    [I(171,44)] = {X32,0xFFFFF0FA},
    [I(172,44)] = {29,0x1FFFDFFA},
    [I(173,44)] = {30,0x3FFFDFFA},
    [I(174,44)] = {31,0x7FFFEBFA},
    [I(175,44)] = {31,0x7FFFECFA},
    [I(176,44)] = {29,0x1FFFE0FA},
    [I(177,44)] = {29,0x1FFFE1FA},
    [I(178,44)] = {30,0x3FFFE0FA},
    [I(179,44)] = {29,0x1FFFE2FA},
    [I(180,44)] = {31,0x7FFFEDFA},
    [I(181,44)] = {30,0x3FFFE1FA},
    [I(182,44)] = {31,0x7FFFEEFA},
    [I(183,44)] = {31,0x7FFFEFFA},
    [I(184,44)] = {28,0xFFFEAFA},
    [I(185,44)] = {30,0x3FFFE2FA},
    [I(186,44)] = {30,0x3FFFE3FA},
    [I(187,44)] = {30,0x3FFFE4FA},
    [I(188,44)] = {31,0x7FFFF0FA},
    [I(189,44)] = {30,0x3FFFE5FA},
    [I(190,44)] = {30,0x3FFFE6FA},
    [I(191,44)] = {31,0x7FFFF1FA},
    [I(192,44)] = {64,0},
    [I(193,44)] = {64,0},
    [I(194,44)] = {28,0xFFFEBFA},
    [I(195,44)] = {27,0x7FFF1FA},
    [I(196,44)] = {30,0x3FFFE7FA},
    [I(197,44)] = {31,0x7FFFF2FA},
    [I(198,44)] = {30,0x3FFFE8FA},
    [I(199,44)] = {64,0},
    [I(200,44)] = {64,0},
    [I(201,44)] = {64,0},
    [I(202,44)] = {64,0},
    [I(203,44)] = {64,0},
    [I(204,44)] = {64,0},
    [I(205,44)] = {64,0},
    [I(206,44)] = {X32,0xFFFFF1FA},
    [I(207,44)] = {64,0},
    [I(208,44)] = {27,0x7FFF2FA},
    [I(209,44)] = {29,0x1FFFE3FA},
    [I(210,44)] = {64,0},
    [I(211,44)] = {64,0},
    [I(212,44)] = {64,0},
    [I(213,44)] = {64,0},
    [I(214,44)] = {64,0},
    [I(215,44)] = {X32,0xFFFFF2FA},
    [I(216,44)] = {29,0x1FFFE4FA},
    [I(217,44)] = {29,0x1FFFE5FA},
    [I(218,44)] = {64,0},
    [I(219,44)] = {64,0},
    [I(220,44)] = {64,0},
    [I(221,44)] = {64,0},
    [I(222,44)] = {64,0},
    [I(223,44)] = {64,0},
    [I(224,44)] = {28,0xFFFECFA},
    [I(225,44)] = {X32,0xFFFFF3FA},
    [I(226,44)] = {28,0xFFFEDFA},
    [I(227,44)] = {29,0x1FFFE6FA},
    [I(228,44)] = {30,0x3FFFE9FA},
    [I(229,44)] = {29,0x1FFFE7FA},
    [I(230,44)] = {29,0x1FFFE8FA},
    [I(231,44)] = {31,0x7FFFF3FA},
    [I(232,44)] = {30,0x3FFFEAFA},
    [I(233,44)] = {30,0x3FFFEBFA},
    [I(234,44)] = {64,0},
    [I(235,44)] = {64,0},
    [I(236,44)] = {X32,0xFFFFF4FA},
    [I(237,44)] = {X32,0xFFFFF5FA},
    [I(238,44)] = {64,0},
    [I(239,44)] = {31,0x7FFFF4FA},
    [I(240,44)] = {64,0},
    [I(241,44)] = {64,0},
    [I(242,44)] = {64,0},
    [I(243,44)] = {64,0},
    [I(244,44)] = {64,0},
    [I(245,44)] = {64,0},
    [I(246,44)] = {64,0},
    [I(247,44)] = {64,0},
    [I(248,44)] = {64,0},
    [I(249,44)] = {64,0},
    [I(250,44)] = {64,0},
    [I(251,44)] = {64,0},
    [I(252,44)] = {64,0},
    [I(253,44)] = {64,0},
    [I(254,44)] = {64,0},
    [I(255,44)] = {64,0},
    [I(0,45)] = {19,0x7FE16},
    [I(1,45)] = {29,0x1FFFF616},
    [I(2,45)] = {64,0},
    [I(3,45)] = {64,0},
    [I(4,45)] = {64,0},
    [I(5,45)] = {64,0},
    [I(6,45)] = {64,0},
    [I(7,45)] = {64,0},
    [I(8,45)] = {64,0},
    [I(9,45)] = {30,0x3FFFFA96},
    [I(10,45)] = {64,0},
    [I(11,45)] = {64,0},
    [I(12,45)] = {64,0},
    [I(13,45)] = {64,0},
    [I(14,45)] = {64,0},
    [I(15,45)] = {64,0},
    [I(16,45)] = {64,0},
    [I(17,45)] = {64,0},
    [I(18,45)] = {64,0},
    [I(19,45)] = {64,0},
    [I(20,45)] = {64,0},
    [I(21,45)] = {64,0},
    [I(22,45)] = {64,0},
    [I(23,45)] = {64,0},
    [I(24,45)] = {64,0},
    [I(25,45)] = {64,0},
    [I(26,45)] = {64,0},
    [I(27,45)] = {64,0},
    [I(28,45)] = {64,0},
    [I(29,45)] = {64,0},
    [I(30,45)] = {64,0},
    [I(31,45)] = {64,0},
    [I(32,45)] = {12,0x516},
    [I(33,45)] = {16,0xFE16},
    [I(34,45)] = {16,0xFE56},
    [I(35,45)] = {18,0x3FE96},
    [I(36,45)] = {19,0x7FE56},
    [I(37,45)] = {12,0x556},
    [I(38,45)] = {14,0x3E16},
    [I(39,45)] = {17,0x1FE96},
    [I(40,45)] = {16,0xFE96},
    [I(41,45)] = {16,0xFED6},
    [I(42,45)] = {14,0x3E56},
    [I(43,45)] = {17,0x1FED6},
    [I(44,45)] = {14,0x3E96},
    [I(45,45)] = {12,0x596},
    [I(46,45)] = {12,0x5D6},
    [I(47,45)] = {12,0x616},
    [I(48,45)] = {11,0x16},
    [I(49,45)] = {11,0x56},
    [I(50,45)] = {11,0x96},
    [I(51,45)] = {12,0x656},
    [I(52,45)] = {12,0x696},
    [I(53,45)] = {12,0x6D6},
    [I(54,45)] = {12,0x716},
    [I(55,45)] = {12,0x756},
    [I(56,45)] = {12,0x796},
    [I(57,45)] = {12,0x7D6},
    [I(58,45)] = {13,0x1716},
    [I(59,45)] = {14,0x3ED6},
    [I(60,45)] = {21,0x1FFF16},
    [I(61,45)] = {12,0x816},
    [I(62,45)] = {18,0x3FED6},
    [I(63,45)] = {16,0xFF16},
    [I(64,45)] = {19,0x7FE96},
    [I(65,45)] = {12,0x856},
    [I(66,45)] = {13,0x1756},
    [I(67,45)] = {13,0x1796},
    [I(68,45)] = {13,0x17D6},
    [I(69,45)] = {13,0x1816},
    [I(70,45)] = {13,0x1856},
    [I(71,45)] = {13,0x1896},
    [I(72,45)] = {13,0x18D6},
    [I(73,45)] = {13,0x1916},
    [I(74,45)] = {13,0x1956},
    [I(75,45)] = {13,0x1996},
    [I(76,45)] = {13,0x19D6},
    [I(77,45)] = {13,0x1A16},
    [I(78,45)] = {13,0x1A56},
    [I(79,45)] = {13,0x1A96},
    [I(80,45)] = {13,0x1AD6},
    [I(81,45)] = {13,0x1B16},
    [I(82,45)] = {13,0x1B56},
    [I(83,45)] = {13,0x1B96},
    [I(84,45)] = {13,0x1BD6},
    [I(85,45)] = {13,0x1C16},
    [I(86,45)] = {13,0x1C56},
    [I(87,45)] = {13,0x1C96},
    [I(88,45)] = {14,0x3F16},
    [I(89,45)] = {13,0x1CD6},
    [I(90,45)] = {14,0x3F56},
    [I(91,45)] = {19,0x7FED6},
    [I(92,45)] = {25,0x1FFFC16},
    [I(93,45)] = {19,0x7FF16},
    [I(94,45)] = {20,0xFFF16},
    [I(95,45)] = {12,0x896},
    [I(96,45)] = {21,0x1FFF56},
    [I(97,45)] = {11,0xD6},
    [I(98,45)] = {12,0x8D6},
    [I(99,45)] = {11,0x116},
    [I(100,45)] = {12,0x916},
    [I(101,45)] = {11,0x156},
    [I(102,45)] = {12,0x956},
    [I(103,45)] = {12,0x996},
    [I(104,45)] = {12,0x9D6},
    [I(105,45)] = {11,0x196},
    [I(106,45)] = {13,0x1D16},
    [I(107,45)] = {13,0x1D56},
    [I(108,45)] = {12,0xA16},
    [I(109,45)] = {12,0xA56},
    [I(110,45)] = {12,0xA96},
    [I(111,45)] = {11,0x1D6},
    [I(112,45)] = {12,0xAD6},
    [I(113,45)] = {13,0x1D96},
    [I(114,45)] = {12,0xB16},
    [I(115,45)] = {11,0x216},
    [I(116,45)] = {11,0x256},
    [I(117,45)] = {12,0xB56},
    [I(118,45)] = {13,0x1DD6},
    [I(119,45)] = {13,0x1E16},
    [I(120,45)] = {13,0x1E56},
    [I(121,45)] = {13,0x1E96},
    [I(122,45)] = {13,0x1ED6},
    [I(123,45)] = {21,0x1FFF96},
    [I(124,45)] = {17,0x1FF16},
    [I(125,45)] = {20,0xFFF56},
    [I(126,45)] = {19,0x7FF56},
    [I(127,45)] = {64,0},
    [I(128,45)] = {26,0x3FFF996},
    [I(129,45)] = {28,0xFFFF496},
    [I(130,45)] = {26,0x3FFF9D6},
    [I(131,45)] = {26,0x3FFFA16},
    [I(132,45)] = {28,0xFFFF4D6},
    [I(133,45)] = {28,0xFFFF516},
    [I(134,45)] = {28,0xFFFF556},
    [I(135,45)] = {29,0x1FFFF656},
    [I(136,45)] = {28,0xFFFF596},
    [I(137,45)] = {29,0x1FFFF696},
    [I(138,45)] = {29,0x1FFFF6D6},
    [I(139,45)] = {29,0x1FFFF716},
    [I(140,45)] = {29,0x1FFFF756},
    [I(141,45)] = {29,0x1FFFF796},
    [I(142,45)] = {30,0x3FFFFAD6},
    [I(143,45)] = {29,0x1FFFF7D6},
    [I(144,45)] = {30,0x3FFFFB16},
    [I(145,45)] = {30,0x3FFFFB56},
    [I(146,45)] = {28,0xFFFF5D6},
    [I(147,45)] = {29,0x1FFFF816},
    [I(148,45)] = {30,0x3FFFFB96},
    [I(149,45)] = {29,0x1FFFF856},
    [I(150,45)] = {29,0x1FFFF896},
    [I(151,45)] = {29,0x1FFFF8D6},
    [I(152,45)] = {29,0x1FFFF916},
    [I(153,45)] = {27,0x7FFF716},
    [I(154,45)] = {28,0xFFFF616},
    [I(155,45)] = {29,0x1FFFF956},
    [I(156,45)] = {28,0xFFFF656},
    [I(157,45)] = {29,0x1FFFF996},
    [I(158,45)] = {29,0x1FFFF9D6},
    [I(159,45)] = {30,0x3FFFFBD6},
    [I(160,45)] = {28,0xFFFF696},
    [I(161,45)] = {27,0x7FFF756},
    [I(162,45)] = {26,0x3FFFA56},
    [I(163,45)] = {28,0xFFFF6D6},
    [I(164,45)] = {28,0xFFFF716},
    [I(165,45)] = {29,0x1FFFFA16},
    [I(166,45)] = {29,0x1FFFFA56},
    [I(167,45)] = {27,0x7FFF796},
    [I(168,45)] = {29,0x1FFFFA96},
    [I(169,45)] = {28,0xFFFF756},
    [I(170,45)] = {28,0xFFFF796},
    [I(171,45)] = {30,0x3FFFFC16},
    [I(172,45)] = {27,0x7FFF7D6},
    [I(173,45)] = {28,0xFFFF7D6},
    [I(174,45)] = {29,0x1FFFFAD6},
    [I(175,45)] = {29,0x1FFFFB16},
    [I(176,45)] = {27,0x7FFF816},
    [I(177,45)] = {27,0x7FFF856},
    [I(178,45)] = {28,0xFFFF816},
    [I(179,45)] = {27,0x7FFF896},
    [I(180,45)] = {29,0x1FFFFB56},
    [I(181,45)] = {28,0xFFFF856},
    [I(182,45)] = {29,0x1FFFFB96},
    [I(183,45)] = {29,0x1FFFFBD6},
    [I(184,45)] = {26,0x3FFFA96},
    [I(185,45)] = {28,0xFFFF896},
    [I(186,45)] = {28,0xFFFF8D6},
    [I(187,45)] = {28,0xFFFF916},
    [I(188,45)] = {29,0x1FFFFC16},
    [I(189,45)] = {28,0xFFFF956},
    [I(190,45)] = {28,0xFFFF996},
    [I(191,45)] = {29,0x1FFFFC56},
    [I(192,45)] = {X32,0xFFFFF816},
    [I(193,45)] = {X32,0xFFFFF856},
    [I(194,45)] = {26,0x3FFFAD6},
    [I(195,45)] = {25,0x1FFFC56},
    [I(196,45)] = {28,0xFFFF9D6},
    [I(197,45)] = {29,0x1FFFFC96},
    [I(198,45)] = {28,0xFFFFA16},
    [I(199,45)] = {31,0x7FFFFB16},
    [I(200,45)] = {X32,0xFFFFF896},
    [I(201,45)] = {X32,0xFFFFF8D6},
    [I(202,45)] = {X32,0xFFFFF916},
    [I(203,45)] = {64,0},
    [I(204,45)] = {64,0},
    [I(205,45)] = {X32,0xFFFFF956},
    [I(206,45)] = {30,0x3FFFFC56},
    [I(207,45)] = {31,0x7FFFFB56},
    [I(208,45)] = {25,0x1FFFC96},
    [I(209,45)] = {27,0x7FFF8D6},
    [I(210,45)] = {X32,0xFFFFF996},
    [I(211,45)] = {64,0},
    [I(212,45)] = {64,0},
    [I(213,45)] = {X32,0xFFFFF9D6},
    [I(214,45)] = {64,0},
    [I(215,45)] = {30,0x3FFFFC96},
    [I(216,45)] = {27,0x7FFF916},
    [I(217,45)] = {27,0x7FFF956},
    [I(218,45)] = {X32,0xFFFFFA16},
    [I(219,45)] = {X32,0xFFFFFA56},
    [I(220,45)] = {64,0},
    [I(221,45)] = {64,0},
    [I(222,45)] = {64,0},
    [I(223,45)] = {64,0},
    [I(224,45)] = {26,0x3FFFB16},
    [I(225,45)] = {30,0x3FFFFCD6},
    [I(226,45)] = {26,0x3FFFB56},
    [I(227,45)] = {27,0x7FFF996},
    [I(228,45)] = {28,0xFFFFA56},
    [I(229,45)] = {27,0x7FFF9D6},
    [I(230,45)] = {27,0x7FFFA16},
    [I(231,45)] = {29,0x1FFFFCD6},
    [I(232,45)] = {28,0xFFFFA96},
    [I(233,45)] = {28,0xFFFFAD6},
    [I(234,45)] = {31,0x7FFFFB96},
    [I(235,45)] = {31,0x7FFFFBD6},
    [I(236,45)] = {30,0x3FFFFD16},
    [I(237,45)] = {30,0x3FFFFD56},
    [I(238,45)] = {X32,0xFFFFFA96},
    [I(239,45)] = {29,0x1FFFFD16},
    [I(240,45)] = {X32,0xFFFFFAD6},
    [I(241,45)] = {64,0},
    [I(242,45)] = {X32,0xFFFFFB16},
    [I(243,45)] = {X32,0xFFFFFB56},
    [I(244,45)] = {64,0},
    [I(245,45)] = {64,0},
    [I(246,45)] = {64,0},
    [I(247,45)] = {64,0},
    [I(248,45)] = {64,0},
    [I(249,45)] = {64,0},
    [I(250,45)] = {64,0},
    [I(251,45)] = {64,0},
    [I(252,45)] = {64,0},
    [I(253,45)] = {64,0},
    [I(254,45)] = {64,0},
    [I(255,45)] = {X32,0xFFFFFB96},
    [I(0,46)] = {19,0x7FE17},
    [I(1,46)] = {29,0x1FFFF617},
    [I(2,46)] = {64,0},
    [I(3,46)] = {64,0},
    [I(4,46)] = {64,0},
    [I(5,46)] = {64,0},
    [I(6,46)] = {64,0},
    [I(7,46)] = {64,0},
    [I(8,46)] = {64,0},
    [I(9,46)] = {30,0x3FFFFA97},
    [I(10,46)] = {64,0},
    [I(11,46)] = {64,0},
    [I(12,46)] = {64,0},
    [I(13,46)] = {64,0},
    [I(14,46)] = {64,0},
    [I(15,46)] = {64,0},
    [I(16,46)] = {64,0},
    [I(17,46)] = {64,0},
    [I(18,46)] = {64,0},
    [I(19,46)] = {64,0},
    [I(20,46)] = {64,0},
    [I(21,46)] = {64,0},
    [I(22,46)] = {64,0},
    [I(23,46)] = {64,0},
    [I(24,46)] = {64,0},
    [I(25,46)] = {64,0},
    [I(26,46)] = {64,0},
    [I(27,46)] = {64,0},
    [I(28,46)] = {64,0},
    [I(29,46)] = {64,0},
    [I(30,46)] = {64,0},
    [I(31,46)] = {64,0},
    [I(32,46)] = {12,0x517},
    [I(33,46)] = {16,0xFE17},
    [I(34,46)] = {16,0xFE57},
    [I(35,46)] = {18,0x3FE97},
    [I(36,46)] = {19,0x7FE57},
    [I(37,46)] = {12,0x557},
    [I(38,46)] = {14,0x3E17},
    [I(39,46)] = {17,0x1FE97},
    [I(40,46)] = {16,0xFE97},
    [I(41,46)] = {16,0xFED7},
    [I(42,46)] = {14,0x3E57},
    [I(43,46)] = {17,0x1FED7},
    [I(44,46)] = {14,0x3E97},
    [I(45,46)] = {12,0x597},
    [I(46,46)] = {12,0x5D7},
    [I(47,46)] = {12,0x617},
    [I(48,46)] = {11,0x17},
    [I(49,46)] = {11,0x57},
    [I(50,46)] = {11,0x97},
    [I(51,46)] = {12,0x657},
    [I(52,46)] = {12,0x697},
    [I(53,46)] = {12,0x6D7},
    [I(54,46)] = {12,0x717},
    [I(55,46)] = {12,0x757},
    [I(56,46)] = {12,0x797},
    [I(57,46)] = {12,0x7D7},
    [I(58,46)] = {13,0x1717},
    [I(59,46)] = {14,0x3ED7},
    [I(60,46)] = {21,0x1FFF17},
    [I(61,46)] = {12,0x817},
    [I(62,46)] = {18,0x3FED7},
    [I(63,46)] = {16,0xFF17},
    [I(64,46)] = {19,0x7FE97},
    [I(65,46)] = {12,0x857},
    [I(66,46)] = {13,0x1757},
    [I(67,46)] = {13,0x1797},
    [I(68,46)] = {13,0x17D7},
    [I(69,46)] = {13,0x1817},
    [I(70,46)] = {13,0x1857},
    [I(71,46)] = {13,0x1897},
    [I(72,46)] = {13,0x18D7},
    [I(73,46)] = {13,0x1917},
    [I(74,46)] = {13,0x1957},
    [I(75,46)] = {13,0x1997},
    [I(76,46)] = {13,0x19D7},
    [I(77,46)] = {13,0x1A17},
    [I(78,46)] = {13,0x1A57},
    [I(79,46)] = {13,0x1A97},
    [I(80,46)] = {13,0x1AD7},
    [I(81,46)] = {13,0x1B17},
    [I(82,46)] = {13,0x1B57},
    [I(83,46)] = {13,0x1B97},
    [I(84,46)] = {13,0x1BD7},
    [I(85,46)] = {13,0x1C17},
    [I(86,46)] = {13,0x1C57},
    [I(87,46)] = {13,0x1C97},
    [I(88,46)] = {14,0x3F17},
    [I(89,46)] = {13,0x1CD7},
    [I(90,46)] = {14,0x3F57},
    [I(91,46)] = {19,0x7FED7},
    [I(92,46)] = {25,0x1FFFC17},
    [I(93,46)] = {19,0x7FF17},
    [I(94,46)] = {20,0xFFF17},
    [I(95,46)] = {12,0x897},
    [I(96,46)] = {21,0x1FFF57},
    [I(97,46)] = {11,0xD7},
    [I(98,46)] = {12,0x8D7},
    [I(99,46)] = {11,0x117},
    [I(100,46)] = {12,0x917},
    [I(101,46)] = {11,0x157},
    [I(102,46)] = {12,0x957},
    [I(103,46)] = {12,0x997},
    [I(104,46)] = {12,0x9D7},
    [I(105,46)] = {11,0x197},
    [I(106,46)] = {13,0x1D17},
    [I(107,46)] = {13,0x1D57},
    [I(108,46)] = {12,0xA17},
    [I(109,46)] = {12,0xA57},
    [I(110,46)] = {12,0xA97},
    [I(111,46)] = {11,0x1D7},
    [I(112,46)] = {12,0xAD7},
    [I(113,46)] = {13,0x1D97},
    [I(114,46)] = {12,0xB17},
    [I(115,46)] = {11,0x217},
    [I(116,46)] = {11,0x257},
    [I(117,46)] = {12,0xB57},
    [I(118,46)] = {13,0x1DD7},
    [I(119,46)] = {13,0x1E17},
    [I(120,46)] = {13,0x1E57},
    [I(121,46)] = {13,0x1E97},
    [I(122,46)] = {13,0x1ED7},
    [I(123,46)] = {21,0x1FFF97},
    [I(124,46)] = {17,0x1FF17},
    [I(125,46)] = {20,0xFFF57},
    [I(126,46)] = {19,0x7FF57},
    [I(127,46)] = {64,0},
    [I(128,46)] = {26,0x3FFF997},
    [I(129,46)] = {28,0xFFFF497},
    [I(130,46)] = {26,0x3FFF9D7},
    [I(131,46)] = {26,0x3FFFA17},
    [I(132,46)] = {28,0xFFFF4D7},
    [I(133,46)] = {28,0xFFFF517},
    [I(134,46)] = {28,0xFFFF557},
    [I(135,46)] = {29,0x1FFFF657},
    [I(136,46)] = {28,0xFFFF597},
    [I(137,46)] = {29,0x1FFFF697},
    [I(138,46)] = {29,0x1FFFF6D7},
    [I(139,46)] = {29,0x1FFFF717},
    [I(140,46)] = {29,0x1FFFF757},
    [I(141,46)] = {29,0x1FFFF797},
    [I(142,46)] = {30,0x3FFFFAD7},
    [I(143,46)] = {29,0x1FFFF7D7},
    [I(144,46)] = {30,0x3FFFFB17},
    [I(145,46)] = {30,0x3FFFFB57},
    [I(146,46)] = {28,0xFFFF5D7},
    [I(147,46)] = {29,0x1FFFF817},
    [I(148,46)] = {30,0x3FFFFB97},
    [I(149,46)] = {29,0x1FFFF857},
    [I(150,46)] = {29,0x1FFFF897},
    [I(151,46)] = {29,0x1FFFF8D7},
    [I(152,46)] = {29,0x1FFFF917},
    [I(153,46)] = {27,0x7FFF717},
    [I(154,46)] = {28,0xFFFF617},
    [I(155,46)] = {29,0x1FFFF957},
    [I(156,46)] = {28,0xFFFF657},
    [I(157,46)] = {29,0x1FFFF997},
    [I(158,46)] = {29,0x1FFFF9D7},
    [I(159,46)] = {30,0x3FFFFBD7},
    [I(160,46)] = {28,0xFFFF697},
    [I(161,46)] = {27,0x7FFF757},
    [I(162,46)] = {26,0x3FFFA57},
    [I(163,46)] = {28,0xFFFF6D7},
    [I(164,46)] = {28,0xFFFF717},
    [I(165,46)] = {29,0x1FFFFA17},
    [I(166,46)] = {29,0x1FFFFA57},
    [I(167,46)] = {27,0x7FFF797},
    [I(168,46)] = {29,0x1FFFFA97},
    [I(169,46)] = {28,0xFFFF757},
    [I(170,46)] = {28,0xFFFF797},
    [I(171,46)] = {30,0x3FFFFC17},
    [I(172,46)] = {27,0x7FFF7D7},
    [I(173,46)] = {28,0xFFFF7D7},
    [I(174,46)] = {29,0x1FFFFAD7},
    [I(175,46)] = {29,0x1FFFFB17},
    [I(176,46)] = {27,0x7FFF817},
    [I(177,46)] = {27,0x7FFF857},
    [I(178,46)] = {28,0xFFFF817},
    [I(179,46)] = {27,0x7FFF897},
    [I(180,46)] = {29,0x1FFFFB57},
    [I(181,46)] = {28,0xFFFF857},
    [I(182,46)] = {29,0x1FFFFB97},
    [I(183,46)] = {29,0x1FFFFBD7},
    [I(184,46)] = {26,0x3FFFA97},
    [I(185,46)] = {28,0xFFFF897},
    [I(186,46)] = {28,0xFFFF8D7},
    [I(187,46)] = {28,0xFFFF917},
    [I(188,46)] = {29,0x1FFFFC17},
    [I(189,46)] = {28,0xFFFF957},
    [I(190,46)] = {28,0xFFFF997},
    [I(191,46)] = {29,0x1FFFFC57},
    [I(192,46)] = {X32,0xFFFFF817},
    [I(193,46)] = {X32,0xFFFFF857},
    [I(194,46)] = {26,0x3FFFAD7},
    [I(195,46)] = {25,0x1FFFC57},
    [I(196,46)] = {28,0xFFFF9D7},
    [I(197,46)] = {29,0x1FFFFC97},
    [I(198,46)] = {28,0xFFFFA17},
    [I(199,46)] = {31,0x7FFFFB17},
    [I(200,46)] = {X32,0xFFFFF897},
    [I(201,46)] = {X32,0xFFFFF8D7},
    [I(202,46)] = {X32,0xFFFFF917},
    [I(203,46)] = {64,0},
    [I(204,46)] = {64,0},
    [I(205,46)] = {X32,0xFFFFF957},
    [I(206,46)] = {30,0x3FFFFC57},
    [I(207,46)] = {31,0x7FFFFB57},
    [I(208,46)] = {25,0x1FFFC97},
    [I(209,46)] = {27,0x7FFF8D7},
    [I(210,46)] = {X32,0xFFFFF997},
    [I(211,46)] = {64,0},
    [I(212,46)] = {64,0},
    [I(213,46)] = {X32,0xFFFFF9D7},
    [I(214,46)] = {64,0},
    [I(215,46)] = {30,0x3FFFFC97},
    [I(216,46)] = {27,0x7FFF917},
    [I(217,46)] = {27,0x7FFF957},
    [I(218,46)] = {X32,0xFFFFFA17},
    [I(219,46)] = {X32,0xFFFFFA57},
    [I(220,46)] = {64,0},
    [I(221,46)] = {64,0},
    [I(222,46)] = {64,0},
    [I(223,46)] = {64,0},
    [I(224,46)] = {26,0x3FFFB17},
    [I(225,46)] = {30,0x3FFFFCD7},
    [I(226,46)] = {26,0x3FFFB57},
    [I(227,46)] = {27,0x7FFF997},
    [I(228,46)] = {28,0xFFFFA57},
    [I(229,46)] = {27,0x7FFF9D7},
    [I(230,46)] = {27,0x7FFFA17},
    [I(231,46)] = {29,0x1FFFFCD7},
    [I(232,46)] = {28,0xFFFFA97},
    [I(233,46)] = {28,0xFFFFAD7},
    [I(234,46)] = {31,0x7FFFFB97},
    [I(235,46)] = {31,0x7FFFFBD7},
    [I(236,46)] = {30,0x3FFFFD17},
    [I(237,46)] = {30,0x3FFFFD57},
    [I(238,46)] = {X32,0xFFFFFA97},
    [I(239,46)] = {29,0x1FFFFD17},
    [I(240,46)] = {X32,0xFFFFFAD7},
    [I(241,46)] = {64,0},
    [I(242,46)] = {X32,0xFFFFFB17},
    [I(243,46)] = {X32,0xFFFFFB57},
    [I(244,46)] = {64,0},
    [I(245,46)] = {64,0},
    [I(246,46)] = {64,0},
    [I(247,46)] = {64,0},
    [I(248,46)] = {64,0},
    [I(249,46)] = {64,0},
    [I(250,46)] = {64,0},
    [I(251,46)] = {64,0},
    [I(252,46)] = {64,0},
    [I(253,46)] = {64,0},
    [I(254,46)] = {64,0},
    [I(255,46)] = {X32,0xFFFFFB97},
    [I(0,47)] = {19,0x7FE18},
    [I(1,47)] = {29,0x1FFFF618},
    [I(2,47)] = {64,0},
    [I(3,47)] = {64,0},
    [I(4,47)] = {64,0},
    [I(5,47)] = {64,0},
    [I(6,47)] = {64,0},
    [I(7,47)] = {64,0},
    [I(8,47)] = {64,0},
    [I(9,47)] = {30,0x3FFFFA98},
    [I(10,47)] = {64,0},
    [I(11,47)] = {64,0},
    [I(12,47)] = {64,0},
    [I(13,47)] = {64,0},
    [I(14,47)] = {64,0},
    [I(15,47)] = {64,0},
    [I(16,47)] = {64,0},
    [I(17,47)] = {64,0},
    [I(18,47)] = {64,0},
    [I(19,47)] = {64,0},
    [I(20,47)] = {64,0},
    [I(21,47)] = {64,0},
    [I(22,47)] = {64,0},
    [I(23,47)] = {64,0},
    [I(24,47)] = {64,0},
    [I(25,47)] = {64,0},
    [I(26,47)] = {64,0},
    [I(27,47)] = {64,0},
    [I(28,47)] = {64,0},
    [I(29,47)] = {64,0},
    [I(30,47)] = {64,0},
    [I(31,47)] = {64,0},
    [I(32,47)] = {12,0x518},
    [I(33,47)] = {16,0xFE18},
    [I(34,47)] = {16,0xFE58},
    [I(35,47)] = {18,0x3FE98},
    [I(36,47)] = {19,0x7FE58},
    [I(37,47)] = {12,0x558},
    [I(38,47)] = {14,0x3E18},
    [I(39,47)] = {17,0x1FE98},
    [I(40,47)] = {16,0xFE98},
    [I(41,47)] = {16,0xFED8},
    [I(42,47)] = {14,0x3E58},
    [I(43,47)] = {17,0x1FED8},
    [I(44,47)] = {14,0x3E98},
    [I(45,47)] = {12,0x598},
    [I(46,47)] = {12,0x5D8},
    [I(47,47)] = {12,0x618},
    [I(48,47)] = {11,0x18},
    [I(49,47)] = {11,0x58},
    [I(50,47)] = {11,0x98},
    [I(51,47)] = {12,0x658},
    [I(52,47)] = {12,0x698},
    [I(53,47)] = {12,0x6D8},
    [I(54,47)] = {12,0x718},
    [I(55,47)] = {12,0x758},
    [I(56,47)] = {12,0x798},
    [I(57,47)] = {12,0x7D8},
    [I(58,47)] = {13,0x1718},
    [I(59,47)] = {14,0x3ED8},
    [I(60,47)] = {21,0x1FFF18},
    [I(61,47)] = {12,0x818},
    [I(62,47)] = {18,0x3FED8},
    [I(63,47)] = {16,0xFF18},
    [I(64,47)] = {19,0x7FE98},
    [I(65,47)] = {12,0x858},
    [I(66,47)] = {13,0x1758},
    [I(67,47)] = {13,0x1798},
    [I(68,47)] = {13,0x17D8},
    [I(69,47)] = {13,0x1818},
    [I(70,47)] = {13,0x1858},
    [I(71,47)] = {13,0x1898},
    [I(72,47)] = {13,0x18D8},
    [I(73,47)] = {13,0x1918},
    [I(74,47)] = {13,0x1958},
    [I(75,47)] = {13,0x1998},
    [I(76,47)] = {13,0x19D8},
    [I(77,47)] = {13,0x1A18},
    [I(78,47)] = {13,0x1A58},
    [I(79,47)] = {13,0x1A98},
    [I(80,47)] = {13,0x1AD8},
    [I(81,47)] = {13,0x1B18},
    [I(82,47)] = {13,0x1B58},
    [I(83,47)] = {13,0x1B98},
    [I(84,47)] = {13,0x1BD8},
    [I(85,47)] = {13,0x1C18},
    [I(86,47)] = {13,0x1C58},
    [I(87,47)] = {13,0x1C98},
    [I(88,47)] = {14,0x3F18},
    [I(89,47)] = {13,0x1CD8},
    [I(90,47)] = {14,0x3F58},
    [I(91,47)] = {19,0x7FED8},
    [I(92,47)] = {25,0x1FFFC18},
    [I(93,47)] = {19,0x7FF18},
    [I(94,47)] = {20,0xFFF18},
    [I(95,47)] = {12,0x898},
    [I(96,47)] = {21,0x1FFF58},
    [I(97,47)] = {11,0xD8},
    [I(98,47)] = {12,0x8D8},
    [I(99,47)] = {11,0x118},
    [I(100,47)] = {12,0x918},
    [I(101,47)] = {11,0x158},
    [I(102,47)] = {12,0x958},
    [I(103,47)] = {12,0x998},
    [I(104,47)] = {12,0x9D8},
    [I(105,47)] = {11,0x198},
    [I(106,47)] = {13,0x1D18},
    [I(107,47)] = {13,0x1D58},
    [I(108,47)] = {12,0xA18},
    [I(109,47)] = {12,0xA58},
    [I(110,47)] = {12,0xA98},
    [I(111,47)] = {11,0x1D8},
    [I(112,47)] = {12,0xAD8},
    [I(113,47)] = {13,0x1D98},
    [I(114,47)] = {12,0xB18},
    [I(115,47)] = {11,0x218},
    [I(116,47)] = {11,0x258},
    [I(117,47)] = {12,0xB58},
    [I(118,47)] = {13,0x1DD8},
    [I(119,47)] = {13,0x1E18},
    [I(120,47)] = {13,0x1E58},
    [I(121,47)] = {13,0x1E98},
    [I(122,47)] = {13,0x1ED8},
    [I(123,47)] = {21,0x1FFF98},
    [I(124,47)] = {17,0x1FF18},
    [I(125,47)] = {20,0xFFF58},
    [I(126,47)] = {19,0x7FF58},
    [I(127,47)] = {64,0},
    [I(128,47)] = {26,0x3FFF998},
    [I(129,47)] = {28,0xFFFF498},
    [I(130,47)] = {26,0x3FFF9D8},
    [I(131,47)] = {26,0x3FFFA18},
    [I(132,47)] = {28,0xFFFF4D8},
    [I(133,47)] = {28,0xFFFF518},
    [I(134,47)] = {28,0xFFFF558},
    [I(135,47)] = {29,0x1FFFF658},
    [I(136,47)] = {28,0xFFFF598},
    [I(137,47)] = {29,0x1FFFF698},
    [I(138,47)] = {29,0x1FFFF6D8},
    [I(139,47)] = {29,0x1FFFF718},
    [I(140,47)] = {29,0x1FFFF758},
    [I(141,47)] = {29,0x1FFFF798},
    [I(142,47)] = {30,0x3FFFFAD8},
    [I(143,47)] = {29,0x1FFFF7D8},
    [I(144,47)] = {30,0x3FFFFB18},
    [I(145,47)] = {30,0x3FFFFB58},
    [I(146,47)] = {28,0xFFFF5D8},
    [I(147,47)] = {29,0x1FFFF818},
    [I(148,47)] = {30,0x3FFFFB98},
    [I(149,47)] = {29,0x1FFFF858},
    [I(150,47)] = {29,0x1FFFF898},
    [I(151,47)] = {29,0x1FFFF8D8},
    [I(152,47)] = {29,0x1FFFF918},
    [I(153,47)] = {27,0x7FFF718},
    [I(154,47)] = {28,0xFFFF618},
    [I(155,47)] = {29,0x1FFFF958},
    [I(156,47)] = {28,0xFFFF658},
    [I(157,47)] = {29,0x1FFFF998},
    [I(158,47)] = {29,0x1FFFF9D8},
    [I(159,47)] = {30,0x3FFFFBD8},
    [I(160,47)] = {28,0xFFFF698},
    [I(161,47)] = {27,0x7FFF758},
    [I(162,47)] = {26,0x3FFFA58},
    [I(163,47)] = {28,0xFFFF6D8},
    [I(164,47)] = {28,0xFFFF718},
    [I(165,47)] = {29,0x1FFFFA18},
    [I(166,47)] = {29,0x1FFFFA58},
    [I(167,47)] = {27,0x7FFF798},
    [I(168,47)] = {29,0x1FFFFA98},
    [I(169,47)] = {28,0xFFFF758},
    [I(170,47)] = {28,0xFFFF798},
    [I(171,47)] = {30,0x3FFFFC18},
    [I(172,47)] = {27,0x7FFF7D8},
    [I(173,47)] = {28,0xFFFF7D8},
    [I(174,47)] = {29,0x1FFFFAD8},
    [I(175,47)] = {29,0x1FFFFB18},
    [I(176,47)] = {27,0x7FFF818},
    [I(177,47)] = {27,0x7FFF858},
    [I(178,47)] = {28,0xFFFF818},
    [I(179,47)] = {27,0x7FFF898},
    [I(180,47)] = {29,0x1FFFFB58},
    [I(181,47)] = {28,0xFFFF858},
    [I(182,47)] = {29,0x1FFFFB98},
    [I(183,47)] = {29,0x1FFFFBD8},
    [I(184,47)] = {26,0x3FFFA98},
    [I(185,47)] = {28,0xFFFF898},
    [I(186,47)] = {28,0xFFFF8D8},
    [I(187,47)] = {28,0xFFFF918},
    [I(188,47)] = {29,0x1FFFFC18},
    [I(189,47)] = {28,0xFFFF958},
    [I(190,47)] = {28,0xFFFF998},
    [I(191,47)] = {29,0x1FFFFC58},
    [I(192,47)] = {X32,0xFFFFF818},
    [I(193,47)] = {X32,0xFFFFF858},
    [I(194,47)] = {26,0x3FFFAD8},
    [I(195,47)] = {25,0x1FFFC58},
    [I(196,47)] = {28,0xFFFF9D8},
    [I(197,47)] = {29,0x1FFFFC98},
    [I(198,47)] = {28,0xFFFFA18},
    [I(199,47)] = {31,0x7FFFFB18},
    [I(200,47)] = {X32,0xFFFFF898},
    [I(201,47)] = {X32,0xFFFFF8D8},
    [I(202,47)] = {X32,0xFFFFF918},
    [I(203,47)] = {64,0},
    [I(204,47)] = {64,0},
    [I(205,47)] = {X32,0xFFFFF958},
    [I(206,47)] = {30,0x3FFFFC58},
    [I(207,47)] = {31,0x7FFFFB58},
    [I(208,47)] = {25,0x1FFFC98},
    [I(209,47)] = {27,0x7FFF8D8},
    [I(210,47)] = {X32,0xFFFFF998},
    [I(211,47)] = {64,0},
    [I(212,47)] = {64,0},
    [I(213,47)] = {X32,0xFFFFF9D8},
    [I(214,47)] = {64,0},
    [I(215,47)] = {30,0x3FFFFC98},
    [I(216,47)] = {27,0x7FFF918},
    [I(217,47)] = {27,0x7FFF958},
    [I(218,47)] = {X32,0xFFFFFA18},
    [I(219,47)] = {X32,0xFFFFFA58},
    [I(220,47)] = {64,0},
    [I(221,47)] = {64,0},
    [I(222,47)] = {64,0},
    [I(223,47)] = {64,0},
    [I(224,47)] = {26,0x3FFFB18},
    [I(225,47)] = {30,0x3FFFFCD8},
    [I(226,47)] = {26,0x3FFFB58},
    [I(227,47)] = {27,0x7FFF998},
    [I(228,47)] = {28,0xFFFFA58},
    [I(229,47)] = {27,0x7FFF9D8},
    [I(230,47)] = {27,0x7FFFA18},
    [I(231,47)] = {29,0x1FFFFCD8},
    [I(232,47)] = {28,0xFFFFA98},
    [I(233,47)] = {28,0xFFFFAD8},
    [I(234,47)] = {31,0x7FFFFB98},
    [I(235,47)] = {31,0x7FFFFBD8},
    [I(236,47)] = {30,0x3FFFFD18},
    [I(237,47)] = {30,0x3FFFFD58},
    [I(238,47)] = {X32,0xFFFFFA98},
    [I(239,47)] = {29,0x1FFFFD18},
    [I(240,47)] = {X32,0xFFFFFAD8},
    [I(241,47)] = {64,0},
    [I(242,47)] = {X32,0xFFFFFB18},
    [I(243,47)] = {X32,0xFFFFFB58},
    [I(244,47)] = {64,0},
    [I(245,47)] = {64,0},
    [I(246,47)] = {64,0},
    [I(247,47)] = {64,0},
    [I(248,47)] = {64,0},
    [I(249,47)] = {64,0},
    [I(250,47)] = {64,0},
    [I(251,47)] = {64,0},
    [I(252,47)] = {64,0},
    [I(253,47)] = {64,0},
    [I(254,47)] = {64,0},
    [I(255,47)] = {X32,0xFFFFFB98},
    [I(0,48)] = {18,0x3FF00},
    [I(1,48)] = {28,0xFFFFB00},
    [I(2,48)] = {64,0},
    [I(3,48)] = {64,0},
    [I(4,48)] = {64,0},
    [I(5,48)] = {64,0},
    [I(6,48)] = {64,0},
    [I(7,48)] = {64,0},
    [I(8,48)] = {64,0},
    [I(9,48)] = {29,0x1FFFFD40},
    [I(10,48)] = {64,0},
    [I(11,48)] = {64,0},
    [I(12,48)] = {64,0},
    [I(13,48)] = {64,0},
    [I(14,48)] = {64,0},
    [I(15,48)] = {64,0},
    [I(16,48)] = {64,0},
    [I(17,48)] = {64,0},
    [I(18,48)] = {64,0},
    [I(19,48)] = {64,0},
    [I(20,48)] = {64,0},
    [I(21,48)] = {64,0},
    [I(22,48)] = {64,0},
    [I(23,48)] = {64,0},
    [I(24,48)] = {64,0},
    [I(25,48)] = {64,0},
    [I(26,48)] = {64,0},
    [I(27,48)] = {64,0},
    [I(28,48)] = {64,0},
    [I(29,48)] = {64,0},
    [I(30,48)] = {64,0},
    [I(31,48)] = {64,0},
    [I(32,48)] = {11,0x280},
    [I(33,48)] = {15,0x7F00},
    [I(34,48)] = {15,0x7F20},
    [I(35,48)] = {17,0x1FF40},
    [I(36,48)] = {18,0x3FF20},
    [I(37,48)] = {11,0x2A0},
    [I(38,48)] = {13,0x1F00},
    [I(39,48)] = {16,0xFF40},
    [I(40,48)] = {15,0x7F40},
    [I(41,48)] = {15,0x7F60},
    [I(42,48)] = {13,0x1F20},
    [I(43,48)] = {16,0xFF60},
    [I(44,48)] = {13,0x1F40},
    [I(45,48)] = {11,0x2C0},
    [I(46,48)] = {11,0x2E0},
    [I(47,48)] = {11,0x300},
    [I(48,48)] = {10,0x0},
    [I(49,48)] = {10,0x20},
    [I(50,48)] = {10,0x40},
    [I(51,48)] = {11,0x320},
    [I(52,48)] = {11,0x340},
    [I(53,48)] = {11,0x360},
    [I(54,48)] = {11,0x380},
    [I(55,48)] = {11,0x3A0},
    [I(56,48)] = {11,0x3C0},
    [I(57,48)] = {11,0x3E0},
    [I(58,48)] = {12,0xB80},
    [I(59,48)] = {13,0x1F60},
    [I(60,48)] = {20,0xFFF80},
    [I(61,48)] = {11,0x400},
    [I(62,48)] = {17,0x1FF60},
    [I(63,48)] = {15,0x7F80},
    [I(64,48)] = {18,0x3FF40},
    [I(65,48)] = {11,0x420},
    [I(66,48)] = {12,0xBA0},
    [I(67,48)] = {12,0xBC0},
    [I(68,48)] = {12,0xBE0},
    [I(69,48)] = {12,0xC00},
    [I(70,48)] = {12,0xC20},
    [I(71,48)] = {12,0xC40},
    [I(72,48)] = {12,0xC60},
    [I(73,48)] = {12,0xC80},
    [I(74,48)] = {12,0xCA0},
    [I(75,48)] = {12,0xCC0},
    [I(76,48)] = {12,0xCE0},
    [I(77,48)] = {12,0xD00},
    [I(78,48)] = {12,0xD20},
    [I(79,48)] = {12,0xD40},
    [I(80,48)] = {12,0xD60},
    [I(81,48)] = {12,0xD80},
    [I(82,48)] = {12,0xDA0},
    [I(83,48)] = {12,0xDC0},
    [I(84,48)] = {12,0xDE0},
    [I(85,48)] = {12,0xE00},
    [I(86,48)] = {12,0xE20},
    [I(87,48)] = {12,0xE40},
    [I(88,48)] = {13,0x1F80},
    [I(89,48)] = {12,0xE60},
    [I(90,48)] = {13,0x1FA0},
    [I(91,48)] = {18,0x3FF60},
    [I(92,48)] = {24,0xFFFE00},
    [I(93,48)] = {18,0x3FF80},
    [I(94,48)] = {19,0x7FF80},
    [I(95,48)] = {11,0x440},
    [I(96,48)] = {20,0xFFFA0},
    [I(97,48)] = {10,0x60},
    [I(98,48)] = {11,0x460},
    [I(99,48)] = {10,0x80},
    [I(100,48)] = {11,0x480},
    [I(101,48)] = {10,0xA0},
    [I(102,48)] = {11,0x4A0},
    [I(103,48)] = {11,0x4C0},
    [I(104,48)] = {11,0x4E0},
    [I(105,48)] = {10,0xC0},
    [I(106,48)] = {12,0xE80},
    [I(107,48)] = {12,0xEA0},
    [I(108,48)] = {11,0x500},
    [I(109,48)] = {11,0x520},
    [I(110,48)] = {11,0x540},
    [I(111,48)] = {10,0xE0},
    [I(112,48)] = {11,0x560},
    [I(113,48)] = {12,0xEC0},
    [I(114,48)] = {11,0x580},
    [I(115,48)] = {10,0x100},
    [I(116,48)] = {10,0x120},
    [I(117,48)] = {11,0x5A0},
    [I(118,48)] = {12,0xEE0},
    [I(119,48)] = {12,0xF00},
    [I(120,48)] = {12,0xF20},
    [I(121,48)] = {12,0xF40},
    [I(122,48)] = {12,0xF60},
    [I(123,48)] = {20,0xFFFC0},
    [I(124,48)] = {16,0xFF80},
    [I(125,48)] = {19,0x7FFA0},
    [I(126,48)] = {18,0x3FFA0},
    [I(127,48)] = {64,0},
    [I(128,48)] = {25,0x1FFFCC0},
    [I(129,48)] = {27,0x7FFFA40},
    [I(130,48)] = {25,0x1FFFCE0},
    [I(131,48)] = {25,0x1FFFD00},
    [I(132,48)] = {27,0x7FFFA60},
    [I(133,48)] = {27,0x7FFFA80},
    [I(134,48)] = {27,0x7FFFAA0},
    [I(135,48)] = {28,0xFFFFB20},
    [I(136,48)] = {27,0x7FFFAC0},
    [I(137,48)] = {28,0xFFFFB40},
    [I(138,48)] = {28,0xFFFFB60},
    [I(139,48)] = {28,0xFFFFB80},
    [I(140,48)] = {28,0xFFFFBA0},
    [I(141,48)] = {28,0xFFFFBC0},
    [I(142,48)] = {29,0x1FFFFD60},
    [I(143,48)] = {28,0xFFFFBE0},
    [I(144,48)] = {29,0x1FFFFD80},
    [I(145,48)] = {29,0x1FFFFDA0},
    [I(146,48)] = {27,0x7FFFAE0},
    [I(147,48)] = {28,0xFFFFC00},
    [I(148,48)] = {29,0x1FFFFDC0},
    [I(149,48)] = {28,0xFFFFC20},
    [I(150,48)] = {28,0xFFFFC40},
    [I(151,48)] = {28,0xFFFFC60},
    [I(152,48)] = {28,0xFFFFC80},
    [I(153,48)] = {26,0x3FFFB80},
    [I(154,48)] = {27,0x7FFFB00},
    [I(155,48)] = {28,0xFFFFCA0},
    [I(156,48)] = {27,0x7FFFB20},
    [I(157,48)] = {28,0xFFFFCC0},
    [I(158,48)] = {28,0xFFFFCE0},
    [I(159,48)] = {29,0x1FFFFDE0},
    [I(160,48)] = {27,0x7FFFB40},
    [I(161,48)] = {26,0x3FFFBA0},
    [I(162,48)] = {25,0x1FFFD20},
    [I(163,48)] = {27,0x7FFFB60},
    [I(164,48)] = {27,0x7FFFB80},
    [I(165,48)] = {28,0xFFFFD00},
    [I(166,48)] = {28,0xFFFFD20},
    [I(167,48)] = {26,0x3FFFBC0},
    [I(168,48)] = {28,0xFFFFD40},
    [I(169,48)] = {27,0x7FFFBA0},
    [I(170,48)] = {27,0x7FFFBC0},
    [I(171,48)] = {29,0x1FFFFE00},
    [I(172,48)] = {26,0x3FFFBE0},
    [I(173,48)] = {27,0x7FFFBE0},
    [I(174,48)] = {28,0xFFFFD60},
    [I(175,48)] = {28,0xFFFFD80},
    [I(176,48)] = {26,0x3FFFC00},
    [I(177,48)] = {26,0x3FFFC20},
    [I(178,48)] = {27,0x7FFFC00},
    [I(179,48)] = {26,0x3FFFC40},
    [I(180,48)] = {28,0xFFFFDA0},
    [I(181,48)] = {27,0x7FFFC20},
    [I(182,48)] = {28,0xFFFFDC0},
    [I(183,48)] = {28,0xFFFFDE0},
    [I(184,48)] = {25,0x1FFFD40},
    [I(185,48)] = {27,0x7FFFC40},
    [I(186,48)] = {27,0x7FFFC60},
    [I(187,48)] = {27,0x7FFFC80},
    [I(188,48)] = {28,0xFFFFE00},
    [I(189,48)] = {27,0x7FFFCA0},
    [I(190,48)] = {27,0x7FFFCC0},
    [I(191,48)] = {28,0xFFFFE20},
    [I(192,48)] = {31,0x7FFFFC00},
    [I(193,48)] = {31,0x7FFFFC20},
    [I(194,48)] = {25,0x1FFFD60},
    [I(195,48)] = {24,0xFFFE20},
    [I(196,48)] = {27,0x7FFFCE0},
    [I(197,48)] = {28,0xFFFFE40},
    [I(198,48)] = {27,0x7FFFD00},
    [I(199,48)] = {30,0x3FFFFD80},
    [I(200,48)] = {31,0x7FFFFC40},
    [I(201,48)] = {31,0x7FFFFC60},
    [I(202,48)] = {31,0x7FFFFC80},
    [I(203,48)] = {X32,0xFFFFFBC0},
    [I(204,48)] = {X32,0xFFFFFBE0},
    [I(205,48)] = {31,0x7FFFFCA0},
    [I(206,48)] = {29,0x1FFFFE20},
    [I(207,48)] = {30,0x3FFFFDA0},
    [I(208,48)] = {24,0xFFFE40},
    [I(209,48)] = {26,0x3FFFC60},
    [I(210,48)] = {31,0x7FFFFCC0},
    [I(211,48)] = {X32,0xFFFFFC00},
    [I(212,48)] = {X32,0xFFFFFC20},
    [I(213,48)] = {31,0x7FFFFCE0},
    [I(214,48)] = {X32,0xFFFFFC40},
    [I(215,48)] = {29,0x1FFFFE40},
    [I(216,48)] = {26,0x3FFFC80},
    [I(217,48)] = {26,0x3FFFCA0},
    [I(218,48)] = {31,0x7FFFFD00},
    [I(219,48)] = {31,0x7FFFFD20},
    [I(220,48)] = {64,0},
    [I(221,48)] = {X32,0xFFFFFC60},
    [I(222,48)] = {X32,0xFFFFFC80},
    [I(223,48)] = {X32,0xFFFFFCA0},
    [I(224,48)] = {25,0x1FFFD80},
    [I(225,48)] = {29,0x1FFFFE60},
    [I(226,48)] = {25,0x1FFFDA0},
    [I(227,48)] = {26,0x3FFFCC0},
    [I(228,48)] = {27,0x7FFFD20},
    [I(229,48)] = {26,0x3FFFCE0},
    [I(230,48)] = {26,0x3FFFD00},
    [I(231,48)] = {28,0xFFFFE60},
    [I(232,48)] = {27,0x7FFFD40},
    [I(233,48)] = {27,0x7FFFD60},
    [I(234,48)] = {30,0x3FFFFDC0},
    [I(235,48)] = {30,0x3FFFFDE0},
    [I(236,48)] = {29,0x1FFFFE80},
    [I(237,48)] = {29,0x1FFFFEA0},
    [I(238,48)] = {31,0x7FFFFD40},
    [I(239,48)] = {28,0xFFFFE80},
    [I(240,48)] = {31,0x7FFFFD60},
    [I(241,48)] = {X32,0xFFFFFCC0},
    [I(242,48)] = {31,0x7FFFFD80},
    [I(243,48)] = {31,0x7FFFFDA0},
    [I(244,48)] = {X32,0xFFFFFCE0},
    [I(245,48)] = {X32,0xFFFFFD00},
    [I(246,48)] = {X32,0xFFFFFD20},
    [I(247,48)] = {X32,0xFFFFFD40},
    [I(248,48)] = {X32,0xFFFFFD60},
    [I(249,48)] = {64,0},
    [I(250,48)] = {X32,0xFFFFFD80},
    [I(251,48)] = {X32,0xFFFFFDA0},
    [I(252,48)] = {X32,0xFFFFFDC0},
    [I(253,48)] = {X32,0xFFFFFDE0},
    [I(254,48)] = {X32,0xFFFFFE00},
    [I(255,48)] = {31,0x7FFFFDC0},
    [I(0,49)] = {18,0x3FF01},
    [I(1,49)] = {28,0xFFFFB01},
    [I(2,49)] = {64,0},
    [I(3,49)] = {64,0},
    [I(4,49)] = {64,0},
    [I(5,49)] = {64,0},
    [I(6,49)] = {64,0},
    [I(7,49)] = {64,0},
    [I(8,49)] = {64,0},
    [I(9,49)] = {29,0x1FFFFD41},
    [I(10,49)] = {64,0},
    [I(11,49)] = {64,0},
    [I(12,49)] = {64,0},
    [I(13,49)] = {64,0},
    [I(14,49)] = {64,0},
    [I(15,49)] = {64,0},
    [I(16,49)] = {64,0},
    [I(17,49)] = {64,0},
    [I(18,49)] = {64,0},
    [I(19,49)] = {64,0},
    [I(20,49)] = {64,0},
    [I(21,49)] = {64,0},
    [I(22,49)] = {64,0},
    [I(23,49)] = {64,0},
    [I(24,49)] = {64,0},
    [I(25,49)] = {64,0},
    [I(26,49)] = {64,0},
    [I(27,49)] = {64,0},
    [I(28,49)] = {64,0},
    [I(29,49)] = {64,0},
    [I(30,49)] = {64,0},
    [I(31,49)] = {64,0},
    [I(32,49)] = {11,0x281},
    [I(33,49)] = {15,0x7F01},
    [I(34,49)] = {15,0x7F21},
    [I(35,49)] = {17,0x1FF41},
    [I(36,49)] = {18,0x3FF21},
    [I(37,49)] = {11,0x2A1},
    [I(38,49)] = {13,0x1F01},
    [I(39,49)] = {16,0xFF41},
    [I(40,49)] = {15,0x7F41},
    [I(41,49)] = {15,0x7F61},
    [I(42,49)] = {13,0x1F21},
    [I(43,49)] = {16,0xFF61},
    [I(44,49)] = {13,0x1F41},
    [I(45,49)] = {11,0x2C1},
    [I(46,49)] = {11,0x2E1},
    [I(47,49)] = {11,0x301},
    [I(48,49)] = {10,0x1},
    [I(49,49)] = {10,0x21},
    [I(50,49)] = {10,0x41},
    [I(51,49)] = {11,0x321},
    [I(52,49)] = {11,0x341},
    [I(53,49)] = {11,0x361},
    [I(54,49)] = {11,0x381},
    [I(55,49)] = {11,0x3A1},
    [I(56,49)] = {11,0x3C1},
    [I(57,49)] = {11,0x3E1},
    [I(58,49)] = {12,0xB81},
    [I(59,49)] = {13,0x1F61},
    [I(60,49)] = {20,0xFFF81},
    [I(61,49)] = {11,0x401},
    [I(62,49)] = {17,0x1FF61},
    [I(63,49)] = {15,0x7F81},
    [I(64,49)] = {18,0x3FF41},
    [I(65,49)] = {11,0x421},
    [I(66,49)] = {12,0xBA1},
    [I(67,49)] = {12,0xBC1},
    [I(68,49)] = {12,0xBE1},
    [I(69,49)] = {12,0xC01},
    [I(70,49)] = {12,0xC21},
    [I(71,49)] = {12,0xC41},
    [I(72,49)] = {12,0xC61},
    [I(73,49)] = {12,0xC81},
    [I(74,49)] = {12,0xCA1},
    [I(75,49)] = {12,0xCC1},
    [I(76,49)] = {12,0xCE1},
    [I(77,49)] = {12,0xD01},
    [I(78,49)] = {12,0xD21},
    [I(79,49)] = {12,0xD41},
    [I(80,49)] = {12,0xD61},
    [I(81,49)] = {12,0xD81},
    [I(82,49)] = {12,0xDA1},
    [I(83,49)] = {12,0xDC1},
    [I(84,49)] = {12,0xDE1},
    [I(85,49)] = {12,0xE01},
    [I(86,49)] = {12,0xE21},
    [I(87,49)] = {12,0xE41},
    [I(88,49)] = {13,0x1F81},
    [I(89,49)] = {12,0xE61},
    [I(90,49)] = {13,0x1FA1},
    [I(91,49)] = {18,0x3FF61},
    [I(92,49)] = {24,0xFFFE01},
    [I(93,49)] = {18,0x3FF81},
    [I(94,49)] = {19,0x7FF81},
    [I(95,49)] = {11,0x441},
    [I(96,49)] = {20,0xFFFA1},
    [I(97,49)] = {10,0x61},
    [I(98,49)] = {11,0x461},
    [I(99,49)] = {10,0x81},
    [I(100,49)] = {11,0x481},
    [I(101,49)] = {10,0xA1},
    [I(102,49)] = {11,0x4A1},
    [I(103,49)] = {11,0x4C1},
    [I(104,49)] = {11,0x4E1},
    [I(105,49)] = {10,0xC1},
    [I(106,49)] = {12,0xE81},
    [I(107,49)] = {12,0xEA1},
    [I(108,49)] = {11,0x501},
    [I(109,49)] = {11,0x521},
    [I(110,49)] = {11,0x541},
    [I(111,49)] = {10,0xE1},
    [I(112,49)] = {11,0x561},
    [I(113,49)] = {12,0xEC1},
    [I(114,49)] = {11,0x581},
    [I(115,49)] = {10,0x101},
    [I(116,49)] = {10,0x121},
    [I(117,49)] = {11,0x5A1},
    [I(118,49)] = {12,0xEE1},
    [I(119,49)] = {12,0xF01},
    [I(120,49)] = {12,0xF21},
    [I(121,49)] = {12,0xF41},
    [I(122,49)] = {12,0xF61},
    [I(123,49)] = {20,0xFFFC1},
    [I(124,49)] = {16,0xFF81},
    [I(125,49)] = {19,0x7FFA1},
    [I(126,49)] = {18,0x3FFA1},
    [I(127,49)] = {64,0},
    [I(128,49)] = {25,0x1FFFCC1},
    [I(129,49)] = {27,0x7FFFA41},
    [I(130,49)] = {25,0x1FFFCE1},
    [I(131,49)] = {25,0x1FFFD01},
    [I(132,49)] = {27,0x7FFFA61},
    [I(133,49)] = {27,0x7FFFA81},
    [I(134,49)] = {27,0x7FFFAA1},
    [I(135,49)] = {28,0xFFFFB21},
    [I(136,49)] = {27,0x7FFFAC1},
    [I(137,49)] = {28,0xFFFFB41},
    [I(138,49)] = {28,0xFFFFB61},
    [I(139,49)] = {28,0xFFFFB81},
    [I(140,49)] = {28,0xFFFFBA1},
    [I(141,49)] = {28,0xFFFFBC1},
    [I(142,49)] = {29,0x1FFFFD61},
    [I(143,49)] = {28,0xFFFFBE1},
    [I(144,49)] = {29,0x1FFFFD81},
    [I(145,49)] = {29,0x1FFFFDA1},
    [I(146,49)] = {27,0x7FFFAE1},
    [I(147,49)] = {28,0xFFFFC01},
    [I(148,49)] = {29,0x1FFFFDC1},
    [I(149,49)] = {28,0xFFFFC21},
    [I(150,49)] = {28,0xFFFFC41},
    [I(151,49)] = {28,0xFFFFC61},
    [I(152,49)] = {28,0xFFFFC81},
    [I(153,49)] = {26,0x3FFFB81},
    [I(154,49)] = {27,0x7FFFB01},
    [I(155,49)] = {28,0xFFFFCA1},
    [I(156,49)] = {27,0x7FFFB21},
    [I(157,49)] = {28,0xFFFFCC1},
    [I(158,49)] = {28,0xFFFFCE1},
    [I(159,49)] = {29,0x1FFFFDE1},
    [I(160,49)] = {27,0x7FFFB41},
    [I(161,49)] = {26,0x3FFFBA1},
    [I(162,49)] = {25,0x1FFFD21},
    [I(163,49)] = {27,0x7FFFB61},
    [I(164,49)] = {27,0x7FFFB81},
    [I(165,49)] = {28,0xFFFFD01},
    [I(166,49)] = {28,0xFFFFD21},
    [I(167,49)] = {26,0x3FFFBC1},
    [I(168,49)] = {28,0xFFFFD41},
    [I(169,49)] = {27,0x7FFFBA1},
    [I(170,49)] = {27,0x7FFFBC1},
    [I(171,49)] = {29,0x1FFFFE01},
    [I(172,49)] = {26,0x3FFFBE1},
    [I(173,49)] = {27,0x7FFFBE1},
    [I(174,49)] = {28,0xFFFFD61},
    [I(175,49)] = {28,0xFFFFD81},
    [I(176,49)] = {26,0x3FFFC01},
    [I(177,49)] = {26,0x3FFFC21},
    [I(178,49)] = {27,0x7FFFC01},
    [I(179,49)] = {26,0x3FFFC41},
    [I(180,49)] = {28,0xFFFFDA1},
    [I(181,49)] = {27,0x7FFFC21},
    [I(182,49)] = {28,0xFFFFDC1},
    [I(183,49)] = {28,0xFFFFDE1},
    [I(184,49)] = {25,0x1FFFD41},
    [I(185,49)] = {27,0x7FFFC41},
    [I(186,49)] = {27,0x7FFFC61},
    [I(187,49)] = {27,0x7FFFC81},
    [I(188,49)] = {28,0xFFFFE01},
    [I(189,49)] = {27,0x7FFFCA1},
    [I(190,49)] = {27,0x7FFFCC1},
    [I(191,49)] = {28,0xFFFFE21},
    [I(192,49)] = {31,0x7FFFFC01},
    [I(193,49)] = {31,0x7FFFFC21},
    [I(194,49)] = {25,0x1FFFD61},
    [I(195,49)] = {24,0xFFFE21},
    [I(196,49)] = {27,0x7FFFCE1},
    [I(197,49)] = {28,0xFFFFE41},
    [I(198,49)] = {27,0x7FFFD01},
    [I(199,49)] = {30,0x3FFFFD81},
    [I(200,49)] = {31,0x7FFFFC41},
    [I(201,49)] = {31,0x7FFFFC61},
    [I(202,49)] = {31,0x7FFFFC81},
    [I(203,49)] = {X32,0xFFFFFBC1},
    [I(204,49)] = {X32,0xFFFFFBE1},
    [I(205,49)] = {31,0x7FFFFCA1},
    [I(206,49)] = {29,0x1FFFFE21},
    [I(207,49)] = {30,0x3FFFFDA1},
    [I(208,49)] = {24,0xFFFE41},
    [I(209,49)] = {26,0x3FFFC61},
    [I(210,49)] = {31,0x7FFFFCC1},
    [I(211,49)] = {X32,0xFFFFFC01},
    [I(212,49)] = {X32,0xFFFFFC21},
    [I(213,49)] = {31,0x7FFFFCE1},
    [I(214,49)] = {X32,0xFFFFFC41},
    [I(215,49)] = {29,0x1FFFFE41},
    [I(216,49)] = {26,0x3FFFC81},
    [I(217,49)] = {26,0x3FFFCA1},
    [I(218,49)] = {31,0x7FFFFD01},
    [I(219,49)] = {31,0x7FFFFD21},
    [I(220,49)] = {64,0},
    [I(221,49)] = {X32,0xFFFFFC61},
    [I(222,49)] = {X32,0xFFFFFC81},
    [I(223,49)] = {X32,0xFFFFFCA1},
    [I(224,49)] = {25,0x1FFFD81},
    [I(225,49)] = {29,0x1FFFFE61},
    [I(226,49)] = {25,0x1FFFDA1},
    [I(227,49)] = {26,0x3FFFCC1},
    [I(228,49)] = {27,0x7FFFD21},
    [I(229,49)] = {26,0x3FFFCE1},
    [I(230,49)] = {26,0x3FFFD01},
    [I(231,49)] = {28,0xFFFFE61},
    [I(232,49)] = {27,0x7FFFD41},
    [I(233,49)] = {27,0x7FFFD61},
    [I(234,49)] = {30,0x3FFFFDC1},
    [I(235,49)] = {30,0x3FFFFDE1},
    [I(236,49)] = {29,0x1FFFFE81},
    [I(237,49)] = {29,0x1FFFFEA1},
    [I(238,49)] = {31,0x7FFFFD41},
    [I(239,49)] = {28,0xFFFFE81},
    [I(240,49)] = {31,0x7FFFFD61},
    [I(241,49)] = {X32,0xFFFFFCC1},
    [I(242,49)] = {31,0x7FFFFD81},
    [I(243,49)] = {31,0x7FFFFDA1},
    [I(244,49)] = {X32,0xFFFFFCE1},
    [I(245,49)] = {X32,0xFFFFFD01},
    [I(246,49)] = {X32,0xFFFFFD21},
    [I(247,49)] = {X32,0xFFFFFD41},
    [I(248,49)] = {X32,0xFFFFFD61},
    [I(249,49)] = {64,0},
    [I(250,49)] = {X32,0xFFFFFD81},
    [I(251,49)] = {X32,0xFFFFFDA1},
    [I(252,49)] = {X32,0xFFFFFDC1},
    [I(253,49)] = {X32,0xFFFFFDE1},
    [I(254,49)] = {X32,0xFFFFFE01},
    [I(255,49)] = {31,0x7FFFFDC1},
    [I(0,50)] = {18,0x3FF02},
    [I(1,50)] = {28,0xFFFFB02},
    [I(2,50)] = {64,0},
    [I(3,50)] = {64,0},
    [I(4,50)] = {64,0},
    [I(5,50)] = {64,0},
    [I(6,50)] = {64,0},
    [I(7,50)] = {64,0},
    [I(8,50)] = {64,0},
    [I(9,50)] = {29,0x1FFFFD42},
    [I(10,50)] = {64,0},
    [I(11,50)] = {64,0},
    [I(12,50)] = {64,0},
    [I(13,50)] = {64,0},
    [I(14,50)] = {64,0},
    [I(15,50)] = {64,0},
    [I(16,50)] = {64,0},
    [I(17,50)] = {64,0},
    [I(18,50)] = {64,0},
    [I(19,50)] = {64,0},
    [I(20,50)] = {64,0},
    [I(21,50)] = {64,0},
    [I(22,50)] = {64,0},
    [I(23,50)] = {64,0},
    [I(24,50)] = {64,0},
    [I(25,50)] = {64,0},
    [I(26,50)] = {64,0},
    [I(27,50)] = {64,0},
    [I(28,50)] = {64,0},
    [I(29,50)] = {64,0},
    [I(30,50)] = {64,0},
    [I(31,50)] = {64,0},
    [I(32,50)] = {11,0x282},
    [I(33,50)] = {15,0x7F02},
    [I(34,50)] = {15,0x7F22},
    [I(35,50)] = {17,0x1FF42},
    [I(36,50)] = {18,0x3FF22},
    [I(37,50)] = {11,0x2A2},
    [I(38,50)] = {13,0x1F02},
    [I(39,50)] = {16,0xFF42},
    [I(40,50)] = {15,0x7F42},
    [I(41,50)] = {15,0x7F62},
    [I(42,50)] = {13,0x1F22},
    [I(43,50)] = {16,0xFF62},
    [I(44,50)] = {13,0x1F42},
    [I(45,50)] = {11,0x2C2},
    [I(46,50)] = {11,0x2E2},
    [I(47,50)] = {11,0x302},
    [I(48,50)] = {10,0x2},
    [I(49,50)] = {10,0x22},
    [I(50,50)] = {10,0x42},
    [I(51,50)] = {11,0x322},
    [I(52,50)] = {11,0x342},
    [I(53,50)] = {11,0x362},
    [I(54,50)] = {11,0x382},
    [I(55,50)] = {11,0x3A2},
    [I(56,50)] = {11,0x3C2},
    [I(57,50)] = {11,0x3E2},
    [I(58,50)] = {12,0xB82},
    [I(59,50)] = {13,0x1F62},
    [I(60,50)] = {20,0xFFF82},
    [I(61,50)] = {11,0x402},
    [I(62,50)] = {17,0x1FF62},
    [I(63,50)] = {15,0x7F82},
    [I(64,50)] = {18,0x3FF42},
    [I(65,50)] = {11,0x422},
    [I(66,50)] = {12,0xBA2},
    [I(67,50)] = {12,0xBC2},
    [I(68,50)] = {12,0xBE2},
    [I(69,50)] = {12,0xC02},
    [I(70,50)] = {12,0xC22},
    [I(71,50)] = {12,0xC42},
    [I(72,50)] = {12,0xC62},
    [I(73,50)] = {12,0xC82},
    [I(74,50)] = {12,0xCA2},
    [I(75,50)] = {12,0xCC2},
    [I(76,50)] = {12,0xCE2},
    [I(77,50)] = {12,0xD02},
    [I(78,50)] = {12,0xD22},
    [I(79,50)] = {12,0xD42},
    [I(80,50)] = {12,0xD62},
    [I(81,50)] = {12,0xD82},
    [I(82,50)] = {12,0xDA2},
    [I(83,50)] = {12,0xDC2},
    [I(84,50)] = {12,0xDE2},
    [I(85,50)] = {12,0xE02},
    [I(86,50)] = {12,0xE22},
    [I(87,50)] = {12,0xE42},
    [I(88,50)] = {13,0x1F82},
    [I(89,50)] = {12,0xE62},
    [I(90,50)] = {13,0x1FA2},
    [I(91,50)] = {18,0x3FF62},
    [I(92,50)] = {24,0xFFFE02},
    [I(93,50)] = {18,0x3FF82},
    [I(94,50)] = {19,0x7FF82},
    [I(95,50)] = {11,0x442},
    [I(96,50)] = {20,0xFFFA2},
    [I(97,50)] = {10,0x62},
    [I(98,50)] = {11,0x462},
    [I(99,50)] = {10,0x82},
    [I(100,50)] = {11,0x482},
    [I(101,50)] = {10,0xA2},
    [I(102,50)] = {11,0x4A2},
    [I(103,50)] = {11,0x4C2},
    [I(104,50)] = {11,0x4E2},
    [I(105,50)] = {10,0xC2},
    [I(106,50)] = {12,0xE82},
    [I(107,50)] = {12,0xEA2},
    [I(108,50)] = {11,0x502},
    [I(109,50)] = {11,0x522},
    [I(110,50)] = {11,0x542},
    [I(111,50)] = {10,0xE2},
    [I(112,50)] = {11,0x562},
    [I(113,50)] = {12,0xEC2},
    [I(114,50)] = {11,0x582},
    [I(115,50)] = {10,0x102},
    [I(116,50)] = {10,0x122},
    [I(117,50)] = {11,0x5A2},
    [I(118,50)] = {12,0xEE2},
    [I(119,50)] = {12,0xF02},
    [I(120,50)] = {12,0xF22},
    [I(121,50)] = {12,0xF42},
    [I(122,50)] = {12,0xF62},
    [I(123,50)] = {20,0xFFFC2},
    [I(124,50)] = {16,0xFF82},
    [I(125,50)] = {19,0x7FFA2},
    [I(126,50)] = {18,0x3FFA2},
    [I(127,50)] = {64,0},
    [I(128,50)] = {25,0x1FFFCC2},
    [I(129,50)] = {27,0x7FFFA42},
    [I(130,50)] = {25,0x1FFFCE2},
    [I(131,50)] = {25,0x1FFFD02},
    [I(132,50)] = {27,0x7FFFA62},
    [I(133,50)] = {27,0x7FFFA82},
    [I(134,50)] = {27,0x7FFFAA2},
    [I(135,50)] = {28,0xFFFFB22},
    [I(136,50)] = {27,0x7FFFAC2},
    [I(137,50)] = {28,0xFFFFB42},
    [I(138,50)] = {28,0xFFFFB62},
    [I(139,50)] = {28,0xFFFFB82},
    [I(140,50)] = {28,0xFFFFBA2},
    [I(141,50)] = {28,0xFFFFBC2},
    [I(142,50)] = {29,0x1FFFFD62},
    [I(143,50)] = {28,0xFFFFBE2},
    [I(144,50)] = {29,0x1FFFFD82},
    [I(145,50)] = {29,0x1FFFFDA2},
    [I(146,50)] = {27,0x7FFFAE2},
    [I(147,50)] = {28,0xFFFFC02},
    [I(148,50)] = {29,0x1FFFFDC2},
    [I(149,50)] = {28,0xFFFFC22},
    [I(150,50)] = {28,0xFFFFC42},
    [I(151,50)] = {28,0xFFFFC62},
    [I(152,50)] = {28,0xFFFFC82},
    [I(153,50)] = {26,0x3FFFB82},
    [I(154,50)] = {27,0x7FFFB02},
    [I(155,50)] = {28,0xFFFFCA2},
    [I(156,50)] = {27,0x7FFFB22},
    [I(157,50)] = {28,0xFFFFCC2},
    [I(158,50)] = {28,0xFFFFCE2},
    [I(159,50)] = {29,0x1FFFFDE2},
    [I(160,50)] = {27,0x7FFFB42},
    [I(161,50)] = {26,0x3FFFBA2},
    [I(162,50)] = {25,0x1FFFD22},
    [I(163,50)] = {27,0x7FFFB62},
    [I(164,50)] = {27,0x7FFFB82},
    [I(165,50)] = {28,0xFFFFD02},
    [I(166,50)] = {28,0xFFFFD22},
    [I(167,50)] = {26,0x3FFFBC2},
    [I(168,50)] = {28,0xFFFFD42},
    [I(169,50)] = {27,0x7FFFBA2},
    [I(170,50)] = {27,0x7FFFBC2},
    [I(171,50)] = {29,0x1FFFFE02},
    [I(172,50)] = {26,0x3FFFBE2},
    [I(173,50)] = {27,0x7FFFBE2},
    [I(174,50)] = {28,0xFFFFD62},
    [I(175,50)] = {28,0xFFFFD82},
    [I(176,50)] = {26,0x3FFFC02},
    [I(177,50)] = {26,0x3FFFC22},
    [I(178,50)] = {27,0x7FFFC02},
    [I(179,50)] = {26,0x3FFFC42},
    [I(180,50)] = {28,0xFFFFDA2},
    [I(181,50)] = {27,0x7FFFC22},
    [I(182,50)] = {28,0xFFFFDC2},
    [I(183,50)] = {28,0xFFFFDE2},
    [I(184,50)] = {25,0x1FFFD42},
    [I(185,50)] = {27,0x7FFFC42},
    [I(186,50)] = {27,0x7FFFC62},
    [I(187,50)] = {27,0x7FFFC82},
    [I(188,50)] = {28,0xFFFFE02},
    [I(189,50)] = {27,0x7FFFCA2},
    [I(190,50)] = {27,0x7FFFCC2},
    [I(191,50)] = {28,0xFFFFE22},
    [I(192,50)] = {31,0x7FFFFC02},
    [I(193,50)] = {31,0x7FFFFC22},
    [I(194,50)] = {25,0x1FFFD62},
    [I(195,50)] = {24,0xFFFE22},
    [I(196,50)] = {27,0x7FFFCE2},
    [I(197,50)] = {28,0xFFFFE42},
    [I(198,50)] = {27,0x7FFFD02},
    [I(199,50)] = {30,0x3FFFFD82},
    [I(200,50)] = {31,0x7FFFFC42},
    [I(201,50)] = {31,0x7FFFFC62},
    [I(202,50)] = {31,0x7FFFFC82},
    [I(203,50)] = {X32,0xFFFFFBC2},
    [I(204,50)] = {X32,0xFFFFFBE2},
    [I(205,50)] = {31,0x7FFFFCA2},
    [I(206,50)] = {29,0x1FFFFE22},
    [I(207,50)] = {30,0x3FFFFDA2},
    [I(208,50)] = {24,0xFFFE42},
    [I(209,50)] = {26,0x3FFFC62},
    [I(210,50)] = {31,0x7FFFFCC2},
    [I(211,50)] = {X32,0xFFFFFC02},
    [I(212,50)] = {X32,0xFFFFFC22},
    [I(213,50)] = {31,0x7FFFFCE2},
    [I(214,50)] = {X32,0xFFFFFC42},
    [I(215,50)] = {29,0x1FFFFE42},
    [I(216,50)] = {26,0x3FFFC82},
    [I(217,50)] = {26,0x3FFFCA2},
    [I(218,50)] = {31,0x7FFFFD02},
    [I(219,50)] = {31,0x7FFFFD22},
    [I(220,50)] = {64,0},
    [I(221,50)] = {X32,0xFFFFFC62},
    [I(222,50)] = {X32,0xFFFFFC82},
    [I(223,50)] = {X32,0xFFFFFCA2},
    [I(224,50)] = {25,0x1FFFD82},
    [I(225,50)] = {29,0x1FFFFE62},
    [I(226,50)] = {25,0x1FFFDA2},
    [I(227,50)] = {26,0x3FFFCC2},
    [I(228,50)] = {27,0x7FFFD22},
    [I(229,50)] = {26,0x3FFFCE2},
    [I(230,50)] = {26,0x3FFFD02},
    [I(231,50)] = {28,0xFFFFE62},
    [I(232,50)] = {27,0x7FFFD42},
    [I(233,50)] = {27,0x7FFFD62},
    [I(234,50)] = {30,0x3FFFFDC2},
    [I(235,50)] = {30,0x3FFFFDE2},
    [I(236,50)] = {29,0x1FFFFE82},
    [I(237,50)] = {29,0x1FFFFEA2},
    [I(238,50)] = {31,0x7FFFFD42},
    [I(239,50)] = {28,0xFFFFE82},
    [I(240,50)] = {31,0x7FFFFD62},
    [I(241,50)] = {X32,0xFFFFFCC2},
    [I(242,50)] = {31,0x7FFFFD82},
    [I(243,50)] = {31,0x7FFFFDA2},
    [I(244,50)] = {X32,0xFFFFFCE2},
    [I(245,50)] = {X32,0xFFFFFD02},
    [I(246,50)] = {X32,0xFFFFFD22},
    [I(247,50)] = {X32,0xFFFFFD42},
    [I(248,50)] = {X32,0xFFFFFD62},
    [I(249,50)] = {64,0},
    [I(250,50)] = {X32,0xFFFFFD82},
    [I(251,50)] = {X32,0xFFFFFDA2},
    [I(252,50)] = {X32,0xFFFFFDC2},
    [I(253,50)] = {X32,0xFFFFFDE2},
    [I(254,50)] = {X32,0xFFFFFE02},
    [I(255,50)] = {31,0x7FFFFDC2},
    [I(0,51)] = {19,0x7FE19},
    [I(1,51)] = {29,0x1FFFF619},
    [I(2,51)] = {64,0},
    [I(3,51)] = {64,0},
    [I(4,51)] = {64,0},
    [I(5,51)] = {64,0},
    [I(6,51)] = {64,0},
    [I(7,51)] = {64,0},
    [I(8,51)] = {64,0},
    [I(9,51)] = {30,0x3FFFFA99},
    [I(10,51)] = {64,0},
    [I(11,51)] = {64,0},
    [I(12,51)] = {64,0},
    [I(13,51)] = {64,0},
    [I(14,51)] = {64,0},
    [I(15,51)] = {64,0},
    [I(16,51)] = {64,0},
    [I(17,51)] = {64,0},
    [I(18,51)] = {64,0},
    [I(19,51)] = {64,0},
    [I(20,51)] = {64,0},
    [I(21,51)] = {64,0},
    [I(22,51)] = {64,0},
    [I(23,51)] = {64,0},
    [I(24,51)] = {64,0},
    [I(25,51)] = {64,0},
    [I(26,51)] = {64,0},
    [I(27,51)] = {64,0},
    [I(28,51)] = {64,0},
    [I(29,51)] = {64,0},
    [I(30,51)] = {64,0},
    [I(31,51)] = {64,0},
    [I(32,51)] = {12,0x519},
    [I(33,51)] = {16,0xFE19},
    [I(34,51)] = {16,0xFE59},
    [I(35,51)] = {18,0x3FE99},
    [I(36,51)] = {19,0x7FE59},
    [I(37,51)] = {12,0x559},
    [I(38,51)] = {14,0x3E19},
    [I(39,51)] = {17,0x1FE99},
    [I(40,51)] = {16,0xFE99},
    [I(41,51)] = {16,0xFED9},
    [I(42,51)] = {14,0x3E59},
    [I(43,51)] = {17,0x1FED9},
    [I(44,51)] = {14,0x3E99},
    [I(45,51)] = {12,0x599},
    [I(46,51)] = {12,0x5D9},
    [I(47,51)] = {12,0x619},
    [I(48,51)] = {11,0x19},
    [I(49,51)] = {11,0x59},
    [I(50,51)] = {11,0x99},
    [I(51,51)] = {12,0x659},
    [I(52,51)] = {12,0x699},
    [I(53,51)] = {12,0x6D9},
    [I(54,51)] = {12,0x719},
    [I(55,51)] = {12,0x759},
    [I(56,51)] = {12,0x799},
    [I(57,51)] = {12,0x7D9},
    [I(58,51)] = {13,0x1719},
    [I(59,51)] = {14,0x3ED9},
    [I(60,51)] = {21,0x1FFF19},
    [I(61,51)] = {12,0x819},
    [I(62,51)] = {18,0x3FED9},
    [I(63,51)] = {16,0xFF19},
    [I(64,51)] = {19,0x7FE99},
    [I(65,51)] = {12,0x859},
    [I(66,51)] = {13,0x1759},
    [I(67,51)] = {13,0x1799},
    [I(68,51)] = {13,0x17D9},
    [I(69,51)] = {13,0x1819},
    [I(70,51)] = {13,0x1859},
    [I(71,51)] = {13,0x1899},
    [I(72,51)] = {13,0x18D9},
    [I(73,51)] = {13,0x1919},
    [I(74,51)] = {13,0x1959},
    [I(75,51)] = {13,0x1999},
    [I(76,51)] = {13,0x19D9},
    [I(77,51)] = {13,0x1A19},
    [I(78,51)] = {13,0x1A59},
    [I(79,51)] = {13,0x1A99},
    [I(80,51)] = {13,0x1AD9},
    [I(81,51)] = {13,0x1B19},
    [I(82,51)] = {13,0x1B59},
    [I(83,51)] = {13,0x1B99},
    [I(84,51)] = {13,0x1BD9},
    [I(85,51)] = {13,0x1C19},
    [I(86,51)] = {13,0x1C59},
    [I(87,51)] = {13,0x1C99},
    [I(88,51)] = {14,0x3F19},
    [I(89,51)] = {13,0x1CD9},
    [I(90,51)] = {14,0x3F59},
    [I(91,51)] = {19,0x7FED9},
    [I(92,51)] = {25,0x1FFFC19},
    [I(93,51)] = {19,0x7FF19},
    [I(94,51)] = {20,0xFFF19},
    [I(95,51)] = {12,0x899},
    [I(96,51)] = {21,0x1FFF59},
    [I(97,51)] = {11,0xD9},
    [I(98,51)] = {12,0x8D9},
    [I(99,51)] = {11,0x119},
    [I(100,51)] = {12,0x919},
    [I(101,51)] = {11,0x159},
    [I(102,51)] = {12,0x959},
    [I(103,51)] = {12,0x999},
    [I(104,51)] = {12,0x9D9},
    [I(105,51)] = {11,0x199},
    [I(106,51)] = {13,0x1D19},
    [I(107,51)] = {13,0x1D59},
    [I(108,51)] = {12,0xA19},
    [I(109,51)] = {12,0xA59},
    [I(110,51)] = {12,0xA99},
    [I(111,51)] = {11,0x1D9},
    [I(112,51)] = {12,0xAD9},
    [I(113,51)] = {13,0x1D99},
    [I(114,51)] = {12,0xB19},
    [I(115,51)] = {11,0x219},
    [I(116,51)] = {11,0x259},
    [I(117,51)] = {12,0xB59},
    [I(118,51)] = {13,0x1DD9},
    [I(119,51)] = {13,0x1E19},
    [I(120,51)] = {13,0x1E59},
    [I(121,51)] = {13,0x1E99},
    [I(122,51)] = {13,0x1ED9},
    [I(123,51)] = {21,0x1FFF99},
    [I(124,51)] = {17,0x1FF19},
    [I(125,51)] = {20,0xFFF59},
    [I(126,51)] = {19,0x7FF59},
    [I(127,51)] = {64,0},
    [I(128,51)] = {26,0x3FFF999},
    [I(129,51)] = {28,0xFFFF499},
    [I(130,51)] = {26,0x3FFF9D9},
    [I(131,51)] = {26,0x3FFFA19},
    [I(132,51)] = {28,0xFFFF4D9},
    [I(133,51)] = {28,0xFFFF519},
    [I(134,51)] = {28,0xFFFF559},
    [I(135,51)] = {29,0x1FFFF659},
    [I(136,51)] = {28,0xFFFF599},
    [I(137,51)] = {29,0x1FFFF699},
    [I(138,51)] = {29,0x1FFFF6D9},
    [I(139,51)] = {29,0x1FFFF719},
    [I(140,51)] = {29,0x1FFFF759},
    [I(141,51)] = {29,0x1FFFF799},
    [I(142,51)] = {30,0x3FFFFAD9},
    [I(143,51)] = {29,0x1FFFF7D9},
    [I(144,51)] = {30,0x3FFFFB19},
    [I(145,51)] = {30,0x3FFFFB59},
    [I(146,51)] = {28,0xFFFF5D9},
    [I(147,51)] = {29,0x1FFFF819},
    [I(148,51)] = {30,0x3FFFFB99},
    [I(149,51)] = {29,0x1FFFF859},
    [I(150,51)] = {29,0x1FFFF899},
    [I(151,51)] = {29,0x1FFFF8D9},
    [I(152,51)] = {29,0x1FFFF919},
    [I(153,51)] = {27,0x7FFF719},
    [I(154,51)] = {28,0xFFFF619},
    [I(155,51)] = {29,0x1FFFF959},
    [I(156,51)] = {28,0xFFFF659},
    [I(157,51)] = {29,0x1FFFF999},
    [I(158,51)] = {29,0x1FFFF9D9},
    [I(159,51)] = {30,0x3FFFFBD9},
    [I(160,51)] = {28,0xFFFF699},
    [I(161,51)] = {27,0x7FFF759},
    [I(162,51)] = {26,0x3FFFA59},
    [I(163,51)] = {28,0xFFFF6D9},
    [I(164,51)] = {28,0xFFFF719},
    [I(165,51)] = {29,0x1FFFFA19},
    [I(166,51)] = {29,0x1FFFFA59},
    [I(167,51)] = {27,0x7FFF799},
    [I(168,51)] = {29,0x1FFFFA99},
    [I(169,51)] = {28,0xFFFF759},
    [I(170,51)] = {28,0xFFFF799},
    [I(171,51)] = {30,0x3FFFFC19},
    [I(172,51)] = {27,0x7FFF7D9},
    [I(173,51)] = {28,0xFFFF7D9},
    [I(174,51)] = {29,0x1FFFFAD9},
    [I(175,51)] = {29,0x1FFFFB19},
    [I(176,51)] = {27,0x7FFF819},
    [I(177,51)] = {27,0x7FFF859},
    [I(178,51)] = {28,0xFFFF819},
    [I(179,51)] = {27,0x7FFF899},
    [I(180,51)] = {29,0x1FFFFB59},
    [I(181,51)] = {28,0xFFFF859},
    [I(182,51)] = {29,0x1FFFFB99},
    [I(183,51)] = {29,0x1FFFFBD9},
    [I(184,51)] = {26,0x3FFFA99},
    [I(185,51)] = {28,0xFFFF899},
    [I(186,51)] = {28,0xFFFF8D9},
    [I(187,51)] = {28,0xFFFF919},
    [I(188,51)] = {29,0x1FFFFC19},
    [I(189,51)] = {28,0xFFFF959},
    [I(190,51)] = {28,0xFFFF999},
    [I(191,51)] = {29,0x1FFFFC59},
    [I(192,51)] = {X32,0xFFFFF819},
    [I(193,51)] = {X32,0xFFFFF859},
    [I(194,51)] = {26,0x3FFFAD9},
    [I(195,51)] = {25,0x1FFFC59},
    [I(196,51)] = {28,0xFFFF9D9},
    [I(197,51)] = {29,0x1FFFFC99},
    [I(198,51)] = {28,0xFFFFA19},
    [I(199,51)] = {31,0x7FFFFB19},
    [I(200,51)] = {X32,0xFFFFF899},
    [I(201,51)] = {X32,0xFFFFF8D9},
    [I(202,51)] = {X32,0xFFFFF919},
    [I(203,51)] = {64,0},
    [I(204,51)] = {64,0},
    [I(205,51)] = {X32,0xFFFFF959},
    [I(206,51)] = {30,0x3FFFFC59},
    [I(207,51)] = {31,0x7FFFFB59},
    [I(208,51)] = {25,0x1FFFC99},
    [I(209,51)] = {27,0x7FFF8D9},
    [I(210,51)] = {X32,0xFFFFF999},
    [I(211,51)] = {64,0},
    [I(212,51)] = {64,0},
    [I(213,51)] = {X32,0xFFFFF9D9},
    [I(214,51)] = {64,0},
    [I(215,51)] = {30,0x3FFFFC99},
    [I(216,51)] = {27,0x7FFF919},
    [I(217,51)] = {27,0x7FFF959},
    [I(218,51)] = {X32,0xFFFFFA19},
    [I(219,51)] = {X32,0xFFFFFA59},
    [I(220,51)] = {64,0},
    [I(221,51)] = {64,0},
    [I(222,51)] = {64,0},
    [I(223,51)] = {64,0},
    [I(224,51)] = {26,0x3FFFB19},
    [I(225,51)] = {30,0x3FFFFCD9},
    [I(226,51)] = {26,0x3FFFB59},
    [I(227,51)] = {27,0x7FFF999},
    [I(228,51)] = {28,0xFFFFA59},
    [I(229,51)] = {27,0x7FFF9D9},
    [I(230,51)] = {27,0x7FFFA19},
    [I(231,51)] = {29,0x1FFFFCD9},
    [I(232,51)] = {28,0xFFFFA99},
    [I(233,51)] = {28,0xFFFFAD9},
    [I(234,51)] = {31,0x7FFFFB99},
    [I(235,51)] = {31,0x7FFFFBD9},
    [I(236,51)] = {30,0x3FFFFD19},
    [I(237,51)] = {30,0x3FFFFD59},
    [I(238,51)] = {X32,0xFFFFFA99},
    [I(239,51)] = {29,0x1FFFFD19},
    [I(240,51)] = {X32,0xFFFFFAD9},
    [I(241,51)] = {64,0},
    [I(242,51)] = {X32,0xFFFFFB19},
    [I(243,51)] = {X32,0xFFFFFB59},
    [I(244,51)] = {64,0},
    [I(245,51)] = {64,0},
    [I(246,51)] = {64,0},
    [I(247,51)] = {64,0},
    [I(248,51)] = {64,0},
    [I(249,51)] = {64,0},
    [I(250,51)] = {64,0},
    [I(251,51)] = {64,0},
    [I(252,51)] = {64,0},
    [I(253,51)] = {64,0},
    [I(254,51)] = {64,0},
    [I(255,51)] = {X32,0xFFFFFB99},
    [I(0,52)] = {19,0x7FE1A},
    [I(1,52)] = {29,0x1FFFF61A},
    [I(2,52)] = {64,0},
    [I(3,52)] = {64,0},
    [I(4,52)] = {64,0},
    [I(5,52)] = {64,0},
    [I(6,52)] = {64,0},
    [I(7,52)] = {64,0},
    [I(8,52)] = {64,0},
    [I(9,52)] = {30,0x3FFFFA9A},
    [I(10,52)] = {64,0},
    [I(11,52)] = {64,0},
    [I(12,52)] = {64,0},
    [I(13,52)] = {64,0},
    [I(14,52)] = {64,0},
    [I(15,52)] = {64,0},
    [I(16,52)] = {64,0},
    [I(17,52)] = {64,0},
    [I(18,52)] = {64,0},
    [I(19,52)] = {64,0},
    [I(20,52)] = {64,0},
    [I(21,52)] = {64,0},
    [I(22,52)] = {64,0},
    [I(23,52)] = {64,0},
    [I(24,52)] = {64,0},
    [I(25,52)] = {64,0},
    [I(26,52)] = {64,0},
    [I(27,52)] = {64,0},
    [I(28,52)] = {64,0},
    [I(29,52)] = {64,0},
    [I(30,52)] = {64,0},
    [I(31,52)] = {64,0},
    [I(32,52)] = {12,0x51A},
    [I(33,52)] = {16,0xFE1A},
    [I(34,52)] = {16,0xFE5A},
    [I(35,52)] = {18,0x3FE9A},
    [I(36,52)] = {19,0x7FE5A},
    [I(37,52)] = {12,0x55A},
    [I(38,52)] = {14,0x3E1A},
    [I(39,52)] = {17,0x1FE9A},
    [I(40,52)] = {16,0xFE9A},
    [I(41,52)] = {16,0xFEDA},
    [I(42,52)] = {14,0x3E5A},
    [I(43,52)] = {17,0x1FEDA},
    [I(44,52)] = {14,0x3E9A},
    [I(45,52)] = {12,0x59A},
    [I(46,52)] = {12,0x5DA},
    [I(47,52)] = {12,0x61A},
    [I(48,52)] = {11,0x1A},
    [I(49,52)] = {11,0x5A},
    [I(50,52)] = {11,0x9A},
    [I(51,52)] = {12,0x65A},
    [I(52,52)] = {12,0x69A},
    [I(53,52)] = {12,0x6DA},
    [I(54,52)] = {12,0x71A},
    [I(55,52)] = {12,0x75A},
    [I(56,52)] = {12,0x79A},
    [I(57,52)] = {12,0x7DA},
    [I(58,52)] = {13,0x171A},
    [I(59,52)] = {14,0x3EDA},
    [I(60,52)] = {21,0x1FFF1A},
    [I(61,52)] = {12,0x81A},
    [I(62,52)] = {18,0x3FEDA},
    [I(63,52)] = {16,0xFF1A},
    [I(64,52)] = {19,0x7FE9A},
    [I(65,52)] = {12,0x85A},
    [I(66,52)] = {13,0x175A},
    [I(67,52)] = {13,0x179A},
    [I(68,52)] = {13,0x17DA},
    [I(69,52)] = {13,0x181A},
    [I(70,52)] = {13,0x185A},
    [I(71,52)] = {13,0x189A},
    [I(72,52)] = {13,0x18DA},
    [I(73,52)] = {13,0x191A},
    [I(74,52)] = {13,0x195A},
    [I(75,52)] = {13,0x199A},
    [I(76,52)] = {13,0x19DA},
    [I(77,52)] = {13,0x1A1A},
    [I(78,52)] = {13,0x1A5A},
    [I(79,52)] = {13,0x1A9A},
    [I(80,52)] = {13,0x1ADA},
    [I(81,52)] = {13,0x1B1A},
    [I(82,52)] = {13,0x1B5A},
    [I(83,52)] = {13,0x1B9A},
    [I(84,52)] = {13,0x1BDA},
    [I(85,52)] = {13,0x1C1A},
    [I(86,52)] = {13,0x1C5A},
    [I(87,52)] = {13,0x1C9A},
    [I(88,52)] = {14,0x3F1A},
    [I(89,52)] = {13,0x1CDA},
    [I(90,52)] = {14,0x3F5A},
    [I(91,52)] = {19,0x7FEDA},
    [I(92,52)] = {25,0x1FFFC1A},
    [I(93,52)] = {19,0x7FF1A},
    [I(94,52)] = {20,0xFFF1A},
    [I(95,52)] = {12,0x89A},
    [I(96,52)] = {21,0x1FFF5A},
    [I(97,52)] = {11,0xDA},
    [I(98,52)] = {12,0x8DA},
    [I(99,52)] = {11,0x11A},
    [I(100,52)] = {12,0x91A},
    [I(101,52)] = {11,0x15A},
    [I(102,52)] = {12,0x95A},
    [I(103,52)] = {12,0x99A},
    [I(104,52)] = {12,0x9DA},
    [I(105,52)] = {11,0x19A},
    [I(106,52)] = {13,0x1D1A},
    [I(107,52)] = {13,0x1D5A},
    [I(108,52)] = {12,0xA1A},
    [I(109,52)] = {12,0xA5A},
    [I(110,52)] = {12,0xA9A},
    [I(111,52)] = {11,0x1DA},
    [I(112,52)] = {12,0xADA},
    [I(113,52)] = {13,0x1D9A},
    [I(114,52)] = {12,0xB1A},
    [I(115,52)] = {11,0x21A},
    [I(116,52)] = {11,0x25A},
    [I(117,52)] = {12,0xB5A},
    [I(118,52)] = {13,0x1DDA},
    [I(119,52)] = {13,0x1E1A},
    [I(120,52)] = {13,0x1E5A},
    [I(121,52)] = {13,0x1E9A},
    [I(122,52)] = {13,0x1EDA},
    [I(123,52)] = {21,0x1FFF9A},
    [I(124,52)] = {17,0x1FF1A},
    [I(125,52)] = {20,0xFFF5A},
    [I(126,52)] = {19,0x7FF5A},
    [I(127,52)] = {64,0},
    [I(128,52)] = {26,0x3FFF99A},
    [I(129,52)] = {28,0xFFFF49A},
    [I(130,52)] = {26,0x3FFF9DA},
    [I(131,52)] = {26,0x3FFFA1A},
    [I(132,52)] = {28,0xFFFF4DA},
    [I(133,52)] = {28,0xFFFF51A},
    [I(134,52)] = {28,0xFFFF55A},
    [I(135,52)] = {29,0x1FFFF65A},
    [I(136,52)] = {28,0xFFFF59A},
    [I(137,52)] = {29,0x1FFFF69A},
    [I(138,52)] = {29,0x1FFFF6DA},
    [I(139,52)] = {29,0x1FFFF71A},
    [I(140,52)] = {29,0x1FFFF75A},
    [I(141,52)] = {29,0x1FFFF79A},
    [I(142,52)] = {30,0x3FFFFADA},
    [I(143,52)] = {29,0x1FFFF7DA},
    [I(144,52)] = {30,0x3FFFFB1A},
    [I(145,52)] = {30,0x3FFFFB5A},
    [I(146,52)] = {28,0xFFFF5DA},
    [I(147,52)] = {29,0x1FFFF81A},
    [I(148,52)] = {30,0x3FFFFB9A},
    [I(149,52)] = {29,0x1FFFF85A},
    [I(150,52)] = {29,0x1FFFF89A},
    [I(151,52)] = {29,0x1FFFF8DA},
    [I(152,52)] = {29,0x1FFFF91A},
    [I(153,52)] = {27,0x7FFF71A},
    [I(154,52)] = {28,0xFFFF61A},
    [I(155,52)] = {29,0x1FFFF95A},
    [I(156,52)] = {28,0xFFFF65A},
    [I(157,52)] = {29,0x1FFFF99A},
    [I(158,52)] = {29,0x1FFFF9DA},
    [I(159,52)] = {30,0x3FFFFBDA},
    [I(160,52)] = {28,0xFFFF69A},
    [I(161,52)] = {27,0x7FFF75A},
    [I(162,52)] = {26,0x3FFFA5A},
    [I(163,52)] = {28,0xFFFF6DA},
    [I(164,52)] = {28,0xFFFF71A},
    [I(165,52)] = {29,0x1FFFFA1A},
    [I(166,52)] = {29,0x1FFFFA5A},
    [I(167,52)] = {27,0x7FFF79A},
    [I(168,52)] = {29,0x1FFFFA9A},
    [I(169,52)] = {28,0xFFFF75A},
    [I(170,52)] = {28,0xFFFF79A},
    [I(171,52)] = {30,0x3FFFFC1A},
    [I(172,52)] = {27,0x7FFF7DA},
    [I(173,52)] = {28,0xFFFF7DA},
    [I(174,52)] = {29,0x1FFFFADA},
    [I(175,52)] = {29,0x1FFFFB1A},
    [I(176,52)] = {27,0x7FFF81A},
    [I(177,52)] = {27,0x7FFF85A},
    [I(178,52)] = {28,0xFFFF81A},
    [I(179,52)] = {27,0x7FFF89A},
    [I(180,52)] = {29,0x1FFFFB5A},
    [I(181,52)] = {28,0xFFFF85A},
    [I(182,52)] = {29,0x1FFFFB9A},
    [I(183,52)] = {29,0x1FFFFBDA},
    [I(184,52)] = {26,0x3FFFA9A},
    [I(185,52)] = {28,0xFFFF89A},
    [I(186,52)] = {28,0xFFFF8DA},
    [I(187,52)] = {28,0xFFFF91A},
    [I(188,52)] = {29,0x1FFFFC1A},
    [I(189,52)] = {28,0xFFFF95A},
    [I(190,52)] = {28,0xFFFF99A},
    [I(191,52)] = {29,0x1FFFFC5A},
    [I(192,52)] = {X32,0xFFFFF81A},
    [I(193,52)] = {X32,0xFFFFF85A},
    [I(194,52)] = {26,0x3FFFADA},
    [I(195,52)] = {25,0x1FFFC5A},
    [I(196,52)] = {28,0xFFFF9DA},
    [I(197,52)] = {29,0x1FFFFC9A},
    [I(198,52)] = {28,0xFFFFA1A},
    [I(199,52)] = {31,0x7FFFFB1A},
    [I(200,52)] = {X32,0xFFFFF89A},
    [I(201,52)] = {X32,0xFFFFF8DA},
    [I(202,52)] = {X32,0xFFFFF91A},
    [I(203,52)] = {64,0},
    [I(204,52)] = {64,0},
    [I(205,52)] = {X32,0xFFFFF95A},
    [I(206,52)] = {30,0x3FFFFC5A},
    [I(207,52)] = {31,0x7FFFFB5A},
    [I(208,52)] = {25,0x1FFFC9A},
    [I(209,52)] = {27,0x7FFF8DA},
    [I(210,52)] = {X32,0xFFFFF99A},
    [I(211,52)] = {64,0},
    [I(212,52)] = {64,0},
    [I(213,52)] = {X32,0xFFFFF9DA},
    [I(214,52)] = {64,0},
    [I(215,52)] = {30,0x3FFFFC9A},
    [I(216,52)] = {27,0x7FFF91A},
    [I(217,52)] = {27,0x7FFF95A},
    [I(218,52)] = {X32,0xFFFFFA1A},
    [I(219,52)] = {X32,0xFFFFFA5A},
    [I(220,52)] = {64,0},
    [I(221,52)] = {64,0},
    [I(222,52)] = {64,0},
    [I(223,52)] = {64,0},
    [I(224,52)] = {26,0x3FFFB1A},
    [I(225,52)] = {30,0x3FFFFCDA},
    [I(226,52)] = {26,0x3FFFB5A},
    [I(227,52)] = {27,0x7FFF99A},
    [I(228,52)] = {28,0xFFFFA5A},
    [I(229,52)] = {27,0x7FFF9DA},
    [I(230,52)] = {27,0x7FFFA1A},
    [I(231,52)] = {29,0x1FFFFCDA},
    [I(232,52)] = {28,0xFFFFA9A},
    [I(233,52)] = {28,0xFFFFADA},
    [I(234,52)] = {31,0x7FFFFB9A},
    [I(235,52)] = {31,0x7FFFFBDA},
    [I(236,52)] = {30,0x3FFFFD1A},
    [I(237,52)] = {30,0x3FFFFD5A},
    [I(238,52)] = {X32,0xFFFFFA9A},
    [I(239,52)] = {29,0x1FFFFD1A},
    [I(240,52)] = {X32,0xFFFFFADA},
    [I(241,52)] = {64,0},
    [I(242,52)] = {X32,0xFFFFFB1A},
    [I(243,52)] = {X32,0xFFFFFB5A},
    [I(244,52)] = {64,0},
    [I(245,52)] = {64,0},
    [I(246,52)] = {64,0},
    [I(247,52)] = {64,0},
    [I(248,52)] = {64,0},
    [I(249,52)] = {64,0},
    [I(250,52)] = {64,0},
    [I(251,52)] = {64,0},
    [I(252,52)] = {64,0},
    [I(253,52)] = {64,0},
    [I(254,52)] = {64,0},
    [I(255,52)] = {X32,0xFFFFFB9A},
    [I(0,53)] = {19,0x7FE1B},
    [I(1,53)] = {29,0x1FFFF61B},
    [I(2,53)] = {64,0},
    [I(3,53)] = {64,0},
    [I(4,53)] = {64,0},
    [I(5,53)] = {64,0},
    [I(6,53)] = {64,0},
    [I(7,53)] = {64,0},
    [I(8,53)] = {64,0},
    [I(9,53)] = {30,0x3FFFFA9B},
    [I(10,53)] = {64,0},
    [I(11,53)] = {64,0},
    [I(12,53)] = {64,0},
    [I(13,53)] = {64,0},
    [I(14,53)] = {64,0},
    [I(15,53)] = {64,0},
    [I(16,53)] = {64,0},
    [I(17,53)] = {64,0},
    [I(18,53)] = {64,0},
    [I(19,53)] = {64,0},
    [I(20,53)] = {64,0},
    [I(21,53)] = {64,0},
    [I(22,53)] = {64,0},
    [I(23,53)] = {64,0},
    [I(24,53)] = {64,0},
    [I(25,53)] = {64,0},
    [I(26,53)] = {64,0},
    [I(27,53)] = {64,0},
    [I(28,53)] = {64,0},
    [I(29,53)] = {64,0},
    [I(30,53)] = {64,0},
    [I(31,53)] = {64,0},
    [I(32,53)] = {12,0x51B},
    [I(33,53)] = {16,0xFE1B},
    [I(34,53)] = {16,0xFE5B},
    [I(35,53)] = {18,0x3FE9B},
    [I(36,53)] = {19,0x7FE5B},
    [I(37,53)] = {12,0x55B},
    [I(38,53)] = {14,0x3E1B},
    [I(39,53)] = {17,0x1FE9B},
    [I(40,53)] = {16,0xFE9B},
    [I(41,53)] = {16,0xFEDB},
    [I(42,53)] = {14,0x3E5B},
    [I(43,53)] = {17,0x1FEDB},
    [I(44,53)] = {14,0x3E9B},
    [I(45,53)] = {12,0x59B},
    [I(46,53)] = {12,0x5DB},
    [I(47,53)] = {12,0x61B},
    [I(48,53)] = {11,0x1B},
    [I(49,53)] = {11,0x5B},
    [I(50,53)] = {11,0x9B},
    [I(51,53)] = {12,0x65B},
    [I(52,53)] = {12,0x69B},
    [I(53,53)] = {12,0x6DB},
    [I(54,53)] = {12,0x71B},
    [I(55,53)] = {12,0x75B},
    [I(56,53)] = {12,0x79B},
    [I(57,53)] = {12,0x7DB},
    [I(58,53)] = {13,0x171B},
    [I(59,53)] = {14,0x3EDB},
    [I(60,53)] = {21,0x1FFF1B},
    [I(61,53)] = {12,0x81B},
    [I(62,53)] = {18,0x3FEDB},
    [I(63,53)] = {16,0xFF1B},
    [I(64,53)] = {19,0x7FE9B},
    [I(65,53)] = {12,0x85B},
    [I(66,53)] = {13,0x175B},
    [I(67,53)] = {13,0x179B},
    [I(68,53)] = {13,0x17DB},
    [I(69,53)] = {13,0x181B},
    [I(70,53)] = {13,0x185B},
    [I(71,53)] = {13,0x189B},
    [I(72,53)] = {13,0x18DB},
    [I(73,53)] = {13,0x191B},
    [I(74,53)] = {13,0x195B},
    [I(75,53)] = {13,0x199B},
    [I(76,53)] = {13,0x19DB},
    [I(77,53)] = {13,0x1A1B},
    [I(78,53)] = {13,0x1A5B},
    [I(79,53)] = {13,0x1A9B},
    [I(80,53)] = {13,0x1ADB},
    [I(81,53)] = {13,0x1B1B},
    [I(82,53)] = {13,0x1B5B},
    [I(83,53)] = {13,0x1B9B},
    [I(84,53)] = {13,0x1BDB},
    [I(85,53)] = {13,0x1C1B},
    [I(86,53)] = {13,0x1C5B},
    [I(87,53)] = {13,0x1C9B},
    [I(88,53)] = {14,0x3F1B},
    [I(89,53)] = {13,0x1CDB},
    [I(90,53)] = {14,0x3F5B},
    [I(91,53)] = {19,0x7FEDB},
    [I(92,53)] = {25,0x1FFFC1B},
    [I(93,53)] = {19,0x7FF1B},
    [I(94,53)] = {20,0xFFF1B},
    [I(95,53)] = {12,0x89B},
    [I(96,53)] = {21,0x1FFF5B},
    [I(97,53)] = {11,0xDB},
    [I(98,53)] = {12,0x8DB},
    [I(99,53)] = {11,0x11B},
    [I(100,53)] = {12,0x91B},
    [I(101,53)] = {11,0x15B},
    [I(102,53)] = {12,0x95B},
    [I(103,53)] = {12,0x99B},
    [I(104,53)] = {12,0x9DB},
    [I(105,53)] = {11,0x19B},
    [I(106,53)] = {13,0x1D1B},
    [I(107,53)] = {13,0x1D5B},
    [I(108,53)] = {12,0xA1B},
    [I(109,53)] = {12,0xA5B},
    [I(110,53)] = {12,0xA9B},
    [I(111,53)] = {11,0x1DB},
    [I(112,53)] = {12,0xADB},
    [I(113,53)] = {13,0x1D9B},
    [I(114,53)] = {12,0xB1B},
    [I(115,53)] = {11,0x21B},
    [I(116,53)] = {11,0x25B},
    [I(117,53)] = {12,0xB5B},
    [I(118,53)] = {13,0x1DDB},
    [I(119,53)] = {13,0x1E1B},
    [I(120,53)] = {13,0x1E5B},
    [I(121,53)] = {13,0x1E9B},
    [I(122,53)] = {13,0x1EDB},
    [I(123,53)] = {21,0x1FFF9B},
    [I(124,53)] = {17,0x1FF1B},
    [I(125,53)] = {20,0xFFF5B},
    [I(126,53)] = {19,0x7FF5B},
    [I(127,53)] = {64,0},
    [I(128,53)] = {26,0x3FFF99B},
    [I(129,53)] = {28,0xFFFF49B},
    [I(130,53)] = {26,0x3FFF9DB},
    [I(131,53)] = {26,0x3FFFA1B},
    [I(132,53)] = {28,0xFFFF4DB},
    [I(133,53)] = {28,0xFFFF51B},
    [I(134,53)] = {28,0xFFFF55B},
    [I(135,53)] = {29,0x1FFFF65B},
    [I(136,53)] = {28,0xFFFF59B},
    [I(137,53)] = {29,0x1FFFF69B},
    [I(138,53)] = {29,0x1FFFF6DB},
    [I(139,53)] = {29,0x1FFFF71B},
    [I(140,53)] = {29,0x1FFFF75B},
    [I(141,53)] = {29,0x1FFFF79B},
    [I(142,53)] = {30,0x3FFFFADB},
    [I(143,53)] = {29,0x1FFFF7DB},
    [I(144,53)] = {30,0x3FFFFB1B},
    [I(145,53)] = {30,0x3FFFFB5B},
    [I(146,53)] = {28,0xFFFF5DB},
    [I(147,53)] = {29,0x1FFFF81B},
    [I(148,53)] = {30,0x3FFFFB9B},
    [I(149,53)] = {29,0x1FFFF85B},
    [I(150,53)] = {29,0x1FFFF89B},
    [I(151,53)] = {29,0x1FFFF8DB},
    [I(152,53)] = {29,0x1FFFF91B},
    [I(153,53)] = {27,0x7FFF71B},
    [I(154,53)] = {28,0xFFFF61B},
    [I(155,53)] = {29,0x1FFFF95B},
    [I(156,53)] = {28,0xFFFF65B},
    [I(157,53)] = {29,0x1FFFF99B},
    [I(158,53)] = {29,0x1FFFF9DB},
    [I(159,53)] = {30,0x3FFFFBDB},
    [I(160,53)] = {28,0xFFFF69B},
    [I(161,53)] = {27,0x7FFF75B},
    [I(162,53)] = {26,0x3FFFA5B},
    [I(163,53)] = {28,0xFFFF6DB},
    [I(164,53)] = {28,0xFFFF71B},
    [I(165,53)] = {29,0x1FFFFA1B},
    [I(166,53)] = {29,0x1FFFFA5B},
    [I(167,53)] = {27,0x7FFF79B},
    [I(168,53)] = {29,0x1FFFFA9B},
    [I(169,53)] = {28,0xFFFF75B},
    [I(170,53)] = {28,0xFFFF79B},
    [I(171,53)] = {30,0x3FFFFC1B},
    [I(172,53)] = {27,0x7FFF7DB},
    [I(173,53)] = {28,0xFFFF7DB},
    [I(174,53)] = {29,0x1FFFFADB},
    [I(175,53)] = {29,0x1FFFFB1B},
    [I(176,53)] = {27,0x7FFF81B},
    [I(177,53)] = {27,0x7FFF85B},
    [I(178,53)] = {28,0xFFFF81B},
    [I(179,53)] = {27,0x7FFF89B},
    [I(180,53)] = {29,0x1FFFFB5B},
    [I(181,53)] = {28,0xFFFF85B},
    [I(182,53)] = {29,0x1FFFFB9B},
    [I(183,53)] = {29,0x1FFFFBDB},
    [I(184,53)] = {26,0x3FFFA9B},
    [I(185,53)] = {28,0xFFFF89B},
    [I(186,53)] = {28,0xFFFF8DB},
    [I(187,53)] = {28,0xFFFF91B},
    [I(188,53)] = {29,0x1FFFFC1B},
    [I(189,53)] = {28,0xFFFF95B},
    [I(190,53)] = {28,0xFFFF99B},
    [I(191,53)] = {29,0x1FFFFC5B},
    [I(192,53)] = {X32,0xFFFFF81B},
    [I(193,53)] = {X32,0xFFFFF85B},
    [I(194,53)] = {26,0x3FFFADB},
    [I(195,53)] = {25,0x1FFFC5B},
    [I(196,53)] = {28,0xFFFF9DB},
    [I(197,53)] = {29,0x1FFFFC9B},
    [I(198,53)] = {28,0xFFFFA1B},
    [I(199,53)] = {31,0x7FFFFB1B},
    [I(200,53)] = {X32,0xFFFFF89B},
    [I(201,53)] = {X32,0xFFFFF8DB},
    [I(202,53)] = {X32,0xFFFFF91B},
    [I(203,53)] = {64,0},
    [I(204,53)] = {64,0},
    [I(205,53)] = {X32,0xFFFFF95B},
    [I(206,53)] = {30,0x3FFFFC5B},
    [I(207,53)] = {31,0x7FFFFB5B},
    [I(208,53)] = {25,0x1FFFC9B},
    [I(209,53)] = {27,0x7FFF8DB},
    [I(210,53)] = {X32,0xFFFFF99B},
    [I(211,53)] = {64,0},
    [I(212,53)] = {64,0},
    [I(213,53)] = {X32,0xFFFFF9DB},
    [I(214,53)] = {64,0},
    [I(215,53)] = {30,0x3FFFFC9B},
    [I(216,53)] = {27,0x7FFF91B},
    [I(217,53)] = {27,0x7FFF95B},
    [I(218,53)] = {X32,0xFFFFFA1B},
    [I(219,53)] = {X32,0xFFFFFA5B},
    [I(220,53)] = {64,0},
    [I(221,53)] = {64,0},
    [I(222,53)] = {64,0},
    [I(223,53)] = {64,0},
    [I(224,53)] = {26,0x3FFFB1B},
    [I(225,53)] = {30,0x3FFFFCDB},
    [I(226,53)] = {26,0x3FFFB5B},
    [I(227,53)] = {27,0x7FFF99B},
    [I(228,53)] = {28,0xFFFFA5B},
    [I(229,53)] = {27,0x7FFF9DB},
    [I(230,53)] = {27,0x7FFFA1B},
    [I(231,53)] = {29,0x1FFFFCDB},
    [I(232,53)] = {28,0xFFFFA9B},
    [I(233,53)] = {28,0xFFFFADB},
    [I(234,53)] = {31,0x7FFFFB9B},
    [I(235,53)] = {31,0x7FFFFBDB},
    [I(236,53)] = {30,0x3FFFFD1B},
    [I(237,53)] = {30,0x3FFFFD5B},
    [I(238,53)] = {X32,0xFFFFFA9B},
    [I(239,53)] = {29,0x1FFFFD1B},
    [I(240,53)] = {X32,0xFFFFFADB},
    [I(241,53)] = {64,0},
    [I(242,53)] = {X32,0xFFFFFB1B},
    [I(243,53)] = {X32,0xFFFFFB5B},
    [I(244,53)] = {64,0},
    [I(245,53)] = {64,0},
    [I(246,53)] = {64,0},
    [I(247,53)] = {64,0},
    [I(248,53)] = {64,0},
    [I(249,53)] = {64,0},
    [I(250,53)] = {64,0},
    [I(251,53)] = {64,0},
    [I(252,53)] = {64,0},
    [I(253,53)] = {64,0},
    [I(254,53)] = {64,0},
    [I(255,53)] = {X32,0xFFFFFB9B},
    [I(0,54)] = {19,0x7FE1C},
    [I(1,54)] = {29,0x1FFFF61C},
    [I(2,54)] = {64,0},
    [I(3,54)] = {64,0},
    [I(4,54)] = {64,0},
    [I(5,54)] = {64,0},
    [I(6,54)] = {64,0},
    [I(7,54)] = {64,0},
    [I(8,54)] = {64,0},
    [I(9,54)] = {30,0x3FFFFA9C},
    [I(10,54)] = {64,0},
    [I(11,54)] = {64,0},
    [I(12,54)] = {64,0},
    [I(13,54)] = {64,0},
    [I(14,54)] = {64,0},
    [I(15,54)] = {64,0},
    [I(16,54)] = {64,0},
    [I(17,54)] = {64,0},
    [I(18,54)] = {64,0},
    [I(19,54)] = {64,0},
    [I(20,54)] = {64,0},
    [I(21,54)] = {64,0},
    [I(22,54)] = {64,0},
    [I(23,54)] = {64,0},
    [I(24,54)] = {64,0},
    [I(25,54)] = {64,0},
    [I(26,54)] = {64,0},
    [I(27,54)] = {64,0},
    [I(28,54)] = {64,0},
    [I(29,54)] = {64,0},
    [I(30,54)] = {64,0},
    [I(31,54)] = {64,0},
    [I(32,54)] = {12,0x51C},
    [I(33,54)] = {16,0xFE1C},
    [I(34,54)] = {16,0xFE5C},
    [I(35,54)] = {18,0x3FE9C},
    [I(36,54)] = {19,0x7FE5C},
    [I(37,54)] = {12,0x55C},
    [I(38,54)] = {14,0x3E1C},
    [I(39,54)] = {17,0x1FE9C},
    [I(40,54)] = {16,0xFE9C},
    [I(41,54)] = {16,0xFEDC},
    [I(42,54)] = {14,0x3E5C},
    [I(43,54)] = {17,0x1FEDC},
    [I(44,54)] = {14,0x3E9C},
    [I(45,54)] = {12,0x59C},
    [I(46,54)] = {12,0x5DC},
    [I(47,54)] = {12,0x61C},
    [I(48,54)] = {11,0x1C},
    [I(49,54)] = {11,0x5C},
    [I(50,54)] = {11,0x9C},
    [I(51,54)] = {12,0x65C},
    [I(52,54)] = {12,0x69C},
    [I(53,54)] = {12,0x6DC},
    [I(54,54)] = {12,0x71C},
    [I(55,54)] = {12,0x75C},
    [I(56,54)] = {12,0x79C},
    [I(57,54)] = {12,0x7DC},
    [I(58,54)] = {13,0x171C},
    [I(59,54)] = {14,0x3EDC},
    [I(60,54)] = {21,0x1FFF1C},
    [I(61,54)] = {12,0x81C},
    [I(62,54)] = {18,0x3FEDC},
    [I(63,54)] = {16,0xFF1C},
    [I(64,54)] = {19,0x7FE9C},
    [I(65,54)] = {12,0x85C},
    [I(66,54)] = {13,0x175C},
    [I(67,54)] = {13,0x179C},
    [I(68,54)] = {13,0x17DC},
    [I(69,54)] = {13,0x181C},
    [I(70,54)] = {13,0x185C},
    [I(71,54)] = {13,0x189C},
    [I(72,54)] = {13,0x18DC},
    [I(73,54)] = {13,0x191C},
    [I(74,54)] = {13,0x195C},
    [I(75,54)] = {13,0x199C},
    [I(76,54)] = {13,0x19DC},
    [I(77,54)] = {13,0x1A1C},
    [I(78,54)] = {13,0x1A5C},
    [I(79,54)] = {13,0x1A9C},
    [I(80,54)] = {13,0x1ADC},
    [I(81,54)] = {13,0x1B1C},
    [I(82,54)] = {13,0x1B5C},
    [I(83,54)] = {13,0x1B9C},
    [I(84,54)] = {13,0x1BDC},
    [I(85,54)] = {13,0x1C1C},
    [I(86,54)] = {13,0x1C5C},
    [I(87,54)] = {13,0x1C9C},
    [I(88,54)] = {14,0x3F1C},
    [I(89,54)] = {13,0x1CDC},
    [I(90,54)] = {14,0x3F5C},
    [I(91,54)] = {19,0x7FEDC},
    [I(92,54)] = {25,0x1FFFC1C},
    [I(93,54)] = {19,0x7FF1C},
    [I(94,54)] = {20,0xFFF1C},
    [I(95,54)] = {12,0x89C},
    [I(96,54)] = {21,0x1FFF5C},
    [I(97,54)] = {11,0xDC},
    [I(98,54)] = {12,0x8DC},
    [I(99,54)] = {11,0x11C},
    [I(100,54)] = {12,0x91C},
    [I(101,54)] = {11,0x15C},
    [I(102,54)] = {12,0x95C},
    [I(103,54)] = {12,0x99C},
    [I(104,54)] = {12,0x9DC},
    [I(105,54)] = {11,0x19C},
    [I(106,54)] = {13,0x1D1C},
    [I(107,54)] = {13,0x1D5C},
    [I(108,54)] = {12,0xA1C},
    [I(109,54)] = {12,0xA5C},
    [I(110,54)] = {12,0xA9C},
    [I(111,54)] = {11,0x1DC},
    [I(112,54)] = {12,0xADC},
    [I(113,54)] = {13,0x1D9C},
    [I(114,54)] = {12,0xB1C},
    [I(115,54)] = {11,0x21C},
    [I(116,54)] = {11,0x25C},
    [I(117,54)] = {12,0xB5C},
    [I(118,54)] = {13,0x1DDC},
    [I(119,54)] = {13,0x1E1C},
    [I(120,54)] = {13,0x1E5C},
    [I(121,54)] = {13,0x1E9C},
    [I(122,54)] = {13,0x1EDC},
    [I(123,54)] = {21,0x1FFF9C},
    [I(124,54)] = {17,0x1FF1C},
    [I(125,54)] = {20,0xFFF5C},
    [I(126,54)] = {19,0x7FF5C},
    [I(127,54)] = {64,0},
    [I(128,54)] = {26,0x3FFF99C},
    [I(129,54)] = {28,0xFFFF49C},
    [I(130,54)] = {26,0x3FFF9DC},
    [I(131,54)] = {26,0x3FFFA1C},
    [I(132,54)] = {28,0xFFFF4DC},
    [I(133,54)] = {28,0xFFFF51C},
    [I(134,54)] = {28,0xFFFF55C},
    [I(135,54)] = {29,0x1FFFF65C},
    [I(136,54)] = {28,0xFFFF59C},
    [I(137,54)] = {29,0x1FFFF69C},
    [I(138,54)] = {29,0x1FFFF6DC},
    [I(139,54)] = {29,0x1FFFF71C},
    [I(140,54)] = {29,0x1FFFF75C},
    [I(141,54)] = {29,0x1FFFF79C},
    [I(142,54)] = {30,0x3FFFFADC},
    [I(143,54)] = {29,0x1FFFF7DC},
    [I(144,54)] = {30,0x3FFFFB1C},
    [I(145,54)] = {30,0x3FFFFB5C},
    [I(146,54)] = {28,0xFFFF5DC},
    [I(147,54)] = {29,0x1FFFF81C},
    [I(148,54)] = {30,0x3FFFFB9C},
    [I(149,54)] = {29,0x1FFFF85C},
    [I(150,54)] = {29,0x1FFFF89C},
    [I(151,54)] = {29,0x1FFFF8DC},
    [I(152,54)] = {29,0x1FFFF91C},
    [I(153,54)] = {27,0x7FFF71C},
    [I(154,54)] = {28,0xFFFF61C},
    [I(155,54)] = {29,0x1FFFF95C},
    [I(156,54)] = {28,0xFFFF65C},
    [I(157,54)] = {29,0x1FFFF99C},
    [I(158,54)] = {29,0x1FFFF9DC},
    [I(159,54)] = {30,0x3FFFFBDC},
    [I(160,54)] = {28,0xFFFF69C},
    [I(161,54)] = {27,0x7FFF75C},
    [I(162,54)] = {26,0x3FFFA5C},
    [I(163,54)] = {28,0xFFFF6DC},
    [I(164,54)] = {28,0xFFFF71C},
    [I(165,54)] = {29,0x1FFFFA1C},
    [I(166,54)] = {29,0x1FFFFA5C},
    [I(167,54)] = {27,0x7FFF79C},
    [I(168,54)] = {29,0x1FFFFA9C},
    [I(169,54)] = {28,0xFFFF75C},
    [I(170,54)] = {28,0xFFFF79C},
    [I(171,54)] = {30,0x3FFFFC1C},
    [I(172,54)] = {27,0x7FFF7DC},
    [I(173,54)] = {28,0xFFFF7DC},
    [I(174,54)] = {29,0x1FFFFADC},
    [I(175,54)] = {29,0x1FFFFB1C},
    [I(176,54)] = {27,0x7FFF81C},
    [I(177,54)] = {27,0x7FFF85C},
    [I(178,54)] = {28,0xFFFF81C},
    [I(179,54)] = {27,0x7FFF89C},
    [I(180,54)] = {29,0x1FFFFB5C},
    [I(181,54)] = {28,0xFFFF85C},
    [I(182,54)] = {29,0x1FFFFB9C},
    [I(183,54)] = {29,0x1FFFFBDC},
    [I(184,54)] = {26,0x3FFFA9C},
    [I(185,54)] = {28,0xFFFF89C},
    [I(186,54)] = {28,0xFFFF8DC},
    [I(187,54)] = {28,0xFFFF91C},
    [I(188,54)] = {29,0x1FFFFC1C},
    [I(189,54)] = {28,0xFFFF95C},
    [I(190,54)] = {28,0xFFFF99C},
    [I(191,54)] = {29,0x1FFFFC5C},
    [I(192,54)] = {X32,0xFFFFF81C},
    [I(193,54)] = {X32,0xFFFFF85C},
    [I(194,54)] = {26,0x3FFFADC},
    [I(195,54)] = {25,0x1FFFC5C},
    [I(196,54)] = {28,0xFFFF9DC},
    [I(197,54)] = {29,0x1FFFFC9C},
    [I(198,54)] = {28,0xFFFFA1C},
    [I(199,54)] = {31,0x7FFFFB1C},
    [I(200,54)] = {X32,0xFFFFF89C},
    [I(201,54)] = {X32,0xFFFFF8DC},
    [I(202,54)] = {X32,0xFFFFF91C},
    [I(203,54)] = {64,0},
    [I(204,54)] = {64,0},
    [I(205,54)] = {X32,0xFFFFF95C},
    [I(206,54)] = {30,0x3FFFFC5C},
    [I(207,54)] = {31,0x7FFFFB5C},
    [I(208,54)] = {25,0x1FFFC9C},
    [I(209,54)] = {27,0x7FFF8DC},
    [I(210,54)] = {X32,0xFFFFF99C},
    [I(211,54)] = {64,0},
    [I(212,54)] = {64,0},
    [I(213,54)] = {X32,0xFFFFF9DC},
    [I(214,54)] = {64,0},
    [I(215,54)] = {30,0x3FFFFC9C},
    [I(216,54)] = {27,0x7FFF91C},
    [I(217,54)] = {27,0x7FFF95C},
    [I(218,54)] = {X32,0xFFFFFA1C},
    [I(219,54)] = {X32,0xFFFFFA5C},
    [I(220,54)] = {64,0},
    [I(221,54)] = {64,0},
    [I(222,54)] = {64,0},
    [I(223,54)] = {64,0},
    [I(224,54)] = {26,0x3FFFB1C},
    [I(225,54)] = {30,0x3FFFFCDC},
    [I(226,54)] = {26,0x3FFFB5C},
    [I(227,54)] = {27,0x7FFF99C},
    [I(228,54)] = {28,0xFFFFA5C},
    [I(229,54)] = {27,0x7FFF9DC},
    [I(230,54)] = {27,0x7FFFA1C},
    [I(231,54)] = {29,0x1FFFFCDC},
    [I(232,54)] = {28,0xFFFFA9C},
    [I(233,54)] = {28,0xFFFFADC},
    [I(234,54)] = {31,0x7FFFFB9C},
    [I(235,54)] = {31,0x7FFFFBDC},
    [I(236,54)] = {30,0x3FFFFD1C},
    [I(237,54)] = {30,0x3FFFFD5C},
    [I(238,54)] = {X32,0xFFFFFA9C},
    [I(239,54)] = {29,0x1FFFFD1C},
    [I(240,54)] = {X32,0xFFFFFADC},
    [I(241,54)] = {64,0},
    [I(242,54)] = {X32,0xFFFFFB1C},
    [I(243,54)] = {X32,0xFFFFFB5C},
    [I(244,54)] = {64,0},
    [I(245,54)] = {64,0},
    [I(246,54)] = {64,0},
    [I(247,54)] = {64,0},
    [I(248,54)] = {64,0},
    [I(249,54)] = {64,0},
    [I(250,54)] = {64,0},
    [I(251,54)] = {64,0},
    [I(252,54)] = {64,0},
    [I(253,54)] = {64,0},
    [I(254,54)] = {64,0},
    [I(255,54)] = {X32,0xFFFFFB9C},
    [I(0,55)] = {19,0x7FE1D},
    [I(1,55)] = {29,0x1FFFF61D},
    [I(2,55)] = {64,0},
    [I(3,55)] = {64,0},
    [I(4,55)] = {64,0},
    [I(5,55)] = {64,0},
    [I(6,55)] = {64,0},
    [I(7,55)] = {64,0},
    [I(8,55)] = {64,0},
    [I(9,55)] = {30,0x3FFFFA9D},
    [I(10,55)] = {64,0},
    [I(11,55)] = {64,0},
    [I(12,55)] = {64,0},
    [I(13,55)] = {64,0},
    [I(14,55)] = {64,0},
    [I(15,55)] = {64,0},
    [I(16,55)] = {64,0},
    [I(17,55)] = {64,0},
    [I(18,55)] = {64,0},
    [I(19,55)] = {64,0},
    [I(20,55)] = {64,0},
    [I(21,55)] = {64,0},
    [I(22,55)] = {64,0},
    [I(23,55)] = {64,0},
    [I(24,55)] = {64,0},
    [I(25,55)] = {64,0},
    [I(26,55)] = {64,0},
    [I(27,55)] = {64,0},
    [I(28,55)] = {64,0},
    [I(29,55)] = {64,0},
    [I(30,55)] = {64,0},
    [I(31,55)] = {64,0},
    [I(32,55)] = {12,0x51D},
    [I(33,55)] = {16,0xFE1D},
    [I(34,55)] = {16,0xFE5D},
    [I(35,55)] = {18,0x3FE9D},
    [I(36,55)] = {19,0x7FE5D},
    [I(37,55)] = {12,0x55D},
    [I(38,55)] = {14,0x3E1D},
    [I(39,55)] = {17,0x1FE9D},
    [I(40,55)] = {16,0xFE9D},
    [I(41,55)] = {16,0xFEDD},
    [I(42,55)] = {14,0x3E5D},
    [I(43,55)] = {17,0x1FEDD},
    [I(44,55)] = {14,0x3E9D},
    [I(45,55)] = {12,0x59D},
    [I(46,55)] = {12,0x5DD},
    [I(47,55)] = {12,0x61D},
    [I(48,55)] = {11,0x1D},
    [I(49,55)] = {11,0x5D},
    [I(50,55)] = {11,0x9D},
    [I(51,55)] = {12,0x65D},
    [I(52,55)] = {12,0x69D},
    [I(53,55)] = {12,0x6DD},
    [I(54,55)] = {12,0x71D},
    [I(55,55)] = {12,0x75D},
    [I(56,55)] = {12,0x79D},
    [I(57,55)] = {12,0x7DD},
    [I(58,55)] = {13,0x171D},
    [I(59,55)] = {14,0x3EDD},
    [I(60,55)] = {21,0x1FFF1D},
    [I(61,55)] = {12,0x81D},
    [I(62,55)] = {18,0x3FEDD},
    [I(63,55)] = {16,0xFF1D},
    [I(64,55)] = {19,0x7FE9D},
    [I(65,55)] = {12,0x85D},
    [I(66,55)] = {13,0x175D},
    [I(67,55)] = {13,0x179D},
    [I(68,55)] = {13,0x17DD},
    [I(69,55)] = {13,0x181D},
    [I(70,55)] = {13,0x185D},
    [I(71,55)] = {13,0x189D},
    [I(72,55)] = {13,0x18DD},
    [I(73,55)] = {13,0x191D},
    [I(74,55)] = {13,0x195D},
    [I(75,55)] = {13,0x199D},
    [I(76,55)] = {13,0x19DD},
    [I(77,55)] = {13,0x1A1D},
    [I(78,55)] = {13,0x1A5D},
    [I(79,55)] = {13,0x1A9D},
    [I(80,55)] = {13,0x1ADD},
    [I(81,55)] = {13,0x1B1D},
    [I(82,55)] = {13,0x1B5D},
    [I(83,55)] = {13,0x1B9D},
    [I(84,55)] = {13,0x1BDD},
    [I(85,55)] = {13,0x1C1D},
    [I(86,55)] = {13,0x1C5D},
    [I(87,55)] = {13,0x1C9D},
    [I(88,55)] = {14,0x3F1D},
    [I(89,55)] = {13,0x1CDD},
    [I(90,55)] = {14,0x3F5D},
    [I(91,55)] = {19,0x7FEDD},
    [I(92,55)] = {25,0x1FFFC1D},
    [I(93,55)] = {19,0x7FF1D},
    [I(94,55)] = {20,0xFFF1D},
    [I(95,55)] = {12,0x89D},
    [I(96,55)] = {21,0x1FFF5D},
    [I(97,55)] = {11,0xDD},
    [I(98,55)] = {12,0x8DD},
    [I(99,55)] = {11,0x11D},
    [I(100,55)] = {12,0x91D},
    [I(101,55)] = {11,0x15D},
    [I(102,55)] = {12,0x95D},
    [I(103,55)] = {12,0x99D},
    [I(104,55)] = {12,0x9DD},
    [I(105,55)] = {11,0x19D},
    [I(106,55)] = {13,0x1D1D},
    [I(107,55)] = {13,0x1D5D},
    [I(108,55)] = {12,0xA1D},
    [I(109,55)] = {12,0xA5D},
    [I(110,55)] = {12,0xA9D},
    [I(111,55)] = {11,0x1DD},
    [I(112,55)] = {12,0xADD},
    [I(113,55)] = {13,0x1D9D},
    [I(114,55)] = {12,0xB1D},
    [I(115,55)] = {11,0x21D},
    [I(116,55)] = {11,0x25D},
    [I(117,55)] = {12,0xB5D},
    [I(118,55)] = {13,0x1DDD},
    [I(119,55)] = {13,0x1E1D},
    [I(120,55)] = {13,0x1E5D},
    [I(121,55)] = {13,0x1E9D},
    [I(122,55)] = {13,0x1EDD},
    [I(123,55)] = {21,0x1FFF9D},
    [I(124,55)] = {17,0x1FF1D},
    [I(125,55)] = {20,0xFFF5D},
    [I(126,55)] = {19,0x7FF5D},
    [I(127,55)] = {64,0},
    [I(128,55)] = {26,0x3FFF99D},
    [I(129,55)] = {28,0xFFFF49D},
    [I(130,55)] = {26,0x3FFF9DD},
    [I(131,55)] = {26,0x3FFFA1D},
    [I(132,55)] = {28,0xFFFF4DD},
    [I(133,55)] = {28,0xFFFF51D},
    [I(134,55)] = {28,0xFFFF55D},
    [I(135,55)] = {29,0x1FFFF65D},
    [I(136,55)] = {28,0xFFFF59D},
    [I(137,55)] = {29,0x1FFFF69D},
    [I(138,55)] = {29,0x1FFFF6DD},
    [I(139,55)] = {29,0x1FFFF71D},
    [I(140,55)] = {29,0x1FFFF75D},
    [I(141,55)] = {29,0x1FFFF79D},
    [I(142,55)] = {30,0x3FFFFADD},
    [I(143,55)] = {29,0x1FFFF7DD},
    [I(144,55)] = {30,0x3FFFFB1D},
    [I(145,55)] = {30,0x3FFFFB5D},
    [I(146,55)] = {28,0xFFFF5DD},
    [I(147,55)] = {29,0x1FFFF81D},
    [I(148,55)] = {30,0x3FFFFB9D},
    [I(149,55)] = {29,0x1FFFF85D},
    [I(150,55)] = {29,0x1FFFF89D},
    [I(151,55)] = {29,0x1FFFF8DD},
    [I(152,55)] = {29,0x1FFFF91D},
    [I(153,55)] = {27,0x7FFF71D},
    [I(154,55)] = {28,0xFFFF61D},
    [I(155,55)] = {29,0x1FFFF95D},
    [I(156,55)] = {28,0xFFFF65D},
    [I(157,55)] = {29,0x1FFFF99D},
    [I(158,55)] = {29,0x1FFFF9DD},
    [I(159,55)] = {30,0x3FFFFBDD},
    [I(160,55)] = {28,0xFFFF69D},
    [I(161,55)] = {27,0x7FFF75D},
    [I(162,55)] = {26,0x3FFFA5D},
    [I(163,55)] = {28,0xFFFF6DD},
    [I(164,55)] = {28,0xFFFF71D},
    [I(165,55)] = {29,0x1FFFFA1D},
    [I(166,55)] = {29,0x1FFFFA5D},
    [I(167,55)] = {27,0x7FFF79D},
    [I(168,55)] = {29,0x1FFFFA9D},
    [I(169,55)] = {28,0xFFFF75D},
    [I(170,55)] = {28,0xFFFF79D},
    [I(171,55)] = {30,0x3FFFFC1D},
    [I(172,55)] = {27,0x7FFF7DD},
    [I(173,55)] = {28,0xFFFF7DD},
    [I(174,55)] = {29,0x1FFFFADD},
    [I(175,55)] = {29,0x1FFFFB1D},
    [I(176,55)] = {27,0x7FFF81D},
    [I(177,55)] = {27,0x7FFF85D},
    [I(178,55)] = {28,0xFFFF81D},
    [I(179,55)] = {27,0x7FFF89D},
    [I(180,55)] = {29,0x1FFFFB5D},
    [I(181,55)] = {28,0xFFFF85D},
    [I(182,55)] = {29,0x1FFFFB9D},
    [I(183,55)] = {29,0x1FFFFBDD},
    [I(184,55)] = {26,0x3FFFA9D},
    [I(185,55)] = {28,0xFFFF89D},
    [I(186,55)] = {28,0xFFFF8DD},
    [I(187,55)] = {28,0xFFFF91D},
    [I(188,55)] = {29,0x1FFFFC1D},
    [I(189,55)] = {28,0xFFFF95D},
    [I(190,55)] = {28,0xFFFF99D},
    [I(191,55)] = {29,0x1FFFFC5D},
    [I(192,55)] = {X32,0xFFFFF81D},
    [I(193,55)] = {X32,0xFFFFF85D},
    [I(194,55)] = {26,0x3FFFADD},
    [I(195,55)] = {25,0x1FFFC5D},
    [I(196,55)] = {28,0xFFFF9DD},
    [I(197,55)] = {29,0x1FFFFC9D},
    [I(198,55)] = {28,0xFFFFA1D},
    [I(199,55)] = {31,0x7FFFFB1D},
    [I(200,55)] = {X32,0xFFFFF89D},
    [I(201,55)] = {X32,0xFFFFF8DD},
    [I(202,55)] = {X32,0xFFFFF91D},
    [I(203,55)] = {64,0},
    [I(204,55)] = {64,0},
    [I(205,55)] = {X32,0xFFFFF95D},
    [I(206,55)] = {30,0x3FFFFC5D},
    [I(207,55)] = {31,0x7FFFFB5D},
    [I(208,55)] = {25,0x1FFFC9D},
    [I(209,55)] = {27,0x7FFF8DD},
    [I(210,55)] = {X32,0xFFFFF99D},
    [I(211,55)] = {64,0},
    [I(212,55)] = {64,0},
    [I(213,55)] = {X32,0xFFFFF9DD},
    [I(214,55)] = {64,0},
    [I(215,55)] = {30,0x3FFFFC9D},
    [I(216,55)] = {27,0x7FFF91D},
    [I(217,55)] = {27,0x7FFF95D},
    [I(218,55)] = {X32,0xFFFFFA1D},
    [I(219,55)] = {X32,0xFFFFFA5D},
    [I(220,55)] = {64,0},
    [I(221,55)] = {64,0},
    [I(222,55)] = {64,0},
    [I(223,55)] = {64,0},
    [I(224,55)] = {26,0x3FFFB1D},
    [I(225,55)] = {30,0x3FFFFCDD},
    [I(226,55)] = {26,0x3FFFB5D},
    [I(227,55)] = {27,0x7FFF99D},
    [I(228,55)] = {28,0xFFFFA5D},
    [I(229,55)] = {27,0x7FFF9DD},
    [I(230,55)] = {27,0x7FFFA1D},
    [I(231,55)] = {29,0x1FFFFCDD},
    [I(232,55)] = {28,0xFFFFA9D},
    [I(233,55)] = {28,0xFFFFADD},
    [I(234,55)] = {31,0x7FFFFB9D},
    [I(235,55)] = {31,0x7FFFFBDD},
    [I(236,55)] = {30,0x3FFFFD1D},
    [I(237,55)] = {30,0x3FFFFD5D},
    [I(238,55)] = {X32,0xFFFFFA9D},
    [I(239,55)] = {29,0x1FFFFD1D},
    [I(240,55)] = {X32,0xFFFFFADD},
    [I(241,55)] = {64,0},
    [I(242,55)] = {X32,0xFFFFFB1D},
    [I(243,55)] = {X32,0xFFFFFB5D},
    [I(244,55)] = {64,0},
    [I(245,55)] = {64,0},
    [I(246,55)] = {64,0},
    [I(247,55)] = {64,0},
    [I(248,55)] = {64,0},
    [I(249,55)] = {64,0},
    [I(250,55)] = {64,0},
    [I(251,55)] = {64,0},
    [I(252,55)] = {64,0},
    [I(253,55)] = {64,0},
    [I(254,55)] = {64,0},
    [I(255,55)] = {X32,0xFFFFFB9D},
    [I(0,56)] = {19,0x7FE1E},
    [I(1,56)] = {29,0x1FFFF61E},
    [I(2,56)] = {64,0},
    [I(3,56)] = {64,0},
    [I(4,56)] = {64,0},
    [I(5,56)] = {64,0},
    [I(6,56)] = {64,0},
    [I(7,56)] = {64,0},
    [I(8,56)] = {64,0},
    [I(9,56)] = {30,0x3FFFFA9E},
    [I(10,56)] = {64,0},
    [I(11,56)] = {64,0},
    [I(12,56)] = {64,0},
    [I(13,56)] = {64,0},
    [I(14,56)] = {64,0},
    [I(15,56)] = {64,0},
    [I(16,56)] = {64,0},
    [I(17,56)] = {64,0},
    [I(18,56)] = {64,0},
    [I(19,56)] = {64,0},
    [I(20,56)] = {64,0},
    [I(21,56)] = {64,0},
    [I(22,56)] = {64,0},
    [I(23,56)] = {64,0},
    [I(24,56)] = {64,0},
    [I(25,56)] = {64,0},
    [I(26,56)] = {64,0},
    [I(27,56)] = {64,0},
    [I(28,56)] = {64,0},
    [I(29,56)] = {64,0},
    [I(30,56)] = {64,0},
    [I(31,56)] = {64,0},
    [I(32,56)] = {12,0x51E},
    [I(33,56)] = {16,0xFE1E},
    [I(34,56)] = {16,0xFE5E},
    [I(35,56)] = {18,0x3FE9E},
    [I(36,56)] = {19,0x7FE5E},
    [I(37,56)] = {12,0x55E},
    [I(38,56)] = {14,0x3E1E},
    [I(39,56)] = {17,0x1FE9E},
    [I(40,56)] = {16,0xFE9E},
    [I(41,56)] = {16,0xFEDE},
    [I(42,56)] = {14,0x3E5E},
    [I(43,56)] = {17,0x1FEDE},
    [I(44,56)] = {14,0x3E9E},
    [I(45,56)] = {12,0x59E},
    [I(46,56)] = {12,0x5DE},
    [I(47,56)] = {12,0x61E},
    [I(48,56)] = {11,0x1E},
    [I(49,56)] = {11,0x5E},
    [I(50,56)] = {11,0x9E},
    [I(51,56)] = {12,0x65E},
    [I(52,56)] = {12,0x69E},
    [I(53,56)] = {12,0x6DE},
    [I(54,56)] = {12,0x71E},
    [I(55,56)] = {12,0x75E},
    [I(56,56)] = {12,0x79E},
    [I(57,56)] = {12,0x7DE},
    [I(58,56)] = {13,0x171E},
    [I(59,56)] = {14,0x3EDE},
    [I(60,56)] = {21,0x1FFF1E},
    [I(61,56)] = {12,0x81E},
    [I(62,56)] = {18,0x3FEDE},
    [I(63,56)] = {16,0xFF1E},
    [I(64,56)] = {19,0x7FE9E},
    [I(65,56)] = {12,0x85E},
    [I(66,56)] = {13,0x175E},
    [I(67,56)] = {13,0x179E},
    [I(68,56)] = {13,0x17DE},
    [I(69,56)] = {13,0x181E},
    [I(70,56)] = {13,0x185E},
    [I(71,56)] = {13,0x189E},
    [I(72,56)] = {13,0x18DE},
    [I(73,56)] = {13,0x191E},
    [I(74,56)] = {13,0x195E},
    [I(75,56)] = {13,0x199E},
    [I(76,56)] = {13,0x19DE},
    [I(77,56)] = {13,0x1A1E},
    [I(78,56)] = {13,0x1A5E},
    [I(79,56)] = {13,0x1A9E},
    [I(80,56)] = {13,0x1ADE},
    [I(81,56)] = {13,0x1B1E},
    [I(82,56)] = {13,0x1B5E},
    [I(83,56)] = {13,0x1B9E},
    [I(84,56)] = {13,0x1BDE},
    [I(85,56)] = {13,0x1C1E},
    [I(86,56)] = {13,0x1C5E},
    [I(87,56)] = {13,0x1C9E},
    [I(88,56)] = {14,0x3F1E},
    [I(89,56)] = {13,0x1CDE},
    [I(90,56)] = {14,0x3F5E},
    [I(91,56)] = {19,0x7FEDE},
    [I(92,56)] = {25,0x1FFFC1E},
    [I(93,56)] = {19,0x7FF1E},
    [I(94,56)] = {20,0xFFF1E},
    [I(95,56)] = {12,0x89E},
    [I(96,56)] = {21,0x1FFF5E},
    [I(97,56)] = {11,0xDE},
    [I(98,56)] = {12,0x8DE},
    [I(99,56)] = {11,0x11E},
    [I(100,56)] = {12,0x91E},
    [I(101,56)] = {11,0x15E},
    [I(102,56)] = {12,0x95E},
    [I(103,56)] = {12,0x99E},
    [I(104,56)] = {12,0x9DE},
    [I(105,56)] = {11,0x19E},
    [I(106,56)] = {13,0x1D1E},
    [I(107,56)] = {13,0x1D5E},
    [I(108,56)] = {12,0xA1E},
    [I(109,56)] = {12,0xA5E},
    [I(110,56)] = {12,0xA9E},
    [I(111,56)] = {11,0x1DE},
    [I(112,56)] = {12,0xADE},
    [I(113,56)] = {13,0x1D9E},
    [I(114,56)] = {12,0xB1E},
    [I(115,56)] = {11,0x21E},
    [I(116,56)] = {11,0x25E},
    [I(117,56)] = {12,0xB5E},
    [I(118,56)] = {13,0x1DDE},
    [I(119,56)] = {13,0x1E1E},
    [I(120,56)] = {13,0x1E5E},
    [I(121,56)] = {13,0x1E9E},
    [I(122,56)] = {13,0x1EDE},
    [I(123,56)] = {21,0x1FFF9E},
    [I(124,56)] = {17,0x1FF1E},
    [I(125,56)] = {20,0xFFF5E},
    [I(126,56)] = {19,0x7FF5E},
    [I(127,56)] = {64,0},
    [I(128,56)] = {26,0x3FFF99E},
    [I(129,56)] = {28,0xFFFF49E},
    [I(130,56)] = {26,0x3FFF9DE},
    [I(131,56)] = {26,0x3FFFA1E},
    [I(132,56)] = {28,0xFFFF4DE},
    [I(133,56)] = {28,0xFFFF51E},
    [I(134,56)] = {28,0xFFFF55E},
    [I(135,56)] = {29,0x1FFFF65E},
    [I(136,56)] = {28,0xFFFF59E},
    [I(137,56)] = {29,0x1FFFF69E},
    [I(138,56)] = {29,0x1FFFF6DE},
    [I(139,56)] = {29,0x1FFFF71E},
    [I(140,56)] = {29,0x1FFFF75E},
    [I(141,56)] = {29,0x1FFFF79E},
    [I(142,56)] = {30,0x3FFFFADE},
    [I(143,56)] = {29,0x1FFFF7DE},
    [I(144,56)] = {30,0x3FFFFB1E},
    [I(145,56)] = {30,0x3FFFFB5E},
    [I(146,56)] = {28,0xFFFF5DE},
    [I(147,56)] = {29,0x1FFFF81E},
    [I(148,56)] = {30,0x3FFFFB9E},
    [I(149,56)] = {29,0x1FFFF85E},
    [I(150,56)] = {29,0x1FFFF89E},
    [I(151,56)] = {29,0x1FFFF8DE},
    [I(152,56)] = {29,0x1FFFF91E},
    [I(153,56)] = {27,0x7FFF71E},
    [I(154,56)] = {28,0xFFFF61E},
    [I(155,56)] = {29,0x1FFFF95E},
    [I(156,56)] = {28,0xFFFF65E},
    [I(157,56)] = {29,0x1FFFF99E},
    [I(158,56)] = {29,0x1FFFF9DE},
    [I(159,56)] = {30,0x3FFFFBDE},
    [I(160,56)] = {28,0xFFFF69E},
    [I(161,56)] = {27,0x7FFF75E},
    [I(162,56)] = {26,0x3FFFA5E},
    [I(163,56)] = {28,0xFFFF6DE},
    [I(164,56)] = {28,0xFFFF71E},
    [I(165,56)] = {29,0x1FFFFA1E},
    [I(166,56)] = {29,0x1FFFFA5E},
    [I(167,56)] = {27,0x7FFF79E},
    [I(168,56)] = {29,0x1FFFFA9E},
    [I(169,56)] = {28,0xFFFF75E},
    [I(170,56)] = {28,0xFFFF79E},
    [I(171,56)] = {30,0x3FFFFC1E},
    [I(172,56)] = {27,0x7FFF7DE},
    [I(173,56)] = {28,0xFFFF7DE},
    [I(174,56)] = {29,0x1FFFFADE},
    [I(175,56)] = {29,0x1FFFFB1E},
    [I(176,56)] = {27,0x7FFF81E},
    [I(177,56)] = {27,0x7FFF85E},
    [I(178,56)] = {28,0xFFFF81E},
    [I(179,56)] = {27,0x7FFF89E},
    [I(180,56)] = {29,0x1FFFFB5E},
    [I(181,56)] = {28,0xFFFF85E},
    [I(182,56)] = {29,0x1FFFFB9E},
    [I(183,56)] = {29,0x1FFFFBDE},
    [I(184,56)] = {26,0x3FFFA9E},
    [I(185,56)] = {28,0xFFFF89E},
    [I(186,56)] = {28,0xFFFF8DE},
    [I(187,56)] = {28,0xFFFF91E},
    [I(188,56)] = {29,0x1FFFFC1E},
    [I(189,56)] = {28,0xFFFF95E},
    [I(190,56)] = {28,0xFFFF99E},
    [I(191,56)] = {29,0x1FFFFC5E},
    [I(192,56)] = {X32,0xFFFFF81E},
    [I(193,56)] = {X32,0xFFFFF85E},
    [I(194,56)] = {26,0x3FFFADE},
    [I(195,56)] = {25,0x1FFFC5E},
    [I(196,56)] = {28,0xFFFF9DE},
    [I(197,56)] = {29,0x1FFFFC9E},
    [I(198,56)] = {28,0xFFFFA1E},
    [I(199,56)] = {31,0x7FFFFB1E},
    [I(200,56)] = {X32,0xFFFFF89E},
    [I(201,56)] = {X32,0xFFFFF8DE},
    [I(202,56)] = {X32,0xFFFFF91E},
    [I(203,56)] = {64,0},
    [I(204,56)] = {64,0},
    [I(205,56)] = {X32,0xFFFFF95E},
    [I(206,56)] = {30,0x3FFFFC5E},
    [I(207,56)] = {31,0x7FFFFB5E},
    [I(208,56)] = {25,0x1FFFC9E},
    [I(209,56)] = {27,0x7FFF8DE},
    [I(210,56)] = {X32,0xFFFFF99E},
    [I(211,56)] = {64,0},
    [I(212,56)] = {64,0},
    [I(213,56)] = {X32,0xFFFFF9DE},
    [I(214,56)] = {64,0},
    [I(215,56)] = {30,0x3FFFFC9E},
    [I(216,56)] = {27,0x7FFF91E},
    [I(217,56)] = {27,0x7FFF95E},
    [I(218,56)] = {X32,0xFFFFFA1E},
    [I(219,56)] = {X32,0xFFFFFA5E},
    [I(220,56)] = {64,0},
    [I(221,56)] = {64,0},
    [I(222,56)] = {64,0},
    [I(223,56)] = {64,0},
    [I(224,56)] = {26,0x3FFFB1E},
    [I(225,56)] = {30,0x3FFFFCDE},
    [I(226,56)] = {26,0x3FFFB5E},
    [I(227,56)] = {27,0x7FFF99E},
    [I(228,56)] = {28,0xFFFFA5E},
    [I(229,56)] = {27,0x7FFF9DE},
    [I(230,56)] = {27,0x7FFFA1E},
    [I(231,56)] = {29,0x1FFFFCDE},
    [I(232,56)] = {28,0xFFFFA9E},
    [I(233,56)] = {28,0xFFFFADE},
    [I(234,56)] = {31,0x7FFFFB9E},
    [I(235,56)] = {31,0x7FFFFBDE},
    [I(236,56)] = {30,0x3FFFFD1E},
    [I(237,56)] = {30,0x3FFFFD5E},
    [I(238,56)] = {X32,0xFFFFFA9E},
    [I(239,56)] = {29,0x1FFFFD1E},
    [I(240,56)] = {X32,0xFFFFFADE},
    [I(241,56)] = {64,0},
    [I(242,56)] = {X32,0xFFFFFB1E},
    [I(243,56)] = {X32,0xFFFFFB5E},
    [I(244,56)] = {64,0},
    [I(245,56)] = {64,0},
    [I(246,56)] = {64,0},
    [I(247,56)] = {64,0},
    [I(248,56)] = {64,0},
    [I(249,56)] = {64,0},
    [I(250,56)] = {64,0},
    [I(251,56)] = {64,0},
    [I(252,56)] = {64,0},
    [I(253,56)] = {64,0},
    [I(254,56)] = {64,0},
    [I(255,56)] = {X32,0xFFFFFB9E},
    [I(0,57)] = {19,0x7FE1F},
    [I(1,57)] = {29,0x1FFFF61F},
    [I(2,57)] = {64,0},
    [I(3,57)] = {64,0},
    [I(4,57)] = {64,0},
    [I(5,57)] = {64,0},
    [I(6,57)] = {64,0},
    [I(7,57)] = {64,0},
    [I(8,57)] = {64,0},
    [I(9,57)] = {30,0x3FFFFA9F},
    [I(10,57)] = {64,0},
    [I(11,57)] = {64,0},
    [I(12,57)] = {64,0},
    [I(13,57)] = {64,0},
    [I(14,57)] = {64,0},
    [I(15,57)] = {64,0},
    [I(16,57)] = {64,0},
    [I(17,57)] = {64,0},
    [I(18,57)] = {64,0},
    [I(19,57)] = {64,0},
    [I(20,57)] = {64,0},
    [I(21,57)] = {64,0},
    [I(22,57)] = {64,0},
    [I(23,57)] = {64,0},
    [I(24,57)] = {64,0},
    [I(25,57)] = {64,0},
    [I(26,57)] = {64,0},
    [I(27,57)] = {64,0},
    [I(28,57)] = {64,0},
    [I(29,57)] = {64,0},
    [I(30,57)] = {64,0},
    [I(31,57)] = {64,0},
    [I(32,57)] = {12,0x51F},
    [I(33,57)] = {16,0xFE1F},
    [I(34,57)] = {16,0xFE5F},
    [I(35,57)] = {18,0x3FE9F},
    [I(36,57)] = {19,0x7FE5F},
    [I(37,57)] = {12,0x55F},
    [I(38,57)] = {14,0x3E1F},
    [I(39,57)] = {17,0x1FE9F},
    [I(40,57)] = {16,0xFE9F},
    [I(41,57)] = {16,0xFEDF},
    [I(42,57)] = {14,0x3E5F},
    [I(43,57)] = {17,0x1FEDF},
    [I(44,57)] = {14,0x3E9F},
    [I(45,57)] = {12,0x59F},
    [I(46,57)] = {12,0x5DF},
    [I(47,57)] = {12,0x61F},
    [I(48,57)] = {11,0x1F},
    [I(49,57)] = {11,0x5F},
    [I(50,57)] = {11,0x9F},
    [I(51,57)] = {12,0x65F},
    [I(52,57)] = {12,0x69F},
    [I(53,57)] = {12,0x6DF},
    [I(54,57)] = {12,0x71F},
    [I(55,57)] = {12,0x75F},
    [I(56,57)] = {12,0x79F},
    [I(57,57)] = {12,0x7DF},
    [I(58,57)] = {13,0x171F},
    [I(59,57)] = {14,0x3EDF},
    [I(60,57)] = {21,0x1FFF1F},
    [I(61,57)] = {12,0x81F},
    [I(62,57)] = {18,0x3FEDF},
    [I(63,57)] = {16,0xFF1F},
    [I(64,57)] = {19,0x7FE9F},
    [I(65,57)] = {12,0x85F},
    [I(66,57)] = {13,0x175F},
    [I(67,57)] = {13,0x179F},
    [I(68,57)] = {13,0x17DF},
    [I(69,57)] = {13,0x181F},
    [I(70,57)] = {13,0x185F},
    [I(71,57)] = {13,0x189F},
    [I(72,57)] = {13,0x18DF},
    [I(73,57)] = {13,0x191F},
    [I(74,57)] = {13,0x195F},
    [I(75,57)] = {13,0x199F},
    [I(76,57)] = {13,0x19DF},
    [I(77,57)] = {13,0x1A1F},
    [I(78,57)] = {13,0x1A5F},
    [I(79,57)] = {13,0x1A9F},
    [I(80,57)] = {13,0x1ADF},
    [I(81,57)] = {13,0x1B1F},
    [I(82,57)] = {13,0x1B5F},
    [I(83,57)] = {13,0x1B9F},
    [I(84,57)] = {13,0x1BDF},
    [I(85,57)] = {13,0x1C1F},
    [I(86,57)] = {13,0x1C5F},
    [I(87,57)] = {13,0x1C9F},
    [I(88,57)] = {14,0x3F1F},
    [I(89,57)] = {13,0x1CDF},
    [I(90,57)] = {14,0x3F5F},
    [I(91,57)] = {19,0x7FEDF},
    [I(92,57)] = {25,0x1FFFC1F},
    [I(93,57)] = {19,0x7FF1F},
    [I(94,57)] = {20,0xFFF1F},
    [I(95,57)] = {12,0x89F},
    [I(96,57)] = {21,0x1FFF5F},
    [I(97,57)] = {11,0xDF},
    [I(98,57)] = {12,0x8DF},
    [I(99,57)] = {11,0x11F},
    [I(100,57)] = {12,0x91F},
    [I(101,57)] = {11,0x15F},
    [I(102,57)] = {12,0x95F},
    [I(103,57)] = {12,0x99F},
    [I(104,57)] = {12,0x9DF},
    [I(105,57)] = {11,0x19F},
    [I(106,57)] = {13,0x1D1F},
    [I(107,57)] = {13,0x1D5F},
    [I(108,57)] = {12,0xA1F},
    [I(109,57)] = {12,0xA5F},
    [I(110,57)] = {12,0xA9F},
    [I(111,57)] = {11,0x1DF},
    [I(112,57)] = {12,0xADF},
    [I(113,57)] = {13,0x1D9F},
    [I(114,57)] = {12,0xB1F},
    [I(115,57)] = {11,0x21F},
    [I(116,57)] = {11,0x25F},
    [I(117,57)] = {12,0xB5F},
    [I(118,57)] = {13,0x1DDF},
    [I(119,57)] = {13,0x1E1F},
    [I(120,57)] = {13,0x1E5F},
    [I(121,57)] = {13,0x1E9F},
    [I(122,57)] = {13,0x1EDF},
    [I(123,57)] = {21,0x1FFF9F},
    [I(124,57)] = {17,0x1FF1F},
    [I(125,57)] = {20,0xFFF5F},
    [I(126,57)] = {19,0x7FF5F},
    [I(127,57)] = {64,0},
    [I(128,57)] = {26,0x3FFF99F},
    [I(129,57)] = {28,0xFFFF49F},
    [I(130,57)] = {26,0x3FFF9DF},
    [I(131,57)] = {26,0x3FFFA1F},
    [I(132,57)] = {28,0xFFFF4DF},
    [I(133,57)] = {28,0xFFFF51F},
    [I(134,57)] = {28,0xFFFF55F},
    [I(135,57)] = {29,0x1FFFF65F},
    [I(136,57)] = {28,0xFFFF59F},
    [I(137,57)] = {29,0x1FFFF69F},
    [I(138,57)] = {29,0x1FFFF6DF},
    [I(139,57)] = {29,0x1FFFF71F},
    [I(140,57)] = {29,0x1FFFF75F},
    [I(141,57)] = {29,0x1FFFF79F},
    [I(142,57)] = {30,0x3FFFFADF},
    [I(143,57)] = {29,0x1FFFF7DF},
    [I(144,57)] = {30,0x3FFFFB1F},
    [I(145,57)] = {30,0x3FFFFB5F},
    [I(146,57)] = {28,0xFFFF5DF},
    [I(147,57)] = {29,0x1FFFF81F},
    [I(148,57)] = {30,0x3FFFFB9F},
    [I(149,57)] = {29,0x1FFFF85F},
    [I(150,57)] = {29,0x1FFFF89F},
    [I(151,57)] = {29,0x1FFFF8DF},
    [I(152,57)] = {29,0x1FFFF91F},
    [I(153,57)] = {27,0x7FFF71F},
    [I(154,57)] = {28,0xFFFF61F},
    [I(155,57)] = {29,0x1FFFF95F},
    [I(156,57)] = {28,0xFFFF65F},
    [I(157,57)] = {29,0x1FFFF99F},
    [I(158,57)] = {29,0x1FFFF9DF},
    [I(159,57)] = {30,0x3FFFFBDF},
    [I(160,57)] = {28,0xFFFF69F},
    [I(161,57)] = {27,0x7FFF75F},
    [I(162,57)] = {26,0x3FFFA5F},
    [I(163,57)] = {28,0xFFFF6DF},
    [I(164,57)] = {28,0xFFFF71F},
    [I(165,57)] = {29,0x1FFFFA1F},
    [I(166,57)] = {29,0x1FFFFA5F},
    [I(167,57)] = {27,0x7FFF79F},
    [I(168,57)] = {29,0x1FFFFA9F},
    [I(169,57)] = {28,0xFFFF75F},
    [I(170,57)] = {28,0xFFFF79F},
    [I(171,57)] = {30,0x3FFFFC1F},
    [I(172,57)] = {27,0x7FFF7DF},
    [I(173,57)] = {28,0xFFFF7DF},
    [I(174,57)] = {29,0x1FFFFADF},
    [I(175,57)] = {29,0x1FFFFB1F},
    [I(176,57)] = {27,0x7FFF81F},
    [I(177,57)] = {27,0x7FFF85F},
    [I(178,57)] = {28,0xFFFF81F},
    [I(179,57)] = {27,0x7FFF89F},
    [I(180,57)] = {29,0x1FFFFB5F},
    [I(181,57)] = {28,0xFFFF85F},
    [I(182,57)] = {29,0x1FFFFB9F},
    [I(183,57)] = {29,0x1FFFFBDF},
    [I(184,57)] = {26,0x3FFFA9F},
    [I(185,57)] = {28,0xFFFF89F},
    [I(186,57)] = {28,0xFFFF8DF},
    [I(187,57)] = {28,0xFFFF91F},
    [I(188,57)] = {29,0x1FFFFC1F},
    [I(189,57)] = {28,0xFFFF95F},
    [I(190,57)] = {28,0xFFFF99F},
    [I(191,57)] = {29,0x1FFFFC5F},
    [I(192,57)] = {X32,0xFFFFF81F},
    [I(193,57)] = {X32,0xFFFFF85F},
    [I(194,57)] = {26,0x3FFFADF},
    [I(195,57)] = {25,0x1FFFC5F},
    [I(196,57)] = {28,0xFFFF9DF},
    [I(197,57)] = {29,0x1FFFFC9F},
    [I(198,57)] = {28,0xFFFFA1F},
    [I(199,57)] = {31,0x7FFFFB1F},
    [I(200,57)] = {X32,0xFFFFF89F},
    [I(201,57)] = {X32,0xFFFFF8DF},
    [I(202,57)] = {X32,0xFFFFF91F},
    [I(203,57)] = {64,0},
    [I(204,57)] = {64,0},
    [I(205,57)] = {X32,0xFFFFF95F},
    [I(206,57)] = {30,0x3FFFFC5F},
    [I(207,57)] = {31,0x7FFFFB5F},
    [I(208,57)] = {25,0x1FFFC9F},
    [I(209,57)] = {27,0x7FFF8DF},
    [I(210,57)] = {X32,0xFFFFF99F},
    [I(211,57)] = {64,0},
    [I(212,57)] = {64,0},
    [I(213,57)] = {X32,0xFFFFF9DF},
    [I(214,57)] = {64,0},
    [I(215,57)] = {30,0x3FFFFC9F},
    [I(216,57)] = {27,0x7FFF91F},
    [I(217,57)] = {27,0x7FFF95F},
    [I(218,57)] = {X32,0xFFFFFA1F},
    [I(219,57)] = {X32,0xFFFFFA5F},
    [I(220,57)] = {64,0},
    [I(221,57)] = {64,0},
    [I(222,57)] = {64,0},
    [I(223,57)] = {64,0},
    [I(224,57)] = {26,0x3FFFB1F},
    [I(225,57)] = {30,0x3FFFFCDF},
    [I(226,57)] = {26,0x3FFFB5F},
    [I(227,57)] = {27,0x7FFF99F},
    [I(228,57)] = {28,0xFFFFA5F},
    [I(229,57)] = {27,0x7FFF9DF},
    [I(230,57)] = {27,0x7FFFA1F},
    [I(231,57)] = {29,0x1FFFFCDF},
    [I(232,57)] = {28,0xFFFFA9F},
    [I(233,57)] = {28,0xFFFFADF},
    [I(234,57)] = {31,0x7FFFFB9F},
    [I(235,57)] = {31,0x7FFFFBDF},
    [I(236,57)] = {30,0x3FFFFD1F},
    [I(237,57)] = {30,0x3FFFFD5F},
    [I(238,57)] = {X32,0xFFFFFA9F},
    [I(239,57)] = {29,0x1FFFFD1F},
    [I(240,57)] = {X32,0xFFFFFADF},
    [I(241,57)] = {64,0},
    [I(242,57)] = {X32,0xFFFFFB1F},
    [I(243,57)] = {X32,0xFFFFFB5F},
    [I(244,57)] = {64,0},
    [I(245,57)] = {64,0},
    [I(246,57)] = {64,0},
    [I(247,57)] = {64,0},
    [I(248,57)] = {64,0},
    [I(249,57)] = {64,0},
    [I(250,57)] = {64,0},
    [I(251,57)] = {64,0},
    [I(252,57)] = {64,0},
    [I(253,57)] = {64,0},
    [I(254,57)] = {64,0},
    [I(255,57)] = {X32,0xFFFFFB9F},
    [I(0,58)] = {20,0xFFC5C},
    [I(1,58)] = {30,0x3FFFEC5C},
    [I(2,58)] = {64,0},
    [I(3,58)] = {64,0},
    [I(4,58)] = {64,0},
    [I(5,58)] = {64,0},
    [I(6,58)] = {64,0},
    [I(7,58)] = {64,0},
    [I(8,58)] = {64,0},
    [I(9,58)] = {31,0x7FFFF55C},
    [I(10,58)] = {64,0},
    [I(11,58)] = {64,0},
    [I(12,58)] = {64,0},
    [I(13,58)] = {64,0},
    [I(14,58)] = {64,0},
    [I(15,58)] = {64,0},
    [I(16,58)] = {64,0},
    [I(17,58)] = {64,0},
    [I(18,58)] = {64,0},
    [I(19,58)] = {64,0},
    [I(20,58)] = {64,0},
    [I(21,58)] = {64,0},
    [I(22,58)] = {64,0},
    [I(23,58)] = {64,0},
    [I(24,58)] = {64,0},
    [I(25,58)] = {64,0},
    [I(26,58)] = {64,0},
    [I(27,58)] = {64,0},
    [I(28,58)] = {64,0},
    [I(29,58)] = {64,0},
    [I(30,58)] = {64,0},
    [I(31,58)] = {64,0},
    [I(32,58)] = {13,0xA5C},
    [I(33,58)] = {17,0x1FC5C},
    [I(34,58)] = {17,0x1FCDC},
    [I(35,58)] = {19,0x7FD5C},
    [I(36,58)] = {20,0xFFCDC},
    [I(37,58)] = {13,0xADC},
    [I(38,58)] = {15,0x7C5C},
    [I(39,58)] = {18,0x3FD5C},
    [I(40,58)] = {17,0x1FD5C},
    [I(41,58)] = {17,0x1FDDC},
    [I(42,58)] = {15,0x7CDC},
    [I(43,58)] = {18,0x3FDDC},
    [I(44,58)] = {15,0x7D5C},
    [I(45,58)] = {13,0xB5C},
    [I(46,58)] = {13,0xBDC},
    [I(47,58)] = {13,0xC5C},
    [I(48,58)] = {12,0x5C},
    [I(49,58)] = {12,0xDC},
    [I(50,58)] = {12,0x15C},
    [I(51,58)] = {13,0xCDC},
    [I(52,58)] = {13,0xD5C},
    [I(53,58)] = {13,0xDDC},
    [I(54,58)] = {13,0xE5C},
    [I(55,58)] = {13,0xEDC},
    [I(56,58)] = {13,0xF5C},
    [I(57,58)] = {13,0xFDC},
    [I(58,58)] = {14,0x2E5C},
    [I(59,58)] = {15,0x7DDC},
    [I(60,58)] = {22,0x3FFE5C},
    [I(61,58)] = {13,0x105C},
    [I(62,58)] = {19,0x7FDDC},
    [I(63,58)] = {17,0x1FE5C},
    [I(64,58)] = {20,0xFFD5C},
    [I(65,58)] = {13,0x10DC},
    [I(66,58)] = {14,0x2EDC},
    [I(67,58)] = {14,0x2F5C},
    [I(68,58)] = {14,0x2FDC},
    [I(69,58)] = {14,0x305C},
    [I(70,58)] = {14,0x30DC},
    [I(71,58)] = {14,0x315C},
    [I(72,58)] = {14,0x31DC},
    [I(73,58)] = {14,0x325C},
    [I(74,58)] = {14,0x32DC},
    [I(75,58)] = {14,0x335C},
    [I(76,58)] = {14,0x33DC},
    [I(77,58)] = {14,0x345C},
    [I(78,58)] = {14,0x34DC},
    [I(79,58)] = {14,0x355C},
    [I(80,58)] = {14,0x35DC},
    [I(81,58)] = {14,0x365C},
    [I(82,58)] = {14,0x36DC},
    [I(83,58)] = {14,0x375C},
    [I(84,58)] = {14,0x37DC},
    [I(85,58)] = {14,0x385C},
    [I(86,58)] = {14,0x38DC},
    [I(87,58)] = {14,0x395C},
    [I(88,58)] = {15,0x7E5C},
    [I(89,58)] = {14,0x39DC},
    [I(90,58)] = {15,0x7EDC},
    [I(91,58)] = {20,0xFFDDC},
    [I(92,58)] = {26,0x3FFF85C},
    [I(93,58)] = {20,0xFFE5C},
    [I(94,58)] = {21,0x1FFE5C},
    [I(95,58)] = {13,0x115C},
    [I(96,58)] = {22,0x3FFEDC},
    [I(97,58)] = {12,0x1DC},
    [I(98,58)] = {13,0x11DC},
    [I(99,58)] = {12,0x25C},
    [I(100,58)] = {13,0x125C},
    [I(101,58)] = {12,0x2DC},
    [I(102,58)] = {13,0x12DC},
    [I(103,58)] = {13,0x135C},
    [I(104,58)] = {13,0x13DC},
    [I(105,58)] = {12,0x35C},
    [I(106,58)] = {14,0x3A5C},
    [I(107,58)] = {14,0x3ADC},
    [I(108,58)] = {13,0x145C},
    [I(109,58)] = {13,0x14DC},
    [I(110,58)] = {13,0x155C},
    [I(111,58)] = {12,0x3DC},
    [I(112,58)] = {13,0x15DC},
    [I(113,58)] = {14,0x3B5C},
    [I(114,58)] = {13,0x165C},
    [I(115,58)] = {12,0x45C},
    [I(116,58)] = {12,0x4DC},
    [I(117,58)] = {13,0x16DC},
    [I(118,58)] = {14,0x3BDC},
    [I(119,58)] = {14,0x3C5C},
    [I(120,58)] = {14,0x3CDC},
    [I(121,58)] = {14,0x3D5C},
    [I(122,58)] = {14,0x3DDC},
    [I(123,58)] = {22,0x3FFF5C},
    [I(124,58)] = {18,0x3FE5C},
    [I(125,58)] = {21,0x1FFEDC},
    [I(126,58)] = {20,0xFFEDC},
    [I(127,58)] = {64,0},
    [I(128,58)] = {27,0x7FFF35C},
    [I(129,58)] = {29,0x1FFFE95C},
    [I(130,58)] = {27,0x7FFF3DC},
    [I(131,58)] = {27,0x7FFF45C},
    [I(132,58)] = {29,0x1FFFE9DC},
    [I(133,58)] = {29,0x1FFFEA5C},
    [I(134,58)] = {29,0x1FFFEADC},
    [I(135,58)] = {30,0x3FFFECDC},
    [I(136,58)] = {29,0x1FFFEB5C},
    [I(137,58)] = {30,0x3FFFED5C},
    [I(138,58)] = {30,0x3FFFEDDC},
    [I(139,58)] = {30,0x3FFFEE5C},
    [I(140,58)] = {30,0x3FFFEEDC},
    [I(141,58)] = {30,0x3FFFEF5C},
    [I(142,58)] = {31,0x7FFFF5DC},
    [I(143,58)] = {30,0x3FFFEFDC},
    [I(144,58)] = {31,0x7FFFF65C},
    [I(145,58)] = {31,0x7FFFF6DC},
    [I(146,58)] = {29,0x1FFFEBDC},
    [I(147,58)] = {30,0x3FFFF05C},
    [I(148,58)] = {31,0x7FFFF75C},
    [I(149,58)] = {30,0x3FFFF0DC},
    [I(150,58)] = {30,0x3FFFF15C},
    [I(151,58)] = {30,0x3FFFF1DC},
    [I(152,58)] = {30,0x3FFFF25C},
    [I(153,58)] = {28,0xFFFEE5C},
    [I(154,58)] = {29,0x1FFFEC5C},
    [I(155,58)] = {30,0x3FFFF2DC},
    [I(156,58)] = {29,0x1FFFECDC},
    [I(157,58)] = {30,0x3FFFF35C},
    [I(158,58)] = {30,0x3FFFF3DC},
    [I(159,58)] = {31,0x7FFFF7DC},
    [I(160,58)] = {29,0x1FFFED5C},
    [I(161,58)] = {28,0xFFFEEDC},
    [I(162,58)] = {27,0x7FFF4DC},
    [I(163,58)] = {29,0x1FFFEDDC},
    [I(164,58)] = {29,0x1FFFEE5C},
    [I(165,58)] = {30,0x3FFFF45C},
    [I(166,58)] = {30,0x3FFFF4DC},
    [I(167,58)] = {28,0xFFFEF5C},
    [I(168,58)] = {30,0x3FFFF55C},
    [I(169,58)] = {29,0x1FFFEEDC},
    [I(170,58)] = {29,0x1FFFEF5C},
    [I(171,58)] = {31,0x7FFFF85C},
    [I(172,58)] = {28,0xFFFEFDC},
    [I(173,58)] = {29,0x1FFFEFDC},
    [I(174,58)] = {30,0x3FFFF5DC},
    [I(175,58)] = {30,0x3FFFF65C},
    [I(176,58)] = {28,0xFFFF05C},
    [I(177,58)] = {28,0xFFFF0DC},
    [I(178,58)] = {29,0x1FFFF05C},
    [I(179,58)] = {28,0xFFFF15C},
    [I(180,58)] = {30,0x3FFFF6DC},
    [I(181,58)] = {29,0x1FFFF0DC},
    [I(182,58)] = {30,0x3FFFF75C},
    [I(183,58)] = {30,0x3FFFF7DC},
    [I(184,58)] = {27,0x7FFF55C},
    [I(185,58)] = {29,0x1FFFF15C},
    [I(186,58)] = {29,0x1FFFF1DC},
    [I(187,58)] = {29,0x1FFFF25C},
    [I(188,58)] = {30,0x3FFFF85C},
    [I(189,58)] = {29,0x1FFFF2DC},
    [I(190,58)] = {29,0x1FFFF35C},
    [I(191,58)] = {30,0x3FFFF8DC},
    [I(192,58)] = {64,0},
    [I(193,58)] = {64,0},
    [I(194,58)] = {27,0x7FFF5DC},
    [I(195,58)] = {26,0x3FFF8DC},
    [I(196,58)] = {29,0x1FFFF3DC},
    [I(197,58)] = {30,0x3FFFF95C},
    [I(198,58)] = {29,0x1FFFF45C},
    [I(199,58)] = {X32,0xFFFFF65C},
    [I(200,58)] = {64,0},
    [I(201,58)] = {64,0},
    [I(202,58)] = {64,0},
    [I(203,58)] = {64,0},
    [I(204,58)] = {64,0},
    [I(205,58)] = {64,0},
    [I(206,58)] = {31,0x7FFFF8DC},
    [I(207,58)] = {X32,0xFFFFF6DC},
    [I(208,58)] = {26,0x3FFF95C},
    [I(209,58)] = {28,0xFFFF1DC},
    [I(210,58)] = {64,0},
    [I(211,58)] = {64,0},
    [I(212,58)] = {64,0},
    [I(213,58)] = {64,0},
    [I(214,58)] = {64,0},
    [I(215,58)] = {31,0x7FFFF95C},
    [I(216,58)] = {28,0xFFFF25C},
    [I(217,58)] = {28,0xFFFF2DC},
    [I(218,58)] = {64,0},
    [I(219,58)] = {64,0},
    [I(220,58)] = {64,0},
    [I(221,58)] = {64,0},
    [I(222,58)] = {64,0},
    [I(223,58)] = {64,0},
    [I(224,58)] = {27,0x7FFF65C},
    [I(225,58)] = {31,0x7FFFF9DC},
    [I(226,58)] = {27,0x7FFF6DC},
    [I(227,58)] = {28,0xFFFF35C},
    [I(228,58)] = {29,0x1FFFF4DC},
    [I(229,58)] = {28,0xFFFF3DC},
    [I(230,58)] = {28,0xFFFF45C},
    [I(231,58)] = {30,0x3FFFF9DC},
    [I(232,58)] = {29,0x1FFFF55C},
    [I(233,58)] = {29,0x1FFFF5DC},
    [I(234,58)] = {X32,0xFFFFF75C},
    [I(235,58)] = {X32,0xFFFFF7DC},
    [I(236,58)] = {31,0x7FFFFA5C},
    [I(237,58)] = {31,0x7FFFFADC},
    [I(238,58)] = {64,0},
    [I(239,58)] = {30,0x3FFFFA5C},
    [I(240,58)] = {64,0},
    [I(241,58)] = {64,0},
    [I(242,58)] = {64,0},
    [I(243,58)] = {64,0},
    [I(244,58)] = {64,0},
    [I(245,58)] = {64,0},
    [I(246,58)] = {64,0},
    [I(247,58)] = {64,0},
    [I(248,58)] = {64,0},
    [I(249,58)] = {64,0},
    [I(250,58)] = {64,0},
    [I(251,58)] = {64,0},
    [I(252,58)] = {64,0},
    [I(253,58)] = {64,0},
    [I(254,58)] = {64,0},
    [I(255,58)] = {64,0},
    [I(0,59)] = {21,0x1FF8FB},
    [I(1,59)] = {31,0x7FFFD8FB},
    [I(2,59)] = {64,0},
    [I(3,59)] = {64,0},
    [I(4,59)] = {64,0},
    [I(5,59)] = {64,0},
    [I(6,59)] = {64,0},
    [I(7,59)] = {64,0},
    [I(8,59)] = {64,0},
    [I(9,59)] = {X32,0xFFFFEAFB},
    [I(10,59)] = {64,0},
    [I(11,59)] = {64,0},
    [I(12,59)] = {64,0},
    [I(13,59)] = {64,0},
    [I(14,59)] = {64,0},
    [I(15,59)] = {64,0},
    [I(16,59)] = {64,0},
    [I(17,59)] = {64,0},
    [I(18,59)] = {64,0},
    [I(19,59)] = {64,0},
    [I(20,59)] = {64,0},
    [I(21,59)] = {64,0},
    [I(22,59)] = {64,0},
    [I(23,59)] = {64,0},
    [I(24,59)] = {64,0},
    [I(25,59)] = {64,0},
    [I(26,59)] = {64,0},
    [I(27,59)] = {64,0},
    [I(28,59)] = {64,0},
    [I(29,59)] = {64,0},
    [I(30,59)] = {64,0},
    [I(31,59)] = {64,0},
    [I(32,59)] = {14,0x14FB},
    [I(33,59)] = {18,0x3F8FB},
    [I(34,59)] = {18,0x3F9FB},
    [I(35,59)] = {20,0xFFAFB},
    [I(36,59)] = {21,0x1FF9FB},
    [I(37,59)] = {14,0x15FB},
    [I(38,59)] = {16,0xF8FB},
    [I(39,59)] = {19,0x7FAFB},
    [I(40,59)] = {18,0x3FAFB},
    [I(41,59)] = {18,0x3FBFB},
    [I(42,59)] = {16,0xF9FB},
    [I(43,59)] = {19,0x7FBFB},
    [I(44,59)] = {16,0xFAFB},
    [I(45,59)] = {14,0x16FB},
    [I(46,59)] = {14,0x17FB},
    [I(47,59)] = {14,0x18FB},
    [I(48,59)] = {13,0xFB},
    [I(49,59)] = {13,0x1FB},
    [I(50,59)] = {13,0x2FB},
    [I(51,59)] = {14,0x19FB},
    [I(52,59)] = {14,0x1AFB},
    [I(53,59)] = {14,0x1BFB},
    [I(54,59)] = {14,0x1CFB},
    [I(55,59)] = {14,0x1DFB},
    [I(56,59)] = {14,0x1EFB},
    [I(57,59)] = {14,0x1FFB},
    [I(58,59)] = {15,0x5CFB},
    [I(59,59)] = {16,0xFBFB},
    [I(60,59)] = {23,0x7FFCFB},
    [I(61,59)] = {14,0x20FB},
    [I(62,59)] = {20,0xFFBFB},
    [I(63,59)] = {18,0x3FCFB},
    [I(64,59)] = {21,0x1FFAFB},
    [I(65,59)] = {14,0x21FB},
    [I(66,59)] = {15,0x5DFB},
    [I(67,59)] = {15,0x5EFB},
    [I(68,59)] = {15,0x5FFB},
    [I(69,59)] = {15,0x60FB},
    [I(70,59)] = {15,0x61FB},
    [I(71,59)] = {15,0x62FB},
    [I(72,59)] = {15,0x63FB},
    [I(73,59)] = {15,0x64FB},
    [I(74,59)] = {15,0x65FB},
    [I(75,59)] = {15,0x66FB},
    [I(76,59)] = {15,0x67FB},
    [I(77,59)] = {15,0x68FB},
    [I(78,59)] = {15,0x69FB},
    [I(79,59)] = {15,0x6AFB},
    [I(80,59)] = {15,0x6BFB},
    [I(81,59)] = {15,0x6CFB},
    [I(82,59)] = {15,0x6DFB},
    [I(83,59)] = {15,0x6EFB},
    [I(84,59)] = {15,0x6FFB},
    [I(85,59)] = {15,0x70FB},
    [I(86,59)] = {15,0x71FB},
    [I(87,59)] = {15,0x72FB},
    [I(88,59)] = {16,0xFCFB},
    [I(89,59)] = {15,0x73FB},
    [I(90,59)] = {16,0xFDFB},
    [I(91,59)] = {21,0x1FFBFB},
    [I(92,59)] = {27,0x7FFF0FB},
    [I(93,59)] = {21,0x1FFCFB},
    [I(94,59)] = {22,0x3FFCFB},
    [I(95,59)] = {14,0x22FB},
    [I(96,59)] = {23,0x7FFDFB},
    [I(97,59)] = {13,0x3FB},
    [I(98,59)] = {14,0x23FB},
    [I(99,59)] = {13,0x4FB},
    [I(100,59)] = {14,0x24FB},
    [I(101,59)] = {13,0x5FB},
    [I(102,59)] = {14,0x25FB},
    [I(103,59)] = {14,0x26FB},
    [I(104,59)] = {14,0x27FB},
    [I(105,59)] = {13,0x6FB},
    [I(106,59)] = {15,0x74FB},
    [I(107,59)] = {15,0x75FB},
    [I(108,59)] = {14,0x28FB},
    [I(109,59)] = {14,0x29FB},
    [I(110,59)] = {14,0x2AFB},
    [I(111,59)] = {13,0x7FB},
    [I(112,59)] = {14,0x2BFB},
    [I(113,59)] = {15,0x76FB},
    [I(114,59)] = {14,0x2CFB},
    [I(115,59)] = {13,0x8FB},
    [I(116,59)] = {13,0x9FB},
    [I(117,59)] = {14,0x2DFB},
    [I(118,59)] = {15,0x77FB},
    [I(119,59)] = {15,0x78FB},
    [I(120,59)] = {15,0x79FB},
    [I(121,59)] = {15,0x7AFB},
    [I(122,59)] = {15,0x7BFB},
    [I(123,59)] = {23,0x7FFEFB},
    [I(124,59)] = {19,0x7FCFB},
    [I(125,59)] = {22,0x3FFDFB},
    [I(126,59)] = {21,0x1FFDFB},
    [I(127,59)] = {64,0},
    [I(128,59)] = {28,0xFFFE6FB},
    [I(129,59)] = {30,0x3FFFD2FB},
    [I(130,59)] = {28,0xFFFE7FB},
    [I(131,59)] = {28,0xFFFE8FB},
    [I(132,59)] = {30,0x3FFFD3FB},
    [I(133,59)] = {30,0x3FFFD4FB},
    [I(134,59)] = {30,0x3FFFD5FB},
    [I(135,59)] = {31,0x7FFFD9FB},
    [I(136,59)] = {30,0x3FFFD6FB},
    [I(137,59)] = {31,0x7FFFDAFB},
    [I(138,59)] = {31,0x7FFFDBFB},
    [I(139,59)] = {31,0x7FFFDCFB},
    [I(140,59)] = {31,0x7FFFDDFB},
    [I(141,59)] = {31,0x7FFFDEFB},
    [I(142,59)] = {X32,0xFFFFEBFB},
    [I(143,59)] = {31,0x7FFFDFFB},
    [I(144,59)] = {X32,0xFFFFECFB},
    [I(145,59)] = {X32,0xFFFFEDFB},
    [I(146,59)] = {30,0x3FFFD7FB},
    [I(147,59)] = {31,0x7FFFE0FB},
    [I(148,59)] = {X32,0xFFFFEEFB},
    [I(149,59)] = {31,0x7FFFE1FB},
    [I(150,59)] = {31,0x7FFFE2FB},
    [I(151,59)] = {31,0x7FFFE3FB},
    [I(152,59)] = {31,0x7FFFE4FB},
    [I(153,59)] = {29,0x1FFFDCFB},
    [I(154,59)] = {30,0x3FFFD8FB},
    [I(155,59)] = {31,0x7FFFE5FB},
    [I(156,59)] = {30,0x3FFFD9FB},
    [I(157,59)] = {31,0x7FFFE6FB},
    [I(158,59)] = {31,0x7FFFE7FB},
    [I(159,59)] = {X32,0xFFFFEFFB},
    [I(160,59)] = {30,0x3FFFDAFB},
    [I(161,59)] = {29,0x1FFFDDFB},
    [I(162,59)] = {28,0xFFFE9FB},
    [I(163,59)] = {30,0x3FFFDBFB},
    [I(164,59)] = {30,0x3FFFDCFB},
    [I(165,59)] = {31,0x7FFFE8FB},
    [I(166,59)] = {31,0x7FFFE9FB},
    [I(167,59)] = {29,0x1FFFDEFB},
    [I(168,59)] = {31,0x7FFFEAFB},
    [I(169,59)] = {30,0x3FFFDDFB},
    [I(170,59)] = {30,0x3FFFDEFB},
    [I(171,59)] = {X32,0xFFFFF0FB},
    [I(172,59)] = {29,0x1FFFDFFB},
    [I(173,59)] = {30,0x3FFFDFFB},
    [I(174,59)] = {31,0x7FFFEBFB},
    [I(175,59)] = {31,0x7FFFECFB},
    [I(176,59)] = {29,0x1FFFE0FB},
    [I(177,59)] = {29,0x1FFFE1FB},
    [I(178,59)] = {30,0x3FFFE0FB},
    [I(179,59)] = {29,0x1FFFE2FB},
    [I(180,59)] = {31,0x7FFFEDFB},
    [I(181,59)] = {30,0x3FFFE1FB},
    [I(182,59)] = {31,0x7FFFEEFB},
    [I(183,59)] = {31,0x7FFFEFFB},
    [I(184,59)] = {28,0xFFFEAFB},
    [I(185,59)] = {30,0x3FFFE2FB},
    [I(186,59)] = {30,0x3FFFE3FB},
    [I(187,59)] = {30,0x3FFFE4FB},
    [I(188,59)] = {31,0x7FFFF0FB},
    [I(189,59)] = {30,0x3FFFE5FB},
    [I(190,59)] = {30,0x3FFFE6FB},
    [I(191,59)] = {31,0x7FFFF1FB},
    [I(192,59)] = {64,0},
    [I(193,59)] = {64,0},
    [I(194,59)] = {28,0xFFFEBFB},
    [I(195,59)] = {27,0x7FFF1FB},
    [I(196,59)] = {30,0x3FFFE7FB},
    [I(197,59)] = {31,0x7FFFF2FB},
    [I(198,59)] = {30,0x3FFFE8FB},
    [I(199,59)] = {64,0},
    [I(200,59)] = {64,0},
    [I(201,59)] = {64,0},
    [I(202,59)] = {64,0},
    [I(203,59)] = {64,0},
    [I(204,59)] = {64,0},
    [I(205,59)] = {64,0},
    [I(206,59)] = {X32,0xFFFFF1FB},
    [I(207,59)] = {64,0},
    [I(208,59)] = {27,0x7FFF2FB},
    [I(209,59)] = {29,0x1FFFE3FB},
    [I(210,59)] = {64,0},
    [I(211,59)] = {64,0},
    [I(212,59)] = {64,0},
    [I(213,59)] = {64,0},
    [I(214,59)] = {64,0},
    [I(215,59)] = {X32,0xFFFFF2FB},
    [I(216,59)] = {29,0x1FFFE4FB},
    [I(217,59)] = {29,0x1FFFE5FB},
    [I(218,59)] = {64,0},
    [I(219,59)] = {64,0},
    [I(220,59)] = {64,0},
    [I(221,59)] = {64,0},
    [I(222,59)] = {64,0},
    [I(223,59)] = {64,0},
    [I(224,59)] = {28,0xFFFECFB},
    [I(225,59)] = {X32,0xFFFFF3FB},
    [I(226,59)] = {28,0xFFFEDFB},
    [I(227,59)] = {29,0x1FFFE6FB},
    [I(228,59)] = {30,0x3FFFE9FB},
    [I(229,59)] = {29,0x1FFFE7FB},
    [I(230,59)] = {29,0x1FFFE8FB},
    [I(231,59)] = {31,0x7FFFF3FB},
    [I(232,59)] = {30,0x3FFFEAFB},
    [I(233,59)] = {30,0x3FFFEBFB},
    [I(234,59)] = {64,0},
    [I(235,59)] = {64,0},
    [I(236,59)] = {X32,0xFFFFF4FB},
    [I(237,59)] = {X32,0xFFFFF5FB},
    [I(238,59)] = {64,0},
    [I(239,59)] = {31,0x7FFFF4FB},
    [I(240,59)] = {64,0},
    [I(241,59)] = {64,0},
    [I(242,59)] = {64,0},
    [I(243,59)] = {64,0},
    [I(244,59)] = {64,0},
    [I(245,59)] = {64,0},
    [I(246,59)] = {64,0},
    [I(247,59)] = {64,0},
    [I(248,59)] = {64,0},
    [I(249,59)] = {64,0},
    [I(250,59)] = {64,0},
    [I(251,59)] = {64,0},
    [I(252,59)] = {64,0},
    [I(253,59)] = {64,0},
    [I(254,59)] = {64,0},
    [I(255,59)] = {64,0},
    [I(0,60)] = {28,0xFFC7FFC},
    [I(1,60)] = {64,0},
    [I(2,60)] = {64,0},
    [I(3,60)] = {64,0},
    [I(4,60)] = {64,0},
    [I(5,60)] = {64,0},
    [I(6,60)] = {64,0},
    [I(7,60)] = {64,0},
    [I(8,60)] = {64,0},
    [I(9,60)] = {64,0},
    [I(10,60)] = {64,0},
    [I(11,60)] = {64,0},
    [I(12,60)] = {64,0},
    [I(13,60)] = {64,0},
    [I(14,60)] = {64,0},
    [I(15,60)] = {64,0},
    [I(16,60)] = {64,0},
    [I(17,60)] = {64,0},
    [I(18,60)] = {64,0},
    [I(19,60)] = {64,0},
    [I(20,60)] = {64,0},
    [I(21,60)] = {64,0},
    [I(22,60)] = {64,0},
    [I(23,60)] = {64,0},
    [I(24,60)] = {64,0},
    [I(25,60)] = {64,0},
    [I(26,60)] = {64,0},
    [I(27,60)] = {64,0},
    [I(28,60)] = {64,0},
    [I(29,60)] = {64,0},
    [I(30,60)] = {64,0},
    [I(31,60)] = {64,0},
    [I(32,60)] = {21,0xA7FFC},
    [I(33,60)] = {25,0x1FC7FFC},
    [I(34,60)] = {25,0x1FCFFFC},
    [I(35,60)] = {27,0x7FD7FFC},
    [I(36,60)] = {28,0xFFCFFFC},
    [I(37,60)] = {21,0xAFFFC},
    [I(38,60)] = {23,0x7C7FFC},
    [I(39,60)] = {26,0x3FD7FFC},
    [I(40,60)] = {25,0x1FD7FFC},
    [I(41,60)] = {25,0x1FDFFFC},
    [I(42,60)] = {23,0x7CFFFC},
    [I(43,60)] = {26,0x3FDFFFC},
    [I(44,60)] = {23,0x7D7FFC},
    [I(45,60)] = {21,0xB7FFC},
    [I(46,60)] = {21,0xBFFFC},
    [I(47,60)] = {21,0xC7FFC},
    [I(48,60)] = {20,0x7FFC},
    [I(49,60)] = {20,0xFFFC},
    [I(50,60)] = {20,0x17FFC},
    [I(51,60)] = {21,0xCFFFC},
    [I(52,60)] = {21,0xD7FFC},
    [I(53,60)] = {21,0xDFFFC},
    [I(54,60)] = {21,0xE7FFC},
    [I(55,60)] = {21,0xEFFFC},
    [I(56,60)] = {21,0xF7FFC},
    [I(57,60)] = {21,0xFFFFC},
    [I(58,60)] = {22,0x2E7FFC},
    [I(59,60)] = {23,0x7DFFFC},
    [I(60,60)] = {30,0x3FFE7FFC},
    [I(61,60)] = {21,0x107FFC},
    [I(62,60)] = {27,0x7FDFFFC},
    [I(63,60)] = {25,0x1FE7FFC},
    [I(64,60)] = {28,0xFFD7FFC},
    [I(65,60)] = {21,0x10FFFC},
    [I(66,60)] = {22,0x2EFFFC},
    [I(67,60)] = {22,0x2F7FFC},
    [I(68,60)] = {22,0x2FFFFC},
    [I(69,60)] = {22,0x307FFC},
    [I(70,60)] = {22,0x30FFFC},
    [I(71,60)] = {22,0x317FFC},
    [I(72,60)] = {22,0x31FFFC},
    [I(73,60)] = {22,0x327FFC},
    [I(74,60)] = {22,0x32FFFC},
    [I(75,60)] = {22,0x337FFC},
    [I(76,60)] = {22,0x33FFFC},
    [I(77,60)] = {22,0x347FFC},
    [I(78,60)] = {22,0x34FFFC},
    [I(79,60)] = {22,0x357FFC},
    [I(80,60)] = {22,0x35FFFC},
    [I(81,60)] = {22,0x367FFC},
    [I(82,60)] = {22,0x36FFFC},
    [I(83,60)] = {22,0x377FFC},
    [I(84,60)] = {22,0x37FFFC},
    [I(85,60)] = {22,0x387FFC},
    [I(86,60)] = {22,0x38FFFC},
    [I(87,60)] = {22,0x397FFC},
    [I(88,60)] = {23,0x7E7FFC},
    [I(89,60)] = {22,0x39FFFC},
    [I(90,60)] = {23,0x7EFFFC},
    [I(91,60)] = {28,0xFFDFFFC},
    [I(92,60)] = {64,0},
    [I(93,60)] = {28,0xFFE7FFC},
    [I(94,60)] = {29,0x1FFE7FFC},
    [I(95,60)] = {21,0x117FFC},
    [I(96,60)] = {30,0x3FFEFFFC},
    [I(97,60)] = {20,0x1FFFC},
    [I(98,60)] = {21,0x11FFFC},
    [I(99,60)] = {20,0x27FFC},
    [I(100,60)] = {21,0x127FFC},
    [I(101,60)] = {20,0x2FFFC},
    [I(102,60)] = {21,0x12FFFC},
    [I(103,60)] = {21,0x137FFC},
    [I(104,60)] = {21,0x13FFFC},
    [I(105,60)] = {20,0x37FFC},
    [I(106,60)] = {22,0x3A7FFC},
    [I(107,60)] = {22,0x3AFFFC},
    [I(108,60)] = {21,0x147FFC},
    [I(109,60)] = {21,0x14FFFC},
    [I(110,60)] = {21,0x157FFC},
    [I(111,60)] = {20,0x3FFFC},
    [I(112,60)] = {21,0x15FFFC},
    [I(113,60)] = {22,0x3B7FFC},
    [I(114,60)] = {21,0x167FFC},
    [I(115,60)] = {20,0x47FFC},
    [I(116,60)] = {20,0x4FFFC},
    [I(117,60)] = {21,0x16FFFC},
    [I(118,60)] = {22,0x3BFFFC},
    [I(119,60)] = {22,0x3C7FFC},
    [I(120,60)] = {22,0x3CFFFC},
    [I(121,60)] = {22,0x3D7FFC},
    [I(122,60)] = {22,0x3DFFFC},
    [I(123,60)] = {30,0x3FFF7FFC},
    [I(124,60)] = {26,0x3FE7FFC},
    [I(125,60)] = {29,0x1FFEFFFC},
    [I(126,60)] = {28,0xFFEFFFC},
    [I(127,60)] = {64,0},
    [I(128,60)] = {64,0},
    [I(129,60)] = {64,0},
    [I(130,60)] = {64,0},
    [I(131,60)] = {64,0},
    [I(132,60)] = {64,0},
    [I(133,60)] = {64,0},
    [I(134,60)] = {64,0},
    [I(135,60)] = {64,0},
    [I(136,60)] = {64,0},
    [I(137,60)] = {64,0},
    [I(138,60)] = {64,0},
    [I(139,60)] = {64,0},
    [I(140,60)] = {64,0},
    [I(141,60)] = {64,0},
    [I(142,60)] = {64,0},
    [I(143,60)] = {64,0},
    [I(144,60)] = {64,0},
    [I(145,60)] = {64,0},
    [I(146,60)] = {64,0},
    [I(147,60)] = {64,0},
    [I(148,60)] = {64,0},
    [I(149,60)] = {64,0},
    [I(150,60)] = {64,0},
    [I(151,60)] = {64,0},
    [I(152,60)] = {64,0},
    [I(153,60)] = {64,0},
    [I(154,60)] = {64,0},
    [I(155,60)] = {64,0},
    [I(156,60)] = {64,0},
    [I(157,60)] = {64,0},
    [I(158,60)] = {64,0},
    [I(159,60)] = {64,0},
    [I(160,60)] = {64,0},
    [I(161,60)] = {64,0},
    [I(162,60)] = {64,0},
    [I(163,60)] = {64,0},
    [I(164,60)] = {64,0},
    [I(165,60)] = {64,0},
    [I(166,60)] = {64,0},
    [I(167,60)] = {64,0},
    [I(168,60)] = {64,0},
    [I(169,60)] = {64,0},
    [I(170,60)] = {64,0},
    [I(171,60)] = {64,0},
    [I(172,60)] = {64,0},
    [I(173,60)] = {64,0},
    [I(174,60)] = {64,0},
    [I(175,60)] = {64,0},
    [I(176,60)] = {64,0},
    [I(177,60)] = {64,0},
    [I(178,60)] = {64,0},
    [I(179,60)] = {64,0},
    [I(180,60)] = {64,0},
    [I(181,60)] = {64,0},
    [I(182,60)] = {64,0},
    [I(183,60)] = {64,0},
    [I(184,60)] = {64,0},
    [I(185,60)] = {64,0},
    [I(186,60)] = {64,0},
    [I(187,60)] = {64,0},
    [I(188,60)] = {64,0},
    [I(189,60)] = {64,0},
    [I(190,60)] = {64,0},
    [I(191,60)] = {64,0},
    [I(192,60)] = {64,0},
    [I(193,60)] = {64,0},
    [I(194,60)] = {64,0},
    [I(195,60)] = {64,0},
    [I(196,60)] = {64,0},
    [I(197,60)] = {64,0},
    [I(198,60)] = {64,0},
    [I(199,60)] = {64,0},
    [I(200,60)] = {64,0},
    [I(201,60)] = {64,0},
    [I(202,60)] = {64,0},
    [I(203,60)] = {64,0},
    [I(204,60)] = {64,0},
    [I(205,60)] = {64,0},
    [I(206,60)] = {64,0},
    [I(207,60)] = {64,0},
    [I(208,60)] = {64,0},
    [I(209,60)] = {64,0},
    [I(210,60)] = {64,0},
    [I(211,60)] = {64,0},
    [I(212,60)] = {64,0},
    [I(213,60)] = {64,0},
    [I(214,60)] = {64,0},
    [I(215,60)] = {64,0},
    [I(216,60)] = {64,0},
    [I(217,60)] = {64,0},
    [I(218,60)] = {64,0},
    [I(219,60)] = {64,0},
    [I(220,60)] = {64,0},
    [I(221,60)] = {64,0},
    [I(222,60)] = {64,0},
    [I(223,60)] = {64,0},
    [I(224,60)] = {64,0},
    [I(225,60)] = {64,0},
    [I(226,60)] = {64,0},
    [I(227,60)] = {64,0},
    [I(228,60)] = {64,0},
    [I(229,60)] = {64,0},
    [I(230,60)] = {64,0},
    [I(231,60)] = {64,0},
    [I(232,60)] = {64,0},
    [I(233,60)] = {64,0},
    [I(234,60)] = {64,0},
    [I(235,60)] = {64,0},
    [I(236,60)] = {64,0},
    [I(237,60)] = {64,0},
    [I(238,60)] = {64,0},
    [I(239,60)] = {64,0},
    [I(240,60)] = {64,0},
    [I(241,60)] = {64,0},
    [I(242,60)] = {64,0},
    [I(243,60)] = {64,0},
    [I(244,60)] = {64,0},
    [I(245,60)] = {64,0},
    [I(246,60)] = {64,0},
    [I(247,60)] = {64,0},
    [I(248,60)] = {64,0},
    [I(249,60)] = {64,0},
    [I(250,60)] = {64,0},
    [I(251,60)] = {64,0},
    [I(252,60)] = {64,0},
    [I(253,60)] = {64,0},
    [I(254,60)] = {64,0},
    [I(255,60)] = {64,0},
    [I(0,61)] = {19,0x7FE20},
    [I(1,61)] = {29,0x1FFFF620},
    [I(2,61)] = {64,0},
    [I(3,61)] = {64,0},
    [I(4,61)] = {64,0},
    [I(5,61)] = {64,0},
    [I(6,61)] = {64,0},
    [I(7,61)] = {64,0},
    [I(8,61)] = {64,0},
    [I(9,61)] = {30,0x3FFFFAA0},
    [I(10,61)] = {64,0},
    [I(11,61)] = {64,0},
    [I(12,61)] = {64,0},
    [I(13,61)] = {64,0},
    [I(14,61)] = {64,0},
    [I(15,61)] = {64,0},
    [I(16,61)] = {64,0},
    [I(17,61)] = {64,0},
    [I(18,61)] = {64,0},
    [I(19,61)] = {64,0},
    [I(20,61)] = {64,0},
    [I(21,61)] = {64,0},
    [I(22,61)] = {64,0},
    [I(23,61)] = {64,0},
    [I(24,61)] = {64,0},
    [I(25,61)] = {64,0},
    [I(26,61)] = {64,0},
    [I(27,61)] = {64,0},
    [I(28,61)] = {64,0},
    [I(29,61)] = {64,0},
    [I(30,61)] = {64,0},
    [I(31,61)] = {64,0},
    [I(32,61)] = {12,0x520},
    [I(33,61)] = {16,0xFE20},
    [I(34,61)] = {16,0xFE60},
    [I(35,61)] = {18,0x3FEA0},
    [I(36,61)] = {19,0x7FE60},
    [I(37,61)] = {12,0x560},
    [I(38,61)] = {14,0x3E20},
    [I(39,61)] = {17,0x1FEA0},
    [I(40,61)] = {16,0xFEA0},
    [I(41,61)] = {16,0xFEE0},
    [I(42,61)] = {14,0x3E60},
    [I(43,61)] = {17,0x1FEE0},
    [I(44,61)] = {14,0x3EA0},
    [I(45,61)] = {12,0x5A0},
    [I(46,61)] = {12,0x5E0},
    [I(47,61)] = {12,0x620},
    [I(48,61)] = {11,0x20},
    [I(49,61)] = {11,0x60},
    [I(50,61)] = {11,0xA0},
    [I(51,61)] = {12,0x660},
    [I(52,61)] = {12,0x6A0},
    [I(53,61)] = {12,0x6E0},
    [I(54,61)] = {12,0x720},
    [I(55,61)] = {12,0x760},
    [I(56,61)] = {12,0x7A0},
    [I(57,61)] = {12,0x7E0},
    [I(58,61)] = {13,0x1720},
    [I(59,61)] = {14,0x3EE0},
    [I(60,61)] = {21,0x1FFF20},
    [I(61,61)] = {12,0x820},
    [I(62,61)] = {18,0x3FEE0},
    [I(63,61)] = {16,0xFF20},
    [I(64,61)] = {19,0x7FEA0},
    [I(65,61)] = {12,0x860},
    [I(66,61)] = {13,0x1760},
    [I(67,61)] = {13,0x17A0},
    [I(68,61)] = {13,0x17E0},
    [I(69,61)] = {13,0x1820},
    [I(70,61)] = {13,0x1860},
    [I(71,61)] = {13,0x18A0},
    [I(72,61)] = {13,0x18E0},
    [I(73,61)] = {13,0x1920},
    [I(74,61)] = {13,0x1960},
    [I(75,61)] = {13,0x19A0},
    [I(76,61)] = {13,0x19E0},
    [I(77,61)] = {13,0x1A20},
    [I(78,61)] = {13,0x1A60},
    [I(79,61)] = {13,0x1AA0},
    [I(80,61)] = {13,0x1AE0},
    [I(81,61)] = {13,0x1B20},
    [I(82,61)] = {13,0x1B60},
    [I(83,61)] = {13,0x1BA0},
    [I(84,61)] = {13,0x1BE0},
    [I(85,61)] = {13,0x1C20},
    [I(86,61)] = {13,0x1C60},
    [I(87,61)] = {13,0x1CA0},
    [I(88,61)] = {14,0x3F20},
    [I(89,61)] = {13,0x1CE0},
    [I(90,61)] = {14,0x3F60},
    [I(91,61)] = {19,0x7FEE0},
    [I(92,61)] = {25,0x1FFFC20},
    [I(93,61)] = {19,0x7FF20},
    [I(94,61)] = {20,0xFFF20},
    [I(95,61)] = {12,0x8A0},
    [I(96,61)] = {21,0x1FFF60},
    [I(97,61)] = {11,0xE0},
    [I(98,61)] = {12,0x8E0},
    [I(99,61)] = {11,0x120},
    [I(100,61)] = {12,0x920},
    [I(101,61)] = {11,0x160},
    [I(102,61)] = {12,0x960},
    [I(103,61)] = {12,0x9A0},
    [I(104,61)] = {12,0x9E0},
    [I(105,61)] = {11,0x1A0},
    [I(106,61)] = {13,0x1D20},
    [I(107,61)] = {13,0x1D60},
    [I(108,61)] = {12,0xA20},
    [I(109,61)] = {12,0xA60},
    [I(110,61)] = {12,0xAA0},
    [I(111,61)] = {11,0x1E0},
    [I(112,61)] = {12,0xAE0},
    [I(113,61)] = {13,0x1DA0},
    [I(114,61)] = {12,0xB20},
    [I(115,61)] = {11,0x220},
    [I(116,61)] = {11,0x260},
    [I(117,61)] = {12,0xB60},
    [I(118,61)] = {13,0x1DE0},
    [I(119,61)] = {13,0x1E20},
    [I(120,61)] = {13,0x1E60},
    [I(121,61)] = {13,0x1EA0},
    [I(122,61)] = {13,0x1EE0},
    [I(123,61)] = {21,0x1FFFA0},
    [I(124,61)] = {17,0x1FF20},
    [I(125,61)] = {20,0xFFF60},
    [I(126,61)] = {19,0x7FF60},
    [I(127,61)] = {64,0},
    [I(128,61)] = {26,0x3FFF9A0},
    [I(129,61)] = {28,0xFFFF4A0},
    [I(130,61)] = {26,0x3FFF9E0},
    [I(131,61)] = {26,0x3FFFA20},
    [I(132,61)] = {28,0xFFFF4E0},
    [I(133,61)] = {28,0xFFFF520},
    [I(134,61)] = {28,0xFFFF560},
    [I(135,61)] = {29,0x1FFFF660},
    [I(136,61)] = {28,0xFFFF5A0},
    [I(137,61)] = {29,0x1FFFF6A0},
    [I(138,61)] = {29,0x1FFFF6E0},
    [I(139,61)] = {29,0x1FFFF720},
    [I(140,61)] = {29,0x1FFFF760},
    [I(141,61)] = {29,0x1FFFF7A0},
    [I(142,61)] = {30,0x3FFFFAE0},
    [I(143,61)] = {29,0x1FFFF7E0},
    [I(144,61)] = {30,0x3FFFFB20},
    [I(145,61)] = {30,0x3FFFFB60},
    [I(146,61)] = {28,0xFFFF5E0},
    [I(147,61)] = {29,0x1FFFF820},
    [I(148,61)] = {30,0x3FFFFBA0},
    [I(149,61)] = {29,0x1FFFF860},
    [I(150,61)] = {29,0x1FFFF8A0},
    [I(151,61)] = {29,0x1FFFF8E0},
    [I(152,61)] = {29,0x1FFFF920},
    [I(153,61)] = {27,0x7FFF720},
    [I(154,61)] = {28,0xFFFF620},
    [I(155,61)] = {29,0x1FFFF960},
    [I(156,61)] = {28,0xFFFF660},
    [I(157,61)] = {29,0x1FFFF9A0},
    [I(158,61)] = {29,0x1FFFF9E0},
    [I(159,61)] = {30,0x3FFFFBE0},
    [I(160,61)] = {28,0xFFFF6A0},
    [I(161,61)] = {27,0x7FFF760},
    [I(162,61)] = {26,0x3FFFA60},
    [I(163,61)] = {28,0xFFFF6E0},
    [I(164,61)] = {28,0xFFFF720},
    [I(165,61)] = {29,0x1FFFFA20},
    [I(166,61)] = {29,0x1FFFFA60},
    [I(167,61)] = {27,0x7FFF7A0},
    [I(168,61)] = {29,0x1FFFFAA0},
    [I(169,61)] = {28,0xFFFF760},
    [I(170,61)] = {28,0xFFFF7A0},
    [I(171,61)] = {30,0x3FFFFC20},
    [I(172,61)] = {27,0x7FFF7E0},
    [I(173,61)] = {28,0xFFFF7E0},
    [I(174,61)] = {29,0x1FFFFAE0},
    [I(175,61)] = {29,0x1FFFFB20},
    [I(176,61)] = {27,0x7FFF820},
    [I(177,61)] = {27,0x7FFF860},
    [I(178,61)] = {28,0xFFFF820},
    [I(179,61)] = {27,0x7FFF8A0},
    [I(180,61)] = {29,0x1FFFFB60},
    [I(181,61)] = {28,0xFFFF860},
    [I(182,61)] = {29,0x1FFFFBA0},
    [I(183,61)] = {29,0x1FFFFBE0},
    [I(184,61)] = {26,0x3FFFAA0},
    [I(185,61)] = {28,0xFFFF8A0},
    [I(186,61)] = {28,0xFFFF8E0},
    [I(187,61)] = {28,0xFFFF920},
    [I(188,61)] = {29,0x1FFFFC20},
    [I(189,61)] = {28,0xFFFF960},
    [I(190,61)] = {28,0xFFFF9A0},
    [I(191,61)] = {29,0x1FFFFC60},
    [I(192,61)] = {X32,0xFFFFF820},
    [I(193,61)] = {X32,0xFFFFF860},
    [I(194,61)] = {26,0x3FFFAE0},
    [I(195,61)] = {25,0x1FFFC60},
    [I(196,61)] = {28,0xFFFF9E0},
    [I(197,61)] = {29,0x1FFFFCA0},
    [I(198,61)] = {28,0xFFFFA20},
    [I(199,61)] = {31,0x7FFFFB20},
    [I(200,61)] = {X32,0xFFFFF8A0},
    [I(201,61)] = {X32,0xFFFFF8E0},
    [I(202,61)] = {X32,0xFFFFF920},
    [I(203,61)] = {64,0},
    [I(204,61)] = {64,0},
    [I(205,61)] = {X32,0xFFFFF960},
    [I(206,61)] = {30,0x3FFFFC60},
    [I(207,61)] = {31,0x7FFFFB60},
    [I(208,61)] = {25,0x1FFFCA0},
    [I(209,61)] = {27,0x7FFF8E0},
    [I(210,61)] = {X32,0xFFFFF9A0},
    [I(211,61)] = {64,0},
    [I(212,61)] = {64,0},
    [I(213,61)] = {X32,0xFFFFF9E0},
    [I(214,61)] = {64,0},
    [I(215,61)] = {30,0x3FFFFCA0},
    [I(216,61)] = {27,0x7FFF920},
    [I(217,61)] = {27,0x7FFF960},
    [I(218,61)] = {X32,0xFFFFFA20},
    [I(219,61)] = {X32,0xFFFFFA60},
    [I(220,61)] = {64,0},
    [I(221,61)] = {64,0},
    [I(222,61)] = {64,0},
    [I(223,61)] = {64,0},
    [I(224,61)] = {26,0x3FFFB20},
    [I(225,61)] = {30,0x3FFFFCE0},
    [I(226,61)] = {26,0x3FFFB60},
    [I(227,61)] = {27,0x7FFF9A0},
    [I(228,61)] = {28,0xFFFFA60},
    [I(229,61)] = {27,0x7FFF9E0},
    [I(230,61)] = {27,0x7FFFA20},
    [I(231,61)] = {29,0x1FFFFCE0},
    [I(232,61)] = {28,0xFFFFAA0},
    [I(233,61)] = {28,0xFFFFAE0},
    [I(234,61)] = {31,0x7FFFFBA0},
    [I(235,61)] = {31,0x7FFFFBE0},
    [I(236,61)] = {30,0x3FFFFD20},
    [I(237,61)] = {30,0x3FFFFD60},
    [I(238,61)] = {X32,0xFFFFFAA0},
    [I(239,61)] = {29,0x1FFFFD20},
    [I(240,61)] = {X32,0xFFFFFAE0},
    [I(241,61)] = {64,0},
    [I(242,61)] = {X32,0xFFFFFB20},
    [I(243,61)] = {X32,0xFFFFFB60},
    [I(244,61)] = {64,0},
    [I(245,61)] = {64,0},
    [I(246,61)] = {64,0},
    [I(247,61)] = {64,0},
    [I(248,61)] = {64,0},
    [I(249,61)] = {64,0},
    [I(250,61)] = {64,0},
    [I(251,61)] = {64,0},
    [I(252,61)] = {64,0},
    [I(253,61)] = {64,0},
    [I(254,61)] = {64,0},
    [I(255,61)] = {X32,0xFFFFFBA0},
    [I(0,62)] = {25,0x1FF8FFB},
    [I(1,62)] = {64,0},
    [I(2,62)] = {64,0},
    [I(3,62)] = {64,0},
    [I(4,62)] = {64,0},
    [I(5,62)] = {64,0},
    [I(6,62)] = {64,0},
    [I(7,62)] = {64,0},
    [I(8,62)] = {64,0},
    [I(9,62)] = {64,0},
    [I(10,62)] = {64,0},
    [I(11,62)] = {64,0},
    [I(12,62)] = {64,0},
    [I(13,62)] = {64,0},
    [I(14,62)] = {64,0},
    [I(15,62)] = {64,0},
    [I(16,62)] = {64,0},
    [I(17,62)] = {64,0},
    [I(18,62)] = {64,0},
    [I(19,62)] = {64,0},
    [I(20,62)] = {64,0},
    [I(21,62)] = {64,0},
    [I(22,62)] = {64,0},
    [I(23,62)] = {64,0},
    [I(24,62)] = {64,0},
    [I(25,62)] = {64,0},
    [I(26,62)] = {64,0},
    [I(27,62)] = {64,0},
    [I(28,62)] = {64,0},
    [I(29,62)] = {64,0},
    [I(30,62)] = {64,0},
    [I(31,62)] = {64,0},
    [I(32,62)] = {18,0x14FFB},
    [I(33,62)] = {22,0x3F8FFB},
    [I(34,62)] = {22,0x3F9FFB},
    [I(35,62)] = {24,0xFFAFFB},
    [I(36,62)] = {25,0x1FF9FFB},
    [I(37,62)] = {18,0x15FFB},
    [I(38,62)] = {20,0xF8FFB},
    [I(39,62)] = {23,0x7FAFFB},
    [I(40,62)] = {22,0x3FAFFB},
    [I(41,62)] = {22,0x3FBFFB},
    [I(42,62)] = {20,0xF9FFB},
    [I(43,62)] = {23,0x7FBFFB},
    [I(44,62)] = {20,0xFAFFB},
    [I(45,62)] = {18,0x16FFB},
    [I(46,62)] = {18,0x17FFB},
    [I(47,62)] = {18,0x18FFB},
    [I(48,62)] = {17,0xFFB},
    [I(49,62)] = {17,0x1FFB},
    [I(50,62)] = {17,0x2FFB},
    [I(51,62)] = {18,0x19FFB},
    [I(52,62)] = {18,0x1AFFB},
    [I(53,62)] = {18,0x1BFFB},
    [I(54,62)] = {18,0x1CFFB},
    [I(55,62)] = {18,0x1DFFB},
    [I(56,62)] = {18,0x1EFFB},
    [I(57,62)] = {18,0x1FFFB},
    [I(58,62)] = {19,0x5CFFB},
    [I(59,62)] = {20,0xFBFFB},
    [I(60,62)] = {27,0x7FFCFFB},
    [I(61,62)] = {18,0x20FFB},
    [I(62,62)] = {24,0xFFBFFB},
    [I(63,62)] = {22,0x3FCFFB},
    [I(64,62)] = {25,0x1FFAFFB},
    [I(65,62)] = {18,0x21FFB},
    [I(66,62)] = {19,0x5DFFB},
    [I(67,62)] = {19,0x5EFFB},
    [I(68,62)] = {19,0x5FFFB},
    [I(69,62)] = {19,0x60FFB},
    [I(70,62)] = {19,0x61FFB},
    [I(71,62)] = {19,0x62FFB},
    [I(72,62)] = {19,0x63FFB},
    [I(73,62)] = {19,0x64FFB},
    [I(74,62)] = {19,0x65FFB},
    [I(75,62)] = {19,0x66FFB},
    [I(76,62)] = {19,0x67FFB},
    [I(77,62)] = {19,0x68FFB},
    [I(78,62)] = {19,0x69FFB},
    [I(79,62)] = {19,0x6AFFB},
    [I(80,62)] = {19,0x6BFFB},
    [I(81,62)] = {19,0x6CFFB},
    [I(82,62)] = {19,0x6DFFB},
    [I(83,62)] = {19,0x6EFFB},
    [I(84,62)] = {19,0x6FFFB},
    [I(85,62)] = {19,0x70FFB},
    [I(86,62)] = {19,0x71FFB},
    [I(87,62)] = {19,0x72FFB},
    [I(88,62)] = {20,0xFCFFB},
    [I(89,62)] = {19,0x73FFB},
    [I(90,62)] = {20,0xFDFFB},
    [I(91,62)] = {25,0x1FFBFFB},
    [I(92,62)] = {31,0x7FFF0FFB},
    [I(93,62)] = {25,0x1FFCFFB},
    [I(94,62)] = {26,0x3FFCFFB},
    [I(95,62)] = {18,0x22FFB},
    [I(96,62)] = {27,0x7FFDFFB},
    [I(97,62)] = {17,0x3FFB},
    [I(98,62)] = {18,0x23FFB},
    [I(99,62)] = {17,0x4FFB},
    [I(100,62)] = {18,0x24FFB},
    [I(101,62)] = {17,0x5FFB},
    [I(102,62)] = {18,0x25FFB},
    [I(103,62)] = {18,0x26FFB},
    [I(104,62)] = {18,0x27FFB},
    [I(105,62)] = {17,0x6FFB},
    [I(106,62)] = {19,0x74FFB},
    [I(107,62)] = {19,0x75FFB},
    [I(108,62)] = {18,0x28FFB},
    [I(109,62)] = {18,0x29FFB},
    [I(110,62)] = {18,0x2AFFB},
    [I(111,62)] = {17,0x7FFB},
    [I(112,62)] = {18,0x2BFFB},
    [I(113,62)] = {19,0x76FFB},
    [I(114,62)] = {18,0x2CFFB},
    [I(115,62)] = {17,0x8FFB},
    [I(116,62)] = {17,0x9FFB},
    [I(117,62)] = {18,0x2DFFB},
    [I(118,62)] = {19,0x77FFB},
    [I(119,62)] = {19,0x78FFB},
    [I(120,62)] = {19,0x79FFB},
    [I(121,62)] = {19,0x7AFFB},
    [I(122,62)] = {19,0x7BFFB},
    [I(123,62)] = {27,0x7FFEFFB},
    [I(124,62)] = {23,0x7FCFFB},
    [I(125,62)] = {26,0x3FFDFFB},
    [I(126,62)] = {25,0x1FFDFFB},
    [I(127,62)] = {64,0},
    [I(128,62)] = {X32,0xFFFE6FFB},
    [I(129,62)] = {64,0},
    [I(130,62)] = {X32,0xFFFE7FFB},
    [I(131,62)] = {X32,0xFFFE8FFB},
    [I(132,62)] = {64,0},
    [I(133,62)] = {64,0},
    [I(134,62)] = {64,0},
    [I(135,62)] = {64,0},
    [I(136,62)] = {64,0},
    [I(137,62)] = {64,0},
    [I(138,62)] = {64,0},
    [I(139,62)] = {64,0},
    [I(140,62)] = {64,0},
    [I(141,62)] = {64,0},
    [I(142,62)] = {64,0},
    [I(143,62)] = {64,0},
    [I(144,62)] = {64,0},
    [I(145,62)] = {64,0},
    [I(146,62)] = {64,0},
    [I(147,62)] = {64,0},
    [I(148,62)] = {64,0},
    [I(149,62)] = {64,0},
    [I(150,62)] = {64,0},
    [I(151,62)] = {64,0},
    [I(152,62)] = {64,0},
    [I(153,62)] = {64,0},
    [I(154,62)] = {64,0},
    [I(155,62)] = {64,0},
    [I(156,62)] = {64,0},
    [I(157,62)] = {64,0},
    [I(158,62)] = {64,0},
    [I(159,62)] = {64,0},
    [I(160,62)] = {64,0},
    [I(161,62)] = {64,0},
    [I(162,62)] = {X32,0xFFFE9FFB},
    [I(163,62)] = {64,0},
    [I(164,62)] = {64,0},
    [I(165,62)] = {64,0},
    [I(166,62)] = {64,0},
    [I(167,62)] = {64,0},
    [I(168,62)] = {64,0},
    [I(169,62)] = {64,0},
    [I(170,62)] = {64,0},
    [I(171,62)] = {64,0},
    [I(172,62)] = {64,0},
    [I(173,62)] = {64,0},
    [I(174,62)] = {64,0},
    [I(175,62)] = {64,0},
    [I(176,62)] = {64,0},
    [I(177,62)] = {64,0},
    [I(178,62)] = {64,0},
    [I(179,62)] = {64,0},
    [I(180,62)] = {64,0},
    [I(181,62)] = {64,0},
    [I(182,62)] = {64,0},
    [I(183,62)] = {64,0},
    [I(184,62)] = {X32,0xFFFEAFFB},
    [I(185,62)] = {64,0},
    [I(186,62)] = {64,0},
    [I(187,62)] = {64,0},
    [I(188,62)] = {64,0},
    [I(189,62)] = {64,0},
    [I(190,62)] = {64,0},
    [I(191,62)] = {64,0},
    [I(192,62)] = {64,0},
    [I(193,62)] = {64,0},
    [I(194,62)] = {X32,0xFFFEBFFB},
    [I(195,62)] = {31,0x7FFF1FFB},
    [I(196,62)] = {64,0},
    [I(197,62)] = {64,0},
    [I(198,62)] = {64,0},
    [I(199,62)] = {64,0},
    [I(200,62)] = {64,0},
    [I(201,62)] = {64,0},
    [I(202,62)] = {64,0},
    [I(203,62)] = {64,0},
    [I(204,62)] = {64,0},
    [I(205,62)] = {64,0},
    [I(206,62)] = {64,0},
    [I(207,62)] = {64,0},
    [I(208,62)] = {31,0x7FFF2FFB},
    [I(209,62)] = {64,0},
    [I(210,62)] = {64,0},
    [I(211,62)] = {64,0},
    [I(212,62)] = {64,0},
    [I(213,62)] = {64,0},
    [I(214,62)] = {64,0},
    [I(215,62)] = {64,0},
    [I(216,62)] = {64,0},
    [I(217,62)] = {64,0},
    [I(218,62)] = {64,0},
    [I(219,62)] = {64,0},
    [I(220,62)] = {64,0},
    [I(221,62)] = {64,0},
    [I(222,62)] = {64,0},
    [I(223,62)] = {64,0},
    [I(224,62)] = {X32,0xFFFECFFB},
    [I(225,62)] = {64,0},
    [I(226,62)] = {X32,0xFFFEDFFB},
    [I(227,62)] = {64,0},
    [I(228,62)] = {64,0},
    [I(229,62)] = {64,0},
    [I(230,62)] = {64,0},
    [I(231,62)] = {64,0},
    [I(232,62)] = {64,0},
    [I(233,62)] = {64,0},
    [I(234,62)] = {64,0},
    [I(235,62)] = {64,0},
    [I(236,62)] = {64,0},
    [I(237,62)] = {64,0},
    [I(238,62)] = {64,0},
    [I(239,62)] = {64,0},
    [I(240,62)] = {64,0},
    [I(241,62)] = {64,0},
    [I(242,62)] = {64,0},
    [I(243,62)] = {64,0},
    [I(244,62)] = {64,0},
    [I(245,62)] = {64,0},
    [I(246,62)] = {64,0},
    [I(247,62)] = {64,0},
    [I(248,62)] = {64,0},
    [I(249,62)] = {64,0},
    [I(250,62)] = {64,0},
    [I(251,62)] = {64,0},
    [I(252,62)] = {64,0},
    [I(253,62)] = {64,0},
    [I(254,62)] = {64,0},
    [I(255,62)] = {64,0},
    [I(0,63)] = {23,0x7FE3FC},
    [I(1,63)] = {64,0},
    [I(2,63)] = {64,0},
    [I(3,63)] = {64,0},
    [I(4,63)] = {64,0},
    [I(5,63)] = {64,0},
    [I(6,63)] = {64,0},
    [I(7,63)] = {64,0},
    [I(8,63)] = {64,0},
    [I(9,63)] = {64,0},
    [I(10,63)] = {64,0},
    [I(11,63)] = {64,0},
    [I(12,63)] = {64,0},
    [I(13,63)] = {64,0},
    [I(14,63)] = {64,0},
    [I(15,63)] = {64,0},
    [I(16,63)] = {64,0},
    [I(17,63)] = {64,0},
    [I(18,63)] = {64,0},
    [I(19,63)] = {64,0},
    [I(20,63)] = {64,0},
    [I(21,63)] = {64,0},
    [I(22,63)] = {64,0},
    [I(23,63)] = {64,0},
    [I(24,63)] = {64,0},
    [I(25,63)] = {64,0},
    [I(26,63)] = {64,0},
    [I(27,63)] = {64,0},
    [I(28,63)] = {64,0},
    [I(29,63)] = {64,0},
    [I(30,63)] = {64,0},
    [I(31,63)] = {64,0},
    [I(32,63)] = {16,0x53FC},
    [I(33,63)] = {20,0xFE3FC},
    [I(34,63)] = {20,0xFE7FC},
    [I(35,63)] = {22,0x3FEBFC},
    [I(36,63)] = {23,0x7FE7FC},
    [I(37,63)] = {16,0x57FC},
    [I(38,63)] = {18,0x3E3FC},
    [I(39,63)] = {21,0x1FEBFC},
    [I(40,63)] = {20,0xFEBFC},
    [I(41,63)] = {20,0xFEFFC},
    [I(42,63)] = {18,0x3E7FC},
    [I(43,63)] = {21,0x1FEFFC},
    [I(44,63)] = {18,0x3EBFC},
    [I(45,63)] = {16,0x5BFC},
    [I(46,63)] = {16,0x5FFC},
    [I(47,63)] = {16,0x63FC},
    [I(48,63)] = {15,0x3FC},
    [I(49,63)] = {15,0x7FC},
    [I(50,63)] = {15,0xBFC},
    [I(51,63)] = {16,0x67FC},
    [I(52,63)] = {16,0x6BFC},
    [I(53,63)] = {16,0x6FFC},
    [I(54,63)] = {16,0x73FC},
    [I(55,63)] = {16,0x77FC},
    [I(56,63)] = {16,0x7BFC},
    [I(57,63)] = {16,0x7FFC},
    [I(58,63)] = {17,0x173FC},
    [I(59,63)] = {18,0x3EFFC},
    [I(60,63)] = {25,0x1FFF3FC},
    [I(61,63)] = {16,0x83FC},
    [I(62,63)] = {22,0x3FEFFC},
    [I(63,63)] = {20,0xFF3FC},
    [I(64,63)] = {23,0x7FEBFC},
    [I(65,63)] = {16,0x87FC},
    [I(66,63)] = {17,0x177FC},
    [I(67,63)] = {17,0x17BFC},
    [I(68,63)] = {17,0x17FFC},
    [I(69,63)] = {17,0x183FC},
    [I(70,63)] = {17,0x187FC},
    [I(71,63)] = {17,0x18BFC},
    [I(72,63)] = {17,0x18FFC},
    [I(73,63)] = {17,0x193FC},
    [I(74,63)] = {17,0x197FC},
    [I(75,63)] = {17,0x19BFC},
    [I(76,63)] = {17,0x19FFC},
    [I(77,63)] = {17,0x1A3FC},
    [I(78,63)] = {17,0x1A7FC},
    [I(79,63)] = {17,0x1ABFC},
    [I(80,63)] = {17,0x1AFFC},
    [I(81,63)] = {17,0x1B3FC},
    [I(82,63)] = {17,0x1B7FC},
    [I(83,63)] = {17,0x1BBFC},
    [I(84,63)] = {17,0x1BFFC},
    [I(85,63)] = {17,0x1C3FC},
    [I(86,63)] = {17,0x1C7FC},
    [I(87,63)] = {17,0x1CBFC},
    [I(88,63)] = {18,0x3F3FC},
    [I(89,63)] = {17,0x1CFFC},
    [I(90,63)] = {18,0x3F7FC},
    [I(91,63)] = {23,0x7FEFFC},
    [I(92,63)] = {29,0x1FFFC3FC},
    [I(93,63)] = {23,0x7FF3FC},
    [I(94,63)] = {24,0xFFF3FC},
    [I(95,63)] = {16,0x8BFC},
    [I(96,63)] = {25,0x1FFF7FC},
    [I(97,63)] = {15,0xFFC},
    [I(98,63)] = {16,0x8FFC},
    [I(99,63)] = {15,0x13FC},
    [I(100,63)] = {16,0x93FC},
    [I(101,63)] = {15,0x17FC},
    [I(102,63)] = {16,0x97FC},
    [I(103,63)] = {16,0x9BFC},
    [I(104,63)] = {16,0x9FFC},
    [I(105,63)] = {15,0x1BFC},
    [I(106,63)] = {17,0x1D3FC},
    [I(107,63)] = {17,0x1D7FC},
    [I(108,63)] = {16,0xA3FC},
    [I(109,63)] = {16,0xA7FC},
    [I(110,63)] = {16,0xABFC},
    [I(111,63)] = {15,0x1FFC},
    [I(112,63)] = {16,0xAFFC},
    [I(113,63)] = {17,0x1DBFC},
    [I(114,63)] = {16,0xB3FC},
    [I(115,63)] = {15,0x23FC},
    [I(116,63)] = {15,0x27FC},
    [I(117,63)] = {16,0xB7FC},
    [I(118,63)] = {17,0x1DFFC},
    [I(119,63)] = {17,0x1E3FC},
    [I(120,63)] = {17,0x1E7FC},
    [I(121,63)] = {17,0x1EBFC},
    [I(122,63)] = {17,0x1EFFC},
    [I(123,63)] = {25,0x1FFFBFC},
    [I(124,63)] = {21,0x1FF3FC},
    [I(125,63)] = {24,0xFFF7FC},
    [I(126,63)] = {23,0x7FF7FC},
    [I(127,63)] = {64,0},
    [I(128,63)] = {30,0x3FFF9BFC},
    [I(129,63)] = {X32,0xFFFF4BFC},
    [I(130,63)] = {30,0x3FFF9FFC},
    [I(131,63)] = {30,0x3FFFA3FC},
    [I(132,63)] = {X32,0xFFFF4FFC},
    [I(133,63)] = {X32,0xFFFF53FC},
    [I(134,63)] = {X32,0xFFFF57FC},
    [I(135,63)] = {64,0},
    [I(136,63)] = {X32,0xFFFF5BFC},
    [I(137,63)] = {64,0},
    [I(138,63)] = {64,0},
    [I(139,63)] = {64,0},
    [I(140,63)] = {64,0},
    [I(141,63)] = {64,0},
    [I(142,63)] = {64,0},
    [I(143,63)] = {64,0},
    [I(144,63)] = {64,0},
    [I(145,63)] = {64,0},
    [I(146,63)] = {X32,0xFFFF5FFC},
    [I(147,63)] = {64,0},
    [I(148,63)] = {64,0},
    [I(149,63)] = {64,0},
    [I(150,63)] = {64,0},
    [I(151,63)] = {64,0},
    [I(152,63)] = {64,0},
    [I(153,63)] = {31,0x7FFF73FC},
    [I(154,63)] = {X32,0xFFFF63FC},
    [I(155,63)] = {64,0},
    [I(156,63)] = {X32,0xFFFF67FC},
    [I(157,63)] = {64,0},
    [I(158,63)] = {64,0},
    [I(159,63)] = {64,0},
    [I(160,63)] = {X32,0xFFFF6BFC},
    [I(161,63)] = {31,0x7FFF77FC},
    [I(162,63)] = {30,0x3FFFA7FC},
    [I(163,63)] = {X32,0xFFFF6FFC},
    [I(164,63)] = {X32,0xFFFF73FC},
    [I(165,63)] = {64,0},
    [I(166,63)] = {64,0},
    [I(167,63)] = {31,0x7FFF7BFC},
    [I(168,63)] = {64,0},
    [I(169,63)] = {X32,0xFFFF77FC},
    [I(170,63)] = {X32,0xFFFF7BFC},
    [I(171,63)] = {64,0},
    [I(172,63)] = {31,0x7FFF7FFC},
    [I(173,63)] = {X32,0xFFFF7FFC},
    [I(174,63)] = {64,0},
    [I(175,63)] = {64,0},
    [I(176,63)] = {31,0x7FFF83FC},
    [I(177,63)] = {31,0x7FFF87FC},
    [I(178,63)] = {X32,0xFFFF83FC},
    [I(179,63)] = {31,0x7FFF8BFC},
    [I(180,63)] = {64,0},
    [I(181,63)] = {X32,0xFFFF87FC},
    [I(182,63)] = {64,0},
    [I(183,63)] = {64,0},
    [I(184,63)] = {30,0x3FFFABFC},
    [I(185,63)] = {X32,0xFFFF8BFC},
    [I(186,63)] = {X32,0xFFFF8FFC},
    [I(187,63)] = {X32,0xFFFF93FC},
    [I(188,63)] = {64,0},
    [I(189,63)] = {X32,0xFFFF97FC},
    [I(190,63)] = {X32,0xFFFF9BFC},
    [I(191,63)] = {64,0},
    [I(192,63)] = {64,0},
    [I(193,63)] = {64,0},
    [I(194,63)] = {30,0x3FFFAFFC},
    [I(195,63)] = {29,0x1FFFC7FC},
    [I(196,63)] = {X32,0xFFFF9FFC},
    [I(197,63)] = {64,0},
    [I(198,63)] = {X32,0xFFFFA3FC},
    [I(199,63)] = {64,0},
    [I(200,63)] = {64,0},
    [I(201,63)] = {64,0},
    [I(202,63)] = {64,0},
    [I(203,63)] = {64,0},
    [I(204,63)] = {64,0},
    [I(205,63)] = {64,0},
    [I(206,63)] = {64,0},
    [I(207,63)] = {64,0},
    [I(208,63)] = {29,0x1FFFCBFC},
    [I(209,63)] = {31,0x7FFF8FFC},
    [I(210,63)] = {64,0},
    [I(211,63)] = {64,0},
    [I(212,63)] = {64,0},
    [I(213,63)] = {64,0},
    [I(214,63)] = {64,0},
    [I(215,63)] = {64,0},
    [I(216,63)] = {31,0x7FFF93FC},
    [I(217,63)] = {31,0x7FFF97FC},
    [I(218,63)] = {64,0},
    [I(219,63)] = {64,0},
    [I(220,63)] = {64,0},
    [I(221,63)] = {64,0},
    [I(222,63)] = {64,0},
    [I(223,63)] = {64,0},
    [I(224,63)] = {30,0x3FFFB3FC},
    [I(225,63)] = {64,0},
    [I(226,63)] = {30,0x3FFFB7FC},
    [I(227,63)] = {31,0x7FFF9BFC},
    [I(228,63)] = {X32,0xFFFFA7FC},
    [I(229,63)] = {31,0x7FFF9FFC},
    [I(230,63)] = {31,0x7FFFA3FC},
    [I(231,63)] = {64,0},
    [I(232,63)] = {X32,0xFFFFABFC},
    [I(233,63)] = {X32,0xFFFFAFFC},
    [I(234,63)] = {64,0},
    [I(235,63)] = {64,0},
    [I(236,63)] = {64,0},
    [I(237,63)] = {64,0},
    [I(238,63)] = {64,0},
    [I(239,63)] = {64,0},
    [I(240,63)] = {64,0},
    [I(241,63)] = {64,0},
    [I(242,63)] = {64,0},
    [I(243,63)] = {64,0},
    [I(244,63)] = {64,0},
    [I(245,63)] = {64,0},
    [I(246,63)] = {64,0},
    [I(247,63)] = {64,0},
    [I(248,63)] = {64,0},
    [I(249,63)] = {64,0},
    [I(250,63)] = {64,0},
    [I(251,63)] = {64,0},
    [I(252,63)] = {64,0},
    [I(253,63)] = {64,0},
    [I(254,63)] = {64,0},
    [I(255,63)] = {64,0},
    [I(0,64)] = {26,0x3FF1FFA},
    [I(1,64)] = {64,0},
    [I(2,64)] = {64,0},
    [I(3,64)] = {64,0},
    [I(4,64)] = {64,0},
    [I(5,64)] = {64,0},
    [I(6,64)] = {64,0},
    [I(7,64)] = {64,0},
    [I(8,64)] = {64,0},
    [I(9,64)] = {64,0},
    [I(10,64)] = {64,0},
    [I(11,64)] = {64,0},
    [I(12,64)] = {64,0},
    [I(13,64)] = {64,0},
    [I(14,64)] = {64,0},
    [I(15,64)] = {64,0},
    [I(16,64)] = {64,0},
    [I(17,64)] = {64,0},
    [I(18,64)] = {64,0},
    [I(19,64)] = {64,0},
    [I(20,64)] = {64,0},
    [I(21,64)] = {64,0},
    [I(22,64)] = {64,0},
    [I(23,64)] = {64,0},
    [I(24,64)] = {64,0},
    [I(25,64)] = {64,0},
    [I(26,64)] = {64,0},
    [I(27,64)] = {64,0},
    [I(28,64)] = {64,0},
    [I(29,64)] = {64,0},
    [I(30,64)] = {64,0},
    [I(31,64)] = {64,0},
    [I(32,64)] = {19,0x29FFA},
    [I(33,64)] = {23,0x7F1FFA},
    [I(34,64)] = {23,0x7F3FFA},
    [I(35,64)] = {25,0x1FF5FFA},
    [I(36,64)] = {26,0x3FF3FFA},
    [I(37,64)] = {19,0x2BFFA},
    [I(38,64)] = {21,0x1F1FFA},
    [I(39,64)] = {24,0xFF5FFA},
    [I(40,64)] = {23,0x7F5FFA},
    [I(41,64)] = {23,0x7F7FFA},
    [I(42,64)] = {21,0x1F3FFA},
    [I(43,64)] = {24,0xFF7FFA},
    [I(44,64)] = {21,0x1F5FFA},
    [I(45,64)] = {19,0x2DFFA},
    [I(46,64)] = {19,0x2FFFA},
    [I(47,64)] = {19,0x31FFA},
    [I(48,64)] = {18,0x1FFA},
    [I(49,64)] = {18,0x3FFA},
    [I(50,64)] = {18,0x5FFA},
    [I(51,64)] = {19,0x33FFA},
    [I(52,64)] = {19,0x35FFA},
    [I(53,64)] = {19,0x37FFA},
    [I(54,64)] = {19,0x39FFA},
    [I(55,64)] = {19,0x3BFFA},
    [I(56,64)] = {19,0x3DFFA},
    [I(57,64)] = {19,0x3FFFA},
    [I(58,64)] = {20,0xB9FFA},
    [I(59,64)] = {21,0x1F7FFA},
    [I(60,64)] = {28,0xFFF9FFA},
    [I(61,64)] = {19,0x41FFA},
    [I(62,64)] = {25,0x1FF7FFA},
    [I(63,64)] = {23,0x7F9FFA},
    [I(64,64)] = {26,0x3FF5FFA},
    [I(65,64)] = {19,0x43FFA},
    [I(66,64)] = {20,0xBBFFA},
    [I(67,64)] = {20,0xBDFFA},
    [I(68,64)] = {20,0xBFFFA},
    [I(69,64)] = {20,0xC1FFA},
    [I(70,64)] = {20,0xC3FFA},
    [I(71,64)] = {20,0xC5FFA},
    [I(72,64)] = {20,0xC7FFA},
    [I(73,64)] = {20,0xC9FFA},
    [I(74,64)] = {20,0xCBFFA},
    [I(75,64)] = {20,0xCDFFA},
    [I(76,64)] = {20,0xCFFFA},
    [I(77,64)] = {20,0xD1FFA},
    [I(78,64)] = {20,0xD3FFA},
    [I(79,64)] = {20,0xD5FFA},
    [I(80,64)] = {20,0xD7FFA},
    [I(81,64)] = {20,0xD9FFA},
    [I(82,64)] = {20,0xDBFFA},
    [I(83,64)] = {20,0xDDFFA},
    [I(84,64)] = {20,0xDFFFA},
    [I(85,64)] = {20,0xE1FFA},
    [I(86,64)] = {20,0xE3FFA},
    [I(87,64)] = {20,0xE5FFA},
    [I(88,64)] = {21,0x1F9FFA},
    [I(89,64)] = {20,0xE7FFA},
    [I(90,64)] = {21,0x1FBFFA},
    [I(91,64)] = {26,0x3FF7FFA},
    [I(92,64)] = {X32,0xFFFE1FFA},
    [I(93,64)] = {26,0x3FF9FFA},
    [I(94,64)] = {27,0x7FF9FFA},
    [I(95,64)] = {19,0x45FFA},
    [I(96,64)] = {28,0xFFFBFFA},
    [I(97,64)] = {18,0x7FFA},
    [I(98,64)] = {19,0x47FFA},
    [I(99,64)] = {18,0x9FFA},
    [I(100,64)] = {19,0x49FFA},
    [I(101,64)] = {18,0xBFFA},
    [I(102,64)] = {19,0x4BFFA},
    [I(103,64)] = {19,0x4DFFA},
    [I(104,64)] = {19,0x4FFFA},
    [I(105,64)] = {18,0xDFFA},
    [I(106,64)] = {20,0xE9FFA},
    [I(107,64)] = {20,0xEBFFA},
    [I(108,64)] = {19,0x51FFA},
    [I(109,64)] = {19,0x53FFA},
    [I(110,64)] = {19,0x55FFA},
    [I(111,64)] = {18,0xFFFA},
    [I(112,64)] = {19,0x57FFA},
    [I(113,64)] = {20,0xEDFFA},
    [I(114,64)] = {19,0x59FFA},
    [I(115,64)] = {18,0x11FFA},
    [I(116,64)] = {18,0x13FFA},
    [I(117,64)] = {19,0x5BFFA},
    [I(118,64)] = {20,0xEFFFA},
    [I(119,64)] = {20,0xF1FFA},
    [I(120,64)] = {20,0xF3FFA},
    [I(121,64)] = {20,0xF5FFA},
    [I(122,64)] = {20,0xF7FFA},
    [I(123,64)] = {28,0xFFFDFFA},
    [I(124,64)] = {24,0xFF9FFA},
    [I(125,64)] = {27,0x7FFBFFA},
    [I(126,64)] = {26,0x3FFBFFA},
    [I(127,64)] = {64,0},
    [I(128,64)] = {64,0},
    [I(129,64)] = {64,0},
    [I(130,64)] = {64,0},
    [I(131,64)] = {64,0},
    [I(132,64)] = {64,0},
    [I(133,64)] = {64,0},
    [I(134,64)] = {64,0},
    [I(135,64)] = {64,0},
    [I(136,64)] = {64,0},
    [I(137,64)] = {64,0},
    [I(138,64)] = {64,0},
    [I(139,64)] = {64,0},
    [I(140,64)] = {64,0},
    [I(141,64)] = {64,0},
    [I(142,64)] = {64,0},
    [I(143,64)] = {64,0},
    [I(144,64)] = {64,0},
    [I(145,64)] = {64,0},
    [I(146,64)] = {64,0},
    [I(147,64)] = {64,0},
    [I(148,64)] = {64,0},
    [I(149,64)] = {64,0},
    [I(150,64)] = {64,0},
    [I(151,64)] = {64,0},
    [I(152,64)] = {64,0},
    [I(153,64)] = {64,0},
    [I(154,64)] = {64,0},
    [I(155,64)] = {64,0},
    [I(156,64)] = {64,0},
    [I(157,64)] = {64,0},
    [I(158,64)] = {64,0},
    [I(159,64)] = {64,0},
    [I(160,64)] = {64,0},
    [I(161,64)] = {64,0},
    [I(162,64)] = {64,0},
    [I(163,64)] = {64,0},
    [I(164,64)] = {64,0},
    [I(165,64)] = {64,0},
    [I(166,64)] = {64,0},
    [I(167,64)] = {64,0},
    [I(168,64)] = {64,0},
    [I(169,64)] = {64,0},
    [I(170,64)] = {64,0},
    [I(171,64)] = {64,0},
    [I(172,64)] = {64,0},
    [I(173,64)] = {64,0},
    [I(174,64)] = {64,0},
    [I(175,64)] = {64,0},
    [I(176,64)] = {64,0},
    [I(177,64)] = {64,0},
    [I(178,64)] = {64,0},
    [I(179,64)] = {64,0},
    [I(180,64)] = {64,0},
    [I(181,64)] = {64,0},
    [I(182,64)] = {64,0},
    [I(183,64)] = {64,0},
    [I(184,64)] = {64,0},
    [I(185,64)] = {64,0},
    [I(186,64)] = {64,0},
    [I(187,64)] = {64,0},
    [I(188,64)] = {64,0},
    [I(189,64)] = {64,0},
    [I(190,64)] = {64,0},
    [I(191,64)] = {64,0},
    [I(192,64)] = {64,0},
    [I(193,64)] = {64,0},
    [I(194,64)] = {64,0},
    [I(195,64)] = {X32,0xFFFE3FFA},
    [I(196,64)] = {64,0},
    [I(197,64)] = {64,0},
    [I(198,64)] = {64,0},
    [I(199,64)] = {64,0},
    [I(200,64)] = {64,0},
    [I(201,64)] = {64,0},
    [I(202,64)] = {64,0},
    [I(203,64)] = {64,0},
    [I(204,64)] = {64,0},
    [I(205,64)] = {64,0},
    [I(206,64)] = {64,0},
    [I(207,64)] = {64,0},
    [I(208,64)] = {X32,0xFFFE5FFA},
    [I(209,64)] = {64,0},
    [I(210,64)] = {64,0},
    [I(211,64)] = {64,0},
    [I(212,64)] = {64,0},
    [I(213,64)] = {64,0},
    [I(214,64)] = {64,0},
    [I(215,64)] = {64,0},
    [I(216,64)] = {64,0},
    [I(217,64)] = {64,0},
    [I(218,64)] = {64,0},
    [I(219,64)] = {64,0},
    [I(220,64)] = {64,0},
    [I(221,64)] = {64,0},
    [I(222,64)] = {64,0},
    [I(223,64)] = {64,0},
    [I(224,64)] = {64,0},
    [I(225,64)] = {64,0},
    [I(226,64)] = {64,0},
    [I(227,64)] = {64,0},
    [I(228,64)] = {64,0},
    [I(229,64)] = {64,0},
    [I(230,64)] = {64,0},
    [I(231,64)] = {64,0},
    [I(232,64)] = {64,0},
    [I(233,64)] = {64,0},
    [I(234,64)] = {64,0},
    [I(235,64)] = {64,0},
    [I(236,64)] = {64,0},
    [I(237,64)] = {64,0},
    [I(238,64)] = {64,0},
    [I(239,64)] = {64,0},
    [I(240,64)] = {64,0},
    [I(241,64)] = {64,0},
    [I(242,64)] = {64,0},
    [I(243,64)] = {64,0},
    [I(244,64)] = {64,0},
    [I(245,64)] = {64,0},
    [I(246,64)] = {64,0},
    [I(247,64)] = {64,0},
    [I(248,64)] = {64,0},
    [I(249,64)] = {64,0},
    [I(250,64)] = {64,0},
    [I(251,64)] = {64,0},
    [I(252,64)] = {64,0},
    [I(253,64)] = {64,0},
    [I(254,64)] = {64,0},
    [I(255,64)] = {64,0},
    [I(0,65)] = {19,0x7FE21},
    [I(1,65)] = {29,0x1FFFF621},
    [I(2,65)] = {64,0},
    [I(3,65)] = {64,0},
    [I(4,65)] = {64,0},
    [I(5,65)] = {64,0},
    [I(6,65)] = {64,0},
    [I(7,65)] = {64,0},
    [I(8,65)] = {64,0},
    [I(9,65)] = {30,0x3FFFFAA1},
    [I(10,65)] = {64,0},
    [I(11,65)] = {64,0},
    [I(12,65)] = {64,0},
    [I(13,65)] = {64,0},
    [I(14,65)] = {64,0},
    [I(15,65)] = {64,0},
    [I(16,65)] = {64,0},
    [I(17,65)] = {64,0},
    [I(18,65)] = {64,0},
    [I(19,65)] = {64,0},
    [I(20,65)] = {64,0},
    [I(21,65)] = {64,0},
    [I(22,65)] = {64,0},
    [I(23,65)] = {64,0},
    [I(24,65)] = {64,0},
    [I(25,65)] = {64,0},
    [I(26,65)] = {64,0},
    [I(27,65)] = {64,0},
    [I(28,65)] = {64,0},
    [I(29,65)] = {64,0},
    [I(30,65)] = {64,0},
    [I(31,65)] = {64,0},
    [I(32,65)] = {12,0x521},
    [I(33,65)] = {16,0xFE21},
    [I(34,65)] = {16,0xFE61},
    [I(35,65)] = {18,0x3FEA1},
    [I(36,65)] = {19,0x7FE61},
    [I(37,65)] = {12,0x561},
    [I(38,65)] = {14,0x3E21},
    [I(39,65)] = {17,0x1FEA1},
    [I(40,65)] = {16,0xFEA1},
    [I(41,65)] = {16,0xFEE1},
    [I(42,65)] = {14,0x3E61},
    [I(43,65)] = {17,0x1FEE1},
    [I(44,65)] = {14,0x3EA1},
    [I(45,65)] = {12,0x5A1},
    [I(46,65)] = {12,0x5E1},
    [I(47,65)] = {12,0x621},
    [I(48,65)] = {11,0x21},
    [I(49,65)] = {11,0x61},
    [I(50,65)] = {11,0xA1},
    [I(51,65)] = {12,0x661},
    [I(52,65)] = {12,0x6A1},
    [I(53,65)] = {12,0x6E1},
    [I(54,65)] = {12,0x721},
    [I(55,65)] = {12,0x761},
    [I(56,65)] = {12,0x7A1},
    [I(57,65)] = {12,0x7E1},
    [I(58,65)] = {13,0x1721},
    [I(59,65)] = {14,0x3EE1},
    [I(60,65)] = {21,0x1FFF21},
    [I(61,65)] = {12,0x821},
    [I(62,65)] = {18,0x3FEE1},
    [I(63,65)] = {16,0xFF21},
    [I(64,65)] = {19,0x7FEA1},
    [I(65,65)] = {12,0x861},
    [I(66,65)] = {13,0x1761},
    [I(67,65)] = {13,0x17A1},
    [I(68,65)] = {13,0x17E1},
    [I(69,65)] = {13,0x1821},
    [I(70,65)] = {13,0x1861},
    [I(71,65)] = {13,0x18A1},
    [I(72,65)] = {13,0x18E1},
    [I(73,65)] = {13,0x1921},
    [I(74,65)] = {13,0x1961},
    [I(75,65)] = {13,0x19A1},
    [I(76,65)] = {13,0x19E1},
    [I(77,65)] = {13,0x1A21},
    [I(78,65)] = {13,0x1A61},
    [I(79,65)] = {13,0x1AA1},
    [I(80,65)] = {13,0x1AE1},
    [I(81,65)] = {13,0x1B21},
    [I(82,65)] = {13,0x1B61},
    [I(83,65)] = {13,0x1BA1},
    [I(84,65)] = {13,0x1BE1},
    [I(85,65)] = {13,0x1C21},
    [I(86,65)] = {13,0x1C61},
    [I(87,65)] = {13,0x1CA1},
    [I(88,65)] = {14,0x3F21},
    [I(89,65)] = {13,0x1CE1},
    [I(90,65)] = {14,0x3F61},
    [I(91,65)] = {19,0x7FEE1},
    [I(92,65)] = {25,0x1FFFC21},
    [I(93,65)] = {19,0x7FF21},
    [I(94,65)] = {20,0xFFF21},
    [I(95,65)] = {12,0x8A1},
    [I(96,65)] = {21,0x1FFF61},
    [I(97,65)] = {11,0xE1},
    [I(98,65)] = {12,0x8E1},
    [I(99,65)] = {11,0x121},
    [I(100,65)] = {12,0x921},
    [I(101,65)] = {11,0x161},
    [I(102,65)] = {12,0x961},
    [I(103,65)] = {12,0x9A1},
    [I(104,65)] = {12,0x9E1},
    [I(105,65)] = {11,0x1A1},
    [I(106,65)] = {13,0x1D21},
    [I(107,65)] = {13,0x1D61},
    [I(108,65)] = {12,0xA21},
    [I(109,65)] = {12,0xA61},
    [I(110,65)] = {12,0xAA1},
    [I(111,65)] = {11,0x1E1},
    [I(112,65)] = {12,0xAE1},
    [I(113,65)] = {13,0x1DA1},
    [I(114,65)] = {12,0xB21},
    [I(115,65)] = {11,0x221},
    [I(116,65)] = {11,0x261},
    [I(117,65)] = {12,0xB61},
    [I(118,65)] = {13,0x1DE1},
    [I(119,65)] = {13,0x1E21},
    [I(120,65)] = {13,0x1E61},
    [I(121,65)] = {13,0x1EA1},
    [I(122,65)] = {13,0x1EE1},
    [I(123,65)] = {21,0x1FFFA1},
    [I(124,65)] = {17,0x1FF21},
    [I(125,65)] = {20,0xFFF61},
    [I(126,65)] = {19,0x7FF61},
    [I(127,65)] = {64,0},
    [I(128,65)] = {26,0x3FFF9A1},
    [I(129,65)] = {28,0xFFFF4A1},
    [I(130,65)] = {26,0x3FFF9E1},
    [I(131,65)] = {26,0x3FFFA21},
    [I(132,65)] = {28,0xFFFF4E1},
    [I(133,65)] = {28,0xFFFF521},
    [I(134,65)] = {28,0xFFFF561},
    [I(135,65)] = {29,0x1FFFF661},
    [I(136,65)] = {28,0xFFFF5A1},
    [I(137,65)] = {29,0x1FFFF6A1},
    [I(138,65)] = {29,0x1FFFF6E1},
    [I(139,65)] = {29,0x1FFFF721},
    [I(140,65)] = {29,0x1FFFF761},
    [I(141,65)] = {29,0x1FFFF7A1},
    [I(142,65)] = {30,0x3FFFFAE1},
    [I(143,65)] = {29,0x1FFFF7E1},
    [I(144,65)] = {30,0x3FFFFB21},
    [I(145,65)] = {30,0x3FFFFB61},
    [I(146,65)] = {28,0xFFFF5E1},
    [I(147,65)] = {29,0x1FFFF821},
    [I(148,65)] = {30,0x3FFFFBA1},
    [I(149,65)] = {29,0x1FFFF861},
    [I(150,65)] = {29,0x1FFFF8A1},
    [I(151,65)] = {29,0x1FFFF8E1},
    [I(152,65)] = {29,0x1FFFF921},
    [I(153,65)] = {27,0x7FFF721},
    [I(154,65)] = {28,0xFFFF621},
    [I(155,65)] = {29,0x1FFFF961},
    [I(156,65)] = {28,0xFFFF661},
    [I(157,65)] = {29,0x1FFFF9A1},
    [I(158,65)] = {29,0x1FFFF9E1},
    [I(159,65)] = {30,0x3FFFFBE1},
    [I(160,65)] = {28,0xFFFF6A1},
    [I(161,65)] = {27,0x7FFF761},
    [I(162,65)] = {26,0x3FFFA61},
    [I(163,65)] = {28,0xFFFF6E1},
    [I(164,65)] = {28,0xFFFF721},
    [I(165,65)] = {29,0x1FFFFA21},
    [I(166,65)] = {29,0x1FFFFA61},
    [I(167,65)] = {27,0x7FFF7A1},
    [I(168,65)] = {29,0x1FFFFAA1},
    [I(169,65)] = {28,0xFFFF761},
    [I(170,65)] = {28,0xFFFF7A1},
    [I(171,65)] = {30,0x3FFFFC21},
    [I(172,65)] = {27,0x7FFF7E1},
    [I(173,65)] = {28,0xFFFF7E1},
    [I(174,65)] = {29,0x1FFFFAE1},
    [I(175,65)] = {29,0x1FFFFB21},
    [I(176,65)] = {27,0x7FFF821},
    [I(177,65)] = {27,0x7FFF861},
    [I(178,65)] = {28,0xFFFF821},
    [I(179,65)] = {27,0x7FFF8A1},
    [I(180,65)] = {29,0x1FFFFB61},
    [I(181,65)] = {28,0xFFFF861},
    [I(182,65)] = {29,0x1FFFFBA1},
    [I(183,65)] = {29,0x1FFFFBE1},
    [I(184,65)] = {26,0x3FFFAA1},
    [I(185,65)] = {28,0xFFFF8A1},
    [I(186,65)] = {28,0xFFFF8E1},
    [I(187,65)] = {28,0xFFFF921},
    [I(188,65)] = {29,0x1FFFFC21},
    [I(189,65)] = {28,0xFFFF961},
    [I(190,65)] = {28,0xFFFF9A1},
    [I(191,65)] = {29,0x1FFFFC61},
    [I(192,65)] = {X32,0xFFFFF821},
    [I(193,65)] = {X32,0xFFFFF861},
    [I(194,65)] = {26,0x3FFFAE1},
    [I(195,65)] = {25,0x1FFFC61},
    [I(196,65)] = {28,0xFFFF9E1},
    [I(197,65)] = {29,0x1FFFFCA1},
    [I(198,65)] = {28,0xFFFFA21},
    [I(199,65)] = {31,0x7FFFFB21},
    [I(200,65)] = {X32,0xFFFFF8A1},
    [I(201,65)] = {X32,0xFFFFF8E1},
    [I(202,65)] = {X32,0xFFFFF921},
    [I(203,65)] = {64,0},
    [I(204,65)] = {64,0},
    [I(205,65)] = {X32,0xFFFFF961},
    [I(206,65)] = {30,0x3FFFFC61},
    [I(207,65)] = {31,0x7FFFFB61},
    [I(208,65)] = {25,0x1FFFCA1},
    [I(209,65)] = {27,0x7FFF8E1},
    [I(210,65)] = {X32,0xFFFFF9A1},
    [I(211,65)] = {64,0},
    [I(212,65)] = {64,0},
    [I(213,65)] = {X32,0xFFFFF9E1},
    [I(214,65)] = {64,0},
    [I(215,65)] = {30,0x3FFFFCA1},
    [I(216,65)] = {27,0x7FFF921},
    [I(217,65)] = {27,0x7FFF961},
    [I(218,65)] = {X32,0xFFFFFA21},
    [I(219,65)] = {X32,0xFFFFFA61},
    [I(220,65)] = {64,0},
    [I(221,65)] = {64,0},
    [I(222,65)] = {64,0},
    [I(223,65)] = {64,0},
    [I(224,65)] = {26,0x3FFFB21},
    [I(225,65)] = {30,0x3FFFFCE1},
    [I(226,65)] = {26,0x3FFFB61},
    [I(227,65)] = {27,0x7FFF9A1},
    [I(228,65)] = {28,0xFFFFA61},
    [I(229,65)] = {27,0x7FFF9E1},
    [I(230,65)] = {27,0x7FFFA21},
    [I(231,65)] = {29,0x1FFFFCE1},
    [I(232,65)] = {28,0xFFFFAA1},
    [I(233,65)] = {28,0xFFFFAE1},
    [I(234,65)] = {31,0x7FFFFBA1},
    [I(235,65)] = {31,0x7FFFFBE1},
    [I(236,65)] = {30,0x3FFFFD21},
    [I(237,65)] = {30,0x3FFFFD61},
    [I(238,65)] = {X32,0xFFFFFAA1},
    [I(239,65)] = {29,0x1FFFFD21},
    [I(240,65)] = {X32,0xFFFFFAE1},
    [I(241,65)] = {64,0},
    [I(242,65)] = {X32,0xFFFFFB21},
    [I(243,65)] = {X32,0xFFFFFB61},
    [I(244,65)] = {64,0},
    [I(245,65)] = {64,0},
    [I(246,65)] = {64,0},
    [I(247,65)] = {64,0},
    [I(248,65)] = {64,0},
    [I(249,65)] = {64,0},
    [I(250,65)] = {64,0},
    [I(251,65)] = {64,0},
    [I(252,65)] = {64,0},
    [I(253,65)] = {64,0},
    [I(254,65)] = {64,0},
    [I(255,65)] = {X32,0xFFFFFBA1},
    [I(0,66)] = {20,0xFFC5D},
    [I(1,66)] = {30,0x3FFFEC5D},
    [I(2,66)] = {64,0},
    [I(3,66)] = {64,0},
    [I(4,66)] = {64,0},
    [I(5,66)] = {64,0},
    [I(6,66)] = {64,0},
    [I(7,66)] = {64,0},
    [I(8,66)] = {64,0},
    [I(9,66)] = {31,0x7FFFF55D},
    [I(10,66)] = {64,0},
    [I(11,66)] = {64,0},
    [I(12,66)] = {64,0},
    [I(13,66)] = {64,0},
    [I(14,66)] = {64,0},
    [I(15,66)] = {64,0},
    [I(16,66)] = {64,0},
    [I(17,66)] = {64,0},
    [I(18,66)] = {64,0},
    [I(19,66)] = {64,0},
    [I(20,66)] = {64,0},
    [I(21,66)] = {64,0},
    [I(22,66)] = {64,0},
    [I(23,66)] = {64,0},
    [I(24,66)] = {64,0},
    [I(25,66)] = {64,0},
    [I(26,66)] = {64,0},
    [I(27,66)] = {64,0},
    [I(28,66)] = {64,0},
    [I(29,66)] = {64,0},
    [I(30,66)] = {64,0},
    [I(31,66)] = {64,0},
    [I(32,66)] = {13,0xA5D},
    [I(33,66)] = {17,0x1FC5D},
    [I(34,66)] = {17,0x1FCDD},
    [I(35,66)] = {19,0x7FD5D},
    [I(36,66)] = {20,0xFFCDD},
    [I(37,66)] = {13,0xADD},
    [I(38,66)] = {15,0x7C5D},
    [I(39,66)] = {18,0x3FD5D},
    [I(40,66)] = {17,0x1FD5D},
    [I(41,66)] = {17,0x1FDDD},
    [I(42,66)] = {15,0x7CDD},
    [I(43,66)] = {18,0x3FDDD},
    [I(44,66)] = {15,0x7D5D},
    [I(45,66)] = {13,0xB5D},
    [I(46,66)] = {13,0xBDD},
    [I(47,66)] = {13,0xC5D},
    [I(48,66)] = {12,0x5D},
    [I(49,66)] = {12,0xDD},
    [I(50,66)] = {12,0x15D},
    [I(51,66)] = {13,0xCDD},
    [I(52,66)] = {13,0xD5D},
    [I(53,66)] = {13,0xDDD},
    [I(54,66)] = {13,0xE5D},
    [I(55,66)] = {13,0xEDD},
    [I(56,66)] = {13,0xF5D},
    [I(57,66)] = {13,0xFDD},
    [I(58,66)] = {14,0x2E5D},
    [I(59,66)] = {15,0x7DDD},
    [I(60,66)] = {22,0x3FFE5D},
    [I(61,66)] = {13,0x105D},
    [I(62,66)] = {19,0x7FDDD},
    [I(63,66)] = {17,0x1FE5D},
    [I(64,66)] = {20,0xFFD5D},
    [I(65,66)] = {13,0x10DD},
    [I(66,66)] = {14,0x2EDD},
    [I(67,66)] = {14,0x2F5D},
    [I(68,66)] = {14,0x2FDD},
    [I(69,66)] = {14,0x305D},
    [I(70,66)] = {14,0x30DD},
    [I(71,66)] = {14,0x315D},
    [I(72,66)] = {14,0x31DD},
    [I(73,66)] = {14,0x325D},
    [I(74,66)] = {14,0x32DD},
    [I(75,66)] = {14,0x335D},
    [I(76,66)] = {14,0x33DD},
    [I(77,66)] = {14,0x345D},
    [I(78,66)] = {14,0x34DD},
    [I(79,66)] = {14,0x355D},
    [I(80,66)] = {14,0x35DD},
    [I(81,66)] = {14,0x365D},
    [I(82,66)] = {14,0x36DD},
    [I(83,66)] = {14,0x375D},
    [I(84,66)] = {14,0x37DD},
    [I(85,66)] = {14,0x385D},
    [I(86,66)] = {14,0x38DD},
    [I(87,66)] = {14,0x395D},
    [I(88,66)] = {15,0x7E5D},
    [I(89,66)] = {14,0x39DD},
    [I(90,66)] = {15,0x7EDD},
    [I(91,66)] = {20,0xFFDDD},
    [I(92,66)] = {26,0x3FFF85D},
    [I(93,66)] = {20,0xFFE5D},
    [I(94,66)] = {21,0x1FFE5D},
    [I(95,66)] = {13,0x115D},
    [I(96,66)] = {22,0x3FFEDD},
    [I(97,66)] = {12,0x1DD},
    [I(98,66)] = {13,0x11DD},
    [I(99,66)] = {12,0x25D},
    [I(100,66)] = {13,0x125D},
    [I(101,66)] = {12,0x2DD},
    [I(102,66)] = {13,0x12DD},
    [I(103,66)] = {13,0x135D},
    [I(104,66)] = {13,0x13DD},
    [I(105,66)] = {12,0x35D},
    [I(106,66)] = {14,0x3A5D},
    [I(107,66)] = {14,0x3ADD},
    [I(108,66)] = {13,0x145D},
    [I(109,66)] = {13,0x14DD},
    [I(110,66)] = {13,0x155D},
    [I(111,66)] = {12,0x3DD},
    [I(112,66)] = {13,0x15DD},
    [I(113,66)] = {14,0x3B5D},
    [I(114,66)] = {13,0x165D},
    [I(115,66)] = {12,0x45D},
    [I(116,66)] = {12,0x4DD},
    [I(117,66)] = {13,0x16DD},
    [I(118,66)] = {14,0x3BDD},
    [I(119,66)] = {14,0x3C5D},
    [I(120,66)] = {14,0x3CDD},
    [I(121,66)] = {14,0x3D5D},
    [I(122,66)] = {14,0x3DDD},
    [I(123,66)] = {22,0x3FFF5D},
    [I(124,66)] = {18,0x3FE5D},
    [I(125,66)] = {21,0x1FFEDD},
    [I(126,66)] = {20,0xFFEDD},
    [I(127,66)] = {64,0},
    [I(128,66)] = {27,0x7FFF35D},
    [I(129,66)] = {29,0x1FFFE95D},
    [I(130,66)] = {27,0x7FFF3DD},
    [I(131,66)] = {27,0x7FFF45D},
    [I(132,66)] = {29,0x1FFFE9DD},
    [I(133,66)] = {29,0x1FFFEA5D},
    [I(134,66)] = {29,0x1FFFEADD},
    [I(135,66)] = {30,0x3FFFECDD},
    [I(136,66)] = {29,0x1FFFEB5D},
    [I(137,66)] = {30,0x3FFFED5D},
    [I(138,66)] = {30,0x3FFFEDDD},
    [I(139,66)] = {30,0x3FFFEE5D},
    [I(140,66)] = {30,0x3FFFEEDD},
    [I(141,66)] = {30,0x3FFFEF5D},
    [I(142,66)] = {31,0x7FFFF5DD},
    [I(143,66)] = {30,0x3FFFEFDD},
    [I(144,66)] = {31,0x7FFFF65D},
    [I(145,66)] = {31,0x7FFFF6DD},
    [I(146,66)] = {29,0x1FFFEBDD},
    [I(147,66)] = {30,0x3FFFF05D},
    [I(148,66)] = {31,0x7FFFF75D},
    [I(149,66)] = {30,0x3FFFF0DD},
    [I(150,66)] = {30,0x3FFFF15D},
    [I(151,66)] = {30,0x3FFFF1DD},
    [I(152,66)] = {30,0x3FFFF25D},
    [I(153,66)] = {28,0xFFFEE5D},
    [I(154,66)] = {29,0x1FFFEC5D},
    [I(155,66)] = {30,0x3FFFF2DD},
    [I(156,66)] = {29,0x1FFFECDD},
    [I(157,66)] = {30,0x3FFFF35D},
    [I(158,66)] = {30,0x3FFFF3DD},
    [I(159,66)] = {31,0x7FFFF7DD},
    [I(160,66)] = {29,0x1FFFED5D},
    [I(161,66)] = {28,0xFFFEEDD},
    [I(162,66)] = {27,0x7FFF4DD},
    [I(163,66)] = {29,0x1FFFEDDD},
    [I(164,66)] = {29,0x1FFFEE5D},
    [I(165,66)] = {30,0x3FFFF45D},
    [I(166,66)] = {30,0x3FFFF4DD},
    [I(167,66)] = {28,0xFFFEF5D},
    [I(168,66)] = {30,0x3FFFF55D},
    [I(169,66)] = {29,0x1FFFEEDD},
    [I(170,66)] = {29,0x1FFFEF5D},
    [I(171,66)] = {31,0x7FFFF85D},
    [I(172,66)] = {28,0xFFFEFDD},
    [I(173,66)] = {29,0x1FFFEFDD},
    [I(174,66)] = {30,0x3FFFF5DD},
    [I(175,66)] = {30,0x3FFFF65D},
    [I(176,66)] = {28,0xFFFF05D},
    [I(177,66)] = {28,0xFFFF0DD},
    [I(178,66)] = {29,0x1FFFF05D},
    [I(179,66)] = {28,0xFFFF15D},
    [I(180,66)] = {30,0x3FFFF6DD},
    [I(181,66)] = {29,0x1FFFF0DD},
    [I(182,66)] = {30,0x3FFFF75D},
    [I(183,66)] = {30,0x3FFFF7DD},
    [I(184,66)] = {27,0x7FFF55D},
    [I(185,66)] = {29,0x1FFFF15D},
    [I(186,66)] = {29,0x1FFFF1DD},
    [I(187,66)] = {29,0x1FFFF25D},
    [I(188,66)] = {30,0x3FFFF85D},
    [I(189,66)] = {29,0x1FFFF2DD},
    [I(190,66)] = {29,0x1FFFF35D},
    [I(191,66)] = {30,0x3FFFF8DD},
    [I(192,66)] = {64,0},
    [I(193,66)] = {64,0},
    [I(194,66)] = {27,0x7FFF5DD},
    [I(195,66)] = {26,0x3FFF8DD},
    [I(196,66)] = {29,0x1FFFF3DD},
    [I(197,66)] = {30,0x3FFFF95D},
    [I(198,66)] = {29,0x1FFFF45D},
    [I(199,66)] = {X32,0xFFFFF65D},
    [I(200,66)] = {64,0},
    [I(201,66)] = {64,0},
    [I(202,66)] = {64,0},
    [I(203,66)] = {64,0},
    [I(204,66)] = {64,0},
    [I(205,66)] = {64,0},
    [I(206,66)] = {31,0x7FFFF8DD},
    [I(207,66)] = {X32,0xFFFFF6DD},
    [I(208,66)] = {26,0x3FFF95D},
    [I(209,66)] = {28,0xFFFF1DD},
    [I(210,66)] = {64,0},
    [I(211,66)] = {64,0},
    [I(212,66)] = {64,0},
    [I(213,66)] = {64,0},
    [I(214,66)] = {64,0},
    [I(215,66)] = {31,0x7FFFF95D},
    [I(216,66)] = {28,0xFFFF25D},
    [I(217,66)] = {28,0xFFFF2DD},
    [I(218,66)] = {64,0},
    [I(219,66)] = {64,0},
    [I(220,66)] = {64,0},
    [I(221,66)] = {64,0},
    [I(222,66)] = {64,0},
    [I(223,66)] = {64,0},
    [I(224,66)] = {27,0x7FFF65D},
    [I(225,66)] = {31,0x7FFFF9DD},
    [I(226,66)] = {27,0x7FFF6DD},
    [I(227,66)] = {28,0xFFFF35D},
    [I(228,66)] = {29,0x1FFFF4DD},
    [I(229,66)] = {28,0xFFFF3DD},
    [I(230,66)] = {28,0xFFFF45D},
    [I(231,66)] = {30,0x3FFFF9DD},
    [I(232,66)] = {29,0x1FFFF55D},
    [I(233,66)] = {29,0x1FFFF5DD},
    [I(234,66)] = {X32,0xFFFFF75D},
    [I(235,66)] = {X32,0xFFFFF7DD},
    [I(236,66)] = {31,0x7FFFFA5D},
    [I(237,66)] = {31,0x7FFFFADD},
    [I(238,66)] = {64,0},
    [I(239,66)] = {30,0x3FFFFA5D},
    [I(240,66)] = {64,0},
    [I(241,66)] = {64,0},
    [I(242,66)] = {64,0},
    [I(243,66)] = {64,0},
    [I(244,66)] = {64,0},
    [I(245,66)] = {64,0},
    [I(246,66)] = {64,0},
    [I(247,66)] = {64,0},
    [I(248,66)] = {64,0},
    [I(249,66)] = {64,0},
    [I(250,66)] = {64,0},
    [I(251,66)] = {64,0},
    [I(252,66)] = {64,0},
    [I(253,66)] = {64,0},
    [I(254,66)] = {64,0},
    [I(255,66)] = {64,0},
    [I(0,67)] = {20,0xFFC5E},
    [I(1,67)] = {30,0x3FFFEC5E},
    [I(2,67)] = {64,0},
    [I(3,67)] = {64,0},
    [I(4,67)] = {64,0},
    [I(5,67)] = {64,0},
    [I(6,67)] = {64,0},
    [I(7,67)] = {64,0},
    [I(8,67)] = {64,0},
    [I(9,67)] = {31,0x7FFFF55E},
    [I(10,67)] = {64,0},
    [I(11,67)] = {64,0},
    [I(12,67)] = {64,0},
    [I(13,67)] = {64,0},
    [I(14,67)] = {64,0},
    [I(15,67)] = {64,0},
    [I(16,67)] = {64,0},
    [I(17,67)] = {64,0},
    [I(18,67)] = {64,0},
    [I(19,67)] = {64,0},
    [I(20,67)] = {64,0},
    [I(21,67)] = {64,0},
    [I(22,67)] = {64,0},
    [I(23,67)] = {64,0},
    [I(24,67)] = {64,0},
    [I(25,67)] = {64,0},
    [I(26,67)] = {64,0},
    [I(27,67)] = {64,0},
    [I(28,67)] = {64,0},
    [I(29,67)] = {64,0},
    [I(30,67)] = {64,0},
    [I(31,67)] = {64,0},
    [I(32,67)] = {13,0xA5E},
    [I(33,67)] = {17,0x1FC5E},
    [I(34,67)] = {17,0x1FCDE},
    [I(35,67)] = {19,0x7FD5E},
    [I(36,67)] = {20,0xFFCDE},
    [I(37,67)] = {13,0xADE},
    [I(38,67)] = {15,0x7C5E},
    [I(39,67)] = {18,0x3FD5E},
    [I(40,67)] = {17,0x1FD5E},
    [I(41,67)] = {17,0x1FDDE},
    [I(42,67)] = {15,0x7CDE},
    [I(43,67)] = {18,0x3FDDE},
    [I(44,67)] = {15,0x7D5E},
    [I(45,67)] = {13,0xB5E},
    [I(46,67)] = {13,0xBDE},
    [I(47,67)] = {13,0xC5E},
    [I(48,67)] = {12,0x5E},
    [I(49,67)] = {12,0xDE},
    [I(50,67)] = {12,0x15E},
    [I(51,67)] = {13,0xCDE},
    [I(52,67)] = {13,0xD5E},
    [I(53,67)] = {13,0xDDE},
    [I(54,67)] = {13,0xE5E},
    [I(55,67)] = {13,0xEDE},
    [I(56,67)] = {13,0xF5E},
    [I(57,67)] = {13,0xFDE},
    [I(58,67)] = {14,0x2E5E},
    [I(59,67)] = {15,0x7DDE},
    [I(60,67)] = {22,0x3FFE5E},
    [I(61,67)] = {13,0x105E},
    [I(62,67)] = {19,0x7FDDE},
    [I(63,67)] = {17,0x1FE5E},
    [I(64,67)] = {20,0xFFD5E},
    [I(65,67)] = {13,0x10DE},
    [I(66,67)] = {14,0x2EDE},
    [I(67,67)] = {14,0x2F5E},
    [I(68,67)] = {14,0x2FDE},
    [I(69,67)] = {14,0x305E},
    [I(70,67)] = {14,0x30DE},
    [I(71,67)] = {14,0x315E},
    [I(72,67)] = {14,0x31DE},
    [I(73,67)] = {14,0x325E},
    [I(74,67)] = {14,0x32DE},
    [I(75,67)] = {14,0x335E},
    [I(76,67)] = {14,0x33DE},
    [I(77,67)] = {14,0x345E},
    [I(78,67)] = {14,0x34DE},
    [I(79,67)] = {14,0x355E},
    [I(80,67)] = {14,0x35DE},
    [I(81,67)] = {14,0x365E},
    [I(82,67)] = {14,0x36DE},
    [I(83,67)] = {14,0x375E},
    [I(84,67)] = {14,0x37DE},
    [I(85,67)] = {14,0x385E},
    [I(86,67)] = {14,0x38DE},
    [I(87,67)] = {14,0x395E},
    [I(88,67)] = {15,0x7E5E},
    [I(89,67)] = {14,0x39DE},
    [I(90,67)] = {15,0x7EDE},
    [I(91,67)] = {20,0xFFDDE},
    [I(92,67)] = {26,0x3FFF85E},
    [I(93,67)] = {20,0xFFE5E},
    [I(94,67)] = {21,0x1FFE5E},
    [I(95,67)] = {13,0x115E},
    [I(96,67)] = {22,0x3FFEDE},
    [I(97,67)] = {12,0x1DE},
    [I(98,67)] = {13,0x11DE},
    [I(99,67)] = {12,0x25E},
    [I(100,67)] = {13,0x125E},
    [I(101,67)] = {12,0x2DE},
    [I(102,67)] = {13,0x12DE},
    [I(103,67)] = {13,0x135E},
    [I(104,67)] = {13,0x13DE},
    [I(105,67)] = {12,0x35E},
    [I(106,67)] = {14,0x3A5E},
    [I(107,67)] = {14,0x3ADE},
    [I(108,67)] = {13,0x145E},
    [I(109,67)] = {13,0x14DE},
    [I(110,67)] = {13,0x155E},
    [I(111,67)] = {12,0x3DE},
    [I(112,67)] = {13,0x15DE},
    [I(113,67)] = {14,0x3B5E},
    [I(114,67)] = {13,0x165E},
    [I(115,67)] = {12,0x45E},
    [I(116,67)] = {12,0x4DE},
    [I(117,67)] = {13,0x16DE},
    [I(118,67)] = {14,0x3BDE},
    [I(119,67)] = {14,0x3C5E},
    [I(120,67)] = {14,0x3CDE},
    [I(121,67)] = {14,0x3D5E},
    [I(122,67)] = {14,0x3DDE},
    [I(123,67)] = {22,0x3FFF5E},
    [I(124,67)] = {18,0x3FE5E},
    [I(125,67)] = {21,0x1FFEDE},
    [I(126,67)] = {20,0xFFEDE},
    [I(127,67)] = {64,0},
    [I(128,67)] = {27,0x7FFF35E},
    [I(129,67)] = {29,0x1FFFE95E},
    [I(130,67)] = {27,0x7FFF3DE},
    [I(131,67)] = {27,0x7FFF45E},
    [I(132,67)] = {29,0x1FFFE9DE},
    [I(133,67)] = {29,0x1FFFEA5E},
    [I(134,67)] = {29,0x1FFFEADE},
    [I(135,67)] = {30,0x3FFFECDE},
    [I(136,67)] = {29,0x1FFFEB5E},
    [I(137,67)] = {30,0x3FFFED5E},
    [I(138,67)] = {30,0x3FFFEDDE},
    [I(139,67)] = {30,0x3FFFEE5E},
    [I(140,67)] = {30,0x3FFFEEDE},
    [I(141,67)] = {30,0x3FFFEF5E},
    [I(142,67)] = {31,0x7FFFF5DE},
    [I(143,67)] = {30,0x3FFFEFDE},
    [I(144,67)] = {31,0x7FFFF65E},
    [I(145,67)] = {31,0x7FFFF6DE},
    [I(146,67)] = {29,0x1FFFEBDE},
    [I(147,67)] = {30,0x3FFFF05E},
    [I(148,67)] = {31,0x7FFFF75E},
    [I(149,67)] = {30,0x3FFFF0DE},
    [I(150,67)] = {30,0x3FFFF15E},
    [I(151,67)] = {30,0x3FFFF1DE},
    [I(152,67)] = {30,0x3FFFF25E},
    [I(153,67)] = {28,0xFFFEE5E},
    [I(154,67)] = {29,0x1FFFEC5E},
    [I(155,67)] = {30,0x3FFFF2DE},
    [I(156,67)] = {29,0x1FFFECDE},
    [I(157,67)] = {30,0x3FFFF35E},
    [I(158,67)] = {30,0x3FFFF3DE},
    [I(159,67)] = {31,0x7FFFF7DE},
    [I(160,67)] = {29,0x1FFFED5E},
    [I(161,67)] = {28,0xFFFEEDE},
    [I(162,67)] = {27,0x7FFF4DE},
    [I(163,67)] = {29,0x1FFFEDDE},
    [I(164,67)] = {29,0x1FFFEE5E},
    [I(165,67)] = {30,0x3FFFF45E},
    [I(166,67)] = {30,0x3FFFF4DE},
    [I(167,67)] = {28,0xFFFEF5E},
    [I(168,67)] = {30,0x3FFFF55E},
    [I(169,67)] = {29,0x1FFFEEDE},
    [I(170,67)] = {29,0x1FFFEF5E},
    [I(171,67)] = {31,0x7FFFF85E},
    [I(172,67)] = {28,0xFFFEFDE},
    [I(173,67)] = {29,0x1FFFEFDE},
    [I(174,67)] = {30,0x3FFFF5DE},
    [I(175,67)] = {30,0x3FFFF65E},
    [I(176,67)] = {28,0xFFFF05E},
    [I(177,67)] = {28,0xFFFF0DE},
    [I(178,67)] = {29,0x1FFFF05E},
    [I(179,67)] = {28,0xFFFF15E},
    [I(180,67)] = {30,0x3FFFF6DE},
    [I(181,67)] = {29,0x1FFFF0DE},
    [I(182,67)] = {30,0x3FFFF75E},
    [I(183,67)] = {30,0x3FFFF7DE},
    [I(184,67)] = {27,0x7FFF55E},
    [I(185,67)] = {29,0x1FFFF15E},
    [I(186,67)] = {29,0x1FFFF1DE},
    [I(187,67)] = {29,0x1FFFF25E},
    [I(188,67)] = {30,0x3FFFF85E},
    [I(189,67)] = {29,0x1FFFF2DE},
    [I(190,67)] = {29,0x1FFFF35E},
    [I(191,67)] = {30,0x3FFFF8DE},
    [I(192,67)] = {64,0},
    [I(193,67)] = {64,0},
    [I(194,67)] = {27,0x7FFF5DE},
    [I(195,67)] = {26,0x3FFF8DE},
    [I(196,67)] = {29,0x1FFFF3DE},
    [I(197,67)] = {30,0x3FFFF95E},
    [I(198,67)] = {29,0x1FFFF45E},
    [I(199,67)] = {X32,0xFFFFF65E},
    [I(200,67)] = {64,0},
    [I(201,67)] = {64,0},
    [I(202,67)] = {64,0},
    [I(203,67)] = {64,0},
    [I(204,67)] = {64,0},
    [I(205,67)] = {64,0},
    [I(206,67)] = {31,0x7FFFF8DE},
    [I(207,67)] = {X32,0xFFFFF6DE},
    [I(208,67)] = {26,0x3FFF95E},
    [I(209,67)] = {28,0xFFFF1DE},
    [I(210,67)] = {64,0},
    [I(211,67)] = {64,0},
    [I(212,67)] = {64,0},
    [I(213,67)] = {64,0},
    [I(214,67)] = {64,0},
    [I(215,67)] = {31,0x7FFFF95E},
    [I(216,67)] = {28,0xFFFF25E},
    [I(217,67)] = {28,0xFFFF2DE},
    [I(218,67)] = {64,0},
    [I(219,67)] = {64,0},
    [I(220,67)] = {64,0},
    [I(221,67)] = {64,0},
    [I(222,67)] = {64,0},
    [I(223,67)] = {64,0},
    [I(224,67)] = {27,0x7FFF65E},
    [I(225,67)] = {31,0x7FFFF9DE},
    [I(226,67)] = {27,0x7FFF6DE},
    [I(227,67)] = {28,0xFFFF35E},
    [I(228,67)] = {29,0x1FFFF4DE},
    [I(229,67)] = {28,0xFFFF3DE},
    [I(230,67)] = {28,0xFFFF45E},
    [I(231,67)] = {30,0x3FFFF9DE},
    [I(232,67)] = {29,0x1FFFF55E},
    [I(233,67)] = {29,0x1FFFF5DE},
    [I(234,67)] = {X32,0xFFFFF75E},
    [I(235,67)] = {X32,0xFFFFF7DE},
    [I(236,67)] = {31,0x7FFFFA5E},
    [I(237,67)] = {31,0x7FFFFADE},
    [I(238,67)] = {64,0},
    [I(239,67)] = {30,0x3FFFFA5E},
    [I(240,67)] = {64,0},
    [I(241,67)] = {64,0},
    [I(242,67)] = {64,0},
    [I(243,67)] = {64,0},
    [I(244,67)] = {64,0},
    [I(245,67)] = {64,0},
    [I(246,67)] = {64,0},
    [I(247,67)] = {64,0},
    [I(248,67)] = {64,0},
    [I(249,67)] = {64,0},
    [I(250,67)] = {64,0},
    [I(251,67)] = {64,0},
    [I(252,67)] = {64,0},
    [I(253,67)] = {64,0},
    [I(254,67)] = {64,0},
    [I(255,67)] = {64,0},
    [I(0,68)] = {20,0xFFC5F},
    [I(1,68)] = {30,0x3FFFEC5F},
    [I(2,68)] = {64,0},
    [I(3,68)] = {64,0},
    [I(4,68)] = {64,0},
    [I(5,68)] = {64,0},
    [I(6,68)] = {64,0},
    [I(7,68)] = {64,0},
    [I(8,68)] = {64,0},
    [I(9,68)] = {31,0x7FFFF55F},
    [I(10,68)] = {64,0},
    [I(11,68)] = {64,0},
    [I(12,68)] = {64,0},
    [I(13,68)] = {64,0},
    [I(14,68)] = {64,0},
    [I(15,68)] = {64,0},
    [I(16,68)] = {64,0},
    [I(17,68)] = {64,0},
    [I(18,68)] = {64,0},
    [I(19,68)] = {64,0},
    [I(20,68)] = {64,0},
    [I(21,68)] = {64,0},
    [I(22,68)] = {64,0},
    [I(23,68)] = {64,0},
    [I(24,68)] = {64,0},
    [I(25,68)] = {64,0},
    [I(26,68)] = {64,0},
    [I(27,68)] = {64,0},
    [I(28,68)] = {64,0},
    [I(29,68)] = {64,0},
    [I(30,68)] = {64,0},
    [I(31,68)] = {64,0},
    [I(32,68)] = {13,0xA5F},
    [I(33,68)] = {17,0x1FC5F},
    [I(34,68)] = {17,0x1FCDF},
    [I(35,68)] = {19,0x7FD5F},
    [I(36,68)] = {20,0xFFCDF},
    [I(37,68)] = {13,0xADF},
    [I(38,68)] = {15,0x7C5F},
    [I(39,68)] = {18,0x3FD5F},
    [I(40,68)] = {17,0x1FD5F},
    [I(41,68)] = {17,0x1FDDF},
    [I(42,68)] = {15,0x7CDF},
    [I(43,68)] = {18,0x3FDDF},
    [I(44,68)] = {15,0x7D5F},
    [I(45,68)] = {13,0xB5F},
    [I(46,68)] = {13,0xBDF},
    [I(47,68)] = {13,0xC5F},
    [I(48,68)] = {12,0x5F},
    [I(49,68)] = {12,0xDF},
    [I(50,68)] = {12,0x15F},
    [I(51,68)] = {13,0xCDF},
    [I(52,68)] = {13,0xD5F},
    [I(53,68)] = {13,0xDDF},
    [I(54,68)] = {13,0xE5F},
    [I(55,68)] = {13,0xEDF},
    [I(56,68)] = {13,0xF5F},
    [I(57,68)] = {13,0xFDF},
    [I(58,68)] = {14,0x2E5F},
    [I(59,68)] = {15,0x7DDF},
    [I(60,68)] = {22,0x3FFE5F},
    [I(61,68)] = {13,0x105F},
    [I(62,68)] = {19,0x7FDDF},
    [I(63,68)] = {17,0x1FE5F},
    [I(64,68)] = {20,0xFFD5F},
    [I(65,68)] = {13,0x10DF},
    [I(66,68)] = {14,0x2EDF},
    [I(67,68)] = {14,0x2F5F},
    [I(68,68)] = {14,0x2FDF},
    [I(69,68)] = {14,0x305F},
    [I(70,68)] = {14,0x30DF},
    [I(71,68)] = {14,0x315F},
    [I(72,68)] = {14,0x31DF},
    [I(73,68)] = {14,0x325F},
    [I(74,68)] = {14,0x32DF},
    [I(75,68)] = {14,0x335F},
    [I(76,68)] = {14,0x33DF},
    [I(77,68)] = {14,0x345F},
    [I(78,68)] = {14,0x34DF},
    [I(79,68)] = {14,0x355F},
    [I(80,68)] = {14,0x35DF},
    [I(81,68)] = {14,0x365F},
    [I(82,68)] = {14,0x36DF},
    [I(83,68)] = {14,0x375F},
    [I(84,68)] = {14,0x37DF},
    [I(85,68)] = {14,0x385F},
    [I(86,68)] = {14,0x38DF},
    [I(87,68)] = {14,0x395F},
    [I(88,68)] = {15,0x7E5F},
    [I(89,68)] = {14,0x39DF},
    [I(90,68)] = {15,0x7EDF},
    [I(91,68)] = {20,0xFFDDF},
    [I(92,68)] = {26,0x3FFF85F},
    [I(93,68)] = {20,0xFFE5F},
    [I(94,68)] = {21,0x1FFE5F},
    [I(95,68)] = {13,0x115F},
    [I(96,68)] = {22,0x3FFEDF},
    [I(97,68)] = {12,0x1DF},
    [I(98,68)] = {13,0x11DF},
    [I(99,68)] = {12,0x25F},
    [I(100,68)] = {13,0x125F},
    [I(101,68)] = {12,0x2DF},
    [I(102,68)] = {13,0x12DF},
    [I(103,68)] = {13,0x135F},
    [I(104,68)] = {13,0x13DF},
    [I(105,68)] = {12,0x35F},
    [I(106,68)] = {14,0x3A5F},
    [I(107,68)] = {14,0x3ADF},
    [I(108,68)] = {13,0x145F},
    [I(109,68)] = {13,0x14DF},
    [I(110,68)] = {13,0x155F},
    [I(111,68)] = {12,0x3DF},
    [I(112,68)] = {13,0x15DF},
    [I(113,68)] = {14,0x3B5F},
    [I(114,68)] = {13,0x165F},
    [I(115,68)] = {12,0x45F},
    [I(116,68)] = {12,0x4DF},
    [I(117,68)] = {13,0x16DF},
    [I(118,68)] = {14,0x3BDF},
    [I(119,68)] = {14,0x3C5F},
    [I(120,68)] = {14,0x3CDF},
    [I(121,68)] = {14,0x3D5F},
    [I(122,68)] = {14,0x3DDF},
    [I(123,68)] = {22,0x3FFF5F},
    [I(124,68)] = {18,0x3FE5F},
    [I(125,68)] = {21,0x1FFEDF},
    [I(126,68)] = {20,0xFFEDF},
    [I(127,68)] = {64,0},
    [I(128,68)] = {27,0x7FFF35F},
    [I(129,68)] = {29,0x1FFFE95F},
    [I(130,68)] = {27,0x7FFF3DF},
    [I(131,68)] = {27,0x7FFF45F},
    [I(132,68)] = {29,0x1FFFE9DF},
    [I(133,68)] = {29,0x1FFFEA5F},
    [I(134,68)] = {29,0x1FFFEADF},
    [I(135,68)] = {30,0x3FFFECDF},
    [I(136,68)] = {29,0x1FFFEB5F},
    [I(137,68)] = {30,0x3FFFED5F},
    [I(138,68)] = {30,0x3FFFEDDF},
    [I(139,68)] = {30,0x3FFFEE5F},
    [I(140,68)] = {30,0x3FFFEEDF},
    [I(141,68)] = {30,0x3FFFEF5F},
    [I(142,68)] = {31,0x7FFFF5DF},
    [I(143,68)] = {30,0x3FFFEFDF},
    [I(144,68)] = {31,0x7FFFF65F},
    [I(145,68)] = {31,0x7FFFF6DF},
    [I(146,68)] = {29,0x1FFFEBDF},
    [I(147,68)] = {30,0x3FFFF05F},
    [I(148,68)] = {31,0x7FFFF75F},
    [I(149,68)] = {30,0x3FFFF0DF},
    [I(150,68)] = {30,0x3FFFF15F},
    [I(151,68)] = {30,0x3FFFF1DF},
    [I(152,68)] = {30,0x3FFFF25F},
    [I(153,68)] = {28,0xFFFEE5F},
    [I(154,68)] = {29,0x1FFFEC5F},
    [I(155,68)] = {30,0x3FFFF2DF},
    [I(156,68)] = {29,0x1FFFECDF},
    [I(157,68)] = {30,0x3FFFF35F},
    [I(158,68)] = {30,0x3FFFF3DF},
    [I(159,68)] = {31,0x7FFFF7DF},
    [I(160,68)] = {29,0x1FFFED5F},
    [I(161,68)] = {28,0xFFFEEDF},
    [I(162,68)] = {27,0x7FFF4DF},
    [I(163,68)] = {29,0x1FFFEDDF},
    [I(164,68)] = {29,0x1FFFEE5F},
    [I(165,68)] = {30,0x3FFFF45F},
    [I(166,68)] = {30,0x3FFFF4DF},
    [I(167,68)] = {28,0xFFFEF5F},
    [I(168,68)] = {30,0x3FFFF55F},
    [I(169,68)] = {29,0x1FFFEEDF},
    [I(170,68)] = {29,0x1FFFEF5F},
    [I(171,68)] = {31,0x7FFFF85F},
    [I(172,68)] = {28,0xFFFEFDF},
    [I(173,68)] = {29,0x1FFFEFDF},
    [I(174,68)] = {30,0x3FFFF5DF},
    [I(175,68)] = {30,0x3FFFF65F},
    [I(176,68)] = {28,0xFFFF05F},
    [I(177,68)] = {28,0xFFFF0DF},
    [I(178,68)] = {29,0x1FFFF05F},
    [I(179,68)] = {28,0xFFFF15F},
    [I(180,68)] = {30,0x3FFFF6DF},
    [I(181,68)] = {29,0x1FFFF0DF},
    [I(182,68)] = {30,0x3FFFF75F},
    [I(183,68)] = {30,0x3FFFF7DF},
    [I(184,68)] = {27,0x7FFF55F},
    [I(185,68)] = {29,0x1FFFF15F},
    [I(186,68)] = {29,0x1FFFF1DF},
    [I(187,68)] = {29,0x1FFFF25F},
    [I(188,68)] = {30,0x3FFFF85F},
    [I(189,68)] = {29,0x1FFFF2DF},
    [I(190,68)] = {29,0x1FFFF35F},
    [I(191,68)] = {30,0x3FFFF8DF},
    [I(192,68)] = {64,0},
    [I(193,68)] = {64,0},
    [I(194,68)] = {27,0x7FFF5DF},
    [I(195,68)] = {26,0x3FFF8DF},
    [I(196,68)] = {29,0x1FFFF3DF},
    [I(197,68)] = {30,0x3FFFF95F},
    [I(198,68)] = {29,0x1FFFF45F},
    [I(199,68)] = {X32,0xFFFFF65F},
    [I(200,68)] = {64,0},
    [I(201,68)] = {64,0},
    [I(202,68)] = {64,0},
    [I(203,68)] = {64,0},
    [I(204,68)] = {64,0},
    [I(205,68)] = {64,0},
    [I(206,68)] = {31,0x7FFFF8DF},
    [I(207,68)] = {X32,0xFFFFF6DF},
    [I(208,68)] = {26,0x3FFF95F},
    [I(209,68)] = {28,0xFFFF1DF},
    [I(210,68)] = {64,0},
    [I(211,68)] = {64,0},
    [I(212,68)] = {64,0},
    [I(213,68)] = {64,0},
    [I(214,68)] = {64,0},
    [I(215,68)] = {31,0x7FFFF95F},
    [I(216,68)] = {28,0xFFFF25F},
    [I(217,68)] = {28,0xFFFF2DF},
    [I(218,68)] = {64,0},
    [I(219,68)] = {64,0},
    [I(220,68)] = {64,0},
    [I(221,68)] = {64,0},
    [I(222,68)] = {64,0},
    [I(223,68)] = {64,0},
    [I(224,68)] = {27,0x7FFF65F},
    [I(225,68)] = {31,0x7FFFF9DF},
    [I(226,68)] = {27,0x7FFF6DF},
    [I(227,68)] = {28,0xFFFF35F},
    [I(228,68)] = {29,0x1FFFF4DF},
    [I(229,68)] = {28,0xFFFF3DF},
    [I(230,68)] = {28,0xFFFF45F},
    [I(231,68)] = {30,0x3FFFF9DF},
    [I(232,68)] = {29,0x1FFFF55F},
    [I(233,68)] = {29,0x1FFFF5DF},
    [I(234,68)] = {X32,0xFFFFF75F},
    [I(235,68)] = {X32,0xFFFFF7DF},
    [I(236,68)] = {31,0x7FFFFA5F},
    [I(237,68)] = {31,0x7FFFFADF},
    [I(238,68)] = {64,0},
    [I(239,68)] = {30,0x3FFFFA5F},
    [I(240,68)] = {64,0},
    [I(241,68)] = {64,0},
    [I(242,68)] = {64,0},
    [I(243,68)] = {64,0},
    [I(244,68)] = {64,0},
    [I(245,68)] = {64,0},
    [I(246,68)] = {64,0},
    [I(247,68)] = {64,0},
    [I(248,68)] = {64,0},
    [I(249,68)] = {64,0},
    [I(250,68)] = {64,0},
    [I(251,68)] = {64,0},
    [I(252,68)] = {64,0},
    [I(253,68)] = {64,0},
    [I(254,68)] = {64,0},
    [I(255,68)] = {64,0},
    [I(0,69)] = {20,0xFFC60},
    [I(1,69)] = {30,0x3FFFEC60},
    [I(2,69)] = {64,0},
    [I(3,69)] = {64,0},
    [I(4,69)] = {64,0},
    [I(5,69)] = {64,0},
    [I(6,69)] = {64,0},
    [I(7,69)] = {64,0},
    [I(8,69)] = {64,0},
    [I(9,69)] = {31,0x7FFFF560},
    [I(10,69)] = {64,0},
    [I(11,69)] = {64,0},
    [I(12,69)] = {64,0},
    [I(13,69)] = {64,0},
    [I(14,69)] = {64,0},
    [I(15,69)] = {64,0},
    [I(16,69)] = {64,0},
    [I(17,69)] = {64,0},
    [I(18,69)] = {64,0},
    [I(19,69)] = {64,0},
    [I(20,69)] = {64,0},
    [I(21,69)] = {64,0},
    [I(22,69)] = {64,0},
    [I(23,69)] = {64,0},
    [I(24,69)] = {64,0},
    [I(25,69)] = {64,0},
    [I(26,69)] = {64,0},
    [I(27,69)] = {64,0},
    [I(28,69)] = {64,0},
    [I(29,69)] = {64,0},
    [I(30,69)] = {64,0},
    [I(31,69)] = {64,0},
    [I(32,69)] = {13,0xA60},
    [I(33,69)] = {17,0x1FC60},
    [I(34,69)] = {17,0x1FCE0},
    [I(35,69)] = {19,0x7FD60},
    [I(36,69)] = {20,0xFFCE0},
    [I(37,69)] = {13,0xAE0},
    [I(38,69)] = {15,0x7C60},
    [I(39,69)] = {18,0x3FD60},
    [I(40,69)] = {17,0x1FD60},
    [I(41,69)] = {17,0x1FDE0},
    [I(42,69)] = {15,0x7CE0},
    [I(43,69)] = {18,0x3FDE0},
    [I(44,69)] = {15,0x7D60},
    [I(45,69)] = {13,0xB60},
    [I(46,69)] = {13,0xBE0},
    [I(47,69)] = {13,0xC60},
    [I(48,69)] = {12,0x60},
    [I(49,69)] = {12,0xE0},
    [I(50,69)] = {12,0x160},
    [I(51,69)] = {13,0xCE0},
    [I(52,69)] = {13,0xD60},
    [I(53,69)] = {13,0xDE0},
    [I(54,69)] = {13,0xE60},
    [I(55,69)] = {13,0xEE0},
    [I(56,69)] = {13,0xF60},
    [I(57,69)] = {13,0xFE0},
    [I(58,69)] = {14,0x2E60},
    [I(59,69)] = {15,0x7DE0},
    [I(60,69)] = {22,0x3FFE60},
    [I(61,69)] = {13,0x1060},
    [I(62,69)] = {19,0x7FDE0},
    [I(63,69)] = {17,0x1FE60},
    [I(64,69)] = {20,0xFFD60},
    [I(65,69)] = {13,0x10E0},
    [I(66,69)] = {14,0x2EE0},
    [I(67,69)] = {14,0x2F60},
    [I(68,69)] = {14,0x2FE0},
    [I(69,69)] = {14,0x3060},
    [I(70,69)] = {14,0x30E0},
    [I(71,69)] = {14,0x3160},
    [I(72,69)] = {14,0x31E0},
    [I(73,69)] = {14,0x3260},
    [I(74,69)] = {14,0x32E0},
    [I(75,69)] = {14,0x3360},
    [I(76,69)] = {14,0x33E0},
    [I(77,69)] = {14,0x3460},
    [I(78,69)] = {14,0x34E0},
    [I(79,69)] = {14,0x3560},
    [I(80,69)] = {14,0x35E0},
    [I(81,69)] = {14,0x3660},
    [I(82,69)] = {14,0x36E0},
    [I(83,69)] = {14,0x3760},
    [I(84,69)] = {14,0x37E0},
    [I(85,69)] = {14,0x3860},
    [I(86,69)] = {14,0x38E0},
    [I(87,69)] = {14,0x3960},
    [I(88,69)] = {15,0x7E60},
    [I(89,69)] = {14,0x39E0},
    [I(90,69)] = {15,0x7EE0},
    [I(91,69)] = {20,0xFFDE0},
    [I(92,69)] = {26,0x3FFF860},
    [I(93,69)] = {20,0xFFE60},
    [I(94,69)] = {21,0x1FFE60},
    [I(95,69)] = {13,0x1160},
    [I(96,69)] = {22,0x3FFEE0},
    [I(97,69)] = {12,0x1E0},
    [I(98,69)] = {13,0x11E0},
    [I(99,69)] = {12,0x260},
    [I(100,69)] = {13,0x1260},
    [I(101,69)] = {12,0x2E0},
    [I(102,69)] = {13,0x12E0},
    [I(103,69)] = {13,0x1360},
    [I(104,69)] = {13,0x13E0},
    [I(105,69)] = {12,0x360},
    [I(106,69)] = {14,0x3A60},
    [I(107,69)] = {14,0x3AE0},
    [I(108,69)] = {13,0x1460},
    [I(109,69)] = {13,0x14E0},
    [I(110,69)] = {13,0x1560},
    [I(111,69)] = {12,0x3E0},
    [I(112,69)] = {13,0x15E0},
    [I(113,69)] = {14,0x3B60},
    [I(114,69)] = {13,0x1660},
    [I(115,69)] = {12,0x460},
    [I(116,69)] = {12,0x4E0},
    [I(117,69)] = {13,0x16E0},
    [I(118,69)] = {14,0x3BE0},
    [I(119,69)] = {14,0x3C60},
    [I(120,69)] = {14,0x3CE0},
    [I(121,69)] = {14,0x3D60},
    [I(122,69)] = {14,0x3DE0},
    [I(123,69)] = {22,0x3FFF60},
    [I(124,69)] = {18,0x3FE60},
    [I(125,69)] = {21,0x1FFEE0},
    [I(126,69)] = {20,0xFFEE0},
    [I(127,69)] = {64,0},
    [I(128,69)] = {27,0x7FFF360},
    [I(129,69)] = {29,0x1FFFE960},
    [I(130,69)] = {27,0x7FFF3E0},
    [I(131,69)] = {27,0x7FFF460},
    [I(132,69)] = {29,0x1FFFE9E0},
    [I(133,69)] = {29,0x1FFFEA60},
    [I(134,69)] = {29,0x1FFFEAE0},
    [I(135,69)] = {30,0x3FFFECE0},
    [I(136,69)] = {29,0x1FFFEB60},
    [I(137,69)] = {30,0x3FFFED60},
    [I(138,69)] = {30,0x3FFFEDE0},
    [I(139,69)] = {30,0x3FFFEE60},
    [I(140,69)] = {30,0x3FFFEEE0},
    [I(141,69)] = {30,0x3FFFEF60},
    [I(142,69)] = {31,0x7FFFF5E0},
    [I(143,69)] = {30,0x3FFFEFE0},
    [I(144,69)] = {31,0x7FFFF660},
    [I(145,69)] = {31,0x7FFFF6E0},
    [I(146,69)] = {29,0x1FFFEBE0},
    [I(147,69)] = {30,0x3FFFF060},
    [I(148,69)] = {31,0x7FFFF760},
    [I(149,69)] = {30,0x3FFFF0E0},
    [I(150,69)] = {30,0x3FFFF160},
    [I(151,69)] = {30,0x3FFFF1E0},
    [I(152,69)] = {30,0x3FFFF260},
    [I(153,69)] = {28,0xFFFEE60},
    [I(154,69)] = {29,0x1FFFEC60},
    [I(155,69)] = {30,0x3FFFF2E0},
    [I(156,69)] = {29,0x1FFFECE0},
    [I(157,69)] = {30,0x3FFFF360},
    [I(158,69)] = {30,0x3FFFF3E0},
    [I(159,69)] = {31,0x7FFFF7E0},
    [I(160,69)] = {29,0x1FFFED60},
    [I(161,69)] = {28,0xFFFEEE0},
    [I(162,69)] = {27,0x7FFF4E0},
    [I(163,69)] = {29,0x1FFFEDE0},
    [I(164,69)] = {29,0x1FFFEE60},
    [I(165,69)] = {30,0x3FFFF460},
    [I(166,69)] = {30,0x3FFFF4E0},
    [I(167,69)] = {28,0xFFFEF60},
    [I(168,69)] = {30,0x3FFFF560},
    [I(169,69)] = {29,0x1FFFEEE0},
    [I(170,69)] = {29,0x1FFFEF60},
    [I(171,69)] = {31,0x7FFFF860},
    [I(172,69)] = {28,0xFFFEFE0},
    [I(173,69)] = {29,0x1FFFEFE0},
    [I(174,69)] = {30,0x3FFFF5E0},
    [I(175,69)] = {30,0x3FFFF660},
    [I(176,69)] = {28,0xFFFF060},
    [I(177,69)] = {28,0xFFFF0E0},
    [I(178,69)] = {29,0x1FFFF060},
    [I(179,69)] = {28,0xFFFF160},
    [I(180,69)] = {30,0x3FFFF6E0},
    [I(181,69)] = {29,0x1FFFF0E0},
    [I(182,69)] = {30,0x3FFFF760},
    [I(183,69)] = {30,0x3FFFF7E0},
    [I(184,69)] = {27,0x7FFF560},
    [I(185,69)] = {29,0x1FFFF160},
    [I(186,69)] = {29,0x1FFFF1E0},
    [I(187,69)] = {29,0x1FFFF260},
    [I(188,69)] = {30,0x3FFFF860},
    [I(189,69)] = {29,0x1FFFF2E0},
    [I(190,69)] = {29,0x1FFFF360},
    [I(191,69)] = {30,0x3FFFF8E0},
    [I(192,69)] = {64,0},
    [I(193,69)] = {64,0},
    [I(194,69)] = {27,0x7FFF5E0},
    [I(195,69)] = {26,0x3FFF8E0},
    [I(196,69)] = {29,0x1FFFF3E0},
    [I(197,69)] = {30,0x3FFFF960},
    [I(198,69)] = {29,0x1FFFF460},
    [I(199,69)] = {X32,0xFFFFF660},
    [I(200,69)] = {64,0},
    [I(201,69)] = {64,0},
    [I(202,69)] = {64,0},
    [I(203,69)] = {64,0},
    [I(204,69)] = {64,0},
    [I(205,69)] = {64,0},
    [I(206,69)] = {31,0x7FFFF8E0},
    [I(207,69)] = {X32,0xFFFFF6E0},
    [I(208,69)] = {26,0x3FFF960},
    [I(209,69)] = {28,0xFFFF1E0},
    [I(210,69)] = {64,0},
    [I(211,69)] = {64,0},
    [I(212,69)] = {64,0},
    [I(213,69)] = {64,0},
    [I(214,69)] = {64,0},
    [I(215,69)] = {31,0x7FFFF960},
    [I(216,69)] = {28,0xFFFF260},
    [I(217,69)] = {28,0xFFFF2E0},
    [I(218,69)] = {64,0},
    [I(219,69)] = {64,0},
    [I(220,69)] = {64,0},
    [I(221,69)] = {64,0},
    [I(222,69)] = {64,0},
    [I(223,69)] = {64,0},
    [I(224,69)] = {27,0x7FFF660},
    [I(225,69)] = {31,0x7FFFF9E0},
    [I(226,69)] = {27,0x7FFF6E0},
    [I(227,69)] = {28,0xFFFF360},
    [I(228,69)] = {29,0x1FFFF4E0},
    [I(229,69)] = {28,0xFFFF3E0},
    [I(230,69)] = {28,0xFFFF460},
    [I(231,69)] = {30,0x3FFFF9E0},
    [I(232,69)] = {29,0x1FFFF560},
    [I(233,69)] = {29,0x1FFFF5E0},
    [I(234,69)] = {X32,0xFFFFF760},
    [I(235,69)] = {X32,0xFFFFF7E0},
    [I(236,69)] = {31,0x7FFFFA60},
    [I(237,69)] = {31,0x7FFFFAE0},
    [I(238,69)] = {64,0},
    [I(239,69)] = {30,0x3FFFFA60},
    [I(240,69)] = {64,0},
    [I(241,69)] = {64,0},
    [I(242,69)] = {64,0},
    [I(243,69)] = {64,0},
    [I(244,69)] = {64,0},
    [I(245,69)] = {64,0},
    [I(246,69)] = {64,0},
    [I(247,69)] = {64,0},
    [I(248,69)] = {64,0},
    [I(249,69)] = {64,0},
    [I(250,69)] = {64,0},
    [I(251,69)] = {64,0},
    [I(252,69)] = {64,0},
    [I(253,69)] = {64,0},
    [I(254,69)] = {64,0},
    [I(255,69)] = {64,0},
    [I(0,70)] = {20,0xFFC61},
    [I(1,70)] = {30,0x3FFFEC61},
    [I(2,70)] = {64,0},
    [I(3,70)] = {64,0},
    [I(4,70)] = {64,0},
    [I(5,70)] = {64,0},
    [I(6,70)] = {64,0},
    [I(7,70)] = {64,0},
    [I(8,70)] = {64,0},
    [I(9,70)] = {31,0x7FFFF561},
    [I(10,70)] = {64,0},
    [I(11,70)] = {64,0},
    [I(12,70)] = {64,0},
    [I(13,70)] = {64,0},
    [I(14,70)] = {64,0},
    [I(15,70)] = {64,0},
    [I(16,70)] = {64,0},
    [I(17,70)] = {64,0},
    [I(18,70)] = {64,0},
    [I(19,70)] = {64,0},
    [I(20,70)] = {64,0},
    [I(21,70)] = {64,0},
    [I(22,70)] = {64,0},
    [I(23,70)] = {64,0},
    [I(24,70)] = {64,0},
    [I(25,70)] = {64,0},
    [I(26,70)] = {64,0},
    [I(27,70)] = {64,0},
    [I(28,70)] = {64,0},
    [I(29,70)] = {64,0},
    [I(30,70)] = {64,0},
    [I(31,70)] = {64,0},
    [I(32,70)] = {13,0xA61},
    [I(33,70)] = {17,0x1FC61},
    [I(34,70)] = {17,0x1FCE1},
    [I(35,70)] = {19,0x7FD61},
    [I(36,70)] = {20,0xFFCE1},
    [I(37,70)] = {13,0xAE1},
    [I(38,70)] = {15,0x7C61},
    [I(39,70)] = {18,0x3FD61},
    [I(40,70)] = {17,0x1FD61},
    [I(41,70)] = {17,0x1FDE1},
    [I(42,70)] = {15,0x7CE1},
    [I(43,70)] = {18,0x3FDE1},
    [I(44,70)] = {15,0x7D61},
    [I(45,70)] = {13,0xB61},
    [I(46,70)] = {13,0xBE1},
    [I(47,70)] = {13,0xC61},
    [I(48,70)] = {12,0x61},
    [I(49,70)] = {12,0xE1},
    [I(50,70)] = {12,0x161},
    [I(51,70)] = {13,0xCE1},
    [I(52,70)] = {13,0xD61},
    [I(53,70)] = {13,0xDE1},
    [I(54,70)] = {13,0xE61},
    [I(55,70)] = {13,0xEE1},
    [I(56,70)] = {13,0xF61},
    [I(57,70)] = {13,0xFE1},
    [I(58,70)] = {14,0x2E61},
    [I(59,70)] = {15,0x7DE1},
    [I(60,70)] = {22,0x3FFE61},
    [I(61,70)] = {13,0x1061},
    [I(62,70)] = {19,0x7FDE1},
    [I(63,70)] = {17,0x1FE61},
    [I(64,70)] = {20,0xFFD61},
    [I(65,70)] = {13,0x10E1},
    [I(66,70)] = {14,0x2EE1},
    [I(67,70)] = {14,0x2F61},
    [I(68,70)] = {14,0x2FE1},
    [I(69,70)] = {14,0x3061},
    [I(70,70)] = {14,0x30E1},
    [I(71,70)] = {14,0x3161},
    [I(72,70)] = {14,0x31E1},
    [I(73,70)] = {14,0x3261},
    [I(74,70)] = {14,0x32E1},
    [I(75,70)] = {14,0x3361},
    [I(76,70)] = {14,0x33E1},
    [I(77,70)] = {14,0x3461},
    [I(78,70)] = {14,0x34E1},
    [I(79,70)] = {14,0x3561},
    [I(80,70)] = {14,0x35E1},
    [I(81,70)] = {14,0x3661},
    [I(82,70)] = {14,0x36E1},
    [I(83,70)] = {14,0x3761},
    [I(84,70)] = {14,0x37E1},
    [I(85,70)] = {14,0x3861},
    [I(86,70)] = {14,0x38E1},
    [I(87,70)] = {14,0x3961},
    [I(88,70)] = {15,0x7E61},
    [I(89,70)] = {14,0x39E1},
    [I(90,70)] = {15,0x7EE1},
    [I(91,70)] = {20,0xFFDE1},
    [I(92,70)] = {26,0x3FFF861},
    [I(93,70)] = {20,0xFFE61},
    [I(94,70)] = {21,0x1FFE61},
    [I(95,70)] = {13,0x1161},
    [I(96,70)] = {22,0x3FFEE1},
    [I(97,70)] = {12,0x1E1},
    [I(98,70)] = {13,0x11E1},
    [I(99,70)] = {12,0x261},
    [I(100,70)] = {13,0x1261},
    [I(101,70)] = {12,0x2E1},
    [I(102,70)] = {13,0x12E1},
    [I(103,70)] = {13,0x1361},
    [I(104,70)] = {13,0x13E1},
    [I(105,70)] = {12,0x361},
    [I(106,70)] = {14,0x3A61},
    [I(107,70)] = {14,0x3AE1},
    [I(108,70)] = {13,0x1461},
    [I(109,70)] = {13,0x14E1},
    [I(110,70)] = {13,0x1561},
    [I(111,70)] = {12,0x3E1},
    [I(112,70)] = {13,0x15E1},
    [I(113,70)] = {14,0x3B61},
    [I(114,70)] = {13,0x1661},
    [I(115,70)] = {12,0x461},
    [I(116,70)] = {12,0x4E1},
    [I(117,70)] = {13,0x16E1},
    [I(118,70)] = {14,0x3BE1},
    [I(119,70)] = {14,0x3C61},
    [I(120,70)] = {14,0x3CE1},
    [I(121,70)] = {14,0x3D61},
    [I(122,70)] = {14,0x3DE1},
    [I(123,70)] = {22,0x3FFF61},
    [I(124,70)] = {18,0x3FE61},
    [I(125,70)] = {21,0x1FFEE1},
    [I(126,70)] = {20,0xFFEE1},
    [I(127,70)] = {64,0},
    [I(128,70)] = {27,0x7FFF361},
    [I(129,70)] = {29,0x1FFFE961},
    [I(130,70)] = {27,0x7FFF3E1},
    [I(131,70)] = {27,0x7FFF461},
    [I(132,70)] = {29,0x1FFFE9E1},
    [I(133,70)] = {29,0x1FFFEA61},
    [I(134,70)] = {29,0x1FFFEAE1},
    [I(135,70)] = {30,0x3FFFECE1},
    [I(136,70)] = {29,0x1FFFEB61},
    [I(137,70)] = {30,0x3FFFED61},
    [I(138,70)] = {30,0x3FFFEDE1},
    [I(139,70)] = {30,0x3FFFEE61},
    [I(140,70)] = {30,0x3FFFEEE1},
    [I(141,70)] = {30,0x3FFFEF61},
    [I(142,70)] = {31,0x7FFFF5E1},
    [I(143,70)] = {30,0x3FFFEFE1},
    [I(144,70)] = {31,0x7FFFF661},
    [I(145,70)] = {31,0x7FFFF6E1},
    [I(146,70)] = {29,0x1FFFEBE1},
    [I(147,70)] = {30,0x3FFFF061},
    [I(148,70)] = {31,0x7FFFF761},
    [I(149,70)] = {30,0x3FFFF0E1},
    [I(150,70)] = {30,0x3FFFF161},
    [I(151,70)] = {30,0x3FFFF1E1},
    [I(152,70)] = {30,0x3FFFF261},
    [I(153,70)] = {28,0xFFFEE61},
    [I(154,70)] = {29,0x1FFFEC61},
    [I(155,70)] = {30,0x3FFFF2E1},
    [I(156,70)] = {29,0x1FFFECE1},
    [I(157,70)] = {30,0x3FFFF361},
    [I(158,70)] = {30,0x3FFFF3E1},
    [I(159,70)] = {31,0x7FFFF7E1},
    [I(160,70)] = {29,0x1FFFED61},
    [I(161,70)] = {28,0xFFFEEE1},
    [I(162,70)] = {27,0x7FFF4E1},
    [I(163,70)] = {29,0x1FFFEDE1},
    [I(164,70)] = {29,0x1FFFEE61},
    [I(165,70)] = {30,0x3FFFF461},
    [I(166,70)] = {30,0x3FFFF4E1},
    [I(167,70)] = {28,0xFFFEF61},
    [I(168,70)] = {30,0x3FFFF561},
    [I(169,70)] = {29,0x1FFFEEE1},
    [I(170,70)] = {29,0x1FFFEF61},
    [I(171,70)] = {31,0x7FFFF861},
    [I(172,70)] = {28,0xFFFEFE1},
    [I(173,70)] = {29,0x1FFFEFE1},
    [I(174,70)] = {30,0x3FFFF5E1},
    [I(175,70)] = {30,0x3FFFF661},
    [I(176,70)] = {28,0xFFFF061},
    [I(177,70)] = {28,0xFFFF0E1},
    [I(178,70)] = {29,0x1FFFF061},
    [I(179,70)] = {28,0xFFFF161},
    [I(180,70)] = {30,0x3FFFF6E1},
    [I(181,70)] = {29,0x1FFFF0E1},
    [I(182,70)] = {30,0x3FFFF761},
    [I(183,70)] = {30,0x3FFFF7E1},
    [I(184,70)] = {27,0x7FFF561},
    [I(185,70)] = {29,0x1FFFF161},
    [I(186,70)] = {29,0x1FFFF1E1},
    [I(187,70)] = {29,0x1FFFF261},
    [I(188,70)] = {30,0x3FFFF861},
    [I(189,70)] = {29,0x1FFFF2E1},
    [I(190,70)] = {29,0x1FFFF361},
    [I(191,70)] = {30,0x3FFFF8E1},
    [I(192,70)] = {64,0},
    [I(193,70)] = {64,0},
    [I(194,70)] = {27,0x7FFF5E1},
    [I(195,70)] = {26,0x3FFF8E1},
    [I(196,70)] = {29,0x1FFFF3E1},
    [I(197,70)] = {30,0x3FFFF961},
    [I(198,70)] = {29,0x1FFFF461},
    [I(199,70)] = {X32,0xFFFFF661},
    [I(200,70)] = {64,0},
    [I(201,70)] = {64,0},
    [I(202,70)] = {64,0},
    [I(203,70)] = {64,0},
    [I(204,70)] = {64,0},
    [I(205,70)] = {64,0},
    [I(206,70)] = {31,0x7FFFF8E1},
    [I(207,70)] = {X32,0xFFFFF6E1},
    [I(208,70)] = {26,0x3FFF961},
    [I(209,70)] = {28,0xFFFF1E1},
    [I(210,70)] = {64,0},
    [I(211,70)] = {64,0},
    [I(212,70)] = {64,0},
    [I(213,70)] = {64,0},
    [I(214,70)] = {64,0},
    [I(215,70)] = {31,0x7FFFF961},
    [I(216,70)] = {28,0xFFFF261},
    [I(217,70)] = {28,0xFFFF2E1},
    [I(218,70)] = {64,0},
    [I(219,70)] = {64,0},
    [I(220,70)] = {64,0},
    [I(221,70)] = {64,0},
    [I(222,70)] = {64,0},
    [I(223,70)] = {64,0},
    [I(224,70)] = {27,0x7FFF661},
    [I(225,70)] = {31,0x7FFFF9E1},
    [I(226,70)] = {27,0x7FFF6E1},
    [I(227,70)] = {28,0xFFFF361},
    [I(228,70)] = {29,0x1FFFF4E1},
    [I(229,70)] = {28,0xFFFF3E1},
    [I(230,70)] = {28,0xFFFF461},
    [I(231,70)] = {30,0x3FFFF9E1},
    [I(232,70)] = {29,0x1FFFF561},
    [I(233,70)] = {29,0x1FFFF5E1},
    [I(234,70)] = {X32,0xFFFFF761},
    [I(235,70)] = {X32,0xFFFFF7E1},
    [I(236,70)] = {31,0x7FFFFA61},
    [I(237,70)] = {31,0x7FFFFAE1},
    [I(238,70)] = {64,0},
    [I(239,70)] = {30,0x3FFFFA61},
    [I(240,70)] = {64,0},
    [I(241,70)] = {64,0},
    [I(242,70)] = {64,0},
    [I(243,70)] = {64,0},
    [I(244,70)] = {64,0},
    [I(245,70)] = {64,0},
    [I(246,70)] = {64,0},
    [I(247,70)] = {64,0},
    [I(248,70)] = {64,0},
    [I(249,70)] = {64,0},
    [I(250,70)] = {64,0},
    [I(251,70)] = {64,0},
    [I(252,70)] = {64,0},
    [I(253,70)] = {64,0},
    [I(254,70)] = {64,0},
    [I(255,70)] = {64,0},
    [I(0,71)] = {20,0xFFC62},
    [I(1,71)] = {30,0x3FFFEC62},
    [I(2,71)] = {64,0},
    [I(3,71)] = {64,0},
    [I(4,71)] = {64,0},
    [I(5,71)] = {64,0},
    [I(6,71)] = {64,0},
    [I(7,71)] = {64,0},
    [I(8,71)] = {64,0},
    [I(9,71)] = {31,0x7FFFF562},
    [I(10,71)] = {64,0},
    [I(11,71)] = {64,0},
    [I(12,71)] = {64,0},
    [I(13,71)] = {64,0},
    [I(14,71)] = {64,0},
    [I(15,71)] = {64,0},
    [I(16,71)] = {64,0},
    [I(17,71)] = {64,0},
    [I(18,71)] = {64,0},
    [I(19,71)] = {64,0},
    [I(20,71)] = {64,0},
    [I(21,71)] = {64,0},
    [I(22,71)] = {64,0},
    [I(23,71)] = {64,0},
    [I(24,71)] = {64,0},
    [I(25,71)] = {64,0},
    [I(26,71)] = {64,0},
    [I(27,71)] = {64,0},
    [I(28,71)] = {64,0},
    [I(29,71)] = {64,0},
    [I(30,71)] = {64,0},
    [I(31,71)] = {64,0},
    [I(32,71)] = {13,0xA62},
    [I(33,71)] = {17,0x1FC62},
    [I(34,71)] = {17,0x1FCE2},
    [I(35,71)] = {19,0x7FD62},
    [I(36,71)] = {20,0xFFCE2},
    [I(37,71)] = {13,0xAE2},
    [I(38,71)] = {15,0x7C62},
    [I(39,71)] = {18,0x3FD62},
    [I(40,71)] = {17,0x1FD62},
    [I(41,71)] = {17,0x1FDE2},
    [I(42,71)] = {15,0x7CE2},
    [I(43,71)] = {18,0x3FDE2},
    [I(44,71)] = {15,0x7D62},
    [I(45,71)] = {13,0xB62},
    [I(46,71)] = {13,0xBE2},
    [I(47,71)] = {13,0xC62},
    [I(48,71)] = {12,0x62},
    [I(49,71)] = {12,0xE2},
    [I(50,71)] = {12,0x162},
    [I(51,71)] = {13,0xCE2},
    [I(52,71)] = {13,0xD62},
    [I(53,71)] = {13,0xDE2},
    [I(54,71)] = {13,0xE62},
    [I(55,71)] = {13,0xEE2},
    [I(56,71)] = {13,0xF62},
    [I(57,71)] = {13,0xFE2},
    [I(58,71)] = {14,0x2E62},
    [I(59,71)] = {15,0x7DE2},
    [I(60,71)] = {22,0x3FFE62},
    [I(61,71)] = {13,0x1062},
    [I(62,71)] = {19,0x7FDE2},
    [I(63,71)] = {17,0x1FE62},
    [I(64,71)] = {20,0xFFD62},
    [I(65,71)] = {13,0x10E2},
    [I(66,71)] = {14,0x2EE2},
    [I(67,71)] = {14,0x2F62},
    [I(68,71)] = {14,0x2FE2},
    [I(69,71)] = {14,0x3062},
    [I(70,71)] = {14,0x30E2},
    [I(71,71)] = {14,0x3162},
    [I(72,71)] = {14,0x31E2},
    [I(73,71)] = {14,0x3262},
    [I(74,71)] = {14,0x32E2},
    [I(75,71)] = {14,0x3362},
    [I(76,71)] = {14,0x33E2},
    [I(77,71)] = {14,0x3462},
    [I(78,71)] = {14,0x34E2},
    [I(79,71)] = {14,0x3562},
    [I(80,71)] = {14,0x35E2},
    [I(81,71)] = {14,0x3662},
    [I(82,71)] = {14,0x36E2},
    [I(83,71)] = {14,0x3762},
    [I(84,71)] = {14,0x37E2},
    [I(85,71)] = {14,0x3862},
    [I(86,71)] = {14,0x38E2},
    [I(87,71)] = {14,0x3962},
    [I(88,71)] = {15,0x7E62},
    [I(89,71)] = {14,0x39E2},
    [I(90,71)] = {15,0x7EE2},
    [I(91,71)] = {20,0xFFDE2},
    [I(92,71)] = {26,0x3FFF862},
    [I(93,71)] = {20,0xFFE62},
    [I(94,71)] = {21,0x1FFE62},
    [I(95,71)] = {13,0x1162},
    [I(96,71)] = {22,0x3FFEE2},
    [I(97,71)] = {12,0x1E2},
    [I(98,71)] = {13,0x11E2},
    [I(99,71)] = {12,0x262},
    [I(100,71)] = {13,0x1262},
    [I(101,71)] = {12,0x2E2},
    [I(102,71)] = {13,0x12E2},
    [I(103,71)] = {13,0x1362},
    [I(104,71)] = {13,0x13E2},
    [I(105,71)] = {12,0x362},
    [I(106,71)] = {14,0x3A62},
    [I(107,71)] = {14,0x3AE2},
    [I(108,71)] = {13,0x1462},
    [I(109,71)] = {13,0x14E2},
    [I(110,71)] = {13,0x1562},
    [I(111,71)] = {12,0x3E2},
    [I(112,71)] = {13,0x15E2},
    [I(113,71)] = {14,0x3B62},
    [I(114,71)] = {13,0x1662},
    [I(115,71)] = {12,0x462},
    [I(116,71)] = {12,0x4E2},
    [I(117,71)] = {13,0x16E2},
    [I(118,71)] = {14,0x3BE2},
    [I(119,71)] = {14,0x3C62},
    [I(120,71)] = {14,0x3CE2},
    [I(121,71)] = {14,0x3D62},
    [I(122,71)] = {14,0x3DE2},
    [I(123,71)] = {22,0x3FFF62},
    [I(124,71)] = {18,0x3FE62},
    [I(125,71)] = {21,0x1FFEE2},
    [I(126,71)] = {20,0xFFEE2},
    [I(127,71)] = {64,0},
    [I(128,71)] = {27,0x7FFF362},
    [I(129,71)] = {29,0x1FFFE962},
    [I(130,71)] = {27,0x7FFF3E2},
    [I(131,71)] = {27,0x7FFF462},
    [I(132,71)] = {29,0x1FFFE9E2},
    [I(133,71)] = {29,0x1FFFEA62},
    [I(134,71)] = {29,0x1FFFEAE2},
    [I(135,71)] = {30,0x3FFFECE2},
    [I(136,71)] = {29,0x1FFFEB62},
    [I(137,71)] = {30,0x3FFFED62},
    [I(138,71)] = {30,0x3FFFEDE2},
    [I(139,71)] = {30,0x3FFFEE62},
    [I(140,71)] = {30,0x3FFFEEE2},
    [I(141,71)] = {30,0x3FFFEF62},
    [I(142,71)] = {31,0x7FFFF5E2},
    [I(143,71)] = {30,0x3FFFEFE2},
    [I(144,71)] = {31,0x7FFFF662},
    [I(145,71)] = {31,0x7FFFF6E2},
    [I(146,71)] = {29,0x1FFFEBE2},
    [I(147,71)] = {30,0x3FFFF062},
    [I(148,71)] = {31,0x7FFFF762},
    [I(149,71)] = {30,0x3FFFF0E2},
    [I(150,71)] = {30,0x3FFFF162},
    [I(151,71)] = {30,0x3FFFF1E2},
    [I(152,71)] = {30,0x3FFFF262},
    [I(153,71)] = {28,0xFFFEE62},
    [I(154,71)] = {29,0x1FFFEC62},
    [I(155,71)] = {30,0x3FFFF2E2},
    [I(156,71)] = {29,0x1FFFECE2},
    [I(157,71)] = {30,0x3FFFF362},
    [I(158,71)] = {30,0x3FFFF3E2},
    [I(159,71)] = {31,0x7FFFF7E2},
    [I(160,71)] = {29,0x1FFFED62},
    [I(161,71)] = {28,0xFFFEEE2},
    [I(162,71)] = {27,0x7FFF4E2},
    [I(163,71)] = {29,0x1FFFEDE2},
    [I(164,71)] = {29,0x1FFFEE62},
    [I(165,71)] = {30,0x3FFFF462},
    [I(166,71)] = {30,0x3FFFF4E2},
    [I(167,71)] = {28,0xFFFEF62},
    [I(168,71)] = {30,0x3FFFF562},
    [I(169,71)] = {29,0x1FFFEEE2},
    [I(170,71)] = {29,0x1FFFEF62},
    [I(171,71)] = {31,0x7FFFF862},
    [I(172,71)] = {28,0xFFFEFE2},
    [I(173,71)] = {29,0x1FFFEFE2},
    [I(174,71)] = {30,0x3FFFF5E2},
    [I(175,71)] = {30,0x3FFFF662},
    [I(176,71)] = {28,0xFFFF062},
    [I(177,71)] = {28,0xFFFF0E2},
    [I(178,71)] = {29,0x1FFFF062},
    [I(179,71)] = {28,0xFFFF162},
    [I(180,71)] = {30,0x3FFFF6E2},
    [I(181,71)] = {29,0x1FFFF0E2},
    [I(182,71)] = {30,0x3FFFF762},
    [I(183,71)] = {30,0x3FFFF7E2},
    [I(184,71)] = {27,0x7FFF562},
    [I(185,71)] = {29,0x1FFFF162},
    [I(186,71)] = {29,0x1FFFF1E2},
    [I(187,71)] = {29,0x1FFFF262},
    [I(188,71)] = {30,0x3FFFF862},
    [I(189,71)] = {29,0x1FFFF2E2},
    [I(190,71)] = {29,0x1FFFF362},
    [I(191,71)] = {30,0x3FFFF8E2},
    [I(192,71)] = {64,0},
    [I(193,71)] = {64,0},
    [I(194,71)] = {27,0x7FFF5E2},
    [I(195,71)] = {26,0x3FFF8E2},
    [I(196,71)] = {29,0x1FFFF3E2},
    [I(197,71)] = {30,0x3FFFF962},
    [I(198,71)] = {29,0x1FFFF462},
    [I(199,71)] = {X32,0xFFFFF662},
    [I(200,71)] = {64,0},
    [I(201,71)] = {64,0},
    [I(202,71)] = {64,0},
    [I(203,71)] = {64,0},
    [I(204,71)] = {64,0},
    [I(205,71)] = {64,0},
    [I(206,71)] = {31,0x7FFFF8E2},
    [I(207,71)] = {X32,0xFFFFF6E2},
    [I(208,71)] = {26,0x3FFF962},
    [I(209,71)] = {28,0xFFFF1E2},
    [I(210,71)] = {64,0},
    [I(211,71)] = {64,0},
    [I(212,71)] = {64,0},
    [I(213,71)] = {64,0},
    [I(214,71)] = {64,0},
    [I(215,71)] = {31,0x7FFFF962},
    [I(216,71)] = {28,0xFFFF262},
    [I(217,71)] = {28,0xFFFF2E2},
    [I(218,71)] = {64,0},
    [I(219,71)] = {64,0},
    [I(220,71)] = {64,0},
    [I(221,71)] = {64,0},
    [I(222,71)] = {64,0},
    [I(223,71)] = {64,0},
    [I(224,71)] = {27,0x7FFF662},
    [I(225,71)] = {31,0x7FFFF9E2},
    [I(226,71)] = {27,0x7FFF6E2},
    [I(227,71)] = {28,0xFFFF362},
    [I(228,71)] = {29,0x1FFFF4E2},
    [I(229,71)] = {28,0xFFFF3E2},
    [I(230,71)] = {28,0xFFFF462},
    [I(231,71)] = {30,0x3FFFF9E2},
    [I(232,71)] = {29,0x1FFFF562},
    [I(233,71)] = {29,0x1FFFF5E2},
    [I(234,71)] = {X32,0xFFFFF762},
    [I(235,71)] = {X32,0xFFFFF7E2},
    [I(236,71)] = {31,0x7FFFFA62},
    [I(237,71)] = {31,0x7FFFFAE2},
    [I(238,71)] = {64,0},
    [I(239,71)] = {30,0x3FFFFA62},
    [I(240,71)] = {64,0},
    [I(241,71)] = {64,0},
    [I(242,71)] = {64,0},
    [I(243,71)] = {64,0},
    [I(244,71)] = {64,0},
    [I(245,71)] = {64,0},
    [I(246,71)] = {64,0},
    [I(247,71)] = {64,0},
    [I(248,71)] = {64,0},
    [I(249,71)] = {64,0},
    [I(250,71)] = {64,0},
    [I(251,71)] = {64,0},
    [I(252,71)] = {64,0},
    [I(253,71)] = {64,0},
    [I(254,71)] = {64,0},
    [I(255,71)] = {64,0},
    [I(0,72)] = {20,0xFFC63},
    [I(1,72)] = {30,0x3FFFEC63},
    [I(2,72)] = {64,0},
    [I(3,72)] = {64,0},
    [I(4,72)] = {64,0},
    [I(5,72)] = {64,0},
    [I(6,72)] = {64,0},
    [I(7,72)] = {64,0},
    [I(8,72)] = {64,0},
    [I(9,72)] = {31,0x7FFFF563},
    [I(10,72)] = {64,0},
    [I(11,72)] = {64,0},
    [I(12,72)] = {64,0},
    [I(13,72)] = {64,0},
    [I(14,72)] = {64,0},
    [I(15,72)] = {64,0},
    [I(16,72)] = {64,0},
    [I(17,72)] = {64,0},
    [I(18,72)] = {64,0},
    [I(19,72)] = {64,0},
    [I(20,72)] = {64,0},
    [I(21,72)] = {64,0},
    [I(22,72)] = {64,0},
    [I(23,72)] = {64,0},
    [I(24,72)] = {64,0},
    [I(25,72)] = {64,0},
    [I(26,72)] = {64,0},
    [I(27,72)] = {64,0},
    [I(28,72)] = {64,0},
    [I(29,72)] = {64,0},
    [I(30,72)] = {64,0},
    [I(31,72)] = {64,0},
    [I(32,72)] = {13,0xA63},
    [I(33,72)] = {17,0x1FC63},
    [I(34,72)] = {17,0x1FCE3},
    [I(35,72)] = {19,0x7FD63},
    [I(36,72)] = {20,0xFFCE3},
    [I(37,72)] = {13,0xAE3},
    [I(38,72)] = {15,0x7C63},
    [I(39,72)] = {18,0x3FD63},
    [I(40,72)] = {17,0x1FD63},
    [I(41,72)] = {17,0x1FDE3},
    [I(42,72)] = {15,0x7CE3},
    [I(43,72)] = {18,0x3FDE3},
    [I(44,72)] = {15,0x7D63},
    [I(45,72)] = {13,0xB63},
    [I(46,72)] = {13,0xBE3},
    [I(47,72)] = {13,0xC63},
    [I(48,72)] = {12,0x63},
    [I(49,72)] = {12,0xE3},
    [I(50,72)] = {12,0x163},
    [I(51,72)] = {13,0xCE3},
    [I(52,72)] = {13,0xD63},
    [I(53,72)] = {13,0xDE3},
    [I(54,72)] = {13,0xE63},
    [I(55,72)] = {13,0xEE3},
    [I(56,72)] = {13,0xF63},
    [I(57,72)] = {13,0xFE3},
    [I(58,72)] = {14,0x2E63},
    [I(59,72)] = {15,0x7DE3},
    [I(60,72)] = {22,0x3FFE63},
    [I(61,72)] = {13,0x1063},
    [I(62,72)] = {19,0x7FDE3},
    [I(63,72)] = {17,0x1FE63},
    [I(64,72)] = {20,0xFFD63},
    [I(65,72)] = {13,0x10E3},
    [I(66,72)] = {14,0x2EE3},
    [I(67,72)] = {14,0x2F63},
    [I(68,72)] = {14,0x2FE3},
    [I(69,72)] = {14,0x3063},
    [I(70,72)] = {14,0x30E3},
    [I(71,72)] = {14,0x3163},
    [I(72,72)] = {14,0x31E3},
    [I(73,72)] = {14,0x3263},
    [I(74,72)] = {14,0x32E3},
    [I(75,72)] = {14,0x3363},
    [I(76,72)] = {14,0x33E3},
    [I(77,72)] = {14,0x3463},
    [I(78,72)] = {14,0x34E3},
    [I(79,72)] = {14,0x3563},
    [I(80,72)] = {14,0x35E3},
    [I(81,72)] = {14,0x3663},
    [I(82,72)] = {14,0x36E3},
    [I(83,72)] = {14,0x3763},
    [I(84,72)] = {14,0x37E3},
    [I(85,72)] = {14,0x3863},
    [I(86,72)] = {14,0x38E3},
    [I(87,72)] = {14,0x3963},
    [I(88,72)] = {15,0x7E63},
    [I(89,72)] = {14,0x39E3},
    [I(90,72)] = {15,0x7EE3},
    [I(91,72)] = {20,0xFFDE3},
    [I(92,72)] = {26,0x3FFF863},
    [I(93,72)] = {20,0xFFE63},
    [I(94,72)] = {21,0x1FFE63},
    [I(95,72)] = {13,0x1163},
    [I(96,72)] = {22,0x3FFEE3},
    [I(97,72)] = {12,0x1E3},
    [I(98,72)] = {13,0x11E3},
    [I(99,72)] = {12,0x263},
    [I(100,72)] = {13,0x1263},
    [I(101,72)] = {12,0x2E3},
    [I(102,72)] = {13,0x12E3},
    [I(103,72)] = {13,0x1363},
    [I(104,72)] = {13,0x13E3},
    [I(105,72)] = {12,0x363},
    [I(106,72)] = {14,0x3A63},
    [I(107,72)] = {14,0x3AE3},
    [I(108,72)] = {13,0x1463},
    [I(109,72)] = {13,0x14E3},
    [I(110,72)] = {13,0x1563},
    [I(111,72)] = {12,0x3E3},
    [I(112,72)] = {13,0x15E3},
    [I(113,72)] = {14,0x3B63},
    [I(114,72)] = {13,0x1663},
    [I(115,72)] = {12,0x463},
    [I(116,72)] = {12,0x4E3},
    [I(117,72)] = {13,0x16E3},
    [I(118,72)] = {14,0x3BE3},
    [I(119,72)] = {14,0x3C63},
    [I(120,72)] = {14,0x3CE3},
    [I(121,72)] = {14,0x3D63},
    [I(122,72)] = {14,0x3DE3},
    [I(123,72)] = {22,0x3FFF63},
    [I(124,72)] = {18,0x3FE63},
    [I(125,72)] = {21,0x1FFEE3},
    [I(126,72)] = {20,0xFFEE3},
    [I(127,72)] = {64,0},
    [I(128,72)] = {27,0x7FFF363},
    [I(129,72)] = {29,0x1FFFE963},
    [I(130,72)] = {27,0x7FFF3E3},
    [I(131,72)] = {27,0x7FFF463},
    [I(132,72)] = {29,0x1FFFE9E3},
    [I(133,72)] = {29,0x1FFFEA63},
    [I(134,72)] = {29,0x1FFFEAE3},
    [I(135,72)] = {30,0x3FFFECE3},
    [I(136,72)] = {29,0x1FFFEB63},
    [I(137,72)] = {30,0x3FFFED63},
    [I(138,72)] = {30,0x3FFFEDE3},
    [I(139,72)] = {30,0x3FFFEE63},
    [I(140,72)] = {30,0x3FFFEEE3},
    [I(141,72)] = {30,0x3FFFEF63},
    [I(142,72)] = {31,0x7FFFF5E3},
    [I(143,72)] = {30,0x3FFFEFE3},
    [I(144,72)] = {31,0x7FFFF663},
    [I(145,72)] = {31,0x7FFFF6E3},
    [I(146,72)] = {29,0x1FFFEBE3},
    [I(147,72)] = {30,0x3FFFF063},
    [I(148,72)] = {31,0x7FFFF763},
    [I(149,72)] = {30,0x3FFFF0E3},
    [I(150,72)] = {30,0x3FFFF163},
    [I(151,72)] = {30,0x3FFFF1E3},
    [I(152,72)] = {30,0x3FFFF263},
    [I(153,72)] = {28,0xFFFEE63},
    [I(154,72)] = {29,0x1FFFEC63},
    [I(155,72)] = {30,0x3FFFF2E3},
    [I(156,72)] = {29,0x1FFFECE3},
    [I(157,72)] = {30,0x3FFFF363},
    [I(158,72)] = {30,0x3FFFF3E3},
    [I(159,72)] = {31,0x7FFFF7E3},
    [I(160,72)] = {29,0x1FFFED63},
    [I(161,72)] = {28,0xFFFEEE3},
    [I(162,72)] = {27,0x7FFF4E3},
    [I(163,72)] = {29,0x1FFFEDE3},
    [I(164,72)] = {29,0x1FFFEE63},
    [I(165,72)] = {30,0x3FFFF463},
    [I(166,72)] = {30,0x3FFFF4E3},
    [I(167,72)] = {28,0xFFFEF63},
    [I(168,72)] = {30,0x3FFFF563},
    [I(169,72)] = {29,0x1FFFEEE3},
    [I(170,72)] = {29,0x1FFFEF63},
    [I(171,72)] = {31,0x7FFFF863},
    [I(172,72)] = {28,0xFFFEFE3},
    [I(173,72)] = {29,0x1FFFEFE3},
    [I(174,72)] = {30,0x3FFFF5E3},
    [I(175,72)] = {30,0x3FFFF663},
    [I(176,72)] = {28,0xFFFF063},
    [I(177,72)] = {28,0xFFFF0E3},
    [I(178,72)] = {29,0x1FFFF063},
    [I(179,72)] = {28,0xFFFF163},
    [I(180,72)] = {30,0x3FFFF6E3},
    [I(181,72)] = {29,0x1FFFF0E3},
    [I(182,72)] = {30,0x3FFFF763},
    [I(183,72)] = {30,0x3FFFF7E3},
    [I(184,72)] = {27,0x7FFF563},
    [I(185,72)] = {29,0x1FFFF163},
    [I(186,72)] = {29,0x1FFFF1E3},
    [I(187,72)] = {29,0x1FFFF263},
    [I(188,72)] = {30,0x3FFFF863},
    [I(189,72)] = {29,0x1FFFF2E3},
    [I(190,72)] = {29,0x1FFFF363},
    [I(191,72)] = {30,0x3FFFF8E3},
    [I(192,72)] = {64,0},
    [I(193,72)] = {64,0},
    [I(194,72)] = {27,0x7FFF5E3},
    [I(195,72)] = {26,0x3FFF8E3},
    [I(196,72)] = {29,0x1FFFF3E3},
    [I(197,72)] = {30,0x3FFFF963},
    [I(198,72)] = {29,0x1FFFF463},
    [I(199,72)] = {X32,0xFFFFF663},
    [I(200,72)] = {64,0},
    [I(201,72)] = {64,0},
    [I(202,72)] = {64,0},
    [I(203,72)] = {64,0},
    [I(204,72)] = {64,0},
    [I(205,72)] = {64,0},
    [I(206,72)] = {31,0x7FFFF8E3},
    [I(207,72)] = {X32,0xFFFFF6E3},
    [I(208,72)] = {26,0x3FFF963},
    [I(209,72)] = {28,0xFFFF1E3},
    [I(210,72)] = {64,0},
    [I(211,72)] = {64,0},
    [I(212,72)] = {64,0},
    [I(213,72)] = {64,0},
    [I(214,72)] = {64,0},
    [I(215,72)] = {31,0x7FFFF963},
    [I(216,72)] = {28,0xFFFF263},
    [I(217,72)] = {28,0xFFFF2E3},
    [I(218,72)] = {64,0},
    [I(219,72)] = {64,0},
    [I(220,72)] = {64,0},
    [I(221,72)] = {64,0},
    [I(222,72)] = {64,0},
    [I(223,72)] = {64,0},
    [I(224,72)] = {27,0x7FFF663},
    [I(225,72)] = {31,0x7FFFF9E3},
    [I(226,72)] = {27,0x7FFF6E3},
    [I(227,72)] = {28,0xFFFF363},
    [I(228,72)] = {29,0x1FFFF4E3},
    [I(229,72)] = {28,0xFFFF3E3},
    [I(230,72)] = {28,0xFFFF463},
    [I(231,72)] = {30,0x3FFFF9E3},
    [I(232,72)] = {29,0x1FFFF563},
    [I(233,72)] = {29,0x1FFFF5E3},
    [I(234,72)] = {X32,0xFFFFF763},
    [I(235,72)] = {X32,0xFFFFF7E3},
    [I(236,72)] = {31,0x7FFFFA63},
    [I(237,72)] = {31,0x7FFFFAE3},
    [I(238,72)] = {64,0},
    [I(239,72)] = {30,0x3FFFFA63},
    [I(240,72)] = {64,0},
    [I(241,72)] = {64,0},
    [I(242,72)] = {64,0},
    [I(243,72)] = {64,0},
    [I(244,72)] = {64,0},
    [I(245,72)] = {64,0},
    [I(246,72)] = {64,0},
    [I(247,72)] = {64,0},
    [I(248,72)] = {64,0},
    [I(249,72)] = {64,0},
    [I(250,72)] = {64,0},
    [I(251,72)] = {64,0},
    [I(252,72)] = {64,0},
    [I(253,72)] = {64,0},
    [I(254,72)] = {64,0},
    [I(255,72)] = {64,0},
    [I(0,73)] = {20,0xFFC64},
    [I(1,73)] = {30,0x3FFFEC64},
    [I(2,73)] = {64,0},
    [I(3,73)] = {64,0},
    [I(4,73)] = {64,0},
    [I(5,73)] = {64,0},
    [I(6,73)] = {64,0},
    [I(7,73)] = {64,0},
    [I(8,73)] = {64,0},
    [I(9,73)] = {31,0x7FFFF564},
    [I(10,73)] = {64,0},
    [I(11,73)] = {64,0},
    [I(12,73)] = {64,0},
    [I(13,73)] = {64,0},
    [I(14,73)] = {64,0},
    [I(15,73)] = {64,0},
    [I(16,73)] = {64,0},
    [I(17,73)] = {64,0},
    [I(18,73)] = {64,0},
    [I(19,73)] = {64,0},
    [I(20,73)] = {64,0},
    [I(21,73)] = {64,0},
    [I(22,73)] = {64,0},
    [I(23,73)] = {64,0},
    [I(24,73)] = {64,0},
    [I(25,73)] = {64,0},
    [I(26,73)] = {64,0},
    [I(27,73)] = {64,0},
    [I(28,73)] = {64,0},
    [I(29,73)] = {64,0},
    [I(30,73)] = {64,0},
    [I(31,73)] = {64,0},
    [I(32,73)] = {13,0xA64},
    [I(33,73)] = {17,0x1FC64},
    [I(34,73)] = {17,0x1FCE4},
    [I(35,73)] = {19,0x7FD64},
    [I(36,73)] = {20,0xFFCE4},
    [I(37,73)] = {13,0xAE4},
    [I(38,73)] = {15,0x7C64},
    [I(39,73)] = {18,0x3FD64},
    [I(40,73)] = {17,0x1FD64},
    [I(41,73)] = {17,0x1FDE4},
    [I(42,73)] = {15,0x7CE4},
    [I(43,73)] = {18,0x3FDE4},
    [I(44,73)] = {15,0x7D64},
    [I(45,73)] = {13,0xB64},
    [I(46,73)] = {13,0xBE4},
    [I(47,73)] = {13,0xC64},
    [I(48,73)] = {12,0x64},
    [I(49,73)] = {12,0xE4},
    [I(50,73)] = {12,0x164},
    [I(51,73)] = {13,0xCE4},
    [I(52,73)] = {13,0xD64},
    [I(53,73)] = {13,0xDE4},
    [I(54,73)] = {13,0xE64},
    [I(55,73)] = {13,0xEE4},
    [I(56,73)] = {13,0xF64},
    [I(57,73)] = {13,0xFE4},
    [I(58,73)] = {14,0x2E64},
    [I(59,73)] = {15,0x7DE4},
    [I(60,73)] = {22,0x3FFE64},
    [I(61,73)] = {13,0x1064},
    [I(62,73)] = {19,0x7FDE4},
    [I(63,73)] = {17,0x1FE64},
    [I(64,73)] = {20,0xFFD64},
    [I(65,73)] = {13,0x10E4},
    [I(66,73)] = {14,0x2EE4},
    [I(67,73)] = {14,0x2F64},
    [I(68,73)] = {14,0x2FE4},
    [I(69,73)] = {14,0x3064},
    [I(70,73)] = {14,0x30E4},
    [I(71,73)] = {14,0x3164},
    [I(72,73)] = {14,0x31E4},
    [I(73,73)] = {14,0x3264},
    [I(74,73)] = {14,0x32E4},
    [I(75,73)] = {14,0x3364},
    [I(76,73)] = {14,0x33E4},
    [I(77,73)] = {14,0x3464},
    [I(78,73)] = {14,0x34E4},
    [I(79,73)] = {14,0x3564},
    [I(80,73)] = {14,0x35E4},
    [I(81,73)] = {14,0x3664},
    [I(82,73)] = {14,0x36E4},
    [I(83,73)] = {14,0x3764},
    [I(84,73)] = {14,0x37E4},
    [I(85,73)] = {14,0x3864},
    [I(86,73)] = {14,0x38E4},
    [I(87,73)] = {14,0x3964},
    [I(88,73)] = {15,0x7E64},
    [I(89,73)] = {14,0x39E4},
    [I(90,73)] = {15,0x7EE4},
    [I(91,73)] = {20,0xFFDE4},
    [I(92,73)] = {26,0x3FFF864},
    [I(93,73)] = {20,0xFFE64},
    [I(94,73)] = {21,0x1FFE64},
    [I(95,73)] = {13,0x1164},
    [I(96,73)] = {22,0x3FFEE4},
    [I(97,73)] = {12,0x1E4},
    [I(98,73)] = {13,0x11E4},
    [I(99,73)] = {12,0x264},
    [I(100,73)] = {13,0x1264},
    [I(101,73)] = {12,0x2E4},
    [I(102,73)] = {13,0x12E4},
    [I(103,73)] = {13,0x1364},
    [I(104,73)] = {13,0x13E4},
    [I(105,73)] = {12,0x364},
    [I(106,73)] = {14,0x3A64},
    [I(107,73)] = {14,0x3AE4},
    [I(108,73)] = {13,0x1464},
    [I(109,73)] = {13,0x14E4},
    [I(110,73)] = {13,0x1564},
    [I(111,73)] = {12,0x3E4},
    [I(112,73)] = {13,0x15E4},
    [I(113,73)] = {14,0x3B64},
    [I(114,73)] = {13,0x1664},
    [I(115,73)] = {12,0x464},
    [I(116,73)] = {12,0x4E4},
    [I(117,73)] = {13,0x16E4},
    [I(118,73)] = {14,0x3BE4},
    [I(119,73)] = {14,0x3C64},
    [I(120,73)] = {14,0x3CE4},
    [I(121,73)] = {14,0x3D64},
    [I(122,73)] = {14,0x3DE4},
    [I(123,73)] = {22,0x3FFF64},
    [I(124,73)] = {18,0x3FE64},
    [I(125,73)] = {21,0x1FFEE4},
    [I(126,73)] = {20,0xFFEE4},
    [I(127,73)] = {64,0},
    [I(128,73)] = {27,0x7FFF364},
    [I(129,73)] = {29,0x1FFFE964},
    [I(130,73)] = {27,0x7FFF3E4},
    [I(131,73)] = {27,0x7FFF464},
    [I(132,73)] = {29,0x1FFFE9E4},
    [I(133,73)] = {29,0x1FFFEA64},
    [I(134,73)] = {29,0x1FFFEAE4},
    [I(135,73)] = {30,0x3FFFECE4},
    [I(136,73)] = {29,0x1FFFEB64},
    [I(137,73)] = {30,0x3FFFED64},
    [I(138,73)] = {30,0x3FFFEDE4},
    [I(139,73)] = {30,0x3FFFEE64},
    [I(140,73)] = {30,0x3FFFEEE4},
    [I(141,73)] = {30,0x3FFFEF64},
    [I(142,73)] = {31,0x7FFFF5E4},
    [I(143,73)] = {30,0x3FFFEFE4},
    [I(144,73)] = {31,0x7FFFF664},
    [I(145,73)] = {31,0x7FFFF6E4},
    [I(146,73)] = {29,0x1FFFEBE4},
    [I(147,73)] = {30,0x3FFFF064},
    [I(148,73)] = {31,0x7FFFF764},
    [I(149,73)] = {30,0x3FFFF0E4},
    [I(150,73)] = {30,0x3FFFF164},
    [I(151,73)] = {30,0x3FFFF1E4},
    [I(152,73)] = {30,0x3FFFF264},
    [I(153,73)] = {28,0xFFFEE64},
    [I(154,73)] = {29,0x1FFFEC64},
    [I(155,73)] = {30,0x3FFFF2E4},
    [I(156,73)] = {29,0x1FFFECE4},
    [I(157,73)] = {30,0x3FFFF364},
    [I(158,73)] = {30,0x3FFFF3E4},
    [I(159,73)] = {31,0x7FFFF7E4},
    [I(160,73)] = {29,0x1FFFED64},
    [I(161,73)] = {28,0xFFFEEE4},
    [I(162,73)] = {27,0x7FFF4E4},
    [I(163,73)] = {29,0x1FFFEDE4},
    [I(164,73)] = {29,0x1FFFEE64},
    [I(165,73)] = {30,0x3FFFF464},
    [I(166,73)] = {30,0x3FFFF4E4},
    [I(167,73)] = {28,0xFFFEF64},
    [I(168,73)] = {30,0x3FFFF564},
    [I(169,73)] = {29,0x1FFFEEE4},
    [I(170,73)] = {29,0x1FFFEF64},
    [I(171,73)] = {31,0x7FFFF864},
    [I(172,73)] = {28,0xFFFEFE4},
    [I(173,73)] = {29,0x1FFFEFE4},
    [I(174,73)] = {30,0x3FFFF5E4},
    [I(175,73)] = {30,0x3FFFF664},
    [I(176,73)] = {28,0xFFFF064},
    [I(177,73)] = {28,0xFFFF0E4},
    [I(178,73)] = {29,0x1FFFF064},
    [I(179,73)] = {28,0xFFFF164},
    [I(180,73)] = {30,0x3FFFF6E4},
    [I(181,73)] = {29,0x1FFFF0E4},
    [I(182,73)] = {30,0x3FFFF764},
    [I(183,73)] = {30,0x3FFFF7E4},
    [I(184,73)] = {27,0x7FFF564},
    [I(185,73)] = {29,0x1FFFF164},
    [I(186,73)] = {29,0x1FFFF1E4},
    [I(187,73)] = {29,0x1FFFF264},
    [I(188,73)] = {30,0x3FFFF864},
    [I(189,73)] = {29,0x1FFFF2E4},
    [I(190,73)] = {29,0x1FFFF364},
    [I(191,73)] = {30,0x3FFFF8E4},
    [I(192,73)] = {64,0},
    [I(193,73)] = {64,0},
    [I(194,73)] = {27,0x7FFF5E4},
    [I(195,73)] = {26,0x3FFF8E4},
    [I(196,73)] = {29,0x1FFFF3E4},
    [I(197,73)] = {30,0x3FFFF964},
    [I(198,73)] = {29,0x1FFFF464},
    [I(199,73)] = {X32,0xFFFFF664},
    [I(200,73)] = {64,0},
    [I(201,73)] = {64,0},
    [I(202,73)] = {64,0},
    [I(203,73)] = {64,0},
    [I(204,73)] = {64,0},
    [I(205,73)] = {64,0},
    [I(206,73)] = {31,0x7FFFF8E4},
    [I(207,73)] = {X32,0xFFFFF6E4},
    [I(208,73)] = {26,0x3FFF964},
    [I(209,73)] = {28,0xFFFF1E4},
    [I(210,73)] = {64,0},
    [I(211,73)] = {64,0},
    [I(212,73)] = {64,0},
    [I(213,73)] = {64,0},
    [I(214,73)] = {64,0},
    [I(215,73)] = {31,0x7FFFF964},
    [I(216,73)] = {28,0xFFFF264},
    [I(217,73)] = {28,0xFFFF2E4},
    [I(218,73)] = {64,0},
    [I(219,73)] = {64,0},
    [I(220,73)] = {64,0},
    [I(221,73)] = {64,0},
    [I(222,73)] = {64,0},
    [I(223,73)] = {64,0},
    [I(224,73)] = {27,0x7FFF664},
    [I(225,73)] = {31,0x7FFFF9E4},
    [I(226,73)] = {27,0x7FFF6E4},
    [I(227,73)] = {28,0xFFFF364},
    [I(228,73)] = {29,0x1FFFF4E4},
    [I(229,73)] = {28,0xFFFF3E4},
    [I(230,73)] = {28,0xFFFF464},
    [I(231,73)] = {30,0x3FFFF9E4},
    [I(232,73)] = {29,0x1FFFF564},
    [I(233,73)] = {29,0x1FFFF5E4},
    [I(234,73)] = {X32,0xFFFFF764},
    [I(235,73)] = {X32,0xFFFFF7E4},
    [I(236,73)] = {31,0x7FFFFA64},
    [I(237,73)] = {31,0x7FFFFAE4},
    [I(238,73)] = {64,0},
    [I(239,73)] = {30,0x3FFFFA64},
    [I(240,73)] = {64,0},
    [I(241,73)] = {64,0},
    [I(242,73)] = {64,0},
    [I(243,73)] = {64,0},
    [I(244,73)] = {64,0},
    [I(245,73)] = {64,0},
    [I(246,73)] = {64,0},
    [I(247,73)] = {64,0},
    [I(248,73)] = {64,0},
    [I(249,73)] = {64,0},
    [I(250,73)] = {64,0},
    [I(251,73)] = {64,0},
    [I(252,73)] = {64,0},
    [I(253,73)] = {64,0},
    [I(254,73)] = {64,0},
    [I(255,73)] = {64,0},
    [I(0,74)] = {20,0xFFC65},
    [I(1,74)] = {30,0x3FFFEC65},
    [I(2,74)] = {64,0},
    [I(3,74)] = {64,0},
    [I(4,74)] = {64,0},
    [I(5,74)] = {64,0},
    [I(6,74)] = {64,0},
    [I(7,74)] = {64,0},
    [I(8,74)] = {64,0},
    [I(9,74)] = {31,0x7FFFF565},
    [I(10,74)] = {64,0},
    [I(11,74)] = {64,0},
    [I(12,74)] = {64,0},
    [I(13,74)] = {64,0},
    [I(14,74)] = {64,0},
    [I(15,74)] = {64,0},
    [I(16,74)] = {64,0},
    [I(17,74)] = {64,0},
    [I(18,74)] = {64,0},
    [I(19,74)] = {64,0},
    [I(20,74)] = {64,0},
    [I(21,74)] = {64,0},
    [I(22,74)] = {64,0},
    [I(23,74)] = {64,0},
    [I(24,74)] = {64,0},
    [I(25,74)] = {64,0},
    [I(26,74)] = {64,0},
    [I(27,74)] = {64,0},
    [I(28,74)] = {64,0},
    [I(29,74)] = {64,0},
    [I(30,74)] = {64,0},
    [I(31,74)] = {64,0},
    [I(32,74)] = {13,0xA65},
    [I(33,74)] = {17,0x1FC65},
    [I(34,74)] = {17,0x1FCE5},
    [I(35,74)] = {19,0x7FD65},
    [I(36,74)] = {20,0xFFCE5},
    [I(37,74)] = {13,0xAE5},
    [I(38,74)] = {15,0x7C65},
    [I(39,74)] = {18,0x3FD65},
    [I(40,74)] = {17,0x1FD65},
    [I(41,74)] = {17,0x1FDE5},
    [I(42,74)] = {15,0x7CE5},
    [I(43,74)] = {18,0x3FDE5},
    [I(44,74)] = {15,0x7D65},
    [I(45,74)] = {13,0xB65},
    [I(46,74)] = {13,0xBE5},
    [I(47,74)] = {13,0xC65},
    [I(48,74)] = {12,0x65},
    [I(49,74)] = {12,0xE5},
    [I(50,74)] = {12,0x165},
    [I(51,74)] = {13,0xCE5},
    [I(52,74)] = {13,0xD65},
    [I(53,74)] = {13,0xDE5},
    [I(54,74)] = {13,0xE65},
    [I(55,74)] = {13,0xEE5},
    [I(56,74)] = {13,0xF65},
    [I(57,74)] = {13,0xFE5},
    [I(58,74)] = {14,0x2E65},
    [I(59,74)] = {15,0x7DE5},
    [I(60,74)] = {22,0x3FFE65},
    [I(61,74)] = {13,0x1065},
    [I(62,74)] = {19,0x7FDE5},
    [I(63,74)] = {17,0x1FE65},
    [I(64,74)] = {20,0xFFD65},
    [I(65,74)] = {13,0x10E5},
    [I(66,74)] = {14,0x2EE5},
    [I(67,74)] = {14,0x2F65},
    [I(68,74)] = {14,0x2FE5},
    [I(69,74)] = {14,0x3065},
    [I(70,74)] = {14,0x30E5},
    [I(71,74)] = {14,0x3165},
    [I(72,74)] = {14,0x31E5},
    [I(73,74)] = {14,0x3265},
    [I(74,74)] = {14,0x32E5},
    [I(75,74)] = {14,0x3365},
    [I(76,74)] = {14,0x33E5},
    [I(77,74)] = {14,0x3465},
    [I(78,74)] = {14,0x34E5},
    [I(79,74)] = {14,0x3565},
    [I(80,74)] = {14,0x35E5},
    [I(81,74)] = {14,0x3665},
    [I(82,74)] = {14,0x36E5},
    [I(83,74)] = {14,0x3765},
    [I(84,74)] = {14,0x37E5},
    [I(85,74)] = {14,0x3865},
    [I(86,74)] = {14,0x38E5},
    [I(87,74)] = {14,0x3965},
    [I(88,74)] = {15,0x7E65},
    [I(89,74)] = {14,0x39E5},
    [I(90,74)] = {15,0x7EE5},
    [I(91,74)] = {20,0xFFDE5},
    [I(92,74)] = {26,0x3FFF865},
    [I(93,74)] = {20,0xFFE65},
    [I(94,74)] = {21,0x1FFE65},
    [I(95,74)] = {13,0x1165},
    [I(96,74)] = {22,0x3FFEE5},
    [I(97,74)] = {12,0x1E5},
    [I(98,74)] = {13,0x11E5},
    [I(99,74)] = {12,0x265},
    [I(100,74)] = {13,0x1265},
    [I(101,74)] = {12,0x2E5},
    [I(102,74)] = {13,0x12E5},
    [I(103,74)] = {13,0x1365},
    [I(104,74)] = {13,0x13E5},
    [I(105,74)] = {12,0x365},
    [I(106,74)] = {14,0x3A65},
    [I(107,74)] = {14,0x3AE5},
    [I(108,74)] = {13,0x1465},
    [I(109,74)] = {13,0x14E5},
    [I(110,74)] = {13,0x1565},
    [I(111,74)] = {12,0x3E5},
    [I(112,74)] = {13,0x15E5},
    [I(113,74)] = {14,0x3B65},
    [I(114,74)] = {13,0x1665},
    [I(115,74)] = {12,0x465},
    [I(116,74)] = {12,0x4E5},
    [I(117,74)] = {13,0x16E5},
    [I(118,74)] = {14,0x3BE5},
    [I(119,74)] = {14,0x3C65},
    [I(120,74)] = {14,0x3CE5},
    [I(121,74)] = {14,0x3D65},
    [I(122,74)] = {14,0x3DE5},
    [I(123,74)] = {22,0x3FFF65},
    [I(124,74)] = {18,0x3FE65},
    [I(125,74)] = {21,0x1FFEE5},
    [I(126,74)] = {20,0xFFEE5},
    [I(127,74)] = {64,0},
    [I(128,74)] = {27,0x7FFF365},
    [I(129,74)] = {29,0x1FFFE965},
    [I(130,74)] = {27,0x7FFF3E5},
    [I(131,74)] = {27,0x7FFF465},
    [I(132,74)] = {29,0x1FFFE9E5},
    [I(133,74)] = {29,0x1FFFEA65},
    [I(134,74)] = {29,0x1FFFEAE5},
    [I(135,74)] = {30,0x3FFFECE5},
    [I(136,74)] = {29,0x1FFFEB65},
    [I(137,74)] = {30,0x3FFFED65},
    [I(138,74)] = {30,0x3FFFEDE5},
    [I(139,74)] = {30,0x3FFFEE65},
    [I(140,74)] = {30,0x3FFFEEE5},
    [I(141,74)] = {30,0x3FFFEF65},
    [I(142,74)] = {31,0x7FFFF5E5},
    [I(143,74)] = {30,0x3FFFEFE5},
    [I(144,74)] = {31,0x7FFFF665},
    [I(145,74)] = {31,0x7FFFF6E5},
    [I(146,74)] = {29,0x1FFFEBE5},
    [I(147,74)] = {30,0x3FFFF065},
    [I(148,74)] = {31,0x7FFFF765},
    [I(149,74)] = {30,0x3FFFF0E5},
    [I(150,74)] = {30,0x3FFFF165},
    [I(151,74)] = {30,0x3FFFF1E5},
    [I(152,74)] = {30,0x3FFFF265},
    [I(153,74)] = {28,0xFFFEE65},
    [I(154,74)] = {29,0x1FFFEC65},
    [I(155,74)] = {30,0x3FFFF2E5},
    [I(156,74)] = {29,0x1FFFECE5},
    [I(157,74)] = {30,0x3FFFF365},
    [I(158,74)] = {30,0x3FFFF3E5},
    [I(159,74)] = {31,0x7FFFF7E5},
    [I(160,74)] = {29,0x1FFFED65},
    [I(161,74)] = {28,0xFFFEEE5},
    [I(162,74)] = {27,0x7FFF4E5},
    [I(163,74)] = {29,0x1FFFEDE5},
    [I(164,74)] = {29,0x1FFFEE65},
    [I(165,74)] = {30,0x3FFFF465},
    [I(166,74)] = {30,0x3FFFF4E5},
    [I(167,74)] = {28,0xFFFEF65},
    [I(168,74)] = {30,0x3FFFF565},
    [I(169,74)] = {29,0x1FFFEEE5},
    [I(170,74)] = {29,0x1FFFEF65},
    [I(171,74)] = {31,0x7FFFF865},
    [I(172,74)] = {28,0xFFFEFE5},
    [I(173,74)] = {29,0x1FFFEFE5},
    [I(174,74)] = {30,0x3FFFF5E5},
    [I(175,74)] = {30,0x3FFFF665},
    [I(176,74)] = {28,0xFFFF065},
    [I(177,74)] = {28,0xFFFF0E5},
    [I(178,74)] = {29,0x1FFFF065},
    [I(179,74)] = {28,0xFFFF165},
    [I(180,74)] = {30,0x3FFFF6E5},
    [I(181,74)] = {29,0x1FFFF0E5},
    [I(182,74)] = {30,0x3FFFF765},
    [I(183,74)] = {30,0x3FFFF7E5},
    [I(184,74)] = {27,0x7FFF565},
    [I(185,74)] = {29,0x1FFFF165},
    [I(186,74)] = {29,0x1FFFF1E5},
    [I(187,74)] = {29,0x1FFFF265},
    [I(188,74)] = {30,0x3FFFF865},
    [I(189,74)] = {29,0x1FFFF2E5},
    [I(190,74)] = {29,0x1FFFF365},
    [I(191,74)] = {30,0x3FFFF8E5},
    [I(192,74)] = {64,0},
    [I(193,74)] = {64,0},
    [I(194,74)] = {27,0x7FFF5E5},
    [I(195,74)] = {26,0x3FFF8E5},
    [I(196,74)] = {29,0x1FFFF3E5},
    [I(197,74)] = {30,0x3FFFF965},
    [I(198,74)] = {29,0x1FFFF465},
    [I(199,74)] = {X32,0xFFFFF665},
    [I(200,74)] = {64,0},
    [I(201,74)] = {64,0},
    [I(202,74)] = {64,0},
    [I(203,74)] = {64,0},
    [I(204,74)] = {64,0},
    [I(205,74)] = {64,0},
    [I(206,74)] = {31,0x7FFFF8E5},
    [I(207,74)] = {X32,0xFFFFF6E5},
    [I(208,74)] = {26,0x3FFF965},
    [I(209,74)] = {28,0xFFFF1E5},
    [I(210,74)] = {64,0},
    [I(211,74)] = {64,0},
    [I(212,74)] = {64,0},
    [I(213,74)] = {64,0},
    [I(214,74)] = {64,0},
    [I(215,74)] = {31,0x7FFFF965},
    [I(216,74)] = {28,0xFFFF265},
    [I(217,74)] = {28,0xFFFF2E5},
    [I(218,74)] = {64,0},
    [I(219,74)] = {64,0},
    [I(220,74)] = {64,0},
    [I(221,74)] = {64,0},
    [I(222,74)] = {64,0},
    [I(223,74)] = {64,0},
    [I(224,74)] = {27,0x7FFF665},
    [I(225,74)] = {31,0x7FFFF9E5},
    [I(226,74)] = {27,0x7FFF6E5},
    [I(227,74)] = {28,0xFFFF365},
    [I(228,74)] = {29,0x1FFFF4E5},
    [I(229,74)] = {28,0xFFFF3E5},
    [I(230,74)] = {28,0xFFFF465},
    [I(231,74)] = {30,0x3FFFF9E5},
    [I(232,74)] = {29,0x1FFFF565},
    [I(233,74)] = {29,0x1FFFF5E5},
    [I(234,74)] = {X32,0xFFFFF765},
    [I(235,74)] = {X32,0xFFFFF7E5},
    [I(236,74)] = {31,0x7FFFFA65},
    [I(237,74)] = {31,0x7FFFFAE5},
    [I(238,74)] = {64,0},
    [I(239,74)] = {30,0x3FFFFA65},
    [I(240,74)] = {64,0},
    [I(241,74)] = {64,0},
    [I(242,74)] = {64,0},
    [I(243,74)] = {64,0},
    [I(244,74)] = {64,0},
    [I(245,74)] = {64,0},
    [I(246,74)] = {64,0},
    [I(247,74)] = {64,0},
    [I(248,74)] = {64,0},
    [I(249,74)] = {64,0},
    [I(250,74)] = {64,0},
    [I(251,74)] = {64,0},
    [I(252,74)] = {64,0},
    [I(253,74)] = {64,0},
    [I(254,74)] = {64,0},
    [I(255,74)] = {64,0},
    [I(0,75)] = {20,0xFFC66},
    [I(1,75)] = {30,0x3FFFEC66},
    [I(2,75)] = {64,0},
    [I(3,75)] = {64,0},
    [I(4,75)] = {64,0},
    [I(5,75)] = {64,0},
    [I(6,75)] = {64,0},
    [I(7,75)] = {64,0},
    [I(8,75)] = {64,0},
    [I(9,75)] = {31,0x7FFFF566},
    [I(10,75)] = {64,0},
    [I(11,75)] = {64,0},
    [I(12,75)] = {64,0},
    [I(13,75)] = {64,0},
    [I(14,75)] = {64,0},
    [I(15,75)] = {64,0},
    [I(16,75)] = {64,0},
    [I(17,75)] = {64,0},
    [I(18,75)] = {64,0},
    [I(19,75)] = {64,0},
    [I(20,75)] = {64,0},
    [I(21,75)] = {64,0},
    [I(22,75)] = {64,0},
    [I(23,75)] = {64,0},
    [I(24,75)] = {64,0},
    [I(25,75)] = {64,0},
    [I(26,75)] = {64,0},
    [I(27,75)] = {64,0},
    [I(28,75)] = {64,0},
    [I(29,75)] = {64,0},
    [I(30,75)] = {64,0},
    [I(31,75)] = {64,0},
    [I(32,75)] = {13,0xA66},
    [I(33,75)] = {17,0x1FC66},
    [I(34,75)] = {17,0x1FCE6},
    [I(35,75)] = {19,0x7FD66},
    [I(36,75)] = {20,0xFFCE6},
    [I(37,75)] = {13,0xAE6},
    [I(38,75)] = {15,0x7C66},
    [I(39,75)] = {18,0x3FD66},
    [I(40,75)] = {17,0x1FD66},
    [I(41,75)] = {17,0x1FDE6},
    [I(42,75)] = {15,0x7CE6},
    [I(43,75)] = {18,0x3FDE6},
    [I(44,75)] = {15,0x7D66},
    [I(45,75)] = {13,0xB66},
    [I(46,75)] = {13,0xBE6},
    [I(47,75)] = {13,0xC66},
    [I(48,75)] = {12,0x66},
    [I(49,75)] = {12,0xE6},
    [I(50,75)] = {12,0x166},
    [I(51,75)] = {13,0xCE6},
    [I(52,75)] = {13,0xD66},
    [I(53,75)] = {13,0xDE6},
    [I(54,75)] = {13,0xE66},
    [I(55,75)] = {13,0xEE6},
    [I(56,75)] = {13,0xF66},
    [I(57,75)] = {13,0xFE6},
    [I(58,75)] = {14,0x2E66},
    [I(59,75)] = {15,0x7DE6},
    [I(60,75)] = {22,0x3FFE66},
    [I(61,75)] = {13,0x1066},
    [I(62,75)] = {19,0x7FDE6},
    [I(63,75)] = {17,0x1FE66},
    [I(64,75)] = {20,0xFFD66},
    [I(65,75)] = {13,0x10E6},
    [I(66,75)] = {14,0x2EE6},
    [I(67,75)] = {14,0x2F66},
    [I(68,75)] = {14,0x2FE6},
    [I(69,75)] = {14,0x3066},
    [I(70,75)] = {14,0x30E6},
    [I(71,75)] = {14,0x3166},
    [I(72,75)] = {14,0x31E6},
    [I(73,75)] = {14,0x3266},
    [I(74,75)] = {14,0x32E6},
    [I(75,75)] = {14,0x3366},
    [I(76,75)] = {14,0x33E6},
    [I(77,75)] = {14,0x3466},
    [I(78,75)] = {14,0x34E6},
    [I(79,75)] = {14,0x3566},
    [I(80,75)] = {14,0x35E6},
    [I(81,75)] = {14,0x3666},
    [I(82,75)] = {14,0x36E6},
    [I(83,75)] = {14,0x3766},
    [I(84,75)] = {14,0x37E6},
    [I(85,75)] = {14,0x3866},
    [I(86,75)] = {14,0x38E6},
    [I(87,75)] = {14,0x3966},
    [I(88,75)] = {15,0x7E66},
    [I(89,75)] = {14,0x39E6},
    [I(90,75)] = {15,0x7EE6},
    [I(91,75)] = {20,0xFFDE6},
    [I(92,75)] = {26,0x3FFF866},
    [I(93,75)] = {20,0xFFE66},
    [I(94,75)] = {21,0x1FFE66},
    [I(95,75)] = {13,0x1166},
    [I(96,75)] = {22,0x3FFEE6},
    [I(97,75)] = {12,0x1E6},
    [I(98,75)] = {13,0x11E6},
    [I(99,75)] = {12,0x266},
    [I(100,75)] = {13,0x1266},
    [I(101,75)] = {12,0x2E6},
    [I(102,75)] = {13,0x12E6},
    [I(103,75)] = {13,0x1366},
    [I(104,75)] = {13,0x13E6},
    [I(105,75)] = {12,0x366},
    [I(106,75)] = {14,0x3A66},
    [I(107,75)] = {14,0x3AE6},
    [I(108,75)] = {13,0x1466},
    [I(109,75)] = {13,0x14E6},
    [I(110,75)] = {13,0x1566},
    [I(111,75)] = {12,0x3E6},
    [I(112,75)] = {13,0x15E6},
    [I(113,75)] = {14,0x3B66},
    [I(114,75)] = {13,0x1666},
    [I(115,75)] = {12,0x466},
    [I(116,75)] = {12,0x4E6},
    [I(117,75)] = {13,0x16E6},
    [I(118,75)] = {14,0x3BE6},
    [I(119,75)] = {14,0x3C66},
    [I(120,75)] = {14,0x3CE6},
    [I(121,75)] = {14,0x3D66},
    [I(122,75)] = {14,0x3DE6},
    [I(123,75)] = {22,0x3FFF66},
    [I(124,75)] = {18,0x3FE66},
    [I(125,75)] = {21,0x1FFEE6},
    [I(126,75)] = {20,0xFFEE6},
    [I(127,75)] = {64,0},
    [I(128,75)] = {27,0x7FFF366},
    [I(129,75)] = {29,0x1FFFE966},
    [I(130,75)] = {27,0x7FFF3E6},
    [I(131,75)] = {27,0x7FFF466},
    [I(132,75)] = {29,0x1FFFE9E6},
    [I(133,75)] = {29,0x1FFFEA66},
    [I(134,75)] = {29,0x1FFFEAE6},
    [I(135,75)] = {30,0x3FFFECE6},
    [I(136,75)] = {29,0x1FFFEB66},
    [I(137,75)] = {30,0x3FFFED66},
    [I(138,75)] = {30,0x3FFFEDE6},
    [I(139,75)] = {30,0x3FFFEE66},
    [I(140,75)] = {30,0x3FFFEEE6},
    [I(141,75)] = {30,0x3FFFEF66},
    [I(142,75)] = {31,0x7FFFF5E6},
    [I(143,75)] = {30,0x3FFFEFE6},
    [I(144,75)] = {31,0x7FFFF666},
    [I(145,75)] = {31,0x7FFFF6E6},
    [I(146,75)] = {29,0x1FFFEBE6},
    [I(147,75)] = {30,0x3FFFF066},
    [I(148,75)] = {31,0x7FFFF766},
    [I(149,75)] = {30,0x3FFFF0E6},
    [I(150,75)] = {30,0x3FFFF166},
    [I(151,75)] = {30,0x3FFFF1E6},
    [I(152,75)] = {30,0x3FFFF266},
    [I(153,75)] = {28,0xFFFEE66},
    [I(154,75)] = {29,0x1FFFEC66},
    [I(155,75)] = {30,0x3FFFF2E6},
    [I(156,75)] = {29,0x1FFFECE6},
    [I(157,75)] = {30,0x3FFFF366},
    [I(158,75)] = {30,0x3FFFF3E6},
    [I(159,75)] = {31,0x7FFFF7E6},
    [I(160,75)] = {29,0x1FFFED66},
    [I(161,75)] = {28,0xFFFEEE6},
    [I(162,75)] = {27,0x7FFF4E6},
    [I(163,75)] = {29,0x1FFFEDE6},
    [I(164,75)] = {29,0x1FFFEE66},
    [I(165,75)] = {30,0x3FFFF466},
    [I(166,75)] = {30,0x3FFFF4E6},
    [I(167,75)] = {28,0xFFFEF66},
    [I(168,75)] = {30,0x3FFFF566},
    [I(169,75)] = {29,0x1FFFEEE6},
    [I(170,75)] = {29,0x1FFFEF66},
    [I(171,75)] = {31,0x7FFFF866},
    [I(172,75)] = {28,0xFFFEFE6},
    [I(173,75)] = {29,0x1FFFEFE6},
    [I(174,75)] = {30,0x3FFFF5E6},
    [I(175,75)] = {30,0x3FFFF666},
    [I(176,75)] = {28,0xFFFF066},
    [I(177,75)] = {28,0xFFFF0E6},
    [I(178,75)] = {29,0x1FFFF066},
    [I(179,75)] = {28,0xFFFF166},
    [I(180,75)] = {30,0x3FFFF6E6},
    [I(181,75)] = {29,0x1FFFF0E6},
    [I(182,75)] = {30,0x3FFFF766},
    [I(183,75)] = {30,0x3FFFF7E6},
    [I(184,75)] = {27,0x7FFF566},
    [I(185,75)] = {29,0x1FFFF166},
    [I(186,75)] = {29,0x1FFFF1E6},
    [I(187,75)] = {29,0x1FFFF266},
    [I(188,75)] = {30,0x3FFFF866},
    [I(189,75)] = {29,0x1FFFF2E6},
    [I(190,75)] = {29,0x1FFFF366},
    [I(191,75)] = {30,0x3FFFF8E6},
    [I(192,75)] = {64,0},
    [I(193,75)] = {64,0},
    [I(194,75)] = {27,0x7FFF5E6},
    [I(195,75)] = {26,0x3FFF8E6},
    [I(196,75)] = {29,0x1FFFF3E6},
    [I(197,75)] = {30,0x3FFFF966},
    [I(198,75)] = {29,0x1FFFF466},
    [I(199,75)] = {X32,0xFFFFF666},
    [I(200,75)] = {64,0},
    [I(201,75)] = {64,0},
    [I(202,75)] = {64,0},
    [I(203,75)] = {64,0},
    [I(204,75)] = {64,0},
    [I(205,75)] = {64,0},
    [I(206,75)] = {31,0x7FFFF8E6},
    [I(207,75)] = {X32,0xFFFFF6E6},
    [I(208,75)] = {26,0x3FFF966},
    [I(209,75)] = {28,0xFFFF1E6},
    [I(210,75)] = {64,0},
    [I(211,75)] = {64,0},
    [I(212,75)] = {64,0},
    [I(213,75)] = {64,0},
    [I(214,75)] = {64,0},
    [I(215,75)] = {31,0x7FFFF966},
    [I(216,75)] = {28,0xFFFF266},
    [I(217,75)] = {28,0xFFFF2E6},
    [I(218,75)] = {64,0},
    [I(219,75)] = {64,0},
    [I(220,75)] = {64,0},
    [I(221,75)] = {64,0},
    [I(222,75)] = {64,0},
    [I(223,75)] = {64,0},
    [I(224,75)] = {27,0x7FFF666},
    [I(225,75)] = {31,0x7FFFF9E6},
    [I(226,75)] = {27,0x7FFF6E6},
    [I(227,75)] = {28,0xFFFF366},
    [I(228,75)] = {29,0x1FFFF4E6},
    [I(229,75)] = {28,0xFFFF3E6},
    [I(230,75)] = {28,0xFFFF466},
    [I(231,75)] = {30,0x3FFFF9E6},
    [I(232,75)] = {29,0x1FFFF566},
    [I(233,75)] = {29,0x1FFFF5E6},
    [I(234,75)] = {X32,0xFFFFF766},
    [I(235,75)] = {X32,0xFFFFF7E6},
    [I(236,75)] = {31,0x7FFFFA66},
    [I(237,75)] = {31,0x7FFFFAE6},
    [I(238,75)] = {64,0},
    [I(239,75)] = {30,0x3FFFFA66},
    [I(240,75)] = {64,0},
    [I(241,75)] = {64,0},
    [I(242,75)] = {64,0},
    [I(243,75)] = {64,0},
    [I(244,75)] = {64,0},
    [I(245,75)] = {64,0},
    [I(246,75)] = {64,0},
    [I(247,75)] = {64,0},
    [I(248,75)] = {64,0},
    [I(249,75)] = {64,0},
    [I(250,75)] = {64,0},
    [I(251,75)] = {64,0},
    [I(252,75)] = {64,0},
    [I(253,75)] = {64,0},
    [I(254,75)] = {64,0},
    [I(255,75)] = {64,0},
    [I(0,76)] = {20,0xFFC67},
    [I(1,76)] = {30,0x3FFFEC67},
    [I(2,76)] = {64,0},
    [I(3,76)] = {64,0},
    [I(4,76)] = {64,0},
    [I(5,76)] = {64,0},
    [I(6,76)] = {64,0},
    [I(7,76)] = {64,0},
    [I(8,76)] = {64,0},
    [I(9,76)] = {31,0x7FFFF567},
    [I(10,76)] = {64,0},
    [I(11,76)] = {64,0},
    [I(12,76)] = {64,0},
    [I(13,76)] = {64,0},
    [I(14,76)] = {64,0},
    [I(15,76)] = {64,0},
    [I(16,76)] = {64,0},
    [I(17,76)] = {64,0},
    [I(18,76)] = {64,0},
    [I(19,76)] = {64,0},
    [I(20,76)] = {64,0},
    [I(21,76)] = {64,0},
    [I(22,76)] = {64,0},
    [I(23,76)] = {64,0},
    [I(24,76)] = {64,0},
    [I(25,76)] = {64,0},
    [I(26,76)] = {64,0},
    [I(27,76)] = {64,0},
    [I(28,76)] = {64,0},
    [I(29,76)] = {64,0},
    [I(30,76)] = {64,0},
    [I(31,76)] = {64,0},
    [I(32,76)] = {13,0xA67},
    [I(33,76)] = {17,0x1FC67},
    [I(34,76)] = {17,0x1FCE7},
    [I(35,76)] = {19,0x7FD67},
    [I(36,76)] = {20,0xFFCE7},
    [I(37,76)] = {13,0xAE7},
    [I(38,76)] = {15,0x7C67},
    [I(39,76)] = {18,0x3FD67},
    [I(40,76)] = {17,0x1FD67},
    [I(41,76)] = {17,0x1FDE7},
    [I(42,76)] = {15,0x7CE7},
    [I(43,76)] = {18,0x3FDE7},
    [I(44,76)] = {15,0x7D67},
    [I(45,76)] = {13,0xB67},
    [I(46,76)] = {13,0xBE7},
    [I(47,76)] = {13,0xC67},
    [I(48,76)] = {12,0x67},
    [I(49,76)] = {12,0xE7},
    [I(50,76)] = {12,0x167},
    [I(51,76)] = {13,0xCE7},
    [I(52,76)] = {13,0xD67},
    [I(53,76)] = {13,0xDE7},
    [I(54,76)] = {13,0xE67},
    [I(55,76)] = {13,0xEE7},
    [I(56,76)] = {13,0xF67},
    [I(57,76)] = {13,0xFE7},
    [I(58,76)] = {14,0x2E67},
    [I(59,76)] = {15,0x7DE7},
    [I(60,76)] = {22,0x3FFE67},
    [I(61,76)] = {13,0x1067},
    [I(62,76)] = {19,0x7FDE7},
    [I(63,76)] = {17,0x1FE67},
    [I(64,76)] = {20,0xFFD67},
    [I(65,76)] = {13,0x10E7},
    [I(66,76)] = {14,0x2EE7},
    [I(67,76)] = {14,0x2F67},
    [I(68,76)] = {14,0x2FE7},
    [I(69,76)] = {14,0x3067},
    [I(70,76)] = {14,0x30E7},
    [I(71,76)] = {14,0x3167},
    [I(72,76)] = {14,0x31E7},
    [I(73,76)] = {14,0x3267},
    [I(74,76)] = {14,0x32E7},
    [I(75,76)] = {14,0x3367},
    [I(76,76)] = {14,0x33E7},
    [I(77,76)] = {14,0x3467},
    [I(78,76)] = {14,0x34E7},
    [I(79,76)] = {14,0x3567},
    [I(80,76)] = {14,0x35E7},
    [I(81,76)] = {14,0x3667},
    [I(82,76)] = {14,0x36E7},
    [I(83,76)] = {14,0x3767},
    [I(84,76)] = {14,0x37E7},
    [I(85,76)] = {14,0x3867},
    [I(86,76)] = {14,0x38E7},
    [I(87,76)] = {14,0x3967},
    [I(88,76)] = {15,0x7E67},
    [I(89,76)] = {14,0x39E7},
    [I(90,76)] = {15,0x7EE7},
    [I(91,76)] = {20,0xFFDE7},
    [I(92,76)] = {26,0x3FFF867},
    [I(93,76)] = {20,0xFFE67},
    [I(94,76)] = {21,0x1FFE67},
    [I(95,76)] = {13,0x1167},
    [I(96,76)] = {22,0x3FFEE7},
    [I(97,76)] = {12,0x1E7},
    [I(98,76)] = {13,0x11E7},
    [I(99,76)] = {12,0x267},
    [I(100,76)] = {13,0x1267},
    [I(101,76)] = {12,0x2E7},
    [I(102,76)] = {13,0x12E7},
    [I(103,76)] = {13,0x1367},
    [I(104,76)] = {13,0x13E7},
    [I(105,76)] = {12,0x367},
    [I(106,76)] = {14,0x3A67},
    [I(107,76)] = {14,0x3AE7},
    [I(108,76)] = {13,0x1467},
    [I(109,76)] = {13,0x14E7},
    [I(110,76)] = {13,0x1567},
    [I(111,76)] = {12,0x3E7},
    [I(112,76)] = {13,0x15E7},
    [I(113,76)] = {14,0x3B67},
    [I(114,76)] = {13,0x1667},
    [I(115,76)] = {12,0x467},
    [I(116,76)] = {12,0x4E7},
    [I(117,76)] = {13,0x16E7},
    [I(118,76)] = {14,0x3BE7},
    [I(119,76)] = {14,0x3C67},
    [I(120,76)] = {14,0x3CE7},
    [I(121,76)] = {14,0x3D67},
    [I(122,76)] = {14,0x3DE7},
    [I(123,76)] = {22,0x3FFF67},
    [I(124,76)] = {18,0x3FE67},
    [I(125,76)] = {21,0x1FFEE7},
    [I(126,76)] = {20,0xFFEE7},
    [I(127,76)] = {64,0},
    [I(128,76)] = {27,0x7FFF367},
    [I(129,76)] = {29,0x1FFFE967},
    [I(130,76)] = {27,0x7FFF3E7},
    [I(131,76)] = {27,0x7FFF467},
    [I(132,76)] = {29,0x1FFFE9E7},
    [I(133,76)] = {29,0x1FFFEA67},
    [I(134,76)] = {29,0x1FFFEAE7},
    [I(135,76)] = {30,0x3FFFECE7},
    [I(136,76)] = {29,0x1FFFEB67},
    [I(137,76)] = {30,0x3FFFED67},
    [I(138,76)] = {30,0x3FFFEDE7},
    [I(139,76)] = {30,0x3FFFEE67},
    [I(140,76)] = {30,0x3FFFEEE7},
    [I(141,76)] = {30,0x3FFFEF67},
    [I(142,76)] = {31,0x7FFFF5E7},
    [I(143,76)] = {30,0x3FFFEFE7},
    [I(144,76)] = {31,0x7FFFF667},
    [I(145,76)] = {31,0x7FFFF6E7},
    [I(146,76)] = {29,0x1FFFEBE7},
    [I(147,76)] = {30,0x3FFFF067},
    [I(148,76)] = {31,0x7FFFF767},
    [I(149,76)] = {30,0x3FFFF0E7},
    [I(150,76)] = {30,0x3FFFF167},
    [I(151,76)] = {30,0x3FFFF1E7},
    [I(152,76)] = {30,0x3FFFF267},
    [I(153,76)] = {28,0xFFFEE67},
    [I(154,76)] = {29,0x1FFFEC67},
    [I(155,76)] = {30,0x3FFFF2E7},
    [I(156,76)] = {29,0x1FFFECE7},
    [I(157,76)] = {30,0x3FFFF367},
    [I(158,76)] = {30,0x3FFFF3E7},
    [I(159,76)] = {31,0x7FFFF7E7},
    [I(160,76)] = {29,0x1FFFED67},
    [I(161,76)] = {28,0xFFFEEE7},
    [I(162,76)] = {27,0x7FFF4E7},
    [I(163,76)] = {29,0x1FFFEDE7},
    [I(164,76)] = {29,0x1FFFEE67},
    [I(165,76)] = {30,0x3FFFF467},
    [I(166,76)] = {30,0x3FFFF4E7},
    [I(167,76)] = {28,0xFFFEF67},
    [I(168,76)] = {30,0x3FFFF567},
    [I(169,76)] = {29,0x1FFFEEE7},
    [I(170,76)] = {29,0x1FFFEF67},
    [I(171,76)] = {31,0x7FFFF867},
    [I(172,76)] = {28,0xFFFEFE7},
    [I(173,76)] = {29,0x1FFFEFE7},
    [I(174,76)] = {30,0x3FFFF5E7},
    [I(175,76)] = {30,0x3FFFF667},
    [I(176,76)] = {28,0xFFFF067},
    [I(177,76)] = {28,0xFFFF0E7},
    [I(178,76)] = {29,0x1FFFF067},
    [I(179,76)] = {28,0xFFFF167},
    [I(180,76)] = {30,0x3FFFF6E7},
    [I(181,76)] = {29,0x1FFFF0E7},
    [I(182,76)] = {30,0x3FFFF767},
    [I(183,76)] = {30,0x3FFFF7E7},
    [I(184,76)] = {27,0x7FFF567},
    [I(185,76)] = {29,0x1FFFF167},
    [I(186,76)] = {29,0x1FFFF1E7},
    [I(187,76)] = {29,0x1FFFF267},
    [I(188,76)] = {30,0x3FFFF867},
    [I(189,76)] = {29,0x1FFFF2E7},
    [I(190,76)] = {29,0x1FFFF367},
    [I(191,76)] = {30,0x3FFFF8E7},
    [I(192,76)] = {64,0},
    [I(193,76)] = {64,0},
    [I(194,76)] = {27,0x7FFF5E7},
    [I(195,76)] = {26,0x3FFF8E7},
    [I(196,76)] = {29,0x1FFFF3E7},
    [I(197,76)] = {30,0x3FFFF967},
    [I(198,76)] = {29,0x1FFFF467},
    [I(199,76)] = {X32,0xFFFFF667},
    [I(200,76)] = {64,0},
    [I(201,76)] = {64,0},
    [I(202,76)] = {64,0},
    [I(203,76)] = {64,0},
    [I(204,76)] = {64,0},
    [I(205,76)] = {64,0},
    [I(206,76)] = {31,0x7FFFF8E7},
    [I(207,76)] = {X32,0xFFFFF6E7},
    [I(208,76)] = {26,0x3FFF967},
    [I(209,76)] = {28,0xFFFF1E7},
    [I(210,76)] = {64,0},
    [I(211,76)] = {64,0},
    [I(212,76)] = {64,0},
    [I(213,76)] = {64,0},
    [I(214,76)] = {64,0},
    [I(215,76)] = {31,0x7FFFF967},
    [I(216,76)] = {28,0xFFFF267},
    [I(217,76)] = {28,0xFFFF2E7},
    [I(218,76)] = {64,0},
    [I(219,76)] = {64,0},
    [I(220,76)] = {64,0},
    [I(221,76)] = {64,0},
    [I(222,76)] = {64,0},
    [I(223,76)] = {64,0},
    [I(224,76)] = {27,0x7FFF667},
    [I(225,76)] = {31,0x7FFFF9E7},
    [I(226,76)] = {27,0x7FFF6E7},
    [I(227,76)] = {28,0xFFFF367},
    [I(228,76)] = {29,0x1FFFF4E7},
    [I(229,76)] = {28,0xFFFF3E7},
    [I(230,76)] = {28,0xFFFF467},
    [I(231,76)] = {30,0x3FFFF9E7},
    [I(232,76)] = {29,0x1FFFF567},
    [I(233,76)] = {29,0x1FFFF5E7},
    [I(234,76)] = {X32,0xFFFFF767},
    [I(235,76)] = {X32,0xFFFFF7E7},
    [I(236,76)] = {31,0x7FFFFA67},
    [I(237,76)] = {31,0x7FFFFAE7},
    [I(238,76)] = {64,0},
    [I(239,76)] = {30,0x3FFFFA67},
    [I(240,76)] = {64,0},
    [I(241,76)] = {64,0},
    [I(242,76)] = {64,0},
    [I(243,76)] = {64,0},
    [I(244,76)] = {64,0},
    [I(245,76)] = {64,0},
    [I(246,76)] = {64,0},
    [I(247,76)] = {64,0},
    [I(248,76)] = {64,0},
    [I(249,76)] = {64,0},
    [I(250,76)] = {64,0},
    [I(251,76)] = {64,0},
    [I(252,76)] = {64,0},
    [I(253,76)] = {64,0},
    [I(254,76)] = {64,0},
    [I(255,76)] = {64,0},
    [I(0,77)] = {20,0xFFC68},
    [I(1,77)] = {30,0x3FFFEC68},
    [I(2,77)] = {64,0},
    [I(3,77)] = {64,0},
    [I(4,77)] = {64,0},
    [I(5,77)] = {64,0},
    [I(6,77)] = {64,0},
    [I(7,77)] = {64,0},
    [I(8,77)] = {64,0},
    [I(9,77)] = {31,0x7FFFF568},
    [I(10,77)] = {64,0},
    [I(11,77)] = {64,0},
    [I(12,77)] = {64,0},
    [I(13,77)] = {64,0},
    [I(14,77)] = {64,0},
    [I(15,77)] = {64,0},
    [I(16,77)] = {64,0},
    [I(17,77)] = {64,0},
    [I(18,77)] = {64,0},
    [I(19,77)] = {64,0},
    [I(20,77)] = {64,0},
    [I(21,77)] = {64,0},
    [I(22,77)] = {64,0},
    [I(23,77)] = {64,0},
    [I(24,77)] = {64,0},
    [I(25,77)] = {64,0},
    [I(26,77)] = {64,0},
    [I(27,77)] = {64,0},
    [I(28,77)] = {64,0},
    [I(29,77)] = {64,0},
    [I(30,77)] = {64,0},
    [I(31,77)] = {64,0},
    [I(32,77)] = {13,0xA68},
    [I(33,77)] = {17,0x1FC68},
    [I(34,77)] = {17,0x1FCE8},
    [I(35,77)] = {19,0x7FD68},
    [I(36,77)] = {20,0xFFCE8},
    [I(37,77)] = {13,0xAE8},
    [I(38,77)] = {15,0x7C68},
    [I(39,77)] = {18,0x3FD68},
    [I(40,77)] = {17,0x1FD68},
    [I(41,77)] = {17,0x1FDE8},
    [I(42,77)] = {15,0x7CE8},
    [I(43,77)] = {18,0x3FDE8},
    [I(44,77)] = {15,0x7D68},
    [I(45,77)] = {13,0xB68},
    [I(46,77)] = {13,0xBE8},
    [I(47,77)] = {13,0xC68},
    [I(48,77)] = {12,0x68},
    [I(49,77)] = {12,0xE8},
    [I(50,77)] = {12,0x168},
    [I(51,77)] = {13,0xCE8},
    [I(52,77)] = {13,0xD68},
    [I(53,77)] = {13,0xDE8},
    [I(54,77)] = {13,0xE68},
    [I(55,77)] = {13,0xEE8},
    [I(56,77)] = {13,0xF68},
    [I(57,77)] = {13,0xFE8},
    [I(58,77)] = {14,0x2E68},
    [I(59,77)] = {15,0x7DE8},
    [I(60,77)] = {22,0x3FFE68},
    [I(61,77)] = {13,0x1068},
    [I(62,77)] = {19,0x7FDE8},
    [I(63,77)] = {17,0x1FE68},
    [I(64,77)] = {20,0xFFD68},
    [I(65,77)] = {13,0x10E8},
    [I(66,77)] = {14,0x2EE8},
    [I(67,77)] = {14,0x2F68},
    [I(68,77)] = {14,0x2FE8},
    [I(69,77)] = {14,0x3068},
    [I(70,77)] = {14,0x30E8},
    [I(71,77)] = {14,0x3168},
    [I(72,77)] = {14,0x31E8},
    [I(73,77)] = {14,0x3268},
    [I(74,77)] = {14,0x32E8},
    [I(75,77)] = {14,0x3368},
    [I(76,77)] = {14,0x33E8},
    [I(77,77)] = {14,0x3468},
    [I(78,77)] = {14,0x34E8},
    [I(79,77)] = {14,0x3568},
    [I(80,77)] = {14,0x35E8},
    [I(81,77)] = {14,0x3668},
    [I(82,77)] = {14,0x36E8},
    [I(83,77)] = {14,0x3768},
    [I(84,77)] = {14,0x37E8},
    [I(85,77)] = {14,0x3868},
    [I(86,77)] = {14,0x38E8},
    [I(87,77)] = {14,0x3968},
    [I(88,77)] = {15,0x7E68},
    [I(89,77)] = {14,0x39E8},
    [I(90,77)] = {15,0x7EE8},
    [I(91,77)] = {20,0xFFDE8},
    [I(92,77)] = {26,0x3FFF868},
    [I(93,77)] = {20,0xFFE68},
    [I(94,77)] = {21,0x1FFE68},
    [I(95,77)] = {13,0x1168},
    [I(96,77)] = {22,0x3FFEE8},
    [I(97,77)] = {12,0x1E8},
    [I(98,77)] = {13,0x11E8},
    [I(99,77)] = {12,0x268},
    [I(100,77)] = {13,0x1268},
    [I(101,77)] = {12,0x2E8},
    [I(102,77)] = {13,0x12E8},
    [I(103,77)] = {13,0x1368},
    [I(104,77)] = {13,0x13E8},
    [I(105,77)] = {12,0x368},
    [I(106,77)] = {14,0x3A68},
    [I(107,77)] = {14,0x3AE8},
    [I(108,77)] = {13,0x1468},
    [I(109,77)] = {13,0x14E8},
    [I(110,77)] = {13,0x1568},
    [I(111,77)] = {12,0x3E8},
    [I(112,77)] = {13,0x15E8},
    [I(113,77)] = {14,0x3B68},
    [I(114,77)] = {13,0x1668},
    [I(115,77)] = {12,0x468},
    [I(116,77)] = {12,0x4E8},
    [I(117,77)] = {13,0x16E8},
    [I(118,77)] = {14,0x3BE8},
    [I(119,77)] = {14,0x3C68},
    [I(120,77)] = {14,0x3CE8},
    [I(121,77)] = {14,0x3D68},
    [I(122,77)] = {14,0x3DE8},
    [I(123,77)] = {22,0x3FFF68},
    [I(124,77)] = {18,0x3FE68},
    [I(125,77)] = {21,0x1FFEE8},
    [I(126,77)] = {20,0xFFEE8},
    [I(127,77)] = {64,0},
    [I(128,77)] = {27,0x7FFF368},
    [I(129,77)] = {29,0x1FFFE968},
    [I(130,77)] = {27,0x7FFF3E8},
    [I(131,77)] = {27,0x7FFF468},
    [I(132,77)] = {29,0x1FFFE9E8},
    [I(133,77)] = {29,0x1FFFEA68},
    [I(134,77)] = {29,0x1FFFEAE8},
    [I(135,77)] = {30,0x3FFFECE8},
    [I(136,77)] = {29,0x1FFFEB68},
    [I(137,77)] = {30,0x3FFFED68},
    [I(138,77)] = {30,0x3FFFEDE8},
    [I(139,77)] = {30,0x3FFFEE68},
    [I(140,77)] = {30,0x3FFFEEE8},
    [I(141,77)] = {30,0x3FFFEF68},
    [I(142,77)] = {31,0x7FFFF5E8},
    [I(143,77)] = {30,0x3FFFEFE8},
    [I(144,77)] = {31,0x7FFFF668},
    [I(145,77)] = {31,0x7FFFF6E8},
    [I(146,77)] = {29,0x1FFFEBE8},
    [I(147,77)] = {30,0x3FFFF068},
    [I(148,77)] = {31,0x7FFFF768},
    [I(149,77)] = {30,0x3FFFF0E8},
    [I(150,77)] = {30,0x3FFFF168},
    [I(151,77)] = {30,0x3FFFF1E8},
    [I(152,77)] = {30,0x3FFFF268},
    [I(153,77)] = {28,0xFFFEE68},
    [I(154,77)] = {29,0x1FFFEC68},
    [I(155,77)] = {30,0x3FFFF2E8},
    [I(156,77)] = {29,0x1FFFECE8},
    [I(157,77)] = {30,0x3FFFF368},
    [I(158,77)] = {30,0x3FFFF3E8},
    [I(159,77)] = {31,0x7FFFF7E8},
    [I(160,77)] = {29,0x1FFFED68},
    [I(161,77)] = {28,0xFFFEEE8},
    [I(162,77)] = {27,0x7FFF4E8},
    [I(163,77)] = {29,0x1FFFEDE8},
    [I(164,77)] = {29,0x1FFFEE68},
    [I(165,77)] = {30,0x3FFFF468},
    [I(166,77)] = {30,0x3FFFF4E8},
    [I(167,77)] = {28,0xFFFEF68},
    [I(168,77)] = {30,0x3FFFF568},
    [I(169,77)] = {29,0x1FFFEEE8},
    [I(170,77)] = {29,0x1FFFEF68},
    [I(171,77)] = {31,0x7FFFF868},
    [I(172,77)] = {28,0xFFFEFE8},
    [I(173,77)] = {29,0x1FFFEFE8},
    [I(174,77)] = {30,0x3FFFF5E8},
    [I(175,77)] = {30,0x3FFFF668},
    [I(176,77)] = {28,0xFFFF068},
    [I(177,77)] = {28,0xFFFF0E8},
    [I(178,77)] = {29,0x1FFFF068},
    [I(179,77)] = {28,0xFFFF168},
    [I(180,77)] = {30,0x3FFFF6E8},
    [I(181,77)] = {29,0x1FFFF0E8},
    [I(182,77)] = {30,0x3FFFF768},
    [I(183,77)] = {30,0x3FFFF7E8},
    [I(184,77)] = {27,0x7FFF568},
    [I(185,77)] = {29,0x1FFFF168},
    [I(186,77)] = {29,0x1FFFF1E8},
    [I(187,77)] = {29,0x1FFFF268},
    [I(188,77)] = {30,0x3FFFF868},
    [I(189,77)] = {29,0x1FFFF2E8},
    [I(190,77)] = {29,0x1FFFF368},
    [I(191,77)] = {30,0x3FFFF8E8},
    [I(192,77)] = {64,0},
    [I(193,77)] = {64,0},
    [I(194,77)] = {27,0x7FFF5E8},
    [I(195,77)] = {26,0x3FFF8E8},
    [I(196,77)] = {29,0x1FFFF3E8},
    [I(197,77)] = {30,0x3FFFF968},
    [I(198,77)] = {29,0x1FFFF468},
    [I(199,77)] = {X32,0xFFFFF668},
    [I(200,77)] = {64,0},
    [I(201,77)] = {64,0},
    [I(202,77)] = {64,0},
    [I(203,77)] = {64,0},
    [I(204,77)] = {64,0},
    [I(205,77)] = {64,0},
    [I(206,77)] = {31,0x7FFFF8E8},
    [I(207,77)] = {X32,0xFFFFF6E8},
    [I(208,77)] = {26,0x3FFF968},
    [I(209,77)] = {28,0xFFFF1E8},
    [I(210,77)] = {64,0},
    [I(211,77)] = {64,0},
    [I(212,77)] = {64,0},
    [I(213,77)] = {64,0},
    [I(214,77)] = {64,0},
    [I(215,77)] = {31,0x7FFFF968},
    [I(216,77)] = {28,0xFFFF268},
    [I(217,77)] = {28,0xFFFF2E8},
    [I(218,77)] = {64,0},
    [I(219,77)] = {64,0},
    [I(220,77)] = {64,0},
    [I(221,77)] = {64,0},
    [I(222,77)] = {64,0},
    [I(223,77)] = {64,0},
    [I(224,77)] = {27,0x7FFF668},
    [I(225,77)] = {31,0x7FFFF9E8},
    [I(226,77)] = {27,0x7FFF6E8},
    [I(227,77)] = {28,0xFFFF368},
    [I(228,77)] = {29,0x1FFFF4E8},
    [I(229,77)] = {28,0xFFFF3E8},
    [I(230,77)] = {28,0xFFFF468},
    [I(231,77)] = {30,0x3FFFF9E8},
    [I(232,77)] = {29,0x1FFFF568},
    [I(233,77)] = {29,0x1FFFF5E8},
    [I(234,77)] = {X32,0xFFFFF768},
    [I(235,77)] = {X32,0xFFFFF7E8},
    [I(236,77)] = {31,0x7FFFFA68},
    [I(237,77)] = {31,0x7FFFFAE8},
    [I(238,77)] = {64,0},
    [I(239,77)] = {30,0x3FFFFA68},
    [I(240,77)] = {64,0},
    [I(241,77)] = {64,0},
    [I(242,77)] = {64,0},
    [I(243,77)] = {64,0},
    [I(244,77)] = {64,0},
    [I(245,77)] = {64,0},
    [I(246,77)] = {64,0},
    [I(247,77)] = {64,0},
    [I(248,77)] = {64,0},
    [I(249,77)] = {64,0},
    [I(250,77)] = {64,0},
    [I(251,77)] = {64,0},
    [I(252,77)] = {64,0},
    [I(253,77)] = {64,0},
    [I(254,77)] = {64,0},
    [I(255,77)] = {64,0},
    [I(0,78)] = {20,0xFFC69},
    [I(1,78)] = {30,0x3FFFEC69},
    [I(2,78)] = {64,0},
    [I(3,78)] = {64,0},
    [I(4,78)] = {64,0},
    [I(5,78)] = {64,0},
    [I(6,78)] = {64,0},
    [I(7,78)] = {64,0},
    [I(8,78)] = {64,0},
    [I(9,78)] = {31,0x7FFFF569},
    [I(10,78)] = {64,0},
    [I(11,78)] = {64,0},
    [I(12,78)] = {64,0},
    [I(13,78)] = {64,0},
    [I(14,78)] = {64,0},
    [I(15,78)] = {64,0},
    [I(16,78)] = {64,0},
    [I(17,78)] = {64,0},
    [I(18,78)] = {64,0},
    [I(19,78)] = {64,0},
    [I(20,78)] = {64,0},
    [I(21,78)] = {64,0},
    [I(22,78)] = {64,0},
    [I(23,78)] = {64,0},
    [I(24,78)] = {64,0},
    [I(25,78)] = {64,0},
    [I(26,78)] = {64,0},
    [I(27,78)] = {64,0},
    [I(28,78)] = {64,0},
    [I(29,78)] = {64,0},
    [I(30,78)] = {64,0},
    [I(31,78)] = {64,0},
    [I(32,78)] = {13,0xA69},
    [I(33,78)] = {17,0x1FC69},
    [I(34,78)] = {17,0x1FCE9},
    [I(35,78)] = {19,0x7FD69},
    [I(36,78)] = {20,0xFFCE9},
    [I(37,78)] = {13,0xAE9},
    [I(38,78)] = {15,0x7C69},
    [I(39,78)] = {18,0x3FD69},
    [I(40,78)] = {17,0x1FD69},
    [I(41,78)] = {17,0x1FDE9},
    [I(42,78)] = {15,0x7CE9},
    [I(43,78)] = {18,0x3FDE9},
    [I(44,78)] = {15,0x7D69},
    [I(45,78)] = {13,0xB69},
    [I(46,78)] = {13,0xBE9},
    [I(47,78)] = {13,0xC69},
    [I(48,78)] = {12,0x69},
    [I(49,78)] = {12,0xE9},
    [I(50,78)] = {12,0x169},
    [I(51,78)] = {13,0xCE9},
    [I(52,78)] = {13,0xD69},
    [I(53,78)] = {13,0xDE9},
    [I(54,78)] = {13,0xE69},
    [I(55,78)] = {13,0xEE9},
    [I(56,78)] = {13,0xF69},
    [I(57,78)] = {13,0xFE9},
    [I(58,78)] = {14,0x2E69},
    [I(59,78)] = {15,0x7DE9},
    [I(60,78)] = {22,0x3FFE69},
    [I(61,78)] = {13,0x1069},
    [I(62,78)] = {19,0x7FDE9},
    [I(63,78)] = {17,0x1FE69},
    [I(64,78)] = {20,0xFFD69},
    [I(65,78)] = {13,0x10E9},
    [I(66,78)] = {14,0x2EE9},
    [I(67,78)] = {14,0x2F69},
    [I(68,78)] = {14,0x2FE9},
    [I(69,78)] = {14,0x3069},
    [I(70,78)] = {14,0x30E9},
    [I(71,78)] = {14,0x3169},
    [I(72,78)] = {14,0x31E9},
    [I(73,78)] = {14,0x3269},
    [I(74,78)] = {14,0x32E9},
    [I(75,78)] = {14,0x3369},
    [I(76,78)] = {14,0x33E9},
    [I(77,78)] = {14,0x3469},
    [I(78,78)] = {14,0x34E9},
    [I(79,78)] = {14,0x3569},
    [I(80,78)] = {14,0x35E9},
    [I(81,78)] = {14,0x3669},
    [I(82,78)] = {14,0x36E9},
    [I(83,78)] = {14,0x3769},
    [I(84,78)] = {14,0x37E9},
    [I(85,78)] = {14,0x3869},
    [I(86,78)] = {14,0x38E9},
    [I(87,78)] = {14,0x3969},
    [I(88,78)] = {15,0x7E69},
    [I(89,78)] = {14,0x39E9},
    [I(90,78)] = {15,0x7EE9},
    [I(91,78)] = {20,0xFFDE9},
    [I(92,78)] = {26,0x3FFF869},
    [I(93,78)] = {20,0xFFE69},
    [I(94,78)] = {21,0x1FFE69},
    [I(95,78)] = {13,0x1169},
    [I(96,78)] = {22,0x3FFEE9},
    [I(97,78)] = {12,0x1E9},
    [I(98,78)] = {13,0x11E9},
    [I(99,78)] = {12,0x269},
    [I(100,78)] = {13,0x1269},
    [I(101,78)] = {12,0x2E9},
    [I(102,78)] = {13,0x12E9},
    [I(103,78)] = {13,0x1369},
    [I(104,78)] = {13,0x13E9},
    [I(105,78)] = {12,0x369},
    [I(106,78)] = {14,0x3A69},
    [I(107,78)] = {14,0x3AE9},
    [I(108,78)] = {13,0x1469},
    [I(109,78)] = {13,0x14E9},
    [I(110,78)] = {13,0x1569},
    [I(111,78)] = {12,0x3E9},
    [I(112,78)] = {13,0x15E9},
    [I(113,78)] = {14,0x3B69},
    [I(114,78)] = {13,0x1669},
    [I(115,78)] = {12,0x469},
    [I(116,78)] = {12,0x4E9},
    [I(117,78)] = {13,0x16E9},
    [I(118,78)] = {14,0x3BE9},
    [I(119,78)] = {14,0x3C69},
    [I(120,78)] = {14,0x3CE9},
    [I(121,78)] = {14,0x3D69},
    [I(122,78)] = {14,0x3DE9},
    [I(123,78)] = {22,0x3FFF69},
    [I(124,78)] = {18,0x3FE69},
    [I(125,78)] = {21,0x1FFEE9},
    [I(126,78)] = {20,0xFFEE9},
    [I(127,78)] = {64,0},
    [I(128,78)] = {27,0x7FFF369},
    [I(129,78)] = {29,0x1FFFE969},
    [I(130,78)] = {27,0x7FFF3E9},
    [I(131,78)] = {27,0x7FFF469},
    [I(132,78)] = {29,0x1FFFE9E9},
    [I(133,78)] = {29,0x1FFFEA69},
    [I(134,78)] = {29,0x1FFFEAE9},
    [I(135,78)] = {30,0x3FFFECE9},
    [I(136,78)] = {29,0x1FFFEB69},
    [I(137,78)] = {30,0x3FFFED69},
    [I(138,78)] = {30,0x3FFFEDE9},
    [I(139,78)] = {30,0x3FFFEE69},
    [I(140,78)] = {30,0x3FFFEEE9},
    [I(141,78)] = {30,0x3FFFEF69},
    [I(142,78)] = {31,0x7FFFF5E9},
    [I(143,78)] = {30,0x3FFFEFE9},
    [I(144,78)] = {31,0x7FFFF669},
    [I(145,78)] = {31,0x7FFFF6E9},
    [I(146,78)] = {29,0x1FFFEBE9},
    [I(147,78)] = {30,0x3FFFF069},
    [I(148,78)] = {31,0x7FFFF769},
    [I(149,78)] = {30,0x3FFFF0E9},
    [I(150,78)] = {30,0x3FFFF169},
    [I(151,78)] = {30,0x3FFFF1E9},
    [I(152,78)] = {30,0x3FFFF269},
    [I(153,78)] = {28,0xFFFEE69},
    [I(154,78)] = {29,0x1FFFEC69},
    [I(155,78)] = {30,0x3FFFF2E9},
    [I(156,78)] = {29,0x1FFFECE9},
    [I(157,78)] = {30,0x3FFFF369},
    [I(158,78)] = {30,0x3FFFF3E9},
    [I(159,78)] = {31,0x7FFFF7E9},
    [I(160,78)] = {29,0x1FFFED69},
    [I(161,78)] = {28,0xFFFEEE9},
    [I(162,78)] = {27,0x7FFF4E9},
    [I(163,78)] = {29,0x1FFFEDE9},
    [I(164,78)] = {29,0x1FFFEE69},
    [I(165,78)] = {30,0x3FFFF469},
    [I(166,78)] = {30,0x3FFFF4E9},
    [I(167,78)] = {28,0xFFFEF69},
    [I(168,78)] = {30,0x3FFFF569},
    [I(169,78)] = {29,0x1FFFEEE9},
    [I(170,78)] = {29,0x1FFFEF69},
    [I(171,78)] = {31,0x7FFFF869},
    [I(172,78)] = {28,0xFFFEFE9},
    [I(173,78)] = {29,0x1FFFEFE9},
    [I(174,78)] = {30,0x3FFFF5E9},
    [I(175,78)] = {30,0x3FFFF669},
    [I(176,78)] = {28,0xFFFF069},
    [I(177,78)] = {28,0xFFFF0E9},
    [I(178,78)] = {29,0x1FFFF069},
    [I(179,78)] = {28,0xFFFF169},
    [I(180,78)] = {30,0x3FFFF6E9},
    [I(181,78)] = {29,0x1FFFF0E9},
    [I(182,78)] = {30,0x3FFFF769},
    [I(183,78)] = {30,0x3FFFF7E9},
    [I(184,78)] = {27,0x7FFF569},
    [I(185,78)] = {29,0x1FFFF169},
    [I(186,78)] = {29,0x1FFFF1E9},
    [I(187,78)] = {29,0x1FFFF269},
    [I(188,78)] = {30,0x3FFFF869},
    [I(189,78)] = {29,0x1FFFF2E9},
    [I(190,78)] = {29,0x1FFFF369},
    [I(191,78)] = {30,0x3FFFF8E9},
    [I(192,78)] = {64,0},
    [I(193,78)] = {64,0},
    [I(194,78)] = {27,0x7FFF5E9},
    [I(195,78)] = {26,0x3FFF8E9},
    [I(196,78)] = {29,0x1FFFF3E9},
    [I(197,78)] = {30,0x3FFFF969},
    [I(198,78)] = {29,0x1FFFF469},
    [I(199,78)] = {X32,0xFFFFF669},
    [I(200,78)] = {64,0},
    [I(201,78)] = {64,0},
    [I(202,78)] = {64,0},
    [I(203,78)] = {64,0},
    [I(204,78)] = {64,0},
    [I(205,78)] = {64,0},
    [I(206,78)] = {31,0x7FFFF8E9},
    [I(207,78)] = {X32,0xFFFFF6E9},
    [I(208,78)] = {26,0x3FFF969},
    [I(209,78)] = {28,0xFFFF1E9},
    [I(210,78)] = {64,0},
    [I(211,78)] = {64,0},
    [I(212,78)] = {64,0},
    [I(213,78)] = {64,0},
    [I(214,78)] = {64,0},
    [I(215,78)] = {31,0x7FFFF969},
    [I(216,78)] = {28,0xFFFF269},
    [I(217,78)] = {28,0xFFFF2E9},
    [I(218,78)] = {64,0},
    [I(219,78)] = {64,0},
    [I(220,78)] = {64,0},
    [I(221,78)] = {64,0},
    [I(222,78)] = {64,0},
    [I(223,78)] = {64,0},
    [I(224,78)] = {27,0x7FFF669},
    [I(225,78)] = {31,0x7FFFF9E9},
    [I(226,78)] = {27,0x7FFF6E9},
    [I(227,78)] = {28,0xFFFF369},
    [I(228,78)] = {29,0x1FFFF4E9},
    [I(229,78)] = {28,0xFFFF3E9},
    [I(230,78)] = {28,0xFFFF469},
    [I(231,78)] = {30,0x3FFFF9E9},
    [I(232,78)] = {29,0x1FFFF569},
    [I(233,78)] = {29,0x1FFFF5E9},
    [I(234,78)] = {X32,0xFFFFF769},
    [I(235,78)] = {X32,0xFFFFF7E9},
    [I(236,78)] = {31,0x7FFFFA69},
    [I(237,78)] = {31,0x7FFFFAE9},
    [I(238,78)] = {64,0},
    [I(239,78)] = {30,0x3FFFFA69},
    [I(240,78)] = {64,0},
    [I(241,78)] = {64,0},
    [I(242,78)] = {64,0},
    [I(243,78)] = {64,0},
    [I(244,78)] = {64,0},
    [I(245,78)] = {64,0},
    [I(246,78)] = {64,0},
    [I(247,78)] = {64,0},
    [I(248,78)] = {64,0},
    [I(249,78)] = {64,0},
    [I(250,78)] = {64,0},
    [I(251,78)] = {64,0},
    [I(252,78)] = {64,0},
    [I(253,78)] = {64,0},
    [I(254,78)] = {64,0},
    [I(255,78)] = {64,0},
    [I(0,79)] = {20,0xFFC6A},
    [I(1,79)] = {30,0x3FFFEC6A},
    [I(2,79)] = {64,0},
    [I(3,79)] = {64,0},
    [I(4,79)] = {64,0},
    [I(5,79)] = {64,0},
    [I(6,79)] = {64,0},
    [I(7,79)] = {64,0},
    [I(8,79)] = {64,0},
    [I(9,79)] = {31,0x7FFFF56A},
    [I(10,79)] = {64,0},
    [I(11,79)] = {64,0},
    [I(12,79)] = {64,0},
    [I(13,79)] = {64,0},
    [I(14,79)] = {64,0},
    [I(15,79)] = {64,0},
    [I(16,79)] = {64,0},
    [I(17,79)] = {64,0},
    [I(18,79)] = {64,0},
    [I(19,79)] = {64,0},
    [I(20,79)] = {64,0},
    [I(21,79)] = {64,0},
    [I(22,79)] = {64,0},
    [I(23,79)] = {64,0},
    [I(24,79)] = {64,0},
    [I(25,79)] = {64,0},
    [I(26,79)] = {64,0},
    [I(27,79)] = {64,0},
    [I(28,79)] = {64,0},
    [I(29,79)] = {64,0},
    [I(30,79)] = {64,0},
    [I(31,79)] = {64,0},
    [I(32,79)] = {13,0xA6A},
    [I(33,79)] = {17,0x1FC6A},
    [I(34,79)] = {17,0x1FCEA},
    [I(35,79)] = {19,0x7FD6A},
    [I(36,79)] = {20,0xFFCEA},
    [I(37,79)] = {13,0xAEA},
    [I(38,79)] = {15,0x7C6A},
    [I(39,79)] = {18,0x3FD6A},
    [I(40,79)] = {17,0x1FD6A},
    [I(41,79)] = {17,0x1FDEA},
    [I(42,79)] = {15,0x7CEA},
    [I(43,79)] = {18,0x3FDEA},
    [I(44,79)] = {15,0x7D6A},
    [I(45,79)] = {13,0xB6A},
    [I(46,79)] = {13,0xBEA},
    [I(47,79)] = {13,0xC6A},
    [I(48,79)] = {12,0x6A},
    [I(49,79)] = {12,0xEA},
    [I(50,79)] = {12,0x16A},
    [I(51,79)] = {13,0xCEA},
    [I(52,79)] = {13,0xD6A},
    [I(53,79)] = {13,0xDEA},
    [I(54,79)] = {13,0xE6A},
    [I(55,79)] = {13,0xEEA},
    [I(56,79)] = {13,0xF6A},
    [I(57,79)] = {13,0xFEA},
    [I(58,79)] = {14,0x2E6A},
    [I(59,79)] = {15,0x7DEA},
    [I(60,79)] = {22,0x3FFE6A},
    [I(61,79)] = {13,0x106A},
    [I(62,79)] = {19,0x7FDEA},
    [I(63,79)] = {17,0x1FE6A},
    [I(64,79)] = {20,0xFFD6A},
    [I(65,79)] = {13,0x10EA},
    [I(66,79)] = {14,0x2EEA},
    [I(67,79)] = {14,0x2F6A},
    [I(68,79)] = {14,0x2FEA},
    [I(69,79)] = {14,0x306A},
    [I(70,79)] = {14,0x30EA},
    [I(71,79)] = {14,0x316A},
    [I(72,79)] = {14,0x31EA},
    [I(73,79)] = {14,0x326A},
    [I(74,79)] = {14,0x32EA},
    [I(75,79)] = {14,0x336A},
    [I(76,79)] = {14,0x33EA},
    [I(77,79)] = {14,0x346A},
    [I(78,79)] = {14,0x34EA},
    [I(79,79)] = {14,0x356A},
    [I(80,79)] = {14,0x35EA},
    [I(81,79)] = {14,0x366A},
    [I(82,79)] = {14,0x36EA},
    [I(83,79)] = {14,0x376A},
    [I(84,79)] = {14,0x37EA},
    [I(85,79)] = {14,0x386A},
    [I(86,79)] = {14,0x38EA},
    [I(87,79)] = {14,0x396A},
    [I(88,79)] = {15,0x7E6A},
    [I(89,79)] = {14,0x39EA},
    [I(90,79)] = {15,0x7EEA},
    [I(91,79)] = {20,0xFFDEA},
    [I(92,79)] = {26,0x3FFF86A},
    [I(93,79)] = {20,0xFFE6A},
    [I(94,79)] = {21,0x1FFE6A},
    [I(95,79)] = {13,0x116A},
    [I(96,79)] = {22,0x3FFEEA},
    [I(97,79)] = {12,0x1EA},
    [I(98,79)] = {13,0x11EA},
    [I(99,79)] = {12,0x26A},
    [I(100,79)] = {13,0x126A},
    [I(101,79)] = {12,0x2EA},
    [I(102,79)] = {13,0x12EA},
    [I(103,79)] = {13,0x136A},
    [I(104,79)] = {13,0x13EA},
    [I(105,79)] = {12,0x36A},
    [I(106,79)] = {14,0x3A6A},
    [I(107,79)] = {14,0x3AEA},
    [I(108,79)] = {13,0x146A},
    [I(109,79)] = {13,0x14EA},
    [I(110,79)] = {13,0x156A},
    [I(111,79)] = {12,0x3EA},
    [I(112,79)] = {13,0x15EA},
    [I(113,79)] = {14,0x3B6A},
    [I(114,79)] = {13,0x166A},
    [I(115,79)] = {12,0x46A},
    [I(116,79)] = {12,0x4EA},
    [I(117,79)] = {13,0x16EA},
    [I(118,79)] = {14,0x3BEA},
    [I(119,79)] = {14,0x3C6A},
    [I(120,79)] = {14,0x3CEA},
    [I(121,79)] = {14,0x3D6A},
    [I(122,79)] = {14,0x3DEA},
    [I(123,79)] = {22,0x3FFF6A},
    [I(124,79)] = {18,0x3FE6A},
    [I(125,79)] = {21,0x1FFEEA},
    [I(126,79)] = {20,0xFFEEA},
    [I(127,79)] = {64,0},
    [I(128,79)] = {27,0x7FFF36A},
    [I(129,79)] = {29,0x1FFFE96A},
    [I(130,79)] = {27,0x7FFF3EA},
    [I(131,79)] = {27,0x7FFF46A},
    [I(132,79)] = {29,0x1FFFE9EA},
    [I(133,79)] = {29,0x1FFFEA6A},
    [I(134,79)] = {29,0x1FFFEAEA},
    [I(135,79)] = {30,0x3FFFECEA},
    [I(136,79)] = {29,0x1FFFEB6A},
    [I(137,79)] = {30,0x3FFFED6A},
    [I(138,79)] = {30,0x3FFFEDEA},
    [I(139,79)] = {30,0x3FFFEE6A},
    [I(140,79)] = {30,0x3FFFEEEA},
    [I(141,79)] = {30,0x3FFFEF6A},
    [I(142,79)] = {31,0x7FFFF5EA},
    [I(143,79)] = {30,0x3FFFEFEA},
    [I(144,79)] = {31,0x7FFFF66A},
    [I(145,79)] = {31,0x7FFFF6EA},
    [I(146,79)] = {29,0x1FFFEBEA},
    [I(147,79)] = {30,0x3FFFF06A},
    [I(148,79)] = {31,0x7FFFF76A},
    [I(149,79)] = {30,0x3FFFF0EA},
    [I(150,79)] = {30,0x3FFFF16A},
    [I(151,79)] = {30,0x3FFFF1EA},
    [I(152,79)] = {30,0x3FFFF26A},
    [I(153,79)] = {28,0xFFFEE6A},
    [I(154,79)] = {29,0x1FFFEC6A},
    [I(155,79)] = {30,0x3FFFF2EA},
    [I(156,79)] = {29,0x1FFFECEA},
    [I(157,79)] = {30,0x3FFFF36A},
    [I(158,79)] = {30,0x3FFFF3EA},
    [I(159,79)] = {31,0x7FFFF7EA},
    [I(160,79)] = {29,0x1FFFED6A},
    [I(161,79)] = {28,0xFFFEEEA},
    [I(162,79)] = {27,0x7FFF4EA},
    [I(163,79)] = {29,0x1FFFEDEA},
    [I(164,79)] = {29,0x1FFFEE6A},
    [I(165,79)] = {30,0x3FFFF46A},
    [I(166,79)] = {30,0x3FFFF4EA},
    [I(167,79)] = {28,0xFFFEF6A},
    [I(168,79)] = {30,0x3FFFF56A},
    [I(169,79)] = {29,0x1FFFEEEA},
    [I(170,79)] = {29,0x1FFFEF6A},
    [I(171,79)] = {31,0x7FFFF86A},
    [I(172,79)] = {28,0xFFFEFEA},
    [I(173,79)] = {29,0x1FFFEFEA},
    [I(174,79)] = {30,0x3FFFF5EA},
    [I(175,79)] = {30,0x3FFFF66A},
    [I(176,79)] = {28,0xFFFF06A},
    [I(177,79)] = {28,0xFFFF0EA},
    [I(178,79)] = {29,0x1FFFF06A},
    [I(179,79)] = {28,0xFFFF16A},
    [I(180,79)] = {30,0x3FFFF6EA},
    [I(181,79)] = {29,0x1FFFF0EA},
    [I(182,79)] = {30,0x3FFFF76A},
    [I(183,79)] = {30,0x3FFFF7EA},
    [I(184,79)] = {27,0x7FFF56A},
    [I(185,79)] = {29,0x1FFFF16A},
    [I(186,79)] = {29,0x1FFFF1EA},
    [I(187,79)] = {29,0x1FFFF26A},
    [I(188,79)] = {30,0x3FFFF86A},
    [I(189,79)] = {29,0x1FFFF2EA},
    [I(190,79)] = {29,0x1FFFF36A},
    [I(191,79)] = {30,0x3FFFF8EA},
    [I(192,79)] = {64,0},
    [I(193,79)] = {64,0},
    [I(194,79)] = {27,0x7FFF5EA},
    [I(195,79)] = {26,0x3FFF8EA},
    [I(196,79)] = {29,0x1FFFF3EA},
    [I(197,79)] = {30,0x3FFFF96A},
    [I(198,79)] = {29,0x1FFFF46A},
    [I(199,79)] = {X32,0xFFFFF66A},
    [I(200,79)] = {64,0},
    [I(201,79)] = {64,0},
    [I(202,79)] = {64,0},
    [I(203,79)] = {64,0},
    [I(204,79)] = {64,0},
    [I(205,79)] = {64,0},
    [I(206,79)] = {31,0x7FFFF8EA},
    [I(207,79)] = {X32,0xFFFFF6EA},
    [I(208,79)] = {26,0x3FFF96A},
    [I(209,79)] = {28,0xFFFF1EA},
    [I(210,79)] = {64,0},
    [I(211,79)] = {64,0},
    [I(212,79)] = {64,0},
    [I(213,79)] = {64,0},
    [I(214,79)] = {64,0},
    [I(215,79)] = {31,0x7FFFF96A},
    [I(216,79)] = {28,0xFFFF26A},
    [I(217,79)] = {28,0xFFFF2EA},
    [I(218,79)] = {64,0},
    [I(219,79)] = {64,0},
    [I(220,79)] = {64,0},
    [I(221,79)] = {64,0},
    [I(222,79)] = {64,0},
    [I(223,79)] = {64,0},
    [I(224,79)] = {27,0x7FFF66A},
    [I(225,79)] = {31,0x7FFFF9EA},
    [I(226,79)] = {27,0x7FFF6EA},
    [I(227,79)] = {28,0xFFFF36A},
    [I(228,79)] = {29,0x1FFFF4EA},
    [I(229,79)] = {28,0xFFFF3EA},
    [I(230,79)] = {28,0xFFFF46A},
    [I(231,79)] = {30,0x3FFFF9EA},
    [I(232,79)] = {29,0x1FFFF56A},
    [I(233,79)] = {29,0x1FFFF5EA},
    [I(234,79)] = {X32,0xFFFFF76A},
    [I(235,79)] = {X32,0xFFFFF7EA},
    [I(236,79)] = {31,0x7FFFFA6A},
    [I(237,79)] = {31,0x7FFFFAEA},
    [I(238,79)] = {64,0},
    [I(239,79)] = {30,0x3FFFFA6A},
    [I(240,79)] = {64,0},
    [I(241,79)] = {64,0},
    [I(242,79)] = {64,0},
    [I(243,79)] = {64,0},
    [I(244,79)] = {64,0},
    [I(245,79)] = {64,0},
    [I(246,79)] = {64,0},
    [I(247,79)] = {64,0},
    [I(248,79)] = {64,0},
    [I(249,79)] = {64,0},
    [I(250,79)] = {64,0},
    [I(251,79)] = {64,0},
    [I(252,79)] = {64,0},
    [I(253,79)] = {64,0},
    [I(254,79)] = {64,0},
    [I(255,79)] = {64,0},
    [I(0,80)] = {20,0xFFC6B},
    [I(1,80)] = {30,0x3FFFEC6B},
    [I(2,80)] = {64,0},
    [I(3,80)] = {64,0},
    [I(4,80)] = {64,0},
    [I(5,80)] = {64,0},
    [I(6,80)] = {64,0},
    [I(7,80)] = {64,0},
    [I(8,80)] = {64,0},
    [I(9,80)] = {31,0x7FFFF56B},
    [I(10,80)] = {64,0},
    [I(11,80)] = {64,0},
    [I(12,80)] = {64,0},
    [I(13,80)] = {64,0},
    [I(14,80)] = {64,0},
    [I(15,80)] = {64,0},
    [I(16,80)] = {64,0},
    [I(17,80)] = {64,0},
    [I(18,80)] = {64,0},
    [I(19,80)] = {64,0},
    [I(20,80)] = {64,0},
    [I(21,80)] = {64,0},
    [I(22,80)] = {64,0},
    [I(23,80)] = {64,0},
    [I(24,80)] = {64,0},
    [I(25,80)] = {64,0},
    [I(26,80)] = {64,0},
    [I(27,80)] = {64,0},
    [I(28,80)] = {64,0},
    [I(29,80)] = {64,0},
    [I(30,80)] = {64,0},
    [I(31,80)] = {64,0},
    [I(32,80)] = {13,0xA6B},
    [I(33,80)] = {17,0x1FC6B},
    [I(34,80)] = {17,0x1FCEB},
    [I(35,80)] = {19,0x7FD6B},
    [I(36,80)] = {20,0xFFCEB},
    [I(37,80)] = {13,0xAEB},
    [I(38,80)] = {15,0x7C6B},
    [I(39,80)] = {18,0x3FD6B},
    [I(40,80)] = {17,0x1FD6B},
    [I(41,80)] = {17,0x1FDEB},
    [I(42,80)] = {15,0x7CEB},
    [I(43,80)] = {18,0x3FDEB},
    [I(44,80)] = {15,0x7D6B},
    [I(45,80)] = {13,0xB6B},
    [I(46,80)] = {13,0xBEB},
    [I(47,80)] = {13,0xC6B},
    [I(48,80)] = {12,0x6B},
    [I(49,80)] = {12,0xEB},
    [I(50,80)] = {12,0x16B},
    [I(51,80)] = {13,0xCEB},
    [I(52,80)] = {13,0xD6B},
    [I(53,80)] = {13,0xDEB},
    [I(54,80)] = {13,0xE6B},
    [I(55,80)] = {13,0xEEB},
    [I(56,80)] = {13,0xF6B},
    [I(57,80)] = {13,0xFEB},
    [I(58,80)] = {14,0x2E6B},
    [I(59,80)] = {15,0x7DEB},
    [I(60,80)] = {22,0x3FFE6B},
    [I(61,80)] = {13,0x106B},
    [I(62,80)] = {19,0x7FDEB},
    [I(63,80)] = {17,0x1FE6B},
    [I(64,80)] = {20,0xFFD6B},
    [I(65,80)] = {13,0x10EB},
    [I(66,80)] = {14,0x2EEB},
    [I(67,80)] = {14,0x2F6B},
    [I(68,80)] = {14,0x2FEB},
    [I(69,80)] = {14,0x306B},
    [I(70,80)] = {14,0x30EB},
    [I(71,80)] = {14,0x316B},
    [I(72,80)] = {14,0x31EB},
    [I(73,80)] = {14,0x326B},
    [I(74,80)] = {14,0x32EB},
    [I(75,80)] = {14,0x336B},
    [I(76,80)] = {14,0x33EB},
    [I(77,80)] = {14,0x346B},
    [I(78,80)] = {14,0x34EB},
    [I(79,80)] = {14,0x356B},
    [I(80,80)] = {14,0x35EB},
    [I(81,80)] = {14,0x366B},
    [I(82,80)] = {14,0x36EB},
    [I(83,80)] = {14,0x376B},
    [I(84,80)] = {14,0x37EB},
    [I(85,80)] = {14,0x386B},
    [I(86,80)] = {14,0x38EB},
    [I(87,80)] = {14,0x396B},
    [I(88,80)] = {15,0x7E6B},
    [I(89,80)] = {14,0x39EB},
    [I(90,80)] = {15,0x7EEB},
    [I(91,80)] = {20,0xFFDEB},
    [I(92,80)] = {26,0x3FFF86B},
    [I(93,80)] = {20,0xFFE6B},
    [I(94,80)] = {21,0x1FFE6B},
    [I(95,80)] = {13,0x116B},
    [I(96,80)] = {22,0x3FFEEB},
    [I(97,80)] = {12,0x1EB},
    [I(98,80)] = {13,0x11EB},
    [I(99,80)] = {12,0x26B},
    [I(100,80)] = {13,0x126B},
    [I(101,80)] = {12,0x2EB},
    [I(102,80)] = {13,0x12EB},
    [I(103,80)] = {13,0x136B},
    [I(104,80)] = {13,0x13EB},
    [I(105,80)] = {12,0x36B},
    [I(106,80)] = {14,0x3A6B},
    [I(107,80)] = {14,0x3AEB},
    [I(108,80)] = {13,0x146B},
    [I(109,80)] = {13,0x14EB},
    [I(110,80)] = {13,0x156B},
    [I(111,80)] = {12,0x3EB},
    [I(112,80)] = {13,0x15EB},
    [I(113,80)] = {14,0x3B6B},
    [I(114,80)] = {13,0x166B},
    [I(115,80)] = {12,0x46B},
    [I(116,80)] = {12,0x4EB},
    [I(117,80)] = {13,0x16EB},
    [I(118,80)] = {14,0x3BEB},
    [I(119,80)] = {14,0x3C6B},
    [I(120,80)] = {14,0x3CEB},
    [I(121,80)] = {14,0x3D6B},
    [I(122,80)] = {14,0x3DEB},
    [I(123,80)] = {22,0x3FFF6B},
    [I(124,80)] = {18,0x3FE6B},
    [I(125,80)] = {21,0x1FFEEB},
    [I(126,80)] = {20,0xFFEEB},
    [I(127,80)] = {64,0},
    [I(128,80)] = {27,0x7FFF36B},
    [I(129,80)] = {29,0x1FFFE96B},
    [I(130,80)] = {27,0x7FFF3EB},
    [I(131,80)] = {27,0x7FFF46B},
    [I(132,80)] = {29,0x1FFFE9EB},
    [I(133,80)] = {29,0x1FFFEA6B},
    [I(134,80)] = {29,0x1FFFEAEB},
    [I(135,80)] = {30,0x3FFFECEB},
    [I(136,80)] = {29,0x1FFFEB6B},
    [I(137,80)] = {30,0x3FFFED6B},
    [I(138,80)] = {30,0x3FFFEDEB},
    [I(139,80)] = {30,0x3FFFEE6B},
    [I(140,80)] = {30,0x3FFFEEEB},
    [I(141,80)] = {30,0x3FFFEF6B},
    [I(142,80)] = {31,0x7FFFF5EB},
    [I(143,80)] = {30,0x3FFFEFEB},
    [I(144,80)] = {31,0x7FFFF66B},
    [I(145,80)] = {31,0x7FFFF6EB},
    [I(146,80)] = {29,0x1FFFEBEB},
    [I(147,80)] = {30,0x3FFFF06B},
    [I(148,80)] = {31,0x7FFFF76B},
    [I(149,80)] = {30,0x3FFFF0EB},
    [I(150,80)] = {30,0x3FFFF16B},
    [I(151,80)] = {30,0x3FFFF1EB},
    [I(152,80)] = {30,0x3FFFF26B},
    [I(153,80)] = {28,0xFFFEE6B},
    [I(154,80)] = {29,0x1FFFEC6B},
    [I(155,80)] = {30,0x3FFFF2EB},
    [I(156,80)] = {29,0x1FFFECEB},
    [I(157,80)] = {30,0x3FFFF36B},
    [I(158,80)] = {30,0x3FFFF3EB},
    [I(159,80)] = {31,0x7FFFF7EB},
    [I(160,80)] = {29,0x1FFFED6B},
    [I(161,80)] = {28,0xFFFEEEB},
    [I(162,80)] = {27,0x7FFF4EB},
    [I(163,80)] = {29,0x1FFFEDEB},
    [I(164,80)] = {29,0x1FFFEE6B},
    [I(165,80)] = {30,0x3FFFF46B},
    [I(166,80)] = {30,0x3FFFF4EB},
    [I(167,80)] = {28,0xFFFEF6B},
    [I(168,80)] = {30,0x3FFFF56B},
    [I(169,80)] = {29,0x1FFFEEEB},
    [I(170,80)] = {29,0x1FFFEF6B},
    [I(171,80)] = {31,0x7FFFF86B},
    [I(172,80)] = {28,0xFFFEFEB},
    [I(173,80)] = {29,0x1FFFEFEB},
    [I(174,80)] = {30,0x3FFFF5EB},
    [I(175,80)] = {30,0x3FFFF66B},
    [I(176,80)] = {28,0xFFFF06B},
    [I(177,80)] = {28,0xFFFF0EB},
    [I(178,80)] = {29,0x1FFFF06B},
    [I(179,80)] = {28,0xFFFF16B},
    [I(180,80)] = {30,0x3FFFF6EB},
    [I(181,80)] = {29,0x1FFFF0EB},
    [I(182,80)] = {30,0x3FFFF76B},
    [I(183,80)] = {30,0x3FFFF7EB},
    [I(184,80)] = {27,0x7FFF56B},
    [I(185,80)] = {29,0x1FFFF16B},
    [I(186,80)] = {29,0x1FFFF1EB},
    [I(187,80)] = {29,0x1FFFF26B},
    [I(188,80)] = {30,0x3FFFF86B},
    [I(189,80)] = {29,0x1FFFF2EB},
    [I(190,80)] = {29,0x1FFFF36B},
    [I(191,80)] = {30,0x3FFFF8EB},
    [I(192,80)] = {64,0},
    [I(193,80)] = {64,0},
    [I(194,80)] = {27,0x7FFF5EB},
    [I(195,80)] = {26,0x3FFF8EB},
    [I(196,80)] = {29,0x1FFFF3EB},
    [I(197,80)] = {30,0x3FFFF96B},
    [I(198,80)] = {29,0x1FFFF46B},
    [I(199,80)] = {X32,0xFFFFF66B},
    [I(200,80)] = {64,0},
    [I(201,80)] = {64,0},
    [I(202,80)] = {64,0},
    [I(203,80)] = {64,0},
    [I(204,80)] = {64,0},
    [I(205,80)] = {64,0},
    [I(206,80)] = {31,0x7FFFF8EB},
    [I(207,80)] = {X32,0xFFFFF6EB},
    [I(208,80)] = {26,0x3FFF96B},
    [I(209,80)] = {28,0xFFFF1EB},
    [I(210,80)] = {64,0},
    [I(211,80)] = {64,0},
    [I(212,80)] = {64,0},
    [I(213,80)] = {64,0},
    [I(214,80)] = {64,0},
    [I(215,80)] = {31,0x7FFFF96B},
    [I(216,80)] = {28,0xFFFF26B},
    [I(217,80)] = {28,0xFFFF2EB},
    [I(218,80)] = {64,0},
    [I(219,80)] = {64,0},
    [I(220,80)] = {64,0},
    [I(221,80)] = {64,0},
    [I(222,80)] = {64,0},
    [I(223,80)] = {64,0},
    [I(224,80)] = {27,0x7FFF66B},
    [I(225,80)] = {31,0x7FFFF9EB},
    [I(226,80)] = {27,0x7FFF6EB},
    [I(227,80)] = {28,0xFFFF36B},
    [I(228,80)] = {29,0x1FFFF4EB},
    [I(229,80)] = {28,0xFFFF3EB},
    [I(230,80)] = {28,0xFFFF46B},
    [I(231,80)] = {30,0x3FFFF9EB},
    [I(232,80)] = {29,0x1FFFF56B},
    [I(233,80)] = {29,0x1FFFF5EB},
    [I(234,80)] = {X32,0xFFFFF76B},
    [I(235,80)] = {X32,0xFFFFF7EB},
    [I(236,80)] = {31,0x7FFFFA6B},
    [I(237,80)] = {31,0x7FFFFAEB},
    [I(238,80)] = {64,0},
    [I(239,80)] = {30,0x3FFFFA6B},
    [I(240,80)] = {64,0},
    [I(241,80)] = {64,0},
    [I(242,80)] = {64,0},
    [I(243,80)] = {64,0},
    [I(244,80)] = {64,0},
    [I(245,80)] = {64,0},
    [I(246,80)] = {64,0},
    [I(247,80)] = {64,0},
    [I(248,80)] = {64,0},
    [I(249,80)] = {64,0},
    [I(250,80)] = {64,0},
    [I(251,80)] = {64,0},
    [I(252,80)] = {64,0},
    [I(253,80)] = {64,0},
    [I(254,80)] = {64,0},
    [I(255,80)] = {64,0},
    [I(0,81)] = {20,0xFFC6C},
    [I(1,81)] = {30,0x3FFFEC6C},
    [I(2,81)] = {64,0},
    [I(3,81)] = {64,0},
    [I(4,81)] = {64,0},
    [I(5,81)] = {64,0},
    [I(6,81)] = {64,0},
    [I(7,81)] = {64,0},
    [I(8,81)] = {64,0},
    [I(9,81)] = {31,0x7FFFF56C},
    [I(10,81)] = {64,0},
    [I(11,81)] = {64,0},
    [I(12,81)] = {64,0},
    [I(13,81)] = {64,0},
    [I(14,81)] = {64,0},
    [I(15,81)] = {64,0},
    [I(16,81)] = {64,0},
    [I(17,81)] = {64,0},
    [I(18,81)] = {64,0},
    [I(19,81)] = {64,0},
    [I(20,81)] = {64,0},
    [I(21,81)] = {64,0},
    [I(22,81)] = {64,0},
    [I(23,81)] = {64,0},
    [I(24,81)] = {64,0},
    [I(25,81)] = {64,0},
    [I(26,81)] = {64,0},
    [I(27,81)] = {64,0},
    [I(28,81)] = {64,0},
    [I(29,81)] = {64,0},
    [I(30,81)] = {64,0},
    [I(31,81)] = {64,0},
    [I(32,81)] = {13,0xA6C},
    [I(33,81)] = {17,0x1FC6C},
    [I(34,81)] = {17,0x1FCEC},
    [I(35,81)] = {19,0x7FD6C},
    [I(36,81)] = {20,0xFFCEC},
    [I(37,81)] = {13,0xAEC},
    [I(38,81)] = {15,0x7C6C},
    [I(39,81)] = {18,0x3FD6C},
    [I(40,81)] = {17,0x1FD6C},
    [I(41,81)] = {17,0x1FDEC},
    [I(42,81)] = {15,0x7CEC},
    [I(43,81)] = {18,0x3FDEC},
    [I(44,81)] = {15,0x7D6C},
    [I(45,81)] = {13,0xB6C},
    [I(46,81)] = {13,0xBEC},
    [I(47,81)] = {13,0xC6C},
    [I(48,81)] = {12,0x6C},
    [I(49,81)] = {12,0xEC},
    [I(50,81)] = {12,0x16C},
    [I(51,81)] = {13,0xCEC},
    [I(52,81)] = {13,0xD6C},
    [I(53,81)] = {13,0xDEC},
    [I(54,81)] = {13,0xE6C},
    [I(55,81)] = {13,0xEEC},
    [I(56,81)] = {13,0xF6C},
    [I(57,81)] = {13,0xFEC},
    [I(58,81)] = {14,0x2E6C},
    [I(59,81)] = {15,0x7DEC},
    [I(60,81)] = {22,0x3FFE6C},
    [I(61,81)] = {13,0x106C},
    [I(62,81)] = {19,0x7FDEC},
    [I(63,81)] = {17,0x1FE6C},
    [I(64,81)] = {20,0xFFD6C},
    [I(65,81)] = {13,0x10EC},
    [I(66,81)] = {14,0x2EEC},
    [I(67,81)] = {14,0x2F6C},
    [I(68,81)] = {14,0x2FEC},
    [I(69,81)] = {14,0x306C},
    [I(70,81)] = {14,0x30EC},
    [I(71,81)] = {14,0x316C},
    [I(72,81)] = {14,0x31EC},
    [I(73,81)] = {14,0x326C},
    [I(74,81)] = {14,0x32EC},
    [I(75,81)] = {14,0x336C},
    [I(76,81)] = {14,0x33EC},
    [I(77,81)] = {14,0x346C},
    [I(78,81)] = {14,0x34EC},
    [I(79,81)] = {14,0x356C},
    [I(80,81)] = {14,0x35EC},
    [I(81,81)] = {14,0x366C},
    [I(82,81)] = {14,0x36EC},
    [I(83,81)] = {14,0x376C},
    [I(84,81)] = {14,0x37EC},
    [I(85,81)] = {14,0x386C},
    [I(86,81)] = {14,0x38EC},
    [I(87,81)] = {14,0x396C},
    [I(88,81)] = {15,0x7E6C},
    [I(89,81)] = {14,0x39EC},
    [I(90,81)] = {15,0x7EEC},
    [I(91,81)] = {20,0xFFDEC},
    [I(92,81)] = {26,0x3FFF86C},
    [I(93,81)] = {20,0xFFE6C},
    [I(94,81)] = {21,0x1FFE6C},
    [I(95,81)] = {13,0x116C},
    [I(96,81)] = {22,0x3FFEEC},
    [I(97,81)] = {12,0x1EC},
    [I(98,81)] = {13,0x11EC},
    [I(99,81)] = {12,0x26C},
    [I(100,81)] = {13,0x126C},
    [I(101,81)] = {12,0x2EC},
    [I(102,81)] = {13,0x12EC},
    [I(103,81)] = {13,0x136C},
    [I(104,81)] = {13,0x13EC},
    [I(105,81)] = {12,0x36C},
    [I(106,81)] = {14,0x3A6C},
    [I(107,81)] = {14,0x3AEC},
    [I(108,81)] = {13,0x146C},
    [I(109,81)] = {13,0x14EC},
    [I(110,81)] = {13,0x156C},
    [I(111,81)] = {12,0x3EC},
    [I(112,81)] = {13,0x15EC},
    [I(113,81)] = {14,0x3B6C},
    [I(114,81)] = {13,0x166C},
    [I(115,81)] = {12,0x46C},
    [I(116,81)] = {12,0x4EC},
    [I(117,81)] = {13,0x16EC},
    [I(118,81)] = {14,0x3BEC},
    [I(119,81)] = {14,0x3C6C},
    [I(120,81)] = {14,0x3CEC},
    [I(121,81)] = {14,0x3D6C},
    [I(122,81)] = {14,0x3DEC},
    [I(123,81)] = {22,0x3FFF6C},
    [I(124,81)] = {18,0x3FE6C},
    [I(125,81)] = {21,0x1FFEEC},
    [I(126,81)] = {20,0xFFEEC},
    [I(127,81)] = {64,0},
    [I(128,81)] = {27,0x7FFF36C},
    [I(129,81)] = {29,0x1FFFE96C},
    [I(130,81)] = {27,0x7FFF3EC},
    [I(131,81)] = {27,0x7FFF46C},
    [I(132,81)] = {29,0x1FFFE9EC},
    [I(133,81)] = {29,0x1FFFEA6C},
    [I(134,81)] = {29,0x1FFFEAEC},
    [I(135,81)] = {30,0x3FFFECEC},
    [I(136,81)] = {29,0x1FFFEB6C},
    [I(137,81)] = {30,0x3FFFED6C},
    [I(138,81)] = {30,0x3FFFEDEC},
    [I(139,81)] = {30,0x3FFFEE6C},
    [I(140,81)] = {30,0x3FFFEEEC},
    [I(141,81)] = {30,0x3FFFEF6C},
    [I(142,81)] = {31,0x7FFFF5EC},
    [I(143,81)] = {30,0x3FFFEFEC},
    [I(144,81)] = {31,0x7FFFF66C},
    [I(145,81)] = {31,0x7FFFF6EC},
    [I(146,81)] = {29,0x1FFFEBEC},
    [I(147,81)] = {30,0x3FFFF06C},
    [I(148,81)] = {31,0x7FFFF76C},
    [I(149,81)] = {30,0x3FFFF0EC},
    [I(150,81)] = {30,0x3FFFF16C},
    [I(151,81)] = {30,0x3FFFF1EC},
    [I(152,81)] = {30,0x3FFFF26C},
    [I(153,81)] = {28,0xFFFEE6C},
    [I(154,81)] = {29,0x1FFFEC6C},
    [I(155,81)] = {30,0x3FFFF2EC},
    [I(156,81)] = {29,0x1FFFECEC},
    [I(157,81)] = {30,0x3FFFF36C},
    [I(158,81)] = {30,0x3FFFF3EC},
    [I(159,81)] = {31,0x7FFFF7EC},
    [I(160,81)] = {29,0x1FFFED6C},
    [I(161,81)] = {28,0xFFFEEEC},
    [I(162,81)] = {27,0x7FFF4EC},
    [I(163,81)] = {29,0x1FFFEDEC},
    [I(164,81)] = {29,0x1FFFEE6C},
    [I(165,81)] = {30,0x3FFFF46C},
    [I(166,81)] = {30,0x3FFFF4EC},
    [I(167,81)] = {28,0xFFFEF6C},
    [I(168,81)] = {30,0x3FFFF56C},
    [I(169,81)] = {29,0x1FFFEEEC},
    [I(170,81)] = {29,0x1FFFEF6C},
    [I(171,81)] = {31,0x7FFFF86C},
    [I(172,81)] = {28,0xFFFEFEC},
    [I(173,81)] = {29,0x1FFFEFEC},
    [I(174,81)] = {30,0x3FFFF5EC},
    [I(175,81)] = {30,0x3FFFF66C},
    [I(176,81)] = {28,0xFFFF06C},
    [I(177,81)] = {28,0xFFFF0EC},
    [I(178,81)] = {29,0x1FFFF06C},
    [I(179,81)] = {28,0xFFFF16C},
    [I(180,81)] = {30,0x3FFFF6EC},
    [I(181,81)] = {29,0x1FFFF0EC},
    [I(182,81)] = {30,0x3FFFF76C},
    [I(183,81)] = {30,0x3FFFF7EC},
    [I(184,81)] = {27,0x7FFF56C},
    [I(185,81)] = {29,0x1FFFF16C},
    [I(186,81)] = {29,0x1FFFF1EC},
    [I(187,81)] = {29,0x1FFFF26C},
    [I(188,81)] = {30,0x3FFFF86C},
    [I(189,81)] = {29,0x1FFFF2EC},
    [I(190,81)] = {29,0x1FFFF36C},
    [I(191,81)] = {30,0x3FFFF8EC},
    [I(192,81)] = {64,0},
    [I(193,81)] = {64,0},
    [I(194,81)] = {27,0x7FFF5EC},
    [I(195,81)] = {26,0x3FFF8EC},
    [I(196,81)] = {29,0x1FFFF3EC},
    [I(197,81)] = {30,0x3FFFF96C},
    [I(198,81)] = {29,0x1FFFF46C},
    [I(199,81)] = {X32,0xFFFFF66C},
    [I(200,81)] = {64,0},
    [I(201,81)] = {64,0},
    [I(202,81)] = {64,0},
    [I(203,81)] = {64,0},
    [I(204,81)] = {64,0},
    [I(205,81)] = {64,0},
    [I(206,81)] = {31,0x7FFFF8EC},
    [I(207,81)] = {X32,0xFFFFF6EC},
    [I(208,81)] = {26,0x3FFF96C},
    [I(209,81)] = {28,0xFFFF1EC},
    [I(210,81)] = {64,0},
    [I(211,81)] = {64,0},
    [I(212,81)] = {64,0},
    [I(213,81)] = {64,0},
    [I(214,81)] = {64,0},
    [I(215,81)] = {31,0x7FFFF96C},
    [I(216,81)] = {28,0xFFFF26C},
    [I(217,81)] = {28,0xFFFF2EC},
    [I(218,81)] = {64,0},
    [I(219,81)] = {64,0},
    [I(220,81)] = {64,0},
    [I(221,81)] = {64,0},
    [I(222,81)] = {64,0},
    [I(223,81)] = {64,0},
    [I(224,81)] = {27,0x7FFF66C},
    [I(225,81)] = {31,0x7FFFF9EC},
    [I(226,81)] = {27,0x7FFF6EC},
    [I(227,81)] = {28,0xFFFF36C},
    [I(228,81)] = {29,0x1FFFF4EC},
    [I(229,81)] = {28,0xFFFF3EC},
    [I(230,81)] = {28,0xFFFF46C},
    [I(231,81)] = {30,0x3FFFF9EC},
    [I(232,81)] = {29,0x1FFFF56C},
    [I(233,81)] = {29,0x1FFFF5EC},
    [I(234,81)] = {X32,0xFFFFF76C},
    [I(235,81)] = {X32,0xFFFFF7EC},
    [I(236,81)] = {31,0x7FFFFA6C},
    [I(237,81)] = {31,0x7FFFFAEC},
    [I(238,81)] = {64,0},
    [I(239,81)] = {30,0x3FFFFA6C},
    [I(240,81)] = {64,0},
    [I(241,81)] = {64,0},
    [I(242,81)] = {64,0},
    [I(243,81)] = {64,0},
    [I(244,81)] = {64,0},
    [I(245,81)] = {64,0},
    [I(246,81)] = {64,0},
    [I(247,81)] = {64,0},
    [I(248,81)] = {64,0},
    [I(249,81)] = {64,0},
    [I(250,81)] = {64,0},
    [I(251,81)] = {64,0},
    [I(252,81)] = {64,0},
    [I(253,81)] = {64,0},
    [I(254,81)] = {64,0},
    [I(255,81)] = {64,0},
    [I(0,82)] = {20,0xFFC6D},
    [I(1,82)] = {30,0x3FFFEC6D},
    [I(2,82)] = {64,0},
    [I(3,82)] = {64,0},
    [I(4,82)] = {64,0},
    [I(5,82)] = {64,0},
    [I(6,82)] = {64,0},
    [I(7,82)] = {64,0},
    [I(8,82)] = {64,0},
    [I(9,82)] = {31,0x7FFFF56D},
    [I(10,82)] = {64,0},
    [I(11,82)] = {64,0},
    [I(12,82)] = {64,0},
    [I(13,82)] = {64,0},
    [I(14,82)] = {64,0},
    [I(15,82)] = {64,0},
    [I(16,82)] = {64,0},
    [I(17,82)] = {64,0},
    [I(18,82)] = {64,0},
    [I(19,82)] = {64,0},
    [I(20,82)] = {64,0},
    [I(21,82)] = {64,0},
    [I(22,82)] = {64,0},
    [I(23,82)] = {64,0},
    [I(24,82)] = {64,0},
    [I(25,82)] = {64,0},
    [I(26,82)] = {64,0},
    [I(27,82)] = {64,0},
    [I(28,82)] = {64,0},
    [I(29,82)] = {64,0},
    [I(30,82)] = {64,0},
    [I(31,82)] = {64,0},
    [I(32,82)] = {13,0xA6D},
    [I(33,82)] = {17,0x1FC6D},
    [I(34,82)] = {17,0x1FCED},
    [I(35,82)] = {19,0x7FD6D},
    [I(36,82)] = {20,0xFFCED},
    [I(37,82)] = {13,0xAED},
    [I(38,82)] = {15,0x7C6D},
    [I(39,82)] = {18,0x3FD6D},
    [I(40,82)] = {17,0x1FD6D},
    [I(41,82)] = {17,0x1FDED},
    [I(42,82)] = {15,0x7CED},
    [I(43,82)] = {18,0x3FDED},
    [I(44,82)] = {15,0x7D6D},
    [I(45,82)] = {13,0xB6D},
    [I(46,82)] = {13,0xBED},
    [I(47,82)] = {13,0xC6D},
    [I(48,82)] = {12,0x6D},
    [I(49,82)] = {12,0xED},
    [I(50,82)] = {12,0x16D},
    [I(51,82)] = {13,0xCED},
    [I(52,82)] = {13,0xD6D},
    [I(53,82)] = {13,0xDED},
    [I(54,82)] = {13,0xE6D},
    [I(55,82)] = {13,0xEED},
    [I(56,82)] = {13,0xF6D},
    [I(57,82)] = {13,0xFED},
    [I(58,82)] = {14,0x2E6D},
    [I(59,82)] = {15,0x7DED},
    [I(60,82)] = {22,0x3FFE6D},
    [I(61,82)] = {13,0x106D},
    [I(62,82)] = {19,0x7FDED},
    [I(63,82)] = {17,0x1FE6D},
    [I(64,82)] = {20,0xFFD6D},
    [I(65,82)] = {13,0x10ED},
    [I(66,82)] = {14,0x2EED},
    [I(67,82)] = {14,0x2F6D},
    [I(68,82)] = {14,0x2FED},
    [I(69,82)] = {14,0x306D},
    [I(70,82)] = {14,0x30ED},
    [I(71,82)] = {14,0x316D},
    [I(72,82)] = {14,0x31ED},
    [I(73,82)] = {14,0x326D},
    [I(74,82)] = {14,0x32ED},
    [I(75,82)] = {14,0x336D},
    [I(76,82)] = {14,0x33ED},
    [I(77,82)] = {14,0x346D},
    [I(78,82)] = {14,0x34ED},
    [I(79,82)] = {14,0x356D},
    [I(80,82)] = {14,0x35ED},
    [I(81,82)] = {14,0x366D},
    [I(82,82)] = {14,0x36ED},
    [I(83,82)] = {14,0x376D},
    [I(84,82)] = {14,0x37ED},
    [I(85,82)] = {14,0x386D},
    [I(86,82)] = {14,0x38ED},
    [I(87,82)] = {14,0x396D},
    [I(88,82)] = {15,0x7E6D},
    [I(89,82)] = {14,0x39ED},
    [I(90,82)] = {15,0x7EED},
    [I(91,82)] = {20,0xFFDED},
    [I(92,82)] = {26,0x3FFF86D},
    [I(93,82)] = {20,0xFFE6D},
    [I(94,82)] = {21,0x1FFE6D},
    [I(95,82)] = {13,0x116D},
    [I(96,82)] = {22,0x3FFEED},
    [I(97,82)] = {12,0x1ED},
    [I(98,82)] = {13,0x11ED},
    [I(99,82)] = {12,0x26D},
    [I(100,82)] = {13,0x126D},
    [I(101,82)] = {12,0x2ED},
    [I(102,82)] = {13,0x12ED},
    [I(103,82)] = {13,0x136D},
    [I(104,82)] = {13,0x13ED},
    [I(105,82)] = {12,0x36D},
    [I(106,82)] = {14,0x3A6D},
    [I(107,82)] = {14,0x3AED},
    [I(108,82)] = {13,0x146D},
    [I(109,82)] = {13,0x14ED},
    [I(110,82)] = {13,0x156D},
    [I(111,82)] = {12,0x3ED},
    [I(112,82)] = {13,0x15ED},
    [I(113,82)] = {14,0x3B6D},
    [I(114,82)] = {13,0x166D},
    [I(115,82)] = {12,0x46D},
    [I(116,82)] = {12,0x4ED},
    [I(117,82)] = {13,0x16ED},
    [I(118,82)] = {14,0x3BED},
    [I(119,82)] = {14,0x3C6D},
    [I(120,82)] = {14,0x3CED},
    [I(121,82)] = {14,0x3D6D},
    [I(122,82)] = {14,0x3DED},
    [I(123,82)] = {22,0x3FFF6D},
    [I(124,82)] = {18,0x3FE6D},
    [I(125,82)] = {21,0x1FFEED},
    [I(126,82)] = {20,0xFFEED},
    [I(127,82)] = {64,0},
    [I(128,82)] = {27,0x7FFF36D},
    [I(129,82)] = {29,0x1FFFE96D},
    [I(130,82)] = {27,0x7FFF3ED},
    [I(131,82)] = {27,0x7FFF46D},
    [I(132,82)] = {29,0x1FFFE9ED},
    [I(133,82)] = {29,0x1FFFEA6D},
    [I(134,82)] = {29,0x1FFFEAED},
    [I(135,82)] = {30,0x3FFFECED},
    [I(136,82)] = {29,0x1FFFEB6D},
    [I(137,82)] = {30,0x3FFFED6D},
    [I(138,82)] = {30,0x3FFFEDED},
    [I(139,82)] = {30,0x3FFFEE6D},
    [I(140,82)] = {30,0x3FFFEEED},
    [I(141,82)] = {30,0x3FFFEF6D},
    [I(142,82)] = {31,0x7FFFF5ED},
    [I(143,82)] = {30,0x3FFFEFED},
    [I(144,82)] = {31,0x7FFFF66D},
    [I(145,82)] = {31,0x7FFFF6ED},
    [I(146,82)] = {29,0x1FFFEBED},
    [I(147,82)] = {30,0x3FFFF06D},
    [I(148,82)] = {31,0x7FFFF76D},
    [I(149,82)] = {30,0x3FFFF0ED},
    [I(150,82)] = {30,0x3FFFF16D},
    [I(151,82)] = {30,0x3FFFF1ED},
    [I(152,82)] = {30,0x3FFFF26D},
    [I(153,82)] = {28,0xFFFEE6D},
    [I(154,82)] = {29,0x1FFFEC6D},
    [I(155,82)] = {30,0x3FFFF2ED},
    [I(156,82)] = {29,0x1FFFECED},
    [I(157,82)] = {30,0x3FFFF36D},
    [I(158,82)] = {30,0x3FFFF3ED},
    [I(159,82)] = {31,0x7FFFF7ED},
    [I(160,82)] = {29,0x1FFFED6D},
    [I(161,82)] = {28,0xFFFEEED},
    [I(162,82)] = {27,0x7FFF4ED},
    [I(163,82)] = {29,0x1FFFEDED},
    [I(164,82)] = {29,0x1FFFEE6D},
    [I(165,82)] = {30,0x3FFFF46D},
    [I(166,82)] = {30,0x3FFFF4ED},
    [I(167,82)] = {28,0xFFFEF6D},
    [I(168,82)] = {30,0x3FFFF56D},
    [I(169,82)] = {29,0x1FFFEEED},
    [I(170,82)] = {29,0x1FFFEF6D},
    [I(171,82)] = {31,0x7FFFF86D},
    [I(172,82)] = {28,0xFFFEFED},
    [I(173,82)] = {29,0x1FFFEFED},
    [I(174,82)] = {30,0x3FFFF5ED},
    [I(175,82)] = {30,0x3FFFF66D},
    [I(176,82)] = {28,0xFFFF06D},
    [I(177,82)] = {28,0xFFFF0ED},
    [I(178,82)] = {29,0x1FFFF06D},
    [I(179,82)] = {28,0xFFFF16D},
    [I(180,82)] = {30,0x3FFFF6ED},
    [I(181,82)] = {29,0x1FFFF0ED},
    [I(182,82)] = {30,0x3FFFF76D},
    [I(183,82)] = {30,0x3FFFF7ED},
    [I(184,82)] = {27,0x7FFF56D},
    [I(185,82)] = {29,0x1FFFF16D},
    [I(186,82)] = {29,0x1FFFF1ED},
    [I(187,82)] = {29,0x1FFFF26D},
    [I(188,82)] = {30,0x3FFFF86D},
    [I(189,82)] = {29,0x1FFFF2ED},
    [I(190,82)] = {29,0x1FFFF36D},
    [I(191,82)] = {30,0x3FFFF8ED},
    [I(192,82)] = {64,0},
    [I(193,82)] = {64,0},
    [I(194,82)] = {27,0x7FFF5ED},
    [I(195,82)] = {26,0x3FFF8ED},
    [I(196,82)] = {29,0x1FFFF3ED},
    [I(197,82)] = {30,0x3FFFF96D},
    [I(198,82)] = {29,0x1FFFF46D},
    [I(199,82)] = {X32,0xFFFFF66D},
    [I(200,82)] = {64,0},
    [I(201,82)] = {64,0},
    [I(202,82)] = {64,0},
    [I(203,82)] = {64,0},
    [I(204,82)] = {64,0},
    [I(205,82)] = {64,0},
    [I(206,82)] = {31,0x7FFFF8ED},
    [I(207,82)] = {X32,0xFFFFF6ED},
    [I(208,82)] = {26,0x3FFF96D},
    [I(209,82)] = {28,0xFFFF1ED},
    [I(210,82)] = {64,0},
    [I(211,82)] = {64,0},
    [I(212,82)] = {64,0},
    [I(213,82)] = {64,0},
    [I(214,82)] = {64,0},
    [I(215,82)] = {31,0x7FFFF96D},
    [I(216,82)] = {28,0xFFFF26D},
    [I(217,82)] = {28,0xFFFF2ED},
    [I(218,82)] = {64,0},
    [I(219,82)] = {64,0},
    [I(220,82)] = {64,0},
    [I(221,82)] = {64,0},
    [I(222,82)] = {64,0},
    [I(223,82)] = {64,0},
    [I(224,82)] = {27,0x7FFF66D},
    [I(225,82)] = {31,0x7FFFF9ED},
    [I(226,82)] = {27,0x7FFF6ED},
    [I(227,82)] = {28,0xFFFF36D},
    [I(228,82)] = {29,0x1FFFF4ED},
    [I(229,82)] = {28,0xFFFF3ED},
    [I(230,82)] = {28,0xFFFF46D},
    [I(231,82)] = {30,0x3FFFF9ED},
    [I(232,82)] = {29,0x1FFFF56D},
    [I(233,82)] = {29,0x1FFFF5ED},
    [I(234,82)] = {X32,0xFFFFF76D},
    [I(235,82)] = {X32,0xFFFFF7ED},
    [I(236,82)] = {31,0x7FFFFA6D},
    [I(237,82)] = {31,0x7FFFFAED},
    [I(238,82)] = {64,0},
    [I(239,82)] = {30,0x3FFFFA6D},
    [I(240,82)] = {64,0},
    [I(241,82)] = {64,0},
    [I(242,82)] = {64,0},
    [I(243,82)] = {64,0},
    [I(244,82)] = {64,0},
    [I(245,82)] = {64,0},
    [I(246,82)] = {64,0},
    [I(247,82)] = {64,0},
    [I(248,82)] = {64,0},
    [I(249,82)] = {64,0},
    [I(250,82)] = {64,0},
    [I(251,82)] = {64,0},
    [I(252,82)] = {64,0},
    [I(253,82)] = {64,0},
    [I(254,82)] = {64,0},
    [I(255,82)] = {64,0},
    [I(0,83)] = {20,0xFFC6E},
    [I(1,83)] = {30,0x3FFFEC6E},
    [I(2,83)] = {64,0},
    [I(3,83)] = {64,0},
    [I(4,83)] = {64,0},
    [I(5,83)] = {64,0},
    [I(6,83)] = {64,0},
    [I(7,83)] = {64,0},
    [I(8,83)] = {64,0},
    [I(9,83)] = {31,0x7FFFF56E},
    [I(10,83)] = {64,0},
    [I(11,83)] = {64,0},
    [I(12,83)] = {64,0},
    [I(13,83)] = {64,0},
    [I(14,83)] = {64,0},
    [I(15,83)] = {64,0},
    [I(16,83)] = {64,0},
    [I(17,83)] = {64,0},
    [I(18,83)] = {64,0},
    [I(19,83)] = {64,0},
    [I(20,83)] = {64,0},
    [I(21,83)] = {64,0},
    [I(22,83)] = {64,0},
    [I(23,83)] = {64,0},
    [I(24,83)] = {64,0},
    [I(25,83)] = {64,0},
    [I(26,83)] = {64,0},
    [I(27,83)] = {64,0},
    [I(28,83)] = {64,0},
    [I(29,83)] = {64,0},
    [I(30,83)] = {64,0},
    [I(31,83)] = {64,0},
    [I(32,83)] = {13,0xA6E},
    [I(33,83)] = {17,0x1FC6E},
    [I(34,83)] = {17,0x1FCEE},
    [I(35,83)] = {19,0x7FD6E},
    [I(36,83)] = {20,0xFFCEE},
    [I(37,83)] = {13,0xAEE},
    [I(38,83)] = {15,0x7C6E},
    [I(39,83)] = {18,0x3FD6E},
    [I(40,83)] = {17,0x1FD6E},
    [I(41,83)] = {17,0x1FDEE},
    [I(42,83)] = {15,0x7CEE},
    [I(43,83)] = {18,0x3FDEE},
    [I(44,83)] = {15,0x7D6E},
    [I(45,83)] = {13,0xB6E},
    [I(46,83)] = {13,0xBEE},
    [I(47,83)] = {13,0xC6E},
    [I(48,83)] = {12,0x6E},
    [I(49,83)] = {12,0xEE},
    [I(50,83)] = {12,0x16E},
    [I(51,83)] = {13,0xCEE},
    [I(52,83)] = {13,0xD6E},
    [I(53,83)] = {13,0xDEE},
    [I(54,83)] = {13,0xE6E},
    [I(55,83)] = {13,0xEEE},
    [I(56,83)] = {13,0xF6E},
    [I(57,83)] = {13,0xFEE},
    [I(58,83)] = {14,0x2E6E},
    [I(59,83)] = {15,0x7DEE},
    [I(60,83)] = {22,0x3FFE6E},
    [I(61,83)] = {13,0x106E},
    [I(62,83)] = {19,0x7FDEE},
    [I(63,83)] = {17,0x1FE6E},
    [I(64,83)] = {20,0xFFD6E},
    [I(65,83)] = {13,0x10EE},
    [I(66,83)] = {14,0x2EEE},
    [I(67,83)] = {14,0x2F6E},
    [I(68,83)] = {14,0x2FEE},
    [I(69,83)] = {14,0x306E},
    [I(70,83)] = {14,0x30EE},
    [I(71,83)] = {14,0x316E},
    [I(72,83)] = {14,0x31EE},
    [I(73,83)] = {14,0x326E},
    [I(74,83)] = {14,0x32EE},
    [I(75,83)] = {14,0x336E},
    [I(76,83)] = {14,0x33EE},
    [I(77,83)] = {14,0x346E},
    [I(78,83)] = {14,0x34EE},
    [I(79,83)] = {14,0x356E},
    [I(80,83)] = {14,0x35EE},
    [I(81,83)] = {14,0x366E},
    [I(82,83)] = {14,0x36EE},
    [I(83,83)] = {14,0x376E},
    [I(84,83)] = {14,0x37EE},
    [I(85,83)] = {14,0x386E},
    [I(86,83)] = {14,0x38EE},
    [I(87,83)] = {14,0x396E},
    [I(88,83)] = {15,0x7E6E},
    [I(89,83)] = {14,0x39EE},
    [I(90,83)] = {15,0x7EEE},
    [I(91,83)] = {20,0xFFDEE},
    [I(92,83)] = {26,0x3FFF86E},
    [I(93,83)] = {20,0xFFE6E},
    [I(94,83)] = {21,0x1FFE6E},
    [I(95,83)] = {13,0x116E},
    [I(96,83)] = {22,0x3FFEEE},
    [I(97,83)] = {12,0x1EE},
    [I(98,83)] = {13,0x11EE},
    [I(99,83)] = {12,0x26E},
    [I(100,83)] = {13,0x126E},
    [I(101,83)] = {12,0x2EE},
    [I(102,83)] = {13,0x12EE},
    [I(103,83)] = {13,0x136E},
    [I(104,83)] = {13,0x13EE},
    [I(105,83)] = {12,0x36E},
    [I(106,83)] = {14,0x3A6E},
    [I(107,83)] = {14,0x3AEE},
    [I(108,83)] = {13,0x146E},
    [I(109,83)] = {13,0x14EE},
    [I(110,83)] = {13,0x156E},
    [I(111,83)] = {12,0x3EE},
    [I(112,83)] = {13,0x15EE},
    [I(113,83)] = {14,0x3B6E},
    [I(114,83)] = {13,0x166E},
    [I(115,83)] = {12,0x46E},
    [I(116,83)] = {12,0x4EE},
    [I(117,83)] = {13,0x16EE},
    [I(118,83)] = {14,0x3BEE},
    [I(119,83)] = {14,0x3C6E},
    [I(120,83)] = {14,0x3CEE},
    [I(121,83)] = {14,0x3D6E},
    [I(122,83)] = {14,0x3DEE},
    [I(123,83)] = {22,0x3FFF6E},
    [I(124,83)] = {18,0x3FE6E},
    [I(125,83)] = {21,0x1FFEEE},
    [I(126,83)] = {20,0xFFEEE},
    [I(127,83)] = {64,0},
    [I(128,83)] = {27,0x7FFF36E},
    [I(129,83)] = {29,0x1FFFE96E},
    [I(130,83)] = {27,0x7FFF3EE},
    [I(131,83)] = {27,0x7FFF46E},
    [I(132,83)] = {29,0x1FFFE9EE},
    [I(133,83)] = {29,0x1FFFEA6E},
    [I(134,83)] = {29,0x1FFFEAEE},
    [I(135,83)] = {30,0x3FFFECEE},
    [I(136,83)] = {29,0x1FFFEB6E},
    [I(137,83)] = {30,0x3FFFED6E},
    [I(138,83)] = {30,0x3FFFEDEE},
    [I(139,83)] = {30,0x3FFFEE6E},
    [I(140,83)] = {30,0x3FFFEEEE},
    [I(141,83)] = {30,0x3FFFEF6E},
    [I(142,83)] = {31,0x7FFFF5EE},
    [I(143,83)] = {30,0x3FFFEFEE},
    [I(144,83)] = {31,0x7FFFF66E},
    [I(145,83)] = {31,0x7FFFF6EE},
    [I(146,83)] = {29,0x1FFFEBEE},
    [I(147,83)] = {30,0x3FFFF06E},
    [I(148,83)] = {31,0x7FFFF76E},
    [I(149,83)] = {30,0x3FFFF0EE},
    [I(150,83)] = {30,0x3FFFF16E},
    [I(151,83)] = {30,0x3FFFF1EE},
    [I(152,83)] = {30,0x3FFFF26E},
    [I(153,83)] = {28,0xFFFEE6E},
    [I(154,83)] = {29,0x1FFFEC6E},
    [I(155,83)] = {30,0x3FFFF2EE},
    [I(156,83)] = {29,0x1FFFECEE},
    [I(157,83)] = {30,0x3FFFF36E},
    [I(158,83)] = {30,0x3FFFF3EE},
    [I(159,83)] = {31,0x7FFFF7EE},
    [I(160,83)] = {29,0x1FFFED6E},
    [I(161,83)] = {28,0xFFFEEEE},
    [I(162,83)] = {27,0x7FFF4EE},
    [I(163,83)] = {29,0x1FFFEDEE},
    [I(164,83)] = {29,0x1FFFEE6E},
    [I(165,83)] = {30,0x3FFFF46E},
    [I(166,83)] = {30,0x3FFFF4EE},
    [I(167,83)] = {28,0xFFFEF6E},
    [I(168,83)] = {30,0x3FFFF56E},
    [I(169,83)] = {29,0x1FFFEEEE},
    [I(170,83)] = {29,0x1FFFEF6E},
    [I(171,83)] = {31,0x7FFFF86E},
    [I(172,83)] = {28,0xFFFEFEE},
    [I(173,83)] = {29,0x1FFFEFEE},
    [I(174,83)] = {30,0x3FFFF5EE},
    [I(175,83)] = {30,0x3FFFF66E},
    [I(176,83)] = {28,0xFFFF06E},
    [I(177,83)] = {28,0xFFFF0EE},
    [I(178,83)] = {29,0x1FFFF06E},
    [I(179,83)] = {28,0xFFFF16E},
    [I(180,83)] = {30,0x3FFFF6EE},
    [I(181,83)] = {29,0x1FFFF0EE},
    [I(182,83)] = {30,0x3FFFF76E},
    [I(183,83)] = {30,0x3FFFF7EE},
    [I(184,83)] = {27,0x7FFF56E},
    [I(185,83)] = {29,0x1FFFF16E},
    [I(186,83)] = {29,0x1FFFF1EE},
    [I(187,83)] = {29,0x1FFFF26E},
    [I(188,83)] = {30,0x3FFFF86E},
    [I(189,83)] = {29,0x1FFFF2EE},
    [I(190,83)] = {29,0x1FFFF36E},
    [I(191,83)] = {30,0x3FFFF8EE},
    [I(192,83)] = {64,0},
    [I(193,83)] = {64,0},
    [I(194,83)] = {27,0x7FFF5EE},
    [I(195,83)] = {26,0x3FFF8EE},
    [I(196,83)] = {29,0x1FFFF3EE},
    [I(197,83)] = {30,0x3FFFF96E},
    [I(198,83)] = {29,0x1FFFF46E},
    [I(199,83)] = {X32,0xFFFFF66E},
    [I(200,83)] = {64,0},
    [I(201,83)] = {64,0},
    [I(202,83)] = {64,0},
    [I(203,83)] = {64,0},
    [I(204,83)] = {64,0},
    [I(205,83)] = {64,0},
    [I(206,83)] = {31,0x7FFFF8EE},
    [I(207,83)] = {X32,0xFFFFF6EE},
    [I(208,83)] = {26,0x3FFF96E},
    [I(209,83)] = {28,0xFFFF1EE},
    [I(210,83)] = {64,0},
    [I(211,83)] = {64,0},
    [I(212,83)] = {64,0},
    [I(213,83)] = {64,0},
    [I(214,83)] = {64,0},
    [I(215,83)] = {31,0x7FFFF96E},
    [I(216,83)] = {28,0xFFFF26E},
    [I(217,83)] = {28,0xFFFF2EE},
    [I(218,83)] = {64,0},
    [I(219,83)] = {64,0},
    [I(220,83)] = {64,0},
    [I(221,83)] = {64,0},
    [I(222,83)] = {64,0},
    [I(223,83)] = {64,0},
    [I(224,83)] = {27,0x7FFF66E},
    [I(225,83)] = {31,0x7FFFF9EE},
    [I(226,83)] = {27,0x7FFF6EE},
    [I(227,83)] = {28,0xFFFF36E},
    [I(228,83)] = {29,0x1FFFF4EE},
    [I(229,83)] = {28,0xFFFF3EE},
    [I(230,83)] = {28,0xFFFF46E},
    [I(231,83)] = {30,0x3FFFF9EE},
    [I(232,83)] = {29,0x1FFFF56E},
    [I(233,83)] = {29,0x1FFFF5EE},
    [I(234,83)] = {X32,0xFFFFF76E},
    [I(235,83)] = {X32,0xFFFFF7EE},
    [I(236,83)] = {31,0x7FFFFA6E},
    [I(237,83)] = {31,0x7FFFFAEE},
    [I(238,83)] = {64,0},
    [I(239,83)] = {30,0x3FFFFA6E},
    [I(240,83)] = {64,0},
    [I(241,83)] = {64,0},
    [I(242,83)] = {64,0},
    [I(243,83)] = {64,0},
    [I(244,83)] = {64,0},
    [I(245,83)] = {64,0},
    [I(246,83)] = {64,0},
    [I(247,83)] = {64,0},
    [I(248,83)] = {64,0},
    [I(249,83)] = {64,0},
    [I(250,83)] = {64,0},
    [I(251,83)] = {64,0},
    [I(252,83)] = {64,0},
    [I(253,83)] = {64,0},
    [I(254,83)] = {64,0},
    [I(255,83)] = {64,0},
    [I(0,84)] = {20,0xFFC6F},
    [I(1,84)] = {30,0x3FFFEC6F},
    [I(2,84)] = {64,0},
    [I(3,84)] = {64,0},
    [I(4,84)] = {64,0},
    [I(5,84)] = {64,0},
    [I(6,84)] = {64,0},
    [I(7,84)] = {64,0},
    [I(8,84)] = {64,0},
    [I(9,84)] = {31,0x7FFFF56F},
    [I(10,84)] = {64,0},
    [I(11,84)] = {64,0},
    [I(12,84)] = {64,0},
    [I(13,84)] = {64,0},
    [I(14,84)] = {64,0},
    [I(15,84)] = {64,0},
    [I(16,84)] = {64,0},
    [I(17,84)] = {64,0},
    [I(18,84)] = {64,0},
    [I(19,84)] = {64,0},
    [I(20,84)] = {64,0},
    [I(21,84)] = {64,0},
    [I(22,84)] = {64,0},
    [I(23,84)] = {64,0},
    [I(24,84)] = {64,0},
    [I(25,84)] = {64,0},
    [I(26,84)] = {64,0},
    [I(27,84)] = {64,0},
    [I(28,84)] = {64,0},
    [I(29,84)] = {64,0},
    [I(30,84)] = {64,0},
    [I(31,84)] = {64,0},
    [I(32,84)] = {13,0xA6F},
    [I(33,84)] = {17,0x1FC6F},
    [I(34,84)] = {17,0x1FCEF},
    [I(35,84)] = {19,0x7FD6F},
    [I(36,84)] = {20,0xFFCEF},
    [I(37,84)] = {13,0xAEF},
    [I(38,84)] = {15,0x7C6F},
    [I(39,84)] = {18,0x3FD6F},
    [I(40,84)] = {17,0x1FD6F},
    [I(41,84)] = {17,0x1FDEF},
    [I(42,84)] = {15,0x7CEF},
    [I(43,84)] = {18,0x3FDEF},
    [I(44,84)] = {15,0x7D6F},
    [I(45,84)] = {13,0xB6F},
    [I(46,84)] = {13,0xBEF},
    [I(47,84)] = {13,0xC6F},
    [I(48,84)] = {12,0x6F},
    [I(49,84)] = {12,0xEF},
    [I(50,84)] = {12,0x16F},
    [I(51,84)] = {13,0xCEF},
    [I(52,84)] = {13,0xD6F},
    [I(53,84)] = {13,0xDEF},
    [I(54,84)] = {13,0xE6F},
    [I(55,84)] = {13,0xEEF},
    [I(56,84)] = {13,0xF6F},
    [I(57,84)] = {13,0xFEF},
    [I(58,84)] = {14,0x2E6F},
    [I(59,84)] = {15,0x7DEF},
    [I(60,84)] = {22,0x3FFE6F},
    [I(61,84)] = {13,0x106F},
    [I(62,84)] = {19,0x7FDEF},
    [I(63,84)] = {17,0x1FE6F},
    [I(64,84)] = {20,0xFFD6F},
    [I(65,84)] = {13,0x10EF},
    [I(66,84)] = {14,0x2EEF},
    [I(67,84)] = {14,0x2F6F},
    [I(68,84)] = {14,0x2FEF},
    [I(69,84)] = {14,0x306F},
    [I(70,84)] = {14,0x30EF},
    [I(71,84)] = {14,0x316F},
    [I(72,84)] = {14,0x31EF},
    [I(73,84)] = {14,0x326F},
    [I(74,84)] = {14,0x32EF},
    [I(75,84)] = {14,0x336F},
    [I(76,84)] = {14,0x33EF},
    [I(77,84)] = {14,0x346F},
    [I(78,84)] = {14,0x34EF},
    [I(79,84)] = {14,0x356F},
    [I(80,84)] = {14,0x35EF},
    [I(81,84)] = {14,0x366F},
    [I(82,84)] = {14,0x36EF},
    [I(83,84)] = {14,0x376F},
    [I(84,84)] = {14,0x37EF},
    [I(85,84)] = {14,0x386F},
    [I(86,84)] = {14,0x38EF},
    [I(87,84)] = {14,0x396F},
    [I(88,84)] = {15,0x7E6F},
    [I(89,84)] = {14,0x39EF},
    [I(90,84)] = {15,0x7EEF},
    [I(91,84)] = {20,0xFFDEF},
    [I(92,84)] = {26,0x3FFF86F},
    [I(93,84)] = {20,0xFFE6F},
    [I(94,84)] = {21,0x1FFE6F},
    [I(95,84)] = {13,0x116F},
    [I(96,84)] = {22,0x3FFEEF},
    [I(97,84)] = {12,0x1EF},
    [I(98,84)] = {13,0x11EF},
    [I(99,84)] = {12,0x26F},
    [I(100,84)] = {13,0x126F},
    [I(101,84)] = {12,0x2EF},
    [I(102,84)] = {13,0x12EF},
    [I(103,84)] = {13,0x136F},
    [I(104,84)] = {13,0x13EF},
    [I(105,84)] = {12,0x36F},
    [I(106,84)] = {14,0x3A6F},
    [I(107,84)] = {14,0x3AEF},
    [I(108,84)] = {13,0x146F},
    [I(109,84)] = {13,0x14EF},
    [I(110,84)] = {13,0x156F},
    [I(111,84)] = {12,0x3EF},
    [I(112,84)] = {13,0x15EF},
    [I(113,84)] = {14,0x3B6F},
    [I(114,84)] = {13,0x166F},
    [I(115,84)] = {12,0x46F},
    [I(116,84)] = {12,0x4EF},
    [I(117,84)] = {13,0x16EF},
    [I(118,84)] = {14,0x3BEF},
    [I(119,84)] = {14,0x3C6F},
    [I(120,84)] = {14,0x3CEF},
    [I(121,84)] = {14,0x3D6F},
    [I(122,84)] = {14,0x3DEF},
    [I(123,84)] = {22,0x3FFF6F},
    [I(124,84)] = {18,0x3FE6F},
    [I(125,84)] = {21,0x1FFEEF},
    [I(126,84)] = {20,0xFFEEF},
    [I(127,84)] = {64,0},
    [I(128,84)] = {27,0x7FFF36F},
    [I(129,84)] = {29,0x1FFFE96F},
    [I(130,84)] = {27,0x7FFF3EF},
    [I(131,84)] = {27,0x7FFF46F},
    [I(132,84)] = {29,0x1FFFE9EF},
    [I(133,84)] = {29,0x1FFFEA6F},
    [I(134,84)] = {29,0x1FFFEAEF},
    [I(135,84)] = {30,0x3FFFECEF},
    [I(136,84)] = {29,0x1FFFEB6F},
    [I(137,84)] = {30,0x3FFFED6F},
    [I(138,84)] = {30,0x3FFFEDEF},
    [I(139,84)] = {30,0x3FFFEE6F},
    [I(140,84)] = {30,0x3FFFEEEF},
    [I(141,84)] = {30,0x3FFFEF6F},
    [I(142,84)] = {31,0x7FFFF5EF},
    [I(143,84)] = {30,0x3FFFEFEF},
    [I(144,84)] = {31,0x7FFFF66F},
    [I(145,84)] = {31,0x7FFFF6EF},
    [I(146,84)] = {29,0x1FFFEBEF},
    [I(147,84)] = {30,0x3FFFF06F},
    [I(148,84)] = {31,0x7FFFF76F},
    [I(149,84)] = {30,0x3FFFF0EF},
    [I(150,84)] = {30,0x3FFFF16F},
    [I(151,84)] = {30,0x3FFFF1EF},
    [I(152,84)] = {30,0x3FFFF26F},
    [I(153,84)] = {28,0xFFFEE6F},
    [I(154,84)] = {29,0x1FFFEC6F},
    [I(155,84)] = {30,0x3FFFF2EF},
    [I(156,84)] = {29,0x1FFFECEF},
    [I(157,84)] = {30,0x3FFFF36F},
    [I(158,84)] = {30,0x3FFFF3EF},
    [I(159,84)] = {31,0x7FFFF7EF},
    [I(160,84)] = {29,0x1FFFED6F},
    [I(161,84)] = {28,0xFFFEEEF},
    [I(162,84)] = {27,0x7FFF4EF},
    [I(163,84)] = {29,0x1FFFEDEF},
    [I(164,84)] = {29,0x1FFFEE6F},
    [I(165,84)] = {30,0x3FFFF46F},
    [I(166,84)] = {30,0x3FFFF4EF},
    [I(167,84)] = {28,0xFFFEF6F},
    [I(168,84)] = {30,0x3FFFF56F},
    [I(169,84)] = {29,0x1FFFEEEF},
    [I(170,84)] = {29,0x1FFFEF6F},
    [I(171,84)] = {31,0x7FFFF86F},
    [I(172,84)] = {28,0xFFFEFEF},
    [I(173,84)] = {29,0x1FFFEFEF},
    [I(174,84)] = {30,0x3FFFF5EF},
    [I(175,84)] = {30,0x3FFFF66F},
    [I(176,84)] = {28,0xFFFF06F},
    [I(177,84)] = {28,0xFFFF0EF},
    [I(178,84)] = {29,0x1FFFF06F},
    [I(179,84)] = {28,0xFFFF16F},
    [I(180,84)] = {30,0x3FFFF6EF},
    [I(181,84)] = {29,0x1FFFF0EF},
    [I(182,84)] = {30,0x3FFFF76F},
    [I(183,84)] = {30,0x3FFFF7EF},
    [I(184,84)] = {27,0x7FFF56F},
    [I(185,84)] = {29,0x1FFFF16F},
    [I(186,84)] = {29,0x1FFFF1EF},
    [I(187,84)] = {29,0x1FFFF26F},
    [I(188,84)] = {30,0x3FFFF86F},
    [I(189,84)] = {29,0x1FFFF2EF},
    [I(190,84)] = {29,0x1FFFF36F},
    [I(191,84)] = {30,0x3FFFF8EF},
    [I(192,84)] = {64,0},
    [I(193,84)] = {64,0},
    [I(194,84)] = {27,0x7FFF5EF},
    [I(195,84)] = {26,0x3FFF8EF},
    [I(196,84)] = {29,0x1FFFF3EF},
    [I(197,84)] = {30,0x3FFFF96F},
    [I(198,84)] = {29,0x1FFFF46F},
    [I(199,84)] = {X32,0xFFFFF66F},
    [I(200,84)] = {64,0},
    [I(201,84)] = {64,0},
    [I(202,84)] = {64,0},
    [I(203,84)] = {64,0},
    [I(204,84)] = {64,0},
    [I(205,84)] = {64,0},
    [I(206,84)] = {31,0x7FFFF8EF},
    [I(207,84)] = {X32,0xFFFFF6EF},
    [I(208,84)] = {26,0x3FFF96F},
    [I(209,84)] = {28,0xFFFF1EF},
    [I(210,84)] = {64,0},
    [I(211,84)] = {64,0},
    [I(212,84)] = {64,0},
    [I(213,84)] = {64,0},
    [I(214,84)] = {64,0},
    [I(215,84)] = {31,0x7FFFF96F},
    [I(216,84)] = {28,0xFFFF26F},
    [I(217,84)] = {28,0xFFFF2EF},
    [I(218,84)] = {64,0},
    [I(219,84)] = {64,0},
    [I(220,84)] = {64,0},
    [I(221,84)] = {64,0},
    [I(222,84)] = {64,0},
    [I(223,84)] = {64,0},
    [I(224,84)] = {27,0x7FFF66F},
    [I(225,84)] = {31,0x7FFFF9EF},
    [I(226,84)] = {27,0x7FFF6EF},
    [I(227,84)] = {28,0xFFFF36F},
    [I(228,84)] = {29,0x1FFFF4EF},
    [I(229,84)] = {28,0xFFFF3EF},
    [I(230,84)] = {28,0xFFFF46F},
    [I(231,84)] = {30,0x3FFFF9EF},
    [I(232,84)] = {29,0x1FFFF56F},
    [I(233,84)] = {29,0x1FFFF5EF},
    [I(234,84)] = {X32,0xFFFFF76F},
    [I(235,84)] = {X32,0xFFFFF7EF},
    [I(236,84)] = {31,0x7FFFFA6F},
    [I(237,84)] = {31,0x7FFFFAEF},
    [I(238,84)] = {64,0},
    [I(239,84)] = {30,0x3FFFFA6F},
    [I(240,84)] = {64,0},
    [I(241,84)] = {64,0},
    [I(242,84)] = {64,0},
    [I(243,84)] = {64,0},
    [I(244,84)] = {64,0},
    [I(245,84)] = {64,0},
    [I(246,84)] = {64,0},
    [I(247,84)] = {64,0},
    [I(248,84)] = {64,0},
    [I(249,84)] = {64,0},
    [I(250,84)] = {64,0},
    [I(251,84)] = {64,0},
    [I(252,84)] = {64,0},
    [I(253,84)] = {64,0},
    [I(254,84)] = {64,0},
    [I(255,84)] = {64,0},
    [I(0,85)] = {20,0xFFC70},
    [I(1,85)] = {30,0x3FFFEC70},
    [I(2,85)] = {64,0},
    [I(3,85)] = {64,0},
    [I(4,85)] = {64,0},
    [I(5,85)] = {64,0},
    [I(6,85)] = {64,0},
    [I(7,85)] = {64,0},
    [I(8,85)] = {64,0},
    [I(9,85)] = {31,0x7FFFF570},
    [I(10,85)] = {64,0},
    [I(11,85)] = {64,0},
    [I(12,85)] = {64,0},
    [I(13,85)] = {64,0},
    [I(14,85)] = {64,0},
    [I(15,85)] = {64,0},
    [I(16,85)] = {64,0},
    [I(17,85)] = {64,0},
    [I(18,85)] = {64,0},
    [I(19,85)] = {64,0},
    [I(20,85)] = {64,0},
    [I(21,85)] = {64,0},
    [I(22,85)] = {64,0},
    [I(23,85)] = {64,0},
    [I(24,85)] = {64,0},
    [I(25,85)] = {64,0},
    [I(26,85)] = {64,0},
    [I(27,85)] = {64,0},
    [I(28,85)] = {64,0},
    [I(29,85)] = {64,0},
    [I(30,85)] = {64,0},
    [I(31,85)] = {64,0},
    [I(32,85)] = {13,0xA70},
    [I(33,85)] = {17,0x1FC70},
    [I(34,85)] = {17,0x1FCF0},
    [I(35,85)] = {19,0x7FD70},
    [I(36,85)] = {20,0xFFCF0},
    [I(37,85)] = {13,0xAF0},
    [I(38,85)] = {15,0x7C70},
    [I(39,85)] = {18,0x3FD70},
    [I(40,85)] = {17,0x1FD70},
    [I(41,85)] = {17,0x1FDF0},
    [I(42,85)] = {15,0x7CF0},
    [I(43,85)] = {18,0x3FDF0},
    [I(44,85)] = {15,0x7D70},
    [I(45,85)] = {13,0xB70},
    [I(46,85)] = {13,0xBF0},
    [I(47,85)] = {13,0xC70},
    [I(48,85)] = {12,0x70},
    [I(49,85)] = {12,0xF0},
    [I(50,85)] = {12,0x170},
    [I(51,85)] = {13,0xCF0},
    [I(52,85)] = {13,0xD70},
    [I(53,85)] = {13,0xDF0},
    [I(54,85)] = {13,0xE70},
    [I(55,85)] = {13,0xEF0},
    [I(56,85)] = {13,0xF70},
    [I(57,85)] = {13,0xFF0},
    [I(58,85)] = {14,0x2E70},
    [I(59,85)] = {15,0x7DF0},
    [I(60,85)] = {22,0x3FFE70},
    [I(61,85)] = {13,0x1070},
    [I(62,85)] = {19,0x7FDF0},
    [I(63,85)] = {17,0x1FE70},
    [I(64,85)] = {20,0xFFD70},
    [I(65,85)] = {13,0x10F0},
    [I(66,85)] = {14,0x2EF0},
    [I(67,85)] = {14,0x2F70},
    [I(68,85)] = {14,0x2FF0},
    [I(69,85)] = {14,0x3070},
    [I(70,85)] = {14,0x30F0},
    [I(71,85)] = {14,0x3170},
    [I(72,85)] = {14,0x31F0},
    [I(73,85)] = {14,0x3270},
    [I(74,85)] = {14,0x32F0},
    [I(75,85)] = {14,0x3370},
    [I(76,85)] = {14,0x33F0},
    [I(77,85)] = {14,0x3470},
    [I(78,85)] = {14,0x34F0},
    [I(79,85)] = {14,0x3570},
    [I(80,85)] = {14,0x35F0},
    [I(81,85)] = {14,0x3670},
    [I(82,85)] = {14,0x36F0},
    [I(83,85)] = {14,0x3770},
    [I(84,85)] = {14,0x37F0},
    [I(85,85)] = {14,0x3870},
    [I(86,85)] = {14,0x38F0},
    [I(87,85)] = {14,0x3970},
    [I(88,85)] = {15,0x7E70},
    [I(89,85)] = {14,0x39F0},
    [I(90,85)] = {15,0x7EF0},
    [I(91,85)] = {20,0xFFDF0},
    [I(92,85)] = {26,0x3FFF870},
    [I(93,85)] = {20,0xFFE70},
    [I(94,85)] = {21,0x1FFE70},
    [I(95,85)] = {13,0x1170},
    [I(96,85)] = {22,0x3FFEF0},
    [I(97,85)] = {12,0x1F0},
    [I(98,85)] = {13,0x11F0},
    [I(99,85)] = {12,0x270},
    [I(100,85)] = {13,0x1270},
    [I(101,85)] = {12,0x2F0},
    [I(102,85)] = {13,0x12F0},
    [I(103,85)] = {13,0x1370},
    [I(104,85)] = {13,0x13F0},
    [I(105,85)] = {12,0x370},
    [I(106,85)] = {14,0x3A70},
    [I(107,85)] = {14,0x3AF0},
    [I(108,85)] = {13,0x1470},
    [I(109,85)] = {13,0x14F0},
    [I(110,85)] = {13,0x1570},
    [I(111,85)] = {12,0x3F0},
    [I(112,85)] = {13,0x15F0},
    [I(113,85)] = {14,0x3B70},
    [I(114,85)] = {13,0x1670},
    [I(115,85)] = {12,0x470},
    [I(116,85)] = {12,0x4F0},
    [I(117,85)] = {13,0x16F0},
    [I(118,85)] = {14,0x3BF0},
    [I(119,85)] = {14,0x3C70},
    [I(120,85)] = {14,0x3CF0},
    [I(121,85)] = {14,0x3D70},
    [I(122,85)] = {14,0x3DF0},
    [I(123,85)] = {22,0x3FFF70},
    [I(124,85)] = {18,0x3FE70},
    [I(125,85)] = {21,0x1FFEF0},
    [I(126,85)] = {20,0xFFEF0},
    [I(127,85)] = {64,0},
    [I(128,85)] = {27,0x7FFF370},
    [I(129,85)] = {29,0x1FFFE970},
    [I(130,85)] = {27,0x7FFF3F0},
    [I(131,85)] = {27,0x7FFF470},
    [I(132,85)] = {29,0x1FFFE9F0},
    [I(133,85)] = {29,0x1FFFEA70},
    [I(134,85)] = {29,0x1FFFEAF0},
    [I(135,85)] = {30,0x3FFFECF0},
    [I(136,85)] = {29,0x1FFFEB70},
    [I(137,85)] = {30,0x3FFFED70},
    [I(138,85)] = {30,0x3FFFEDF0},
    [I(139,85)] = {30,0x3FFFEE70},
    [I(140,85)] = {30,0x3FFFEEF0},
    [I(141,85)] = {30,0x3FFFEF70},
    [I(142,85)] = {31,0x7FFFF5F0},
    [I(143,85)] = {30,0x3FFFEFF0},
    [I(144,85)] = {31,0x7FFFF670},
    [I(145,85)] = {31,0x7FFFF6F0},
    [I(146,85)] = {29,0x1FFFEBF0},
    [I(147,85)] = {30,0x3FFFF070},
    [I(148,85)] = {31,0x7FFFF770},
    [I(149,85)] = {30,0x3FFFF0F0},
    [I(150,85)] = {30,0x3FFFF170},
    [I(151,85)] = {30,0x3FFFF1F0},
    [I(152,85)] = {30,0x3FFFF270},
    [I(153,85)] = {28,0xFFFEE70},
    [I(154,85)] = {29,0x1FFFEC70},
    [I(155,85)] = {30,0x3FFFF2F0},
    [I(156,85)] = {29,0x1FFFECF0},
    [I(157,85)] = {30,0x3FFFF370},
    [I(158,85)] = {30,0x3FFFF3F0},
    [I(159,85)] = {31,0x7FFFF7F0},
    [I(160,85)] = {29,0x1FFFED70},
    [I(161,85)] = {28,0xFFFEEF0},
    [I(162,85)] = {27,0x7FFF4F0},
    [I(163,85)] = {29,0x1FFFEDF0},
    [I(164,85)] = {29,0x1FFFEE70},
    [I(165,85)] = {30,0x3FFFF470},
    [I(166,85)] = {30,0x3FFFF4F0},
    [I(167,85)] = {28,0xFFFEF70},
    [I(168,85)] = {30,0x3FFFF570},
    [I(169,85)] = {29,0x1FFFEEF0},
    [I(170,85)] = {29,0x1FFFEF70},
    [I(171,85)] = {31,0x7FFFF870},
    [I(172,85)] = {28,0xFFFEFF0},
    [I(173,85)] = {29,0x1FFFEFF0},
    [I(174,85)] = {30,0x3FFFF5F0},
    [I(175,85)] = {30,0x3FFFF670},
    [I(176,85)] = {28,0xFFFF070},
    [I(177,85)] = {28,0xFFFF0F0},
    [I(178,85)] = {29,0x1FFFF070},
    [I(179,85)] = {28,0xFFFF170},
    [I(180,85)] = {30,0x3FFFF6F0},
    [I(181,85)] = {29,0x1FFFF0F0},
    [I(182,85)] = {30,0x3FFFF770},
    [I(183,85)] = {30,0x3FFFF7F0},
    [I(184,85)] = {27,0x7FFF570},
    [I(185,85)] = {29,0x1FFFF170},
    [I(186,85)] = {29,0x1FFFF1F0},
    [I(187,85)] = {29,0x1FFFF270},
    [I(188,85)] = {30,0x3FFFF870},
    [I(189,85)] = {29,0x1FFFF2F0},
    [I(190,85)] = {29,0x1FFFF370},
    [I(191,85)] = {30,0x3FFFF8F0},
    [I(192,85)] = {64,0},
    [I(193,85)] = {64,0},
    [I(194,85)] = {27,0x7FFF5F0},
    [I(195,85)] = {26,0x3FFF8F0},
    [I(196,85)] = {29,0x1FFFF3F0},
    [I(197,85)] = {30,0x3FFFF970},
    [I(198,85)] = {29,0x1FFFF470},
    [I(199,85)] = {X32,0xFFFFF670},
    [I(200,85)] = {64,0},
    [I(201,85)] = {64,0},
    [I(202,85)] = {64,0},
    [I(203,85)] = {64,0},
    [I(204,85)] = {64,0},
    [I(205,85)] = {64,0},
    [I(206,85)] = {31,0x7FFFF8F0},
    [I(207,85)] = {X32,0xFFFFF6F0},
    [I(208,85)] = {26,0x3FFF970},
    [I(209,85)] = {28,0xFFFF1F0},
    [I(210,85)] = {64,0},
    [I(211,85)] = {64,0},
    [I(212,85)] = {64,0},
    [I(213,85)] = {64,0},
    [I(214,85)] = {64,0},
    [I(215,85)] = {31,0x7FFFF970},
    [I(216,85)] = {28,0xFFFF270},
    [I(217,85)] = {28,0xFFFF2F0},
    [I(218,85)] = {64,0},
    [I(219,85)] = {64,0},
    [I(220,85)] = {64,0},
    [I(221,85)] = {64,0},
    [I(222,85)] = {64,0},
    [I(223,85)] = {64,0},
    [I(224,85)] = {27,0x7FFF670},
    [I(225,85)] = {31,0x7FFFF9F0},
    [I(226,85)] = {27,0x7FFF6F0},
    [I(227,85)] = {28,0xFFFF370},
    [I(228,85)] = {29,0x1FFFF4F0},
    [I(229,85)] = {28,0xFFFF3F0},
    [I(230,85)] = {28,0xFFFF470},
    [I(231,85)] = {30,0x3FFFF9F0},
    [I(232,85)] = {29,0x1FFFF570},
    [I(233,85)] = {29,0x1FFFF5F0},
    [I(234,85)] = {X32,0xFFFFF770},
    [I(235,85)] = {X32,0xFFFFF7F0},
    [I(236,85)] = {31,0x7FFFFA70},
    [I(237,85)] = {31,0x7FFFFAF0},
    [I(238,85)] = {64,0},
    [I(239,85)] = {30,0x3FFFFA70},
    [I(240,85)] = {64,0},
    [I(241,85)] = {64,0},
    [I(242,85)] = {64,0},
    [I(243,85)] = {64,0},
    [I(244,85)] = {64,0},
    [I(245,85)] = {64,0},
    [I(246,85)] = {64,0},
    [I(247,85)] = {64,0},
    [I(248,85)] = {64,0},
    [I(249,85)] = {64,0},
    [I(250,85)] = {64,0},
    [I(251,85)] = {64,0},
    [I(252,85)] = {64,0},
    [I(253,85)] = {64,0},
    [I(254,85)] = {64,0},
    [I(255,85)] = {64,0},
    [I(0,86)] = {20,0xFFC71},
    [I(1,86)] = {30,0x3FFFEC71},
    [I(2,86)] = {64,0},
    [I(3,86)] = {64,0},
    [I(4,86)] = {64,0},
    [I(5,86)] = {64,0},
    [I(6,86)] = {64,0},
    [I(7,86)] = {64,0},
    [I(8,86)] = {64,0},
    [I(9,86)] = {31,0x7FFFF571},
    [I(10,86)] = {64,0},
    [I(11,86)] = {64,0},
    [I(12,86)] = {64,0},
    [I(13,86)] = {64,0},
    [I(14,86)] = {64,0},
    [I(15,86)] = {64,0},
    [I(16,86)] = {64,0},
    [I(17,86)] = {64,0},
    [I(18,86)] = {64,0},
    [I(19,86)] = {64,0},
    [I(20,86)] = {64,0},
    [I(21,86)] = {64,0},
    [I(22,86)] = {64,0},
    [I(23,86)] = {64,0},
    [I(24,86)] = {64,0},
    [I(25,86)] = {64,0},
    [I(26,86)] = {64,0},
    [I(27,86)] = {64,0},
    [I(28,86)] = {64,0},
    [I(29,86)] = {64,0},
    [I(30,86)] = {64,0},
    [I(31,86)] = {64,0},
    [I(32,86)] = {13,0xA71},
    [I(33,86)] = {17,0x1FC71},
    [I(34,86)] = {17,0x1FCF1},
    [I(35,86)] = {19,0x7FD71},
    [I(36,86)] = {20,0xFFCF1},
    [I(37,86)] = {13,0xAF1},
    [I(38,86)] = {15,0x7C71},
    [I(39,86)] = {18,0x3FD71},
    [I(40,86)] = {17,0x1FD71},
    [I(41,86)] = {17,0x1FDF1},
    [I(42,86)] = {15,0x7CF1},
    [I(43,86)] = {18,0x3FDF1},
    [I(44,86)] = {15,0x7D71},
    [I(45,86)] = {13,0xB71},
    [I(46,86)] = {13,0xBF1},
    [I(47,86)] = {13,0xC71},
    [I(48,86)] = {12,0x71},
    [I(49,86)] = {12,0xF1},
    [I(50,86)] = {12,0x171},
    [I(51,86)] = {13,0xCF1},
    [I(52,86)] = {13,0xD71},
    [I(53,86)] = {13,0xDF1},
    [I(54,86)] = {13,0xE71},
    [I(55,86)] = {13,0xEF1},
    [I(56,86)] = {13,0xF71},
    [I(57,86)] = {13,0xFF1},
    [I(58,86)] = {14,0x2E71},
    [I(59,86)] = {15,0x7DF1},
    [I(60,86)] = {22,0x3FFE71},
    [I(61,86)] = {13,0x1071},
    [I(62,86)] = {19,0x7FDF1},
    [I(63,86)] = {17,0x1FE71},
    [I(64,86)] = {20,0xFFD71},
    [I(65,86)] = {13,0x10F1},
    [I(66,86)] = {14,0x2EF1},
    [I(67,86)] = {14,0x2F71},
    [I(68,86)] = {14,0x2FF1},
    [I(69,86)] = {14,0x3071},
    [I(70,86)] = {14,0x30F1},
    [I(71,86)] = {14,0x3171},
    [I(72,86)] = {14,0x31F1},
    [I(73,86)] = {14,0x3271},
    [I(74,86)] = {14,0x32F1},
    [I(75,86)] = {14,0x3371},
    [I(76,86)] = {14,0x33F1},
    [I(77,86)] = {14,0x3471},
    [I(78,86)] = {14,0x34F1},
    [I(79,86)] = {14,0x3571},
    [I(80,86)] = {14,0x35F1},
    [I(81,86)] = {14,0x3671},
    [I(82,86)] = {14,0x36F1},
    [I(83,86)] = {14,0x3771},
    [I(84,86)] = {14,0x37F1},
    [I(85,86)] = {14,0x3871},
    [I(86,86)] = {14,0x38F1},
    [I(87,86)] = {14,0x3971},
    [I(88,86)] = {15,0x7E71},
    [I(89,86)] = {14,0x39F1},
    [I(90,86)] = {15,0x7EF1},
    [I(91,86)] = {20,0xFFDF1},
    [I(92,86)] = {26,0x3FFF871},
    [I(93,86)] = {20,0xFFE71},
    [I(94,86)] = {21,0x1FFE71},
    [I(95,86)] = {13,0x1171},
    [I(96,86)] = {22,0x3FFEF1},
    [I(97,86)] = {12,0x1F1},
    [I(98,86)] = {13,0x11F1},
    [I(99,86)] = {12,0x271},
    [I(100,86)] = {13,0x1271},
    [I(101,86)] = {12,0x2F1},
    [I(102,86)] = {13,0x12F1},
    [I(103,86)] = {13,0x1371},
    [I(104,86)] = {13,0x13F1},
    [I(105,86)] = {12,0x371},
    [I(106,86)] = {14,0x3A71},
    [I(107,86)] = {14,0x3AF1},
    [I(108,86)] = {13,0x1471},
    [I(109,86)] = {13,0x14F1},
    [I(110,86)] = {13,0x1571},
    [I(111,86)] = {12,0x3F1},
    [I(112,86)] = {13,0x15F1},
    [I(113,86)] = {14,0x3B71},
    [I(114,86)] = {13,0x1671},
    [I(115,86)] = {12,0x471},
    [I(116,86)] = {12,0x4F1},
    [I(117,86)] = {13,0x16F1},
    [I(118,86)] = {14,0x3BF1},
    [I(119,86)] = {14,0x3C71},
    [I(120,86)] = {14,0x3CF1},
    [I(121,86)] = {14,0x3D71},
    [I(122,86)] = {14,0x3DF1},
    [I(123,86)] = {22,0x3FFF71},
    [I(124,86)] = {18,0x3FE71},
    [I(125,86)] = {21,0x1FFEF1},
    [I(126,86)] = {20,0xFFEF1},
    [I(127,86)] = {64,0},
    [I(128,86)] = {27,0x7FFF371},
    [I(129,86)] = {29,0x1FFFE971},
    [I(130,86)] = {27,0x7FFF3F1},
    [I(131,86)] = {27,0x7FFF471},
    [I(132,86)] = {29,0x1FFFE9F1},
    [I(133,86)] = {29,0x1FFFEA71},
    [I(134,86)] = {29,0x1FFFEAF1},
    [I(135,86)] = {30,0x3FFFECF1},
    [I(136,86)] = {29,0x1FFFEB71},
    [I(137,86)] = {30,0x3FFFED71},
    [I(138,86)] = {30,0x3FFFEDF1},
    [I(139,86)] = {30,0x3FFFEE71},
    [I(140,86)] = {30,0x3FFFEEF1},
    [I(141,86)] = {30,0x3FFFEF71},
    [I(142,86)] = {31,0x7FFFF5F1},
    [I(143,86)] = {30,0x3FFFEFF1},
    [I(144,86)] = {31,0x7FFFF671},
    [I(145,86)] = {31,0x7FFFF6F1},
    [I(146,86)] = {29,0x1FFFEBF1},
    [I(147,86)] = {30,0x3FFFF071},
    [I(148,86)] = {31,0x7FFFF771},
    [I(149,86)] = {30,0x3FFFF0F1},
    [I(150,86)] = {30,0x3FFFF171},
    [I(151,86)] = {30,0x3FFFF1F1},
    [I(152,86)] = {30,0x3FFFF271},
    [I(153,86)] = {28,0xFFFEE71},
    [I(154,86)] = {29,0x1FFFEC71},
    [I(155,86)] = {30,0x3FFFF2F1},
    [I(156,86)] = {29,0x1FFFECF1},
    [I(157,86)] = {30,0x3FFFF371},
    [I(158,86)] = {30,0x3FFFF3F1},
    [I(159,86)] = {31,0x7FFFF7F1},
    [I(160,86)] = {29,0x1FFFED71},
    [I(161,86)] = {28,0xFFFEEF1},
    [I(162,86)] = {27,0x7FFF4F1},
    [I(163,86)] = {29,0x1FFFEDF1},
    [I(164,86)] = {29,0x1FFFEE71},
    [I(165,86)] = {30,0x3FFFF471},
    [I(166,86)] = {30,0x3FFFF4F1},
    [I(167,86)] = {28,0xFFFEF71},
    [I(168,86)] = {30,0x3FFFF571},
    [I(169,86)] = {29,0x1FFFEEF1},
    [I(170,86)] = {29,0x1FFFEF71},
    [I(171,86)] = {31,0x7FFFF871},
    [I(172,86)] = {28,0xFFFEFF1},
    [I(173,86)] = {29,0x1FFFEFF1},
    [I(174,86)] = {30,0x3FFFF5F1},
    [I(175,86)] = {30,0x3FFFF671},
    [I(176,86)] = {28,0xFFFF071},
    [I(177,86)] = {28,0xFFFF0F1},
    [I(178,86)] = {29,0x1FFFF071},
    [I(179,86)] = {28,0xFFFF171},
    [I(180,86)] = {30,0x3FFFF6F1},
    [I(181,86)] = {29,0x1FFFF0F1},
    [I(182,86)] = {30,0x3FFFF771},
    [I(183,86)] = {30,0x3FFFF7F1},
    [I(184,86)] = {27,0x7FFF571},
    [I(185,86)] = {29,0x1FFFF171},
    [I(186,86)] = {29,0x1FFFF1F1},
    [I(187,86)] = {29,0x1FFFF271},
    [I(188,86)] = {30,0x3FFFF871},
    [I(189,86)] = {29,0x1FFFF2F1},
    [I(190,86)] = {29,0x1FFFF371},
    [I(191,86)] = {30,0x3FFFF8F1},
    [I(192,86)] = {64,0},
    [I(193,86)] = {64,0},
    [I(194,86)] = {27,0x7FFF5F1},
    [I(195,86)] = {26,0x3FFF8F1},
    [I(196,86)] = {29,0x1FFFF3F1},
    [I(197,86)] = {30,0x3FFFF971},
    [I(198,86)] = {29,0x1FFFF471},
    [I(199,86)] = {X32,0xFFFFF671},
    [I(200,86)] = {64,0},
    [I(201,86)] = {64,0},
    [I(202,86)] = {64,0},
    [I(203,86)] = {64,0},
    [I(204,86)] = {64,0},
    [I(205,86)] = {64,0},
    [I(206,86)] = {31,0x7FFFF8F1},
    [I(207,86)] = {X32,0xFFFFF6F1},
    [I(208,86)] = {26,0x3FFF971},
    [I(209,86)] = {28,0xFFFF1F1},
    [I(210,86)] = {64,0},
    [I(211,86)] = {64,0},
    [I(212,86)] = {64,0},
    [I(213,86)] = {64,0},
    [I(214,86)] = {64,0},
    [I(215,86)] = {31,0x7FFFF971},
    [I(216,86)] = {28,0xFFFF271},
    [I(217,86)] = {28,0xFFFF2F1},
    [I(218,86)] = {64,0},
    [I(219,86)] = {64,0},
    [I(220,86)] = {64,0},
    [I(221,86)] = {64,0},
    [I(222,86)] = {64,0},
    [I(223,86)] = {64,0},
    [I(224,86)] = {27,0x7FFF671},
    [I(225,86)] = {31,0x7FFFF9F1},
    [I(226,86)] = {27,0x7FFF6F1},
    [I(227,86)] = {28,0xFFFF371},
    [I(228,86)] = {29,0x1FFFF4F1},
    [I(229,86)] = {28,0xFFFF3F1},
    [I(230,86)] = {28,0xFFFF471},
    [I(231,86)] = {30,0x3FFFF9F1},
    [I(232,86)] = {29,0x1FFFF571},
    [I(233,86)] = {29,0x1FFFF5F1},
    [I(234,86)] = {X32,0xFFFFF771},
    [I(235,86)] = {X32,0xFFFFF7F1},
    [I(236,86)] = {31,0x7FFFFA71},
    [I(237,86)] = {31,0x7FFFFAF1},
    [I(238,86)] = {64,0},
    [I(239,86)] = {30,0x3FFFFA71},
    [I(240,86)] = {64,0},
    [I(241,86)] = {64,0},
    [I(242,86)] = {64,0},
    [I(243,86)] = {64,0},
    [I(244,86)] = {64,0},
    [I(245,86)] = {64,0},
    [I(246,86)] = {64,0},
    [I(247,86)] = {64,0},
    [I(248,86)] = {64,0},
    [I(249,86)] = {64,0},
    [I(250,86)] = {64,0},
    [I(251,86)] = {64,0},
    [I(252,86)] = {64,0},
    [I(253,86)] = {64,0},
    [I(254,86)] = {64,0},
    [I(255,86)] = {64,0},
    [I(0,87)] = {20,0xFFC72},
    [I(1,87)] = {30,0x3FFFEC72},
    [I(2,87)] = {64,0},
    [I(3,87)] = {64,0},
    [I(4,87)] = {64,0},
    [I(5,87)] = {64,0},
    [I(6,87)] = {64,0},
    [I(7,87)] = {64,0},
    [I(8,87)] = {64,0},
    [I(9,87)] = {31,0x7FFFF572},
    [I(10,87)] = {64,0},
    [I(11,87)] = {64,0},
    [I(12,87)] = {64,0},
    [I(13,87)] = {64,0},
    [I(14,87)] = {64,0},
    [I(15,87)] = {64,0},
    [I(16,87)] = {64,0},
    [I(17,87)] = {64,0},
    [I(18,87)] = {64,0},
    [I(19,87)] = {64,0},
    [I(20,87)] = {64,0},
    [I(21,87)] = {64,0},
    [I(22,87)] = {64,0},
    [I(23,87)] = {64,0},
    [I(24,87)] = {64,0},
    [I(25,87)] = {64,0},
    [I(26,87)] = {64,0},
    [I(27,87)] = {64,0},
    [I(28,87)] = {64,0},
    [I(29,87)] = {64,0},
    [I(30,87)] = {64,0},
    [I(31,87)] = {64,0},
    [I(32,87)] = {13,0xA72},
    [I(33,87)] = {17,0x1FC72},
    [I(34,87)] = {17,0x1FCF2},
    [I(35,87)] = {19,0x7FD72},
    [I(36,87)] = {20,0xFFCF2},
    [I(37,87)] = {13,0xAF2},
    [I(38,87)] = {15,0x7C72},
    [I(39,87)] = {18,0x3FD72},
    [I(40,87)] = {17,0x1FD72},
    [I(41,87)] = {17,0x1FDF2},
    [I(42,87)] = {15,0x7CF2},
    [I(43,87)] = {18,0x3FDF2},
    [I(44,87)] = {15,0x7D72},
    [I(45,87)] = {13,0xB72},
    [I(46,87)] = {13,0xBF2},
    [I(47,87)] = {13,0xC72},
    [I(48,87)] = {12,0x72},
    [I(49,87)] = {12,0xF2},
    [I(50,87)] = {12,0x172},
    [I(51,87)] = {13,0xCF2},
    [I(52,87)] = {13,0xD72},
    [I(53,87)] = {13,0xDF2},
    [I(54,87)] = {13,0xE72},
    [I(55,87)] = {13,0xEF2},
    [I(56,87)] = {13,0xF72},
    [I(57,87)] = {13,0xFF2},
    [I(58,87)] = {14,0x2E72},
    [I(59,87)] = {15,0x7DF2},
    [I(60,87)] = {22,0x3FFE72},
    [I(61,87)] = {13,0x1072},
    [I(62,87)] = {19,0x7FDF2},
    [I(63,87)] = {17,0x1FE72},
    [I(64,87)] = {20,0xFFD72},
    [I(65,87)] = {13,0x10F2},
    [I(66,87)] = {14,0x2EF2},
    [I(67,87)] = {14,0x2F72},
    [I(68,87)] = {14,0x2FF2},
    [I(69,87)] = {14,0x3072},
    [I(70,87)] = {14,0x30F2},
    [I(71,87)] = {14,0x3172},
    [I(72,87)] = {14,0x31F2},
    [I(73,87)] = {14,0x3272},
    [I(74,87)] = {14,0x32F2},
    [I(75,87)] = {14,0x3372},
    [I(76,87)] = {14,0x33F2},
    [I(77,87)] = {14,0x3472},
    [I(78,87)] = {14,0x34F2},
    [I(79,87)] = {14,0x3572},
    [I(80,87)] = {14,0x35F2},
    [I(81,87)] = {14,0x3672},
    [I(82,87)] = {14,0x36F2},
    [I(83,87)] = {14,0x3772},
    [I(84,87)] = {14,0x37F2},
    [I(85,87)] = {14,0x3872},
    [I(86,87)] = {14,0x38F2},
    [I(87,87)] = {14,0x3972},
    [I(88,87)] = {15,0x7E72},
    [I(89,87)] = {14,0x39F2},
    [I(90,87)] = {15,0x7EF2},
    [I(91,87)] = {20,0xFFDF2},
    [I(92,87)] = {26,0x3FFF872},
    [I(93,87)] = {20,0xFFE72},
    [I(94,87)] = {21,0x1FFE72},
    [I(95,87)] = {13,0x1172},
    [I(96,87)] = {22,0x3FFEF2},
    [I(97,87)] = {12,0x1F2},
    [I(98,87)] = {13,0x11F2},
    [I(99,87)] = {12,0x272},
    [I(100,87)] = {13,0x1272},
    [I(101,87)] = {12,0x2F2},
    [I(102,87)] = {13,0x12F2},
    [I(103,87)] = {13,0x1372},
    [I(104,87)] = {13,0x13F2},
    [I(105,87)] = {12,0x372},
    [I(106,87)] = {14,0x3A72},
    [I(107,87)] = {14,0x3AF2},
    [I(108,87)] = {13,0x1472},
    [I(109,87)] = {13,0x14F2},
    [I(110,87)] = {13,0x1572},
    [I(111,87)] = {12,0x3F2},
    [I(112,87)] = {13,0x15F2},
    [I(113,87)] = {14,0x3B72},
    [I(114,87)] = {13,0x1672},
    [I(115,87)] = {12,0x472},
    [I(116,87)] = {12,0x4F2},
    [I(117,87)] = {13,0x16F2},
    [I(118,87)] = {14,0x3BF2},
    [I(119,87)] = {14,0x3C72},
    [I(120,87)] = {14,0x3CF2},
    [I(121,87)] = {14,0x3D72},
    [I(122,87)] = {14,0x3DF2},
    [I(123,87)] = {22,0x3FFF72},
    [I(124,87)] = {18,0x3FE72},
    [I(125,87)] = {21,0x1FFEF2},
    [I(126,87)] = {20,0xFFEF2},
    [I(127,87)] = {64,0},
    [I(128,87)] = {27,0x7FFF372},
    [I(129,87)] = {29,0x1FFFE972},
    [I(130,87)] = {27,0x7FFF3F2},
    [I(131,87)] = {27,0x7FFF472},
    [I(132,87)] = {29,0x1FFFE9F2},
    [I(133,87)] = {29,0x1FFFEA72},
    [I(134,87)] = {29,0x1FFFEAF2},
    [I(135,87)] = {30,0x3FFFECF2},
    [I(136,87)] = {29,0x1FFFEB72},
    [I(137,87)] = {30,0x3FFFED72},
    [I(138,87)] = {30,0x3FFFEDF2},
    [I(139,87)] = {30,0x3FFFEE72},
    [I(140,87)] = {30,0x3FFFEEF2},
    [I(141,87)] = {30,0x3FFFEF72},
    [I(142,87)] = {31,0x7FFFF5F2},
    [I(143,87)] = {30,0x3FFFEFF2},
    [I(144,87)] = {31,0x7FFFF672},
    [I(145,87)] = {31,0x7FFFF6F2},
    [I(146,87)] = {29,0x1FFFEBF2},
    [I(147,87)] = {30,0x3FFFF072},
    [I(148,87)] = {31,0x7FFFF772},
    [I(149,87)] = {30,0x3FFFF0F2},
    [I(150,87)] = {30,0x3FFFF172},
    [I(151,87)] = {30,0x3FFFF1F2},
    [I(152,87)] = {30,0x3FFFF272},
    [I(153,87)] = {28,0xFFFEE72},
    [I(154,87)] = {29,0x1FFFEC72},
    [I(155,87)] = {30,0x3FFFF2F2},
    [I(156,87)] = {29,0x1FFFECF2},
    [I(157,87)] = {30,0x3FFFF372},
    [I(158,87)] = {30,0x3FFFF3F2},
    [I(159,87)] = {31,0x7FFFF7F2},
    [I(160,87)] = {29,0x1FFFED72},
    [I(161,87)] = {28,0xFFFEEF2},
    [I(162,87)] = {27,0x7FFF4F2},
    [I(163,87)] = {29,0x1FFFEDF2},
    [I(164,87)] = {29,0x1FFFEE72},
    [I(165,87)] = {30,0x3FFFF472},
    [I(166,87)] = {30,0x3FFFF4F2},
    [I(167,87)] = {28,0xFFFEF72},
    [I(168,87)] = {30,0x3FFFF572},
    [I(169,87)] = {29,0x1FFFEEF2},
    [I(170,87)] = {29,0x1FFFEF72},
    [I(171,87)] = {31,0x7FFFF872},
    [I(172,87)] = {28,0xFFFEFF2},
    [I(173,87)] = {29,0x1FFFEFF2},
    [I(174,87)] = {30,0x3FFFF5F2},
    [I(175,87)] = {30,0x3FFFF672},
    [I(176,87)] = {28,0xFFFF072},
    [I(177,87)] = {28,0xFFFF0F2},
    [I(178,87)] = {29,0x1FFFF072},
    [I(179,87)] = {28,0xFFFF172},
    [I(180,87)] = {30,0x3FFFF6F2},
    [I(181,87)] = {29,0x1FFFF0F2},
    [I(182,87)] = {30,0x3FFFF772},
    [I(183,87)] = {30,0x3FFFF7F2},
    [I(184,87)] = {27,0x7FFF572},
    [I(185,87)] = {29,0x1FFFF172},
    [I(186,87)] = {29,0x1FFFF1F2},
    [I(187,87)] = {29,0x1FFFF272},
    [I(188,87)] = {30,0x3FFFF872},
    [I(189,87)] = {29,0x1FFFF2F2},
    [I(190,87)] = {29,0x1FFFF372},
    [I(191,87)] = {30,0x3FFFF8F2},
    [I(192,87)] = {64,0},
    [I(193,87)] = {64,0},
    [I(194,87)] = {27,0x7FFF5F2},
    [I(195,87)] = {26,0x3FFF8F2},
    [I(196,87)] = {29,0x1FFFF3F2},
    [I(197,87)] = {30,0x3FFFF972},
    [I(198,87)] = {29,0x1FFFF472},
    [I(199,87)] = {X32,0xFFFFF672},
    [I(200,87)] = {64,0},
    [I(201,87)] = {64,0},
    [I(202,87)] = {64,0},
    [I(203,87)] = {64,0},
    [I(204,87)] = {64,0},
    [I(205,87)] = {64,0},
    [I(206,87)] = {31,0x7FFFF8F2},
    [I(207,87)] = {X32,0xFFFFF6F2},
    [I(208,87)] = {26,0x3FFF972},
    [I(209,87)] = {28,0xFFFF1F2},
    [I(210,87)] = {64,0},
    [I(211,87)] = {64,0},
    [I(212,87)] = {64,0},
    [I(213,87)] = {64,0},
    [I(214,87)] = {64,0},
    [I(215,87)] = {31,0x7FFFF972},
    [I(216,87)] = {28,0xFFFF272},
    [I(217,87)] = {28,0xFFFF2F2},
    [I(218,87)] = {64,0},
    [I(219,87)] = {64,0},
    [I(220,87)] = {64,0},
    [I(221,87)] = {64,0},
    [I(222,87)] = {64,0},
    [I(223,87)] = {64,0},
    [I(224,87)] = {27,0x7FFF672},
    [I(225,87)] = {31,0x7FFFF9F2},
    [I(226,87)] = {27,0x7FFF6F2},
    [I(227,87)] = {28,0xFFFF372},
    [I(228,87)] = {29,0x1FFFF4F2},
    [I(229,87)] = {28,0xFFFF3F2},
    [I(230,87)] = {28,0xFFFF472},
    [I(231,87)] = {30,0x3FFFF9F2},
    [I(232,87)] = {29,0x1FFFF572},
    [I(233,87)] = {29,0x1FFFF5F2},
    [I(234,87)] = {X32,0xFFFFF772},
    [I(235,87)] = {X32,0xFFFFF7F2},
    [I(236,87)] = {31,0x7FFFFA72},
    [I(237,87)] = {31,0x7FFFFAF2},
    [I(238,87)] = {64,0},
    [I(239,87)] = {30,0x3FFFFA72},
    [I(240,87)] = {64,0},
    [I(241,87)] = {64,0},
    [I(242,87)] = {64,0},
    [I(243,87)] = {64,0},
    [I(244,87)] = {64,0},
    [I(245,87)] = {64,0},
    [I(246,87)] = {64,0},
    [I(247,87)] = {64,0},
    [I(248,87)] = {64,0},
    [I(249,87)] = {64,0},
    [I(250,87)] = {64,0},
    [I(251,87)] = {64,0},
    [I(252,87)] = {64,0},
    [I(253,87)] = {64,0},
    [I(254,87)] = {64,0},
    [I(255,87)] = {64,0},
    [I(0,88)] = {21,0x1FF8FC},
    [I(1,88)] = {31,0x7FFFD8FC},
    [I(2,88)] = {64,0},
    [I(3,88)] = {64,0},
    [I(4,88)] = {64,0},
    [I(5,88)] = {64,0},
    [I(6,88)] = {64,0},
    [I(7,88)] = {64,0},
    [I(8,88)] = {64,0},
    [I(9,88)] = {X32,0xFFFFEAFC},
    [I(10,88)] = {64,0},
    [I(11,88)] = {64,0},
    [I(12,88)] = {64,0},
    [I(13,88)] = {64,0},
    [I(14,88)] = {64,0},
    [I(15,88)] = {64,0},
    [I(16,88)] = {64,0},
    [I(17,88)] = {64,0},
    [I(18,88)] = {64,0},
    [I(19,88)] = {64,0},
    [I(20,88)] = {64,0},
    [I(21,88)] = {64,0},
    [I(22,88)] = {64,0},
    [I(23,88)] = {64,0},
    [I(24,88)] = {64,0},
    [I(25,88)] = {64,0},
    [I(26,88)] = {64,0},
    [I(27,88)] = {64,0},
    [I(28,88)] = {64,0},
    [I(29,88)] = {64,0},
    [I(30,88)] = {64,0},
    [I(31,88)] = {64,0},
    [I(32,88)] = {14,0x14FC},
    [I(33,88)] = {18,0x3F8FC},
    [I(34,88)] = {18,0x3F9FC},
    [I(35,88)] = {20,0xFFAFC},
    [I(36,88)] = {21,0x1FF9FC},
    [I(37,88)] = {14,0x15FC},
    [I(38,88)] = {16,0xF8FC},
    [I(39,88)] = {19,0x7FAFC},
    [I(40,88)] = {18,0x3FAFC},
    [I(41,88)] = {18,0x3FBFC},
    [I(42,88)] = {16,0xF9FC},
    [I(43,88)] = {19,0x7FBFC},
    [I(44,88)] = {16,0xFAFC},
    [I(45,88)] = {14,0x16FC},
    [I(46,88)] = {14,0x17FC},
    [I(47,88)] = {14,0x18FC},
    [I(48,88)] = {13,0xFC},
    [I(49,88)] = {13,0x1FC},
    [I(50,88)] = {13,0x2FC},
    [I(51,88)] = {14,0x19FC},
    [I(52,88)] = {14,0x1AFC},
    [I(53,88)] = {14,0x1BFC},
    [I(54,88)] = {14,0x1CFC},
    [I(55,88)] = {14,0x1DFC},
    [I(56,88)] = {14,0x1EFC},
    [I(57,88)] = {14,0x1FFC},
    [I(58,88)] = {15,0x5CFC},
    [I(59,88)] = {16,0xFBFC},
    [I(60,88)] = {23,0x7FFCFC},
    [I(61,88)] = {14,0x20FC},
    [I(62,88)] = {20,0xFFBFC},
    [I(63,88)] = {18,0x3FCFC},
    [I(64,88)] = {21,0x1FFAFC},
    [I(65,88)] = {14,0x21FC},
    [I(66,88)] = {15,0x5DFC},
    [I(67,88)] = {15,0x5EFC},
    [I(68,88)] = {15,0x5FFC},
    [I(69,88)] = {15,0x60FC},
    [I(70,88)] = {15,0x61FC},
    [I(71,88)] = {15,0x62FC},
    [I(72,88)] = {15,0x63FC},
    [I(73,88)] = {15,0x64FC},
    [I(74,88)] = {15,0x65FC},
    [I(75,88)] = {15,0x66FC},
    [I(76,88)] = {15,0x67FC},
    [I(77,88)] = {15,0x68FC},
    [I(78,88)] = {15,0x69FC},
    [I(79,88)] = {15,0x6AFC},
    [I(80,88)] = {15,0x6BFC},
    [I(81,88)] = {15,0x6CFC},
    [I(82,88)] = {15,0x6DFC},
    [I(83,88)] = {15,0x6EFC},
    [I(84,88)] = {15,0x6FFC},
    [I(85,88)] = {15,0x70FC},
    [I(86,88)] = {15,0x71FC},
    [I(87,88)] = {15,0x72FC},
    [I(88,88)] = {16,0xFCFC},
    [I(89,88)] = {15,0x73FC},
    [I(90,88)] = {16,0xFDFC},
    [I(91,88)] = {21,0x1FFBFC},
    [I(92,88)] = {27,0x7FFF0FC},
    [I(93,88)] = {21,0x1FFCFC},
    [I(94,88)] = {22,0x3FFCFC},
    [I(95,88)] = {14,0x22FC},
    [I(96,88)] = {23,0x7FFDFC},
    [I(97,88)] = {13,0x3FC},
    [I(98,88)] = {14,0x23FC},
    [I(99,88)] = {13,0x4FC},
    [I(100,88)] = {14,0x24FC},
    [I(101,88)] = {13,0x5FC},
    [I(102,88)] = {14,0x25FC},
    [I(103,88)] = {14,0x26FC},
    [I(104,88)] = {14,0x27FC},
    [I(105,88)] = {13,0x6FC},
    [I(106,88)] = {15,0x74FC},
    [I(107,88)] = {15,0x75FC},
    [I(108,88)] = {14,0x28FC},
    [I(109,88)] = {14,0x29FC},
    [I(110,88)] = {14,0x2AFC},
    [I(111,88)] = {13,0x7FC},
    [I(112,88)] = {14,0x2BFC},
    [I(113,88)] = {15,0x76FC},
    [I(114,88)] = {14,0x2CFC},
    [I(115,88)] = {13,0x8FC},
    [I(116,88)] = {13,0x9FC},
    [I(117,88)] = {14,0x2DFC},
    [I(118,88)] = {15,0x77FC},
    [I(119,88)] = {15,0x78FC},
    [I(120,88)] = {15,0x79FC},
    [I(121,88)] = {15,0x7AFC},
    [I(122,88)] = {15,0x7BFC},
    [I(123,88)] = {23,0x7FFEFC},
    [I(124,88)] = {19,0x7FCFC},
    [I(125,88)] = {22,0x3FFDFC},
    [I(126,88)] = {21,0x1FFDFC},
    [I(127,88)] = {64,0},
    [I(128,88)] = {28,0xFFFE6FC},
    [I(129,88)] = {30,0x3FFFD2FC},
    [I(130,88)] = {28,0xFFFE7FC},
    [I(131,88)] = {28,0xFFFE8FC},
    [I(132,88)] = {30,0x3FFFD3FC},
    [I(133,88)] = {30,0x3FFFD4FC},
    [I(134,88)] = {30,0x3FFFD5FC},
    [I(135,88)] = {31,0x7FFFD9FC},
    [I(136,88)] = {30,0x3FFFD6FC},
    [I(137,88)] = {31,0x7FFFDAFC},
    [I(138,88)] = {31,0x7FFFDBFC},
    [I(139,88)] = {31,0x7FFFDCFC},
    [I(140,88)] = {31,0x7FFFDDFC},
    [I(141,88)] = {31,0x7FFFDEFC},
    [I(142,88)] = {X32,0xFFFFEBFC},
    [I(143,88)] = {31,0x7FFFDFFC},
    [I(144,88)] = {X32,0xFFFFECFC},
    [I(145,88)] = {X32,0xFFFFEDFC},
    [I(146,88)] = {30,0x3FFFD7FC},
    [I(147,88)] = {31,0x7FFFE0FC},
    [I(148,88)] = {X32,0xFFFFEEFC},
    [I(149,88)] = {31,0x7FFFE1FC},
    [I(150,88)] = {31,0x7FFFE2FC},
    [I(151,88)] = {31,0x7FFFE3FC},
    [I(152,88)] = {31,0x7FFFE4FC},
    [I(153,88)] = {29,0x1FFFDCFC},
    [I(154,88)] = {30,0x3FFFD8FC},
    [I(155,88)] = {31,0x7FFFE5FC},
    [I(156,88)] = {30,0x3FFFD9FC},
    [I(157,88)] = {31,0x7FFFE6FC},
    [I(158,88)] = {31,0x7FFFE7FC},
    [I(159,88)] = {X32,0xFFFFEFFC},
    [I(160,88)] = {30,0x3FFFDAFC},
    [I(161,88)] = {29,0x1FFFDDFC},
    [I(162,88)] = {28,0xFFFE9FC},
    [I(163,88)] = {30,0x3FFFDBFC},
    [I(164,88)] = {30,0x3FFFDCFC},
    [I(165,88)] = {31,0x7FFFE8FC},
    [I(166,88)] = {31,0x7FFFE9FC},
    [I(167,88)] = {29,0x1FFFDEFC},
    [I(168,88)] = {31,0x7FFFEAFC},
    [I(169,88)] = {30,0x3FFFDDFC},
    [I(170,88)] = {30,0x3FFFDEFC},
    [I(171,88)] = {X32,0xFFFFF0FC},
    [I(172,88)] = {29,0x1FFFDFFC},
    [I(173,88)] = {30,0x3FFFDFFC},
    [I(174,88)] = {31,0x7FFFEBFC},
    [I(175,88)] = {31,0x7FFFECFC},
    [I(176,88)] = {29,0x1FFFE0FC},
    [I(177,88)] = {29,0x1FFFE1FC},
    [I(178,88)] = {30,0x3FFFE0FC},
    [I(179,88)] = {29,0x1FFFE2FC},
    [I(180,88)] = {31,0x7FFFEDFC},
    [I(181,88)] = {30,0x3FFFE1FC},
    [I(182,88)] = {31,0x7FFFEEFC},
    [I(183,88)] = {31,0x7FFFEFFC},
    [I(184,88)] = {28,0xFFFEAFC},
    [I(185,88)] = {30,0x3FFFE2FC},
    [I(186,88)] = {30,0x3FFFE3FC},
    [I(187,88)] = {30,0x3FFFE4FC},
    [I(188,88)] = {31,0x7FFFF0FC},
    [I(189,88)] = {30,0x3FFFE5FC},
    [I(190,88)] = {30,0x3FFFE6FC},
    [I(191,88)] = {31,0x7FFFF1FC},
    [I(192,88)] = {64,0},
    [I(193,88)] = {64,0},
    [I(194,88)] = {28,0xFFFEBFC},
    [I(195,88)] = {27,0x7FFF1FC},
    [I(196,88)] = {30,0x3FFFE7FC},
    [I(197,88)] = {31,0x7FFFF2FC},
    [I(198,88)] = {30,0x3FFFE8FC},
    [I(199,88)] = {64,0},
    [I(200,88)] = {64,0},
    [I(201,88)] = {64,0},
    [I(202,88)] = {64,0},
    [I(203,88)] = {64,0},
    [I(204,88)] = {64,0},
    [I(205,88)] = {64,0},
    [I(206,88)] = {X32,0xFFFFF1FC},
    [I(207,88)] = {64,0},
    [I(208,88)] = {27,0x7FFF2FC},
    [I(209,88)] = {29,0x1FFFE3FC},
    [I(210,88)] = {64,0},
    [I(211,88)] = {64,0},
    [I(212,88)] = {64,0},
    [I(213,88)] = {64,0},
    [I(214,88)] = {64,0},
    [I(215,88)] = {X32,0xFFFFF2FC},
    [I(216,88)] = {29,0x1FFFE4FC},
    [I(217,88)] = {29,0x1FFFE5FC},
    [I(218,88)] = {64,0},
    [I(219,88)] = {64,0},
    [I(220,88)] = {64,0},
    [I(221,88)] = {64,0},
    [I(222,88)] = {64,0},
    [I(223,88)] = {64,0},
    [I(224,88)] = {28,0xFFFECFC},
    [I(225,88)] = {X32,0xFFFFF3FC},
    [I(226,88)] = {28,0xFFFEDFC},
    [I(227,88)] = {29,0x1FFFE6FC},
    [I(228,88)] = {30,0x3FFFE9FC},
    [I(229,88)] = {29,0x1FFFE7FC},
    [I(230,88)] = {29,0x1FFFE8FC},
    [I(231,88)] = {31,0x7FFFF3FC},
    [I(232,88)] = {30,0x3FFFEAFC},
    [I(233,88)] = {30,0x3FFFEBFC},
    [I(234,88)] = {64,0},
    [I(235,88)] = {64,0},
    [I(236,88)] = {X32,0xFFFFF4FC},
    [I(237,88)] = {X32,0xFFFFF5FC},
    [I(238,88)] = {64,0},
    [I(239,88)] = {31,0x7FFFF4FC},
    [I(240,88)] = {64,0},
    [I(241,88)] = {64,0},
    [I(242,88)] = {64,0},
    [I(243,88)] = {64,0},
    [I(244,88)] = {64,0},
    [I(245,88)] = {64,0},
    [I(246,88)] = {64,0},
    [I(247,88)] = {64,0},
    [I(248,88)] = {64,0},
    [I(249,88)] = {64,0},
    [I(250,88)] = {64,0},
    [I(251,88)] = {64,0},
    [I(252,88)] = {64,0},
    [I(253,88)] = {64,0},
    [I(254,88)] = {64,0},
    [I(255,88)] = {64,0},
    [I(0,89)] = {20,0xFFC73},
    [I(1,89)] = {30,0x3FFFEC73},
    [I(2,89)] = {64,0},
    [I(3,89)] = {64,0},
    [I(4,89)] = {64,0},
    [I(5,89)] = {64,0},
    [I(6,89)] = {64,0},
    [I(7,89)] = {64,0},
    [I(8,89)] = {64,0},
    [I(9,89)] = {31,0x7FFFF573},
    [I(10,89)] = {64,0},
    [I(11,89)] = {64,0},
    [I(12,89)] = {64,0},
    [I(13,89)] = {64,0},
    [I(14,89)] = {64,0},
    [I(15,89)] = {64,0},
    [I(16,89)] = {64,0},
    [I(17,89)] = {64,0},
    [I(18,89)] = {64,0},
    [I(19,89)] = {64,0},
    [I(20,89)] = {64,0},
    [I(21,89)] = {64,0},
    [I(22,89)] = {64,0},
    [I(23,89)] = {64,0},
    [I(24,89)] = {64,0},
    [I(25,89)] = {64,0},
    [I(26,89)] = {64,0},
    [I(27,89)] = {64,0},
    [I(28,89)] = {64,0},
    [I(29,89)] = {64,0},
    [I(30,89)] = {64,0},
    [I(31,89)] = {64,0},
    [I(32,89)] = {13,0xA73},
    [I(33,89)] = {17,0x1FC73},
    [I(34,89)] = {17,0x1FCF3},
    [I(35,89)] = {19,0x7FD73},
    [I(36,89)] = {20,0xFFCF3},
    [I(37,89)] = {13,0xAF3},
    [I(38,89)] = {15,0x7C73},
    [I(39,89)] = {18,0x3FD73},
    [I(40,89)] = {17,0x1FD73},
    [I(41,89)] = {17,0x1FDF3},
    [I(42,89)] = {15,0x7CF3},
    [I(43,89)] = {18,0x3FDF3},
    [I(44,89)] = {15,0x7D73},
    [I(45,89)] = {13,0xB73},
    [I(46,89)] = {13,0xBF3},
    [I(47,89)] = {13,0xC73},
    [I(48,89)] = {12,0x73},
    [I(49,89)] = {12,0xF3},
    [I(50,89)] = {12,0x173},
    [I(51,89)] = {13,0xCF3},
    [I(52,89)] = {13,0xD73},
    [I(53,89)] = {13,0xDF3},
    [I(54,89)] = {13,0xE73},
    [I(55,89)] = {13,0xEF3},
    [I(56,89)] = {13,0xF73},
    [I(57,89)] = {13,0xFF3},
    [I(58,89)] = {14,0x2E73},
    [I(59,89)] = {15,0x7DF3},
    [I(60,89)] = {22,0x3FFE73},
    [I(61,89)] = {13,0x1073},
    [I(62,89)] = {19,0x7FDF3},
    [I(63,89)] = {17,0x1FE73},
    [I(64,89)] = {20,0xFFD73},
    [I(65,89)] = {13,0x10F3},
    [I(66,89)] = {14,0x2EF3},
    [I(67,89)] = {14,0x2F73},
    [I(68,89)] = {14,0x2FF3},
    [I(69,89)] = {14,0x3073},
    [I(70,89)] = {14,0x30F3},
    [I(71,89)] = {14,0x3173},
    [I(72,89)] = {14,0x31F3},
    [I(73,89)] = {14,0x3273},
    [I(74,89)] = {14,0x32F3},
    [I(75,89)] = {14,0x3373},
    [I(76,89)] = {14,0x33F3},
    [I(77,89)] = {14,0x3473},
    [I(78,89)] = {14,0x34F3},
    [I(79,89)] = {14,0x3573},
    [I(80,89)] = {14,0x35F3},
    [I(81,89)] = {14,0x3673},
    [I(82,89)] = {14,0x36F3},
    [I(83,89)] = {14,0x3773},
    [I(84,89)] = {14,0x37F3},
    [I(85,89)] = {14,0x3873},
    [I(86,89)] = {14,0x38F3},
    [I(87,89)] = {14,0x3973},
    [I(88,89)] = {15,0x7E73},
    [I(89,89)] = {14,0x39F3},
    [I(90,89)] = {15,0x7EF3},
    [I(91,89)] = {20,0xFFDF3},
    [I(92,89)] = {26,0x3FFF873},
    [I(93,89)] = {20,0xFFE73},
    [I(94,89)] = {21,0x1FFE73},
    [I(95,89)] = {13,0x1173},
    [I(96,89)] = {22,0x3FFEF3},
    [I(97,89)] = {12,0x1F3},
    [I(98,89)] = {13,0x11F3},
    [I(99,89)] = {12,0x273},
    [I(100,89)] = {13,0x1273},
    [I(101,89)] = {12,0x2F3},
    [I(102,89)] = {13,0x12F3},
    [I(103,89)] = {13,0x1373},
    [I(104,89)] = {13,0x13F3},
    [I(105,89)] = {12,0x373},
    [I(106,89)] = {14,0x3A73},
    [I(107,89)] = {14,0x3AF3},
    [I(108,89)] = {13,0x1473},
    [I(109,89)] = {13,0x14F3},
    [I(110,89)] = {13,0x1573},
    [I(111,89)] = {12,0x3F3},
    [I(112,89)] = {13,0x15F3},
    [I(113,89)] = {14,0x3B73},
    [I(114,89)] = {13,0x1673},
    [I(115,89)] = {12,0x473},
    [I(116,89)] = {12,0x4F3},
    [I(117,89)] = {13,0x16F3},
    [I(118,89)] = {14,0x3BF3},
    [I(119,89)] = {14,0x3C73},
    [I(120,89)] = {14,0x3CF3},
    [I(121,89)] = {14,0x3D73},
    [I(122,89)] = {14,0x3DF3},
    [I(123,89)] = {22,0x3FFF73},
    [I(124,89)] = {18,0x3FE73},
    [I(125,89)] = {21,0x1FFEF3},
    [I(126,89)] = {20,0xFFEF3},
    [I(127,89)] = {64,0},
    [I(128,89)] = {27,0x7FFF373},
    [I(129,89)] = {29,0x1FFFE973},
    [I(130,89)] = {27,0x7FFF3F3},
    [I(131,89)] = {27,0x7FFF473},
    [I(132,89)] = {29,0x1FFFE9F3},
    [I(133,89)] = {29,0x1FFFEA73},
    [I(134,89)] = {29,0x1FFFEAF3},
    [I(135,89)] = {30,0x3FFFECF3},
    [I(136,89)] = {29,0x1FFFEB73},
    [I(137,89)] = {30,0x3FFFED73},
    [I(138,89)] = {30,0x3FFFEDF3},
    [I(139,89)] = {30,0x3FFFEE73},
    [I(140,89)] = {30,0x3FFFEEF3},
    [I(141,89)] = {30,0x3FFFEF73},
    [I(142,89)] = {31,0x7FFFF5F3},
    [I(143,89)] = {30,0x3FFFEFF3},
    [I(144,89)] = {31,0x7FFFF673},
    [I(145,89)] = {31,0x7FFFF6F3},
    [I(146,89)] = {29,0x1FFFEBF3},
    [I(147,89)] = {30,0x3FFFF073},
    [I(148,89)] = {31,0x7FFFF773},
    [I(149,89)] = {30,0x3FFFF0F3},
    [I(150,89)] = {30,0x3FFFF173},
    [I(151,89)] = {30,0x3FFFF1F3},
    [I(152,89)] = {30,0x3FFFF273},
    [I(153,89)] = {28,0xFFFEE73},
    [I(154,89)] = {29,0x1FFFEC73},
    [I(155,89)] = {30,0x3FFFF2F3},
    [I(156,89)] = {29,0x1FFFECF3},
    [I(157,89)] = {30,0x3FFFF373},
    [I(158,89)] = {30,0x3FFFF3F3},
    [I(159,89)] = {31,0x7FFFF7F3},
    [I(160,89)] = {29,0x1FFFED73},
    [I(161,89)] = {28,0xFFFEEF3},
    [I(162,89)] = {27,0x7FFF4F3},
    [I(163,89)] = {29,0x1FFFEDF3},
    [I(164,89)] = {29,0x1FFFEE73},
    [I(165,89)] = {30,0x3FFFF473},
    [I(166,89)] = {30,0x3FFFF4F3},
    [I(167,89)] = {28,0xFFFEF73},
    [I(168,89)] = {30,0x3FFFF573},
    [I(169,89)] = {29,0x1FFFEEF3},
    [I(170,89)] = {29,0x1FFFEF73},
    [I(171,89)] = {31,0x7FFFF873},
    [I(172,89)] = {28,0xFFFEFF3},
    [I(173,89)] = {29,0x1FFFEFF3},
    [I(174,89)] = {30,0x3FFFF5F3},
    [I(175,89)] = {30,0x3FFFF673},
    [I(176,89)] = {28,0xFFFF073},
    [I(177,89)] = {28,0xFFFF0F3},
    [I(178,89)] = {29,0x1FFFF073},
    [I(179,89)] = {28,0xFFFF173},
    [I(180,89)] = {30,0x3FFFF6F3},
    [I(181,89)] = {29,0x1FFFF0F3},
    [I(182,89)] = {30,0x3FFFF773},
    [I(183,89)] = {30,0x3FFFF7F3},
    [I(184,89)] = {27,0x7FFF573},
    [I(185,89)] = {29,0x1FFFF173},
    [I(186,89)] = {29,0x1FFFF1F3},
    [I(187,89)] = {29,0x1FFFF273},
    [I(188,89)] = {30,0x3FFFF873},
    [I(189,89)] = {29,0x1FFFF2F3},
    [I(190,89)] = {29,0x1FFFF373},
    [I(191,89)] = {30,0x3FFFF8F3},
    [I(192,89)] = {64,0},
    [I(193,89)] = {64,0},
    [I(194,89)] = {27,0x7FFF5F3},
    [I(195,89)] = {26,0x3FFF8F3},
    [I(196,89)] = {29,0x1FFFF3F3},
    [I(197,89)] = {30,0x3FFFF973},
    [I(198,89)] = {29,0x1FFFF473},
    [I(199,89)] = {X32,0xFFFFF673},
    [I(200,89)] = {64,0},
    [I(201,89)] = {64,0},
    [I(202,89)] = {64,0},
    [I(203,89)] = {64,0},
    [I(204,89)] = {64,0},
    [I(205,89)] = {64,0},
    [I(206,89)] = {31,0x7FFFF8F3},
    [I(207,89)] = {X32,0xFFFFF6F3},
    [I(208,89)] = {26,0x3FFF973},
    [I(209,89)] = {28,0xFFFF1F3},
    [I(210,89)] = {64,0},
    [I(211,89)] = {64,0},
    [I(212,89)] = {64,0},
    [I(213,89)] = {64,0},
    [I(214,89)] = {64,0},
    [I(215,89)] = {31,0x7FFFF973},
    [I(216,89)] = {28,0xFFFF273},
    [I(217,89)] = {28,0xFFFF2F3},
    [I(218,89)] = {64,0},
    [I(219,89)] = {64,0},
    [I(220,89)] = {64,0},
    [I(221,89)] = {64,0},
    [I(222,89)] = {64,0},
    [I(223,89)] = {64,0},
    [I(224,89)] = {27,0x7FFF673},
    [I(225,89)] = {31,0x7FFFF9F3},
    [I(226,89)] = {27,0x7FFF6F3},
    [I(227,89)] = {28,0xFFFF373},
    [I(228,89)] = {29,0x1FFFF4F3},
    [I(229,89)] = {28,0xFFFF3F3},
    [I(230,89)] = {28,0xFFFF473},
    [I(231,89)] = {30,0x3FFFF9F3},
    [I(232,89)] = {29,0x1FFFF573},
    [I(233,89)] = {29,0x1FFFF5F3},
    [I(234,89)] = {X32,0xFFFFF773},
    [I(235,89)] = {X32,0xFFFFF7F3},
    [I(236,89)] = {31,0x7FFFFA73},
    [I(237,89)] = {31,0x7FFFFAF3},
    [I(238,89)] = {64,0},
    [I(239,89)] = {30,0x3FFFFA73},
    [I(240,89)] = {64,0},
    [I(241,89)] = {64,0},
    [I(242,89)] = {64,0},
    [I(243,89)] = {64,0},
    [I(244,89)] = {64,0},
    [I(245,89)] = {64,0},
    [I(246,89)] = {64,0},
    [I(247,89)] = {64,0},
    [I(248,89)] = {64,0},
    [I(249,89)] = {64,0},
    [I(250,89)] = {64,0},
    [I(251,89)] = {64,0},
    [I(252,89)] = {64,0},
    [I(253,89)] = {64,0},
    [I(254,89)] = {64,0},
    [I(255,89)] = {64,0},
    [I(0,90)] = {21,0x1FF8FD},
    [I(1,90)] = {31,0x7FFFD8FD},
    [I(2,90)] = {64,0},
    [I(3,90)] = {64,0},
    [I(4,90)] = {64,0},
    [I(5,90)] = {64,0},
    [I(6,90)] = {64,0},
    [I(7,90)] = {64,0},
    [I(8,90)] = {64,0},
    [I(9,90)] = {X32,0xFFFFEAFD},
    [I(10,90)] = {64,0},
    [I(11,90)] = {64,0},
    [I(12,90)] = {64,0},
    [I(13,90)] = {64,0},
    [I(14,90)] = {64,0},
    [I(15,90)] = {64,0},
    [I(16,90)] = {64,0},
    [I(17,90)] = {64,0},
    [I(18,90)] = {64,0},
    [I(19,90)] = {64,0},
    [I(20,90)] = {64,0},
    [I(21,90)] = {64,0},
    [I(22,90)] = {64,0},
    [I(23,90)] = {64,0},
    [I(24,90)] = {64,0},
    [I(25,90)] = {64,0},
    [I(26,90)] = {64,0},
    [I(27,90)] = {64,0},
    [I(28,90)] = {64,0},
    [I(29,90)] = {64,0},
    [I(30,90)] = {64,0},
    [I(31,90)] = {64,0},
    [I(32,90)] = {14,0x14FD},
    [I(33,90)] = {18,0x3F8FD},
    [I(34,90)] = {18,0x3F9FD},
    [I(35,90)] = {20,0xFFAFD},
    [I(36,90)] = {21,0x1FF9FD},
    [I(37,90)] = {14,0x15FD},
    [I(38,90)] = {16,0xF8FD},
    [I(39,90)] = {19,0x7FAFD},
    [I(40,90)] = {18,0x3FAFD},
    [I(41,90)] = {18,0x3FBFD},
    [I(42,90)] = {16,0xF9FD},
    [I(43,90)] = {19,0x7FBFD},
    [I(44,90)] = {16,0xFAFD},
    [I(45,90)] = {14,0x16FD},
    [I(46,90)] = {14,0x17FD},
    [I(47,90)] = {14,0x18FD},
    [I(48,90)] = {13,0xFD},
    [I(49,90)] = {13,0x1FD},
    [I(50,90)] = {13,0x2FD},
    [I(51,90)] = {14,0x19FD},
    [I(52,90)] = {14,0x1AFD},
    [I(53,90)] = {14,0x1BFD},
    [I(54,90)] = {14,0x1CFD},
    [I(55,90)] = {14,0x1DFD},
    [I(56,90)] = {14,0x1EFD},
    [I(57,90)] = {14,0x1FFD},
    [I(58,90)] = {15,0x5CFD},
    [I(59,90)] = {16,0xFBFD},
    [I(60,90)] = {23,0x7FFCFD},
    [I(61,90)] = {14,0x20FD},
    [I(62,90)] = {20,0xFFBFD},
    [I(63,90)] = {18,0x3FCFD},
    [I(64,90)] = {21,0x1FFAFD},
    [I(65,90)] = {14,0x21FD},
    [I(66,90)] = {15,0x5DFD},
    [I(67,90)] = {15,0x5EFD},
    [I(68,90)] = {15,0x5FFD},
    [I(69,90)] = {15,0x60FD},
    [I(70,90)] = {15,0x61FD},
    [I(71,90)] = {15,0x62FD},
    [I(72,90)] = {15,0x63FD},
    [I(73,90)] = {15,0x64FD},
    [I(74,90)] = {15,0x65FD},
    [I(75,90)] = {15,0x66FD},
    [I(76,90)] = {15,0x67FD},
    [I(77,90)] = {15,0x68FD},
    [I(78,90)] = {15,0x69FD},
    [I(79,90)] = {15,0x6AFD},
    [I(80,90)] = {15,0x6BFD},
    [I(81,90)] = {15,0x6CFD},
    [I(82,90)] = {15,0x6DFD},
    [I(83,90)] = {15,0x6EFD},
    [I(84,90)] = {15,0x6FFD},
    [I(85,90)] = {15,0x70FD},
    [I(86,90)] = {15,0x71FD},
    [I(87,90)] = {15,0x72FD},
    [I(88,90)] = {16,0xFCFD},
    [I(89,90)] = {15,0x73FD},
    [I(90,90)] = {16,0xFDFD},
    [I(91,90)] = {21,0x1FFBFD},
    [I(92,90)] = {27,0x7FFF0FD},
    [I(93,90)] = {21,0x1FFCFD},
    [I(94,90)] = {22,0x3FFCFD},
    [I(95,90)] = {14,0x22FD},
    [I(96,90)] = {23,0x7FFDFD},
    [I(97,90)] = {13,0x3FD},
    [I(98,90)] = {14,0x23FD},
    [I(99,90)] = {13,0x4FD},
    [I(100,90)] = {14,0x24FD},
    [I(101,90)] = {13,0x5FD},
    [I(102,90)] = {14,0x25FD},
    [I(103,90)] = {14,0x26FD},
    [I(104,90)] = {14,0x27FD},
    [I(105,90)] = {13,0x6FD},
    [I(106,90)] = {15,0x74FD},
    [I(107,90)] = {15,0x75FD},
    [I(108,90)] = {14,0x28FD},
    [I(109,90)] = {14,0x29FD},
    [I(110,90)] = {14,0x2AFD},
    [I(111,90)] = {13,0x7FD},
    [I(112,90)] = {14,0x2BFD},
    [I(113,90)] = {15,0x76FD},
    [I(114,90)] = {14,0x2CFD},
    [I(115,90)] = {13,0x8FD},
    [I(116,90)] = {13,0x9FD},
    [I(117,90)] = {14,0x2DFD},
    [I(118,90)] = {15,0x77FD},
    [I(119,90)] = {15,0x78FD},
    [I(120,90)] = {15,0x79FD},
    [I(121,90)] = {15,0x7AFD},
    [I(122,90)] = {15,0x7BFD},
    [I(123,90)] = {23,0x7FFEFD},
    [I(124,90)] = {19,0x7FCFD},
    [I(125,90)] = {22,0x3FFDFD},
    [I(126,90)] = {21,0x1FFDFD},
    [I(127,90)] = {64,0},
    [I(128,90)] = {28,0xFFFE6FD},
    [I(129,90)] = {30,0x3FFFD2FD},
    [I(130,90)] = {28,0xFFFE7FD},
    [I(131,90)] = {28,0xFFFE8FD},
    [I(132,90)] = {30,0x3FFFD3FD},
    [I(133,90)] = {30,0x3FFFD4FD},
    [I(134,90)] = {30,0x3FFFD5FD},
    [I(135,90)] = {31,0x7FFFD9FD},
    [I(136,90)] = {30,0x3FFFD6FD},
    [I(137,90)] = {31,0x7FFFDAFD},
    [I(138,90)] = {31,0x7FFFDBFD},
    [I(139,90)] = {31,0x7FFFDCFD},
    [I(140,90)] = {31,0x7FFFDDFD},
    [I(141,90)] = {31,0x7FFFDEFD},
    [I(142,90)] = {X32,0xFFFFEBFD},
    [I(143,90)] = {31,0x7FFFDFFD},
    [I(144,90)] = {X32,0xFFFFECFD},
    [I(145,90)] = {X32,0xFFFFEDFD},
    [I(146,90)] = {30,0x3FFFD7FD},
    [I(147,90)] = {31,0x7FFFE0FD},
    [I(148,90)] = {X32,0xFFFFEEFD},
    [I(149,90)] = {31,0x7FFFE1FD},
    [I(150,90)] = {31,0x7FFFE2FD},
    [I(151,90)] = {31,0x7FFFE3FD},
    [I(152,90)] = {31,0x7FFFE4FD},
    [I(153,90)] = {29,0x1FFFDCFD},
    [I(154,90)] = {30,0x3FFFD8FD},
    [I(155,90)] = {31,0x7FFFE5FD},
    [I(156,90)] = {30,0x3FFFD9FD},
    [I(157,90)] = {31,0x7FFFE6FD},
    [I(158,90)] = {31,0x7FFFE7FD},
    [I(159,90)] = {X32,0xFFFFEFFD},
    [I(160,90)] = {30,0x3FFFDAFD},
    [I(161,90)] = {29,0x1FFFDDFD},
    [I(162,90)] = {28,0xFFFE9FD},
    [I(163,90)] = {30,0x3FFFDBFD},
    [I(164,90)] = {30,0x3FFFDCFD},
    [I(165,90)] = {31,0x7FFFE8FD},
    [I(166,90)] = {31,0x7FFFE9FD},
    [I(167,90)] = {29,0x1FFFDEFD},
    [I(168,90)] = {31,0x7FFFEAFD},
    [I(169,90)] = {30,0x3FFFDDFD},
    [I(170,90)] = {30,0x3FFFDEFD},
    [I(171,90)] = {X32,0xFFFFF0FD},
    [I(172,90)] = {29,0x1FFFDFFD},
    [I(173,90)] = {30,0x3FFFDFFD},
    [I(174,90)] = {31,0x7FFFEBFD},
    [I(175,90)] = {31,0x7FFFECFD},
    [I(176,90)] = {29,0x1FFFE0FD},
    [I(177,90)] = {29,0x1FFFE1FD},
    [I(178,90)] = {30,0x3FFFE0FD},
    [I(179,90)] = {29,0x1FFFE2FD},
    [I(180,90)] = {31,0x7FFFEDFD},
    [I(181,90)] = {30,0x3FFFE1FD},
    [I(182,90)] = {31,0x7FFFEEFD},
    [I(183,90)] = {31,0x7FFFEFFD},
    [I(184,90)] = {28,0xFFFEAFD},
    [I(185,90)] = {30,0x3FFFE2FD},
    [I(186,90)] = {30,0x3FFFE3FD},
    [I(187,90)] = {30,0x3FFFE4FD},
    [I(188,90)] = {31,0x7FFFF0FD},
    [I(189,90)] = {30,0x3FFFE5FD},
    [I(190,90)] = {30,0x3FFFE6FD},
    [I(191,90)] = {31,0x7FFFF1FD},
    [I(192,90)] = {64,0},
    [I(193,90)] = {64,0},
    [I(194,90)] = {28,0xFFFEBFD},
    [I(195,90)] = {27,0x7FFF1FD},
    [I(196,90)] = {30,0x3FFFE7FD},
    [I(197,90)] = {31,0x7FFFF2FD},
    [I(198,90)] = {30,0x3FFFE8FD},
    [I(199,90)] = {64,0},
    [I(200,90)] = {64,0},
    [I(201,90)] = {64,0},
    [I(202,90)] = {64,0},
    [I(203,90)] = {64,0},
    [I(204,90)] = {64,0},
    [I(205,90)] = {64,0},
    [I(206,90)] = {X32,0xFFFFF1FD},
    [I(207,90)] = {64,0},
    [I(208,90)] = {27,0x7FFF2FD},
    [I(209,90)] = {29,0x1FFFE3FD},
    [I(210,90)] = {64,0},
    [I(211,90)] = {64,0},
    [I(212,90)] = {64,0},
    [I(213,90)] = {64,0},
    [I(214,90)] = {64,0},
    [I(215,90)] = {X32,0xFFFFF2FD},
    [I(216,90)] = {29,0x1FFFE4FD},
    [I(217,90)] = {29,0x1FFFE5FD},
    [I(218,90)] = {64,0},
    [I(219,90)] = {64,0},
    [I(220,90)] = {64,0},
    [I(221,90)] = {64,0},
    [I(222,90)] = {64,0},
    [I(223,90)] = {64,0},
    [I(224,90)] = {28,0xFFFECFD},
    [I(225,90)] = {X32,0xFFFFF3FD},
    [I(226,90)] = {28,0xFFFEDFD},
    [I(227,90)] = {29,0x1FFFE6FD},
    [I(228,90)] = {30,0x3FFFE9FD},
    [I(229,90)] = {29,0x1FFFE7FD},
    [I(230,90)] = {29,0x1FFFE8FD},
    [I(231,90)] = {31,0x7FFFF3FD},
    [I(232,90)] = {30,0x3FFFEAFD},
    [I(233,90)] = {30,0x3FFFEBFD},
    [I(234,90)] = {64,0},
    [I(235,90)] = {64,0},
    [I(236,90)] = {X32,0xFFFFF4FD},
    [I(237,90)] = {X32,0xFFFFF5FD},
    [I(238,90)] = {64,0},
    [I(239,90)] = {31,0x7FFFF4FD},
    [I(240,90)] = {64,0},
    [I(241,90)] = {64,0},
    [I(242,90)] = {64,0},
    [I(243,90)] = {64,0},
    [I(244,90)] = {64,0},
    [I(245,90)] = {64,0},
    [I(246,90)] = {64,0},
    [I(247,90)] = {64,0},
    [I(248,90)] = {64,0},
    [I(249,90)] = {64,0},
    [I(250,90)] = {64,0},
    [I(251,90)] = {64,0},
    [I(252,90)] = {64,0},
    [I(253,90)] = {64,0},
    [I(254,90)] = {64,0},
    [I(255,90)] = {64,0},
    [I(0,91)] = {26,0x3FF1FFB},
    [I(1,91)] = {64,0},
    [I(2,91)] = {64,0},
    [I(3,91)] = {64,0},
    [I(4,91)] = {64,0},
    [I(5,91)] = {64,0},
    [I(6,91)] = {64,0},
    [I(7,91)] = {64,0},
    [I(8,91)] = {64,0},
    [I(9,91)] = {64,0},
    [I(10,91)] = {64,0},
    [I(11,91)] = {64,0},
    [I(12,91)] = {64,0},
    [I(13,91)] = {64,0},
    [I(14,91)] = {64,0},
    [I(15,91)] = {64,0},
    [I(16,91)] = {64,0},
    [I(17,91)] = {64,0},
    [I(18,91)] = {64,0},
    [I(19,91)] = {64,0},
    [I(20,91)] = {64,0},
    [I(21,91)] = {64,0},
    [I(22,91)] = {64,0},
    [I(23,91)] = {64,0},
    [I(24,91)] = {64,0},
    [I(25,91)] = {64,0},
    [I(26,91)] = {64,0},
    [I(27,91)] = {64,0},
    [I(28,91)] = {64,0},
    [I(29,91)] = {64,0},
    [I(30,91)] = {64,0},
    [I(31,91)] = {64,0},
    [I(32,91)] = {19,0x29FFB},
    [I(33,91)] = {23,0x7F1FFB},
    [I(34,91)] = {23,0x7F3FFB},
    [I(35,91)] = {25,0x1FF5FFB},
    [I(36,91)] = {26,0x3FF3FFB},
    [I(37,91)] = {19,0x2BFFB},
    [I(38,91)] = {21,0x1F1FFB},
    [I(39,91)] = {24,0xFF5FFB},
    [I(40,91)] = {23,0x7F5FFB},
    [I(41,91)] = {23,0x7F7FFB},
    [I(42,91)] = {21,0x1F3FFB},
    [I(43,91)] = {24,0xFF7FFB},
    [I(44,91)] = {21,0x1F5FFB},
    [I(45,91)] = {19,0x2DFFB},
    [I(46,91)] = {19,0x2FFFB},
    [I(47,91)] = {19,0x31FFB},
    [I(48,91)] = {18,0x1FFB},
    [I(49,91)] = {18,0x3FFB},
    [I(50,91)] = {18,0x5FFB},
    [I(51,91)] = {19,0x33FFB},
    [I(52,91)] = {19,0x35FFB},
    [I(53,91)] = {19,0x37FFB},
    [I(54,91)] = {19,0x39FFB},
    [I(55,91)] = {19,0x3BFFB},
    [I(56,91)] = {19,0x3DFFB},
    [I(57,91)] = {19,0x3FFFB},
    [I(58,91)] = {20,0xB9FFB},
    [I(59,91)] = {21,0x1F7FFB},
    [I(60,91)] = {28,0xFFF9FFB},
    [I(61,91)] = {19,0x41FFB},
    [I(62,91)] = {25,0x1FF7FFB},
    [I(63,91)] = {23,0x7F9FFB},
    [I(64,91)] = {26,0x3FF5FFB},
    [I(65,91)] = {19,0x43FFB},
    [I(66,91)] = {20,0xBBFFB},
    [I(67,91)] = {20,0xBDFFB},
    [I(68,91)] = {20,0xBFFFB},
    [I(69,91)] = {20,0xC1FFB},
    [I(70,91)] = {20,0xC3FFB},
    [I(71,91)] = {20,0xC5FFB},
    [I(72,91)] = {20,0xC7FFB},
    [I(73,91)] = {20,0xC9FFB},
    [I(74,91)] = {20,0xCBFFB},
    [I(75,91)] = {20,0xCDFFB},
    [I(76,91)] = {20,0xCFFFB},
    [I(77,91)] = {20,0xD1FFB},
    [I(78,91)] = {20,0xD3FFB},
    [I(79,91)] = {20,0xD5FFB},
    [I(80,91)] = {20,0xD7FFB},
    [I(81,91)] = {20,0xD9FFB},
    [I(82,91)] = {20,0xDBFFB},
    [I(83,91)] = {20,0xDDFFB},
    [I(84,91)] = {20,0xDFFFB},
    [I(85,91)] = {20,0xE1FFB},
    [I(86,91)] = {20,0xE3FFB},
    [I(87,91)] = {20,0xE5FFB},
    [I(88,91)] = {21,0x1F9FFB},
    [I(89,91)] = {20,0xE7FFB},
    [I(90,91)] = {21,0x1FBFFB},
    [I(91,91)] = {26,0x3FF7FFB},
    [I(92,91)] = {X32,0xFFFE1FFB},
    [I(93,91)] = {26,0x3FF9FFB},
    [I(94,91)] = {27,0x7FF9FFB},
    [I(95,91)] = {19,0x45FFB},
    [I(96,91)] = {28,0xFFFBFFB},
    [I(97,91)] = {18,0x7FFB},
    [I(98,91)] = {19,0x47FFB},
    [I(99,91)] = {18,0x9FFB},
    [I(100,91)] = {19,0x49FFB},
    [I(101,91)] = {18,0xBFFB},
    [I(102,91)] = {19,0x4BFFB},
    [I(103,91)] = {19,0x4DFFB},
    [I(104,91)] = {19,0x4FFFB},
    [I(105,91)] = {18,0xDFFB},
    [I(106,91)] = {20,0xE9FFB},
    [I(107,91)] = {20,0xEBFFB},
    [I(108,91)] = {19,0x51FFB},
    [I(109,91)] = {19,0x53FFB},
    [I(110,91)] = {19,0x55FFB},
    [I(111,91)] = {18,0xFFFB},
    [I(112,91)] = {19,0x57FFB},
    [I(113,91)] = {20,0xEDFFB},
    [I(114,91)] = {19,0x59FFB},
    [I(115,91)] = {18,0x11FFB},
    [I(116,91)] = {18,0x13FFB},
    [I(117,91)] = {19,0x5BFFB},
    [I(118,91)] = {20,0xEFFFB},
    [I(119,91)] = {20,0xF1FFB},
    [I(120,91)] = {20,0xF3FFB},
    [I(121,91)] = {20,0xF5FFB},
    [I(122,91)] = {20,0xF7FFB},
    [I(123,91)] = {28,0xFFFDFFB},
    [I(124,91)] = {24,0xFF9FFB},
    [I(125,91)] = {27,0x7FFBFFB},
    [I(126,91)] = {26,0x3FFBFFB},
    [I(127,91)] = {64,0},
    [I(128,91)] = {64,0},
    [I(129,91)] = {64,0},
    [I(130,91)] = {64,0},
    [I(131,91)] = {64,0},
    [I(132,91)] = {64,0},
    [I(133,91)] = {64,0},
    [I(134,91)] = {64,0},
    [I(135,91)] = {64,0},
    [I(136,91)] = {64,0},
    [I(137,91)] = {64,0},
    [I(138,91)] = {64,0},
    [I(139,91)] = {64,0},
    [I(140,91)] = {64,0},
    [I(141,91)] = {64,0},
    [I(142,91)] = {64,0},
    [I(143,91)] = {64,0},
    [I(144,91)] = {64,0},
    [I(145,91)] = {64,0},
    [I(146,91)] = {64,0},
    [I(147,91)] = {64,0},
    [I(148,91)] = {64,0},
    [I(149,91)] = {64,0},
    [I(150,91)] = {64,0},
    [I(151,91)] = {64,0},
    [I(152,91)] = {64,0},
    [I(153,91)] = {64,0},
    [I(154,91)] = {64,0},
    [I(155,91)] = {64,0},
    [I(156,91)] = {64,0},
    [I(157,91)] = {64,0},
    [I(158,91)] = {64,0},
    [I(159,91)] = {64,0},
    [I(160,91)] = {64,0},
    [I(161,91)] = {64,0},
    [I(162,91)] = {64,0},
    [I(163,91)] = {64,0},
    [I(164,91)] = {64,0},
    [I(165,91)] = {64,0},
    [I(166,91)] = {64,0},
    [I(167,91)] = {64,0},
    [I(168,91)] = {64,0},
    [I(169,91)] = {64,0},
    [I(170,91)] = {64,0},
    [I(171,91)] = {64,0},
    [I(172,91)] = {64,0},
    [I(173,91)] = {64,0},
    [I(174,91)] = {64,0},
    [I(175,91)] = {64,0},
    [I(176,91)] = {64,0},
    [I(177,91)] = {64,0},
    [I(178,91)] = {64,0},
    [I(179,91)] = {64,0},
    [I(180,91)] = {64,0},
    [I(181,91)] = {64,0},
    [I(182,91)] = {64,0},
    [I(183,91)] = {64,0},
    [I(184,91)] = {64,0},
    [I(185,91)] = {64,0},
    [I(186,91)] = {64,0},
    [I(187,91)] = {64,0},
    [I(188,91)] = {64,0},
    [I(189,91)] = {64,0},
    [I(190,91)] = {64,0},
    [I(191,91)] = {64,0},
    [I(192,91)] = {64,0},
    [I(193,91)] = {64,0},
    [I(194,91)] = {64,0},
    [I(195,91)] = {X32,0xFFFE3FFB},
    [I(196,91)] = {64,0},
    [I(197,91)] = {64,0},
    [I(198,91)] = {64,0},
    [I(199,91)] = {64,0},
    [I(200,91)] = {64,0},
    [I(201,91)] = {64,0},
    [I(202,91)] = {64,0},
    [I(203,91)] = {64,0},
    [I(204,91)] = {64,0},
    [I(205,91)] = {64,0},
    [I(206,91)] = {64,0},
    [I(207,91)] = {64,0},
    [I(208,91)] = {X32,0xFFFE5FFB},
    [I(209,91)] = {64,0},
    [I(210,91)] = {64,0},
    [I(211,91)] = {64,0},
    [I(212,91)] = {64,0},
    [I(213,91)] = {64,0},
    [I(214,91)] = {64,0},
    [I(215,91)] = {64,0},
    [I(216,91)] = {64,0},
    [I(217,91)] = {64,0},
    [I(218,91)] = {64,0},
    [I(219,91)] = {64,0},
    [I(220,91)] = {64,0},
    [I(221,91)] = {64,0},
    [I(222,91)] = {64,0},
    [I(223,91)] = {64,0},
    [I(224,91)] = {64,0},
    [I(225,91)] = {64,0},
    [I(226,91)] = {64,0},
    [I(227,91)] = {64,0},
    [I(228,91)] = {64,0},
    [I(229,91)] = {64,0},
    [I(230,91)] = {64,0},
    [I(231,91)] = {64,0},
    [I(232,91)] = {64,0},
    [I(233,91)] = {64,0},
    [I(234,91)] = {64,0},
    [I(235,91)] = {64,0},
    [I(236,91)] = {64,0},
    [I(237,91)] = {64,0},
    [I(238,91)] = {64,0},
    [I(239,91)] = {64,0},
    [I(240,91)] = {64,0},
    [I(241,91)] = {64,0},
    [I(242,91)] = {64,0},
    [I(243,91)] = {64,0},
    [I(244,91)] = {64,0},
    [I(245,91)] = {64,0},
    [I(246,91)] = {64,0},
    [I(247,91)] = {64,0},
    [I(248,91)] = {64,0},
    [I(249,91)] = {64,0},
    [I(250,91)] = {64,0},
    [I(251,91)] = {64,0},
    [I(252,91)] = {64,0},
    [I(253,91)] = {64,0},
    [I(254,91)] = {64,0},
    [I(255,91)] = {64,0},
    [I(0,92)] = {X32,0xFFC7FFF0},
    [I(1,92)] = {64,0},
    [I(2,92)] = {64,0},
    [I(3,92)] = {64,0},
    [I(4,92)] = {64,0},
    [I(5,92)] = {64,0},
    [I(6,92)] = {64,0},
    [I(7,92)] = {64,0},
    [I(8,92)] = {64,0},
    [I(9,92)] = {64,0},
    [I(10,92)] = {64,0},
    [I(11,92)] = {64,0},
    [I(12,92)] = {64,0},
    [I(13,92)] = {64,0},
    [I(14,92)] = {64,0},
    [I(15,92)] = {64,0},
    [I(16,92)] = {64,0},
    [I(17,92)] = {64,0},
    [I(18,92)] = {64,0},
    [I(19,92)] = {64,0},
    [I(20,92)] = {64,0},
    [I(21,92)] = {64,0},
    [I(22,92)] = {64,0},
    [I(23,92)] = {64,0},
    [I(24,92)] = {64,0},
    [I(25,92)] = {64,0},
    [I(26,92)] = {64,0},
    [I(27,92)] = {64,0},
    [I(28,92)] = {64,0},
    [I(29,92)] = {64,0},
    [I(30,92)] = {64,0},
    [I(31,92)] = {64,0},
    [I(32,92)] = {25,0xA7FFF0},
    [I(33,92)] = {29,0x1FC7FFF0},
    [I(34,92)] = {29,0x1FCFFFF0},
    [I(35,92)] = {31,0x7FD7FFF0},
    [I(36,92)] = {X32,0xFFCFFFF0},
    [I(37,92)] = {25,0xAFFFF0},
    [I(38,92)] = {27,0x7C7FFF0},
    [I(39,92)] = {30,0x3FD7FFF0},
    [I(40,92)] = {29,0x1FD7FFF0},
    [I(41,92)] = {29,0x1FDFFFF0},
    [I(42,92)] = {27,0x7CFFFF0},
    [I(43,92)] = {30,0x3FDFFFF0},
    [I(44,92)] = {27,0x7D7FFF0},
    [I(45,92)] = {25,0xB7FFF0},
    [I(46,92)] = {25,0xBFFFF0},
    [I(47,92)] = {25,0xC7FFF0},
    [I(48,92)] = {24,0x7FFF0},
    [I(49,92)] = {24,0xFFFF0},
    [I(50,92)] = {24,0x17FFF0},
    [I(51,92)] = {25,0xCFFFF0},
    [I(52,92)] = {25,0xD7FFF0},
    [I(53,92)] = {25,0xDFFFF0},
    [I(54,92)] = {25,0xE7FFF0},
    [I(55,92)] = {25,0xEFFFF0},
    [I(56,92)] = {25,0xF7FFF0},
    [I(57,92)] = {25,0xFFFFF0},
    [I(58,92)] = {26,0x2E7FFF0},
    [I(59,92)] = {27,0x7DFFFF0},
    [I(60,92)] = {64,0},
    [I(61,92)] = {25,0x107FFF0},
    [I(62,92)] = {31,0x7FDFFFF0},
    [I(63,92)] = {29,0x1FE7FFF0},
    [I(64,92)] = {X32,0xFFD7FFF0},
    [I(65,92)] = {25,0x10FFFF0},
    [I(66,92)] = {26,0x2EFFFF0},
    [I(67,92)] = {26,0x2F7FFF0},
    [I(68,92)] = {26,0x2FFFFF0},
    [I(69,92)] = {26,0x307FFF0},
    [I(70,92)] = {26,0x30FFFF0},
    [I(71,92)] = {26,0x317FFF0},
    [I(72,92)] = {26,0x31FFFF0},
    [I(73,92)] = {26,0x327FFF0},
    [I(74,92)] = {26,0x32FFFF0},
    [I(75,92)] = {26,0x337FFF0},
    [I(76,92)] = {26,0x33FFFF0},
    [I(77,92)] = {26,0x347FFF0},
    [I(78,92)] = {26,0x34FFFF0},
    [I(79,92)] = {26,0x357FFF0},
    [I(80,92)] = {26,0x35FFFF0},
    [I(81,92)] = {26,0x367FFF0},
    [I(82,92)] = {26,0x36FFFF0},
    [I(83,92)] = {26,0x377FFF0},
    [I(84,92)] = {26,0x37FFFF0},
    [I(85,92)] = {26,0x387FFF0},
    [I(86,92)] = {26,0x38FFFF0},
    [I(87,92)] = {26,0x397FFF0},
    [I(88,92)] = {27,0x7E7FFF0},
    [I(89,92)] = {26,0x39FFFF0},
    [I(90,92)] = {27,0x7EFFFF0},
    [I(91,92)] = {X32,0xFFDFFFF0},
    [I(92,92)] = {64,0},
    [I(93,92)] = {X32,0xFFE7FFF0},
    [I(94,92)] = {64,0},
    [I(95,92)] = {25,0x117FFF0},
    [I(96,92)] = {64,0},
    [I(97,92)] = {24,0x1FFFF0},
    [I(98,92)] = {25,0x11FFFF0},
    [I(99,92)] = {24,0x27FFF0},
    [I(100,92)] = {25,0x127FFF0},
    [I(101,92)] = {24,0x2FFFF0},
    [I(102,92)] = {25,0x12FFFF0},
    [I(103,92)] = {25,0x137FFF0},
    [I(104,92)] = {25,0x13FFFF0},
    [I(105,92)] = {24,0x37FFF0},
    [I(106,92)] = {26,0x3A7FFF0},
    [I(107,92)] = {26,0x3AFFFF0},
    [I(108,92)] = {25,0x147FFF0},
    [I(109,92)] = {25,0x14FFFF0},
    [I(110,92)] = {25,0x157FFF0},
    [I(111,92)] = {24,0x3FFFF0},
    [I(112,92)] = {25,0x15FFFF0},
    [I(113,92)] = {26,0x3B7FFF0},
    [I(114,92)] = {25,0x167FFF0},
    [I(115,92)] = {24,0x47FFF0},
    [I(116,92)] = {24,0x4FFFF0},
    [I(117,92)] = {25,0x16FFFF0},
    [I(118,92)] = {26,0x3BFFFF0},
    [I(119,92)] = {26,0x3C7FFF0},
    [I(120,92)] = {26,0x3CFFFF0},
    [I(121,92)] = {26,0x3D7FFF0},
    [I(122,92)] = {26,0x3DFFFF0},
    [I(123,92)] = {64,0},
    [I(124,92)] = {30,0x3FE7FFF0},
    [I(125,92)] = {64,0},
    [I(126,92)] = {X32,0xFFEFFFF0},
    [I(127,92)] = {64,0},
    [I(128,92)] = {64,0},
    [I(129,92)] = {64,0},
    [I(130,92)] = {64,0},
    [I(131,92)] = {64,0},
    [I(132,92)] = {64,0},
    [I(133,92)] = {64,0},
    [I(134,92)] = {64,0},
    [I(135,92)] = {64,0},
    [I(136,92)] = {64,0},
    [I(137,92)] = {64,0},
    [I(138,92)] = {64,0},
    [I(139,92)] = {64,0},
    [I(140,92)] = {64,0},
    [I(141,92)] = {64,0},
    [I(142,92)] = {64,0},
    [I(143,92)] = {64,0},
    [I(144,92)] = {64,0},
    [I(145,92)] = {64,0},
    [I(146,92)] = {64,0},
    [I(147,92)] = {64,0},
    [I(148,92)] = {64,0},
    [I(149,92)] = {64,0},
    [I(150,92)] = {64,0},
    [I(151,92)] = {64,0},
    [I(152,92)] = {64,0},
    [I(153,92)] = {64,0},
    [I(154,92)] = {64,0},
    [I(155,92)] = {64,0},
    [I(156,92)] = {64,0},
    [I(157,92)] = {64,0},
    [I(158,92)] = {64,0},
    [I(159,92)] = {64,0},
    [I(160,92)] = {64,0},
    [I(161,92)] = {64,0},
    [I(162,92)] = {64,0},
    [I(163,92)] = {64,0},
    [I(164,92)] = {64,0},
    [I(165,92)] = {64,0},
    [I(166,92)] = {64,0},
    [I(167,92)] = {64,0},
    [I(168,92)] = {64,0},
    [I(169,92)] = {64,0},
    [I(170,92)] = {64,0},
    [I(171,92)] = {64,0},
    [I(172,92)] = {64,0},
    [I(173,92)] = {64,0},
    [I(174,92)] = {64,0},
    [I(175,92)] = {64,0},
    [I(176,92)] = {64,0},
    [I(177,92)] = {64,0},
    [I(178,92)] = {64,0},
    [I(179,92)] = {64,0},
    [I(180,92)] = {64,0},
    [I(181,92)] = {64,0},
    [I(182,92)] = {64,0},
    [I(183,92)] = {64,0},
    [I(184,92)] = {64,0},
    [I(185,92)] = {64,0},
    [I(186,92)] = {64,0},
    [I(187,92)] = {64,0},
    [I(188,92)] = {64,0},
    [I(189,92)] = {64,0},
    [I(190,92)] = {64,0},
    [I(191,92)] = {64,0},
    [I(192,92)] = {64,0},
    [I(193,92)] = {64,0},
    [I(194,92)] = {64,0},
    [I(195,92)] = {64,0},
    [I(196,92)] = {64,0},
    [I(197,92)] = {64,0},
    [I(198,92)] = {64,0},
    [I(199,92)] = {64,0},
    [I(200,92)] = {64,0},
    [I(201,92)] = {64,0},
    [I(202,92)] = {64,0},
    [I(203,92)] = {64,0},
    [I(204,92)] = {64,0},
    [I(205,92)] = {64,0},
    [I(206,92)] = {64,0},
    [I(207,92)] = {64,0},
    [I(208,92)] = {64,0},
    [I(209,92)] = {64,0},
    [I(210,92)] = {64,0},
    [I(211,92)] = {64,0},
    [I(212,92)] = {64,0},
    [I(213,92)] = {64,0},
    [I(214,92)] = {64,0},
    [I(215,92)] = {64,0},
    [I(216,92)] = {64,0},
    [I(217,92)] = {64,0},
    [I(218,92)] = {64,0},
    [I(219,92)] = {64,0},
    [I(220,92)] = {64,0},
    [I(221,92)] = {64,0},
    [I(222,92)] = {64,0},
    [I(223,92)] = {64,0},
    [I(224,92)] = {64,0},
    [I(225,92)] = {64,0},
    [I(226,92)] = {64,0},
    [I(227,92)] = {64,0},
    [I(228,92)] = {64,0},
    [I(229,92)] = {64,0},
    [I(230,92)] = {64,0},
    [I(231,92)] = {64,0},
    [I(232,92)] = {64,0},
    [I(233,92)] = {64,0},
    [I(234,92)] = {64,0},
    [I(235,92)] = {64,0},
    [I(236,92)] = {64,0},
    [I(237,92)] = {64,0},
    [I(238,92)] = {64,0},
    [I(239,92)] = {64,0},
    [I(240,92)] = {64,0},
    [I(241,92)] = {64,0},
    [I(242,92)] = {64,0},
    [I(243,92)] = {64,0},
    [I(244,92)] = {64,0},
    [I(245,92)] = {64,0},
    [I(246,92)] = {64,0},
    [I(247,92)] = {64,0},
    [I(248,92)] = {64,0},
    [I(249,92)] = {64,0},
    [I(250,92)] = {64,0},
    [I(251,92)] = {64,0},
    [I(252,92)] = {64,0},
    [I(253,92)] = {64,0},
    [I(254,92)] = {64,0},
    [I(255,92)] = {64,0},
    [I(0,93)] = {26,0x3FF1FFC},
    [I(1,93)] = {64,0},
    [I(2,93)] = {64,0},
    [I(3,93)] = {64,0},
    [I(4,93)] = {64,0},
    [I(5,93)] = {64,0},
    [I(6,93)] = {64,0},
    [I(7,93)] = {64,0},
    [I(8,93)] = {64,0},
    [I(9,93)] = {64,0},
    [I(10,93)] = {64,0},
    [I(11,93)] = {64,0},
    [I(12,93)] = {64,0},
    [I(13,93)] = {64,0},
    [I(14,93)] = {64,0},
    [I(15,93)] = {64,0},
    [I(16,93)] = {64,0},
    [I(17,93)] = {64,0},
    [I(18,93)] = {64,0},
    [I(19,93)] = {64,0},
    [I(20,93)] = {64,0},
    [I(21,93)] = {64,0},
    [I(22,93)] = {64,0},
    [I(23,93)] = {64,0},
    [I(24,93)] = {64,0},
    [I(25,93)] = {64,0},
    [I(26,93)] = {64,0},
    [I(27,93)] = {64,0},
    [I(28,93)] = {64,0},
    [I(29,93)] = {64,0},
    [I(30,93)] = {64,0},
    [I(31,93)] = {64,0},
    [I(32,93)] = {19,0x29FFC},
    [I(33,93)] = {23,0x7F1FFC},
    [I(34,93)] = {23,0x7F3FFC},
    [I(35,93)] = {25,0x1FF5FFC},
    [I(36,93)] = {26,0x3FF3FFC},
    [I(37,93)] = {19,0x2BFFC},
    [I(38,93)] = {21,0x1F1FFC},
    [I(39,93)] = {24,0xFF5FFC},
    [I(40,93)] = {23,0x7F5FFC},
    [I(41,93)] = {23,0x7F7FFC},
    [I(42,93)] = {21,0x1F3FFC},
    [I(43,93)] = {24,0xFF7FFC},
    [I(44,93)] = {21,0x1F5FFC},
    [I(45,93)] = {19,0x2DFFC},
    [I(46,93)] = {19,0x2FFFC},
    [I(47,93)] = {19,0x31FFC},
    [I(48,93)] = {18,0x1FFC},
    [I(49,93)] = {18,0x3FFC},
    [I(50,93)] = {18,0x5FFC},
    [I(51,93)] = {19,0x33FFC},
    [I(52,93)] = {19,0x35FFC},
    [I(53,93)] = {19,0x37FFC},
    [I(54,93)] = {19,0x39FFC},
    [I(55,93)] = {19,0x3BFFC},
    [I(56,93)] = {19,0x3DFFC},
    [I(57,93)] = {19,0x3FFFC},
    [I(58,93)] = {20,0xB9FFC},
    [I(59,93)] = {21,0x1F7FFC},
    [I(60,93)] = {28,0xFFF9FFC},
    [I(61,93)] = {19,0x41FFC},
    [I(62,93)] = {25,0x1FF7FFC},
    [I(63,93)] = {23,0x7F9FFC},
    [I(64,93)] = {26,0x3FF5FFC},
    [I(65,93)] = {19,0x43FFC},
    [I(66,93)] = {20,0xBBFFC},
    [I(67,93)] = {20,0xBDFFC},
    [I(68,93)] = {20,0xBFFFC},
    [I(69,93)] = {20,0xC1FFC},
    [I(70,93)] = {20,0xC3FFC},
    [I(71,93)] = {20,0xC5FFC},
    [I(72,93)] = {20,0xC7FFC},
    [I(73,93)] = {20,0xC9FFC},
    [I(74,93)] = {20,0xCBFFC},
    [I(75,93)] = {20,0xCDFFC},
    [I(76,93)] = {20,0xCFFFC},
    [I(77,93)] = {20,0xD1FFC},
    [I(78,93)] = {20,0xD3FFC},
    [I(79,93)] = {20,0xD5FFC},
    [I(80,93)] = {20,0xD7FFC},
    [I(81,93)] = {20,0xD9FFC},
    [I(82,93)] = {20,0xDBFFC},
    [I(83,93)] = {20,0xDDFFC},
    [I(84,93)] = {20,0xDFFFC},
    [I(85,93)] = {20,0xE1FFC},
    [I(86,93)] = {20,0xE3FFC},
    [I(87,93)] = {20,0xE5FFC},
    [I(88,93)] = {21,0x1F9FFC},
    [I(89,93)] = {20,0xE7FFC},
    [I(90,93)] = {21,0x1FBFFC},
    [I(91,93)] = {26,0x3FF7FFC},
    [I(92,93)] = {X32,0xFFFE1FFC},
    [I(93,93)] = {26,0x3FF9FFC},
    [I(94,93)] = {27,0x7FF9FFC},
    [I(95,93)] = {19,0x45FFC},
    [I(96,93)] = {28,0xFFFBFFC},
    [I(97,93)] = {18,0x7FFC},
    [I(98,93)] = {19,0x47FFC},
    [I(99,93)] = {18,0x9FFC},
    [I(100,93)] = {19,0x49FFC},
    [I(101,93)] = {18,0xBFFC},
    [I(102,93)] = {19,0x4BFFC},
    [I(103,93)] = {19,0x4DFFC},
    [I(104,93)] = {19,0x4FFFC},
    [I(105,93)] = {18,0xDFFC},
    [I(106,93)] = {20,0xE9FFC},
    [I(107,93)] = {20,0xEBFFC},
    [I(108,93)] = {19,0x51FFC},
    [I(109,93)] = {19,0x53FFC},
    [I(110,93)] = {19,0x55FFC},
    [I(111,93)] = {18,0xFFFC},
    [I(112,93)] = {19,0x57FFC},
    [I(113,93)] = {20,0xEDFFC},
    [I(114,93)] = {19,0x59FFC},
    [I(115,93)] = {18,0x11FFC},
    [I(116,93)] = {18,0x13FFC},
    [I(117,93)] = {19,0x5BFFC},
    [I(118,93)] = {20,0xEFFFC},
    [I(119,93)] = {20,0xF1FFC},
    [I(120,93)] = {20,0xF3FFC},
    [I(121,93)] = {20,0xF5FFC},
    [I(122,93)] = {20,0xF7FFC},
    [I(123,93)] = {28,0xFFFDFFC},
    [I(124,93)] = {24,0xFF9FFC},
    [I(125,93)] = {27,0x7FFBFFC},
    [I(126,93)] = {26,0x3FFBFFC},
    [I(127,93)] = {64,0},
    [I(128,93)] = {64,0},
    [I(129,93)] = {64,0},
    [I(130,93)] = {64,0},
    [I(131,93)] = {64,0},
    [I(132,93)] = {64,0},
    [I(133,93)] = {64,0},
    [I(134,93)] = {64,0},
    [I(135,93)] = {64,0},
    [I(136,93)] = {64,0},
    [I(137,93)] = {64,0},
    [I(138,93)] = {64,0},
    [I(139,93)] = {64,0},
    [I(140,93)] = {64,0},
    [I(141,93)] = {64,0},
    [I(142,93)] = {64,0},
    [I(143,93)] = {64,0},
    [I(144,93)] = {64,0},
    [I(145,93)] = {64,0},
    [I(146,93)] = {64,0},
    [I(147,93)] = {64,0},
    [I(148,93)] = {64,0},
    [I(149,93)] = {64,0},
    [I(150,93)] = {64,0},
    [I(151,93)] = {64,0},
    [I(152,93)] = {64,0},
    [I(153,93)] = {64,0},
    [I(154,93)] = {64,0},
    [I(155,93)] = {64,0},
    [I(156,93)] = {64,0},
    [I(157,93)] = {64,0},
    [I(158,93)] = {64,0},
    [I(159,93)] = {64,0},
    [I(160,93)] = {64,0},
    [I(161,93)] = {64,0},
    [I(162,93)] = {64,0},
    [I(163,93)] = {64,0},
    [I(164,93)] = {64,0},
    [I(165,93)] = {64,0},
    [I(166,93)] = {64,0},
    [I(167,93)] = {64,0},
    [I(168,93)] = {64,0},
    [I(169,93)] = {64,0},
    [I(170,93)] = {64,0},
    [I(171,93)] = {64,0},
    [I(172,93)] = {64,0},
    [I(173,93)] = {64,0},
    [I(174,93)] = {64,0},
    [I(175,93)] = {64,0},
    [I(176,93)] = {64,0},
    [I(177,93)] = {64,0},
    [I(178,93)] = {64,0},
    [I(179,93)] = {64,0},
    [I(180,93)] = {64,0},
    [I(181,93)] = {64,0},
    [I(182,93)] = {64,0},
    [I(183,93)] = {64,0},
    [I(184,93)] = {64,0},
    [I(185,93)] = {64,0},
    [I(186,93)] = {64,0},
    [I(187,93)] = {64,0},
    [I(188,93)] = {64,0},
    [I(189,93)] = {64,0},
    [I(190,93)] = {64,0},
    [I(191,93)] = {64,0},
    [I(192,93)] = {64,0},
    [I(193,93)] = {64,0},
    [I(194,93)] = {64,0},
    [I(195,93)] = {X32,0xFFFE3FFC},
    [I(196,93)] = {64,0},
    [I(197,93)] = {64,0},
    [I(198,93)] = {64,0},
    [I(199,93)] = {64,0},
    [I(200,93)] = {64,0},
    [I(201,93)] = {64,0},
    [I(202,93)] = {64,0},
    [I(203,93)] = {64,0},
    [I(204,93)] = {64,0},
    [I(205,93)] = {64,0},
    [I(206,93)] = {64,0},
    [I(207,93)] = {64,0},
    [I(208,93)] = {X32,0xFFFE5FFC},
    [I(209,93)] = {64,0},
    [I(210,93)] = {64,0},
    [I(211,93)] = {64,0},
    [I(212,93)] = {64,0},
    [I(213,93)] = {64,0},
    [I(214,93)] = {64,0},
    [I(215,93)] = {64,0},
    [I(216,93)] = {64,0},
    [I(217,93)] = {64,0},
    [I(218,93)] = {64,0},
    [I(219,93)] = {64,0},
    [I(220,93)] = {64,0},
    [I(221,93)] = {64,0},
    [I(222,93)] = {64,0},
    [I(223,93)] = {64,0},
    [I(224,93)] = {64,0},
    [I(225,93)] = {64,0},
    [I(226,93)] = {64,0},
    [I(227,93)] = {64,0},
    [I(228,93)] = {64,0},
    [I(229,93)] = {64,0},
    [I(230,93)] = {64,0},
    [I(231,93)] = {64,0},
    [I(232,93)] = {64,0},
    [I(233,93)] = {64,0},
    [I(234,93)] = {64,0},
    [I(235,93)] = {64,0},
    [I(236,93)] = {64,0},
    [I(237,93)] = {64,0},
    [I(238,93)] = {64,0},
    [I(239,93)] = {64,0},
    [I(240,93)] = {64,0},
    [I(241,93)] = {64,0},
    [I(242,93)] = {64,0},
    [I(243,93)] = {64,0},
    [I(244,93)] = {64,0},
    [I(245,93)] = {64,0},
    [I(246,93)] = {64,0},
    [I(247,93)] = {64,0},
    [I(248,93)] = {64,0},
    [I(249,93)] = {64,0},
    [I(250,93)] = {64,0},
    [I(251,93)] = {64,0},
    [I(252,93)] = {64,0},
    [I(253,93)] = {64,0},
    [I(254,93)] = {64,0},
    [I(255,93)] = {64,0},
    [I(0,94)] = {27,0x7FE3FFC},
    [I(1,94)] = {64,0},
    [I(2,94)] = {64,0},
    [I(3,94)] = {64,0},
    [I(4,94)] = {64,0},
    [I(5,94)] = {64,0},
    [I(6,94)] = {64,0},
    [I(7,94)] = {64,0},
    [I(8,94)] = {64,0},
    [I(9,94)] = {64,0},
    [I(10,94)] = {64,0},
    [I(11,94)] = {64,0},
    [I(12,94)] = {64,0},
    [I(13,94)] = {64,0},
    [I(14,94)] = {64,0},
    [I(15,94)] = {64,0},
    [I(16,94)] = {64,0},
    [I(17,94)] = {64,0},
    [I(18,94)] = {64,0},
    [I(19,94)] = {64,0},
    [I(20,94)] = {64,0},
    [I(21,94)] = {64,0},
    [I(22,94)] = {64,0},
    [I(23,94)] = {64,0},
    [I(24,94)] = {64,0},
    [I(25,94)] = {64,0},
    [I(26,94)] = {64,0},
    [I(27,94)] = {64,0},
    [I(28,94)] = {64,0},
    [I(29,94)] = {64,0},
    [I(30,94)] = {64,0},
    [I(31,94)] = {64,0},
    [I(32,94)] = {20,0x53FFC},
    [I(33,94)] = {24,0xFE3FFC},
    [I(34,94)] = {24,0xFE7FFC},
    [I(35,94)] = {26,0x3FEBFFC},
    [I(36,94)] = {27,0x7FE7FFC},
    [I(37,94)] = {20,0x57FFC},
    [I(38,94)] = {22,0x3E3FFC},
    [I(39,94)] = {25,0x1FEBFFC},
    [I(40,94)] = {24,0xFEBFFC},
    [I(41,94)] = {24,0xFEFFFC},
    [I(42,94)] = {22,0x3E7FFC},
    [I(43,94)] = {25,0x1FEFFFC},
    [I(44,94)] = {22,0x3EBFFC},
    [I(45,94)] = {20,0x5BFFC},
    [I(46,94)] = {20,0x5FFFC},
    [I(47,94)] = {20,0x63FFC},
    [I(48,94)] = {19,0x3FFC},
    [I(49,94)] = {19,0x7FFC},
    [I(50,94)] = {19,0xBFFC},
    [I(51,94)] = {20,0x67FFC},
    [I(52,94)] = {20,0x6BFFC},
    [I(53,94)] = {20,0x6FFFC},
    [I(54,94)] = {20,0x73FFC},
    [I(55,94)] = {20,0x77FFC},
    [I(56,94)] = {20,0x7BFFC},
    [I(57,94)] = {20,0x7FFFC},
    [I(58,94)] = {21,0x173FFC},
    [I(59,94)] = {22,0x3EFFFC},
    [I(60,94)] = {29,0x1FFF3FFC},
    [I(61,94)] = {20,0x83FFC},
    [I(62,94)] = {26,0x3FEFFFC},
    [I(63,94)] = {24,0xFF3FFC},
    [I(64,94)] = {27,0x7FEBFFC},
    [I(65,94)] = {20,0x87FFC},
    [I(66,94)] = {21,0x177FFC},
    [I(67,94)] = {21,0x17BFFC},
    [I(68,94)] = {21,0x17FFFC},
    [I(69,94)] = {21,0x183FFC},
    [I(70,94)] = {21,0x187FFC},
    [I(71,94)] = {21,0x18BFFC},
    [I(72,94)] = {21,0x18FFFC},
    [I(73,94)] = {21,0x193FFC},
    [I(74,94)] = {21,0x197FFC},
    [I(75,94)] = {21,0x19BFFC},
    [I(76,94)] = {21,0x19FFFC},
    [I(77,94)] = {21,0x1A3FFC},
    [I(78,94)] = {21,0x1A7FFC},
    [I(79,94)] = {21,0x1ABFFC},
    [I(80,94)] = {21,0x1AFFFC},
    [I(81,94)] = {21,0x1B3FFC},
    [I(82,94)] = {21,0x1B7FFC},
    [I(83,94)] = {21,0x1BBFFC},
    [I(84,94)] = {21,0x1BFFFC},
    [I(85,94)] = {21,0x1C3FFC},
    [I(86,94)] = {21,0x1C7FFC},
    [I(87,94)] = {21,0x1CBFFC},
    [I(88,94)] = {22,0x3F3FFC},
    [I(89,94)] = {21,0x1CFFFC},
    [I(90,94)] = {22,0x3F7FFC},
    [I(91,94)] = {27,0x7FEFFFC},
    [I(92,94)] = {64,0},
    [I(93,94)] = {27,0x7FF3FFC},
    [I(94,94)] = {28,0xFFF3FFC},
    [I(95,94)] = {20,0x8BFFC},
    [I(96,94)] = {29,0x1FFF7FFC},
    [I(97,94)] = {19,0xFFFC},
    [I(98,94)] = {20,0x8FFFC},
    [I(99,94)] = {19,0x13FFC},
    [I(100,94)] = {20,0x93FFC},
    [I(101,94)] = {19,0x17FFC},
    [I(102,94)] = {20,0x97FFC},
    [I(103,94)] = {20,0x9BFFC},
    [I(104,94)] = {20,0x9FFFC},
    [I(105,94)] = {19,0x1BFFC},
    [I(106,94)] = {21,0x1D3FFC},
    [I(107,94)] = {21,0x1D7FFC},
    [I(108,94)] = {20,0xA3FFC},
    [I(109,94)] = {20,0xA7FFC},
    [I(110,94)] = {20,0xABFFC},
    [I(111,94)] = {19,0x1FFFC},
    [I(112,94)] = {20,0xAFFFC},
    [I(113,94)] = {21,0x1DBFFC},
    [I(114,94)] = {20,0xB3FFC},
    [I(115,94)] = {19,0x23FFC},
    [I(116,94)] = {19,0x27FFC},
    [I(117,94)] = {20,0xB7FFC},
    [I(118,94)] = {21,0x1DFFFC},
    [I(119,94)] = {21,0x1E3FFC},
    [I(120,94)] = {21,0x1E7FFC},
    [I(121,94)] = {21,0x1EBFFC},
    [I(122,94)] = {21,0x1EFFFC},
    [I(123,94)] = {29,0x1FFFBFFC},
    [I(124,94)] = {25,0x1FF3FFC},
    [I(125,94)] = {28,0xFFF7FFC},
    [I(126,94)] = {27,0x7FF7FFC},
    [I(127,94)] = {64,0},
    [I(128,94)] = {64,0},
    [I(129,94)] = {64,0},
    [I(130,94)] = {64,0},
    [I(131,94)] = {64,0},
    [I(132,94)] = {64,0},
    [I(133,94)] = {64,0},
    [I(134,94)] = {64,0},
    [I(135,94)] = {64,0},
    [I(136,94)] = {64,0},
    [I(137,94)] = {64,0},
    [I(138,94)] = {64,0},
    [I(139,94)] = {64,0},
    [I(140,94)] = {64,0},
    [I(141,94)] = {64,0},
    [I(142,94)] = {64,0},
    [I(143,94)] = {64,0},
    [I(144,94)] = {64,0},
    [I(145,94)] = {64,0},
    [I(146,94)] = {64,0},
    [I(147,94)] = {64,0},
    [I(148,94)] = {64,0},
    [I(149,94)] = {64,0},
    [I(150,94)] = {64,0},
    [I(151,94)] = {64,0},
    [I(152,94)] = {64,0},
    [I(153,94)] = {64,0},
    [I(154,94)] = {64,0},
    [I(155,94)] = {64,0},
    [I(156,94)] = {64,0},
    [I(157,94)] = {64,0},
    [I(158,94)] = {64,0},
    [I(159,94)] = {64,0},
    [I(160,94)] = {64,0},
    [I(161,94)] = {64,0},
    [I(162,94)] = {64,0},
    [I(163,94)] = {64,0},
    [I(164,94)] = {64,0},
    [I(165,94)] = {64,0},
    [I(166,94)] = {64,0},
    [I(167,94)] = {64,0},
    [I(168,94)] = {64,0},
    [I(169,94)] = {64,0},
    [I(170,94)] = {64,0},
    [I(171,94)] = {64,0},
    [I(172,94)] = {64,0},
    [I(173,94)] = {64,0},
    [I(174,94)] = {64,0},
    [I(175,94)] = {64,0},
    [I(176,94)] = {64,0},
    [I(177,94)] = {64,0},
    [I(178,94)] = {64,0},
    [I(179,94)] = {64,0},
    [I(180,94)] = {64,0},
    [I(181,94)] = {64,0},
    [I(182,94)] = {64,0},
    [I(183,94)] = {64,0},
    [I(184,94)] = {64,0},
    [I(185,94)] = {64,0},
    [I(186,94)] = {64,0},
    [I(187,94)] = {64,0},
    [I(188,94)] = {64,0},
    [I(189,94)] = {64,0},
    [I(190,94)] = {64,0},
    [I(191,94)] = {64,0},
    [I(192,94)] = {64,0},
    [I(193,94)] = {64,0},
    [I(194,94)] = {64,0},
    [I(195,94)] = {64,0},
    [I(196,94)] = {64,0},
    [I(197,94)] = {64,0},
    [I(198,94)] = {64,0},
    [I(199,94)] = {64,0},
    [I(200,94)] = {64,0},
    [I(201,94)] = {64,0},
    [I(202,94)] = {64,0},
    [I(203,94)] = {64,0},
    [I(204,94)] = {64,0},
    [I(205,94)] = {64,0},
    [I(206,94)] = {64,0},
    [I(207,94)] = {64,0},
    [I(208,94)] = {64,0},
    [I(209,94)] = {64,0},
    [I(210,94)] = {64,0},
    [I(211,94)] = {64,0},
    [I(212,94)] = {64,0},
    [I(213,94)] = {64,0},
    [I(214,94)] = {64,0},
    [I(215,94)] = {64,0},
    [I(216,94)] = {64,0},
    [I(217,94)] = {64,0},
    [I(218,94)] = {64,0},
    [I(219,94)] = {64,0},
    [I(220,94)] = {64,0},
    [I(221,94)] = {64,0},
    [I(222,94)] = {64,0},
    [I(223,94)] = {64,0},
    [I(224,94)] = {64,0},
    [I(225,94)] = {64,0},
    [I(226,94)] = {64,0},
    [I(227,94)] = {64,0},
    [I(228,94)] = {64,0},
    [I(229,94)] = {64,0},
    [I(230,94)] = {64,0},
    [I(231,94)] = {64,0},
    [I(232,94)] = {64,0},
    [I(233,94)] = {64,0},
    [I(234,94)] = {64,0},
    [I(235,94)] = {64,0},
    [I(236,94)] = {64,0},
    [I(237,94)] = {64,0},
    [I(238,94)] = {64,0},
    [I(239,94)] = {64,0},
    [I(240,94)] = {64,0},
    [I(241,94)] = {64,0},
    [I(242,94)] = {64,0},
    [I(243,94)] = {64,0},
    [I(244,94)] = {64,0},
    [I(245,94)] = {64,0},
    [I(246,94)] = {64,0},
    [I(247,94)] = {64,0},
    [I(248,94)] = {64,0},
    [I(249,94)] = {64,0},
    [I(250,94)] = {64,0},
    [I(251,94)] = {64,0},
    [I(252,94)] = {64,0},
    [I(253,94)] = {64,0},
    [I(254,94)] = {64,0},
    [I(255,94)] = {64,0},
    [I(0,95)] = {19,0x7FE22},
    [I(1,95)] = {29,0x1FFFF622},
    [I(2,95)] = {64,0},
    [I(3,95)] = {64,0},
    [I(4,95)] = {64,0},
    [I(5,95)] = {64,0},
    [I(6,95)] = {64,0},
    [I(7,95)] = {64,0},
    [I(8,95)] = {64,0},
    [I(9,95)] = {30,0x3FFFFAA2},
    [I(10,95)] = {64,0},
    [I(11,95)] = {64,0},
    [I(12,95)] = {64,0},
    [I(13,95)] = {64,0},
    [I(14,95)] = {64,0},
    [I(15,95)] = {64,0},
    [I(16,95)] = {64,0},
    [I(17,95)] = {64,0},
    [I(18,95)] = {64,0},
    [I(19,95)] = {64,0},
    [I(20,95)] = {64,0},
    [I(21,95)] = {64,0},
    [I(22,95)] = {64,0},
    [I(23,95)] = {64,0},
    [I(24,95)] = {64,0},
    [I(25,95)] = {64,0},
    [I(26,95)] = {64,0},
    [I(27,95)] = {64,0},
    [I(28,95)] = {64,0},
    [I(29,95)] = {64,0},
    [I(30,95)] = {64,0},
    [I(31,95)] = {64,0},
    [I(32,95)] = {12,0x522},
    [I(33,95)] = {16,0xFE22},
    [I(34,95)] = {16,0xFE62},
    [I(35,95)] = {18,0x3FEA2},
    [I(36,95)] = {19,0x7FE62},
    [I(37,95)] = {12,0x562},
    [I(38,95)] = {14,0x3E22},
    [I(39,95)] = {17,0x1FEA2},
    [I(40,95)] = {16,0xFEA2},
    [I(41,95)] = {16,0xFEE2},
    [I(42,95)] = {14,0x3E62},
    [I(43,95)] = {17,0x1FEE2},
    [I(44,95)] = {14,0x3EA2},
    [I(45,95)] = {12,0x5A2},
    [I(46,95)] = {12,0x5E2},
    [I(47,95)] = {12,0x622},
    [I(48,95)] = {11,0x22},
    [I(49,95)] = {11,0x62},
    [I(50,95)] = {11,0xA2},
    [I(51,95)] = {12,0x662},
    [I(52,95)] = {12,0x6A2},
    [I(53,95)] = {12,0x6E2},
    [I(54,95)] = {12,0x722},
    [I(55,95)] = {12,0x762},
    [I(56,95)] = {12,0x7A2},
    [I(57,95)] = {12,0x7E2},
    [I(58,95)] = {13,0x1722},
    [I(59,95)] = {14,0x3EE2},
    [I(60,95)] = {21,0x1FFF22},
    [I(61,95)] = {12,0x822},
    [I(62,95)] = {18,0x3FEE2},
    [I(63,95)] = {16,0xFF22},
    [I(64,95)] = {19,0x7FEA2},
    [I(65,95)] = {12,0x862},
    [I(66,95)] = {13,0x1762},
    [I(67,95)] = {13,0x17A2},
    [I(68,95)] = {13,0x17E2},
    [I(69,95)] = {13,0x1822},
    [I(70,95)] = {13,0x1862},
    [I(71,95)] = {13,0x18A2},
    [I(72,95)] = {13,0x18E2},
    [I(73,95)] = {13,0x1922},
    [I(74,95)] = {13,0x1962},
    [I(75,95)] = {13,0x19A2},
    [I(76,95)] = {13,0x19E2},
    [I(77,95)] = {13,0x1A22},
    [I(78,95)] = {13,0x1A62},
    [I(79,95)] = {13,0x1AA2},
    [I(80,95)] = {13,0x1AE2},
    [I(81,95)] = {13,0x1B22},
    [I(82,95)] = {13,0x1B62},
    [I(83,95)] = {13,0x1BA2},
    [I(84,95)] = {13,0x1BE2},
    [I(85,95)] = {13,0x1C22},
    [I(86,95)] = {13,0x1C62},
    [I(87,95)] = {13,0x1CA2},
    [I(88,95)] = {14,0x3F22},
    [I(89,95)] = {13,0x1CE2},
    [I(90,95)] = {14,0x3F62},
    [I(91,95)] = {19,0x7FEE2},
    [I(92,95)] = {25,0x1FFFC22},
    [I(93,95)] = {19,0x7FF22},
    [I(94,95)] = {20,0xFFF22},
    [I(95,95)] = {12,0x8A2},
    [I(96,95)] = {21,0x1FFF62},
    [I(97,95)] = {11,0xE2},
    [I(98,95)] = {12,0x8E2},
    [I(99,95)] = {11,0x122},
    [I(100,95)] = {12,0x922},
    [I(101,95)] = {11,0x162},
    [I(102,95)] = {12,0x962},
    [I(103,95)] = {12,0x9A2},
    [I(104,95)] = {12,0x9E2},
    [I(105,95)] = {11,0x1A2},
    [I(106,95)] = {13,0x1D22},
    [I(107,95)] = {13,0x1D62},
    [I(108,95)] = {12,0xA22},
    [I(109,95)] = {12,0xA62},
    [I(110,95)] = {12,0xAA2},
    [I(111,95)] = {11,0x1E2},
    [I(112,95)] = {12,0xAE2},
    [I(113,95)] = {13,0x1DA2},
    [I(114,95)] = {12,0xB22},
    [I(115,95)] = {11,0x222},
    [I(116,95)] = {11,0x262},
    [I(117,95)] = {12,0xB62},
    [I(118,95)] = {13,0x1DE2},
    [I(119,95)] = {13,0x1E22},
    [I(120,95)] = {13,0x1E62},
    [I(121,95)] = {13,0x1EA2},
    [I(122,95)] = {13,0x1EE2},
    [I(123,95)] = {21,0x1FFFA2},
    [I(124,95)] = {17,0x1FF22},
    [I(125,95)] = {20,0xFFF62},
    [I(126,95)] = {19,0x7FF62},
    [I(127,95)] = {64,0},
    [I(128,95)] = {26,0x3FFF9A2},
    [I(129,95)] = {28,0xFFFF4A2},
    [I(130,95)] = {26,0x3FFF9E2},
    [I(131,95)] = {26,0x3FFFA22},
    [I(132,95)] = {28,0xFFFF4E2},
    [I(133,95)] = {28,0xFFFF522},
    [I(134,95)] = {28,0xFFFF562},
    [I(135,95)] = {29,0x1FFFF662},
    [I(136,95)] = {28,0xFFFF5A2},
    [I(137,95)] = {29,0x1FFFF6A2},
    [I(138,95)] = {29,0x1FFFF6E2},
    [I(139,95)] = {29,0x1FFFF722},
    [I(140,95)] = {29,0x1FFFF762},
    [I(141,95)] = {29,0x1FFFF7A2},
    [I(142,95)] = {30,0x3FFFFAE2},
    [I(143,95)] = {29,0x1FFFF7E2},
    [I(144,95)] = {30,0x3FFFFB22},
    [I(145,95)] = {30,0x3FFFFB62},
    [I(146,95)] = {28,0xFFFF5E2},
    [I(147,95)] = {29,0x1FFFF822},
    [I(148,95)] = {30,0x3FFFFBA2},
    [I(149,95)] = {29,0x1FFFF862},
    [I(150,95)] = {29,0x1FFFF8A2},
    [I(151,95)] = {29,0x1FFFF8E2},
    [I(152,95)] = {29,0x1FFFF922},
    [I(153,95)] = {27,0x7FFF722},
    [I(154,95)] = {28,0xFFFF622},
    [I(155,95)] = {29,0x1FFFF962},
    [I(156,95)] = {28,0xFFFF662},
    [I(157,95)] = {29,0x1FFFF9A2},
    [I(158,95)] = {29,0x1FFFF9E2},
    [I(159,95)] = {30,0x3FFFFBE2},
    [I(160,95)] = {28,0xFFFF6A2},
    [I(161,95)] = {27,0x7FFF762},
    [I(162,95)] = {26,0x3FFFA62},
    [I(163,95)] = {28,0xFFFF6E2},
    [I(164,95)] = {28,0xFFFF722},
    [I(165,95)] = {29,0x1FFFFA22},
    [I(166,95)] = {29,0x1FFFFA62},
    [I(167,95)] = {27,0x7FFF7A2},
    [I(168,95)] = {29,0x1FFFFAA2},
    [I(169,95)] = {28,0xFFFF762},
    [I(170,95)] = {28,0xFFFF7A2},
    [I(171,95)] = {30,0x3FFFFC22},
    [I(172,95)] = {27,0x7FFF7E2},
    [I(173,95)] = {28,0xFFFF7E2},
    [I(174,95)] = {29,0x1FFFFAE2},
    [I(175,95)] = {29,0x1FFFFB22},
    [I(176,95)] = {27,0x7FFF822},
    [I(177,95)] = {27,0x7FFF862},
    [I(178,95)] = {28,0xFFFF822},
    [I(179,95)] = {27,0x7FFF8A2},
    [I(180,95)] = {29,0x1FFFFB62},
    [I(181,95)] = {28,0xFFFF862},
    [I(182,95)] = {29,0x1FFFFBA2},
    [I(183,95)] = {29,0x1FFFFBE2},
    [I(184,95)] = {26,0x3FFFAA2},
    [I(185,95)] = {28,0xFFFF8A2},
    [I(186,95)] = {28,0xFFFF8E2},
    [I(187,95)] = {28,0xFFFF922},
    [I(188,95)] = {29,0x1FFFFC22},
    [I(189,95)] = {28,0xFFFF962},
    [I(190,95)] = {28,0xFFFF9A2},
    [I(191,95)] = {29,0x1FFFFC62},
    [I(192,95)] = {X32,0xFFFFF822},
    [I(193,95)] = {X32,0xFFFFF862},
    [I(194,95)] = {26,0x3FFFAE2},
    [I(195,95)] = {25,0x1FFFC62},
    [I(196,95)] = {28,0xFFFF9E2},
    [I(197,95)] = {29,0x1FFFFCA2},
    [I(198,95)] = {28,0xFFFFA22},
    [I(199,95)] = {31,0x7FFFFB22},
    [I(200,95)] = {X32,0xFFFFF8A2},
    [I(201,95)] = {X32,0xFFFFF8E2},
    [I(202,95)] = {X32,0xFFFFF922},
    [I(203,95)] = {64,0},
    [I(204,95)] = {64,0},
    [I(205,95)] = {X32,0xFFFFF962},
    [I(206,95)] = {30,0x3FFFFC62},
    [I(207,95)] = {31,0x7FFFFB62},
    [I(208,95)] = {25,0x1FFFCA2},
    [I(209,95)] = {27,0x7FFF8E2},
    [I(210,95)] = {X32,0xFFFFF9A2},
    [I(211,95)] = {64,0},
    [I(212,95)] = {64,0},
    [I(213,95)] = {X32,0xFFFFF9E2},
    [I(214,95)] = {64,0},
    [I(215,95)] = {30,0x3FFFFCA2},
    [I(216,95)] = {27,0x7FFF922},
    [I(217,95)] = {27,0x7FFF962},
    [I(218,95)] = {X32,0xFFFFFA22},
    [I(219,95)] = {X32,0xFFFFFA62},
    [I(220,95)] = {64,0},
    [I(221,95)] = {64,0},
    [I(222,95)] = {64,0},
    [I(223,95)] = {64,0},
    [I(224,95)] = {26,0x3FFFB22},
    [I(225,95)] = {30,0x3FFFFCE2},
    [I(226,95)] = {26,0x3FFFB62},
    [I(227,95)] = {27,0x7FFF9A2},
    [I(228,95)] = {28,0xFFFFA62},
    [I(229,95)] = {27,0x7FFF9E2},
    [I(230,95)] = {27,0x7FFFA22},
    [I(231,95)] = {29,0x1FFFFCE2},
    [I(232,95)] = {28,0xFFFFAA2},
    [I(233,95)] = {28,0xFFFFAE2},
    [I(234,95)] = {31,0x7FFFFBA2},
    [I(235,95)] = {31,0x7FFFFBE2},
    [I(236,95)] = {30,0x3FFFFD22},
    [I(237,95)] = {30,0x3FFFFD62},
    [I(238,95)] = {X32,0xFFFFFAA2},
    [I(239,95)] = {29,0x1FFFFD22},
    [I(240,95)] = {X32,0xFFFFFAE2},
    [I(241,95)] = {64,0},
    [I(242,95)] = {X32,0xFFFFFB22},
    [I(243,95)] = {X32,0xFFFFFB62},
    [I(244,95)] = {64,0},
    [I(245,95)] = {64,0},
    [I(246,95)] = {64,0},
    [I(247,95)] = {64,0},
    [I(248,95)] = {64,0},
    [I(249,95)] = {64,0},
    [I(250,95)] = {64,0},
    [I(251,95)] = {64,0},
    [I(252,95)] = {64,0},
    [I(253,95)] = {64,0},
    [I(254,95)] = {64,0},
    [I(255,95)] = {X32,0xFFFFFBA2},
    [I(0,96)] = {28,0xFFC7FFD},
    [I(1,96)] = {64,0},
    [I(2,96)] = {64,0},
    [I(3,96)] = {64,0},
    [I(4,96)] = {64,0},
    [I(5,96)] = {64,0},
    [I(6,96)] = {64,0},
    [I(7,96)] = {64,0},
    [I(8,96)] = {64,0},
    [I(9,96)] = {64,0},
    [I(10,96)] = {64,0},
    [I(11,96)] = {64,0},
    [I(12,96)] = {64,0},
    [I(13,96)] = {64,0},
    [I(14,96)] = {64,0},
    [I(15,96)] = {64,0},
    [I(16,96)] = {64,0},
    [I(17,96)] = {64,0},
    [I(18,96)] = {64,0},
    [I(19,96)] = {64,0},
    [I(20,96)] = {64,0},
    [I(21,96)] = {64,0},
    [I(22,96)] = {64,0},
    [I(23,96)] = {64,0},
    [I(24,96)] = {64,0},
    [I(25,96)] = {64,0},
    [I(26,96)] = {64,0},
    [I(27,96)] = {64,0},
    [I(28,96)] = {64,0},
    [I(29,96)] = {64,0},
    [I(30,96)] = {64,0},
    [I(31,96)] = {64,0},
    [I(32,96)] = {21,0xA7FFD},
    [I(33,96)] = {25,0x1FC7FFD},
    [I(34,96)] = {25,0x1FCFFFD},
    [I(35,96)] = {27,0x7FD7FFD},
    [I(36,96)] = {28,0xFFCFFFD},
    [I(37,96)] = {21,0xAFFFD},
    [I(38,96)] = {23,0x7C7FFD},
    [I(39,96)] = {26,0x3FD7FFD},
    [I(40,96)] = {25,0x1FD7FFD},
    [I(41,96)] = {25,0x1FDFFFD},
    [I(42,96)] = {23,0x7CFFFD},
    [I(43,96)] = {26,0x3FDFFFD},
    [I(44,96)] = {23,0x7D7FFD},
    [I(45,96)] = {21,0xB7FFD},
    [I(46,96)] = {21,0xBFFFD},
    [I(47,96)] = {21,0xC7FFD},
    [I(48,96)] = {20,0x7FFD},
    [I(49,96)] = {20,0xFFFD},
    [I(50,96)] = {20,0x17FFD},
    [I(51,96)] = {21,0xCFFFD},
    [I(52,96)] = {21,0xD7FFD},
    [I(53,96)] = {21,0xDFFFD},
    [I(54,96)] = {21,0xE7FFD},
    [I(55,96)] = {21,0xEFFFD},
    [I(56,96)] = {21,0xF7FFD},
    [I(57,96)] = {21,0xFFFFD},
    [I(58,96)] = {22,0x2E7FFD},
    [I(59,96)] = {23,0x7DFFFD},
    [I(60,96)] = {30,0x3FFE7FFD},
    [I(61,96)] = {21,0x107FFD},
    [I(62,96)] = {27,0x7FDFFFD},
    [I(63,96)] = {25,0x1FE7FFD},
    [I(64,96)] = {28,0xFFD7FFD},
    [I(65,96)] = {21,0x10FFFD},
    [I(66,96)] = {22,0x2EFFFD},
    [I(67,96)] = {22,0x2F7FFD},
    [I(68,96)] = {22,0x2FFFFD},
    [I(69,96)] = {22,0x307FFD},
    [I(70,96)] = {22,0x30FFFD},
    [I(71,96)] = {22,0x317FFD},
    [I(72,96)] = {22,0x31FFFD},
    [I(73,96)] = {22,0x327FFD},
    [I(74,96)] = {22,0x32FFFD},
    [I(75,96)] = {22,0x337FFD},
    [I(76,96)] = {22,0x33FFFD},
    [I(77,96)] = {22,0x347FFD},
    [I(78,96)] = {22,0x34FFFD},
    [I(79,96)] = {22,0x357FFD},
    [I(80,96)] = {22,0x35FFFD},
    [I(81,96)] = {22,0x367FFD},
    [I(82,96)] = {22,0x36FFFD},
    [I(83,96)] = {22,0x377FFD},
    [I(84,96)] = {22,0x37FFFD},
    [I(85,96)] = {22,0x387FFD},
    [I(86,96)] = {22,0x38FFFD},
    [I(87,96)] = {22,0x397FFD},
    [I(88,96)] = {23,0x7E7FFD},
    [I(89,96)] = {22,0x39FFFD},
    [I(90,96)] = {23,0x7EFFFD},
    [I(91,96)] = {28,0xFFDFFFD},
    [I(92,96)] = {64,0},
    [I(93,96)] = {28,0xFFE7FFD},
    [I(94,96)] = {29,0x1FFE7FFD},
    [I(95,96)] = {21,0x117FFD},
    [I(96,96)] = {30,0x3FFEFFFD},
    [I(97,96)] = {20,0x1FFFD},
    [I(98,96)] = {21,0x11FFFD},
    [I(99,96)] = {20,0x27FFD},
    [I(100,96)] = {21,0x127FFD},
    [I(101,96)] = {20,0x2FFFD},
    [I(102,96)] = {21,0x12FFFD},
    [I(103,96)] = {21,0x137FFD},
    [I(104,96)] = {21,0x13FFFD},
    [I(105,96)] = {20,0x37FFD},
    [I(106,96)] = {22,0x3A7FFD},
    [I(107,96)] = {22,0x3AFFFD},
    [I(108,96)] = {21,0x147FFD},
    [I(109,96)] = {21,0x14FFFD},
    [I(110,96)] = {21,0x157FFD},
    [I(111,96)] = {20,0x3FFFD},
    [I(112,96)] = {21,0x15FFFD},
    [I(113,96)] = {22,0x3B7FFD},
    [I(114,96)] = {21,0x167FFD},
    [I(115,96)] = {20,0x47FFD},
    [I(116,96)] = {20,0x4FFFD},
    [I(117,96)] = {21,0x16FFFD},
    [I(118,96)] = {22,0x3BFFFD},
    [I(119,96)] = {22,0x3C7FFD},
    [I(120,96)] = {22,0x3CFFFD},
    [I(121,96)] = {22,0x3D7FFD},
    [I(122,96)] = {22,0x3DFFFD},
    [I(123,96)] = {30,0x3FFF7FFD},
    [I(124,96)] = {26,0x3FE7FFD},
    [I(125,96)] = {29,0x1FFEFFFD},
    [I(126,96)] = {28,0xFFEFFFD},
    [I(127,96)] = {64,0},
    [I(128,96)] = {64,0},
    [I(129,96)] = {64,0},
    [I(130,96)] = {64,0},
    [I(131,96)] = {64,0},
    [I(132,96)] = {64,0},
    [I(133,96)] = {64,0},
    [I(134,96)] = {64,0},
    [I(135,96)] = {64,0},
    [I(136,96)] = {64,0},
    [I(137,96)] = {64,0},
    [I(138,96)] = {64,0},
    [I(139,96)] = {64,0},
    [I(140,96)] = {64,0},
    [I(141,96)] = {64,0},
    [I(142,96)] = {64,0},
    [I(143,96)] = {64,0},
    [I(144,96)] = {64,0},
    [I(145,96)] = {64,0},
    [I(146,96)] = {64,0},
    [I(147,96)] = {64,0},
    [I(148,96)] = {64,0},
    [I(149,96)] = {64,0},
    [I(150,96)] = {64,0},
    [I(151,96)] = {64,0},
    [I(152,96)] = {64,0},
    [I(153,96)] = {64,0},
    [I(154,96)] = {64,0},
    [I(155,96)] = {64,0},
    [I(156,96)] = {64,0},
    [I(157,96)] = {64,0},
    [I(158,96)] = {64,0},
    [I(159,96)] = {64,0},
    [I(160,96)] = {64,0},
    [I(161,96)] = {64,0},
    [I(162,96)] = {64,0},
    [I(163,96)] = {64,0},
    [I(164,96)] = {64,0},
    [I(165,96)] = {64,0},
    [I(166,96)] = {64,0},
    [I(167,96)] = {64,0},
    [I(168,96)] = {64,0},
    [I(169,96)] = {64,0},
    [I(170,96)] = {64,0},
    [I(171,96)] = {64,0},
    [I(172,96)] = {64,0},
    [I(173,96)] = {64,0},
    [I(174,96)] = {64,0},
    [I(175,96)] = {64,0},
    [I(176,96)] = {64,0},
    [I(177,96)] = {64,0},
    [I(178,96)] = {64,0},
    [I(179,96)] = {64,0},
    [I(180,96)] = {64,0},
    [I(181,96)] = {64,0},
    [I(182,96)] = {64,0},
    [I(183,96)] = {64,0},
    [I(184,96)] = {64,0},
    [I(185,96)] = {64,0},
    [I(186,96)] = {64,0},
    [I(187,96)] = {64,0},
    [I(188,96)] = {64,0},
    [I(189,96)] = {64,0},
    [I(190,96)] = {64,0},
    [I(191,96)] = {64,0},
    [I(192,96)] = {64,0},
    [I(193,96)] = {64,0},
    [I(194,96)] = {64,0},
    [I(195,96)] = {64,0},
    [I(196,96)] = {64,0},
    [I(197,96)] = {64,0},
    [I(198,96)] = {64,0},
    [I(199,96)] = {64,0},
    [I(200,96)] = {64,0},
    [I(201,96)] = {64,0},
    [I(202,96)] = {64,0},
    [I(203,96)] = {64,0},
    [I(204,96)] = {64,0},
    [I(205,96)] = {64,0},
    [I(206,96)] = {64,0},
    [I(207,96)] = {64,0},
    [I(208,96)] = {64,0},
    [I(209,96)] = {64,0},
    [I(210,96)] = {64,0},
    [I(211,96)] = {64,0},
    [I(212,96)] = {64,0},
    [I(213,96)] = {64,0},
    [I(214,96)] = {64,0},
    [I(215,96)] = {64,0},
    [I(216,96)] = {64,0},
    [I(217,96)] = {64,0},
    [I(218,96)] = {64,0},
    [I(219,96)] = {64,0},
    [I(220,96)] = {64,0},
    [I(221,96)] = {64,0},
    [I(222,96)] = {64,0},
    [I(223,96)] = {64,0},
    [I(224,96)] = {64,0},
    [I(225,96)] = {64,0},
    [I(226,96)] = {64,0},
    [I(227,96)] = {64,0},
    [I(228,96)] = {64,0},
    [I(229,96)] = {64,0},
    [I(230,96)] = {64,0},
    [I(231,96)] = {64,0},
    [I(232,96)] = {64,0},
    [I(233,96)] = {64,0},
    [I(234,96)] = {64,0},
    [I(235,96)] = {64,0},
    [I(236,96)] = {64,0},
    [I(237,96)] = {64,0},
    [I(238,96)] = {64,0},
    [I(239,96)] = {64,0},
    [I(240,96)] = {64,0},
    [I(241,96)] = {64,0},
    [I(242,96)] = {64,0},
    [I(243,96)] = {64,0},
    [I(244,96)] = {64,0},
    [I(245,96)] = {64,0},
    [I(246,96)] = {64,0},
    [I(247,96)] = {64,0},
    [I(248,96)] = {64,0},
    [I(249,96)] = {64,0},
    [I(250,96)] = {64,0},
    [I(251,96)] = {64,0},
    [I(252,96)] = {64,0},
    [I(253,96)] = {64,0},
    [I(254,96)] = {64,0},
    [I(255,96)] = {64,0},
    [I(0,97)] = {18,0x3FF03},
    [I(1,97)] = {28,0xFFFFB03},
    [I(2,97)] = {64,0},
    [I(3,97)] = {64,0},
    [I(4,97)] = {64,0},
    [I(5,97)] = {64,0},
    [I(6,97)] = {64,0},
    [I(7,97)] = {64,0},
    [I(8,97)] = {64,0},
    [I(9,97)] = {29,0x1FFFFD43},
    [I(10,97)] = {64,0},
    [I(11,97)] = {64,0},
    [I(12,97)] = {64,0},
    [I(13,97)] = {64,0},
    [I(14,97)] = {64,0},
    [I(15,97)] = {64,0},
    [I(16,97)] = {64,0},
    [I(17,97)] = {64,0},
    [I(18,97)] = {64,0},
    [I(19,97)] = {64,0},
    [I(20,97)] = {64,0},
    [I(21,97)] = {64,0},
    [I(22,97)] = {64,0},
    [I(23,97)] = {64,0},
    [I(24,97)] = {64,0},
    [I(25,97)] = {64,0},
    [I(26,97)] = {64,0},
    [I(27,97)] = {64,0},
    [I(28,97)] = {64,0},
    [I(29,97)] = {64,0},
    [I(30,97)] = {64,0},
    [I(31,97)] = {64,0},
    [I(32,97)] = {11,0x283},
    [I(33,97)] = {15,0x7F03},
    [I(34,97)] = {15,0x7F23},
    [I(35,97)] = {17,0x1FF43},
    [I(36,97)] = {18,0x3FF23},
    [I(37,97)] = {11,0x2A3},
    [I(38,97)] = {13,0x1F03},
    [I(39,97)] = {16,0xFF43},
    [I(40,97)] = {15,0x7F43},
    [I(41,97)] = {15,0x7F63},
    [I(42,97)] = {13,0x1F23},
    [I(43,97)] = {16,0xFF63},
    [I(44,97)] = {13,0x1F43},
    [I(45,97)] = {11,0x2C3},
    [I(46,97)] = {11,0x2E3},
    [I(47,97)] = {11,0x303},
    [I(48,97)] = {10,0x3},
    [I(49,97)] = {10,0x23},
    [I(50,97)] = {10,0x43},
    [I(51,97)] = {11,0x323},
    [I(52,97)] = {11,0x343},
    [I(53,97)] = {11,0x363},
    [I(54,97)] = {11,0x383},
    [I(55,97)] = {11,0x3A3},
    [I(56,97)] = {11,0x3C3},
    [I(57,97)] = {11,0x3E3},
    [I(58,97)] = {12,0xB83},
    [I(59,97)] = {13,0x1F63},
    [I(60,97)] = {20,0xFFF83},
    [I(61,97)] = {11,0x403},
    [I(62,97)] = {17,0x1FF63},
    [I(63,97)] = {15,0x7F83},
    [I(64,97)] = {18,0x3FF43},
    [I(65,97)] = {11,0x423},
    [I(66,97)] = {12,0xBA3},
    [I(67,97)] = {12,0xBC3},
    [I(68,97)] = {12,0xBE3},
    [I(69,97)] = {12,0xC03},
    [I(70,97)] = {12,0xC23},
    [I(71,97)] = {12,0xC43},
    [I(72,97)] = {12,0xC63},
    [I(73,97)] = {12,0xC83},
    [I(74,97)] = {12,0xCA3},
    [I(75,97)] = {12,0xCC3},
    [I(76,97)] = {12,0xCE3},
    [I(77,97)] = {12,0xD03},
    [I(78,97)] = {12,0xD23},
    [I(79,97)] = {12,0xD43},
    [I(80,97)] = {12,0xD63},
    [I(81,97)] = {12,0xD83},
    [I(82,97)] = {12,0xDA3},
    [I(83,97)] = {12,0xDC3},
    [I(84,97)] = {12,0xDE3},
    [I(85,97)] = {12,0xE03},
    [I(86,97)] = {12,0xE23},
    [I(87,97)] = {12,0xE43},
    [I(88,97)] = {13,0x1F83},
    [I(89,97)] = {12,0xE63},
    [I(90,97)] = {13,0x1FA3},
    [I(91,97)] = {18,0x3FF63},
    [I(92,97)] = {24,0xFFFE03},
    [I(93,97)] = {18,0x3FF83},
    [I(94,97)] = {19,0x7FF83},
    [I(95,97)] = {11,0x443},
    [I(96,97)] = {20,0xFFFA3},
    [I(97,97)] = {10,0x63},
    [I(98,97)] = {11,0x463},
    [I(99,97)] = {10,0x83},
    [I(100,97)] = {11,0x483},
    [I(101,97)] = {10,0xA3},
    [I(102,97)] = {11,0x4A3},
    [I(103,97)] = {11,0x4C3},
    [I(104,97)] = {11,0x4E3},
    [I(105,97)] = {10,0xC3},
    [I(106,97)] = {12,0xE83},
    [I(107,97)] = {12,0xEA3},
    [I(108,97)] = {11,0x503},
    [I(109,97)] = {11,0x523},
    [I(110,97)] = {11,0x543},
    [I(111,97)] = {10,0xE3},
    [I(112,97)] = {11,0x563},
    [I(113,97)] = {12,0xEC3},
    [I(114,97)] = {11,0x583},
    [I(115,97)] = {10,0x103},
    [I(116,97)] = {10,0x123},
    [I(117,97)] = {11,0x5A3},
    [I(118,97)] = {12,0xEE3},
    [I(119,97)] = {12,0xF03},
    [I(120,97)] = {12,0xF23},
    [I(121,97)] = {12,0xF43},
    [I(122,97)] = {12,0xF63},
    [I(123,97)] = {20,0xFFFC3},
    [I(124,97)] = {16,0xFF83},
    [I(125,97)] = {19,0x7FFA3},
    [I(126,97)] = {18,0x3FFA3},
    [I(127,97)] = {64,0},
    [I(128,97)] = {25,0x1FFFCC3},
    [I(129,97)] = {27,0x7FFFA43},
    [I(130,97)] = {25,0x1FFFCE3},
    [I(131,97)] = {25,0x1FFFD03},
    [I(132,97)] = {27,0x7FFFA63},
    [I(133,97)] = {27,0x7FFFA83},
    [I(134,97)] = {27,0x7FFFAA3},
    [I(135,97)] = {28,0xFFFFB23},
    [I(136,97)] = {27,0x7FFFAC3},
    [I(137,97)] = {28,0xFFFFB43},
    [I(138,97)] = {28,0xFFFFB63},
    [I(139,97)] = {28,0xFFFFB83},
    [I(140,97)] = {28,0xFFFFBA3},
    [I(141,97)] = {28,0xFFFFBC3},
    [I(142,97)] = {29,0x1FFFFD63},
    [I(143,97)] = {28,0xFFFFBE3},
    [I(144,97)] = {29,0x1FFFFD83},
    [I(145,97)] = {29,0x1FFFFDA3},
    [I(146,97)] = {27,0x7FFFAE3},
    [I(147,97)] = {28,0xFFFFC03},
    [I(148,97)] = {29,0x1FFFFDC3},
    [I(149,97)] = {28,0xFFFFC23},
    [I(150,97)] = {28,0xFFFFC43},
    [I(151,97)] = {28,0xFFFFC63},
    [I(152,97)] = {28,0xFFFFC83},
    [I(153,97)] = {26,0x3FFFB83},
    [I(154,97)] = {27,0x7FFFB03},
    [I(155,97)] = {28,0xFFFFCA3},
    [I(156,97)] = {27,0x7FFFB23},
    [I(157,97)] = {28,0xFFFFCC3},
    [I(158,97)] = {28,0xFFFFCE3},
    [I(159,97)] = {29,0x1FFFFDE3},
    [I(160,97)] = {27,0x7FFFB43},
    [I(161,97)] = {26,0x3FFFBA3},
    [I(162,97)] = {25,0x1FFFD23},
    [I(163,97)] = {27,0x7FFFB63},
    [I(164,97)] = {27,0x7FFFB83},
    [I(165,97)] = {28,0xFFFFD03},
    [I(166,97)] = {28,0xFFFFD23},
    [I(167,97)] = {26,0x3FFFBC3},
    [I(168,97)] = {28,0xFFFFD43},
    [I(169,97)] = {27,0x7FFFBA3},
    [I(170,97)] = {27,0x7FFFBC3},
    [I(171,97)] = {29,0x1FFFFE03},
    [I(172,97)] = {26,0x3FFFBE3},
    [I(173,97)] = {27,0x7FFFBE3},
    [I(174,97)] = {28,0xFFFFD63},
    [I(175,97)] = {28,0xFFFFD83},
    [I(176,97)] = {26,0x3FFFC03},
    [I(177,97)] = {26,0x3FFFC23},
    [I(178,97)] = {27,0x7FFFC03},
    [I(179,97)] = {26,0x3FFFC43},
    [I(180,97)] = {28,0xFFFFDA3},
    [I(181,97)] = {27,0x7FFFC23},
    [I(182,97)] = {28,0xFFFFDC3},
    [I(183,97)] = {28,0xFFFFDE3},
    [I(184,97)] = {25,0x1FFFD43},
    [I(185,97)] = {27,0x7FFFC43},
    [I(186,97)] = {27,0x7FFFC63},
    [I(187,97)] = {27,0x7FFFC83},
    [I(188,97)] = {28,0xFFFFE03},
    [I(189,97)] = {27,0x7FFFCA3},
    [I(190,97)] = {27,0x7FFFCC3},
    [I(191,97)] = {28,0xFFFFE23},
    [I(192,97)] = {31,0x7FFFFC03},
    [I(193,97)] = {31,0x7FFFFC23},
    [I(194,97)] = {25,0x1FFFD63},
    [I(195,97)] = {24,0xFFFE23},
    [I(196,97)] = {27,0x7FFFCE3},
    [I(197,97)] = {28,0xFFFFE43},
    [I(198,97)] = {27,0x7FFFD03},
    [I(199,97)] = {30,0x3FFFFD83},
    [I(200,97)] = {31,0x7FFFFC43},
    [I(201,97)] = {31,0x7FFFFC63},
    [I(202,97)] = {31,0x7FFFFC83},
    [I(203,97)] = {X32,0xFFFFFBC3},
    [I(204,97)] = {X32,0xFFFFFBE3},
    [I(205,97)] = {31,0x7FFFFCA3},
    [I(206,97)] = {29,0x1FFFFE23},
    [I(207,97)] = {30,0x3FFFFDA3},
    [I(208,97)] = {24,0xFFFE43},
    [I(209,97)] = {26,0x3FFFC63},
    [I(210,97)] = {31,0x7FFFFCC3},
    [I(211,97)] = {X32,0xFFFFFC03},
    [I(212,97)] = {X32,0xFFFFFC23},
    [I(213,97)] = {31,0x7FFFFCE3},
    [I(214,97)] = {X32,0xFFFFFC43},
    [I(215,97)] = {29,0x1FFFFE43},
    [I(216,97)] = {26,0x3FFFC83},
    [I(217,97)] = {26,0x3FFFCA3},
    [I(218,97)] = {31,0x7FFFFD03},
    [I(219,97)] = {31,0x7FFFFD23},
    [I(220,97)] = {64,0},
    [I(221,97)] = {X32,0xFFFFFC63},
    [I(222,97)] = {X32,0xFFFFFC83},
    [I(223,97)] = {X32,0xFFFFFCA3},
    [I(224,97)] = {25,0x1FFFD83},
    [I(225,97)] = {29,0x1FFFFE63},
    [I(226,97)] = {25,0x1FFFDA3},
    [I(227,97)] = {26,0x3FFFCC3},
    [I(228,97)] = {27,0x7FFFD23},
    [I(229,97)] = {26,0x3FFFCE3},
    [I(230,97)] = {26,0x3FFFD03},
    [I(231,97)] = {28,0xFFFFE63},
    [I(232,97)] = {27,0x7FFFD43},
    [I(233,97)] = {27,0x7FFFD63},
    [I(234,97)] = {30,0x3FFFFDC3},
    [I(235,97)] = {30,0x3FFFFDE3},
    [I(236,97)] = {29,0x1FFFFE83},
    [I(237,97)] = {29,0x1FFFFEA3},
    [I(238,97)] = {31,0x7FFFFD43},
    [I(239,97)] = {28,0xFFFFE83},
    [I(240,97)] = {31,0x7FFFFD63},
    [I(241,97)] = {X32,0xFFFFFCC3},
    [I(242,97)] = {31,0x7FFFFD83},
    [I(243,97)] = {31,0x7FFFFDA3},
    [I(244,97)] = {X32,0xFFFFFCE3},
    [I(245,97)] = {X32,0xFFFFFD03},
    [I(246,97)] = {X32,0xFFFFFD23},
    [I(247,97)] = {X32,0xFFFFFD43},
    [I(248,97)] = {X32,0xFFFFFD63},
    [I(249,97)] = {64,0},
    [I(250,97)] = {X32,0xFFFFFD83},
    [I(251,97)] = {X32,0xFFFFFDA3},
    [I(252,97)] = {X32,0xFFFFFDC3},
    [I(253,97)] = {X32,0xFFFFFDE3},
    [I(254,97)] = {X32,0xFFFFFE03},
    [I(255,97)] = {31,0x7FFFFDC3},
    [I(0,98)] = {19,0x7FE23},
    [I(1,98)] = {29,0x1FFFF623},
    [I(2,98)] = {64,0},
    [I(3,98)] = {64,0},
    [I(4,98)] = {64,0},
    [I(5,98)] = {64,0},
    [I(6,98)] = {64,0},
    [I(7,98)] = {64,0},
    [I(8,98)] = {64,0},
    [I(9,98)] = {30,0x3FFFFAA3},
    [I(10,98)] = {64,0},
    [I(11,98)] = {64,0},
    [I(12,98)] = {64,0},
    [I(13,98)] = {64,0},
    [I(14,98)] = {64,0},
    [I(15,98)] = {64,0},
    [I(16,98)] = {64,0},
    [I(17,98)] = {64,0},
    [I(18,98)] = {64,0},
    [I(19,98)] = {64,0},
    [I(20,98)] = {64,0},
    [I(21,98)] = {64,0},
    [I(22,98)] = {64,0},
    [I(23,98)] = {64,0},
    [I(24,98)] = {64,0},
    [I(25,98)] = {64,0},
    [I(26,98)] = {64,0},
    [I(27,98)] = {64,0},
    [I(28,98)] = {64,0},
    [I(29,98)] = {64,0},
    [I(30,98)] = {64,0},
    [I(31,98)] = {64,0},
    [I(32,98)] = {12,0x523},
    [I(33,98)] = {16,0xFE23},
    [I(34,98)] = {16,0xFE63},
    [I(35,98)] = {18,0x3FEA3},
    [I(36,98)] = {19,0x7FE63},
    [I(37,98)] = {12,0x563},
    [I(38,98)] = {14,0x3E23},
    [I(39,98)] = {17,0x1FEA3},
    [I(40,98)] = {16,0xFEA3},
    [I(41,98)] = {16,0xFEE3},
    [I(42,98)] = {14,0x3E63},
    [I(43,98)] = {17,0x1FEE3},
    [I(44,98)] = {14,0x3EA3},
    [I(45,98)] = {12,0x5A3},
    [I(46,98)] = {12,0x5E3},
    [I(47,98)] = {12,0x623},
    [I(48,98)] = {11,0x23},
    [I(49,98)] = {11,0x63},
    [I(50,98)] = {11,0xA3},
    [I(51,98)] = {12,0x663},
    [I(52,98)] = {12,0x6A3},
    [I(53,98)] = {12,0x6E3},
    [I(54,98)] = {12,0x723},
    [I(55,98)] = {12,0x763},
    [I(56,98)] = {12,0x7A3},
    [I(57,98)] = {12,0x7E3},
    [I(58,98)] = {13,0x1723},
    [I(59,98)] = {14,0x3EE3},
    [I(60,98)] = {21,0x1FFF23},
    [I(61,98)] = {12,0x823},
    [I(62,98)] = {18,0x3FEE3},
    [I(63,98)] = {16,0xFF23},
    [I(64,98)] = {19,0x7FEA3},
    [I(65,98)] = {12,0x863},
    [I(66,98)] = {13,0x1763},
    [I(67,98)] = {13,0x17A3},
    [I(68,98)] = {13,0x17E3},
    [I(69,98)] = {13,0x1823},
    [I(70,98)] = {13,0x1863},
    [I(71,98)] = {13,0x18A3},
    [I(72,98)] = {13,0x18E3},
    [I(73,98)] = {13,0x1923},
    [I(74,98)] = {13,0x1963},
    [I(75,98)] = {13,0x19A3},
    [I(76,98)] = {13,0x19E3},
    [I(77,98)] = {13,0x1A23},
    [I(78,98)] = {13,0x1A63},
    [I(79,98)] = {13,0x1AA3},
    [I(80,98)] = {13,0x1AE3},
    [I(81,98)] = {13,0x1B23},
    [I(82,98)] = {13,0x1B63},
    [I(83,98)] = {13,0x1BA3},
    [I(84,98)] = {13,0x1BE3},
    [I(85,98)] = {13,0x1C23},
    [I(86,98)] = {13,0x1C63},
    [I(87,98)] = {13,0x1CA3},
    [I(88,98)] = {14,0x3F23},
    [I(89,98)] = {13,0x1CE3},
    [I(90,98)] = {14,0x3F63},
    [I(91,98)] = {19,0x7FEE3},
    [I(92,98)] = {25,0x1FFFC23},
    [I(93,98)] = {19,0x7FF23},
    [I(94,98)] = {20,0xFFF23},
    [I(95,98)] = {12,0x8A3},
    [I(96,98)] = {21,0x1FFF63},
    [I(97,98)] = {11,0xE3},
    [I(98,98)] = {12,0x8E3},
    [I(99,98)] = {11,0x123},
    [I(100,98)] = {12,0x923},
    [I(101,98)] = {11,0x163},
    [I(102,98)] = {12,0x963},
    [I(103,98)] = {12,0x9A3},
    [I(104,98)] = {12,0x9E3},
    [I(105,98)] = {11,0x1A3},
    [I(106,98)] = {13,0x1D23},
    [I(107,98)] = {13,0x1D63},
    [I(108,98)] = {12,0xA23},
    [I(109,98)] = {12,0xA63},
    [I(110,98)] = {12,0xAA3},
    [I(111,98)] = {11,0x1E3},
    [I(112,98)] = {12,0xAE3},
    [I(113,98)] = {13,0x1DA3},
    [I(114,98)] = {12,0xB23},
    [I(115,98)] = {11,0x223},
    [I(116,98)] = {11,0x263},
    [I(117,98)] = {12,0xB63},
    [I(118,98)] = {13,0x1DE3},
    [I(119,98)] = {13,0x1E23},
    [I(120,98)] = {13,0x1E63},
    [I(121,98)] = {13,0x1EA3},
    [I(122,98)] = {13,0x1EE3},
    [I(123,98)] = {21,0x1FFFA3},
    [I(124,98)] = {17,0x1FF23},
    [I(125,98)] = {20,0xFFF63},
    [I(126,98)] = {19,0x7FF63},
    [I(127,98)] = {64,0},
    [I(128,98)] = {26,0x3FFF9A3},
    [I(129,98)] = {28,0xFFFF4A3},
    [I(130,98)] = {26,0x3FFF9E3},
    [I(131,98)] = {26,0x3FFFA23},
    [I(132,98)] = {28,0xFFFF4E3},
    [I(133,98)] = {28,0xFFFF523},
    [I(134,98)] = {28,0xFFFF563},
    [I(135,98)] = {29,0x1FFFF663},
    [I(136,98)] = {28,0xFFFF5A3},
    [I(137,98)] = {29,0x1FFFF6A3},
    [I(138,98)] = {29,0x1FFFF6E3},
    [I(139,98)] = {29,0x1FFFF723},
    [I(140,98)] = {29,0x1FFFF763},
    [I(141,98)] = {29,0x1FFFF7A3},
    [I(142,98)] = {30,0x3FFFFAE3},
    [I(143,98)] = {29,0x1FFFF7E3},
    [I(144,98)] = {30,0x3FFFFB23},
    [I(145,98)] = {30,0x3FFFFB63},
    [I(146,98)] = {28,0xFFFF5E3},
    [I(147,98)] = {29,0x1FFFF823},
    [I(148,98)] = {30,0x3FFFFBA3},
    [I(149,98)] = {29,0x1FFFF863},
    [I(150,98)] = {29,0x1FFFF8A3},
    [I(151,98)] = {29,0x1FFFF8E3},
    [I(152,98)] = {29,0x1FFFF923},
    [I(153,98)] = {27,0x7FFF723},
    [I(154,98)] = {28,0xFFFF623},
    [I(155,98)] = {29,0x1FFFF963},
    [I(156,98)] = {28,0xFFFF663},
    [I(157,98)] = {29,0x1FFFF9A3},
    [I(158,98)] = {29,0x1FFFF9E3},
    [I(159,98)] = {30,0x3FFFFBE3},
    [I(160,98)] = {28,0xFFFF6A3},
    [I(161,98)] = {27,0x7FFF763},
    [I(162,98)] = {26,0x3FFFA63},
    [I(163,98)] = {28,0xFFFF6E3},
    [I(164,98)] = {28,0xFFFF723},
    [I(165,98)] = {29,0x1FFFFA23},
    [I(166,98)] = {29,0x1FFFFA63},
    [I(167,98)] = {27,0x7FFF7A3},
    [I(168,98)] = {29,0x1FFFFAA3},
    [I(169,98)] = {28,0xFFFF763},
    [I(170,98)] = {28,0xFFFF7A3},
    [I(171,98)] = {30,0x3FFFFC23},
    [I(172,98)] = {27,0x7FFF7E3},
    [I(173,98)] = {28,0xFFFF7E3},
    [I(174,98)] = {29,0x1FFFFAE3},
    [I(175,98)] = {29,0x1FFFFB23},
    [I(176,98)] = {27,0x7FFF823},
    [I(177,98)] = {27,0x7FFF863},
    [I(178,98)] = {28,0xFFFF823},
    [I(179,98)] = {27,0x7FFF8A3},
    [I(180,98)] = {29,0x1FFFFB63},
    [I(181,98)] = {28,0xFFFF863},
    [I(182,98)] = {29,0x1FFFFBA3},
    [I(183,98)] = {29,0x1FFFFBE3},
    [I(184,98)] = {26,0x3FFFAA3},
    [I(185,98)] = {28,0xFFFF8A3},
    [I(186,98)] = {28,0xFFFF8E3},
    [I(187,98)] = {28,0xFFFF923},
    [I(188,98)] = {29,0x1FFFFC23},
    [I(189,98)] = {28,0xFFFF963},
    [I(190,98)] = {28,0xFFFF9A3},
    [I(191,98)] = {29,0x1FFFFC63},
    [I(192,98)] = {X32,0xFFFFF823},
    [I(193,98)] = {X32,0xFFFFF863},
    [I(194,98)] = {26,0x3FFFAE3},
    [I(195,98)] = {25,0x1FFFC63},
    [I(196,98)] = {28,0xFFFF9E3},
    [I(197,98)] = {29,0x1FFFFCA3},
    [I(198,98)] = {28,0xFFFFA23},
    [I(199,98)] = {31,0x7FFFFB23},
    [I(200,98)] = {X32,0xFFFFF8A3},
    [I(201,98)] = {X32,0xFFFFF8E3},
    [I(202,98)] = {X32,0xFFFFF923},
    [I(203,98)] = {64,0},
    [I(204,98)] = {64,0},
    [I(205,98)] = {X32,0xFFFFF963},
    [I(206,98)] = {30,0x3FFFFC63},
    [I(207,98)] = {31,0x7FFFFB63},
    [I(208,98)] = {25,0x1FFFCA3},
    [I(209,98)] = {27,0x7FFF8E3},
    [I(210,98)] = {X32,0xFFFFF9A3},
    [I(211,98)] = {64,0},
    [I(212,98)] = {64,0},
    [I(213,98)] = {X32,0xFFFFF9E3},
    [I(214,98)] = {64,0},
    [I(215,98)] = {30,0x3FFFFCA3},
    [I(216,98)] = {27,0x7FFF923},
    [I(217,98)] = {27,0x7FFF963},
    [I(218,98)] = {X32,0xFFFFFA23},
    [I(219,98)] = {X32,0xFFFFFA63},
    [I(220,98)] = {64,0},
    [I(221,98)] = {64,0},
    [I(222,98)] = {64,0},
    [I(223,98)] = {64,0},
    [I(224,98)] = {26,0x3FFFB23},
    [I(225,98)] = {30,0x3FFFFCE3},
    [I(226,98)] = {26,0x3FFFB63},
    [I(227,98)] = {27,0x7FFF9A3},
    [I(228,98)] = {28,0xFFFFA63},
    [I(229,98)] = {27,0x7FFF9E3},
    [I(230,98)] = {27,0x7FFFA23},
    [I(231,98)] = {29,0x1FFFFCE3},
    [I(232,98)] = {28,0xFFFFAA3},
    [I(233,98)] = {28,0xFFFFAE3},
    [I(234,98)] = {31,0x7FFFFBA3},
    [I(235,98)] = {31,0x7FFFFBE3},
    [I(236,98)] = {30,0x3FFFFD23},
    [I(237,98)] = {30,0x3FFFFD63},
    [I(238,98)] = {X32,0xFFFFFAA3},
    [I(239,98)] = {29,0x1FFFFD23},
    [I(240,98)] = {X32,0xFFFFFAE3},
    [I(241,98)] = {64,0},
    [I(242,98)] = {X32,0xFFFFFB23},
    [I(243,98)] = {X32,0xFFFFFB63},
    [I(244,98)] = {64,0},
    [I(245,98)] = {64,0},
    [I(246,98)] = {64,0},
    [I(247,98)] = {64,0},
    [I(248,98)] = {64,0},
    [I(249,98)] = {64,0},
    [I(250,98)] = {64,0},
    [I(251,98)] = {64,0},
    [I(252,98)] = {64,0},
    [I(253,98)] = {64,0},
    [I(254,98)] = {64,0},
    [I(255,98)] = {X32,0xFFFFFBA3},
    [I(0,99)] = {18,0x3FF04},
    [I(1,99)] = {28,0xFFFFB04},
    [I(2,99)] = {64,0},
    [I(3,99)] = {64,0},
    [I(4,99)] = {64,0},
    [I(5,99)] = {64,0},
    [I(6,99)] = {64,0},
    [I(7,99)] = {64,0},
    [I(8,99)] = {64,0},
    [I(9,99)] = {29,0x1FFFFD44},
    [I(10,99)] = {64,0},
    [I(11,99)] = {64,0},
    [I(12,99)] = {64,0},
    [I(13,99)] = {64,0},
    [I(14,99)] = {64,0},
    [I(15,99)] = {64,0},
    [I(16,99)] = {64,0},
    [I(17,99)] = {64,0},
    [I(18,99)] = {64,0},
    [I(19,99)] = {64,0},
    [I(20,99)] = {64,0},
    [I(21,99)] = {64,0},
    [I(22,99)] = {64,0},
    [I(23,99)] = {64,0},
    [I(24,99)] = {64,0},
    [I(25,99)] = {64,0},
    [I(26,99)] = {64,0},
    [I(27,99)] = {64,0},
    [I(28,99)] = {64,0},
    [I(29,99)] = {64,0},
    [I(30,99)] = {64,0},
    [I(31,99)] = {64,0},
    [I(32,99)] = {11,0x284},
    [I(33,99)] = {15,0x7F04},
    [I(34,99)] = {15,0x7F24},
    [I(35,99)] = {17,0x1FF44},
    [I(36,99)] = {18,0x3FF24},
    [I(37,99)] = {11,0x2A4},
    [I(38,99)] = {13,0x1F04},
    [I(39,99)] = {16,0xFF44},
    [I(40,99)] = {15,0x7F44},
    [I(41,99)] = {15,0x7F64},
    [I(42,99)] = {13,0x1F24},
    [I(43,99)] = {16,0xFF64},
    [I(44,99)] = {13,0x1F44},
    [I(45,99)] = {11,0x2C4},
    [I(46,99)] = {11,0x2E4},
    [I(47,99)] = {11,0x304},
    [I(48,99)] = {10,0x4},
    [I(49,99)] = {10,0x24},
    [I(50,99)] = {10,0x44},
    [I(51,99)] = {11,0x324},
    [I(52,99)] = {11,0x344},
    [I(53,99)] = {11,0x364},
    [I(54,99)] = {11,0x384},
    [I(55,99)] = {11,0x3A4},
    [I(56,99)] = {11,0x3C4},
    [I(57,99)] = {11,0x3E4},
    [I(58,99)] = {12,0xB84},
    [I(59,99)] = {13,0x1F64},
    [I(60,99)] = {20,0xFFF84},
    [I(61,99)] = {11,0x404},
    [I(62,99)] = {17,0x1FF64},
    [I(63,99)] = {15,0x7F84},
    [I(64,99)] = {18,0x3FF44},
    [I(65,99)] = {11,0x424},
    [I(66,99)] = {12,0xBA4},
    [I(67,99)] = {12,0xBC4},
    [I(68,99)] = {12,0xBE4},
    [I(69,99)] = {12,0xC04},
    [I(70,99)] = {12,0xC24},
    [I(71,99)] = {12,0xC44},
    [I(72,99)] = {12,0xC64},
    [I(73,99)] = {12,0xC84},
    [I(74,99)] = {12,0xCA4},
    [I(75,99)] = {12,0xCC4},
    [I(76,99)] = {12,0xCE4},
    [I(77,99)] = {12,0xD04},
    [I(78,99)] = {12,0xD24},
    [I(79,99)] = {12,0xD44},
    [I(80,99)] = {12,0xD64},
    [I(81,99)] = {12,0xD84},
    [I(82,99)] = {12,0xDA4},
    [I(83,99)] = {12,0xDC4},
    [I(84,99)] = {12,0xDE4},
    [I(85,99)] = {12,0xE04},
    [I(86,99)] = {12,0xE24},
    [I(87,99)] = {12,0xE44},
    [I(88,99)] = {13,0x1F84},
    [I(89,99)] = {12,0xE64},
    [I(90,99)] = {13,0x1FA4},
    [I(91,99)] = {18,0x3FF64},
    [I(92,99)] = {24,0xFFFE04},
    [I(93,99)] = {18,0x3FF84},
    [I(94,99)] = {19,0x7FF84},
    [I(95,99)] = {11,0x444},
    [I(96,99)] = {20,0xFFFA4},
    [I(97,99)] = {10,0x64},
    [I(98,99)] = {11,0x464},
    [I(99,99)] = {10,0x84},
    [I(100,99)] = {11,0x484},
    [I(101,99)] = {10,0xA4},
    [I(102,99)] = {11,0x4A4},
    [I(103,99)] = {11,0x4C4},
    [I(104,99)] = {11,0x4E4},
    [I(105,99)] = {10,0xC4},
    [I(106,99)] = {12,0xE84},
    [I(107,99)] = {12,0xEA4},
    [I(108,99)] = {11,0x504},
    [I(109,99)] = {11,0x524},
    [I(110,99)] = {11,0x544},
    [I(111,99)] = {10,0xE4},
    [I(112,99)] = {11,0x564},
    [I(113,99)] = {12,0xEC4},
    [I(114,99)] = {11,0x584},
    [I(115,99)] = {10,0x104},
    [I(116,99)] = {10,0x124},
    [I(117,99)] = {11,0x5A4},
    [I(118,99)] = {12,0xEE4},
    [I(119,99)] = {12,0xF04},
    [I(120,99)] = {12,0xF24},
    [I(121,99)] = {12,0xF44},
    [I(122,99)] = {12,0xF64},
    [I(123,99)] = {20,0xFFFC4},
    [I(124,99)] = {16,0xFF84},
    [I(125,99)] = {19,0x7FFA4},
    [I(126,99)] = {18,0x3FFA4},
    [I(127,99)] = {64,0},
    [I(128,99)] = {25,0x1FFFCC4},
    [I(129,99)] = {27,0x7FFFA44},
    [I(130,99)] = {25,0x1FFFCE4},
    [I(131,99)] = {25,0x1FFFD04},
    [I(132,99)] = {27,0x7FFFA64},
    [I(133,99)] = {27,0x7FFFA84},
    [I(134,99)] = {27,0x7FFFAA4},
    [I(135,99)] = {28,0xFFFFB24},
    [I(136,99)] = {27,0x7FFFAC4},
    [I(137,99)] = {28,0xFFFFB44},
    [I(138,99)] = {28,0xFFFFB64},
    [I(139,99)] = {28,0xFFFFB84},
    [I(140,99)] = {28,0xFFFFBA4},
    [I(141,99)] = {28,0xFFFFBC4},
    [I(142,99)] = {29,0x1FFFFD64},
    [I(143,99)] = {28,0xFFFFBE4},
    [I(144,99)] = {29,0x1FFFFD84},
    [I(145,99)] = {29,0x1FFFFDA4},
    [I(146,99)] = {27,0x7FFFAE4},
    [I(147,99)] = {28,0xFFFFC04},
    [I(148,99)] = {29,0x1FFFFDC4},
    [I(149,99)] = {28,0xFFFFC24},
    [I(150,99)] = {28,0xFFFFC44},
    [I(151,99)] = {28,0xFFFFC64},
    [I(152,99)] = {28,0xFFFFC84},
    [I(153,99)] = {26,0x3FFFB84},
    [I(154,99)] = {27,0x7FFFB04},
    [I(155,99)] = {28,0xFFFFCA4},
    [I(156,99)] = {27,0x7FFFB24},
    [I(157,99)] = {28,0xFFFFCC4},
    [I(158,99)] = {28,0xFFFFCE4},
    [I(159,99)] = {29,0x1FFFFDE4},
    [I(160,99)] = {27,0x7FFFB44},
    [I(161,99)] = {26,0x3FFFBA4},
    [I(162,99)] = {25,0x1FFFD24},
    [I(163,99)] = {27,0x7FFFB64},
    [I(164,99)] = {27,0x7FFFB84},
    [I(165,99)] = {28,0xFFFFD04},
    [I(166,99)] = {28,0xFFFFD24},
    [I(167,99)] = {26,0x3FFFBC4},
    [I(168,99)] = {28,0xFFFFD44},
    [I(169,99)] = {27,0x7FFFBA4},
    [I(170,99)] = {27,0x7FFFBC4},
    [I(171,99)] = {29,0x1FFFFE04},
    [I(172,99)] = {26,0x3FFFBE4},
    [I(173,99)] = {27,0x7FFFBE4},
    [I(174,99)] = {28,0xFFFFD64},
    [I(175,99)] = {28,0xFFFFD84},
    [I(176,99)] = {26,0x3FFFC04},
    [I(177,99)] = {26,0x3FFFC24},
    [I(178,99)] = {27,0x7FFFC04},
    [I(179,99)] = {26,0x3FFFC44},
    [I(180,99)] = {28,0xFFFFDA4},
    [I(181,99)] = {27,0x7FFFC24},
    [I(182,99)] = {28,0xFFFFDC4},
    [I(183,99)] = {28,0xFFFFDE4},
    [I(184,99)] = {25,0x1FFFD44},
    [I(185,99)] = {27,0x7FFFC44},
    [I(186,99)] = {27,0x7FFFC64},
    [I(187,99)] = {27,0x7FFFC84},
    [I(188,99)] = {28,0xFFFFE04},
    [I(189,99)] = {27,0x7FFFCA4},
    [I(190,99)] = {27,0x7FFFCC4},
    [I(191,99)] = {28,0xFFFFE24},
    [I(192,99)] = {31,0x7FFFFC04},
    [I(193,99)] = {31,0x7FFFFC24},
    [I(194,99)] = {25,0x1FFFD64},
    [I(195,99)] = {24,0xFFFE24},
    [I(196,99)] = {27,0x7FFFCE4},
    [I(197,99)] = {28,0xFFFFE44},
    [I(198,99)] = {27,0x7FFFD04},
    [I(199,99)] = {30,0x3FFFFD84},
    [I(200,99)] = {31,0x7FFFFC44},
    [I(201,99)] = {31,0x7FFFFC64},
    [I(202,99)] = {31,0x7FFFFC84},
    [I(203,99)] = {X32,0xFFFFFBC4},
    [I(204,99)] = {X32,0xFFFFFBE4},
    [I(205,99)] = {31,0x7FFFFCA4},
    [I(206,99)] = {29,0x1FFFFE24},
    [I(207,99)] = {30,0x3FFFFDA4},
    [I(208,99)] = {24,0xFFFE44},
    [I(209,99)] = {26,0x3FFFC64},
    [I(210,99)] = {31,0x7FFFFCC4},
    [I(211,99)] = {X32,0xFFFFFC04},
    [I(212,99)] = {X32,0xFFFFFC24},
    [I(213,99)] = {31,0x7FFFFCE4},
    [I(214,99)] = {X32,0xFFFFFC44},
    [I(215,99)] = {29,0x1FFFFE44},
    [I(216,99)] = {26,0x3FFFC84},
    [I(217,99)] = {26,0x3FFFCA4},
    [I(218,99)] = {31,0x7FFFFD04},
    [I(219,99)] = {31,0x7FFFFD24},
    [I(220,99)] = {64,0},
    [I(221,99)] = {X32,0xFFFFFC64},
    [I(222,99)] = {X32,0xFFFFFC84},
    [I(223,99)] = {X32,0xFFFFFCA4},
    [I(224,99)] = {25,0x1FFFD84},
    [I(225,99)] = {29,0x1FFFFE64},
    [I(226,99)] = {25,0x1FFFDA4},
    [I(227,99)] = {26,0x3FFFCC4},
    [I(228,99)] = {27,0x7FFFD24},
    [I(229,99)] = {26,0x3FFFCE4},
    [I(230,99)] = {26,0x3FFFD04},
    [I(231,99)] = {28,0xFFFFE64},
    [I(232,99)] = {27,0x7FFFD44},
    [I(233,99)] = {27,0x7FFFD64},
    [I(234,99)] = {30,0x3FFFFDC4},
    [I(235,99)] = {30,0x3FFFFDE4},
    [I(236,99)] = {29,0x1FFFFE84},
    [I(237,99)] = {29,0x1FFFFEA4},
    [I(238,99)] = {31,0x7FFFFD44},
    [I(239,99)] = {28,0xFFFFE84},
    [I(240,99)] = {31,0x7FFFFD64},
    [I(241,99)] = {X32,0xFFFFFCC4},
    [I(242,99)] = {31,0x7FFFFD84},
    [I(243,99)] = {31,0x7FFFFDA4},
    [I(244,99)] = {X32,0xFFFFFCE4},
    [I(245,99)] = {X32,0xFFFFFD04},
    [I(246,99)] = {X32,0xFFFFFD24},
    [I(247,99)] = {X32,0xFFFFFD44},
    [I(248,99)] = {X32,0xFFFFFD64},
    [I(249,99)] = {64,0},
    [I(250,99)] = {X32,0xFFFFFD84},
    [I(251,99)] = {X32,0xFFFFFDA4},
    [I(252,99)] = {X32,0xFFFFFDC4},
    [I(253,99)] = {X32,0xFFFFFDE4},
    [I(254,99)] = {X32,0xFFFFFE04},
    [I(255,99)] = {31,0x7FFFFDC4},
    [I(0,100)] = {19,0x7FE24},
    [I(1,100)] = {29,0x1FFFF624},
    [I(2,100)] = {64,0},
    [I(3,100)] = {64,0},
    [I(4,100)] = {64,0},
    [I(5,100)] = {64,0},
    [I(6,100)] = {64,0},
    [I(7,100)] = {64,0},
    [I(8,100)] = {64,0},
    [I(9,100)] = {30,0x3FFFFAA4},
    [I(10,100)] = {64,0},
    [I(11,100)] = {64,0},
    [I(12,100)] = {64,0},
    [I(13,100)] = {64,0},
    [I(14,100)] = {64,0},
    [I(15,100)] = {64,0},
    [I(16,100)] = {64,0},
    [I(17,100)] = {64,0},
    [I(18,100)] = {64,0},
    [I(19,100)] = {64,0},
    [I(20,100)] = {64,0},
    [I(21,100)] = {64,0},
    [I(22,100)] = {64,0},
    [I(23,100)] = {64,0},
    [I(24,100)] = {64,0},
    [I(25,100)] = {64,0},
    [I(26,100)] = {64,0},
    [I(27,100)] = {64,0},
    [I(28,100)] = {64,0},
    [I(29,100)] = {64,0},
    [I(30,100)] = {64,0},
    [I(31,100)] = {64,0},
    [I(32,100)] = {12,0x524},
    [I(33,100)] = {16,0xFE24},
    [I(34,100)] = {16,0xFE64},
    [I(35,100)] = {18,0x3FEA4},
    [I(36,100)] = {19,0x7FE64},
    [I(37,100)] = {12,0x564},
    [I(38,100)] = {14,0x3E24},
    [I(39,100)] = {17,0x1FEA4},
    [I(40,100)] = {16,0xFEA4},
    [I(41,100)] = {16,0xFEE4},
    [I(42,100)] = {14,0x3E64},
    [I(43,100)] = {17,0x1FEE4},
    [I(44,100)] = {14,0x3EA4},
    [I(45,100)] = {12,0x5A4},
    [I(46,100)] = {12,0x5E4},
    [I(47,100)] = {12,0x624},
    [I(48,100)] = {11,0x24},
    [I(49,100)] = {11,0x64},
    [I(50,100)] = {11,0xA4},
    [I(51,100)] = {12,0x664},
    [I(52,100)] = {12,0x6A4},
    [I(53,100)] = {12,0x6E4},
    [I(54,100)] = {12,0x724},
    [I(55,100)] = {12,0x764},
    [I(56,100)] = {12,0x7A4},
    [I(57,100)] = {12,0x7E4},
    [I(58,100)] = {13,0x1724},
    [I(59,100)] = {14,0x3EE4},
    [I(60,100)] = {21,0x1FFF24},
    [I(61,100)] = {12,0x824},
    [I(62,100)] = {18,0x3FEE4},
    [I(63,100)] = {16,0xFF24},
    [I(64,100)] = {19,0x7FEA4},
    [I(65,100)] = {12,0x864},
    [I(66,100)] = {13,0x1764},
    [I(67,100)] = {13,0x17A4},
    [I(68,100)] = {13,0x17E4},
    [I(69,100)] = {13,0x1824},
    [I(70,100)] = {13,0x1864},
    [I(71,100)] = {13,0x18A4},
    [I(72,100)] = {13,0x18E4},
    [I(73,100)] = {13,0x1924},
    [I(74,100)] = {13,0x1964},
    [I(75,100)] = {13,0x19A4},
    [I(76,100)] = {13,0x19E4},
    [I(77,100)] = {13,0x1A24},
    [I(78,100)] = {13,0x1A64},
    [I(79,100)] = {13,0x1AA4},
    [I(80,100)] = {13,0x1AE4},
    [I(81,100)] = {13,0x1B24},
    [I(82,100)] = {13,0x1B64},
    [I(83,100)] = {13,0x1BA4},
    [I(84,100)] = {13,0x1BE4},
    [I(85,100)] = {13,0x1C24},
    [I(86,100)] = {13,0x1C64},
    [I(87,100)] = {13,0x1CA4},
    [I(88,100)] = {14,0x3F24},
    [I(89,100)] = {13,0x1CE4},
    [I(90,100)] = {14,0x3F64},
    [I(91,100)] = {19,0x7FEE4},
    [I(92,100)] = {25,0x1FFFC24},
    [I(93,100)] = {19,0x7FF24},
    [I(94,100)] = {20,0xFFF24},
    [I(95,100)] = {12,0x8A4},
    [I(96,100)] = {21,0x1FFF64},
    [I(97,100)] = {11,0xE4},
    [I(98,100)] = {12,0x8E4},
    [I(99,100)] = {11,0x124},
    [I(100,100)] = {12,0x924},
    [I(101,100)] = {11,0x164},
    [I(102,100)] = {12,0x964},
    [I(103,100)] = {12,0x9A4},
    [I(104,100)] = {12,0x9E4},
    [I(105,100)] = {11,0x1A4},
    [I(106,100)] = {13,0x1D24},
    [I(107,100)] = {13,0x1D64},
    [I(108,100)] = {12,0xA24},
    [I(109,100)] = {12,0xA64},
    [I(110,100)] = {12,0xAA4},
    [I(111,100)] = {11,0x1E4},
    [I(112,100)] = {12,0xAE4},
    [I(113,100)] = {13,0x1DA4},
    [I(114,100)] = {12,0xB24},
    [I(115,100)] = {11,0x224},
    [I(116,100)] = {11,0x264},
    [I(117,100)] = {12,0xB64},
    [I(118,100)] = {13,0x1DE4},
    [I(119,100)] = {13,0x1E24},
    [I(120,100)] = {13,0x1E64},
    [I(121,100)] = {13,0x1EA4},
    [I(122,100)] = {13,0x1EE4},
    [I(123,100)] = {21,0x1FFFA4},
    [I(124,100)] = {17,0x1FF24},
    [I(125,100)] = {20,0xFFF64},
    [I(126,100)] = {19,0x7FF64},
    [I(127,100)] = {64,0},
    [I(128,100)] = {26,0x3FFF9A4},
    [I(129,100)] = {28,0xFFFF4A4},
    [I(130,100)] = {26,0x3FFF9E4},
    [I(131,100)] = {26,0x3FFFA24},
    [I(132,100)] = {28,0xFFFF4E4},
    [I(133,100)] = {28,0xFFFF524},
    [I(134,100)] = {28,0xFFFF564},
    [I(135,100)] = {29,0x1FFFF664},
    [I(136,100)] = {28,0xFFFF5A4},
    [I(137,100)] = {29,0x1FFFF6A4},
    [I(138,100)] = {29,0x1FFFF6E4},
    [I(139,100)] = {29,0x1FFFF724},
    [I(140,100)] = {29,0x1FFFF764},
    [I(141,100)] = {29,0x1FFFF7A4},
    [I(142,100)] = {30,0x3FFFFAE4},
    [I(143,100)] = {29,0x1FFFF7E4},
    [I(144,100)] = {30,0x3FFFFB24},
    [I(145,100)] = {30,0x3FFFFB64},
    [I(146,100)] = {28,0xFFFF5E4},
    [I(147,100)] = {29,0x1FFFF824},
    [I(148,100)] = {30,0x3FFFFBA4},
    [I(149,100)] = {29,0x1FFFF864},
    [I(150,100)] = {29,0x1FFFF8A4},
    [I(151,100)] = {29,0x1FFFF8E4},
    [I(152,100)] = {29,0x1FFFF924},
    [I(153,100)] = {27,0x7FFF724},
    [I(154,100)] = {28,0xFFFF624},
    [I(155,100)] = {29,0x1FFFF964},
    [I(156,100)] = {28,0xFFFF664},
    [I(157,100)] = {29,0x1FFFF9A4},
    [I(158,100)] = {29,0x1FFFF9E4},
    [I(159,100)] = {30,0x3FFFFBE4},
    [I(160,100)] = {28,0xFFFF6A4},
    [I(161,100)] = {27,0x7FFF764},
    [I(162,100)] = {26,0x3FFFA64},
    [I(163,100)] = {28,0xFFFF6E4},
    [I(164,100)] = {28,0xFFFF724},
    [I(165,100)] = {29,0x1FFFFA24},
    [I(166,100)] = {29,0x1FFFFA64},
    [I(167,100)] = {27,0x7FFF7A4},
    [I(168,100)] = {29,0x1FFFFAA4},
    [I(169,100)] = {28,0xFFFF764},
    [I(170,100)] = {28,0xFFFF7A4},
    [I(171,100)] = {30,0x3FFFFC24},
    [I(172,100)] = {27,0x7FFF7E4},
    [I(173,100)] = {28,0xFFFF7E4},
    [I(174,100)] = {29,0x1FFFFAE4},
    [I(175,100)] = {29,0x1FFFFB24},
    [I(176,100)] = {27,0x7FFF824},
    [I(177,100)] = {27,0x7FFF864},
    [I(178,100)] = {28,0xFFFF824},
    [I(179,100)] = {27,0x7FFF8A4},
    [I(180,100)] = {29,0x1FFFFB64},
    [I(181,100)] = {28,0xFFFF864},
    [I(182,100)] = {29,0x1FFFFBA4},
    [I(183,100)] = {29,0x1FFFFBE4},
    [I(184,100)] = {26,0x3FFFAA4},
    [I(185,100)] = {28,0xFFFF8A4},
    [I(186,100)] = {28,0xFFFF8E4},
    [I(187,100)] = {28,0xFFFF924},
    [I(188,100)] = {29,0x1FFFFC24},
    [I(189,100)] = {28,0xFFFF964},
    [I(190,100)] = {28,0xFFFF9A4},
    [I(191,100)] = {29,0x1FFFFC64},
    [I(192,100)] = {X32,0xFFFFF824},
    [I(193,100)] = {X32,0xFFFFF864},
    [I(194,100)] = {26,0x3FFFAE4},
    [I(195,100)] = {25,0x1FFFC64},
    [I(196,100)] = {28,0xFFFF9E4},
    [I(197,100)] = {29,0x1FFFFCA4},
    [I(198,100)] = {28,0xFFFFA24},
    [I(199,100)] = {31,0x7FFFFB24},
    [I(200,100)] = {X32,0xFFFFF8A4},
    [I(201,100)] = {X32,0xFFFFF8E4},
    [I(202,100)] = {X32,0xFFFFF924},
    [I(203,100)] = {64,0},
    [I(204,100)] = {64,0},
    [I(205,100)] = {X32,0xFFFFF964},
    [I(206,100)] = {30,0x3FFFFC64},
    [I(207,100)] = {31,0x7FFFFB64},
    [I(208,100)] = {25,0x1FFFCA4},
    [I(209,100)] = {27,0x7FFF8E4},
    [I(210,100)] = {X32,0xFFFFF9A4},
    [I(211,100)] = {64,0},
    [I(212,100)] = {64,0},
    [I(213,100)] = {X32,0xFFFFF9E4},
    [I(214,100)] = {64,0},
    [I(215,100)] = {30,0x3FFFFCA4},
    [I(216,100)] = {27,0x7FFF924},
    [I(217,100)] = {27,0x7FFF964},
    [I(218,100)] = {X32,0xFFFFFA24},
    [I(219,100)] = {X32,0xFFFFFA64},
    [I(220,100)] = {64,0},
    [I(221,100)] = {64,0},
    [I(222,100)] = {64,0},
    [I(223,100)] = {64,0},
    [I(224,100)] = {26,0x3FFFB24},
    [I(225,100)] = {30,0x3FFFFCE4},
    [I(226,100)] = {26,0x3FFFB64},
    [I(227,100)] = {27,0x7FFF9A4},
    [I(228,100)] = {28,0xFFFFA64},
    [I(229,100)] = {27,0x7FFF9E4},
    [I(230,100)] = {27,0x7FFFA24},
    [I(231,100)] = {29,0x1FFFFCE4},
    [I(232,100)] = {28,0xFFFFAA4},
    [I(233,100)] = {28,0xFFFFAE4},
    [I(234,100)] = {31,0x7FFFFBA4},
    [I(235,100)] = {31,0x7FFFFBE4},
    [I(236,100)] = {30,0x3FFFFD24},
    [I(237,100)] = {30,0x3FFFFD64},
    [I(238,100)] = {X32,0xFFFFFAA4},
    [I(239,100)] = {29,0x1FFFFD24},
    [I(240,100)] = {X32,0xFFFFFAE4},
    [I(241,100)] = {64,0},
    [I(242,100)] = {X32,0xFFFFFB24},
    [I(243,100)] = {X32,0xFFFFFB64},
    [I(244,100)] = {64,0},
    [I(245,100)] = {64,0},
    [I(246,100)] = {64,0},
    [I(247,100)] = {64,0},
    [I(248,100)] = {64,0},
    [I(249,100)] = {64,0},
    [I(250,100)] = {64,0},
    [I(251,100)] = {64,0},
    [I(252,100)] = {64,0},
    [I(253,100)] = {64,0},
    [I(254,100)] = {64,0},
    [I(255,100)] = {X32,0xFFFFFBA4},
    [I(0,101)] = {18,0x3FF05},
    [I(1,101)] = {28,0xFFFFB05},
    [I(2,101)] = {64,0},
    [I(3,101)] = {64,0},
    [I(4,101)] = {64,0},
    [I(5,101)] = {64,0},
    [I(6,101)] = {64,0},
    [I(7,101)] = {64,0},
    [I(8,101)] = {64,0},
    [I(9,101)] = {29,0x1FFFFD45},
    [I(10,101)] = {64,0},
    [I(11,101)] = {64,0},
    [I(12,101)] = {64,0},
    [I(13,101)] = {64,0},
    [I(14,101)] = {64,0},
    [I(15,101)] = {64,0},
    [I(16,101)] = {64,0},
    [I(17,101)] = {64,0},
    [I(18,101)] = {64,0},
    [I(19,101)] = {64,0},
    [I(20,101)] = {64,0},
    [I(21,101)] = {64,0},
    [I(22,101)] = {64,0},
    [I(23,101)] = {64,0},
    [I(24,101)] = {64,0},
    [I(25,101)] = {64,0},
    [I(26,101)] = {64,0},
    [I(27,101)] = {64,0},
    [I(28,101)] = {64,0},
    [I(29,101)] = {64,0},
    [I(30,101)] = {64,0},
    [I(31,101)] = {64,0},
    [I(32,101)] = {11,0x285},
    [I(33,101)] = {15,0x7F05},
    [I(34,101)] = {15,0x7F25},
    [I(35,101)] = {17,0x1FF45},
    [I(36,101)] = {18,0x3FF25},
    [I(37,101)] = {11,0x2A5},
    [I(38,101)] = {13,0x1F05},
    [I(39,101)] = {16,0xFF45},
    [I(40,101)] = {15,0x7F45},
    [I(41,101)] = {15,0x7F65},
    [I(42,101)] = {13,0x1F25},
    [I(43,101)] = {16,0xFF65},
    [I(44,101)] = {13,0x1F45},
    [I(45,101)] = {11,0x2C5},
    [I(46,101)] = {11,0x2E5},
    [I(47,101)] = {11,0x305},
    [I(48,101)] = {10,0x5},
    [I(49,101)] = {10,0x25},
    [I(50,101)] = {10,0x45},
    [I(51,101)] = {11,0x325},
    [I(52,101)] = {11,0x345},
    [I(53,101)] = {11,0x365},
    [I(54,101)] = {11,0x385},
    [I(55,101)] = {11,0x3A5},
    [I(56,101)] = {11,0x3C5},
    [I(57,101)] = {11,0x3E5},
    [I(58,101)] = {12,0xB85},
    [I(59,101)] = {13,0x1F65},
    [I(60,101)] = {20,0xFFF85},
    [I(61,101)] = {11,0x405},
    [I(62,101)] = {17,0x1FF65},
    [I(63,101)] = {15,0x7F85},
    [I(64,101)] = {18,0x3FF45},
    [I(65,101)] = {11,0x425},
    [I(66,101)] = {12,0xBA5},
    [I(67,101)] = {12,0xBC5},
    [I(68,101)] = {12,0xBE5},
    [I(69,101)] = {12,0xC05},
    [I(70,101)] = {12,0xC25},
    [I(71,101)] = {12,0xC45},
    [I(72,101)] = {12,0xC65},
    [I(73,101)] = {12,0xC85},
    [I(74,101)] = {12,0xCA5},
    [I(75,101)] = {12,0xCC5},
    [I(76,101)] = {12,0xCE5},
    [I(77,101)] = {12,0xD05},
    [I(78,101)] = {12,0xD25},
    [I(79,101)] = {12,0xD45},
    [I(80,101)] = {12,0xD65},
    [I(81,101)] = {12,0xD85},
    [I(82,101)] = {12,0xDA5},
    [I(83,101)] = {12,0xDC5},
    [I(84,101)] = {12,0xDE5},
    [I(85,101)] = {12,0xE05},
    [I(86,101)] = {12,0xE25},
    [I(87,101)] = {12,0xE45},
    [I(88,101)] = {13,0x1F85},
    [I(89,101)] = {12,0xE65},
    [I(90,101)] = {13,0x1FA5},
    [I(91,101)] = {18,0x3FF65},
    [I(92,101)] = {24,0xFFFE05},
    [I(93,101)] = {18,0x3FF85},
    [I(94,101)] = {19,0x7FF85},
    [I(95,101)] = {11,0x445},
    [I(96,101)] = {20,0xFFFA5},
    [I(97,101)] = {10,0x65},
    [I(98,101)] = {11,0x465},
    [I(99,101)] = {10,0x85},
    [I(100,101)] = {11,0x485},
    [I(101,101)] = {10,0xA5},
    [I(102,101)] = {11,0x4A5},
    [I(103,101)] = {11,0x4C5},
    [I(104,101)] = {11,0x4E5},
    [I(105,101)] = {10,0xC5},
    [I(106,101)] = {12,0xE85},
    [I(107,101)] = {12,0xEA5},
    [I(108,101)] = {11,0x505},
    [I(109,101)] = {11,0x525},
    [I(110,101)] = {11,0x545},
    [I(111,101)] = {10,0xE5},
    [I(112,101)] = {11,0x565},
    [I(113,101)] = {12,0xEC5},
    [I(114,101)] = {11,0x585},
    [I(115,101)] = {10,0x105},
    [I(116,101)] = {10,0x125},
    [I(117,101)] = {11,0x5A5},
    [I(118,101)] = {12,0xEE5},
    [I(119,101)] = {12,0xF05},
    [I(120,101)] = {12,0xF25},
    [I(121,101)] = {12,0xF45},
    [I(122,101)] = {12,0xF65},
    [I(123,101)] = {20,0xFFFC5},
    [I(124,101)] = {16,0xFF85},
    [I(125,101)] = {19,0x7FFA5},
    [I(126,101)] = {18,0x3FFA5},
    [I(127,101)] = {64,0},
    [I(128,101)] = {25,0x1FFFCC5},
    [I(129,101)] = {27,0x7FFFA45},
    [I(130,101)] = {25,0x1FFFCE5},
    [I(131,101)] = {25,0x1FFFD05},
    [I(132,101)] = {27,0x7FFFA65},
    [I(133,101)] = {27,0x7FFFA85},
    [I(134,101)] = {27,0x7FFFAA5},
    [I(135,101)] = {28,0xFFFFB25},
    [I(136,101)] = {27,0x7FFFAC5},
    [I(137,101)] = {28,0xFFFFB45},
    [I(138,101)] = {28,0xFFFFB65},
    [I(139,101)] = {28,0xFFFFB85},
    [I(140,101)] = {28,0xFFFFBA5},
    [I(141,101)] = {28,0xFFFFBC5},
    [I(142,101)] = {29,0x1FFFFD65},
    [I(143,101)] = {28,0xFFFFBE5},
    [I(144,101)] = {29,0x1FFFFD85},
    [I(145,101)] = {29,0x1FFFFDA5},
    [I(146,101)] = {27,0x7FFFAE5},
    [I(147,101)] = {28,0xFFFFC05},
    [I(148,101)] = {29,0x1FFFFDC5},
    [I(149,101)] = {28,0xFFFFC25},
    [I(150,101)] = {28,0xFFFFC45},
    [I(151,101)] = {28,0xFFFFC65},
    [I(152,101)] = {28,0xFFFFC85},
    [I(153,101)] = {26,0x3FFFB85},
    [I(154,101)] = {27,0x7FFFB05},
    [I(155,101)] = {28,0xFFFFCA5},
    [I(156,101)] = {27,0x7FFFB25},
    [I(157,101)] = {28,0xFFFFCC5},
    [I(158,101)] = {28,0xFFFFCE5},
    [I(159,101)] = {29,0x1FFFFDE5},
    [I(160,101)] = {27,0x7FFFB45},
    [I(161,101)] = {26,0x3FFFBA5},
    [I(162,101)] = {25,0x1FFFD25},
    [I(163,101)] = {27,0x7FFFB65},
    [I(164,101)] = {27,0x7FFFB85},
    [I(165,101)] = {28,0xFFFFD05},
    [I(166,101)] = {28,0xFFFFD25},
    [I(167,101)] = {26,0x3FFFBC5},
    [I(168,101)] = {28,0xFFFFD45},
    [I(169,101)] = {27,0x7FFFBA5},
    [I(170,101)] = {27,0x7FFFBC5},
    [I(171,101)] = {29,0x1FFFFE05},
    [I(172,101)] = {26,0x3FFFBE5},
    [I(173,101)] = {27,0x7FFFBE5},
    [I(174,101)] = {28,0xFFFFD65},
    [I(175,101)] = {28,0xFFFFD85},
    [I(176,101)] = {26,0x3FFFC05},
    [I(177,101)] = {26,0x3FFFC25},
    [I(178,101)] = {27,0x7FFFC05},
    [I(179,101)] = {26,0x3FFFC45},
    [I(180,101)] = {28,0xFFFFDA5},
    [I(181,101)] = {27,0x7FFFC25},
    [I(182,101)] = {28,0xFFFFDC5},
    [I(183,101)] = {28,0xFFFFDE5},
    [I(184,101)] = {25,0x1FFFD45},
    [I(185,101)] = {27,0x7FFFC45},
    [I(186,101)] = {27,0x7FFFC65},
    [I(187,101)] = {27,0x7FFFC85},
    [I(188,101)] = {28,0xFFFFE05},
    [I(189,101)] = {27,0x7FFFCA5},
    [I(190,101)] = {27,0x7FFFCC5},
    [I(191,101)] = {28,0xFFFFE25},
    [I(192,101)] = {31,0x7FFFFC05},
    [I(193,101)] = {31,0x7FFFFC25},
    [I(194,101)] = {25,0x1FFFD65},
    [I(195,101)] = {24,0xFFFE25},
    [I(196,101)] = {27,0x7FFFCE5},
    [I(197,101)] = {28,0xFFFFE45},
    [I(198,101)] = {27,0x7FFFD05},
    [I(199,101)] = {30,0x3FFFFD85},
    [I(200,101)] = {31,0x7FFFFC45},
    [I(201,101)] = {31,0x7FFFFC65},
    [I(202,101)] = {31,0x7FFFFC85},
    [I(203,101)] = {X32,0xFFFFFBC5},
    [I(204,101)] = {X32,0xFFFFFBE5},
    [I(205,101)] = {31,0x7FFFFCA5},
    [I(206,101)] = {29,0x1FFFFE25},
    [I(207,101)] = {30,0x3FFFFDA5},
    [I(208,101)] = {24,0xFFFE45},
    [I(209,101)] = {26,0x3FFFC65},
    [I(210,101)] = {31,0x7FFFFCC5},
    [I(211,101)] = {X32,0xFFFFFC05},
    [I(212,101)] = {X32,0xFFFFFC25},
    [I(213,101)] = {31,0x7FFFFCE5},
    [I(214,101)] = {X32,0xFFFFFC45},
    [I(215,101)] = {29,0x1FFFFE45},
    [I(216,101)] = {26,0x3FFFC85},
    [I(217,101)] = {26,0x3FFFCA5},
    [I(218,101)] = {31,0x7FFFFD05},
    [I(219,101)] = {31,0x7FFFFD25},
    [I(220,101)] = {64,0},
    [I(221,101)] = {X32,0xFFFFFC65},
    [I(222,101)] = {X32,0xFFFFFC85},
    [I(223,101)] = {X32,0xFFFFFCA5},
    [I(224,101)] = {25,0x1FFFD85},
    [I(225,101)] = {29,0x1FFFFE65},
    [I(226,101)] = {25,0x1FFFDA5},
    [I(227,101)] = {26,0x3FFFCC5},
    [I(228,101)] = {27,0x7FFFD25},
    [I(229,101)] = {26,0x3FFFCE5},
    [I(230,101)] = {26,0x3FFFD05},
    [I(231,101)] = {28,0xFFFFE65},
    [I(232,101)] = {27,0x7FFFD45},
    [I(233,101)] = {27,0x7FFFD65},
    [I(234,101)] = {30,0x3FFFFDC5},
    [I(235,101)] = {30,0x3FFFFDE5},
    [I(236,101)] = {29,0x1FFFFE85},
    [I(237,101)] = {29,0x1FFFFEA5},
    [I(238,101)] = {31,0x7FFFFD45},
    [I(239,101)] = {28,0xFFFFE85},
    [I(240,101)] = {31,0x7FFFFD65},
    [I(241,101)] = {X32,0xFFFFFCC5},
    [I(242,101)] = {31,0x7FFFFD85},
    [I(243,101)] = {31,0x7FFFFDA5},
    [I(244,101)] = {X32,0xFFFFFCE5},
    [I(245,101)] = {X32,0xFFFFFD05},
    [I(246,101)] = {X32,0xFFFFFD25},
    [I(247,101)] = {X32,0xFFFFFD45},
    [I(248,101)] = {X32,0xFFFFFD65},
    [I(249,101)] = {64,0},
    [I(250,101)] = {X32,0xFFFFFD85},
    [I(251,101)] = {X32,0xFFFFFDA5},
    [I(252,101)] = {X32,0xFFFFFDC5},
    [I(253,101)] = {X32,0xFFFFFDE5},
    [I(254,101)] = {X32,0xFFFFFE05},
    [I(255,101)] = {31,0x7FFFFDC5},
    [I(0,102)] = {19,0x7FE25},
    [I(1,102)] = {29,0x1FFFF625},
    [I(2,102)] = {64,0},
    [I(3,102)] = {64,0},
    [I(4,102)] = {64,0},
    [I(5,102)] = {64,0},
    [I(6,102)] = {64,0},
    [I(7,102)] = {64,0},
    [I(8,102)] = {64,0},
    [I(9,102)] = {30,0x3FFFFAA5},
    [I(10,102)] = {64,0},
    [I(11,102)] = {64,0},
    [I(12,102)] = {64,0},
    [I(13,102)] = {64,0},
    [I(14,102)] = {64,0},
    [I(15,102)] = {64,0},
    [I(16,102)] = {64,0},
    [I(17,102)] = {64,0},
    [I(18,102)] = {64,0},
    [I(19,102)] = {64,0},
    [I(20,102)] = {64,0},
    [I(21,102)] = {64,0},
    [I(22,102)] = {64,0},
    [I(23,102)] = {64,0},
    [I(24,102)] = {64,0},
    [I(25,102)] = {64,0},
    [I(26,102)] = {64,0},
    [I(27,102)] = {64,0},
    [I(28,102)] = {64,0},
    [I(29,102)] = {64,0},
    [I(30,102)] = {64,0},
    [I(31,102)] = {64,0},
    [I(32,102)] = {12,0x525},
    [I(33,102)] = {16,0xFE25},
    [I(34,102)] = {16,0xFE65},
    [I(35,102)] = {18,0x3FEA5},
    [I(36,102)] = {19,0x7FE65},
    [I(37,102)] = {12,0x565},
    [I(38,102)] = {14,0x3E25},
    [I(39,102)] = {17,0x1FEA5},
    [I(40,102)] = {16,0xFEA5},
    [I(41,102)] = {16,0xFEE5},
    [I(42,102)] = {14,0x3E65},
    [I(43,102)] = {17,0x1FEE5},
    [I(44,102)] = {14,0x3EA5},
    [I(45,102)] = {12,0x5A5},
    [I(46,102)] = {12,0x5E5},
    [I(47,102)] = {12,0x625},
    [I(48,102)] = {11,0x25},
    [I(49,102)] = {11,0x65},
    [I(50,102)] = {11,0xA5},
    [I(51,102)] = {12,0x665},
    [I(52,102)] = {12,0x6A5},
    [I(53,102)] = {12,0x6E5},
    [I(54,102)] = {12,0x725},
    [I(55,102)] = {12,0x765},
    [I(56,102)] = {12,0x7A5},
    [I(57,102)] = {12,0x7E5},
    [I(58,102)] = {13,0x1725},
    [I(59,102)] = {14,0x3EE5},
    [I(60,102)] = {21,0x1FFF25},
    [I(61,102)] = {12,0x825},
    [I(62,102)] = {18,0x3FEE5},
    [I(63,102)] = {16,0xFF25},
    [I(64,102)] = {19,0x7FEA5},
    [I(65,102)] = {12,0x865},
    [I(66,102)] = {13,0x1765},
    [I(67,102)] = {13,0x17A5},
    [I(68,102)] = {13,0x17E5},
    [I(69,102)] = {13,0x1825},
    [I(70,102)] = {13,0x1865},
    [I(71,102)] = {13,0x18A5},
    [I(72,102)] = {13,0x18E5},
    [I(73,102)] = {13,0x1925},
    [I(74,102)] = {13,0x1965},
    [I(75,102)] = {13,0x19A5},
    [I(76,102)] = {13,0x19E5},
    [I(77,102)] = {13,0x1A25},
    [I(78,102)] = {13,0x1A65},
    [I(79,102)] = {13,0x1AA5},
    [I(80,102)] = {13,0x1AE5},
    [I(81,102)] = {13,0x1B25},
    [I(82,102)] = {13,0x1B65},
    [I(83,102)] = {13,0x1BA5},
    [I(84,102)] = {13,0x1BE5},
    [I(85,102)] = {13,0x1C25},
    [I(86,102)] = {13,0x1C65},
    [I(87,102)] = {13,0x1CA5},
    [I(88,102)] = {14,0x3F25},
    [I(89,102)] = {13,0x1CE5},
    [I(90,102)] = {14,0x3F65},
    [I(91,102)] = {19,0x7FEE5},
    [I(92,102)] = {25,0x1FFFC25},
    [I(93,102)] = {19,0x7FF25},
    [I(94,102)] = {20,0xFFF25},
    [I(95,102)] = {12,0x8A5},
    [I(96,102)] = {21,0x1FFF65},
    [I(97,102)] = {11,0xE5},
    [I(98,102)] = {12,0x8E5},
    [I(99,102)] = {11,0x125},
    [I(100,102)] = {12,0x925},
    [I(101,102)] = {11,0x165},
    [I(102,102)] = {12,0x965},
    [I(103,102)] = {12,0x9A5},
    [I(104,102)] = {12,0x9E5},
    [I(105,102)] = {11,0x1A5},
    [I(106,102)] = {13,0x1D25},
    [I(107,102)] = {13,0x1D65},
    [I(108,102)] = {12,0xA25},
    [I(109,102)] = {12,0xA65},
    [I(110,102)] = {12,0xAA5},
    [I(111,102)] = {11,0x1E5},
    [I(112,102)] = {12,0xAE5},
    [I(113,102)] = {13,0x1DA5},
    [I(114,102)] = {12,0xB25},
    [I(115,102)] = {11,0x225},
    [I(116,102)] = {11,0x265},
    [I(117,102)] = {12,0xB65},
    [I(118,102)] = {13,0x1DE5},
    [I(119,102)] = {13,0x1E25},
    [I(120,102)] = {13,0x1E65},
    [I(121,102)] = {13,0x1EA5},
    [I(122,102)] = {13,0x1EE5},
    [I(123,102)] = {21,0x1FFFA5},
    [I(124,102)] = {17,0x1FF25},
    [I(125,102)] = {20,0xFFF65},
    [I(126,102)] = {19,0x7FF65},
    [I(127,102)] = {64,0},
    [I(128,102)] = {26,0x3FFF9A5},
    [I(129,102)] = {28,0xFFFF4A5},
    [I(130,102)] = {26,0x3FFF9E5},
    [I(131,102)] = {26,0x3FFFA25},
    [I(132,102)] = {28,0xFFFF4E5},
    [I(133,102)] = {28,0xFFFF525},
    [I(134,102)] = {28,0xFFFF565},
    [I(135,102)] = {29,0x1FFFF665},
    [I(136,102)] = {28,0xFFFF5A5},
    [I(137,102)] = {29,0x1FFFF6A5},
    [I(138,102)] = {29,0x1FFFF6E5},
    [I(139,102)] = {29,0x1FFFF725},
    [I(140,102)] = {29,0x1FFFF765},
    [I(141,102)] = {29,0x1FFFF7A5},
    [I(142,102)] = {30,0x3FFFFAE5},
    [I(143,102)] = {29,0x1FFFF7E5},
    [I(144,102)] = {30,0x3FFFFB25},
    [I(145,102)] = {30,0x3FFFFB65},
    [I(146,102)] = {28,0xFFFF5E5},
    [I(147,102)] = {29,0x1FFFF825},
    [I(148,102)] = {30,0x3FFFFBA5},
    [I(149,102)] = {29,0x1FFFF865},
    [I(150,102)] = {29,0x1FFFF8A5},
    [I(151,102)] = {29,0x1FFFF8E5},
    [I(152,102)] = {29,0x1FFFF925},
    [I(153,102)] = {27,0x7FFF725},
    [I(154,102)] = {28,0xFFFF625},
    [I(155,102)] = {29,0x1FFFF965},
    [I(156,102)] = {28,0xFFFF665},
    [I(157,102)] = {29,0x1FFFF9A5},
    [I(158,102)] = {29,0x1FFFF9E5},
    [I(159,102)] = {30,0x3FFFFBE5},
    [I(160,102)] = {28,0xFFFF6A5},
    [I(161,102)] = {27,0x7FFF765},
    [I(162,102)] = {26,0x3FFFA65},
    [I(163,102)] = {28,0xFFFF6E5},
    [I(164,102)] = {28,0xFFFF725},
    [I(165,102)] = {29,0x1FFFFA25},
    [I(166,102)] = {29,0x1FFFFA65},
    [I(167,102)] = {27,0x7FFF7A5},
    [I(168,102)] = {29,0x1FFFFAA5},
    [I(169,102)] = {28,0xFFFF765},
    [I(170,102)] = {28,0xFFFF7A5},
    [I(171,102)] = {30,0x3FFFFC25},
    [I(172,102)] = {27,0x7FFF7E5},
    [I(173,102)] = {28,0xFFFF7E5},
    [I(174,102)] = {29,0x1FFFFAE5},
    [I(175,102)] = {29,0x1FFFFB25},
    [I(176,102)] = {27,0x7FFF825},
    [I(177,102)] = {27,0x7FFF865},
    [I(178,102)] = {28,0xFFFF825},
    [I(179,102)] = {27,0x7FFF8A5},
    [I(180,102)] = {29,0x1FFFFB65},
    [I(181,102)] = {28,0xFFFF865},
    [I(182,102)] = {29,0x1FFFFBA5},
    [I(183,102)] = {29,0x1FFFFBE5},
    [I(184,102)] = {26,0x3FFFAA5},
    [I(185,102)] = {28,0xFFFF8A5},
    [I(186,102)] = {28,0xFFFF8E5},
    [I(187,102)] = {28,0xFFFF925},
    [I(188,102)] = {29,0x1FFFFC25},
    [I(189,102)] = {28,0xFFFF965},
    [I(190,102)] = {28,0xFFFF9A5},
    [I(191,102)] = {29,0x1FFFFC65},
    [I(192,102)] = {X32,0xFFFFF825},
    [I(193,102)] = {X32,0xFFFFF865},
    [I(194,102)] = {26,0x3FFFAE5},
    [I(195,102)] = {25,0x1FFFC65},
    [I(196,102)] = {28,0xFFFF9E5},
    [I(197,102)] = {29,0x1FFFFCA5},
    [I(198,102)] = {28,0xFFFFA25},
    [I(199,102)] = {31,0x7FFFFB25},
    [I(200,102)] = {X32,0xFFFFF8A5},
    [I(201,102)] = {X32,0xFFFFF8E5},
    [I(202,102)] = {X32,0xFFFFF925},
    [I(203,102)] = {64,0},
    [I(204,102)] = {64,0},
    [I(205,102)] = {X32,0xFFFFF965},
    [I(206,102)] = {30,0x3FFFFC65},
    [I(207,102)] = {31,0x7FFFFB65},
    [I(208,102)] = {25,0x1FFFCA5},
    [I(209,102)] = {27,0x7FFF8E5},
    [I(210,102)] = {X32,0xFFFFF9A5},
    [I(211,102)] = {64,0},
    [I(212,102)] = {64,0},
    [I(213,102)] = {X32,0xFFFFF9E5},
    [I(214,102)] = {64,0},
    [I(215,102)] = {30,0x3FFFFCA5},
    [I(216,102)] = {27,0x7FFF925},
    [I(217,102)] = {27,0x7FFF965},
    [I(218,102)] = {X32,0xFFFFFA25},
    [I(219,102)] = {X32,0xFFFFFA65},
    [I(220,102)] = {64,0},
    [I(221,102)] = {64,0},
    [I(222,102)] = {64,0},
    [I(223,102)] = {64,0},
    [I(224,102)] = {26,0x3FFFB25},
    [I(225,102)] = {30,0x3FFFFCE5},
    [I(226,102)] = {26,0x3FFFB65},
    [I(227,102)] = {27,0x7FFF9A5},
    [I(228,102)] = {28,0xFFFFA65},
    [I(229,102)] = {27,0x7FFF9E5},
    [I(230,102)] = {27,0x7FFFA25},
    [I(231,102)] = {29,0x1FFFFCE5},
    [I(232,102)] = {28,0xFFFFAA5},
    [I(233,102)] = {28,0xFFFFAE5},
    [I(234,102)] = {31,0x7FFFFBA5},
    [I(235,102)] = {31,0x7FFFFBE5},
    [I(236,102)] = {30,0x3FFFFD25},
    [I(237,102)] = {30,0x3FFFFD65},
    [I(238,102)] = {X32,0xFFFFFAA5},
    [I(239,102)] = {29,0x1FFFFD25},
    [I(240,102)] = {X32,0xFFFFFAE5},
    [I(241,102)] = {64,0},
    [I(242,102)] = {X32,0xFFFFFB25},
    [I(243,102)] = {X32,0xFFFFFB65},
    [I(244,102)] = {64,0},
    [I(245,102)] = {64,0},
    [I(246,102)] = {64,0},
    [I(247,102)] = {64,0},
    [I(248,102)] = {64,0},
    [I(249,102)] = {64,0},
    [I(250,102)] = {64,0},
    [I(251,102)] = {64,0},
    [I(252,102)] = {64,0},
    [I(253,102)] = {64,0},
    [I(254,102)] = {64,0},
    [I(255,102)] = {X32,0xFFFFFBA5},
    [I(0,103)] = {19,0x7FE26},
    [I(1,103)] = {29,0x1FFFF626},
    [I(2,103)] = {64,0},
    [I(3,103)] = {64,0},
    [I(4,103)] = {64,0},
    [I(5,103)] = {64,0},
    [I(6,103)] = {64,0},
    [I(7,103)] = {64,0},
    [I(8,103)] = {64,0},
    [I(9,103)] = {30,0x3FFFFAA6},
    [I(10,103)] = {64,0},
    [I(11,103)] = {64,0},
    [I(12,103)] = {64,0},
    [I(13,103)] = {64,0},
    [I(14,103)] = {64,0},
    [I(15,103)] = {64,0},
    [I(16,103)] = {64,0},
    [I(17,103)] = {64,0},
    [I(18,103)] = {64,0},
    [I(19,103)] = {64,0},
    [I(20,103)] = {64,0},
    [I(21,103)] = {64,0},
    [I(22,103)] = {64,0},
    [I(23,103)] = {64,0},
    [I(24,103)] = {64,0},
    [I(25,103)] = {64,0},
    [I(26,103)] = {64,0},
    [I(27,103)] = {64,0},
    [I(28,103)] = {64,0},
    [I(29,103)] = {64,0},
    [I(30,103)] = {64,0},
    [I(31,103)] = {64,0},
    [I(32,103)] = {12,0x526},
    [I(33,103)] = {16,0xFE26},
    [I(34,103)] = {16,0xFE66},
    [I(35,103)] = {18,0x3FEA6},
    [I(36,103)] = {19,0x7FE66},
    [I(37,103)] = {12,0x566},
    [I(38,103)] = {14,0x3E26},
    [I(39,103)] = {17,0x1FEA6},
    [I(40,103)] = {16,0xFEA6},
    [I(41,103)] = {16,0xFEE6},
    [I(42,103)] = {14,0x3E66},
    [I(43,103)] = {17,0x1FEE6},
    [I(44,103)] = {14,0x3EA6},
    [I(45,103)] = {12,0x5A6},
    [I(46,103)] = {12,0x5E6},
    [I(47,103)] = {12,0x626},
    [I(48,103)] = {11,0x26},
    [I(49,103)] = {11,0x66},
    [I(50,103)] = {11,0xA6},
    [I(51,103)] = {12,0x666},
    [I(52,103)] = {12,0x6A6},
    [I(53,103)] = {12,0x6E6},
    [I(54,103)] = {12,0x726},
    [I(55,103)] = {12,0x766},
    [I(56,103)] = {12,0x7A6},
    [I(57,103)] = {12,0x7E6},
    [I(58,103)] = {13,0x1726},
    [I(59,103)] = {14,0x3EE6},
    [I(60,103)] = {21,0x1FFF26},
    [I(61,103)] = {12,0x826},
    [I(62,103)] = {18,0x3FEE6},
    [I(63,103)] = {16,0xFF26},
    [I(64,103)] = {19,0x7FEA6},
    [I(65,103)] = {12,0x866},
    [I(66,103)] = {13,0x1766},
    [I(67,103)] = {13,0x17A6},
    [I(68,103)] = {13,0x17E6},
    [I(69,103)] = {13,0x1826},
    [I(70,103)] = {13,0x1866},
    [I(71,103)] = {13,0x18A6},
    [I(72,103)] = {13,0x18E6},
    [I(73,103)] = {13,0x1926},
    [I(74,103)] = {13,0x1966},
    [I(75,103)] = {13,0x19A6},
    [I(76,103)] = {13,0x19E6},
    [I(77,103)] = {13,0x1A26},
    [I(78,103)] = {13,0x1A66},
    [I(79,103)] = {13,0x1AA6},
    [I(80,103)] = {13,0x1AE6},
    [I(81,103)] = {13,0x1B26},
    [I(82,103)] = {13,0x1B66},
    [I(83,103)] = {13,0x1BA6},
    [I(84,103)] = {13,0x1BE6},
    [I(85,103)] = {13,0x1C26},
    [I(86,103)] = {13,0x1C66},
    [I(87,103)] = {13,0x1CA6},
    [I(88,103)] = {14,0x3F26},
    [I(89,103)] = {13,0x1CE6},
    [I(90,103)] = {14,0x3F66},
    [I(91,103)] = {19,0x7FEE6},
    [I(92,103)] = {25,0x1FFFC26},
    [I(93,103)] = {19,0x7FF26},
    [I(94,103)] = {20,0xFFF26},
    [I(95,103)] = {12,0x8A6},
    [I(96,103)] = {21,0x1FFF66},
    [I(97,103)] = {11,0xE6},
    [I(98,103)] = {12,0x8E6},
    [I(99,103)] = {11,0x126},
    [I(100,103)] = {12,0x926},
    [I(101,103)] = {11,0x166},
    [I(102,103)] = {12,0x966},
    [I(103,103)] = {12,0x9A6},
    [I(104,103)] = {12,0x9E6},
    [I(105,103)] = {11,0x1A6},
    [I(106,103)] = {13,0x1D26},
    [I(107,103)] = {13,0x1D66},
    [I(108,103)] = {12,0xA26},
    [I(109,103)] = {12,0xA66},
    [I(110,103)] = {12,0xAA6},
    [I(111,103)] = {11,0x1E6},
    [I(112,103)] = {12,0xAE6},
    [I(113,103)] = {13,0x1DA6},
    [I(114,103)] = {12,0xB26},
    [I(115,103)] = {11,0x226},
    [I(116,103)] = {11,0x266},
    [I(117,103)] = {12,0xB66},
    [I(118,103)] = {13,0x1DE6},
    [I(119,103)] = {13,0x1E26},
    [I(120,103)] = {13,0x1E66},
    [I(121,103)] = {13,0x1EA6},
    [I(122,103)] = {13,0x1EE6},
    [I(123,103)] = {21,0x1FFFA6},
    [I(124,103)] = {17,0x1FF26},
    [I(125,103)] = {20,0xFFF66},
    [I(126,103)] = {19,0x7FF66},
    [I(127,103)] = {64,0},
    [I(128,103)] = {26,0x3FFF9A6},
    [I(129,103)] = {28,0xFFFF4A6},
    [I(130,103)] = {26,0x3FFF9E6},
    [I(131,103)] = {26,0x3FFFA26},
    [I(132,103)] = {28,0xFFFF4E6},
    [I(133,103)] = {28,0xFFFF526},
    [I(134,103)] = {28,0xFFFF566},
    [I(135,103)] = {29,0x1FFFF666},
    [I(136,103)] = {28,0xFFFF5A6},
    [I(137,103)] = {29,0x1FFFF6A6},
    [I(138,103)] = {29,0x1FFFF6E6},
    [I(139,103)] = {29,0x1FFFF726},
    [I(140,103)] = {29,0x1FFFF766},
    [I(141,103)] = {29,0x1FFFF7A6},
    [I(142,103)] = {30,0x3FFFFAE6},
    [I(143,103)] = {29,0x1FFFF7E6},
    [I(144,103)] = {30,0x3FFFFB26},
    [I(145,103)] = {30,0x3FFFFB66},
    [I(146,103)] = {28,0xFFFF5E6},
    [I(147,103)] = {29,0x1FFFF826},
    [I(148,103)] = {30,0x3FFFFBA6},
    [I(149,103)] = {29,0x1FFFF866},
    [I(150,103)] = {29,0x1FFFF8A6},
    [I(151,103)] = {29,0x1FFFF8E6},
    [I(152,103)] = {29,0x1FFFF926},
    [I(153,103)] = {27,0x7FFF726},
    [I(154,103)] = {28,0xFFFF626},
    [I(155,103)] = {29,0x1FFFF966},
    [I(156,103)] = {28,0xFFFF666},
    [I(157,103)] = {29,0x1FFFF9A6},
    [I(158,103)] = {29,0x1FFFF9E6},
    [I(159,103)] = {30,0x3FFFFBE6},
    [I(160,103)] = {28,0xFFFF6A6},
    [I(161,103)] = {27,0x7FFF766},
    [I(162,103)] = {26,0x3FFFA66},
    [I(163,103)] = {28,0xFFFF6E6},
    [I(164,103)] = {28,0xFFFF726},
    [I(165,103)] = {29,0x1FFFFA26},
    [I(166,103)] = {29,0x1FFFFA66},
    [I(167,103)] = {27,0x7FFF7A6},
    [I(168,103)] = {29,0x1FFFFAA6},
    [I(169,103)] = {28,0xFFFF766},
    [I(170,103)] = {28,0xFFFF7A6},
    [I(171,103)] = {30,0x3FFFFC26},
    [I(172,103)] = {27,0x7FFF7E6},
    [I(173,103)] = {28,0xFFFF7E6},
    [I(174,103)] = {29,0x1FFFFAE6},
    [I(175,103)] = {29,0x1FFFFB26},
    [I(176,103)] = {27,0x7FFF826},
    [I(177,103)] = {27,0x7FFF866},
    [I(178,103)] = {28,0xFFFF826},
    [I(179,103)] = {27,0x7FFF8A6},
    [I(180,103)] = {29,0x1FFFFB66},
    [I(181,103)] = {28,0xFFFF866},
    [I(182,103)] = {29,0x1FFFFBA6},
    [I(183,103)] = {29,0x1FFFFBE6},
    [I(184,103)] = {26,0x3FFFAA6},
    [I(185,103)] = {28,0xFFFF8A6},
    [I(186,103)] = {28,0xFFFF8E6},
    [I(187,103)] = {28,0xFFFF926},
    [I(188,103)] = {29,0x1FFFFC26},
    [I(189,103)] = {28,0xFFFF966},
    [I(190,103)] = {28,0xFFFF9A6},
    [I(191,103)] = {29,0x1FFFFC66},
    [I(192,103)] = {X32,0xFFFFF826},
    [I(193,103)] = {X32,0xFFFFF866},
    [I(194,103)] = {26,0x3FFFAE6},
    [I(195,103)] = {25,0x1FFFC66},
    [I(196,103)] = {28,0xFFFF9E6},
    [I(197,103)] = {29,0x1FFFFCA6},
    [I(198,103)] = {28,0xFFFFA26},
    [I(199,103)] = {31,0x7FFFFB26},
    [I(200,103)] = {X32,0xFFFFF8A6},
    [I(201,103)] = {X32,0xFFFFF8E6},
    [I(202,103)] = {X32,0xFFFFF926},
    [I(203,103)] = {64,0},
    [I(204,103)] = {64,0},
    [I(205,103)] = {X32,0xFFFFF966},
    [I(206,103)] = {30,0x3FFFFC66},
    [I(207,103)] = {31,0x7FFFFB66},
    [I(208,103)] = {25,0x1FFFCA6},
    [I(209,103)] = {27,0x7FFF8E6},
    [I(210,103)] = {X32,0xFFFFF9A6},
    [I(211,103)] = {64,0},
    [I(212,103)] = {64,0},
    [I(213,103)] = {X32,0xFFFFF9E6},
    [I(214,103)] = {64,0},
    [I(215,103)] = {30,0x3FFFFCA6},
    [I(216,103)] = {27,0x7FFF926},
    [I(217,103)] = {27,0x7FFF966},
    [I(218,103)] = {X32,0xFFFFFA26},
    [I(219,103)] = {X32,0xFFFFFA66},
    [I(220,103)] = {64,0},
    [I(221,103)] = {64,0},
    [I(222,103)] = {64,0},
    [I(223,103)] = {64,0},
    [I(224,103)] = {26,0x3FFFB26},
    [I(225,103)] = {30,0x3FFFFCE6},
    [I(226,103)] = {26,0x3FFFB66},
    [I(227,103)] = {27,0x7FFF9A6},
    [I(228,103)] = {28,0xFFFFA66},
    [I(229,103)] = {27,0x7FFF9E6},
    [I(230,103)] = {27,0x7FFFA26},
    [I(231,103)] = {29,0x1FFFFCE6},
    [I(232,103)] = {28,0xFFFFAA6},
    [I(233,103)] = {28,0xFFFFAE6},
    [I(234,103)] = {31,0x7FFFFBA6},
    [I(235,103)] = {31,0x7FFFFBE6},
    [I(236,103)] = {30,0x3FFFFD26},
    [I(237,103)] = {30,0x3FFFFD66},
    [I(238,103)] = {X32,0xFFFFFAA6},
    [I(239,103)] = {29,0x1FFFFD26},
    [I(240,103)] = {X32,0xFFFFFAE6},
    [I(241,103)] = {64,0},
    [I(242,103)] = {X32,0xFFFFFB26},
    [I(243,103)] = {X32,0xFFFFFB66},
    [I(244,103)] = {64,0},
    [I(245,103)] = {64,0},
    [I(246,103)] = {64,0},
    [I(247,103)] = {64,0},
    [I(248,103)] = {64,0},
    [I(249,103)] = {64,0},
    [I(250,103)] = {64,0},
    [I(251,103)] = {64,0},
    [I(252,103)] = {64,0},
    [I(253,103)] = {64,0},
    [I(254,103)] = {64,0},
    [I(255,103)] = {X32,0xFFFFFBA6},
    [I(0,104)] = {19,0x7FE27},
    [I(1,104)] = {29,0x1FFFF627},
    [I(2,104)] = {64,0},
    [I(3,104)] = {64,0},
    [I(4,104)] = {64,0},
    [I(5,104)] = {64,0},
    [I(6,104)] = {64,0},
    [I(7,104)] = {64,0},
    [I(8,104)] = {64,0},
    [I(9,104)] = {30,0x3FFFFAA7},
    [I(10,104)] = {64,0},
    [I(11,104)] = {64,0},
    [I(12,104)] = {64,0},
    [I(13,104)] = {64,0},
    [I(14,104)] = {64,0},
    [I(15,104)] = {64,0},
    [I(16,104)] = {64,0},
    [I(17,104)] = {64,0},
    [I(18,104)] = {64,0},
    [I(19,104)] = {64,0},
    [I(20,104)] = {64,0},
    [I(21,104)] = {64,0},
    [I(22,104)] = {64,0},
    [I(23,104)] = {64,0},
    [I(24,104)] = {64,0},
    [I(25,104)] = {64,0},
    [I(26,104)] = {64,0},
    [I(27,104)] = {64,0},
    [I(28,104)] = {64,0},
    [I(29,104)] = {64,0},
    [I(30,104)] = {64,0},
    [I(31,104)] = {64,0},
    [I(32,104)] = {12,0x527},
    [I(33,104)] = {16,0xFE27},
    [I(34,104)] = {16,0xFE67},
    [I(35,104)] = {18,0x3FEA7},
    [I(36,104)] = {19,0x7FE67},
    [I(37,104)] = {12,0x567},
    [I(38,104)] = {14,0x3E27},
    [I(39,104)] = {17,0x1FEA7},
    [I(40,104)] = {16,0xFEA7},
    [I(41,104)] = {16,0xFEE7},
    [I(42,104)] = {14,0x3E67},
    [I(43,104)] = {17,0x1FEE7},
    [I(44,104)] = {14,0x3EA7},
    [I(45,104)] = {12,0x5A7},
    [I(46,104)] = {12,0x5E7},
    [I(47,104)] = {12,0x627},
    [I(48,104)] = {11,0x27},
    [I(49,104)] = {11,0x67},
    [I(50,104)] = {11,0xA7},
    [I(51,104)] = {12,0x667},
    [I(52,104)] = {12,0x6A7},
    [I(53,104)] = {12,0x6E7},
    [I(54,104)] = {12,0x727},
    [I(55,104)] = {12,0x767},
    [I(56,104)] = {12,0x7A7},
    [I(57,104)] = {12,0x7E7},
    [I(58,104)] = {13,0x1727},
    [I(59,104)] = {14,0x3EE7},
    [I(60,104)] = {21,0x1FFF27},
    [I(61,104)] = {12,0x827},
    [I(62,104)] = {18,0x3FEE7},
    [I(63,104)] = {16,0xFF27},
    [I(64,104)] = {19,0x7FEA7},
    [I(65,104)] = {12,0x867},
    [I(66,104)] = {13,0x1767},
    [I(67,104)] = {13,0x17A7},
    [I(68,104)] = {13,0x17E7},
    [I(69,104)] = {13,0x1827},
    [I(70,104)] = {13,0x1867},
    [I(71,104)] = {13,0x18A7},
    [I(72,104)] = {13,0x18E7},
    [I(73,104)] = {13,0x1927},
    [I(74,104)] = {13,0x1967},
    [I(75,104)] = {13,0x19A7},
    [I(76,104)] = {13,0x19E7},
    [I(77,104)] = {13,0x1A27},
    [I(78,104)] = {13,0x1A67},
    [I(79,104)] = {13,0x1AA7},
    [I(80,104)] = {13,0x1AE7},
    [I(81,104)] = {13,0x1B27},
    [I(82,104)] = {13,0x1B67},
    [I(83,104)] = {13,0x1BA7},
    [I(84,104)] = {13,0x1BE7},
    [I(85,104)] = {13,0x1C27},
    [I(86,104)] = {13,0x1C67},
    [I(87,104)] = {13,0x1CA7},
    [I(88,104)] = {14,0x3F27},
    [I(89,104)] = {13,0x1CE7},
    [I(90,104)] = {14,0x3F67},
    [I(91,104)] = {19,0x7FEE7},
    [I(92,104)] = {25,0x1FFFC27},
    [I(93,104)] = {19,0x7FF27},
    [I(94,104)] = {20,0xFFF27},
    [I(95,104)] = {12,0x8A7},
    [I(96,104)] = {21,0x1FFF67},
    [I(97,104)] = {11,0xE7},
    [I(98,104)] = {12,0x8E7},
    [I(99,104)] = {11,0x127},
    [I(100,104)] = {12,0x927},
    [I(101,104)] = {11,0x167},
    [I(102,104)] = {12,0x967},
    [I(103,104)] = {12,0x9A7},
    [I(104,104)] = {12,0x9E7},
    [I(105,104)] = {11,0x1A7},
    [I(106,104)] = {13,0x1D27},
    [I(107,104)] = {13,0x1D67},
    [I(108,104)] = {12,0xA27},
    [I(109,104)] = {12,0xA67},
    [I(110,104)] = {12,0xAA7},
    [I(111,104)] = {11,0x1E7},
    [I(112,104)] = {12,0xAE7},
    [I(113,104)] = {13,0x1DA7},
    [I(114,104)] = {12,0xB27},
    [I(115,104)] = {11,0x227},
    [I(116,104)] = {11,0x267},
    [I(117,104)] = {12,0xB67},
    [I(118,104)] = {13,0x1DE7},
    [I(119,104)] = {13,0x1E27},
    [I(120,104)] = {13,0x1E67},
    [I(121,104)] = {13,0x1EA7},
    [I(122,104)] = {13,0x1EE7},
    [I(123,104)] = {21,0x1FFFA7},
    [I(124,104)] = {17,0x1FF27},
    [I(125,104)] = {20,0xFFF67},
    [I(126,104)] = {19,0x7FF67},
    [I(127,104)] = {64,0},
    [I(128,104)] = {26,0x3FFF9A7},
    [I(129,104)] = {28,0xFFFF4A7},
    [I(130,104)] = {26,0x3FFF9E7},
    [I(131,104)] = {26,0x3FFFA27},
    [I(132,104)] = {28,0xFFFF4E7},
    [I(133,104)] = {28,0xFFFF527},
    [I(134,104)] = {28,0xFFFF567},
    [I(135,104)] = {29,0x1FFFF667},
    [I(136,104)] = {28,0xFFFF5A7},
    [I(137,104)] = {29,0x1FFFF6A7},
    [I(138,104)] = {29,0x1FFFF6E7},
    [I(139,104)] = {29,0x1FFFF727},
    [I(140,104)] = {29,0x1FFFF767},
    [I(141,104)] = {29,0x1FFFF7A7},
    [I(142,104)] = {30,0x3FFFFAE7},
    [I(143,104)] = {29,0x1FFFF7E7},
    [I(144,104)] = {30,0x3FFFFB27},
    [I(145,104)] = {30,0x3FFFFB67},
    [I(146,104)] = {28,0xFFFF5E7},
    [I(147,104)] = {29,0x1FFFF827},
    [I(148,104)] = {30,0x3FFFFBA7},
    [I(149,104)] = {29,0x1FFFF867},
    [I(150,104)] = {29,0x1FFFF8A7},
    [I(151,104)] = {29,0x1FFFF8E7},
    [I(152,104)] = {29,0x1FFFF927},
    [I(153,104)] = {27,0x7FFF727},
    [I(154,104)] = {28,0xFFFF627},
    [I(155,104)] = {29,0x1FFFF967},
    [I(156,104)] = {28,0xFFFF667},
    [I(157,104)] = {29,0x1FFFF9A7},
    [I(158,104)] = {29,0x1FFFF9E7},
    [I(159,104)] = {30,0x3FFFFBE7},
    [I(160,104)] = {28,0xFFFF6A7},
    [I(161,104)] = {27,0x7FFF767},
    [I(162,104)] = {26,0x3FFFA67},
    [I(163,104)] = {28,0xFFFF6E7},
    [I(164,104)] = {28,0xFFFF727},
    [I(165,104)] = {29,0x1FFFFA27},
    [I(166,104)] = {29,0x1FFFFA67},
    [I(167,104)] = {27,0x7FFF7A7},
    [I(168,104)] = {29,0x1FFFFAA7},
    [I(169,104)] = {28,0xFFFF767},
    [I(170,104)] = {28,0xFFFF7A7},
    [I(171,104)] = {30,0x3FFFFC27},
    [I(172,104)] = {27,0x7FFF7E7},
    [I(173,104)] = {28,0xFFFF7E7},
    [I(174,104)] = {29,0x1FFFFAE7},
    [I(175,104)] = {29,0x1FFFFB27},
    [I(176,104)] = {27,0x7FFF827},
    [I(177,104)] = {27,0x7FFF867},
    [I(178,104)] = {28,0xFFFF827},
    [I(179,104)] = {27,0x7FFF8A7},
    [I(180,104)] = {29,0x1FFFFB67},
    [I(181,104)] = {28,0xFFFF867},
    [I(182,104)] = {29,0x1FFFFBA7},
    [I(183,104)] = {29,0x1FFFFBE7},
    [I(184,104)] = {26,0x3FFFAA7},
    [I(185,104)] = {28,0xFFFF8A7},
    [I(186,104)] = {28,0xFFFF8E7},
    [I(187,104)] = {28,0xFFFF927},
    [I(188,104)] = {29,0x1FFFFC27},
    [I(189,104)] = {28,0xFFFF967},
    [I(190,104)] = {28,0xFFFF9A7},
    [I(191,104)] = {29,0x1FFFFC67},
    [I(192,104)] = {X32,0xFFFFF827},
    [I(193,104)] = {X32,0xFFFFF867},
    [I(194,104)] = {26,0x3FFFAE7},
    [I(195,104)] = {25,0x1FFFC67},
    [I(196,104)] = {28,0xFFFF9E7},
    [I(197,104)] = {29,0x1FFFFCA7},
    [I(198,104)] = {28,0xFFFFA27},
    [I(199,104)] = {31,0x7FFFFB27},
    [I(200,104)] = {X32,0xFFFFF8A7},
    [I(201,104)] = {X32,0xFFFFF8E7},
    [I(202,104)] = {X32,0xFFFFF927},
    [I(203,104)] = {64,0},
    [I(204,104)] = {64,0},
    [I(205,104)] = {X32,0xFFFFF967},
    [I(206,104)] = {30,0x3FFFFC67},
    [I(207,104)] = {31,0x7FFFFB67},
    [I(208,104)] = {25,0x1FFFCA7},
    [I(209,104)] = {27,0x7FFF8E7},
    [I(210,104)] = {X32,0xFFFFF9A7},
    [I(211,104)] = {64,0},
    [I(212,104)] = {64,0},
    [I(213,104)] = {X32,0xFFFFF9E7},
    [I(214,104)] = {64,0},
    [I(215,104)] = {30,0x3FFFFCA7},
    [I(216,104)] = {27,0x7FFF927},
    [I(217,104)] = {27,0x7FFF967},
    [I(218,104)] = {X32,0xFFFFFA27},
    [I(219,104)] = {X32,0xFFFFFA67},
    [I(220,104)] = {64,0},
    [I(221,104)] = {64,0},
    [I(222,104)] = {64,0},
    [I(223,104)] = {64,0},
    [I(224,104)] = {26,0x3FFFB27},
    [I(225,104)] = {30,0x3FFFFCE7},
    [I(226,104)] = {26,0x3FFFB67},
    [I(227,104)] = {27,0x7FFF9A7},
    [I(228,104)] = {28,0xFFFFA67},
    [I(229,104)] = {27,0x7FFF9E7},
    [I(230,104)] = {27,0x7FFFA27},
    [I(231,104)] = {29,0x1FFFFCE7},
    [I(232,104)] = {28,0xFFFFAA7},
    [I(233,104)] = {28,0xFFFFAE7},
    [I(234,104)] = {31,0x7FFFFBA7},
    [I(235,104)] = {31,0x7FFFFBE7},
    [I(236,104)] = {30,0x3FFFFD27},
    [I(237,104)] = {30,0x3FFFFD67},
    [I(238,104)] = {X32,0xFFFFFAA7},
    [I(239,104)] = {29,0x1FFFFD27},
    [I(240,104)] = {X32,0xFFFFFAE7},
    [I(241,104)] = {64,0},
    [I(242,104)] = {X32,0xFFFFFB27},
    [I(243,104)] = {X32,0xFFFFFB67},
    [I(244,104)] = {64,0},
    [I(245,104)] = {64,0},
    [I(246,104)] = {64,0},
    [I(247,104)] = {64,0},
    [I(248,104)] = {64,0},
    [I(249,104)] = {64,0},
    [I(250,104)] = {64,0},
    [I(251,104)] = {64,0},
    [I(252,104)] = {64,0},
    [I(253,104)] = {64,0},
    [I(254,104)] = {64,0},
    [I(255,104)] = {X32,0xFFFFFBA7},
    [I(0,105)] = {18,0x3FF06},
    [I(1,105)] = {28,0xFFFFB06},
    [I(2,105)] = {64,0},
    [I(3,105)] = {64,0},
    [I(4,105)] = {64,0},
    [I(5,105)] = {64,0},
    [I(6,105)] = {64,0},
    [I(7,105)] = {64,0},
    [I(8,105)] = {64,0},
    [I(9,105)] = {29,0x1FFFFD46},
    [I(10,105)] = {64,0},
    [I(11,105)] = {64,0},
    [I(12,105)] = {64,0},
    [I(13,105)] = {64,0},
    [I(14,105)] = {64,0},
    [I(15,105)] = {64,0},
    [I(16,105)] = {64,0},
    [I(17,105)] = {64,0},
    [I(18,105)] = {64,0},
    [I(19,105)] = {64,0},
    [I(20,105)] = {64,0},
    [I(21,105)] = {64,0},
    [I(22,105)] = {64,0},
    [I(23,105)] = {64,0},
    [I(24,105)] = {64,0},
    [I(25,105)] = {64,0},
    [I(26,105)] = {64,0},
    [I(27,105)] = {64,0},
    [I(28,105)] = {64,0},
    [I(29,105)] = {64,0},
    [I(30,105)] = {64,0},
    [I(31,105)] = {64,0},
    [I(32,105)] = {11,0x286},
    [I(33,105)] = {15,0x7F06},
    [I(34,105)] = {15,0x7F26},
    [I(35,105)] = {17,0x1FF46},
    [I(36,105)] = {18,0x3FF26},
    [I(37,105)] = {11,0x2A6},
    [I(38,105)] = {13,0x1F06},
    [I(39,105)] = {16,0xFF46},
    [I(40,105)] = {15,0x7F46},
    [I(41,105)] = {15,0x7F66},
    [I(42,105)] = {13,0x1F26},
    [I(43,105)] = {16,0xFF66},
    [I(44,105)] = {13,0x1F46},
    [I(45,105)] = {11,0x2C6},
    [I(46,105)] = {11,0x2E6},
    [I(47,105)] = {11,0x306},
    [I(48,105)] = {10,0x6},
    [I(49,105)] = {10,0x26},
    [I(50,105)] = {10,0x46},
    [I(51,105)] = {11,0x326},
    [I(52,105)] = {11,0x346},
    [I(53,105)] = {11,0x366},
    [I(54,105)] = {11,0x386},
    [I(55,105)] = {11,0x3A6},
    [I(56,105)] = {11,0x3C6},
    [I(57,105)] = {11,0x3E6},
    [I(58,105)] = {12,0xB86},
    [I(59,105)] = {13,0x1F66},
    [I(60,105)] = {20,0xFFF86},
    [I(61,105)] = {11,0x406},
    [I(62,105)] = {17,0x1FF66},
    [I(63,105)] = {15,0x7F86},
    [I(64,105)] = {18,0x3FF46},
    [I(65,105)] = {11,0x426},
    [I(66,105)] = {12,0xBA6},
    [I(67,105)] = {12,0xBC6},
    [I(68,105)] = {12,0xBE6},
    [I(69,105)] = {12,0xC06},
    [I(70,105)] = {12,0xC26},
    [I(71,105)] = {12,0xC46},
    [I(72,105)] = {12,0xC66},
    [I(73,105)] = {12,0xC86},
    [I(74,105)] = {12,0xCA6},
    [I(75,105)] = {12,0xCC6},
    [I(76,105)] = {12,0xCE6},
    [I(77,105)] = {12,0xD06},
    [I(78,105)] = {12,0xD26},
    [I(79,105)] = {12,0xD46},
    [I(80,105)] = {12,0xD66},
    [I(81,105)] = {12,0xD86},
    [I(82,105)] = {12,0xDA6},
    [I(83,105)] = {12,0xDC6},
    [I(84,105)] = {12,0xDE6},
    [I(85,105)] = {12,0xE06},
    [I(86,105)] = {12,0xE26},
    [I(87,105)] = {12,0xE46},
    [I(88,105)] = {13,0x1F86},
    [I(89,105)] = {12,0xE66},
    [I(90,105)] = {13,0x1FA6},
    [I(91,105)] = {18,0x3FF66},
    [I(92,105)] = {24,0xFFFE06},
    [I(93,105)] = {18,0x3FF86},
    [I(94,105)] = {19,0x7FF86},
    [I(95,105)] = {11,0x446},
    [I(96,105)] = {20,0xFFFA6},
    [I(97,105)] = {10,0x66},
    [I(98,105)] = {11,0x466},
    [I(99,105)] = {10,0x86},
    [I(100,105)] = {11,0x486},
    [I(101,105)] = {10,0xA6},
    [I(102,105)] = {11,0x4A6},
    [I(103,105)] = {11,0x4C6},
    [I(104,105)] = {11,0x4E6},
    [I(105,105)] = {10,0xC6},
    [I(106,105)] = {12,0xE86},
    [I(107,105)] = {12,0xEA6},
    [I(108,105)] = {11,0x506},
    [I(109,105)] = {11,0x526},
    [I(110,105)] = {11,0x546},
    [I(111,105)] = {10,0xE6},
    [I(112,105)] = {11,0x566},
    [I(113,105)] = {12,0xEC6},
    [I(114,105)] = {11,0x586},
    [I(115,105)] = {10,0x106},
    [I(116,105)] = {10,0x126},
    [I(117,105)] = {11,0x5A6},
    [I(118,105)] = {12,0xEE6},
    [I(119,105)] = {12,0xF06},
    [I(120,105)] = {12,0xF26},
    [I(121,105)] = {12,0xF46},
    [I(122,105)] = {12,0xF66},
    [I(123,105)] = {20,0xFFFC6},
    [I(124,105)] = {16,0xFF86},
    [I(125,105)] = {19,0x7FFA6},
    [I(126,105)] = {18,0x3FFA6},
    [I(127,105)] = {64,0},
    [I(128,105)] = {25,0x1FFFCC6},
    [I(129,105)] = {27,0x7FFFA46},
    [I(130,105)] = {25,0x1FFFCE6},
    [I(131,105)] = {25,0x1FFFD06},
    [I(132,105)] = {27,0x7FFFA66},
    [I(133,105)] = {27,0x7FFFA86},
    [I(134,105)] = {27,0x7FFFAA6},
    [I(135,105)] = {28,0xFFFFB26},
    [I(136,105)] = {27,0x7FFFAC6},
    [I(137,105)] = {28,0xFFFFB46},
    [I(138,105)] = {28,0xFFFFB66},
    [I(139,105)] = {28,0xFFFFB86},
    [I(140,105)] = {28,0xFFFFBA6},
    [I(141,105)] = {28,0xFFFFBC6},
    [I(142,105)] = {29,0x1FFFFD66},
    [I(143,105)] = {28,0xFFFFBE6},
    [I(144,105)] = {29,0x1FFFFD86},
    [I(145,105)] = {29,0x1FFFFDA6},
    [I(146,105)] = {27,0x7FFFAE6},
    [I(147,105)] = {28,0xFFFFC06},
    [I(148,105)] = {29,0x1FFFFDC6},
    [I(149,105)] = {28,0xFFFFC26},
    [I(150,105)] = {28,0xFFFFC46},
    [I(151,105)] = {28,0xFFFFC66},
    [I(152,105)] = {28,0xFFFFC86},
    [I(153,105)] = {26,0x3FFFB86},
    [I(154,105)] = {27,0x7FFFB06},
    [I(155,105)] = {28,0xFFFFCA6},
    [I(156,105)] = {27,0x7FFFB26},
    [I(157,105)] = {28,0xFFFFCC6},
    [I(158,105)] = {28,0xFFFFCE6},
    [I(159,105)] = {29,0x1FFFFDE6},
    [I(160,105)] = {27,0x7FFFB46},
    [I(161,105)] = {26,0x3FFFBA6},
    [I(162,105)] = {25,0x1FFFD26},
    [I(163,105)] = {27,0x7FFFB66},
    [I(164,105)] = {27,0x7FFFB86},
    [I(165,105)] = {28,0xFFFFD06},
    [I(166,105)] = {28,0xFFFFD26},
    [I(167,105)] = {26,0x3FFFBC6},
    [I(168,105)] = {28,0xFFFFD46},
    [I(169,105)] = {27,0x7FFFBA6},
    [I(170,105)] = {27,0x7FFFBC6},
    [I(171,105)] = {29,0x1FFFFE06},
    [I(172,105)] = {26,0x3FFFBE6},
    [I(173,105)] = {27,0x7FFFBE6},
    [I(174,105)] = {28,0xFFFFD66},
    [I(175,105)] = {28,0xFFFFD86},
    [I(176,105)] = {26,0x3FFFC06},
    [I(177,105)] = {26,0x3FFFC26},
    [I(178,105)] = {27,0x7FFFC06},
    [I(179,105)] = {26,0x3FFFC46},
    [I(180,105)] = {28,0xFFFFDA6},
    [I(181,105)] = {27,0x7FFFC26},
    [I(182,105)] = {28,0xFFFFDC6},
    [I(183,105)] = {28,0xFFFFDE6},
    [I(184,105)] = {25,0x1FFFD46},
    [I(185,105)] = {27,0x7FFFC46},
    [I(186,105)] = {27,0x7FFFC66},
    [I(187,105)] = {27,0x7FFFC86},
    [I(188,105)] = {28,0xFFFFE06},
    [I(189,105)] = {27,0x7FFFCA6},
    [I(190,105)] = {27,0x7FFFCC6},
    [I(191,105)] = {28,0xFFFFE26},
    [I(192,105)] = {31,0x7FFFFC06},
    [I(193,105)] = {31,0x7FFFFC26},
    [I(194,105)] = {25,0x1FFFD66},
    [I(195,105)] = {24,0xFFFE26},
    [I(196,105)] = {27,0x7FFFCE6},
    [I(197,105)] = {28,0xFFFFE46},
    [I(198,105)] = {27,0x7FFFD06},
    [I(199,105)] = {30,0x3FFFFD86},
    [I(200,105)] = {31,0x7FFFFC46},
    [I(201,105)] = {31,0x7FFFFC66},
    [I(202,105)] = {31,0x7FFFFC86},
    [I(203,105)] = {X32,0xFFFFFBC6},
    [I(204,105)] = {X32,0xFFFFFBE6},
    [I(205,105)] = {31,0x7FFFFCA6},
    [I(206,105)] = {29,0x1FFFFE26},
    [I(207,105)] = {30,0x3FFFFDA6},
    [I(208,105)] = {24,0xFFFE46},
    [I(209,105)] = {26,0x3FFFC66},
    [I(210,105)] = {31,0x7FFFFCC6},
    [I(211,105)] = {X32,0xFFFFFC06},
    [I(212,105)] = {X32,0xFFFFFC26},
    [I(213,105)] = {31,0x7FFFFCE6},
    [I(214,105)] = {X32,0xFFFFFC46},
    [I(215,105)] = {29,0x1FFFFE46},
    [I(216,105)] = {26,0x3FFFC86},
    [I(217,105)] = {26,0x3FFFCA6},
    [I(218,105)] = {31,0x7FFFFD06},
    [I(219,105)] = {31,0x7FFFFD26},
    [I(220,105)] = {64,0},
    [I(221,105)] = {X32,0xFFFFFC66},
    [I(222,105)] = {X32,0xFFFFFC86},
    [I(223,105)] = {X32,0xFFFFFCA6},
    [I(224,105)] = {25,0x1FFFD86},
    [I(225,105)] = {29,0x1FFFFE66},
    [I(226,105)] = {25,0x1FFFDA6},
    [I(227,105)] = {26,0x3FFFCC6},
    [I(228,105)] = {27,0x7FFFD26},
    [I(229,105)] = {26,0x3FFFCE6},
    [I(230,105)] = {26,0x3FFFD06},
    [I(231,105)] = {28,0xFFFFE66},
    [I(232,105)] = {27,0x7FFFD46},
    [I(233,105)] = {27,0x7FFFD66},
    [I(234,105)] = {30,0x3FFFFDC6},
    [I(235,105)] = {30,0x3FFFFDE6},
    [I(236,105)] = {29,0x1FFFFE86},
    [I(237,105)] = {29,0x1FFFFEA6},
    [I(238,105)] = {31,0x7FFFFD46},
    [I(239,105)] = {28,0xFFFFE86},
    [I(240,105)] = {31,0x7FFFFD66},
    [I(241,105)] = {X32,0xFFFFFCC6},
    [I(242,105)] = {31,0x7FFFFD86},
    [I(243,105)] = {31,0x7FFFFDA6},
    [I(244,105)] = {X32,0xFFFFFCE6},
    [I(245,105)] = {X32,0xFFFFFD06},
    [I(246,105)] = {X32,0xFFFFFD26},
    [I(247,105)] = {X32,0xFFFFFD46},
    [I(248,105)] = {X32,0xFFFFFD66},
    [I(249,105)] = {64,0},
    [I(250,105)] = {X32,0xFFFFFD86},
    [I(251,105)] = {X32,0xFFFFFDA6},
    [I(252,105)] = {X32,0xFFFFFDC6},
    [I(253,105)] = {X32,0xFFFFFDE6},
    [I(254,105)] = {X32,0xFFFFFE06},
    [I(255,105)] = {31,0x7FFFFDC6},
    [I(0,106)] = {20,0xFFC74},
    [I(1,106)] = {30,0x3FFFEC74},
    [I(2,106)] = {64,0},
    [I(3,106)] = {64,0},
    [I(4,106)] = {64,0},
    [I(5,106)] = {64,0},
    [I(6,106)] = {64,0},
    [I(7,106)] = {64,0},
    [I(8,106)] = {64,0},
    [I(9,106)] = {31,0x7FFFF574},
    [I(10,106)] = {64,0},
    [I(11,106)] = {64,0},
    [I(12,106)] = {64,0},
    [I(13,106)] = {64,0},
    [I(14,106)] = {64,0},
    [I(15,106)] = {64,0},
    [I(16,106)] = {64,0},
    [I(17,106)] = {64,0},
    [I(18,106)] = {64,0},
    [I(19,106)] = {64,0},
    [I(20,106)] = {64,0},
    [I(21,106)] = {64,0},
    [I(22,106)] = {64,0},
    [I(23,106)] = {64,0},
    [I(24,106)] = {64,0},
    [I(25,106)] = {64,0},
    [I(26,106)] = {64,0},
    [I(27,106)] = {64,0},
    [I(28,106)] = {64,0},
    [I(29,106)] = {64,0},
    [I(30,106)] = {64,0},
    [I(31,106)] = {64,0},
    [I(32,106)] = {13,0xA74},
    [I(33,106)] = {17,0x1FC74},
    [I(34,106)] = {17,0x1FCF4},
    [I(35,106)] = {19,0x7FD74},
    [I(36,106)] = {20,0xFFCF4},
    [I(37,106)] = {13,0xAF4},
    [I(38,106)] = {15,0x7C74},
    [I(39,106)] = {18,0x3FD74},
    [I(40,106)] = {17,0x1FD74},
    [I(41,106)] = {17,0x1FDF4},
    [I(42,106)] = {15,0x7CF4},
    [I(43,106)] = {18,0x3FDF4},
    [I(44,106)] = {15,0x7D74},
    [I(45,106)] = {13,0xB74},
    [I(46,106)] = {13,0xBF4},
    [I(47,106)] = {13,0xC74},
    [I(48,106)] = {12,0x74},
    [I(49,106)] = {12,0xF4},
    [I(50,106)] = {12,0x174},
    [I(51,106)] = {13,0xCF4},
    [I(52,106)] = {13,0xD74},
    [I(53,106)] = {13,0xDF4},
    [I(54,106)] = {13,0xE74},
    [I(55,106)] = {13,0xEF4},
    [I(56,106)] = {13,0xF74},
    [I(57,106)] = {13,0xFF4},
    [I(58,106)] = {14,0x2E74},
    [I(59,106)] = {15,0x7DF4},
    [I(60,106)] = {22,0x3FFE74},
    [I(61,106)] = {13,0x1074},
    [I(62,106)] = {19,0x7FDF4},
    [I(63,106)] = {17,0x1FE74},
    [I(64,106)] = {20,0xFFD74},
    [I(65,106)] = {13,0x10F4},
    [I(66,106)] = {14,0x2EF4},
    [I(67,106)] = {14,0x2F74},
    [I(68,106)] = {14,0x2FF4},
    [I(69,106)] = {14,0x3074},
    [I(70,106)] = {14,0x30F4},
    [I(71,106)] = {14,0x3174},
    [I(72,106)] = {14,0x31F4},
    [I(73,106)] = {14,0x3274},
    [I(74,106)] = {14,0x32F4},
    [I(75,106)] = {14,0x3374},
    [I(76,106)] = {14,0x33F4},
    [I(77,106)] = {14,0x3474},
    [I(78,106)] = {14,0x34F4},
    [I(79,106)] = {14,0x3574},
    [I(80,106)] = {14,0x35F4},
    [I(81,106)] = {14,0x3674},
    [I(82,106)] = {14,0x36F4},
    [I(83,106)] = {14,0x3774},
    [I(84,106)] = {14,0x37F4},
    [I(85,106)] = {14,0x3874},
    [I(86,106)] = {14,0x38F4},
    [I(87,106)] = {14,0x3974},
    [I(88,106)] = {15,0x7E74},
    [I(89,106)] = {14,0x39F4},
    [I(90,106)] = {15,0x7EF4},
    [I(91,106)] = {20,0xFFDF4},
    [I(92,106)] = {26,0x3FFF874},
    [I(93,106)] = {20,0xFFE74},
    [I(94,106)] = {21,0x1FFE74},
    [I(95,106)] = {13,0x1174},
    [I(96,106)] = {22,0x3FFEF4},
    [I(97,106)] = {12,0x1F4},
    [I(98,106)] = {13,0x11F4},
    [I(99,106)] = {12,0x274},
    [I(100,106)] = {13,0x1274},
    [I(101,106)] = {12,0x2F4},
    [I(102,106)] = {13,0x12F4},
    [I(103,106)] = {13,0x1374},
    [I(104,106)] = {13,0x13F4},
    [I(105,106)] = {12,0x374},
    [I(106,106)] = {14,0x3A74},
    [I(107,106)] = {14,0x3AF4},
    [I(108,106)] = {13,0x1474},
    [I(109,106)] = {13,0x14F4},
    [I(110,106)] = {13,0x1574},
    [I(111,106)] = {12,0x3F4},
    [I(112,106)] = {13,0x15F4},
    [I(113,106)] = {14,0x3B74},
    [I(114,106)] = {13,0x1674},
    [I(115,106)] = {12,0x474},
    [I(116,106)] = {12,0x4F4},
    [I(117,106)] = {13,0x16F4},
    [I(118,106)] = {14,0x3BF4},
    [I(119,106)] = {14,0x3C74},
    [I(120,106)] = {14,0x3CF4},
    [I(121,106)] = {14,0x3D74},
    [I(122,106)] = {14,0x3DF4},
    [I(123,106)] = {22,0x3FFF74},
    [I(124,106)] = {18,0x3FE74},
    [I(125,106)] = {21,0x1FFEF4},
    [I(126,106)] = {20,0xFFEF4},
    [I(127,106)] = {64,0},
    [I(128,106)] = {27,0x7FFF374},
    [I(129,106)] = {29,0x1FFFE974},
    [I(130,106)] = {27,0x7FFF3F4},
    [I(131,106)] = {27,0x7FFF474},
    [I(132,106)] = {29,0x1FFFE9F4},
    [I(133,106)] = {29,0x1FFFEA74},
    [I(134,106)] = {29,0x1FFFEAF4},
    [I(135,106)] = {30,0x3FFFECF4},
    [I(136,106)] = {29,0x1FFFEB74},
    [I(137,106)] = {30,0x3FFFED74},
    [I(138,106)] = {30,0x3FFFEDF4},
    [I(139,106)] = {30,0x3FFFEE74},
    [I(140,106)] = {30,0x3FFFEEF4},
    [I(141,106)] = {30,0x3FFFEF74},
    [I(142,106)] = {31,0x7FFFF5F4},
    [I(143,106)] = {30,0x3FFFEFF4},
    [I(144,106)] = {31,0x7FFFF674},
    [I(145,106)] = {31,0x7FFFF6F4},
    [I(146,106)] = {29,0x1FFFEBF4},
    [I(147,106)] = {30,0x3FFFF074},
    [I(148,106)] = {31,0x7FFFF774},
    [I(149,106)] = {30,0x3FFFF0F4},
    [I(150,106)] = {30,0x3FFFF174},
    [I(151,106)] = {30,0x3FFFF1F4},
    [I(152,106)] = {30,0x3FFFF274},
    [I(153,106)] = {28,0xFFFEE74},
    [I(154,106)] = {29,0x1FFFEC74},
    [I(155,106)] = {30,0x3FFFF2F4},
    [I(156,106)] = {29,0x1FFFECF4},
    [I(157,106)] = {30,0x3FFFF374},
    [I(158,106)] = {30,0x3FFFF3F4},
    [I(159,106)] = {31,0x7FFFF7F4},
    [I(160,106)] = {29,0x1FFFED74},
    [I(161,106)] = {28,0xFFFEEF4},
    [I(162,106)] = {27,0x7FFF4F4},
    [I(163,106)] = {29,0x1FFFEDF4},
    [I(164,106)] = {29,0x1FFFEE74},
    [I(165,106)] = {30,0x3FFFF474},
    [I(166,106)] = {30,0x3FFFF4F4},
    [I(167,106)] = {28,0xFFFEF74},
    [I(168,106)] = {30,0x3FFFF574},
    [I(169,106)] = {29,0x1FFFEEF4},
    [I(170,106)] = {29,0x1FFFEF74},
    [I(171,106)] = {31,0x7FFFF874},
    [I(172,106)] = {28,0xFFFEFF4},
    [I(173,106)] = {29,0x1FFFEFF4},
    [I(174,106)] = {30,0x3FFFF5F4},
    [I(175,106)] = {30,0x3FFFF674},
    [I(176,106)] = {28,0xFFFF074},
    [I(177,106)] = {28,0xFFFF0F4},
    [I(178,106)] = {29,0x1FFFF074},
    [I(179,106)] = {28,0xFFFF174},
    [I(180,106)] = {30,0x3FFFF6F4},
    [I(181,106)] = {29,0x1FFFF0F4},
    [I(182,106)] = {30,0x3FFFF774},
    [I(183,106)] = {30,0x3FFFF7F4},
    [I(184,106)] = {27,0x7FFF574},
    [I(185,106)] = {29,0x1FFFF174},
    [I(186,106)] = {29,0x1FFFF1F4},
    [I(187,106)] = {29,0x1FFFF274},
    [I(188,106)] = {30,0x3FFFF874},
    [I(189,106)] = {29,0x1FFFF2F4},
    [I(190,106)] = {29,0x1FFFF374},
    [I(191,106)] = {30,0x3FFFF8F4},
    [I(192,106)] = {64,0},
    [I(193,106)] = {64,0},
    [I(194,106)] = {27,0x7FFF5F4},
    [I(195,106)] = {26,0x3FFF8F4},
    [I(196,106)] = {29,0x1FFFF3F4},
    [I(197,106)] = {30,0x3FFFF974},
    [I(198,106)] = {29,0x1FFFF474},
    [I(199,106)] = {X32,0xFFFFF674},
    [I(200,106)] = {64,0},
    [I(201,106)] = {64,0},
    [I(202,106)] = {64,0},
    [I(203,106)] = {64,0},
    [I(204,106)] = {64,0},
    [I(205,106)] = {64,0},
    [I(206,106)] = {31,0x7FFFF8F4},
    [I(207,106)] = {X32,0xFFFFF6F4},
    [I(208,106)] = {26,0x3FFF974},
    [I(209,106)] = {28,0xFFFF1F4},
    [I(210,106)] = {64,0},
    [I(211,106)] = {64,0},
    [I(212,106)] = {64,0},
    [I(213,106)] = {64,0},
    [I(214,106)] = {64,0},
    [I(215,106)] = {31,0x7FFFF974},
    [I(216,106)] = {28,0xFFFF274},
    [I(217,106)] = {28,0xFFFF2F4},
    [I(218,106)] = {64,0},
    [I(219,106)] = {64,0},
    [I(220,106)] = {64,0},
    [I(221,106)] = {64,0},
    [I(222,106)] = {64,0},
    [I(223,106)] = {64,0},
    [I(224,106)] = {27,0x7FFF674},
    [I(225,106)] = {31,0x7FFFF9F4},
    [I(226,106)] = {27,0x7FFF6F4},
    [I(227,106)] = {28,0xFFFF374},
    [I(228,106)] = {29,0x1FFFF4F4},
    [I(229,106)] = {28,0xFFFF3F4},
    [I(230,106)] = {28,0xFFFF474},
    [I(231,106)] = {30,0x3FFFF9F4},
    [I(232,106)] = {29,0x1FFFF574},
    [I(233,106)] = {29,0x1FFFF5F4},
    [I(234,106)] = {X32,0xFFFFF774},
    [I(235,106)] = {X32,0xFFFFF7F4},
    [I(236,106)] = {31,0x7FFFFA74},
    [I(237,106)] = {31,0x7FFFFAF4},
    [I(238,106)] = {64,0},
    [I(239,106)] = {30,0x3FFFFA74},
    [I(240,106)] = {64,0},
    [I(241,106)] = {64,0},
    [I(242,106)] = {64,0},
    [I(243,106)] = {64,0},
    [I(244,106)] = {64,0},
    [I(245,106)] = {64,0},
    [I(246,106)] = {64,0},
    [I(247,106)] = {64,0},
    [I(248,106)] = {64,0},
    [I(249,106)] = {64,0},
    [I(250,106)] = {64,0},
    [I(251,106)] = {64,0},
    [I(252,106)] = {64,0},
    [I(253,106)] = {64,0},
    [I(254,106)] = {64,0},
    [I(255,106)] = {64,0},
    [I(0,107)] = {20,0xFFC75},
    [I(1,107)] = {30,0x3FFFEC75},
    [I(2,107)] = {64,0},
    [I(3,107)] = {64,0},
    [I(4,107)] = {64,0},
    [I(5,107)] = {64,0},
    [I(6,107)] = {64,0},
    [I(7,107)] = {64,0},
    [I(8,107)] = {64,0},
    [I(9,107)] = {31,0x7FFFF575},
    [I(10,107)] = {64,0},
    [I(11,107)] = {64,0},
    [I(12,107)] = {64,0},
    [I(13,107)] = {64,0},
    [I(14,107)] = {64,0},
    [I(15,107)] = {64,0},
    [I(16,107)] = {64,0},
    [I(17,107)] = {64,0},
    [I(18,107)] = {64,0},
    [I(19,107)] = {64,0},
    [I(20,107)] = {64,0},
    [I(21,107)] = {64,0},
    [I(22,107)] = {64,0},
    [I(23,107)] = {64,0},
    [I(24,107)] = {64,0},
    [I(25,107)] = {64,0},
    [I(26,107)] = {64,0},
    [I(27,107)] = {64,0},
    [I(28,107)] = {64,0},
    [I(29,107)] = {64,0},
    [I(30,107)] = {64,0},
    [I(31,107)] = {64,0},
    [I(32,107)] = {13,0xA75},
    [I(33,107)] = {17,0x1FC75},
    [I(34,107)] = {17,0x1FCF5},
    [I(35,107)] = {19,0x7FD75},
    [I(36,107)] = {20,0xFFCF5},
    [I(37,107)] = {13,0xAF5},
    [I(38,107)] = {15,0x7C75},
    [I(39,107)] = {18,0x3FD75},
    [I(40,107)] = {17,0x1FD75},
    [I(41,107)] = {17,0x1FDF5},
    [I(42,107)] = {15,0x7CF5},
    [I(43,107)] = {18,0x3FDF5},
    [I(44,107)] = {15,0x7D75},
    [I(45,107)] = {13,0xB75},
    [I(46,107)] = {13,0xBF5},
    [I(47,107)] = {13,0xC75},
    [I(48,107)] = {12,0x75},
    [I(49,107)] = {12,0xF5},
    [I(50,107)] = {12,0x175},
    [I(51,107)] = {13,0xCF5},
    [I(52,107)] = {13,0xD75},
    [I(53,107)] = {13,0xDF5},
    [I(54,107)] = {13,0xE75},
    [I(55,107)] = {13,0xEF5},
    [I(56,107)] = {13,0xF75},
    [I(57,107)] = {13,0xFF5},
    [I(58,107)] = {14,0x2E75},
    [I(59,107)] = {15,0x7DF5},
    [I(60,107)] = {22,0x3FFE75},
    [I(61,107)] = {13,0x1075},
    [I(62,107)] = {19,0x7FDF5},
    [I(63,107)] = {17,0x1FE75},
    [I(64,107)] = {20,0xFFD75},
    [I(65,107)] = {13,0x10F5},
    [I(66,107)] = {14,0x2EF5},
    [I(67,107)] = {14,0x2F75},
    [I(68,107)] = {14,0x2FF5},
    [I(69,107)] = {14,0x3075},
    [I(70,107)] = {14,0x30F5},
    [I(71,107)] = {14,0x3175},
    [I(72,107)] = {14,0x31F5},
    [I(73,107)] = {14,0x3275},
    [I(74,107)] = {14,0x32F5},
    [I(75,107)] = {14,0x3375},
    [I(76,107)] = {14,0x33F5},
    [I(77,107)] = {14,0x3475},
    [I(78,107)] = {14,0x34F5},
    [I(79,107)] = {14,0x3575},
    [I(80,107)] = {14,0x35F5},
    [I(81,107)] = {14,0x3675},
    [I(82,107)] = {14,0x36F5},
    [I(83,107)] = {14,0x3775},
    [I(84,107)] = {14,0x37F5},
    [I(85,107)] = {14,0x3875},
    [I(86,107)] = {14,0x38F5},
    [I(87,107)] = {14,0x3975},
    [I(88,107)] = {15,0x7E75},
    [I(89,107)] = {14,0x39F5},
    [I(90,107)] = {15,0x7EF5},
    [I(91,107)] = {20,0xFFDF5},
    [I(92,107)] = {26,0x3FFF875},
    [I(93,107)] = {20,0xFFE75},
    [I(94,107)] = {21,0x1FFE75},
    [I(95,107)] = {13,0x1175},
    [I(96,107)] = {22,0x3FFEF5},
    [I(97,107)] = {12,0x1F5},
    [I(98,107)] = {13,0x11F5},
    [I(99,107)] = {12,0x275},
    [I(100,107)] = {13,0x1275},
    [I(101,107)] = {12,0x2F5},
    [I(102,107)] = {13,0x12F5},
    [I(103,107)] = {13,0x1375},
    [I(104,107)] = {13,0x13F5},
    [I(105,107)] = {12,0x375},
    [I(106,107)] = {14,0x3A75},
    [I(107,107)] = {14,0x3AF5},
    [I(108,107)] = {13,0x1475},
    [I(109,107)] = {13,0x14F5},
    [I(110,107)] = {13,0x1575},
    [I(111,107)] = {12,0x3F5},
    [I(112,107)] = {13,0x15F5},
    [I(113,107)] = {14,0x3B75},
    [I(114,107)] = {13,0x1675},
    [I(115,107)] = {12,0x475},
    [I(116,107)] = {12,0x4F5},
    [I(117,107)] = {13,0x16F5},
    [I(118,107)] = {14,0x3BF5},
    [I(119,107)] = {14,0x3C75},
    [I(120,107)] = {14,0x3CF5},
    [I(121,107)] = {14,0x3D75},
    [I(122,107)] = {14,0x3DF5},
    [I(123,107)] = {22,0x3FFF75},
    [I(124,107)] = {18,0x3FE75},
    [I(125,107)] = {21,0x1FFEF5},
    [I(126,107)] = {20,0xFFEF5},
    [I(127,107)] = {64,0},
    [I(128,107)] = {27,0x7FFF375},
    [I(129,107)] = {29,0x1FFFE975},
    [I(130,107)] = {27,0x7FFF3F5},
    [I(131,107)] = {27,0x7FFF475},
    [I(132,107)] = {29,0x1FFFE9F5},
    [I(133,107)] = {29,0x1FFFEA75},
    [I(134,107)] = {29,0x1FFFEAF5},
    [I(135,107)] = {30,0x3FFFECF5},
    [I(136,107)] = {29,0x1FFFEB75},
    [I(137,107)] = {30,0x3FFFED75},
    [I(138,107)] = {30,0x3FFFEDF5},
    [I(139,107)] = {30,0x3FFFEE75},
    [I(140,107)] = {30,0x3FFFEEF5},
    [I(141,107)] = {30,0x3FFFEF75},
    [I(142,107)] = {31,0x7FFFF5F5},
    [I(143,107)] = {30,0x3FFFEFF5},
    [I(144,107)] = {31,0x7FFFF675},
    [I(145,107)] = {31,0x7FFFF6F5},
    [I(146,107)] = {29,0x1FFFEBF5},
    [I(147,107)] = {30,0x3FFFF075},
    [I(148,107)] = {31,0x7FFFF775},
    [I(149,107)] = {30,0x3FFFF0F5},
    [I(150,107)] = {30,0x3FFFF175},
    [I(151,107)] = {30,0x3FFFF1F5},
    [I(152,107)] = {30,0x3FFFF275},
    [I(153,107)] = {28,0xFFFEE75},
    [I(154,107)] = {29,0x1FFFEC75},
    [I(155,107)] = {30,0x3FFFF2F5},
    [I(156,107)] = {29,0x1FFFECF5},
    [I(157,107)] = {30,0x3FFFF375},
    [I(158,107)] = {30,0x3FFFF3F5},
    [I(159,107)] = {31,0x7FFFF7F5},
    [I(160,107)] = {29,0x1FFFED75},
    [I(161,107)] = {28,0xFFFEEF5},
    [I(162,107)] = {27,0x7FFF4F5},
    [I(163,107)] = {29,0x1FFFEDF5},
    [I(164,107)] = {29,0x1FFFEE75},
    [I(165,107)] = {30,0x3FFFF475},
    [I(166,107)] = {30,0x3FFFF4F5},
    [I(167,107)] = {28,0xFFFEF75},
    [I(168,107)] = {30,0x3FFFF575},
    [I(169,107)] = {29,0x1FFFEEF5},
    [I(170,107)] = {29,0x1FFFEF75},
    [I(171,107)] = {31,0x7FFFF875},
    [I(172,107)] = {28,0xFFFEFF5},
    [I(173,107)] = {29,0x1FFFEFF5},
    [I(174,107)] = {30,0x3FFFF5F5},
    [I(175,107)] = {30,0x3FFFF675},
    [I(176,107)] = {28,0xFFFF075},
    [I(177,107)] = {28,0xFFFF0F5},
    [I(178,107)] = {29,0x1FFFF075},
    [I(179,107)] = {28,0xFFFF175},
    [I(180,107)] = {30,0x3FFFF6F5},
    [I(181,107)] = {29,0x1FFFF0F5},
    [I(182,107)] = {30,0x3FFFF775},
    [I(183,107)] = {30,0x3FFFF7F5},
    [I(184,107)] = {27,0x7FFF575},
    [I(185,107)] = {29,0x1FFFF175},
    [I(186,107)] = {29,0x1FFFF1F5},
    [I(187,107)] = {29,0x1FFFF275},
    [I(188,107)] = {30,0x3FFFF875},
    [I(189,107)] = {29,0x1FFFF2F5},
    [I(190,107)] = {29,0x1FFFF375},
    [I(191,107)] = {30,0x3FFFF8F5},
    [I(192,107)] = {64,0},
    [I(193,107)] = {64,0},
    [I(194,107)] = {27,0x7FFF5F5},
    [I(195,107)] = {26,0x3FFF8F5},
    [I(196,107)] = {29,0x1FFFF3F5},
    [I(197,107)] = {30,0x3FFFF975},
    [I(198,107)] = {29,0x1FFFF475},
    [I(199,107)] = {X32,0xFFFFF675},
    [I(200,107)] = {64,0},
    [I(201,107)] = {64,0},
    [I(202,107)] = {64,0},
    [I(203,107)] = {64,0},
    [I(204,107)] = {64,0},
    [I(205,107)] = {64,0},
    [I(206,107)] = {31,0x7FFFF8F5},
    [I(207,107)] = {X32,0xFFFFF6F5},
    [I(208,107)] = {26,0x3FFF975},
    [I(209,107)] = {28,0xFFFF1F5},
    [I(210,107)] = {64,0},
    [I(211,107)] = {64,0},
    [I(212,107)] = {64,0},
    [I(213,107)] = {64,0},
    [I(214,107)] = {64,0},
    [I(215,107)] = {31,0x7FFFF975},
    [I(216,107)] = {28,0xFFFF275},
    [I(217,107)] = {28,0xFFFF2F5},
    [I(218,107)] = {64,0},
    [I(219,107)] = {64,0},
    [I(220,107)] = {64,0},
    [I(221,107)] = {64,0},
    [I(222,107)] = {64,0},
    [I(223,107)] = {64,0},
    [I(224,107)] = {27,0x7FFF675},
    [I(225,107)] = {31,0x7FFFF9F5},
    [I(226,107)] = {27,0x7FFF6F5},
    [I(227,107)] = {28,0xFFFF375},
    [I(228,107)] = {29,0x1FFFF4F5},
    [I(229,107)] = {28,0xFFFF3F5},
    [I(230,107)] = {28,0xFFFF475},
    [I(231,107)] = {30,0x3FFFF9F5},
    [I(232,107)] = {29,0x1FFFF575},
    [I(233,107)] = {29,0x1FFFF5F5},
    [I(234,107)] = {X32,0xFFFFF775},
    [I(235,107)] = {X32,0xFFFFF7F5},
    [I(236,107)] = {31,0x7FFFFA75},
    [I(237,107)] = {31,0x7FFFFAF5},
    [I(238,107)] = {64,0},
    [I(239,107)] = {30,0x3FFFFA75},
    [I(240,107)] = {64,0},
    [I(241,107)] = {64,0},
    [I(242,107)] = {64,0},
    [I(243,107)] = {64,0},
    [I(244,107)] = {64,0},
    [I(245,107)] = {64,0},
    [I(246,107)] = {64,0},
    [I(247,107)] = {64,0},
    [I(248,107)] = {64,0},
    [I(249,107)] = {64,0},
    [I(250,107)] = {64,0},
    [I(251,107)] = {64,0},
    [I(252,107)] = {64,0},
    [I(253,107)] = {64,0},
    [I(254,107)] = {64,0},
    [I(255,107)] = {64,0},
    [I(0,108)] = {19,0x7FE28},
    [I(1,108)] = {29,0x1FFFF628},
    [I(2,108)] = {64,0},
    [I(3,108)] = {64,0},
    [I(4,108)] = {64,0},
    [I(5,108)] = {64,0},
    [I(6,108)] = {64,0},
    [I(7,108)] = {64,0},
    [I(8,108)] = {64,0},
    [I(9,108)] = {30,0x3FFFFAA8},
    [I(10,108)] = {64,0},
    [I(11,108)] = {64,0},
    [I(12,108)] = {64,0},
    [I(13,108)] = {64,0},
    [I(14,108)] = {64,0},
    [I(15,108)] = {64,0},
    [I(16,108)] = {64,0},
    [I(17,108)] = {64,0},
    [I(18,108)] = {64,0},
    [I(19,108)] = {64,0},
    [I(20,108)] = {64,0},
    [I(21,108)] = {64,0},
    [I(22,108)] = {64,0},
    [I(23,108)] = {64,0},
    [I(24,108)] = {64,0},
    [I(25,108)] = {64,0},
    [I(26,108)] = {64,0},
    [I(27,108)] = {64,0},
    [I(28,108)] = {64,0},
    [I(29,108)] = {64,0},
    [I(30,108)] = {64,0},
    [I(31,108)] = {64,0},
    [I(32,108)] = {12,0x528},
    [I(33,108)] = {16,0xFE28},
    [I(34,108)] = {16,0xFE68},
    [I(35,108)] = {18,0x3FEA8},
    [I(36,108)] = {19,0x7FE68},
    [I(37,108)] = {12,0x568},
    [I(38,108)] = {14,0x3E28},
    [I(39,108)] = {17,0x1FEA8},
    [I(40,108)] = {16,0xFEA8},
    [I(41,108)] = {16,0xFEE8},
    [I(42,108)] = {14,0x3E68},
    [I(43,108)] = {17,0x1FEE8},
    [I(44,108)] = {14,0x3EA8},
    [I(45,108)] = {12,0x5A8},
    [I(46,108)] = {12,0x5E8},
    [I(47,108)] = {12,0x628},
    [I(48,108)] = {11,0x28},
    [I(49,108)] = {11,0x68},
    [I(50,108)] = {11,0xA8},
    [I(51,108)] = {12,0x668},
    [I(52,108)] = {12,0x6A8},
    [I(53,108)] = {12,0x6E8},
    [I(54,108)] = {12,0x728},
    [I(55,108)] = {12,0x768},
    [I(56,108)] = {12,0x7A8},
    [I(57,108)] = {12,0x7E8},
    [I(58,108)] = {13,0x1728},
    [I(59,108)] = {14,0x3EE8},
    [I(60,108)] = {21,0x1FFF28},
    [I(61,108)] = {12,0x828},
    [I(62,108)] = {18,0x3FEE8},
    [I(63,108)] = {16,0xFF28},
    [I(64,108)] = {19,0x7FEA8},
    [I(65,108)] = {12,0x868},
    [I(66,108)] = {13,0x1768},
    [I(67,108)] = {13,0x17A8},
    [I(68,108)] = {13,0x17E8},
    [I(69,108)] = {13,0x1828},
    [I(70,108)] = {13,0x1868},
    [I(71,108)] = {13,0x18A8},
    [I(72,108)] = {13,0x18E8},
    [I(73,108)] = {13,0x1928},
    [I(74,108)] = {13,0x1968},
    [I(75,108)] = {13,0x19A8},
    [I(76,108)] = {13,0x19E8},
    [I(77,108)] = {13,0x1A28},
    [I(78,108)] = {13,0x1A68},
    [I(79,108)] = {13,0x1AA8},
    [I(80,108)] = {13,0x1AE8},
    [I(81,108)] = {13,0x1B28},
    [I(82,108)] = {13,0x1B68},
    [I(83,108)] = {13,0x1BA8},
    [I(84,108)] = {13,0x1BE8},
    [I(85,108)] = {13,0x1C28},
    [I(86,108)] = {13,0x1C68},
    [I(87,108)] = {13,0x1CA8},
    [I(88,108)] = {14,0x3F28},
    [I(89,108)] = {13,0x1CE8},
    [I(90,108)] = {14,0x3F68},
    [I(91,108)] = {19,0x7FEE8},
    [I(92,108)] = {25,0x1FFFC28},
    [I(93,108)] = {19,0x7FF28},
    [I(94,108)] = {20,0xFFF28},
    [I(95,108)] = {12,0x8A8},
    [I(96,108)] = {21,0x1FFF68},
    [I(97,108)] = {11,0xE8},
    [I(98,108)] = {12,0x8E8},
    [I(99,108)] = {11,0x128},
    [I(100,108)] = {12,0x928},
    [I(101,108)] = {11,0x168},
    [I(102,108)] = {12,0x968},
    [I(103,108)] = {12,0x9A8},
    [I(104,108)] = {12,0x9E8},
    [I(105,108)] = {11,0x1A8},
    [I(106,108)] = {13,0x1D28},
    [I(107,108)] = {13,0x1D68},
    [I(108,108)] = {12,0xA28},
    [I(109,108)] = {12,0xA68},
    [I(110,108)] = {12,0xAA8},
    [I(111,108)] = {11,0x1E8},
    [I(112,108)] = {12,0xAE8},
    [I(113,108)] = {13,0x1DA8},
    [I(114,108)] = {12,0xB28},
    [I(115,108)] = {11,0x228},
    [I(116,108)] = {11,0x268},
    [I(117,108)] = {12,0xB68},
    [I(118,108)] = {13,0x1DE8},
    [I(119,108)] = {13,0x1E28},
    [I(120,108)] = {13,0x1E68},
    [I(121,108)] = {13,0x1EA8},
    [I(122,108)] = {13,0x1EE8},
    [I(123,108)] = {21,0x1FFFA8},
    [I(124,108)] = {17,0x1FF28},
    [I(125,108)] = {20,0xFFF68},
    [I(126,108)] = {19,0x7FF68},
    [I(127,108)] = {64,0},
    [I(128,108)] = {26,0x3FFF9A8},
    [I(129,108)] = {28,0xFFFF4A8},
    [I(130,108)] = {26,0x3FFF9E8},
    [I(131,108)] = {26,0x3FFFA28},
    [I(132,108)] = {28,0xFFFF4E8},
    [I(133,108)] = {28,0xFFFF528},
    [I(134,108)] = {28,0xFFFF568},
    [I(135,108)] = {29,0x1FFFF668},
    [I(136,108)] = {28,0xFFFF5A8},
    [I(137,108)] = {29,0x1FFFF6A8},
    [I(138,108)] = {29,0x1FFFF6E8},
    [I(139,108)] = {29,0x1FFFF728},
    [I(140,108)] = {29,0x1FFFF768},
    [I(141,108)] = {29,0x1FFFF7A8},
    [I(142,108)] = {30,0x3FFFFAE8},
    [I(143,108)] = {29,0x1FFFF7E8},
    [I(144,108)] = {30,0x3FFFFB28},
    [I(145,108)] = {30,0x3FFFFB68},
    [I(146,108)] = {28,0xFFFF5E8},
    [I(147,108)] = {29,0x1FFFF828},
    [I(148,108)] = {30,0x3FFFFBA8},
    [I(149,108)] = {29,0x1FFFF868},
    [I(150,108)] = {29,0x1FFFF8A8},
    [I(151,108)] = {29,0x1FFFF8E8},
    [I(152,108)] = {29,0x1FFFF928},
    [I(153,108)] = {27,0x7FFF728},
    [I(154,108)] = {28,0xFFFF628},
    [I(155,108)] = {29,0x1FFFF968},
    [I(156,108)] = {28,0xFFFF668},
    [I(157,108)] = {29,0x1FFFF9A8},
    [I(158,108)] = {29,0x1FFFF9E8},
    [I(159,108)] = {30,0x3FFFFBE8},
    [I(160,108)] = {28,0xFFFF6A8},
    [I(161,108)] = {27,0x7FFF768},
    [I(162,108)] = {26,0x3FFFA68},
    [I(163,108)] = {28,0xFFFF6E8},
    [I(164,108)] = {28,0xFFFF728},
    [I(165,108)] = {29,0x1FFFFA28},
    [I(166,108)] = {29,0x1FFFFA68},
    [I(167,108)] = {27,0x7FFF7A8},
    [I(168,108)] = {29,0x1FFFFAA8},
    [I(169,108)] = {28,0xFFFF768},
    [I(170,108)] = {28,0xFFFF7A8},
    [I(171,108)] = {30,0x3FFFFC28},
    [I(172,108)] = {27,0x7FFF7E8},
    [I(173,108)] = {28,0xFFFF7E8},
    [I(174,108)] = {29,0x1FFFFAE8},
    [I(175,108)] = {29,0x1FFFFB28},
    [I(176,108)] = {27,0x7FFF828},
    [I(177,108)] = {27,0x7FFF868},
    [I(178,108)] = {28,0xFFFF828},
    [I(179,108)] = {27,0x7FFF8A8},
    [I(180,108)] = {29,0x1FFFFB68},
    [I(181,108)] = {28,0xFFFF868},
    [I(182,108)] = {29,0x1FFFFBA8},
    [I(183,108)] = {29,0x1FFFFBE8},
    [I(184,108)] = {26,0x3FFFAA8},
    [I(185,108)] = {28,0xFFFF8A8},
    [I(186,108)] = {28,0xFFFF8E8},
    [I(187,108)] = {28,0xFFFF928},
    [I(188,108)] = {29,0x1FFFFC28},
    [I(189,108)] = {28,0xFFFF968},
    [I(190,108)] = {28,0xFFFF9A8},
    [I(191,108)] = {29,0x1FFFFC68},
    [I(192,108)] = {X32,0xFFFFF828},
    [I(193,108)] = {X32,0xFFFFF868},
    [I(194,108)] = {26,0x3FFFAE8},
    [I(195,108)] = {25,0x1FFFC68},
    [I(196,108)] = {28,0xFFFF9E8},
    [I(197,108)] = {29,0x1FFFFCA8},
    [I(198,108)] = {28,0xFFFFA28},
    [I(199,108)] = {31,0x7FFFFB28},
    [I(200,108)] = {X32,0xFFFFF8A8},
    [I(201,108)] = {X32,0xFFFFF8E8},
    [I(202,108)] = {X32,0xFFFFF928},
    [I(203,108)] = {64,0},
    [I(204,108)] = {64,0},
    [I(205,108)] = {X32,0xFFFFF968},
    [I(206,108)] = {30,0x3FFFFC68},
    [I(207,108)] = {31,0x7FFFFB68},
    [I(208,108)] = {25,0x1FFFCA8},
    [I(209,108)] = {27,0x7FFF8E8},
    [I(210,108)] = {X32,0xFFFFF9A8},
    [I(211,108)] = {64,0},
    [I(212,108)] = {64,0},
    [I(213,108)] = {X32,0xFFFFF9E8},
    [I(214,108)] = {64,0},
    [I(215,108)] = {30,0x3FFFFCA8},
    [I(216,108)] = {27,0x7FFF928},
    [I(217,108)] = {27,0x7FFF968},
    [I(218,108)] = {X32,0xFFFFFA28},
    [I(219,108)] = {X32,0xFFFFFA68},
    [I(220,108)] = {64,0},
    [I(221,108)] = {64,0},
    [I(222,108)] = {64,0},
    [I(223,108)] = {64,0},
    [I(224,108)] = {26,0x3FFFB28},
    [I(225,108)] = {30,0x3FFFFCE8},
    [I(226,108)] = {26,0x3FFFB68},
    [I(227,108)] = {27,0x7FFF9A8},
    [I(228,108)] = {28,0xFFFFA68},
    [I(229,108)] = {27,0x7FFF9E8},
    [I(230,108)] = {27,0x7FFFA28},
    [I(231,108)] = {29,0x1FFFFCE8},
    [I(232,108)] = {28,0xFFFFAA8},
    [I(233,108)] = {28,0xFFFFAE8},
    [I(234,108)] = {31,0x7FFFFBA8},
    [I(235,108)] = {31,0x7FFFFBE8},
    [I(236,108)] = {30,0x3FFFFD28},
    [I(237,108)] = {30,0x3FFFFD68},
    [I(238,108)] = {X32,0xFFFFFAA8},
    [I(239,108)] = {29,0x1FFFFD28},
    [I(240,108)] = {X32,0xFFFFFAE8},
    [I(241,108)] = {64,0},
    [I(242,108)] = {X32,0xFFFFFB28},
    [I(243,108)] = {X32,0xFFFFFB68},
    [I(244,108)] = {64,0},
    [I(245,108)] = {64,0},
    [I(246,108)] = {64,0},
    [I(247,108)] = {64,0},
    [I(248,108)] = {64,0},
    [I(249,108)] = {64,0},
    [I(250,108)] = {64,0},
    [I(251,108)] = {64,0},
    [I(252,108)] = {64,0},
    [I(253,108)] = {64,0},
    [I(254,108)] = {64,0},
    [I(255,108)] = {X32,0xFFFFFBA8},
    [I(0,109)] = {19,0x7FE29},
    [I(1,109)] = {29,0x1FFFF629},
    [I(2,109)] = {64,0},
    [I(3,109)] = {64,0},
    [I(4,109)] = {64,0},
    [I(5,109)] = {64,0},
    [I(6,109)] = {64,0},
    [I(7,109)] = {64,0},
    [I(8,109)] = {64,0},
    [I(9,109)] = {30,0x3FFFFAA9},
    [I(10,109)] = {64,0},
    [I(11,109)] = {64,0},
    [I(12,109)] = {64,0},
    [I(13,109)] = {64,0},
    [I(14,109)] = {64,0},
    [I(15,109)] = {64,0},
    [I(16,109)] = {64,0},
    [I(17,109)] = {64,0},
    [I(18,109)] = {64,0},
    [I(19,109)] = {64,0},
    [I(20,109)] = {64,0},
    [I(21,109)] = {64,0},
    [I(22,109)] = {64,0},
    [I(23,109)] = {64,0},
    [I(24,109)] = {64,0},
    [I(25,109)] = {64,0},
    [I(26,109)] = {64,0},
    [I(27,109)] = {64,0},
    [I(28,109)] = {64,0},
    [I(29,109)] = {64,0},
    [I(30,109)] = {64,0},
    [I(31,109)] = {64,0},
    [I(32,109)] = {12,0x529},
    [I(33,109)] = {16,0xFE29},
    [I(34,109)] = {16,0xFE69},
    [I(35,109)] = {18,0x3FEA9},
    [I(36,109)] = {19,0x7FE69},
    [I(37,109)] = {12,0x569},
    [I(38,109)] = {14,0x3E29},
    [I(39,109)] = {17,0x1FEA9},
    [I(40,109)] = {16,0xFEA9},
    [I(41,109)] = {16,0xFEE9},
    [I(42,109)] = {14,0x3E69},
    [I(43,109)] = {17,0x1FEE9},
    [I(44,109)] = {14,0x3EA9},
    [I(45,109)] = {12,0x5A9},
    [I(46,109)] = {12,0x5E9},
    [I(47,109)] = {12,0x629},
    [I(48,109)] = {11,0x29},
    [I(49,109)] = {11,0x69},
    [I(50,109)] = {11,0xA9},
    [I(51,109)] = {12,0x669},
    [I(52,109)] = {12,0x6A9},
    [I(53,109)] = {12,0x6E9},
    [I(54,109)] = {12,0x729},
    [I(55,109)] = {12,0x769},
    [I(56,109)] = {12,0x7A9},
    [I(57,109)] = {12,0x7E9},
    [I(58,109)] = {13,0x1729},
    [I(59,109)] = {14,0x3EE9},
    [I(60,109)] = {21,0x1FFF29},
    [I(61,109)] = {12,0x829},
    [I(62,109)] = {18,0x3FEE9},
    [I(63,109)] = {16,0xFF29},
    [I(64,109)] = {19,0x7FEA9},
    [I(65,109)] = {12,0x869},
    [I(66,109)] = {13,0x1769},
    [I(67,109)] = {13,0x17A9},
    [I(68,109)] = {13,0x17E9},
    [I(69,109)] = {13,0x1829},
    [I(70,109)] = {13,0x1869},
    [I(71,109)] = {13,0x18A9},
    [I(72,109)] = {13,0x18E9},
    [I(73,109)] = {13,0x1929},
    [I(74,109)] = {13,0x1969},
    [I(75,109)] = {13,0x19A9},
    [I(76,109)] = {13,0x19E9},
    [I(77,109)] = {13,0x1A29},
    [I(78,109)] = {13,0x1A69},
    [I(79,109)] = {13,0x1AA9},
    [I(80,109)] = {13,0x1AE9},
    [I(81,109)] = {13,0x1B29},
    [I(82,109)] = {13,0x1B69},
    [I(83,109)] = {13,0x1BA9},
    [I(84,109)] = {13,0x1BE9},
    [I(85,109)] = {13,0x1C29},
    [I(86,109)] = {13,0x1C69},
    [I(87,109)] = {13,0x1CA9},
    [I(88,109)] = {14,0x3F29},
    [I(89,109)] = {13,0x1CE9},
    [I(90,109)] = {14,0x3F69},
    [I(91,109)] = {19,0x7FEE9},
    [I(92,109)] = {25,0x1FFFC29},
    [I(93,109)] = {19,0x7FF29},
    [I(94,109)] = {20,0xFFF29},
    [I(95,109)] = {12,0x8A9},
    [I(96,109)] = {21,0x1FFF69},
    [I(97,109)] = {11,0xE9},
    [I(98,109)] = {12,0x8E9},
    [I(99,109)] = {11,0x129},
    [I(100,109)] = {12,0x929},
    [I(101,109)] = {11,0x169},
    [I(102,109)] = {12,0x969},
    [I(103,109)] = {12,0x9A9},
    [I(104,109)] = {12,0x9E9},
    [I(105,109)] = {11,0x1A9},
    [I(106,109)] = {13,0x1D29},
    [I(107,109)] = {13,0x1D69},
    [I(108,109)] = {12,0xA29},
    [I(109,109)] = {12,0xA69},
    [I(110,109)] = {12,0xAA9},
    [I(111,109)] = {11,0x1E9},
    [I(112,109)] = {12,0xAE9},
    [I(113,109)] = {13,0x1DA9},
    [I(114,109)] = {12,0xB29},
    [I(115,109)] = {11,0x229},
    [I(116,109)] = {11,0x269},
    [I(117,109)] = {12,0xB69},
    [I(118,109)] = {13,0x1DE9},
    [I(119,109)] = {13,0x1E29},
    [I(120,109)] = {13,0x1E69},
    [I(121,109)] = {13,0x1EA9},
    [I(122,109)] = {13,0x1EE9},
    [I(123,109)] = {21,0x1FFFA9},
    [I(124,109)] = {17,0x1FF29},
    [I(125,109)] = {20,0xFFF69},
    [I(126,109)] = {19,0x7FF69},
    [I(127,109)] = {64,0},
    [I(128,109)] = {26,0x3FFF9A9},
    [I(129,109)] = {28,0xFFFF4A9},
    [I(130,109)] = {26,0x3FFF9E9},
    [I(131,109)] = {26,0x3FFFA29},
    [I(132,109)] = {28,0xFFFF4E9},
    [I(133,109)] = {28,0xFFFF529},
    [I(134,109)] = {28,0xFFFF569},
    [I(135,109)] = {29,0x1FFFF669},
    [I(136,109)] = {28,0xFFFF5A9},
    [I(137,109)] = {29,0x1FFFF6A9},
    [I(138,109)] = {29,0x1FFFF6E9},
    [I(139,109)] = {29,0x1FFFF729},
    [I(140,109)] = {29,0x1FFFF769},
    [I(141,109)] = {29,0x1FFFF7A9},
    [I(142,109)] = {30,0x3FFFFAE9},
    [I(143,109)] = {29,0x1FFFF7E9},
    [I(144,109)] = {30,0x3FFFFB29},
    [I(145,109)] = {30,0x3FFFFB69},
    [I(146,109)] = {28,0xFFFF5E9},
    [I(147,109)] = {29,0x1FFFF829},
    [I(148,109)] = {30,0x3FFFFBA9},
    [I(149,109)] = {29,0x1FFFF869},
    [I(150,109)] = {29,0x1FFFF8A9},
    [I(151,109)] = {29,0x1FFFF8E9},
    [I(152,109)] = {29,0x1FFFF929},
    [I(153,109)] = {27,0x7FFF729},
    [I(154,109)] = {28,0xFFFF629},
    [I(155,109)] = {29,0x1FFFF969},
    [I(156,109)] = {28,0xFFFF669},
    [I(157,109)] = {29,0x1FFFF9A9},
    [I(158,109)] = {29,0x1FFFF9E9},
    [I(159,109)] = {30,0x3FFFFBE9},
    [I(160,109)] = {28,0xFFFF6A9},
    [I(161,109)] = {27,0x7FFF769},
    [I(162,109)] = {26,0x3FFFA69},
    [I(163,109)] = {28,0xFFFF6E9},
    [I(164,109)] = {28,0xFFFF729},
    [I(165,109)] = {29,0x1FFFFA29},
    [I(166,109)] = {29,0x1FFFFA69},
    [I(167,109)] = {27,0x7FFF7A9},
    [I(168,109)] = {29,0x1FFFFAA9},
    [I(169,109)] = {28,0xFFFF769},
    [I(170,109)] = {28,0xFFFF7A9},
    [I(171,109)] = {30,0x3FFFFC29},
    [I(172,109)] = {27,0x7FFF7E9},
    [I(173,109)] = {28,0xFFFF7E9},
    [I(174,109)] = {29,0x1FFFFAE9},
    [I(175,109)] = {29,0x1FFFFB29},
    [I(176,109)] = {27,0x7FFF829},
    [I(177,109)] = {27,0x7FFF869},
    [I(178,109)] = {28,0xFFFF829},
    [I(179,109)] = {27,0x7FFF8A9},
    [I(180,109)] = {29,0x1FFFFB69},
    [I(181,109)] = {28,0xFFFF869},
    [I(182,109)] = {29,0x1FFFFBA9},
    [I(183,109)] = {29,0x1FFFFBE9},
    [I(184,109)] = {26,0x3FFFAA9},
    [I(185,109)] = {28,0xFFFF8A9},
    [I(186,109)] = {28,0xFFFF8E9},
    [I(187,109)] = {28,0xFFFF929},
    [I(188,109)] = {29,0x1FFFFC29},
    [I(189,109)] = {28,0xFFFF969},
    [I(190,109)] = {28,0xFFFF9A9},
    [I(191,109)] = {29,0x1FFFFC69},
    [I(192,109)] = {X32,0xFFFFF829},
    [I(193,109)] = {X32,0xFFFFF869},
    [I(194,109)] = {26,0x3FFFAE9},
    [I(195,109)] = {25,0x1FFFC69},
    [I(196,109)] = {28,0xFFFF9E9},
    [I(197,109)] = {29,0x1FFFFCA9},
    [I(198,109)] = {28,0xFFFFA29},
    [I(199,109)] = {31,0x7FFFFB29},
    [I(200,109)] = {X32,0xFFFFF8A9},
    [I(201,109)] = {X32,0xFFFFF8E9},
    [I(202,109)] = {X32,0xFFFFF929},
    [I(203,109)] = {64,0},
    [I(204,109)] = {64,0},
    [I(205,109)] = {X32,0xFFFFF969},
    [I(206,109)] = {30,0x3FFFFC69},
    [I(207,109)] = {31,0x7FFFFB69},
    [I(208,109)] = {25,0x1FFFCA9},
    [I(209,109)] = {27,0x7FFF8E9},
    [I(210,109)] = {X32,0xFFFFF9A9},
    [I(211,109)] = {64,0},
    [I(212,109)] = {64,0},
    [I(213,109)] = {X32,0xFFFFF9E9},
    [I(214,109)] = {64,0},
    [I(215,109)] = {30,0x3FFFFCA9},
    [I(216,109)] = {27,0x7FFF929},
    [I(217,109)] = {27,0x7FFF969},
    [I(218,109)] = {X32,0xFFFFFA29},
    [I(219,109)] = {X32,0xFFFFFA69},
    [I(220,109)] = {64,0},
    [I(221,109)] = {64,0},
    [I(222,109)] = {64,0},
    [I(223,109)] = {64,0},
    [I(224,109)] = {26,0x3FFFB29},
    [I(225,109)] = {30,0x3FFFFCE9},
    [I(226,109)] = {26,0x3FFFB69},
    [I(227,109)] = {27,0x7FFF9A9},
    [I(228,109)] = {28,0xFFFFA69},
    [I(229,109)] = {27,0x7FFF9E9},
    [I(230,109)] = {27,0x7FFFA29},
    [I(231,109)] = {29,0x1FFFFCE9},
    [I(232,109)] = {28,0xFFFFAA9},
    [I(233,109)] = {28,0xFFFFAE9},
    [I(234,109)] = {31,0x7FFFFBA9},
    [I(235,109)] = {31,0x7FFFFBE9},
    [I(236,109)] = {30,0x3FFFFD29},
    [I(237,109)] = {30,0x3FFFFD69},
    [I(238,109)] = {X32,0xFFFFFAA9},
    [I(239,109)] = {29,0x1FFFFD29},
    [I(240,109)] = {X32,0xFFFFFAE9},
    [I(241,109)] = {64,0},
    [I(242,109)] = {X32,0xFFFFFB29},
    [I(243,109)] = {X32,0xFFFFFB69},
    [I(244,109)] = {64,0},
    [I(245,109)] = {64,0},
    [I(246,109)] = {64,0},
    [I(247,109)] = {64,0},
    [I(248,109)] = {64,0},
    [I(249,109)] = {64,0},
    [I(250,109)] = {64,0},
    [I(251,109)] = {64,0},
    [I(252,109)] = {64,0},
    [I(253,109)] = {64,0},
    [I(254,109)] = {64,0},
    [I(255,109)] = {X32,0xFFFFFBA9},
    [I(0,110)] = {19,0x7FE2A},
    [I(1,110)] = {29,0x1FFFF62A},
    [I(2,110)] = {64,0},
    [I(3,110)] = {64,0},
    [I(4,110)] = {64,0},
    [I(5,110)] = {64,0},
    [I(6,110)] = {64,0},
    [I(7,110)] = {64,0},
    [I(8,110)] = {64,0},
    [I(9,110)] = {30,0x3FFFFAAA},
    [I(10,110)] = {64,0},
    [I(11,110)] = {64,0},
    [I(12,110)] = {64,0},
    [I(13,110)] = {64,0},
    [I(14,110)] = {64,0},
    [I(15,110)] = {64,0},
    [I(16,110)] = {64,0},
    [I(17,110)] = {64,0},
    [I(18,110)] = {64,0},
    [I(19,110)] = {64,0},
    [I(20,110)] = {64,0},
    [I(21,110)] = {64,0},
    [I(22,110)] = {64,0},
    [I(23,110)] = {64,0},
    [I(24,110)] = {64,0},
    [I(25,110)] = {64,0},
    [I(26,110)] = {64,0},
    [I(27,110)] = {64,0},
    [I(28,110)] = {64,0},
    [I(29,110)] = {64,0},
    [I(30,110)] = {64,0},
    [I(31,110)] = {64,0},
    [I(32,110)] = {12,0x52A},
    [I(33,110)] = {16,0xFE2A},
    [I(34,110)] = {16,0xFE6A},
    [I(35,110)] = {18,0x3FEAA},
    [I(36,110)] = {19,0x7FE6A},
    [I(37,110)] = {12,0x56A},
    [I(38,110)] = {14,0x3E2A},
    [I(39,110)] = {17,0x1FEAA},
    [I(40,110)] = {16,0xFEAA},
    [I(41,110)] = {16,0xFEEA},
    [I(42,110)] = {14,0x3E6A},
    [I(43,110)] = {17,0x1FEEA},
    [I(44,110)] = {14,0x3EAA},
    [I(45,110)] = {12,0x5AA},
    [I(46,110)] = {12,0x5EA},
    [I(47,110)] = {12,0x62A},
    [I(48,110)] = {11,0x2A},
    [I(49,110)] = {11,0x6A},
    [I(50,110)] = {11,0xAA},
    [I(51,110)] = {12,0x66A},
    [I(52,110)] = {12,0x6AA},
    [I(53,110)] = {12,0x6EA},
    [I(54,110)] = {12,0x72A},
    [I(55,110)] = {12,0x76A},
    [I(56,110)] = {12,0x7AA},
    [I(57,110)] = {12,0x7EA},
    [I(58,110)] = {13,0x172A},
    [I(59,110)] = {14,0x3EEA},
    [I(60,110)] = {21,0x1FFF2A},
    [I(61,110)] = {12,0x82A},
    [I(62,110)] = {18,0x3FEEA},
    [I(63,110)] = {16,0xFF2A},
    [I(64,110)] = {19,0x7FEAA},
    [I(65,110)] = {12,0x86A},
    [I(66,110)] = {13,0x176A},
    [I(67,110)] = {13,0x17AA},
    [I(68,110)] = {13,0x17EA},
    [I(69,110)] = {13,0x182A},
    [I(70,110)] = {13,0x186A},
    [I(71,110)] = {13,0x18AA},
    [I(72,110)] = {13,0x18EA},
    [I(73,110)] = {13,0x192A},
    [I(74,110)] = {13,0x196A},
    [I(75,110)] = {13,0x19AA},
    [I(76,110)] = {13,0x19EA},
    [I(77,110)] = {13,0x1A2A},
    [I(78,110)] = {13,0x1A6A},
    [I(79,110)] = {13,0x1AAA},
    [I(80,110)] = {13,0x1AEA},
    [I(81,110)] = {13,0x1B2A},
    [I(82,110)] = {13,0x1B6A},
    [I(83,110)] = {13,0x1BAA},
    [I(84,110)] = {13,0x1BEA},
    [I(85,110)] = {13,0x1C2A},
    [I(86,110)] = {13,0x1C6A},
    [I(87,110)] = {13,0x1CAA},
    [I(88,110)] = {14,0x3F2A},
    [I(89,110)] = {13,0x1CEA},
    [I(90,110)] = {14,0x3F6A},
    [I(91,110)] = {19,0x7FEEA},
    [I(92,110)] = {25,0x1FFFC2A},
    [I(93,110)] = {19,0x7FF2A},
    [I(94,110)] = {20,0xFFF2A},
    [I(95,110)] = {12,0x8AA},
    [I(96,110)] = {21,0x1FFF6A},
    [I(97,110)] = {11,0xEA},
    [I(98,110)] = {12,0x8EA},
    [I(99,110)] = {11,0x12A},
    [I(100,110)] = {12,0x92A},
    [I(101,110)] = {11,0x16A},
    [I(102,110)] = {12,0x96A},
    [I(103,110)] = {12,0x9AA},
    [I(104,110)] = {12,0x9EA},
    [I(105,110)] = {11,0x1AA},
    [I(106,110)] = {13,0x1D2A},
    [I(107,110)] = {13,0x1D6A},
    [I(108,110)] = {12,0xA2A},
    [I(109,110)] = {12,0xA6A},
    [I(110,110)] = {12,0xAAA},
    [I(111,110)] = {11,0x1EA},
    [I(112,110)] = {12,0xAEA},
    [I(113,110)] = {13,0x1DAA},
    [I(114,110)] = {12,0xB2A},
    [I(115,110)] = {11,0x22A},
    [I(116,110)] = {11,0x26A},
    [I(117,110)] = {12,0xB6A},
    [I(118,110)] = {13,0x1DEA},
    [I(119,110)] = {13,0x1E2A},
    [I(120,110)] = {13,0x1E6A},
    [I(121,110)] = {13,0x1EAA},
    [I(122,110)] = {13,0x1EEA},
    [I(123,110)] = {21,0x1FFFAA},
    [I(124,110)] = {17,0x1FF2A},
    [I(125,110)] = {20,0xFFF6A},
    [I(126,110)] = {19,0x7FF6A},
    [I(127,110)] = {64,0},
    [I(128,110)] = {26,0x3FFF9AA},
    [I(129,110)] = {28,0xFFFF4AA},
    [I(130,110)] = {26,0x3FFF9EA},
    [I(131,110)] = {26,0x3FFFA2A},
    [I(132,110)] = {28,0xFFFF4EA},
    [I(133,110)] = {28,0xFFFF52A},
    [I(134,110)] = {28,0xFFFF56A},
    [I(135,110)] = {29,0x1FFFF66A},
    [I(136,110)] = {28,0xFFFF5AA},
    [I(137,110)] = {29,0x1FFFF6AA},
    [I(138,110)] = {29,0x1FFFF6EA},
    [I(139,110)] = {29,0x1FFFF72A},
    [I(140,110)] = {29,0x1FFFF76A},
    [I(141,110)] = {29,0x1FFFF7AA},
    [I(142,110)] = {30,0x3FFFFAEA},
    [I(143,110)] = {29,0x1FFFF7EA},
    [I(144,110)] = {30,0x3FFFFB2A},
    [I(145,110)] = {30,0x3FFFFB6A},
    [I(146,110)] = {28,0xFFFF5EA},
    [I(147,110)] = {29,0x1FFFF82A},
    [I(148,110)] = {30,0x3FFFFBAA},
    [I(149,110)] = {29,0x1FFFF86A},
    [I(150,110)] = {29,0x1FFFF8AA},
    [I(151,110)] = {29,0x1FFFF8EA},
    [I(152,110)] = {29,0x1FFFF92A},
    [I(153,110)] = {27,0x7FFF72A},
    [I(154,110)] = {28,0xFFFF62A},
    [I(155,110)] = {29,0x1FFFF96A},
    [I(156,110)] = {28,0xFFFF66A},
    [I(157,110)] = {29,0x1FFFF9AA},
    [I(158,110)] = {29,0x1FFFF9EA},
    [I(159,110)] = {30,0x3FFFFBEA},
    [I(160,110)] = {28,0xFFFF6AA},
    [I(161,110)] = {27,0x7FFF76A},
    [I(162,110)] = {26,0x3FFFA6A},
    [I(163,110)] = {28,0xFFFF6EA},
    [I(164,110)] = {28,0xFFFF72A},
    [I(165,110)] = {29,0x1FFFFA2A},
    [I(166,110)] = {29,0x1FFFFA6A},
    [I(167,110)] = {27,0x7FFF7AA},
    [I(168,110)] = {29,0x1FFFFAAA},
    [I(169,110)] = {28,0xFFFF76A},
    [I(170,110)] = {28,0xFFFF7AA},
    [I(171,110)] = {30,0x3FFFFC2A},
    [I(172,110)] = {27,0x7FFF7EA},
    [I(173,110)] = {28,0xFFFF7EA},
    [I(174,110)] = {29,0x1FFFFAEA},
    [I(175,110)] = {29,0x1FFFFB2A},
    [I(176,110)] = {27,0x7FFF82A},
    [I(177,110)] = {27,0x7FFF86A},
    [I(178,110)] = {28,0xFFFF82A},
    [I(179,110)] = {27,0x7FFF8AA},
    [I(180,110)] = {29,0x1FFFFB6A},
    [I(181,110)] = {28,0xFFFF86A},
    [I(182,110)] = {29,0x1FFFFBAA},
    [I(183,110)] = {29,0x1FFFFBEA},
    [I(184,110)] = {26,0x3FFFAAA},
    [I(185,110)] = {28,0xFFFF8AA},
    [I(186,110)] = {28,0xFFFF8EA},
    [I(187,110)] = {28,0xFFFF92A},
    [I(188,110)] = {29,0x1FFFFC2A},
    [I(189,110)] = {28,0xFFFF96A},
    [I(190,110)] = {28,0xFFFF9AA},
    [I(191,110)] = {29,0x1FFFFC6A},
    [I(192,110)] = {X32,0xFFFFF82A},
    [I(193,110)] = {X32,0xFFFFF86A},
    [I(194,110)] = {26,0x3FFFAEA},
    [I(195,110)] = {25,0x1FFFC6A},
    [I(196,110)] = {28,0xFFFF9EA},
    [I(197,110)] = {29,0x1FFFFCAA},
    [I(198,110)] = {28,0xFFFFA2A},
    [I(199,110)] = {31,0x7FFFFB2A},
    [I(200,110)] = {X32,0xFFFFF8AA},
    [I(201,110)] = {X32,0xFFFFF8EA},
    [I(202,110)] = {X32,0xFFFFF92A},
    [I(203,110)] = {64,0},
    [I(204,110)] = {64,0},
    [I(205,110)] = {X32,0xFFFFF96A},
    [I(206,110)] = {30,0x3FFFFC6A},
    [I(207,110)] = {31,0x7FFFFB6A},
    [I(208,110)] = {25,0x1FFFCAA},
    [I(209,110)] = {27,0x7FFF8EA},
    [I(210,110)] = {X32,0xFFFFF9AA},
    [I(211,110)] = {64,0},
    [I(212,110)] = {64,0},
    [I(213,110)] = {X32,0xFFFFF9EA},
    [I(214,110)] = {64,0},
    [I(215,110)] = {30,0x3FFFFCAA},
    [I(216,110)] = {27,0x7FFF92A},
    [I(217,110)] = {27,0x7FFF96A},
    [I(218,110)] = {X32,0xFFFFFA2A},
    [I(219,110)] = {X32,0xFFFFFA6A},
    [I(220,110)] = {64,0},
    [I(221,110)] = {64,0},
    [I(222,110)] = {64,0},
    [I(223,110)] = {64,0},
    [I(224,110)] = {26,0x3FFFB2A},
    [I(225,110)] = {30,0x3FFFFCEA},
    [I(226,110)] = {26,0x3FFFB6A},
    [I(227,110)] = {27,0x7FFF9AA},
    [I(228,110)] = {28,0xFFFFA6A},
    [I(229,110)] = {27,0x7FFF9EA},
    [I(230,110)] = {27,0x7FFFA2A},
    [I(231,110)] = {29,0x1FFFFCEA},
    [I(232,110)] = {28,0xFFFFAAA},
    [I(233,110)] = {28,0xFFFFAEA},
    [I(234,110)] = {31,0x7FFFFBAA},
    [I(235,110)] = {31,0x7FFFFBEA},
    [I(236,110)] = {30,0x3FFFFD2A},
    [I(237,110)] = {30,0x3FFFFD6A},
    [I(238,110)] = {X32,0xFFFFFAAA},
    [I(239,110)] = {29,0x1FFFFD2A},
    [I(240,110)] = {X32,0xFFFFFAEA},
    [I(241,110)] = {64,0},
    [I(242,110)] = {X32,0xFFFFFB2A},
    [I(243,110)] = {X32,0xFFFFFB6A},
    [I(244,110)] = {64,0},
    [I(245,110)] = {64,0},
    [I(246,110)] = {64,0},
    [I(247,110)] = {64,0},
    [I(248,110)] = {64,0},
    [I(249,110)] = {64,0},
    [I(250,110)] = {64,0},
    [I(251,110)] = {64,0},
    [I(252,110)] = {64,0},
    [I(253,110)] = {64,0},
    [I(254,110)] = {64,0},
    [I(255,110)] = {X32,0xFFFFFBAA},
    [I(0,111)] = {18,0x3FF07},
    [I(1,111)] = {28,0xFFFFB07},
    [I(2,111)] = {64,0},
    [I(3,111)] = {64,0},
    [I(4,111)] = {64,0},
    [I(5,111)] = {64,0},
    [I(6,111)] = {64,0},
    [I(7,111)] = {64,0},
    [I(8,111)] = {64,0},
    [I(9,111)] = {29,0x1FFFFD47},
    [I(10,111)] = {64,0},
    [I(11,111)] = {64,0},
    [I(12,111)] = {64,0},
    [I(13,111)] = {64,0},
    [I(14,111)] = {64,0},
    [I(15,111)] = {64,0},
    [I(16,111)] = {64,0},
    [I(17,111)] = {64,0},
    [I(18,111)] = {64,0},
    [I(19,111)] = {64,0},
    [I(20,111)] = {64,0},
    [I(21,111)] = {64,0},
    [I(22,111)] = {64,0},
    [I(23,111)] = {64,0},
    [I(24,111)] = {64,0},
    [I(25,111)] = {64,0},
    [I(26,111)] = {64,0},
    [I(27,111)] = {64,0},
    [I(28,111)] = {64,0},
    [I(29,111)] = {64,0},
    [I(30,111)] = {64,0},
    [I(31,111)] = {64,0},
    [I(32,111)] = {11,0x287},
    [I(33,111)] = {15,0x7F07},
    [I(34,111)] = {15,0x7F27},
    [I(35,111)] = {17,0x1FF47},
    [I(36,111)] = {18,0x3FF27},
    [I(37,111)] = {11,0x2A7},
    [I(38,111)] = {13,0x1F07},
    [I(39,111)] = {16,0xFF47},
    [I(40,111)] = {15,0x7F47},
    [I(41,111)] = {15,0x7F67},
    [I(42,111)] = {13,0x1F27},
    [I(43,111)] = {16,0xFF67},
    [I(44,111)] = {13,0x1F47},
    [I(45,111)] = {11,0x2C7},
    [I(46,111)] = {11,0x2E7},
    [I(47,111)] = {11,0x307},
    [I(48,111)] = {10,0x7},
    [I(49,111)] = {10,0x27},
    [I(50,111)] = {10,0x47},
    [I(51,111)] = {11,0x327},
    [I(52,111)] = {11,0x347},
    [I(53,111)] = {11,0x367},
    [I(54,111)] = {11,0x387},
    [I(55,111)] = {11,0x3A7},
    [I(56,111)] = {11,0x3C7},
    [I(57,111)] = {11,0x3E7},
    [I(58,111)] = {12,0xB87},
    [I(59,111)] = {13,0x1F67},
    [I(60,111)] = {20,0xFFF87},
    [I(61,111)] = {11,0x407},
    [I(62,111)] = {17,0x1FF67},
    [I(63,111)] = {15,0x7F87},
    [I(64,111)] = {18,0x3FF47},
    [I(65,111)] = {11,0x427},
    [I(66,111)] = {12,0xBA7},
    [I(67,111)] = {12,0xBC7},
    [I(68,111)] = {12,0xBE7},
    [I(69,111)] = {12,0xC07},
    [I(70,111)] = {12,0xC27},
    [I(71,111)] = {12,0xC47},
    [I(72,111)] = {12,0xC67},
    [I(73,111)] = {12,0xC87},
    [I(74,111)] = {12,0xCA7},
    [I(75,111)] = {12,0xCC7},
    [I(76,111)] = {12,0xCE7},
    [I(77,111)] = {12,0xD07},
    [I(78,111)] = {12,0xD27},
    [I(79,111)] = {12,0xD47},
    [I(80,111)] = {12,0xD67},
    [I(81,111)] = {12,0xD87},
    [I(82,111)] = {12,0xDA7},
    [I(83,111)] = {12,0xDC7},
    [I(84,111)] = {12,0xDE7},
    [I(85,111)] = {12,0xE07},
    [I(86,111)] = {12,0xE27},
    [I(87,111)] = {12,0xE47},
    [I(88,111)] = {13,0x1F87},
    [I(89,111)] = {12,0xE67},
    [I(90,111)] = {13,0x1FA7},
    [I(91,111)] = {18,0x3FF67},
    [I(92,111)] = {24,0xFFFE07},
    [I(93,111)] = {18,0x3FF87},
    [I(94,111)] = {19,0x7FF87},
    [I(95,111)] = {11,0x447},
    [I(96,111)] = {20,0xFFFA7},
    [I(97,111)] = {10,0x67},
    [I(98,111)] = {11,0x467},
    [I(99,111)] = {10,0x87},
    [I(100,111)] = {11,0x487},
    [I(101,111)] = {10,0xA7},
    [I(102,111)] = {11,0x4A7},
    [I(103,111)] = {11,0x4C7},
    [I(104,111)] = {11,0x4E7},
    [I(105,111)] = {10,0xC7},
    [I(106,111)] = {12,0xE87},
    [I(107,111)] = {12,0xEA7},
    [I(108,111)] = {11,0x507},
    [I(109,111)] = {11,0x527},
    [I(110,111)] = {11,0x547},
    [I(111,111)] = {10,0xE7},
    [I(112,111)] = {11,0x567},
    [I(113,111)] = {12,0xEC7},
    [I(114,111)] = {11,0x587},
    [I(115,111)] = {10,0x107},
    [I(116,111)] = {10,0x127},
    [I(117,111)] = {11,0x5A7},
    [I(118,111)] = {12,0xEE7},
    [I(119,111)] = {12,0xF07},
    [I(120,111)] = {12,0xF27},
    [I(121,111)] = {12,0xF47},
    [I(122,111)] = {12,0xF67},
    [I(123,111)] = {20,0xFFFC7},
    [I(124,111)] = {16,0xFF87},
    [I(125,111)] = {19,0x7FFA7},
    [I(126,111)] = {18,0x3FFA7},
    [I(127,111)] = {64,0},
    [I(128,111)] = {25,0x1FFFCC7},
    [I(129,111)] = {27,0x7FFFA47},
    [I(130,111)] = {25,0x1FFFCE7},
    [I(131,111)] = {25,0x1FFFD07},
    [I(132,111)] = {27,0x7FFFA67},
    [I(133,111)] = {27,0x7FFFA87},
    [I(134,111)] = {27,0x7FFFAA7},
    [I(135,111)] = {28,0xFFFFB27},
    [I(136,111)] = {27,0x7FFFAC7},
    [I(137,111)] = {28,0xFFFFB47},
    [I(138,111)] = {28,0xFFFFB67},
    [I(139,111)] = {28,0xFFFFB87},
    [I(140,111)] = {28,0xFFFFBA7},
    [I(141,111)] = {28,0xFFFFBC7},
    [I(142,111)] = {29,0x1FFFFD67},
    [I(143,111)] = {28,0xFFFFBE7},
    [I(144,111)] = {29,0x1FFFFD87},
    [I(145,111)] = {29,0x1FFFFDA7},
    [I(146,111)] = {27,0x7FFFAE7},
    [I(147,111)] = {28,0xFFFFC07},
    [I(148,111)] = {29,0x1FFFFDC7},
    [I(149,111)] = {28,0xFFFFC27},
    [I(150,111)] = {28,0xFFFFC47},
    [I(151,111)] = {28,0xFFFFC67},
    [I(152,111)] = {28,0xFFFFC87},
    [I(153,111)] = {26,0x3FFFB87},
    [I(154,111)] = {27,0x7FFFB07},
    [I(155,111)] = {28,0xFFFFCA7},
    [I(156,111)] = {27,0x7FFFB27},
    [I(157,111)] = {28,0xFFFFCC7},
    [I(158,111)] = {28,0xFFFFCE7},
    [I(159,111)] = {29,0x1FFFFDE7},
    [I(160,111)] = {27,0x7FFFB47},
    [I(161,111)] = {26,0x3FFFBA7},
    [I(162,111)] = {25,0x1FFFD27},
    [I(163,111)] = {27,0x7FFFB67},
    [I(164,111)] = {27,0x7FFFB87},
    [I(165,111)] = {28,0xFFFFD07},
    [I(166,111)] = {28,0xFFFFD27},
    [I(167,111)] = {26,0x3FFFBC7},
    [I(168,111)] = {28,0xFFFFD47},
    [I(169,111)] = {27,0x7FFFBA7},
    [I(170,111)] = {27,0x7FFFBC7},
    [I(171,111)] = {29,0x1FFFFE07},
    [I(172,111)] = {26,0x3FFFBE7},
    [I(173,111)] = {27,0x7FFFBE7},
    [I(174,111)] = {28,0xFFFFD67},
    [I(175,111)] = {28,0xFFFFD87},
    [I(176,111)] = {26,0x3FFFC07},
    [I(177,111)] = {26,0x3FFFC27},
    [I(178,111)] = {27,0x7FFFC07},
    [I(179,111)] = {26,0x3FFFC47},
    [I(180,111)] = {28,0xFFFFDA7},
    [I(181,111)] = {27,0x7FFFC27},
    [I(182,111)] = {28,0xFFFFDC7},
    [I(183,111)] = {28,0xFFFFDE7},
    [I(184,111)] = {25,0x1FFFD47},
    [I(185,111)] = {27,0x7FFFC47},
    [I(186,111)] = {27,0x7FFFC67},
    [I(187,111)] = {27,0x7FFFC87},
    [I(188,111)] = {28,0xFFFFE07},
    [I(189,111)] = {27,0x7FFFCA7},
    [I(190,111)] = {27,0x7FFFCC7},
    [I(191,111)] = {28,0xFFFFE27},
    [I(192,111)] = {31,0x7FFFFC07},
    [I(193,111)] = {31,0x7FFFFC27},
    [I(194,111)] = {25,0x1FFFD67},
    [I(195,111)] = {24,0xFFFE27},
    [I(196,111)] = {27,0x7FFFCE7},
    [I(197,111)] = {28,0xFFFFE47},
    [I(198,111)] = {27,0x7FFFD07},
    [I(199,111)] = {30,0x3FFFFD87},
    [I(200,111)] = {31,0x7FFFFC47},
    [I(201,111)] = {31,0x7FFFFC67},
    [I(202,111)] = {31,0x7FFFFC87},
    [I(203,111)] = {X32,0xFFFFFBC7},
    [I(204,111)] = {X32,0xFFFFFBE7},
    [I(205,111)] = {31,0x7FFFFCA7},
    [I(206,111)] = {29,0x1FFFFE27},
    [I(207,111)] = {30,0x3FFFFDA7},
    [I(208,111)] = {24,0xFFFE47},
    [I(209,111)] = {26,0x3FFFC67},
    [I(210,111)] = {31,0x7FFFFCC7},
    [I(211,111)] = {X32,0xFFFFFC07},
    [I(212,111)] = {X32,0xFFFFFC27},
    [I(213,111)] = {31,0x7FFFFCE7},
    [I(214,111)] = {X32,0xFFFFFC47},
    [I(215,111)] = {29,0x1FFFFE47},
    [I(216,111)] = {26,0x3FFFC87},
    [I(217,111)] = {26,0x3FFFCA7},
    [I(218,111)] = {31,0x7FFFFD07},
    [I(219,111)] = {31,0x7FFFFD27},
    [I(220,111)] = {64,0},
    [I(221,111)] = {X32,0xFFFFFC67},
    [I(222,111)] = {X32,0xFFFFFC87},
    [I(223,111)] = {X32,0xFFFFFCA7},
    [I(224,111)] = {25,0x1FFFD87},
    [I(225,111)] = {29,0x1FFFFE67},
    [I(226,111)] = {25,0x1FFFDA7},
    [I(227,111)] = {26,0x3FFFCC7},
    [I(228,111)] = {27,0x7FFFD27},
    [I(229,111)] = {26,0x3FFFCE7},
    [I(230,111)] = {26,0x3FFFD07},
    [I(231,111)] = {28,0xFFFFE67},
    [I(232,111)] = {27,0x7FFFD47},
    [I(233,111)] = {27,0x7FFFD67},
    [I(234,111)] = {30,0x3FFFFDC7},
    [I(235,111)] = {30,0x3FFFFDE7},
    [I(236,111)] = {29,0x1FFFFE87},
    [I(237,111)] = {29,0x1FFFFEA7},
    [I(238,111)] = {31,0x7FFFFD47},
    [I(239,111)] = {28,0xFFFFE87},
    [I(240,111)] = {31,0x7FFFFD67},
    [I(241,111)] = {X32,0xFFFFFCC7},
    [I(242,111)] = {31,0x7FFFFD87},
    [I(243,111)] = {31,0x7FFFFDA7},
    [I(244,111)] = {X32,0xFFFFFCE7},
    [I(245,111)] = {X32,0xFFFFFD07},
    [I(246,111)] = {X32,0xFFFFFD27},
    [I(247,111)] = {X32,0xFFFFFD47},
    [I(248,111)] = {X32,0xFFFFFD67},
    [I(249,111)] = {64,0},
    [I(250,111)] = {X32,0xFFFFFD87},
    [I(251,111)] = {X32,0xFFFFFDA7},
    [I(252,111)] = {X32,0xFFFFFDC7},
    [I(253,111)] = {X32,0xFFFFFDE7},
    [I(254,111)] = {X32,0xFFFFFE07},
    [I(255,111)] = {31,0x7FFFFDC7},
    [I(0,112)] = {19,0x7FE2B},
    [I(1,112)] = {29,0x1FFFF62B},
    [I(2,112)] = {64,0},
    [I(3,112)] = {64,0},
    [I(4,112)] = {64,0},
    [I(5,112)] = {64,0},
    [I(6,112)] = {64,0},
    [I(7,112)] = {64,0},
    [I(8,112)] = {64,0},
    [I(9,112)] = {30,0x3FFFFAAB},
    [I(10,112)] = {64,0},
    [I(11,112)] = {64,0},
    [I(12,112)] = {64,0},
    [I(13,112)] = {64,0},
    [I(14,112)] = {64,0},
    [I(15,112)] = {64,0},
    [I(16,112)] = {64,0},
    [I(17,112)] = {64,0},
    [I(18,112)] = {64,0},
    [I(19,112)] = {64,0},
    [I(20,112)] = {64,0},
    [I(21,112)] = {64,0},
    [I(22,112)] = {64,0},
    [I(23,112)] = {64,0},
    [I(24,112)] = {64,0},
    [I(25,112)] = {64,0},
    [I(26,112)] = {64,0},
    [I(27,112)] = {64,0},
    [I(28,112)] = {64,0},
    [I(29,112)] = {64,0},
    [I(30,112)] = {64,0},
    [I(31,112)] = {64,0},
    [I(32,112)] = {12,0x52B},
    [I(33,112)] = {16,0xFE2B},
    [I(34,112)] = {16,0xFE6B},
    [I(35,112)] = {18,0x3FEAB},
    [I(36,112)] = {19,0x7FE6B},
    [I(37,112)] = {12,0x56B},
    [I(38,112)] = {14,0x3E2B},
    [I(39,112)] = {17,0x1FEAB},
    [I(40,112)] = {16,0xFEAB},
    [I(41,112)] = {16,0xFEEB},
    [I(42,112)] = {14,0x3E6B},
    [I(43,112)] = {17,0x1FEEB},
    [I(44,112)] = {14,0x3EAB},
    [I(45,112)] = {12,0x5AB},
    [I(46,112)] = {12,0x5EB},
    [I(47,112)] = {12,0x62B},
    [I(48,112)] = {11,0x2B},
    [I(49,112)] = {11,0x6B},
    [I(50,112)] = {11,0xAB},
    [I(51,112)] = {12,0x66B},
    [I(52,112)] = {12,0x6AB},
    [I(53,112)] = {12,0x6EB},
    [I(54,112)] = {12,0x72B},
    [I(55,112)] = {12,0x76B},
    [I(56,112)] = {12,0x7AB},
    [I(57,112)] = {12,0x7EB},
    [I(58,112)] = {13,0x172B},
    [I(59,112)] = {14,0x3EEB},
    [I(60,112)] = {21,0x1FFF2B},
    [I(61,112)] = {12,0x82B},
    [I(62,112)] = {18,0x3FEEB},
    [I(63,112)] = {16,0xFF2B},
    [I(64,112)] = {19,0x7FEAB},
    [I(65,112)] = {12,0x86B},
    [I(66,112)] = {13,0x176B},
    [I(67,112)] = {13,0x17AB},
    [I(68,112)] = {13,0x17EB},
    [I(69,112)] = {13,0x182B},
    [I(70,112)] = {13,0x186B},
    [I(71,112)] = {13,0x18AB},
    [I(72,112)] = {13,0x18EB},
    [I(73,112)] = {13,0x192B},
    [I(74,112)] = {13,0x196B},
    [I(75,112)] = {13,0x19AB},
    [I(76,112)] = {13,0x19EB},
    [I(77,112)] = {13,0x1A2B},
    [I(78,112)] = {13,0x1A6B},
    [I(79,112)] = {13,0x1AAB},
    [I(80,112)] = {13,0x1AEB},
    [I(81,112)] = {13,0x1B2B},
    [I(82,112)] = {13,0x1B6B},
    [I(83,112)] = {13,0x1BAB},
    [I(84,112)] = {13,0x1BEB},
    [I(85,112)] = {13,0x1C2B},
    [I(86,112)] = {13,0x1C6B},
    [I(87,112)] = {13,0x1CAB},
    [I(88,112)] = {14,0x3F2B},
    [I(89,112)] = {13,0x1CEB},
    [I(90,112)] = {14,0x3F6B},
    [I(91,112)] = {19,0x7FEEB},
    [I(92,112)] = {25,0x1FFFC2B},
    [I(93,112)] = {19,0x7FF2B},
    [I(94,112)] = {20,0xFFF2B},
    [I(95,112)] = {12,0x8AB},
    [I(96,112)] = {21,0x1FFF6B},
    [I(97,112)] = {11,0xEB},
    [I(98,112)] = {12,0x8EB},
    [I(99,112)] = {11,0x12B},
    [I(100,112)] = {12,0x92B},
    [I(101,112)] = {11,0x16B},
    [I(102,112)] = {12,0x96B},
    [I(103,112)] = {12,0x9AB},
    [I(104,112)] = {12,0x9EB},
    [I(105,112)] = {11,0x1AB},
    [I(106,112)] = {13,0x1D2B},
    [I(107,112)] = {13,0x1D6B},
    [I(108,112)] = {12,0xA2B},
    [I(109,112)] = {12,0xA6B},
    [I(110,112)] = {12,0xAAB},
    [I(111,112)] = {11,0x1EB},
    [I(112,112)] = {12,0xAEB},
    [I(113,112)] = {13,0x1DAB},
    [I(114,112)] = {12,0xB2B},
    [I(115,112)] = {11,0x22B},
    [I(116,112)] = {11,0x26B},
    [I(117,112)] = {12,0xB6B},
    [I(118,112)] = {13,0x1DEB},
    [I(119,112)] = {13,0x1E2B},
    [I(120,112)] = {13,0x1E6B},
    [I(121,112)] = {13,0x1EAB},
    [I(122,112)] = {13,0x1EEB},
    [I(123,112)] = {21,0x1FFFAB},
    [I(124,112)] = {17,0x1FF2B},
    [I(125,112)] = {20,0xFFF6B},
    [I(126,112)] = {19,0x7FF6B},
    [I(127,112)] = {64,0},
    [I(128,112)] = {26,0x3FFF9AB},
    [I(129,112)] = {28,0xFFFF4AB},
    [I(130,112)] = {26,0x3FFF9EB},
    [I(131,112)] = {26,0x3FFFA2B},
    [I(132,112)] = {28,0xFFFF4EB},
    [I(133,112)] = {28,0xFFFF52B},
    [I(134,112)] = {28,0xFFFF56B},
    [I(135,112)] = {29,0x1FFFF66B},
    [I(136,112)] = {28,0xFFFF5AB},
    [I(137,112)] = {29,0x1FFFF6AB},
    [I(138,112)] = {29,0x1FFFF6EB},
    [I(139,112)] = {29,0x1FFFF72B},
    [I(140,112)] = {29,0x1FFFF76B},
    [I(141,112)] = {29,0x1FFFF7AB},
    [I(142,112)] = {30,0x3FFFFAEB},
    [I(143,112)] = {29,0x1FFFF7EB},
    [I(144,112)] = {30,0x3FFFFB2B},
    [I(145,112)] = {30,0x3FFFFB6B},
    [I(146,112)] = {28,0xFFFF5EB},
    [I(147,112)] = {29,0x1FFFF82B},
    [I(148,112)] = {30,0x3FFFFBAB},
    [I(149,112)] = {29,0x1FFFF86B},
    [I(150,112)] = {29,0x1FFFF8AB},
    [I(151,112)] = {29,0x1FFFF8EB},
    [I(152,112)] = {29,0x1FFFF92B},
    [I(153,112)] = {27,0x7FFF72B},
    [I(154,112)] = {28,0xFFFF62B},
    [I(155,112)] = {29,0x1FFFF96B},
    [I(156,112)] = {28,0xFFFF66B},
    [I(157,112)] = {29,0x1FFFF9AB},
    [I(158,112)] = {29,0x1FFFF9EB},
    [I(159,112)] = {30,0x3FFFFBEB},
    [I(160,112)] = {28,0xFFFF6AB},
    [I(161,112)] = {27,0x7FFF76B},
    [I(162,112)] = {26,0x3FFFA6B},
    [I(163,112)] = {28,0xFFFF6EB},
    [I(164,112)] = {28,0xFFFF72B},
    [I(165,112)] = {29,0x1FFFFA2B},
    [I(166,112)] = {29,0x1FFFFA6B},
    [I(167,112)] = {27,0x7FFF7AB},
    [I(168,112)] = {29,0x1FFFFAAB},
    [I(169,112)] = {28,0xFFFF76B},
    [I(170,112)] = {28,0xFFFF7AB},
    [I(171,112)] = {30,0x3FFFFC2B},
    [I(172,112)] = {27,0x7FFF7EB},
    [I(173,112)] = {28,0xFFFF7EB},
    [I(174,112)] = {29,0x1FFFFAEB},
    [I(175,112)] = {29,0x1FFFFB2B},
    [I(176,112)] = {27,0x7FFF82B},
    [I(177,112)] = {27,0x7FFF86B},
    [I(178,112)] = {28,0xFFFF82B},
    [I(179,112)] = {27,0x7FFF8AB},
    [I(180,112)] = {29,0x1FFFFB6B},
    [I(181,112)] = {28,0xFFFF86B},
    [I(182,112)] = {29,0x1FFFFBAB},
    [I(183,112)] = {29,0x1FFFFBEB},
    [I(184,112)] = {26,0x3FFFAAB},
    [I(185,112)] = {28,0xFFFF8AB},
    [I(186,112)] = {28,0xFFFF8EB},
    [I(187,112)] = {28,0xFFFF92B},
    [I(188,112)] = {29,0x1FFFFC2B},
    [I(189,112)] = {28,0xFFFF96B},
    [I(190,112)] = {28,0xFFFF9AB},
    [I(191,112)] = {29,0x1FFFFC6B},
    [I(192,112)] = {X32,0xFFFFF82B},
    [I(193,112)] = {X32,0xFFFFF86B},
    [I(194,112)] = {26,0x3FFFAEB},
    [I(195,112)] = {25,0x1FFFC6B},
    [I(196,112)] = {28,0xFFFF9EB},
    [I(197,112)] = {29,0x1FFFFCAB},
    [I(198,112)] = {28,0xFFFFA2B},
    [I(199,112)] = {31,0x7FFFFB2B},
    [I(200,112)] = {X32,0xFFFFF8AB},
    [I(201,112)] = {X32,0xFFFFF8EB},
    [I(202,112)] = {X32,0xFFFFF92B},
    [I(203,112)] = {64,0},
    [I(204,112)] = {64,0},
    [I(205,112)] = {X32,0xFFFFF96B},
    [I(206,112)] = {30,0x3FFFFC6B},
    [I(207,112)] = {31,0x7FFFFB6B},
    [I(208,112)] = {25,0x1FFFCAB},
    [I(209,112)] = {27,0x7FFF8EB},
    [I(210,112)] = {X32,0xFFFFF9AB},
    [I(211,112)] = {64,0},
    [I(212,112)] = {64,0},
    [I(213,112)] = {X32,0xFFFFF9EB},
    [I(214,112)] = {64,0},
    [I(215,112)] = {30,0x3FFFFCAB},
    [I(216,112)] = {27,0x7FFF92B},
    [I(217,112)] = {27,0x7FFF96B},
    [I(218,112)] = {X32,0xFFFFFA2B},
    [I(219,112)] = {X32,0xFFFFFA6B},
    [I(220,112)] = {64,0},
    [I(221,112)] = {64,0},
    [I(222,112)] = {64,0},
    [I(223,112)] = {64,0},
    [I(224,112)] = {26,0x3FFFB2B},
    [I(225,112)] = {30,0x3FFFFCEB},
    [I(226,112)] = {26,0x3FFFB6B},
    [I(227,112)] = {27,0x7FFF9AB},
    [I(228,112)] = {28,0xFFFFA6B},
    [I(229,112)] = {27,0x7FFF9EB},
    [I(230,112)] = {27,0x7FFFA2B},
    [I(231,112)] = {29,0x1FFFFCEB},
    [I(232,112)] = {28,0xFFFFAAB},
    [I(233,112)] = {28,0xFFFFAEB},
    [I(234,112)] = {31,0x7FFFFBAB},
    [I(235,112)] = {31,0x7FFFFBEB},
    [I(236,112)] = {30,0x3FFFFD2B},
    [I(237,112)] = {30,0x3FFFFD6B},
    [I(238,112)] = {X32,0xFFFFFAAB},
    [I(239,112)] = {29,0x1FFFFD2B},
    [I(240,112)] = {X32,0xFFFFFAEB},
    [I(241,112)] = {64,0},
    [I(242,112)] = {X32,0xFFFFFB2B},
    [I(243,112)] = {X32,0xFFFFFB6B},
    [I(244,112)] = {64,0},
    [I(245,112)] = {64,0},
    [I(246,112)] = {64,0},
    [I(247,112)] = {64,0},
    [I(248,112)] = {64,0},
    [I(249,112)] = {64,0},
    [I(250,112)] = {64,0},
    [I(251,112)] = {64,0},
    [I(252,112)] = {64,0},
    [I(253,112)] = {64,0},
    [I(254,112)] = {64,0},
    [I(255,112)] = {X32,0xFFFFFBAB},
    [I(0,113)] = {20,0xFFC76},
    [I(1,113)] = {30,0x3FFFEC76},
    [I(2,113)] = {64,0},
    [I(3,113)] = {64,0},
    [I(4,113)] = {64,0},
    [I(5,113)] = {64,0},
    [I(6,113)] = {64,0},
    [I(7,113)] = {64,0},
    [I(8,113)] = {64,0},
    [I(9,113)] = {31,0x7FFFF576},
    [I(10,113)] = {64,0},
    [I(11,113)] = {64,0},
    [I(12,113)] = {64,0},
    [I(13,113)] = {64,0},
    [I(14,113)] = {64,0},
    [I(15,113)] = {64,0},
    [I(16,113)] = {64,0},
    [I(17,113)] = {64,0},
    [I(18,113)] = {64,0},
    [I(19,113)] = {64,0},
    [I(20,113)] = {64,0},
    [I(21,113)] = {64,0},
    [I(22,113)] = {64,0},
    [I(23,113)] = {64,0},
    [I(24,113)] = {64,0},
    [I(25,113)] = {64,0},
    [I(26,113)] = {64,0},
    [I(27,113)] = {64,0},
    [I(28,113)] = {64,0},
    [I(29,113)] = {64,0},
    [I(30,113)] = {64,0},
    [I(31,113)] = {64,0},
    [I(32,113)] = {13,0xA76},
    [I(33,113)] = {17,0x1FC76},
    [I(34,113)] = {17,0x1FCF6},
    [I(35,113)] = {19,0x7FD76},
    [I(36,113)] = {20,0xFFCF6},
    [I(37,113)] = {13,0xAF6},
    [I(38,113)] = {15,0x7C76},
    [I(39,113)] = {18,0x3FD76},
    [I(40,113)] = {17,0x1FD76},
    [I(41,113)] = {17,0x1FDF6},
    [I(42,113)] = {15,0x7CF6},
    [I(43,113)] = {18,0x3FDF6},
    [I(44,113)] = {15,0x7D76},
    [I(45,113)] = {13,0xB76},
    [I(46,113)] = {13,0xBF6},
    [I(47,113)] = {13,0xC76},
    [I(48,113)] = {12,0x76},
    [I(49,113)] = {12,0xF6},
    [I(50,113)] = {12,0x176},
    [I(51,113)] = {13,0xCF6},
    [I(52,113)] = {13,0xD76},
    [I(53,113)] = {13,0xDF6},
    [I(54,113)] = {13,0xE76},
    [I(55,113)] = {13,0xEF6},
    [I(56,113)] = {13,0xF76},
    [I(57,113)] = {13,0xFF6},
    [I(58,113)] = {14,0x2E76},
    [I(59,113)] = {15,0x7DF6},
    [I(60,113)] = {22,0x3FFE76},
    [I(61,113)] = {13,0x1076},
    [I(62,113)] = {19,0x7FDF6},
    [I(63,113)] = {17,0x1FE76},
    [I(64,113)] = {20,0xFFD76},
    [I(65,113)] = {13,0x10F6},
    [I(66,113)] = {14,0x2EF6},
    [I(67,113)] = {14,0x2F76},
    [I(68,113)] = {14,0x2FF6},
    [I(69,113)] = {14,0x3076},
    [I(70,113)] = {14,0x30F6},
    [I(71,113)] = {14,0x3176},
    [I(72,113)] = {14,0x31F6},
    [I(73,113)] = {14,0x3276},
    [I(74,113)] = {14,0x32F6},
    [I(75,113)] = {14,0x3376},
    [I(76,113)] = {14,0x33F6},
    [I(77,113)] = {14,0x3476},
    [I(78,113)] = {14,0x34F6},
    [I(79,113)] = {14,0x3576},
    [I(80,113)] = {14,0x35F6},
    [I(81,113)] = {14,0x3676},
    [I(82,113)] = {14,0x36F6},
    [I(83,113)] = {14,0x3776},
    [I(84,113)] = {14,0x37F6},
    [I(85,113)] = {14,0x3876},
    [I(86,113)] = {14,0x38F6},
    [I(87,113)] = {14,0x3976},
    [I(88,113)] = {15,0x7E76},
    [I(89,113)] = {14,0x39F6},
    [I(90,113)] = {15,0x7EF6},
    [I(91,113)] = {20,0xFFDF6},
    [I(92,113)] = {26,0x3FFF876},
    [I(93,113)] = {20,0xFFE76},
    [I(94,113)] = {21,0x1FFE76},
    [I(95,113)] = {13,0x1176},
    [I(96,113)] = {22,0x3FFEF6},
    [I(97,113)] = {12,0x1F6},
    [I(98,113)] = {13,0x11F6},
    [I(99,113)] = {12,0x276},
    [I(100,113)] = {13,0x1276},
    [I(101,113)] = {12,0x2F6},
    [I(102,113)] = {13,0x12F6},
    [I(103,113)] = {13,0x1376},
    [I(104,113)] = {13,0x13F6},
    [I(105,113)] = {12,0x376},
    [I(106,113)] = {14,0x3A76},
    [I(107,113)] = {14,0x3AF6},
    [I(108,113)] = {13,0x1476},
    [I(109,113)] = {13,0x14F6},
    [I(110,113)] = {13,0x1576},
    [I(111,113)] = {12,0x3F6},
    [I(112,113)] = {13,0x15F6},
    [I(113,113)] = {14,0x3B76},
    [I(114,113)] = {13,0x1676},
    [I(115,113)] = {12,0x476},
    [I(116,113)] = {12,0x4F6},
    [I(117,113)] = {13,0x16F6},
    [I(118,113)] = {14,0x3BF6},
    [I(119,113)] = {14,0x3C76},
    [I(120,113)] = {14,0x3CF6},
    [I(121,113)] = {14,0x3D76},
    [I(122,113)] = {14,0x3DF6},
    [I(123,113)] = {22,0x3FFF76},
    [I(124,113)] = {18,0x3FE76},
    [I(125,113)] = {21,0x1FFEF6},
    [I(126,113)] = {20,0xFFEF6},
    [I(127,113)] = {64,0},
    [I(128,113)] = {27,0x7FFF376},
    [I(129,113)] = {29,0x1FFFE976},
    [I(130,113)] = {27,0x7FFF3F6},
    [I(131,113)] = {27,0x7FFF476},
    [I(132,113)] = {29,0x1FFFE9F6},
    [I(133,113)] = {29,0x1FFFEA76},
    [I(134,113)] = {29,0x1FFFEAF6},
    [I(135,113)] = {30,0x3FFFECF6},
    [I(136,113)] = {29,0x1FFFEB76},
    [I(137,113)] = {30,0x3FFFED76},
    [I(138,113)] = {30,0x3FFFEDF6},
    [I(139,113)] = {30,0x3FFFEE76},
    [I(140,113)] = {30,0x3FFFEEF6},
    [I(141,113)] = {30,0x3FFFEF76},
    [I(142,113)] = {31,0x7FFFF5F6},
    [I(143,113)] = {30,0x3FFFEFF6},
    [I(144,113)] = {31,0x7FFFF676},
    [I(145,113)] = {31,0x7FFFF6F6},
    [I(146,113)] = {29,0x1FFFEBF6},
    [I(147,113)] = {30,0x3FFFF076},
    [I(148,113)] = {31,0x7FFFF776},
    [I(149,113)] = {30,0x3FFFF0F6},
    [I(150,113)] = {30,0x3FFFF176},
    [I(151,113)] = {30,0x3FFFF1F6},
    [I(152,113)] = {30,0x3FFFF276},
    [I(153,113)] = {28,0xFFFEE76},
    [I(154,113)] = {29,0x1FFFEC76},
    [I(155,113)] = {30,0x3FFFF2F6},
    [I(156,113)] = {29,0x1FFFECF6},
    [I(157,113)] = {30,0x3FFFF376},
    [I(158,113)] = {30,0x3FFFF3F6},
    [I(159,113)] = {31,0x7FFFF7F6},
    [I(160,113)] = {29,0x1FFFED76},
    [I(161,113)] = {28,0xFFFEEF6},
    [I(162,113)] = {27,0x7FFF4F6},
    [I(163,113)] = {29,0x1FFFEDF6},
    [I(164,113)] = {29,0x1FFFEE76},
    [I(165,113)] = {30,0x3FFFF476},
    [I(166,113)] = {30,0x3FFFF4F6},
    [I(167,113)] = {28,0xFFFEF76},
    [I(168,113)] = {30,0x3FFFF576},
    [I(169,113)] = {29,0x1FFFEEF6},
    [I(170,113)] = {29,0x1FFFEF76},
    [I(171,113)] = {31,0x7FFFF876},
    [I(172,113)] = {28,0xFFFEFF6},
    [I(173,113)] = {29,0x1FFFEFF6},
    [I(174,113)] = {30,0x3FFFF5F6},
    [I(175,113)] = {30,0x3FFFF676},
    [I(176,113)] = {28,0xFFFF076},
    [I(177,113)] = {28,0xFFFF0F6},
    [I(178,113)] = {29,0x1FFFF076},
    [I(179,113)] = {28,0xFFFF176},
    [I(180,113)] = {30,0x3FFFF6F6},
    [I(181,113)] = {29,0x1FFFF0F6},
    [I(182,113)] = {30,0x3FFFF776},
    [I(183,113)] = {30,0x3FFFF7F6},
    [I(184,113)] = {27,0x7FFF576},
    [I(185,113)] = {29,0x1FFFF176},
    [I(186,113)] = {29,0x1FFFF1F6},
    [I(187,113)] = {29,0x1FFFF276},
    [I(188,113)] = {30,0x3FFFF876},
    [I(189,113)] = {29,0x1FFFF2F6},
    [I(190,113)] = {29,0x1FFFF376},
    [I(191,113)] = {30,0x3FFFF8F6},
    [I(192,113)] = {64,0},
    [I(193,113)] = {64,0},
    [I(194,113)] = {27,0x7FFF5F6},
    [I(195,113)] = {26,0x3FFF8F6},
    [I(196,113)] = {29,0x1FFFF3F6},
    [I(197,113)] = {30,0x3FFFF976},
    [I(198,113)] = {29,0x1FFFF476},
    [I(199,113)] = {X32,0xFFFFF676},
    [I(200,113)] = {64,0},
    [I(201,113)] = {64,0},
    [I(202,113)] = {64,0},
    [I(203,113)] = {64,0},
    [I(204,113)] = {64,0},
    [I(205,113)] = {64,0},
    [I(206,113)] = {31,0x7FFFF8F6},
    [I(207,113)] = {X32,0xFFFFF6F6},
    [I(208,113)] = {26,0x3FFF976},
    [I(209,113)] = {28,0xFFFF1F6},
    [I(210,113)] = {64,0},
    [I(211,113)] = {64,0},
    [I(212,113)] = {64,0},
    [I(213,113)] = {64,0},
    [I(214,113)] = {64,0},
    [I(215,113)] = {31,0x7FFFF976},
    [I(216,113)] = {28,0xFFFF276},
    [I(217,113)] = {28,0xFFFF2F6},
    [I(218,113)] = {64,0},
    [I(219,113)] = {64,0},
    [I(220,113)] = {64,0},
    [I(221,113)] = {64,0},
    [I(222,113)] = {64,0},
    [I(223,113)] = {64,0},
    [I(224,113)] = {27,0x7FFF676},
    [I(225,113)] = {31,0x7FFFF9F6},
    [I(226,113)] = {27,0x7FFF6F6},
    [I(227,113)] = {28,0xFFFF376},
    [I(228,113)] = {29,0x1FFFF4F6},
    [I(229,113)] = {28,0xFFFF3F6},
    [I(230,113)] = {28,0xFFFF476},
    [I(231,113)] = {30,0x3FFFF9F6},
    [I(232,113)] = {29,0x1FFFF576},
    [I(233,113)] = {29,0x1FFFF5F6},
    [I(234,113)] = {X32,0xFFFFF776},
    [I(235,113)] = {X32,0xFFFFF7F6},
    [I(236,113)] = {31,0x7FFFFA76},
    [I(237,113)] = {31,0x7FFFFAF6},
    [I(238,113)] = {64,0},
    [I(239,113)] = {30,0x3FFFFA76},
    [I(240,113)] = {64,0},
    [I(241,113)] = {64,0},
    [I(242,113)] = {64,0},
    [I(243,113)] = {64,0},
    [I(244,113)] = {64,0},
    [I(245,113)] = {64,0},
    [I(246,113)] = {64,0},
    [I(247,113)] = {64,0},
    [I(248,113)] = {64,0},
    [I(249,113)] = {64,0},
    [I(250,113)] = {64,0},
    [I(251,113)] = {64,0},
    [I(252,113)] = {64,0},
    [I(253,113)] = {64,0},
    [I(254,113)] = {64,0},
    [I(255,113)] = {64,0},
    [I(0,114)] = {19,0x7FE2C},
    [I(1,114)] = {29,0x1FFFF62C},
    [I(2,114)] = {64,0},
    [I(3,114)] = {64,0},
    [I(4,114)] = {64,0},
    [I(5,114)] = {64,0},
    [I(6,114)] = {64,0},
    [I(7,114)] = {64,0},
    [I(8,114)] = {64,0},
    [I(9,114)] = {30,0x3FFFFAAC},
    [I(10,114)] = {64,0},
    [I(11,114)] = {64,0},
    [I(12,114)] = {64,0},
    [I(13,114)] = {64,0},
    [I(14,114)] = {64,0},
    [I(15,114)] = {64,0},
    [I(16,114)] = {64,0},
    [I(17,114)] = {64,0},
    [I(18,114)] = {64,0},
    [I(19,114)] = {64,0},
    [I(20,114)] = {64,0},
    [I(21,114)] = {64,0},
    [I(22,114)] = {64,0},
    [I(23,114)] = {64,0},
    [I(24,114)] = {64,0},
    [I(25,114)] = {64,0},
    [I(26,114)] = {64,0},
    [I(27,114)] = {64,0},
    [I(28,114)] = {64,0},
    [I(29,114)] = {64,0},
    [I(30,114)] = {64,0},
    [I(31,114)] = {64,0},
    [I(32,114)] = {12,0x52C},
    [I(33,114)] = {16,0xFE2C},
    [I(34,114)] = {16,0xFE6C},
    [I(35,114)] = {18,0x3FEAC},
    [I(36,114)] = {19,0x7FE6C},
    [I(37,114)] = {12,0x56C},
    [I(38,114)] = {14,0x3E2C},
    [I(39,114)] = {17,0x1FEAC},
    [I(40,114)] = {16,0xFEAC},
    [I(41,114)] = {16,0xFEEC},
    [I(42,114)] = {14,0x3E6C},
    [I(43,114)] = {17,0x1FEEC},
    [I(44,114)] = {14,0x3EAC},
    [I(45,114)] = {12,0x5AC},
    [I(46,114)] = {12,0x5EC},
    [I(47,114)] = {12,0x62C},
    [I(48,114)] = {11,0x2C},
    [I(49,114)] = {11,0x6C},
    [I(50,114)] = {11,0xAC},
    [I(51,114)] = {12,0x66C},
    [I(52,114)] = {12,0x6AC},
    [I(53,114)] = {12,0x6EC},
    [I(54,114)] = {12,0x72C},
    [I(55,114)] = {12,0x76C},
    [I(56,114)] = {12,0x7AC},
    [I(57,114)] = {12,0x7EC},
    [I(58,114)] = {13,0x172C},
    [I(59,114)] = {14,0x3EEC},
    [I(60,114)] = {21,0x1FFF2C},
    [I(61,114)] = {12,0x82C},
    [I(62,114)] = {18,0x3FEEC},
    [I(63,114)] = {16,0xFF2C},
    [I(64,114)] = {19,0x7FEAC},
    [I(65,114)] = {12,0x86C},
    [I(66,114)] = {13,0x176C},
    [I(67,114)] = {13,0x17AC},
    [I(68,114)] = {13,0x17EC},
    [I(69,114)] = {13,0x182C},
    [I(70,114)] = {13,0x186C},
    [I(71,114)] = {13,0x18AC},
    [I(72,114)] = {13,0x18EC},
    [I(73,114)] = {13,0x192C},
    [I(74,114)] = {13,0x196C},
    [I(75,114)] = {13,0x19AC},
    [I(76,114)] = {13,0x19EC},
    [I(77,114)] = {13,0x1A2C},
    [I(78,114)] = {13,0x1A6C},
    [I(79,114)] = {13,0x1AAC},
    [I(80,114)] = {13,0x1AEC},
    [I(81,114)] = {13,0x1B2C},
    [I(82,114)] = {13,0x1B6C},
    [I(83,114)] = {13,0x1BAC},
    [I(84,114)] = {13,0x1BEC},
    [I(85,114)] = {13,0x1C2C},
    [I(86,114)] = {13,0x1C6C},
    [I(87,114)] = {13,0x1CAC},
    [I(88,114)] = {14,0x3F2C},
    [I(89,114)] = {13,0x1CEC},
    [I(90,114)] = {14,0x3F6C},
    [I(91,114)] = {19,0x7FEEC},
    [I(92,114)] = {25,0x1FFFC2C},
    [I(93,114)] = {19,0x7FF2C},
    [I(94,114)] = {20,0xFFF2C},
    [I(95,114)] = {12,0x8AC},
    [I(96,114)] = {21,0x1FFF6C},
    [I(97,114)] = {11,0xEC},
    [I(98,114)] = {12,0x8EC},
    [I(99,114)] = {11,0x12C},
    [I(100,114)] = {12,0x92C},
    [I(101,114)] = {11,0x16C},
    [I(102,114)] = {12,0x96C},
    [I(103,114)] = {12,0x9AC},
    [I(104,114)] = {12,0x9EC},
    [I(105,114)] = {11,0x1AC},
    [I(106,114)] = {13,0x1D2C},
    [I(107,114)] = {13,0x1D6C},
    [I(108,114)] = {12,0xA2C},
    [I(109,114)] = {12,0xA6C},
    [I(110,114)] = {12,0xAAC},
    [I(111,114)] = {11,0x1EC},
    [I(112,114)] = {12,0xAEC},
    [I(113,114)] = {13,0x1DAC},
    [I(114,114)] = {12,0xB2C},
    [I(115,114)] = {11,0x22C},
    [I(116,114)] = {11,0x26C},
    [I(117,114)] = {12,0xB6C},
    [I(118,114)] = {13,0x1DEC},
    [I(119,114)] = {13,0x1E2C},
    [I(120,114)] = {13,0x1E6C},
    [I(121,114)] = {13,0x1EAC},
    [I(122,114)] = {13,0x1EEC},
    [I(123,114)] = {21,0x1FFFAC},
    [I(124,114)] = {17,0x1FF2C},
    [I(125,114)] = {20,0xFFF6C},
    [I(126,114)] = {19,0x7FF6C},
    [I(127,114)] = {64,0},
    [I(128,114)] = {26,0x3FFF9AC},
    [I(129,114)] = {28,0xFFFF4AC},
    [I(130,114)] = {26,0x3FFF9EC},
    [I(131,114)] = {26,0x3FFFA2C},
    [I(132,114)] = {28,0xFFFF4EC},
    [I(133,114)] = {28,0xFFFF52C},
    [I(134,114)] = {28,0xFFFF56C},
    [I(135,114)] = {29,0x1FFFF66C},
    [I(136,114)] = {28,0xFFFF5AC},
    [I(137,114)] = {29,0x1FFFF6AC},
    [I(138,114)] = {29,0x1FFFF6EC},
    [I(139,114)] = {29,0x1FFFF72C},
    [I(140,114)] = {29,0x1FFFF76C},
    [I(141,114)] = {29,0x1FFFF7AC},
    [I(142,114)] = {30,0x3FFFFAEC},
    [I(143,114)] = {29,0x1FFFF7EC},
    [I(144,114)] = {30,0x3FFFFB2C},
    [I(145,114)] = {30,0x3FFFFB6C},
    [I(146,114)] = {28,0xFFFF5EC},
    [I(147,114)] = {29,0x1FFFF82C},
    [I(148,114)] = {30,0x3FFFFBAC},
    [I(149,114)] = {29,0x1FFFF86C},
    [I(150,114)] = {29,0x1FFFF8AC},
    [I(151,114)] = {29,0x1FFFF8EC},
    [I(152,114)] = {29,0x1FFFF92C},
    [I(153,114)] = {27,0x7FFF72C},
    [I(154,114)] = {28,0xFFFF62C},
    [I(155,114)] = {29,0x1FFFF96C},
    [I(156,114)] = {28,0xFFFF66C},
    [I(157,114)] = {29,0x1FFFF9AC},
    [I(158,114)] = {29,0x1FFFF9EC},
    [I(159,114)] = {30,0x3FFFFBEC},
    [I(160,114)] = {28,0xFFFF6AC},
    [I(161,114)] = {27,0x7FFF76C},
    [I(162,114)] = {26,0x3FFFA6C},
    [I(163,114)] = {28,0xFFFF6EC},
    [I(164,114)] = {28,0xFFFF72C},
    [I(165,114)] = {29,0x1FFFFA2C},
    [I(166,114)] = {29,0x1FFFFA6C},
    [I(167,114)] = {27,0x7FFF7AC},
    [I(168,114)] = {29,0x1FFFFAAC},
    [I(169,114)] = {28,0xFFFF76C},
    [I(170,114)] = {28,0xFFFF7AC},
    [I(171,114)] = {30,0x3FFFFC2C},
    [I(172,114)] = {27,0x7FFF7EC},
    [I(173,114)] = {28,0xFFFF7EC},
    [I(174,114)] = {29,0x1FFFFAEC},
    [I(175,114)] = {29,0x1FFFFB2C},
    [I(176,114)] = {27,0x7FFF82C},
    [I(177,114)] = {27,0x7FFF86C},
    [I(178,114)] = {28,0xFFFF82C},
    [I(179,114)] = {27,0x7FFF8AC},
    [I(180,114)] = {29,0x1FFFFB6C},
    [I(181,114)] = {28,0xFFFF86C},
    [I(182,114)] = {29,0x1FFFFBAC},
    [I(183,114)] = {29,0x1FFFFBEC},
    [I(184,114)] = {26,0x3FFFAAC},
    [I(185,114)] = {28,0xFFFF8AC},
    [I(186,114)] = {28,0xFFFF8EC},
    [I(187,114)] = {28,0xFFFF92C},
    [I(188,114)] = {29,0x1FFFFC2C},
    [I(189,114)] = {28,0xFFFF96C},
    [I(190,114)] = {28,0xFFFF9AC},
    [I(191,114)] = {29,0x1FFFFC6C},
    [I(192,114)] = {X32,0xFFFFF82C},
    [I(193,114)] = {X32,0xFFFFF86C},
    [I(194,114)] = {26,0x3FFFAEC},
    [I(195,114)] = {25,0x1FFFC6C},
    [I(196,114)] = {28,0xFFFF9EC},
    [I(197,114)] = {29,0x1FFFFCAC},
    [I(198,114)] = {28,0xFFFFA2C},
    [I(199,114)] = {31,0x7FFFFB2C},
    [I(200,114)] = {X32,0xFFFFF8AC},
    [I(201,114)] = {X32,0xFFFFF8EC},
    [I(202,114)] = {X32,0xFFFFF92C},
    [I(203,114)] = {64,0},
    [I(204,114)] = {64,0},
    [I(205,114)] = {X32,0xFFFFF96C},
    [I(206,114)] = {30,0x3FFFFC6C},
    [I(207,114)] = {31,0x7FFFFB6C},
    [I(208,114)] = {25,0x1FFFCAC},
    [I(209,114)] = {27,0x7FFF8EC},
    [I(210,114)] = {X32,0xFFFFF9AC},
    [I(211,114)] = {64,0},
    [I(212,114)] = {64,0},
    [I(213,114)] = {X32,0xFFFFF9EC},
    [I(214,114)] = {64,0},
    [I(215,114)] = {30,0x3FFFFCAC},
    [I(216,114)] = {27,0x7FFF92C},
    [I(217,114)] = {27,0x7FFF96C},
    [I(218,114)] = {X32,0xFFFFFA2C},
    [I(219,114)] = {X32,0xFFFFFA6C},
    [I(220,114)] = {64,0},
    [I(221,114)] = {64,0},
    [I(222,114)] = {64,0},
    [I(223,114)] = {64,0},
    [I(224,114)] = {26,0x3FFFB2C},
    [I(225,114)] = {30,0x3FFFFCEC},
    [I(226,114)] = {26,0x3FFFB6C},
    [I(227,114)] = {27,0x7FFF9AC},
    [I(228,114)] = {28,0xFFFFA6C},
    [I(229,114)] = {27,0x7FFF9EC},
    [I(230,114)] = {27,0x7FFFA2C},
    [I(231,114)] = {29,0x1FFFFCEC},
    [I(232,114)] = {28,0xFFFFAAC},
    [I(233,114)] = {28,0xFFFFAEC},
    [I(234,114)] = {31,0x7FFFFBAC},
    [I(235,114)] = {31,0x7FFFFBEC},
    [I(236,114)] = {30,0x3FFFFD2C},
    [I(237,114)] = {30,0x3FFFFD6C},
    [I(238,114)] = {X32,0xFFFFFAAC},
    [I(239,114)] = {29,0x1FFFFD2C},
    [I(240,114)] = {X32,0xFFFFFAEC},
    [I(241,114)] = {64,0},
    [I(242,114)] = {X32,0xFFFFFB2C},
    [I(243,114)] = {X32,0xFFFFFB6C},
    [I(244,114)] = {64,0},
    [I(245,114)] = {64,0},
    [I(246,114)] = {64,0},
    [I(247,114)] = {64,0},
    [I(248,114)] = {64,0},
    [I(249,114)] = {64,0},
    [I(250,114)] = {64,0},
    [I(251,114)] = {64,0},
    [I(252,114)] = {64,0},
    [I(253,114)] = {64,0},
    [I(254,114)] = {64,0},
    [I(255,114)] = {X32,0xFFFFFBAC},
    [I(0,115)] = {18,0x3FF08},
    [I(1,115)] = {28,0xFFFFB08},
    [I(2,115)] = {64,0},
    [I(3,115)] = {64,0},
    [I(4,115)] = {64,0},
    [I(5,115)] = {64,0},
    [I(6,115)] = {64,0},
    [I(7,115)] = {64,0},
    [I(8,115)] = {64,0},
    [I(9,115)] = {29,0x1FFFFD48},
    [I(10,115)] = {64,0},
    [I(11,115)] = {64,0},
    [I(12,115)] = {64,0},
    [I(13,115)] = {64,0},
    [I(14,115)] = {64,0},
    [I(15,115)] = {64,0},
    [I(16,115)] = {64,0},
    [I(17,115)] = {64,0},
    [I(18,115)] = {64,0},
    [I(19,115)] = {64,0},
    [I(20,115)] = {64,0},
    [I(21,115)] = {64,0},
    [I(22,115)] = {64,0},
    [I(23,115)] = {64,0},
    [I(24,115)] = {64,0},
    [I(25,115)] = {64,0},
    [I(26,115)] = {64,0},
    [I(27,115)] = {64,0},
    [I(28,115)] = {64,0},
    [I(29,115)] = {64,0},
    [I(30,115)] = {64,0},
    [I(31,115)] = {64,0},
    [I(32,115)] = {11,0x288},
    [I(33,115)] = {15,0x7F08},
    [I(34,115)] = {15,0x7F28},
    [I(35,115)] = {17,0x1FF48},
    [I(36,115)] = {18,0x3FF28},
    [I(37,115)] = {11,0x2A8},
    [I(38,115)] = {13,0x1F08},
    [I(39,115)] = {16,0xFF48},
    [I(40,115)] = {15,0x7F48},
    [I(41,115)] = {15,0x7F68},
    [I(42,115)] = {13,0x1F28},
    [I(43,115)] = {16,0xFF68},
    [I(44,115)] = {13,0x1F48},
    [I(45,115)] = {11,0x2C8},
    [I(46,115)] = {11,0x2E8},
    [I(47,115)] = {11,0x308},
    [I(48,115)] = {10,0x8},
    [I(49,115)] = {10,0x28},
    [I(50,115)] = {10,0x48},
    [I(51,115)] = {11,0x328},
    [I(52,115)] = {11,0x348},
    [I(53,115)] = {11,0x368},
    [I(54,115)] = {11,0x388},
    [I(55,115)] = {11,0x3A8},
    [I(56,115)] = {11,0x3C8},
    [I(57,115)] = {11,0x3E8},
    [I(58,115)] = {12,0xB88},
    [I(59,115)] = {13,0x1F68},
    [I(60,115)] = {20,0xFFF88},
    [I(61,115)] = {11,0x408},
    [I(62,115)] = {17,0x1FF68},
    [I(63,115)] = {15,0x7F88},
    [I(64,115)] = {18,0x3FF48},
    [I(65,115)] = {11,0x428},
    [I(66,115)] = {12,0xBA8},
    [I(67,115)] = {12,0xBC8},
    [I(68,115)] = {12,0xBE8},
    [I(69,115)] = {12,0xC08},
    [I(70,115)] = {12,0xC28},
    [I(71,115)] = {12,0xC48},
    [I(72,115)] = {12,0xC68},
    [I(73,115)] = {12,0xC88},
    [I(74,115)] = {12,0xCA8},
    [I(75,115)] = {12,0xCC8},
    [I(76,115)] = {12,0xCE8},
    [I(77,115)] = {12,0xD08},
    [I(78,115)] = {12,0xD28},
    [I(79,115)] = {12,0xD48},
    [I(80,115)] = {12,0xD68},
    [I(81,115)] = {12,0xD88},
    [I(82,115)] = {12,0xDA8},
    [I(83,115)] = {12,0xDC8},
    [I(84,115)] = {12,0xDE8},
    [I(85,115)] = {12,0xE08},
    [I(86,115)] = {12,0xE28},
    [I(87,115)] = {12,0xE48},
    [I(88,115)] = {13,0x1F88},
    [I(89,115)] = {12,0xE68},
    [I(90,115)] = {13,0x1FA8},
    [I(91,115)] = {18,0x3FF68},
    [I(92,115)] = {24,0xFFFE08},
    [I(93,115)] = {18,0x3FF88},
    [I(94,115)] = {19,0x7FF88},
    [I(95,115)] = {11,0x448},
    [I(96,115)] = {20,0xFFFA8},
    [I(97,115)] = {10,0x68},
    [I(98,115)] = {11,0x468},
    [I(99,115)] = {10,0x88},
    [I(100,115)] = {11,0x488},
    [I(101,115)] = {10,0xA8},
    [I(102,115)] = {11,0x4A8},
    [I(103,115)] = {11,0x4C8},
    [I(104,115)] = {11,0x4E8},
    [I(105,115)] = {10,0xC8},
    [I(106,115)] = {12,0xE88},
    [I(107,115)] = {12,0xEA8},
    [I(108,115)] = {11,0x508},
    [I(109,115)] = {11,0x528},
    [I(110,115)] = {11,0x548},
    [I(111,115)] = {10,0xE8},
    [I(112,115)] = {11,0x568},
    [I(113,115)] = {12,0xEC8},
    [I(114,115)] = {11,0x588},
    [I(115,115)] = {10,0x108},
    [I(116,115)] = {10,0x128},
    [I(117,115)] = {11,0x5A8},
    [I(118,115)] = {12,0xEE8},
    [I(119,115)] = {12,0xF08},
    [I(120,115)] = {12,0xF28},
    [I(121,115)] = {12,0xF48},
    [I(122,115)] = {12,0xF68},
    [I(123,115)] = {20,0xFFFC8},
    [I(124,115)] = {16,0xFF88},
    [I(125,115)] = {19,0x7FFA8},
    [I(126,115)] = {18,0x3FFA8},
    [I(127,115)] = {64,0},
    [I(128,115)] = {25,0x1FFFCC8},
    [I(129,115)] = {27,0x7FFFA48},
    [I(130,115)] = {25,0x1FFFCE8},
    [I(131,115)] = {25,0x1FFFD08},
    [I(132,115)] = {27,0x7FFFA68},
    [I(133,115)] = {27,0x7FFFA88},
    [I(134,115)] = {27,0x7FFFAA8},
    [I(135,115)] = {28,0xFFFFB28},
    [I(136,115)] = {27,0x7FFFAC8},
    [I(137,115)] = {28,0xFFFFB48},
    [I(138,115)] = {28,0xFFFFB68},
    [I(139,115)] = {28,0xFFFFB88},
    [I(140,115)] = {28,0xFFFFBA8},
    [I(141,115)] = {28,0xFFFFBC8},
    [I(142,115)] = {29,0x1FFFFD68},
    [I(143,115)] = {28,0xFFFFBE8},
    [I(144,115)] = {29,0x1FFFFD88},
    [I(145,115)] = {29,0x1FFFFDA8},
    [I(146,115)] = {27,0x7FFFAE8},
    [I(147,115)] = {28,0xFFFFC08},
    [I(148,115)] = {29,0x1FFFFDC8},
    [I(149,115)] = {28,0xFFFFC28},
    [I(150,115)] = {28,0xFFFFC48},
    [I(151,115)] = {28,0xFFFFC68},
    [I(152,115)] = {28,0xFFFFC88},
    [I(153,115)] = {26,0x3FFFB88},
    [I(154,115)] = {27,0x7FFFB08},
    [I(155,115)] = {28,0xFFFFCA8},
    [I(156,115)] = {27,0x7FFFB28},
    [I(157,115)] = {28,0xFFFFCC8},
    [I(158,115)] = {28,0xFFFFCE8},
    [I(159,115)] = {29,0x1FFFFDE8},
    [I(160,115)] = {27,0x7FFFB48},
    [I(161,115)] = {26,0x3FFFBA8},
    [I(162,115)] = {25,0x1FFFD28},
    [I(163,115)] = {27,0x7FFFB68},
    [I(164,115)] = {27,0x7FFFB88},
    [I(165,115)] = {28,0xFFFFD08},
    [I(166,115)] = {28,0xFFFFD28},
    [I(167,115)] = {26,0x3FFFBC8},
    [I(168,115)] = {28,0xFFFFD48},
    [I(169,115)] = {27,0x7FFFBA8},
    [I(170,115)] = {27,0x7FFFBC8},
    [I(171,115)] = {29,0x1FFFFE08},
    [I(172,115)] = {26,0x3FFFBE8},
    [I(173,115)] = {27,0x7FFFBE8},
    [I(174,115)] = {28,0xFFFFD68},
    [I(175,115)] = {28,0xFFFFD88},
    [I(176,115)] = {26,0x3FFFC08},
    [I(177,115)] = {26,0x3FFFC28},
    [I(178,115)] = {27,0x7FFFC08},
    [I(179,115)] = {26,0x3FFFC48},
    [I(180,115)] = {28,0xFFFFDA8},
    [I(181,115)] = {27,0x7FFFC28},
    [I(182,115)] = {28,0xFFFFDC8},
    [I(183,115)] = {28,0xFFFFDE8},
    [I(184,115)] = {25,0x1FFFD48},
    [I(185,115)] = {27,0x7FFFC48},
    [I(186,115)] = {27,0x7FFFC68},
    [I(187,115)] = {27,0x7FFFC88},
    [I(188,115)] = {28,0xFFFFE08},
    [I(189,115)] = {27,0x7FFFCA8},
    [I(190,115)] = {27,0x7FFFCC8},
    [I(191,115)] = {28,0xFFFFE28},
    [I(192,115)] = {31,0x7FFFFC08},
    [I(193,115)] = {31,0x7FFFFC28},
    [I(194,115)] = {25,0x1FFFD68},
    [I(195,115)] = {24,0xFFFE28},
    [I(196,115)] = {27,0x7FFFCE8},
    [I(197,115)] = {28,0xFFFFE48},
    [I(198,115)] = {27,0x7FFFD08},
    [I(199,115)] = {30,0x3FFFFD88},
    [I(200,115)] = {31,0x7FFFFC48},
    [I(201,115)] = {31,0x7FFFFC68},
    [I(202,115)] = {31,0x7FFFFC88},
    [I(203,115)] = {X32,0xFFFFFBC8},
    [I(204,115)] = {X32,0xFFFFFBE8},
    [I(205,115)] = {31,0x7FFFFCA8},
    [I(206,115)] = {29,0x1FFFFE28},
    [I(207,115)] = {30,0x3FFFFDA8},
    [I(208,115)] = {24,0xFFFE48},
    [I(209,115)] = {26,0x3FFFC68},
    [I(210,115)] = {31,0x7FFFFCC8},
    [I(211,115)] = {X32,0xFFFFFC08},
    [I(212,115)] = {X32,0xFFFFFC28},
    [I(213,115)] = {31,0x7FFFFCE8},
    [I(214,115)] = {X32,0xFFFFFC48},
    [I(215,115)] = {29,0x1FFFFE48},
    [I(216,115)] = {26,0x3FFFC88},
    [I(217,115)] = {26,0x3FFFCA8},
    [I(218,115)] = {31,0x7FFFFD08},
    [I(219,115)] = {31,0x7FFFFD28},
    [I(220,115)] = {64,0},
    [I(221,115)] = {X32,0xFFFFFC68},
    [I(222,115)] = {X32,0xFFFFFC88},
    [I(223,115)] = {X32,0xFFFFFCA8},
    [I(224,115)] = {25,0x1FFFD88},
    [I(225,115)] = {29,0x1FFFFE68},
    [I(226,115)] = {25,0x1FFFDA8},
    [I(227,115)] = {26,0x3FFFCC8},
    [I(228,115)] = {27,0x7FFFD28},
    [I(229,115)] = {26,0x3FFFCE8},
    [I(230,115)] = {26,0x3FFFD08},
    [I(231,115)] = {28,0xFFFFE68},
    [I(232,115)] = {27,0x7FFFD48},
    [I(233,115)] = {27,0x7FFFD68},
    [I(234,115)] = {30,0x3FFFFDC8},
    [I(235,115)] = {30,0x3FFFFDE8},
    [I(236,115)] = {29,0x1FFFFE88},
    [I(237,115)] = {29,0x1FFFFEA8},
    [I(238,115)] = {31,0x7FFFFD48},
    [I(239,115)] = {28,0xFFFFE88},
    [I(240,115)] = {31,0x7FFFFD68},
    [I(241,115)] = {X32,0xFFFFFCC8},
    [I(242,115)] = {31,0x7FFFFD88},
    [I(243,115)] = {31,0x7FFFFDA8},
    [I(244,115)] = {X32,0xFFFFFCE8},
    [I(245,115)] = {X32,0xFFFFFD08},
    [I(246,115)] = {X32,0xFFFFFD28},
    [I(247,115)] = {X32,0xFFFFFD48},
    [I(248,115)] = {X32,0xFFFFFD68},
    [I(249,115)] = {64,0},
    [I(250,115)] = {X32,0xFFFFFD88},
    [I(251,115)] = {X32,0xFFFFFDA8},
    [I(252,115)] = {X32,0xFFFFFDC8},
    [I(253,115)] = {X32,0xFFFFFDE8},
    [I(254,115)] = {X32,0xFFFFFE08},
    [I(255,115)] = {31,0x7FFFFDC8},
    [I(0,116)] = {18,0x3FF09},
    [I(1,116)] = {28,0xFFFFB09},
    [I(2,116)] = {64,0},
    [I(3,116)] = {64,0},
    [I(4,116)] = {64,0},
    [I(5,116)] = {64,0},
    [I(6,116)] = {64,0},
    [I(7,116)] = {64,0},
    [I(8,116)] = {64,0},
    [I(9,116)] = {29,0x1FFFFD49},
    [I(10,116)] = {64,0},
    [I(11,116)] = {64,0},
    [I(12,116)] = {64,0},
    [I(13,116)] = {64,0},
    [I(14,116)] = {64,0},
    [I(15,116)] = {64,0},
    [I(16,116)] = {64,0},
    [I(17,116)] = {64,0},
    [I(18,116)] = {64,0},
    [I(19,116)] = {64,0},
    [I(20,116)] = {64,0},
    [I(21,116)] = {64,0},
    [I(22,116)] = {64,0},
    [I(23,116)] = {64,0},
    [I(24,116)] = {64,0},
    [I(25,116)] = {64,0},
    [I(26,116)] = {64,0},
    [I(27,116)] = {64,0},
    [I(28,116)] = {64,0},
    [I(29,116)] = {64,0},
    [I(30,116)] = {64,0},
    [I(31,116)] = {64,0},
    [I(32,116)] = {11,0x289},
    [I(33,116)] = {15,0x7F09},
    [I(34,116)] = {15,0x7F29},
    [I(35,116)] = {17,0x1FF49},
    [I(36,116)] = {18,0x3FF29},
    [I(37,116)] = {11,0x2A9},
    [I(38,116)] = {13,0x1F09},
    [I(39,116)] = {16,0xFF49},
    [I(40,116)] = {15,0x7F49},
    [I(41,116)] = {15,0x7F69},
    [I(42,116)] = {13,0x1F29},
    [I(43,116)] = {16,0xFF69},
    [I(44,116)] = {13,0x1F49},
    [I(45,116)] = {11,0x2C9},
    [I(46,116)] = {11,0x2E9},
    [I(47,116)] = {11,0x309},
    [I(48,116)] = {10,0x9},
    [I(49,116)] = {10,0x29},
    [I(50,116)] = {10,0x49},
    [I(51,116)] = {11,0x329},
    [I(52,116)] = {11,0x349},
    [I(53,116)] = {11,0x369},
    [I(54,116)] = {11,0x389},
    [I(55,116)] = {11,0x3A9},
    [I(56,116)] = {11,0x3C9},
    [I(57,116)] = {11,0x3E9},
    [I(58,116)] = {12,0xB89},
    [I(59,116)] = {13,0x1F69},
    [I(60,116)] = {20,0xFFF89},
    [I(61,116)] = {11,0x409},
    [I(62,116)] = {17,0x1FF69},
    [I(63,116)] = {15,0x7F89},
    [I(64,116)] = {18,0x3FF49},
    [I(65,116)] = {11,0x429},
    [I(66,116)] = {12,0xBA9},
    [I(67,116)] = {12,0xBC9},
    [I(68,116)] = {12,0xBE9},
    [I(69,116)] = {12,0xC09},
    [I(70,116)] = {12,0xC29},
    [I(71,116)] = {12,0xC49},
    [I(72,116)] = {12,0xC69},
    [I(73,116)] = {12,0xC89},
    [I(74,116)] = {12,0xCA9},
    [I(75,116)] = {12,0xCC9},
    [I(76,116)] = {12,0xCE9},
    [I(77,116)] = {12,0xD09},
    [I(78,116)] = {12,0xD29},
    [I(79,116)] = {12,0xD49},
    [I(80,116)] = {12,0xD69},
    [I(81,116)] = {12,0xD89},
    [I(82,116)] = {12,0xDA9},
    [I(83,116)] = {12,0xDC9},
    [I(84,116)] = {12,0xDE9},
    [I(85,116)] = {12,0xE09},
    [I(86,116)] = {12,0xE29},
    [I(87,116)] = {12,0xE49},
    [I(88,116)] = {13,0x1F89},
    [I(89,116)] = {12,0xE69},
    [I(90,116)] = {13,0x1FA9},
    [I(91,116)] = {18,0x3FF69},
    [I(92,116)] = {24,0xFFFE09},
    [I(93,116)] = {18,0x3FF89},
    [I(94,116)] = {19,0x7FF89},
    [I(95,116)] = {11,0x449},
    [I(96,116)] = {20,0xFFFA9},
    [I(97,116)] = {10,0x69},
    [I(98,116)] = {11,0x469},
    [I(99,116)] = {10,0x89},
    [I(100,116)] = {11,0x489},
    [I(101,116)] = {10,0xA9},
    [I(102,116)] = {11,0x4A9},
    [I(103,116)] = {11,0x4C9},
    [I(104,116)] = {11,0x4E9},
    [I(105,116)] = {10,0xC9},
    [I(106,116)] = {12,0xE89},
    [I(107,116)] = {12,0xEA9},
    [I(108,116)] = {11,0x509},
    [I(109,116)] = {11,0x529},
    [I(110,116)] = {11,0x549},
    [I(111,116)] = {10,0xE9},
    [I(112,116)] = {11,0x569},
    [I(113,116)] = {12,0xEC9},
    [I(114,116)] = {11,0x589},
    [I(115,116)] = {10,0x109},
    [I(116,116)] = {10,0x129},
    [I(117,116)] = {11,0x5A9},
    [I(118,116)] = {12,0xEE9},
    [I(119,116)] = {12,0xF09},
    [I(120,116)] = {12,0xF29},
    [I(121,116)] = {12,0xF49},
    [I(122,116)] = {12,0xF69},
    [I(123,116)] = {20,0xFFFC9},
    [I(124,116)] = {16,0xFF89},
    [I(125,116)] = {19,0x7FFA9},
    [I(126,116)] = {18,0x3FFA9},
    [I(127,116)] = {64,0},
    [I(128,116)] = {25,0x1FFFCC9},
    [I(129,116)] = {27,0x7FFFA49},
    [I(130,116)] = {25,0x1FFFCE9},
    [I(131,116)] = {25,0x1FFFD09},
    [I(132,116)] = {27,0x7FFFA69},
    [I(133,116)] = {27,0x7FFFA89},
    [I(134,116)] = {27,0x7FFFAA9},
    [I(135,116)] = {28,0xFFFFB29},
    [I(136,116)] = {27,0x7FFFAC9},
    [I(137,116)] = {28,0xFFFFB49},
    [I(138,116)] = {28,0xFFFFB69},
    [I(139,116)] = {28,0xFFFFB89},
    [I(140,116)] = {28,0xFFFFBA9},
    [I(141,116)] = {28,0xFFFFBC9},
    [I(142,116)] = {29,0x1FFFFD69},
    [I(143,116)] = {28,0xFFFFBE9},
    [I(144,116)] = {29,0x1FFFFD89},
    [I(145,116)] = {29,0x1FFFFDA9},
    [I(146,116)] = {27,0x7FFFAE9},
    [I(147,116)] = {28,0xFFFFC09},
    [I(148,116)] = {29,0x1FFFFDC9},
    [I(149,116)] = {28,0xFFFFC29},
    [I(150,116)] = {28,0xFFFFC49},
    [I(151,116)] = {28,0xFFFFC69},
    [I(152,116)] = {28,0xFFFFC89},
    [I(153,116)] = {26,0x3FFFB89},
    [I(154,116)] = {27,0x7FFFB09},
    [I(155,116)] = {28,0xFFFFCA9},
    [I(156,116)] = {27,0x7FFFB29},
    [I(157,116)] = {28,0xFFFFCC9},
    [I(158,116)] = {28,0xFFFFCE9},
    [I(159,116)] = {29,0x1FFFFDE9},
    [I(160,116)] = {27,0x7FFFB49},
    [I(161,116)] = {26,0x3FFFBA9},
    [I(162,116)] = {25,0x1FFFD29},
    [I(163,116)] = {27,0x7FFFB69},
    [I(164,116)] = {27,0x7FFFB89},
    [I(165,116)] = {28,0xFFFFD09},
    [I(166,116)] = {28,0xFFFFD29},
    [I(167,116)] = {26,0x3FFFBC9},
    [I(168,116)] = {28,0xFFFFD49},
    [I(169,116)] = {27,0x7FFFBA9},
    [I(170,116)] = {27,0x7FFFBC9},
    [I(171,116)] = {29,0x1FFFFE09},
    [I(172,116)] = {26,0x3FFFBE9},
    [I(173,116)] = {27,0x7FFFBE9},
    [I(174,116)] = {28,0xFFFFD69},
    [I(175,116)] = {28,0xFFFFD89},
    [I(176,116)] = {26,0x3FFFC09},
    [I(177,116)] = {26,0x3FFFC29},
    [I(178,116)] = {27,0x7FFFC09},
    [I(179,116)] = {26,0x3FFFC49},
    [I(180,116)] = {28,0xFFFFDA9},
    [I(181,116)] = {27,0x7FFFC29},
    [I(182,116)] = {28,0xFFFFDC9},
    [I(183,116)] = {28,0xFFFFDE9},
    [I(184,116)] = {25,0x1FFFD49},
    [I(185,116)] = {27,0x7FFFC49},
    [I(186,116)] = {27,0x7FFFC69},
    [I(187,116)] = {27,0x7FFFC89},
    [I(188,116)] = {28,0xFFFFE09},
    [I(189,116)] = {27,0x7FFFCA9},
    [I(190,116)] = {27,0x7FFFCC9},
    [I(191,116)] = {28,0xFFFFE29},
    [I(192,116)] = {31,0x7FFFFC09},
    [I(193,116)] = {31,0x7FFFFC29},
    [I(194,116)] = {25,0x1FFFD69},
    [I(195,116)] = {24,0xFFFE29},
    [I(196,116)] = {27,0x7FFFCE9},
    [I(197,116)] = {28,0xFFFFE49},
    [I(198,116)] = {27,0x7FFFD09},
    [I(199,116)] = {30,0x3FFFFD89},
    [I(200,116)] = {31,0x7FFFFC49},
    [I(201,116)] = {31,0x7FFFFC69},
    [I(202,116)] = {31,0x7FFFFC89},
    [I(203,116)] = {X32,0xFFFFFBC9},
    [I(204,116)] = {X32,0xFFFFFBE9},
    [I(205,116)] = {31,0x7FFFFCA9},
    [I(206,116)] = {29,0x1FFFFE29},
    [I(207,116)] = {30,0x3FFFFDA9},
    [I(208,116)] = {24,0xFFFE49},
    [I(209,116)] = {26,0x3FFFC69},
    [I(210,116)] = {31,0x7FFFFCC9},
    [I(211,116)] = {X32,0xFFFFFC09},
    [I(212,116)] = {X32,0xFFFFFC29},
    [I(213,116)] = {31,0x7FFFFCE9},
    [I(214,116)] = {X32,0xFFFFFC49},
    [I(215,116)] = {29,0x1FFFFE49},
    [I(216,116)] = {26,0x3FFFC89},
    [I(217,116)] = {26,0x3FFFCA9},
    [I(218,116)] = {31,0x7FFFFD09},
    [I(219,116)] = {31,0x7FFFFD29},
    [I(220,116)] = {64,0},
    [I(221,116)] = {X32,0xFFFFFC69},
    [I(222,116)] = {X32,0xFFFFFC89},
    [I(223,116)] = {X32,0xFFFFFCA9},
    [I(224,116)] = {25,0x1FFFD89},
    [I(225,116)] = {29,0x1FFFFE69},
    [I(226,116)] = {25,0x1FFFDA9},
    [I(227,116)] = {26,0x3FFFCC9},
    [I(228,116)] = {27,0x7FFFD29},
    [I(229,116)] = {26,0x3FFFCE9},
    [I(230,116)] = {26,0x3FFFD09},
    [I(231,116)] = {28,0xFFFFE69},
    [I(232,116)] = {27,0x7FFFD49},
    [I(233,116)] = {27,0x7FFFD69},
    [I(234,116)] = {30,0x3FFFFDC9},
    [I(235,116)] = {30,0x3FFFFDE9},
    [I(236,116)] = {29,0x1FFFFE89},
    [I(237,116)] = {29,0x1FFFFEA9},
    [I(238,116)] = {31,0x7FFFFD49},
    [I(239,116)] = {28,0xFFFFE89},
    [I(240,116)] = {31,0x7FFFFD69},
    [I(241,116)] = {X32,0xFFFFFCC9},
    [I(242,116)] = {31,0x7FFFFD89},
    [I(243,116)] = {31,0x7FFFFDA9},
    [I(244,116)] = {X32,0xFFFFFCE9},
    [I(245,116)] = {X32,0xFFFFFD09},
    [I(246,116)] = {X32,0xFFFFFD29},
    [I(247,116)] = {X32,0xFFFFFD49},
    [I(248,116)] = {X32,0xFFFFFD69},
    [I(249,116)] = {64,0},
    [I(250,116)] = {X32,0xFFFFFD89},
    [I(251,116)] = {X32,0xFFFFFDA9},
    [I(252,116)] = {X32,0xFFFFFDC9},
    [I(253,116)] = {X32,0xFFFFFDE9},
    [I(254,116)] = {X32,0xFFFFFE09},
    [I(255,116)] = {31,0x7FFFFDC9},
    [I(0,117)] = {19,0x7FE2D},
    [I(1,117)] = {29,0x1FFFF62D},
    [I(2,117)] = {64,0},
    [I(3,117)] = {64,0},
    [I(4,117)] = {64,0},
    [I(5,117)] = {64,0},
    [I(6,117)] = {64,0},
    [I(7,117)] = {64,0},
    [I(8,117)] = {64,0},
    [I(9,117)] = {30,0x3FFFFAAD},
    [I(10,117)] = {64,0},
    [I(11,117)] = {64,0},
    [I(12,117)] = {64,0},
    [I(13,117)] = {64,0},
    [I(14,117)] = {64,0},
    [I(15,117)] = {64,0},
    [I(16,117)] = {64,0},
    [I(17,117)] = {64,0},
    [I(18,117)] = {64,0},
    [I(19,117)] = {64,0},
    [I(20,117)] = {64,0},
    [I(21,117)] = {64,0},
    [I(22,117)] = {64,0},
    [I(23,117)] = {64,0},
    [I(24,117)] = {64,0},
    [I(25,117)] = {64,0},
    [I(26,117)] = {64,0},
    [I(27,117)] = {64,0},
    [I(28,117)] = {64,0},
    [I(29,117)] = {64,0},
    [I(30,117)] = {64,0},
    [I(31,117)] = {64,0},
    [I(32,117)] = {12,0x52D},
    [I(33,117)] = {16,0xFE2D},
    [I(34,117)] = {16,0xFE6D},
    [I(35,117)] = {18,0x3FEAD},
    [I(36,117)] = {19,0x7FE6D},
    [I(37,117)] = {12,0x56D},
    [I(38,117)] = {14,0x3E2D},
    [I(39,117)] = {17,0x1FEAD},
    [I(40,117)] = {16,0xFEAD},
    [I(41,117)] = {16,0xFEED},
    [I(42,117)] = {14,0x3E6D},
    [I(43,117)] = {17,0x1FEED},
    [I(44,117)] = {14,0x3EAD},
    [I(45,117)] = {12,0x5AD},
    [I(46,117)] = {12,0x5ED},
    [I(47,117)] = {12,0x62D},
    [I(48,117)] = {11,0x2D},
    [I(49,117)] = {11,0x6D},
    [I(50,117)] = {11,0xAD},
    [I(51,117)] = {12,0x66D},
    [I(52,117)] = {12,0x6AD},
    [I(53,117)] = {12,0x6ED},
    [I(54,117)] = {12,0x72D},
    [I(55,117)] = {12,0x76D},
    [I(56,117)] = {12,0x7AD},
    [I(57,117)] = {12,0x7ED},
    [I(58,117)] = {13,0x172D},
    [I(59,117)] = {14,0x3EED},
    [I(60,117)] = {21,0x1FFF2D},
    [I(61,117)] = {12,0x82D},
    [I(62,117)] = {18,0x3FEED},
    [I(63,117)] = {16,0xFF2D},
    [I(64,117)] = {19,0x7FEAD},
    [I(65,117)] = {12,0x86D},
    [I(66,117)] = {13,0x176D},
    [I(67,117)] = {13,0x17AD},
    [I(68,117)] = {13,0x17ED},
    [I(69,117)] = {13,0x182D},
    [I(70,117)] = {13,0x186D},
    [I(71,117)] = {13,0x18AD},
    [I(72,117)] = {13,0x18ED},
    [I(73,117)] = {13,0x192D},
    [I(74,117)] = {13,0x196D},
    [I(75,117)] = {13,0x19AD},
    [I(76,117)] = {13,0x19ED},
    [I(77,117)] = {13,0x1A2D},
    [I(78,117)] = {13,0x1A6D},
    [I(79,117)] = {13,0x1AAD},
    [I(80,117)] = {13,0x1AED},
    [I(81,117)] = {13,0x1B2D},
    [I(82,117)] = {13,0x1B6D},
    [I(83,117)] = {13,0x1BAD},
    [I(84,117)] = {13,0x1BED},
    [I(85,117)] = {13,0x1C2D},
    [I(86,117)] = {13,0x1C6D},
    [I(87,117)] = {13,0x1CAD},
    [I(88,117)] = {14,0x3F2D},
    [I(89,117)] = {13,0x1CED},
    [I(90,117)] = {14,0x3F6D},
    [I(91,117)] = {19,0x7FEED},
    [I(92,117)] = {25,0x1FFFC2D},
    [I(93,117)] = {19,0x7FF2D},
    [I(94,117)] = {20,0xFFF2D},
    [I(95,117)] = {12,0x8AD},
    [I(96,117)] = {21,0x1FFF6D},
    [I(97,117)] = {11,0xED},
    [I(98,117)] = {12,0x8ED},
    [I(99,117)] = {11,0x12D},
    [I(100,117)] = {12,0x92D},
    [I(101,117)] = {11,0x16D},
    [I(102,117)] = {12,0x96D},
    [I(103,117)] = {12,0x9AD},
    [I(104,117)] = {12,0x9ED},
    [I(105,117)] = {11,0x1AD},
    [I(106,117)] = {13,0x1D2D},
    [I(107,117)] = {13,0x1D6D},
    [I(108,117)] = {12,0xA2D},
    [I(109,117)] = {12,0xA6D},
    [I(110,117)] = {12,0xAAD},
    [I(111,117)] = {11,0x1ED},
    [I(112,117)] = {12,0xAED},
    [I(113,117)] = {13,0x1DAD},
    [I(114,117)] = {12,0xB2D},
    [I(115,117)] = {11,0x22D},
    [I(116,117)] = {11,0x26D},
    [I(117,117)] = {12,0xB6D},
    [I(118,117)] = {13,0x1DED},
    [I(119,117)] = {13,0x1E2D},
    [I(120,117)] = {13,0x1E6D},
    [I(121,117)] = {13,0x1EAD},
    [I(122,117)] = {13,0x1EED},
    [I(123,117)] = {21,0x1FFFAD},
    [I(124,117)] = {17,0x1FF2D},
    [I(125,117)] = {20,0xFFF6D},
    [I(126,117)] = {19,0x7FF6D},
    [I(127,117)] = {64,0},
    [I(128,117)] = {26,0x3FFF9AD},
    [I(129,117)] = {28,0xFFFF4AD},
    [I(130,117)] = {26,0x3FFF9ED},
    [I(131,117)] = {26,0x3FFFA2D},
    [I(132,117)] = {28,0xFFFF4ED},
    [I(133,117)] = {28,0xFFFF52D},
    [I(134,117)] = {28,0xFFFF56D},
    [I(135,117)] = {29,0x1FFFF66D},
    [I(136,117)] = {28,0xFFFF5AD},
    [I(137,117)] = {29,0x1FFFF6AD},
    [I(138,117)] = {29,0x1FFFF6ED},
    [I(139,117)] = {29,0x1FFFF72D},
    [I(140,117)] = {29,0x1FFFF76D},
    [I(141,117)] = {29,0x1FFFF7AD},
    [I(142,117)] = {30,0x3FFFFAED},
    [I(143,117)] = {29,0x1FFFF7ED},
    [I(144,117)] = {30,0x3FFFFB2D},
    [I(145,117)] = {30,0x3FFFFB6D},
    [I(146,117)] = {28,0xFFFF5ED},
    [I(147,117)] = {29,0x1FFFF82D},
    [I(148,117)] = {30,0x3FFFFBAD},
    [I(149,117)] = {29,0x1FFFF86D},
    [I(150,117)] = {29,0x1FFFF8AD},
    [I(151,117)] = {29,0x1FFFF8ED},
    [I(152,117)] = {29,0x1FFFF92D},
    [I(153,117)] = {27,0x7FFF72D},
    [I(154,117)] = {28,0xFFFF62D},
    [I(155,117)] = {29,0x1FFFF96D},
    [I(156,117)] = {28,0xFFFF66D},
    [I(157,117)] = {29,0x1FFFF9AD},
    [I(158,117)] = {29,0x1FFFF9ED},
    [I(159,117)] = {30,0x3FFFFBED},
    [I(160,117)] = {28,0xFFFF6AD},
    [I(161,117)] = {27,0x7FFF76D},
    [I(162,117)] = {26,0x3FFFA6D},
    [I(163,117)] = {28,0xFFFF6ED},
    [I(164,117)] = {28,0xFFFF72D},
    [I(165,117)] = {29,0x1FFFFA2D},
    [I(166,117)] = {29,0x1FFFFA6D},
    [I(167,117)] = {27,0x7FFF7AD},
    [I(168,117)] = {29,0x1FFFFAAD},
    [I(169,117)] = {28,0xFFFF76D},
    [I(170,117)] = {28,0xFFFF7AD},
    [I(171,117)] = {30,0x3FFFFC2D},
    [I(172,117)] = {27,0x7FFF7ED},
    [I(173,117)] = {28,0xFFFF7ED},
    [I(174,117)] = {29,0x1FFFFAED},
    [I(175,117)] = {29,0x1FFFFB2D},
    [I(176,117)] = {27,0x7FFF82D},
    [I(177,117)] = {27,0x7FFF86D},
    [I(178,117)] = {28,0xFFFF82D},
    [I(179,117)] = {27,0x7FFF8AD},
    [I(180,117)] = {29,0x1FFFFB6D},
    [I(181,117)] = {28,0xFFFF86D},
    [I(182,117)] = {29,0x1FFFFBAD},
    [I(183,117)] = {29,0x1FFFFBED},
    [I(184,117)] = {26,0x3FFFAAD},
    [I(185,117)] = {28,0xFFFF8AD},
    [I(186,117)] = {28,0xFFFF8ED},
    [I(187,117)] = {28,0xFFFF92D},
    [I(188,117)] = {29,0x1FFFFC2D},
    [I(189,117)] = {28,0xFFFF96D},
    [I(190,117)] = {28,0xFFFF9AD},
    [I(191,117)] = {29,0x1FFFFC6D},
    [I(192,117)] = {X32,0xFFFFF82D},
    [I(193,117)] = {X32,0xFFFFF86D},
    [I(194,117)] = {26,0x3FFFAED},
    [I(195,117)] = {25,0x1FFFC6D},
    [I(196,117)] = {28,0xFFFF9ED},
    [I(197,117)] = {29,0x1FFFFCAD},
    [I(198,117)] = {28,0xFFFFA2D},
    [I(199,117)] = {31,0x7FFFFB2D},
    [I(200,117)] = {X32,0xFFFFF8AD},
    [I(201,117)] = {X32,0xFFFFF8ED},
    [I(202,117)] = {X32,0xFFFFF92D},
    [I(203,117)] = {64,0},
    [I(204,117)] = {64,0},
    [I(205,117)] = {X32,0xFFFFF96D},
    [I(206,117)] = {30,0x3FFFFC6D},
    [I(207,117)] = {31,0x7FFFFB6D},
    [I(208,117)] = {25,0x1FFFCAD},
    [I(209,117)] = {27,0x7FFF8ED},
    [I(210,117)] = {X32,0xFFFFF9AD},
    [I(211,117)] = {64,0},
    [I(212,117)] = {64,0},
    [I(213,117)] = {X32,0xFFFFF9ED},
    [I(214,117)] = {64,0},
    [I(215,117)] = {30,0x3FFFFCAD},
    [I(216,117)] = {27,0x7FFF92D},
    [I(217,117)] = {27,0x7FFF96D},
    [I(218,117)] = {X32,0xFFFFFA2D},
    [I(219,117)] = {X32,0xFFFFFA6D},
    [I(220,117)] = {64,0},
    [I(221,117)] = {64,0},
    [I(222,117)] = {64,0},
    [I(223,117)] = {64,0},
    [I(224,117)] = {26,0x3FFFB2D},
    [I(225,117)] = {30,0x3FFFFCED},
    [I(226,117)] = {26,0x3FFFB6D},
    [I(227,117)] = {27,0x7FFF9AD},
    [I(228,117)] = {28,0xFFFFA6D},
    [I(229,117)] = {27,0x7FFF9ED},
    [I(230,117)] = {27,0x7FFFA2D},
    [I(231,117)] = {29,0x1FFFFCED},
    [I(232,117)] = {28,0xFFFFAAD},
    [I(233,117)] = {28,0xFFFFAED},
    [I(234,117)] = {31,0x7FFFFBAD},
    [I(235,117)] = {31,0x7FFFFBED},
    [I(236,117)] = {30,0x3FFFFD2D},
    [I(237,117)] = {30,0x3FFFFD6D},
    [I(238,117)] = {X32,0xFFFFFAAD},
    [I(239,117)] = {29,0x1FFFFD2D},
    [I(240,117)] = {X32,0xFFFFFAED},
    [I(241,117)] = {64,0},
    [I(242,117)] = {X32,0xFFFFFB2D},
    [I(243,117)] = {X32,0xFFFFFB6D},
    [I(244,117)] = {64,0},
    [I(245,117)] = {64,0},
    [I(246,117)] = {64,0},
    [I(247,117)] = {64,0},
    [I(248,117)] = {64,0},
    [I(249,117)] = {64,0},
    [I(250,117)] = {64,0},
    [I(251,117)] = {64,0},
    [I(252,117)] = {64,0},
    [I(253,117)] = {64,0},
    [I(254,117)] = {64,0},
    [I(255,117)] = {X32,0xFFFFFBAD},
    [I(0,118)] = {20,0xFFC77},
    [I(1,118)] = {30,0x3FFFEC77},
    [I(2,118)] = {64,0},
    [I(3,118)] = {64,0},
    [I(4,118)] = {64,0},
    [I(5,118)] = {64,0},
    [I(6,118)] = {64,0},
    [I(7,118)] = {64,0},
    [I(8,118)] = {64,0},
    [I(9,118)] = {31,0x7FFFF577},
    [I(10,118)] = {64,0},
    [I(11,118)] = {64,0},
    [I(12,118)] = {64,0},
    [I(13,118)] = {64,0},
    [I(14,118)] = {64,0},
    [I(15,118)] = {64,0},
    [I(16,118)] = {64,0},
    [I(17,118)] = {64,0},
    [I(18,118)] = {64,0},
    [I(19,118)] = {64,0},
    [I(20,118)] = {64,0},
    [I(21,118)] = {64,0},
    [I(22,118)] = {64,0},
    [I(23,118)] = {64,0},
    [I(24,118)] = {64,0},
    [I(25,118)] = {64,0},
    [I(26,118)] = {64,0},
    [I(27,118)] = {64,0},
    [I(28,118)] = {64,0},
    [I(29,118)] = {64,0},
    [I(30,118)] = {64,0},
    [I(31,118)] = {64,0},
    [I(32,118)] = {13,0xA77},
    [I(33,118)] = {17,0x1FC77},
    [I(34,118)] = {17,0x1FCF7},
    [I(35,118)] = {19,0x7FD77},
    [I(36,118)] = {20,0xFFCF7},
    [I(37,118)] = {13,0xAF7},
    [I(38,118)] = {15,0x7C77},
    [I(39,118)] = {18,0x3FD77},
    [I(40,118)] = {17,0x1FD77},
    [I(41,118)] = {17,0x1FDF7},
    [I(42,118)] = {15,0x7CF7},
    [I(43,118)] = {18,0x3FDF7},
    [I(44,118)] = {15,0x7D77},
    [I(45,118)] = {13,0xB77},
    [I(46,118)] = {13,0xBF7},
    [I(47,118)] = {13,0xC77},
    [I(48,118)] = {12,0x77},
    [I(49,118)] = {12,0xF7},
    [I(50,118)] = {12,0x177},
    [I(51,118)] = {13,0xCF7},
    [I(52,118)] = {13,0xD77},
    [I(53,118)] = {13,0xDF7},
    [I(54,118)] = {13,0xE77},
    [I(55,118)] = {13,0xEF7},
    [I(56,118)] = {13,0xF77},
    [I(57,118)] = {13,0xFF7},
    [I(58,118)] = {14,0x2E77},
    [I(59,118)] = {15,0x7DF7},
    [I(60,118)] = {22,0x3FFE77},
    [I(61,118)] = {13,0x1077},
    [I(62,118)] = {19,0x7FDF7},
    [I(63,118)] = {17,0x1FE77},
    [I(64,118)] = {20,0xFFD77},
    [I(65,118)] = {13,0x10F7},
    [I(66,118)] = {14,0x2EF7},
    [I(67,118)] = {14,0x2F77},
    [I(68,118)] = {14,0x2FF7},
    [I(69,118)] = {14,0x3077},
    [I(70,118)] = {14,0x30F7},
    [I(71,118)] = {14,0x3177},
    [I(72,118)] = {14,0x31F7},
    [I(73,118)] = {14,0x3277},
    [I(74,118)] = {14,0x32F7},
    [I(75,118)] = {14,0x3377},
    [I(76,118)] = {14,0x33F7},
    [I(77,118)] = {14,0x3477},
    [I(78,118)] = {14,0x34F7},
    [I(79,118)] = {14,0x3577},
    [I(80,118)] = {14,0x35F7},
    [I(81,118)] = {14,0x3677},
    [I(82,118)] = {14,0x36F7},
    [I(83,118)] = {14,0x3777},
    [I(84,118)] = {14,0x37F7},
    [I(85,118)] = {14,0x3877},
    [I(86,118)] = {14,0x38F7},
    [I(87,118)] = {14,0x3977},
    [I(88,118)] = {15,0x7E77},
    [I(89,118)] = {14,0x39F7},
    [I(90,118)] = {15,0x7EF7},
    [I(91,118)] = {20,0xFFDF7},
    [I(92,118)] = {26,0x3FFF877},
    [I(93,118)] = {20,0xFFE77},
    [I(94,118)] = {21,0x1FFE77},
    [I(95,118)] = {13,0x1177},
    [I(96,118)] = {22,0x3FFEF7},
    [I(97,118)] = {12,0x1F7},
    [I(98,118)] = {13,0x11F7},
    [I(99,118)] = {12,0x277},
    [I(100,118)] = {13,0x1277},
    [I(101,118)] = {12,0x2F7},
    [I(102,118)] = {13,0x12F7},
    [I(103,118)] = {13,0x1377},
    [I(104,118)] = {13,0x13F7},
    [I(105,118)] = {12,0x377},
    [I(106,118)] = {14,0x3A77},
    [I(107,118)] = {14,0x3AF7},
    [I(108,118)] = {13,0x1477},
    [I(109,118)] = {13,0x14F7},
    [I(110,118)] = {13,0x1577},
    [I(111,118)] = {12,0x3F7},
    [I(112,118)] = {13,0x15F7},
    [I(113,118)] = {14,0x3B77},
    [I(114,118)] = {13,0x1677},
    [I(115,118)] = {12,0x477},
    [I(116,118)] = {12,0x4F7},
    [I(117,118)] = {13,0x16F7},
    [I(118,118)] = {14,0x3BF7},
    [I(119,118)] = {14,0x3C77},
    [I(120,118)] = {14,0x3CF7},
    [I(121,118)] = {14,0x3D77},
    [I(122,118)] = {14,0x3DF7},
    [I(123,118)] = {22,0x3FFF77},
    [I(124,118)] = {18,0x3FE77},
    [I(125,118)] = {21,0x1FFEF7},
    [I(126,118)] = {20,0xFFEF7},
    [I(127,118)] = {64,0},
    [I(128,118)] = {27,0x7FFF377},
    [I(129,118)] = {29,0x1FFFE977},
    [I(130,118)] = {27,0x7FFF3F7},
    [I(131,118)] = {27,0x7FFF477},
    [I(132,118)] = {29,0x1FFFE9F7},
    [I(133,118)] = {29,0x1FFFEA77},
    [I(134,118)] = {29,0x1FFFEAF7},
    [I(135,118)] = {30,0x3FFFECF7},
    [I(136,118)] = {29,0x1FFFEB77},
    [I(137,118)] = {30,0x3FFFED77},
    [I(138,118)] = {30,0x3FFFEDF7},
    [I(139,118)] = {30,0x3FFFEE77},
    [I(140,118)] = {30,0x3FFFEEF7},
    [I(141,118)] = {30,0x3FFFEF77},
    [I(142,118)] = {31,0x7FFFF5F7},
    [I(143,118)] = {30,0x3FFFEFF7},
    [I(144,118)] = {31,0x7FFFF677},
    [I(145,118)] = {31,0x7FFFF6F7},
    [I(146,118)] = {29,0x1FFFEBF7},
    [I(147,118)] = {30,0x3FFFF077},
    [I(148,118)] = {31,0x7FFFF777},
    [I(149,118)] = {30,0x3FFFF0F7},
    [I(150,118)] = {30,0x3FFFF177},
    [I(151,118)] = {30,0x3FFFF1F7},
    [I(152,118)] = {30,0x3FFFF277},
    [I(153,118)] = {28,0xFFFEE77},
    [I(154,118)] = {29,0x1FFFEC77},
    [I(155,118)] = {30,0x3FFFF2F7},
    [I(156,118)] = {29,0x1FFFECF7},
    [I(157,118)] = {30,0x3FFFF377},
    [I(158,118)] = {30,0x3FFFF3F7},
    [I(159,118)] = {31,0x7FFFF7F7},
    [I(160,118)] = {29,0x1FFFED77},
    [I(161,118)] = {28,0xFFFEEF7},
    [I(162,118)] = {27,0x7FFF4F7},
    [I(163,118)] = {29,0x1FFFEDF7},
    [I(164,118)] = {29,0x1FFFEE77},
    [I(165,118)] = {30,0x3FFFF477},
    [I(166,118)] = {30,0x3FFFF4F7},
    [I(167,118)] = {28,0xFFFEF77},
    [I(168,118)] = {30,0x3FFFF577},
    [I(169,118)] = {29,0x1FFFEEF7},
    [I(170,118)] = {29,0x1FFFEF77},
    [I(171,118)] = {31,0x7FFFF877},
    [I(172,118)] = {28,0xFFFEFF7},
    [I(173,118)] = {29,0x1FFFEFF7},
    [I(174,118)] = {30,0x3FFFF5F7},
    [I(175,118)] = {30,0x3FFFF677},
    [I(176,118)] = {28,0xFFFF077},
    [I(177,118)] = {28,0xFFFF0F7},
    [I(178,118)] = {29,0x1FFFF077},
    [I(179,118)] = {28,0xFFFF177},
    [I(180,118)] = {30,0x3FFFF6F7},
    [I(181,118)] = {29,0x1FFFF0F7},
    [I(182,118)] = {30,0x3FFFF777},
    [I(183,118)] = {30,0x3FFFF7F7},
    [I(184,118)] = {27,0x7FFF577},
    [I(185,118)] = {29,0x1FFFF177},
    [I(186,118)] = {29,0x1FFFF1F7},
    [I(187,118)] = {29,0x1FFFF277},
    [I(188,118)] = {30,0x3FFFF877},
    [I(189,118)] = {29,0x1FFFF2F7},
    [I(190,118)] = {29,0x1FFFF377},
    [I(191,118)] = {30,0x3FFFF8F7},
    [I(192,118)] = {64,0},
    [I(193,118)] = {64,0},
    [I(194,118)] = {27,0x7FFF5F7},
    [I(195,118)] = {26,0x3FFF8F7},
    [I(196,118)] = {29,0x1FFFF3F7},
    [I(197,118)] = {30,0x3FFFF977},
    [I(198,118)] = {29,0x1FFFF477},
    [I(199,118)] = {X32,0xFFFFF677},
    [I(200,118)] = {64,0},
    [I(201,118)] = {64,0},
    [I(202,118)] = {64,0},
    [I(203,118)] = {64,0},
    [I(204,118)] = {64,0},
    [I(205,118)] = {64,0},
    [I(206,118)] = {31,0x7FFFF8F7},
    [I(207,118)] = {X32,0xFFFFF6F7},
    [I(208,118)] = {26,0x3FFF977},
    [I(209,118)] = {28,0xFFFF1F7},
    [I(210,118)] = {64,0},
    [I(211,118)] = {64,0},
    [I(212,118)] = {64,0},
    [I(213,118)] = {64,0},
    [I(214,118)] = {64,0},
    [I(215,118)] = {31,0x7FFFF977},
    [I(216,118)] = {28,0xFFFF277},
    [I(217,118)] = {28,0xFFFF2F7},
    [I(218,118)] = {64,0},
    [I(219,118)] = {64,0},
    [I(220,118)] = {64,0},
    [I(221,118)] = {64,0},
    [I(222,118)] = {64,0},
    [I(223,118)] = {64,0},
    [I(224,118)] = {27,0x7FFF677},
    [I(225,118)] = {31,0x7FFFF9F7},
    [I(226,118)] = {27,0x7FFF6F7},
    [I(227,118)] = {28,0xFFFF377},
    [I(228,118)] = {29,0x1FFFF4F7},
    [I(229,118)] = {28,0xFFFF3F7},
    [I(230,118)] = {28,0xFFFF477},
    [I(231,118)] = {30,0x3FFFF9F7},
    [I(232,118)] = {29,0x1FFFF577},
    [I(233,118)] = {29,0x1FFFF5F7},
    [I(234,118)] = {X32,0xFFFFF777},
    [I(235,118)] = {X32,0xFFFFF7F7},
    [I(236,118)] = {31,0x7FFFFA77},
    [I(237,118)] = {31,0x7FFFFAF7},
    [I(238,118)] = {64,0},
    [I(239,118)] = {30,0x3FFFFA77},
    [I(240,118)] = {64,0},
    [I(241,118)] = {64,0},
    [I(242,118)] = {64,0},
    [I(243,118)] = {64,0},
    [I(244,118)] = {64,0},
    [I(245,118)] = {64,0},
    [I(246,118)] = {64,0},
    [I(247,118)] = {64,0},
    [I(248,118)] = {64,0},
    [I(249,118)] = {64,0},
    [I(250,118)] = {64,0},
    [I(251,118)] = {64,0},
    [I(252,118)] = {64,0},
    [I(253,118)] = {64,0},
    [I(254,118)] = {64,0},
    [I(255,118)] = {64,0},
    [I(0,119)] = {20,0xFFC78},
    [I(1,119)] = {30,0x3FFFEC78},
    [I(2,119)] = {64,0},
    [I(3,119)] = {64,0},
    [I(4,119)] = {64,0},
    [I(5,119)] = {64,0},
    [I(6,119)] = {64,0},
    [I(7,119)] = {64,0},
    [I(8,119)] = {64,0},
    [I(9,119)] = {31,0x7FFFF578},
    [I(10,119)] = {64,0},
    [I(11,119)] = {64,0},
    [I(12,119)] = {64,0},
    [I(13,119)] = {64,0},
    [I(14,119)] = {64,0},
    [I(15,119)] = {64,0},
    [I(16,119)] = {64,0},
    [I(17,119)] = {64,0},
    [I(18,119)] = {64,0},
    [I(19,119)] = {64,0},
    [I(20,119)] = {64,0},
    [I(21,119)] = {64,0},
    [I(22,119)] = {64,0},
    [I(23,119)] = {64,0},
    [I(24,119)] = {64,0},
    [I(25,119)] = {64,0},
    [I(26,119)] = {64,0},
    [I(27,119)] = {64,0},
    [I(28,119)] = {64,0},
    [I(29,119)] = {64,0},
    [I(30,119)] = {64,0},
    [I(31,119)] = {64,0},
    [I(32,119)] = {13,0xA78},
    [I(33,119)] = {17,0x1FC78},
    [I(34,119)] = {17,0x1FCF8},
    [I(35,119)] = {19,0x7FD78},
    [I(36,119)] = {20,0xFFCF8},
    [I(37,119)] = {13,0xAF8},
    [I(38,119)] = {15,0x7C78},
    [I(39,119)] = {18,0x3FD78},
    [I(40,119)] = {17,0x1FD78},
    [I(41,119)] = {17,0x1FDF8},
    [I(42,119)] = {15,0x7CF8},
    [I(43,119)] = {18,0x3FDF8},
    [I(44,119)] = {15,0x7D78},
    [I(45,119)] = {13,0xB78},
    [I(46,119)] = {13,0xBF8},
    [I(47,119)] = {13,0xC78},
    [I(48,119)] = {12,0x78},
    [I(49,119)] = {12,0xF8},
    [I(50,119)] = {12,0x178},
    [I(51,119)] = {13,0xCF8},
    [I(52,119)] = {13,0xD78},
    [I(53,119)] = {13,0xDF8},
    [I(54,119)] = {13,0xE78},
    [I(55,119)] = {13,0xEF8},
    [I(56,119)] = {13,0xF78},
    [I(57,119)] = {13,0xFF8},
    [I(58,119)] = {14,0x2E78},
    [I(59,119)] = {15,0x7DF8},
    [I(60,119)] = {22,0x3FFE78},
    [I(61,119)] = {13,0x1078},
    [I(62,119)] = {19,0x7FDF8},
    [I(63,119)] = {17,0x1FE78},
    [I(64,119)] = {20,0xFFD78},
    [I(65,119)] = {13,0x10F8},
    [I(66,119)] = {14,0x2EF8},
    [I(67,119)] = {14,0x2F78},
    [I(68,119)] = {14,0x2FF8},
    [I(69,119)] = {14,0x3078},
    [I(70,119)] = {14,0x30F8},
    [I(71,119)] = {14,0x3178},
    [I(72,119)] = {14,0x31F8},
    [I(73,119)] = {14,0x3278},
    [I(74,119)] = {14,0x32F8},
    [I(75,119)] = {14,0x3378},
    [I(76,119)] = {14,0x33F8},
    [I(77,119)] = {14,0x3478},
    [I(78,119)] = {14,0x34F8},
    [I(79,119)] = {14,0x3578},
    [I(80,119)] = {14,0x35F8},
    [I(81,119)] = {14,0x3678},
    [I(82,119)] = {14,0x36F8},
    [I(83,119)] = {14,0x3778},
    [I(84,119)] = {14,0x37F8},
    [I(85,119)] = {14,0x3878},
    [I(86,119)] = {14,0x38F8},
    [I(87,119)] = {14,0x3978},
    [I(88,119)] = {15,0x7E78},
    [I(89,119)] = {14,0x39F8},
    [I(90,119)] = {15,0x7EF8},
    [I(91,119)] = {20,0xFFDF8},
    [I(92,119)] = {26,0x3FFF878},
    [I(93,119)] = {20,0xFFE78},
    [I(94,119)] = {21,0x1FFE78},
    [I(95,119)] = {13,0x1178},
    [I(96,119)] = {22,0x3FFEF8},
    [I(97,119)] = {12,0x1F8},
    [I(98,119)] = {13,0x11F8},
    [I(99,119)] = {12,0x278},
    [I(100,119)] = {13,0x1278},
    [I(101,119)] = {12,0x2F8},
    [I(102,119)] = {13,0x12F8},
    [I(103,119)] = {13,0x1378},
    [I(104,119)] = {13,0x13F8},
    [I(105,119)] = {12,0x378},
    [I(106,119)] = {14,0x3A78},
    [I(107,119)] = {14,0x3AF8},
    [I(108,119)] = {13,0x1478},
    [I(109,119)] = {13,0x14F8},
    [I(110,119)] = {13,0x1578},
    [I(111,119)] = {12,0x3F8},
    [I(112,119)] = {13,0x15F8},
    [I(113,119)] = {14,0x3B78},
    [I(114,119)] = {13,0x1678},
    [I(115,119)] = {12,0x478},
    [I(116,119)] = {12,0x4F8},
    [I(117,119)] = {13,0x16F8},
    [I(118,119)] = {14,0x3BF8},
    [I(119,119)] = {14,0x3C78},
    [I(120,119)] = {14,0x3CF8},
    [I(121,119)] = {14,0x3D78},
    [I(122,119)] = {14,0x3DF8},
    [I(123,119)] = {22,0x3FFF78},
    [I(124,119)] = {18,0x3FE78},
    [I(125,119)] = {21,0x1FFEF8},
    [I(126,119)] = {20,0xFFEF8},
    [I(127,119)] = {64,0},
    [I(128,119)] = {27,0x7FFF378},
    [I(129,119)] = {29,0x1FFFE978},
    [I(130,119)] = {27,0x7FFF3F8},
    [I(131,119)] = {27,0x7FFF478},
    [I(132,119)] = {29,0x1FFFE9F8},
    [I(133,119)] = {29,0x1FFFEA78},
    [I(134,119)] = {29,0x1FFFEAF8},
    [I(135,119)] = {30,0x3FFFECF8},
    [I(136,119)] = {29,0x1FFFEB78},
    [I(137,119)] = {30,0x3FFFED78},
    [I(138,119)] = {30,0x3FFFEDF8},
    [I(139,119)] = {30,0x3FFFEE78},
    [I(140,119)] = {30,0x3FFFEEF8},
    [I(141,119)] = {30,0x3FFFEF78},
    [I(142,119)] = {31,0x7FFFF5F8},
    [I(143,119)] = {30,0x3FFFEFF8},
    [I(144,119)] = {31,0x7FFFF678},
    [I(145,119)] = {31,0x7FFFF6F8},
    [I(146,119)] = {29,0x1FFFEBF8},
    [I(147,119)] = {30,0x3FFFF078},
    [I(148,119)] = {31,0x7FFFF778},
    [I(149,119)] = {30,0x3FFFF0F8},
    [I(150,119)] = {30,0x3FFFF178},
    [I(151,119)] = {30,0x3FFFF1F8},
    [I(152,119)] = {30,0x3FFFF278},
    [I(153,119)] = {28,0xFFFEE78},
    [I(154,119)] = {29,0x1FFFEC78},
    [I(155,119)] = {30,0x3FFFF2F8},
    [I(156,119)] = {29,0x1FFFECF8},
    [I(157,119)] = {30,0x3FFFF378},
    [I(158,119)] = {30,0x3FFFF3F8},
    [I(159,119)] = {31,0x7FFFF7F8},
    [I(160,119)] = {29,0x1FFFED78},
    [I(161,119)] = {28,0xFFFEEF8},
    [I(162,119)] = {27,0x7FFF4F8},
    [I(163,119)] = {29,0x1FFFEDF8},
    [I(164,119)] = {29,0x1FFFEE78},
    [I(165,119)] = {30,0x3FFFF478},
    [I(166,119)] = {30,0x3FFFF4F8},
    [I(167,119)] = {28,0xFFFEF78},
    [I(168,119)] = {30,0x3FFFF578},
    [I(169,119)] = {29,0x1FFFEEF8},
    [I(170,119)] = {29,0x1FFFEF78},
    [I(171,119)] = {31,0x7FFFF878},
    [I(172,119)] = {28,0xFFFEFF8},
    [I(173,119)] = {29,0x1FFFEFF8},
    [I(174,119)] = {30,0x3FFFF5F8},
    [I(175,119)] = {30,0x3FFFF678},
    [I(176,119)] = {28,0xFFFF078},
    [I(177,119)] = {28,0xFFFF0F8},
    [I(178,119)] = {29,0x1FFFF078},
    [I(179,119)] = {28,0xFFFF178},
    [I(180,119)] = {30,0x3FFFF6F8},
    [I(181,119)] = {29,0x1FFFF0F8},
    [I(182,119)] = {30,0x3FFFF778},
    [I(183,119)] = {30,0x3FFFF7F8},
    [I(184,119)] = {27,0x7FFF578},
    [I(185,119)] = {29,0x1FFFF178},
    [I(186,119)] = {29,0x1FFFF1F8},
    [I(187,119)] = {29,0x1FFFF278},
    [I(188,119)] = {30,0x3FFFF878},
    [I(189,119)] = {29,0x1FFFF2F8},
    [I(190,119)] = {29,0x1FFFF378},
    [I(191,119)] = {30,0x3FFFF8F8},
    [I(192,119)] = {64,0},
    [I(193,119)] = {64,0},
    [I(194,119)] = {27,0x7FFF5F8},
    [I(195,119)] = {26,0x3FFF8F8},
    [I(196,119)] = {29,0x1FFFF3F8},
    [I(197,119)] = {30,0x3FFFF978},
    [I(198,119)] = {29,0x1FFFF478},
    [I(199,119)] = {X32,0xFFFFF678},
    [I(200,119)] = {64,0},
    [I(201,119)] = {64,0},
    [I(202,119)] = {64,0},
    [I(203,119)] = {64,0},
    [I(204,119)] = {64,0},
    [I(205,119)] = {64,0},
    [I(206,119)] = {31,0x7FFFF8F8},
    [I(207,119)] = {X32,0xFFFFF6F8},
    [I(208,119)] = {26,0x3FFF978},
    [I(209,119)] = {28,0xFFFF1F8},
    [I(210,119)] = {64,0},
    [I(211,119)] = {64,0},
    [I(212,119)] = {64,0},
    [I(213,119)] = {64,0},
    [I(214,119)] = {64,0},
    [I(215,119)] = {31,0x7FFFF978},
    [I(216,119)] = {28,0xFFFF278},
    [I(217,119)] = {28,0xFFFF2F8},
    [I(218,119)] = {64,0},
    [I(219,119)] = {64,0},
    [I(220,119)] = {64,0},
    [I(221,119)] = {64,0},
    [I(222,119)] = {64,0},
    [I(223,119)] = {64,0},
    [I(224,119)] = {27,0x7FFF678},
    [I(225,119)] = {31,0x7FFFF9F8},
    [I(226,119)] = {27,0x7FFF6F8},
    [I(227,119)] = {28,0xFFFF378},
    [I(228,119)] = {29,0x1FFFF4F8},
    [I(229,119)] = {28,0xFFFF3F8},
    [I(230,119)] = {28,0xFFFF478},
    [I(231,119)] = {30,0x3FFFF9F8},
    [I(232,119)] = {29,0x1FFFF578},
    [I(233,119)] = {29,0x1FFFF5F8},
    [I(234,119)] = {X32,0xFFFFF778},
    [I(235,119)] = {X32,0xFFFFF7F8},
    [I(236,119)] = {31,0x7FFFFA78},
    [I(237,119)] = {31,0x7FFFFAF8},
    [I(238,119)] = {64,0},
    [I(239,119)] = {30,0x3FFFFA78},
    [I(240,119)] = {64,0},
    [I(241,119)] = {64,0},
    [I(242,119)] = {64,0},
    [I(243,119)] = {64,0},
    [I(244,119)] = {64,0},
    [I(245,119)] = {64,0},
    [I(246,119)] = {64,0},
    [I(247,119)] = {64,0},
    [I(248,119)] = {64,0},
    [I(249,119)] = {64,0},
    [I(250,119)] = {64,0},
    [I(251,119)] = {64,0},
    [I(252,119)] = {64,0},
    [I(253,119)] = {64,0},
    [I(254,119)] = {64,0},
    [I(255,119)] = {64,0},
    [I(0,120)] = {20,0xFFC79},
    [I(1,120)] = {30,0x3FFFEC79},
    [I(2,120)] = {64,0},
    [I(3,120)] = {64,0},
    [I(4,120)] = {64,0},
    [I(5,120)] = {64,0},
    [I(6,120)] = {64,0},
    [I(7,120)] = {64,0},
    [I(8,120)] = {64,0},
    [I(9,120)] = {31,0x7FFFF579},
    [I(10,120)] = {64,0},
    [I(11,120)] = {64,0},
    [I(12,120)] = {64,0},
    [I(13,120)] = {64,0},
    [I(14,120)] = {64,0},
    [I(15,120)] = {64,0},
    [I(16,120)] = {64,0},
    [I(17,120)] = {64,0},
    [I(18,120)] = {64,0},
    [I(19,120)] = {64,0},
    [I(20,120)] = {64,0},
    [I(21,120)] = {64,0},
    [I(22,120)] = {64,0},
    [I(23,120)] = {64,0},
    [I(24,120)] = {64,0},
    [I(25,120)] = {64,0},
    [I(26,120)] = {64,0},
    [I(27,120)] = {64,0},
    [I(28,120)] = {64,0},
    [I(29,120)] = {64,0},
    [I(30,120)] = {64,0},
    [I(31,120)] = {64,0},
    [I(32,120)] = {13,0xA79},
    [I(33,120)] = {17,0x1FC79},
    [I(34,120)] = {17,0x1FCF9},
    [I(35,120)] = {19,0x7FD79},
    [I(36,120)] = {20,0xFFCF9},
    [I(37,120)] = {13,0xAF9},
    [I(38,120)] = {15,0x7C79},
    [I(39,120)] = {18,0x3FD79},
    [I(40,120)] = {17,0x1FD79},
    [I(41,120)] = {17,0x1FDF9},
    [I(42,120)] = {15,0x7CF9},
    [I(43,120)] = {18,0x3FDF9},
    [I(44,120)] = {15,0x7D79},
    [I(45,120)] = {13,0xB79},
    [I(46,120)] = {13,0xBF9},
    [I(47,120)] = {13,0xC79},
    [I(48,120)] = {12,0x79},
    [I(49,120)] = {12,0xF9},
    [I(50,120)] = {12,0x179},
    [I(51,120)] = {13,0xCF9},
    [I(52,120)] = {13,0xD79},
    [I(53,120)] = {13,0xDF9},
    [I(54,120)] = {13,0xE79},
    [I(55,120)] = {13,0xEF9},
    [I(56,120)] = {13,0xF79},
    [I(57,120)] = {13,0xFF9},
    [I(58,120)] = {14,0x2E79},
    [I(59,120)] = {15,0x7DF9},
    [I(60,120)] = {22,0x3FFE79},
    [I(61,120)] = {13,0x1079},
    [I(62,120)] = {19,0x7FDF9},
    [I(63,120)] = {17,0x1FE79},
    [I(64,120)] = {20,0xFFD79},
    [I(65,120)] = {13,0x10F9},
    [I(66,120)] = {14,0x2EF9},
    [I(67,120)] = {14,0x2F79},
    [I(68,120)] = {14,0x2FF9},
    [I(69,120)] = {14,0x3079},
    [I(70,120)] = {14,0x30F9},
    [I(71,120)] = {14,0x3179},
    [I(72,120)] = {14,0x31F9},
    [I(73,120)] = {14,0x3279},
    [I(74,120)] = {14,0x32F9},
    [I(75,120)] = {14,0x3379},
    [I(76,120)] = {14,0x33F9},
    [I(77,120)] = {14,0x3479},
    [I(78,120)] = {14,0x34F9},
    [I(79,120)] = {14,0x3579},
    [I(80,120)] = {14,0x35F9},
    [I(81,120)] = {14,0x3679},
    [I(82,120)] = {14,0x36F9},
    [I(83,120)] = {14,0x3779},
    [I(84,120)] = {14,0x37F9},
    [I(85,120)] = {14,0x3879},
    [I(86,120)] = {14,0x38F9},
    [I(87,120)] = {14,0x3979},
    [I(88,120)] = {15,0x7E79},
    [I(89,120)] = {14,0x39F9},
    [I(90,120)] = {15,0x7EF9},
    [I(91,120)] = {20,0xFFDF9},
    [I(92,120)] = {26,0x3FFF879},
    [I(93,120)] = {20,0xFFE79},
    [I(94,120)] = {21,0x1FFE79},
    [I(95,120)] = {13,0x1179},
    [I(96,120)] = {22,0x3FFEF9},
    [I(97,120)] = {12,0x1F9},
    [I(98,120)] = {13,0x11F9},
    [I(99,120)] = {12,0x279},
    [I(100,120)] = {13,0x1279},
    [I(101,120)] = {12,0x2F9},
    [I(102,120)] = {13,0x12F9},
    [I(103,120)] = {13,0x1379},
    [I(104,120)] = {13,0x13F9},
    [I(105,120)] = {12,0x379},
    [I(106,120)] = {14,0x3A79},
    [I(107,120)] = {14,0x3AF9},
    [I(108,120)] = {13,0x1479},
    [I(109,120)] = {13,0x14F9},
    [I(110,120)] = {13,0x1579},
    [I(111,120)] = {12,0x3F9},
    [I(112,120)] = {13,0x15F9},
    [I(113,120)] = {14,0x3B79},
    [I(114,120)] = {13,0x1679},
    [I(115,120)] = {12,0x479},
    [I(116,120)] = {12,0x4F9},
    [I(117,120)] = {13,0x16F9},
    [I(118,120)] = {14,0x3BF9},
    [I(119,120)] = {14,0x3C79},
    [I(120,120)] = {14,0x3CF9},
    [I(121,120)] = {14,0x3D79},
    [I(122,120)] = {14,0x3DF9},
    [I(123,120)] = {22,0x3FFF79},
    [I(124,120)] = {18,0x3FE79},
    [I(125,120)] = {21,0x1FFEF9},
    [I(126,120)] = {20,0xFFEF9},
    [I(127,120)] = {64,0},
    [I(128,120)] = {27,0x7FFF379},
    [I(129,120)] = {29,0x1FFFE979},
    [I(130,120)] = {27,0x7FFF3F9},
    [I(131,120)] = {27,0x7FFF479},
    [I(132,120)] = {29,0x1FFFE9F9},
    [I(133,120)] = {29,0x1FFFEA79},
    [I(134,120)] = {29,0x1FFFEAF9},
    [I(135,120)] = {30,0x3FFFECF9},
    [I(136,120)] = {29,0x1FFFEB79},
    [I(137,120)] = {30,0x3FFFED79},
    [I(138,120)] = {30,0x3FFFEDF9},
    [I(139,120)] = {30,0x3FFFEE79},
    [I(140,120)] = {30,0x3FFFEEF9},
    [I(141,120)] = {30,0x3FFFEF79},
    [I(142,120)] = {31,0x7FFFF5F9},
    [I(143,120)] = {30,0x3FFFEFF9},
    [I(144,120)] = {31,0x7FFFF679},
    [I(145,120)] = {31,0x7FFFF6F9},
    [I(146,120)] = {29,0x1FFFEBF9},
    [I(147,120)] = {30,0x3FFFF079},
    [I(148,120)] = {31,0x7FFFF779},
    [I(149,120)] = {30,0x3FFFF0F9},
    [I(150,120)] = {30,0x3FFFF179},
    [I(151,120)] = {30,0x3FFFF1F9},
    [I(152,120)] = {30,0x3FFFF279},
    [I(153,120)] = {28,0xFFFEE79},
    [I(154,120)] = {29,0x1FFFEC79},
    [I(155,120)] = {30,0x3FFFF2F9},
    [I(156,120)] = {29,0x1FFFECF9},
    [I(157,120)] = {30,0x3FFFF379},
    [I(158,120)] = {30,0x3FFFF3F9},
    [I(159,120)] = {31,0x7FFFF7F9},
    [I(160,120)] = {29,0x1FFFED79},
    [I(161,120)] = {28,0xFFFEEF9},
    [I(162,120)] = {27,0x7FFF4F9},
    [I(163,120)] = {29,0x1FFFEDF9},
    [I(164,120)] = {29,0x1FFFEE79},
    [I(165,120)] = {30,0x3FFFF479},
    [I(166,120)] = {30,0x3FFFF4F9},
    [I(167,120)] = {28,0xFFFEF79},
    [I(168,120)] = {30,0x3FFFF579},
    [I(169,120)] = {29,0x1FFFEEF9},
    [I(170,120)] = {29,0x1FFFEF79},
    [I(171,120)] = {31,0x7FFFF879},
    [I(172,120)] = {28,0xFFFEFF9},
    [I(173,120)] = {29,0x1FFFEFF9},
    [I(174,120)] = {30,0x3FFFF5F9},
    [I(175,120)] = {30,0x3FFFF679},
    [I(176,120)] = {28,0xFFFF079},
    [I(177,120)] = {28,0xFFFF0F9},
    [I(178,120)] = {29,0x1FFFF079},
    [I(179,120)] = {28,0xFFFF179},
    [I(180,120)] = {30,0x3FFFF6F9},
    [I(181,120)] = {29,0x1FFFF0F9},
    [I(182,120)] = {30,0x3FFFF779},
    [I(183,120)] = {30,0x3FFFF7F9},
    [I(184,120)] = {27,0x7FFF579},
    [I(185,120)] = {29,0x1FFFF179},
    [I(186,120)] = {29,0x1FFFF1F9},
    [I(187,120)] = {29,0x1FFFF279},
    [I(188,120)] = {30,0x3FFFF879},
    [I(189,120)] = {29,0x1FFFF2F9},
    [I(190,120)] = {29,0x1FFFF379},
    [I(191,120)] = {30,0x3FFFF8F9},
    [I(192,120)] = {64,0},
    [I(193,120)] = {64,0},
    [I(194,120)] = {27,0x7FFF5F9},
    [I(195,120)] = {26,0x3FFF8F9},
    [I(196,120)] = {29,0x1FFFF3F9},
    [I(197,120)] = {30,0x3FFFF979},
    [I(198,120)] = {29,0x1FFFF479},
    [I(199,120)] = {X32,0xFFFFF679},
    [I(200,120)] = {64,0},
    [I(201,120)] = {64,0},
    [I(202,120)] = {64,0},
    [I(203,120)] = {64,0},
    [I(204,120)] = {64,0},
    [I(205,120)] = {64,0},
    [I(206,120)] = {31,0x7FFFF8F9},
    [I(207,120)] = {X32,0xFFFFF6F9},
    [I(208,120)] = {26,0x3FFF979},
    [I(209,120)] = {28,0xFFFF1F9},
    [I(210,120)] = {64,0},
    [I(211,120)] = {64,0},
    [I(212,120)] = {64,0},
    [I(213,120)] = {64,0},
    [I(214,120)] = {64,0},
    [I(215,120)] = {31,0x7FFFF979},
    [I(216,120)] = {28,0xFFFF279},
    [I(217,120)] = {28,0xFFFF2F9},
    [I(218,120)] = {64,0},
    [I(219,120)] = {64,0},
    [I(220,120)] = {64,0},
    [I(221,120)] = {64,0},
    [I(222,120)] = {64,0},
    [I(223,120)] = {64,0},
    [I(224,120)] = {27,0x7FFF679},
    [I(225,120)] = {31,0x7FFFF9F9},
    [I(226,120)] = {27,0x7FFF6F9},
    [I(227,120)] = {28,0xFFFF379},
    [I(228,120)] = {29,0x1FFFF4F9},
    [I(229,120)] = {28,0xFFFF3F9},
    [I(230,120)] = {28,0xFFFF479},
    [I(231,120)] = {30,0x3FFFF9F9},
    [I(232,120)] = {29,0x1FFFF579},
    [I(233,120)] = {29,0x1FFFF5F9},
    [I(234,120)] = {X32,0xFFFFF779},
    [I(235,120)] = {X32,0xFFFFF7F9},
    [I(236,120)] = {31,0x7FFFFA79},
    [I(237,120)] = {31,0x7FFFFAF9},
    [I(238,120)] = {64,0},
    [I(239,120)] = {30,0x3FFFFA79},
    [I(240,120)] = {64,0},
    [I(241,120)] = {64,0},
    [I(242,120)] = {64,0},
    [I(243,120)] = {64,0},
    [I(244,120)] = {64,0},
    [I(245,120)] = {64,0},
    [I(246,120)] = {64,0},
    [I(247,120)] = {64,0},
    [I(248,120)] = {64,0},
    [I(249,120)] = {64,0},
    [I(250,120)] = {64,0},
    [I(251,120)] = {64,0},
    [I(252,120)] = {64,0},
    [I(253,120)] = {64,0},
    [I(254,120)] = {64,0},
    [I(255,120)] = {64,0},
    [I(0,121)] = {20,0xFFC7A},
    [I(1,121)] = {30,0x3FFFEC7A},
    [I(2,121)] = {64,0},
    [I(3,121)] = {64,0},
    [I(4,121)] = {64,0},
    [I(5,121)] = {64,0},
    [I(6,121)] = {64,0},
    [I(7,121)] = {64,0},
    [I(8,121)] = {64,0},
    [I(9,121)] = {31,0x7FFFF57A},
    [I(10,121)] = {64,0},
    [I(11,121)] = {64,0},
    [I(12,121)] = {64,0},
    [I(13,121)] = {64,0},
    [I(14,121)] = {64,0},
    [I(15,121)] = {64,0},
    [I(16,121)] = {64,0},
    [I(17,121)] = {64,0},
    [I(18,121)] = {64,0},
    [I(19,121)] = {64,0},
    [I(20,121)] = {64,0},
    [I(21,121)] = {64,0},
    [I(22,121)] = {64,0},
    [I(23,121)] = {64,0},
    [I(24,121)] = {64,0},
    [I(25,121)] = {64,0},
    [I(26,121)] = {64,0},
    [I(27,121)] = {64,0},
    [I(28,121)] = {64,0},
    [I(29,121)] = {64,0},
    [I(30,121)] = {64,0},
    [I(31,121)] = {64,0},
    [I(32,121)] = {13,0xA7A},
    [I(33,121)] = {17,0x1FC7A},
    [I(34,121)] = {17,0x1FCFA},
    [I(35,121)] = {19,0x7FD7A},
    [I(36,121)] = {20,0xFFCFA},
    [I(37,121)] = {13,0xAFA},
    [I(38,121)] = {15,0x7C7A},
    [I(39,121)] = {18,0x3FD7A},
    [I(40,121)] = {17,0x1FD7A},
    [I(41,121)] = {17,0x1FDFA},
    [I(42,121)] = {15,0x7CFA},
    [I(43,121)] = {18,0x3FDFA},
    [I(44,121)] = {15,0x7D7A},
    [I(45,121)] = {13,0xB7A},
    [I(46,121)] = {13,0xBFA},
    [I(47,121)] = {13,0xC7A},
    [I(48,121)] = {12,0x7A},
    [I(49,121)] = {12,0xFA},
    [I(50,121)] = {12,0x17A},
    [I(51,121)] = {13,0xCFA},
    [I(52,121)] = {13,0xD7A},
    [I(53,121)] = {13,0xDFA},
    [I(54,121)] = {13,0xE7A},
    [I(55,121)] = {13,0xEFA},
    [I(56,121)] = {13,0xF7A},
    [I(57,121)] = {13,0xFFA},
    [I(58,121)] = {14,0x2E7A},
    [I(59,121)] = {15,0x7DFA},
    [I(60,121)] = {22,0x3FFE7A},
    [I(61,121)] = {13,0x107A},
    [I(62,121)] = {19,0x7FDFA},
    [I(63,121)] = {17,0x1FE7A},
    [I(64,121)] = {20,0xFFD7A},
    [I(65,121)] = {13,0x10FA},
    [I(66,121)] = {14,0x2EFA},
    [I(67,121)] = {14,0x2F7A},
    [I(68,121)] = {14,0x2FFA},
    [I(69,121)] = {14,0x307A},
    [I(70,121)] = {14,0x30FA},
    [I(71,121)] = {14,0x317A},
    [I(72,121)] = {14,0x31FA},
    [I(73,121)] = {14,0x327A},
    [I(74,121)] = {14,0x32FA},
    [I(75,121)] = {14,0x337A},
    [I(76,121)] = {14,0x33FA},
    [I(77,121)] = {14,0x347A},
    [I(78,121)] = {14,0x34FA},
    [I(79,121)] = {14,0x357A},
    [I(80,121)] = {14,0x35FA},
    [I(81,121)] = {14,0x367A},
    [I(82,121)] = {14,0x36FA},
    [I(83,121)] = {14,0x377A},
    [I(84,121)] = {14,0x37FA},
    [I(85,121)] = {14,0x387A},
    [I(86,121)] = {14,0x38FA},
    [I(87,121)] = {14,0x397A},
    [I(88,121)] = {15,0x7E7A},
    [I(89,121)] = {14,0x39FA},
    [I(90,121)] = {15,0x7EFA},
    [I(91,121)] = {20,0xFFDFA},
    [I(92,121)] = {26,0x3FFF87A},
    [I(93,121)] = {20,0xFFE7A},
    [I(94,121)] = {21,0x1FFE7A},
    [I(95,121)] = {13,0x117A},
    [I(96,121)] = {22,0x3FFEFA},
    [I(97,121)] = {12,0x1FA},
    [I(98,121)] = {13,0x11FA},
    [I(99,121)] = {12,0x27A},
    [I(100,121)] = {13,0x127A},
    [I(101,121)] = {12,0x2FA},
    [I(102,121)] = {13,0x12FA},
    [I(103,121)] = {13,0x137A},
    [I(104,121)] = {13,0x13FA},
    [I(105,121)] = {12,0x37A},
    [I(106,121)] = {14,0x3A7A},
    [I(107,121)] = {14,0x3AFA},
    [I(108,121)] = {13,0x147A},
    [I(109,121)] = {13,0x14FA},
    [I(110,121)] = {13,0x157A},
    [I(111,121)] = {12,0x3FA},
    [I(112,121)] = {13,0x15FA},
    [I(113,121)] = {14,0x3B7A},
    [I(114,121)] = {13,0x167A},
    [I(115,121)] = {12,0x47A},
    [I(116,121)] = {12,0x4FA},
    [I(117,121)] = {13,0x16FA},
    [I(118,121)] = {14,0x3BFA},
    [I(119,121)] = {14,0x3C7A},
    [I(120,121)] = {14,0x3CFA},
    [I(121,121)] = {14,0x3D7A},
    [I(122,121)] = {14,0x3DFA},
    [I(123,121)] = {22,0x3FFF7A},
    [I(124,121)] = {18,0x3FE7A},
    [I(125,121)] = {21,0x1FFEFA},
    [I(126,121)] = {20,0xFFEFA},
    [I(127,121)] = {64,0},
    [I(128,121)] = {27,0x7FFF37A},
    [I(129,121)] = {29,0x1FFFE97A},
    [I(130,121)] = {27,0x7FFF3FA},
    [I(131,121)] = {27,0x7FFF47A},
    [I(132,121)] = {29,0x1FFFE9FA},
    [I(133,121)] = {29,0x1FFFEA7A},
    [I(134,121)] = {29,0x1FFFEAFA},
    [I(135,121)] = {30,0x3FFFECFA},
    [I(136,121)] = {29,0x1FFFEB7A},
    [I(137,121)] = {30,0x3FFFED7A},
    [I(138,121)] = {30,0x3FFFEDFA},
    [I(139,121)] = {30,0x3FFFEE7A},
    [I(140,121)] = {30,0x3FFFEEFA},
    [I(141,121)] = {30,0x3FFFEF7A},
    [I(142,121)] = {31,0x7FFFF5FA},
    [I(143,121)] = {30,0x3FFFEFFA},
    [I(144,121)] = {31,0x7FFFF67A},
    [I(145,121)] = {31,0x7FFFF6FA},
    [I(146,121)] = {29,0x1FFFEBFA},
    [I(147,121)] = {30,0x3FFFF07A},
    [I(148,121)] = {31,0x7FFFF77A},
    [I(149,121)] = {30,0x3FFFF0FA},
    [I(150,121)] = {30,0x3FFFF17A},
    [I(151,121)] = {30,0x3FFFF1FA},
    [I(152,121)] = {30,0x3FFFF27A},
    [I(153,121)] = {28,0xFFFEE7A},
    [I(154,121)] = {29,0x1FFFEC7A},
    [I(155,121)] = {30,0x3FFFF2FA},
    [I(156,121)] = {29,0x1FFFECFA},
    [I(157,121)] = {30,0x3FFFF37A},
    [I(158,121)] = {30,0x3FFFF3FA},
    [I(159,121)] = {31,0x7FFFF7FA},
    [I(160,121)] = {29,0x1FFFED7A},
    [I(161,121)] = {28,0xFFFEEFA},
    [I(162,121)] = {27,0x7FFF4FA},
    [I(163,121)] = {29,0x1FFFEDFA},
    [I(164,121)] = {29,0x1FFFEE7A},
    [I(165,121)] = {30,0x3FFFF47A},
    [I(166,121)] = {30,0x3FFFF4FA},
    [I(167,121)] = {28,0xFFFEF7A},
    [I(168,121)] = {30,0x3FFFF57A},
    [I(169,121)] = {29,0x1FFFEEFA},
    [I(170,121)] = {29,0x1FFFEF7A},
    [I(171,121)] = {31,0x7FFFF87A},
    [I(172,121)] = {28,0xFFFEFFA},
    [I(173,121)] = {29,0x1FFFEFFA},
    [I(174,121)] = {30,0x3FFFF5FA},
    [I(175,121)] = {30,0x3FFFF67A},
    [I(176,121)] = {28,0xFFFF07A},
    [I(177,121)] = {28,0xFFFF0FA},
    [I(178,121)] = {29,0x1FFFF07A},
    [I(179,121)] = {28,0xFFFF17A},
    [I(180,121)] = {30,0x3FFFF6FA},
    [I(181,121)] = {29,0x1FFFF0FA},
    [I(182,121)] = {30,0x3FFFF77A},
    [I(183,121)] = {30,0x3FFFF7FA},
    [I(184,121)] = {27,0x7FFF57A},
    [I(185,121)] = {29,0x1FFFF17A},
    [I(186,121)] = {29,0x1FFFF1FA},
    [I(187,121)] = {29,0x1FFFF27A},
    [I(188,121)] = {30,0x3FFFF87A},
    [I(189,121)] = {29,0x1FFFF2FA},
    [I(190,121)] = {29,0x1FFFF37A},
    [I(191,121)] = {30,0x3FFFF8FA},
    [I(192,121)] = {64,0},
    [I(193,121)] = {64,0},
    [I(194,121)] = {27,0x7FFF5FA},
    [I(195,121)] = {26,0x3FFF8FA},
    [I(196,121)] = {29,0x1FFFF3FA},
    [I(197,121)] = {30,0x3FFFF97A},
    [I(198,121)] = {29,0x1FFFF47A},
    [I(199,121)] = {X32,0xFFFFF67A},
    [I(200,121)] = {64,0},
    [I(201,121)] = {64,0},
    [I(202,121)] = {64,0},
    [I(203,121)] = {64,0},
    [I(204,121)] = {64,0},
    [I(205,121)] = {64,0},
    [I(206,121)] = {31,0x7FFFF8FA},
    [I(207,121)] = {X32,0xFFFFF6FA},
    [I(208,121)] = {26,0x3FFF97A},
    [I(209,121)] = {28,0xFFFF1FA},
    [I(210,121)] = {64,0},
    [I(211,121)] = {64,0},
    [I(212,121)] = {64,0},
    [I(213,121)] = {64,0},
    [I(214,121)] = {64,0},
    [I(215,121)] = {31,0x7FFFF97A},
    [I(216,121)] = {28,0xFFFF27A},
    [I(217,121)] = {28,0xFFFF2FA},
    [I(218,121)] = {64,0},
    [I(219,121)] = {64,0},
    [I(220,121)] = {64,0},
    [I(221,121)] = {64,0},
    [I(222,121)] = {64,0},
    [I(223,121)] = {64,0},
    [I(224,121)] = {27,0x7FFF67A},
    [I(225,121)] = {31,0x7FFFF9FA},
    [I(226,121)] = {27,0x7FFF6FA},
    [I(227,121)] = {28,0xFFFF37A},
    [I(228,121)] = {29,0x1FFFF4FA},
    [I(229,121)] = {28,0xFFFF3FA},
    [I(230,121)] = {28,0xFFFF47A},
    [I(231,121)] = {30,0x3FFFF9FA},
    [I(232,121)] = {29,0x1FFFF57A},
    [I(233,121)] = {29,0x1FFFF5FA},
    [I(234,121)] = {X32,0xFFFFF77A},
    [I(235,121)] = {X32,0xFFFFF7FA},
    [I(236,121)] = {31,0x7FFFFA7A},
    [I(237,121)] = {31,0x7FFFFAFA},
    [I(238,121)] = {64,0},
    [I(239,121)] = {30,0x3FFFFA7A},
    [I(240,121)] = {64,0},
    [I(241,121)] = {64,0},
    [I(242,121)] = {64,0},
    [I(243,121)] = {64,0},
    [I(244,121)] = {64,0},
    [I(245,121)] = {64,0},
    [I(246,121)] = {64,0},
    [I(247,121)] = {64,0},
    [I(248,121)] = {64,0},
    [I(249,121)] = {64,0},
    [I(250,121)] = {64,0},
    [I(251,121)] = {64,0},
    [I(252,121)] = {64,0},
    [I(253,121)] = {64,0},
    [I(254,121)] = {64,0},
    [I(255,121)] = {64,0},
    [I(0,122)] = {20,0xFFC7B},
    [I(1,122)] = {30,0x3FFFEC7B},
    [I(2,122)] = {64,0},
    [I(3,122)] = {64,0},
    [I(4,122)] = {64,0},
    [I(5,122)] = {64,0},
    [I(6,122)] = {64,0},
    [I(7,122)] = {64,0},
    [I(8,122)] = {64,0},
    [I(9,122)] = {31,0x7FFFF57B},
    [I(10,122)] = {64,0},
    [I(11,122)] = {64,0},
    [I(12,122)] = {64,0},
    [I(13,122)] = {64,0},
    [I(14,122)] = {64,0},
    [I(15,122)] = {64,0},
    [I(16,122)] = {64,0},
    [I(17,122)] = {64,0},
    [I(18,122)] = {64,0},
    [I(19,122)] = {64,0},
    [I(20,122)] = {64,0},
    [I(21,122)] = {64,0},
    [I(22,122)] = {64,0},
    [I(23,122)] = {64,0},
    [I(24,122)] = {64,0},
    [I(25,122)] = {64,0},
    [I(26,122)] = {64,0},
    [I(27,122)] = {64,0},
    [I(28,122)] = {64,0},
    [I(29,122)] = {64,0},
    [I(30,122)] = {64,0},
    [I(31,122)] = {64,0},
    [I(32,122)] = {13,0xA7B},
    [I(33,122)] = {17,0x1FC7B},
    [I(34,122)] = {17,0x1FCFB},
    [I(35,122)] = {19,0x7FD7B},
    [I(36,122)] = {20,0xFFCFB},
    [I(37,122)] = {13,0xAFB},
    [I(38,122)] = {15,0x7C7B},
    [I(39,122)] = {18,0x3FD7B},
    [I(40,122)] = {17,0x1FD7B},
    [I(41,122)] = {17,0x1FDFB},
    [I(42,122)] = {15,0x7CFB},
    [I(43,122)] = {18,0x3FDFB},
    [I(44,122)] = {15,0x7D7B},
    [I(45,122)] = {13,0xB7B},
    [I(46,122)] = {13,0xBFB},
    [I(47,122)] = {13,0xC7B},
    [I(48,122)] = {12,0x7B},
    [I(49,122)] = {12,0xFB},
    [I(50,122)] = {12,0x17B},
    [I(51,122)] = {13,0xCFB},
    [I(52,122)] = {13,0xD7B},
    [I(53,122)] = {13,0xDFB},
    [I(54,122)] = {13,0xE7B},
    [I(55,122)] = {13,0xEFB},
    [I(56,122)] = {13,0xF7B},
    [I(57,122)] = {13,0xFFB},
    [I(58,122)] = {14,0x2E7B},
    [I(59,122)] = {15,0x7DFB},
    [I(60,122)] = {22,0x3FFE7B},
    [I(61,122)] = {13,0x107B},
    [I(62,122)] = {19,0x7FDFB},
    [I(63,122)] = {17,0x1FE7B},
    [I(64,122)] = {20,0xFFD7B},
    [I(65,122)] = {13,0x10FB},
    [I(66,122)] = {14,0x2EFB},
    [I(67,122)] = {14,0x2F7B},
    [I(68,122)] = {14,0x2FFB},
    [I(69,122)] = {14,0x307B},
    [I(70,122)] = {14,0x30FB},
    [I(71,122)] = {14,0x317B},
    [I(72,122)] = {14,0x31FB},
    [I(73,122)] = {14,0x327B},
    [I(74,122)] = {14,0x32FB},
    [I(75,122)] = {14,0x337B},
    [I(76,122)] = {14,0x33FB},
    [I(77,122)] = {14,0x347B},
    [I(78,122)] = {14,0x34FB},
    [I(79,122)] = {14,0x357B},
    [I(80,122)] = {14,0x35FB},
    [I(81,122)] = {14,0x367B},
    [I(82,122)] = {14,0x36FB},
    [I(83,122)] = {14,0x377B},
    [I(84,122)] = {14,0x37FB},
    [I(85,122)] = {14,0x387B},
    [I(86,122)] = {14,0x38FB},
    [I(87,122)] = {14,0x397B},
    [I(88,122)] = {15,0x7E7B},
    [I(89,122)] = {14,0x39FB},
    [I(90,122)] = {15,0x7EFB},
    [I(91,122)] = {20,0xFFDFB},
    [I(92,122)] = {26,0x3FFF87B},
    [I(93,122)] = {20,0xFFE7B},
    [I(94,122)] = {21,0x1FFE7B},
    [I(95,122)] = {13,0x117B},
    [I(96,122)] = {22,0x3FFEFB},
    [I(97,122)] = {12,0x1FB},
    [I(98,122)] = {13,0x11FB},
    [I(99,122)] = {12,0x27B},
    [I(100,122)] = {13,0x127B},
    [I(101,122)] = {12,0x2FB},
    [I(102,122)] = {13,0x12FB},
    [I(103,122)] = {13,0x137B},
    [I(104,122)] = {13,0x13FB},
    [I(105,122)] = {12,0x37B},
    [I(106,122)] = {14,0x3A7B},
    [I(107,122)] = {14,0x3AFB},
    [I(108,122)] = {13,0x147B},
    [I(109,122)] = {13,0x14FB},
    [I(110,122)] = {13,0x157B},
    [I(111,122)] = {12,0x3FB},
    [I(112,122)] = {13,0x15FB},
    [I(113,122)] = {14,0x3B7B},
    [I(114,122)] = {13,0x167B},
    [I(115,122)] = {12,0x47B},
    [I(116,122)] = {12,0x4FB},
    [I(117,122)] = {13,0x16FB},
    [I(118,122)] = {14,0x3BFB},
    [I(119,122)] = {14,0x3C7B},
    [I(120,122)] = {14,0x3CFB},
    [I(121,122)] = {14,0x3D7B},
    [I(122,122)] = {14,0x3DFB},
    [I(123,122)] = {22,0x3FFF7B},
    [I(124,122)] = {18,0x3FE7B},
    [I(125,122)] = {21,0x1FFEFB},
    [I(126,122)] = {20,0xFFEFB},
    [I(127,122)] = {64,0},
    [I(128,122)] = {27,0x7FFF37B},
    [I(129,122)] = {29,0x1FFFE97B},
    [I(130,122)] = {27,0x7FFF3FB},
    [I(131,122)] = {27,0x7FFF47B},
    [I(132,122)] = {29,0x1FFFE9FB},
    [I(133,122)] = {29,0x1FFFEA7B},
    [I(134,122)] = {29,0x1FFFEAFB},
    [I(135,122)] = {30,0x3FFFECFB},
    [I(136,122)] = {29,0x1FFFEB7B},
    [I(137,122)] = {30,0x3FFFED7B},
    [I(138,122)] = {30,0x3FFFEDFB},
    [I(139,122)] = {30,0x3FFFEE7B},
    [I(140,122)] = {30,0x3FFFEEFB},
    [I(141,122)] = {30,0x3FFFEF7B},
    [I(142,122)] = {31,0x7FFFF5FB},
    [I(143,122)] = {30,0x3FFFEFFB},
    [I(144,122)] = {31,0x7FFFF67B},
    [I(145,122)] = {31,0x7FFFF6FB},
    [I(146,122)] = {29,0x1FFFEBFB},
    [I(147,122)] = {30,0x3FFFF07B},
    [I(148,122)] = {31,0x7FFFF77B},
    [I(149,122)] = {30,0x3FFFF0FB},
    [I(150,122)] = {30,0x3FFFF17B},
    [I(151,122)] = {30,0x3FFFF1FB},
    [I(152,122)] = {30,0x3FFFF27B},
    [I(153,122)] = {28,0xFFFEE7B},
    [I(154,122)] = {29,0x1FFFEC7B},
    [I(155,122)] = {30,0x3FFFF2FB},
    [I(156,122)] = {29,0x1FFFECFB},
    [I(157,122)] = {30,0x3FFFF37B},
    [I(158,122)] = {30,0x3FFFF3FB},
    [I(159,122)] = {31,0x7FFFF7FB},
    [I(160,122)] = {29,0x1FFFED7B},
    [I(161,122)] = {28,0xFFFEEFB},
    [I(162,122)] = {27,0x7FFF4FB},
    [I(163,122)] = {29,0x1FFFEDFB},
    [I(164,122)] = {29,0x1FFFEE7B},
    [I(165,122)] = {30,0x3FFFF47B},
    [I(166,122)] = {30,0x3FFFF4FB},
    [I(167,122)] = {28,0xFFFEF7B},
    [I(168,122)] = {30,0x3FFFF57B},
    [I(169,122)] = {29,0x1FFFEEFB},
    [I(170,122)] = {29,0x1FFFEF7B},
    [I(171,122)] = {31,0x7FFFF87B},
    [I(172,122)] = {28,0xFFFEFFB},
    [I(173,122)] = {29,0x1FFFEFFB},
    [I(174,122)] = {30,0x3FFFF5FB},
    [I(175,122)] = {30,0x3FFFF67B},
    [I(176,122)] = {28,0xFFFF07B},
    [I(177,122)] = {28,0xFFFF0FB},
    [I(178,122)] = {29,0x1FFFF07B},
    [I(179,122)] = {28,0xFFFF17B},
    [I(180,122)] = {30,0x3FFFF6FB},
    [I(181,122)] = {29,0x1FFFF0FB},
    [I(182,122)] = {30,0x3FFFF77B},
    [I(183,122)] = {30,0x3FFFF7FB},
    [I(184,122)] = {27,0x7FFF57B},
    [I(185,122)] = {29,0x1FFFF17B},
    [I(186,122)] = {29,0x1FFFF1FB},
    [I(187,122)] = {29,0x1FFFF27B},
    [I(188,122)] = {30,0x3FFFF87B},
    [I(189,122)] = {29,0x1FFFF2FB},
    [I(190,122)] = {29,0x1FFFF37B},
    [I(191,122)] = {30,0x3FFFF8FB},
    [I(192,122)] = {64,0},
    [I(193,122)] = {64,0},
    [I(194,122)] = {27,0x7FFF5FB},
    [I(195,122)] = {26,0x3FFF8FB},
    [I(196,122)] = {29,0x1FFFF3FB},
    [I(197,122)] = {30,0x3FFFF97B},
    [I(198,122)] = {29,0x1FFFF47B},
    [I(199,122)] = {X32,0xFFFFF67B},
    [I(200,122)] = {64,0},
    [I(201,122)] = {64,0},
    [I(202,122)] = {64,0},
    [I(203,122)] = {64,0},
    [I(204,122)] = {64,0},
    [I(205,122)] = {64,0},
    [I(206,122)] = {31,0x7FFFF8FB},
    [I(207,122)] = {X32,0xFFFFF6FB},
    [I(208,122)] = {26,0x3FFF97B},
    [I(209,122)] = {28,0xFFFF1FB},
    [I(210,122)] = {64,0},
    [I(211,122)] = {64,0},
    [I(212,122)] = {64,0},
    [I(213,122)] = {64,0},
    [I(214,122)] = {64,0},
    [I(215,122)] = {31,0x7FFFF97B},
    [I(216,122)] = {28,0xFFFF27B},
    [I(217,122)] = {28,0xFFFF2FB},
    [I(218,122)] = {64,0},
    [I(219,122)] = {64,0},
    [I(220,122)] = {64,0},
    [I(221,122)] = {64,0},
    [I(222,122)] = {64,0},
    [I(223,122)] = {64,0},
    [I(224,122)] = {27,0x7FFF67B},
    [I(225,122)] = {31,0x7FFFF9FB},
    [I(226,122)] = {27,0x7FFF6FB},
    [I(227,122)] = {28,0xFFFF37B},
    [I(228,122)] = {29,0x1FFFF4FB},
    [I(229,122)] = {28,0xFFFF3FB},
    [I(230,122)] = {28,0xFFFF47B},
    [I(231,122)] = {30,0x3FFFF9FB},
    [I(232,122)] = {29,0x1FFFF57B},
    [I(233,122)] = {29,0x1FFFF5FB},
    [I(234,122)] = {X32,0xFFFFF77B},
    [I(235,122)] = {X32,0xFFFFF7FB},
    [I(236,122)] = {31,0x7FFFFA7B},
    [I(237,122)] = {31,0x7FFFFAFB},
    [I(238,122)] = {64,0},
    [I(239,122)] = {30,0x3FFFFA7B},
    [I(240,122)] = {64,0},
    [I(241,122)] = {64,0},
    [I(242,122)] = {64,0},
    [I(243,122)] = {64,0},
    [I(244,122)] = {64,0},
    [I(245,122)] = {64,0},
    [I(246,122)] = {64,0},
    [I(247,122)] = {64,0},
    [I(248,122)] = {64,0},
    [I(249,122)] = {64,0},
    [I(250,122)] = {64,0},
    [I(251,122)] = {64,0},
    [I(252,122)] = {64,0},
    [I(253,122)] = {64,0},
    [I(254,122)] = {64,0},
    [I(255,122)] = {64,0},
    [I(0,123)] = {28,0xFFC7FFE},
    [I(1,123)] = {64,0},
    [I(2,123)] = {64,0},
    [I(3,123)] = {64,0},
    [I(4,123)] = {64,0},
    [I(5,123)] = {64,0},
    [I(6,123)] = {64,0},
    [I(7,123)] = {64,0},
    [I(8,123)] = {64,0},
    [I(9,123)] = {64,0},
    [I(10,123)] = {64,0},
    [I(11,123)] = {64,0},
    [I(12,123)] = {64,0},
    [I(13,123)] = {64,0},
    [I(14,123)] = {64,0},
    [I(15,123)] = {64,0},
    [I(16,123)] = {64,0},
    [I(17,123)] = {64,0},
    [I(18,123)] = {64,0},
    [I(19,123)] = {64,0},
    [I(20,123)] = {64,0},
    [I(21,123)] = {64,0},
    [I(22,123)] = {64,0},
    [I(23,123)] = {64,0},
    [I(24,123)] = {64,0},
    [I(25,123)] = {64,0},
    [I(26,123)] = {64,0},
    [I(27,123)] = {64,0},
    [I(28,123)] = {64,0},
    [I(29,123)] = {64,0},
    [I(30,123)] = {64,0},
    [I(31,123)] = {64,0},
    [I(32,123)] = {21,0xA7FFE},
    [I(33,123)] = {25,0x1FC7FFE},
    [I(34,123)] = {25,0x1FCFFFE},
    [I(35,123)] = {27,0x7FD7FFE},
    [I(36,123)] = {28,0xFFCFFFE},
    [I(37,123)] = {21,0xAFFFE},
    [I(38,123)] = {23,0x7C7FFE},
    [I(39,123)] = {26,0x3FD7FFE},
    [I(40,123)] = {25,0x1FD7FFE},
    [I(41,123)] = {25,0x1FDFFFE},
    [I(42,123)] = {23,0x7CFFFE},
    [I(43,123)] = {26,0x3FDFFFE},
    [I(44,123)] = {23,0x7D7FFE},
    [I(45,123)] = {21,0xB7FFE},
    [I(46,123)] = {21,0xBFFFE},
    [I(47,123)] = {21,0xC7FFE},
    [I(48,123)] = {20,0x7FFE},
    [I(49,123)] = {20,0xFFFE},
    [I(50,123)] = {20,0x17FFE},
    [I(51,123)] = {21,0xCFFFE},
    [I(52,123)] = {21,0xD7FFE},
    [I(53,123)] = {21,0xDFFFE},
    [I(54,123)] = {21,0xE7FFE},
    [I(55,123)] = {21,0xEFFFE},
    [I(56,123)] = {21,0xF7FFE},
    [I(57,123)] = {21,0xFFFFE},
    [I(58,123)] = {22,0x2E7FFE},
    [I(59,123)] = {23,0x7DFFFE},
    [I(60,123)] = {30,0x3FFE7FFE},
    [I(61,123)] = {21,0x107FFE},
    [I(62,123)] = {27,0x7FDFFFE},
    [I(63,123)] = {25,0x1FE7FFE},
    [I(64,123)] = {28,0xFFD7FFE},
    [I(65,123)] = {21,0x10FFFE},
    [I(66,123)] = {22,0x2EFFFE},
    [I(67,123)] = {22,0x2F7FFE},
    [I(68,123)] = {22,0x2FFFFE},
    [I(69,123)] = {22,0x307FFE},
    [I(70,123)] = {22,0x30FFFE},
    [I(71,123)] = {22,0x317FFE},
    [I(72,123)] = {22,0x31FFFE},
    [I(73,123)] = {22,0x327FFE},
    [I(74,123)] = {22,0x32FFFE},
    [I(75,123)] = {22,0x337FFE},
    [I(76,123)] = {22,0x33FFFE},
    [I(77,123)] = {22,0x347FFE},
    [I(78,123)] = {22,0x34FFFE},
    [I(79,123)] = {22,0x357FFE},
    [I(80,123)] = {22,0x35FFFE},
    [I(81,123)] = {22,0x367FFE},
    [I(82,123)] = {22,0x36FFFE},
    [I(83,123)] = {22,0x377FFE},
    [I(84,123)] = {22,0x37FFFE},
    [I(85,123)] = {22,0x387FFE},
    [I(86,123)] = {22,0x38FFFE},
    [I(87,123)] = {22,0x397FFE},
    [I(88,123)] = {23,0x7E7FFE},
    [I(89,123)] = {22,0x39FFFE},
    [I(90,123)] = {23,0x7EFFFE},
    [I(91,123)] = {28,0xFFDFFFE},
    [I(92,123)] = {64,0},
    [I(93,123)] = {28,0xFFE7FFE},
    [I(94,123)] = {29,0x1FFE7FFE},
    [I(95,123)] = {21,0x117FFE},
    [I(96,123)] = {30,0x3FFEFFFE},
    [I(97,123)] = {20,0x1FFFE},
    [I(98,123)] = {21,0x11FFFE},
    [I(99,123)] = {20,0x27FFE},
    [I(100,123)] = {21,0x127FFE},
    [I(101,123)] = {20,0x2FFFE},
    [I(102,123)] = {21,0x12FFFE},
    [I(103,123)] = {21,0x137FFE},
    [I(104,123)] = {21,0x13FFFE},
    [I(105,123)] = {20,0x37FFE},
    [I(106,123)] = {22,0x3A7FFE},
    [I(107,123)] = {22,0x3AFFFE},
    [I(108,123)] = {21,0x147FFE},
    [I(109,123)] = {21,0x14FFFE},
    [I(110,123)] = {21,0x157FFE},
    [I(111,123)] = {20,0x3FFFE},
    [I(112,123)] = {21,0x15FFFE},
    [I(113,123)] = {22,0x3B7FFE},
    [I(114,123)] = {21,0x167FFE},
    [I(115,123)] = {20,0x47FFE},
    [I(116,123)] = {20,0x4FFFE},
    [I(117,123)] = {21,0x16FFFE},
    [I(118,123)] = {22,0x3BFFFE},
    [I(119,123)] = {22,0x3C7FFE},
    [I(120,123)] = {22,0x3CFFFE},
    [I(121,123)] = {22,0x3D7FFE},
    [I(122,123)] = {22,0x3DFFFE},
    [I(123,123)] = {30,0x3FFF7FFE},
    [I(124,123)] = {26,0x3FE7FFE},
    [I(125,123)] = {29,0x1FFEFFFE},
    [I(126,123)] = {28,0xFFEFFFE},
    [I(127,123)] = {64,0},
    [I(128,123)] = {64,0},
    [I(129,123)] = {64,0},
    [I(130,123)] = {64,0},
    [I(131,123)] = {64,0},
    [I(132,123)] = {64,0},
    [I(133,123)] = {64,0},
    [I(134,123)] = {64,0},
    [I(135,123)] = {64,0},
    [I(136,123)] = {64,0},
    [I(137,123)] = {64,0},
    [I(138,123)] = {64,0},
    [I(139,123)] = {64,0},
    [I(140,123)] = {64,0},
    [I(141,123)] = {64,0},
    [I(142,123)] = {64,0},
    [I(143,123)] = {64,0},
    [I(144,123)] = {64,0},
    [I(145,123)] = {64,0},
    [I(146,123)] = {64,0},
    [I(147,123)] = {64,0},
    [I(148,123)] = {64,0},
    [I(149,123)] = {64,0},
    [I(150,123)] = {64,0},
    [I(151,123)] = {64,0},
    [I(152,123)] = {64,0},
    [I(153,123)] = {64,0},
    [I(154,123)] = {64,0},
    [I(155,123)] = {64,0},
    [I(156,123)] = {64,0},
    [I(157,123)] = {64,0},
    [I(158,123)] = {64,0},
    [I(159,123)] = {64,0},
    [I(160,123)] = {64,0},
    [I(161,123)] = {64,0},
    [I(162,123)] = {64,0},
    [I(163,123)] = {64,0},
    [I(164,123)] = {64,0},
    [I(165,123)] = {64,0},
    [I(166,123)] = {64,0},
    [I(167,123)] = {64,0},
    [I(168,123)] = {64,0},
    [I(169,123)] = {64,0},
    [I(170,123)] = {64,0},
    [I(171,123)] = {64,0},
    [I(172,123)] = {64,0},
    [I(173,123)] = {64,0},
    [I(174,123)] = {64,0},
    [I(175,123)] = {64,0},
    [I(176,123)] = {64,0},
    [I(177,123)] = {64,0},
    [I(178,123)] = {64,0},
    [I(179,123)] = {64,0},
    [I(180,123)] = {64,0},
    [I(181,123)] = {64,0},
    [I(182,123)] = {64,0},
    [I(183,123)] = {64,0},
    [I(184,123)] = {64,0},
    [I(185,123)] = {64,0},
    [I(186,123)] = {64,0},
    [I(187,123)] = {64,0},
    [I(188,123)] = {64,0},
    [I(189,123)] = {64,0},
    [I(190,123)] = {64,0},
    [I(191,123)] = {64,0},
    [I(192,123)] = {64,0},
    [I(193,123)] = {64,0},
    [I(194,123)] = {64,0},
    [I(195,123)] = {64,0},
    [I(196,123)] = {64,0},
    [I(197,123)] = {64,0},
    [I(198,123)] = {64,0},
    [I(199,123)] = {64,0},
    [I(200,123)] = {64,0},
    [I(201,123)] = {64,0},
    [I(202,123)] = {64,0},
    [I(203,123)] = {64,0},
    [I(204,123)] = {64,0},
    [I(205,123)] = {64,0},
    [I(206,123)] = {64,0},
    [I(207,123)] = {64,0},
    [I(208,123)] = {64,0},
    [I(209,123)] = {64,0},
    [I(210,123)] = {64,0},
    [I(211,123)] = {64,0},
    [I(212,123)] = {64,0},
    [I(213,123)] = {64,0},
    [I(214,123)] = {64,0},
    [I(215,123)] = {64,0},
    [I(216,123)] = {64,0},
    [I(217,123)] = {64,0},
    [I(218,123)] = {64,0},
    [I(219,123)] = {64,0},
    [I(220,123)] = {64,0},
    [I(221,123)] = {64,0},
    [I(222,123)] = {64,0},
    [I(223,123)] = {64,0},
    [I(224,123)] = {64,0},
    [I(225,123)] = {64,0},
    [I(226,123)] = {64,0},
    [I(227,123)] = {64,0},
    [I(228,123)] = {64,0},
    [I(229,123)] = {64,0},
    [I(230,123)] = {64,0},
    [I(231,123)] = {64,0},
    [I(232,123)] = {64,0},
    [I(233,123)] = {64,0},
    [I(234,123)] = {64,0},
    [I(235,123)] = {64,0},
    [I(236,123)] = {64,0},
    [I(237,123)] = {64,0},
    [I(238,123)] = {64,0},
    [I(239,123)] = {64,0},
    [I(240,123)] = {64,0},
    [I(241,123)] = {64,0},
    [I(242,123)] = {64,0},
    [I(243,123)] = {64,0},
    [I(244,123)] = {64,0},
    [I(245,123)] = {64,0},
    [I(246,123)] = {64,0},
    [I(247,123)] = {64,0},
    [I(248,123)] = {64,0},
    [I(249,123)] = {64,0},
    [I(250,123)] = {64,0},
    [I(251,123)] = {64,0},
    [I(252,123)] = {64,0},
    [I(253,123)] = {64,0},
    [I(254,123)] = {64,0},
    [I(255,123)] = {64,0},
    [I(0,124)] = {24,0xFFC7FC},
    [I(1,124)] = {64,0},
    [I(2,124)] = {64,0},
    [I(3,124)] = {64,0},
    [I(4,124)] = {64,0},
    [I(5,124)] = {64,0},
    [I(6,124)] = {64,0},
    [I(7,124)] = {64,0},
    [I(8,124)] = {64,0},
    [I(9,124)] = {64,0},
    [I(10,124)] = {64,0},
    [I(11,124)] = {64,0},
    [I(12,124)] = {64,0},
    [I(13,124)] = {64,0},
    [I(14,124)] = {64,0},
    [I(15,124)] = {64,0},
    [I(16,124)] = {64,0},
    [I(17,124)] = {64,0},
    [I(18,124)] = {64,0},
    [I(19,124)] = {64,0},
    [I(20,124)] = {64,0},
    [I(21,124)] = {64,0},
    [I(22,124)] = {64,0},
    [I(23,124)] = {64,0},
    [I(24,124)] = {64,0},
    [I(25,124)] = {64,0},
    [I(26,124)] = {64,0},
    [I(27,124)] = {64,0},
    [I(28,124)] = {64,0},
    [I(29,124)] = {64,0},
    [I(30,124)] = {64,0},
    [I(31,124)] = {64,0},
    [I(32,124)] = {17,0xA7FC},
    [I(33,124)] = {21,0x1FC7FC},
    [I(34,124)] = {21,0x1FCFFC},
    [I(35,124)] = {23,0x7FD7FC},
    [I(36,124)] = {24,0xFFCFFC},
    [I(37,124)] = {17,0xAFFC},
    [I(38,124)] = {19,0x7C7FC},
    [I(39,124)] = {22,0x3FD7FC},
    [I(40,124)] = {21,0x1FD7FC},
    [I(41,124)] = {21,0x1FDFFC},
    [I(42,124)] = {19,0x7CFFC},
    [I(43,124)] = {22,0x3FDFFC},
    [I(44,124)] = {19,0x7D7FC},
    [I(45,124)] = {17,0xB7FC},
    [I(46,124)] = {17,0xBFFC},
    [I(47,124)] = {17,0xC7FC},
    [I(48,124)] = {16,0x7FC},
    [I(49,124)] = {16,0xFFC},
    [I(50,124)] = {16,0x17FC},
    [I(51,124)] = {17,0xCFFC},
    [I(52,124)] = {17,0xD7FC},
    [I(53,124)] = {17,0xDFFC},
    [I(54,124)] = {17,0xE7FC},
    [I(55,124)] = {17,0xEFFC},
    [I(56,124)] = {17,0xF7FC},
    [I(57,124)] = {17,0xFFFC},
    [I(58,124)] = {18,0x2E7FC},
    [I(59,124)] = {19,0x7DFFC},
    [I(60,124)] = {26,0x3FFE7FC},
    [I(61,124)] = {17,0x107FC},
    [I(62,124)] = {23,0x7FDFFC},
    [I(63,124)] = {21,0x1FE7FC},
    [I(64,124)] = {24,0xFFD7FC},
    [I(65,124)] = {17,0x10FFC},
    [I(66,124)] = {18,0x2EFFC},
    [I(67,124)] = {18,0x2F7FC},
    [I(68,124)] = {18,0x2FFFC},
    [I(69,124)] = {18,0x307FC},
    [I(70,124)] = {18,0x30FFC},
    [I(71,124)] = {18,0x317FC},
    [I(72,124)] = {18,0x31FFC},
    [I(73,124)] = {18,0x327FC},
    [I(74,124)] = {18,0x32FFC},
    [I(75,124)] = {18,0x337FC},
    [I(76,124)] = {18,0x33FFC},
    [I(77,124)] = {18,0x347FC},
    [I(78,124)] = {18,0x34FFC},
    [I(79,124)] = {18,0x357FC},
    [I(80,124)] = {18,0x35FFC},
    [I(81,124)] = {18,0x367FC},
    [I(82,124)] = {18,0x36FFC},
    [I(83,124)] = {18,0x377FC},
    [I(84,124)] = {18,0x37FFC},
    [I(85,124)] = {18,0x387FC},
    [I(86,124)] = {18,0x38FFC},
    [I(87,124)] = {18,0x397FC},
    [I(88,124)] = {19,0x7E7FC},
    [I(89,124)] = {18,0x39FFC},
    [I(90,124)] = {19,0x7EFFC},
    [I(91,124)] = {24,0xFFDFFC},
    [I(92,124)] = {30,0x3FFF87FC},
    [I(93,124)] = {24,0xFFE7FC},
    [I(94,124)] = {25,0x1FFE7FC},
    [I(95,124)] = {17,0x117FC},
    [I(96,124)] = {26,0x3FFEFFC},
    [I(97,124)] = {16,0x1FFC},
    [I(98,124)] = {17,0x11FFC},
    [I(99,124)] = {16,0x27FC},
    [I(100,124)] = {17,0x127FC},
    [I(101,124)] = {16,0x2FFC},
    [I(102,124)] = {17,0x12FFC},
    [I(103,124)] = {17,0x137FC},
    [I(104,124)] = {17,0x13FFC},
    [I(105,124)] = {16,0x37FC},
    [I(106,124)] = {18,0x3A7FC},
    [I(107,124)] = {18,0x3AFFC},
    [I(108,124)] = {17,0x147FC},
    [I(109,124)] = {17,0x14FFC},
    [I(110,124)] = {17,0x157FC},
    [I(111,124)] = {16,0x3FFC},
    [I(112,124)] = {17,0x15FFC},
    [I(113,124)] = {18,0x3B7FC},
    [I(114,124)] = {17,0x167FC},
    [I(115,124)] = {16,0x47FC},
    [I(116,124)] = {16,0x4FFC},
    [I(117,124)] = {17,0x16FFC},
    [I(118,124)] = {18,0x3BFFC},
    [I(119,124)] = {18,0x3C7FC},
    [I(120,124)] = {18,0x3CFFC},
    [I(121,124)] = {18,0x3D7FC},
    [I(122,124)] = {18,0x3DFFC},
    [I(123,124)] = {26,0x3FFF7FC},
    [I(124,124)] = {22,0x3FE7FC},
    [I(125,124)] = {25,0x1FFEFFC},
    [I(126,124)] = {24,0xFFEFFC},
    [I(127,124)] = {64,0},
    [I(128,124)] = {31,0x7FFF37FC},
    [I(129,124)] = {64,0},
    [I(130,124)] = {31,0x7FFF3FFC},
    [I(131,124)] = {31,0x7FFF47FC},
    [I(132,124)] = {64,0},
    [I(133,124)] = {64,0},
    [I(134,124)] = {64,0},
    [I(135,124)] = {64,0},
    [I(136,124)] = {64,0},
    [I(137,124)] = {64,0},
    [I(138,124)] = {64,0},
    [I(139,124)] = {64,0},
    [I(140,124)] = {64,0},
    [I(141,124)] = {64,0},
    [I(142,124)] = {64,0},
    [I(143,124)] = {64,0},
    [I(144,124)] = {64,0},
    [I(145,124)] = {64,0},
    [I(146,124)] = {64,0},
    [I(147,124)] = {64,0},
    [I(148,124)] = {64,0},
    [I(149,124)] = {64,0},
    [I(150,124)] = {64,0},
    [I(151,124)] = {64,0},
    [I(152,124)] = {64,0},
    [I(153,124)] = {X32,0xFFFEE7FC},
    [I(154,124)] = {64,0},
    [I(155,124)] = {64,0},
    [I(156,124)] = {64,0},
    [I(157,124)] = {64,0},
    [I(158,124)] = {64,0},
    [I(159,124)] = {64,0},
    [I(160,124)] = {64,0},
    [I(161,124)] = {X32,0xFFFEEFFC},
    [I(162,124)] = {31,0x7FFF4FFC},
    [I(163,124)] = {64,0},
    [I(164,124)] = {64,0},
    [I(165,124)] = {64,0},
    [I(166,124)] = {64,0},
    [I(167,124)] = {X32,0xFFFEF7FC},
    [I(168,124)] = {64,0},
    [I(169,124)] = {64,0},
    [I(170,124)] = {64,0},
    [I(171,124)] = {64,0},
    [I(172,124)] = {X32,0xFFFEFFFC},
    [I(173,124)] = {64,0},
    [I(174,124)] = {64,0},
    [I(175,124)] = {64,0},
    [I(176,124)] = {X32,0xFFFF07FC},
    [I(177,124)] = {X32,0xFFFF0FFC},
    [I(178,124)] = {64,0},
    [I(179,124)] = {X32,0xFFFF17FC},
    [I(180,124)] = {64,0},
    [I(181,124)] = {64,0},
    [I(182,124)] = {64,0},
    [I(183,124)] = {64,0},
    [I(184,124)] = {31,0x7FFF57FC},
    [I(185,124)] = {64,0},
    [I(186,124)] = {64,0},
    [I(187,124)] = {64,0},
    [I(188,124)] = {64,0},
    [I(189,124)] = {64,0},
    [I(190,124)] = {64,0},
    [I(191,124)] = {64,0},
    [I(192,124)] = {64,0},
    [I(193,124)] = {64,0},
    [I(194,124)] = {31,0x7FFF5FFC},
    [I(195,124)] = {30,0x3FFF8FFC},
    [I(196,124)] = {64,0},
    [I(197,124)] = {64,0},
    [I(198,124)] = {64,0},
    [I(199,124)] = {64,0},
    [I(200,124)] = {64,0},
    [I(201,124)] = {64,0},
    [I(202,124)] = {64,0},
    [I(203,124)] = {64,0},
    [I(204,124)] = {64,0},
    [I(205,124)] = {64,0},
    [I(206,124)] = {64,0},
    [I(207,124)] = {64,0},
    [I(208,124)] = {30,0x3FFF97FC},
    [I(209,124)] = {X32,0xFFFF1FFC},
    [I(210,124)] = {64,0},
    [I(211,124)] = {64,0},
    [I(212,124)] = {64,0},
    [I(213,124)] = {64,0},
    [I(214,124)] = {64,0},
    [I(215,124)] = {64,0},
    [I(216,124)] = {X32,0xFFFF27FC},
    [I(217,124)] = {X32,0xFFFF2FFC},
    [I(218,124)] = {64,0},
    [I(219,124)] = {64,0},
    [I(220,124)] = {64,0},
    [I(221,124)] = {64,0},
    [I(222,124)] = {64,0},
    [I(223,124)] = {64,0},
    [I(224,124)] = {31,0x7FFF67FC},
    [I(225,124)] = {64,0},
    [I(226,124)] = {31,0x7FFF6FFC},
    [I(227,124)] = {X32,0xFFFF37FC},
    [I(228,124)] = {64,0},
    [I(229,124)] = {X32,0xFFFF3FFC},
    [I(230,124)] = {X32,0xFFFF47FC},
    [I(231,124)] = {64,0},
    [I(232,124)] = {64,0},
    [I(233,124)] = {64,0},
    [I(234,124)] = {64,0},
    [I(235,124)] = {64,0},
    [I(236,124)] = {64,0},
    [I(237,124)] = {64,0},
    [I(238,124)] = {64,0},
    [I(239,124)] = {64,0},
    [I(240,124)] = {64,0},
    [I(241,124)] = {64,0},
    [I(242,124)] = {64,0},
    [I(243,124)] = {64,0},
    [I(244,124)] = {64,0},
    [I(245,124)] = {64,0},
    [I(246,124)] = {64,0},
    [I(247,124)] = {64,0},
    [I(248,124)] = {64,0},
    [I(249,124)] = {64,0},
    [I(250,124)] = {64,0},
    [I(251,124)] = {64,0},
    [I(252,124)] = {64,0},
    [I(253,124)] = {64,0},
    [I(254,124)] = {64,0},
    [I(255,124)] = {64,0},
    [I(0,125)] = {27,0x7FE3FFD},
    [I(1,125)] = {64,0},
    [I(2,125)] = {64,0},
    [I(3,125)] = {64,0},
    [I(4,125)] = {64,0},
    [I(5,125)] = {64,0},
    [I(6,125)] = {64,0},
    [I(7,125)] = {64,0},
    [I(8,125)] = {64,0},
    [I(9,125)] = {64,0},
    [I(10,125)] = {64,0},
    [I(11,125)] = {64,0},
    [I(12,125)] = {64,0},
    [I(13,125)] = {64,0},
    [I(14,125)] = {64,0},
    [I(15,125)] = {64,0},
    [I(16,125)] = {64,0},
    [I(17,125)] = {64,0},
    [I(18,125)] = {64,0},
    [I(19,125)] = {64,0},
    [I(20,125)] = {64,0},
    [I(21,125)] = {64,0},
    [I(22,125)] = {64,0},
    [I(23,125)] = {64,0},
    [I(24,125)] = {64,0},
    [I(25,125)] = {64,0},
    [I(26,125)] = {64,0},
    [I(27,125)] = {64,0},
    [I(28,125)] = {64,0},
    [I(29,125)] = {64,0},
    [I(30,125)] = {64,0},
    [I(31,125)] = {64,0},
    [I(32,125)] = {20,0x53FFD},
    [I(33,125)] = {24,0xFE3FFD},
    [I(34,125)] = {24,0xFE7FFD},
    [I(35,125)] = {26,0x3FEBFFD},
    [I(36,125)] = {27,0x7FE7FFD},
    [I(37,125)] = {20,0x57FFD},
    [I(38,125)] = {22,0x3E3FFD},
    [I(39,125)] = {25,0x1FEBFFD},
    [I(40,125)] = {24,0xFEBFFD},
    [I(41,125)] = {24,0xFEFFFD},
    [I(42,125)] = {22,0x3E7FFD},
    [I(43,125)] = {25,0x1FEFFFD},
    [I(44,125)] = {22,0x3EBFFD},
    [I(45,125)] = {20,0x5BFFD},
    [I(46,125)] = {20,0x5FFFD},
    [I(47,125)] = {20,0x63FFD},
    [I(48,125)] = {19,0x3FFD},
    [I(49,125)] = {19,0x7FFD},
    [I(50,125)] = {19,0xBFFD},
    [I(51,125)] = {20,0x67FFD},
    [I(52,125)] = {20,0x6BFFD},
    [I(53,125)] = {20,0x6FFFD},
    [I(54,125)] = {20,0x73FFD},
    [I(55,125)] = {20,0x77FFD},
    [I(56,125)] = {20,0x7BFFD},
    [I(57,125)] = {20,0x7FFFD},
    [I(58,125)] = {21,0x173FFD},
    [I(59,125)] = {22,0x3EFFFD},
    [I(60,125)] = {29,0x1FFF3FFD},
    [I(61,125)] = {20,0x83FFD},
    [I(62,125)] = {26,0x3FEFFFD},
    [I(63,125)] = {24,0xFF3FFD},
    [I(64,125)] = {27,0x7FEBFFD},
    [I(65,125)] = {20,0x87FFD},
    [I(66,125)] = {21,0x177FFD},
    [I(67,125)] = {21,0x17BFFD},
    [I(68,125)] = {21,0x17FFFD},
    [I(69,125)] = {21,0x183FFD},
    [I(70,125)] = {21,0x187FFD},
    [I(71,125)] = {21,0x18BFFD},
    [I(72,125)] = {21,0x18FFFD},
    [I(73,125)] = {21,0x193FFD},
    [I(74,125)] = {21,0x197FFD},
    [I(75,125)] = {21,0x19BFFD},
    [I(76,125)] = {21,0x19FFFD},
    [I(77,125)] = {21,0x1A3FFD},
    [I(78,125)] = {21,0x1A7FFD},
    [I(79,125)] = {21,0x1ABFFD},
    [I(80,125)] = {21,0x1AFFFD},
    [I(81,125)] = {21,0x1B3FFD},
    [I(82,125)] = {21,0x1B7FFD},
    [I(83,125)] = {21,0x1BBFFD},
    [I(84,125)] = {21,0x1BFFFD},
    [I(85,125)] = {21,0x1C3FFD},
    [I(86,125)] = {21,0x1C7FFD},
    [I(87,125)] = {21,0x1CBFFD},
    [I(88,125)] = {22,0x3F3FFD},
    [I(89,125)] = {21,0x1CFFFD},
    [I(90,125)] = {22,0x3F7FFD},
    [I(91,125)] = {27,0x7FEFFFD},
    [I(92,125)] = {64,0},
    [I(93,125)] = {27,0x7FF3FFD},
    [I(94,125)] = {28,0xFFF3FFD},
    [I(95,125)] = {20,0x8BFFD},
    [I(96,125)] = {29,0x1FFF7FFD},
    [I(97,125)] = {19,0xFFFD},
    [I(98,125)] = {20,0x8FFFD},
    [I(99,125)] = {19,0x13FFD},
    [I(100,125)] = {20,0x93FFD},
    [I(101,125)] = {19,0x17FFD},
    [I(102,125)] = {20,0x97FFD},
    [I(103,125)] = {20,0x9BFFD},
    [I(104,125)] = {20,0x9FFFD},
    [I(105,125)] = {19,0x1BFFD},
    [I(106,125)] = {21,0x1D3FFD},
    [I(107,125)] = {21,0x1D7FFD},
    [I(108,125)] = {20,0xA3FFD},
    [I(109,125)] = {20,0xA7FFD},
    [I(110,125)] = {20,0xABFFD},
    [I(111,125)] = {19,0x1FFFD},
    [I(112,125)] = {20,0xAFFFD},
    [I(113,125)] = {21,0x1DBFFD},
    [I(114,125)] = {20,0xB3FFD},
    [I(115,125)] = {19,0x23FFD},
    [I(116,125)] = {19,0x27FFD},
    [I(117,125)] = {20,0xB7FFD},
    [I(118,125)] = {21,0x1DFFFD},
    [I(119,125)] = {21,0x1E3FFD},
    [I(120,125)] = {21,0x1E7FFD},
    [I(121,125)] = {21,0x1EBFFD},
    [I(122,125)] = {21,0x1EFFFD},
    [I(123,125)] = {29,0x1FFFBFFD},
    [I(124,125)] = {25,0x1FF3FFD},
    [I(125,125)] = {28,0xFFF7FFD},
    [I(126,125)] = {27,0x7FF7FFD},
    [I(127,125)] = {64,0},
    [I(128,125)] = {64,0},
    [I(129,125)] = {64,0},
    [I(130,125)] = {64,0},
    [I(131,125)] = {64,0},
    [I(132,125)] = {64,0},
    [I(133,125)] = {64,0},
    [I(134,125)] = {64,0},
    [I(135,125)] = {64,0},
    [I(136,125)] = {64,0},
    [I(137,125)] = {64,0},
    [I(138,125)] = {64,0},
    [I(139,125)] = {64,0},
    [I(140,125)] = {64,0},
    [I(141,125)] = {64,0},
    [I(142,125)] = {64,0},
    [I(143,125)] = {64,0},
    [I(144,125)] = {64,0},
    [I(145,125)] = {64,0},
    [I(146,125)] = {64,0},
    [I(147,125)] = {64,0},
    [I(148,125)] = {64,0},
    [I(149,125)] = {64,0},
    [I(150,125)] = {64,0},
    [I(151,125)] = {64,0},
    [I(152,125)] = {64,0},
    [I(153,125)] = {64,0},
    [I(154,125)] = {64,0},
    [I(155,125)] = {64,0},
    [I(156,125)] = {64,0},
    [I(157,125)] = {64,0},
    [I(158,125)] = {64,0},
    [I(159,125)] = {64,0},
    [I(160,125)] = {64,0},
    [I(161,125)] = {64,0},
    [I(162,125)] = {64,0},
    [I(163,125)] = {64,0},
    [I(164,125)] = {64,0},
    [I(165,125)] = {64,0},
    [I(166,125)] = {64,0},
    [I(167,125)] = {64,0},
    [I(168,125)] = {64,0},
    [I(169,125)] = {64,0},
    [I(170,125)] = {64,0},
    [I(171,125)] = {64,0},
    [I(172,125)] = {64,0},
    [I(173,125)] = {64,0},
    [I(174,125)] = {64,0},
    [I(175,125)] = {64,0},
    [I(176,125)] = {64,0},
    [I(177,125)] = {64,0},
    [I(178,125)] = {64,0},
    [I(179,125)] = {64,0},
    [I(180,125)] = {64,0},
    [I(181,125)] = {64,0},
    [I(182,125)] = {64,0},
    [I(183,125)] = {64,0},
    [I(184,125)] = {64,0},
    [I(185,125)] = {64,0},
    [I(186,125)] = {64,0},
    [I(187,125)] = {64,0},
    [I(188,125)] = {64,0},
    [I(189,125)] = {64,0},
    [I(190,125)] = {64,0},
    [I(191,125)] = {64,0},
    [I(192,125)] = {64,0},
    [I(193,125)] = {64,0},
    [I(194,125)] = {64,0},
    [I(195,125)] = {64,0},
    [I(196,125)] = {64,0},
    [I(197,125)] = {64,0},
    [I(198,125)] = {64,0},
    [I(199,125)] = {64,0},
    [I(200,125)] = {64,0},
    [I(201,125)] = {64,0},
    [I(202,125)] = {64,0},
    [I(203,125)] = {64,0},
    [I(204,125)] = {64,0},
    [I(205,125)] = {64,0},
    [I(206,125)] = {64,0},
    [I(207,125)] = {64,0},
    [I(208,125)] = {64,0},
    [I(209,125)] = {64,0},
    [I(210,125)] = {64,0},
    [I(211,125)] = {64,0},
    [I(212,125)] = {64,0},
    [I(213,125)] = {64,0},
    [I(214,125)] = {64,0},
    [I(215,125)] = {64,0},
    [I(216,125)] = {64,0},
    [I(217,125)] = {64,0},
    [I(218,125)] = {64,0},
    [I(219,125)] = {64,0},
    [I(220,125)] = {64,0},
    [I(221,125)] = {64,0},
    [I(222,125)] = {64,0},
    [I(223,125)] = {64,0},
    [I(224,125)] = {64,0},
    [I(225,125)] = {64,0},
    [I(226,125)] = {64,0},
    [I(227,125)] = {64,0},
    [I(228,125)] = {64,0},
    [I(229,125)] = {64,0},
    [I(230,125)] = {64,0},
    [I(231,125)] = {64,0},
    [I(232,125)] = {64,0},
    [I(233,125)] = {64,0},
    [I(234,125)] = {64,0},
    [I(235,125)] = {64,0},
    [I(236,125)] = {64,0},
    [I(237,125)] = {64,0},
    [I(238,125)] = {64,0},
    [I(239,125)] = {64,0},
    [I(240,125)] = {64,0},
    [I(241,125)] = {64,0},
    [I(242,125)] = {64,0},
    [I(243,125)] = {64,0},
    [I(244,125)] = {64,0},
    [I(245,125)] = {64,0},
    [I(246,125)] = {64,0},
    [I(247,125)] = {64,0},
    [I(248,125)] = {64,0},
    [I(249,125)] = {64,0},
    [I(250,125)] = {64,0},
    [I(251,125)] = {64,0},
    [I(252,125)] = {64,0},
    [I(253,125)] = {64,0},
    [I(254,125)] = {64,0},
    [I(255,125)] = {64,0},
    [I(0,126)] = {26,0x3FF1FFD},
    [I(1,126)] = {64,0},
    [I(2,126)] = {64,0},
    [I(3,126)] = {64,0},
    [I(4,126)] = {64,0},
    [I(5,126)] = {64,0},
    [I(6,126)] = {64,0},
    [I(7,126)] = {64,0},
    [I(8,126)] = {64,0},
    [I(9,126)] = {64,0},
    [I(10,126)] = {64,0},
    [I(11,126)] = {64,0},
    [I(12,126)] = {64,0},
    [I(13,126)] = {64,0},
    [I(14,126)] = {64,0},
    [I(15,126)] = {64,0},
    [I(16,126)] = {64,0},
    [I(17,126)] = {64,0},
    [I(18,126)] = {64,0},
    [I(19,126)] = {64,0},
    [I(20,126)] = {64,0},
    [I(21,126)] = {64,0},
    [I(22,126)] = {64,0},
    [I(23,126)] = {64,0},
    [I(24,126)] = {64,0},
    [I(25,126)] = {64,0},
    [I(26,126)] = {64,0},
    [I(27,126)] = {64,0},
    [I(28,126)] = {64,0},
    [I(29,126)] = {64,0},
    [I(30,126)] = {64,0},
    [I(31,126)] = {64,0},
    [I(32,126)] = {19,0x29FFD},
    [I(33,126)] = {23,0x7F1FFD},
    [I(34,126)] = {23,0x7F3FFD},
    [I(35,126)] = {25,0x1FF5FFD},
    [I(36,126)] = {26,0x3FF3FFD},
    [I(37,126)] = {19,0x2BFFD},
    [I(38,126)] = {21,0x1F1FFD},
    [I(39,126)] = {24,0xFF5FFD},
    [I(40,126)] = {23,0x7F5FFD},
    [I(41,126)] = {23,0x7F7FFD},
    [I(42,126)] = {21,0x1F3FFD},
    [I(43,126)] = {24,0xFF7FFD},
    [I(44,126)] = {21,0x1F5FFD},
    [I(45,126)] = {19,0x2DFFD},
    [I(46,126)] = {19,0x2FFFD},
    [I(47,126)] = {19,0x31FFD},
    [I(48,126)] = {18,0x1FFD},
    [I(49,126)] = {18,0x3FFD},
    [I(50,126)] = {18,0x5FFD},
    [I(51,126)] = {19,0x33FFD},
    [I(52,126)] = {19,0x35FFD},
    [I(53,126)] = {19,0x37FFD},
    [I(54,126)] = {19,0x39FFD},
    [I(55,126)] = {19,0x3BFFD},
    [I(56,126)] = {19,0x3DFFD},
    [I(57,126)] = {19,0x3FFFD},
    [I(58,126)] = {20,0xB9FFD},
    [I(59,126)] = {21,0x1F7FFD},
    [I(60,126)] = {28,0xFFF9FFD},
    [I(61,126)] = {19,0x41FFD},
    [I(62,126)] = {25,0x1FF7FFD},
    [I(63,126)] = {23,0x7F9FFD},
    [I(64,126)] = {26,0x3FF5FFD},
    [I(65,126)] = {19,0x43FFD},
    [I(66,126)] = {20,0xBBFFD},
    [I(67,126)] = {20,0xBDFFD},
    [I(68,126)] = {20,0xBFFFD},
    [I(69,126)] = {20,0xC1FFD},
    [I(70,126)] = {20,0xC3FFD},
    [I(71,126)] = {20,0xC5FFD},
    [I(72,126)] = {20,0xC7FFD},
    [I(73,126)] = {20,0xC9FFD},
    [I(74,126)] = {20,0xCBFFD},
    [I(75,126)] = {20,0xCDFFD},
    [I(76,126)] = {20,0xCFFFD},
    [I(77,126)] = {20,0xD1FFD},
    [I(78,126)] = {20,0xD3FFD},
    [I(79,126)] = {20,0xD5FFD},
    [I(80,126)] = {20,0xD7FFD},
    [I(81,126)] = {20,0xD9FFD},
    [I(82,126)] = {20,0xDBFFD},
    [I(83,126)] = {20,0xDDFFD},
    [I(84,126)] = {20,0xDFFFD},
    [I(85,126)] = {20,0xE1FFD},
    [I(86,126)] = {20,0xE3FFD},
    [I(87,126)] = {20,0xE5FFD},
    [I(88,126)] = {21,0x1F9FFD},
    [I(89,126)] = {20,0xE7FFD},
    [I(90,126)] = {21,0x1FBFFD},
    [I(91,126)] = {26,0x3FF7FFD},
    [I(92,126)] = {X32,0xFFFE1FFD},
    [I(93,126)] = {26,0x3FF9FFD},
    [I(94,126)] = {27,0x7FF9FFD},
    [I(95,126)] = {19,0x45FFD},
    [I(96,126)] = {28,0xFFFBFFD},
    [I(97,126)] = {18,0x7FFD},
    [I(98,126)] = {19,0x47FFD},
    [I(99,126)] = {18,0x9FFD},
    [I(100,126)] = {19,0x49FFD},
    [I(101,126)] = {18,0xBFFD},
    [I(102,126)] = {19,0x4BFFD},
    [I(103,126)] = {19,0x4DFFD},
    [I(104,126)] = {19,0x4FFFD},
    [I(105,126)] = {18,0xDFFD},
    [I(106,126)] = {20,0xE9FFD},
    [I(107,126)] = {20,0xEBFFD},
    [I(108,126)] = {19,0x51FFD},
    [I(109,126)] = {19,0x53FFD},
    [I(110,126)] = {19,0x55FFD},
    [I(111,126)] = {18,0xFFFD},
    [I(112,126)] = {19,0x57FFD},
    [I(113,126)] = {20,0xEDFFD},
    [I(114,126)] = {19,0x59FFD},
    [I(115,126)] = {18,0x11FFD},
    [I(116,126)] = {18,0x13FFD},
    [I(117,126)] = {19,0x5BFFD},
    [I(118,126)] = {20,0xEFFFD},
    [I(119,126)] = {20,0xF1FFD},
    [I(120,126)] = {20,0xF3FFD},
    [I(121,126)] = {20,0xF5FFD},
    [I(122,126)] = {20,0xF7FFD},
    [I(123,126)] = {28,0xFFFDFFD},
    [I(124,126)] = {24,0xFF9FFD},
    [I(125,126)] = {27,0x7FFBFFD},
    [I(126,126)] = {26,0x3FFBFFD},
    [I(127,126)] = {64,0},
    [I(128,126)] = {64,0},
    [I(129,126)] = {64,0},
    [I(130,126)] = {64,0},
    [I(131,126)] = {64,0},
    [I(132,126)] = {64,0},
    [I(133,126)] = {64,0},
    [I(134,126)] = {64,0},
    [I(135,126)] = {64,0},
    [I(136,126)] = {64,0},
    [I(137,126)] = {64,0},
    [I(138,126)] = {64,0},
    [I(139,126)] = {64,0},
    [I(140,126)] = {64,0},
    [I(141,126)] = {64,0},
    [I(142,126)] = {64,0},
    [I(143,126)] = {64,0},
    [I(144,126)] = {64,0},
    [I(145,126)] = {64,0},
    [I(146,126)] = {64,0},
    [I(147,126)] = {64,0},
    [I(148,126)] = {64,0},
    [I(149,126)] = {64,0},
    [I(150,126)] = {64,0},
    [I(151,126)] = {64,0},
    [I(152,126)] = {64,0},
    [I(153,126)] = {64,0},
    [I(154,126)] = {64,0},
    [I(155,126)] = {64,0},
    [I(156,126)] = {64,0},
    [I(157,126)] = {64,0},
    [I(158,126)] = {64,0},
    [I(159,126)] = {64,0},
    [I(160,126)] = {64,0},
    [I(161,126)] = {64,0},
    [I(162,126)] = {64,0},
    [I(163,126)] = {64,0},
    [I(164,126)] = {64,0},
    [I(165,126)] = {64,0},
    [I(166,126)] = {64,0},
    [I(167,126)] = {64,0},
    [I(168,126)] = {64,0},
    [I(169,126)] = {64,0},
    [I(170,126)] = {64,0},
    [I(171,126)] = {64,0},
    [I(172,126)] = {64,0},
    [I(173,126)] = {64,0},
    [I(174,126)] = {64,0},
    [I(175,126)] = {64,0},
    [I(176,126)] = {64,0},
    [I(177,126)] = {64,0},
    [I(178,126)] = {64,0},
    [I(179,126)] = {64,0},
    [I(180,126)] = {64,0},
    [I(181,126)] = {64,0},
    [I(182,126)] = {64,0},
    [I(183,126)] = {64,0},
    [I(184,126)] = {64,0},
    [I(185,126)] = {64,0},
    [I(186,126)] = {64,0},
    [I(187,126)] = {64,0},
    [I(188,126)] = {64,0},
    [I(189,126)] = {64,0},
    [I(190,126)] = {64,0},
    [I(191,126)] = {64,0},
    [I(192,126)] = {64,0},
    [I(193,126)] = {64,0},
    [I(194,126)] = {64,0},
    [I(195,126)] = {X32,0xFFFE3FFD},
    [I(196,126)] = {64,0},
    [I(197,126)] = {64,0},
    [I(198,126)] = {64,0},
    [I(199,126)] = {64,0},
    [I(200,126)] = {64,0},
    [I(201,126)] = {64,0},
    [I(202,126)] = {64,0},
    [I(203,126)] = {64,0},
    [I(204,126)] = {64,0},
    [I(205,126)] = {64,0},
    [I(206,126)] = {64,0},
    [I(207,126)] = {64,0},
    [I(208,126)] = {X32,0xFFFE5FFD},
    [I(209,126)] = {64,0},
    [I(210,126)] = {64,0},
    [I(211,126)] = {64,0},
    [I(212,126)] = {64,0},
    [I(213,126)] = {64,0},
    [I(214,126)] = {64,0},
    [I(215,126)] = {64,0},
    [I(216,126)] = {64,0},
    [I(217,126)] = {64,0},
    [I(218,126)] = {64,0},
    [I(219,126)] = {64,0},
    [I(220,126)] = {64,0},
    [I(221,126)] = {64,0},
    [I(222,126)] = {64,0},
    [I(223,126)] = {64,0},
    [I(224,126)] = {64,0},
    [I(225,126)] = {64,0},
    [I(226,126)] = {64,0},
    [I(227,126)] = {64,0},
    [I(228,126)] = {64,0},
    [I(229,126)] = {64,0},
    [I(230,126)] = {64,0},
    [I(231,126)] = {64,0},
    [I(232,126)] = {64,0},
    [I(233,126)] = {64,0},
    [I(234,126)] = {64,0},
    [I(235,126)] = {64,0},
    [I(236,126)] = {64,0},
    [I(237,126)] = {64,0},
    [I(238,126)] = {64,0},
    [I(239,126)] = {64,0},
    [I(240,126)] = {64,0},
    [I(241,126)] = {64,0},
    [I(242,126)] = {64,0},
    [I(243,126)] = {64,0},
    [I(244,126)] = {64,0},
    [I(245,126)] = {64,0},
    [I(246,126)] = {64,0},
    [I(247,126)] = {64,0},
    [I(248,126)] = {64,0},
    [I(249,126)] = {64,0},
    [I(250,126)] = {64,0},
    [I(251,126)] = {64,0},
    [I(252,126)] = {64,0},
    [I(253,126)] = {64,0},
    [I(254,126)] = {64,0},
    [I(255,126)] = {64,0},
    [I(0,127)] = {64,0},
    [I(1,127)] = {64,0},
    [I(2,127)] = {64,0},
    [I(3,127)] = {64,0},
    [I(4,127)] = {64,0},
    [I(5,127)] = {64,0},
    [I(6,127)] = {64,0},
    [I(7,127)] = {64,0},
    [I(8,127)] = {64,0},
    [I(9,127)] = {64,0},
    [I(10,127)] = {64,0},
    [I(11,127)] = {64,0},
    [I(12,127)] = {64,0},
    [I(13,127)] = {64,0},
    [I(14,127)] = {64,0},
    [I(15,127)] = {64,0},
    [I(16,127)] = {64,0},
    [I(17,127)] = {64,0},
    [I(18,127)] = {64,0},
    [I(19,127)] = {64,0},
    [I(20,127)] = {64,0},
    [I(21,127)] = {64,0},
    [I(22,127)] = {64,0},
    [I(23,127)] = {64,0},
    [I(24,127)] = {64,0},
    [I(25,127)] = {64,0},
    [I(26,127)] = {64,0},
    [I(27,127)] = {64,0},
    [I(28,127)] = {64,0},
    [I(29,127)] = {64,0},
    [I(30,127)] = {64,0},
    [I(31,127)] = {64,0},
    [I(32,127)] = {64,0},
    [I(33,127)] = {64,0},
    [I(34,127)] = {64,0},
    [I(35,127)] = {64,0},
    [I(36,127)] = {64,0},
    [I(37,127)] = {64,0},
    [I(38,127)] = {64,0},
    [I(39,127)] = {64,0},
    [I(40,127)] = {64,0},
    [I(41,127)] = {64,0},
    [I(42,127)] = {64,0},
    [I(43,127)] = {64,0},
    [I(44,127)] = {64,0},
    [I(45,127)] = {64,0},
    [I(46,127)] = {64,0},
    [I(47,127)] = {64,0},
    [I(48,127)] = {64,0},
    [I(49,127)] = {64,0},
    [I(50,127)] = {64,0},
    [I(51,127)] = {64,0},
    [I(52,127)] = {64,0},
    [I(53,127)] = {64,0},
    [I(54,127)] = {64,0},
    [I(55,127)] = {64,0},
    [I(56,127)] = {64,0},
    [I(57,127)] = {64,0},
    [I(58,127)] = {64,0},
    [I(59,127)] = {64,0},
    [I(60,127)] = {64,0},
    [I(61,127)] = {64,0},
    [I(62,127)] = {64,0},
    [I(63,127)] = {64,0},
    [I(64,127)] = {64,0},
    [I(65,127)] = {64,0},
    [I(66,127)] = {64,0},
    [I(67,127)] = {64,0},
    [I(68,127)] = {64,0},
    [I(69,127)] = {64,0},
    [I(70,127)] = {64,0},
    [I(71,127)] = {64,0},
    [I(72,127)] = {64,0},
    [I(73,127)] = {64,0},
    [I(74,127)] = {64,0},
    [I(75,127)] = {64,0},
    [I(76,127)] = {64,0},
    [I(77,127)] = {64,0},
    [I(78,127)] = {64,0},
    [I(79,127)] = {64,0},
    [I(80,127)] = {64,0},
    [I(81,127)] = {64,0},
    [I(82,127)] = {64,0},
    [I(83,127)] = {64,0},
    [I(84,127)] = {64,0},
    [I(85,127)] = {64,0},
    [I(86,127)] = {64,0},
    [I(87,127)] = {64,0},
    [I(88,127)] = {64,0},
    [I(89,127)] = {64,0},
    [I(90,127)] = {64,0},
    [I(91,127)] = {64,0},
    [I(92,127)] = {64,0},
    [I(93,127)] = {64,0},
    [I(94,127)] = {64,0},
    [I(95,127)] = {64,0},
    [I(96,127)] = {64,0},
    [I(97,127)] = {64,0},
    [I(98,127)] = {64,0},
    [I(99,127)] = {64,0},
    [I(100,127)] = {64,0},
    [I(101,127)] = {64,0},
    [I(102,127)] = {64,0},
    [I(103,127)] = {64,0},
    [I(104,127)] = {64,0},
    [I(105,127)] = {64,0},
    [I(106,127)] = {64,0},
    [I(107,127)] = {64,0},
    [I(108,127)] = {64,0},
    [I(109,127)] = {64,0},
    [I(110,127)] = {64,0},
    [I(111,127)] = {64,0},
    [I(112,127)] = {64,0},
    [I(113,127)] = {64,0},
    [I(114,127)] = {64,0},
    [I(115,127)] = {64,0},
    [I(116,127)] = {64,0},
    [I(117,127)] = {64,0},
    [I(118,127)] = {64,0},
    [I(119,127)] = {64,0},
    [I(120,127)] = {64,0},
    [I(121,127)] = {64,0},
    [I(122,127)] = {64,0},
    [I(123,127)] = {64,0},
    [I(124,127)] = {64,0},
    [I(125,127)] = {64,0},
    [I(126,127)] = {64,0},
    [I(127,127)] = {64,0},
    [I(128,127)] = {64,0},
    [I(129,127)] = {64,0},
    [I(130,127)] = {64,0},
    [I(131,127)] = {64,0},
    [I(132,127)] = {64,0},
    [I(133,127)] = {64,0},
    [I(134,127)] = {64,0},
    [I(135,127)] = {64,0},
    [I(136,127)] = {64,0},
    [I(137,127)] = {64,0},
    [I(138,127)] = {64,0},
    [I(139,127)] = {64,0},
    [I(140,127)] = {64,0},
    [I(141,127)] = {64,0},
    [I(142,127)] = {64,0},
    [I(143,127)] = {64,0},
    [I(144,127)] = {64,0},
    [I(145,127)] = {64,0},
    [I(146,127)] = {64,0},
    [I(147,127)] = {64,0},
    [I(148,127)] = {64,0},
    [I(149,127)] = {64,0},
    [I(150,127)] = {64,0},
    [I(151,127)] = {64,0},
    [I(152,127)] = {64,0},
    [I(153,127)] = {64,0},
    [I(154,127)] = {64,0},
    [I(155,127)] = {64,0},
    [I(156,127)] = {64,0},
    [I(157,127)] = {64,0},
    [I(158,127)] = {64,0},
    [I(159,127)] = {64,0},
    [I(160,127)] = {64,0},
    [I(161,127)] = {64,0},
    [I(162,127)] = {64,0},
    [I(163,127)] = {64,0},
    [I(164,127)] = {64,0},
    [I(165,127)] = {64,0},
    [I(166,127)] = {64,0},
    [I(167,127)] = {64,0},
    [I(168,127)] = {64,0},
    [I(169,127)] = {64,0},
    [I(170,127)] = {64,0},
    [I(171,127)] = {64,0},
    [I(172,127)] = {64,0},
    [I(173,127)] = {64,0},
    [I(174,127)] = {64,0},
    [I(175,127)] = {64,0},
    [I(176,127)] = {64,0},
    [I(177,127)] = {64,0},
    [I(178,127)] = {64,0},
    [I(179,127)] = {64,0},
    [I(180,127)] = {64,0},
    [I(181,127)] = {64,0},
    [I(182,127)] = {64,0},
    [I(183,127)] = {64,0},
    [I(184,127)] = {64,0},
    [I(185,127)] = {64,0},
    [I(186,127)] = {64,0},
    [I(187,127)] = {64,0},
    [I(188,127)] = {64,0},
    [I(189,127)] = {64,0},
    [I(190,127)] = {64,0},
    [I(191,127)] = {64,0},
    [I(192,127)] = {64,0},
    [I(193,127)] = {64,0},
    [I(194,127)] = {64,0},
    [I(195,127)] = {64,0},
    [I(196,127)] = {64,0},
    [I(197,127)] = {64,0},
    [I(198,127)] = {64,0},
    [I(199,127)] = {64,0},
    [I(200,127)] = {64,0},
    [I(201,127)] = {64,0},
    [I(202,127)] = {64,0},
    [I(203,127)] = {64,0},
    [I(204,127)] = {64,0},
    [I(205,127)] = {64,0},
    [I(206,127)] = {64,0},
    [I(207,127)] = {64,0},
    [I(208,127)] = {64,0},
    [I(209,127)] = {64,0},
    [I(210,127)] = {64,0},
    [I(211,127)] = {64,0},
    [I(212,127)] = {64,0},
    [I(213,127)] = {64,0},
    [I(214,127)] = {64,0},
    [I(215,127)] = {64,0},
    [I(216,127)] = {64,0},
    [I(217,127)] = {64,0},
    [I(218,127)] = {64,0},
    [I(219,127)] = {64,0},
    [I(220,127)] = {64,0},
    [I(221,127)] = {64,0},
    [I(222,127)] = {64,0},
    [I(223,127)] = {64,0},
    [I(224,127)] = {64,0},
    [I(225,127)] = {64,0},
    [I(226,127)] = {64,0},
    [I(227,127)] = {64,0},
    [I(228,127)] = {64,0},
    [I(229,127)] = {64,0},
    [I(230,127)] = {64,0},
    [I(231,127)] = {64,0},
    [I(232,127)] = {64,0},
    [I(233,127)] = {64,0},
    [I(234,127)] = {64,0},
    [I(235,127)] = {64,0},
    [I(236,127)] = {64,0},
    [I(237,127)] = {64,0},
    [I(238,127)] = {64,0},
    [I(239,127)] = {64,0},
    [I(240,127)] = {64,0},
    [I(241,127)] = {64,0},
    [I(242,127)] = {64,0},
    [I(243,127)] = {64,0},
    [I(244,127)] = {64,0},
    [I(245,127)] = {64,0},
    [I(246,127)] = {64,0},
    [I(247,127)] = {64,0},
    [I(248,127)] = {64,0},
    [I(249,127)] = {64,0},
    [I(250,127)] = {64,0},
    [I(251,127)] = {64,0},
    [I(252,127)] = {64,0},
    [I(253,127)] = {64,0},
    [I(254,127)] = {64,0},
    [I(255,127)] = {64,0},
    [I(0,128)] = {64,0},
    [I(1,128)] = {64,0},
    [I(2,128)] = {64,0},
    [I(3,128)] = {64,0},
    [I(4,128)] = {64,0},
    [I(5,128)] = {64,0},
    [I(6,128)] = {64,0},
    [I(7,128)] = {64,0},
    [I(8,128)] = {64,0},
    [I(9,128)] = {64,0},
    [I(10,128)] = {64,0},
    [I(11,128)] = {64,0},
    [I(12,128)] = {64,0},
    [I(13,128)] = {64,0},
    [I(14,128)] = {64,0},
    [I(15,128)] = {64,0},
    [I(16,128)] = {64,0},
    [I(17,128)] = {64,0},
    [I(18,128)] = {64,0},
    [I(19,128)] = {64,0},
    [I(20,128)] = {64,0},
    [I(21,128)] = {64,0},
    [I(22,128)] = {64,0},
    [I(23,128)] = {64,0},
    [I(24,128)] = {64,0},
    [I(25,128)] = {64,0},
    [I(26,128)] = {64,0},
    [I(27,128)] = {64,0},
    [I(28,128)] = {64,0},
    [I(29,128)] = {64,0},
    [I(30,128)] = {64,0},
    [I(31,128)] = {64,0},
    [I(32,128)] = {26,0x14FFFE6},
    [I(33,128)] = {30,0x3F8FFFE6},
    [I(34,128)] = {30,0x3F9FFFE6},
    [I(35,128)] = {X32,0xFFAFFFE6},
    [I(36,128)] = {64,0},
    [I(37,128)] = {26,0x15FFFE6},
    [I(38,128)] = {28,0xF8FFFE6},
    [I(39,128)] = {31,0x7FAFFFE6},
    [I(40,128)] = {30,0x3FAFFFE6},
    [I(41,128)] = {30,0x3FBFFFE6},
    [I(42,128)] = {28,0xF9FFFE6},
    [I(43,128)] = {31,0x7FBFFFE6},
    [I(44,128)] = {28,0xFAFFFE6},
    [I(45,128)] = {26,0x16FFFE6},
    [I(46,128)] = {26,0x17FFFE6},
    [I(47,128)] = {26,0x18FFFE6},
    [I(48,128)] = {25,0xFFFE6},
    [I(49,128)] = {25,0x1FFFE6},
    [I(50,128)] = {25,0x2FFFE6},
    [I(51,128)] = {26,0x19FFFE6},
    [I(52,128)] = {26,0x1AFFFE6},
    [I(53,128)] = {26,0x1BFFFE6},
    [I(54,128)] = {26,0x1CFFFE6},
    [I(55,128)] = {26,0x1DFFFE6},
    [I(56,128)] = {26,0x1EFFFE6},
    [I(57,128)] = {26,0x1FFFFE6},
    [I(58,128)] = {27,0x5CFFFE6},
    [I(59,128)] = {28,0xFBFFFE6},
    [I(60,128)] = {64,0},
    [I(61,128)] = {26,0x20FFFE6},
    [I(62,128)] = {X32,0xFFBFFFE6},
    [I(63,128)] = {30,0x3FCFFFE6},
    [I(64,128)] = {64,0},
    [I(65,128)] = {26,0x21FFFE6},
    [I(66,128)] = {27,0x5DFFFE6},
    [I(67,128)] = {27,0x5EFFFE6},
    [I(68,128)] = {27,0x5FFFFE6},
    [I(69,128)] = {27,0x60FFFE6},
    [I(70,128)] = {27,0x61FFFE6},
    [I(71,128)] = {27,0x62FFFE6},
    [I(72,128)] = {27,0x63FFFE6},
    [I(73,128)] = {27,0x64FFFE6},
    [I(74,128)] = {27,0x65FFFE6},
    [I(75,128)] = {27,0x66FFFE6},
    [I(76,128)] = {27,0x67FFFE6},
    [I(77,128)] = {27,0x68FFFE6},
    [I(78,128)] = {27,0x69FFFE6},
    [I(79,128)] = {27,0x6AFFFE6},
    [I(80,128)] = {27,0x6BFFFE6},
    [I(81,128)] = {27,0x6CFFFE6},
    [I(82,128)] = {27,0x6DFFFE6},
    [I(83,128)] = {27,0x6EFFFE6},
    [I(84,128)] = {27,0x6FFFFE6},
    [I(85,128)] = {27,0x70FFFE6},
    [I(86,128)] = {27,0x71FFFE6},
    [I(87,128)] = {27,0x72FFFE6},
    [I(88,128)] = {28,0xFCFFFE6},
    [I(89,128)] = {27,0x73FFFE6},
    [I(90,128)] = {28,0xFDFFFE6},
    [I(91,128)] = {64,0},
    [I(92,128)] = {64,0},
    [I(93,128)] = {64,0},
    [I(94,128)] = {64,0},
    [I(95,128)] = {26,0x22FFFE6},
    [I(96,128)] = {64,0},
    [I(97,128)] = {25,0x3FFFE6},
    [I(98,128)] = {26,0x23FFFE6},
    [I(99,128)] = {25,0x4FFFE6},
    [I(100,128)] = {26,0x24FFFE6},
    [I(101,128)] = {25,0x5FFFE6},
    [I(102,128)] = {26,0x25FFFE6},
    [I(103,128)] = {26,0x26FFFE6},
    [I(104,128)] = {26,0x27FFFE6},
    [I(105,128)] = {25,0x6FFFE6},
    [I(106,128)] = {27,0x74FFFE6},
    [I(107,128)] = {27,0x75FFFE6},
    [I(108,128)] = {26,0x28FFFE6},
    [I(109,128)] = {26,0x29FFFE6},
    [I(110,128)] = {26,0x2AFFFE6},
    [I(111,128)] = {25,0x7FFFE6},
    [I(112,128)] = {26,0x2BFFFE6},
    [I(113,128)] = {27,0x76FFFE6},
    [I(114,128)] = {26,0x2CFFFE6},
    [I(115,128)] = {25,0x8FFFE6},
    [I(116,128)] = {25,0x9FFFE6},
    [I(117,128)] = {26,0x2DFFFE6},
    [I(118,128)] = {27,0x77FFFE6},
    [I(119,128)] = {27,0x78FFFE6},
    [I(120,128)] = {27,0x79FFFE6},
    [I(121,128)] = {27,0x7AFFFE6},
    [I(122,128)] = {27,0x7BFFFE6},
    [I(123,128)] = {64,0},
    [I(124,128)] = {31,0x7FCFFFE6},
    [I(125,128)] = {64,0},
    [I(126,128)] = {64,0},
    [I(127,128)] = {64,0},
    [I(128,128)] = {64,0},
    [I(129,128)] = {64,0},
    [I(130,128)] = {64,0},
    [I(131,128)] = {64,0},
    [I(132,128)] = {64,0},
    [I(133,128)] = {64,0},
    [I(134,128)] = {64,0},
    [I(135,128)] = {64,0},
    [I(136,128)] = {64,0},
    [I(137,128)] = {64,0},
    [I(138,128)] = {64,0},
    [I(139,128)] = {64,0},
    [I(140,128)] = {64,0},
    [I(141,128)] = {64,0},
    [I(142,128)] = {64,0},
    [I(143,128)] = {64,0},
    [I(144,128)] = {64,0},
    [I(145,128)] = {64,0},
    [I(146,128)] = {64,0},
    [I(147,128)] = {64,0},
    [I(148,128)] = {64,0},
    [I(149,128)] = {64,0},
    [I(150,128)] = {64,0},
    [I(151,128)] = {64,0},
    [I(152,128)] = {64,0},
    [I(153,128)] = {64,0},
    [I(154,128)] = {64,0},
    [I(155,128)] = {64,0},
    [I(156,128)] = {64,0},
    [I(157,128)] = {64,0},
    [I(158,128)] = {64,0},
    [I(159,128)] = {64,0},
    [I(160,128)] = {64,0},
    [I(161,128)] = {64,0},
    [I(162,128)] = {64,0},
    [I(163,128)] = {64,0},
    [I(164,128)] = {64,0},
    [I(165,128)] = {64,0},
    [I(166,128)] = {64,0},
    [I(167,128)] = {64,0},
    [I(168,128)] = {64,0},
    [I(169,128)] = {64,0},
    [I(170,128)] = {64,0},
    [I(171,128)] = {64,0},
    [I(172,128)] = {64,0},
    [I(173,128)] = {64,0},
    [I(174,128)] = {64,0},
    [I(175,128)] = {64,0},
    [I(176,128)] = {64,0},
    [I(177,128)] = {64,0},
    [I(178,128)] = {64,0},
    [I(179,128)] = {64,0},
    [I(180,128)] = {64,0},
    [I(181,128)] = {64,0},
    [I(182,128)] = {64,0},
    [I(183,128)] = {64,0},
    [I(184,128)] = {64,0},
    [I(185,128)] = {64,0},
    [I(186,128)] = {64,0},
    [I(187,128)] = {64,0},
    [I(188,128)] = {64,0},
    [I(189,128)] = {64,0},
    [I(190,128)] = {64,0},
    [I(191,128)] = {64,0},
    [I(192,128)] = {64,0},
    [I(193,128)] = {64,0},
    [I(194,128)] = {64,0},
    [I(195,128)] = {64,0},
    [I(196,128)] = {64,0},
    [I(197,128)] = {64,0},
    [I(198,128)] = {64,0},
    [I(199,128)] = {64,0},
    [I(200,128)] = {64,0},
    [I(201,128)] = {64,0},
    [I(202,128)] = {64,0},
    [I(203,128)] = {64,0},
    [I(204,128)] = {64,0},
    [I(205,128)] = {64,0},
    [I(206,128)] = {64,0},
    [I(207,128)] = {64,0},
    [I(208,128)] = {64,0},
    [I(209,128)] = {64,0},
    [I(210,128)] = {64,0},
    [I(211,128)] = {64,0},
    [I(212,128)] = {64,0},
    [I(213,128)] = {64,0},
    [I(214,128)] = {64,0},
    [I(215,128)] = {64,0},
    [I(216,128)] = {64,0},
    [I(217,128)] = {64,0},
    [I(218,128)] = {64,0},
    [I(219,128)] = {64,0},
    [I(220,128)] = {64,0},
    [I(221,128)] = {64,0},
    [I(222,128)] = {64,0},
    [I(223,128)] = {64,0},
    [I(224,128)] = {64,0},
    [I(225,128)] = {64,0},
    [I(226,128)] = {64,0},
    [I(227,128)] = {64,0},
    [I(228,128)] = {64,0},
    [I(229,128)] = {64,0},
    [I(230,128)] = {64,0},
    [I(231,128)] = {64,0},
    [I(232,128)] = {64,0},
    [I(233,128)] = {64,0},
    [I(234,128)] = {64,0},
    [I(235,128)] = {64,0},
    [I(236,128)] = {64,0},
    [I(237,128)] = {64,0},
    [I(238,128)] = {64,0},
    [I(239,128)] = {64,0},
    [I(240,128)] = {64,0},
    [I(241,128)] = {64,0},
    [I(242,128)] = {64,0},
    [I(243,128)] = {64,0},
    [I(244,128)] = {64,0},
    [I(245,128)] = {64,0},
    [I(246,128)] = {64,0},
    [I(247,128)] = {64,0},
    [I(248,128)] = {64,0},
    [I(249,128)] = {64,0},
    [I(250,128)] = {64,0},
    [I(251,128)] = {64,0},
    [I(252,128)] = {64,0},
    [I(253,128)] = {64,0},
    [I(254,128)] = {64,0},
    [I(255,128)] = {64,0},
    [I(0,129)] = {64,0},
    [I(1,129)] = {64,0},
    [I(2,129)] = {64,0},
    [I(3,129)] = {64,0},
    [I(4,129)] = {64,0},
    [I(5,129)] = {64,0},
    [I(6,129)] = {64,0},
    [I(7,129)] = {64,0},
    [I(8,129)] = {64,0},
    [I(9,129)] = {64,0},
    [I(10,129)] = {64,0},
    [I(11,129)] = {64,0},
    [I(12,129)] = {64,0},
    [I(13,129)] = {64,0},
    [I(14,129)] = {64,0},
    [I(15,129)] = {64,0},
    [I(16,129)] = {64,0},
    [I(17,129)] = {64,0},
    [I(18,129)] = {64,0},
    [I(19,129)] = {64,0},
    [I(20,129)] = {64,0},
    [I(21,129)] = {64,0},
    [I(22,129)] = {64,0},
    [I(23,129)] = {64,0},
    [I(24,129)] = {64,0},
    [I(25,129)] = {64,0},
    [I(26,129)] = {64,0},
    [I(27,129)] = {64,0},
    [I(28,129)] = {64,0},
    [I(29,129)] = {64,0},
    [I(30,129)] = {64,0},
    [I(31,129)] = {64,0},
    [I(32,129)] = {28,0x53FFFD2},
    [I(33,129)] = {X32,0xFE3FFFD2},
    [I(34,129)] = {X32,0xFE7FFFD2},
    [I(35,129)] = {64,0},
    [I(36,129)] = {64,0},
    [I(37,129)] = {28,0x57FFFD2},
    [I(38,129)] = {30,0x3E3FFFD2},
    [I(39,129)] = {64,0},
    [I(40,129)] = {X32,0xFEBFFFD2},
    [I(41,129)] = {X32,0xFEFFFFD2},
    [I(42,129)] = {30,0x3E7FFFD2},
    [I(43,129)] = {64,0},
    [I(44,129)] = {30,0x3EBFFFD2},
    [I(45,129)] = {28,0x5BFFFD2},
    [I(46,129)] = {28,0x5FFFFD2},
    [I(47,129)] = {28,0x63FFFD2},
    [I(48,129)] = {27,0x3FFFD2},
    [I(49,129)] = {27,0x7FFFD2},
    [I(50,129)] = {27,0xBFFFD2},
    [I(51,129)] = {28,0x67FFFD2},
    [I(52,129)] = {28,0x6BFFFD2},
    [I(53,129)] = {28,0x6FFFFD2},
    [I(54,129)] = {28,0x73FFFD2},
    [I(55,129)] = {28,0x77FFFD2},
    [I(56,129)] = {28,0x7BFFFD2},
    [I(57,129)] = {28,0x7FFFFD2},
    [I(58,129)] = {29,0x173FFFD2},
    [I(59,129)] = {30,0x3EFFFFD2},
    [I(60,129)] = {64,0},
    [I(61,129)] = {28,0x83FFFD2},
    [I(62,129)] = {64,0},
    [I(63,129)] = {X32,0xFF3FFFD2},
    [I(64,129)] = {64,0},
    [I(65,129)] = {28,0x87FFFD2},
    [I(66,129)] = {29,0x177FFFD2},
    [I(67,129)] = {29,0x17BFFFD2},
    [I(68,129)] = {29,0x17FFFFD2},
    [I(69,129)] = {29,0x183FFFD2},
    [I(70,129)] = {29,0x187FFFD2},
    [I(71,129)] = {29,0x18BFFFD2},
    [I(72,129)] = {29,0x18FFFFD2},
    [I(73,129)] = {29,0x193FFFD2},
    [I(74,129)] = {29,0x197FFFD2},
    [I(75,129)] = {29,0x19BFFFD2},
    [I(76,129)] = {29,0x19FFFFD2},
    [I(77,129)] = {29,0x1A3FFFD2},
    [I(78,129)] = {29,0x1A7FFFD2},
    [I(79,129)] = {29,0x1ABFFFD2},
    [I(80,129)] = {29,0x1AFFFFD2},
    [I(81,129)] = {29,0x1B3FFFD2},
    [I(82,129)] = {29,0x1B7FFFD2},
    [I(83,129)] = {29,0x1BBFFFD2},
    [I(84,129)] = {29,0x1BFFFFD2},
    [I(85,129)] = {29,0x1C3FFFD2},
    [I(86,129)] = {29,0x1C7FFFD2},
    [I(87,129)] = {29,0x1CBFFFD2},
    [I(88,129)] = {30,0x3F3FFFD2},
    [I(89,129)] = {29,0x1CFFFFD2},
    [I(90,129)] = {30,0x3F7FFFD2},
    [I(91,129)] = {64,0},
    [I(92,129)] = {64,0},
    [I(93,129)] = {64,0},
    [I(94,129)] = {64,0},
    [I(95,129)] = {28,0x8BFFFD2},
    [I(96,129)] = {64,0},
    [I(97,129)] = {27,0xFFFFD2},
    [I(98,129)] = {28,0x8FFFFD2},
    [I(99,129)] = {27,0x13FFFD2},
    [I(100,129)] = {28,0x93FFFD2},
    [I(101,129)] = {27,0x17FFFD2},
    [I(102,129)] = {28,0x97FFFD2},
    [I(103,129)] = {28,0x9BFFFD2},
    [I(104,129)] = {28,0x9FFFFD2},
    [I(105,129)] = {27,0x1BFFFD2},
    [I(106,129)] = {29,0x1D3FFFD2},
    [I(107,129)] = {29,0x1D7FFFD2},
    [I(108,129)] = {28,0xA3FFFD2},
    [I(109,129)] = {28,0xA7FFFD2},
    [I(110,129)] = {28,0xABFFFD2},
    [I(111,129)] = {27,0x1FFFFD2},
    [I(112,129)] = {28,0xAFFFFD2},
    [I(113,129)] = {29,0x1DBFFFD2},
    [I(114,129)] = {28,0xB3FFFD2},
    [I(115,129)] = {27,0x23FFFD2},
    [I(116,129)] = {27,0x27FFFD2},
    [I(117,129)] = {28,0xB7FFFD2},
    [I(118,129)] = {29,0x1DFFFFD2},
    [I(119,129)] = {29,0x1E3FFFD2},
    [I(120,129)] = {29,0x1E7FFFD2},
    [I(121,129)] = {29,0x1EBFFFD2},
    [I(122,129)] = {29,0x1EFFFFD2},
    [I(123,129)] = {64,0},
    [I(124,129)] = {64,0},
    [I(125,129)] = {64,0},
    [I(126,129)] = {64,0},
    [I(127,129)] = {64,0},
    [I(128,129)] = {64,0},
    [I(129,129)] = {64,0},
    [I(130,129)] = {64,0},
    [I(131,129)] = {64,0},
    [I(132,129)] = {64,0},
    [I(133,129)] = {64,0},
    [I(134,129)] = {64,0},
    [I(135,129)] = {64,0},
    [I(136,129)] = {64,0},
    [I(137,129)] = {64,0},
    [I(138,129)] = {64,0},
    [I(139,129)] = {64,0},
    [I(140,129)] = {64,0},
    [I(141,129)] = {64,0},
    [I(142,129)] = {64,0},
    [I(143,129)] = {64,0},
    [I(144,129)] = {64,0},
    [I(145,129)] = {64,0},
    [I(146,129)] = {64,0},
    [I(147,129)] = {64,0},
    [I(148,129)] = {64,0},
    [I(149,129)] = {64,0},
    [I(150,129)] = {64,0},
    [I(151,129)] = {64,0},
    [I(152,129)] = {64,0},
    [I(153,129)] = {64,0},
    [I(154,129)] = {64,0},
    [I(155,129)] = {64,0},
    [I(156,129)] = {64,0},
    [I(157,129)] = {64,0},
    [I(158,129)] = {64,0},
    [I(159,129)] = {64,0},
    [I(160,129)] = {64,0},
    [I(161,129)] = {64,0},
    [I(162,129)] = {64,0},
    [I(163,129)] = {64,0},
    [I(164,129)] = {64,0},
    [I(165,129)] = {64,0},
    [I(166,129)] = {64,0},
    [I(167,129)] = {64,0},
    [I(168,129)] = {64,0},
    [I(169,129)] = {64,0},
    [I(170,129)] = {64,0},
    [I(171,129)] = {64,0},
    [I(172,129)] = {64,0},
    [I(173,129)] = {64,0},
    [I(174,129)] = {64,0},
    [I(175,129)] = {64,0},
    [I(176,129)] = {64,0},
    [I(177,129)] = {64,0},
    [I(178,129)] = {64,0},
    [I(179,129)] = {64,0},
    [I(180,129)] = {64,0},
    [I(181,129)] = {64,0},
    [I(182,129)] = {64,0},
    [I(183,129)] = {64,0},
    [I(184,129)] = {64,0},
    [I(185,129)] = {64,0},
    [I(186,129)] = {64,0},
    [I(187,129)] = {64,0},
    [I(188,129)] = {64,0},
    [I(189,129)] = {64,0},
    [I(190,129)] = {64,0},
    [I(191,129)] = {64,0},
    [I(192,129)] = {64,0},
    [I(193,129)] = {64,0},
    [I(194,129)] = {64,0},
    [I(195,129)] = {64,0},
    [I(196,129)] = {64,0},
    [I(197,129)] = {64,0},
    [I(198,129)] = {64,0},
    [I(199,129)] = {64,0},
    [I(200,129)] = {64,0},
    [I(201,129)] = {64,0},
    [I(202,129)] = {64,0},
    [I(203,129)] = {64,0},
    [I(204,129)] = {64,0},
    [I(205,129)] = {64,0},
    [I(206,129)] = {64,0},
    [I(207,129)] = {64,0},
    [I(208,129)] = {64,0},
    [I(209,129)] = {64,0},
    [I(210,129)] = {64,0},
    [I(211,129)] = {64,0},
    [I(212,129)] = {64,0},
    [I(213,129)] = {64,0},
    [I(214,129)] = {64,0},
    [I(215,129)] = {64,0},
    [I(216,129)] = {64,0},
    [I(217,129)] = {64,0},
    [I(218,129)] = {64,0},
    [I(219,129)] = {64,0},
    [I(220,129)] = {64,0},
    [I(221,129)] = {64,0},
    [I(222,129)] = {64,0},
    [I(223,129)] = {64,0},
    [I(224,129)] = {64,0},
    [I(225,129)] = {64,0},
    [I(226,129)] = {64,0},
    [I(227,129)] = {64,0},
    [I(228,129)] = {64,0},
    [I(229,129)] = {64,0},
    [I(230,129)] = {64,0},
    [I(231,129)] = {64,0},
    [I(232,129)] = {64,0},
    [I(233,129)] = {64,0},
    [I(234,129)] = {64,0},
    [I(235,129)] = {64,0},
    [I(236,129)] = {64,0},
    [I(237,129)] = {64,0},
    [I(238,129)] = {64,0},
    [I(239,129)] = {64,0},
    [I(240,129)] = {64,0},
    [I(241,129)] = {64,0},
    [I(242,129)] = {64,0},
    [I(243,129)] = {64,0},
    [I(244,129)] = {64,0},
    [I(245,129)] = {64,0},
    [I(246,129)] = {64,0},
    [I(247,129)] = {64,0},
    [I(248,129)] = {64,0},
    [I(249,129)] = {64,0},
    [I(250,129)] = {64,0},
    [I(251,129)] = {64,0},
    [I(252,129)] = {64,0},
    [I(253,129)] = {64,0},
    [I(254,129)] = {64,0},
    [I(255,129)] = {64,0},
    [I(0,130)] = {64,0},
    [I(1,130)] = {64,0},
    [I(2,130)] = {64,0},
    [I(3,130)] = {64,0},
    [I(4,130)] = {64,0},
    [I(5,130)] = {64,0},
    [I(6,130)] = {64,0},
    [I(7,130)] = {64,0},
    [I(8,130)] = {64,0},
    [I(9,130)] = {64,0},
    [I(10,130)] = {64,0},
    [I(11,130)] = {64,0},
    [I(12,130)] = {64,0},
    [I(13,130)] = {64,0},
    [I(14,130)] = {64,0},
    [I(15,130)] = {64,0},
    [I(16,130)] = {64,0},
    [I(17,130)] = {64,0},
    [I(18,130)] = {64,0},
    [I(19,130)] = {64,0},
    [I(20,130)] = {64,0},
    [I(21,130)] = {64,0},
    [I(22,130)] = {64,0},
    [I(23,130)] = {64,0},
    [I(24,130)] = {64,0},
    [I(25,130)] = {64,0},
    [I(26,130)] = {64,0},
    [I(27,130)] = {64,0},
    [I(28,130)] = {64,0},
    [I(29,130)] = {64,0},
    [I(30,130)] = {64,0},
    [I(31,130)] = {64,0},
    [I(32,130)] = {26,0x14FFFE7},
    [I(33,130)] = {30,0x3F8FFFE7},
    [I(34,130)] = {30,0x3F9FFFE7},
    [I(35,130)] = {X32,0xFFAFFFE7},
    [I(36,130)] = {64,0},
    [I(37,130)] = {26,0x15FFFE7},
    [I(38,130)] = {28,0xF8FFFE7},
    [I(39,130)] = {31,0x7FAFFFE7},
    [I(40,130)] = {30,0x3FAFFFE7},
    [I(41,130)] = {30,0x3FBFFFE7},
    [I(42,130)] = {28,0xF9FFFE7},
    [I(43,130)] = {31,0x7FBFFFE7},
    [I(44,130)] = {28,0xFAFFFE7},
    [I(45,130)] = {26,0x16FFFE7},
    [I(46,130)] = {26,0x17FFFE7},
    [I(47,130)] = {26,0x18FFFE7},
    [I(48,130)] = {25,0xFFFE7},
    [I(49,130)] = {25,0x1FFFE7},
    [I(50,130)] = {25,0x2FFFE7},
    [I(51,130)] = {26,0x19FFFE7},
    [I(52,130)] = {26,0x1AFFFE7},
    [I(53,130)] = {26,0x1BFFFE7},
    [I(54,130)] = {26,0x1CFFFE7},
    [I(55,130)] = {26,0x1DFFFE7},
    [I(56,130)] = {26,0x1EFFFE7},
    [I(57,130)] = {26,0x1FFFFE7},
    [I(58,130)] = {27,0x5CFFFE7},
    [I(59,130)] = {28,0xFBFFFE7},
    [I(60,130)] = {64,0},
    [I(61,130)] = {26,0x20FFFE7},
    [I(62,130)] = {X32,0xFFBFFFE7},
    [I(63,130)] = {30,0x3FCFFFE7},
    [I(64,130)] = {64,0},
    [I(65,130)] = {26,0x21FFFE7},
    [I(66,130)] = {27,0x5DFFFE7},
    [I(67,130)] = {27,0x5EFFFE7},
    [I(68,130)] = {27,0x5FFFFE7},
    [I(69,130)] = {27,0x60FFFE7},
    [I(70,130)] = {27,0x61FFFE7},
    [I(71,130)] = {27,0x62FFFE7},
    [I(72,130)] = {27,0x63FFFE7},
    [I(73,130)] = {27,0x64FFFE7},
    [I(74,130)] = {27,0x65FFFE7},
    [I(75,130)] = {27,0x66FFFE7},
    [I(76,130)] = {27,0x67FFFE7},
    [I(77,130)] = {27,0x68FFFE7},
    [I(78,130)] = {27,0x69FFFE7},
    [I(79,130)] = {27,0x6AFFFE7},
    [I(80,130)] = {27,0x6BFFFE7},
    [I(81,130)] = {27,0x6CFFFE7},
    [I(82,130)] = {27,0x6DFFFE7},
    [I(83,130)] = {27,0x6EFFFE7},
    [I(84,130)] = {27,0x6FFFFE7},
    [I(85,130)] = {27,0x70FFFE7},
    [I(86,130)] = {27,0x71FFFE7},
    [I(87,130)] = {27,0x72FFFE7},
    [I(88,130)] = {28,0xFCFFFE7},
    [I(89,130)] = {27,0x73FFFE7},
    [I(90,130)] = {28,0xFDFFFE7},
    [I(91,130)] = {64,0},
    [I(92,130)] = {64,0},
    [I(93,130)] = {64,0},
    [I(94,130)] = {64,0},
    [I(95,130)] = {26,0x22FFFE7},
    [I(96,130)] = {64,0},
    [I(97,130)] = {25,0x3FFFE7},
    [I(98,130)] = {26,0x23FFFE7},
    [I(99,130)] = {25,0x4FFFE7},
    [I(100,130)] = {26,0x24FFFE7},
    [I(101,130)] = {25,0x5FFFE7},
    [I(102,130)] = {26,0x25FFFE7},
    [I(103,130)] = {26,0x26FFFE7},
    [I(104,130)] = {26,0x27FFFE7},
    [I(105,130)] = {25,0x6FFFE7},
    [I(106,130)] = {27,0x74FFFE7},
    [I(107,130)] = {27,0x75FFFE7},
    [I(108,130)] = {26,0x28FFFE7},
    [I(109,130)] = {26,0x29FFFE7},
    [I(110,130)] = {26,0x2AFFFE7},
    [I(111,130)] = {25,0x7FFFE7},
    [I(112,130)] = {26,0x2BFFFE7},
    [I(113,130)] = {27,0x76FFFE7},
    [I(114,130)] = {26,0x2CFFFE7},
    [I(115,130)] = {25,0x8FFFE7},
    [I(116,130)] = {25,0x9FFFE7},
    [I(117,130)] = {26,0x2DFFFE7},
    [I(118,130)] = {27,0x77FFFE7},
    [I(119,130)] = {27,0x78FFFE7},
    [I(120,130)] = {27,0x79FFFE7},
    [I(121,130)] = {27,0x7AFFFE7},
    [I(122,130)] = {27,0x7BFFFE7},
    [I(123,130)] = {64,0},
    [I(124,130)] = {31,0x7FCFFFE7},
    [I(125,130)] = {64,0},
    [I(126,130)] = {64,0},
    [I(127,130)] = {64,0},
    [I(128,130)] = {64,0},
    [I(129,130)] = {64,0},
    [I(130,130)] = {64,0},
    [I(131,130)] = {64,0},
    [I(132,130)] = {64,0},
    [I(133,130)] = {64,0},
    [I(134,130)] = {64,0},
    [I(135,130)] = {64,0},
    [I(136,130)] = {64,0},
    [I(137,130)] = {64,0},
    [I(138,130)] = {64,0},
    [I(139,130)] = {64,0},
    [I(140,130)] = {64,0},
    [I(141,130)] = {64,0},
    [I(142,130)] = {64,0},
    [I(143,130)] = {64,0},
    [I(144,130)] = {64,0},
    [I(145,130)] = {64,0},
    [I(146,130)] = {64,0},
    [I(147,130)] = {64,0},
    [I(148,130)] = {64,0},
    [I(149,130)] = {64,0},
    [I(150,130)] = {64,0},
    [I(151,130)] = {64,0},
    [I(152,130)] = {64,0},
    [I(153,130)] = {64,0},
    [I(154,130)] = {64,0},
    [I(155,130)] = {64,0},
    [I(156,130)] = {64,0},
    [I(157,130)] = {64,0},
    [I(158,130)] = {64,0},
    [I(159,130)] = {64,0},
    [I(160,130)] = {64,0},
    [I(161,130)] = {64,0},
    [I(162,130)] = {64,0},
    [I(163,130)] = {64,0},
    [I(164,130)] = {64,0},
    [I(165,130)] = {64,0},
    [I(166,130)] = {64,0},
    [I(167,130)] = {64,0},
    [I(168,130)] = {64,0},
    [I(169,130)] = {64,0},
    [I(170,130)] = {64,0},
    [I(171,130)] = {64,0},
    [I(172,130)] = {64,0},
    [I(173,130)] = {64,0},
    [I(174,130)] = {64,0},
    [I(175,130)] = {64,0},
    [I(176,130)] = {64,0},
    [I(177,130)] = {64,0},
    [I(178,130)] = {64,0},
    [I(179,130)] = {64,0},
    [I(180,130)] = {64,0},
    [I(181,130)] = {64,0},
    [I(182,130)] = {64,0},
    [I(183,130)] = {64,0},
    [I(184,130)] = {64,0},
    [I(185,130)] = {64,0},
    [I(186,130)] = {64,0},
    [I(187,130)] = {64,0},
    [I(188,130)] = {64,0},
    [I(189,130)] = {64,0},
    [I(190,130)] = {64,0},
    [I(191,130)] = {64,0},
    [I(192,130)] = {64,0},
    [I(193,130)] = {64,0},
    [I(194,130)] = {64,0},
    [I(195,130)] = {64,0},
    [I(196,130)] = {64,0},
    [I(197,130)] = {64,0},
    [I(198,130)] = {64,0},
    [I(199,130)] = {64,0},
    [I(200,130)] = {64,0},
    [I(201,130)] = {64,0},
    [I(202,130)] = {64,0},
    [I(203,130)] = {64,0},
    [I(204,130)] = {64,0},
    [I(205,130)] = {64,0},
    [I(206,130)] = {64,0},
    [I(207,130)] = {64,0},
    [I(208,130)] = {64,0},
    [I(209,130)] = {64,0},
    [I(210,130)] = {64,0},
    [I(211,130)] = {64,0},
    [I(212,130)] = {64,0},
    [I(213,130)] = {64,0},
    [I(214,130)] = {64,0},
    [I(215,130)] = {64,0},
    [I(216,130)] = {64,0},
    [I(217,130)] = {64,0},
    [I(218,130)] = {64,0},
    [I(219,130)] = {64,0},
    [I(220,130)] = {64,0},
    [I(221,130)] = {64,0},
    [I(222,130)] = {64,0},
    [I(223,130)] = {64,0},
    [I(224,130)] = {64,0},
    [I(225,130)] = {64,0},
    [I(226,130)] = {64,0},
    [I(227,130)] = {64,0},
    [I(228,130)] = {64,0},
    [I(229,130)] = {64,0},
    [I(230,130)] = {64,0},
    [I(231,130)] = {64,0},
    [I(232,130)] = {64,0},
    [I(233,130)] = {64,0},
    [I(234,130)] = {64,0},
    [I(235,130)] = {64,0},
    [I(236,130)] = {64,0},
    [I(237,130)] = {64,0},
    [I(238,130)] = {64,0},
    [I(239,130)] = {64,0},
    [I(240,130)] = {64,0},
    [I(241,130)] = {64,0},
    [I(242,130)] = {64,0},
    [I(243,130)] = {64,0},
    [I(244,130)] = {64,0},
    [I(245,130)] = {64,0},
    [I(246,130)] = {64,0},
    [I(247,130)] = {64,0},
    [I(248,130)] = {64,0},
    [I(249,130)] = {64,0},
    [I(250,130)] = {64,0},
    [I(251,130)] = {64,0},
    [I(252,130)] = {64,0},
    [I(253,130)] = {64,0},
    [I(254,130)] = {64,0},
    [I(255,130)] = {64,0},
    [I(0,131)] = {64,0},
    [I(1,131)] = {64,0},
    [I(2,131)] = {64,0},
    [I(3,131)] = {64,0},
    [I(4,131)] = {64,0},
    [I(5,131)] = {64,0},
    [I(6,131)] = {64,0},
    [I(7,131)] = {64,0},
    [I(8,131)] = {64,0},
    [I(9,131)] = {64,0},
    [I(10,131)] = {64,0},
    [I(11,131)] = {64,0},
    [I(12,131)] = {64,0},
    [I(13,131)] = {64,0},
    [I(14,131)] = {64,0},
    [I(15,131)] = {64,0},
    [I(16,131)] = {64,0},
    [I(17,131)] = {64,0},
    [I(18,131)] = {64,0},
    [I(19,131)] = {64,0},
    [I(20,131)] = {64,0},
    [I(21,131)] = {64,0},
    [I(22,131)] = {64,0},
    [I(23,131)] = {64,0},
    [I(24,131)] = {64,0},
    [I(25,131)] = {64,0},
    [I(26,131)] = {64,0},
    [I(27,131)] = {64,0},
    [I(28,131)] = {64,0},
    [I(29,131)] = {64,0},
    [I(30,131)] = {64,0},
    [I(31,131)] = {64,0},
    [I(32,131)] = {26,0x14FFFE8},
    [I(33,131)] = {30,0x3F8FFFE8},
    [I(34,131)] = {30,0x3F9FFFE8},
    [I(35,131)] = {X32,0xFFAFFFE8},
    [I(36,131)] = {64,0},
    [I(37,131)] = {26,0x15FFFE8},
    [I(38,131)] = {28,0xF8FFFE8},
    [I(39,131)] = {31,0x7FAFFFE8},
    [I(40,131)] = {30,0x3FAFFFE8},
    [I(41,131)] = {30,0x3FBFFFE8},
    [I(42,131)] = {28,0xF9FFFE8},
    [I(43,131)] = {31,0x7FBFFFE8},
    [I(44,131)] = {28,0xFAFFFE8},
    [I(45,131)] = {26,0x16FFFE8},
    [I(46,131)] = {26,0x17FFFE8},
    [I(47,131)] = {26,0x18FFFE8},
    [I(48,131)] = {25,0xFFFE8},
    [I(49,131)] = {25,0x1FFFE8},
    [I(50,131)] = {25,0x2FFFE8},
    [I(51,131)] = {26,0x19FFFE8},
    [I(52,131)] = {26,0x1AFFFE8},
    [I(53,131)] = {26,0x1BFFFE8},
    [I(54,131)] = {26,0x1CFFFE8},
    [I(55,131)] = {26,0x1DFFFE8},
    [I(56,131)] = {26,0x1EFFFE8},
    [I(57,131)] = {26,0x1FFFFE8},
    [I(58,131)] = {27,0x5CFFFE8},
    [I(59,131)] = {28,0xFBFFFE8},
    [I(60,131)] = {64,0},
    [I(61,131)] = {26,0x20FFFE8},
    [I(62,131)] = {X32,0xFFBFFFE8},
    [I(63,131)] = {30,0x3FCFFFE8},
    [I(64,131)] = {64,0},
    [I(65,131)] = {26,0x21FFFE8},
    [I(66,131)] = {27,0x5DFFFE8},
    [I(67,131)] = {27,0x5EFFFE8},
    [I(68,131)] = {27,0x5FFFFE8},
    [I(69,131)] = {27,0x60FFFE8},
    [I(70,131)] = {27,0x61FFFE8},
    [I(71,131)] = {27,0x62FFFE8},
    [I(72,131)] = {27,0x63FFFE8},
    [I(73,131)] = {27,0x64FFFE8},
    [I(74,131)] = {27,0x65FFFE8},
    [I(75,131)] = {27,0x66FFFE8},
    [I(76,131)] = {27,0x67FFFE8},
    [I(77,131)] = {27,0x68FFFE8},
    [I(78,131)] = {27,0x69FFFE8},
    [I(79,131)] = {27,0x6AFFFE8},
    [I(80,131)] = {27,0x6BFFFE8},
    [I(81,131)] = {27,0x6CFFFE8},
    [I(82,131)] = {27,0x6DFFFE8},
    [I(83,131)] = {27,0x6EFFFE8},
    [I(84,131)] = {27,0x6FFFFE8},
    [I(85,131)] = {27,0x70FFFE8},
    [I(86,131)] = {27,0x71FFFE8},
    [I(87,131)] = {27,0x72FFFE8},
    [I(88,131)] = {28,0xFCFFFE8},
    [I(89,131)] = {27,0x73FFFE8},
    [I(90,131)] = {28,0xFDFFFE8},
    [I(91,131)] = {64,0},
    [I(92,131)] = {64,0},
    [I(93,131)] = {64,0},
    [I(94,131)] = {64,0},
    [I(95,131)] = {26,0x22FFFE8},
    [I(96,131)] = {64,0},
    [I(97,131)] = {25,0x3FFFE8},
    [I(98,131)] = {26,0x23FFFE8},
    [I(99,131)] = {25,0x4FFFE8},
    [I(100,131)] = {26,0x24FFFE8},
    [I(10