#!/bin/sh

#################################
#
# DirectAdmin User Jailing Script
#
# Usage: jail_user.sh username
#
# The use must already exist
#
#################################

OS=`uname`

JAILED_SHELL=/bin/jail
if [ $OS = "FreeBSD" ]; then
	USER_SHELL=/bin/sh
else
	USER_SHELL=/bin/bash
fi

JAIL_DIR=/usr/local/directadmin/custombuild/jail
FILE_LIST=$JAIL_DIR/files.list
SU=$JAIL_DIR/su
SENDMAIL=$JAIL_DIR/sendmail
NBSMTP=$JAIL_DIR/nbsmtp
SUDOERS=/etc/sudoers
USE_SUDOERS=0

if [ $# = 0 ]; then

	echo "Usage:";
	echo " $0 <username>";
	echo "The user must already exist";
	exit 1;
fi

/usr/bin/id $1 1>/dev/null 2>/dev/null

if [ $? != 0 ]; then
	echo "Cannot find user $1";
	exit 2;
fi

if [ "$1" = "root" ]; then
	echo "Are you nuts? Jailing root is a bad idea."
	exit 3;
fi

STR="cd ~$1"
eval $STR

USER_HOME=`pwd`

if [ "$USER_HOME" = "" ]; then
	echo "User's home was empty";
	exit 4;
fi

mkdir -p $USER_HOME/etc
mkdir -p $USER_HOME/bin
mkdir -p $USER_HOME/usr/bin
mkdir -p $USER_HOME/usr/sbin
mkdir -p $USER_HOME/sbin
mkdir -p $USER_HOME/lib
mkdir -p $USER_HOME/tmp
mkdir -p $USER_HOME/var/tmp
chmod 1777 $USER_HOME/tmp
chmod 1777 $USER_HOME/var/tmp
mkdir -p $USER_HOME/lib/tls
mkdir -p $USER_HOME/usr/lib
#mkdir -p $USER_HOME/$USER_HOME
if [ ! -e $USER_HOME/$USER_HOME ]; then
	# Ok, we can't assume it's in /home, so create
	# all directory paths like before, then delete the users home
	# then create the symbolic link. If we didn't
	# create the full path first, there might be
	# missing directories if they've got a weird home path.
	mkdir -p $USER_HOME$USER_HOME
	rm -rf $USER_HOME$USER_HOME
	ln -sf .. $USER_HOME$USER_HOME
fi
mkdir -p $USER_HOME/etc/profile.d
mkdir -p $USER_HOME/usr/X11R6/bin
mkdir -p $USER_HOME/usr/X11R6/lib
mkdir -p $USER_HOME/usr/local/bin
mkdir -p $USER_HOME/usr/local/lib
mkdir -p $USER_HOME/usr/kerberos/lib
mkdir -p $USER_HOME/usr/libexec
mkdir -p $USER_HOME/usr/libexec/openssh
mkdir -p $USER_HOME/usr/share/misc
mkdir -p $USER_HOME/usr/local/pgsql/lib
mkdir -p $USER_HOME/usr/share/terminfo/v

PERL_VERSION=`perl -v | awk '/perl,/ { print $4 }' | awk --field-separator=v '{ print $2 }'`
if [ -e /usr/lib/perl5/$PERL_VERSION/i386-linux-thread-multi/CORE ]; then
	mkdir -p $USER_HOME/usr/lib/perl5/$PERL_VERSION/i386-linux-thread-multi/CORE
fi

if [ -e /usr/lib/perl5/5.8.0/i386-linux-thread-multi/CORE ]; then
	mkdir -p $USER_HOME/usr/lib/perl5/5.8.0/i386-linux-thread-multi/CORE
fi
if [ -e /usr/lib/perl5/5.8.3/i386-linux-thread-multi/CORE ]; then
	mkdir -p $USER_HOME/usr/lib/perl5/5.8.3/i386-linux-thread-multi/CORE
fi
if [ -e /usr/lib64/perl5/5.8.5/x86_64-linux-thread-multi/CORE ]; then
	mkdir -p $USER_HOME/usr/lib64/perl5/5.8.5/x86_64-linux-thread-multi/CORE
fi
if [ -e /lib/tls/i586 ]; then
	mkdir -p $USER_HOME/lib/tls/i586
fi
if [ -e /lib/i686 ]; then
	mkdir -p $USER_HOME/lib/i686
fi
if [ -e /lib64 ]; then
	mkdir -p $USER_HOME/lib64/tls
fi
if [ -e /usr/lib64 ]; then
	mkdir -p $USER_HOME/usr/lib64
fi

chown $1:$1 $USER_HOME$USER_HOME

#################################
#
# 1) files
#	/etc/passwd
#	/etc/shadow
#	/etc/group
#	/etc/pwdb.conf
#

#################
# Create /etc/passwd

FILE=$USER_HOME/etc/passwd
rm -f $FILE;
echo "`cat /etc/passwd | grep -e "^root:"`" > $FILE;
echo "`cat /etc/passwd | grep -e "^apache:"`" >> $FILE;
echo "`cat /etc/passwd | grep -e "^$1:" | cut -d: -f1,2,3,4,5,6`:$USER_SHELL" >> $FILE;
chmod 644 $FILE;

#################
# create /etc/shadow
SHDW=/etc/shadow
if [ $OS = "FreeBSD" ]; then
	SHDW=/etc/master.passwd
fi

FILE=${USER_HOME}${SHDW}

rm -f $FILE;
if [ $OS = "FreeBSD" ];
then
	echo "root:*:0:0::0:0:Charlie &:/root:" >> $FILE;
	echo "`cat $SHDW | grep -e "^$1:" | cut -d: -f1,2,3,4,5,6,7,8,9`:$USER_SHELL" >> $FILE;
else
	echo `cat $SHDW | grep -e "^$1:"` >> $FILE;	
fi
chmod 644 $FILE;

#################
# create /etc/group

FILE=$USER_HOME/etc/group
rm -f $FILE;
echo "`cat /etc/group | grep -e "^root:"`" > $FILE;
echo "`cat /etc/group | grep -e "^$1:"`" >> $FILE;
chmod 644 $FILE;

#make password databases
if [ $OS = "FreeBSD" ]; then
	/usr/sbin/pwd_mkdb -d $USER_HOME/etc ${USER_HOME}${SHDW}
fi

# Used to copy program dependancies
# copyDependancies file new_root
copyDependancies()
{
	for i in `/usr/bin/ldd $1 2>/dev/null`; do
	{
		if [ -e "$i" ] && [ ! -e "$2/$i" ]; then
			copyFile $i $2;
		fi
	};
	done;
}

# Used to copy a file to a user home directory.
# copyFile name new_root
copyFile()
{
	if [ ! -e $1 ]; then
		return;
	fi

	if [ -e $2/$1 ]; then
		return;
	fi

        #copy the directory
        if [ -d $1 ]; then
		cp -pRL $1 $2$1
		return;
        fi

	#echo "copy $1 to $2";
	cp -p $1 $2$1

	if [ -x $1 ]; then
		copyDependancies $1 $2
	fi
}



for i in `cat $FILE_LIST`; do
{
	copyFile $i $USER_HOME;
};
done;

copyFile $USER_HOME/.bashrc $USER_HOME
if [ -e /etc/inputrc ]; then
	cp -f /etc/inputrc $USER_HOME/$USER_HOME/.inputrc
	chown $1:$1 $USER_HOME/$USER_HOME/.inputrc
fi

cp -f $SU $USER_HOME/bin/su
copyDependancies $SU $USER_HOME

cp -f $SENDMAIL $USER_HOME/usr/sbin/sendmail
STR="perl -pi -e 's/USERNAME/$1/' $USER_HOME/usr/sbin/sendmail"
eval $STR;
ln -sf ../sbin/sendmail $USER_HOME/usr/lib/sendmail

cp -f $NBSMTP $USER_HOME/usr/sbin/nbsmtp
copyDependancies $NBSMTP $USER_HOME

#######################
### create .bash_profile
FILE=$USER_HOME/$USER_HOME/.bash_profile
echo "# .bash_profile" > $FILE;
echo "" >> $FILE;
echo "# Get the aliases and functions" >> $FILE;
echo "if [ -f ~/.bashrc ]; then" >> $FILE;
echo "   . ~/.bashrc" >> $FILE;
echo "fi" >> $FILE;
echo "" >> $FILE;
echo "# User specific environment and startup programs" >> $FILE;
echo "" >> $FILE;
echo 'PATH=$PATH:$HOME/bin:/sbin' >> $FILE;
echo 'BASH_ENV=$HOME/.bashrc' >> $FILE;
echo "USERNAME=\"$1\"" >> $FILE;
echo "" >> $FILE;
echo "export USERNAME BASH_ENV PATH LS_COLORS" >> $FILE;
chown $1:$1 $FILE;

#########################
# create .Xdefaults
#FILE=$USER_HOME/$USER_HOME/.Xdefaults
#echo '*VT100.Translations: #override \' > $FILE;
#echo '              <Key>BackSpace: string(0x7F)\n\' >> $FILE;
#echo '              <Key>Delete:    string("\033[3~")\n\' >> $FILE;
#echo '              <Key>Home:      string("\033[1~")\n\' >> $FILE;
#echo '              <Key>End:       string("\033[4~")' >> $FILE;
#echo '*ttyModes: erase ^? ' >> $FILE;
#chown $1:$1 $FILE;



############################################
# Modify their real shell to the jailed one

if [ $OS = "FreeBSD" ]; then
	/usr/bin/chpass -s $JAILED_SHELL $1
else
	/usr/sbin/usermod -s $JAILED_SHELL $1
fi

###########################################
# Add to the /etc/sudoers file (check first)
if [ $USE_SUDOERS -eq 1 ]; then
	COUNT=`cat $SUDOERS | grep -c -e "^$1\b"`
	if [ $COUNT = 0 ]; then
		echo -e "$1\tALL= NOPASSWD: /usr/sbin/chroot $USER_HOME /bin/su - $1*" >> $SUDOERS
	fi
fi
