<?php 

global $_tipsdb;

$_tipsdb['CACertFile'] = new DAttrHelp("CA Certificate File", 'Specifies the file that contains all certificates of certification authorities (CAs) for chained certificates. This file is simply the concatenation of PEM-encoded certificate files, in order of preference. This can be used as an alternative or in addition to &quot;CA Certificate Path&quot;. Those certificates are used for client certificate authentication and constructing the server certificate chain, which will be sent to browsers in addition to the server certificate.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['CACertPath'] = new DAttrHelp("CA Certificate Path", 'Specifies the directory where the certificates of certification authorities (CAs) are kept. Those certificates are used for client certificate authentication and constructing the server certificate chain, which will be sent to browsers in addition to the server certificate.', '', 'path', '');

$_tipsdb['CGIPriority'] = new DAttrHelp("CGI Priority", 'Specifies priority of the external application process. Value ranges from -20 to 20. A lower number means a higher priority.<br/><br/>A CGI process cannot have a higher priority than the web server. If this priority is set to a lower number than the server&#039;s, the server&#039;s priority will be used for this value.', '', 'int', '');

$_tipsdb['CPUHardLimit'] = new DAttrHelp("CPU Hard Limit", 'Specifies maximum CPU consumption time limit in seconds for a CGI process.  If the process continues to consume CPU time and reach the hard limit, the process  will be force killed. The operating system&#039;s default setting will be used if the value is absent or set to 0.', '', 'Integer number', '');

$_tipsdb['CPUSoftLimit'] = new DAttrHelp("CPU Soft Limit (sec)", 'Specifies CPU consumption time limit in seconds for a CGI process. When the process  reaches the soft limit, it will be notified by a signal. The operating system&#039;s default setting will  be used if the value is absent or set to 0.', '', 'Integer number', '');

$_tipsdb['DHParam'] = new DAttrHelp("DH Parameter", 'Specifies the location of the Diffie-Hellman parameter file necessary for DH key exchange.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['GroupDBLocation'] = new DAttrHelp("Group DB Location", 'Specifies the location of the group database. <br/>Group information can be set either in the user database or in this standalone group DB. For user authentication, the user DB will be checked first. If the user DB also contains group information, then the group DB will not be checked. <br/><br/>For the DB type Password File, the group DB location should be the path to  the flat file containing group definitions. You can edit this file through the  WebAdmin console by clicking on the filename. <br/><br/>Each line of a group file should contain a groupname followed by a colon,   followed by space delimited group of usernames. Example:<br/><blockquote><code>testgroup: user1 user2 user3</code></blockquote> <br/>For the DB type LDAP, the group DB location should be the LDAP URL to query  for group information. For each valid group, one and only one record should be returned in the LDAP search request based on  this URL and the group name specified in &quot;Require (Authorized Users/Groups)&quot;. &quot;$k&quot; must be specified in the filter part of the URL and it will be replaced with the group name. The name of the attribute that  specifies members in this group is specified by the &quot;Group Member Attribute&quot;.<br/><br/>Example: If objectClass posixGroup is being used to store group information. The following URL could be used: <br/><blockquote><code>ldap://localhost/ou=GroupDB,dc=example,dc=com???(&(objectClass=*)(cn=$k))</code></blockquote>', ' It is recommended to store a group file outside the document tree.  If it has to be placed inside document tree, simply name it with a leading &quot;.ht&quot;  like .htgroup, to prevent the file being served as a static file.  LiteSpeed Web Server  does not serve files prefixed with &quot;.ht&quot;.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.', '');

$_tipsdb['HANDLER_RESTART'] = new DAttrHelp("Hook::HANDLER_RESTART Priority", 'Sets the priority for this module callback within the HTTP Handler Restart Hook.<br/>   The HTTP Handler Restart Hook is triggered when the web server needs to discard the current response and start processing from beginning, for example, when an internal redirect has been requested.<br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['HTTP_AUTH'] = new DAttrHelp("Hook::HTTP_AUTH Priority", 'Sets the priority for this module callback within the HTTP Authentication Hook.<br/>  The HTTP Authentication Hook is triggered after resource mapping and before handler processing.  It occurs after HTTP built-in authentication, and can be used to perform additional authentication checking.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['HTTP_BEGIN'] = new DAttrHelp("Hook::HTTP_BEGIN Priority", 'Sets the priority for this module callback within the HTTP Begin Hook.<br/>   The HTTP Begin Hook is triggered when the TCP/IP connection begins an HTTP Session.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['HTTP_END'] = new DAttrHelp("Hook::HTTP_END Priority", 'Sets the priority for this module callback within the HTTP Session End Hook. <br/><br/>The HTTP Session End Hook is triggered when the HTTP connection has ended.     <br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['L4_BEGINSESSION'] = new DAttrHelp("Hook::L4_BEGINSESSION Priority", 'Sets the priority for this module callback within the L4 Begin Session Hook.<br/>  The L4 Begin Session Hook is triggered when the TCP/IP connection begins.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['L4_ENDSESSION'] = new DAttrHelp("Hook::L4_ENDSESSION Priority", 'Sets the priority for this module callback within the L4 End Session Hook.<br/>   The L4 End Session Hook is triggered when the TCP/IP connection ends.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['L4_RECVING'] = new DAttrHelp("Hook::L4_RECVING Priority", 'Sets the priority for this module callback within the L4 Receiving Hook.<br/>   The L4 Receiving Hook is triggered when the TCP/IP connection receives data.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['L4_SENDING'] = new DAttrHelp("Hook::L4_SENDING Priority", 'Sets the priority for this module callback within the L4 Sending Hook.<br/>  The L4 Sending Hook is triggered when the TCP/IP connection sends data.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['MAIN_ATEXIT'] = new DAttrHelp("Hook::MAIN_ATEXIT Priority", 'Sets the priority for this module callback within the Main At Exit Hook. <br/><br/>The Main At Exit Hook is triggered by the main (controller) process just prior to exiting. It is the last hook point to be called by the main process.   <br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['MAIN_INITED'] = new DAttrHelp("Hook::MAIN_INITED Priority", 'Sets the priority for this module callback within the Main Initialized Hook. <br/><br/>The Main Initialized Hook is triggered once upon startup, after the server configuration and  initialization is completed by the main (controller) process, and before any requests are serviced.   <br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['MAIN_POSTFORK'] = new DAttrHelp("Hook::MAIN_POSTFORK Priority", 'Sets the priority for this module callback within the Main Postfork Hook. <br/><br/>The Main Postfork Hook is triggered by the main (controller) process immediately after  a new worker process has been started (forked). This is called for each worker, and may happen during  system startup, or if a worker has been restarted.   <br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['MAIN_PREFORK'] = new DAttrHelp("Hook::MAIN_PREFORK Priority", 'Sets the priority for this module callback within the Main Prefork Hook. <br/><br/>The Main Prefork Hook is triggered by the main (controller) process immediately before  a new worker process is started (forked). This is called for each worker, and may happen during  system startup, or if a worker has been restarted.   <br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['RCVD_REQ_BODY'] = new DAttrHelp("Hook::RCVD_REQ_BODY Priority", 'Sets the priority for this module callback within the HTTP Received Request Body Hook.  <br/><br/>The HTTP Received Request Body Hook is triggered when the web server finishes receiving request body data.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['RCVD_RESP_BODY'] = new DAttrHelp("Hook::RCVD_RESP_BODY Priority", 'Sets the priority for this module callback within the HTTP Received Response Body Hook.  <br/><br/>The HTTP Received Response Body Hook is triggered when the web server backend finishes receiving the response body.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['RECV_REQ_BODY'] = new DAttrHelp("Hook::RECV_REQ_BODY Priority", 'Sets the priority for this module callback within the HTTP Receive Request Body Hook.  <br/><br/>The HTTP Receive Request Body Hook is triggered when the web server receives request body data.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['RECV_REQ_HEADER'] = new DAttrHelp("Hook::RECV_REQ_HEADER Priority", 'Sets the priority for this module callback within the HTTP Receive Request Header Hook.<br/>   The HTTP Receive Request Header Hook is triggered when the web server receives a request header.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['RECV_RESP_BODY'] = new DAttrHelp("Hook::RECV_RESP_BODY Priority", 'Sets the priority for this module callback within the HTTP Receive Response Body Hook.  <br/><br/>The HTTP Receive Response Body Hook is triggered when the web server backend receives the response body.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['RECV_RESP_HEADER'] = new DAttrHelp("Hook::RECV_RESP_HEADER Priority", 'Sets the priority for this module callback within the HTTP Receive Response Header Hook.  <br/><br/>The HTTP Receive Response Header Hook is triggered when the web server creates the response header.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['SEND_RESP_BODY'] = new DAttrHelp("Hook::SEND_RESP_BODY Priority", 'Sets the priority for this module callback within the HTTP Send Response Body Hook. <br/><br/>The HTTP Send Response Body Hook is triggered when the web server is going to send the response body.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['SEND_RESP_HEADER'] = new DAttrHelp("Hook::SEND_RESP_HEADER Priority", 'Sets the priority for this module callback within the HTTP Send Response Header Hook. <br/><br/>The HTTP Send Response Header Hook is triggered when the web server is ready to send the response header.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['URI_MAP'] = new DAttrHelp("Hook::URI_MAP Priority", 'Sets the priority for this module callback within the HTTP URI Map Hook.<br/>  The HTTP URI Map Hook is triggered when the web server maps a URI request to a context.  <br/><br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['VHlsrecaptcha'] = new DAttrHelp("reCaptcha Protection", 'reCaptcha Protection is a service provided as a way to mitigate heavy server load. reCaptcha Protection will activate after one of the below situations is hit. Once active, all requests by NON TRUSTED(as configured) clients will be redirected to a reCAPTCHA validation page. After validation, the client will be redirected to their desired page.<br/><br/>The following situations will activate reCaptcha Protection:<br/>1. The server or vhost concurrent requests count passes the configured connection limit.<br/>2. Anti-DDoS is enabled and a client is hitting a url in a suspicious manner. The client will redirect to reCAPTCHA first instead of getting denied when triggered.<br/>3. WP Brute Force protection is enabled and action is set to &#039;Captcha or Drop’. When a brute force attack is detected, the client will redirect to reCAPTCHA first. After max tries is reached, the connection will be dropped, as per the ‘drop’ option.<br/>4. A new rewrite rule environment is provided to activate reCAPTCHA via RewriteRules. &#039;verifycaptcha&#039; can be set to redirect clients to reCAPTCHA. A special value &#039;: deny&#039; can be set to deny the client if it failed too many times. For example, [E=verifycaptcha] will always redirect to reCAPTCHA until verified. [E=verifycaptcha: deny] will redirect to reCAPTCHA until Max Tries is hit, after which the client will be denied.', '', '', '');

$_tipsdb['WORKER_ATEXIT'] = new DAttrHelp("Hook::WORKER_ATEXIT Priority", 'Sets the priority for this module callback within the Worker At Exit Hook. <br/><br/>The Worker At Exit Hook is triggered by a worker process just prior to exiting. It is the last hook point to be called by a worker.   <br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['WORKER_POSTFORK'] = new DAttrHelp("Hook::WORKER_POSTFORK Priority", 'Sets the priority for this module callback within the Worker Postfork Hook. <br/><br/>The Worker Postfork Hook is triggered by a worker process after being created by the main (controller) process.  Note that a corresponding Main Postfork Hook may be called by the main process either before or after this callback.   <br/>It will only take effect if the module has a hook point here. If it is not set, the priority will be the default value defined in the module.', '', 'Integer value from -6000 to 6000. Lower value means higher priority.', '');

$_tipsdb['accessAllowed'] = new DAttrHelp("Access Allowed", 'Specifies which IPs or sub-networks are allowed to access resources under this context. Together with &quot;Access Denied&quot; and server/virtual host level access control, accessibility is determined by the smallest scope that a client&#039;s IP address falls into.', '', 'Comma-delimited list of IPs/sub-networks.', 'Sub-networks can be written as 192.168.1.0/255.255.255.0, 192.168.1, or 192.168.1.*.');

$_tipsdb['accessControl'] = new DAttrHelp("Access Control", 'Specifies what sub networks and/or IP addresses can access the server.  At the server level, this setting will affect all virtual hosts. You can also set up  access control unique to each virtual host at the virtual host level. Virtual host level settings will NOT  override server level settings. <br/><br/>Blocking/Allowing an IP is determined by the combination of the allowed list and the denied list.  If you want to block only certain IPs or sub-networks, put * or ALL in  the &quot;Allowed List&quot; and list the blocked IPs or sub-networks in the &quot;Denied List&quot;.  If you want to allow only certain IPs or sub-networks, put * or ALL  in the &quot;Denied List&quot; and list the allowed IPs or sub-networks in the &quot;Allowed List&quot;.  The setting of the smallest scope that fits for an IP will be used to determine access.<br/><br/><b>Server Level:</b> Trusted IPs or sub-networks must be specified in the &quot;Allowed List&quot; by adding a  trailing &quot;T&quot;. Trusted IPs or sub-networks are not affected by connection/throttling limits.  Only server level access control can set up trusted IPs/sub-networks.', ' Use this at the server level for general restrictions that apply to all virtual hosts.', '', '');

$_tipsdb['accessControl_allow'] = new DAttrHelp("Allowed List", 'Specifies the list of IPs or sub-networks allowed. * or ALL are accepted.', ' Trusted IPs or sub-networks set at the server level access  control will be excluded from connection/throttling limits.', 'Comma delimited list of IP addresses or sub-networks.  A trailing &quot;T&quot; can be used to indicate a trusted IP or sub-network, such as 192.168.1.*T.', '<b>Sub-networks:</b> 192.168.1.0/255.255.255.0, 192.168.1.0/24, 192.168.1, or 192.168.1.*<br/><b>IPv6 addresses:</b> ::1 or [::1] <br/><b>IPv6 subnets:</b> 3ffe:302:11:2:20f:1fff:fe29:717c/64 or  [3ffe:302:11:2:20f:1fff:fe29:717c]/64');

$_tipsdb['accessControl_deny'] = new DAttrHelp("Denied List", 'Specifies the list of IPs or sub-networks disallowed.', '', 'Comma delimited list of IP addresses or sub-networks.  * or ALL are accepted.', '<b>Sub-networks:</b> 192.168.1.0/255.255.255.0, 192.168.1.0/24, 192.168.1, or 192.168.1.*<br/><b>IPv6 addresses:</b> ::1 or [::1] <br/><b>IPv6 subnets:</b> 3ffe:302:11:2:20f:1fff:fe29:717c/64 or  [3ffe:302:11:2:20f:1fff:fe29:717c]/64');

$_tipsdb['accessDenied'] = new DAttrHelp("Access Denied", 'Specifies which IPs or sub-networks are NOT allowed to access resources under this context. Together with &quot;Access Allowed&quot; and server/virtual host-level access control, accessibility is determined by the smallest scope that a client&#039;s IP address falls into.', '', 'Comma-delimited list of IPs/sub-networks.', 'Sub-networks can be written as 192.168.1.0/255.255.255.0, 192.168.1, or 192.168.1.*.');

$_tipsdb['accessDenyDir'] = new DAttrHelp("Access Denied Directories", 'Specifies directories that should be blocked from access.  Add directories that contain sensitive data to this list to prevent accidentally  exposing sensitive files to clients. Append a &quot;*&quot; to the path to include all sub-directories.  If both &quot;Follow Symbolic Link&quot; and &quot;Check Symbolic Link&quot; are enabled, symbolic  links will be checked against the denied directories.', ' Of critical importance: This setting only prevents serving static  files from these directories. This does not prevent exposure by external scripts such as PHP/Ruby/CGI.', 'Comma-delimited list of directories', '');

$_tipsdb['accessLog_bytesLog'] = new DAttrHelp("Bytes Log", 'Specifies the path to the bandwidth bytes log file. When specified, a cPanel compatible bandwidth log will be created. This will log  the total bytes transferred for a request including both the request and reply bodies.', ' Put the log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['accessLog_compressArchive'] = new DAttrHelp("Compress Archive", 'Specifies whether to compress rotated log files in order to save disk space.', 'Log files are highly compressible and this is recommended to reduce disk usage for old logs.', 'Select from radio box', '');

$_tipsdb['accessLog_fileName'] = new DAttrHelp("File Name", 'The access log filename.', ' Put access log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['accessLog_keepDays'] = new DAttrHelp("Keep Days", 'Specifies how many days the access log file will be kept on disk.  Only rotated log files older than the specified number of days will be deleted. The current  log file will not be touched regardless how many days worth of data it contains.  If you do not want to auto-delete stale and very old log files, set this to 0.', '', 'Integer number', '');

$_tipsdb['accessLog_logFormat'] = new DAttrHelp("Log Format", ' Specifies the log format for the access log. When log format is set, it will override the &quot;Log Headers&quot; setting.', '', 'String. The syntax of log format is compatible with Apache 2.0&#039;s custom  <a href="http://httpd.apache.org/docs/current/mod/mod_log_config.html#formats" target="_blank" rel="noopener noreferrer">log format</a>.', '<b>Common Log Format (CLF)</b><br/>    &quot;%h %l %u %t \&quot;%r\&quot; %>s %b&quot;<br/><br/><b>Common Log Format with Virtual Host</b><br/>    &quot;%v %h %l %u %t \&quot;%r\&quot; %>s %b&quot;<br/><br/><b>NCSA extended/combined log format</b><br/>    &quot;%h %l %u %t \&quot;%r\&quot; %>s %b \&quot;%{Referer}i\&quot; \&quot;%{User-agent}i\&quot; <br/><br/><b>Log cookie value of Foobar</b><br/>    &quot;%{Foobar}C&quot;');

$_tipsdb['accessLog_logHeader'] = new DAttrHelp("Log Headers", 'Specifies whether to log HTTP request headers: Referer, UserAgent, and Host.', ' Turn this off if you do not need these headers in the access log.', 'Select from checkbox', '');

$_tipsdb['accessLog_pipedLogger'] = new DAttrHelp("Piped Logger", 'Specifies the external application that will receive the access log data sent by LiteSpeed through a pipe on its STDIN stream (file handle is 0).  When this field is specified, the access log will be sent only to the logger  application and not the access log file specified in previous entry.<br/><br/>The logger application must be defined in &quot;External Apps&quot; section first.  Server-level access logging can only use an external logger application  defined at the server level. Virtual host-level access logging can only use a logger application defined at the virtual host level.<br/><br/>The logger process is spawned in the same way as other external  (CGI/FastCGI/LSAPI) processes. This means it will execute as the  user ID specified in the virtual host&#039;s &quot;External App Set UID Mode&quot;  settings and will never run on behalf of a privileged user. <br/><br/>LiteSpeed web server performs simple load balancing among multiple logger  applications if more than one instance of a logger application is configured.  LiteSpeed server always attempts to keep the number of logger applications  as low as possible. Only when one logger application fails to process access  log entries in time will the server attempt to spawn another instance of  the logger application. <br/><br/>If a logger crashes, the web server will start another instance but the  log data in the stream buffer will be lost. It is possible to lose log  data if external loggers cannot keep up with the speed and volume of the log stream.', '', 'Select from drop down list', '');

$_tipsdb['aclogUseServer'] = new DAttrHelp("Log Control", 'Where the access log should be written. There are three options:  <ol> <li>Write to the server&#039;s access log</li> <li>Create an access log for this virtual host</li> <li>Disable access logging</li> </ol>', '', 'Select from drop down list', '');

$_tipsdb['addDefaultCharset'] = new DAttrHelp("Add Default Charset", 'Specifies whether to add a character set tag to the 	   &quot;Content-Type&quot; response header, when content type is either 	   &quot;text/html&quot; or &quot;text/plain&quot; without any parameters. 	   When set to Off,  this function is disabled. When set to 	   On, either the character set specified by 	   &quot;Customized Default Charset&quot; or the default &quot;iso-8859-1&quot; will be added.', '', 'Select from radio box', '');

$_tipsdb['addMIMEType'] = new DAttrHelp("MIME Type", 'Specifies additional MIME types and mappings for this 	   context. New mappings will override existing mappings under this 	   context and its children contexts.<br/>	   If you want to show PHP scripts as text files instead of being 	   executed as scripts, just override the .php mapping to MIME type 	   &quot;text/plain&quot;.', '', 'MIME-type1 extension extension ..., MIME-type2 extension ... 		Use comma to separate between MIME types, use space to 		separate multiple extensions.', 'image/jpg jpeg jpg, image/gif gif');

$_tipsdb['addonmodules'] = new DAttrHelp("Add-on Modules", 'Select the add-on modules you wish to use.   If you want to use a version not listed here, you can manually update the source code.  (The location of the source code is shown in a prompt at this step of the PHP build.)', '', 'Select from checkbox', '');

$_tipsdb['adminEmails'] = new DAttrHelp("Administrator Email", 'Specifies the server administrator&#039;s email address(es). If specified, administrators will be notified by email of important events (for example, when the LiteSpeed service is restarted automatically due to crash detection or when license is expiring).', 'Email alert feature will only work if the server has an active MX server such as postfix, exim, or sendmail.', 'Comma delimited list of email address.', '');

$_tipsdb['adminUser'] = new DAttrHelp("WebAdmin User", 'Change the username and password for the WebAdmin Console.  The old password must be entered and verified in order to save changes.', '', '', '');

$_tipsdb['allowBrowse'] = new DAttrHelp("Accessible", 'Specifies whether this context can be accessed. Set to No to deny access. You can use this feature to protect the specified directory from being visited. You may use it when you are updating contents for this context or you have special data in this directory.', '', 'Select from radio box', '');

$_tipsdb['allowSetUID'] = new DAttrHelp("Allow Set UID", 'Specifies whether the set UID bit is allowed for CGI scripts. If the set UID bit is allowed and the set UID bit is enabled for a CGI script, no matter which user the CGI script was started on behalf of, the user ID of the CGI process will switch to the user ID of the owner of the CGI script.<br/>The default is &quot;Off&quot;.', ' Do not allow Set UID CGI scripts whenever possible, as it is inherently a security risk.', 'Select from radio box', '');

$_tipsdb['allowSymbolLink'] = new DAttrHelp("Follow Symbolic Link", 'Specifies whether to follow symbolic links in this virtual host.  IF OWNER MATCH option will follow a symbolic link only if it has the same ownership.  This setting overrides the default server-level setting.', ' For better security, disable this feature. For better performance, enable it.', 'Select from drop down list', '');

$_tipsdb['appServerContext'] = new DAttrHelp("App Server Context", 'An App Server Context provides an easy way to configure a Ruby Rack/Rails, WSGI, or Node.js application. To add a an application through an App Server Context, only mounting the URL and the application&#039;s root directory is required. There is no need to go through all the trouble to define an external application, add a 404 handler, and rewrite rules, etc.', '', '', '');

$_tipsdb['appType'] = new DAttrHelp("Application Type", 'The type of application used for this context. Rack/Rails, WSGI, or Node.js are supported.', '', '', '');

$_tipsdb['appserverEnv'] = new DAttrHelp("Run-Time Mode", 'Specifies which mode the application will be running as: &quot;Development&quot;, &quot;Production&quot;, or &quot;Staging&quot;. The default is &quot;Production&quot;.', '', 'Select from drop down list', '');

$_tipsdb['as_location'] = new DAttrHelp("Location", 'Specifies the corresponding location of this context in the file system.<br/><br/>Default value: $DOC_ROOT + &quot;URI&quot;', '', 'It can be an absolute path or path relative to $SERVER_ROOT, $VH_ROOT, or $DOC_ROOT. $DOC_ROOT is the default relative path, and can be omitted.<br/><br/>If the &quot;URI&quot; is a regular expression, then the matched sub-string can be used to form the &quot;Root&quot; string. The matched sub-string can be referenced with the values &quot;$1&quot; - &quot;$9&quot;. &quot;$0&quot; and &quot;&&quot; can be used to reference the whole matched string. Additionally, a query string can be set by appending a &quot;?&quot; followed by the query string. Be careful. &quot;&&quot; should be escaped as &quot;\&&quot; in the query string.', 'A plain URI like /examples/ with &quot;Location&quot; set to /home/john/web_examples will map the request &quot;/examples/foo/bar.html&quot; to file &quot;/home/john/web_examples/foo/bar.html&quot;.<br/>To simulate Apache&#039;s mod_userdir, set URI to exp: ^/~([A-Za-z0-9]+)(.*), set &quot;Location&quot; to /home/$1/public_html$2. With these settings, a request of URI /~john/foo/bar.html will map to file /home/john/public_html/foo/bar.html.');

$_tipsdb['as_startupfile'] = new DAttrHelp("Startup File", 'The location of file used to start the application, relative to the application root directory.<br/><br/>Default startup file names include &#039;config.ru&#039; for Rack/Rails, &#039;wsgi.py&#039; and &#039;passenger_wsgi.py&#039; for WSGI, and &#039;app.js&#039; for NodeJS.', '', 'Path relative to application root directory', '');

$_tipsdb['authName'] = new DAttrHelp("Authentication Name", 'Specifies an alternative name for the authorization realm for the current context. If not specified, the original realm name will be used. The authentication name is displayed on the browser&#039;s login pop-up.', '', '', '');

$_tipsdb['autoFix503'] = new DAttrHelp("Auto Fix 503 Error", 'Specifies whether to try to fix the &quot;503 Service Unavailable&quot; error by restarting the server gracefully. A &quot;503&quot; error is usually caused by malfunctioning external applications and a web server restart can often fix the error temporarily. If enabled, the server will restart automatically whenever there are more than 30 &quot;503&quot; errors within a 30 seconds span. This feature is enabled by default.', '', 'Select from radio box', '');

$_tipsdb['autoIndex'] = new DAttrHelp("Auto Index", 'Specifies whether to generate a directory index on the fly when index files listed in &quot;Index Files&quot; are not available in a directory. This option is customizable at the virtual host and context level, and is inherited along the directory tree until it is explicitly overridden. You can customize the generated index page. Please check online wiki How-tos.', ' It is recommended to turn off Auto Index wherever possible to prevent revealing confidential data.', 'Select from radio box', '');

$_tipsdb['autoIndexURI'] = new DAttrHelp("Auto Index URI", 'Specifies the URI that will be used to generate the index page when index files listed in &quot;Index Files&quot; are not available in a directory. LiteSpeed web server uses an external script to generate the index page providing the maximum customization flexibility. The default script produces an index page with same look as Apache&#039;s. To customize the generated index page, please read online wiki How-tos. The directory to be indexed is passed to the script via an environment variable &quot;LS_AI_PATH&quot;.', '', 'URI', '');

$_tipsdb['autoLoadHtaccess'] = new DAttrHelp("Auto Load from .htaccess", 'Autoload rewrite rules contained in a directory&#039;s .htaccess file when first accessing that directory if an HttpContext for that directory using the <b>rewritefile</b> directive does not already exist. Once initially loaded, a graceful restart must be performed for any further changes to that .htaccess file to take effect.<br/><br/>Virtual Host-level setting overrides Server-level setting. Default values:<br/><br/><b>Server-level:</b> No<br/><br/><b>VH-Level:</b> Inherit Server-level setting', '', 'Select from radio box', '');

$_tipsdb['autoStart'] = new DAttrHelp("Start By Server", 'Specifies whether you want the web server to start the application automatically. Only FastCGI and LSAPI applications running on the same machine can be started automatically. The IP in the &quot;Address&quot; must be a local IP. Starting through the LiteSpeed CGI Daemon instead of a main server process will help reduce system overhead.<br/><br/>Default value: Yes (Through CGI Daemon)', '', 'Select from drop down list', '');

$_tipsdb['backlog'] = new DAttrHelp("Back Log", 'Specifies the backlog of the listening socket.  Required if &quot;Start By Server&quot; is enabled.', '', 'Integer number', '');

$_tipsdb['banPeriod'] = new DAttrHelp("Banned Period (sec)", 'Specifies how long new connections will be rejected from an IP if, after the  &quot;Grace Period (sec)&quot; has elapsed, the number of connections is still more than  the &quot;Connection Soft Limit&quot;. If IPs are getting banned repeatedly, we suggest that you  increase your banned period to stiffen the penalty for abuse.', '', 'Integer number', '');

$_tipsdb['binPath'] = new DAttrHelp("Binary Path", 'The location of the App Server application binary.', '', '', '');

$_tipsdb['blockBadReq'] = new DAttrHelp("Block Bad Request", 'Block IPs that keep sending badly-formated HTTP requests for the &quot;Banned Period (sec)&quot;. Default  is Yes. This helps to block botnet attacks that repeatedly sending junk requests.', '', 'Select from radio box', '');

$_tipsdb['brStaticCompressLevel'] = new DAttrHelp("Brotli Compression Level (Static File)", 'Specifies the level of Brotli compression applied to static files. Ranges from 1 (lowest) to 11 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; and &quot;Auto Update Static File&quot; are enabled.<br/><br/>Default value: 5', ' Save network bandwidth. Text-based responses such as html, css, and javascript files benefit the most and on average can be compressed to half of their original size.', 'Number between 1 and 11.', '');

$_tipsdb['certChain'] = new DAttrHelp("Chained Certificate", 'Specifies whether the certificate is a chained certificate or not. The file that stores a certificate chain must be in PEM format, and the certificates must be in the chained order, from the lowest level (the actual client or server certificate) to the highest level (root) CA.', '', 'Select from radio box', '');

$_tipsdb['certFile'] = new DAttrHelp("Certificate File", 'The filename of the SSL certificate file.', ' The certificate file should be placed in a secured directory, which allows read-only access to the user that the server runs as.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['cgiContext'] = new DAttrHelp("CGI Context", 'A CGI context defines scripts in a particular directory as CGI scripts. This directory can be inside or outside of the document root. When a file under this directory is requested, the server will always try to execute it as a CGI script, no matter if it&#039;s executable or not. In this way, file content under a CGI Context is always protected and cannot be read as static content. It is recommended that you put all your CGI scripts in a directory and set up a CGI Context to access them.', '', '', '');

$_tipsdb['cgiResource'] = new DAttrHelp("CGI Settings", 'The following settings control CGI processes. Memory and process limits also serve as the default for other external applications if limits have not been set explicitly for those applications.', '', '', '');

$_tipsdb['cgi_path'] = new DAttrHelp("Path", 'Specifies the location of CGI scripts.', '', 'The path can be a directory that contains a group of CGI scripts, like $VH_ROOT/myapp/cgi-bin/. In this case, the context &quot;URI&quot; must end with &quot;/&quot;, like /app1/cgi/. The Path can also specify only one CGI script, like $VH_ROOT/myapp/myscript.pl. This script should have the corresponding &quot;URI&quot; /myapp/myscript.pl.', '');

$_tipsdb['cgidSock'] = new DAttrHelp("CGI Daemon Socket", 'A unique socket address used to communicate with the CGI daemon. LiteSpeed server uses a standalone CGI daemon to  spawn CGI scripts for best performance and security. Default socket is &quot;uds://$SERVER_ROOT/admin/conf/.cgid.sock&quot;. If you need to put in another location, specify a Unix domain socket here.', '', 'UDS://path', 'UDS://tmp/lshttpd/cgid.sock');

$_tipsdb['cgroups'] = new DAttrHelp("cgroups", 'Apply cgroup settings to this CGI process if supported by the current OS. At this time, RedHat/Centos Linux v7.5+ and Ubuntu 18.04+ are supported. The currently executing user will be used to determine which cgroup configuration to apply.<br/><br/>Setting this to Disabled at the Server level will disable this setting server-wide. In all other cases, the Server level setting can be overridden at the Virtual Host level.<br/><br/>Default values:<br/><b>Server level:</b> Off<br/><b>VH level:</b> Inherit Server level setting', '', 'Select from drop down list', '');

$_tipsdb['checkSymbolLink'] = new DAttrHelp("Check Symbolic Link", 'Specifies whether to check symbolic links against &quot;Access Denied Directories&quot;  when &quot;Follow Symbolic Link&quot; is turned on. If enabled, the canonical real path of the resource  referred by a URL will be checked against the configurable access denied directories.  Access will be denied if it falls inside an access denied directory.', ' For best security, enable this option. For best performance, disable it.', 'Select from radio box', '');

$_tipsdb['ciphers'] = new DAttrHelp("Ciphers", 'Specifies the cipher suite to be used when negotiating the SSL handshake. LSWS supports cipher suites implemented in SSL v3.0, TLS v1.0, TLS v1.2, and TLS v1.3.', ' We recommend leaving this field blank to use our default cipher which follows SSL cipher best practices.', 'Colon-separated string of cipher specifications.', 'ECDHE-RSA-AES128-SHA256:RC4:HIGH:!MD5:!aNULL:!EDH');

$_tipsdb['clientVerify'] = new DAttrHelp("Client Verification", ' Specifies the type of client certifcate authentication. Available types are: <ul> <li><b>None:</b> No client certificate is required.</li> <li><b>Optional:</b> Client certificate is optional.</li> <li><b>Require:</b> The client must has valid certificate.</li> <li><b>Optional_no_ca:</b> Same as optional.</li> </ul> The default is &quot;None&quot;.', '&quot;None&quot; or &quot;Require&quot; are recommended.', 'Select from drop down list', '');

$_tipsdb['compilerflags'] = new DAttrHelp("Compiler Flags", 'Add additional compiler flags, like optimized compiler options.', '', 'Supported flags are CFLAGS, CXXFLAGS, CPPFLAGS, LDFLAGS. Use a space to separate different flags.  Use single quotes (not double quotes) for flag values.', 'CFLAGS=&#039;-O3 -msse2 -msse3 -msse4.1 -msse4.2 -msse4 -mavx&#039;');

$_tipsdb['compressibleTypes'] = new DAttrHelp("Compressible Types", 'Specifies what MIME types are allowed to be compressed.', ' Only allow types that will benefit from GZIP/Brotli compression. Binary files such as gif/png/jpeg images and flash files do not benefit from compression.', 'MIME type list separated by commas. Wild card &quot;*&quot; and negate sign &quot;!&quot; are allowed, such as text/*, !text/js.', 'If you want to compress text/* but not text/css, you can have a rule like text/*, !text/css. &quot;!&quot; will exclude that MIME type.');

$_tipsdb['configFile'] = new DAttrHelp("Config File", 'The configuration filename and directory for this virtual host. The configuration file must be under the $SERVER_ROOT/conf/vhosts/ directory.', '$SERVER_ROOT/conf/vhosts/$VH_NAME/vhconf.conf is recommended', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['configureparams'] = new DAttrHelp("Configure Parameters", 'Configure parameters for PHP build. Apache-specific parameters and &quot;--prefix&quot; value will be automatically  removed and &quot;--with-litespeed&quot; will be automatically appended when you click Next Step.  (Prefix can be set in the field above.) This way you can simply copy and paste the configure  parameters from the phpinfo() output of an existing working PHP build.', '', 'Space-delimited series of options (with or without double quotes)', '');

$_tipsdb['connTimeout'] = new DAttrHelp("Connection Timeout (secs)", 'Specifies the maximum connection idle time allowed during processing one request. The connection will be closed if it has been idle, i.e. no I/O activity, for this period of time.', ' Set this as low as you can to help recover dead connections during a potential DoS attack.', 'Integer number', '');

$_tipsdb['consoleSessionTimeout'] = new DAttrHelp("Session Timeout (secs)", 'Customize the session timeout length of the WebAdmin Console.  The default is 60 seconds.', ' Set a proper value for production use, usually less than 300 seconds.', 'Integer number', '');

$_tipsdb['cpuAffinity'] = new DAttrHelp("CPU Affinity", 'CPU affinity binds a process to one or more CPUs (cores). It is beneficial for a process to always use the same CPU because then the process can make use of data left in CPU cache. If the process moves to a different CPU, there is no use of CPU cache and unnecessary overhead is required.<br/><br/>The CPU Affinity setting controls how many CPUs (cores) one server process will be associated with. The minimum value is 0, which will disable this feature. The maximum value is the number of cores the server has. Generally, 1 is the best setting because because it creates the strictest use of CPU affinity and thus makes the most use of CPU cache.<br/><br/>Default value: 0', '', 'Integer value from 0 to 64. (0 will disable this feature)', '');

$_tipsdb['crlFile'] = new DAttrHelp("Client Revocation File", ' Specifies the file containing PEM-encoded CA CRL files enumerating revoked client certificates. This can be used as an alternative or in addition to &quot;Client Revocation Path&quot;.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['crlPath'] = new DAttrHelp("Client Revocation Path", ' Specifies the directory containing PEM-encoded CA CRL files for revoked client certificates. The files in this directory have to be PEM-encoded. These files are accessed through hash filenames, hash-value.rN. Please refer to openSSL or Apache mod_ssl documentation regarding creating the hash filename.', '', 'path', '');

$_tipsdb['ctxType'] = new DAttrHelp("Context Type", 'The type of context created determines it&#039;s usage.<br><br><b>Static</b> context can be used to map a URI to a directory either outside document root or within it.<br> <b>Java Web App</b> context is used to automatically import a predefined Java Application in an AJPv13 compilant Java servlet engine.<br> <b>Servlet</b> context is used to import a specific servlet under a web application.<br> <b>Fast CGI</b> context is a mount point of Fast CGI application.<br> <b>LiteSpeed SAPI</b> context can be used to associate a URI with an LSAPI application.<br> <b>Proxy</b> context enables this virtual host to serve as a transparant reverse proxy server to an external web server or application server.<br> <b>CGI</b> context can be used to specify a directory only contains CGI scripts.<br> <b>Load Balancer</b> context can be used to assign a different cluster for that context.<br> <b>Redirect</b> context can set up an internal or external redirect URI.<br> <b>App Server</b> context is specifically used for Rack/Rails, WSGI, and Node.js applications.<br> <b>Module handler</b> context is a mount point of hander type modules.<br>', '', '', '');

$_tipsdb['defaultCharsetCustomized'] = new DAttrHelp("Customized Default Charset", 'Specifies a character set to be used when &quot;Add Default Charset&quot; 	   is On. This is optional. The default value is iso-8859-1. 	   This entry has no effect when &quot;Add Default Charset&quot; is 	   Off.', '', 'Name of a character set.', 'utf-8');

$_tipsdb['defaultType'] = new DAttrHelp("Default MIME Type", 'When specified, this type will be used when MIME type mapping 	   cannot be determined by the suffix of a document or if there is no suffix. 	   If not specified, the default value 	   application/octet-stream will be used.', '', 'MIME-type', '');

$_tipsdb['destinationuri'] = new DAttrHelp("Destination URI", 'Specifies the target location of the redirect. If this redirected URI maps to a URI in another redirect context, it will be redirected again.', '', 'This URI can either be a relative URI on the same web site starting with &quot;/&quot;, or an absolute URI pointing to different web site starting with &quot;http(s)://&quot;. If the &quot;URI&quot; contains regular expressions, the destination can reference the matched variables, such as $1 or $2.', '');

$_tipsdb['disableInitLogRotation'] = new DAttrHelp("Disable Initial Log Rotation", 'Specifies whether to enable/disable rotation of server error log file at startup. Initial log rotation is enabled by default when using value &quot;Not Set&quot;.', '', 'Select from radio box', '');

$_tipsdb['docRoot'] = new DAttrHelp("Document Root", 'Specifies the document root for this virtual host. $VH_ROOT/html is recommended. This directory is referred to as $DOC_ROOT in contexts.', '', 'A path which can be absolute, relative to $SERVER_ROOT, or relative to $VH_ROOT.', '');

$_tipsdb['domainName'] = new DAttrHelp("Domains", 'Specifies the mapping domain names. Domain names are case insensitive and the leading &quot;www.&quot; will be removed. The wildcard characters &quot;*&quot; and &quot;?&quot; are allowed. &quot;?&quot; only represents one character. &quot;*&quot; represents any numbers of characters. Duplicated domain names are not allowed.', ' If a listener is dedicated to one virtual host, always use * for the domain name to avoid unnecessary checking. Domain names with wildcard characters  (other than the catchall domain) should be avoided whenever possible.', 'Comma-separated list.', 'www?.example.com<br/>&quot;*.mydomain.com&quot; will match all subdomains of mydomain.com.<br/>&quot;*&quot; by itself is the catchall domain and will match any unmatched domain names.');

$_tipsdb['dynReqPerSec'] = new DAttrHelp("Dynamic Requests/Second", 'Specifies the maximum number of requests to dynamically generated content  coming from a single IP address that can be processed in each second regardless of the number of connections established.  When this limit is reached, all future requests to dynamic content  are tar-pitted until the next second. <br/><br/>The request limit for static content is independent of this limit. This per client request limit can be set at server or virtual host level.  Virtual host-level settings override server-level settings.', ' Trusted IPs or sub-networks are not restrained by this limit.', 'Integer number', '');

$_tipsdb['enableBrCompress'] = new DAttrHelp("Brotli Compression Level (Dynamic Content)", 'Controls the level of Brotli compression applied to dynamic responses. Ranges from 0 (OFF) to 6 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; is enabled.<br/><br/>Default value: 2', '', 'Number between 0 and 6.', '');

$_tipsdb['enableCoreDump'] = new DAttrHelp("Enable Core Dump", 'Specifies whether to enable core dump when the server is started by &quot;root&quot; user.  For most modern Unix systems, processes that change user ID or group ID are not allowed to  dump a core file for security reasons. However, it is much easier to identify root  cause of a problem with a core dump. This option only works on Linux kernel 2.4 and up.   Solaris users should use the coreadm command to control this feature.', ' Only enable this when you see no core file created in   the server log file. Disable it immediately after producing the core file.   Please submit a bug report when a core dump has been created.', 'Select from radio box', '');

$_tipsdb['enableDHE'] = new DAttrHelp("Enable DH Key Exchange", 'Allows use of Diffie-Hellman key exchange for further SSL encryption.', ' DH key exchange is more secure than using just an RSA key. ECDH and DH key exchange are equally secure.<br/><br/> Enabling DH key exchange will increase CPU load and is slower than ECDH key exchange and RSA. ECDH key exchange is preferred when available.', 'Select from radio box', '');

$_tipsdb['enableDynGzipCompress'] = new DAttrHelp("Enable GZIP Dynamic Compression", 'Controls GZIP compression for dynamically generated responses.<br/><br/>For this setting to have an effect, &quot;Enable Compression&quot; must be set to Yes.<br/><br/>Default value: Yes', ' Compressing dynamic responses increases CPU and memory utilization but saves network bandwidth.', 'Select from radio box', '');

$_tipsdb['enableECDHE'] = new DAttrHelp("Enable ECDH Key Exchange", 'Allows use of Elliptic Curve Diffie-Hellman key exchange for further SSL encryption.', ' ECDH key exchange is more secure than using just an RSA key. ECDH and DH key exchange are equally secure.<br/><br/> Enabling ECDH key exchange will increase CPU load and is slower than using just an RSA key.', 'Select from radio box', '');

$_tipsdb['enableExpires'] = new DAttrHelp("Enable Expires", 'Specifies whether to generate an Expires header for static files. If enabled, an Expires header will be generated based on &quot;Expires Default&quot; and &quot;Expires By Type&quot;.<br/><br/>This can be set at server, virtual host and context level. Lower level settings will override higher level ones, i.e. context settings will override virtual host settings and virtual host settings will override server settings.', '', 'Select from radio box', '');

$_tipsdb['enableGzipCompress'] = new DAttrHelp("Enable Compression", 'Enables GZIP/Brotli compression for both static and dynamic responses.<br/><br/>Default value: Yes', ' Enable it to save network bandwidth. Text-based responses such as html, css, and javascript files benefit the most and on average can be compressed to half of their original size.', 'Select from radio box', '');

$_tipsdb['enableIpGeo'] = new DAttrHelp("Enable GeoLocation Lookup", ' Specifies whether to enable/disable IP Geolocation lookup. Can be set at server, virtual host, or context level. IP Geolocation is disabled by default when using value &quot;Not Set&quot;.', '', 'Select from radio box', '');

$_tipsdb['enableLVE'] = new DAttrHelp("Cloud-Linux", 'Specifies whether to enable CloudLinux&#039;s Lightweight Virtual Environment (LVE)  when it exists. You can use LiteSpeed with LVE to achieve better resource management.  For more information, please check http://www.cloudlinux.com.', '', 'Select from drop down list', '');

$_tipsdb['enableRecaptcha'] = new DAttrHelp("Enable reCAPTCHA", 'Enable the reCaptcha Protection feature at the current level. This setting must be set to Yes at the Server level before the reCaptcha Protection feature can be used.<br/><br/>Default values:<br/><b>Server-level:</b> Yes<br/><b>VH-Level:</b> Inherit Server level setting', '', 'Select from radio box', '');

$_tipsdb['enableRewrite'] = new DAttrHelp("Enable Rewrite", 'Specifies whether to enable LiteSpeed&#039;s URL rewrite engine. This option can be customized at the virtual host or context level, and is inherited along the directory tree until it is explicitly overridden.', '', 'Select from radio box', '');

$_tipsdb['enableScript'] = new DAttrHelp("Enable Script", 'Specifies whether scripting (non-static pages) is allowed in this virtual host.  If disabled, CGI, FastCGI, LSAPI, Servlet engines and other scripting languages will not be allowed in this virtual host.  Therefore, if you want to use a script handler, you need to enable it here as well.', '', 'Select from radio box', '');

$_tipsdb['enableSpdy'] = new DAttrHelp("Enable SPDY/HTTP2", 'HTTP/2 and SPDY are new versions of the HTTP network protocol with the goal of reducing page load times. More information can be found at <a href=&quot;http://en.wikipedia.org/wiki/HTTP/2&quot;>http://en.wikipedia.org/wiki/HTTP/2</a>.', 'This setting can be set at the listener and virtual host levels.', 'Check the protocol(s) you wish to enable. Leaving all boxes unchecked will enable SPDY and HTTP/2 support (the default). If you wish to disable SPDY and HTTP/2, check &quot;None&quot; only and leave all other boxes unchecked.', '');

$_tipsdb['enableStapling'] = new DAttrHelp("Enable OCSP Stapling", 'Determines whether to enable OCSP stapling, a more efficient way of verifying public key certificates.', '', 'Select from radio box', '');

$_tipsdb['enableh2c'] = new DAttrHelp("Enable HTTP/2 Over Cleartext TCP", 'Specifies whether to enable HTTP/2 over non-encrypted TCP connections. Default is disabled.', '', 'Select from radio box', '');

$_tipsdb['env'] = new DAttrHelp("Environment", 'Specifies extra environment variables for the external application.', '', 'Key=value. Multiple variables can be separated by &quot;ENTER&quot;', '');

$_tipsdb['errCode'] = new DAttrHelp("Error Code", 'Specifies the HTTP status code for the error page. Only the selected HTTP status code will have this customized error page.', '', 'Select from drop down list', '');

$_tipsdb['errPage'] = new DAttrHelp("Customized Error Pages", 'Whenever the server has a problem processing a request, the server will return an error code and an html page as an error message to the web client. Error codes are defined in the HTTP protocol (see RFC 2616). LiteSpeed web server has a built-in default error page for each error code, but a customized page can be configured for each error code as well. These error pages can be even further customized to be unique for each virtual host.', '', '', '');

$_tipsdb['errURL'] = new DAttrHelp("URL", 'Specifies the URL of the customized error page. The server will forward the request to this URL when the corresponding HTTP status code has returned. If this URL refers to a non-existing resource, the built-in error page will be used. The URL can be a static file, a dynamically generated page, or a page on another web site (a URL starting with &quot;http(s)://&quot;). When referring to a page on another web site, the client will receive a redirect status code instead of the original status code.', '', 'URL', '');

$_tipsdb['expWSAddress'] = new DAttrHelp("Address", 'HTTP or HTTPS address used by the external web server.', ' If you proxy to another web server running on the same machine, set the IP address to localhost or 127.0.0.1, so the external application is inaccessible from other machines.', 'IPv4 or IPV6 address(:port). Add &quot;https://&quot; in front if the external web server uses HTTPS. Port is optional if the external web server uses the standard ports 80 or 443.', '192.168.0.10<br/>127.0.0.1:5434<br/>https://10.0.8.9<br/>https://127.0.0.1:5438');

$_tipsdb['expiresByType'] = new DAttrHelp("Expires By Type", 'Specifies Expires header settings for individual MIME types.', '', 'Comma delimited list of &quot;MIME-type=A|Mseconds&quot;. The file will expire after base time (A|M) plus specified seconds.<br/><br/>Base time &quot;A&quot; sets the value to the client&#039;s access time and &quot;M&quot; to the file&#039;s last modified time. MIME-type accepts wildcard &quot;*&quot;, like image/*.', '');

$_tipsdb['expiresDefault'] = new DAttrHelp("Expires Default", 'Specifies default settings for Expires header generation. This setting takes effect when &quot;Enable Expires&quot; is set to &quot;Yes&quot;. It can be overridden by &quot;Expires By Type&quot;. Do not set this default at the server or virtual host level unless you have to, since it will generate Expires headers for all pages. Most of time this should be set at the context level for certain directories that do not change often. If there is no default setting, no Expires header will be generated for types not specified in &quot;Expires By Type&quot;.', '', 'A|Mseconds<br/>The file will expire after base time(A|M) plus specified seconds. Base time &quot;A&quot; sets the value to the client&#039;s access time and &quot;M&quot; to the file&#039;s last modified time.', '');

$_tipsdb['expuri'] = new DAttrHelp("URI", 'Specifies the URI for this context.', '', 'The URI can be a plain URI (starting with &quot;/&quot;) or a Perl compatible regular expression URI (starting with &quot;exp:&quot;). If a plain URI ends with a &quot;/&quot;, then this context will include all sub-URIs under this URI. If the context maps to a directory on the file system, a trailing &quot;/&quot; must be added.', '');

$_tipsdb['extAppAddress'] = new DAttrHelp("Address", 'A unique socket address used by the external application. IPv4/IPv6 sockets and Unix Domain Sockets (UDS) are supported. IPv4/IPv6 sockets can be used for communication over the network. UDS can only be used when the external application resides on the same machine as the server.', ' If the external application runs on the same machine, UDS is preferred. If you have to use an IPv4|IPV6 socket, set the IP address to localhost or 127.0.0.1, so the external application is inaccessible from other machines.<br/> Unix Domain Sockets generally provide higher performance than IPv4 sockets.', 'IPv4 or IPV6 address:port or UDS://path', '127.0.0.1:5434<br/>UDS://tmp/lshttpd/php.sock.');

$_tipsdb['extAppName'] = new DAttrHelp("Name", 'A unique name for this external application. You will refer to it by this name when you use it in other parts of the configuration.', '', '', '');

$_tipsdb['extAppPath'] = new DAttrHelp("Command", 'Specifies the full command line including parameters to execute the external application. Required value if &quot;Start By Server&quot; is enabled. A parameter should be quoted with a double or single quote if the parameter contains space or tab characters.', '', 'Full path to the executable with optional parameters.', '');

$_tipsdb['extAppPriority'] = new DAttrHelp("Priority", 'Specifies priority of the external application process. Value ranges from -20 to 20. A lower number means a higher priority. An external application process cannot have a higher priority than the web server. If this priority is set to a lower number than the server&#039;s, the server&#039;s priority will be used for this value.', '', 'int', '');

$_tipsdb['extAppType'] = new DAttrHelp("Type", 'Specifies the type of external application. Application types are differentiated by the service they provide or the protocol they use to communicate with the server. Choose from <ul>   <li>FastCGI: a FastCGI application with a Responder role.</li>   <li>FastCGI Authorizer: a FastCGI application with an Authorizer role</li>   <li>Servlet Engine: a servlet engine with an AJPv13 connector, such as Tomcat.</li>   <li>Web Server: a web server or application server that supports HTTP protocol.</li>   <li>LiteSpeed SAPI App: an application that communicates with the web server using LSAPI protocol.</li>   <li>Load Balancer: a virtual application that can balance load among worker applications.</li>   <li>Piped Logger: an application that can process access log entries received on its STDIN stream.</li> </ul>', 'Most applications will use either LSAPI or FastCGI protocol. LSAPI supports PHP, Ruby, and Python. Perl can be used with FastCGI. (PHP, Ruby, and Python can also be set up to run using FastCGI, but they run faster using LSAPI.) Java uses servlet engines.', 'Select from drop down list', '');

$_tipsdb['extAuthorizer'] = new DAttrHelp("Authorizer", 'Specifies an external application that can be used to generate authorized/unauthorized decisions. Currently, only the FastCGI Authorizer is available. For more details about the FastCGI Authorizer role, please visit <a href="http://www.fastcgi.com" target="_blank" rel="noopener noreferrer">http://www.fastcgi.com</a>.', '', 'Select from drop down list', '');

$_tipsdb['extGroup'] = new DAttrHelp("Run As Group", 'The external application will run as this specified group name. If not set, Virtual Host level settings will be inherited.<br/><br/>Default value: Not Set', '', 'Valid group name.', '');

$_tipsdb['extMaxIdleTime'] = new DAttrHelp("Max Idle Time", 'Specifies the maximum idle time before an external application is stopped by the server, freeing idle resources. When set to &quot;-1&quot;, the external application will not be stopped by the server unless running in ProcessGroup mode where idle external applications will be stopped after 30 seconds. The default value is &quot;-1&quot;.', ' This feature is especially useful in the mass hosting environment where, in order to prevent files owned by one virtual host from being accessed by the external application scripts of another virtual host, many different applications are run at the same time in SetUID mode. Set this value low to prevent these external applications from idling unnecessarily.', 'Select from radio box', '');

$_tipsdb['extUmask'] = new DAttrHelp("umask", 'Sets default umask for this external application&#039;s processes. See  man 2 umask  for details. The default value taken from the server-level &quot;umask&quot; setting.', '', 'value valid range [000]-[777].', '');

$_tipsdb['extUser'] = new DAttrHelp("Run As User", 'The external application will run as this specified user name. If not set, Virtual Host level settings will be inherited.<br/><br/>Default value: Not Set', '', 'Valid username.', '');

$_tipsdb['extWorkers'] = new DAttrHelp("Workers", 'List of worker groups previously defined in the external load balancer.', '', 'A comma-separated list in the form ExternalAppType::ExternalAppName', 'fcgi::localPHP, proxy::backend1');

$_tipsdb['externalredirect'] = new DAttrHelp("External Redirect", 'Specifies whether this redirect is external. For external redirection, &quot;Status Code&quot; may be specified and &quot;Destination URI&quot; can start either with &quot;/&quot; or &quot;http(s)://&quot;. For internal redirection, &quot;Destination URI&quot; must start with &quot;/&quot;.', '', '', '');

$_tipsdb['extraHeaders'] = new DAttrHelp("Header Operations", 'Specifies additional response/request headers to be added. Multiple header directives can be added with one directive per line. &quot;NONE&quot; can be used to disable parent header inheritance. If no directive is provided &#039;Header&#039; is assumed.', ' Syntax and usage are similar to <a href="https://httpd.apache.org/docs/2.2/mod/mod_headers.html#header" target="_blank" rel="noopener noreferrer">Apache&#039;s mod_headers directives</a> for supported operations.<br/><br/> The &#039;Header&#039; directive is is optional and can be excluded or left in when copying rules from elsewhere without issue.', '[Header]|RequestHeader [condition] set|append|merge|add|unset header [value] [early|env=[!]variable]', 'set Cache-control no-cache<br/>append Cache-control no-store<br/>Header set My-header cust_header_val<br/>RequestHeader set My-req-header cust_req_header_val');

$_tipsdb['extrapathenv'] = new DAttrHelp("Extra PATH Environment Variables", 'Additional PATH values that will be appended to the current PATH environment variables for build scripts.', '', 'path values separated by &quot;:&quot;', '');

$_tipsdb['fcgiContext'] = new DAttrHelp("FastCGI Context", 'FastCGI applications cannot be used directly. A FastCGI application must be either configured as a script handler or mapped to a URL through FastCGI context. A FastCGI context will associate a URI with a FastCGI application.', '', '', '');

$_tipsdb['fcgiapp'] = new DAttrHelp("FastCGI App", 'Specifies the name of the FastCGI application. This application must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');

$_tipsdb['fileETag'] = new DAttrHelp("File ETag", 'Specifies whether to use a file&#039;s inode, last-modified time, and size attributes to generate the ETag HTTP response header for static files. All three attributes are enabled by default. If you plan to serve the same file out of mirrored servers, you should not include inode; otherwise, the ETag generated for one file will be different on different servers.', '', 'Select from checkbox', '');

$_tipsdb['fileUpload'] = new DAttrHelp("File Upload", 'Provides additional security functionality when uploading files by using a Request Body Parser to parse files to a server local directory where they can be easily scanned for malicious intent by third party modules. Request Body Parser is used when &quot;Pass Upload Data by File Path&quot; is enabled or a module calls LSIAPI’s set_parse_req_body in the LSI_HKPT_HTTP_BEGIN level. API examples provided in source package.', '', '', '');

$_tipsdb['followSymbolLink'] = new DAttrHelp("Follow Symbolic Link", 'Specifies the server-level default setting of following symbolic links  when serving static files. <br/><br/>Choices are Yes, If Owner Match and No. <br/><br/>Yes sets the server to always follow symbolic links.  If Owner Match sets the server to follow a symbolic link only if the owner of the link and of the target are same.  No means the server will never follow a symbolic link.  This setting can be overridden in the virtual host configurations but cannot be overridden from an .htaccess file.', ' For best security select No or If Owner Match.  For best performance, select Yes.', 'Select from drop down list', '');

$_tipsdb['forceGID'] = new DAttrHelp("Force GID", 'Specifies a group ID to be used for all external applications started in suEXEC mode.  When set to non-zero value, all suEXEC external applications (CGI/FastCGI/LSAPI) will use this group ID. This can be used to prevent an external application from accessing files owned by other users.<br/><br/>For example, in a shared hosting environment, LiteSpeed runs as user &quot;www-data&quot;, group &quot;www-data&quot;. Each docroot is owned by a user account, with a group of &quot;www-data&quot; and permission mode 0750. If Force GID is set to &quot;nogroup&quot; (or any group other than &#039;www-data&#039;), all suEXEC external applications will run as a particular user but in the group &quot;nogroup&quot;. These external application processes  will still be able to access files owned by that particular user (because of their user ID),  but will not have group permission to access anyone else&#039;s files. The server, on the other hand, still can serve files under any user&#039;s docroot directory (because of its group ID).', ' Set it high enough to exclude all groups used by system users.', 'Integer number', '');

$_tipsdb['forceStrictOwnership'] = new DAttrHelp("Force Strict Ownership Checking", 'Specifies whether to enforce strict file ownership checking.  If it is enabled, the web server will check if the owner of the file being served is the same as  the owner of the virtual host. If it is different, a 403 Access Denied Error will be returned. This is turned off by default.', ' For shared hosting, enable this check for better security.', 'Select from radio box', '');

$_tipsdb['forceType'] = new DAttrHelp("Force MIME Type", 'When specified, all files under this context will be served as 	   static files with the MIME type specified regardless of file suffix. 	   When set to NONE, inherited force type setting will be 	   disabled.', '', 'MIME type or NONE.', '');

$_tipsdb['generalContext'] = new DAttrHelp("Static Context", 'Context settings are used to specify special settings for files in a certain location. These settings can be used to bring in files outside of the document root (like Apache&#039;s Alias or AliasMatch directives), to protect a particular directory using authorization realms, or to block or restrict access to a particular directory within the document root.', '', '', '');

$_tipsdb['geoipDBFile'] = new DAttrHelp("DB File Path", 'Specifies the path to MaxMind GeoIP database.', '', 'Absolute path', '/usr/local/share/GeoIP/GeoLite2-Country.mmdb');

$_tipsdb['geoipDBName'] = new DAttrHelp("DB Name", 'MaxMind GeoIP database name. As of GeoIP2, this setting is required.<br/><br/>When upgrading from a GeoIP to a GeoIP2, using values &quot;COUNTRY_DB&quot;, &quot;CITY_DB&quot;, or &quot;ASN_DB&quot; for this setting will automatically populate PHP&#039;s $_SERVER variable with some GeoIP compatible entries (listed by DB Name value below) to help ease this transition.<br/><br/><b>CITY_DB:</b> &#039;GEOIP_COUNTRY_CODE&#039;, &#039;GEOIP_COUNTRY_NAME&#039;, &#039;GEOIP_CONTINENT_CODE&#039;, &#039;GEOIP_COUNTRY_CONTINENT&#039;, &#039;GEOIP_DMA_CODE&#039;, &#039;GEOIP_METRO_CODE&#039;, &#039;GEOIP_LATITUDE&#039;, &#039;GEOIP_LONGITUDE&#039;, &#039;GEOIP_POSTAL_CODE&#039;, and &#039;GEOIP_CITY&#039;.<br/><b>COUNTRY_DB:</b> &#039;GEOIP_COUNTRY_CODE&#039;, &#039;GEOIP_COUNTRY_NAME&#039;, &#039;GEOIP_CONTINENT_CODE&#039;, and &#039;GEOIP_COUNTRY_CONTINENT&#039;.<br/><b>ASN_DB:</b> &#039;GEOIP_ORGANIZATION&#039; and &#039;GEOIP_ISP&#039;.', '', '', 'COUNTRY_DB');

$_tipsdb['geolocationDB'] = new DAttrHelp("MaxMind GeoIP DB", 'Multiple MaxMind geolocation databases can be specified here. MaxMind has the following type of DBs: Country, Region, City, Organization, ISP and Netspeed. If multiple databases of types &quot;Country&quot;, &quot;Region&quot;, and &quot;City&quot; are configured, the last configuration will be effective.', '', '', '');

$_tipsdb['gracePeriod'] = new DAttrHelp("Grace Period (sec)", 'Specifies how long new connections can be accepted after the number of connections  established from one IP is over the &quot;Connection Soft Limit&quot;. Within this period, new connections  will be accepted if the total connections is still below the &quot;Connection Hard Limit&quot;. After this  period has elapsed, if the number of connections still higher than the &quot;Connection Soft Limit&quot;,  then the offending IP will be blocked for the &quot;Banned Period (sec)&quot;.', ' Set to a proper number big enough for downloading  a complete page but low enough to prevent deliberate attacks.', 'Integer number', '');

$_tipsdb['gracefulRestartTimeout'] = new DAttrHelp("Graceful Restart Timeout (secs)", 'During a graceful restart, even after the new server instance is up, the old instance will continue to handle existing requests. This timeout defines how long the previous instance shall wait before exit. Default value is 300 seconds. -1 means wait forever. 0 means no wait and abort immediately.', '', 'int', '');

$_tipsdb['groupDBCacheTimeout'] = new DAttrHelp("Group DB Cache Timeout (secs)", 'Specifies how often the backend group database will be checked for changes.  For more detail please refer to &quot;User DB Cache Timeout (secs)&quot;.', '', 'Integer number', '');

$_tipsdb['groupDBMaxCacheSize'] = new DAttrHelp("Group DB Max Cache Size", 'Specifies the maximum cache size of the group database.', ' As a larger cache will consume more memory,  a higher value may or may not provide better performance. Set it to an appropriate size according  to your user database size and site usage.', 'Integer number', '');

$_tipsdb['gzipAutoUpdateStatic'] = new DAttrHelp("Auto Update Static File", 'Specifies whether to let the server automatically create/update GZIP/Brotli-compressed versions of compressible static files or not. If set to Yes, when a file with a MIME type listed in &quot;Compressible Types&quot; is requested, the server may create or update the corresponding compressed version of the file depending on the compressed file&#039;s timestamp. This compressed file is created under the &quot;Static Cache Directory&quot;. The filename is based on a MD5 hash of the path of the original file.<br/><br/>Default value: Yes', '', 'Select from radio box', '');

$_tipsdb['gzipCacheDir'] = new DAttrHelp("Static Cache Directory", 'Specifies the path of the directory used to store compressed files for static content.<br/><br/>Default value: &quot;Swapping Directory&quot;.', '', 'Directory Path', '');

$_tipsdb['gzipCompressLevel'] = new DAttrHelp("GZIP Compression Level (Dynamic Content)", 'Specifies the level of GZIP compression applied to dynamic content. Ranges from 1 (lowest) to 9 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; and &quot;Enable GZIP Dynamic Compression&quot; are enabled.<br/><br/>Default value: 6', ' Higher compression level will use more memory and CPU cycles. You can set it to a higher level if your machine has additional power. There is not much difference between 6 and 9, except that 9 uses many more CPU cycles.', 'Number between 1 and 9.', '');

$_tipsdb['gzipMaxFileSize'] = new DAttrHelp("Max Static File Size (bytes)", 'Specifies the maximum size of a static file for which the server will create a compressed file automatically.<br/><br/>Default value: 10M', ' It is not recommended to have the server create/update compressed files for large files. Compressing blocks an entire server process and no further requests can be processed until the compression is completed.', 'Number in bytes not less than 1K.', '');

$_tipsdb['gzipMinFileSize'] = new DAttrHelp("Min Static File Size (bytes)", 'Specifies the minimum size of a static file for which the server will create a corresponding compressed file.<br/><br/>Default value: 200', 'It is not necessary to compress very small files as the bandwidth saving is negligible.', 'Number in bytes not less than 200.', '');

$_tipsdb['gzipStaticCompressLevel'] = new DAttrHelp("GZIP Compression Level (Static File)", 'Specifies the level of GZIP compression applied to static files. Ranges from 1 (lowest) to 9 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; and &quot;Auto Update Static File&quot; are enabled.<br/><br/>Default value: 6', '', 'Number between 1 and 9.', '');

$_tipsdb['hardLimit'] = new DAttrHelp("Connection Hard Limit", 'Specifies the maximum number of allowed concurrent connections from a single IP address.  This limit is always enforced and a client will never be able to exceed this limit.   HTTP/1.0 clients usually try to set up as many connections as they need to download embedded  content at the same time. This limit should be set high enough so that HTTP/1.0 clients can still  access the site.   Use &quot;Connection Soft Limit&quot; to set the desired connection limit. <br/><br/>The recommended limit is between 20 and 50 depending on the content of your web page and your traffic load.', ' A lower number will enable serving more distinct clients.<br/> Trusted IPs or sub-networks are not affected. <br/> Set to a high value when you are performing benchmark tests with a large number of concurrent client machines.', 'Integer number', '');

$_tipsdb['httpdWorkers'] = new DAttrHelp("Number of Workers", 'Specifies the number of httpd workers.', ' Set an appropriate number to suit your needs. Adding more workers may not necessarily mean better performance.', 'Integer value between 1 and 16.', '');

$_tipsdb['inBandwidth'] = new DAttrHelp("Inbound Bandwidth (bytes/sec)", 'The maximum allowed incoming throughput from a single IP address, regardless of the number of connections established. The real bandwidth may end up being slightly higher than this setting for efficiency reasons.  Bandwidth is allocated in 1KB units. Set to 0 to disable throttling. Per-client bandwidth limits (bytes/sec) can be set at the server or virtual host level where virtual host level settings override server level settings.', ' Trusted IPs or sub-networks are not affected.', 'Integer number', '');

$_tipsdb['inMemBufSize'] = new DAttrHelp("Max I/O Buffer Size", 'Specifies the maximum buffer size that is used to store a request body and its dynamically generated response. When this limit is reached, the server will start to create temporary swapping files under &quot;Swapping Directory&quot;.', ' Set the buffer size large enough to accommodate all concurrent requests/replies to avoid memory to disk swapping. If there is frequent I/O activity to the swap directoy, by default /tmp/lshttpd/swap/, this buffer size is too low and LiteSpeed is swapping to disk.', 'Integer number', '');

$_tipsdb['indexFiles'] = new DAttrHelp("Index Files", 'Specifies names of index files that will be searched sequentially when a URL is mapped to a directory. You can customize it at the server, virtual host, and context level.', ' Only set index files that you need.', 'Comma-delimited list of index filenames.', '');

$_tipsdb['indexUseServer'] = new DAttrHelp("Use Server Index Files", 'Specifies whether to use the server&#039;s index file settings. If set to Yes, only the server&#039;s settings will be used. If set to No, the server&#039;s settings will not be used. If set to Addition, additional index files can be added to server&#039;s index file list for this virtual host. If you want to disable index files for this virtual host, you can set the value to No and leave the index files field empty.', '', 'Select from drop down list', '');

$_tipsdb['initTimeout'] = new DAttrHelp("Initial Request Timeout (secs)", 'Specifies the maximum time in seconds the server will wait for the external application to respond to the first request over a new established connection. If the server does not receive any data from the external application within this timeout limit, it will mark this connection as bad. This helps to identify communication problems with external applications as quickly as possible. If some requests take longer to process, increase this limit to avoid 503 error messages.', '', 'Integer number', '');

$_tipsdb['installpathprefix'] = new DAttrHelp("Installation Path Prefix", 'Sets the value for the &quot;--prefix&quot; configure option. The default installation location is under LiteSpeed Web Server&#039;s  install directory.', 'LiteSpeed Web Server can use multiple PHP versions at the same time. If you are installing multiple versions, you  should give them different prefixes.', 'path', '/usr/local/lsws/lsphp5');

$_tipsdb['instances'] = new DAttrHelp("Instances", 'Specifies the maximum instances of the external application the server will create. It is required if &quot;Start By Server&quot; is enabled. Most FastCGI/LSAPI applications can only process one request per process instance and for those types of applications, instances should be set to match the value of &quot;Max Connections&quot;. Some FastCGI/LSAPI applications can spawn multiple child processes to handle multiple requests concurrently. For these types of applications, instances should be set to &quot;1&quot; and environment variables used to control how many child processes the application can spawn.', '', 'Integer number', '');

$_tipsdb['internalmodule'] = new DAttrHelp("Is Internal", 'Specify whether the module is an internal module, which is statically linked, instead of being an external .so library.', '', 'Select from radio box', '');

$_tipsdb['ip2locDBCache'] = new DAttrHelp("DB Cache Type", 'The caching method used. The default value is Memory.', '', 'Select from drop down list', '');

$_tipsdb['ip2locDBFile'] = new DAttrHelp("IP2Location DB File Path", 'The location of a valid database file.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['javaServletEngine'] = new DAttrHelp("Servlet Engine", 'Specifies the name of the servlet engine that serves this web application. Servlet engines must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');

$_tipsdb['javaWebAppContext'] = new DAttrHelp("Java Web App Context", 'Many people running Java applications use the servlet engine to serve static content as well. But no servlet engine is nearly as efficient as LiteSpeed Web Server for these processes. In order to improve the overall performance, LiteSpeed Web Server can be configured as a gateway server, which serves static content and forwards dynamic Java page requests to the servlet engine.<br/><br/>LiteSpeed Web Server requires certain contexts to be defined in order to run a Java application. A Java Web App Context automatically creates all required contexts based on the Java web application&#039;s configuration file (WEB-INF/web.xml).<br/><br/>There are a few points you need to keep in mind when setting up a Java Web App Context:<br/><ul> <li>A Servlet Engine external application must be set up in &quot;External Apps&quot; before Java Web App Context can be set up.</li> <li>A &quot;Script Handler&quot; for .jsp files should be defined as well.</li> <li>If the web application is packed into a .war file, the .war file must be expanded. The server cannot access compressed archive files.</li> <li>For the same resources, the same URL should be used no matter whether it is accessed through LiteSpeed Web Server or through the servlet engine&#039;s built-in HTTP server.<br/>For example,   Tomcat 4.1 is installed under /opt/tomcat. Files for the &quot;examples&quot; web application are   located at /opt/tomcat/webapps/examples/. Through Tomcat&#039;s built-in HTTP server,   the &quot;examples&quot; web application is thus accessed with a URI like &quot;/examples/***&quot;.   The corresponding Java Web App Context should thus be configured:   &quot;URI&quot; = /examples/, &quot;Location&quot; = /opt/tomcat/webapps/examples/.</li>   </ul>', '', '', '');

$_tipsdb['javaWebApp_location'] = new DAttrHelp("Location", 'Specifies the directory that contains the files for this web application. This is the directory containing &quot;WEB-INF/web.xml&quot;.<br/><br/>Default value: $DOC_ROOT + &quot;URI&quot;', '', 'path', '');

$_tipsdb['keepAliveTimeout'] = new DAttrHelp("Keep-Alive Timeout (secs)", 'Specifies the maximum idle time between requests from a keep-alive connection. If no new request is received during this period of time, the connection will be closed. This setting only applies to HTTP/1.1 connections. HTTP/2 connections have long keep-alive timeouts by design and are not affected by this setting.', ' We recommend that you set this value just long enough to wait for subsequent requests from  a client when there are more assets referenced by a single page that need to be loaded. Do not set this too long hoping that  the next page will be served over the keep-alive connection. Keeping many idle keep-alive connections is a waste of server resources and could be taken advantage of by (D)DoS attacks. 2-5 seconds is a  reasonable range for most applications. LiteSpeed is highly efficient in a non-keep-alive environment.', 'Integer number', '');

$_tipsdb['keyFile'] = new DAttrHelp("Private Key File", 'The filename of the SSL private key file. The key file should not be encrypted.', ' The private key file should be placed in a secured directory that allows read-only access to the user the server runs as.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['lbContext'] = new DAttrHelp("Load Balancer Context", 'Like other external applications, load balancer worker applications cannot be used directly. They must be mapped to a URL through a context. A Load Balancer Context will associate a URI to be load balanced by the load balancer workers.', '', '', '');

$_tipsdb['lbapp'] = new DAttrHelp("Load Balancer", 'Specifies the name of the load balancer to be associated to this context. This load balancer is a virtual application, and must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');

$_tipsdb['listenerBinding'] = new DAttrHelp("Binding", 'Specifies which lshttpd child process the listener is assigned to. Different child processes can be used to handle requests to different listeners by manually associating a listener with a process. By default, a listener is assigned to all child processes.', '', 'Select from checkbox', '');

$_tipsdb['listenerIP'] = new DAttrHelp("IP Address", 'Specifies the IP of this listener. All available IP addresses are listed. IPv6 addresses are enclosed in &quot;[ ]&quot;. To listen on all IPv4 IP addresses, select ANY. To listen on all IPv4 and IPv6 IP addresses, select [ANY]. In order to serve both IPv4 and IPv6 clients, an IPv4-mapped IPv6 address should be used instead of a plain IPv4 address. An IPv4-mapped IPv6 address is written as [::FFFF:x.x.x.x].', ' If your machine has multiple IPs on different sub-networks, you can select a specific IP to only allow traffic from the corresponding sub-network.', 'Select from drop down list', '');

$_tipsdb['listenerModules'] = new DAttrHelp("Listener Modules", 'Listener module configuration data is, by default inherited from the Server module configuration.   The Listener Modules are limited to the TCP/IP Layer 4 hooks.', '', '', '');

$_tipsdb['listenerName'] = new DAttrHelp("Listener Name", 'A unique name for this listener.', '', '', '');

$_tipsdb['listenerPort'] = new DAttrHelp("Port", 'Specifies the TCP port of the listener. Only the super user (&quot;root&quot;) can use ports lower than 1024. Port 80 is the default HTTP port. Port 443 is the default HTTPS port.', '', 'Integer number', '');

$_tipsdb['listenerSecure'] = new DAttrHelp("Secure", 'Specifies whether this is a secure (SSL) listener. For secure listeners, additional SSL settings need to be set properly.', '', 'Select from radio box', '');

$_tipsdb['lmap'] = new DAttrHelp("Virtual Hosts Mappings", 'Shows currently established mappings to virtual hosts from a particular listener.  The virtual host name appears in brackets and is followed by the matching domain name(s) for this listener.', 'If a virtual host has not been loaded successfully (fatal errors in the  virtual host configuration), the mapping to that virtual host will not be displayed.', '', '');

$_tipsdb['lname'] = new DAttrHelp("Name - Listener", 'The unique name that identifies this listener. This is the  &quot;Listener Name&quot; you specified when setting up the listener.', '', '', '');

$_tipsdb['location'] = new DAttrHelp("Location", 'Specifies the corresponding location of this context in the file system.<br/><br/>Default value: $DOC_ROOT + &quot;URI&quot;', '', 'It can be an absolute path or path relative to $SERVER_ROOT, $VH_ROOT, or $DOC_ROOT. $DOC_ROOT is the default relative path, and can be omitted.<br/><br/>If the &quot;URI&quot; is a regular expression, then the matched sub-string can be used to form the &quot;Root&quot; string. The matched sub-string can be referenced with the values &quot;$1&quot; - &quot;$9&quot;. &quot;$0&quot; and &quot;&&quot; can be used to reference the whole matched string. Additionally, a query string can be set by appending a &quot;?&quot; followed by the query string. Be careful. &quot;&&quot; should be escaped as &quot;\&&quot; in the query string.', 'A plain URI like /examples/ with &quot;Location&quot; set to /home/john/web_examples will map the request &quot;/examples/foo/bar.html&quot; to file &quot;/home/john/web_examples/foo/bar.html&quot;.<br/>To simulate Apache&#039;s mod_userdir, set URI to exp: ^/~([A-Za-z0-9]+)(.*), set &quot;Location&quot; to /home/$1/public_html$2. With these settings, a request of URI /~john/foo/bar.html will map to file /home/john/public_html/foo/bar.html.');

$_tipsdb['logUseServer'] = new DAttrHelp("Use Server's Log", 'Specifies whether to put log messages from this virtual host into the server  log file instead of creating its own log file.', '', 'Select from radio box', '');

$_tipsdb['log_debugLevel'] = new DAttrHelp("Debug Level", 'Specifies the level of debug logging.  &quot;Log Level&quot; must be set to DEBUG to use this feature.  Debug logging is disabled when &quot;Debug Level&quot; is set to NONE even if &quot;Log Level&quot; is set to DEBUG.  &quot;Toggle Debug Logging&quot; can be used to control debug level on a live server without restarting.', ' Important! Always set this to NONE if you do not need detailed debug logging. Active debug logging will severely degrade service performance and potentially saturate disk space in a very short time. Debug logging includes detailed information for each request and response.<br/><br/>It&#039;s recommended to set Log Level to DEBUG and Debug Level to NONE.  These settings mean that you will not fill up your hard disk with debug logging,  but you will be able to use the &quot;Toggle Debug Logging&quot; action to control debug output.  This action can turn debug logging on and off on the fly, and is useful for debugging busy production servers.', 'Select from drop down list', '');

$_tipsdb['log_enableStderrLog'] = new DAttrHelp("Enable stderr Log", 'Specifies whether to write to log when receiving stderr output from any process started by the server.  If enabled, stderr messages will be logged in the same directory as the server log with  the fixed name &quot;stderr.log&quot;. If disabled, all stderr output will be discarded.', 'Turn it on if you need to debug configured external applications: i.e. PHP, Ruby, Java, Python, Perl.', 'Select from radio box', '');

$_tipsdb['log_fileName'] = new DAttrHelp("File Name", 'Specifies the path for the log file.', ' Place the log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['log_logLevel'] = new DAttrHelp("Log Level", 'Specifies the level of logging to include in your log file.  Available levels (from high to low) are: ERROR,  WARNING, NOTICE, INFO and DEBUG.  Only messages with level higher or equal to the current setting will be logged.', ' Using DEBUG log level does not have any performance impact, unless &quot;Debug Level&quot; is set to a level other than NONE. It&#039;s recommended to set Log Level to DEBUG and Debug Level to NONE. These settings mean that you will not fill up your  hard disk with debug logging, but you will be able to use the &quot;Toggle Debug Logging&quot;  action to control debug output. This action can turn debug logging on and off on the fly,   and is useful for debugging busy production servers.', 'Select from drop down list', '');

$_tipsdb['log_rollingSize'] = new DAttrHelp("Rolling Size (bytes)", 'Specifies when the current log file needs to be rolled over, also known as log rotation.  When the file size is over the rollover limit, the active log file will be renamed  to log_name.mm_dd_yyyy(.sequence) in the same directory and a new active log file will be created. The actual size of the rotated log file once it is created will sometimes be a little bigger than  this size limit. Set to 0 to disable log rotation.', 'Append &quot;K&quot;, &quot;M&quot;, &quot;G&quot; to the number for kilo-, mega- and giga- bytes.', 'Integer number', '');

$_tipsdb['lsapiContext'] = new DAttrHelp("LiteSpeed SAPI Context", 'External applications cannot be used directly. They must be either configured as a script handler or mapped to a URL through a context. An LiteSpeed SAPI Context will associate a URI with an LSAPI (LiteSpeed Server Application Programming Interface) application. Currently PHP, Ruby and Python have LSAPI modules. LSAPI, as it is developed specifically for LiteSpeed web server, is the most efficient way to communicate with LiteSpeed web server.', '', '', '');

$_tipsdb['lsapiapp'] = new DAttrHelp("LiteSpeed SAPI App", 'Specifies the name of the LiteSpeed SAPI application to be connected to this context. This application must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');

$_tipsdb['lsrecaptcha'] = new DAttrHelp("reCaptcha Protection", 'reCaptcha Protection is a service provided as a way to mitigate heavy server load. reCaptcha Protection will activate after one of the below situations is hit. Once active, all requests by NON TRUSTED(as configured) clients will be redirected to a reCAPTCHA validation page. After validation, the client will be redirected to their desired page.<br/><br/>The following situations will activate reCaptcha Protection:<br/>1. The server or vhost concurrent requests count passes the configured connection limit.<br/>2. Anti-DDoS is enabled and a client is hitting a url in a suspicious manner. The client will redirect to reCAPTCHA first instead of getting denied when triggered.<br/>3. WP Brute Force protection is enabled and action is set to &#039;Captcha or Drop’. When a brute force attack is detected, the client will redirect to reCAPTCHA first. After max tries is reached, the connection will be dropped, as per the ‘drop’ option.<br/>4. A new rewrite rule environment is provided to activate reCAPTCHA via RewriteRules. &#039;verifycaptcha&#039; can be set to redirect clients to reCAPTCHA. A special value &#039;: deny&#039; can be set to deny the client if it failed too many times. For example, [E=verifycaptcha] will always redirect to reCAPTCHA until verified. [E=verifycaptcha: deny] will redirect to reCAPTCHA until Max Tries is hit, after which the client will be denied.', '', '', '');

$_tipsdb['lstatus'] = new DAttrHelp("Status - Listener", 'The current status of this listener. The status is either Running or Error.', 'If the listener is in the Error state, you can view the server log to find out why.', '', '');

$_tipsdb['mappedListeners'] = new DAttrHelp("Mapped Listeners", 'Specifies the names of all listeners that this template maps to. A listener-to-virtual host mapping for this template&#039;s member virtual hosts will be added to the listeners specified in this field. This mapping will map listeners to virtual hosts based on the domain names and aliases set in the member virtual hosts&#039; individual configurations.', '', 'comma-separated list', '');

$_tipsdb['maxCGIInstances'] = new DAttrHelp("Max CGI Instances", 'Specifies the maximum number of concurrent CGI processes the server can start.  For each request to a CGI script, the server needs to start a standalone CGI process.  On a Unix system, the number of concurrent processes is limited. Excessive  concurrent processes will degrade the performance of the whole system and are one way to perform a DoS attack.  LiteSpeed server pipelines requests to CGI scripts  and limits concurrent CGI processes to ensure the optimal performance and reliability.  The hard limit is 2000.', ' A higher limit does not necessarily translate to faster performance.  In most cases, a lower limit gives better performance and security. A higher limit will only help  when I/O latency is excessive during CGI processing.', 'Integer number', '');

$_tipsdb['maxCachedFileSize'] = new DAttrHelp("Max Cached Small File Size (bytes)", 'Specifies the largest static file that will be cached in a pre-allocated memory buffer. Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write, and sendfile(). Files whose size is smaller than this setting are served from memory buffer cache. Files whose size is larger than this setting, but smaller than the &quot;Max MMAP File Size (bytes)&quot; will be served from memory-mapped cache. Files whose size is larger than the &quot;Max MMAP File Size (bytes)&quot; will be served via plain read/write or sendfile(). It is optimal to serve static files smaller than 4K from the memory buffer cache.', '', 'Integer number', '');

$_tipsdb['maxConnections'] = new DAttrHelp("Max Connections", 'Specifies the maximum number of concurrent connections that the server can accept. This includes both plain TCP connections and SSL connections. Once the maximum concurrent connections limit is reached, the server will close Keep-Alive connections when they complete active requests.', 'When the server is started by &quot;root&quot; user, the server will try to adjust the per-process file descriptor limits automatically, however, if this fails, you may need to increase this limit manually.', 'Integer number', '');

$_tipsdb['maxConns'] = new DAttrHelp("Max Connections", 'Specifies the maximum number of concurrent connections that can be established between the server and an external application. This setting controls how many requests can be processed concurrently by an external application, however, the real limit also depends on the external application itself. Setting this value higher will not help if the external application is not fast enough or cannot scale to a large number of concurrent requests.', ' Setting a high value does not directly translate to higher performance. Setting the limit to a value that will not overload the external application will provide the best performance/throughput.', 'Integer number', '');

$_tipsdb['maxDynRespHeaderSize'] = new DAttrHelp("Max Dynamic Response Header Size (bytes)", 'Specifies the maximum header size of a dynamically generated response. Hard limit is 64KB.<br/><br/>Default value: 16KB', ' Set it reasonably low to help recognize bad responses dynamically generated by external applications.', 'Integer number', '');

$_tipsdb['maxDynRespSize'] = new DAttrHelp("Max Dynamic Response Body Size (bytes)", 'Specifies the maximum body size of a dynamically generated response. Hard limit is 2047MB.', ' Set the limit reasonably low to help identify bad responses. It is not uncommon to malformed scripts to contain an infinite loop which leads to infinity-sized responses.', 'Integer number', '');

$_tipsdb['maxKeepAliveReq'] = new DAttrHelp("Max Keep-Alive Requests", 'Specifies the maximum number of requests that can be served through a keep-alive (persistent) session. The connection will be closed once this limit is reached. You can set this limit for each virtual host as well.', ' Set this to a reasonably high value. A value of &quot;1&quot; or &quot;0&quot; will disable keep-alive.', 'Integer number', '');

$_tipsdb['maxMMapFileSize'] = new DAttrHelp("Max MMAP File Size (bytes)", 'Specifies the largest static file that will be memory mapped (MMAP).  Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write, and sendfile(). Files whose size is smaller than the &quot;Max Cached Small File Size (bytes)&quot; are served from memory buffer cache. Files whose size is larger than the  &quot;Max Cached Small File Size (bytes)&quot;, but smaller than the Max MMAP File Size  will be served from memory-mapped cache. Files whose size is larger than the Max MMAP File Size will be served via plain read/write or sendfile(). Since the server has a 32bit address space (2GB), it is not recommended to memory map very large files.', '', 'Integer number', '');

$_tipsdb['maxMindDBEnv'] = new DAttrHelp("Environment Variables", 'Assign the results of database lookups to environment variables.', '', 'Variable_Name mapped_DB_data<br/><br/>One entry per line. Path to data can use map keys or 0-based array indexes, both being separated by /.', 'COUNTRY_CODE COUNTRY_DB/country/iso_code<br/>REGION_CODE  CITY_DB/subdivisions/0/iso_code');

$_tipsdb['maxReqBodySize'] = new DAttrHelp("Max Request Body Size (bytes)", 'Specifies the maximum size of an HTTP request body. For a 32Bit OS, 2GB is the hard limit.  For a 64Bit OS, it is virtually unlimited.', ' To help prevent DoS attacks, try to constrain this limit to only what is really needed. Your swapping space must have enough free space to accommodate this limit.', 'Integer number', '');

$_tipsdb['maxReqHeaderSize'] = new DAttrHelp("Max Request Header Size (bytes)", 'Specifies the maximum size of an HTTP request header including request URL. Hard limit is 16380 bytes.', ' Set it reasonably low to reduce memory usage and help identify bogus requests and DoS attacks.<br/>4-8K is big enough for most web sites.', 'Integer number', '');

$_tipsdb['maxReqURLLen'] = new DAttrHelp("Max Request URL Length (bytes)", 'Specifies the maximum size of a request URL. URL is the full text address used to access a server resource including the query string. 64K bytes is the hard limit.', ' Set it reasonably low to reduce memory usage and help identify bogus requests and DoS attacks.<br/>2-3K is big enough for most web sites unless the HTTP GET method is used with large query strings instead of POST.', 'Integer number', '');

$_tipsdb['maxSSLConnections'] = new DAttrHelp("Max SSL Connections", 'Specifies the maximum number of concurrent SSL connections the server will accept. Since total concurrent SSL and non-SSL connections cannot exceed the limit specified by &quot;Max Connections&quot;, the actual number of concurrent SSL connections allowed must be lower than this limit.', '', 'Integer number', '');

$_tipsdb['memHardLimit'] = new DAttrHelp("Memory Hard Limit (bytes)", 'Much the same as &quot;Memory Soft Limit (bytes)&quot;, except the soft limit can be raised up to the hard limit from within a user process. The hard limit can be set at server level or at an individual external application level. The server-level limit will be used if   it is not set at an individual application level. <br/><br/>The operating system&#039;s default will be used if the value is absent at both levels or set to 0.', ' Do not over adjust this limit. This may result in 503 errors if your application need more memory.', 'Integer number', '');

$_tipsdb['memSoftLimit'] = new DAttrHelp("Memory Soft Limit (bytes)", 'Specifies the memory consumption limit in bytes for an external application process or an external application started by the server.  <br/><br/>The main purpose of this limit is to prevent excessive memory usage because of software bugs or intentional attacks, not to impose a limit on normal usage. Make sure to leave enough head room, otherwise your application may fail and 503 error may be returned. It can be set at the server- level or at an individual external application level. The server-level limit will be used if it is not set at the individual application level.<br/><br/>The operating system&#039;s default setting will be used if the value is absent at both levels or set to 0.', ' Do not over adjust this limit. This may result in 503 errors if your application needs more memory.', 'Integer number', '');

$_tipsdb['memberVHRoot'] = new DAttrHelp("Member Virtual Host Root", 'Specifies the root directory of this virtual host. If left blank, the default virtual host root for this template will be used.<br/><br/>Note: This is <b>NOT</b> the document root. It is recommended to place all files related to the virtual host (like virtual host configuration, log files, html files, CGI scripts, etc.) under this directory. Virtual host root can be referred to as $VH_ROOT.', '', 'path', '');

$_tipsdb['mime'] = new DAttrHelp("MIME Settings", 'Specifies the file that contains the MIME settings for this server. It is always relative to the real root when an absolute path is given in chroot mode. Click on the filename to view/edit the detailed MIME entries.', 'Click the filename to edit the MIME settings.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['mimesuffix'] = new DAttrHelp("Suffixes", 'You can list multiple suffixes for the same MIME type, using comma to separate.', '', '', '');

$_tipsdb['mimetype'] = new DAttrHelp("MIME Type", 'A MIME type consists of a type and subtype in the format of &quot;type/subtype&quot;.', '', '', '');

$_tipsdb['minGID'] = new DAttrHelp("Minimum GID", 'Specifies the minimum group ID allowed to run external applications when running as a specified group. Execution of an external script with a group ID lower than the value specified here will be denied.', ' Set it high enough to exclude all groups used by system users.', 'Integer number', '');

$_tipsdb['minUID'] = new DAttrHelp("Minimum UID", 'Specifies the minimum user ID allowed to run external applications when running as a specified user. Execution of an external script with a user ID lower than the value specified here will be denied.', ' Set it high enough to exclude all system/privileged users.', 'Integer number', '');

$_tipsdb['modParams'] = new DAttrHelp("Module Parameters", 'Set module parameters. The module parameters are defined by the module developer.<br/><br/>Set the value in the Server configuration to globally assign the default value.  The user can override this setting at the Listener, Virtual Host or Context levels. If the &#039;Not Set&#039; radio button is selected, it will be inherited from the upper level.', '', 'Specified by the module interface.', '');

$_tipsdb['moduleContext'] = new DAttrHelp("Module Handler Context", 'A module handler context will associate a URI with a registered module. Modules need to be registered at Server Module Configuration tab.', '', '', '');

$_tipsdb['moduleEnabled'] = new DAttrHelp("Enable Module", 'Enables module hooks globally. This setting can be overridden at the Listener and Virtual Host levels.<br/><br/>Default value: Yes', '', 'Select from radio box', '');

$_tipsdb['moduleEnabled_lst'] = new DAttrHelp("Enable Module", 'Enables module hooks at the Listener level. This setting will only take effect if the module has TCP/IP level hooks (L4_BEGSESSION, L4_ENDSESSION, L4_RECVING, L4_SENDING).<br/><br/>Default value: Inherit Server level setting', '', 'Select from radio box', '');

$_tipsdb['moduleEnabled_vh'] = new DAttrHelp("Enable Module", 'Enables module hooks at the Virtual Host level. This setting will only take effect if the module has HTTP level hooks.<br/><br/>Default value: Inherit Server level setting', '', 'Select from radio box', '');

$_tipsdb['moduleNameSel'] = new DAttrHelp("Module", 'Name of the module. The module must be registered under the Server Module Configuration tab. Once it is registered, the module name will be available in the drop down box for the Listener and Virtual Host configurations.', '', 'Select from drop down list', '');

$_tipsdb['modulename'] = new DAttrHelp("Module", 'Name of the module. The module name will be the same as the module filename.  The module file must be located under $SERVER_ROOT/modules/modulename.so in order to be loaded by the server application. The server will load the registered modules at start up. This requires that the server is restarted after new modules are registered.', '', 'the library name of .so.', '');

$_tipsdb['nodeBin'] = new DAttrHelp("Node Path", 'Path to Node.js executable.', '', 'Absolute path', '');

$_tipsdb['nodeDefaults'] = new DAttrHelp("Node.js App Default Settings", 'Default configurations for Node.js applications. These settings can be overriden at the context level.', '', '', '');

$_tipsdb['note'] = new DAttrHelp("Notes", 'Add notes for yourself.', '', '', '');

$_tipsdb['ocspCACerts'] = new DAttrHelp("OCSP CA Certificates", 'Specifies the location of the file where OCSP certificate authority (CA) certificates are stored. These certificates are used to check responses from the OCSP responder (and make sure those responses are not spoofed or otherwise compromised). This file should contain the whole certificate chain. If this file does not contain the root certificate, LSWS should be able to find the root certificate in your system directory without you adding it to the file, but, if this validation fails, you should try adding your root certificate to this file.<br/><br/>This setting is optional. If this setting is not set, the server will automatically check &quot;CA Certificate File&quot;.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['ocspRespMaxAge'] = new DAttrHelp("OCSP Response Max Age (secs)", 'This option sets the maximum allowable age for an OCSP response. If an OCSP response is older than this maximum age, the server will contact the OCSP responder for a new response. The default value is 86400. Maximum age can be turned off by setting this value to -1.', '', 'Integer of seconds', '');

$_tipsdb['ocspResponder'] = new DAttrHelp("OCSP Responder", 'Specifies the URL of the OCSP responder to be used. If not set, the server will attempt to contact the OCSP responder detailed in the certificate authority&#039;s issuer certificate. Some issuer certificates may not have an OCSP responder URL specified.', '', 'URL starting with http://', 'http://rapidssl-ocsp.geotrust.com ');

$_tipsdb['outBandwidth'] = new DAttrHelp("Outbound Bandwidth (bytes/sec)", 'The maximum allowed outgoing throughput to a single IP address, regardless of the number of connections established. The real bandwidth may end up being slightly higher than this setting for efficiency reasons.  Bandwidth is allocated in 4KB units. Set to 0 to disable throttling. Per-client bandwidth limits (bytes/sec) can be set at the server or virtual host level where virtual host level settings override server level settings.', ' Set the bandwidth in 8KB units for better performance.<br/><br/> Trusted IPs or sub-networks are not affected.', 'Integer number', '');

$_tipsdb['pcKeepAliveTimeout'] = new DAttrHelp("Connection Keepalive Timeout", 'Specifies the maximum time in seconds to keep an idle persistent connection open.<br/><br/>When set to &quot;-1&quot;, the connection will never timeout. When set to 0 or greater, the connection will be closed after this time in seconds has passed.', '', 'int', '');

$_tipsdb['perClientConnLimit'] = new DAttrHelp("Per Client Throttling", 'These are connection control settings are based on client IP.  These settings help to mitigate DoS (Denial of Service) and DDoS (Distributed Denial of Service) attacks.', '', '', '');

$_tipsdb['persistConn'] = new DAttrHelp("Persistent Connection", 'Specifies whether to keep the connection open after a request has been processed. Persistent connections can increase performance, but some FastCGI external applications do not support persistent connections fully. The default is &quot;On&quot;.', '', 'Select from radio box', '');

$_tipsdb['phpIniOverride'] = new DAttrHelp("php.ini Override", 'Used to overwrite php.ini settings in the current context (Virtual Host level or Context level).<br/><br/>Supported directives are:<br/>php_value<br/>php_flag<br/>php_admin_value<br/>php_admin_flag<br/><br/>All other lines/directives will be ignored.', '', 'Override syntax is similar to Apache, a newline separated list of directives and their values with each directive being prepended by php_value, php_flag, php_admin_value, or php_admin_flag appropriately.', 'php_value include_path &quot;.:/usr/local/lib/php&quot;<br/>php_admin_flag engine on<br/>php_admin_value open_basedir &quot;/home&quot;');

$_tipsdb['pid'] = new DAttrHelp("PID", 'PID (Process ID) of the current server process.', 'The PID will change each time the server is restarted.', '', '');

$_tipsdb['procHardLimit'] = new DAttrHelp("Process Hard Limit", 'Much the same as &quot;Process Soft Limit&quot;, except the soft limit can be raised up to the hard limit from within a user process. The hard limit can be set at the server level or at an   individual external application level. The server-level limit will be used if it is not set at an individual application level.    The operating system&#039;s default value will be used if the value is absent at both levels or set to 0.', '', 'Integer number', '');

$_tipsdb['procSoftLimit'] = new DAttrHelp("Process Soft Limit", 'Limits the total number of processes that can be created on behalf of a user. All existing processes will be counted against this limit, not just new processes to be started.<br/><br/>The limit can be set at the server level or at an individual external application level. The server-level limit will be used if it is not set at an individual application level. The operating system&#039;s default setting will be used if this value is 0 or absent at both levels.', 'PHP scripts can call for forking processes. The main purpose of this limit is as a last line of defense to prevent fork bombs and other attacks caused by PHP processes creating other processes.<br/><br/>Setting this setting too low can severely hurt functionality. The setting will thus be ignored below certain levels.<br/><br/>When <b>Run On Start Up</b> is set to &quot;Yes (Daemon mode)&quot;, the actual process limit will be higher than this setting to make sure parent processes are not limited.', 'Integer number', '');

$_tipsdb['proxyContext'] = new DAttrHelp("Proxy Context", 'A Proxy Context enables this virtual host as a transparent reverse proxy server. This proxy server can run in front of any web servers or application servers that support HTTP protocol. The External web server that this virtual host proxies for  has to be defined in &quot;External Apps&quot; before you can set up a Proxy Context.', '', '', '');

$_tipsdb['proxyWebServer'] = new DAttrHelp("Web Server", 'Specifies the name of the external web server. This external web server must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');

$_tipsdb['railsDefaults'] = new DAttrHelp("Rack/Rails Default Settings", 'Default configurations for Rack/Rails applications. These settings can be overriden at the context level.', '', '', '');

$_tipsdb['rcvBufSize'] = new DAttrHelp("Receive Buffer Size (bytes)", 'The receiving buffer size of each TCP socket. 512K is the maximum allowed buffer size.', ' It is recommended to leave this value as &quot;Not Set&quot; or set to 0 to use the operating system&#039;s default buffer size.<br/> A large receive buffer will increase performance when processing  incoming requests with large payloads, i.e. file uploads.<br/> Setting this to a lower value will reduce throughput and memory usage per socket allowing the server to have more concurrent sockets when memory is a bottleneck.', 'Integer number', '');

$_tipsdb['realm'] = new DAttrHelp("Realm", 'Specifies the authorization realm for this context. When specified, a valid username and password must be provided in order to access this context. &quot;Authorization Realms&quot; are set up in the &quot;Virtual Host Security&quot; section. This setting uses each realm&#039;s &quot;Realm Name&quot;.', '', 'Select from drop down list', '');

$_tipsdb['realmName'] = new DAttrHelp("Realm Name", 'Specifies a unique name for the authorization realm.', '', '', '');

$_tipsdb['realms'] = new DAttrHelp("Authorization Realms", 'Lists all authorization realms for this virtual host.  Authorization realms are used to block unauthorized users from accessing protected web pages. A realm is a user directory containing usernames and passwords with optional  group classifications. Authorization is performed at context level.  Since different contexts can share the same realm (user database), so realms are  defined separately from the contexts that use them.  You can refer to a realm by these names in context configuration.', '', '', '');

$_tipsdb['realtimerpt'] = new DAttrHelp("Real-Time Statistics", 'The Real-Time Statistics link leads to a page with a real-time server status report. This is a convenient tool to monitor the system.    The report shows a snapshot of your server statistics. The refresh rate for this snapshot  is controlled by the Refresh Interval drop-down list in the upper righthand corner.   The report contains the following sections: <ul><li>Server Health shows the basic server statistics, uptime, load, and anti-DDoS blocked IPs.</li>   <li>Server lists current traffic throughput, connections, and requests statistics.</li>  <li>Virtual Host shows request processing statuses and external application statuses for each virtual host.</li>  <li>External Application lists the external applications currently running and their usage statistics.   The CGI daemon process lscgid is always running as an external application.</li> </ul>   Many of the rows in the Real-Time Statistics feature a graph icon.  Clicking on this icon will open a graph of that row&#039;s statistics updated in real-time.   In the Server section, next to Requests, there is a link labeled (Details).  This link takes you to the Requests Snapshot, where you can view detailed information  on which clients are making certain kinds of requests or which aspects of your site  are bottlenecking. The fields in the blue area allow you to filter the snapshot to isolate  certain parts of your server or look for clients that are performing certain actions.', '', '', '');

$_tipsdb['recaptchaAllowedRobotHits'] = new DAttrHelp("Allowed Robot Hits", 'Number of hits per 10 seconds to allow ‘good bots’ to pass. Bots will still be throttled when the server is under load.<br/><br/>Default value is 3.', '', 'Integer number', '');

$_tipsdb['recaptchaBotWhiteList'] = new DAttrHelp("Bot White List", 'List of custom user agents to allow access. Will be subject to the ‘good bots’ limitations, including allowedRobotHits.', '', 'List of user agents, one per line. Regex is supported.', '');

$_tipsdb['recaptchaMaxTries'] = new DAttrHelp("Max Tries", 'Max Tries specifies the maximum number of reCAPTCHA attempts permitted before denying the visitor.<br/><br/>Default value is 3.', '', 'Integer number', '');

$_tipsdb['recaptchaRegConnLimit'] = new DAttrHelp("Connection Limit", 'The number of concurrent connections (SSL & non-SSL) needed to activate reCAPTCHA. reCAPTCHA will be used until concurrent connections drop below this number.<br/><br/>Default value is 15000.', '', 'Integer number', '');

$_tipsdb['recaptchaSecretKey'] = new DAttrHelp("Secret Key", 'The secret key is the private key provided by Google via its reCAPTCHA service. A default Secret Key will be used if not set.', '', '', '');

$_tipsdb['recaptchaSiteKey'] = new DAttrHelp("Site Key", 'The site key is the public key provided by Google via its reCAPTCHA service. A default Site Key will be used if not set.', '', '', '');

$_tipsdb['recaptchaSslConnLimit'] = new DAttrHelp("SSL Connection Limit", 'The number of concurrent SSL connections needed to activate reCAPTCHA. reCAPTCHA will be used until concurrent connections drop below this number.<br/><br/>Default value is 10000.', '', 'Integer number', '');

$_tipsdb['recaptchaType'] = new DAttrHelp("reCAPTCHA Type", 'Specify the reCAPTCHA type to use with the key pairs. If a key pair has not been provided and this setting is set to Not Set, a default key pair of type Invisible will be used.<br/>Checkbox will display a checkbox reCAPTCHA for the visitor to validate.<br/>Invisible will attempt to validate the reCAPTCHA automatically and if successful, will redirect to the desired page.<br/><br/>Default value is Invisible.', '', 'Select from drop down list', '');

$_tipsdb['recaptchaVhReqLimit'] = new DAttrHelp("Concurrent Request Limit", 'The number of concurrent requests needed to activate reCAPTCHA. reCAPTCHA will be used until concurrent requests drop below this number.<br/><br/>Default value is 15000.', '', 'Integer number', '');

$_tipsdb['redirectContext'] = new DAttrHelp("Redirect Context", 'A Redirect Context can be used to forward one URI or a group of URIs to another location. The destination URI can be either on the same web site (an internal redirect) or an absolute URI pointing to another web site (an external redirect).', '', '', '');

$_tipsdb['renegProtection'] = new DAttrHelp("SSL Renegotiation Protection", 'Specifies whether to enable SSL Renegotiation Protection to defend against SSL handshake-based attacks. The default value is &quot;Yes&quot;.', 'This setting can be enabled at the listener and virtual host levels.', 'Select from radio box', '');

$_tipsdb['required'] = new DAttrHelp("Require (Authorized Users/Groups)", 'Specifies which user/group can access this context. This allows you to use one user/group database (specified in &quot;Realm&quot;) across a number of contexts, but only allow certain users/groups from that database to access this context.', '', 'Syntax is compatible with Apache&#039;s Require directive. For example: <ul> <li>user username [username ...]<br/>Only listed users can access this context.</li> <li> group groupid [groupid ...]<br/>Only users belonging to the listed groups can access this context.</li> </ul> If this setting is not specified, all valid users will be allowed to access this resource.', '');

$_tipsdb['requiredPermissionMask'] = new DAttrHelp("Required Permission Mask", 'Specifies the required permission mask for static files that the server will serve. For example, if only files that are readable by everyone can be served, set the value to 0004. See man 2 stat for all values.', '', 'octal numbers', '');

$_tipsdb['respBuffer'] = new DAttrHelp("Response Buffering", 'Specifies whether to buffer responses received from external applications. If a &quot;nph-&quot; (Non-Parsed-Header) script is detected, buffering is turned off for responses with full HTTP headers.', '', 'Select from drop down list', '');

$_tipsdb['restart'] = new DAttrHelp("Apply Changes/Graceful Restart", 'By clicking Graceful Restart, a new server process will be started.  For Graceful Restart, the old server process will only exit after all requests  to it have been finished (or the &quot;Graceful Restart Timeout (secs)&quot; limit has been reached).   Configuration changes are applied at the next restart.  Graceful Restart will apply these changes without any server downtime.', 'Graceful restart takes less than 2 seconds to generate a new server process.', '', '');

$_tipsdb['restrained'] = new DAttrHelp("Restrained", 'Specifies whether files beyond this virtual host root($VH_ROOT) can be accessed  though this web site. If set to Yes, only files under $VH_ROOT can be accessed   and access to symbolic links or context pointing to files or directories beyond $VH_ROOT  will be denied. This, however, does not limit the accessibility of CGI scripts. This is useful  in the shared hosting environment. &quot;Follow Symbolic Link&quot; can be set to Yes to allow  users to use symbolic links under $VH_ROOT, but not anything beyond $VH_ROOT.', ' Turn it on in the shared hosting environment.', 'Select from radio box', '');

$_tipsdb['restrictedDirPermissionMask'] = new DAttrHelp("Script Directory Restricted Permission Mask", 'Specifies the restricted permission mask of parent directories of script files that the server will not serve. For example, to prohibit serving PHP scripts in a directory that is group and world writable, set the mask to 022. Default value is 000. This option can be used to prevent serving scripts under a directory of  uploaded files. <br/><br/>See man 2 stat for all values.', '', 'octal numbers', '');

$_tipsdb['restrictedPermissionMask'] = new DAttrHelp("Restricted Permission Mask", 'Specifies the restricted permission mask for static files that the server will not serve. For example, to prohibit serving files that are executable, set the mask to 0111.<br/><br/>See man 2 stat for all values.', '', 'octal numbers', '');

$_tipsdb['restrictedScriptPermissionMask'] = new DAttrHelp("Script Restricted Permission Mask", 'Specifies the restricted permission mask for script files that the server will not serve. For example, to prohibit serving PHP scripts that are group and world writable, set the mask to 022. Default value is 000.<br/><br/>See man 2 stat for all values.', '', 'octal numbers', '');

$_tipsdb['retryTimeout'] = new DAttrHelp("Retry Timeout (secs)", 'Specifies the period of time that the server waits before retrying an external application that had a prior communication problem.', '', 'Integer number', '');

$_tipsdb['rewriteBase'] = new DAttrHelp("Rewrite Base", 'Specifies the base URL for rewrite rules.', '', 'URL', '');

$_tipsdb['rewriteInherit'] = new DAttrHelp("Rewrite Inherit", 'Specifies whether to inherit rewrite rules from parent contexts. If rewrite is enabled and not inherited, rewrite base and rewrite rules defined in this context will be used.', '', 'Select from radio box', '');

$_tipsdb['rewriteLogLevel'] = new DAttrHelp("Log Level", 'Specifies the level of detail of the rewrite engine&#039;s debug output. This value ranges from 0 - 9. 0 disables logging. 9 produces the most detailed log. The server and virtual host&#039;s error log &quot;Log Level&quot;  must be set to at least INFO for this option to take effect. This is useful when testing rewrite rules.', '', 'Integer number', '');

$_tipsdb['rewriteMapLocation'] = new DAttrHelp("Location", 'Specifies the location of the rewrite map using the syntax MapType:MapSource.<br/>LiteSpeed&#039;s rewrite engine supports three types of rewrite maps: <ul> 	<li><b>Standard Plain Text</b> <blockquote> 		<b>MapType:</b> txt; <br/>		<b>MapSource:</b> file path to a valid plain ASCII file.  </blockquote> 		Each line of this file should contain two elements separated  		by blank spaces. The first element is the key and the second 		element is the value. Comments can be added with a leading &quot;#&quot; 		sign.  	</li> 	<li><b>Randomized Plain Text</b> <blockquote> 		<b>MapType:</b> rnd;<br/>		<b>MapSource:</b> file path of a valid plain ASCII file. </blockquote> 		File format is similar to the Standard Plain Text file, except that the 		second element can contain multiple choices separated by a &quot;|&quot; 		sign and chosen randomly by the rewrite engine. 	</li> 	<li><b>Internal Function</b> <blockquote> 	    <b>MapType:</b> int;<br/>		<b>MapSource:</b> Internal string function  </blockquote> 		4 functions are available: 		<ul> 			<li><b>toupper:</b> converts lookup key to upper cases.</li> 			<li><b>tolower:</b> converts lookup key to lower cases.</li> 			<li><b>escape:</b> perform URL encoding on lookup key.</li> 			<li><b>unescape:</b> perform URL decoding on lookup key.</li> 		</ul> 	</li> 	The following map types available in Apache 	have not been implemented in LiteSpeed:<br/>Hash File and External Rewriting Program. </ul> The implementation of LiteSpeed&#039;s rewrite engine follows the specifications of Apache&#039;s rewrite engine. For more details about rewrite map, please refer to <a href="http://httpd.apache.org/docs/current/mod/mod_rewrite.html" target="_blank" rel="noopener noreferrer">Apache&#039;s mod_rewrite document</a>.', '', 'String', '');

$_tipsdb['rewriteMapName'] = new DAttrHelp("Name", 'Specifies a unique name for the rewrite map at the virtual host  level. This name will be used by a mapping-reference in rewrite rules. When referencing this name, one of the following syntaxes should be used: <blockquote><code> $\{MapName:LookupKey\}<br/>$\{MapName:LookupKey|DefaultValue\} </code></blockquote><br/>The implementation of LiteSpeed&#039;s rewrite engine follows the specifications of Apache&#039;s rewrite engine. For more details about rewrite maps, please refer to <a href="http://httpd.apache.org/docs/current/mod/mod_rewrite.html" target="_blank" rel="noopener noreferrer">Apache&#039;s mod_rewrite document</a>.', '', 'string', '');

$_tipsdb['rewriteRules'] = new DAttrHelp("Rewrite Rules", 'Specifies a list of rewrite rules at the virtual host level.<br/><br/>Do NOT add any document root level rewrite rules here. If you have any document root level rewrite rules from .htaccess,  you should instead create a static context with uri &quot;/&quot; and add the rewrite rules there.<br/><br/>A rewrite rule is comprised of one RewriteRule directive and optionally preceded by multiple RewriteCond directives.  <ul> <li>Each directive should take only one line. </li> <li>RewriteCond and RewriteRule follow Apache&#039;s rewrite directive syntax. Just copy and paste rewrite directives from your Apache configuration files.</li> <li>There are minor differences between LiteSpeed and Apache mod_rewrite implementation:  <ul><li>%\{LA-U:variable\} and %\{LA-F:variable\} are ignored by the LiteSpeed rewrite engine </li>   <li>two new server variables are added in the LiteSpeed rewrite engine:    %\{CURRENT_URI\} represents the current URI being processed by the rewrite engine and %\{SCRIPT_NAME\} has the same  meaning as the corresponding CGI environment variable. </li> </ul></li> </ul> The implementation of LiteSpeed&#039;s rewrite engine follows the  Apache&#039;s rewrite engine specifications. For more details about rewrite rules, please refer to <a href="http://httpd.apache.org/docs/current/mod/mod_rewrite.html" target="_blank" rel="noopener noreferrer">Apache&#039;s mod_rewrite document</a> and <a href="http://httpd.apache.org/docs/current/rewrite/" target="_blank" rel="noopener noreferrer">Apache&#039;s URL  rewriting guide</a>.', '', 'string', '');

$_tipsdb['rubyBin'] = new DAttrHelp("Ruby Path", 'Path to Ruby executable. Generally, it is /usr/bin/ruby or /usr/local/bin/ruby depending on where Ruby has been installed to.', '', 'Absolute path', '');

$_tipsdb['runOnStartUp'] = new DAttrHelp("Run On Start Up", 'Specifies whether to start the external application at server start up. Only applicable to external applications that can manage their own child processes and where &quot;Instances&quot; value is set to &quot;1&quot;.<br/><br/>If enabled, external processes will be created at server startup instead of run-time.<br/><br/>When selecting &quot;Yes (Detached mode)&quot;, all detached process can be restarted at the Server level or Virtual Host level by touching the &#039;.lsphp_restart.txt&#039; file under the $SERVER_ROOT/admin/tmp/ or $VH_ROOT/ directory respectively.<br/><br/>Default value: Yes (Detached mode)', ' If the configured external process has significant startup overhead, like a Rails app, then this option should be enabled to decrease first page response time.', 'Select from radio box', '');

$_tipsdb['runningAs'] = new DAttrHelp("Running As", 'Specifies the user/group that the server process runs as. This is set using the parameters &quot;--with-user&quot; and &quot;--with-group&quot; when running the configure command before installation. To reset these values, you must rerun the configure command and reinstall.', ' Server should not run as a privileged user such as &quot;root&quot;. It is critical that the server is configured to run with a un-privileged user/group combination that does not have login/shell access. A user/group of nobody is generally a good choice.', '', '');

$_tipsdb['servAction'] = new DAttrHelp("Actions", 'Six actions are available from this menu: Graceful Restart, Toggle Debug Logging, Server Log Viewer, Real-Time Statistics,  Version Manager, and Compile PHP.  <ul><li>&quot;Apply Changes/Graceful Restart&quot; restarts server process gracefully without interrupting requests in process.</li> 	<li>&quot;Toggle Debug Logging&quot; turns debug logging on or off.</li> 	<li>&quot;Server Log Viewer&quot; allows you to view the server log through the log viewer.</li> 	<li>&quot;Real-Time Statistics&quot; allows you to view real-time server status.</li> 	<li>&quot;Version Management&quot; allows you to download new versions of LSWS and switch between different versions. 	<li>Compile PHP allows you to compile PHP for LiteSpeed Web Server. </ul>', 'The shell utility $SERVER_ROOT/bin/lswsctrl can be used to control the server processes as well,  but requires a login shell.', '', '');

$_tipsdb['servModules'] = new DAttrHelp("Server Modules", 'The Server module configuration globally defines the module configuration data.  Once defined, the Listeners and Virtual Hosts have access to the modules and module configurations. <br/><br/>All modules that are to be processed must be registered in the Server configuration. The Server configuration also  defines the default values for module parameter data.  These values can be inherited  or overridden by the Listener and Virtual Host configuration data.<br/><br/>Module priority is only defined at server level and is inherited by the Listener and Virtual Host configurations.', '', '', '');

$_tipsdb['serverName'] = new DAttrHelp("Server Name", 'A unique name for this server. If empty, server hostname will be used by default.', '', '', '');

$_tipsdb['serverPriority'] = new DAttrHelp("Priority", 'Specifies priority of the server processes. Value ranges from -20 to 20. A lower number means higher priority.', ' Usually a higher priority leads to slightly higher web performance on a busy server. Do not set priority higher than that of database processes.', 'Integer number', '');

$_tipsdb['servletContext'] = new DAttrHelp("Servlet Context", 'Servlets can be imported individually through Servlet Contexts. A Servlet Context just specifies the URI for the servlet and the name of the servlet engine. You only need to use this when you do not want to import the whole web application or you want to protect different servlets with different authorization realms. This URI has the same requirements as for a &quot;Java Web App Context&quot;.', '', '', '');

$_tipsdb['servletEngine'] = new DAttrHelp("Servlet Engine", 'Specifies the name of the servlet engine that serves this web application. Servlet engines must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');

$_tipsdb['setUidMode'] = new DAttrHelp("External App Set UID Mode", 'Specifies how user ID is set for an external application process. Three choices are available:  <ul><li>Server UID: Set the user/group ID of external application processes  to the same as the server&#039;s user/group ID.</li>     <li>CGI File UID: Set the user/group ID of external CGI processes based  	on the user/group ID of the executable. This option only applies to CGI, not FastCGI or LSPHP.</li>     <li>Doc Root UID: Set the user/group ID of external application processes based  	on the user/group ID of the document root of the current virtual host.</li> </ul><br/><br/>Default value: Server UID', ' In the shared hosting environment, it is recommended to use the CGI File UID or Doc Root UID modes to prevent files owned by one virtual host from being accessed by the external application scripts of another virtual host.', 'Select from drop down list', '');

$_tipsdb['shHandlerName'] = new DAttrHelp("Handler Name", 'Specifies the name of the external application that processes the script files  when the handler type is FastCGI, Web Server, LSAPI, Load Balancer, or Servlet Engine.', '', 'Select from drop down list', '');

$_tipsdb['shType'] = new DAttrHelp("Handler Type", 'Specifies the type of external application that processes these script files.   Available types are: CGI, FastCGI, Web Server, LSAPI app, Load balancer, or Servlet Engine.  For FastCGI, Web Server and Servlet Engine, a &quot;Handler Name&quot; needs to be specified.  This is an external application name as predefined in the &quot;External Apps&quot; section.', '', 'Select from drop down list', '');

$_tipsdb['shmDefaultDir'] = new DAttrHelp("Default SHM Directory", 'Changes shared memory&#039;s default directory to the specified path. If the directory does not exist, it will be created. All SHM data will be stored in this directory unless otherwise specified.', '', 'Path', '');

$_tipsdb['showVersionNumber'] = new DAttrHelp("Server Signature", 'Specifies whether to show the server signature and version number in the response header&#039;s &quot;Server&quot; value. There are three options: when set to Hide Version, only LiteSpeed is shown. When set to Show Version, LiteSpeed and the version number are shown.  When set to Hide Full Header, the entire Server header will not be shown in the response header.', ' Set to Hide Version if you do not wish to expose the server version number.', 'Select from drop down list', '');

$_tipsdb['smartKeepAlive'] = new DAttrHelp("Smart Keep-Alive", 'Specifies whether to turn on Smart Keep-Alive. This option is effective only if &quot;Max Keep-Alive Requests&quot; is greater than 1. If enabled, you can also enable/disable it at the virtual host level. Smart keep-alive will only establish keep-alive connections for requests of JavaScript, CSS Style Sheet, and image files. For html pages, the connection will not be kept alive. This will help serve more users more efficiently. Normally a web page contains multiple images and scripts that will be cached by the browser after the initial request. It is more efficient to send those non-html static files through a single keep-alive connection and have the text/html file sent through another non-keep-alive connection. This method will reduce idle connections and in turn increase the capacity to handle more concurrent requests and users.', ' Enable this for high-load web sites.', 'Select from radio box', '');

$_tipsdb['sname'] = new DAttrHelp("Name - Server", 'The unique name that identifies this server. This is the  &quot;Server Name&quot; specified in the general configuration.', '', '', '');

$_tipsdb['sndBufSize'] = new DAttrHelp("Send Buffer Size (bytes)", 'The sending buffer size of each TCP socket. 512K is the maximum allowed buffer size.', ' It is recommended to leave this value as &quot;Not Set&quot; or set to 0 to use the operating system&#039;s default buffer size.<br/> If your web site serves large static files, increase the send buffer  size to improve performance.<br/> Setting this to a lower value will reduce throughput and memory usage per socket allowing the server to have more concurrent sockets when memory is a bottleneck.', 'Integer number', '');

$_tipsdb['softLimit'] = new DAttrHelp("Connection Soft Limit", 'Specifies the soft limit of concurrent connections allowed from one IP.  This soft limit can be exceeded temporarily during &quot;Grace Period (sec)&quot; as long as  the number is below the &quot;Connection Hard Limit&quot;, but Keep-Alive connections  will be closed as soon as possible until the number of connections is lower  than the limit. If number of connections is still over the limit after the  &quot;Grace Period (sec)&quot;, that IP will be blocked for the &quot;Banned Period (sec)&quot;.<br/><br/>For example, if a page contains many small graphs, the browser may try to set up  many connections at same time, especially for HTTP/1.0 clients. You would want to allow  those connections for a short period.<br/><br/>HTTP/1.1 clients may also set up multiple connections to speed up downloading and SSL   requires separate connections from non-SSL connections. Make sure the limit is set properly,   as not to adversely affect normal service. The recommended limit is between 5 and 10.', ' A lower number will enable serving more distinct clients.<br/> Trusted IPs or sub-networks are not affected. <br/> Set to a high value when you are performing benchmark tests  with a large number of concurrent client machines.', 'Integer number', '');

$_tipsdb['sslCert'] = new DAttrHelp("SSL Private Key & Certificate", 'Every SSL listener requires a paired SSL private key and SSL certificate. Multiple SSL listeners can share the same key and certificate.<br/><br/>You can generate SSL private keys yourself using an SSL software package, such as OpenSSL. SSL certificates can also be purchased from an authorized certificate issuer like VeriSign or Thawte. You can also sign the certificate yourself. Self-signed certificates will not be trusted by web browsers and should not be used on public websites containing critical data. However, a self-signed certificate is good enough for internal use, e.g. for encrypting traffic to LiteSpeed Web Server&#039;s WebAdmin Console.', '', '', '');

$_tipsdb['sslEnableMultiCerts'] = new DAttrHelp("Enable Multiple SSL Certificates", 'Allows listeners/vhosts to set multiple SSL certificates.  If multiple certificates are enabled, the certificates/keys are expected to follow a naming scheme.  If the cert is named server.crt, other possible cert names are server.crt.rsa, server.crt.dsa, server.crt.ecc. If &quot;Not Set&quot;, defaults to &quot;No&quot;.', '', 'Select from radio box', '');

$_tipsdb['sslOCSP'] = new DAttrHelp("OCSP Stapling", 'Online Certificate Status Protocol (OCSP) is a more efficient method of checking whether a digital certificate is valid. It works by communicating with another server — the OCSP responder — to get verification that the certificate is valid instead of checking through certificate revocation lists (CRL).<br/><br/>OCSP stapling is a further improvement on this protocol, allowing the server to check with the OCSP responder at regular intervals instead of every time a certificate is requested. See the <a href=&quot;http://en.wikipedia.org/wiki/OCSP_Stapling&quot;>OCSP Wikipedia page</a> for more details.', '', '', '');

$_tipsdb['sslProtocol'] = new DAttrHelp("Protocol Version", 'Specifies which version of the SSL protocol will be used. You can choose from SSL v3.0 and TLS v1.0. Since OpenSSL 1.0.1, TLS v1.1, TLS v1.2 are also supported. TLS v1.3 is also supported via BoringSSL.', 'Leaving this field blank will enable TLS v1.0, TLS v1.1, and TLS v1.2 by default. TLS v1.3 requires BoringSSL and will also be enabled if the underlying SSL library supports it.', '', '');

$_tipsdb['sslProtocolSetting'] = new DAttrHelp("SSL Protocol", 'Customizes SSL protocols accepted by the listener.', '', '', '');

$_tipsdb['sslSessionCache'] = new DAttrHelp("Enable Session Cache", 'Enables session ID caching using OpenSSL&#039;s default setting. Server-level setting must be set to &quot;Yes&quot; for Virtual Host setting to take effect.<br/><br/>Default values:<br/><b>Server-level:</b> Yes<br/><b>VH-Level:</b> Yes', '', 'Select from radio box', '');

$_tipsdb['sslSessionCacheSize'] = new DAttrHelp("Session Cache Size (bytes)", 'Sets the maximum number of SSL session IDs to store in the cache. Default is 1,000,000.', '', 'Integer number', '');

$_tipsdb['sslSessionCacheTimeout'] = new DAttrHelp("Session Cache Timeout (secs)", 'This value determines how long a session ID will be valid within the cache before renegotiation is required. Default is 3,600.', '', 'Integer number', '');

$_tipsdb['sslSessionTicketKeyFile'] = new DAttrHelp("SSL Session Ticket Key File", 'Allows the SSL Ticket Key to be created/maintained by an administrator. The file must be 48 bytes long. If this option is left empty, the load balancer will generate and rotate its own set of keys.<br/><br/>IMPORTANT: To maintain forward secrecy, it is strongly recommended to change the key every <b>SSL Session Ticket Lifetime</b> seconds. If this cannot be done, it is recommended to leave this field empty.', '', 'Path', '');

$_tipsdb['sslSessionTicketLifetime'] = new DAttrHelp("SSL Session Ticket Lifetime (secs)", 'This value determines how long a session ticket will be valid before a renegotiation is required. Default is 3,600.', '', 'Integer number', '');

$_tipsdb['sslSessionTickets'] = new DAttrHelp("Enable Session Tickets", 'Enables session tickets using OpenSSL&#039;s default session ticket setting. Server-level setting must be set to &quot;Yes&quot; for Virtual Host setting to take effect.<br/><br/>Default values:<br/><b>Server-level:</b> Yes<br/><b>VH-Level:</b> Yes', '', 'Select from radio box', '');

$_tipsdb['sslStrongDhKey'] = new DAttrHelp("SSL Strong DH Key", 'Specifies whether to use 2048 or 1024 bit DH keys for SSL handshakes. If set to &quot;Yes&quot;, 2048 bit DH keys will be used for 2048 bit SSL keys and certificates. 1024 bit DH keys will still be used in other situations. Default is &quot;Yes&quot;.<br/><br/>Earlier versions of Java do not support DH key size higher than 1024 bits. If Java client compatibility is required, this should be set to &quot;No&quot;.', '', 'radio', '');

$_tipsdb['statDir'] = new DAttrHelp("Statistics Output Directory", 'The directory where the Real-Time Stats report file will be written. The default directory is <b>/tmp/lshttpd/</b> .', 'During server operation, the .rtreport file will be written to every second. To avoid unnecessary disk writes, set this to a RAM Disk.<br/>The .rtreport file can be used with 3rd party monitoring software to track server health.', 'Absolute path', '');

$_tipsdb['staticReqPerSec'] = new DAttrHelp("Static Requests/Second", 'Specifies the maximum number of requests to static content coming from a single IP address that can be processed in a single second regardless of the number of connections established. <br/><br/>When this limit is reached, all future requests are tar-pitted until the next second.  Request limits for dynamically generated content are independent of this limit. Per-client request limits can be set at server- or virtual host-level.  Virtual host-level settings override server-level settings.', ' Trusted IPs or sub-networks are not affected.', 'Integer number', '');

$_tipsdb['statuscode'] = new DAttrHelp("Status Code", 'Specifies the response status code of the external redirection. If the status code is between 300 and 399, &quot;Destination URI&quot; can be specified.', '', 'Select from drop down list', '');

$_tipsdb['suexecGroup'] = new DAttrHelp("suEXEC Group", 'At the current context level, run as this group. Either <b>suEXEC User</b> at the Virtual Host level, or <b>Run As User</b> at the External Application level, must be set for <b>suEXEC Group</b> to take effect.<br/><br/>This configuration can be overridden at the External Application level using the <b>Run As Group</b> setting.<br/><br/>Default value: <b>suExec User</b> setting value', '', 'Valid group name or uid', '');

$_tipsdb['suexecUser'] = new DAttrHelp("suEXEC User", 'At the current context level, run as this user. If set, this value will override the Virtual Host level <b>ExtApp Set UID Mode</b> setting.<br/><br/>This configuration may be overridden at the External Application level using the <b>Run As User</b> setting.<br/><br/>Default value: Not Set', '', 'Valid user name or uid.', '');

$_tipsdb['suffix'] = new DAttrHelp("Suffix", 'Specifies the script file suffixes that will be handled by this  script handler. Suffixes must be unique.', 'The server will automatically add a special MIME type (&quot;application/x-httpd-[suffix]&quot;) for the first  suffix in the list. For example, MIME type &quot;application/x-httpd-php53&quot; will be added  for suffix &quot;php53&quot;. Suffixes after the first need to set up in the &quot;MIME Settings&quot; settings.<br/>Though we list suffixes in this field, the script handlers use MIME types, not suffixes,  to decide which scripts to handle. <br/> Only specify the suffixes you really need.', 'Comma delimited list with period &quot;.&quot; character prohibited.', '');

$_tipsdb['swappingDir'] = new DAttrHelp("Swapping Directory", 'Specifies the directory where the swapping files should be placed. When the server is started in chroot mode, this directory is relative to the new root directory, otherwise it is relative to the real root directory.<br/><br/>The server uses its own virtual memory to reduce system memory usage. Virtual memory and disk swapping are used to store large request bodies and dynamically generated responses. The swapping directory should be placed on a disk with enough space.<br/><br/>Default value: /tmp/lshttpd/swap', ' Place the swapping directory on a separate disk or increase Max I/O Buffer Size to eliminate swapping.', 'Absolute path', '');

$_tipsdb['templateFile'] = new DAttrHelp("Template File", 'Specifies the path to the configuration file of this template. The file must be located within $SERVER_ROOT/conf/templates/ with a &quot;.conf&quot; filename. If the file you designate does not exist, after trying to save the template an error will appear with the link &quot;CLICK TO CREATE&quot;. This link will generate a new empty template file. When you delete the template, the entry will be removed from your configurations, but the actual template config file will not be deleted.', '', 'path', '');

$_tipsdb['templateFileRef'] = new DAttrHelp("File Name Used In Template", 'Specifies a path for the file to be used for member virtual hosts.   Variable $VH_NAME or $VH_ROOT must appear in the path so  each member virtual host will have its own file.', '', 'string', '');

$_tipsdb['templateName'] = new DAttrHelp("Template Name", 'A unique name for the template.', '', '', '');

$_tipsdb['templateVHAliases'] = new DAttrHelp("Aliases", 'Specifies alternate names for the virtual host. All possible hostnames and IP addresses should be added to this list. The wildcard characters * and ? are allowed in the name. Append :<port> for web sites not on port 80.<br/><br/>Aliases will be used in the following situations: <ol>   <li>To match the hostname in the Host header when processing a   request.</li>   <li>To populate domain name/alias configurations for add-ons   like FrontPage or AWstats.</li>   <li>To configure listener-to-virtual host mappings based on the virtual host template.</li> </ol>', '', 'Comma-separated list of domain names.', '');

$_tipsdb['templateVHConfigFile'] = new DAttrHelp("Instantiated VHost Config File", 'Specifies the location of the config file generated when you instantiate a member virtual host.  Variable $VH_NAME must appear in the path so each virtual host will have its own file. Must be located under  $SERVER_ROOT/conf/vhosts/. This config file will be created only after you move a member vhost out of the template  through instantiation.', '$VH_NAME/vhconf.conf is recommended for easy management.', 'String with $VH_NAME variable and .conf suffix', '');

$_tipsdb['templateVHDocRoot'] = new DAttrHelp("Document Root", 'Specifies the unique path for each member virtual host&#039;s document root.   Variable $VH_NAME or $VH_ROOT must appear in the path so  each member virtual host will have its own document root.', '', 'path with $VH_NAME or $VH_ROOT variable', '$VH_ROOT/public_html/ or $SERVER_ROOT/$VH_NAME/public_html.');

$_tipsdb['templateVHDomain'] = new DAttrHelp("Domain", 'Specifies the main domain name for this member virtual host. If left blank, the virtual host name will be used. This should be a fully qualified domain name, but you can use an IP address as well. It is recommended to append :<port> for web sites not on port 80. For configurations containing domain names, this domain can be referenced with variable $VH_DOMAIN.<br/><br/>This domain name will be used in the following situations: <ol>   <li>To match the hostname in the Host header when processing a   request.</li>   <li>To populate domain name configurations for add-ons   like FrontPage or AWstats.</li>  <li>To configure listener-to-virtual host mappings based on the virtual host template.</li> </ol>', '', 'domain name', '');

$_tipsdb['templateVHName'] = new DAttrHelp("Virtual Host Name", 'A unique name for this virtual host. This name must be unique among all template member virtual hosts and standalone virtual hosts. Inside a directory path configuration, this name can be referenced by the variable $VH_NAME.<br/><br/>If a standalone virtual host with the same name is also configured, then the member virtual host configuration will be ignored.', '', '', '');

$_tipsdb['templateVHRoot'] = new DAttrHelp("Default Virtual Host Root", 'Specifies the default root directory for member virtual hosts using this template.  Variable $VH_NAME must appear in the path. This will allow each member template  to be automatically assigned a separate root directory based on its name.', '', 'path', '');

$_tipsdb['toggleDebugLog'] = new DAttrHelp("Toggle Debug Logging", 'Toggle Debug Logging toggles the value of &quot;Debug Level&quot; between NONE and HIGH.  As debug logging has an impact on performance and can fill up the hard drive quickly, so &quot;Debug Level&quot; should usually be set to NONE on a production server.  This feature can be used instead to turn debug logging on and off quickly  in order to debug a problem on a production server. Debug logging turned on or  off in this way will not change anything shown in your server configurations.', '&quot;Toggle Debug Logging&quot; will only work if &quot;Log Level&quot;  is set to DEBUG.   Important! Debug logging includes detailed information for each  request and response. Active debug logging will severely degrade service performance and potentially saturate disk space in a very short time. This feature should only be  used for a short period of time when trying to diagnose server issues.', '', '');

$_tipsdb['totalInMemCacheSize'] = new DAttrHelp("Total Small File Cache Size (bytes)", 'Specifies the total memory that can be allocated to the buffer cache in order to cache/serve small static files.', '', 'Integer number', '');

$_tipsdb['totalMMapCacheSize'] = new DAttrHelp("Total MMAP Cache Size (bytes)", 'Specifies the total memory that can be allocated for memory- mapped cache in order to cache/serve medium sized static files.', '', 'Integer number', '');

$_tipsdb['umask'] = new DAttrHelp("umask", 'Sets default umask for CGI processes.   See  man 2 umask  for details. This also serves as the default value for external applications   &quot;umask&quot;.', '', 'value valid range [000]-[777].', '');

$_tipsdb['uploadPassByPath'] = new DAttrHelp("Pass Upload Data by File Path", 'Specify whether or not to pass upload file data by path. If enabled, file path along with some other information is sent to backend handler instead of file itself when uploading. This saves on CPU resources and file transfer time but requires some updates to backend to implement. If disabled, file content will be transferred to backend handler, request body is still parsed to files.', ' Enable this to speed up file upload processing if backward compatibility is not an issue.', 'Select from radio box', '');

$_tipsdb['uploadTmpDir'] = new DAttrHelp("Temporary File Path", 'Temporary directory where files being uploaded to server will be stored  while request body parser is working. Default value is /tmp/lshttpd/.', '', 'Absolute path or path starting with $SERVER_ROOT (for Server and VHost levels) or $VH_ROOT (for VHost levels).', '');

$_tipsdb['uploadTmpFilePermission'] = new DAttrHelp("Temporary File Permissions", 'Determines file permissions used for files stored in temporary directory.  Server level setting is global, can be overridden at VHost level.', '', '3 digits octet number. Default value is 666.', '');

$_tipsdb['uri'] = new DAttrHelp("URI", 'Specifies the URI for this context. The URI should start with a &quot;/&quot;. If a URI ends with a &quot;/&quot;, then this context will include all sub-URIs under this URI.', '', 'URI', '');

$_tipsdb['useIpInProxyHeader'] = new DAttrHelp("Use Client IP in Header", 'Specifies whether to use the IP address listed in the &quot;X-Forwarded-For&quot; HTTP request header for all IP address-related features, including connection/bandwidth throttling, access control, and IP geolocation.<br/><br/>This feature is useful if your web server is behind a load balancer or a proxy server. If you select &quot;Trusted IP Only&quot;, then X-Forwarded-For IP will be used only when the request  is coming from trusted IPs defined in the server-level &quot;Allowed List&quot;.<br/><br/>&quot;Keep Header from Trusted IP&quot; is the same as &quot;Trusted IP Only&quot;, but the X-Forwarded-For header used for the backend will not be modified to include the connecting peer address.', '', 'Select from drop down list', '');

$_tipsdb['useSendfile'] = new DAttrHelp("Use sendfile()", 'Specifies whether to use the sendfile() system call to serve static files. Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write, and sendfile(). Files smaller than the &quot;Max Cached Small File Size (bytes)&quot; are served from memory buffer cache. Files larger than the &quot;Max Cached Small File Size (bytes)&quot; but smaller than the &quot;Max MMAP File Size (bytes)&quot; will be served from memory-mapped cache. Files larger than the &quot;Max MMAP File Size (bytes)&quot; will be served via plain read/write or sendfile(). Sendfile() is a &quot;zero copy&quot; system call that can greatly reduce CPU utilization when serving very large static files. Sendfile() requires an optimized network card kernel driver and thus may not be suitable for some small-vendor network adapters.', '', 'Select from radio box', '');

$_tipsdb['userDBCacheTimeout'] = new DAttrHelp("User DB Cache Timeout (secs)", 'Specifies how often the backend user database will be checked for changes.   Every entry in the cache has a timestamp.  When cached data is older than the specified timeout, the backend database will be checked  for changes. If there is no change, the timestamp will be reset to the current time, otherwise  the new data will be loaded. Sevrer reload and graceful restart will clear the cache immediately.', ' If the backend database does not change very often,  set a longer timeout for better performance.', 'Integer number', '');

$_tipsdb['userDBLocation'] = new DAttrHelp("User DB Location", 'Specifies the location of the user database.  For DB type Password File, it is the path to the flat file containing user/password definitions. You can edit this file through the WebAdmin console by clicking on the filename.<br/><br/>Each line of the user file contains a username followed by a colon,  followed by a crypt() encrypted password, optionally followed by a colon  and group names that user belongs to. Group names are delimitated by commas.  If group information is specified in the user database, then the group database will not be checked.<br/><br/>Example:<blockquote><code>john:HZ.U8kgjnMOHo:admin,user</code></blockquote><br/><br/>For DB type LDAP, it is the LDAP URL to query for the user information. For each valid user, the authentication data stored in the LDAP server should contain at least the user id and user password. One and only one record should be returned in the LDAP search request based on the this URL and username received in the HTTP Authentication header. &quot;$k&quot; must be specified in the filter part of the URL and it will be replaced with the username. The user password attribute must be returned in the query result. The attribute name of the user password is specified by &quot;Password Attribute&quot;. Group information can be optionally specified by the &quot;Member-of Attribute&quot;.<br/><br/>Example: At minimum, a user can be defined in LDAP with object classes: uidObject, simpleSecurityObject and organizationalRole. The following URL could be used: <br/><br/><blockquote><code>ldap://localhost/ou=UserDB,dc=example,dc=com???(&(objectClass=*)(uid=$k))</code></blockquote>', ' It is recommended to store user password files outside of the document tree.  If a user password file has to be placed inside document tree, simply name it with a leading &quot;.ht&quot;  like .htuser to prevent it being served as a static file.  LiteSpeed Web Server  does not serve files prefixed with &quot;.ht&quot;.', 'Path to user DB file or LDAP URL (RFC 2255).', '');

$_tipsdb['userDBMaxCacheSize'] = new DAttrHelp("User DB Max Cache Size", 'Specifies the maximum cache size of the user database.  Recently accessed user authentication data will be cached in memory  to provide maximum performance.', ' As a larger cache will consume more memory,  a higher value may or may not provide better performance. Set it to an appropriate size according  to your user database size and site usage.', 'Integer number', '');

$_tipsdb['vaction'] = new DAttrHelp("Actions - Virtual Host", 'This field shows buttons to disable, enable, or restart the virtual host.   Actions taken on one virtual host do not affect the rest of the web server.', 'It is good idea to disable a virtual host temporarily when updating its content.', '', '');

$_tipsdb['vdisable'] = new DAttrHelp("Disable", 'The Disable action stops a running virtual host. New requests will not be accepted, but requests being processed will finish as usual.', '', '', '');

$_tipsdb['venable'] = new DAttrHelp("Enable", 'The Enable action starts up a stopped virtual host.   This allows new requests to be accepted.', '', '', '');

$_tipsdb['verifyDepth'] = new DAttrHelp("Verify Depth", ' Specifies how deeply a certificate should be verified before determining that the client does not have a valid certificate. The default is &quot;1&quot;.', '', 'Select from drop down list', '');

$_tipsdb['vhEnableGzip'] = new DAttrHelp("Enable Compression", 'Specifies whether to enable GZIP/Brotli compression for this virtual host. This setting is only effective when compression is enabled at the server level. Compression settings are configured at the server level (Tuning > GZIP/Brotli Compression).', '', 'Select from radio box', '');

$_tipsdb['vhMaxKeepAliveReq'] = new DAttrHelp("Max Keep-Alive Requests", 'Specifies the maximum requests that can be served through a keep-alive (persistent)  connection. Connections will be closed once this limit is reached. You can specify a different limit for each virtual hosts. This number cannot exceed the server-level &quot;Max Keep-Alive Requests&quot; limit.', ' Set to a reasonably high value. A value of &quot;1&quot; or less will  disable keep-alive connections.', 'Integer number', '');

$_tipsdb['vhModuleUrlFilters'] = new DAttrHelp("Virtual Host Module Context", 'It&#039;s a centralized place to customize module settings for virtual host contexts. Settings for a context URI will override the virtual host or the server level settings.', '', '', '');

$_tipsdb['vhModules'] = new DAttrHelp("Virtual Host Modules", 'Virtual Host module configuration data is, by default inherited from the Server module configuration.   The Virtual Host Modules are limited to the HTTP level hooks.', '', '', '');

$_tipsdb['vhName'] = new DAttrHelp("Virtual Host Name", 'A unique name for a virtual host. It is recommended to use the virtual host&#039;s domain name as the Virtual Host Name.  Virtual Host Name can be referred to using the variable $VH_NAME.', '', '', '');

$_tipsdb['vhRoot'] = new DAttrHelp("Virtual Host Root", 'Specifies the root directory of the virtual host. Note: This is <b>NOT</b> the document root. It is recommended to place all files related to the virtual host (like log files, html files, CGI scripts, etc.) under this directory. Virtual Host Root can be referred to using the variable $VH_ROOT.', ' Place different virtual hosts on different hard drives.', 'An absolute path or a relative path to $SERVER_ROOT.', '');

$_tipsdb['vhSmartKeepAlive'] = new DAttrHelp("Smart Keep-Alive", 'Specifies whether to turn on Smart Keep-Alive for this virtual host. This option is only effective if  &quot;Smart Keep-Alive&quot; is enabled at the server level and &quot;Max Keep-Alive Requests&quot; is greater than 1.', ' Enable this for busy web sites.', 'Select from radio box', '');

$_tipsdb['vhaccessLog_fileName'] = new DAttrHelp("File Name", 'The access log filename.', ' Put access log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.', '');

$_tipsdb['vhadminEmails'] = new DAttrHelp("Administrator Email", 'Specifies email address(es) of the administrator(s) of this virtual host.', '', 'Comma separated list of email addresses', '');

$_tipsdb['vhlog_fileName'] = new DAttrHelp("File Name", 'Specifies the path for the log file.', ' Place the log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.', '');

$_tipsdb['vhlog_logLevel'] = new DAttrHelp("Log Level", 'Specifies the level of logging. Available levels (from high to low) are ERROR,  WARNING, NOTICE, INFO, and DEBUG.  Only messages with a level higher than or equal to the current setting will be logged.  If you want to set it to DEBUG, you must set the server log level to DEBUG as well.  The level of debugging is controlled solely at the server level by &quot;Debug Level&quot;.', ' Unless &quot;Debug Level&quot; is set to a level other than NONE, DEBUG log level does not have any performance impact and is recommended.', 'Select from drop down list', '');

$_tipsdb['viewlog'] = new DAttrHelp("Server Log Viewer", 'The Server Log Viewer is a convenient tool for browsing the  current server log to check for errors or problems.  The log viewer  searches the server log file in blocks for the specified log level.    The default block size is 20KB. You can use the Begin,   End, Next, and Prev buttons to navigate a large log file.', 'The size of a dynamically generated page is limited by &quot;Max Dynamic Response Body Size (bytes)&quot;.   So if the block is too big, the page might be truncated.', '', '');

$_tipsdb['virtualHostMapping'] = new DAttrHelp("Virtual Host Mappings", 'Specifies the relationship between the listener and virtual hosts. Listeners and virtual hosts are associated by domain names. An HTTP request will be routed to a virtual host with a matching domain name. One listener can map to multiple virtual hosts for different domain names. One virtual host can also be mapped from different listeners. One listener can allow one catchall virtual host with the domain name value &quot;*&quot;. When there is no explicitly matched domain name in the listener&#039;s mapping, the listener will forward the request to that catchall virtual host.', ' Only add necessary mappings. If the listener is mapped to only one virtual host, then only set up a catchall mapping &quot;*&quot;.', '', '');

$_tipsdb['virtualHostName'] = new DAttrHelp("Virtual Host", 'Specifies the name of a virtual host.', '', 'Select from drop down list', '');

$_tipsdb['vname'] = new DAttrHelp("Name - Virtual Host", 'The unique name that identifies this virtual host. This is the &quot;Virtual Host Name&quot;  you specified when setting up this virtual host.', '', '', '');

$_tipsdb['vreload'] = new DAttrHelp("Restart - Virtual Host", 'The Restart action causes the web server to load the newest configuration  for this virtual host. Requests being processed will finish with the old configuration.  The new configuration will only apply for new requests. All changes to a virtual host  can be applied on the fly this way.', '', '', '');

$_tipsdb['vstatus'] = new DAttrHelp("Status - Virtual Host", 'The current status of a virtual host.   The status can be: Running, Stopped, Restart Required,   or Running - Removed from Configuration.  <ul>     <li>Running means the virtual host is loaded and in service.</li>     <li>Stopped means the virtual host is loaded but not in service (disabled). </li>     <li> Restart Required means this is a newly added virtual host and          the server has not yet loaded its configuration. </li>     <li>Running - Removed from Configuration means the virtual host has been deleted      from the server&#039;s configuration but it is still in service. </li> </ul>', '', '', '');

$_tipsdb['wsaddr'] = new DAttrHelp("Address", 'A unique socket address used by the WebSocket backend.  IPv4 sockets, IPv6 sockets, and Unix Domain Sockets (UDS) are supported.  IPv4 and IPv6 sockets can be used for communication over the network.  UDS can only be used when the WebSocket backend resides on the same machine as the server.', ' If the WebSocket backend runs on the same machine,  UDS is preferred. If you have to use an IPv4 or IPv6 socket,  set the IP address to localhost or 127.0.0.1, so the WebSocket backend  is inaccessible from other machines.<br/> Unix Domain Sockets generally provide higher performance than IPv4 or IPv6 sockets.', 'IPv4 or IPV6 address:port or UDS://path', '127.0.0.1:5434 <br/>UDS://tmp/lshttpd/php.sock.');

$_tipsdb['wsgiBin'] = new DAttrHelp("WSGI Path", 'Path to LiteSpeed Python Web Server Gateway Interface executable (lswsgi).<br/><br/>This executable is created by compiling Python with LiteSpeed&#039;s WSGI LSAPI module.', '', 'Absolute path', '');

$_tipsdb['wsgiDefaults'] = new DAttrHelp("Python WSGI Default Settings", 'Default configurations for Python WSGI applications. These settings can be overriden at the context level.', '', '', '');

$_tipsdb['wsuri'] = new DAttrHelp("URI", 'Specifies the URI(s) that will use this WebSocket backend. Traffic to  this URI will only be forwarded to the WebSocket backend when it contains  a WebSocket upgrade request. <br/><br/>Traffic without this upgrade request will automatically be forwarded to the  Context that this URI belongs to. If no Context exists for this URI,  LSWS will treat this traffic as though it is accessing a static context with  the location $DOC_ROOT/URI.', '', 'A plain URI (starting with &quot;/&quot;). If the URI ends with a &quot;/&quot;,  then this WebSocket backend will include all sub-URIs under this URI.', 'Using the WebSocket proxy in conjunction with a Context  allows you to serve different kinds of traffic in different ways  on the same page, thus optimizing performance. You can send WebSocket  traffic to the WebSocket backend, while setting up a static context so  that LSWS can serve the page&#039;s static content, or an LSAPI context so LSWS  will serve PHP content (both of which LSWS does more efficiently  than the WebSocket backend).');


$_tipsdb['EDTP:UDBgroup'] = array('If you enter group information here, the group DB will not be checked.','You can enter multiple groups, use comma to separate. Space will be treated as part of a group name.');

$_tipsdb['EDTP:accessControl_allow'] = array('You can set up access control at server, virtual host and context levels. If there is access control  at server level, the virtual host rules will be applied after the server rules are satisfied.','Input format can be an IP like 192.168.0.2, a sub-network like 192.168.*, or a subnet/netmask like 192.168.128.5/255.255.128.0.','If you have trusted IP or sub-network, then you must specify them in allowed list by adding a trailing &quot;T&quot; such as  192.168.1.*T. Trusted IP or sub-network is not limited by connection/throttling limit.');

$_tipsdb['EDTP:accessControl_deny'] = array('To deny access from certain address, put &quot;ALL&quot; in allowed list, and put subnet or IP in denied  list. To allow only certain IP or subnet to access the site, put &quot;ALL&quot; in denied list and specify the address in the allowed list.');

$_tipsdb['EDTP:accessDenyDir'] = array('Enter a full path if you want to deny access for specific directory; entering a path followed by * will disable all the  sub directories.','Path can be either absolute or relative to $SERVER_ROOT, use comma to separate.','If both <b>Follow Symbolic Link</b> and <b>Check Symbolic Link</b> are enabled, symbolic links will be checked  against the denied directories.');

$_tipsdb['EDTP:accessLog_fileName'] = array('Log file path can be an absolute path or relative to $SERVER_ROOT.');

$_tipsdb['EDTP:aclogUseServer'] = array('When required, you can disable access logging for this virtual host to save on disk i/o.');

$_tipsdb['EDTP:adminEmails'] = array('You can enter multiple admin emails: use comma to separate.');

$_tipsdb['EDTP:adminOldPass'] = array('For security reasons, if you forget the admin password, you will be unable to change it from the WebAdmin Console.  Please use the following shell command instead:  <br><br> /usr/local/lsws/admin/misc/admpass.sh.  <br><br> This script will remove all entered admin user IDs and overwrite them with a single admin user.');

$_tipsdb['EDTP:allowBrowse'] = array('Static context can be used to map a URI to a directory either outside document root or within it. The directory can be absolute path or relative to document root(default), $VH_ROOT or $SERVER_ROOT.','Check &quot;Accessible&quot; will allow browsing static files in this context. You may want to disable it to prevent viewing static files, for e.g. when you update the content.');

$_tipsdb['EDTP:appType'] = array('','');

$_tipsdb['EDTP:as_location'] = array('The App Server context is for easy configuration of running Rack/Rails, WSGI, or Node.js applications. You only need to specify the root location of your application in the &quot;Location&quot; field.');

$_tipsdb['EDTP:as_startupfile'] = array('','');

$_tipsdb['EDTP:autoFix503'] = array('When you enable <b>Auto Fix 503 Error</b>, the monitor process will automatically launch a new server process and service will resume instantly if a crash is detected.');

$_tipsdb['EDTP:backlog'] = array('Local applications can be started by the web server. In this case, you need to specify the path, backlog and number of instances.');

$_tipsdb['EDTP:binPath'] = array('','');

$_tipsdb['EDTP:cgi_path'] = array('A CGI context can be used to specify a directory only contains CGI scripts. Path can be absolute path or relative to $SERVER_ROOT, $VH_ROOT or $DOC_ROOT(default). Path and URI must be ended with &quot;/&quot; for a cgi-bin directory.','If only a specific script is needed in that directory, it is recommended to create a CGI context for that script only. In this case, path and URI need not be a directory. For e.g., path can be ~/myapp/myscript.pl, URI can be /myapp/myscript.pl. All other files will not be served as CGI.');

$_tipsdb['EDTP:checkSymbolLink'] = array('Check-Symbolic-Link control will take effect only if Follow-Symbolic-Link is turned on.  This controls whether symbolic links are checked against Access Denied Directories.');

$_tipsdb['EDTP:compressibleTypes'] = array('Compressible Types is a list of MIME types that are compressible, separated by commas. You can use wildcard &quot;*&quot; for MIME types, like */*, text/*. You can put &quot;!&quot; in front to exclude certain types. The order of the list is important if you use &quot;!&quot;. For e.g., a list like &quot;text/*, !text/css, !text/js&quot; will compress all text file except for css and js.');

$_tipsdb['EDTP:ctxType'] = array('<b>Static</b> context can be used to map a URI to a directory either outside document root or within it.','<b>Java Web App</b> context is used to automatically import a predefined Java Application in an AJPv13 compilant Java servlet engine.','<b>Servlet</b> context is used to import a specific servlet under a web application.','<b>Fast CGI</b> context is a mount point of Fast CGI application.','<b>LiteSpeed SAPI</b> context can be used to associate a URI with an LSAPI application.','<b>Proxy</b> context enables this virtual host to serve as a transparant reverse proxy server to an external web server or application server.','<b>CGI</b> context can be used to specify a directory only contains CGI scripts.','<b>Load Balancer</b> context can be used to assign a different cluster for that context.','<b>Redirect</b> context can set up an internal or external redirect URI.','<b>App Server</b> context is specifically used for Rack/Rails, WSGI, and Node.js applications.<br>','<b>Module handler</b> context is a mount point of hander type modules.');

$_tipsdb['EDTP:docRoot'] = array('Set up your document root here, which can be absolute path or relative to $SERV_ROOT or $VH_ROOT','Document root is referred as $DOC_ROOT in this virtual host, which can be used in other path configuration.');

$_tipsdb['EDTP:domainName'] = array('Enter all the domains that you want this listener to respond to. Use comma &quot;,&quot; to separate individual domain.','You can choose only one virtual host to handle all unspecified domains, put &quot;*&quot; in domains.');

$_tipsdb['EDTP:enableDynGzipCompress'] = array('Dynamic GZIP compression control will be effective only if GZIP Compression is enabled.');

$_tipsdb['EDTP:enableExpires'] = array('Expires can be set at the Server/Virtual Host/Context level. Lower level settings will override higher level settings. In terms of overwrite priority: <br><br> Context Level > Virtual Host Level > Server Level <br><br>');

$_tipsdb['EDTP:enableRecaptcha'] = array('When this setting is set to <b>Yes</b> at the Server level, reCaptcha Protection can still be disabled at the Virtual Host level.');

$_tipsdb['EDTP:errURL'] = array('You can set up customized error pages for different error codes.');

$_tipsdb['EDTP:expiresByType'] = array('Expires By Type will override default settings. Each entry is in the format of &quot;MIME-type=A|Mseconds&quot; with no space in between. You can input multiple entries separated by comma.');

$_tipsdb['EDTP:expiresDefault'] = array('Expires syntax, &quot;A|Mseconds&quot; means after base time (A or M) plus the specified time in seconds, the file will expire. &quot;A&quot; means client access time, &quot;M&quot; means file modified time. You can override this default setting by different MIME types: A86400 means the file will expire after 1 day based on client access time.','Here are some common numbers: 1 hour = 3600 sec, 1 day = 86400 sec, 1 week = 604800 sec, 1 month = 2592000 sec, 1 year = 31536000 sec.');

$_tipsdb['EDTP:extAppAddress'] = array('Address can be IPv4 socket address &quot;IP:PORT&quot;, like 192.168.1.3:7777 and localhost:7777 or Unix domain socket address &quot;UDS://path&quot; like UDS://tmp/lshttpd/myfcgi.sock.','UDS is chrooted in chroot environment.','For local applications, Unix domain socket is preferred due to security and better performance. If you have to use IPv4 socket, set the IP part to localhost or 127.0.0.1, thus the application is inaccessible from other machines.');

$_tipsdb['EDTP:extAppName'] = array('Give a name that easy to remember, other places will refer to this app by its name.');

$_tipsdb['EDTP:extAppType'] = array('You can set up external Fast CGI application and AJPv13 (Apache JServ Protocol v1.3) compatible servlet engine.');

$_tipsdb['EDTP:extWorkers'] = array('Load balancing workers must be previously defined.','Available ExtApp Types are fcgi(Fast CGI App), lsapi(LSAPI App), servlet(Servlet/JSP Engine), proxy(Web Server).','Different types of external applications can be mixed in one load balancing cluster.');

$_tipsdb['EDTP:externalredirect'] = array('Set up redirect URI here. If it is an external redirect, you can specify the status code. Internal redirect has to start with &quot;/&quot;, external redirect can either start with &quot;/&quot; or with &quot;http(s)://&quot;.');

$_tipsdb['EDTP:extraHeaders'] = array('The Header Operations setting is backwards compatible with the old &#039;header_name: value1,value2,...&#039; syntax, which is equivalent to setting the header + values using the &#039;Header&#039; directive.');

$_tipsdb['EDTP:fcgiapp'] = array('Fast CGI context is a mount point of Fast CGI application. The Fast CGI Application must be pre-defined at server level or virtual host level.');

$_tipsdb['EDTP:followSymbolLink'] = array('If Follow-Symbolic-Link is enabled, you can still disable it at virtual host level.');

$_tipsdb['EDTP:gzipCompressLevel'] = array('GZIP Compression level ranges from 1 (Minimum) to 9 (Maximum).');

$_tipsdb['EDTP:hardLimit'] = array('Set concurrent connection Limits coming from one client (per IP address). This helps against DoS attack.');

$_tipsdb['EDTP:indexUseServer'] = array('You can use default server level settings for index files or use your own.','You can use your settings in addition to the server level settings.','You can disable index files by choosing not to use server level settings and leaving vhost level settings blank.','You can enable/disable &quot;auto index&quot; at the context level.');

$_tipsdb['EDTP:javaServletEngine'] = array('If the servlet engine runs on a different machine, it is recommended to make a copy of webapps directory locally. Otherwise you must put the files in a common accessible network drive, which may affect performance.');

$_tipsdb['EDTP:javaWebApp_location'] = array('Java web app context is used to automatically import a predefined Java Application in an AJPv13 compilant Java servlet engine, the servlet engine should be set up in external app section (either server or virtual host level).','Location is the directory that contains web application files, which includes WEB-INF/ sub directory.','The web server will automatically import configuration file of web application, which usually is WEB-INF/web.xml under the driectory specified by &quot;location&quot;.');

$_tipsdb['EDTP:listenerIP'] = array('Select an IP address from the list, if you don&#039;t specify a particular address, the system will bind to all the available IP address on this machine.');

$_tipsdb['EDTP:listenerName'] = array('Give listener a name that is easy to understand and remember.');

$_tipsdb['EDTP:listenerPort'] = array('Input a unique port number on this IP for this listener. Only super user (root) can use ports lower than 1024. Port 80 is the default HTTP port; port 443 is the default HTTPS port.');

$_tipsdb['EDTP:listenerSecure'] = array('Selecting &quot;Yes&quot; for <b>Secure</b> will make this listener use https. You must then configure this further in SSL settings.');

$_tipsdb['EDTP:logUseServer'] = array('If you select &quot;Yes&quot; for <b>Use Server&#039;s Log</b>, the log will be written to the server file set up at the server level.');

$_tipsdb['EDTP:log_enableStderrLog'] = array('Stderr Log is located in the same directory as the Server Log. If enabled, all External Application output to stderr will be logged in this file.');

$_tipsdb['EDTP:log_fileName'] = array('Log file path can be an absolute path or relative to $SERVER_ROOT.');

$_tipsdb['EDTP:log_rollingSize'] = array('A new log file will be created if current log file exceeds the rolling size. File size is in bytes and can be in multiple input formats: 10240, 10K or 1M.');

$_tipsdb['EDTP:maxCGIInstances'] = array('Limits resources that a CGI program can use. This helps against DoS attacks.','Max CGI Instances controls how many CGI processes the web server can launch.');

$_tipsdb['EDTP:maxReqHeaderSize'] = array('Numbers can be represented as 10240, 10K or 1M.');

$_tipsdb['EDTP:mime'] = array('MIME settings can be edited from the previous page. You can specify the mime configuration file location which can be either be an absolute path or relative to $SERVER_ROOT.');

$_tipsdb['EDTP:nodeBin'] = array('');

$_tipsdb['EDTP:phpIniOverride'] = array('');

$_tipsdb['EDTP:procSoftLimit'] = array('Process soft/hard limit controls how many processes are allowed for one user. This includes all the processes spawned by CGI application. OS level limit is used if not set.','Set to 0 or empty will use operation system default value for all soft/hard limits.','The soft limit is the value that the kernel enforces for the corresponding resource. The hard limit acts as a ceiling for the soft limit');

$_tipsdb['EDTP:proxyWebServer'] = array('Proxy context enables this virtual host serving as a transparent reverse proxy server to an external web server or application server.','External web server must be pre-defined under External App at server or virtual host level.');

$_tipsdb['EDTP:realm'] = array('A Context can be protected with a predefined realm, which is set up in the virtual host security section. Optionally, an alternative name and additional requirements can be specified.');

$_tipsdb['EDTP:realmName'] = array('Define your HT Access realm here, this can be used for contexts.');

$_tipsdb['EDTP:recaptchaAllowedRobotHits'] = array('');

$_tipsdb['EDTP:recaptchaBotWhiteList'] = array('');

$_tipsdb['EDTP:recaptchaMaxTries'] = array('');

$_tipsdb['EDTP:recaptchaRegConnLimit'] = array('');

$_tipsdb['EDTP:recaptchaSecretKey'] = array('');

$_tipsdb['EDTP:recaptchaSiteKey'] = array('The server level site/secret key pair must be configured to skip domain checking if the server manages multiple domains. Otherwise, the reCAPTCHA verification will not work properly.');

$_tipsdb['EDTP:recaptchaSslConnLimit'] = array('');

$_tipsdb['EDTP:recaptchaType'] = array('');

$_tipsdb['EDTP:recaptchaVhReqLimit'] = array('');

$_tipsdb['EDTP:restrained'] = array('Turn on Restrained in a shared hosting enviroment.');

$_tipsdb['EDTP:rewriteMapLocation'] = array('Enter URI for location. URI must start with &quot;/&quot;.');

$_tipsdb['EDTP:rewriteRules'] = array('Only virtual host level rewrite rules should be used here, such as those found in an Apache virtual host  config file. Do NOT add any document root level rewrite rules here. If you have any document root level rewrite rules from  .htaccess, you should instead create a static context with uri &quot;/&quot; and add the rewrite rules there.');

$_tipsdb['EDTP:rubyBin'] = array('<b>Ruby Path</b> is the absolute path of a ruby executable. For e.g., /usr/local/bin/ruby.');

$_tipsdb['EDTP:serverName'] = array('The user and group setting of the server process cannot be modified. This was set up during installation. You have to reinstall to change this option.');

$_tipsdb['EDTP:servletEngine'] = array('If the servlet engine runs on a different machine, it is recommended to make a copy of webapps directory locally. Otherwise you must put the files in a common accessible network drive, which may affect performance.');

$_tipsdb['EDTP:shHandlerName'] = array('Except CGI, other handlers need to be predefined in the &quot;External App&quot; section.');

$_tipsdb['EDTP:shType'] = array('Script handler can be a CGI, an FCGI app, a module handler, a Servlet engine, or a proxy to Web server.');

$_tipsdb['EDTP:sndBufSize'] = array('Numbers can be represented as 10240, 10K or 1M.','If send/receive buffer size is 0, OS default TCP buffer size will be used.');

$_tipsdb['EDTP:softLimit'] = array('Set IP level throttle limit here. The number will be rounded up to 4K units. Set to &quot;0&quot; to disable throttling.','Number of connections can temporarily exceed Soft Limit during Grace Period as long as under Hard Limit. After Grace Period, if it is still above Soft Limit, then no more connections will be allowed from that IP for time of Banned Period.');

$_tipsdb['EDTP:sslProtocol'] = array('&quot;Yes&quot; must be selected for <b>Secure</b> in General > Address Settings.','For SSL versions and encryption levels, please select all you want to accept.');

$_tipsdb['EDTP:sslSessionCache'] = array('Session caching allows a client to resume a session within a set amount of time without having to re-perform an SSL handshake. You can do this by assigning clients a session ID using  <b>Enable Session Cache</b>, or by creating and using session tickets.');

$_tipsdb['EDTP:sslSessionTicketKeyFile'] = array('Session tickets will be rotated automatically if the tickets are being generated by the server. If using the <b>SSL Session Ticket Key File</b> option to create and manage your own session tickets, you must be rotate the tickets yourself using a cron job.');

$_tipsdb['EDTP:swappingDir'] = array('Swapping directory is recommended to be placed on a local disk such as /tmp. Network drive should be avoided at all cost. Swap will be when configured memory i/o buffer is exhausted.');

$_tipsdb['EDTP:users'] = array('Group DB will be checked only if the user in the user DB does not contain group information..','Use comma to separate multiple users.');

$_tipsdb['EDTP:vhRoot'] = array('All directories must pre-exist. This web interface will not create the directory for you. If you are creating a new virtual host, you can create an empty root directory and set it up from the beginning; or you can copy the &quot;Example&quot; virtual root that shipped with the package to this virtual host root and modify it.','Virtual host root ($VH_ROOT) can be absolute path or relative to $SERVER_ROOT.');

$_tipsdb['EDTP:vhaccessLog_fileName'] = array('Log file path can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.');

$_tipsdb['EDTP:vhadminEmails'] = array('You can enter multiple admin emails, separated by commas.');

$_tipsdb['EDTP:vhlog_fileName'] = array('Log file path can be an absolute path or relative to $SERVER_ROOT, $VH_ROOT.','If you want to set Log Level to DEBUG, you must set the server log level to DEBUG as well. The level of  debugging is controlled by Server DEBUG Level. Use DEBUG only if you have to as it has a large impact on server performance and can fill up disk space quickly.');

$_tipsdb['EDTP:virtualHostName'] = array('Select the virtual hosts that you want to map to this listener.','If you have not set up the virtual host you want to map, you can skip this step and come back later.');

$_tipsdb['EDTP:wsgiBin'] = array('');
